/*****************************************************************************/
/* td_mod_box.c : Objet Gtk+
 * td_mod_box.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"

#include "td_mod_box.h"

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_ID,
  ARG_IDPARENT,
  ARG_CUSTOMIZE,
};

static void td_mod_box_set_name (TdModBox *mod_box, gchar *name)
{
  g_return_if_fail (mod_box != NULL);
  g_return_if_fail (TD_IS_MOD_BOX (mod_box));
  if (mod_box->name != name)
    {
      mod_box->name = name;
      mod_box->label = gtk_label_new (name);
    }
}

static void td_mod_box_set_id (TdModBox *mod_box, int id)
{
  g_return_if_fail (mod_box != NULL);
  g_return_if_fail (TD_IS_MOD_BOX (mod_box));
  if (mod_box->id != id)
    mod_box->id = id;
}

static void td_mod_box_set_idparent (TdModBox *mod_box, int idparent)
{
  g_return_if_fail (mod_box != NULL);
  g_return_if_fail (TD_IS_MOD_BOX (mod_box));
  if (mod_box->idparent != idparent)
    mod_box->idparent = idparent;
}

static void td_mod_box_set_customize (TdModBox *mod_box, gboolean customize)
{
  g_return_if_fail (mod_box != NULL);
  g_return_if_fail (TD_IS_MOD_BOX (mod_box));
  if (mod_box->customize != customize)
    mod_box->customize = customize;
}

static void td_mod_box_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModBox *mod_box;
  mod_box = TD_MOD_BOX (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_mod_box_set_name (mod_box, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ID:
      td_mod_box_set_id (mod_box, GTK_VALUE_INT (*arg));
      break;
    case ARG_IDPARENT:
      td_mod_box_set_idparent (mod_box, GTK_VALUE_INT (*arg));
      break;
    case ARG_CUSTOMIZE:
      td_mod_box_set_customize (mod_box, GTK_VALUE_BOOL (*arg));
      break;
    default:
      break;
    }
}

static void td_mod_box_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdModBox *mod_box;
  mod_box = TD_MOD_BOX (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = mod_box->name;
      break;
    case ARG_ID:
      GTK_VALUE_INT (*arg) = mod_box->id;
      break;
    case ARG_IDPARENT:
      GTK_VALUE_INT (*arg) = mod_box->idparent;
      break;
    case ARG_CUSTOMIZE:
      GTK_VALUE_BOOL (*arg) = mod_box->customize;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_box_init (TdModBox *mod_box)
{
  mod_box->name = NULL;
  mod_box->id = -1;
  mod_box->idparent = -1;
  mod_box->label = NULL;
  mod_box->widget = NULL;
  mod_box->customize = FALSE;
}

static void td_mod_box_class_init (TdModBoxClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdModBox::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdModBox::id", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_ID);
  gtk_object_add_arg_type ("TdModBox::idparent", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_IDPARENT);
  gtk_object_add_arg_type ("TdModBox::customize", GTK_TYPE_INT, GTK_ARG_READWRITE, ARG_CUSTOMIZE);
  object_class->set_arg = td_mod_box_set_arg;
  object_class->get_arg = td_mod_box_get_arg;
  klass->set_widget = td_mod_box_set_widget;
  klass->create = td_mod_box_create;
}

GtkType td_mod_box_get_type (void)
{
  static GtkType mod_box_type = 0;
  if (!mod_box_type)
    {
      static const GtkTypeInfo mod_box_info =
      {
  	"TdModBox", sizeof (TdModBox), sizeof (TdModBoxClass),
  	(GtkClassInitFunc) td_mod_box_class_init,
	(GtkObjectInitFunc) td_mod_box_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_box_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_box_info);
    }
  return mod_box_type;
}

GtkObject *td_mod_box_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_box_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_box_set_widget (TdModBox *mod_box, GtkWidget *widget)
{
  g_return_if_fail (mod_box != NULL);
  g_return_if_fail (TD_IS_MOD_BOX (mod_box));
  if (mod_box->widget != widget)
    mod_box->widget = widget;
}

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_mod_box_create (TdModBox *mod_box, int id, int idparent)
{
}





