/*****************************************************************************/
/* td_flower.c : Objet Gtk+
 * td_flower.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"

#include "td_app.h"

#include "td_flower.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_SPACE,
  ARG_ROOT,
  ARG_BRANCH,
  ARG_PETAL,
  ARG_FOLIOLE,
  ARG_MODE_LEVEL,
  ARG_MODE_TYPE,
  ARG_MODE_ONE_COLUMN,
};

void td_flower_set_space (TdFlower *flower, gchar *space)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->space != space)
    flower->space = space;
}

void td_flower_set_root (TdFlower *flower, gchar *root)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->root != root)
    flower->root = root;
}

void td_flower_set_branch (TdFlower *flower, gchar *branch)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->branch != branch)
    flower->branch = branch;
}

void td_flower_set_petal (TdFlower *flower, gchar *petal)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->petal != petal)
    flower->petal = petal;
}

void td_flower_set_foliole (TdFlower *flower, gchar *foliole)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->foliole != foliole)
    flower->foliole = foliole;
}

void td_flower_set_mode_level (TdFlower *flower, gboolean mode_level)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->mode_level != mode_level)
    flower->mode_level = mode_level;
}

void td_flower_set_mode_type (TdFlower *flower, gboolean mode_type)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->mode_type != mode_type)
    flower->mode_type = mode_type;
}

void td_flower_set_mode_one_column (TdFlower *flower, gboolean mode_one_column)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  if (flower->mode_one_column != mode_one_column)
    flower->mode_one_column = mode_one_column;
}

static void td_flower_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdFlower *flower;
  flower = TD_FLOWER (object);
  switch (arg_id)
    {
    case ARG_SPACE:
      td_flower_set_space (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_ROOT:
      td_flower_set_root (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_BRANCH:
      td_flower_set_branch (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PETAL:
      td_flower_set_petal (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_FOLIOLE:
      td_flower_set_foliole (flower, GTK_VALUE_STRING (*arg));
      break;
    case ARG_MODE_LEVEL:
      td_flower_set_mode_level (flower, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_MODE_TYPE:
      td_flower_set_mode_type (flower, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_MODE_ONE_COLUMN:
      td_flower_set_mode_one_column (flower, GTK_VALUE_BOOL (*arg));
      break;
    default:
      break;
    }
}

static void td_flower_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdFlower *flower;
  flower = TD_FLOWER (object);
   switch (arg_id)
    {
    case ARG_SPACE:
      GTK_VALUE_STRING (*arg) = flower->space;
      break;
    case ARG_ROOT:
      GTK_VALUE_STRING (*arg) = flower->root;
      break;
    case ARG_BRANCH:
      GTK_VALUE_STRING (*arg) = flower->branch;
      break;
    case ARG_PETAL:
      GTK_VALUE_STRING (*arg) = flower->petal;
      break;
    case ARG_FOLIOLE:
      GTK_VALUE_STRING (*arg) = flower->foliole;
      break;
    case ARG_MODE_LEVEL:
      GTK_VALUE_BOOL (*arg) = flower->mode_level;
      break;
    case ARG_MODE_TYPE:
      GTK_VALUE_BOOL (*arg) = flower->mode_type;
      break;
    case ARG_MODE_ONE_COLUMN:
      GTK_VALUE_BOOL (*arg) = flower->mode_one_column;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_flower_init (TdFlower *flower)
{
  flower->space = NULL;
  flower->root = NULL;
  flower->branch = NULL;
  flower->branch_attribut = NULL;
  flower->petal = NULL;
  flower->petal_attribut = NULL;
  flower->foliole = NULL;
  flower->foliole_attribut = NULL;
  flower->items_value = NULL;
  flower->items_level = NULL;
  flower->mode_level = FALSE;
  flower->mode_type = FALSE;
  flower->mode_one_column = FALSE;
}

static void td_flower_class_init (TdFlowerClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdFlower::space", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_SPACE);
  gtk_object_add_arg_type ("TdFlower::root", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_ROOT);
  gtk_object_add_arg_type ("TdFlower::branch", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_BRANCH);
  gtk_object_add_arg_type ("TdFlower::petal", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PETAL);
  gtk_object_add_arg_type ("TdFlower::foliole", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_FOLIOLE);
  gtk_object_add_arg_type ("TdFlower::mode_level", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODE_LEVEL);
  gtk_object_add_arg_type ("TdFlower::mode_type", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODE_TYPE);
  gtk_object_add_arg_type ("TdFlower::mode_one_column", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_MODE_ONE_COLUMN);
  object_class->set_arg = td_flower_set_arg;
  object_class->get_arg = td_flower_get_arg;
  klass->add_branch_attribut = td_flower_add_branch_attribut;
  klass->add_petal_attribut = td_flower_add_petal_attribut;
  klass->add_foliole_attribut = td_flower_add_foliole_attribut;
}

GtkType td_flower_get_type (void)
{
  static GtkType flower_type = 0;
  if (!flower_type)
    {
      static const GtkTypeInfo flower_info =
      {
  	"TdFlower", sizeof (TdFlower), sizeof (TdFlowerClass),
  	(GtkClassInitFunc) td_flower_class_init,
	(GtkObjectInitFunc) td_flower_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      flower_type = gtk_type_unique (GTK_TYPE_OBJECT, &flower_info);
    }
  return flower_type;
}

GtkObject *td_flower_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_flower_get_type ()));
}

void td_flower_destroy (TdFlower *flower)
{
  gtk_object_destroy (GTK_OBJECT (flower));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_flower_add_branch_attribut (TdFlower *flower, gchar *branch_attribut)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  flower->branch_attribut = g_list_append (flower->branch_attribut, branch_attribut);
}

void td_flower_add_petal_attribut (TdFlower *flower, gchar *petal_attribut)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  flower->petal_attribut = g_list_append (flower->petal_attribut, petal_attribut);
}

void td_flower_add_foliole_attribut (TdFlower *flower, gchar *foliole_attribut)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));
  flower->foliole_attribut = g_list_append (flower->foliole_attribut, foliole_attribut);
}

void td_flower_add_item (TdFlower *flower, GList *item, int level)
{
  g_return_if_fail (flower != NULL);
  g_return_if_fail (TD_IS_FLOWER (flower));

  /* Vrification de la longueur de l'item */
  /* if (g_list_length (flower->items_value)) */
  /*   if (g_list_length (item) != g_list_length (g_list_nth_data (flower->items_value, 0))) */
  /*     td_palette_message (NULL, _("Adding node : incompatible length between flowers records"), "failed"); */
  flower->items_value = g_list_append (flower->items_value, item);
  flower->items_level = g_list_append (flower->items_level, GINT_TO_POINTER (level));
}


/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
gboolean td_flower_load_file (TdFlower *flower, char *file)
{
  GList *data = NULL;
  xmlDocPtr doc;
  xmlNsPtr ns;
  xmlNodePtr cur;
  xmlNodePtr cur2;
  xmlNodePtr cur3;
  gchar *txt_tmp = NULL;
  int i, j;

  /* En-tte */
  doc = xmlParseFile (file);
  if (!doc)
    {
      td_palette_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : doc == NULL"), file), "failed");
      return FALSE;
    }
  cur = doc->root;
  if (!cur)
    {
      td_palette_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : cur == NULL"), file), "failed");
      xmlFreeDoc(doc);
      return FALSE;
    }

  /* Valeurs */
  if (flower->items_value)
    {
      flower->items_value = NULL;
      flower->items_level = NULL;
    }
  cur = doc->root->childs;
  while (cur)
    {

      /* Branche */
      if (!strcmp (cur->name, flower->branch))
	{
	  if (flower->mode_one_column)
	    {
	      for (j=0; j<g_list_length (flower->branch_attribut); j++)
		if (!j)
		  txt_tmp = g_strdup_printf ("%s", xmlGetProp (cur, g_list_nth_data (flower->branch_attribut, j)));
		else
		  txt_tmp = g_strdup_printf ("%s %s", txt_tmp, xmlGetProp (cur, g_list_nth_data (flower->branch_attribut, j)));
	      data = g_list_append (data, txt_tmp);
	      td_flower_add_item (flower, data, 0);
	      data = NULL;
	    }
	  else
	    {
	      for (j=0; j<g_list_length (flower->branch_attribut); j++)
		data = g_list_append (data, xmlGetProp (cur, g_list_nth_data (flower->branch_attribut, j)));
  	      if (flower->mode_type)
  		data = g_list_append (data, flower->branch);
	      if (flower->mode_level)
		td_flower_add_item (flower, data, atoi (xmlGetProp (cur, "level")));
	      else
		td_flower_add_item (flower, data, 0);
	      data = NULL;
	    }

	  /* Feuille */
	  cur2 = cur->childs;
	  while (cur2)
	    {
	      if (!strcmp (cur2->name, flower->petal))
		{
		  if (flower->mode_one_column)
		    {
		      for (j=0; j<g_list_length (flower->petal_attribut); j++)
			if (!j)
			  txt_tmp = g_strdup_printf ("%s", xmlGetProp (cur2, g_list_nth_data (flower->petal_attribut, j)));
			else
			  txt_tmp = g_strdup_printf ("%s %s", txt_tmp, xmlGetProp (cur2, g_list_nth_data (flower->petal_attribut, j)));
		      data = g_list_append (data, txt_tmp);
		      td_flower_add_item (flower, data, 1);
		      data = NULL;
		    }
		  else
		    {
		      for (j=0; j<g_list_length (flower->branch_attribut); j++)
			data = g_list_append (data, xmlGetProp (cur2, g_list_nth_data (flower->branch_attribut, j)));
  		      if (flower->mode_type)
			data = g_list_append (data, flower->petal);
		      if (flower->mode_level)
			td_flower_add_item (flower, data, atoi (xmlGetProp (cur2, "level")));
		      else
			td_flower_add_item (flower, data, 1);
		      data = NULL;
		    }

		  /* Foliole */
		  cur3 = cur2->childs;
		  while (cur3)
		    {
		      if (!strcmp (cur3->name, flower->foliole))
			{
			  if (flower->mode_one_column)
			    {
			      for (j=0; j<g_list_length (flower->foliole_attribut); j++)
				if (!j)
				  txt_tmp = g_strdup_printf ("%s", xmlGetProp (cur3, g_list_nth_data (flower->foliole_attribut, j)));
				else
				  txt_tmp = g_strdup_printf ("%s %s", txt_tmp, xmlGetProp (cur3, g_list_nth_data (flower->foliole_attribut, j)));
			      data = g_list_append (data, txt_tmp);
			      td_flower_add_item (flower, data, 2);
			      data = NULL;
			    }
			  else
			    {
			      for (j=0; j<g_list_length (flower->branch_attribut); j++)
				data = g_list_append (data, xmlGetProp (cur3, g_list_nth_data (flower->branch_attribut, j)));
  			      if (flower->mode_type)
  				data = g_list_append (data, flower->foliole);
			      if (flower->mode_level)
				td_flower_add_item (flower, data, atoi (xmlGetProp (cur3, "level")));
			      else
				td_flower_add_item (flower, data, 2);
			      data = NULL;
			    }
			}
		      cur3 = cur3->next;
		    }
		}
	      cur2 = cur2->next;
	    }
	}
      cur = cur->next;
    }
  xmlFreeDoc (doc);
  return TRUE;
}

gboolean td_flower_save_file (TdFlower *flower, char *file)
{
/*    GList *data = NULL; */
/*    FILE *fp; */
/*    xmlDocPtr doc; */
/*    xmlNsPtr ns; */
/*    xmlNodePtr tree; */
/*    xmlNodePtr item; */
/*    GtkCTreeNode *node; */
/*    int i; */

    /* Go ! */ 
/*    if (!TD_FLOWER (flower)->mode_level) */
/*      { */
/*        td_palette_message (_("Saving XML flower"), _("Saving XML flower without 'mode_level' isn't possible"), "failed"); */
/*        return FALSE; */
/*      } */
/*    fp = fopen (file, "w"); */
/*    if (!fp) */
/*      { */
/*        td_palette_message (NULL, _("Opening file"), "failed"); */
/*        return FALSE; */
/*      } */
/*    fclose (fp); */
/*    doc = xmlNewDoc ("1.0"); */
/*    ns = xmlNewGlobalNs (doc, TD_FLOWER (flower)->space, g_strdup_printf("ToutDoux-%s", TD_FLOWER (flower)->root)); */
/*    doc->root = xmlNewDocNode (doc, ns, TD_FLOWER (flower)->root, NULL); */
/*    tree = doc->root; */
/*    node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (mod_tree->widget)->child), 0); */
/*    while (node) */
/*      { */
/*        data = td_mod_tree_read_node (mod_tree, node, FALSE); */
/*        item = xmlNewChild (tree, ns, TD_FLOWER (flower)->branch, NULL); */
/*        for (i=0; i<g_list_length (mod_tree->field); i++) */
/*  	xmlSetProp (item, g_strdup_printf("%s", (gchar*) TD_FIELD (g_list_nth_data (mod_tree->field, i))->name), g_strdup_printf("%s", (gchar*) g_list_nth_data (data, i))); */
/*        xmlSetProp (item, "level", g_strdup_printf("%d", GTK_CTREE_ROW (node)->level)); */
/*        data = NULL; */
/*        node = gtdk_ctree_next (node); */
/*      } */
/*    if (xmlSaveFile (file, doc) < 0) */
/*      { */
/*        td_palette_message (NULL, _("Writting file"), "failed"); */
/*        xmlFreeDoc (doc); */
/*        return FALSE; */
/*      } */
/*    xmlFreeDoc (doc); */
/*    g_list_free (data); */
  return TRUE;
}

