/*****************************************************************************/
/* td_db_table_field.c : Objet Gtk+
 * td_db_table_field.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "td_db_table_field.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_COMMENT,
  ARG_KEY,
  ARG_TYPE,
  ARG_TYPECOMMENT,
};

void td_db_table_field_set_name (TdDbTableField *db_table_field, gchar *name)
{
  g_return_if_fail (db_table_field != NULL);
  g_return_if_fail (TD_IS_DB_TABLE_FIELD (db_table_field));
  if (db_table_field->name != name)
    db_table_field->name = name;
}

void td_db_table_field_set_comment (TdDbTableField *db_table_field, gchar *comment)
{
  g_return_if_fail (db_table_field != NULL);
  g_return_if_fail (TD_IS_DB_TABLE_FIELD (db_table_field));
  if (db_table_field->comment != comment)
    db_table_field->comment = comment;
}

void td_db_table_field_set_key (TdDbTableField *db_table_field, gboolean key)
{
  g_return_if_fail (db_table_field != NULL);
  g_return_if_fail (TD_IS_DB_TABLE_FIELD (db_table_field));
  if (db_table_field->key != key)
    db_table_field->key = key;
}

void td_db_table_field_set_type (TdDbTableField *db_table_field, gchar *type)
{
  g_return_if_fail (db_table_field != NULL);
  g_return_if_fail (TD_IS_DB_TABLE_FIELD (db_table_field));
  if (db_table_field->type != type)
    db_table_field->type = type;
}

void td_db_table_field_set_typecomment (TdDbTableField *db_table_field, gchar *typecomment)
{
  g_return_if_fail (db_table_field != NULL);
  g_return_if_fail (TD_IS_DB_TABLE_FIELD (db_table_field));
  if (db_table_field->typecomment != typecomment)
    db_table_field->typecomment = typecomment;
}

static void td_db_table_field_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbTableField *db_table_field;
  db_table_field = TD_DB_TABLE_FIELD (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_table_field_set_name (db_table_field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COMMENT:
      td_db_table_field_set_comment (db_table_field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_KEY:
      td_db_table_field_set_key (db_table_field, GTK_VALUE_BOOL (*arg));
      break;
    case ARG_TYPE:
      td_db_table_field_set_type (db_table_field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TYPECOMMENT:
      td_db_table_field_set_typecomment (db_table_field, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_table_field_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbTableField *db_table_field;
  db_table_field = TD_DB_TABLE_FIELD (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = db_table_field->name;
      break;
    case ARG_COMMENT:
      GTK_VALUE_STRING (*arg) = db_table_field->comment;
      break;
    case ARG_KEY:
      GTK_VALUE_BOOL (*arg) = db_table_field->key;
      break;
    case ARG_TYPE:
      GTK_VALUE_STRING (*arg) = db_table_field->comment;
      break;
    case ARG_TYPECOMMENT:
      GTK_VALUE_STRING (*arg) = db_table_field->typecomment;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_db_table_field_init (TdDbTableField *db_table_field)
{
  db_table_field->name = NULL;
  db_table_field->comment = NULL;
  db_table_field->key = FALSE;
  db_table_field->type = NULL;
  db_table_field->typecomment = NULL;
}

static void td_db_table_field_class_init (TdDbTableFieldClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbTableField::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbTableField::comment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMENT);
  gtk_object_add_arg_type ("TdDbTableField::key", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_KEY);
  gtk_object_add_arg_type ("TdDbTableField::type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TYPE);
  gtk_object_add_arg_type ("TdDbTableField::typecomment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TYPECOMMENT);
  object_class->set_arg = td_db_table_field_set_arg;
  object_class->get_arg = td_db_table_field_get_arg;
}

GtkType td_db_table_field_get_type (void)
{
  static GtkType db_table_field_type = 0;
  if (!db_table_field_type)
    {
      static const GtkTypeInfo db_table_field_info =
      {
  	"TdDbTableField", sizeof (TdDbTableField), sizeof (TdDbTableFieldClass),
  	(GtkClassInitFunc) td_db_table_field_class_init,
	(GtkObjectInitFunc) td_db_table_field_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_table_field_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_table_field_info);
    }
  return db_table_field_type;
}

GtkObject *td_db_table_field_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_table_field_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/


/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
GtkObject *td_db_table_field_load_hopla (xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
  GtkObject *ret;

  /* Champs */
  ret = td_db_table_field_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur, "name"), 
		  "comment", xmlGetProp (cur, "comment"), 
		  "key", atoi (xmlGetProp (cur, "key")), NULL);

  /* Type */
  cur = cur->childs;
  gtk_object_set (GTK_OBJECT (ret), 
		  "type", xmlGetProp (cur, "name"), 
		  "typecomment", xmlGetProp (cur, "comment"), NULL);
  return (ret);
}
