/*****************************************************************************/
/* td_db_base.c : Objet Gtk+
 * td_db_base.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"

#include "td_app.h"

#include "td_db_base.h"
#include "td_db_connect.h"
#include "td_db_table.h"
#include "td_db_table_field.h"
#include "td_db_mod.h"
#include "td_db_mod_field.h"
#include "td_db_datatable.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_COMMENT,
};

void td_db_base_set_name (TdDbBase *db_base, gchar *name)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  if (db_base->name != name)
    db_base->name = name;
}

void td_db_base_set_comment (TdDbBase *db_base, gchar *comment)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  if (db_base->comment != comment)
    db_base->comment = comment;
}

static void td_db_base_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbBase *db_base;
  db_base = TD_DB_BASE (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_base_set_name (db_base, GTK_VALUE_STRING (*arg));
      break;
    case ARG_COMMENT:
      td_db_base_set_comment (db_base, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_base_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbBase *db_base;
  db_base = TD_DB_BASE (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = db_base->name;
      break;
    case ARG_COMMENT:
      GTK_VALUE_STRING (*arg) = db_base->comment;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_db_base_init (TdDbBase *db_base)
{
  db_base->name = NULL;
  db_base->comment = NULL;
  db_base->table = NULL;
  db_base->mod = NULL;
  db_base->datatable = NULL;
  db_base->connexion = NULL;
}

static void td_db_base_class_init (TdDbBaseClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbBase::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbBase::comment", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_COMMENT);
  object_class->set_arg = td_db_base_set_arg;
  object_class->get_arg = td_db_base_get_arg;
  klass->add_table = td_db_base_add_table;
  klass->add_mod = td_db_base_add_mod;
  klass->add_datatable = td_db_base_add_datatable;
  klass->set_connexion = td_db_base_set_connexion;
}

GtkType td_db_base_get_type (void)
{
  static GtkType db_base_type = 0;
  if (!db_base_type)
    {
      static const GtkTypeInfo db_base_info =
      {
  	"TdDbBase", sizeof (TdDbBase), sizeof (TdDbBaseClass),
  	(GtkClassInitFunc) td_db_base_class_init,
	(GtkObjectInitFunc) td_db_base_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_base_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_base_info);
    }
  return db_base_type;
}

GtkObject *td_db_base_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_base_get_type ()));
}

void td_db_base_destroy (TdDbBase *db_base)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  g_list_free (db_base->table);
  g_list_free (db_base->mod);
  g_list_free (db_base->datatable);
  gtk_object_destroy (GTK_OBJECT (db_base));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_db_base_add_table (TdDbBase *db_base, GtkObject *table)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  db_base->table = g_list_append (db_base->table, table);
}

void td_db_base_add_mod (TdDbBase *db_base, GtkObject *mod)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  db_base->mod = g_list_append (db_base->mod, mod);
}

void td_db_base_add_datatable (TdDbBase *db_base, GtkObject *datatable)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  db_base->datatable = g_list_append (db_base->datatable, datatable);
}

void td_db_base_set_connexion (TdDbBase *db_base, GtkObject *connexion)
{
  g_return_if_fail (db_base != NULL);
  g_return_if_fail (TD_IS_DB_BASE (db_base));
  if (db_base->connexion != connexion)
    db_base->connexion = connexion;
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/


/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
GtkObject *td_db_base_load_hopla (gchar *file)
{
  GtkObject *ret;
  xmlDocPtr doc;
  xmlNsPtr ns;
  xmlNodePtr cur;

  /* Vrif du contenu du fichier */
  doc = xmlParseFile (file);
  if (!doc)
    {
      td_palette_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : doc == NULL"), file), "failed");
      return (NULL);
    }	
  cur = doc->root;
  if (!cur)
    {
      td_palette_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : cur == NULL"), file), "failed");
      xmlFreeDoc (doc);
      return (NULL);
    }
  ns = xmlSearchNsByHref (doc, cur, "hopla/1.0.4");
  if (!ns)
    {
      td_palette_message (NULL, g_strdup_printf (_("Parsing XML file '%s' : ns == NULL"), file), "failed");
      xmlFreeDoc (doc);
      return (NULL);
    }

  /* Base */
  ret = td_db_base_new ();
  cur = doc->root;
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur, "name"), 
		  "comment", xmlGetProp (cur, "comment"), NULL);

  /* Table */
  cur = doc->root->childs->childs;
  while (cur)
    {
      if (!strcmp (cur->name, "table"))
	td_db_base_add_table (TD_DB_BASE (ret), td_db_table_load_hopla (doc, ns, cur));
      cur = cur->next;
    }

  /* Mod */
  cur = doc->root->childs->next->childs;
  while (cur)
    {
      if ((!strcmp (cur->name, "view")) || (!strcmp (cur->name, "mod")))  /* FIXME: passage de view  module */
	td_db_base_add_mod (TD_DB_BASE (ret), td_db_mod_load_hopla (doc, ns, cur));
      cur = cur->next;
    }

  /* Datatable */
  cur = doc->root->childs->next->next->childs;
  while (cur)
    {
      if (!strcmp (cur->name, "datatable"))
	td_db_base_add_datatable (TD_DB_BASE (ret), td_db_datatable_load_hopla (doc, ns, cur));
      cur = cur->next;
    }
  xmlFreeDoc (doc);
  return (ret);
}

gboolean td_db_base_save_hopla (TdDbBase *base, gchar *file)
{
  GList *data = NULL;
  GList *item = NULL;
  TdDbTable *table = NULL;
  TdDbTableField *table_field = NULL;
  TdDbMod *mod = NULL;
  TdDbModField *mod_field = NULL;
  TdDbDatatable *datatable = NULL;
  FILE *fp;
  xmlDocPtr doc;
  xmlNsPtr ns;
  xmlNodePtr tree_tables;
  xmlNodePtr tree_table;
  xmlNodePtr tree_fields;
  xmlNodePtr tree_field;
  xmlNodePtr tree_type;
  xmlNodePtr tree_mods;
  xmlNodePtr tree_mod;
  xmlNodePtr tree_properties;
  xmlNodePtr tree_property;
  xmlNodePtr tree_datatables;
  xmlNodePtr tree_datatable;
  xmlNodePtr tree_items; 
  xmlNodePtr tree_item;
  int i, j, k;

  /* Vrif de l'existance du fichier */
  fp = fopen (file, "w");
  if (!fp)
    {
      td_palette_message (_("Opening file"), NULL, "failed");
      return FALSE;
    }
  fclose (fp);
  doc = xmlNewDoc ("1.0");
  ns = xmlNewGlobalNs (doc, "hopla/1.0.4","hOpla" );

  /* Base */
  doc->root = xmlNewDocNode (doc, ns, "database", NULL);
  xmlSetProp (doc->root, "name", base->name);
  xmlSetProp (doc->root, "comment", base->comment);

  /* Tables */
  tree_tables = xmlNewChild (doc->root, ns, "tables", NULL);
  for (i=0; i<g_list_length (base->table); i++)
    {
      table = (TdDbTable*) g_list_nth_data (base->table, i);
      tree_table = xmlNewChild (tree_tables, ns, "table", NULL);
      xmlSetProp (tree_table, "name", table->name);
      xmlSetProp (tree_table, "comment", table->comment);
      tree_fields = xmlNewChild (tree_table, ns, "fields", NULL);
      for (j=0; j<g_list_length (table->field); j++)
	{
	  table_field = (TdDbTableField*) g_list_nth_data (table->field, j);
	  tree_field = xmlNewChild (tree_fields, ns, "field", NULL);
	  xmlSetProp (tree_field, "name", table_field->name);
	  xmlSetProp (tree_field, "comment", table_field->comment);
	  xmlSetProp (tree_field, "key", g_strdup_printf ("%d", table_field->key));
	  tree_type = xmlNewChild (tree_field, ns, "type", NULL);
	  xmlSetProp (tree_type, "name", table_field->type);
	  xmlSetProp (tree_type, "comment", table_field->typecomment);
	}
    }
  gtk_object_destroy (GTK_OBJECT (table_field));
  gtk_object_destroy (GTK_OBJECT (table));

  /* Vues */
  tree_mods = xmlNewChild (doc->root, ns, "mods", NULL);
  for (i=0; i<g_list_length (base->mod); i++)
    {
      mod = (TdDbMod*) g_list_nth_data (base->mod, i);
      tree_mod = xmlNewChild (tree_mods, ns, "mod", NULL);
      xmlSetProp (tree_mod, "name", mod->name);
      xmlSetProp (tree_mod, "table", mod->table);
      tree_fields = xmlNewChild (tree_mod, ns, "fields", NULL);
      for (j=0; j<g_list_length (mod->field); j++)
	{
	  mod_field = (TdDbModField*) g_list_nth_data (mod->field, j);
	  tree_field = xmlNewChild (tree_fields, ns, "field", NULL);
	  xmlSetProp (tree_field, "name", mod_field->name);
	  xmlSetProp (tree_field, "table_field", mod_field->table_field);
	  tree_properties = xmlNewChild (tree_field, ns, "properties", NULL);
	  for (k=0; k<g_list_length (mod_field->property_name); k++)
	    {
	      tree_property = xmlNewChild (tree_properties, ns, "property", NULL);
	      xmlSetProp (tree_property, "name", (gchar*) g_list_nth_data (mod_field->property_name, k));
	      xmlSetProp (tree_property, "value", (gchar*) g_list_nth_data (mod_field->property_value, k));
	    }
	}
    }

  /* Table de donnes */
  tree_datatables = xmlNewChild (doc->root, ns, "datatables", NULL);
  for (i=0; i<g_list_length (base->datatable); i++)
    {
      datatable = (TdDbDatatable*) g_list_nth_data (base->datatable, i);
      tree_datatable = xmlNewChild (tree_datatables, ns, "datatable", NULL);
      xmlSetProp (tree_datatable, "table", datatable->table);
      tree_items = xmlNewChild (tree_datatable, ns, "items", NULL);
      for (j=0; j<g_list_length (datatable->item); j++)
	{
	  item = g_list_nth_data (datatable->item, j);
	  tree_item = xmlNewChild (tree_items, ns, "item", NULL);
	  for (k=0; k<g_list_length (item); k++)
	    xmlSetProp (tree_item, g_strdup_printf ("field%d", k), (gchar*) g_list_nth_data (item, k));
	}
    }

  /* Fin */
  if (xmlSaveFile (file, doc) < 0)
    {
      td_palette_message (_("Writting file"), NULL, "failed");
      xmlFreeDoc (doc);
      return FALSE;
    }
  xmlFreeDoc (doc);
  return TRUE;
}
