/*****************************************************************************/
/* td_custom.h : Objet Gtk+
 * td_custom.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_CUSTOM (td_custom_get_type ())
#define TD_CUSTOM(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_CUSTOM, TdCustom))
#define TD_CUSTOM_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_CUSTOM, TdCustomClass))
#define TD_IS_CUSTOM(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_CUSTOM))
#define TD_IS_CUSTOM_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_CUSTOM))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdCustom TdCustom;
typedef struct _TdCustomClass TdCustomClass;

struct _TdCustom
{
  GtkObject object;
  gchar *name;
  gchar *category1;
  gchar *category2;
  gchar *category3;
  GList *option;
  GtkWidget *box;
  GtkWidget *box2;
  GtkWidget *scrolledwindow;
  GtkWidget *viewport;
  GList *group_frame;
  GList *group_vbox;
  GList *group_hbox;
};

struct _TdCustomClass
{
  GtkObjectClass parent_class;
  void (*add_option) (TdCustom *custom, GtkObject *option);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_custom_set_name (TdCustom *custom, gchar *name);
void td_custom_set_category1 (TdCustom *custom, gchar *category1);
void td_custom_set_category2 (TdCustom *custom, gchar *category2);
void td_custom_set_category3 (TdCustom *custom, gchar *category3);
static void td_custom_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_custom_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_custom_init (TdCustom *custom);
static void td_custom_class_init (TdCustomClass *klass);
GtkType td_custom_get_type (void);
GtkObject *td_custom_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_custom_add_option (TdCustom *custom, GtkObject *option);
gchar *td_custom_value (GtkObject *flower, gchar *custom, gchar *group, gchar *option);
void td_custom_create_title (TdCustom *custom, GtkWidget *widget);











