/*****************************************************************************/
/* td_custom.c : Objet Gtk+
 * td_custom.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>

#include "commons.h"
#include "gtdk.h"

#include "td_app.h"
#include "td_app_palette.h"

#include "td_mod.h"
#include "td_mod_box.h"

#include "td_flower.h"
#include "td_custom.h"
#include "td_custom_option.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_CATEGORY1,
  ARG_CATEGORY2,
  ARG_CATEGORY3,
};

void td_custom_set_name (TdCustom *custom, gchar *name)
{
  g_return_if_fail (custom != NULL);
  g_return_if_fail (TD_IS_CUSTOM (custom));
  if (custom->name != name)
    custom->name = name;
}

void td_custom_set_category1 (TdCustom *custom, gchar *category1)
{
  g_return_if_fail (custom != NULL);
  g_return_if_fail (TD_IS_CUSTOM (custom));
  if (custom->category1 != category1)
    custom->category1 = category1;
}

void td_custom_set_category2 (TdCustom *custom, gchar *category2)
{
  g_return_if_fail (custom != NULL);
  g_return_if_fail (TD_IS_CUSTOM (custom));
  if (custom->category2 != category2)
    custom->category2 = category2;
}

void td_custom_set_category3 (TdCustom *custom, gchar *category3)
{
  g_return_if_fail (custom != NULL);
  g_return_if_fail (TD_IS_CUSTOM (custom));
  if (custom->category3 != category3)
    custom->category3 = category3;
}

static void td_custom_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdCustom *custom;
  custom = TD_CUSTOM (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_custom_set_name (custom, GTK_VALUE_STRING (*arg));
      break;
    case ARG_CATEGORY1:
      td_custom_set_category1 (custom, GTK_VALUE_STRING (*arg));
      break;
    case ARG_CATEGORY2:
      td_custom_set_category2 (custom, GTK_VALUE_STRING (*arg));
      break;
    case ARG_CATEGORY3:
      td_custom_set_category3 (custom, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_custom_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdCustom *custom;
  custom = TD_CUSTOM (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = custom->name;
      break;
    case ARG_CATEGORY1:
      GTK_VALUE_STRING (*arg) = custom->category1;
      break;
    case ARG_CATEGORY2:
      GTK_VALUE_STRING (*arg) = custom->category2;
      break;
    case ARG_CATEGORY3:
      GTK_VALUE_STRING (*arg) = custom->category3;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_custom_init (TdCustom *custom)
{
  custom->name = NULL;
  custom->category1 = NULL;
  custom->category2 = NULL;
  custom->category3 = NULL;
  custom->option = NULL;
  custom->box = NULL;
  custom->scrolledwindow = NULL;
  custom->viewport = NULL;
  custom->box2 = NULL;
  custom->group_frame = NULL;
  custom->group_vbox = NULL;
  custom->group_hbox = NULL;
}

static void td_custom_class_init (TdCustomClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdCustom::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdCustom::category1", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_CATEGORY1);
  gtk_object_add_arg_type ("TdCustom::category2", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_CATEGORY2);
  gtk_object_add_arg_type ("TdCustom::category3", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_CATEGORY3);
  object_class->set_arg = td_custom_set_arg;
  object_class->get_arg = td_custom_get_arg;
  klass->add_option = td_custom_add_option;
}

GtkType td_custom_get_type (void)
{
  static GtkType custom_type = 0;
  if (!custom_type)
    {
      static const GtkTypeInfo custom_info =
      {
  	"TdCustom", sizeof (TdCustom), sizeof (TdCustomClass),
  	(GtkClassInitFunc) td_custom_class_init,
	(GtkObjectInitFunc) td_custom_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      custom_type = gtk_type_unique (GTK_TYPE_OBJECT, &custom_info);
    }
  return custom_type;
}

GtkObject *td_custom_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_custom_get_type ()));
}

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_custom_add_option (TdCustom *custom, GtkObject *option)
{
  g_return_if_fail (custom != NULL);
  g_return_if_fail (TD_IS_CUSTOM (custom));
  custom->option = g_list_append (custom->option, option);
}

gchar *td_custom_value (GtkObject *flower, gchar *custom, gchar *group, gchar *option)
{
  int i;
  gboolean bool_tmp;
  GList *data = NULL;

  /* Recherche du custom */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    {
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0)
	{
	  data = g_list_nth_data (TD_FLOWER (flower)->items_value, i);
	  if (!strcmp (g_list_nth_data (data, 0), custom))
	    {
	      bool_tmp = TRUE;
	      break;
	    }
	  data = NULL;
	}
      if ((GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 1) ||
	  (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 2))
	continue;
    }
  if (!bool_tmp)
    {
      td_palette_message (NULL, g_strdup_printf (_("Customizing : option's category '%s' not find"), custom), "no");
      return ("(null)");
    }
  
  /* Recherche du groupe */
  bool_tmp = FALSE;
  data = NULL;
  for (i++; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    {
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0)
	{
	  bool_tmp = FALSE;
	  break;
	}
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 1)
	{
	  data = g_list_nth_data (TD_FLOWER (flower)->items_value, i);
	  if (!strcmp (g_list_nth_data (data, 0), group))
	    {
	      bool_tmp = TRUE;
	      break;
	    }
	  data = NULL;
	}
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 2)
	continue;
    }
  if (!bool_tmp)
    {
      td_palette_message (NULL, g_strdup_printf (_("Customizing : option's group '%s' not find"), group), "no");
      return ("(null)");
    }

  /* Recherche de l'option */
  bool_tmp = FALSE;
  data = NULL;
  for (i++; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    {
      if ((GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 0) ||
	  (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 1))
	{
	  bool_tmp = FALSE;
	  break;
	}
      if (GPOINTER_TO_INT (g_list_nth_data (TD_FLOWER (flower)->items_level, i)) == 2)
	{
	  data = g_list_nth_data (TD_FLOWER (flower)->items_value, i);
	  if (!strcmp (g_list_nth_data (data, 0), option))
	    {
	      bool_tmp = TRUE;
	      break;
	    }
	  data = NULL;
	}
    }
  if (!bool_tmp)
    {
      td_palette_message (NULL, g_strdup_printf (_("Customizing : option '%s' not find"), option), "no");
      return ("(null)");
    }

  /* Valeur */
  return ((gchar*) g_list_nth_data (data, 1));
}

void td_custom_create_title (TdCustom *custom, GtkWidget *widget)
{
  custom->box2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (custom->box2);
  gtk_container_add (GTK_CONTAINER (widget), custom->box2);
  gtdk_vbox_title (custom->name, custom->box2);
  custom->scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (custom->scrolledwindow);
  gtk_box_pack_start (GTK_BOX (custom->box2), custom->scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (custom->scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  custom->viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (custom->viewport);
  gtk_container_add (GTK_CONTAINER (custom->scrolledwindow), custom->viewport);
  custom->box = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (custom->box);
  gtk_container_add (GTK_CONTAINER (custom->viewport), custom->box);
}
