/*****************************************************************************/
/* commons.h : Variables et fonctions communes
 * commons.h : Commons variables and commons functions
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manage
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#include <parser.h>
#include <tree.h>


/*****************************************************************************/
/* Dnd configuration */
/*****************************************************************************/
static GtkTargetEntry TD_DRAG_TYPES [] = {
  { "plain/text", 0, 0 },
};
static GtkTargetEntry TD_DROP_TYPES [] = {
  { "plain/text", 0, 0 },
};
static gint TD_N_DRAG_TYPES = sizeof (TD_DRAG_TYPES) / sizeof (TD_DRAG_TYPES [0]);
static gint TD_N_DROP_TYPES = sizeof (TD_DROP_TYPES) / sizeof (TD_DROP_TYPES [0]);


/*****************************************************************************/
/* Globals variables */
/*****************************************************************************/
 /* Application */
GtkObject *APP;
void *PLUGINS_CORE[50];
void *PLUGINS_DATA[50];

/* Data */
GList *DATA_LIST_TYPE;

/* Drag'n'drop */
int FLAG_DRAG_ROW_OLD;
int FLAG_DRAG_AUTOEXPAND_ID;
int FLAG_DRAG_AUTOEXPAND_ROW;
int DRAG_ROW;

/* Internals flags */
gboolean FLAG_ANTI_AUTOEXPAND;
gboolean FLAG_NO_REFRESH_NODE;

/* Widget */
GtkFileSelection *WINDOW_FILE_SELECTION;


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
void td_init (void);

/*****************************************************************************/
/* Ok */
/*****************************************************************************/
void td_set_ok (GtkWidget *widget, gboolean *dialog_result);

/*****************************************************************************/
/* Text */
/*****************************************************************************/
gchar *td_text_normalize_null (gchar *text);

/*****************************************************************************/
/* Message */
/*****************************************************************************/
void td_message_create_window (gchar *message);
int td_question_create_window (gchar *question, gchar *titre);
gchar *td_fileselector_create_window (gchar *title, gchar *file, gboolean show);

/*****************************************************************************/
/* Extension */
/*****************************************************************************/
gboolean td_system (gchar *command);
gpointer *td_dlsym (void *module, gchar *dir, gchar *file, gchar *symbol);
