/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Fossile : Arbre d'actions pour projet infomatique
 * ToutDoux's plug-in : Fossile : Simple actions tree for computer project
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "main.h"
#include "icons.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkObject *mod; /* Module */


/*****************************************************************************/
/* Dfinition des menus */
/*****************************************************************************/
static GnomeUIInfo menu_help_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Customize"), NULL,
   plugins_custom, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_CUSTOM, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("About..."), NULL,
   mod_about, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_maxi_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create"), NULL,
   menu_new, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Insert-Create"), NULL,
   menu_new, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Remove"), NULL,
   menu_remove, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_mini_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create"), NULL,
   menu_new, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};


/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "Fossile",
		  "type", _("view"),
		  "version", "1.0.2",
		  "blurb", _("Simple actions tree for computer project"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", _("The first ToutDoux's form"),
		  "category1", _("project manager"),
		  "category2", "Fossile",
		  "category3", "(null)",
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "icon", g_strdup_printf ("%s/share/pixmaps/toutdoux/icon_fossile.xpm", PACKAGE_DATA_DIR),
		  "web", _("http://toutdoux.sourceforge.net/en/"), NULL);
  return ret;
}

void mod_about (void)
{
  td_about_show TD_ABOUT (TD_MOD (mod)->about);
}

GtkObject *plugins_mod_def (void)
{
  GtkObject *ret;
  GtkObject *tree[1];
  GtkObject *field[5];
  GtkObject *dico[5];
  GtkObject *icon[4];
  GtkObject *menu[1];
  GtkObject *icon_equal[4];
  GtkObject *menu_equal[3];
  GtkObject *prop[5];
  GtkWidget *prop_widget[5];
  GtkObject *prop_visible_equal[3];
  GtkObject *prop_unsensitive_equal[2];
  int i;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "Fossile",
		  "name_intl", "Fossile", NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());

  /* Actions : arbre */
  tree[0] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("Actions"), 
		  "reorderable", TRUE,
		  "column_auto_resize", TRUE,
		  "customize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[0]);

  /* Actions : champs */
  field[0] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[0]), 
		  "name", "name", 
		  "name_intl", _("Name"), 
		  "type", "varchar(200)", NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[0]);

  field[1] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[1]), 
		  "name", "version", 
		  "name_intl", _("Version"), 
		  "type", "varchar(10)", NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[1]);

  field[2] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[2]), 
		  "name", "planned", 
		  "name_intl", _("Planned"),
		  "type", "bool", NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[2]);

  dico[0] = td_field_dico_new ();
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[0]), "t" , _("yes"));
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[0]), "f" , _("no"));
  td_field_set_dico (TD_FIELD (field[2]), dico[0]);

  field[3] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[3]), 
		  "name", "design", 
		  "name_intl", _("Design"),
		  "type", "bool", NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[3]);

  dico[1] = td_field_dico_new ();
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[1]), "t" , _("yes"));
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[1]), "f" , _("no"));
  td_field_set_dico (TD_FIELD (field[3]), dico[1]);

  field[4] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[4]), 
		  "name", "construction", 
		  "name_intl", _("Construction"), 
		  "type", "bool", NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[4]);

  dico[2] = td_field_dico_new ();
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[2]), "t" , _("yes"));
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[2]), "f" , _("no"));
  td_field_set_dico (TD_FIELD (field[4]), dico[2]);

  /* Actions : proprits */
  prop[0] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[0]), 
		  "name", _("Name"), 
		  "tab", 0, 
		  "column", 0, NULL);

  prop_widget[0] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[0]), "changed", GTK_SIGNAL_FUNC (prop_name), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[0]), prop_widget[0], NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[0]);

  prop_visible_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[0]), 8, "(bud)");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[0]);

  prop_visible_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[1]), 8, "t");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[1]);

  prop_visible_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[2]), 8, "f");
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[2]);

  prop[1] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[1]), 
		  "name", _("Version"), 
		  "tab", 0, 
		  "column", 1, NULL);

  prop_widget[1] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[1]), "changed", GTK_SIGNAL_FUNC (prop_version), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[1]), prop_widget[1], NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[1]), prop_visible_equal[0]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[1]), prop_visible_equal[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[1]), prop_visible_equal[2]);

  prop[2] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[2]), 
		  "name", _("Planned"), 
		  "defaultv", _("no"), 
		  "tab", 0, 
		  "column", 2, NULL);

  prop_widget[2] = gtk_toggle_button_new_with_label (_("no"));
  gtk_signal_connect (GTK_OBJECT (prop_widget[2]), "clicked", GTK_SIGNAL_FUNC (prop_planned), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[2]), prop_widget[2], NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[2]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[2]), prop_visible_equal[0]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[2]), prop_visible_equal[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[2]), prop_visible_equal[2]);

  prop[3] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[3]), 
		  "name", _("Design"), 
		  "defaultv", _("no"), 
		  "tab", 0, 
		  "column", 3, NULL);

  prop_widget[3] = gtk_toggle_button_new_with_label (_("no"));
  gtk_signal_connect (GTK_OBJECT (prop_widget[3]), "clicked", GTK_SIGNAL_FUNC (prop_design), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[3]), prop_widget[3], NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[3]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[3]), prop_visible_equal[0]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[3]), prop_visible_equal[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[3]), prop_visible_equal[2]);

  prop_unsensitive_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_unsensitive_equal[0]), 2, _("no"));
  td_mod_tree_prop_add_unsensitive (TD_MOD_TREE_PROP (prop[3]), prop_unsensitive_equal[0]);

  prop[4] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[4]), 
		  "name", _("Construction"), 
		  "defaultv", _("no"), 
		  "tab", 0, 
		  "column", 4, NULL);

  prop_widget[4] = gtk_toggle_button_new_with_label (_("no"));
  gtk_signal_connect (GTK_OBJECT (prop_widget[4]), "clicked", GTK_SIGNAL_FUNC (prop_construction), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[4]), prop_widget[4], NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[4]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[4]), prop_visible_equal[0]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[4]), prop_visible_equal[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[4]), prop_visible_equal[2]);
  td_mod_tree_prop_add_unsensitive (TD_MOD_TREE_PROP (prop[4]), prop_unsensitive_equal[0]);

  prop_unsensitive_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_unsensitive_equal[1]), 3, _("no"));
  td_mod_tree_prop_add_unsensitive (TD_MOD_TREE_PROP (prop[4]), prop_unsensitive_equal[1]);

  /* Actions : icones */
  icon[0] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[0]), (gchar*) TD_STOCK_LIST_NO, (gchar*) TD_STOCK_LIST_NO);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[0]);

  icon_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[0]), 2, _("no"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[0]), icon_equal[0]);

  icon[1] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[1]), (gchar*) TD_STOCK_LIST_BOOKCLOSE, (gchar*) TD_STOCK_LIST_BOOKOPEN);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[1]);

  icon_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[1]), 3, _("no"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[1]), icon_equal[1]);

  icon[2] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[2]), (gchar*) list_eclair_xpm, (gchar*) list_eclair_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[2]);
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[2]), icon_equal[1]);

  icon_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[2]), 4, _("no"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[2]), icon_equal[2]);

  icon[3] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[3]), (gchar*) list_package_xpm, (gchar*) list_package_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[3]);

  icon_equal[3] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[3]), 4, _("yes"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[3]), icon_equal[3]);

  /* Actions : menu */
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[0]), gnome_popup_menu_new (menu_mini_uiinfo));

  menu[0] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[0]), gnome_popup_menu_new (menu_maxi_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[0]), menu[0]);

  menu_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[0]), 8, "(bud)");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[0]), menu_equal[0]);

  menu_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[1]), 8, "t");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[0]), menu_equal[1]);

  menu_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[2]), 8, "f");
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[0]), menu_equal[2]);
  return ret;
}

void plugins_init (int mod_id)
{
  mod = plugins_mod_def ();
  td_mod_create (TD_MOD (mod), mod_id);
}

void plugins_show (void)
{
  td_mod_show (TD_MOD (mod));
}

void plugins_hide (void)
{
  td_mod_hide (TD_MOD (mod));
}

void plugins_destroy (void)
{
  td_mod_destroy (TD_MOD (mod));
}

void plugins_custom (void)
{
  td_mod_custom_show (mod);
}

/*****************************************************************************/
/* Proprits */
/*****************************************************************************/
void prop_name (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 0, FALSE, FALSE);
}

void prop_version (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 1, FALSE, FALSE);
}

void prop_planned (GtkWidget *widget, GtkObject *mod_tree)
{
  GtkWidget *label_tampon;
  label_tampon = GTK_BUTTON (widget)->child;
  if (GTK_TOGGLE_BUTTON (widget)->active)
    gtk_label_set_text (GTK_LABEL (label_tampon), _("yes"));
  else
    gtk_label_set_text (GTK_LABEL (label_tampon), _("no"));
  td_mod_tree_refresh_node (widget, mod_tree, 2, TRUE, TRUE);
}

void prop_design (GtkWidget *widget, GtkObject *mod_tree)
{
  GtkWidget *label_tampon;
  label_tampon = GTK_BUTTON (widget)->child;
  if (GTK_TOGGLE_BUTTON (widget)->active)
    gtk_label_set_text (GTK_LABEL (label_tampon), _("yes"));
  else
    gtk_label_set_text (GTK_LABEL (label_tampon), _("no"));
  td_mod_tree_refresh_node (widget, mod_tree, 3, TRUE, TRUE);
}

void prop_construction (GtkWidget *widget, GtkObject *mod_tree)
{
  GtkWidget *label_tampon;
  label_tampon = GTK_BUTTON (widget)->child;
  if (GTK_TOGGLE_BUTTON (widget)->active)
    gtk_label_set_text (GTK_LABEL (label_tampon), _("yes"));
  else
    gtk_label_set_text (GTK_LABEL (label_tampon), _("no"));
  td_mod_tree_refresh_node (widget, mod_tree, 4, TRUE, TRUE);
}


/*****************************************************************************/
/* Menus */
/*****************************************************************************/
void menu_new (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node;
  GtkCTreeNode *node_parent = NULL;
  GtkCTreeNode *node_sibling = NULL;

  /* Valeurs */
  data = g_list_append (data, "");
  data = g_list_append (data, "");
  data = g_list_append (data, _("yes"));
  data = g_list_append (data, _("no"));
  data = g_list_append (data, _("no"));

  /* Node */
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Insert-Create"))))
    {
      if (GTK_CTREE_ROW (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected)->parent)
	node_parent = GTK_CTREE_ROW (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected)->parent;
      else
	node_parent = NULL;
      node_sibling = TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected;
    }
  else
    {
      node_parent = TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected;
      node_sibling = NULL;
      if (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected)
	gtk_ctree_expand (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected);
    }
  node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node_parent, node_sibling, data, TRUE);
  TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected = NULL;
  /* g_free (data); */
}

void menu_remove (GtkMenuItem *menuitem, gpointer user_data)
{
  td_mod_tree_remove_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
}

/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
void plugins_load (GtkObject *datatable)
{
  gtk_window_set_title (GTK_WINDOW (TD_MOD (mod)->window), g_strdup_printf ("ToutDoux : %s : %s", TD_MOD (mod)->name_intl, TD_DB_CONNECT (TD_APP(APP)->connect)->name));
  td_mod_tree_load (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), datatable, TRUE);
}

GtkObject *plugins_save (void)
{
  gtk_window_set_title (GTK_WINDOW (TD_MOD (mod)->window), g_strdup_printf ("ToutDoux : %s : %s", TD_MOD (mod)->name_intl, TD_DB_CONNECT (TD_APP(APP)->connect)->name));
  return (td_mod_tree_save (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TRUE));
}
