/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux :  propos
 * ToutDoux's plug-in : about
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkObject *mod; /* Module */
GtkObject *flower[3]; /* Fichier support */


/*****************************************************************************/
/* Dfinition des menus */
/*****************************************************************************/
static GnomeUIInfo menu_help_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("About..."), NULL,
   mod_about, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_uiinfo[] =
{
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};


/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("About"),
		  "type", _("help"),
		  "version", "1.0.1",
		  "blurb", _("About"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", "(null)",
		  "category1", _("core"),
		  "category2", _("help"),
		  "category3", _("about"),
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void mod_about (void)
{
  td_about_show TD_ABOUT (TD_MOD (mod)->about);
}

GtkObject *mod_def (void)
{
  GtkObject *ret;
  gchar *txt_tmp;

  GtkObject *box[1];
  GtkWidget *eventbox1;
  GtkWidget *viewport1;
  GtkWidget *vbox1;
  GtkWidget *pixmap;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *href;

  GtkObject *tree[3];
  GtkObject *field[3];

  GtkWidget *toolbar;
  GtkWidget *toolbar_icon;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *radiobutton3;
  GtkWidget *radiobutton4;
  GtkWidget *button1;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "about",
		  "name_intl", _("About"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());

  /* Barre d'outils */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf("%s/share/pixmaps/toutdoux/button_about.xpm", PACKAGE_DATA_DIR));
  radiobutton1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, NULL, _("About"), _("About"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton1);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton1), FALSE);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf ("%s/share/pixmaps/toutdoux/button_authors.xpm", PACKAGE_DATA_DIR));
  radiobutton2 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, radiobutton1, _("Authors"), _("Authors"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton2);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton2), FALSE);

  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf ("%s/share/pixmaps/toutdoux/button_thanks.xpm", PACKAGE_DATA_DIR));
  radiobutton3 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, radiobutton2, _("Thanks"), _("Thanks"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton3);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton3), FALSE);

  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf ("%s/share/pixmaps/toutdoux/button_supporters.xpm", PACKAGE_DATA_DIR));
  radiobutton4 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, radiobutton3, _("Supporters"), _("Supporters"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton4);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton4), FALSE);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_CLOSE);
  button1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Close"), _("Close"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton3), "clicked", GTK_SIGNAL_FUNC (radiobutton3_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton4), "clicked", GTK_SIGNAL_FUNC (radiobutton4_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (plugins_hide), NULL);
  td_mod_set_toolbar (TD_MOD (ret), toolbar);

  /* About : widget */
  box[0] = td_mod_box_new ();
  gtk_object_set (GTK_OBJECT (box[0]), 
		  "name", _("About"), NULL);
  td_mod_add_child (TD_MOD (ret), box[0]);
  eventbox1 = gtk_event_box_new ();
  gtk_widget_show (eventbox1);
  td_mod_box_set_widget (TD_MOD_BOX (box[0]), eventbox1);
  vbox1 = gtk_vbox_new (FALSE, 2);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (eventbox1), vbox1);

  /* Logo */
  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport1);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (vbox1), viewport1, TRUE, TRUE, 0);
  pixmap = gtk_type_new (gnome_pixmap_get_type ());
  gnome_pixmap_load_file (GNOME_PIXMAP (pixmap), TD_ABOUT (TD_APP (APP)->about)->logo);
  gtk_widget_show (pixmap);
  gtk_container_add (GTK_CONTAINER (viewport1), pixmap);
  
  /* Licence */
  txt_tmp = g_strdup_printf(_("Version %s ( %s ) - Copyright (c) 2000 Philippe Roy"), VERSION, DATEVERSION, TD_ABOUT (TD_APP(APP)->about)->copyright);
  label1 = gtk_label_new (txt_tmp);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);
  label2 = gtk_label_new (TD_ABOUT (TD_APP (APP)->about)->license);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (vbox1), label2, FALSE, FALSE, 0);

  /* Site web */
  href = gnome_href_new (TD_ABOUT (TD_APP (APP)->about)->web, TD_ABOUT (TD_APP (APP)->about)->web);
  gtk_widget_show (href);
  gtk_box_pack_start (GTK_BOX (vbox1), href, FALSE, FALSE, 0);

  /* Auteurs : arbre */
  tree[0] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("About"),
		  "column_auto_resize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[0]);
  field[0] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[0]), 
		  "name", "Authors", 
		  "name_intl", _("Authors"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[0]);
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[0]), gnome_popup_menu_new (menu_uiinfo));

  /* Auteurs : fichier support (flower) */
  flower[0] = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower[0]),
		  "space", "toutdoux-authors/1.0.1",
		  "root", "authors", 
		  "branch", "section",
		  "petal", "author",
		  "foliole", "work",
		  "mode_one_column", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower[0]), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower[0]), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower[0]), "email");
  td_flower_add_foliole_attribut (TD_FLOWER (flower[0]), "name");
  td_flower_load_file (TD_FLOWER (flower[0]), g_strdup_printf ("%s/authors.xml", TD_APP (APP)->dir_doc));

  /* Remerciements : arbre */
  tree[1] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[1]), 
		  "name", _("About"),
		  "column_auto_resize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[1]);
  field[1] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[1]), 
		  "name", "Thanks", 
		  "name_intl", _("Thanks"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[1]), field[1]);
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[1]), gnome_popup_menu_new (menu_uiinfo));

  /* Remerciements : fichier support (flower) */
  flower[1] = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower[1]), 
		  "space", "toutdoux-thanks/1.0.1",
		  "root", "thanks", 
		  "branch", "user",
		  "mode_one_column", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower[1]), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower[1]), "email");
  td_flower_load_file (TD_FLOWER (flower[1]), g_strdup_printf("%s/doc/toutdoux/thanks.xml", PACKAGE_DATA_DIR));

  /* Supporter : arbre */
  tree[2] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[2]), 
		  "name", _("About"),
		  "column_auto_resize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[2]);
  field[2] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[2]), 
		  "name", "Supporters", 
		  "name_intl", _("Supporters"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[2]), field[2]);
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[2]), gnome_popup_menu_new (menu_uiinfo));

  /* Supporter : fichier support (flower) */
  flower[2] = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower[2]), 
		  "space", "toutdoux-supporters/1.0.1",
		  "root", "supporters", 
		  "branch", "supporter",
		  "mode_one_column", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "email");
  td_flower_add_branch_attribut (TD_FLOWER (flower[2]), "category");
  td_flower_load_file (TD_FLOWER (flower[2]), g_strdup_printf("%s/doc/toutdoux/thanks.xml", PACKAGE_DATA_DIR));
  return ret;
}

void plugins_show (gboolean exist)
{
  /* Cration */
  if (!exist)
    {
      mod = mod_def ();
      td_mod_create (TD_MOD (mod), -1);
      td_mod_tree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 1), flower[0]);
      td_mod_tree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 2), flower[1]);
      td_mod_tree_load_flower (g_list_nth_data (TD_MOD (mod)->child, 3), flower[2]);
    }

  /* Affichage */
  td_mod_show (TD_MOD (mod));
}

void plugins_hide (void)
{
  td_mod_hide (TD_MOD (mod));
}

void plugins_destroy (void)
{
  td_mod_destroy (TD_MOD (mod));
  td_flower_destroy (TD_FLOWER (flower[0]));
  td_flower_destroy (TD_FLOWER (flower[1]));
  td_flower_destroy (TD_FLOWER (flower[2]));
}

/*****************************************************************************/
/* Barre d'outils */
/*****************************************************************************/
void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 0);
}
void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 1);
}
void radiobutton3_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 2);
}
void radiobutton4_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 3);
}









