/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Communication avec une base de donnes
 * ToutDoux's plug-in : Data base communication
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "main.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkObject *mod; /* Module */


/*****************************************************************************/
/* Dfinition des menus */
/*****************************************************************************/
static GnomeUIInfo menu_help_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("About..."), NULL,
   mod_about, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_mini_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create base"), NULL,
   menu_new_base, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_maxi_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create base"), NULL,
   menu_new_base, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Remove base"), NULL,
   menu_remove_base, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};


/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Database communication"),
		  "type", _("communication"),
		  "version", "1.0.1",
		  "blurb", _("Database communication"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", _("hOpla frontend"),
		  "category1", _("core"),
		  "category2", _("communication"),
		  "category3", _("database"),
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void mod_about (void)
{
  td_about_show TD_ABOUT (TD_MOD (mod)->about);
}

GtkObject *mod_def (void)
{
  GtkObject *ret;
  GtkObject *tree[1];
  GtkObject *field[1];
  GtkObject *menu[1];
  GtkObject *menu_equal[1];
  GtkWidget *toolbar;
  GtkWidget *toolbar_icon;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *statusbar;
  gchar *txt_tmp;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "database_admin",
		  "name_intl", _("Database administration"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());

  /* Barre d'outils */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_REVERT);
  button1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Re-read server"), _("Re-read server"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);
  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_SAVE);
  button2 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Write server"), _("Write server"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button2);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_CLOSE);
  button3 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Close"), _("Close"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (open_server), NULL);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC (save_server), NULL);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked", GTK_SIGNAL_FUNC (plugins_hide), NULL);
  td_mod_set_toolbar (TD_MOD (ret), toolbar);

  /* Barre d'tats */
  statusbar = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_ALWAYS); 
  gtk_signal_connect (GTK_OBJECT (statusbar), "user-response", GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  td_mod_set_statusbar (TD_MOD (ret), statusbar);

  /* Bases : arbre */
  tree[0] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("Database administration"), NULL);
  td_mod_add_child (TD_MOD (ret), tree[0]);
  field[0] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[0]), 
		  "name", "Bases", 
		  "name_intl", _("Bases"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[0]);

  /* Bases : menu */
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[0]), gnome_popup_menu_new (menu_mini_uiinfo));
  menu[0] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[0]), gnome_popup_menu_new (menu_maxi_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[0]), menu[0]);
  menu_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[0]), 1, _("(bud)"));
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[0]), menu_equal[0]);
  td_mod_tree_add_menu (TD_MOD_TREE (tree[0]), menu[0]);
  return ret;
}

void plugins_init (void)
{
  mod = mod_def ();
  td_mod_create (TD_MOD (mod), -1);
}

void plugins_show (gboolean exist)
{
  td_mod_show (TD_MOD (mod));
  open_server (NULL, NULL);
}

void plugins_hide (void)
{
  td_mod_hide (TD_MOD (mod));
}

void plugins_destroy (void)
{
  td_mod_destroy (TD_MOD (mod));
}


/*****************************************************************************/
/* Menu */
/*****************************************************************************/
void menu_new_base (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node;

  /* Go ! */
  gnome_appbar_set_prompt (GNOME_APPBAR (TD_MOD (mod)->statusbar), g_strdup_printf(_("Database name ? :")), FALSE);
  gtk_grab_add (GTK_WIDGET (TD_MOD (mod)->statusbar));
  gtk_main ();
  gtk_grab_remove (GTK_WIDGET (TD_MOD (mod)->statusbar));
  data = g_list_append (data, g_strdup_printf("%s", gnome_appbar_get_response (GNOME_APPBAR (TD_MOD (mod)->statusbar))));
  gnome_appbar_clear_prompt (GNOME_APPBAR (TD_MOD (mod)->statusbar));
  node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL, NULL, data, TRUE);
  g_list_free (data);
}

void menu_remove_base (GtkMenuItem *menuitem, gpointer user_data)
{
  td_mod_tree_remove_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
}


/*****************************************************************************/
/* Barre d'outils */
/*****************************************************************************/
gboolean open_server (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkObject *base;
  GtkObject *datatable;
  GtkCTreeNode *node;
  gchar *txt_tmp;
  int i;
  gchar *file_tmp = g_strdup_printf ("%s/admin.toutdoux", TD_APP(APP)->dir_tmp);
  gchar *file_log = g_strdup_printf ("%s/hopla.log", TD_APP(APP)->dir_tmp);
  gchar *file_xmllog = g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp);

  /* Lecture serveur *//* FIXME: connexion pas configurable  : +tards */
  td_palette_message (NULL, _("Database administration"), "begin");
  txt_tmp = g_strdup_printf ("hopla --interface=pgsql --file=%s --operation=admin2xml --log=%s --nocolor > %s", file_tmp, file_xmllog, file_log);
  if (!td_system (txt_tmp))
    return FALSE;
  /* td_command_xmllog_open (file_xmllog); *//* FIXME: XML log : +tards */

  /* Affichage */
  td_mod_tree_clear (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
  base = td_db_base_load_hopla (file_tmp);
  datatable = g_list_nth_data (TD_DB_BASE (base)->datatable, 0);
  for (i=0; i<g_list_length (TD_DB_DATATABLE (datatable)->item); i++)
    {
      data = g_list_nth_data (TD_DB_DATATABLE (datatable)->item, i);
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL, NULL, data, TRUE);
      data = NULL;
    }
  td_palette_message (NULL, _("Database administration"), "end");
  g_list_free (data);
  return TRUE;
}

gboolean save_server (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkObject *base;
  GtkObject *table;
  GtkObject *table_field;
  GtkObject *datatable;
  GtkCTreeNode *node;
  int i;
  gchar *file_tmp = g_strdup_printf ("%s/admin.toutdoux", TD_APP(APP)->dir_tmp);
  gchar *file_log = g_strdup_printf ("%s/hopla.log", TD_APP(APP)->dir_tmp);
  gchar *file_xmllog = g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp);
  gchar *txt_tmp;

  /* Dfinition de la structure XML */
  td_palette_message (NULL, _("Database administration"), "begin");
  base = td_db_base_new ();
  TD_DB_BASE (base)->name = "database administration";
  TD_DB_BASE (base)->comment = "(null)";
  table = td_db_table_new ();
  TD_DB_TABLE (table)->name = "hopla_bases";
  TD_DB_TABLE (table)->comment = "(null)";
  table_field = td_db_table_field_new ();
  TD_DB_TABLE_FIELD (table_field)->name = "name";
  TD_DB_TABLE_FIELD (table_field)->comment = "(null)";
  TD_DB_TABLE_FIELD (table_field)->key = 1;
  TD_DB_TABLE_FIELD (table_field)->type = "varchar[200]";
  TD_DB_TABLE_FIELD (table_field)->typecomment = "(null)";
  td_db_table_add_field (TD_DB_TABLE (table), table_field);
  td_db_base_add_table (TD_DB_BASE(base), table);

  /* Lecture arbre */
  datatable = td_db_datatable_new ();
  TD_DB_DATATABLE (datatable)->table = "hopla_bases";
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), 0);
  if (node)
    do
      {
	data = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node, FALSE);
	td_db_datatable_add_item (TD_DB_DATATABLE (datatable), data);
	node = gtdk_ctree_next (node);
      }
    while (node);
  td_db_base_add_datatable (TD_DB_BASE(base), datatable);

  /* Ecriture fichier XML */
  txt_tmp = g_strdup_printf ("%s '%s'", _("Writting tempory file"), file_tmp);
  if (!td_db_base_save_hopla (TD_DB_BASE (base), file_tmp))
    {
      td_palette_message (_("Writting tempory file"), txt_tmp, "failed");
      td_palette_message (NULL, _("Database administration"), "end");
      gtk_object_destroy (GTK_OBJECT (base));
      gtk_object_destroy (GTK_OBJECT (table));
      gtk_object_destroy (GTK_OBJECT (table_field));
      gtk_object_destroy (GTK_OBJECT (datatable));
      return FALSE;
    }
  td_palette_message (_("Writting tempory file"), txt_tmp, "done");

  /* Ecriture serveur *//* FIXME: connexion pas configurable : +tards */
  txt_tmp = g_strdup_printf ("hopla --interface=pgsql --file=%s --operation=xml2admin --log=%s --nocolor > %s", file_tmp, file_xmllog, file_log);
  if (!td_system (txt_tmp))
    return FALSE;
  /* td_command_xmllog_open (file_xmllog); *//* FIXME: XML log : +tards */
  td_palette_message (NULL, _("Database administration"), "end");
  gtk_object_destroy (GTK_OBJECT (base));
  gtk_object_destroy (GTK_OBJECT (table));
  gtk_object_destroy (GTK_OBJECT (table_field));
  gtk_object_destroy (GTK_OBJECT (datatable));
  return TRUE;
}


/*****************************************************************************/
/* hOpla */
/*****************************************************************************/
/* Prfix de commande hopla pour hte, port, utilisateur et mot de passe */
gchar *prefix_hopla (gchar *host, gchar *port, gchar *user, gchar *password, gchar *base, gchar *template)
{
  gchar *ret = g_strdup_printf ("hopla");

  /* Go ! */
  if (host)
    if (strcmp (td_text_normalize_null (host), "(null)"))
      ret = g_strdup_printf("%s --host=%s", ret, host);
  if (port)
    if (strcmp (td_text_normalize_null (port), "(null)"))
      ret = g_strdup_printf("%s --port=%s", ret, port);
  if (user)
    if (strcmp (td_text_normalize_null (user), "(null)"))
      ret = g_strdup_printf("%s --user=%s", ret, user);
  if (password)
    if (strcmp (td_text_normalize_null (password), "(null)"))
      ret = g_strdup_printf("%s --password=%s", ret, password);
  if (base)
    if (strcmp (td_text_normalize_null (base), "(null)"))
      ret = g_strdup_printf("%s --base=%s", ret, base);
  if (template)
    if (strcmp (td_text_normalize_null (template), "(null)"))
      ret = g_strdup_printf("%s --template=%s", ret, template);
  return (ret);
}

gboolean plugins_load_database (GtkObject *connect)
{
  gchar *file_tmp = g_strdup_printf ("%s/database.toutdoux", TD_APP(APP)->dir_tmp);
  gchar *file_log = g_strdup_printf ("%s/hopla.log", TD_APP(APP)->dir_tmp);
  gchar *file_xmllog = g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp);
  gchar *txt_tmp;
  int i;

  /* Go ! */
  txt_tmp = g_strdup_printf ("%s --interface=%s --file=%s --operation=db2xml --log=%s --nocolor > %s", 
			     prefix_hopla (
					   TD_DB_CONNECT(connect)->host, 
					   TD_DB_CONNECT(connect)->port, 
					   TD_DB_CONNECT(connect)->user, 
					   TD_DB_CONNECT(connect)->password, 
					   TD_DB_CONNECT(connect)->base, 
					   TD_DB_CONNECT(connect)->template), 
			     TD_DB_CONNECT(connect)->interface, file_tmp, file_xmllog, file_log);
  if (!td_system (txt_tmp))
    return FALSE;
  return TRUE;
}


gboolean plugins_save_database (GtkObject *connect)
{
  gchar *file_tmp = g_strdup_printf ("%s/database.toutdoux", TD_APP(APP)->dir_tmp);
  gchar *file_log = g_strdup_printf ("%s/hopla.log", TD_APP(APP)->dir_tmp);
  gchar *file_xmllog = g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp);
  gchar *txt_tmp;
  int i;

  /* Go ! */  
  txt_tmp = g_strdup_printf ("%s --interface=%s --file=%s --operation=xml2data --method=update --log=%s --nocolor > %s", 
			     prefix_hopla (
					   TD_DB_CONNECT(connect)->host, 
					   TD_DB_CONNECT(connect)->port, 
					   TD_DB_CONNECT(connect)->user, 
					   TD_DB_CONNECT(connect)->password, 
					   TD_DB_CONNECT(connect)->base, 
					   TD_DB_CONNECT(connect)->template), 
			     TD_DB_CONNECT(connect)->interface, file_tmp, file_xmllog, file_log);
  if (!td_system (txt_tmp))
    return FALSE;
  return TRUE;
}

gboolean plugins_save_structure (GtkObject *connect)
{
  gchar *file_tmp = g_strdup_printf ("%s/database.toutdoux", TD_APP(APP)->dir_tmp);
  gchar *file_log = g_strdup_printf ("%s/hopla.log", TD_APP(APP)->dir_tmp);
  gchar *file_xmllog = g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp);
  gchar *txt_tmp;
  int i;

  /* Go ! */  
  txt_tmp = g_strdup_printf ("%s --interface=%s --file=%s --operation=xml2struc --log=%s --nocolor > %s", 
			     prefix_hopla (
					   TD_DB_CONNECT(connect)->host, 
					   TD_DB_CONNECT(connect)->port, 
					   TD_DB_CONNECT(connect)->user, 
					   TD_DB_CONNECT(connect)->password, 
					   TD_DB_CONNECT(connect)->base, 
					   NULL), 
			     TD_DB_CONNECT(connect)->interface, file_tmp, file_xmllog, file_log);
  if (!td_system (txt_tmp))
    return FALSE;
  return TRUE;
}







