/*
 * Copyright © 2002-2012 Bastien Nocera <hadess@hadess.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * The Totem project hereby grant permission for non-gpl compatible GStreamer
 * plugins to be used and distributed together with GStreamer and Totem. This
 * permission is above and beyond the permissions granted by the GPL license
 * Totem is covered by.
 *
 * Monday 7th February 2005: Christian Schaller: Add exception clause.
 * See license_change file for details.
 *
 */

#ifndef _TOTEM_TIME_HELPERS_H_
#define _TOTEM_TIME_HELPERS_H_

#include <glib.h>

typedef enum {
	TOTEM_TIME_FLAG_NONE            = 0,
	TOTEM_TIME_FLAG_REMAINING       = 1 << 0,
	TOTEM_TIME_FLAG_FORCE_HOUR      = 1 << 2,
	TOTEM_TIME_FLAG_MSECS           = 1 << 3,
} TotemTimeFlag;

char *totem_time_to_string (gint64        msecs,
			    TotemTimeFlag flags);

#endif /* _TOTEM_TIME_HELPERS_H_ */
