/*
 * This file is part of Tepl, a text editor library.
 *
 * Copyright 2016-2020 - Sébastien Wilmet <swilmet@gnome.org>
 *
 * Tepl is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * Tepl is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TEPL_H
#define TEPL_H

#define TEPL_H_INSIDE

#include <amtk/amtk.h>

#include <tepl/tepl-enum-types.h>

#include <tepl/tepl-abstract-factory.h>
#include <tepl/tepl-application.h>
#include <tepl/tepl-application-window.h>
#include <tepl/tepl-buffer.h>
#include <tepl/tepl-encoding.h>
#include <tepl/tepl-file.h>
#include <tepl/tepl-file-loader.h>
#include <tepl/tepl-file-saver.h>
#include <tepl/tepl-fold-region.h>
#include <tepl/tepl-gutter-renderer-folds.h>
#include <tepl/tepl-info-bar.h>
#include <tepl/tepl-init.h>
#include <tepl/tepl-io-error-info-bars.h>
#include <tepl/tepl-iter.h>
#include <tepl/tepl-menu-shell.h>
#include <tepl/tepl-metadata.h>
#include <tepl/tepl-metadata-manager.h>
#include <tepl/tepl-notebook.h>
#include <tepl/tepl-panel.h>
#include <tepl/tepl-statusbar.h>
#include <tepl/tepl-style-scheme-chooser-widget.h>
#include <tepl/tepl-tab.h>
#include <tepl/tepl-tab-group.h>
#include <tepl/tepl-tab-label.h>
#include <tepl/tepl-utils.h>
#include <tepl/tepl-view.h>

#undef TEPL_H_INSIDE

#endif /* TEPL_H */
