/* pixpack.c generated by valac 0.42.2, the Vala compiler
 * generated from pixpack.vala, do not modify */

/*
 * Copyright (C) 2000 Dirk-Jan C. Binnema <djcb@dds.nl>
 * Copyright (C) 2008-2016 Colin Watson <cjwatson@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */
/* Image-rendering widget. */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>


#define TG_TYPE_PIXPACK (tg_pixpack_get_type ())
#define TG_PIXPACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_PIXPACK, TgPixpack))
#define TG_PIXPACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_PIXPACK, TgPixpackClass))
#define TG_IS_PIXPACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_PIXPACK))
#define TG_IS_PIXPACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_PIXPACK))
#define TG_PIXPACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_PIXPACK, TgPixpackClass))

typedef struct _TgPixpack TgPixpack;
typedef struct _TgPixpackClass TgPixpackClass;
typedef struct _TgPixpackPrivate TgPixpackPrivate;
enum  {
	TG_PIXPACK_0_PROPERTY,
	TG_PIXPACK_AUTOSIZE_PROPERTY,
	TG_PIXPACK_NUM_PROPERTIES
};
static GParamSpec* tg_pixpack_properties[TG_PIXPACK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TgPixpack {
	GtkWidget parent_instance;
	TgPixpackPrivate * priv;
};

struct _TgPixpackClass {
	GtkWidgetClass parent_class;
};

struct _TgPixpackPrivate {
	GdkPixbuf* pixbuf;
	gboolean _autosize;
};


static gint TgPixpack_private_offset;
static gpointer tg_pixpack_parent_class = NULL;

GType tg_pixpack_get_type (void) G_GNUC_CONST;
TgPixpack* tg_pixpack_new (void);
TgPixpack* tg_pixpack_construct (GType object_type);
static void tg_pixpack_on_unrealize (TgPixpack* self);
static void _tg_pixpack_on_unrealize_gtk_widget_unrealize (GtkWidget* _sender,
                                                    gpointer self);
static void tg_pixpack_real_realize (GtkWidget* base);
static gboolean tg_pixpack_real_draw (GtkWidget* base,
                               cairo_t* cr);
void tg_pixpack_load_image (TgPixpack* self,
                            GdkPixbuf* pixbuf);
gboolean tg_pixpack_get_autosize (TgPixpack* self);
void tg_pixpack_load_image_from_resource (TgPixpack* self,
                                          const gchar* resource_path);
void tg_pixpack_set_autosize (TgPixpack* self,
                              gboolean value);
static void tg_pixpack_finalize (GObject * obj);
static void _vala_tg_pixpack_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_tg_pixpack_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);


static inline gpointer
tg_pixpack_get_instance_private (TgPixpack* self)
{
	return G_STRUCT_MEMBER_P (self, TgPixpack_private_offset);
}


static void
_tg_pixpack_on_unrealize_gtk_widget_unrealize (GtkWidget* _sender,
                                               gpointer self)
{
	tg_pixpack_on_unrealize ((TgPixpack*) self);
}


TgPixpack*
tg_pixpack_construct (GType object_type)
{
	TgPixpack * self = NULL;
	self = (TgPixpack*) gtk_widget_new (object_type, "can-focus", TRUE, "receives-default", TRUE, NULL);
	_g_object_unref0 (self->priv->pixbuf);
	self->priv->pixbuf = NULL;
	gtk_widget_set_has_window ((GtkWidget*) self, TRUE);
	g_signal_connect_object ((GtkWidget*) self, "unrealize", (GCallback) _tg_pixpack_on_unrealize_gtk_widget_unrealize, self, 0);
	return self;
}


TgPixpack*
tg_pixpack_new (void)
{
	return tg_pixpack_construct (TG_TYPE_PIXPACK);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
tg_pixpack_real_realize (GtkWidget* base)
{
	TgPixpack * self;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GdkWindowAttr attributes = {0};
	GtkAllocation _tmp1_;
	gint _tmp2_;
	GtkAllocation _tmp3_;
	gint _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	GdkVisual* _tmp9_;
	GdkWindowAttr _tmp10_ = {0};
	GdkWindowAttributesType attributes_mask = 0;
	GdkWindow* window = NULL;
	GdkWindow* _tmp11_;
	GdkWindowAttr _tmp12_;
	GdkWindow* _tmp13_;
	GdkWindow* _tmp14_;
	self = (TgPixpack*) base;
	gtk_widget_set_realized ((GtkWidget*) self, TRUE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = allocation;
	_tmp2_ = _tmp1_.x;
	_tmp3_ = allocation;
	_tmp4_ = _tmp3_.y;
	_tmp5_ = allocation;
	_tmp6_ = _tmp5_.height;
	_tmp7_ = allocation;
	_tmp8_ = _tmp7_.width;
	_tmp9_ = gtk_widget_get_visual ((GtkWidget*) self);
	memset (&_tmp10_, 0, sizeof (GdkWindowAttr));
	_tmp10_.window_type = GDK_WINDOW_CHILD;
	_tmp10_.x = _tmp2_;
	_tmp10_.y = _tmp4_;
	_tmp10_.height = _tmp6_;
	_tmp10_.width = _tmp8_;
	_tmp10_.wclass = GDK_INPUT_OUTPUT;
	_tmp10_.visual = _tmp9_;
	_tmp10_.event_mask = gtk_widget_get_events ((GtkWidget*) self) | GDK_EXPOSURE_MASK;
	attributes = _tmp10_;
	attributes_mask = (GDK_WA_X | GDK_WA_Y) | GDK_WA_VISUAL;
	_tmp11_ = gtk_widget_get_parent_window ((GtkWidget*) self);
	_tmp12_ = attributes;
	_tmp13_ = gdk_window_new (_tmp11_, &_tmp12_, attributes_mask);
	window = _tmp13_;
	_tmp14_ = _g_object_ref0 (window);
	gtk_widget_set_window ((GtkWidget*) self, _tmp14_);
	gdk_window_set_user_data (window, (GObject*) self);
	_g_object_unref0 (window);
}


static void
tg_pixpack_on_unrealize (TgPixpack* self)
{
	g_return_if_fail (self != NULL);
	if (gtk_widget_get_mapped ((GtkWidget*) self)) {
		gtk_widget_unmap ((GtkWidget*) self);
	}
	gtk_widget_set_mapped ((GtkWidget*) self, FALSE);
}


static gboolean
tg_pixpack_real_draw (GtkWidget* base,
                      cairo_t* cr)
{
	TgPixpack * self;
	gboolean result = FALSE;
	GdkPixbuf* _tmp0_;
	gint width = 0;
	gint height = 0;
	GdkPixbuf* _tmp1_;
	gint _tmp2_;
	GdkPixbuf* _tmp3_;
	gint _tmp4_;
	GdkPixbuf* _tmp5_;
	self = (TgPixpack*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->pixbuf;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	cairo_set_source_rgb (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_fill (cr);
	_tmp1_ = self->priv->pixbuf;
	gdk_cairo_set_source_pixbuf (cr, _tmp1_, (gdouble) 0, (gdouble) 0);
	_tmp2_ = width;
	_tmp3_ = self->priv->pixbuf;
	_tmp4_ = height;
	_tmp5_ = self->priv->pixbuf;
	cairo_scale (cr, (gdouble) (_tmp2_ / gdk_pixbuf_get_width (_tmp3_)), (gdouble) (_tmp4_ / gdk_pixbuf_get_height (_tmp5_)));
	cairo_paint (cr);
	result = TRUE;
	return result;
}


void
tg_pixpack_load_image (TgPixpack* self,
                       GdkPixbuf* pixbuf)
{
	GdkPixbuf* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	_tmp0_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->priv->pixbuf);
	self->priv->pixbuf = _tmp0_;
	_tmp1_ = self->priv->_autosize;
	if (_tmp1_) {
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		_tmp2_ = self->priv->pixbuf;
		_tmp3_ = self->priv->pixbuf;
		gtk_widget_set_size_request ((GtkWidget*) self, gdk_pixbuf_get_width (_tmp2_), gdk_pixbuf_get_height (_tmp3_));
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void
tg_pixpack_load_image_from_resource (TgPixpack* self,
                                     const gchar* resource_path)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource_path != NULL);
	{
		GdkPixbuf* pixbuf = NULL;
		GdkPixbuf* _tmp0_;
		_tmp0_ = gdk_pixbuf_new_from_resource (resource_path, &_inner_error_);
		pixbuf = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		tg_pixpack_load_image (self, pixbuf);
		_g_object_unref0 (pixbuf);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_vala_assert (_tmp1_, "e");
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean
tg_pixpack_get_autosize (TgPixpack* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_autosize;
	result = _tmp0_;
	return result;
}


void
tg_pixpack_set_autosize (TgPixpack* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	if (tg_pixpack_get_autosize (self) != value) {
		self->priv->_autosize = value;
		g_object_notify_by_pspec ((GObject *) self, tg_pixpack_properties[TG_PIXPACK_AUTOSIZE_PROPERTY]);
	}
}


static void
tg_pixpack_class_init (TgPixpackClass * klass)
{
	tg_pixpack_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TgPixpack_private_offset);
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget *)) tg_pixpack_real_realize;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) tg_pixpack_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_tg_pixpack_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tg_pixpack_set_property;
	G_OBJECT_CLASS (klass)->finalize = tg_pixpack_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TG_PIXPACK_AUTOSIZE_PROPERTY, tg_pixpack_properties[TG_PIXPACK_AUTOSIZE_PROPERTY] = g_param_spec_boolean ("autosize", "Autosize", "If true, set the widget's size request to the size of the image.", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
tg_pixpack_instance_init (TgPixpack * self)
{
	self->priv = tg_pixpack_get_instance_private (self);
	self->priv->_autosize = FALSE;
}


static void
tg_pixpack_finalize (GObject * obj)
{
	TgPixpack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TG_TYPE_PIXPACK, TgPixpack);
	_g_object_unref0 (self->priv->pixbuf);
	G_OBJECT_CLASS (tg_pixpack_parent_class)->finalize (obj);
}


GType
tg_pixpack_get_type (void)
{
	static volatile gsize tg_pixpack_type_id__volatile = 0;
	if (g_once_init_enter (&tg_pixpack_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TgPixpackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tg_pixpack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TgPixpack), 0, (GInstanceInitFunc) tg_pixpack_instance_init, NULL };
		GType tg_pixpack_type_id;
		tg_pixpack_type_id = g_type_register_static (gtk_widget_get_type (), "TgPixpack", &g_define_type_info, 0);
		TgPixpack_private_offset = g_type_add_instance_private (tg_pixpack_type_id, sizeof (TgPixpackPrivate));
		g_once_init_leave (&tg_pixpack_type_id__volatile, tg_pixpack_type_id);
	}
	return tg_pixpack_type_id__volatile;
}


static void
_vala_tg_pixpack_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	TgPixpack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TG_TYPE_PIXPACK, TgPixpack);
	switch (property_id) {
		case TG_PIXPACK_AUTOSIZE_PROPERTY:
		g_value_set_boolean (value, tg_pixpack_get_autosize (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_tg_pixpack_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	TgPixpack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TG_TYPE_PIXPACK, TgPixpack);
	switch (property_id) {
		case TG_PIXPACK_AUTOSIZE_PROPERTY:
		tg_pixpack_set_autosize (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



