/* game-view.c generated by valac 0.25.3.3-7022, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cogl/cogl.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_TILE_ACTOR (tile_actor_get_type ())
#define TILE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_ACTOR, TileActor))
#define TILE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_ACTOR, TileActorClass))
#define IS_TILE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_ACTOR))
#define IS_TILE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_ACTOR))
#define TILE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_ACTOR, TileActorClass))

typedef struct _TileActor TileActor;
typedef struct _TileActorClass TileActorClass;

#define TYPE_CURSOR_ACTOR (cursor_actor_get_type ())
#define CURSOR_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURSOR_ACTOR, CursorActor))
#define CURSOR_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURSOR_ACTOR, CursorActorClass))
#define IS_CURSOR_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURSOR_ACTOR))
#define IS_CURSOR_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURSOR_ACTOR))
#define CURSOR_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURSOR_ACTOR, CursorActorClass))

typedef struct _CursorActor CursorActor;
typedef struct _CursorActorClass CursorActorClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _ThemePrivate ThemePrivate;
typedef struct _TilePrivate TilePrivate;
typedef struct _TileActorPrivate TileActorPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SCORE_ACTOR (score_actor_get_type ())
#define SCORE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_ACTOR, ScoreActor))
#define SCORE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_ACTOR, ScoreActorClass))
#define IS_SCORE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_ACTOR))
#define IS_SCORE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_ACTOR))
#define SCORE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_ACTOR, ScoreActorClass))

typedef struct _ScoreActor ScoreActor;
typedef struct _ScoreActorClass ScoreActorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_ClutterPoint_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterPoint_free (var), NULL)))
typedef struct _CursorActorPrivate CursorActorPrivate;
typedef struct _ScoreActorPrivate ScoreActorPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
	gboolean is_zealous;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	TileActor* highlighted;
	CursorActor* cursor;
	gboolean cursor_active;
	gint _cursor_x;
	gint _cursor_y;
	TileActor** tiles;
	gint tiles_length1;
	gint tiles_length2;
	ClutterActor* game_actors;
	Game* _game;
	GHashTable* themes;
	gchar* _theme_name;
	gint tile_size;
};

struct _Theme {
	GObject parent_instance;
	ThemePrivate * priv;
	ClutterImage** textures;
	gint textures_length1;
	ClutterImage* cursor;
};

struct _ThemeClass {
	GObjectClass parent_class;
};

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	gint grid_x;
	gint grid_y;
	gint color;
	gboolean visited;
};

struct _TileClass {
	GObjectClass parent_class;
};

struct _TileActor {
	ClutterActor parent_instance;
	TileActorPrivate * priv;
	Tile* tile;
};

struct _TileActorClass {
	ClutterActorClass parent_class;
};

struct _CursorActor {
	ClutterActor parent_instance;
	CursorActorPrivate * priv;
};

struct _CursorActorClass {
	ClutterActorClass parent_class;
};

struct _ScoreActor {
	ClutterGroup parent_instance;
	ScoreActorPrivate * priv;
};

struct _ScoreActorClass {
	ClutterGroupClass parent_class;
};

struct _ScoreActorPrivate {
	ClutterText* label;
	gfloat scene_width;
	gfloat scene_height;
	gint game_size;
};


static gpointer game_view_parent_class = NULL;
static gpointer theme_parent_class = NULL;
static gpointer tile_actor_parent_class = NULL;
static gpointer cursor_actor_parent_class = NULL;
static gpointer score_actor_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType tile_actor_get_type (void) G_GNUC_CONST;
GType cursor_actor_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
GType theme_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_CURSOR_X,
	GAME_VIEW_CURSOR_Y,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME_NAME
};
static void game_view_remove_tiles (GameView* self);
Game* game_view_get_game (GameView* self);
gint game_get_columns (Game* self);
gint game_get_rows (Game* self);
static void game_view_place_tiles (GameView* self);
const gchar* game_view_get_theme_name (GameView* self);
GType tile_get_type (void) G_GNUC_CONST;
Tile* game_get_tile (Game* self, gint x, gint y);
gboolean tile_get_closed (Tile* self);
TileActor* tile_actor_new (Tile* tile, ClutterImage* texture, gint size);
TileActor* tile_actor_construct (GType object_type, Tile* tile, ClutterImage* texture, gint size);
void game_view_move_cb (GameView* self, gint old_x, gint old_y, gint new_x, gint new_y);
static void _game_view_move_cb_tile_move (Tile* _sender, gint old_x, gint old_y, gint new_x, gint new_y, gpointer self);
void game_view_close_cb (GameView* self, gint grid_x, gint grid_y);
static void _game_view_close_cb_tile_close (Tile* _sender, gint grid_x, gint grid_y, gpointer self);
static void game_view_remove_region_cb (GameView* self, ClutterTapAction* tap, ClutterActor* actor);
static void _game_view_remove_region_cb_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self);
static gboolean game_view_tile_entered_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event);
static gboolean _game_view_tile_entered_cb_clutter_actor_enter_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self);
static gboolean game_view_tile_left_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event);
static gboolean _game_view_tile_left_cb_clutter_actor_leave_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self);
CursorActor* cursor_actor_new (ClutterContent* texture, gint size);
CursorActor* cursor_actor_construct (GType object_type, ClutterContent* texture, gint size);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
Theme* theme_new (const gchar* name);
Theme* theme_construct (GType object_type, const gchar* name);
void tile_actor_animate_out (TileActor* self);
void tile_actor_animate_to (TileActor* self, gdouble new_x, gdouble new_y, gboolean is_zealous);
static void game_view_opacity_for_connected_tiles (GameView* self, TileActor* actor, gint opacity);
GList* game_connected_tiles (Game* self, Tile* li);
static void _g_list_free__g_object_unref0_ (GList* self);
void game_view_set_cursor_x (GameView* self, gint value);
void game_view_set_cursor_y (GameView* self, gint value);
gboolean game_remove_connected_tiles (Game* self, Tile* tile);
gboolean game_view_board_left_cb (GameView* self);
void game_reset_visit (Game* self);
void game_view_cursor_move (GameView* self, gint x, gint y);
gint game_view_get_cursor_x (GameView* self);
gint game_view_get_cursor_y (GameView* self);
void game_view_cursor_click (GameView* self);
void game_view_update_score_cb (GameView* self, gint points_awarded);
GType score_actor_get_type (void) G_GNUC_CONST;
ScoreActor* score_actor_new (gint game_size, gdouble width, gdouble height);
ScoreActor* score_actor_construct (GType object_type, gint game_size, gdouble width, gdouble height);
void score_actor_animate_score (ScoreActor* self, gint points);
void game_view_game_complete_cb (GameView* self);
void score_actor_animate_final_score (ScoreActor* self, guint points);
gint game_get_score (Game* self);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self);
static void _game_view_update_score_cb_game_update_score (Game* _sender, gint points_awarded, gpointer self);
void game_view_set_theme_name (GameView* self, const gchar* value);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	THEME_DUMMY_PROPERTY
};
static void theme_finalize (GObject* obj);
enum  {
	TILE_ACTOR_DUMMY_PROPERTY
};
static void _vala_ClutterPoint_free (ClutterPoint* self);
static void tile_actor_hide_tile_cb (TileActor* self);
static void _tile_actor_hide_tile_cb_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static void tile_actor_finalize (GObject* obj);
enum  {
	CURSOR_ACTOR_DUMMY_PROPERTY
};
#define SCORE_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCORE_ACTOR, ScoreActorPrivate))
enum  {
	SCORE_ACTOR_DUMMY_PROPERTY
};
static void __lambda4_ (ScoreActor* self);
static void ___lambda4__clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static void score_actor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void game_view_remove_tiles (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	CursorActor* _tmp28_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_ = 0;
				Game* _tmp5_ = NULL;
				Game* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = x;
					x = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = x;
				_tmp5_ = game_view_get_game (self);
				_tmp6_ = _tmp5_;
				_tmp7_ = game_get_columns (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp4_ < _tmp8_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							Game* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							TileActor* tile = NULL;
							TileActor** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp16__length2 = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							TileActor* _tmp19_ = NULL;
							TileActor* _tmp20_ = NULL;
							TileActor* _tmp21_ = NULL;
							TileActor** _tmp22_ = NULL;
							gint _tmp22__length1 = 0;
							gint _tmp22__length2 = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							TileActor* _tmp25_ = NULL;
							TileActor* _tmp26_ = NULL;
							TileActor* _tmp27_ = NULL;
							if (!_tmp9_) {
								gint _tmp10_ = 0;
								_tmp10_ = y;
								y = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = y;
							_tmp12_ = game_view_get_game (self);
							_tmp13_ = _tmp12_;
							_tmp14_ = game_get_rows (_tmp13_);
							_tmp15_ = _tmp14_;
							if (!(_tmp11_ < _tmp15_)) {
								break;
							}
							_tmp16_ = self->priv->tiles;
							_tmp16__length1 = self->priv->tiles_length1;
							_tmp16__length2 = self->priv->tiles_length2;
							_tmp17_ = x;
							_tmp18_ = y;
							_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
							_tmp20_ = _g_object_ref0 (_tmp19_);
							tile = _tmp20_;
							_tmp21_ = tile;
							if (_tmp21_ == NULL) {
								_g_object_unref0 (tile);
								continue;
							}
							_tmp22_ = self->priv->tiles;
							_tmp22__length1 = self->priv->tiles_length1;
							_tmp22__length2 = self->priv->tiles_length2;
							_tmp23_ = x;
							_tmp24_ = y;
							_g_object_unref0 (_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_]);
							_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_] = NULL;
							_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
							_tmp26_ = tile;
							g_signal_handlers_disconnect_matched (_tmp26_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
							_tmp27_ = tile;
							clutter_actor_destroy ((ClutterActor*) _tmp27_);
							_g_object_unref0 (tile);
						}
					}
				}
			}
		}
	}
	_tmp28_ = self->priv->cursor;
	clutter_actor_destroy ((ClutterActor*) _tmp28_);
}


static void _game_view_move_cb_tile_move (Tile* _sender, gint old_x, gint old_y, gint new_x, gint new_y, gpointer self) {
	game_view_move_cb ((GameView*) self, old_x, old_y, new_x, new_y);
}


static void _game_view_close_cb_tile_close (Tile* _sender, gint grid_x, gint grid_y, gpointer self) {
	game_view_close_cb ((GameView*) self, grid_x, grid_y);
}


static void _game_view_remove_region_cb_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self) {
	game_view_remove_region_cb ((GameView*) self, _sender, actor);
}


static gboolean _game_view_tile_entered_cb_clutter_actor_enter_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self) {
	gboolean result;
	result = game_view_tile_entered_cb ((GameView*) self, _sender, event);
	return result;
}


static gboolean _game_view_tile_left_cb_clutter_actor_leave_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self) {
	gboolean result;
	result = game_view_tile_left_cb ((GameView*) self, _sender, event);
	return result;
}


static void game_view_place_tiles (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Theme* theme = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	Theme* _tmp6_ = NULL;
	Theme* _tmp7_ = NULL;
	Theme* _tmp71_ = NULL;
	ClutterImage* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	CursorActor* _tmp74_ = NULL;
	ClutterActor* _tmp75_ = NULL;
	CursorActor* _tmp76_ = NULL;
	CursorActor* _tmp77_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->themes;
	_tmp3_ = game_view_get_theme_name (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_hash_table_lookup (_tmp2_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((Theme*) _tmp5_);
	theme = _tmp6_;
	_tmp7_ = theme;
	if (_tmp7_ == NULL) {
		GHashTable* _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		Theme* _tmp10_ = NULL;
		_tmp8_ = self->priv->themes;
		_tmp9_ = g_hash_table_lookup (_tmp8_, "shapesandcolors");
		_tmp10_ = _g_object_ref0 ((Theme*) _tmp9_);
		_g_object_unref0 (theme);
		theme = _tmp10_;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				Game* _tmp14_ = NULL;
				Game* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = x;
					x = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = x;
				_tmp14_ = game_view_get_game (self);
				_tmp15_ = _tmp14_;
				_tmp16_ = game_get_columns (_tmp15_);
				_tmp17_ = _tmp16_;
				if (!(_tmp13_ < _tmp17_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp18_ = FALSE;
						_tmp18_ = TRUE;
						while (TRUE) {
							gint _tmp20_ = 0;
							Game* _tmp21_ = NULL;
							Game* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							Tile* l = NULL;
							Game* _tmp25_ = NULL;
							Game* _tmp26_ = NULL;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							Tile* _tmp29_ = NULL;
							gboolean _tmp30_ = FALSE;
							Tile* _tmp31_ = NULL;
							TileActor* tile = NULL;
							Tile* _tmp35_ = NULL;
							Theme* _tmp36_ = NULL;
							ClutterImage** _tmp37_ = NULL;
							gint _tmp37__length1 = 0;
							Tile* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							ClutterImage* _tmp40_ = NULL;
							gint _tmp41_ = 0;
							TileActor* _tmp42_ = NULL;
							Tile* _tmp43_ = NULL;
							Tile* _tmp44_ = NULL;
							gfloat xx = 0.0F;
							gfloat yy = 0.0F;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							Game* _tmp47_ = NULL;
							Game* _tmp48_ = NULL;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							TileActor* _tmp53_ = NULL;
							gfloat _tmp54_ = 0.0F;
							gfloat _tmp55_ = 0.0F;
							TileActor* _tmp56_ = NULL;
							ClutterTapAction* tap = NULL;
							ClutterTapAction* _tmp57_ = NULL;
							TileActor* _tmp58_ = NULL;
							ClutterTapAction* _tmp59_ = NULL;
							ClutterTapAction* _tmp60_ = NULL;
							TileActor* _tmp61_ = NULL;
							TileActor* _tmp62_ = NULL;
							TileActor** _tmp63_ = NULL;
							gint _tmp63__length1 = 0;
							gint _tmp63__length2 = 0;
							gint _tmp64_ = 0;
							gint _tmp65_ = 0;
							TileActor* _tmp66_ = NULL;
							TileActor* _tmp67_ = NULL;
							TileActor* _tmp68_ = NULL;
							ClutterActor* _tmp69_ = NULL;
							TileActor* _tmp70_ = NULL;
							if (!_tmp18_) {
								gint _tmp19_ = 0;
								_tmp19_ = y;
								y = _tmp19_ + 1;
							}
							_tmp18_ = FALSE;
							_tmp20_ = y;
							_tmp21_ = game_view_get_game (self);
							_tmp22_ = _tmp21_;
							_tmp23_ = game_get_rows (_tmp22_);
							_tmp24_ = _tmp23_;
							if (!(_tmp20_ < _tmp24_)) {
								break;
							}
							_tmp25_ = game_view_get_game (self);
							_tmp26_ = _tmp25_;
							_tmp27_ = x;
							_tmp28_ = y;
							_tmp29_ = game_get_tile (_tmp26_, _tmp27_, _tmp28_);
							l = _tmp29_;
							_tmp31_ = l;
							if (_tmp31_ == NULL) {
								_tmp30_ = TRUE;
							} else {
								Tile* _tmp32_ = NULL;
								gboolean _tmp33_ = FALSE;
								gboolean _tmp34_ = FALSE;
								_tmp32_ = l;
								_tmp33_ = tile_get_closed (_tmp32_);
								_tmp34_ = _tmp33_;
								_tmp30_ = _tmp34_;
							}
							if (_tmp30_) {
								_g_object_unref0 (l);
								continue;
							}
							_tmp35_ = l;
							_tmp36_ = theme;
							_tmp37_ = _tmp36_->textures;
							_tmp37__length1 = _tmp36_->textures_length1;
							_tmp38_ = l;
							_tmp39_ = _tmp38_->color;
							_tmp40_ = _tmp37_[_tmp39_];
							_tmp41_ = self->priv->tile_size;
							_tmp42_ = tile_actor_new (_tmp35_, _tmp40_, _tmp41_);
							g_object_ref_sink (_tmp42_);
							tile = _tmp42_;
							_tmp43_ = l;
							g_signal_connect_object (_tmp43_, "move", (GCallback) _game_view_move_cb_tile_move, self, 0);
							_tmp44_ = l;
							g_signal_connect_object (_tmp44_, "close", (GCallback) _game_view_close_cb_tile_close, self, 0);
							_tmp45_ = x;
							_tmp46_ = self->priv->tile_size;
							xx = (gfloat) (_tmp45_ * _tmp46_);
							_tmp47_ = game_view_get_game (self);
							_tmp48_ = _tmp47_;
							_tmp49_ = game_get_rows (_tmp48_);
							_tmp50_ = _tmp49_;
							_tmp51_ = y;
							_tmp52_ = self->priv->tile_size;
							yy = (gfloat) (((_tmp50_ - _tmp51_) - 1) * _tmp52_);
							_tmp53_ = tile;
							_tmp54_ = xx;
							_tmp55_ = yy;
							clutter_actor_set_position ((ClutterActor*) _tmp53_, _tmp54_, _tmp55_);
							_tmp56_ = tile;
							clutter_actor_set_reactive ((ClutterActor*) _tmp56_, TRUE);
							_tmp57_ = (ClutterTapAction*) clutter_tap_action_new ();
							g_object_ref_sink (_tmp57_);
							tap = _tmp57_;
							_tmp58_ = tile;
							_tmp59_ = tap;
							clutter_actor_add_action ((ClutterActor*) _tmp58_, (ClutterAction*) _tmp59_);
							_tmp60_ = tap;
							g_signal_connect_object (_tmp60_, "tap", (GCallback) _game_view_remove_region_cb_clutter_tap_action_tap, self, 0);
							_tmp61_ = tile;
							g_signal_connect_object ((ClutterActor*) _tmp61_, "enter-event", (GCallback) _game_view_tile_entered_cb_clutter_actor_enter_event, self, 0);
							_tmp62_ = tile;
							g_signal_connect_object ((ClutterActor*) _tmp62_, "leave-event", (GCallback) _game_view_tile_left_cb_clutter_actor_leave_event, self, 0);
							_tmp63_ = self->priv->tiles;
							_tmp63__length1 = self->priv->tiles_length1;
							_tmp63__length2 = self->priv->tiles_length2;
							_tmp64_ = x;
							_tmp65_ = y;
							_tmp66_ = tile;
							_tmp67_ = _g_object_ref0 (_tmp66_);
							_g_object_unref0 (_tmp63_[(_tmp64_ * _tmp63__length2) + _tmp65_]);
							_tmp63_[(_tmp64_ * _tmp63__length2) + _tmp65_] = _tmp67_;
							_tmp68_ = _tmp63_[(_tmp64_ * _tmp63__length2) + _tmp65_];
							_tmp69_ = self->priv->game_actors;
							_tmp70_ = tile;
							clutter_actor_add_child (_tmp69_, (ClutterActor*) _tmp70_);
							_g_object_unref0 (tap);
							_g_object_unref0 (tile);
							_g_object_unref0 (l);
						}
					}
				}
			}
		}
	}
	_tmp71_ = theme;
	_tmp72_ = _tmp71_->cursor;
	_tmp73_ = self->priv->tile_size;
	_tmp74_ = cursor_actor_new ((ClutterContent*) _tmp72_, _tmp73_);
	g_object_ref_sink (_tmp74_);
	_g_object_unref0 (self->priv->cursor);
	self->priv->cursor = _tmp74_;
	_tmp75_ = self->priv->game_actors;
	_tmp76_ = self->priv->cursor;
	clutter_actor_add_child (_tmp75_, (ClutterActor*) _tmp76_);
	_tmp77_ = self->priv->cursor;
	clutter_actor_hide ((ClutterActor*) _tmp77_);
	_g_object_unref0 (theme);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	Theme* theme = NULL;
	Theme* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Theme* _tmp6_ = NULL;
	Theme* _tmp7_ = NULL;
	Theme* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	Theme* _tmp11_ = NULL;
	Theme* _tmp12_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->themes);
	self->priv->themes = _tmp2_;
	_tmp3_ = theme_new ("colors");
	theme = _tmp3_;
	_tmp4_ = self->priv->themes;
	_tmp5_ = g_strdup ("colors");
	_tmp6_ = theme;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
	_tmp8_ = theme_new ("shapesandcolors");
	_g_object_unref0 (theme);
	theme = _tmp8_;
	_tmp9_ = self->priv->themes;
	_tmp10_ = g_strdup ("shapesandcolors");
	_tmp11_ = theme;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
	_g_object_unref0 (theme);
	return self;
}


GameView* game_view_new (void) {
	return game_view_construct (TYPE_GAME_VIEW);
}


void game_view_close_cb (GameView* self, gint grid_x, gint grid_y) {
	TileActor** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TileActor* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = grid_x;
	_tmp2_ = grid_y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	tile_actor_animate_out (_tmp3_);
}


void game_view_move_cb (GameView* self, gint old_x, gint old_y, gint new_x, gint new_y) {
	TileActor* tile = NULL;
	TileActor** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TileActor* _tmp3_ = NULL;
	TileActor* _tmp4_ = NULL;
	TileActor** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	TileActor* _tmp8_ = NULL;
	TileActor* _tmp9_ = NULL;
	gint new_xx = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint new_yy = 0;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = old_x;
	_tmp2_ = old_y;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tile = _tmp4_;
	_tmp5_ = self->priv->tiles;
	_tmp5__length1 = self->priv->tiles_length1;
	_tmp5__length2 = self->priv->tiles_length2;
	_tmp6_ = new_x;
	_tmp7_ = new_y;
	_tmp8_ = _g_object_ref0 (tile);
	_g_object_unref0 (_tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_]);
	_tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_] = _tmp8_;
	_tmp9_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
	_tmp10_ = new_x;
	_tmp11_ = self->priv->tile_size;
	new_xx = _tmp10_ * _tmp11_;
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = game_get_rows (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = new_y;
	_tmp17_ = self->priv->tile_size;
	new_yy = ((_tmp15_ - _tmp16_) - 1) * _tmp17_;
	_tmp18_ = self->is_zealous;
	tile_actor_animate_to (tile, (gdouble) new_xx, (gdouble) new_yy, _tmp18_);
	_g_object_unref0 (tile);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void game_view_opacity_for_connected_tiles (GameView* self, TileActor* actor, gint opacity) {
	TileActor* _tmp0_ = NULL;
	GList* connected_tiles = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
	Tile* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = actor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = actor;
	_tmp4_ = _tmp3_->tile;
	_tmp5_ = game_connected_tiles (_tmp2_, _tmp4_);
	connected_tiles = _tmp5_;
	_tmp6_ = connected_tiles;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp6_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			Tile* _tmp7_ = NULL;
			Tile* l = NULL;
			_tmp7_ = _g_object_ref0 ((Tile*) l_it->data);
			l = _tmp7_;
			{
				TileActor** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp8__length2 = 0;
				Tile* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				Tile* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				TileActor* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				_tmp8_ = self->priv->tiles;
				_tmp8__length1 = self->priv->tiles_length1;
				_tmp8__length2 = self->priv->tiles_length2;
				_tmp9_ = l;
				_tmp10_ = _tmp9_->grid_x;
				_tmp11_ = l;
				_tmp12_ = _tmp11_->grid_y;
				_tmp13_ = _tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_];
				_tmp14_ = opacity;
				clutter_actor_set_opacity ((ClutterActor*) _tmp13_, (guint) _tmp14_);
				_g_object_unref0 (l);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (connected_tiles);
}


static gboolean game_view_tile_entered_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TileActor* tile = NULL;
	ClutterActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
	TileActor* _tmp4_ = NULL;
	TileActor* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->cursor_active;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = actor;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp2_;
	_tmp3_ = tile;
	game_view_opacity_for_connected_tiles (self, _tmp3_, 255);
	_tmp4_ = tile;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->highlighted);
	self->priv->highlighted = _tmp5_;
	result = FALSE;
	_g_object_unref0 (tile);
	return result;
}


static gboolean game_view_tile_left_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TileActor* tile = NULL;
	ClutterActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->cursor_active;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = actor;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp2_;
	_tmp3_ = tile;
	game_view_opacity_for_connected_tiles (self, _tmp3_, 180);
	result = FALSE;
	_g_object_unref0 (tile);
	return result;
}


static void game_view_remove_region_cb (GameView* self, ClutterTapAction* tap, ClutterActor* actor) {
	TileActor* tile = NULL;
	ClutterActor* _tmp0_ = NULL;
	TileActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	TileActor* _tmp5_ = NULL;
	Tile* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	TileActor* _tmp8_ = NULL;
	Tile* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	Game* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	TileActor* _tmp13_ = NULL;
	Tile* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tap != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = actor;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_TILE_ACTOR, TileActor));
	tile = _tmp1_;
	_tmp2_ = self->priv->highlighted;
	game_view_opacity_for_connected_tiles (self, _tmp2_, 180);
	_tmp3_ = self->priv->cursor_active;
	if (_tmp3_) {
		CursorActor* _tmp4_ = NULL;
		self->priv->cursor_active = FALSE;
		_tmp4_ = self->priv->cursor;
		clutter_actor_hide ((ClutterActor*) _tmp4_);
	}
	_tmp5_ = tile;
	_tmp6_ = _tmp5_->tile;
	_tmp7_ = _tmp6_->grid_x;
	game_view_set_cursor_x (self, _tmp7_);
	_tmp8_ = tile;
	_tmp9_ = _tmp8_->tile;
	_tmp10_ = _tmp9_->grid_y;
	game_view_set_cursor_y (self, _tmp10_);
	_tmp11_ = game_view_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = tile;
	_tmp14_ = _tmp13_->tile;
	game_remove_connected_tiles (_tmp12_, _tmp14_);
	_g_object_unref0 (tile);
}


gboolean game_view_board_left_cb (GameView* self) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	TileActor** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	game_reset_visit (_tmp1_);
	_tmp2_ = self->priv->tiles;
	_tmp2__length1 = self->priv->tiles_length1;
	_tmp2__length2 = self->priv->tiles_length2;
	{
		TileActor** tile_collection = NULL;
		gint tile_collection_length1 = 0;
		gint tile_collection_length2 = 0;
		gint tile_it = 0;
		tile_collection = _tmp2_;
		tile_collection_length1 = _tmp2__length1 * _tmp2__length2;
		for (tile_it = 0; tile_it < (_tmp2__length1 * _tmp2__length2); tile_it = tile_it + 1) {
			TileActor* _tmp3_ = NULL;
			TileActor* tile = NULL;
			_tmp3_ = _g_object_ref0 (tile_collection[tile_it]);
			tile = _tmp3_;
			{
				TileActor* _tmp4_ = NULL;
				_tmp4_ = tile;
				clutter_actor_set_opacity ((ClutterActor*) _tmp4_, (guint) 180);
				_g_object_unref0 (tile);
			}
		}
	}
	result = FALSE;
	return result;
}


void game_view_cursor_move (GameView* self, gint x, gint y) {
	TileActor* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	TileActor** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp7__length2 = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	TileActor* _tmp12_ = NULL;
	TileActor* _tmp13_ = NULL;
	TileActor* _tmp14_ = NULL;
	gfloat xx = 0.0F;
	gfloat yy = 0.0F;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Game* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	CursorActor* _tmp25_ = NULL;
	CursorActor* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->cursor_active = TRUE;
	_tmp0_ = self->priv->highlighted;
	game_view_opacity_for_connected_tiles (self, _tmp0_, 180);
	_tmp1_ = game_view_get_cursor_x (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	game_view_set_cursor_x (self, _tmp2_ + _tmp3_);
	_tmp4_ = game_view_get_cursor_y (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = y;
	game_view_set_cursor_y (self, _tmp5_ + _tmp6_);
	_tmp7_ = self->priv->tiles;
	_tmp7__length1 = self->priv->tiles_length1;
	_tmp7__length2 = self->priv->tiles_length2;
	_tmp8_ = game_view_get_cursor_x (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = game_view_get_cursor_y (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp7_[(_tmp9_ * _tmp7__length2) + _tmp11_];
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->highlighted);
	self->priv->highlighted = _tmp13_;
	_tmp14_ = self->priv->highlighted;
	game_view_opacity_for_connected_tiles (self, _tmp14_, 255);
	_tmp15_ = game_view_get_cursor_x (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->tile_size;
	xx = (gfloat) (_tmp16_ * _tmp17_);
	_tmp18_ = game_view_get_game (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = game_get_rows (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = game_view_get_cursor_y (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->tile_size;
	yy = (gfloat) (((_tmp21_ - 1) - _tmp23_) * _tmp24_);
	_tmp25_ = self->priv->cursor;
	clutter_actor_set_position ((ClutterActor*) _tmp25_, xx, yy);
	_tmp26_ = self->priv->cursor;
	clutter_actor_show ((ClutterActor*) _tmp26_);
}


void game_view_cursor_click (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	TileActor** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	TileActor* _tmp7_ = NULL;
	Tile* _tmp8_ = NULL;
	TileActor** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	TileActor* _tmp14_ = NULL;
	TileActor* _tmp15_ = NULL;
	TileActor* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->tiles;
	_tmp2__length1 = self->priv->tiles_length1;
	_tmp2__length2 = self->priv->tiles_length2;
	_tmp3_ = game_view_get_cursor_x (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = game_view_get_cursor_y (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp2_[(_tmp4_ * _tmp2__length2) + _tmp6_];
	_tmp8_ = _tmp7_->tile;
	game_remove_connected_tiles (_tmp1_, _tmp8_);
	_tmp9_ = self->priv->tiles;
	_tmp9__length1 = self->priv->tiles_length1;
	_tmp9__length2 = self->priv->tiles_length2;
	_tmp10_ = game_view_get_cursor_x (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = game_view_get_cursor_y (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp9_[(_tmp11_ * _tmp9__length2) + _tmp13_];
	_tmp15_ = _g_object_ref0 (_tmp14_);
	_g_object_unref0 (self->priv->highlighted);
	self->priv->highlighted = _tmp15_;
	_tmp16_ = self->priv->highlighted;
	game_view_opacity_for_connected_tiles (self, _tmp16_, 255);
}


void game_view_update_score_cb (GameView* self, gint points_awarded) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_zealous;
	if (_tmp0_) {
		ScoreActor* text = NULL;
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gfloat _tmp5_ = 0.0F;
		gfloat _tmp6_ = 0.0F;
		gfloat _tmp7_ = 0.0F;
		gfloat _tmp8_ = 0.0F;
		ScoreActor* _tmp9_ = NULL;
		ClutterActor* _tmp10_ = NULL;
		ScoreActor* _tmp11_ = NULL;
		ScoreActor* _tmp12_ = NULL;
		ClutterAlignConstraint* _tmp13_ = NULL;
		ClutterAlignConstraint* _tmp14_ = NULL;
		ScoreActor* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp1_ = game_view_get_game (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = game_get_rows (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = score_actor_new (_tmp4_ / 5, (gdouble) _tmp6_, (gdouble) _tmp8_);
		g_object_ref_sink (_tmp9_);
		text = _tmp9_;
		_tmp10_ = self->priv->game_actors;
		_tmp11_ = text;
		clutter_actor_add_child (_tmp10_, (ClutterActor*) _tmp11_);
		_tmp12_ = text;
		_tmp13_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
		g_object_ref_sink (_tmp13_);
		_tmp14_ = _tmp13_;
		clutter_actor_add_constraint ((ClutterActor*) _tmp12_, (ClutterConstraint*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_tmp15_ = text;
		_tmp16_ = points_awarded;
		score_actor_animate_score (_tmp15_, _tmp16_);
		_g_object_unref0 (text);
	}
}


void game_view_game_complete_cb (GameView* self) {
	ScoreActor* text = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	ScoreActor* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterAlignConstraint* _tmp10_ = NULL;
	ClutterAlignConstraint* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = game_get_rows (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = score_actor_new (_tmp3_ / 5, (gdouble) _tmp5_, (gdouble) _tmp7_);
	g_object_ref_sink (_tmp8_);
	text = _tmp8_;
	_tmp9_ = self->priv->game_actors;
	clutter_actor_add_child (_tmp9_, (ClutterActor*) text);
	_tmp10_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	clutter_actor_add_constraint ((ClutterActor*) text, (ClutterConstraint*) _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = game_get_score (_tmp13_);
	_tmp15_ = _tmp14_;
	score_actor_animate_final_score (text, (guint) _tmp15_);
	_g_object_unref0 (text);
}


gint game_view_get_cursor_x (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cursor_x;
	result = _tmp0_;
	return result;
}


void game_view_set_cursor_x (GameView* self, gint value) {
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_columns (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = CLAMP (_tmp0_, 0, _tmp4_ - 1);
	self->priv->_cursor_x = _tmp5_;
	g_object_notify ((GObject *) self, "cursor-x");
}


gint game_view_get_cursor_y (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_cursor_y;
	result = _tmp0_;
	return result;
}


void game_view_set_cursor_y (GameView* self, gint value) {
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_rows (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = CLAMP (_tmp0_, 0, _tmp4_ - 1);
	self->priv->_cursor_y = _tmp5_;
	g_object_notify ((GObject *) self, "cursor-y");
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}


static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	game_view_game_complete_cb ((GameView*) self);
}


static void _game_view_update_score_cb_game_update_score (Game* _sender, gint points_awarded, gpointer self) {
	game_view_update_score_cb ((GameView*) self, points_awarded);
}


void game_view_set_game (GameView* self, Game* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	Game* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	Game* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Game* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	TileActor** _tmp22_ = NULL;
	gint _tmp23_ = 0;
	Game* _tmp24_ = NULL;
	Game* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	Game* _tmp29_ = NULL;
	Game* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_actors;
	if (_tmp0_ != NULL) {
		ClutterActor* _tmp1_ = NULL;
		_tmp1_ = self->priv->game_actors;
		clutter_actor_destroy (_tmp1_);
	}
	_tmp2_ = clutter_actor_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->game_actors);
	self->priv->game_actors = _tmp2_;
	_tmp3_ = self->priv->game_actors;
	clutter_actor_add_child ((ClutterActor*) self, _tmp3_);
	game_view_remove_tiles (self);
	_tmp4_ = game_view_get_game (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		Game* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		_tmp6_ = game_view_get_game (self);
		_tmp7_ = _tmp6_;
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp8_ = value;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp9_;
	_tmp10_ = game_view_get_game (self);
	_tmp11_ = _tmp10_;
	g_signal_connect_object (_tmp11_, "complete", (GCallback) _game_view_game_complete_cb_game_complete, self, 0);
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "update-score", (GCallback) _game_view_update_score_cb_game_update_score, self, 0);
	_tmp14_ = game_view_get_game (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = game_get_columns (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = game_view_get_game (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = game_get_rows (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_new0 (TileActor*, (_tmp17_ * _tmp21_) + 1);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->tiles = _tmp22_;
	self->priv->tiles_length1 = _tmp17_;
	self->priv->tiles_length2 = _tmp21_;
	game_view_place_tiles (self);
	_tmp23_ = self->priv->tile_size;
	_tmp24_ = game_view_get_game (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = game_get_columns (_tmp25_);
	_tmp27_ = _tmp26_;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) (_tmp23_ * _tmp27_));
	_tmp28_ = self->priv->tile_size;
	_tmp29_ = game_view_get_game (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = game_get_rows (_tmp30_);
	_tmp32_ = _tmp31_;
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) (_tmp28_ * _tmp32_));
	g_object_notify ((GObject *) self, "game");
}


const gchar* game_view_get_theme_name (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme_name;
	result = _tmp0_;
	return result;
}


void game_view_set_theme_name (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_theme_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = value;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		return;
	}
	_tmp3_ = value;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_theme_name);
	self->priv->_theme_name = _tmp4_;
	game_view_remove_tiles (self);
	game_view_place_tiles (self);
	g_object_notify ((GObject *) self, "theme-name");
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_CURSOR_X, g_param_spec_int ("cursor-x", "cursor-x", "cursor-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_CURSOR_Y, g_param_spec_int ("cursor-y", "cursor-y", "cursor-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME_NAME, g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void game_view_instance_init (GameView * self) {
	gchar* _tmp0_ = NULL;
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->highlighted = NULL;
	self->priv->cursor_active = FALSE;
	self->priv->game_actors = NULL;
	self->priv->_game = NULL;
	_tmp0_ = g_strdup ("shapesandcolors");
	self->priv->_theme_name = _tmp0_;
	self->priv->tile_size = 50;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->highlighted);
	_g_object_unref0 (self->priv->cursor);
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->game_actors);
	_g_object_unref0 (self->priv->_game);
	_g_hash_table_unref0 (self->priv->themes);
	_g_free0 (self->priv->_theme_name);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


/**
 *  This class defines the view of a game. All clutter related stuff goes here. It follows the
 *  principle of MVC framework. This class deals with the presentation (view) layer. It communicates
 *  with the model class by composite relation and with the control layer by means of signals and
 *  events.
 */
GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_CURSOR_X:
		g_value_set_int (value, game_view_get_cursor_x (self));
		break;
		case GAME_VIEW_CURSOR_Y:
		g_value_set_int (value, game_view_get_cursor_y (self));
		break;
		case GAME_VIEW_GAME:
		g_value_set_object (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME_NAME:
		g_value_set_string (value, game_view_get_theme_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_CURSOR_X:
		game_view_set_cursor_x (self, g_value_get_int (value));
		break;
		case GAME_VIEW_CURSOR_Y:
		game_view_set_cursor_y (self, g_value_get_int (value));
		break;
		case GAME_VIEW_GAME:
		game_view_set_game (self, g_value_get_object (value));
		break;
		case GAME_VIEW_THEME_NAME:
		game_view_set_theme_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


Theme* theme_construct (GType object_type, const gchar* name) {
	Theme * self = NULL;
	ClutterImage** _tmp0_ = NULL;
	gchar** colors = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint colors_length1 = 0;
	gint _colors_size_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (Theme*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (ClutterImage*, 4 + 1);
	self->textures = (_vala_array_free (self->textures, self->textures_length1, (GDestroyNotify) g_object_unref), NULL);
	self->textures = _tmp0_;
	self->textures_length1 = 4;
	_tmp1_ = g_strdup ("blue");
	_tmp2_ = g_strdup ("green");
	_tmp3_ = g_strdup ("yellow");
	_tmp4_ = g_strdup ("red");
	_tmp5_ = g_new0 (gchar*, 4 + 1);
	_tmp5_[0] = _tmp1_;
	_tmp5_[1] = _tmp2_;
	_tmp5_[2] = _tmp3_;
	_tmp5_[3] = _tmp4_;
	colors = _tmp5_;
	colors_length1 = 4;
	_colors_size_ = colors_length1;
	{
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		GdkPixbuf* _tmp37_ = NULL;
		GdkPixbuf* _tmp38_ = NULL;
		ClutterImage* _tmp39_ = NULL;
		ClutterImage* _tmp40_ = NULL;
		GdkPixbuf* _tmp41_ = NULL;
		guint8* _tmp42_ = NULL;
		GdkPixbuf* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		GdkPixbuf* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		GdkPixbuf* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gint _tmp8_ = 0;
					GdkPixbuf* pixbuf = NULL;
					const gchar* _tmp9_ = NULL;
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp11_ = 0;
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					GdkPixbuf* _tmp17_ = NULL;
					GdkPixbuf* _tmp18_ = NULL;
					ClutterImage** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					gint _tmp20_ = 0;
					ClutterImage* _tmp21_ = NULL;
					ClutterImage* _tmp22_ = NULL;
					ClutterImage** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					gint _tmp24_ = 0;
					ClutterImage* _tmp25_ = NULL;
					GdkPixbuf* _tmp26_ = NULL;
					guint8* _tmp27_ = NULL;
					GdkPixbuf* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					GdkPixbuf* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					GdkPixbuf* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					if (!_tmp6_) {
						gint _tmp7_ = 0;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = i;
					if (!(_tmp8_ < 4)) {
						break;
					}
					_tmp9_ = name;
					_tmp10_ = colors;
					_tmp10__length1 = colors_length1;
					_tmp11_ = i;
					_tmp12_ = _tmp10_[_tmp11_];
					_tmp13_ = g_strconcat (_tmp12_, ".svg", NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_build_filename (DATADIR, "themes", _tmp9_, _tmp14_, NULL);
					_tmp16_ = _tmp15_;
					_tmp17_ = gdk_pixbuf_new_from_file (_tmp16_, &_inner_error_);
					_tmp18_ = _tmp17_;
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
					pixbuf = _tmp18_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch0_clutter_texture_error;
						}
						goto __catch0_g_error;
					}
					_tmp19_ = self->textures;
					_tmp19__length1 = self->textures_length1;
					_tmp20_ = i;
					_tmp21_ = clutter_image_new ();
					_g_object_unref0 (_tmp19_[_tmp20_]);
					_tmp19_[_tmp20_] = _tmp21_;
					_tmp22_ = _tmp19_[_tmp20_];
					_tmp23_ = self->textures;
					_tmp23__length1 = self->textures_length1;
					_tmp24_ = i;
					_tmp25_ = _tmp23_[_tmp24_];
					_tmp26_ = pixbuf;
					_tmp27_ = gdk_pixbuf_get_pixels (_tmp26_);
					_tmp28_ = pixbuf;
					_tmp29_ = gdk_pixbuf_get_width (_tmp28_);
					_tmp30_ = pixbuf;
					_tmp31_ = gdk_pixbuf_get_height (_tmp30_);
					_tmp32_ = pixbuf;
					_tmp33_ = gdk_pixbuf_get_rowstride (_tmp32_);
					clutter_image_set_data (_tmp25_, _tmp27_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) _tmp29_, (guint) _tmp31_, (guint) _tmp33_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_object_unref0 (pixbuf);
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
							goto __catch0_clutter_texture_error;
						}
						goto __catch0_g_error;
					}
					_g_object_unref0 (pixbuf);
				}
			}
		}
		_tmp34_ = name;
		_tmp35_ = g_build_filename (DATADIR, "themes", _tmp34_, "highlight.svg", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = gdk_pixbuf_new_from_file (_tmp36_, &_inner_error_);
		_tmp38_ = _tmp37_;
		_g_free0 (_tmp36_);
		pixbuf = _tmp38_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch0_clutter_texture_error;
			}
			goto __catch0_g_error;
		}
		_tmp39_ = clutter_image_new ();
		_g_object_unref0 (self->cursor);
		self->cursor = _tmp39_;
		_tmp40_ = self->cursor;
		_tmp41_ = pixbuf;
		_tmp42_ = gdk_pixbuf_get_pixels (_tmp41_);
		_tmp43_ = pixbuf;
		_tmp44_ = gdk_pixbuf_get_width (_tmp43_);
		_tmp45_ = pixbuf;
		_tmp46_ = gdk_pixbuf_get_height (_tmp45_);
		_tmp47_ = pixbuf;
		_tmp48_ = gdk_pixbuf_get_rowstride (_tmp47_);
		clutter_image_set_data (_tmp40_, _tmp42_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) _tmp44_, (guint) _tmp46_, (guint) _tmp48_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (pixbuf);
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch0_clutter_texture_error;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (pixbuf);
	}
	goto __finally0;
	__catch0_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp49_ = e;
		_tmp50_ = _tmp49_->message;
		g_warning ("game-view.vala:341: Failed to load textures: %s", _tmp50_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp51_ = e;
		_tmp52_ = _tmp51_->message;
		g_warning ("game-view.vala:345: Failed to load textures: %s", _tmp52_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


Theme* theme_new (const gchar* name) {
	return theme_construct (TYPE_THEME, name);
}


static void theme_class_init (ThemeClass * klass) {
	theme_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = theme_finalize;
}


static void theme_instance_init (Theme * self) {
}


static void theme_finalize (GObject* obj) {
	Theme * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME, Theme);
	self->textures = (_vala_array_free (self->textures, self->textures_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->cursor);
	G_OBJECT_CLASS (theme_parent_class)->finalize (obj);
}


/**
 *  This class holds the textures for a specific theme. These textures are used for creating light
 *  actors and cursor actor.
 */
GType theme_get_type (void) {
	static volatile gsize theme_type_id__volatile = 0;
	if (g_once_init_enter (&theme_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Theme), 0, (GInstanceInitFunc) theme_instance_init, NULL };
		GType theme_type_id;
		theme_type_id = g_type_register_static (G_TYPE_OBJECT, "Theme", &g_define_type_info, 0);
		g_once_init_leave (&theme_type_id__volatile, theme_type_id);
	}
	return theme_type_id__volatile;
}


static void _vala_ClutterPoint_free (ClutterPoint* self) {
	g_boxed_free (clutter_point_get_type (), self);
}


TileActor* tile_actor_construct (GType object_type, Tile* tile, ClutterImage* texture, gint size) {
	TileActor * self = NULL;
	Tile* _tmp0_ = NULL;
	Tile* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	ClutterImage* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
	ClutterPoint* _tmp9_ = NULL;
	ClutterPoint* _tmp10_ = NULL;
	g_return_val_if_fail (tile != NULL, NULL);
	g_return_val_if_fail (texture != NULL, NULL);
	self = (TileActor*) g_object_new (object_type, NULL);
	_tmp0_ = tile;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->tile);
	self->tile = _tmp1_;
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 180);
	_tmp2_ = size;
	_tmp3_ = size;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp2_, (gfloat) _tmp3_);
	_tmp4_ = texture;
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) _tmp4_);
	clutter_actor_set_content_gravity ((ClutterActor*) self, CLUTTER_CONTENT_GRAVITY_CENTER);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7_->x = 0.5f;
	__vala_ClutterPoint_free0 (_tmp7_);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10_->y = 0.5f;
	__vala_ClutterPoint_free0 (_tmp10_);
	return self;
}


TileActor* tile_actor_new (Tile* tile, ClutterImage* texture, gint size) {
	return tile_actor_construct (TYPE_TILE_ACTOR, tile, texture, size);
}


static void _tile_actor_hide_tile_cb_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
	tile_actor_hide_tile_cb ((TileActor*) self);
}


void tile_actor_animate_out (TileActor* self) {
	g_return_if_fail (self != NULL);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_LINEAR);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 500);
	clutter_actor_set_scale ((ClutterActor*) self, 2.0, 2.0);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) _tile_actor_hide_tile_cb_clutter_actor_transitions_completed, self, 0);
}


static void tile_actor_hide_tile_cb (TileActor* self) {
	g_return_if_fail (self != NULL);
	clutter_actor_hide ((ClutterActor*) self);
}


void tile_actor_animate_to (TileActor* self, gdouble new_x, gdouble new_y, gboolean is_zealous) {
	ClutterAnimationMode _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ClutterAnimationMode anim_mode = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp1_ = is_zealous;
	if (_tmp1_) {
		_tmp0_ = CLUTTER_EASE_OUT_BOUNCE;
	} else {
		_tmp0_ = CLUTTER_EASE_OUT_QUAD;
	}
	anim_mode = _tmp0_;
	clutter_actor_set_easing_mode ((ClutterActor*) self, anim_mode);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 500);
	_tmp2_ = new_x;
	_tmp3_ = new_y;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp2_, (gfloat) _tmp3_);
}


static void tile_actor_class_init (TileActorClass * klass) {
	tile_actor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tile_actor_finalize;
}


static void tile_actor_instance_init (TileActor * self) {
}


static void tile_actor_finalize (GObject* obj) {
	TileActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE_ACTOR, TileActor);
	_g_object_unref0 (self->tile);
	G_OBJECT_CLASS (tile_actor_parent_class)->finalize (obj);
}


/**
 *  This class defines the view of a tile. All clutter related stuff goes here
 */
GType tile_actor_get_type (void) {
	static volatile gsize tile_actor_type_id__volatile = 0;
	if (g_once_init_enter (&tile_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileActor), 0, (GInstanceInitFunc) tile_actor_instance_init, NULL };
		GType tile_actor_type_id;
		tile_actor_type_id = g_type_register_static (clutter_actor_get_type (), "TileActor", &g_define_type_info, 0);
		g_once_init_leave (&tile_actor_type_id__volatile, tile_actor_type_id);
	}
	return tile_actor_type_id__volatile;
}


CursorActor* cursor_actor_construct (GType object_type, ClutterContent* texture, gint size) {
	CursorActor * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	ClutterContent* _tmp2_ = NULL;
	ClutterPoint* _tmp3_ = NULL;
	ClutterPoint* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
	g_return_val_if_fail (texture != NULL, NULL);
	self = (CursorActor*) g_object_new (object_type, NULL);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 180);
	_tmp0_ = size;
	_tmp1_ = size;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp0_, (gfloat) _tmp1_);
	_tmp2_ = texture;
	clutter_actor_set_content ((ClutterActor*) self, _tmp2_);
	clutter_actor_set_content_gravity ((ClutterActor*) self, CLUTTER_CONTENT_GRAVITY_CENTER);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp5_->x = 0.5f;
	__vala_ClutterPoint_free0 (_tmp5_);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8_->y = 0.5f;
	__vala_ClutterPoint_free0 (_tmp8_);
	return self;
}


CursorActor* cursor_actor_new (ClutterContent* texture, gint size) {
	return cursor_actor_construct (TYPE_CURSOR_ACTOR, texture, size);
}


static void cursor_actor_class_init (CursorActorClass * klass) {
	cursor_actor_parent_class = g_type_class_peek_parent (klass);
}


static void cursor_actor_instance_init (CursorActor * self) {
}


GType cursor_actor_get_type (void) {
	static volatile gsize cursor_actor_type_id__volatile = 0;
	if (g_once_init_enter (&cursor_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CursorActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cursor_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CursorActor), 0, (GInstanceInitFunc) cursor_actor_instance_init, NULL };
		GType cursor_actor_type_id;
		cursor_actor_type_id = g_type_register_static (clutter_actor_get_type (), "CursorActor", &g_define_type_info, 0);
		g_once_init_leave (&cursor_actor_type_id__volatile, cursor_actor_type_id);
	}
	return cursor_actor_type_id__volatile;
}


ScoreActor* score_actor_construct (GType object_type, gint game_size, gdouble width, gdouble height) {
	ScoreActor * self = NULL;
	ClutterText* _tmp0_ = NULL;
	ClutterText* _tmp1_ = NULL;
	ClutterColor _tmp2_ = {0};
	ClutterText* _tmp3_ = NULL;
	ClutterPoint* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
	ClutterPoint* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gint _tmp12_ = 0;
	self = (ScoreActor*) g_object_new (object_type, NULL);
	_tmp0_ = (ClutterText*) clutter_text_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp0_;
	_tmp1_ = self->priv->label;
	clutter_color_from_string (&_tmp2_, "rgba(255, 255, 255, 255)");
	clutter_text_set_color (_tmp1_, &_tmp2_);
	_tmp3_ = self->priv->label;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp3_);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6_->x = 0.5f;
	__vala_ClutterPoint_free0 (_tmp6_);
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9_->y = 0.5f;
	__vala_ClutterPoint_free0 (_tmp9_);
	_tmp10_ = width;
	self->priv->scene_width = (gfloat) _tmp10_;
	_tmp11_ = height;
	self->priv->scene_height = (gfloat) _tmp11_;
	_tmp12_ = game_size;
	self->priv->game_size = _tmp12_;
	return self;
}


ScoreActor* score_actor_new (gint game_size, gdouble width, gdouble height) {
	return score_actor_construct (TYPE_SCORE_ACTOR, game_size, width, height);
}


static void __lambda4_ (ScoreActor* self) {
	clutter_actor_destroy ((ClutterActor*) self);
}


static void ___lambda4__clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
	__lambda4_ ((ScoreActor*) self);
}


void score_actor_animate_score (ScoreActor* self, gint points) {
	gint _tmp0_ = 0;
	ClutterText* _tmp1_ = NULL;
	ClutterText* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = points;
	if (_tmp0_ <= 0) {
		return;
	}
	_tmp1_ = self->priv->label;
	clutter_text_set_font_name (_tmp1_, "Bitstrem Vera Sans Bold 30");
	_tmp2_ = self->priv->label;
	_tmp3_ = points;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("+", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	clutter_text_set_text (_tmp2_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	clutter_actor_set_z_position ((ClutterActor*) self, 0.f);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_SINE);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 600);
	clutter_actor_set_z_position ((ClutterActor*) self, 500.f);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) ___lambda4__clutter_actor_transitions_completed, self, 0);
}


void score_actor_animate_final_score (ScoreActor* self, guint points) {
	ClutterText* _tmp0_ = NULL;
	gchar* points_label = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	ClutterText* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	ClutterText* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label;
	clutter_text_set_font_name (_tmp0_, "Bitstrem Vera Sans 40");
	_tmp1_ = points;
	_tmp2_ = ngettext ("%u point", "%u points", (gulong) _tmp1_);
	_tmp3_ = points;
	_tmp4_ = g_strdup_printf (_tmp2_, _tmp3_);
	points_label = _tmp4_;
	_tmp5_ = self->priv->label;
	_tmp6_ = _ ("Game Over!");
	_tmp7_ = g_strdup_printf ("<b>%s</b>\n%s", _tmp6_, points_label);
	_tmp8_ = _tmp7_;
	clutter_text_set_markup (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = self->priv->label;
	clutter_text_set_line_alignment (_tmp9_, PANGO_ALIGN_CENTER);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	_tmp10_ = self->priv->game_size;
	clutter_actor_set_z_position ((ClutterActor*) self, (-300.f) + (_tmp10_ * 100));
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_ELASTIC);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 2000);
	_tmp11_ = self->priv->game_size;
	clutter_actor_set_z_position ((ClutterActor*) self, (gfloat) ((-200) + (_tmp11_ * 150)));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 255);
	_g_free0 (points_label);
}


static void score_actor_class_init (ScoreActorClass * klass) {
	score_actor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ScoreActorPrivate));
	G_OBJECT_CLASS (klass)->finalize = score_actor_finalize;
}


static void score_actor_instance_init (ScoreActor * self) {
	self->priv = SCORE_ACTOR_GET_PRIVATE (self);
}


static void score_actor_finalize (GObject* obj) {
	ScoreActor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_ACTOR, ScoreActor);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (score_actor_parent_class)->finalize (obj);
}


/**
 *  This class defines the view of a score. All clutter related stuff goes here
 */
GType score_actor_get_type (void) {
	static volatile gsize score_actor_type_id__volatile = 0;
	if (g_once_init_enter (&score_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreActor), 0, (GInstanceInitFunc) score_actor_instance_init, NULL };
		GType score_actor_type_id;
		score_actor_type_id = g_type_register_static (clutter_group_get_type (), "ScoreActor", &g_define_type_info, 0);
		g_once_init_leave (&score_actor_type_id__volatile, score_actor_type_id);
	}
	return score_actor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



