/*
 * wsdl-describe.h: Print text description of WSDL tree
 *
 * Authors:
 *	Dick Porter (dick@ximian.com)
 *
 * Copyright (C) 2001, Ximian, Inc.
 */

#ifndef _WSDL_DESCRIBE_H_
#define _WSDL_DESCRIBE_H_

#include "wsdl-parse.h"

#define OFFSET 4

extern void indent(guint);
extern void wsdl_describe_types(guint, wsdl_types *);
extern void wsdl_describe_message_part(guint, wsdl_message_part *);
extern void wsdl_describe_message(guint, wsdl_message *);
extern void wsdl_describe_porttype_operation_iof(guint, wsdl_porttype_operation_inoutfault *, wsdl_state_t);
extern void wsdl_describe_porttype_operation(guint, wsdl_porttype_operation *);
extern void wsdl_describe_porttype(guint, wsdl_porttype *);
extern void wsdl_describe_soap_operation(guint, wsdl_soap_operation *);
extern void wsdl_describe_soap_body(guint, wsdl_soap_body *);
extern void wsdl_describe_soap_header(guint, wsdl_soap_header *);
extern void wsdl_describe_soap_fault(guint, wsdl_soap_fault *);
extern void wsdl_describe_binding_operation_iof(guint, wsdl_binding_operation_inoutfault *, wsdl_state_t);
extern void wsdl_describe_binding_operation(guint, wsdl_binding_operation *);
extern void wsdl_describe_soap_binding(guint, wsdl_soap_binding *);
extern void wsdl_describe_binding(guint, wsdl_binding *);
extern void wsdl_describe_soap_address(guint, wsdl_soap_address *);
extern void wsdl_describe_service_port(guint, wsdl_service_port *);
extern void wsdl_describe_service(guint, wsdl_service *);
extern void wsdl_describe_definitions(guint, wsdl_definitions *);

#endif /* _WSDL_DESCRIBE_H_ */
