#ifndef __SP_TEXT_CONTEXT_H__
#define __SP_TEXT_CONTEXT_H__

/*
 * SPTextContext
 *
 * Authors:
 *   Lauris Kaplinski <lauris@ximian.com>
 *
 * Copyright (C) 1999-2000 Lauris Kaplinski
 * Copyright (C) 2001 Ximian, Inc.
 *
 * Licensed under GNU GPL
 */

#include "event-context.h"

#define SP_TC_XIM

#define SP_TYPE_TEXT_CONTEXT (sp_text_context_get_type ())
#define SP_TEXT_CONTEXT(obj) (GTK_CHECK_CAST ((obj), SP_TYPE_TEXT_CONTEXT, SPTextContext))
#define SP_TEXT_CONTEXT_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), SP_TYPE_TEXT_CONTEXT, SPTextContextClass))
#define SP_IS_TEXT_CONTEXT(obj) (GTK_CHECK_TYPE ((obj), SP_TYPE_TEXT_CONTEXT))
#define SP_IS_TEXT_CONTEXT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), SP_TYPE_TEXT_CONTEXT))

typedef struct _SPTextContext SPTextContext;
typedef struct _SPTextContextClass SPTextContextClass;

struct _SPTextContext {
	SPEventContext event_context;

	SPItem *text;

	/* Text item position in document coordinates */
	ArtPoint pdoc;
	/* Insertion point position */
	gint ipos;

	GnomeCanvasItem *cursor;
	gint timeout;
	guint show : 1;
	guint phase : 1;

#ifdef SP_TC_XIM
	GdkIC *ic;
	GdkICAttr *ic_attr;
	GdkEventMask savedmask;
#endif
};

struct _SPTextContextClass {
	SPEventContextClass parent_class;
};

/* Standard Gtk function */

GtkType sp_text_context_get_type (void);

#endif
