/* Siobhan Audio Player
 *
 * (c) 2005 Ariel Rios <ariel@gnu.org>
 *
 * main.c: main program
 *
 * This file is part of Siobhan Audio Player.
 *
 *   Siobhan is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Siobhan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */


#ifdef HAVE_GPE
#include <gpe/init.h>
#endif

#include <gst/gst.h>
#include <gtk/gtk.h>

#include "timer.h"
#include "callback.h"


#define GST_PLAYER_ERROR (gst_player_error_quark ())

static GQuark 
gst_player_error_quark ()
{
  static GQuark qk = 0;
  if (!qk)
    qk = g_quark_from_static_string ("gst-player-error-quark");

  return qk;
}

int 
main (int argc, char *argv [])
{
	GtkWidget *app;
	GtkWidget *button_play, *stop, *pause, *properties;
	GtkWidget *hbox, *vbox;
	GtkWidget *filesel;
	GtkWidget *slider;
	GtkWidget *video;

	
	GstElement *filesrc, *decoder, *audiosink;
	GstElement *play;


	CallBackData *data = g_new (CallBackData, 1);
	GError *err = NULL;

	gst_init (&argc, &argv);

#ifndef HAVE_GPE
	gtk_init (&argc, &argv);
#else
	gpe_init (&argc, &argv);
#endif


	play = gst_element_factory_make ("playbin", "play");

	g_print ("aca llego\n");
	
	data->thread = play;
	data->filesrc = filesrc;
	data->decoder = decoder;



	audiosink = gst_element_factory_make ("ximagesink", "video-sink");


	printf ("%d-%d\n", play, audiosink);
	
	g_object_set (play, "video-sink", audiosink, NULL);
	g_object_set (G_OBJECT (play), "uri", argv[1], NULL);	

	g_signal_connect (G_OBJECT (play), "eos", G_CALLBACK (eos), play);

	app = gtk_window_new (GTK_WINDOW_TOPLEVEL);

#ifdef HAVE_GPE
	button_play = gpe_button_new_from_stock (GTK_STOCK_MEDIA_PLAY, GPE_BUTTON_TYPE_ICON);
	pause = gpe_button_new_from_stock (GTK_STOCK_MEDIA_PAUSE, GPE_BUTTON_TYPE_ICON);
	stop = gpe_button_new_from_stock (GTK_STOCK_MEDIA_STOP, GPE_BUTTON_TYPE_ICON);
#else					  
#ifdef HAVE_GTK_2_6
	button_play = gtk_button_new_from_stock (GTK_STOCK_MEDIA_PLAY);
	pause = gtk_button_new_from_stock (GTK_STOCK_MEDIA_PAUSE);
	stop = gtk_button_new_from_stock (GTK_STOCK_MEDIA_STOP);
#else
	button_play = gtk_button_new_with_label (">");
	pause = gtk_button_new_with_label ("||");
	stop = gtk_button_new_with_label ("[]");
#endif
#endif 					  

#ifdef HAVE_GPE

	filesel = gpe_button_new_from_stock (GPE_STOCK_OPEN, GPE_BUTTON_TYPE_ICON);
	/*
	  properties = gpe_button_new_from_stock (GPE_STOCK_PROPERTIES. GPE_BUTTON_TYPE_ICON);
	*/
#else
	filesel = gtk_button_new_from_stock (GTK_STOCK_OPEN);
	/*
	  properties = gtk_button_new_from_stock (GTK_STOCK_PROPERTIES);

	*/
#endif

	g_print ("los creo");

	slider = gst_player_timer_new (play);
	g_print ("eres la culpable");
	video = gst_player_video_new (audiosink, play); 
	g_print ("chin chun chan");      


	hbox = gtk_hbox_new (TRUE, 0);
	vbox = gtk_vbox_new (FALSE, 0);

	data->widget = slider;

	gtk_window_set_title (GTK_WINDOW (app), "Siobhan Audio Player");

	gtk_box_pack_start (GTK_BOX (hbox), button_play, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), pause, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), stop, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), filesel, TRUE, TRUE, 0);
	/* gtk_box_pack_start (GTK_BOX (hbox), properties, TRUE, TRUE, 0); */
	gtk_box_pack_start (GTK_BOX (vbox), video, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), slider, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX  (vbox), hbox, FALSE, TRUE, 0);

	gtk_container_add (GTK_CONTAINER (app), vbox);
	
	g_signal_connect (G_OBJECT (app), "delete_event", G_CALLBACK (gtk_main_quit),NULL);
	g_signal_connect (G_OBJECT (button_play), "clicked", G_CALLBACK (cb_play), data);
	g_signal_connect (G_OBJECT (pause), "clicked", G_CALLBACK (cb_pause), play);
	g_signal_connect (G_OBJECT (stop), "clicked", G_CALLBACK (cb_stop), play);
	g_signal_connect (G_OBJECT (filesel), "clicked", G_CALLBACK (cb_choose), data);


	/* 
	   FIXME:
	   Properties are gone for now.
	   A better way that actually works is needed.

	/*
	  g_signal_connect (G_OBJECT (properties), "clicked", G_CALLBACK (cb_properties), NULL);
	*/

	g_idle_add (cb_iterate, (gpointer) data);


	gtk_widget_show_all (app);

	gtk_main ();
}
