/* simple-scan.c generated by valac 0.20.1, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gudev/gudev.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include "colord.h"
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>


#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _user_interface_unref0(var) ((var == NULL) ? NULL : (var = (user_interface_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _SimpleScan {
	GtkApplication parent_instance;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	GtkApplicationClass parent_class;
};

struct _SimpleScanPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUdevClient* udev_client;
	UserInterface* ui;
	Scanner* scanner;
	Book* book;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};


static gpointer simple_scan_parent_class = NULL;
static gboolean simple_scan_show_version;
static gboolean simple_scan_show_version = FALSE;
static gboolean simple_scan_debug_enabled;
static gboolean simple_scan_debug_enabled = FALSE;
static gchar* simple_scan_fix_pdf_filename;
static gchar* simple_scan_fix_pdf_filename = NULL;
static GTimer* simple_scan_log_timer;
static GTimer* simple_scan_log_timer = NULL;
static FILE* simple_scan_log_file;
static FILE* simple_scan_log_file = NULL;

GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
gpointer user_interface_ref (gpointer instance);
void user_interface_unref (gpointer instance);
GParamSpec* param_spec_user_interface (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_user_interface (GValue* value, gpointer v_object);
void value_take_user_interface (GValue* value, gpointer v_object);
gpointer value_get_user_interface (const GValue* value);
GType user_interface_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define SIMPLE_SCAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_SCAN, SimpleScanPrivate))
enum  {
	SIMPLE_SCAN_DUMMY_PROPERTY
};
SimpleScan* simple_scan_new (ScanDevice* device);
SimpleScan* simple_scan_construct (GType object_type, ScanDevice* device);
static void simple_scan_real_startup (GApplication* base);
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* user_interface_get_book (UserInterface* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static void simple_scan_scan_cb (SimpleScan* self, UserInterface* ui, const gchar* device, ScanOptions* options);
static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender, const gchar* device, ScanOptions* options, gpointer self);
static void simple_scan_cancel_cb (SimpleScan* self, UserInterface* ui);
static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender, gpointer self);
static void simple_scan_email_cb (SimpleScan* self, UserInterface* ui, const gchar* profile, gint quality);
static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender, const gchar* profile, gint quality, gpointer self);
Scanner* scanner_get_instance (void);
static void simple_scan_update_scan_devices_cb (SimpleScan* self, Scanner* scanner, GList* devices);
static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self);
static void simple_scan_authorize_cb (SimpleScan* self, Scanner* scanner, const gchar* resource);
static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self);
static void simple_scan_scanner_new_page_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_page_info_cb (SimpleScan* self, Scanner* scanner, ScanPageInfo* info);
static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_line_cb (SimpleScan* self, Scanner* scanner, ScanLine* line);
static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self);
static void simple_scan_scanner_page_done_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self);
static void simple_scan_scanner_document_done_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self);
static void simple_scan_scanner_failed_cb (SimpleScan* self, Scanner* scanner, gint error_code, const gchar* error_string);
static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self);
static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self);
static void simple_scan_on_uevent (SimpleScan* self, GUdevClient* client, const gchar* action, GUdevDevice* device);
static void _simple_scan_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
void user_interface_set_selected_device (UserInterface* self, const gchar* device);
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
static void simple_scan_real_activate (GApplication* base);
void user_interface_start (UserInterface* self);
void scanner_start (Scanner* self);
static void simple_scan_real_shutdown (GApplication* base);
void scanner_free (Scanner* self);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static Page* simple_scan_append_page (SimpleScan* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_has_data (Page* self);
void user_interface_set_selected_page (UserInterface* self, Page* page);
void page_start (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
gboolean page_has_crop (Page* self);
gchar* page_get_named_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
void page_set_named_crop (Page* self, const gchar* name);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
static gchar* simple_scan_get_profile_for_device (SimpleScan* self, const gchar* device_name);
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* color_profile);
guint book_get_n_pages (Book* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
static void simple_scan_remove_empty_page (SimpleScan* self);
void book_delete_page (Book* self, Page* page);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
void user_interface_set_scanning (UserInterface* self, gboolean scanning);
gboolean scanner_is_scanning (Scanner* self);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
void user_interface_set_default_file_name (UserInterface* self, const gchar* default_file_name);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void user_interface_hide_progress_dialog (UserInterface* self);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void simple_scan_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
void scanner_redetect (Scanner* self);
static void simple_scan_fix_pdf (const gchar* filename, GError** error);
gint simple_scan_main (gchar** args, int args_length1);
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void _simple_scan_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void simple_scan_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry SIMPLE_SCAN_options[4] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &simple_scan_show_version, "Show release version", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &simple_scan_debug_enabled, "Print debugging messages", NULL}, {"fix-pdf", (gchar) 0, 0, G_OPTION_ARG_STRING, &simple_scan_fix_pdf_filename, "Fix PDF files generated with older versions of Simple Scan", "FILENAME..."}, {NULL}};

static gpointer _scan_device_ref0 (gpointer self) {
#line 41 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	return self ? scan_device_ref (self) : NULL;
#line 410 "simple-scan.c"
}


SimpleScan* simple_scan_construct (GType object_type, ScanDevice* device) {
	SimpleScan * self = NULL;
	ScanDevice* _tmp0_;
	ScanDevice* _tmp1_;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self = (SimpleScan*) g_object_new (object_type, NULL);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = device;
#line 41 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = _scan_device_ref0 (_tmp0_);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 41 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->default_device = _tmp1_;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	return self;
#line 430 "simple-scan.c"
}


SimpleScan* simple_scan_new (ScanDevice* device) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	return simple_scan_construct (TYPE_SIMPLE_SCAN, device);
#line 437 "simple-scan.c"
}


static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender, const gchar* device, ScanOptions* options, gpointer self) {
#line 50 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_scan_cb (self, _sender, device, options);
#line 444 "simple-scan.c"
}


static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender, gpointer self) {
#line 51 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_cancel_cb (self, _sender);
#line 451 "simple-scan.c"
}


static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender, const gchar* profile, gint quality, gpointer self) {
#line 52 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_email_cb (self, _sender, profile, quality);
#line 458 "simple-scan.c"
}


static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self) {
#line 55 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_update_scan_devices_cb (self, _sender, devices);
#line 465 "simple-scan.c"
}


static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self) {
#line 56 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_authorize_cb (self, _sender, resource);
#line 472 "simple-scan.c"
}


static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self) {
#line 57 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_scanner_new_page_cb (self, _sender);
#line 479 "simple-scan.c"
}


static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self) {
#line 58 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_scanner_page_info_cb (self, _sender, info);
#line 486 "simple-scan.c"
}


static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self) {
#line 59 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_scanner_line_cb (self, _sender, line);
#line 493 "simple-scan.c"
}


static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self) {
#line 60 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_scanner_page_done_cb (self, _sender);
#line 500 "simple-scan.c"
}


static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self) {
#line 61 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_scanner_document_done_cb (self, _sender);
#line 507 "simple-scan.c"
}


static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self) {
#line 62 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_scanner_failed_cb (self, _sender, error_code, error_string);
#line 514 "simple-scan.c"
}


static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self) {
#line 63 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_scanner_scanning_changed_cb (self, _sender);
#line 521 "simple-scan.c"
}


static void _simple_scan_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
#line 67 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_on_uevent (self, _sender, action, device);
#line 528 "simple-scan.c"
}


static void _scan_device_unref0_ (gpointer var) {
#line 69 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 535 "simple-scan.c"
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
#line 69 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
#line 69 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_list_free (self);
#line 544 "simple-scan.c"
}


static void simple_scan_real_startup (GApplication* base) {
	SimpleScan * self;
	UserInterface* _tmp0_;
	UserInterface* _tmp1_;
	Book* _tmp2_ = NULL;
	UserInterface* _tmp3_;
	UserInterface* _tmp4_;
	UserInterface* _tmp5_;
	Scanner* _tmp6_ = NULL;
	Scanner* _tmp7_;
	Scanner* _tmp8_;
	Scanner* _tmp9_;
	Scanner* _tmp10_;
	Scanner* _tmp11_;
	Scanner* _tmp12_;
	Scanner* _tmp13_;
	Scanner* _tmp14_;
	Scanner* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_ = NULL;
	gchar** subsystems;
	gint subsystems_length1;
	gint _subsystems_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	GUdevClient* _tmp19_;
	GUdevClient* _tmp20_;
	ScanDevice* _tmp21_;
#line 44 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 46 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 48 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = user_interface_new ();
#line 48 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_user_interface_unref0 (self->priv->ui);
#line 48 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->ui = _tmp0_;
#line 49 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = self->priv->ui;
#line 49 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = user_interface_get_book (_tmp1_);
#line 49 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 49 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->book = _tmp2_;
#line 50 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = self->priv->ui;
#line 50 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp3_, "start-scan", (GCallback) _simple_scan_scan_cb_user_interface_start_scan, self, 0);
#line 51 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp4_ = self->priv->ui;
#line 51 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp4_, "stop-scan", (GCallback) _simple_scan_cancel_cb_user_interface_stop_scan, self, 0);
#line 52 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp5_ = self->priv->ui;
#line 52 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp5_, "email", (GCallback) _simple_scan_email_cb_user_interface_email, self, 0);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp6_ = scanner_get_instance ();
#line 54 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->scanner = _tmp6_;
#line 55 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp7_ = self->priv->scanner;
#line 55 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp7_, "update-devices", (GCallback) _simple_scan_update_scan_devices_cb_scanner_update_devices, self, 0);
#line 56 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp8_ = self->priv->scanner;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp8_, "request-authorization", (GCallback) _simple_scan_authorize_cb_scanner_request_authorization, self, 0);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp9_ = self->priv->scanner;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp9_, "expect-page", (GCallback) _simple_scan_scanner_new_page_cb_scanner_expect_page, self, 0);
#line 58 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp10_ = self->priv->scanner;
#line 58 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp10_, "got-page-info", (GCallback) _simple_scan_scanner_page_info_cb_scanner_got_page_info, self, 0);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp11_ = self->priv->scanner;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp11_, "got-line", (GCallback) _simple_scan_scanner_line_cb_scanner_got_line, self, 0);
#line 60 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp12_ = self->priv->scanner;
#line 60 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp12_, "page-done", (GCallback) _simple_scan_scanner_page_done_cb_scanner_page_done, self, 0);
#line 61 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp13_ = self->priv->scanner;
#line 61 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp13_, "document-done", (GCallback) _simple_scan_scanner_document_done_cb_scanner_document_done, self, 0);
#line 62 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp14_ = self->priv->scanner;
#line 62 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp14_, "scan-failed", (GCallback) _simple_scan_scanner_failed_cb_scanner_scan_failed, self, 0);
#line 63 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp15_ = self->priv->scanner;
#line 63 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp15_, "scanning-changed", (GCallback) _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed, self, 0);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp16_ = g_strdup ("usb");
#line 65 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp17_ = g_new0 (gchar*, 2 + 1);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp17_[0] = _tmp16_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp17_[1] = NULL;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	subsystems = _tmp17_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	subsystems_length1 = 2;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_subsystems_size_ = subsystems_length1;
#line 66 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp18_ = subsystems;
#line 66 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp18__length1 = subsystems_length1;
#line 66 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp19_ = g_udev_client_new (_tmp18_);
#line 66 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 66 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->udev_client = _tmp19_;
#line 67 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp20_ = self->priv->udev_client;
#line 67 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_signal_connect_object (_tmp20_, "uevent", (GCallback) _simple_scan_on_uevent_g_udev_client_uevent, self, 0);
#line 69 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp21_ = self->priv->default_device;
#line 69 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp21_ != NULL) {
#line 680 "simple-scan.c"
		GList* device_list;
		ScanDevice* _tmp22_;
		ScanDevice* _tmp23_;
		UserInterface* _tmp24_;
		GList* _tmp25_;
		UserInterface* _tmp26_;
		ScanDevice* _tmp27_;
		const gchar* _tmp28_;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		device_list = NULL;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp22_ = self->priv->default_device;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp23_ = _scan_device_ref0 (_tmp22_);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		device_list = g_list_append (device_list, _tmp23_);
#line 74 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp24_ = self->priv->ui;
#line 74 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp25_ = device_list;
#line 74 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		user_interface_set_scan_devices (_tmp24_, _tmp25_);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp26_ = self->priv->ui;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp27_ = self->priv->default_device;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp28_ = _tmp27_->name;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		user_interface_set_selected_device (_tmp26_, _tmp28_);
#line 69 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		__g_list_free__scan_device_unref0_0 (device_list);
#line 713 "simple-scan.c"
	}
#line 44 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	subsystems = (_vala_array_free (subsystems, subsystems_length1, (GDestroyNotify) g_free), NULL);
#line 717 "simple-scan.c"
}


static void simple_scan_real_activate (GApplication* base) {
	SimpleScan * self;
	UserInterface* _tmp0_;
	Scanner* _tmp1_;
#line 79 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 82 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 82 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	user_interface_start (_tmp0_);
#line 83 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = self->priv->scanner;
#line 83 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	scanner_start (_tmp1_);
#line 737 "simple-scan.c"
}


static void simple_scan_real_shutdown (GApplication* base) {
	SimpleScan * self;
	Scanner* _tmp0_;
#line 86 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 88 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 89 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->book = NULL;
#line 90 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_user_interface_unref0 (self->priv->ui);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->ui = NULL;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->udev_client = NULL;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	scanner_free (_tmp0_);
#line 764 "simple-scan.c"
}


static void simple_scan_update_scan_devices_cb (SimpleScan* self, Scanner* scanner, GList* devices) {
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* devices_copy;
	ScanDevice* _tmp2_;
	GList* _tmp10_;
	guint _tmp11_ = 0U;
	UserInterface* _tmp12_;
	GList* _tmp13_;
#line 95 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = devices;
#line 97 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = g_list_copy (_tmp0_);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	devices_copy = _tmp1_;
#line 100 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = self->priv->default_device;
#line 100 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp2_ != NULL) {
#line 791 "simple-scan.c"
		gboolean default_in_list;
		GList* _tmp3_;
		gboolean _tmp8_;
#line 102 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		default_in_list = FALSE;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp3_ = devices_copy;
#line 799 "simple-scan.c"
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			device_collection = _tmp3_;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 807 "simple-scan.c"
				ScanDevice* device = NULL;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				device = (ScanDevice*) device_it->data;
#line 811 "simple-scan.c"
				{
					ScanDevice* _tmp4_;
					const gchar* _tmp5_;
					ScanDevice* _tmp6_;
					const gchar* _tmp7_;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp4_ = device;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp5_ = _tmp4_->name;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp6_ = self->priv->default_device;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp7_ = _tmp6_->name;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
#line 107 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						default_in_list = TRUE;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						break;
#line 831 "simple-scan.c"
					}
				}
			}
		}
#line 112 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp8_ = default_in_list;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (!_tmp8_) {
#line 840 "simple-scan.c"
			ScanDevice* _tmp9_;
#line 113 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp9_ = self->priv->default_device;
#line 113 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			devices_copy = g_list_prepend (devices_copy, _tmp9_);
#line 846 "simple-scan.c"
		}
	}
#line 116 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp10_ = devices_copy;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp11_ = g_list_length (_tmp10_);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->have_devices = _tmp11_ > ((guint) 0);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp12_ = self->priv->ui;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp13_ = devices_copy;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	user_interface_set_scan_devices (_tmp12_, _tmp13_);
#line 95 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_list_free0 (devices_copy);
#line 863 "simple-scan.c"
}


static void simple_scan_authorize_cb (SimpleScan* self, Scanner* scanner, const gchar* resource) {
	gchar* username = NULL;
	gchar* password = NULL;
	UserInterface* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Scanner* _tmp4_;
#line 120 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (resource != NULL);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = resource;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	user_interface_authorize (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (username);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	username = _tmp2_;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (password);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	password = _tmp3_;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp4_ = scanner;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	scanner_authorize (_tmp4_, username, password);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (password);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (username);
#line 903 "simple-scan.c"
}


static Page* simple_scan_append_page (SimpleScan* self) {
	Page* result = NULL;
	Book* _tmp0_;
	Page* _tmp1_ = NULL;
	Page* page;
	gboolean _tmp2_ = FALSE;
	Page* _tmp3_;
	gboolean _tmp6_;
	ScanDirection scan_direction;
	gboolean do_crop;
	gchar* named_crop;
	gint width;
	gint height;
	gint dpi;
	gint cx;
	gint cy;
	gint cw;
	gint ch;
	Page* _tmp10_;
	Book* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ScanDirection _tmp33_;
	Page* _tmp34_ = NULL;
	gboolean _tmp35_;
	UserInterface* _tmp45_;
	Page* _tmp46_;
	Page* _tmp47_;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 130 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = book_get_page (_tmp0_, -1);
#line 130 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page = _tmp1_;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = page;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp3_ != NULL) {
#line 948 "simple-scan.c"
		Page* _tmp4_;
		gboolean _tmp5_ = FALSE;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp4_ = page;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp5_ = page_has_data (_tmp4_);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp2_ = !_tmp5_;
#line 957 "simple-scan.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp2_ = FALSE;
#line 961 "simple-scan.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp6_ = _tmp2_;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp6_) {
#line 967 "simple-scan.c"
		UserInterface* _tmp7_;
		Page* _tmp8_;
		Page* _tmp9_;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp7_ = self->priv->ui;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp8_ = page;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		user_interface_set_selected_page (_tmp7_, _tmp8_);
#line 134 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp9_ = page;
#line 134 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		page_start (_tmp9_);
#line 135 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = page;
#line 135 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 985 "simple-scan.c"
	}
#line 139 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	do_crop = FALSE;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	named_crop = NULL;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	width = 100;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	height = 100;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	dpi = 100;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	cx = 0;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	cy = 0;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	cw = 0;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	ch = 0;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp10_ = page;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp10_ != NULL) {
#line 1011 "simple-scan.c"
		Page* _tmp11_;
		ScanDirection _tmp12_ = 0;
		Page* _tmp13_;
		gint _tmp14_ = 0;
		Page* _tmp15_;
		gint _tmp16_ = 0;
		Page* _tmp17_;
		gint _tmp18_ = 0;
		Page* _tmp19_;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp11_ = page;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp12_ = page_get_scan_direction (_tmp11_);
#line 145 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		scan_direction = _tmp12_;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp13_ = page;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp14_ = page_get_width (_tmp13_);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		width = _tmp14_;
#line 147 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp15_ = page;
#line 147 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp16_ = page_get_height (_tmp15_);
#line 147 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		height = _tmp16_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp17_ = page;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp18_ = page_get_dpi (_tmp17_);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		dpi = _tmp18_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp19_ = page;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp20_ = page_has_crop (_tmp19_);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		do_crop = _tmp20_;
#line 151 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp21_ = do_crop;
#line 151 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_tmp21_) {
#line 1057 "simple-scan.c"
			Page* _tmp22_;
			gchar* _tmp23_ = NULL;
			Page* _tmp24_;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp22_ = page;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp23_ = page_get_named_crop (_tmp22_);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (named_crop);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			named_crop = _tmp23_;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp24_ = page;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			page_get_crop (_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
#line 154 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			cx = _tmp25_;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			cy = _tmp26_;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			cw = _tmp27_;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			ch = _tmp28_;
#line 1085 "simple-scan.c"
		}
	}
#line 158 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp29_ = self->priv->book;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp30_ = width;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp31_ = height;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp32_ = dpi;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp33_ = scan_direction;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp34_ = book_append_page (_tmp29_, _tmp30_, _tmp31_, _tmp32_, _tmp33_);
#line 158 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_page_unref0 (page);
#line 158 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page = _tmp34_;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp35_ = do_crop;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp35_) {
#line 1108 "simple-scan.c"
		const gchar* _tmp36_;
		Page* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp36_ = named_crop;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_tmp36_ != NULL) {
#line 1117 "simple-scan.c"
			Page* _tmp37_;
			const gchar* _tmp38_;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp37_ = page;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp38_ = named_crop;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			page_set_named_crop (_tmp37_, _tmp38_);
#line 1126 "simple-scan.c"
		} else {
			Page* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp39_ = page;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp40_ = cw;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp41_ = ch;
#line 166 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			page_set_custom_crop (_tmp39_, _tmp40_, _tmp41_);
#line 1139 "simple-scan.c"
		}
#line 167 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp42_ = page;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp43_ = cx;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp44_ = cy;
#line 167 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		page_move_crop (_tmp42_, _tmp43_, _tmp44_);
#line 1149 "simple-scan.c"
	}
#line 169 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp45_ = self->priv->ui;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp46_ = page;
#line 169 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	user_interface_set_selected_page (_tmp45_, _tmp46_);
#line 170 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp47_ = page;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page_start (_tmp47_);
#line 172 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	result = page;
#line 172 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (named_crop);
#line 172 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	return result;
#line 1167 "simple-scan.c"
}


static void simple_scan_scanner_new_page_cb (SimpleScan* self, Scanner* scanner) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 177 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = simple_scan_append_page (self);
#line 177 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = _tmp0_;
#line 177 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_page_unref0 (_tmp1_);
#line 1184 "simple-scan.c"
}


static gchar* simple_scan_get_profile_for_device (SimpleScan* self, const gchar* device_name) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* device_id;
	const gchar* _tmp2_;
	CdClient* _tmp3_;
	CdClient* client;
	CdDevice* device = NULL;
	CdDevice* _tmp18_;
	CdProfile* _tmp19_ = NULL;
	CdProfile* profile;
	CdProfile* _tmp20_;
	CdProfile* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	CdProfile* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	CdProfile* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	GError * _inner_error_ = NULL;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 180 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_val_if_fail (device_name != NULL, NULL);
#line 183 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = device_name;
#line 183 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = g_strdup_printf ("sane:%s", _tmp0_);
#line 183 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	device_id = _tmp1_;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = device_name;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_debug ("simple-scan.vala:184: Getting color profile for device %s", _tmp2_);
#line 186 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = cd_client_new ();
#line 186 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	client = _tmp3_;
#line 1231 "simple-scan.c"
	{
		CdClient* _tmp4_;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp4_ = client;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		cd_client_connect_sync (_tmp4_, NULL, &_inner_error_);
#line 189 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1240 "simple-scan.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		e = _inner_error_;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp5_ = e;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp6_ = _tmp5_->message;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_debug ("simple-scan.vala:193: Failed to connect to colord: %s", _tmp6_);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = NULL;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_error_free0 (e);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 1270 "simple-scan.c"
	}
	__finally4:
#line 187 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 187 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return NULL;
#line 1285 "simple-scan.c"
	}
	{
		CdClient* _tmp7_;
		const gchar* _tmp8_;
		CdDevice* _tmp9_ = NULL;
		CdDevice* _tmp10_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp7_ = client;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp8_ = device_id;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp9_ = cd_client_find_device_by_property_sync (_tmp7_, CD_DEVICE_PROPERTY_SERIAL, _tmp8_, NULL, &_inner_error_);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp10_ = _tmp9_;
#line 200 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1302 "simple-scan.c"
			goto __catch5_g_error;
		}
#line 200 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		device = _tmp10_;
#line 1309 "simple-scan.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		e = _inner_error_;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp11_ = device_name;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp12_ = e;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp13_ = _tmp12_->message;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_debug ("simple-scan.vala:204: Unable to find colord device %s: %s", _tmp11_, _tmp13_);
#line 205 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = NULL;
#line 205 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_error_free0 (e);
#line 205 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 205 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 205 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 205 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 1342 "simple-scan.c"
	}
	__finally5:
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return NULL;
#line 1359 "simple-scan.c"
	}
	{
		CdDevice* _tmp14_;
#line 210 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp14_ = device;
#line 210 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		cd_device_connect_sync (_tmp14_, NULL, &_inner_error_);
#line 210 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1369 "simple-scan.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		e = _inner_error_;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp15_ = device_name;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp16_ = e;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp17_ = _tmp16_->message;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_debug ("simple-scan.vala:214: Failed to get properties from the device %s: %s", _tmp15_, _tmp17_);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = NULL;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_error_free0 (e);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 1404 "simple-scan.c"
	}
	__finally6:
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return NULL;
#line 1421 "simple-scan.c"
	}
#line 218 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp18_ = device;
#line 218 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp19_ = cd_device_get_default_profile (_tmp18_);
#line 218 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	profile = _tmp19_;
#line 219 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp20_ = profile;
#line 219 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp20_ == NULL) {
#line 1433 "simple-scan.c"
		const gchar* _tmp21_;
#line 221 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp21_ = device_name;
#line 221 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_debug ("simple-scan.vala:221: No default color profile for device: %s", _tmp21_);
#line 222 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = NULL;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 222 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 222 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 222 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 222 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 1451 "simple-scan.c"
	}
	{
		CdProfile* _tmp22_;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp22_ = profile;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		cd_profile_connect_sync (_tmp22_, NULL, &_inner_error_);
#line 227 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1461 "simple-scan.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		e = _inner_error_;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp23_ = device_name;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp24_ = e;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp25_ = _tmp24_->message;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_debug ("simple-scan.vala:231: Failed to get properties from the profile %s: %s", _tmp23_, _tmp25_);
#line 232 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = NULL;
#line 232 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_error_free0 (e);
#line 232 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 232 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 232 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 232 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 232 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 1498 "simple-scan.c"
	}
	__finally7:
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return NULL;
#line 1517 "simple-scan.c"
	}
#line 235 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp26_ = profile;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp27_ = cd_profile_get_filename (_tmp26_);
#line 235 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp28_ = _tmp27_;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp28_ == NULL) {
#line 1527 "simple-scan.c"
		const gchar* _tmp29_;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp29_ = device_name;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_debug ("simple-scan.vala:237: No icc color profile for the device %s", _tmp29_);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = NULL;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (device_id);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 1545 "simple-scan.c"
	}
#line 241 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp30_ = profile;
#line 241 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp31_ = cd_profile_get_filename (_tmp30_);
#line 241 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp32_ = _tmp31_;
#line 241 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp33_ = device_name;
#line 241 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_debug ("simple-scan.vala:241: Using color profile %s for device %s", _tmp32_, _tmp33_);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp34_ = profile;
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp35_ = cd_profile_get_filename (_tmp34_);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp36_ = _tmp35_;
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp37_ = g_strdup (_tmp36_);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	result = _tmp37_;
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_object_unref0 (profile);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_object_unref0 (device);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_object_unref0 (client);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (device_id);
#line 242 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	return result;
#line 1577 "simple-scan.c"
}


static void simple_scan_scanner_page_info_cb (SimpleScan* self, Scanner* scanner, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_;
	gint _tmp1_;
	ScanPageInfo* _tmp2_;
	gint _tmp3_;
	ScanPageInfo* _tmp4_;
	gint _tmp5_;
	Page* _tmp6_ = NULL;
	Page* page;
	ScanPageInfo* _tmp7_;
	ScanPageInfo* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
#line 248 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 248 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 248 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (info != NULL);
#line 250 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = info;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = _tmp0_->width;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = info;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = _tmp2_->height;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp4_ = info;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp5_ = _tmp4_->depth;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_debug ("simple-scan.vala:250: Page is %d pixels wide, %d pixels high, %d bits " \
"per pixel", _tmp1_, _tmp3_, _tmp5_);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp6_ = simple_scan_append_page (self);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page = _tmp6_;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp7_ = info;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page_set_page_info (page, _tmp7_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp8_ = info;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp9_ = _tmp8_->device;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp10_ = simple_scan_get_profile_for_device (self, _tmp9_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp11_ = _tmp10_;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page_set_color_profile (page, _tmp11_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (_tmp11_);
#line 248 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_page_unref0 (page);
#line 1637 "simple-scan.c"
}


static void simple_scan_scanner_line_cb (SimpleScan* self, Scanner* scanner, ScanLine* line) {
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* page;
	ScanLine* _tmp4_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (line != NULL);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page = _tmp3_;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp4_ = line;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page_parse_scan_line (page, _tmp4_);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_page_unref0 (page);
#line 1670 "simple-scan.c"
}


static void simple_scan_scanner_page_done_cb (SimpleScan* self, Scanner* scanner) {
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* page;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 269 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page = _tmp3_;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page_finish (page);
#line 269 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_page_unref0 (page);
#line 1698 "simple-scan.c"
}


static void simple_scan_remove_empty_page (SimpleScan* self) {
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_ = 0U;
	Page* _tmp3_ = NULL;
	Page* page;
	Page* _tmp4_;
	gboolean _tmp5_ = FALSE;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 277 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 277 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = book_get_page (_tmp0_, ((gint) _tmp2_) - 1);
#line 277 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	page = _tmp3_;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp4_ = page;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp5_ = page_has_data (_tmp4_);
#line 280 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp5_) {
#line 1728 "simple-scan.c"
		Page* _tmp6_;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp6_ = page;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		page_finish (_tmp6_);
#line 1734 "simple-scan.c"
	} else {
		Book* _tmp7_;
		Page* _tmp8_;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp7_ = self->priv->book;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp8_ = page;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		book_delete_page (_tmp7_, _tmp8_);
#line 1744 "simple-scan.c"
	}
#line 275 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_page_unref0 (page);
#line 1748 "simple-scan.c"
}


static void simple_scan_scanner_document_done_cb (SimpleScan* self, Scanner* scanner) {
#line 286 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 286 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 288 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_remove_empty_page (self);
#line 1759 "simple-scan.c"
}


static void simple_scan_scanner_failed_cb (SimpleScan* self, Scanner* scanner, gint error_code, const gchar* error_string) {
	gint _tmp0_;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 291 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 291 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (error_string != NULL);
#line 293 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_remove_empty_page (self);
#line 294 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = error_code;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp0_ != ((gint) SANE_STATUS_CANCELLED)) {
#line 1777 "simple-scan.c"
		UserInterface* _tmp1_;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		gboolean _tmp4_;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp1_ = self->priv->ui;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp2_ = _ ("Failed to scan");
#line 296 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp3_ = error_string;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp4_ = self->priv->have_devices;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		user_interface_show_error (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1792 "simple-scan.c"
	}
}


static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self, Scanner* scanner) {
	UserInterface* _tmp0_;
	Scanner* _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 303 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 305 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = scanner;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = scanner_is_scanning (_tmp1_);
#line 305 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	user_interface_set_scanning (_tmp0_, _tmp2_);
#line 1813 "simple-scan.c"
}


static void simple_scan_scan_cb (SimpleScan* self, UserInterface* ui, const gchar* device, ScanOptions* options) {
	ScanOptions* _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	Scanner* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* filename_prefix;
	gchar* extension = NULL;
	ScanOptions* _tmp9_;
	ScanMode _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* filename;
	UserInterface* _tmp16_;
	Scanner* _tmp17_;
	const gchar* _tmp18_;
	ScanOptions* _tmp19_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 308 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (options != NULL);
#line 310 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = options;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = _tmp0_->dpi;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = device;
#line 310 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_debug ("simple-scan.vala:310: Requesting scan at %d dpi from device '%s'", _tmp1_, _tmp2_);
#line 312 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = self->priv->scanner;
#line 312 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp4_ = scanner_is_scanning (_tmp3_);
#line 312 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (!_tmp4_) {
#line 1857 "simple-scan.c"
		Page* _tmp5_ = NULL;
		Page* _tmp6_;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp5_ = simple_scan_append_page (self);
#line 313 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp6_ = _tmp5_;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_page_unref0 (_tmp6_);
#line 1866 "simple-scan.c"
	}
#line 316 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp7_ = _ ("Scanned Document");
#line 316 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 316 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	filename_prefix = _tmp8_;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp9_ = options;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp10_ = _tmp9_->scan_mode;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp10_ == SCAN_MODE_COLOR) {
#line 1880 "simple-scan.c"
		gchar* _tmp11_;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp11_ = g_strdup ("jpg");
#line 319 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (extension);
#line 319 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		extension = _tmp11_;
#line 1888 "simple-scan.c"
	} else {
		gchar* _tmp12_;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp12_ = g_strdup ("pdf");
#line 321 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (extension);
#line 321 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		extension = _tmp12_;
#line 1897 "simple-scan.c"
	}
#line 322 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp13_ = filename_prefix;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp14_ = extension;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp15_ = g_strdup_printf ("%s.%s", _tmp13_, _tmp14_);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	filename = _tmp15_;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp16_ = ui;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	user_interface_set_default_file_name (_tmp16_, filename);
#line 324 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp17_ = self->priv->scanner;
#line 324 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp18_ = device;
#line 324 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp19_ = options;
#line 324 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	scanner_scan (_tmp17_, _tmp18_, _tmp19_);
#line 308 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (filename);
#line 308 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (extension);
#line 308 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (filename_prefix);
#line 1925 "simple-scan.c"
}


static void simple_scan_cancel_cb (SimpleScan* self, UserInterface* ui) {
	Scanner* _tmp0_;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 329 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	scanner_cancel (_tmp0_);
#line 1939 "simple-scan.c"
}


static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 332 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 332 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 332 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = prefix;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = extension;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	filename = _tmp2_;
#line 1965 "simple-scan.c"
	{
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint fd;
		gint _tmp6_;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp3_ = filename;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 341 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (path);
#line 341 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		path = _tmp4_;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		fd = _tmp5_;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 1984 "simple-scan.c"
			goto __catch8_g_error;
		}
#line 342 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp6_ = fd;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		close (_tmp6_);
#line 1991 "simple-scan.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		e = _inner_error_;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp7_ = e;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp8_ = _tmp7_->message;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_warning ("simple-scan.vala:346: Error saving email attachment: %s", _tmp8_);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = NULL;
#line 347 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_error_free0 (e);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (path);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (filename);
#line 347 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 2019 "simple-scan.c"
	}
	__finally8:
#line 339 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 339 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (path);
#line 339 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (filename);
#line 339 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 339 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 339 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return NULL;
#line 2034 "simple-scan.c"
	}
#line 350 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	result = path;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (filename);
#line 350 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	return result;
#line 2042 "simple-scan.c"
}


static void simple_scan_email_cb (SimpleScan* self, UserInterface* ui, const gchar* profile, gint quality) {
	gboolean saved;
	gchar* _tmp0_;
	gchar* command_line;
	const gchar* _tmp1_;
	const gchar* _tmp42_;
	GError * _inner_error_ = NULL;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 353 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 353 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (profile != NULL);
#line 355 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	saved = FALSE;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = g_strdup ("xdg-email");
#line 356 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	command_line = _tmp0_;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = profile;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 2069 "simple-scan.c"
		gchar* _tmp2_ = NULL;
		gchar* path;
		const gchar* _tmp3_;
#line 362 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp2_ = simple_scan_get_temporary_filename (self, "scan", "pdf");
#line 362 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		path = _tmp2_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp3_ = path;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_tmp3_ != NULL) {
#line 2081 "simple-scan.c"
			const gchar* _tmp4_;
			GFile* _tmp5_ = NULL;
			GFile* file;
			UserInterface* _tmp6_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp4_ = path;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp5_ = g_file_new_for_path (_tmp4_);
#line 365 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			file = _tmp5_;
#line 366 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp6_ = ui;
#line 366 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			user_interface_show_progress_dialog (_tmp6_);
#line 2101 "simple-scan.c"
			{
				Book* _tmp7_;
				gint _tmp8_;
				GFile* _tmp9_;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp7_ = self->priv->book;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp8_ = quality;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp9_ = file;
#line 369 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				book_save (_tmp7_, "pdf", _tmp8_, _tmp9_, &_inner_error_);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				if (_inner_error_ != NULL) {
#line 2116 "simple-scan.c"
					goto __catch9_g_error;
				}
			}
			goto __finally9;
			__catch9_g_error:
			{
				GError* e = NULL;
				UserInterface* _tmp10_;
				GError* _tmp11_;
				const gchar* _tmp12_;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				e = _inner_error_;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_inner_error_ = NULL;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp10_ = ui;
#line 373 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				user_interface_hide_progress_dialog (_tmp10_);
#line 374 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp11_ = e;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp12_ = _tmp11_->message;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				g_warning ("simple-scan.vala:374: Unable to save email file: %s", _tmp12_);
#line 375 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_g_error_free0 (e);
#line 375 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 375 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_g_free0 (path);
#line 375 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_g_free0 (command_line);
#line 375 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				return;
#line 2151 "simple-scan.c"
			}
			__finally9:
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			if (_inner_error_ != NULL) {
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_g_free0 (path);
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_g_free0 (command_line);
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				g_clear_error (&_inner_error_);
#line 367 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				return;
#line 2168 "simple-scan.c"
			}
#line 377 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp13_ = command_line;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp14_ = path;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp15_ = g_strdup_printf (" --attach %s", _tmp14_);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp16_ = _tmp15_;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (command_line);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			command_line = _tmp17_;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (_tmp16_);
#line 363 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_object_unref0 (file);
#line 2188 "simple-scan.c"
		}
#line 359 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (path);
#line 2192 "simple-scan.c"
	} else {
		{
			gint i;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			i = 0;
#line 2198 "simple-scan.c"
			{
				gboolean _tmp18_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp18_ = TRUE;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				while (TRUE) {
#line 2205 "simple-scan.c"
					gboolean _tmp19_;
					gint _tmp21_;
					Book* _tmp22_;
					guint _tmp23_ = 0U;
					gchar* _tmp24_ = NULL;
					gchar* path;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					GFile* _tmp27_ = NULL;
					GFile* file;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gboolean _tmp41_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp19_ = _tmp18_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					if (!_tmp19_) {
#line 2226 "simple-scan.c"
						gint _tmp20_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp20_ = i;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						i = _tmp20_ + 1;
#line 2232 "simple-scan.c"
					}
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp18_ = FALSE;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp21_ = i;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp22_ = self->priv->book;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp23_ = book_get_n_pages (_tmp22_);
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					if (!(((guint) _tmp21_) < _tmp23_)) {
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						break;
#line 2246 "simple-scan.c"
					}
#line 384 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp24_ = simple_scan_get_temporary_filename (self, "scan", "jpg");
#line 384 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					path = _tmp24_;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp25_ = path;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					if (_tmp25_ == NULL) {
#line 387 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						saved = FALSE;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_free0 (path);
#line 388 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						break;
#line 2262 "simple-scan.c"
					}
#line 391 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp26_ = path;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp27_ = g_file_new_for_path (_tmp26_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					file = _tmp27_;
#line 2270 "simple-scan.c"
					{
						Book* _tmp28_;
						gint _tmp29_;
						Page* _tmp30_ = NULL;
						Page* _tmp31_;
						gint _tmp32_;
						GFile* _tmp33_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp28_ = self->priv->book;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp29_ = i;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp30_ = book_get_page (_tmp28_, _tmp29_);
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp31_ = _tmp30_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp32_ = quality;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp33_ = file;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						page_save (_tmp31_, "jpeg", _tmp32_, _tmp33_, &_inner_error_);
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_page_unref0 (_tmp31_);
#line 394 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						if (_inner_error_ != NULL) {
#line 2296 "simple-scan.c"
							goto __catch10_g_error;
						}
					}
					goto __finally10;
					__catch10_g_error:
					{
						GError* e = NULL;
						GError* _tmp34_;
						const gchar* _tmp35_;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						e = _inner_error_;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_inner_error_ = NULL;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp34_ = e;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp35_ = _tmp34_->message;
#line 398 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						g_warning ("simple-scan.vala:398: Unable to save email file: %s", _tmp35_);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_error_free0 (e);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_free0 (path);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_free0 (command_line);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						return;
#line 2326 "simple-scan.c"
					}
					__finally10:
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					if (_inner_error_ != NULL) {
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_free0 (path);
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_free0 (command_line);
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						g_clear_error (&_inner_error_);
#line 392 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						return;
#line 2343 "simple-scan.c"
					}
#line 401 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp36_ = command_line;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp37_ = path;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp38_ = g_strdup_printf (" --attach %s", _tmp37_);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp39_ = _tmp38_;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_g_free0 (command_line);
#line 401 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					command_line = _tmp40_;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_g_free0 (_tmp39_);
#line 403 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp41_ = saved;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					if (!_tmp41_) {
#line 404 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 404 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_free0 (path);
#line 404 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						break;
#line 2371 "simple-scan.c"
					}
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_g_object_unref0 (file);
#line 382 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_g_free0 (path);
#line 2377 "simple-scan.c"
				}
			}
		}
	}
#line 408 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp42_ = command_line;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_debug ("simple-scan.vala:408: Launching email client: %s", _tmp42_);
#line 2386 "simple-scan.c"
	{
		const gchar* _tmp43_;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp43_ = command_line;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_spawn_command_line_async (_tmp43_, &_inner_error_);
#line 411 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 2395 "simple-scan.c"
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		e = _inner_error_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp44_ = e;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp45_ = _tmp44_->message;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_warning ("simple-scan.vala:415: Unable to start email: %s", _tmp45_);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_error_free0 (e);
#line 2417 "simple-scan.c"
	}
	__finally11:
#line 409 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 409 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (command_line);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return;
#line 2430 "simple-scan.c"
	}
#line 353 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (command_line);
#line 2434 "simple-scan.c"
}


static void simple_scan_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	gchar* prefix = NULL;
	GLogLevelFlags _tmp0_;
	FILE* _tmp8_;
	GTimer* _tmp9_;
	gdouble _tmp10_ = 0.0;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
#line 419 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (message != NULL);
#line 423 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = log_level;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	switch (_tmp0_ & G_LOG_LEVEL_MASK) {
#line 423 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		case G_LOG_LEVEL_ERROR:
#line 2455 "simple-scan.c"
		{
			gchar* _tmp1_;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp1_ = g_strdup ("ERROR:");
#line 426 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (prefix);
#line 426 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			prefix = _tmp1_;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			break;
#line 2466 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		case G_LOG_LEVEL_CRITICAL:
#line 2470 "simple-scan.c"
		{
			gchar* _tmp2_;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp2_ = g_strdup ("CRITICAL:");
#line 429 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (prefix);
#line 429 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			prefix = _tmp2_;
#line 430 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			break;
#line 2481 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		case G_LOG_LEVEL_WARNING:
#line 2485 "simple-scan.c"
		{
			gchar* _tmp3_;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp3_ = g_strdup ("WARNING:");
#line 432 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (prefix);
#line 432 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			prefix = _tmp3_;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			break;
#line 2496 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		case G_LOG_LEVEL_MESSAGE:
#line 2500 "simple-scan.c"
		{
			gchar* _tmp4_;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp4_ = g_strdup ("MESSAGE:");
#line 435 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (prefix);
#line 435 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			prefix = _tmp4_;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			break;
#line 2511 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		case G_LOG_LEVEL_INFO:
#line 2515 "simple-scan.c"
		{
			gchar* _tmp5_;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp5_ = g_strdup ("INFO:");
#line 438 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (prefix);
#line 438 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			prefix = _tmp5_;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			break;
#line 2526 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		case G_LOG_LEVEL_DEBUG:
#line 2530 "simple-scan.c"
		{
			gchar* _tmp6_;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp6_ = g_strdup ("DEBUG:");
#line 441 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (prefix);
#line 441 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			prefix = _tmp6_;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			break;
#line 2541 "simple-scan.c"
		}
		default:
		{
			gchar* _tmp7_;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp7_ = g_strdup ("LOG:");
#line 444 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (prefix);
#line 444 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			prefix = _tmp7_;
#line 445 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			break;
#line 2554 "simple-scan.c"
		}
	}
#line 448 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp8_ = simple_scan_log_file;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp9_ = simple_scan_log_timer;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp10_ = g_timer_elapsed (_tmp9_, NULL);
#line 448 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp11_ = prefix;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp12_ = message;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	fprintf (_tmp8_, "[%+.2fs] %s %s\n", _tmp10_, _tmp11_, _tmp12_);
#line 449 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp13_ = simple_scan_debug_enabled;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp13_) {
#line 2573 "simple-scan.c"
		FILE* _tmp14_;
		GTimer* _tmp15_;
		gdouble _tmp16_ = 0.0;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp14_ = stderr;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp15_ = simple_scan_log_timer;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp16_ = g_timer_elapsed (_tmp15_, NULL);
#line 450 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp17_ = prefix;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp18_ = message;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		fprintf (_tmp14_, "[%+.2fs] %s %s\n", _tmp16_, _tmp17_, _tmp18_);
#line 2591 "simple-scan.c"
	}
#line 419 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (prefix);
#line 2595 "simple-scan.c"
}


static void simple_scan_on_uevent (SimpleScan* self, GUdevClient* client, const gchar* action, GUdevDevice* device) {
	Scanner* _tmp0_;
#line 453 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 453 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (client != NULL);
#line 453 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (action != NULL);
#line 453 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (device != NULL);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	scanner_redetect (_tmp0_);
#line 2613 "simple-scan.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1157 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1158 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2636 "simple-scan.c"
		glong _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1159 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 2644 "simple-scan.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1161 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 2656 "simple-scan.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1168 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2681 "simple-scan.c"
		glong _tmp2_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2687 "simple-scan.c"
	} else {
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2691 "simple-scan.c"
	}
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1170 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 2697 "simple-scan.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1172 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 2709 "simple-scan.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1174 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 2719 "simple-scan.c"
	}
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1177 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 2725 "simple-scan.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1178 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1179 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 2739 "simple-scan.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1181 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 2749 "simple-scan.c"
	}
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1183 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 2755 "simple-scan.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1184 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 2764 "simple-scan.c"
	}
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1186 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1187 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 2784 "simple-scan.c"
}


static void simple_scan_fix_pdf (const gchar* filename, GError** error) {
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_;
	guint8* _tmp1_ = NULL;
	size_t _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FILE* _tmp6_ = NULL;
	FILE* _tmp7_;
	FILE* fixed_file;
	gint offset;
	gint line_number;
	gint xref_offset;
	gint xref_line;
	GRegex* _tmp8_;
	GRegex* xref_regex;
	GMatchInfo* xref_match = NULL;
	GString* _tmp9_;
	GString* line;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gint _tmp88_ = 0;
	gboolean _tmp89_;
	GError * _inner_error_ = NULL;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_return_if_fail (filename != NULL);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = filename;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_file_get_contents (_tmp0_, (gchar**) (&_tmp1_), &_tmp2_, &_inner_error_);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	data = _tmp1_;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	data_length1 = _tmp2_;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_data_size_ = data_length1;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_propagate_error (error, _inner_error_);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		data = (g_free (data), NULL);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return;
#line 2839 "simple-scan.c"
	}
#line 463 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = filename;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".fixed", NULL);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp5_ = _tmp4_;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp6_ = g_fopen (_tmp5_, "w");
#line 463 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp7_ = _tmp6_;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (_tmp5_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	fixed_file = _tmp7_;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	offset = 0;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	line_number = 0;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	xref_offset = 0;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	xref_line = -1;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp8_ = g_regex_new ("^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d 0000 n$", 0, 0, &_inner_error_);
#line 469 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	xref_regex = _tmp8_;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 469 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_propagate_error (error, _inner_error_);
#line 469 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_fclose0 (fixed_file);
#line 469 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		data = (g_free (data), NULL);
#line 469 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return;
#line 2877 "simple-scan.c"
	}
#line 471 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp9_ = g_string_new ("");
#line 471 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	line = _tmp9_;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	while (TRUE) {
#line 2885 "simple-scan.c"
		gint _tmp10_;
		guint8* _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_;
		gint end_offset;
		GString* _tmp13_;
		GString* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp26_ = FALSE;
		gint _tmp27_;
		gboolean _tmp31_;
		gint _tmp82_;
		gint _tmp83_;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp10_ = offset;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp11_ = data;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp11__length1 = data_length1;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (!(_tmp10_ < _tmp11__length1)) {
#line 472 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			break;
#line 2909 "simple-scan.c"
		}
#line 474 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp12_ = offset;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		end_offset = _tmp12_;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp13_ = line;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_string_assign (_tmp13_, "");
#line 476 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		while (TRUE) {
#line 2921 "simple-scan.c"
			gint _tmp14_;
			guint8* _tmp15_;
			gint _tmp15__length1;
			guint8* _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			guint8 _tmp18_;
			guint8 c;
			GString* _tmp19_;
			guint8 _tmp20_;
			gint _tmp21_;
			guint8 _tmp22_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp14_ = end_offset;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp15_ = data;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp15__length1 = data_length1;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			if (!(_tmp14_ < _tmp15__length1)) {
#line 476 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				break;
#line 2944 "simple-scan.c"
			}
#line 478 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp16_ = data;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp16__length1 = data_length1;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp17_ = end_offset;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp18_ = _tmp16_[_tmp17_];
#line 478 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			c = _tmp18_;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp19_ = line;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp20_ = c;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			g_string_append_c (_tmp19_, (gchar) _tmp20_);
#line 480 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp21_ = end_offset;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			end_offset = _tmp21_ + 1;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp22_ = c;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			if (_tmp22_ == ((guint8) '\n')) {
#line 482 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				break;
#line 2972 "simple-scan.c"
			}
		}
#line 485 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp23_ = line;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp24_ = _tmp23_->str;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (g_strcmp0 (_tmp24_, "startxref\n") == 0) {
#line 2981 "simple-scan.c"
			gint _tmp25_;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp25_ = line_number;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			xref_line = _tmp25_;
#line 2987 "simple-scan.c"
		}
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp27_ = line_number;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_tmp27_ < 2) {
#line 2993 "simple-scan.c"
			GString* _tmp28_;
			const gchar* _tmp29_;
			gboolean _tmp30_ = FALSE;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp28_ = line;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp29_ = _tmp28_->str;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp30_ = g_str_has_prefix (_tmp29_, "%%");
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp26_ = _tmp30_;
#line 3005 "simple-scan.c"
		} else {
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp26_ = FALSE;
#line 3009 "simple-scan.c"
		}
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp31_ = _tmp26_;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_tmp31_) {
#line 3015 "simple-scan.c"
			gint _tmp32_;
			FILE* _tmp33_;
			GString* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp32_ = xref_offset;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			xref_offset = _tmp32_ - 1;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp33_ = fixed_file;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp34_ = line;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp35_ = _tmp34_->str;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp36_ = string_substring (_tmp35_, (glong) 1, (glong) (-1));
#line 492 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp37_ = _tmp36_;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			fprintf (_tmp33_, "%s", _tmp37_);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_free0 (_tmp37_);
#line 3040 "simple-scan.c"
		} else {
			GRegex* _tmp38_;
			GString* _tmp39_;
			const gchar* _tmp40_;
			GMatchInfo* _tmp41_ = NULL;
			gboolean _tmp42_ = FALSE;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp38_ = xref_regex;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp39_ = line;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp40_ = _tmp39_->str;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp42_ = g_regex_match (_tmp38_, _tmp40_, 0, &_tmp41_);
#line 496 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_match_info_free0 (xref_match);
#line 496 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			xref_match = _tmp41_;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			if (_tmp42_) {
#line 3061 "simple-scan.c"
				FILE* _tmp43_;
				GMatchInfo* _tmp44_;
				const gchar* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				gint _tmp47_;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp43_ = fixed_file;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp44_ = xref_match;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp45_ = g_match_info_get_string (_tmp44_);
#line 497 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp46_ = atoi (_tmp45_);
#line 497 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp47_ = xref_offset;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				fprintf (_tmp43_, "%010d 00000 n \n", _tmp46_ + _tmp47_);
#line 3079 "simple-scan.c"
			} else {
				gboolean _tmp48_ = FALSE;
				gint _tmp49_;
				gboolean _tmp52_;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp49_ = xref_line;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				if (_tmp49_ > 0) {
#line 3088 "simple-scan.c"
					gint _tmp50_;
					gint _tmp51_;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp50_ = line_number;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp51_ = xref_line;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp48_ = _tmp50_ == (_tmp51_ + 1);
#line 3097 "simple-scan.c"
				} else {
#line 500 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp48_ = FALSE;
#line 3101 "simple-scan.c"
				}
#line 500 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				_tmp52_ = _tmp48_;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				if (_tmp52_) {
#line 3107 "simple-scan.c"
					FILE* _tmp53_;
					GString* _tmp54_;
					const gchar* _tmp55_;
					gint _tmp56_ = 0;
					gint _tmp57_;
					gchar* _tmp58_ = NULL;
					gchar* _tmp59_;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp53_ = fixed_file;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp54_ = line;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp55_ = _tmp54_->str;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp56_ = atoi (_tmp55_);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp57_ = xref_offset;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp58_ = g_strdup_printf ("%d\n", _tmp56_ + _tmp57_);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp59_ = _tmp58_;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					fprintf (_tmp53_, "%s", _tmp59_);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_g_free0 (_tmp59_);
#line 3133 "simple-scan.c"
				} else {
					gboolean _tmp60_ = FALSE;
					gint _tmp61_;
					gint _tmp62_;
					gboolean _tmp66_;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp61_ = line_number;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp62_ = xref_line;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					if (_tmp61_ == (_tmp62_ + 2)) {
#line 3145 "simple-scan.c"
						GString* _tmp63_;
						const gchar* _tmp64_;
						gboolean _tmp65_ = FALSE;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp63_ = line;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp64_ = _tmp63_->str;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp65_ = g_str_has_prefix (_tmp64_, "%%%%");
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp60_ = _tmp65_;
#line 3157 "simple-scan.c"
					} else {
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp60_ = FALSE;
#line 3161 "simple-scan.c"
					}
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp66_ = _tmp60_;
#line 504 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					if (_tmp66_) {
#line 3167 "simple-scan.c"
						FILE* _tmp67_;
						GString* _tmp68_;
						const gchar* _tmp69_;
						gchar* _tmp70_ = NULL;
						gchar* _tmp71_;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp67_ = fixed_file;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp68_ = line;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp69_ = _tmp68_->str;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp70_ = string_substring (_tmp69_, (glong) 2, (glong) (-1));
#line 505 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp71_ = _tmp70_;
#line 505 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						fprintf (_tmp67_, "%s", _tmp71_);
#line 505 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_g_free0 (_tmp71_);
#line 3187 "simple-scan.c"
					} else {
						{
							gint _tmp72_;
							gint i;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
							_tmp72_ = offset;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
							i = _tmp72_;
#line 3196 "simple-scan.c"
							{
								gboolean _tmp73_;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
								_tmp73_ = TRUE;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
								while (TRUE) {
#line 3203 "simple-scan.c"
									gboolean _tmp74_;
									gint _tmp76_;
									gint _tmp77_;
									FILE* _tmp78_;
									guint8* _tmp79_;
									gint _tmp79__length1;
									gint _tmp80_;
									guint8 _tmp81_;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp74_ = _tmp73_;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									if (!_tmp74_) {
#line 3216 "simple-scan.c"
										gint _tmp75_;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
										_tmp75_ = i;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
										i = _tmp75_ + 1;
#line 3222 "simple-scan.c"
									}
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp73_ = FALSE;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp76_ = i;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp77_ = end_offset;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									if (!(_tmp76_ < _tmp77_)) {
#line 508 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
										break;
#line 3234 "simple-scan.c"
									}
#line 509 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp78_ = fixed_file;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp79_ = data;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp79__length1 = data_length1;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp80_ = i;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									_tmp81_ = _tmp79_[_tmp80_];
#line 509 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
									fputc ((gchar) _tmp81_, _tmp78_);
#line 3248 "simple-scan.c"
								}
							}
						}
					}
				}
			}
		}
#line 511 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp82_ = line_number;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		line_number = _tmp82_ + 1;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp83_ = end_offset;
#line 512 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		offset = _tmp83_;
#line 3264 "simple-scan.c"
	}
#line 515 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp84_ = filename;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp85_ = filename;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp86_ = g_strconcat (_tmp85_, "~", NULL);
#line 515 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp87_ = _tmp86_;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp88_ = g_rename (_tmp84_, _tmp87_);
#line 515 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp89_ = _tmp88_ >= 0;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (_tmp87_);
#line 515 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp89_) {
#line 3282 "simple-scan.c"
		const gchar* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		const gchar* _tmp93_;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp90_ = filename;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp91_ = g_strconcat (_tmp90_, ".fixed", NULL);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp92_ = _tmp91_;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp93_ = filename;
#line 516 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_rename (_tmp92_, _tmp93_);
#line 516 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (_tmp92_);
#line 3299 "simple-scan.c"
	}
#line 458 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_string_free0 (line);
#line 458 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_match_info_free0 (xref_match);
#line 458 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_regex_unref0 (xref_regex);
#line 458 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_fclose0 (fixed_file);
#line 458 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 3311 "simple-scan.c"
}


static void _simple_scan_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
#line 580 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_log_cb (log_domain, log_levels, message);
#line 3318 "simple-scan.c"
}


gint simple_scan_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionContext* c;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_;
	const gchar* _tmp16_;
	ScanDevice* device;
	gchar** _tmp29_;
	gint _tmp29__length1;
	GTimer* _tmp39_;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* path;
	const gchar* _tmp42_;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_;
	FILE* _tmp46_ = NULL;
	pid_t _tmp47_ = 0;
	ScanDevice* _tmp48_;
	SimpleScan* _tmp49_;
	SimpleScan* app;
	SimpleScan* _tmp50_;
	gint _tmp51_ = 0;
	GError * _inner_error_ = NULL;
#line 521 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	setlocale (LC_ALL, "");
#line 522 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
#line 523 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 524 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	textdomain (GETTEXT_PACKAGE);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	gtk_init (&args_length1, &args);
#line 528 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp0_ = _ ("[DEVICE...] - Scanning utility");
#line 528 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp1_ = g_option_context_new (_tmp0_);
#line 528 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	c = _tmp1_;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp2_ = c;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_option_context_add_main_entries (_tmp2_, SIMPLE_SCAN_options, GETTEXT_PACKAGE);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp3_ = c;
#line 531 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp4_ = gtk_get_option_group (TRUE);
#line 531 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 3377 "simple-scan.c"
	{
		GOptionContext* _tmp5_;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp5_ = c;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 534 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 3386 "simple-scan.c"
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		FILE* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		FILE* _tmp13_;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		e = _inner_error_;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp6_ = stderr;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp7_ = e;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp8_ = _tmp7_->message;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 539 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp9_ = stderr;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
#line 539 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp11_ = args;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp11__length1 = args_length1;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp12_ = _tmp11_[0];
#line 539 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		fprintf (_tmp9_, _tmp10_, _tmp12_);
#line 541 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp13_ = stderr;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		fprintf (_tmp13_, "\n");
#line 542 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = EXIT_FAILURE;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_error_free0 (e);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 3439 "simple-scan.c"
	}
	__finally12:
#line 532 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_inner_error_ != NULL) {
#line 532 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 532 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 532 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 532 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return 0;
#line 3452 "simple-scan.c"
	}
#line 544 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp14_ = simple_scan_show_version;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp14_) {
#line 3458 "simple-scan.c"
		FILE* _tmp15_;
#line 547 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp15_ = stderr;
#line 547 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		fprintf (_tmp15_, "simple-scan %s\n", VERSION);
#line 548 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 548 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 3470 "simple-scan.c"
	}
#line 550 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp16_ = simple_scan_fix_pdf_filename;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp16_ != NULL) {
#line 3476 "simple-scan.c"
		{
			const gchar* _tmp17_;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp17_ = simple_scan_fix_pdf_filename;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			simple_scan_fix_pdf (_tmp17_, &_inner_error_);
#line 554 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			if (_inner_error_ != NULL) {
#line 3485 "simple-scan.c"
				goto __catch13_g_error;
			}
			{
				gint i;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
				i = 1;
#line 3492 "simple-scan.c"
				{
					gboolean _tmp18_;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					_tmp18_ = TRUE;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
					while (TRUE) {
#line 3499 "simple-scan.c"
						gboolean _tmp19_;
						gint _tmp21_;
						gchar** _tmp22_;
						gint _tmp22__length1;
						gchar** _tmp23_;
						gint _tmp23__length1;
						gint _tmp24_;
						const gchar* _tmp25_;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp19_ = _tmp18_;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						if (!_tmp19_) {
#line 3512 "simple-scan.c"
							gint _tmp20_;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
							_tmp20_ = i;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
							i = _tmp20_ + 1;
#line 3518 "simple-scan.c"
						}
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp18_ = FALSE;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp21_ = i;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp22_ = args;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp22__length1 = args_length1;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						if (!(_tmp21_ < _tmp22__length1)) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
							break;
#line 3532 "simple-scan.c"
						}
#line 556 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp23_ = args;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp23__length1 = args_length1;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp24_ = i;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						_tmp25_ = _tmp23_[_tmp24_];
#line 556 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						simple_scan_fix_pdf (_tmp25_, &_inner_error_);
#line 556 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
						if (_inner_error_ != NULL) {
#line 3546 "simple-scan.c"
							goto __catch13_g_error;
						}
					}
				}
			}
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			e = _inner_error_;
#line 552 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_inner_error_ = NULL;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp26_ = stderr;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp27_ = e;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_tmp28_ = _tmp27_->message;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			fprintf (_tmp26_, "Error fixing PDF file: %s", _tmp28_);
#line 561 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			result = EXIT_FAILURE;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_error_free0 (e);
#line 561 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 561 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			return result;
#line 3580 "simple-scan.c"
		}
		__finally13:
#line 552 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		if (_inner_error_ != NULL) {
#line 552 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			g_clear_error (&_inner_error_);
#line 552 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
			return 0;
#line 3593 "simple-scan.c"
		}
#line 563 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 563 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 563 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		return result;
#line 3601 "simple-scan.c"
	}
#line 566 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	device = NULL;
#line 567 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp29_ = args;
#line 567 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp29__length1 = args_length1;
#line 567 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	if (_tmp29__length1 > 1) {
#line 3611 "simple-scan.c"
		ScanDevice* _tmp30_;
		ScanDevice* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		ScanDevice* _tmp35_;
		gchar** _tmp36_;
		gint _tmp36__length1;
		const gchar* _tmp37_;
		gchar* _tmp38_;
#line 569 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp30_ = scan_device_new ();
#line 569 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_scan_device_unref0 (device);
#line 569 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		device = _tmp30_;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp31_ = device;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp32_ = args;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp32__length1 = args_length1;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp33_ = _tmp32_[1];
#line 570 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp34_ = g_strdup (_tmp33_);
#line 570 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (_tmp31_->name);
#line 570 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp31_->name = _tmp34_;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp35_ = device;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp36_ = args;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp36__length1 = args_length1;
#line 571 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp37_ = _tmp36_[1];
#line 571 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp38_ = g_strdup (_tmp37_);
#line 571 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_g_free0 (_tmp35_->label);
#line 571 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
		_tmp35_->label = _tmp38_;
#line 3657 "simple-scan.c"
	}
#line 575 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp39_ = g_timer_new ();
#line 575 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_timer_destroy0 (simple_scan_log_timer);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_log_timer = _tmp39_;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp40_ = g_get_user_cache_dir ();
#line 576 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp41_ = g_build_filename (_tmp40_, "simple-scan", NULL, NULL);
#line 576 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	path = _tmp41_;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp42_ = path;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_mkdir_with_parents (_tmp42_, 0700);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp43_ = g_get_user_cache_dir ();
#line 578 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp44_ = g_build_filename (_tmp43_, "simple-scan", "simple-scan.log", NULL, NULL);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (path);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	path = _tmp44_;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp45_ = path;
#line 579 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp46_ = g_fopen (_tmp45_, "w");
#line 579 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_fclose0 (simple_scan_log_file);
#line 579 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_log_file = _tmp46_;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_log_set_default_handler (_simple_scan_log_cb_glog_func, NULL);
#line 582 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp47_ = getpid ();
#line 582 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_debug ("simple-scan.vala:582: Starting Simple Scan %s, PID=%i", VERSION, (gint) _tmp47_);
#line 584 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp48_ = device;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp49_ = simple_scan_new (_tmp48_);
#line 584 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	app = _tmp49_;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp50_ = app;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_tmp51_ = g_application_run ((GApplication*) _tmp50_, 0, NULL);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	result = _tmp51_;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_object_unref0 (app);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_free0 (path);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_scan_device_unref0 (device);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_option_context_free0 (c);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	return result;
#line 3719 "simple-scan.c"
}


int main (int argc, char ** argv) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_type_init ();
#line 519 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	return simple_scan_main (argv, argc);
#line 3728 "simple-scan.c"
}


static void simple_scan_class_init (SimpleScanClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	simple_scan_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	g_type_class_add_private (klass, sizeof (SimpleScanPrivate));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	G_APPLICATION_CLASS (klass)->startup = simple_scan_real_startup;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	G_APPLICATION_CLASS (klass)->activate = simple_scan_real_activate;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	G_APPLICATION_CLASS (klass)->shutdown = simple_scan_real_shutdown;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	G_OBJECT_CLASS (klass)->finalize = simple_scan_finalize;
#line 3745 "simple-scan.c"
}


static void simple_scan_instance_init (SimpleScan * self) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv = SIMPLE_SCAN_GET_PRIVATE (self);
#line 32 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->default_device = NULL;
#line 33 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self->priv->have_devices = FALSE;
#line 3756 "simple-scan.c"
}


static void simple_scan_finalize (GObject* obj) {
	SimpleScan * self;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SCAN, SimpleScan);
#line 32 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 34 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 35 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_user_interface_unref0 (self->priv->ui);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 37 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/simple-scan.vala"
	G_OBJECT_CLASS (simple_scan_parent_class)->finalize (obj);
#line 3776 "simple-scan.c"
}


GType simple_scan_get_type (void) {
	static volatile gsize simple_scan_type_id__volatile = 0;
	if (g_once_init_enter (&simple_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, NULL };
		GType simple_scan_type_id;
		simple_scan_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "SimpleScan", &g_define_type_info, 0);
		g_once_init_leave (&simple_scan_type_id__volatile, simple_scan_type_id);
	}
	return simple_scan_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



