/* page.c generated by valac 0.20.1, the Vala compiler
 * generated from page.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef struct _PagePrivate PagePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PIXBUF_WRITER (pixbuf_writer_get_type ())
#define PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_WRITER, PixbufWriter))
#define PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_WRITER, PixbufWriterClass))
#define IS_PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_WRITER))
#define IS_PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_WRITER))
#define PIXBUF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_WRITER, PixbufWriterClass))

typedef struct _PixbufWriter PixbufWriter;
typedef struct _PixbufWriterClass PixbufWriterClass;
#define _pixbuf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pixbuf_writer_unref (var), NULL)))
typedef struct _ParamSpecPage ParamSpecPage;
typedef struct _PixbufWriterPrivate PixbufWriterPrivate;
typedef struct _ParamSpecPixbufWriter ParamSpecPixbufWriter;

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _Page {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PagePrivate * priv;
};

struct _PageClass {
	GTypeClass parent_class;
	void (*finalize) (Page *self);
};

struct _PagePrivate {
	gint dpi;
	gint expected_rows;
	gint depth;
	gchar* color_profile;
	gint width;
	gint n_rows;
	gint rowstride;
	gint n_channels;
	guchar* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	gboolean scanning;
	gboolean has_data_;
	gint scan_line;
	ScanDirection scan_direction;
	gboolean has_crop_;
	gchar* crop_name;
	gint crop_x;
	gint crop_y;
	gint crop_width;
	gint crop_height;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecPage {
	GParamSpec parent_instance;
};

struct _PixbufWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixbufWriterPrivate * priv;
	GFileOutputStream* stream;
};

struct _PixbufWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PixbufWriter *self);
};

struct _ParamSpecPixbufWriter {
	GParamSpec parent_instance;
};


static gpointer page_parent_class = NULL;
static gpointer pixbuf_writer_parent_class = NULL;

GType scan_direction_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE, PagePrivate))
enum  {
	PAGE_DUMMY_PROPERTY
};
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_start (Page* self);
gboolean page_is_scanning (Page* self);
gboolean page_has_data (Page* self);
gboolean page_is_color (Page* self);
gint page_get_scan_line (Page* self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void page_parse_line (Page* self, ScanLine* line, gint n, gboolean* size_changed);
gint page_get_scan_height (Page* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
ScanDirection page_get_scan_direction (Page* self);
static void page_set_scan_direction (Page* self, ScanDirection direction);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
void page_rotate_left (Page* self);
void page_rotate_right (Page* self);
gint page_get_dpi (Page* self);
gboolean page_is_landscape (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_rowstride (Page* self);
gint page_get_scan_width (Page* self);
void page_set_color_profile (Page* self, const gchar* color_profile);
gchar* page_get_color_profile (Page* self);
void page_set_no_crop (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_set_named_crop (Page* self, const gchar* name);
void page_move_crop (Page* self, gint x, gint y);
void page_rotate_crop (Page* self);
gboolean page_has_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
gchar* page_get_named_crop (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
void page_set_pixels (Page* self, guchar* new_pixels, int new_pixels_length1);
static guchar* _vala_array_dup3 (guchar* self, int length);
static guchar page_get_sample (Page* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint n_channels, gint channel);
static void page_get_pixel (Page* self, gint x, gint y, guchar* pixel, int pixel_length1, gint offset);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
static gchar* page_get_icc_data_encoded (Page* self, const gchar* icc_profile_filename);
void page_copy_to_clipboard (Page* self, GtkWindow* window);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream);
PixbufWriter* pixbuf_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer pixbuf_writer_ref (gpointer instance);
void pixbuf_writer_unref (gpointer instance);
GParamSpec* param_spec_pixbuf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixbuf_writer (GValue* value, gpointer v_object);
void value_take_pixbuf_writer (GValue* value, gpointer v_object);
gpointer value_get_pixbuf_writer (const GValue* value);
GType pixbuf_writer_get_type (void) G_GNUC_CONST;
void pixbuf_writer_save (PixbufWriter* self, GdkPixbuf* image, const gchar* type, gchar** option_keys, int option_keys_length1, gchar** option_values, int option_values_length1, GError** error);
static void page_finalize (Page* obj);
enum  {
	PIXBUF_WRITER_DUMMY_PROPERTY
};
static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self, guint8* buf, int buf_length1, GError** error);
static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void pixbuf_writer_finalize (PixbufWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType scan_direction_get_type (void) {
	static volatile gsize scan_direction_type_id__volatile = 0;
	if (g_once_init_enter (&scan_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_DIRECTION_TOP_TO_BOTTOM, "SCAN_DIRECTION_TOP_TO_BOTTOM", "top-to-bottom"}, {SCAN_DIRECTION_LEFT_TO_RIGHT, "SCAN_DIRECTION_LEFT_TO_RIGHT", "left-to-right"}, {SCAN_DIRECTION_BOTTOM_TO_TOP, "SCAN_DIRECTION_BOTTOM_TO_TOP", "bottom-to-top"}, {SCAN_DIRECTION_RIGHT_TO_LEFT, "SCAN_DIRECTION_RIGHT_TO_LEFT", "right-to-left"}, {0, NULL, NULL}};
		GType scan_direction_type_id;
		scan_direction_type_id = g_enum_register_static ("ScanDirection", values);
		g_once_init_leave (&scan_direction_type_id__volatile, scan_direction_type_id);
	}
	return scan_direction_type_id__volatile;
}


Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction) {
	Page* self = NULL;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	gboolean _tmp3_;
	gint _tmp8_;
	ScanDirection _tmp9_;
	self = (Page*) g_type_create_instance (object_type);
	_tmp1_ = scan_direction;
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
		_tmp0_ = TRUE;
	} else {
		ScanDirection _tmp2_;
		_tmp2_ = scan_direction;
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = width;
		self->priv->width = _tmp4_;
		_tmp5_ = height;
		self->priv->n_rows = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = height;
		self->priv->width = _tmp6_;
		_tmp7_ = width;
		self->priv->n_rows = _tmp7_;
	}
	_tmp8_ = dpi;
	self->priv->dpi = _tmp8_;
	_tmp9_ = scan_direction;
	self->priv->scan_direction = _tmp9_;
	return self;
}


Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction) {
	return page_construct (TYPE_PAGE, width, height, dpi, scan_direction);
}


void page_set_page_info (Page* self, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_;
	gint _tmp1_;
	ScanPageInfo* _tmp2_;
	gdouble _tmp3_;
	ScanPageInfo* _tmp4_;
	gint _tmp5_;
	ScanPageInfo* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	ScanPageInfo* _tmp10_;
	gint _tmp11_;
	ScanPageInfo* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_ = 0;
	guchar* _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = _tmp0_->height;
	self->priv->expected_rows = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = _tmp2_->dpi;
	self->priv->dpi = (gint) _tmp3_;
	_tmp4_ = info;
	_tmp5_ = _tmp4_->width;
	self->priv->width = _tmp5_;
	_tmp6_ = info;
	_tmp7_ = _tmp6_->height;
	self->priv->n_rows = _tmp7_;
	_tmp8_ = self->priv->n_rows;
	if (_tmp8_ < 0) {
		gint _tmp9_;
		_tmp9_ = self->priv->width;
		self->priv->n_rows = _tmp9_ / 2;
	}
	_tmp10_ = info;
	_tmp11_ = _tmp10_->depth;
	self->priv->depth = _tmp11_;
	_tmp12_ = info;
	_tmp13_ = _tmp12_->n_channels;
	self->priv->n_channels = _tmp13_;
	_tmp14_ = self->priv->width;
	_tmp15_ = self->priv->depth;
	_tmp16_ = self->priv->n_channels;
	self->priv->rowstride = (((_tmp14_ * _tmp15_) * _tmp16_) + 7) / 8;
	_tmp17_ = self->priv->n_rows;
	_tmp18_ = self->priv->rowstride;
	_tmp19_ = _tmp17_ * _tmp18_;
	self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp17_ * _tmp18_);
	(_tmp19_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp19_ - self->priv->pixels_length1)) : NULL;
	self->priv->pixels_length1 = _tmp19_;
	self->priv->_pixels_size_ = _tmp19_;
	_tmp20_ = self->priv->pixels;
	_tmp20__length1 = self->priv->pixels_length1;
	g_return_if_fail (_tmp20_ != NULL);
	_tmp21_ = self->priv->depth;
	if (_tmp21_ == 1) {
		guchar* _tmp22_;
		gint _tmp22__length1;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = self->priv->pixels;
		_tmp22__length1 = self->priv->pixels_length1;
		_tmp23_ = self->priv->n_rows;
		_tmp24_ = self->priv->rowstride;
		memset (_tmp22_, 0x00, (gsize) (_tmp23_ * _tmp24_));
	} else {
		guchar* _tmp25_;
		gint _tmp25__length1;
		gint _tmp26_;
		gint _tmp27_;
		_tmp25_ = self->priv->pixels;
		_tmp25__length1 = self->priv->pixels_length1;
		_tmp26_ = self->priv->n_rows;
		_tmp27_ = self->priv->rowstride;
		memset (_tmp25_, 0xFF, (gsize) (_tmp26_ * _tmp27_));
	}
	g_signal_emit_by_name (self, "size-changed");
	g_signal_emit_by_name (self, "pixels-changed");
}


void page_start (Page* self) {
	g_return_if_fail (self != NULL);
	self->priv->scanning = TRUE;
	g_signal_emit_by_name (self, "scan-line-changed");
}


gboolean page_is_scanning (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->scanning;
	result = _tmp0_;
	return result;
}


gboolean page_has_data (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->has_data_;
	result = _tmp0_;
	return result;
}


gboolean page_is_color (Page* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->n_channels;
	result = _tmp0_ > 1;
	return result;
}


gint page_get_scan_line (Page* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->scan_line;
	result = _tmp0_;
	return result;
}


static void page_parse_line (Page* self, ScanLine* line, gint n, gboolean* size_changed) {
	gboolean _vala_size_changed = FALSE;
	gint line_number = 0;
	ScanLine* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp13_;
	gint _tmp14_;
	gint offset;
	gint _tmp15_;
	ScanLine* _tmp16_;
	gint _tmp17_;
	gint line_offset;
	gint _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = line;
	_tmp1_ = _tmp0_->number;
	_tmp2_ = n;
	line_number = _tmp1_ + _tmp2_;
	_vala_size_changed = FALSE;
	while (TRUE) {
		gint _tmp3_;
		gint _tmp4_ = 0;
		gint rows = 0;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_ = 0;
		_tmp3_ = line_number;
		_tmp4_ = page_get_scan_height (self);
		if (!(_tmp3_ >= _tmp4_)) {
			break;
		}
		_tmp5_ = self->priv->n_rows;
		rows = _tmp5_;
		_tmp6_ = rows;
		_tmp7_ = self->priv->width;
		self->priv->n_rows = _tmp6_ + (_tmp7_ / 2);
		_tmp8_ = rows;
		_tmp9_ = self->priv->n_rows;
		g_debug ("page.vala:152: Extending image from %d lines to %d lines", _tmp8_, _tmp9_);
		_tmp10_ = self->priv->n_rows;
		_tmp11_ = self->priv->rowstride;
		_tmp12_ = _tmp10_ * _tmp11_;
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp10_ * _tmp11_);
		(_tmp12_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp12_ - self->priv->pixels_length1)) : NULL;
		self->priv->pixels_length1 = _tmp12_;
		self->priv->_pixels_size_ = _tmp12_;
		_vala_size_changed = TRUE;
	}
	_tmp13_ = line_number;
	_tmp14_ = self->priv->rowstride;
	offset = _tmp13_ * _tmp14_;
	_tmp15_ = n;
	_tmp16_ = line;
	_tmp17_ = _tmp16_->data_length;
	line_offset = _tmp15_ * _tmp17_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp18_;
			_tmp18_ = TRUE;
			while (TRUE) {
				gboolean _tmp19_;
				gint _tmp21_;
				ScanLine* _tmp22_;
				gint _tmp23_;
				guchar* _tmp24_;
				gint _tmp24__length1;
				gint _tmp25_;
				gint _tmp26_;
				ScanLine* _tmp27_;
				guchar* _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				gint _tmp30_;
				guchar _tmp31_;
				guchar _tmp32_;
				_tmp19_ = _tmp18_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp21_ = i;
				_tmp22_ = line;
				_tmp23_ = _tmp22_->data_length;
				if (!(_tmp21_ < _tmp23_)) {
					break;
				}
				_tmp24_ = self->priv->pixels;
				_tmp24__length1 = self->priv->pixels_length1;
				_tmp25_ = offset;
				_tmp26_ = i;
				_tmp27_ = line;
				_tmp28_ = _tmp27_->data;
				_tmp28__length1 = _tmp27_->data_length1;
				_tmp29_ = line_offset;
				_tmp30_ = i;
				_tmp31_ = _tmp28_[_tmp29_ + _tmp30_];
				_tmp24_[_tmp25_ + _tmp26_] = _tmp31_;
				_tmp32_ = _tmp24_[_tmp25_ + _tmp26_];
			}
		}
	}
	_tmp33_ = line_number;
	self->priv->scan_line = _tmp33_;
	if (size_changed) {
		*size_changed = _vala_size_changed;
	}
}


void page_parse_scan_line (Page* self, ScanLine* line) {
	gboolean size_has_changed;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	size_has_changed = FALSE;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				ScanLine* _tmp4_;
				gint _tmp5_;
				ScanLine* _tmp6_;
				gint _tmp7_;
				gboolean _tmp8_ = FALSE;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = line;
				_tmp5_ = _tmp4_->n_lines;
				if (!(_tmp3_ < _tmp5_)) {
					break;
				}
				_tmp6_ = line;
				_tmp7_ = i;
				page_parse_line (self, _tmp6_, _tmp7_, &_tmp8_);
				size_has_changed = _tmp8_;
			}
		}
	}
	self->priv->has_data_ = TRUE;
	_tmp9_ = size_has_changed;
	if (_tmp9_) {
		g_signal_emit_by_name (self, "size-changed");
	}
	g_signal_emit_by_name (self, "scan-line-changed");
	g_signal_emit_by_name (self, "pixels-changed");
}


void page_finish (Page* self) {
	gboolean size_has_changed;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	size_has_changed = FALSE;
	_tmp1_ = self->priv->expected_rows;
	if (_tmp1_ < 0) {
		gint _tmp2_;
		gint _tmp3_ = 0;
		_tmp2_ = self->priv->scan_line;
		_tmp3_ = page_get_scan_height (self);
		_tmp0_ = _tmp2_ != _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gint rows = 0;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_ = 0;
		gint _tmp10_;
		gint _tmp11_;
		_tmp5_ = self->priv->n_rows;
		rows = _tmp5_;
		_tmp6_ = self->priv->scan_line;
		self->priv->n_rows = _tmp6_;
		_tmp7_ = self->priv->n_rows;
		_tmp8_ = self->priv->rowstride;
		_tmp9_ = _tmp7_ * _tmp8_;
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp7_ * _tmp8_);
		(_tmp9_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp9_ - self->priv->pixels_length1)) : NULL;
		self->priv->pixels_length1 = _tmp9_;
		self->priv->_pixels_size_ = _tmp9_;
		_tmp10_ = rows;
		_tmp11_ = self->priv->n_rows;
		g_debug ("page.vala:194: Trimming page from %d lines to %d lines", _tmp10_, _tmp11_);
		size_has_changed = TRUE;
	}
	self->priv->scanning = FALSE;
	_tmp12_ = size_has_changed;
	if (_tmp12_) {
		g_signal_emit_by_name (self, "size-changed");
	}
	g_signal_emit_by_name (self, "scan-line-changed");
	g_signal_emit_by_name (self, "scan-finished");
}


ScanDirection page_get_scan_direction (Page* self) {
	ScanDirection result = 0;
	ScanDirection _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->scan_direction;
	result = _tmp0_;
	return result;
}


static void page_set_scan_direction (Page* self, ScanDirection direction) {
	gint left_steps = 0;
	gint t = 0;
	gboolean size_has_changed;
	gint width = 0;
	gint height = 0;
	ScanDirection _tmp0_;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
	ScanDirection _tmp3_;
	gint _tmp4_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_;
	ScanDirection _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	g_return_if_fail (self != NULL);
	size_has_changed = FALSE;
	_tmp0_ = self->priv->scan_direction;
	_tmp1_ = direction;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = direction;
	_tmp3_ = self->priv->scan_direction;
	left_steps = (gint) (_tmp2_ - _tmp3_);
	_tmp4_ = left_steps;
	if (_tmp4_ < 0) {
		gint _tmp5_;
		_tmp5_ = left_steps;
		left_steps = _tmp5_ + 4;
	}
	_tmp6_ = left_steps;
	if (_tmp6_ != 2) {
		size_has_changed = TRUE;
	}
	_tmp7_ = page_get_width (self);
	width = _tmp7_;
	_tmp8_ = page_get_height (self);
	height = _tmp8_;
	_tmp9_ = self->priv->has_crop_;
	if (_tmp9_) {
		gint _tmp10_;
		_tmp10_ = left_steps;
		switch (_tmp10_) {
			case 1:
			{
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				_tmp11_ = self->priv->crop_x;
				t = _tmp11_;
				_tmp12_ = self->priv->crop_y;
				self->priv->crop_x = _tmp12_;
				_tmp13_ = width;
				_tmp14_ = t;
				_tmp15_ = self->priv->crop_width;
				self->priv->crop_y = _tmp13_ - (_tmp14_ + _tmp15_);
				_tmp16_ = self->priv->crop_width;
				t = _tmp16_;
				_tmp17_ = self->priv->crop_height;
				self->priv->crop_width = _tmp17_;
				_tmp18_ = t;
				self->priv->crop_height = _tmp18_;
				break;
			}
			case 2:
			{
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_tmp19_ = width;
				_tmp20_ = self->priv->crop_x;
				_tmp21_ = self->priv->crop_width;
				self->priv->crop_x = _tmp19_ - (_tmp20_ + _tmp21_);
				_tmp22_ = width;
				_tmp23_ = self->priv->crop_y;
				_tmp24_ = self->priv->crop_height;
				self->priv->crop_y = _tmp22_ - (_tmp23_ + _tmp24_);
				break;
			}
			case 3:
			{
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				_tmp25_ = self->priv->crop_y;
				t = _tmp25_;
				_tmp26_ = self->priv->crop_x;
				self->priv->crop_y = _tmp26_;
				_tmp27_ = height;
				_tmp28_ = t;
				_tmp29_ = self->priv->crop_height;
				self->priv->crop_x = _tmp27_ - (_tmp28_ + _tmp29_);
				_tmp30_ = self->priv->crop_width;
				t = _tmp30_;
				_tmp31_ = self->priv->crop_height;
				self->priv->crop_width = _tmp31_;
				_tmp32_ = t;
				self->priv->crop_height = _tmp32_;
				break;
			}
			default:
			break;
		}
	}
	_tmp33_ = direction;
	self->priv->scan_direction = _tmp33_;
	_tmp34_ = size_has_changed;
	if (_tmp34_) {
		g_signal_emit_by_name (self, "size-changed");
	}
	g_signal_emit_by_name (self, "scan-direction-changed");
	_tmp35_ = self->priv->has_crop_;
	if (_tmp35_) {
		g_signal_emit_by_name (self, "crop-changed");
	}
}


void page_rotate_left (Page* self) {
	ScanDirection _tmp0_;
	ScanDirection direction;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_direction;
	direction = _tmp0_;
	_tmp1_ = direction;
	switch (_tmp1_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
			break;
		}
		default:
		break;
	}
	_tmp2_ = direction;
	page_set_scan_direction (self, _tmp2_);
}


void page_rotate_right (Page* self) {
	ScanDirection _tmp0_;
	ScanDirection direction;
	ScanDirection _tmp1_;
	ScanDirection _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_direction;
	direction = _tmp0_;
	_tmp1_ = direction;
	switch (_tmp1_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
			break;
		}
		default:
		break;
	}
	_tmp2_ = direction;
	page_set_scan_direction (self, _tmp2_);
}


gint page_get_dpi (Page* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->dpi;
	result = _tmp0_;
	return result;
}


gboolean page_is_landscape (Page* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = page_get_width (self);
	_tmp1_ = page_get_height (self);
	result = _tmp0_ > _tmp1_;
	return result;
}


gint page_get_width (Page* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->scan_direction;
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
		_tmp0_ = TRUE;
	} else {
		ScanDirection _tmp2_;
		_tmp2_ = self->priv->scan_direction;
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gint _tmp4_;
		_tmp4_ = self->priv->width;
		result = _tmp4_;
		return result;
	} else {
		gint _tmp5_;
		_tmp5_ = self->priv->n_rows;
		result = _tmp5_;
		return result;
	}
}


gint page_get_height (Page* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->scan_direction;
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
		_tmp0_ = TRUE;
	} else {
		ScanDirection _tmp2_;
		_tmp2_ = self->priv->scan_direction;
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gint _tmp4_;
		_tmp4_ = self->priv->n_rows;
		result = _tmp4_;
		return result;
	} else {
		gint _tmp5_;
		_tmp5_ = self->priv->width;
		result = _tmp5_;
		return result;
	}
}


gint page_get_depth (Page* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->depth;
	result = _tmp0_;
	return result;
}


gint page_get_n_channels (Page* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->n_channels;
	result = _tmp0_;
	return result;
}


gint page_get_rowstride (Page* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->rowstride;
	result = _tmp0_;
	return result;
}


gint page_get_scan_width (Page* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->width;
	result = _tmp0_;
	return result;
}


gint page_get_scan_height (Page* self) {
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->n_rows;
	result = _tmp0_;
	return result;
}


void page_set_color_profile (Page* self, const gchar* color_profile) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = color_profile;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->color_profile);
	self->priv->color_profile = _tmp1_;
}


gchar* page_get_color_profile (Page* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->color_profile;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void page_set_no_crop (Page* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->has_crop_;
	if (!_tmp0_) {
		return;
	}
	self->priv->has_crop_ = FALSE;
	g_signal_emit_by_name (self, "crop-changed");
}


void page_set_custom_crop (Page* self, gint width, gint height) {
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = width;
	g_return_if_fail (_tmp0_ >= 1);
	_tmp1_ = height;
	g_return_if_fail (_tmp1_ >= 1);
	_tmp5_ = self->priv->crop_name;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_;
		_tmp6_ = self->priv->has_crop_;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = self->priv->crop_width;
		_tmp9_ = width;
		_tmp3_ = _tmp8_ == _tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = _tmp3_;
	if (_tmp10_) {
		gint _tmp11_;
		gint _tmp12_;
		_tmp11_ = self->priv->crop_height;
		_tmp12_ = height;
		_tmp2_ = _tmp11_ == _tmp12_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp13_ = _tmp2_;
	if (_tmp13_) {
		return;
	}
	_g_free0 (self->priv->crop_name);
	self->priv->crop_name = NULL;
	self->priv->has_crop_ = TRUE;
	_tmp14_ = width;
	self->priv->crop_width = _tmp14_;
	_tmp15_ = height;
	self->priv->crop_height = _tmp15_;
	g_signal_emit_by_name (self, "crop-changed");
}


void page_set_named_crop (Page* self, const gchar* name) {
	gdouble width = 0.0;
	gdouble height = 0.0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_ = 0;
	gint pw;
	gint _tmp8_ = 0;
	gint ph;
	gint _tmp9_;
	gint _tmp10_;
	gdouble _tmp14_;
	gint _tmp15_;
	gdouble _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp22_;
	gint _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("A4")))) {
		switch (0) {
			default:
			{
				width = 8.3;
				height = 11.7;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("A5")))) {
		switch (0) {
			default:
			{
				width = 5.8;
				height = 8.3;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("A6")))) {
		switch (0) {
			default:
			{
				width = 4.1;
				height = 5.8;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("letter")))) {
		switch (0) {
			default:
			{
				width = 8.5;
				height = (gdouble) 11;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("legal")))) {
		switch (0) {
			default:
			{
				width = 8.5;
				height = (gdouble) 14;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("4x6")))) {
		switch (0) {
			default:
			{
				width = (gdouble) 4;
				height = (gdouble) 6;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp4_;
				_tmp4_ = name;
				g_warning ("page.vala:439: Unknown paper size '%s'", _tmp4_);
				return;
			}
		}
	}
	_tmp5_ = name;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->crop_name);
	self->priv->crop_name = _tmp6_;
	self->priv->has_crop_ = TRUE;
	_tmp7_ = page_get_width (self);
	pw = _tmp7_;
	_tmp8_ = page_get_height (self);
	ph = _tmp8_;
	_tmp9_ = pw;
	_tmp10_ = ph;
	if (_tmp9_ > _tmp10_) {
		gdouble t = 0.0;
		gdouble _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		_tmp11_ = width;
		t = _tmp11_;
		_tmp12_ = height;
		width = _tmp12_;
		_tmp13_ = t;
		height = _tmp13_;
	}
	_tmp14_ = width;
	_tmp15_ = self->priv->dpi;
	self->priv->crop_width = (gint) ((_tmp14_ * _tmp15_) + 0.5);
	_tmp16_ = height;
	_tmp17_ = self->priv->dpi;
	self->priv->crop_height = (gint) ((_tmp16_ * _tmp17_) + 0.5);
	_tmp18_ = self->priv->crop_width;
	_tmp19_ = pw;
	if (_tmp18_ < _tmp19_) {
		gint _tmp20_;
		gint _tmp21_;
		_tmp20_ = pw;
		_tmp21_ = self->priv->crop_width;
		self->priv->crop_x = (_tmp20_ - _tmp21_) / 2;
	} else {
		self->priv->crop_x = 0;
	}
	_tmp22_ = self->priv->crop_height;
	_tmp23_ = ph;
	if (_tmp22_ < _tmp23_) {
		gint _tmp24_;
		gint _tmp25_;
		_tmp24_ = ph;
		_tmp25_ = self->priv->crop_height;
		self->priv->crop_y = (_tmp24_ - _tmp25_) / 2;
	} else {
		self->priv->crop_y = 0;
	}
	g_signal_emit_by_name (self, "crop-changed");
}


void page_move_crop (Page* self, gint x, gint y) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	g_return_if_fail (_tmp0_ >= 0);
	_tmp1_ = y;
	g_return_if_fail (_tmp1_ >= 0);
	_tmp2_ = x;
	_tmp3_ = page_get_width (self);
	g_return_if_fail (_tmp2_ < _tmp3_);
	_tmp4_ = y;
	_tmp5_ = page_get_height (self);
	g_return_if_fail (_tmp4_ < _tmp5_);
	_tmp6_ = x;
	self->priv->crop_x = _tmp6_;
	_tmp7_ = y;
	self->priv->crop_y = _tmp7_;
	g_signal_emit_by_name (self, "crop-changed");
}


void page_rotate_crop (Page* self) {
	gint t = 0;
	gboolean _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->has_crop_;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->crop_width;
	t = _tmp1_;
	_tmp2_ = self->priv->crop_height;
	self->priv->crop_width = _tmp2_;
	_tmp3_ = t;
	self->priv->crop_height = _tmp3_;
	_tmp4_ = self->priv->crop_name;
	if (_tmp4_ == NULL) {
		gint w = 0;
		gint h = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp12_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp19_;
		_tmp5_ = page_get_width (self);
		w = _tmp5_;
		_tmp6_ = page_get_height (self);
		h = _tmp6_;
		_tmp7_ = self->priv->crop_x;
		_tmp8_ = self->priv->crop_width;
		_tmp9_ = w;
		if ((_tmp7_ + _tmp8_) > _tmp9_) {
			gint _tmp10_;
			gint _tmp11_;
			_tmp10_ = w;
			_tmp11_ = self->priv->crop_width;
			self->priv->crop_x = _tmp10_ - _tmp11_;
		}
		_tmp12_ = self->priv->crop_x;
		if (_tmp12_ < 0) {
			gint _tmp13_;
			self->priv->crop_x = 0;
			_tmp13_ = w;
			self->priv->crop_width = _tmp13_;
		}
		_tmp14_ = self->priv->crop_y;
		_tmp15_ = self->priv->crop_height;
		_tmp16_ = h;
		if ((_tmp14_ + _tmp15_) > _tmp16_) {
			gint _tmp17_;
			gint _tmp18_;
			_tmp17_ = h;
			_tmp18_ = self->priv->crop_height;
			self->priv->crop_y = _tmp17_ - _tmp18_;
		}
		_tmp19_ = self->priv->crop_y;
		if (_tmp19_ < 0) {
			gint _tmp20_;
			self->priv->crop_y = 0;
			_tmp20_ = h;
			self->priv->crop_height = _tmp20_;
		}
	}
	g_signal_emit_by_name (self, "crop-changed");
}


gboolean page_has_crop (Page* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->has_crop_;
	result = _tmp0_;
	return result;
}


void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_x;
	_vala_x = _tmp0_;
	_tmp1_ = self->priv->crop_y;
	_vala_y = _tmp1_;
	_tmp2_ = self->priv->crop_width;
	_vala_width = _tmp2_;
	_tmp3_ = self->priv->crop_height;
	_vala_height = _tmp3_;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}


gchar* page_get_named_crop (Page* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->crop_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


guchar* page_get_pixels (Page* self, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pixels;
	_tmp0__length1 = self->priv->pixels_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static guchar* _vala_array_dup3 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


void page_set_pixels (Page* self, guchar* new_pixels, int new_pixels_length1) {
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
	guchar* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_pixels;
	_tmp0__length1 = new_pixels_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
	self->priv->pixels = _tmp1_;
	self->priv->pixels_length1 = _tmp1__length1;
	self->priv->_pixels_size_ = self->priv->pixels_length1;
	_tmp2_ = new_pixels;
	_tmp2__length1 = new_pixels_length1;
	self->priv->has_data_ = _tmp2_ != NULL;
	g_signal_emit_by_name (self, "pixels-changed");
}


static guchar page_get_sample (Page* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint n_channels, gint channel) {
	guchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = (guchar) 0xFF;
	return result;
}


static void page_get_pixel (Page* self, gint x, gint y, guchar* pixel, int pixel_length1, gint offset) {
	ScanDirection _tmp0_ = 0;
	gint _tmp13_ = 0;
	gint depth;
	gint _tmp14_ = 0;
	gint n_channels;
	gint _tmp15_ = 0;
	gint _tmp16_;
	gint line_offset;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_;
	gboolean _tmp20_;
	guchar* _tmp104_;
	gint _tmp104__length1;
	gint _tmp105_;
	guchar* _tmp106_;
	gint _tmp106__length1;
	gint _tmp107_;
	gint _tmp108_;
	gint _tmp109_;
	gint _tmp110_;
	guchar _tmp111_ = '\0';
	guchar _tmp112_;
	guchar* _tmp113_;
	gint _tmp113__length1;
	gint _tmp114_;
	guchar* _tmp115_;
	gint _tmp115__length1;
	gint _tmp116_;
	gint _tmp117_;
	gint _tmp118_;
	gint _tmp119_;
	guchar _tmp120_ = '\0';
	guchar _tmp121_;
	guchar* _tmp122_;
	gint _tmp122__length1;
	gint _tmp123_;
	guchar* _tmp124_;
	gint _tmp124__length1;
	gint _tmp125_;
	gint _tmp126_;
	gint _tmp127_;
	gint _tmp128_;
	guchar _tmp129_ = '\0';
	guchar _tmp130_;
	g_return_if_fail (self != NULL);
	_tmp0_ = page_get_scan_direction (self);
	switch (_tmp0_) {
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
		{
			break;
		}
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
		{
			gint _tmp1_ = 0;
			gint _tmp2_;
			gint _tmp3_ = 0;
			gint _tmp4_;
			_tmp1_ = page_get_scan_width (self);
			_tmp2_ = x;
			x = (_tmp1_ - _tmp2_) - 1;
			_tmp3_ = page_get_scan_height (self);
			_tmp4_ = y;
			y = (_tmp3_ - _tmp4_) - 1;
			break;
		}
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
		{
			gint _tmp5_;
			gint t;
			gint _tmp6_ = 0;
			gint _tmp7_;
			gint _tmp8_;
			_tmp5_ = x;
			t = _tmp5_;
			_tmp6_ = page_get_scan_width (self);
			_tmp7_ = y;
			x = (_tmp6_ - _tmp7_) - 1;
			_tmp8_ = t;
			y = _tmp8_;
			break;
		}
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
		{
			gint _tmp9_;
			gint t;
			gint _tmp10_;
			gint _tmp11_ = 0;
			gint _tmp12_;
			_tmp9_ = x;
			t = _tmp9_;
			_tmp10_ = y;
			x = _tmp10_;
			_tmp11_ = page_get_scan_height (self);
			_tmp12_ = t;
			y = (_tmp11_ - _tmp12_) - 1;
			break;
		}
		default:
		break;
	}
	_tmp13_ = page_get_depth (self);
	depth = _tmp13_;
	_tmp14_ = page_get_n_channels (self);
	n_channels = _tmp14_;
	_tmp15_ = page_get_rowstride (self);
	_tmp16_ = y;
	line_offset = _tmp15_ * _tmp16_;
	_tmp18_ = depth;
	if (_tmp18_ == 8) {
		gint _tmp19_;
		_tmp19_ = n_channels;
		_tmp17_ = _tmp19_ == 3;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp20_ = _tmp17_;
	if (_tmp20_) {
		gint _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint o;
		guchar* _tmp24_;
		gint _tmp24__length1;
		gint _tmp25_;
		guchar* _tmp26_;
		gint _tmp26__length1;
		gint _tmp27_;
		guchar _tmp28_;
		guchar _tmp29_;
		guchar* _tmp30_;
		gint _tmp30__length1;
		gint _tmp31_;
		guchar* _tmp32_;
		gint _tmp32__length1;
		gint _tmp33_;
		guchar _tmp34_;
		guchar _tmp35_;
		guchar* _tmp36_;
		gint _tmp36__length1;
		gint _tmp37_;
		guchar* _tmp38_;
		gint _tmp38__length1;
		gint _tmp39_;
		guchar _tmp40_;
		guchar _tmp41_;
		_tmp21_ = line_offset;
		_tmp22_ = x;
		_tmp23_ = n_channels;
		o = _tmp21_ + (_tmp22_ * _tmp23_);
		_tmp24_ = pixel;
		_tmp24__length1 = pixel_length1;
		_tmp25_ = offset;
		_tmp26_ = self->priv->pixels;
		_tmp26__length1 = self->priv->pixels_length1;
		_tmp27_ = o;
		_tmp28_ = _tmp26_[_tmp27_];
		_tmp24_[_tmp25_ + 0] = _tmp28_;
		_tmp29_ = _tmp24_[_tmp25_ + 0];
		_tmp30_ = pixel;
		_tmp30__length1 = pixel_length1;
		_tmp31_ = offset;
		_tmp32_ = self->priv->pixels;
		_tmp32__length1 = self->priv->pixels_length1;
		_tmp33_ = o;
		_tmp34_ = _tmp32_[_tmp33_ + 1];
		_tmp30_[_tmp31_ + 1] = _tmp34_;
		_tmp35_ = _tmp30_[_tmp31_ + 1];
		_tmp36_ = pixel;
		_tmp36__length1 = pixel_length1;
		_tmp37_ = offset;
		_tmp38_ = self->priv->pixels;
		_tmp38__length1 = self->priv->pixels_length1;
		_tmp39_ = o;
		_tmp40_ = _tmp38_[_tmp39_ + 2];
		_tmp36_[_tmp37_ + 2] = _tmp40_;
		_tmp41_ = _tmp36_[_tmp37_ + 2];
		return;
	} else {
		gboolean _tmp42_ = FALSE;
		gint _tmp43_;
		gboolean _tmp45_;
		_tmp43_ = depth;
		if (_tmp43_ == 8) {
			gint _tmp44_;
			_tmp44_ = n_channels;
			_tmp42_ = _tmp44_ == 1;
		} else {
			_tmp42_ = FALSE;
		}
		_tmp45_ = _tmp42_;
		if (_tmp45_) {
			guchar* _tmp46_;
			gint _tmp46__length1;
			gint _tmp47_;
			gint _tmp48_;
			guchar _tmp49_;
			guchar p;
			guchar* _tmp50_;
			gint _tmp50__length1;
			gint _tmp51_;
			guchar* _tmp52_;
			gint _tmp52__length1;
			gint _tmp53_;
			guchar* _tmp54_;
			gint _tmp54__length1;
			gint _tmp55_;
			guchar _tmp56_;
			guchar _tmp57_;
			guchar _tmp58_;
			guchar _tmp59_;
			_tmp46_ = self->priv->pixels;
			_tmp46__length1 = self->priv->pixels_length1;
			_tmp47_ = line_offset;
			_tmp48_ = x;
			_tmp49_ = _tmp46_[_tmp47_ + _tmp48_];
			p = _tmp49_;
			_tmp50_ = pixel;
			_tmp50__length1 = pixel_length1;
			_tmp51_ = offset;
			_tmp52_ = pixel;
			_tmp52__length1 = pixel_length1;
			_tmp53_ = offset;
			_tmp54_ = pixel;
			_tmp54__length1 = pixel_length1;
			_tmp55_ = offset;
			_tmp56_ = p;
			_tmp54_[_tmp55_ + 2] = _tmp56_;
			_tmp57_ = _tmp54_[_tmp55_ + 2];
			_tmp52_[_tmp53_ + 1] = _tmp57_;
			_tmp58_ = _tmp52_[_tmp53_ + 1];
			_tmp50_[_tmp51_ + 0] = _tmp58_;
			_tmp59_ = _tmp50_[_tmp51_ + 0];
			return;
		} else {
			gboolean _tmp60_ = FALSE;
			gint _tmp61_;
			gboolean _tmp63_;
			_tmp61_ = depth;
			if (_tmp61_ == 1) {
				gint _tmp62_;
				_tmp62_ = n_channels;
				_tmp60_ = _tmp62_ == 1;
			} else {
				_tmp60_ = FALSE;
			}
			_tmp63_ = _tmp60_;
			if (_tmp63_) {
				guchar* _tmp64_;
				gint _tmp64__length1;
				gint _tmp65_;
				gint _tmp66_;
				guchar _tmp67_;
				guchar p;
				gint _tmp68_ = 0;
				guchar _tmp69_;
				gint _tmp70_;
				guchar* _tmp71_;
				gint _tmp71__length1;
				gint _tmp72_;
				guchar* _tmp73_;
				gint _tmp73__length1;
				gint _tmp74_;
				guchar* _tmp75_;
				gint _tmp75__length1;
				gint _tmp76_;
				gint _tmp77_;
				guchar _tmp78_;
				guchar _tmp79_;
				guchar _tmp80_;
				_tmp64_ = self->priv->pixels;
				_tmp64__length1 = self->priv->pixels_length1;
				_tmp65_ = line_offset;
				_tmp66_ = x;
				_tmp67_ = _tmp64_[_tmp65_ + (_tmp66_ / 8)];
				p = _tmp67_;
				_tmp69_ = p;
				_tmp70_ = x;
				if (((gint) (_tmp69_ & (0x80 >> (_tmp70_ % 8)))) != 0) {
					_tmp68_ = 0x00;
				} else {
					_tmp68_ = 0xFF;
				}
				_tmp71_ = pixel;
				_tmp71__length1 = pixel_length1;
				_tmp72_ = offset;
				_tmp73_ = pixel;
				_tmp73__length1 = pixel_length1;
				_tmp74_ = offset;
				_tmp75_ = pixel;
				_tmp75__length1 = pixel_length1;
				_tmp76_ = offset;
				_tmp77_ = _tmp68_;
				_tmp75_[_tmp76_ + 2] = (guchar) _tmp77_;
				_tmp78_ = _tmp75_[_tmp76_ + 2];
				_tmp73_[_tmp74_ + 1] = _tmp78_;
				_tmp79_ = _tmp73_[_tmp74_ + 1];
				_tmp71_[_tmp72_ + 0] = _tmp79_;
				_tmp80_ = _tmp71_[_tmp72_ + 0];
				return;
			} else {
				gboolean _tmp81_ = FALSE;
				gint _tmp82_;
				gboolean _tmp84_;
				_tmp82_ = depth;
				if (_tmp82_ == 2) {
					gint _tmp83_;
					_tmp83_ = n_channels;
					_tmp81_ = _tmp83_ == 1;
				} else {
					_tmp81_ = FALSE;
				}
				_tmp84_ = _tmp81_;
				if (_tmp84_) {
					gint _tmp85_[4] = {0};
					gint block_shift[4];
					guchar* _tmp86_;
					gint _tmp86__length1;
					gint _tmp87_;
					gint _tmp88_;
					guchar _tmp89_;
					guchar p;
					guchar _tmp90_;
					gint _tmp91_;
					gint _tmp92_;
					gint sample;
					gint _tmp93_;
					guchar* _tmp94_;
					gint _tmp94__length1;
					gint _tmp95_;
					guchar* _tmp96_;
					gint _tmp96__length1;
					gint _tmp97_;
					guchar* _tmp98_;
					gint _tmp98__length1;
					gint _tmp99_;
					gint _tmp100_;
					guchar _tmp101_;
					guchar _tmp102_;
					guchar _tmp103_;
					_tmp85_[0] = 6;
					_tmp85_[1] = 4;
					_tmp85_[2] = 2;
					_tmp85_[3] = 0;
					memcpy (block_shift, _tmp85_, 4 * sizeof (gint));
					_tmp86_ = self->priv->pixels;
					_tmp86__length1 = self->priv->pixels_length1;
					_tmp87_ = line_offset;
					_tmp88_ = x;
					_tmp89_ = _tmp86_[_tmp87_ + (_tmp88_ / 4)];
					p = _tmp89_;
					_tmp90_ = p;
					_tmp91_ = x;
					_tmp92_ = block_shift[_tmp91_ % 4];
					sample = (_tmp90_ >> _tmp92_) & 0x3;
					_tmp93_ = sample;
					sample = (_tmp93_ * 255) / 3;
					_tmp94_ = pixel;
					_tmp94__length1 = pixel_length1;
					_tmp95_ = offset;
					_tmp96_ = pixel;
					_tmp96__length1 = pixel_length1;
					_tmp97_ = offset;
					_tmp98_ = pixel;
					_tmp98__length1 = pixel_length1;
					_tmp99_ = offset;
					_tmp100_ = sample;
					_tmp98_[_tmp99_ + 2] = (guchar) _tmp100_;
					_tmp101_ = _tmp98_[_tmp99_ + 2];
					_tmp96_[_tmp97_ + 1] = _tmp101_;
					_tmp102_ = _tmp96_[_tmp97_ + 1];
					_tmp94_[_tmp95_ + 0] = _tmp102_;
					_tmp103_ = _tmp94_[_tmp95_ + 0];
					return;
				}
			}
		}
	}
	_tmp104_ = pixel;
	_tmp104__length1 = pixel_length1;
	_tmp105_ = offset;
	_tmp106_ = self->priv->pixels;
	_tmp106__length1 = self->priv->pixels_length1;
	_tmp107_ = line_offset;
	_tmp108_ = x;
	_tmp109_ = depth;
	_tmp110_ = n_channels;
	_tmp111_ = page_get_sample (self, _tmp106_, _tmp106__length1, _tmp107_, _tmp108_, _tmp109_, _tmp110_, 0);
	_tmp104_[_tmp105_ + 0] = _tmp111_;
	_tmp112_ = _tmp104_[_tmp105_ + 0];
	_tmp113_ = pixel;
	_tmp113__length1 = pixel_length1;
	_tmp114_ = offset;
	_tmp115_ = self->priv->pixels;
	_tmp115__length1 = self->priv->pixels_length1;
	_tmp116_ = line_offset;
	_tmp117_ = x;
	_tmp118_ = depth;
	_tmp119_ = n_channels;
	_tmp120_ = page_get_sample (self, _tmp115_, _tmp115__length1, _tmp116_, _tmp117_, _tmp118_, _tmp119_, 1);
	_tmp113_[_tmp114_ + 1] = _tmp120_;
	_tmp121_ = _tmp113_[_tmp114_ + 1];
	_tmp122_ = pixel;
	_tmp122__length1 = pixel_length1;
	_tmp123_ = offset;
	_tmp124_ = self->priv->pixels;
	_tmp124__length1 = self->priv->pixels_length1;
	_tmp125_ = line_offset;
	_tmp126_ = x;
	_tmp127_ = depth;
	_tmp128_ = n_channels;
	_tmp129_ = page_get_sample (self, _tmp124_, _tmp124__length1, _tmp125_, _tmp126_, _tmp127_, _tmp128_, 2);
	_tmp122_[_tmp123_ + 2] = _tmp129_;
	_tmp130_ = _tmp122_[_tmp123_ + 2];
}


GdkPixbuf* page_get_image (Page* self, gboolean apply_crop) {
	GdkPixbuf* result = NULL;
	gint l = 0;
	gint r = 0;
	gint t = 0;
	gint b = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GdkPixbuf* _tmp24_;
	GdkPixbuf* image;
	GdkPixbuf* _tmp25_;
	guint8* _tmp26_ = NULL;
	guint8* image_pixels;
	gint image_pixels_length1;
	gint _image_pixels_size_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = apply_crop;
	if (_tmp1_) {
		gboolean _tmp2_;
		_tmp2_ = self->priv->has_crop_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_ = 0;
		_tmp4_ = self->priv->crop_x;
		l = _tmp4_;
		_tmp5_ = l;
		_tmp6_ = self->priv->crop_width;
		r = _tmp5_ + _tmp6_;
		_tmp7_ = self->priv->crop_y;
		t = _tmp7_;
		_tmp8_ = t;
		_tmp9_ = self->priv->crop_height;
		b = _tmp8_ + _tmp9_;
		_tmp10_ = l;
		if (_tmp10_ < 0) {
			l = 0;
		}
		_tmp11_ = r;
		_tmp12_ = page_get_width (self);
		if (_tmp11_ > _tmp12_) {
			gint _tmp13_ = 0;
			_tmp13_ = page_get_width (self);
			r = _tmp13_;
		}
		_tmp14_ = t;
		if (_tmp14_ < 0) {
			t = 0;
		}
		_tmp15_ = b;
		_tmp16_ = page_get_height (self);
		if (_tmp15_ > _tmp16_) {
			gint _tmp17_ = 0;
			_tmp17_ = page_get_height (self);
			b = _tmp17_;
		}
	} else {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		l = 0;
		_tmp18_ = page_get_width (self);
		r = _tmp18_;
		t = 0;
		_tmp19_ = page_get_height (self);
		b = _tmp19_;
	}
	_tmp20_ = r;
	_tmp21_ = l;
	_tmp22_ = b;
	_tmp23_ = t;
	_tmp24_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp20_ - _tmp21_, _tmp22_ - _tmp23_);
	image = _tmp24_;
	_tmp25_ = image;
	_tmp26_ = gdk_pixbuf_get_pixels (_tmp25_);
	image_pixels = _tmp26_;
	image_pixels_length1 = -1;
	_image_pixels_size_ = image_pixels_length1;
	{
		gint _tmp27_;
		gint y;
		_tmp27_ = t;
		y = _tmp27_;
		{
			gboolean _tmp28_;
			_tmp28_ = TRUE;
			while (TRUE) {
				gboolean _tmp29_;
				gint _tmp31_;
				gint _tmp32_;
				GdkPixbuf* _tmp33_;
				gint _tmp34_ = 0;
				gint _tmp35_;
				gint _tmp36_;
				gint offset;
				_tmp29_ = _tmp28_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = y;
					y = _tmp30_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp31_ = y;
				_tmp32_ = b;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = image;
				_tmp34_ = gdk_pixbuf_get_rowstride (_tmp33_);
				_tmp35_ = y;
				_tmp36_ = t;
				offset = _tmp34_ * (_tmp35_ - _tmp36_);
				{
					gint _tmp37_;
					gint x;
					_tmp37_ = l;
					x = _tmp37_;
					{
						gboolean _tmp38_;
						_tmp38_ = TRUE;
						while (TRUE) {
							gboolean _tmp39_;
							gint _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							gint _tmp44_;
							guint8* _tmp45_;
							gint _tmp45__length1;
							gint _tmp46_;
							gint _tmp47_;
							gint _tmp48_;
							_tmp39_ = _tmp38_;
							if (!_tmp39_) {
								gint _tmp40_;
								_tmp40_ = x;
								x = _tmp40_ + 1;
							}
							_tmp38_ = FALSE;
							_tmp41_ = x;
							_tmp42_ = r;
							if (!(_tmp41_ < _tmp42_)) {
								break;
							}
							_tmp43_ = x;
							_tmp44_ = y;
							_tmp45_ = image_pixels;
							_tmp45__length1 = image_pixels_length1;
							_tmp46_ = offset;
							_tmp47_ = x;
							_tmp48_ = l;
							page_get_pixel (self, _tmp43_, _tmp44_, _tmp45_, _tmp45__length1, _tmp46_ + ((_tmp47_ - _tmp48_) * 3));
						}
					}
				}
			}
		}
	}
	result = image;
	return result;
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static gchar* page_get_icc_data_encoded (Page* self, const gchar* icc_profile_filename) {
	gchar* result = NULL;
	gchar* contents = NULL;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icc_profile_filename != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		_tmp0_ = icc_profile_filename;
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("page.vala:679: failed to get icc profile data: %s", _tmp3_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (contents);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = contents;
	_tmp6_ = string_to_utf8 (_tmp4_, &_tmp5_);
	_tmp7_ = (guchar*) _tmp6_;
	_tmp7__length1 = (_tmp5_ * sizeof (gchar)) / sizeof (guchar);
	_tmp8_ = g_base64_encode (_tmp7_, (_tmp5_ * sizeof (gchar)) / sizeof (guchar));
	_tmp9_ = _tmp8_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	result = _tmp9_;
	_g_free0 (contents);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void page_copy_to_clipboard (Page* self, GtkWindow* window) {
	GtkWindow* _tmp0_;
	GdkDisplay* _tmp1_ = NULL;
	GdkDisplay* _tmp2_;
	GdkDisplay* display;
	GtkClipboard* _tmp3_ = NULL;
	GtkClipboard* _tmp4_;
	GtkClipboard* clipboard;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* image;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = window;
	_tmp1_ = gtk_widget_get_display ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = gtk_clipboard_get_for_display (display, GDK_SELECTION_CLIPBOARD);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	clipboard = _tmp4_;
	_tmp5_ = page_get_image (self, TRUE);
	image = _tmp5_;
	gtk_clipboard_set_image (clipboard, image);
	_g_object_unref0 (image);
	_g_object_unref0 (clipboard);
	_g_object_unref0 (display);
}


void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	GFileOutputStream* _tmp2_;
	PixbufWriter* _tmp3_;
	PixbufWriter* writer;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* image;
	gchar* icc_profile_data;
	const gchar* _tmp5_;
	GCompareFunc _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	stream = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = stream;
	_tmp3_ = pixbuf_writer_new (_tmp2_);
	writer = _tmp3_;
	_tmp4_ = page_get_image (self, TRUE);
	image = _tmp4_;
	icc_profile_data = NULL;
	_tmp5_ = self->priv->color_profile;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		_tmp6_ = self->priv->color_profile;
		_tmp7_ = page_get_icc_data_encoded (self, _tmp6_);
		_g_free0 (icc_profile_data);
		icc_profile_data = _tmp7_;
	}
	_tmp8_ = g_strcmp0;
	_tmp9_ = type;
	_tmp10_ = _tmp8_ (_tmp9_, "jpeg");
	if (_tmp10_ == 0) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar** _tmp16_ = NULL;
		gchar** keys;
		gint keys_length1;
		gint _keys_size_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gint _tmp22_;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_ = NULL;
		gchar** values;
		gint values_length1;
		gint _values_size_;
		const gchar* _tmp27_;
		PixbufWriter* _tmp30_;
		GdkPixbuf* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar** _tmp33_;
		gint _tmp33__length1;
		_tmp11_ = g_strdup ("quality");
		_tmp12_ = g_strdup ("density-unit");
		_tmp13_ = g_strdup ("x-density");
		_tmp14_ = g_strdup ("y-density");
		_tmp15_ = g_strdup ("icc-profile");
		_tmp16_ = g_new0 (gchar*, 6 + 1);
		_tmp16_[0] = _tmp11_;
		_tmp16_[1] = _tmp12_;
		_tmp16_[2] = _tmp13_;
		_tmp16_[3] = _tmp14_;
		_tmp16_[4] = _tmp15_;
		_tmp16_[5] = NULL;
		keys = _tmp16_;
		keys_length1 = 6;
		_keys_size_ = keys_length1;
		_tmp17_ = quality;
		_tmp18_ = g_strdup_printf ("%d", _tmp17_);
		_tmp19_ = g_strdup ("dots-per-inch");
		_tmp20_ = self->priv->dpi;
		_tmp21_ = g_strdup_printf ("%d", _tmp20_);
		_tmp22_ = self->priv->dpi;
		_tmp23_ = g_strdup_printf ("%d", _tmp22_);
		_tmp24_ = icc_profile_data;
		_tmp25_ = g_strdup (_tmp24_);
		_tmp26_ = g_new0 (gchar*, 6 + 1);
		_tmp26_[0] = _tmp18_;
		_tmp26_[1] = _tmp19_;
		_tmp26_[2] = _tmp21_;
		_tmp26_[3] = _tmp23_;
		_tmp26_[4] = _tmp25_;
		_tmp26_[5] = NULL;
		values = _tmp26_;
		values_length1 = 6;
		_values_size_ = values_length1;
		_tmp27_ = icc_profile_data;
		if (_tmp27_ == NULL) {
			gchar** _tmp28_;
			gint _tmp28__length1;
			gchar* _tmp29_;
			_tmp28_ = keys;
			_tmp28__length1 = keys_length1;
			_g_free0 (_tmp28_[4]);
			_tmp28_[4] = NULL;
			_tmp29_ = _tmp28_[4];
		}
		_tmp30_ = writer;
		_tmp31_ = image;
		_tmp32_ = keys;
		_tmp32__length1 = keys_length1;
		_tmp33_ = values;
		_tmp33__length1 = values_length1;
		pixbuf_writer_save (_tmp30_, _tmp31_, "jpeg", _tmp32_, _tmp32__length1, _tmp33_, _tmp33__length1, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (icc_profile_data);
			_g_object_unref0 (image);
			_pixbuf_writer_unref0 (writer);
			_g_object_unref0 (stream);
			return;
		}
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	} else {
		GCompareFunc _tmp34_;
		const gchar* _tmp35_;
		gint _tmp36_ = 0;
		_tmp34_ = g_strcmp0;
		_tmp35_ = type;
		_tmp36_ = _tmp34_ (_tmp35_, "png");
		if (_tmp36_ == 0) {
			gchar* _tmp37_;
			gchar** _tmp38_ = NULL;
			gchar** keys;
			gint keys_length1;
			gint _keys_size_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar** _tmp41_ = NULL;
			gchar** values;
			gint values_length1;
			gint _values_size_;
			const gchar* _tmp42_;
			PixbufWriter* _tmp45_;
			GdkPixbuf* _tmp46_;
			gchar** _tmp47_;
			gint _tmp47__length1;
			gchar** _tmp48_;
			gint _tmp48__length1;
			_tmp37_ = g_strdup ("icc-profile");
			_tmp38_ = g_new0 (gchar*, 2 + 1);
			_tmp38_[0] = _tmp37_;
			_tmp38_[1] = NULL;
			keys = _tmp38_;
			keys_length1 = 2;
			_keys_size_ = keys_length1;
			_tmp39_ = icc_profile_data;
			_tmp40_ = g_strdup (_tmp39_);
			_tmp41_ = g_new0 (gchar*, 2 + 1);
			_tmp41_[0] = _tmp40_;
			_tmp41_[1] = NULL;
			values = _tmp41_;
			values_length1 = 2;
			_values_size_ = values_length1;
			_tmp42_ = icc_profile_data;
			if (_tmp42_ == NULL) {
				gchar** _tmp43_;
				gint _tmp43__length1;
				gchar* _tmp44_;
				_tmp43_ = keys;
				_tmp43__length1 = keys_length1;
				_g_free0 (_tmp43_[0]);
				_tmp43_[0] = NULL;
				_tmp44_ = _tmp43_[0];
			}
			_tmp45_ = writer;
			_tmp46_ = image;
			_tmp47_ = keys;
			_tmp47__length1 = keys_length1;
			_tmp48_ = values;
			_tmp48__length1 = values_length1;
			pixbuf_writer_save (_tmp45_, _tmp46_, "png", _tmp47_, _tmp47__length1, _tmp48_, _tmp48__length1, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (icc_profile_data);
				_g_object_unref0 (image);
				_pixbuf_writer_unref0 (writer);
				_g_object_unref0 (stream);
				return;
			}
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		} else {
			GCompareFunc _tmp49_;
			const gchar* _tmp50_;
			gint _tmp51_ = 0;
			_tmp49_ = g_strcmp0;
			_tmp50_ = type;
			_tmp51_ = _tmp49_ (_tmp50_, "tiff");
			if (_tmp51_ == 0) {
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar** _tmp54_ = NULL;
				gchar** keys;
				gint keys_length1;
				gint _keys_size_;
				gchar* _tmp55_;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				gchar** _tmp58_ = NULL;
				gchar** values;
				gint values_length1;
				gint _values_size_;
				const gchar* _tmp59_;
				PixbufWriter* _tmp62_;
				GdkPixbuf* _tmp63_;
				gchar** _tmp64_;
				gint _tmp64__length1;
				gchar** _tmp65_;
				gint _tmp65__length1;
				_tmp52_ = g_strdup ("compression");
				_tmp53_ = g_strdup ("icc-profile");
				_tmp54_ = g_new0 (gchar*, 3 + 1);
				_tmp54_[0] = _tmp52_;
				_tmp54_[1] = _tmp53_;
				_tmp54_[2] = NULL;
				keys = _tmp54_;
				keys_length1 = 3;
				_keys_size_ = keys_length1;
				_tmp55_ = g_strdup ("8");
				_tmp56_ = icc_profile_data;
				_tmp57_ = g_strdup (_tmp56_);
				_tmp58_ = g_new0 (gchar*, 3 + 1);
				_tmp58_[0] = _tmp55_;
				_tmp58_[1] = _tmp57_;
				_tmp58_[2] = NULL;
				values = _tmp58_;
				values_length1 = 3;
				_values_size_ = values_length1;
				_tmp59_ = icc_profile_data;
				if (_tmp59_ == NULL) {
					gchar** _tmp60_;
					gint _tmp60__length1;
					gchar* _tmp61_;
					_tmp60_ = keys;
					_tmp60__length1 = keys_length1;
					_g_free0 (_tmp60_[1]);
					_tmp60_[1] = NULL;
					_tmp61_ = _tmp60_[1];
				}
				_tmp62_ = writer;
				_tmp63_ = image;
				_tmp64_ = keys;
				_tmp64__length1 = keys_length1;
				_tmp65_ = values;
				_tmp65__length1 = values_length1;
				pixbuf_writer_save (_tmp62_, _tmp63_, "tiff", _tmp64_, _tmp64__length1, _tmp65_, _tmp65__length1, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (icc_profile_data);
					_g_object_unref0 (image);
					_pixbuf_writer_unref0 (writer);
					_g_object_unref0 (stream);
					return;
				}
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			} else {
			}
		}
	}
	_g_free0 (icc_profile_data);
	_g_object_unref0 (image);
	_pixbuf_writer_unref0 (writer);
	_g_object_unref0 (stream);
}


static void value_page_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_page_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		page_unref (value->data[0].v_pointer);
	}
}


static void value_page_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = page_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_page_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_page_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Page* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = page_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_page_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Page** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = page_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_page (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE), NULL);
	return value->data[0].v_pointer;
}


void value_set_page (GValue* value, gpointer v_object) {
	Page* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		page_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		page_unref (old);
	}
}


void value_take_page (GValue* value, gpointer v_object) {
	Page* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		page_unref (old);
	}
}


static void page_class_init (PageClass * klass) {
	page_parent_class = g_type_class_peek_parent (klass);
	PAGE_CLASS (klass)->finalize = page_finalize;
	g_type_class_add_private (klass, sizeof (PagePrivate));
	g_signal_new ("pixels_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("size_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("scan_line_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("scan_direction_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("crop_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("scan_finished", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void page_instance_init (Page * self) {
	self->priv = PAGE_GET_PRIVATE (self);
	self->priv->scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
	self->ref_count = 1;
}


static void page_finalize (Page* obj) {
	Page * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE, Page);
	_g_free0 (self->priv->color_profile);
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
	_g_free0 (self->priv->crop_name);
}


GType page_get_type (void) {
	static volatile gsize page_type_id__volatile = 0;
	if (g_once_init_enter (&page_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_init, value_page_free_value, value_page_copy_value, value_page_peek_pointer, "p", value_page_collect_value, "p", value_page_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Page), 0, (GInstanceInitFunc) page_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_type_id;
		page_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Page", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_type_id__volatile, page_type_id);
	}
	return page_type_id__volatile;
}


gpointer page_ref (gpointer instance) {
	Page* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void page_unref (gpointer instance) {
	Page* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


PixbufWriter* pixbuf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PixbufWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (PixbufWriter*) g_type_create_instance (object_type);
	_tmp0_ = stream;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->stream);
	self->stream = _tmp1_;
	return self;
}


PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream) {
	return pixbuf_writer_construct (TYPE_PIXBUF_WRITER, stream);
}


static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = pixbuf_writer_write_pixbuf_data (self, buf, buf_length1, error);
	return result;
}


void pixbuf_writer_save (PixbufWriter* self, GdkPixbuf* image, const gchar* type, gchar** option_keys, int option_keys_length1, gchar** option_values, int option_values_length1, GError** error) {
	GdkPixbuf* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = image;
	_tmp1_ = type;
	_tmp2_ = option_keys;
	_tmp2__length1 = option_keys_length1;
	_tmp3_ = option_values;
	_tmp3__length1 = option_values_length1;
	gdk_pixbuf_save_to_callbackv (_tmp0_, _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func, self, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GFileOutputStream* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->stream;
	_tmp1_ = buf;
	_tmp1__length1 = buf_length1;
	g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void value_pixbuf_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pixbuf_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pixbuf_writer_unref (value->data[0].v_pointer);
	}
}


static void value_pixbuf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pixbuf_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pixbuf_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pixbuf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PixbufWriter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pixbuf_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pixbuf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixbufWriter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pixbuf_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pixbuf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixbufWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXBUF_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pixbuf_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER), NULL);
	return value->data[0].v_pointer;
}


void value_set_pixbuf_writer (GValue* value, gpointer v_object) {
	PixbufWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pixbuf_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pixbuf_writer_unref (old);
	}
}


void value_take_pixbuf_writer (GValue* value, gpointer v_object) {
	PixbufWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pixbuf_writer_unref (old);
	}
}


static void pixbuf_writer_class_init (PixbufWriterClass * klass) {
	pixbuf_writer_parent_class = g_type_class_peek_parent (klass);
	PIXBUF_WRITER_CLASS (klass)->finalize = pixbuf_writer_finalize;
}


static void pixbuf_writer_instance_init (PixbufWriter * self) {
	self->ref_count = 1;
}


static void pixbuf_writer_finalize (PixbufWriter* obj) {
	PixbufWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_WRITER, PixbufWriter);
	_g_object_unref0 (self->stream);
}


GType pixbuf_writer_get_type (void) {
	static volatile gsize pixbuf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixbuf_writer_init, value_pixbuf_writer_free_value, value_pixbuf_writer_copy_value, value_pixbuf_writer_peek_pointer, "p", value_pixbuf_writer_collect_value, "p", value_pixbuf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixbufWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufWriter), 0, (GInstanceInitFunc) pixbuf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixbuf_writer_type_id;
		pixbuf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixbufWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixbuf_writer_type_id__volatile, pixbuf_writer_type_id);
	}
	return pixbuf_writer_type_id__volatile;
}


gpointer pixbuf_writer_ref (gpointer instance) {
	PixbufWriter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pixbuf_writer_unref (gpointer instance) {
	PixbufWriter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PIXBUF_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



