/* book.c generated by valac 0.22.1, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include "jpeglib.h"
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void book_page_changed_cb (Book* self, Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self, gboolean needs_saving);
GType scan_direction_get_type (void) G_GNUC_CONST;
Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_move_page (Book* self, Page* page, guint location);
void book_delete_page (Book* self, Page* page);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
static void book_save_multi_file (Book* self, const gchar* type, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static void book_jpeg_init_cb (struct jpeg_compress_struct* info);
static gboolean book_jpeg_empty_cb (struct jpeg_compress_struct* info);
static void book_jpeg_term_cb (struct jpeg_compress_struct* info);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gsize* n_written, int* result_length1);
static void _book_jpeg_init_cb_jpeg_initdestinationfunc (struct jpeg_compress_struct* cinfo);
static gboolean _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc (struct jpeg_compress_struct* cinfo);
static void _book_jpeg_term_cb_jpeg_termdestinationfunc (struct jpeg_compress_struct* cinfo);
static void book_save_pdf (Book* self, GFile* file, GError** error);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);


static gpointer _page_ref0 (gpointer self) {
	return self ? page_ref (self) : NULL;
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
	book_page_changed_cb (self, _sender);
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
	book_page_changed_cb (self, _sender);
}


static void _page_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
}


static void _g_list_free__page_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
	g_list_free (self);
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
	self = (Book*) g_type_create_instance (object_type);
	__g_list_free__page_unref0_0 (self->priv->pages);
	self->priv->pages = NULL;
	return self;
}


Book* book_new (void) {
	return book_construct (TYPE_BOOK);
}


void book_clear (Book* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp0_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp1_ = NULL;
			Page* page = NULL;
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
			page = _tmp1_;
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				_tmp2_ = page;
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
				_tmp4_ = page;
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
				_page_unref0 (page);
			}
		}
	}
	__g_list_free__page_unref0_0 (self->priv->pages);
	self->priv->pages = NULL;
	g_signal_emit_by_name (self, "cleared");
}


static void book_page_changed_cb (Book* self, Page* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	book_set_needs_saving (self, TRUE);
}


Page* book_append_page (Book* self, gint width, gint height, gint dpi, ScanDirection scan_direction) {
	Page* result = NULL;
	Page* page = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = dpi;
	_tmp3_ = scan_direction;
	_tmp4_ = page_new (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	page = _tmp4_;
	g_signal_connect (page, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
	g_signal_connect (page, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
	_tmp5_ = _page_ref0 (page);
	self->priv->pages = g_list_append (self->priv->pages, _tmp5_);
	g_signal_emit_by_name (self, "page-added", page);
	book_set_needs_saving (self, TRUE);
	result = page;
	return result;
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
	_tmp1_ = page;
	_tmp2_ = _page_ref0 (_tmp1_);
	_tmp3_ = location;
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
	g_signal_emit_by_name (self, "reordered");
	book_set_needs_saving (self, TRUE);
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Page* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = page;
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
	_tmp2_ = page;
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
	_tmp4_ = page;
	g_signal_emit_by_name (self, "page-removed", _tmp4_);
	_tmp5_ = page;
	self->priv->pages = g_list_remove (self->priv->pages, _tmp5_);
	book_set_needs_saving (self, TRUE);
}


guint book_get_n_pages (Book* self) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pages;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_;
	return result;
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_ = 0;
	GList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = page_number;
	if (_tmp0_ < 0) {
		GList* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->pages;
		_tmp2_ = g_list_length (_tmp1_);
		_tmp3_ = page_number;
		page_number = ((gint) _tmp2_) + _tmp3_;
	}
	_tmp4_ = self->priv->pages;
	_tmp5_ = page_number;
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
	result = _tmp7_;
	return result;
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (page != NULL, 0U);
	_tmp0_ = self->priv->pages;
	_tmp1_ = page;
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
	result = (guint) _tmp2_;
	return result;
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_ = 0U;
	gchar* basename = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* prefix = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* suffix = NULL;
	gchar* _tmp7_ = NULL;
	gint extension_index = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	const gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GFile* _tmp30_ = NULL;
	GFile* _tmp31_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = book_get_n_pages (self);
	if (_tmp0_ == ((guint) 1)) {
		const gchar* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		_tmp1_ = uri;
		_tmp2_ = g_file_new_for_uri (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = uri;
	_tmp4_ = g_path_get_basename (_tmp3_);
	basename = _tmp4_;
	_tmp5_ = uri;
	_tmp6_ = g_strdup (_tmp5_);
	prefix = _tmp6_;
	_tmp7_ = g_strdup ("");
	suffix = _tmp7_;
	_tmp8_ = basename;
	_tmp9_ = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
	extension_index = _tmp9_;
	_tmp10_ = extension_index;
	if (_tmp10_ >= 0) {
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		const gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
		_tmp11_ = basename;
		_tmp12_ = extension_index;
		_tmp13_ = basename;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_slice (_tmp11_, (glong) _tmp12_, (glong) _tmp15_);
		_g_free0 (suffix);
		suffix = _tmp16_;
		_tmp17_ = uri;
		_tmp18_ = uri;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = suffix;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = string_slice (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp23_));
		_g_free0 (prefix);
		prefix = _tmp24_;
	}
	_tmp25_ = prefix;
	_tmp26_ = i;
	_tmp27_ = suffix;
	_tmp28_ = g_strdup_printf ("%s-%d%s", _tmp25_, _tmp26_ + 1, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_file_new_for_uri (_tmp29_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	result = _tmp31_;
	_g_free0 (suffix);
	_g_free0 (prefix);
	_g_free0 (basename);
	return result;
}


static void book_save_multi_file (Book* self, const gchar* type, GFile* file, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (file != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				guint _tmp4_ = 0U;
				Page* page = NULL;
				gint _tmp5_ = 0;
				Page* _tmp6_ = NULL;
				Page* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				GFile* _tmp13_ = NULL;
				GFile* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = book_get_n_pages (self);
				if (!(((guint) _tmp3_) < _tmp4_)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = book_get_page (self, _tmp5_);
				page = _tmp6_;
				_tmp7_ = page;
				_tmp8_ = type;
				_tmp9_ = file;
				_tmp10_ = g_file_get_uri (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = i;
				_tmp13_ = book_make_indexed_file (self, _tmp11_, _tmp12_);
				_tmp14_ = _tmp13_;
				page_save (_tmp7_, _tmp8_, _tmp14_, &_inner_error_);
				_g_object_unref0 (_tmp14_);
				_g_free0 (_tmp11_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_page_unref0 (page);
					return;
				}
				_tmp15_ = i;
				g_signal_emit_by_name (self, "saving", _tmp15_);
				_page_unref0 (page);
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_t* context = NULL;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_pattern_t* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (surface != NULL);
	g_return_if_fail (image != NULL);
	_tmp0_ = surface;
	_tmp1_ = cairo_create (_tmp0_);
	context = _tmp1_;
	_tmp2_ = dpi;
	_tmp3_ = dpi;
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
	_tmp4_ = image;
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
	_tmp5_ = cairo_get_source (context);
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
	cairo_paint (context);
	_cairo_destroy0 (context);
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFileOutputStream* stream = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	PsWriter* writer = NULL;
	PsWriter* _tmp2_ = NULL;
	cairo_surface_t* surface = NULL;
	PsWriter* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	stream = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ps_writer_new (stream);
	writer = _tmp2_;
	_tmp3_ = writer;
	_tmp4_ = _tmp3_->surface;
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
	surface = _tmp5_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_ = FALSE;
				gint _tmp9_ = 0;
				guint _tmp10_ = 0U;
				Page* page = NULL;
				gint _tmp11_ = 0;
				Page* _tmp12_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp13_ = NULL;
				GdkPixbuf* _tmp14_ = NULL;
				gdouble width = 0.0;
				GdkPixbuf* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				Page* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gdouble height = 0.0;
				GdkPixbuf* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				Page* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				cairo_surface_t* _tmp23_ = NULL;
				gdouble _tmp24_ = 0.0;
				gdouble _tmp25_ = 0.0;
				cairo_surface_t* _tmp26_ = NULL;
				GdkPixbuf* _tmp27_ = NULL;
				Page* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				cairo_surface_t* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = book_get_n_pages (self);
				if (!(((guint) _tmp9_) < _tmp10_)) {
					break;
				}
				_tmp11_ = i;
				_tmp12_ = book_get_page (self, _tmp11_);
				page = _tmp12_;
				_tmp13_ = page;
				_tmp14_ = page_get_image (_tmp13_, TRUE);
				image = _tmp14_;
				_tmp15_ = image;
				_tmp16_ = gdk_pixbuf_get_width (_tmp15_);
				_tmp17_ = page;
				_tmp18_ = page_get_dpi (_tmp17_);
				width = (_tmp16_ * 72.0) / _tmp18_;
				_tmp19_ = image;
				_tmp20_ = gdk_pixbuf_get_height (_tmp19_);
				_tmp21_ = page;
				_tmp22_ = page_get_dpi (_tmp21_);
				height = (_tmp20_ * 72.0) / _tmp22_;
				_tmp23_ = surface;
				_tmp24_ = width;
				_tmp25_ = height;
				cairo_ps_surface_set_size (_tmp23_, _tmp24_, _tmp25_);
				_tmp26_ = surface;
				_tmp27_ = image;
				_tmp28_ = page;
				_tmp29_ = page_get_dpi (_tmp28_);
				book_save_ps_pdf_surface (self, _tmp26_, _tmp27_, (gdouble) _tmp29_);
				_tmp30_ = surface;
				cairo_surface_show_page (_tmp30_);
				_tmp31_ = i;
				g_signal_emit_by_name (self, "saving", _tmp31_);
				_g_object_unref0 (image);
				_page_unref0 (page);
			}
		}
	}
	_cairo_surface_destroy0 (surface);
	_ps_writer_unref0 (writer);
	_g_object_unref0 (stream);
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* out_data = NULL;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guint8* _tmp1_ = NULL;
	gint out_data_length1 = 0;
	gint _out_data_size_ = 0;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	z_stream _tmp7_ = {0};
	guint _tmp8_ = 0U;
	guint n_written = 0U;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	z_stream _tmp11_ = {0};
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	gint _tmp14_ = 0;
	guint8* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
	out_data = _tmp1_;
	out_data_length1 = _tmp0__length1;
	_out_data_size_ = out_data_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	stream.next_in = _tmp2_;
	stream.avail_in = _tmp2__length1;
	_tmp3_ = out_data;
	_tmp3__length1 = out_data_length1;
	stream.next_out = _tmp3_;
	stream.avail_out = _tmp3__length1;
	while (TRUE) {
		z_stream _tmp4_ = {0};
		guint _tmp5_ = 0U;
		gint _tmp6_ = 0;
		_tmp4_ = stream;
		_tmp5_ = _tmp4_.avail_in;
		if (!(_tmp5_ > ((guint) 0))) {
			break;
		}
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
			break;
		}
	}
	_tmp7_ = stream;
	_tmp8_ = _tmp7_.avail_in;
	if (_tmp8_ > ((guint) 0)) {
		guint8* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp9_ = NULL;
		_tmp9__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		out_data = (g_free (out_data), NULL);
		deflateEnd (&stream);
		return result;
	}
	_tmp10_ = data;
	_tmp10__length1 = data_length1;
	_tmp11_ = stream;
	_tmp12_ = _tmp11_.avail_out;
	n_written = _tmp10__length1 - _tmp12_;
	_tmp13_ = n_written;
	_tmp14_ = (gint) _tmp13_;
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
	out_data_length1 = _tmp14_;
	_out_data_size_ = _tmp14_;
	_tmp15_ = out_data;
	_tmp15__length1 = out_data_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	deflateEnd (&stream);
	return result;
}


static void book_jpeg_init_cb (struct jpeg_compress_struct* info) {
	g_return_if_fail (info != NULL);
}


static gboolean book_jpeg_empty_cb (struct jpeg_compress_struct* info) {
	gboolean result = FALSE;
	g_return_val_if_fail (info != NULL, FALSE);
	result = TRUE;
	return result;
}


static void book_jpeg_term_cb (struct jpeg_compress_struct* info) {
	g_return_if_fail (info != NULL);
}


static void _book_jpeg_init_cb_jpeg_initdestinationfunc (struct jpeg_compress_struct* cinfo) {
	book_jpeg_init_cb (cinfo);
}


static gboolean _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc (struct jpeg_compress_struct* cinfo) {
	gboolean result;
	result = book_jpeg_empty_cb (cinfo);
	return result;
}


static void _book_jpeg_term_cb_jpeg_termdestinationfunc (struct jpeg_compress_struct* cinfo) {
	book_jpeg_term_cb (cinfo);
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gsize* n_written, int* result_length1) {
	gsize _vala_n_written = 0UL;
	guint8* result = NULL;
	struct jpeg_compress_struct info = {0};
	struct jpeg_error_mgr jerr = {0};
	struct jpeg_destination_mgr dest_mgr = {0};
	struct jpeg_error_mgr* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint max_length = 0;
	struct jpeg_compress_struct _tmp5_ = {0};
	gint _tmp6_ = 0;
	struct jpeg_compress_struct _tmp7_ = {0};
	gint _tmp8_ = 0;
	struct jpeg_compress_struct _tmp9_ = {0};
	gint _tmp10_ = 0;
	guint8* data = NULL;
	gint _tmp11_ = 0;
	guint8* _tmp12_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp14_ = 0;
	guint8* pixels = NULL;
	GdkPixbuf* _tmp15_ = NULL;
	guint8* _tmp16_ = NULL;
	gint pixels_length1 = 0;
	gint _pixels_size_ = 0;
	gint _tmp28_ = 0;
	struct jpeg_destination_mgr _tmp29_ = {0};
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	guint8* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (image != NULL, NULL);
	memset (&info, 0, sizeof (struct jpeg_compress_struct));
	memset (&jerr, 0, sizeof (struct jpeg_error_mgr));
	memset (&dest_mgr, 0, sizeof (struct jpeg_destination_mgr));
	_tmp0_ = jpeg_std_error (&jerr);
	info.err = _tmp0_;
	jpeg_create_compress (&info);
	_tmp1_ = image;
	_tmp2_ = gdk_pixbuf_get_width (_tmp1_);
	info.image_width = _tmp2_;
	_tmp3_ = image;
	_tmp4_ = gdk_pixbuf_get_height (_tmp3_);
	info.image_height = _tmp4_;
	info.input_components = 3;
	info.in_color_space = JCS_RGB;
	jpeg_set_defaults (&info);
	_tmp5_ = info;
	_tmp6_ = _tmp5_.image_width;
	_tmp7_ = info;
	_tmp8_ = _tmp7_.image_height;
	_tmp9_ = info;
	_tmp10_ = _tmp9_.input_components;
	max_length = (_tmp6_ * _tmp8_) * _tmp10_;
	_tmp11_ = max_length;
	_tmp12_ = g_new0 (guint8, _tmp11_);
	data = _tmp12_;
	data_length1 = _tmp11_;
	_data_size_ = data_length1;
	_tmp13_ = data;
	_tmp13__length1 = data_length1;
	dest_mgr.next_output_byte = _tmp13_;
	_tmp14_ = max_length;
	dest_mgr.free_in_buffer = _tmp14_;
	dest_mgr.init_destination = _book_jpeg_init_cb_jpeg_initdestinationfunc;
	dest_mgr.empty_output_buffer = _book_jpeg_empty_cb_jpeg_emptyoutputbufferfunc;
	dest_mgr.term_destination = _book_jpeg_term_cb_jpeg_termdestinationfunc;
	info.dest = &dest_mgr;
	jpeg_start_compress (&info, TRUE);
	_tmp15_ = image;
	_tmp16_ = gdk_pixbuf_get_pixels (_tmp15_);
	pixels = _tmp16_;
	pixels_length1 = -1;
	_pixels_size_ = pixels_length1;
	{
		gint r = 0;
		r = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_ = FALSE;
				gint _tmp20_ = 0;
				struct jpeg_compress_struct _tmp21_ = {0};
				gint _tmp22_ = 0;
				guint8* row[1] = {0};
				guint8* _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint _tmp24_ = 0;
				GdkPixbuf* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				guint8* _tmp27_ = NULL;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_ = 0;
					_tmp19_ = r;
					r = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = r;
				_tmp21_ = info;
				_tmp22_ = _tmp21_.image_height;
				if (!(_tmp20_ < _tmp22_)) {
					break;
				}
				_tmp23_ = pixels;
				_tmp23__length1 = pixels_length1;
				_tmp24_ = r;
				_tmp25_ = image;
				_tmp26_ = gdk_pixbuf_get_rowstride (_tmp25_);
				row[0] = ((guint8*) _tmp23_) + (_tmp24_ * _tmp26_);
				_tmp27_ = row[0];
				jpeg_write_scanlines (&info, row, 1);
			}
		}
	}
	jpeg_finish_compress (&info);
	_tmp28_ = max_length;
	_tmp29_ = dest_mgr;
	_tmp30_ = _tmp29_.free_in_buffer;
	_vala_n_written = (gsize) (_tmp28_ - _tmp30_);
	_tmp31_ = (gint) _vala_n_written;
	data = g_renew (guint8, data, (gint) _vala_n_written);
	(_tmp31_ > data_length1) ? memset (data + data_length1, 0, sizeof (guint8) * (_tmp31_ - data_length1)) : NULL;
	data_length1 = _tmp31_;
	_data_size_ = _tmp31_;
	_tmp32_ = data;
	_tmp32__length1 = data_length1;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	jpeg_destroy_compress (&info);
	if (n_written) {
		*n_written = _vala_n_written;
	}
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void book_save_pdf (Book* self, GFile* file, GError** error) {
	gchar* id = NULL;
	gchar* _tmp0_ = NULL;
	GFileOutputStream* stream = NULL;
	GFile* _tmp10_ = NULL;
	GFileOutputStream* _tmp11_ = NULL;
	PDFWriter* writer = NULL;
	PDFWriter* _tmp12_ = NULL;
	PDFWriter* _tmp13_ = NULL;
	PDFWriter* _tmp14_ = NULL;
	guint catalog_number = 0U;
	PDFWriter* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	PDFWriter* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	PDFWriter* _tmp21_ = NULL;
	PDFWriter* _tmp22_ = NULL;
	PDFWriter* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	PDFWriter* _tmp27_ = NULL;
	PDFWriter* _tmp28_ = NULL;
	PDFWriter* _tmp29_ = NULL;
	guint pages_number = 0U;
	PDFWriter* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
	PDFWriter* _tmp32_ = NULL;
	guint _tmp33_ = 0U;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	PDFWriter* _tmp36_ = NULL;
	PDFWriter* _tmp37_ = NULL;
	PDFWriter* _tmp38_ = NULL;
	PDFWriter* _tmp49_ = NULL;
	PDFWriter* _tmp50_ = NULL;
	guint _tmp51_ = 0U;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	PDFWriter* _tmp54_ = NULL;
	PDFWriter* _tmp55_ = NULL;
	PDFWriter* _tmp360_ = NULL;
	guint info_number = 0U;
	PDFWriter* _tmp361_ = NULL;
	guint _tmp362_ = 0U;
	PDFWriter* _tmp363_ = NULL;
	guint _tmp364_ = 0U;
	gchar* _tmp365_ = NULL;
	gchar* _tmp366_ = NULL;
	PDFWriter* _tmp367_ = NULL;
	PDFWriter* _tmp368_ = NULL;
	gchar* _tmp369_ = NULL;
	gchar* _tmp370_ = NULL;
	PDFWriter* _tmp371_ = NULL;
	PDFWriter* _tmp372_ = NULL;
	PDFWriter* _tmp373_ = NULL;
	gsize xref_offset = 0UL;
	PDFWriter* _tmp374_ = NULL;
	gsize _tmp375_ = 0UL;
	PDFWriter* _tmp376_ = NULL;
	PDFWriter* _tmp377_ = NULL;
	PDFWriter* _tmp378_ = NULL;
	GList* _tmp379_ = NULL;
	guint _tmp380_ = 0U;
	gchar* _tmp381_ = NULL;
	gchar* _tmp382_ = NULL;
	PDFWriter* _tmp383_ = NULL;
	PDFWriter* _tmp384_ = NULL;
	GList* _tmp385_ = NULL;
	PDFWriter* _tmp390_ = NULL;
	PDFWriter* _tmp391_ = NULL;
	PDFWriter* _tmp392_ = NULL;
	PDFWriter* _tmp393_ = NULL;
	PDFWriter* _tmp394_ = NULL;
	GList* _tmp395_ = NULL;
	guint _tmp396_ = 0U;
	gchar* _tmp397_ = NULL;
	gchar* _tmp398_ = NULL;
	PDFWriter* _tmp399_ = NULL;
	guint _tmp400_ = 0U;
	gchar* _tmp401_ = NULL;
	gchar* _tmp402_ = NULL;
	PDFWriter* _tmp403_ = NULL;
	guint _tmp404_ = 0U;
	gchar* _tmp405_ = NULL;
	gchar* _tmp406_ = NULL;
	PDFWriter* _tmp407_ = NULL;
	const gchar* _tmp408_ = NULL;
	const gchar* _tmp409_ = NULL;
	gchar* _tmp410_ = NULL;
	gchar* _tmp411_ = NULL;
	PDFWriter* _tmp412_ = NULL;
	PDFWriter* _tmp413_ = NULL;
	PDFWriter* _tmp414_ = NULL;
	gsize _tmp415_ = 0UL;
	gchar* _tmp416_ = NULL;
	gchar* _tmp417_ = NULL;
	PDFWriter* _tmp418_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_strdup ("");
	id = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gint _tmp4_ = 0;
				const gchar* _tmp5_ = NULL;
				guint32 _tmp6_ = 0U;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_ = 0;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < 4)) {
					break;
				}
				_tmp5_ = id;
				_tmp6_ = g_random_int ();
				_tmp7_ = g_strdup_printf ("%08x", (guint) _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat (_tmp5_, _tmp8_, NULL);
				_g_free0 (id);
				id = _tmp9_;
				_g_free0 (_tmp8_);
			}
		}
	}
	_tmp10_ = file;
	_tmp11_ = g_file_replace (_tmp10_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
	stream = _tmp11_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (id);
		return;
	}
	_tmp12_ = pdf_writer_new (stream);
	writer = _tmp12_;
	_tmp13_ = writer;
	pdf_writer_write_string (_tmp13_, "%PDF-1.3\n");
	_tmp14_ = writer;
	pdf_writer_write_string (_tmp14_, "%\xe2\xe3\xcf\xd3\n");
	_tmp15_ = writer;
	_tmp16_ = pdf_writer_start_object (_tmp15_);
	catalog_number = _tmp16_;
	_tmp17_ = writer;
	_tmp18_ = catalog_number;
	_tmp19_ = g_strdup_printf ("%u 0 obj\n", _tmp18_);
	_tmp20_ = _tmp19_;
	pdf_writer_write_string (_tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = writer;
	pdf_writer_write_string (_tmp21_, "<<\n");
	_tmp22_ = writer;
	pdf_writer_write_string (_tmp22_, "/Type /Catalog\n");
	_tmp23_ = writer;
	_tmp24_ = catalog_number;
	_tmp25_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp24_ + 1);
	_tmp26_ = _tmp25_;
	pdf_writer_write_string (_tmp23_, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = writer;
	pdf_writer_write_string (_tmp27_, ">>\n");
	_tmp28_ = writer;
	pdf_writer_write_string (_tmp28_, "endobj\n");
	_tmp29_ = writer;
	pdf_writer_write_string (_tmp29_, "\n");
	_tmp30_ = writer;
	_tmp31_ = pdf_writer_start_object (_tmp30_);
	pages_number = _tmp31_;
	_tmp32_ = writer;
	_tmp33_ = pages_number;
	_tmp34_ = g_strdup_printf ("%u 0 obj\n", _tmp33_);
	_tmp35_ = _tmp34_;
	pdf_writer_write_string (_tmp32_, _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = writer;
	pdf_writer_write_string (_tmp36_, "<<\n");
	_tmp37_ = writer;
	pdf_writer_write_string (_tmp37_, "/Type /Pages\n");
	_tmp38_ = writer;
	pdf_writer_write_string (_tmp38_, "/Kids [");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp39_ = FALSE;
			_tmp39_ = TRUE;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				gint _tmp42_ = 0;
				guint _tmp43_ = 0U;
				PDFWriter* _tmp44_ = NULL;
				guint _tmp45_ = 0U;
				gint _tmp46_ = 0;
				gchar* _tmp47_ = NULL;
				gchar* _tmp48_ = NULL;
				_tmp40_ = _tmp39_;
				if (!_tmp40_) {
					gint _tmp41_ = 0;
					_tmp41_ = i;
					i = _tmp41_ + 1;
				}
				_tmp39_ = FALSE;
				_tmp42_ = i;
				_tmp43_ = book_get_n_pages (self);
				if (!(((guint) _tmp42_) < _tmp43_)) {
					break;
				}
				_tmp44_ = writer;
				_tmp45_ = pages_number;
				_tmp46_ = i;
				_tmp47_ = g_strdup_printf (" %u 0 R", (_tmp45_ + 1) + (_tmp46_ * 3));
				_tmp48_ = _tmp47_;
				pdf_writer_write_string (_tmp44_, _tmp48_);
				_g_free0 (_tmp48_);
			}
		}
	}
	_tmp49_ = writer;
	pdf_writer_write_string (_tmp49_, " ]\n");
	_tmp50_ = writer;
	_tmp51_ = book_get_n_pages (self);
	_tmp52_ = g_strdup_printf ("/Count %u\n", _tmp51_);
	_tmp53_ = _tmp52_;
	pdf_writer_write_string (_tmp50_, _tmp53_);
	_g_free0 (_tmp53_);
	_tmp54_ = writer;
	pdf_writer_write_string (_tmp54_, ">>\n");
	_tmp55_ = writer;
	pdf_writer_write_string (_tmp55_, "endobj\n");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp56_ = FALSE;
			_tmp56_ = TRUE;
			while (TRUE) {
				gboolean _tmp57_ = FALSE;
				gint _tmp59_ = 0;
				guint _tmp60_ = 0U;
				Page* page = NULL;
				gint _tmp61_ = 0;
				Page* _tmp62_ = NULL;
				GdkPixbuf* image = NULL;
				Page* _tmp63_ = NULL;
				GdkPixbuf* _tmp64_ = NULL;
				gint width = 0;
				GdkPixbuf* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gint height = 0;
				GdkPixbuf* _tmp67_ = NULL;
				gint _tmp68_ = 0;
				guint8* pixels = NULL;
				GdkPixbuf* _tmp69_ = NULL;
				guint8* _tmp70_ = NULL;
				gint pixels_length1 = 0;
				gint _pixels_size_ = 0;
				gdouble page_width = 0.0;
				gint _tmp71_ = 0;
				Page* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				gdouble page_height = 0.0;
				gint _tmp74_ = 0;
				Page* _tmp75_ = NULL;
				gint _tmp76_ = 0;
				gint depth = 0;
				gchar* color_space = NULL;
				gchar* _tmp77_ = NULL;
				gchar* filter = NULL;
				gchar* width_buffer = NULL;
				gchar* _tmp78_ = NULL;
				gint width_buffer_length1 = 0;
				gint _width_buffer_size_ = 0;
				gchar* height_buffer = NULL;
				gchar* _tmp79_ = NULL;
				gint height_buffer_length1 = 0;
				gint _height_buffer_size_ = 0;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp80_ = NULL;
				gboolean _tmp81_ = FALSE;
				guint8* compressed_data = NULL;
				guint8* _tmp237_ = NULL;
				gint _tmp237__length1 = 0;
				gint _tmp238_ = 0;
				guint8* _tmp239_ = NULL;
				gint compressed_data_length1 = 0;
				gint _compressed_data_size_ = 0;
				guint8* _tmp240_ = NULL;
				gint _tmp240__length1 = 0;
				PDFWriter* _tmp255_ = NULL;
				guint number = 0U;
				PDFWriter* _tmp256_ = NULL;
				guint _tmp257_ = 0U;
				PDFWriter* _tmp258_ = NULL;
				guint _tmp259_ = 0U;
				gchar* _tmp260_ = NULL;
				gchar* _tmp261_ = NULL;
				PDFWriter* _tmp262_ = NULL;
				PDFWriter* _tmp263_ = NULL;
				PDFWriter* _tmp264_ = NULL;
				guint _tmp265_ = 0U;
				gchar* _tmp266_ = NULL;
				gchar* _tmp267_ = NULL;
				PDFWriter* _tmp268_ = NULL;
				gint _tmp269_ = 0;
				guint _tmp270_ = 0U;
				gchar* _tmp271_ = NULL;
				gchar* _tmp272_ = NULL;
				PDFWriter* _tmp273_ = NULL;
				gdouble _tmp274_ = 0.0;
				gchar* _tmp275_ = NULL;
				gint _tmp275__length1 = 0;
				const gchar* _tmp276_ = NULL;
				gdouble _tmp277_ = 0.0;
				gchar* _tmp278_ = NULL;
				gint _tmp278__length1 = 0;
				const gchar* _tmp279_ = NULL;
				gchar* _tmp280_ = NULL;
				gchar* _tmp281_ = NULL;
				PDFWriter* _tmp282_ = NULL;
				guint _tmp283_ = 0U;
				gchar* _tmp284_ = NULL;
				gchar* _tmp285_ = NULL;
				PDFWriter* _tmp286_ = NULL;
				PDFWriter* _tmp287_ = NULL;
				PDFWriter* _tmp288_ = NULL;
				PDFWriter* _tmp289_ = NULL;
				guint _tmp290_ = 0U;
				PDFWriter* _tmp291_ = NULL;
				guint _tmp292_ = 0U;
				gchar* _tmp293_ = NULL;
				gchar* _tmp294_ = NULL;
				PDFWriter* _tmp295_ = NULL;
				PDFWriter* _tmp296_ = NULL;
				PDFWriter* _tmp297_ = NULL;
				PDFWriter* _tmp298_ = NULL;
				gint _tmp299_ = 0;
				gchar* _tmp300_ = NULL;
				gchar* _tmp301_ = NULL;
				PDFWriter* _tmp302_ = NULL;
				gint _tmp303_ = 0;
				gchar* _tmp304_ = NULL;
				gchar* _tmp305_ = NULL;
				PDFWriter* _tmp306_ = NULL;
				const gchar* _tmp307_ = NULL;
				gchar* _tmp308_ = NULL;
				gchar* _tmp309_ = NULL;
				PDFWriter* _tmp310_ = NULL;
				gint _tmp311_ = 0;
				gchar* _tmp312_ = NULL;
				gchar* _tmp313_ = NULL;
				PDFWriter* _tmp314_ = NULL;
				guint8* _tmp315_ = NULL;
				gint _tmp315__length1 = 0;
				gchar* _tmp316_ = NULL;
				gchar* _tmp317_ = NULL;
				const gchar* _tmp318_ = NULL;
				PDFWriter* _tmp323_ = NULL;
				PDFWriter* _tmp324_ = NULL;
				PDFWriter* _tmp325_ = NULL;
				guint8* _tmp326_ = NULL;
				gint _tmp326__length1 = 0;
				PDFWriter* _tmp327_ = NULL;
				PDFWriter* _tmp328_ = NULL;
				PDFWriter* _tmp329_ = NULL;
				gchar* command = NULL;
				gdouble _tmp330_ = 0.0;
				gchar* _tmp331_ = NULL;
				gint _tmp331__length1 = 0;
				const gchar* _tmp332_ = NULL;
				gdouble _tmp333_ = 0.0;
				gchar* _tmp334_ = NULL;
				gint _tmp334__length1 = 0;
				const gchar* _tmp335_ = NULL;
				gint _tmp336_ = 0;
				gchar* _tmp337_ = NULL;
				PDFWriter* _tmp338_ = NULL;
				PDFWriter* _tmp339_ = NULL;
				guint _tmp340_ = 0U;
				PDFWriter* _tmp341_ = NULL;
				guint _tmp342_ = 0U;
				gchar* _tmp343_ = NULL;
				gchar* _tmp344_ = NULL;
				PDFWriter* _tmp345_ = NULL;
				PDFWriter* _tmp346_ = NULL;
				const gchar* _tmp347_ = NULL;
				gint _tmp348_ = 0;
				gint _tmp349_ = 0;
				gchar* _tmp350_ = NULL;
				gchar* _tmp351_ = NULL;
				PDFWriter* _tmp352_ = NULL;
				PDFWriter* _tmp353_ = NULL;
				PDFWriter* _tmp354_ = NULL;
				const gchar* _tmp355_ = NULL;
				PDFWriter* _tmp356_ = NULL;
				PDFWriter* _tmp357_ = NULL;
				PDFWriter* _tmp358_ = NULL;
				gint _tmp359_ = 0;
				_tmp57_ = _tmp56_;
				if (!_tmp57_) {
					gint _tmp58_ = 0;
					_tmp58_ = i;
					i = _tmp58_ + 1;
				}
				_tmp56_ = FALSE;
				_tmp59_ = i;
				_tmp60_ = book_get_n_pages (self);
				if (!(((guint) _tmp59_) < _tmp60_)) {
					break;
				}
				_tmp61_ = i;
				_tmp62_ = book_get_page (self, _tmp61_);
				page = _tmp62_;
				_tmp63_ = page;
				_tmp64_ = page_get_image (_tmp63_, TRUE);
				image = _tmp64_;
				_tmp65_ = image;
				_tmp66_ = gdk_pixbuf_get_width (_tmp65_);
				width = _tmp66_;
				_tmp67_ = image;
				_tmp68_ = gdk_pixbuf_get_height (_tmp67_);
				height = _tmp68_;
				_tmp69_ = image;
				_tmp70_ = gdk_pixbuf_get_pixels (_tmp69_);
				pixels = _tmp70_;
				pixels_length1 = -1;
				_pixels_size_ = pixels_length1;
				_tmp71_ = width;
				_tmp72_ = page;
				_tmp73_ = page_get_dpi (_tmp72_);
				page_width = (_tmp71_ * 72.0) / _tmp73_;
				_tmp74_ = height;
				_tmp75_ = page;
				_tmp76_ = page_get_dpi (_tmp75_);
				page_height = (_tmp74_ * 72.0) / _tmp76_;
				depth = 8;
				_tmp77_ = g_strdup ("DeviceRGB");
				color_space = _tmp77_;
				filter = NULL;
				_tmp78_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
				width_buffer = _tmp78_;
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
				_width_buffer_size_ = width_buffer_length1;
				_tmp79_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
				height_buffer = _tmp79_;
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
				_height_buffer_size_ = height_buffer_length1;
				_tmp80_ = page;
				_tmp81_ = page_is_color (_tmp80_);
				if (_tmp81_) {
					gchar* _tmp82_ = NULL;
					gint data_length = 0;
					gint _tmp83_ = 0;
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					guint8* _tmp86_ = NULL;
					depth = 8;
					_tmp82_ = g_strdup ("DeviceRGB");
					_g_free0 (color_space);
					color_space = _tmp82_;
					_tmp83_ = height;
					_tmp84_ = width;
					data_length = (_tmp83_ * _tmp84_) * 3;
					_tmp85_ = data_length;
					_tmp86_ = g_new0 (guint8, _tmp85_);
					data = (g_free (data), NULL);
					data = _tmp86_;
					data_length1 = _tmp85_;
					_data_size_ = data_length1;
					{
						gint row = 0;
						row = 0;
						{
							gboolean _tmp87_ = FALSE;
							_tmp87_ = TRUE;
							while (TRUE) {
								gboolean _tmp88_ = FALSE;
								gint _tmp90_ = 0;
								gint _tmp91_ = 0;
								gint in_offset = 0;
								gint _tmp92_ = 0;
								GdkPixbuf* _tmp93_ = NULL;
								gint _tmp94_ = 0;
								gint out_offset = 0;
								gint _tmp95_ = 0;
								gint _tmp96_ = 0;
								_tmp88_ = _tmp87_;
								if (!_tmp88_) {
									gint _tmp89_ = 0;
									_tmp89_ = row;
									row = _tmp89_ + 1;
								}
								_tmp87_ = FALSE;
								_tmp90_ = row;
								_tmp91_ = height;
								if (!(_tmp90_ < _tmp91_)) {
									break;
								}
								_tmp92_ = row;
								_tmp93_ = image;
								_tmp94_ = gdk_pixbuf_get_rowstride (_tmp93_);
								in_offset = _tmp92_ * _tmp94_;
								_tmp95_ = row;
								_tmp96_ = width;
								out_offset = (_tmp95_ * _tmp96_) * 3;
								{
									gint x = 0;
									x = 0;
									{
										gboolean _tmp97_ = FALSE;
										_tmp97_ = TRUE;
										while (TRUE) {
											gboolean _tmp98_ = FALSE;
											gint _tmp100_ = 0;
											gint _tmp101_ = 0;
											gint in_o = 0;
											gint _tmp102_ = 0;
											gint _tmp103_ = 0;
											gint out_o = 0;
											gint _tmp104_ = 0;
											gint _tmp105_ = 0;
											guint8* _tmp106_ = NULL;
											gint _tmp106__length1 = 0;
											gint _tmp107_ = 0;
											guint8* _tmp108_ = NULL;
											gint _tmp108__length1 = 0;
											gint _tmp109_ = 0;
											guint8 _tmp110_ = 0U;
											guint8 _tmp111_ = 0U;
											guint8* _tmp112_ = NULL;
											gint _tmp112__length1 = 0;
											gint _tmp113_ = 0;
											guint8* _tmp114_ = NULL;
											gint _tmp114__length1 = 0;
											gint _tmp115_ = 0;
											guint8 _tmp116_ = 0U;
											guint8 _tmp117_ = 0U;
											guint8* _tmp118_ = NULL;
											gint _tmp118__length1 = 0;
											gint _tmp119_ = 0;
											guint8* _tmp120_ = NULL;
											gint _tmp120__length1 = 0;
											gint _tmp121_ = 0;
											guint8 _tmp122_ = 0U;
											guint8 _tmp123_ = 0U;
											_tmp98_ = _tmp97_;
											if (!_tmp98_) {
												gint _tmp99_ = 0;
												_tmp99_ = x;
												x = _tmp99_ + 1;
											}
											_tmp97_ = FALSE;
											_tmp100_ = x;
											_tmp101_ = width;
											if (!(_tmp100_ < _tmp101_)) {
												break;
											}
											_tmp102_ = in_offset;
											_tmp103_ = x;
											in_o = _tmp102_ + (_tmp103_ * 3);
											_tmp104_ = out_offset;
											_tmp105_ = x;
											out_o = _tmp104_ + (_tmp105_ * 3);
											_tmp106_ = data;
											_tmp106__length1 = data_length1;
											_tmp107_ = out_o;
											_tmp108_ = pixels;
											_tmp108__length1 = pixels_length1;
											_tmp109_ = in_o;
											_tmp110_ = _tmp108_[_tmp109_];
											_tmp106_[_tmp107_] = _tmp110_;
											_tmp111_ = _tmp106_[_tmp107_];
											_tmp112_ = data;
											_tmp112__length1 = data_length1;
											_tmp113_ = out_o;
											_tmp114_ = pixels;
											_tmp114__length1 = pixels_length1;
											_tmp115_ = in_o;
											_tmp116_ = _tmp114_[_tmp115_ + 1];
											_tmp112_[_tmp113_ + 1] = _tmp116_;
											_tmp117_ = _tmp112_[_tmp113_ + 1];
											_tmp118_ = data;
											_tmp118__length1 = data_length1;
											_tmp119_ = out_o;
											_tmp120_ = pixels;
											_tmp120__length1 = pixels_length1;
											_tmp121_ = in_o;
											_tmp122_ = _tmp120_[_tmp121_ + 2];
											_tmp118_[_tmp119_ + 2] = _tmp122_;
											_tmp123_ = _tmp118_[_tmp119_ + 2];
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp124_ = NULL;
					gint _tmp125_ = 0;
					_tmp124_ = page;
					_tmp125_ = page_get_depth (_tmp124_);
					if (_tmp125_ == 2) {
						gint shift_count = 0;
						gchar* _tmp126_ = NULL;
						gint data_length = 0;
						gint _tmp127_ = 0;
						gint _tmp128_ = 0;
						gint _tmp129_ = 0;
						guint8* _tmp130_ = NULL;
						gint offset = 0;
						shift_count = 6;
						depth = 2;
						_tmp126_ = g_strdup ("DeviceGray");
						_g_free0 (color_space);
						color_space = _tmp126_;
						_tmp127_ = height;
						_tmp128_ = width;
						data_length = _tmp127_ * (((_tmp128_ * 2) + 7) / 8);
						_tmp129_ = data_length;
						_tmp130_ = g_new0 (guint8, _tmp129_);
						data = (g_free (data), NULL);
						data = _tmp130_;
						data_length1 = _tmp129_;
						_data_size_ = data_length1;
						offset = 0;
						{
							gint row = 0;
							row = 0;
							{
								gboolean _tmp131_ = FALSE;
								_tmp131_ = TRUE;
								while (TRUE) {
									gboolean _tmp132_ = FALSE;
									gint _tmp134_ = 0;
									gint _tmp135_ = 0;
									gint _tmp136_ = 0;
									gint in_offset = 0;
									gint _tmp138_ = 0;
									GdkPixbuf* _tmp139_ = NULL;
									gint _tmp140_ = 0;
									_tmp132_ = _tmp131_;
									if (!_tmp132_) {
										gint _tmp133_ = 0;
										_tmp133_ = row;
										row = _tmp133_ + 1;
									}
									_tmp131_ = FALSE;
									_tmp134_ = row;
									_tmp135_ = height;
									if (!(_tmp134_ < _tmp135_)) {
										break;
									}
									_tmp136_ = shift_count;
									if (_tmp136_ != 6) {
										gint _tmp137_ = 0;
										_tmp137_ = offset;
										offset = _tmp137_ + 1;
										shift_count = 6;
									}
									_tmp138_ = row;
									_tmp139_ = image;
									_tmp140_ = gdk_pixbuf_get_rowstride (_tmp139_);
									in_offset = _tmp138_ * _tmp140_;
									{
										gint x = 0;
										x = 0;
										{
											gboolean _tmp141_ = FALSE;
											_tmp141_ = TRUE;
											while (TRUE) {
												gboolean _tmp142_ = FALSE;
												gint _tmp144_ = 0;
												gint _tmp145_ = 0;
												gint _tmp146_ = 0;
												guint8 p = 0U;
												guint8* _tmp150_ = NULL;
												gint _tmp150__length1 = 0;
												gint _tmp151_ = 0;
												gint _tmp152_ = 0;
												guint8 _tmp153_ = 0U;
												guint8 _tmp154_ = 0U;
												gint _tmp169_ = 0;
												_tmp142_ = _tmp141_;
												if (!_tmp142_) {
													gint _tmp143_ = 0;
													_tmp143_ = x;
													x = _tmp143_ + 1;
												}
												_tmp141_ = FALSE;
												_tmp144_ = x;
												_tmp145_ = width;
												if (!(_tmp144_ < _tmp145_)) {
													break;
												}
												_tmp146_ = shift_count;
												if (_tmp146_ == 6) {
													guint8* _tmp147_ = NULL;
													gint _tmp147__length1 = 0;
													gint _tmp148_ = 0;
													guint8 _tmp149_ = 0U;
													_tmp147_ = data;
													_tmp147__length1 = data_length1;
													_tmp148_ = offset;
													_tmp147_[_tmp148_] = (guint8) 0;
													_tmp149_ = _tmp147_[_tmp148_];
												}
												_tmp150_ = pixels;
												_tmp150__length1 = pixels_length1;
												_tmp151_ = in_offset;
												_tmp152_ = x;
												_tmp153_ = _tmp150_[_tmp151_ + (_tmp152_ * 3)];
												p = _tmp153_;
												_tmp154_ = p;
												if (((gint) _tmp154_) >= 192) {
													guint8* _tmp155_ = NULL;
													gint _tmp155__length1 = 0;
													gint _tmp156_ = 0;
													gint _tmp157_ = 0;
													guint8 _tmp158_ = 0U;
													_tmp155_ = data;
													_tmp155__length1 = data_length1;
													_tmp156_ = offset;
													_tmp157_ = shift_count;
													_tmp155_[_tmp156_] |= (guint8) (3 << _tmp157_);
													_tmp158_ = _tmp155_[_tmp156_];
												} else {
													guint8 _tmp159_ = 0U;
													_tmp159_ = p;
													if (((gint) _tmp159_) >= 128) {
														guint8* _tmp160_ = NULL;
														gint _tmp160__length1 = 0;
														gint _tmp161_ = 0;
														gint _tmp162_ = 0;
														guint8 _tmp163_ = 0U;
														_tmp160_ = data;
														_tmp160__length1 = data_length1;
														_tmp161_ = offset;
														_tmp162_ = shift_count;
														_tmp160_[_tmp161_] |= (guint8) (2 << _tmp162_);
														_tmp163_ = _tmp160_[_tmp161_];
													} else {
														guint8 _tmp164_ = 0U;
														_tmp164_ = p;
														if (((gint) _tmp164_) >= 64) {
															guint8* _tmp165_ = NULL;
															gint _tmp165__length1 = 0;
															gint _tmp166_ = 0;
															gint _tmp167_ = 0;
															guint8 _tmp168_ = 0U;
															_tmp165_ = data;
															_tmp165__length1 = data_length1;
															_tmp166_ = offset;
															_tmp167_ = shift_count;
															_tmp165_[_tmp166_] |= (guint8) (1 << _tmp167_);
															_tmp168_ = _tmp165_[_tmp166_];
														}
													}
												}
												_tmp169_ = shift_count;
												if (_tmp169_ == 0) {
													gint _tmp170_ = 0;
													_tmp170_ = offset;
													offset = _tmp170_ + 1;
													shift_count = 6;
												} else {
													gint _tmp171_ = 0;
													_tmp171_ = shift_count;
													shift_count = _tmp171_ - 2;
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp172_ = NULL;
						gint _tmp173_ = 0;
						_tmp172_ = page;
						_tmp173_ = page_get_depth (_tmp172_);
						if (_tmp173_ == 1) {
							gint mask = 0;
							gchar* _tmp174_ = NULL;
							gint data_length = 0;
							gint _tmp175_ = 0;
							gint _tmp176_ = 0;
							gint _tmp177_ = 0;
							guint8* _tmp178_ = NULL;
							gint offset = 0;
							mask = 0x80;
							depth = 1;
							_tmp174_ = g_strdup ("DeviceGray");
							_g_free0 (color_space);
							color_space = _tmp174_;
							_tmp175_ = height;
							_tmp176_ = width;
							data_length = _tmp175_ * ((_tmp176_ + 7) / 8);
							_tmp177_ = data_length;
							_tmp178_ = g_new0 (guint8, _tmp177_);
							data = (g_free (data), NULL);
							data = _tmp178_;
							data_length1 = _tmp177_;
							_data_size_ = data_length1;
							offset = 0;
							{
								gint row = 0;
								row = 0;
								{
									gboolean _tmp179_ = FALSE;
									_tmp179_ = TRUE;
									while (TRUE) {
										gboolean _tmp180_ = FALSE;
										gint _tmp182_ = 0;
										gint _tmp183_ = 0;
										gint _tmp184_ = 0;
										gint in_offset = 0;
										gint _tmp186_ = 0;
										GdkPixbuf* _tmp187_ = NULL;
										gint _tmp188_ = 0;
										_tmp180_ = _tmp179_;
										if (!_tmp180_) {
											gint _tmp181_ = 0;
											_tmp181_ = row;
											row = _tmp181_ + 1;
										}
										_tmp179_ = FALSE;
										_tmp182_ = row;
										_tmp183_ = height;
										if (!(_tmp182_ < _tmp183_)) {
											break;
										}
										_tmp184_ = mask;
										if (_tmp184_ != 0x80) {
											gint _tmp185_ = 0;
											_tmp185_ = offset;
											offset = _tmp185_ + 1;
											mask = 0x80;
										}
										_tmp186_ = row;
										_tmp187_ = image;
										_tmp188_ = gdk_pixbuf_get_rowstride (_tmp187_);
										in_offset = _tmp186_ * _tmp188_;
										{
											gint x = 0;
											x = 0;
											{
												gboolean _tmp189_ = FALSE;
												_tmp189_ = TRUE;
												while (TRUE) {
													gboolean _tmp190_ = FALSE;
													gint _tmp192_ = 0;
													gint _tmp193_ = 0;
													gint _tmp194_ = 0;
													guint8* _tmp198_ = NULL;
													gint _tmp198__length1 = 0;
													gint _tmp199_ = 0;
													gint _tmp200_ = 0;
													guint8 _tmp201_ = 0U;
													gint _tmp206_ = 0;
													gint _tmp207_ = 0;
													_tmp190_ = _tmp189_;
													if (!_tmp190_) {
														gint _tmp191_ = 0;
														_tmp191_ = x;
														x = _tmp191_ + 1;
													}
													_tmp189_ = FALSE;
													_tmp192_ = x;
													_tmp193_ = width;
													if (!(_tmp192_ < _tmp193_)) {
														break;
													}
													_tmp194_ = mask;
													if (_tmp194_ == 0x80) {
														guint8* _tmp195_ = NULL;
														gint _tmp195__length1 = 0;
														gint _tmp196_ = 0;
														guint8 _tmp197_ = 0U;
														_tmp195_ = data;
														_tmp195__length1 = data_length1;
														_tmp196_ = offset;
														_tmp195_[_tmp196_] = (guint8) 0;
														_tmp197_ = _tmp195_[_tmp196_];
													}
													_tmp198_ = pixels;
													_tmp198__length1 = pixels_length1;
													_tmp199_ = in_offset;
													_tmp200_ = x;
													_tmp201_ = _tmp198_[_tmp199_ + (_tmp200_ * 3)];
													if (((gint) _tmp201_) != 0) {
														guint8* _tmp202_ = NULL;
														gint _tmp202__length1 = 0;
														gint _tmp203_ = 0;
														gint _tmp204_ = 0;
														guint8 _tmp205_ = 0U;
														_tmp202_ = data;
														_tmp202__length1 = data_length1;
														_tmp203_ = offset;
														_tmp204_ = mask;
														_tmp202_[_tmp203_] |= (guint8) _tmp204_;
														_tmp205_ = _tmp202_[_tmp203_];
													}
													_tmp206_ = mask;
													mask = _tmp206_ >> 1;
													_tmp207_ = mask;
													if (_tmp207_ == 0) {
														gint _tmp208_ = 0;
														_tmp208_ = offset;
														offset = _tmp208_ + 1;
														mask = 0x80;
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp209_ = NULL;
							gint data_length = 0;
							gint _tmp210_ = 0;
							gint _tmp211_ = 0;
							gint _tmp212_ = 0;
							guint8* _tmp213_ = NULL;
							depth = 8;
							_tmp209_ = g_strdup ("DeviceGray");
							_g_free0 (color_space);
							color_space = _tmp209_;
							_tmp210_ = height;
							_tmp211_ = width;
							data_length = _tmp210_ * _tmp211_;
							_tmp212_ = data_length;
							_tmp213_ = g_new0 (guint8, _tmp212_);
							data = (g_free (data), NULL);
							data = _tmp213_;
							data_length1 = _tmp212_;
							_data_size_ = data_length1;
							{
								gint row = 0;
								row = 0;
								{
									gboolean _tmp214_ = FALSE;
									_tmp214_ = TRUE;
									while (TRUE) {
										gboolean _tmp215_ = FALSE;
										gint _tmp217_ = 0;
										gint _tmp218_ = 0;
										gint in_offset = 0;
										gint _tmp219_ = 0;
										GdkPixbuf* _tmp220_ = NULL;
										gint _tmp221_ = 0;
										gint out_offset = 0;
										gint _tmp222_ = 0;
										gint _tmp223_ = 0;
										_tmp215_ = _tmp214_;
										if (!_tmp215_) {
											gint _tmp216_ = 0;
											_tmp216_ = row;
											row = _tmp216_ + 1;
										}
										_tmp214_ = FALSE;
										_tmp217_ = row;
										_tmp218_ = height;
										if (!(_tmp217_ < _tmp218_)) {
											break;
										}
										_tmp219_ = row;
										_tmp220_ = image;
										_tmp221_ = gdk_pixbuf_get_rowstride (_tmp220_);
										in_offset = _tmp219_ * _tmp221_;
										_tmp222_ = row;
										_tmp223_ = width;
										out_offset = _tmp222_ * _tmp223_;
										{
											gint x = 0;
											x = 0;
											{
												gboolean _tmp224_ = FALSE;
												_tmp224_ = TRUE;
												while (TRUE) {
													gboolean _tmp225_ = FALSE;
													gint _tmp227_ = 0;
													gint _tmp228_ = 0;
													guint8* _tmp229_ = NULL;
													gint _tmp229__length1 = 0;
													gint _tmp230_ = 0;
													gint _tmp231_ = 0;
													guint8* _tmp232_ = NULL;
													gint _tmp232__length1 = 0;
													gint _tmp233_ = 0;
													gint _tmp234_ = 0;
													guint8 _tmp235_ = 0U;
													guint8 _tmp236_ = 0U;
													_tmp225_ = _tmp224_;
													if (!_tmp225_) {
														gint _tmp226_ = 0;
														_tmp226_ = x;
														x = _tmp226_ + 1;
													}
													_tmp224_ = FALSE;
													_tmp227_ = x;
													_tmp228_ = width;
													if (!(_tmp227_ < _tmp228_)) {
														break;
													}
													_tmp229_ = data;
													_tmp229__length1 = data_length1;
													_tmp230_ = out_offset;
													_tmp231_ = x;
													_tmp232_ = pixels;
													_tmp232__length1 = pixels_length1;
													_tmp233_ = in_offset;
													_tmp234_ = x;
													_tmp235_ = _tmp232_[_tmp233_ + (_tmp234_ * 3)];
													_tmp229_[_tmp230_ + _tmp231_] = _tmp235_;
													_tmp236_ = _tmp229_[_tmp230_ + _tmp231_];
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp237_ = data;
				_tmp237__length1 = data_length1;
				_tmp239_ = book_compress_zlib (self, _tmp237_, _tmp237__length1, &_tmp238_);
				compressed_data = _tmp239_;
				compressed_data_length1 = _tmp238_;
				_compressed_data_size_ = compressed_data_length1;
				_tmp240_ = compressed_data;
				_tmp240__length1 = compressed_data_length1;
				if (_tmp240_ != NULL) {
					gint _tmp241_ = 0;
					const gchar* _tmp251_ = NULL;
					_tmp241_ = depth;
					if (_tmp241_ > 1) {
						gsize jpeg_length = 0UL;
						guint8* jpeg_data = NULL;
						GdkPixbuf* _tmp242_ = NULL;
						gsize _tmp243_ = 0UL;
						gint _tmp244_ = 0;
						guint8* _tmp245_ = NULL;
						gint jpeg_data_length1 = 0;
						gint _jpeg_data_size_ = 0;
						gsize _tmp246_ = 0UL;
						guint8* _tmp247_ = NULL;
						gint _tmp247__length1 = 0;
						_tmp242_ = image;
						_tmp245_ = book_compress_jpeg (self, _tmp242_, &_tmp243_, &_tmp244_);
						jpeg_length = _tmp243_;
						jpeg_data = _tmp245_;
						jpeg_data_length1 = _tmp244_;
						_jpeg_data_size_ = jpeg_data_length1;
						_tmp246_ = jpeg_length;
						_tmp247_ = compressed_data;
						_tmp247__length1 = compressed_data_length1;
						if (_tmp246_ < ((gsize) _tmp247__length1)) {
							gchar* _tmp248_ = NULL;
							guint8* _tmp249_ = NULL;
							gint _tmp249__length1 = 0;
							guint8* _tmp250_ = NULL;
							gint _tmp250__length1 = 0;
							_tmp248_ = g_strdup ("DCTDecode");
							_g_free0 (filter);
							filter = _tmp248_;
							_tmp249_ = jpeg_data;
							_tmp249__length1 = jpeg_data_length1;
							_tmp250_ = (_tmp249_ != NULL) ? _vala_array_dup1 (_tmp249_, _tmp249__length1) : ((gpointer) _tmp249_);
							_tmp250__length1 = _tmp249__length1;
							data = (g_free (data), NULL);
							data = _tmp250_;
							data_length1 = _tmp250__length1;
							_data_size_ = data_length1;
						}
						jpeg_data = (g_free (jpeg_data), NULL);
					}
					_tmp251_ = filter;
					if (_tmp251_ == NULL) {
						gchar* _tmp252_ = NULL;
						guint8* _tmp253_ = NULL;
						gint _tmp253__length1 = 0;
						guint8* _tmp254_ = NULL;
						gint _tmp254__length1 = 0;
						_tmp252_ = g_strdup ("FlateDecode");
						_g_free0 (filter);
						filter = _tmp252_;
						_tmp253_ = compressed_data;
						_tmp253__length1 = compressed_data_length1;
						_tmp254_ = (_tmp253_ != NULL) ? _vala_array_dup2 (_tmp253_, _tmp253__length1) : ((gpointer) _tmp253_);
						_tmp254__length1 = _tmp253__length1;
						data = (g_free (data), NULL);
						data = _tmp254_;
						data_length1 = _tmp254__length1;
						_data_size_ = data_length1;
					}
				}
				_tmp255_ = writer;
				pdf_writer_write_string (_tmp255_, "\n");
				_tmp256_ = writer;
				_tmp257_ = pdf_writer_start_object (_tmp256_);
				number = _tmp257_;
				_tmp258_ = writer;
				_tmp259_ = number;
				_tmp260_ = g_strdup_printf ("%u 0 obj\n", _tmp259_);
				_tmp261_ = _tmp260_;
				pdf_writer_write_string (_tmp258_, _tmp261_);
				_g_free0 (_tmp261_);
				_tmp262_ = writer;
				pdf_writer_write_string (_tmp262_, "<<\n");
				_tmp263_ = writer;
				pdf_writer_write_string (_tmp263_, "/Type /Page\n");
				_tmp264_ = writer;
				_tmp265_ = pages_number;
				_tmp266_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp265_);
				_tmp267_ = _tmp266_;
				pdf_writer_write_string (_tmp264_, _tmp267_);
				_g_free0 (_tmp267_);
				_tmp268_ = writer;
				_tmp269_ = i;
				_tmp270_ = number;
				_tmp271_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp269_, _tmp270_ + 1);
				_tmp272_ = _tmp271_;
				pdf_writer_write_string (_tmp268_, _tmp272_);
				_g_free0 (_tmp272_);
				_tmp273_ = writer;
				_tmp274_ = page_width;
				_tmp275_ = width_buffer;
				_tmp275__length1 = width_buffer_length1;
				_tmp276_ = g_ascii_formatd (_tmp275_, _tmp275__length1, "%.2f", _tmp274_);
				_tmp277_ = page_height;
				_tmp278_ = height_buffer;
				_tmp278__length1 = height_buffer_length1;
				_tmp279_ = g_ascii_formatd (_tmp278_, _tmp278__length1, "%.2f", _tmp277_);
				_tmp280_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp276_, _tmp279_);
				_tmp281_ = _tmp280_;
				pdf_writer_write_string (_tmp273_, _tmp281_);
				_g_free0 (_tmp281_);
				_tmp282_ = writer;
				_tmp283_ = number;
				_tmp284_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp283_ + 2);
				_tmp285_ = _tmp284_;
				pdf_writer_write_string (_tmp282_, _tmp285_);
				_g_free0 (_tmp285_);
				_tmp286_ = writer;
				pdf_writer_write_string (_tmp286_, ">>\n");
				_tmp287_ = writer;
				pdf_writer_write_string (_tmp287_, "endobj\n");
				_tmp288_ = writer;
				pdf_writer_write_string (_tmp288_, "\n");
				_tmp289_ = writer;
				_tmp290_ = pdf_writer_start_object (_tmp289_);
				number = _tmp290_;
				_tmp291_ = writer;
				_tmp292_ = number;
				_tmp293_ = g_strdup_printf ("%u 0 obj\n", _tmp292_);
				_tmp294_ = _tmp293_;
				pdf_writer_write_string (_tmp291_, _tmp294_);
				_g_free0 (_tmp294_);
				_tmp295_ = writer;
				pdf_writer_write_string (_tmp295_, "<<\n");
				_tmp296_ = writer;
				pdf_writer_write_string (_tmp296_, "/Type /XObject\n");
				_tmp297_ = writer;
				pdf_writer_write_string (_tmp297_, "/Subtype /Image\n");
				_tmp298_ = writer;
				_tmp299_ = width;
				_tmp300_ = g_strdup_printf ("/Width %d\n", _tmp299_);
				_tmp301_ = _tmp300_;
				pdf_writer_write_string (_tmp298_, _tmp301_);
				_g_free0 (_tmp301_);
				_tmp302_ = writer;
				_tmp303_ = height;
				_tmp304_ = g_strdup_printf ("/Height %d\n", _tmp303_);
				_tmp305_ = _tmp304_;
				pdf_writer_write_string (_tmp302_, _tmp305_);
				_g_free0 (_tmp305_);
				_tmp306_ = writer;
				_tmp307_ = color_space;
				_tmp308_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp307_);
				_tmp309_ = _tmp308_;
				pdf_writer_write_string (_tmp306_, _tmp309_);
				_g_free0 (_tmp309_);
				_tmp310_ = writer;
				_tmp311_ = depth;
				_tmp312_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp311_);
				_tmp313_ = _tmp312_;
				pdf_writer_write_string (_tmp310_, _tmp313_);
				_g_free0 (_tmp313_);
				_tmp314_ = writer;
				_tmp315_ = data;
				_tmp315__length1 = data_length1;
				_tmp316_ = g_strdup_printf ("/Length %d\n", _tmp315__length1);
				_tmp317_ = _tmp316_;
				pdf_writer_write_string (_tmp314_, _tmp317_);
				_g_free0 (_tmp317_);
				_tmp318_ = filter;
				if (_tmp318_ != NULL) {
					PDFWriter* _tmp319_ = NULL;
					const gchar* _tmp320_ = NULL;
					gchar* _tmp321_ = NULL;
					gchar* _tmp322_ = NULL;
					_tmp319_ = writer;
					_tmp320_ = filter;
					_tmp321_ = g_strdup_printf ("/Filter /%s\n", _tmp320_);
					_tmp322_ = _tmp321_;
					pdf_writer_write_string (_tmp319_, _tmp322_);
					_g_free0 (_tmp322_);
				}
				_tmp323_ = writer;
				pdf_writer_write_string (_tmp323_, ">>\n");
				_tmp324_ = writer;
				pdf_writer_write_string (_tmp324_, "stream\n");
				_tmp325_ = writer;
				_tmp326_ = data;
				_tmp326__length1 = data_length1;
				pdf_writer_write (_tmp325_, _tmp326_, _tmp326__length1);
				_tmp327_ = writer;
				pdf_writer_write_string (_tmp327_, "\n");
				_tmp328_ = writer;
				pdf_writer_write_string (_tmp328_, "endstream\n");
				_tmp329_ = writer;
				pdf_writer_write_string (_tmp329_, "endobj\n");
				_tmp330_ = page_width;
				_tmp331_ = width_buffer;
				_tmp331__length1 = width_buffer_length1;
				_tmp332_ = g_ascii_formatd (_tmp331_, _tmp331__length1, "%f", _tmp330_);
				_tmp333_ = page_height;
				_tmp334_ = height_buffer;
				_tmp334__length1 = height_buffer_length1;
				_tmp335_ = g_ascii_formatd (_tmp334_, _tmp334__length1, "%f", _tmp333_);
				_tmp336_ = i;
				_tmp337_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp332_, _tmp335_, _tmp336_);
				command = _tmp337_;
				_tmp338_ = writer;
				pdf_writer_write_string (_tmp338_, "\n");
				_tmp339_ = writer;
				_tmp340_ = pdf_writer_start_object (_tmp339_);
				number = _tmp340_;
				_tmp341_ = writer;
				_tmp342_ = number;
				_tmp343_ = g_strdup_printf ("%u 0 obj\n", _tmp342_);
				_tmp344_ = _tmp343_;
				pdf_writer_write_string (_tmp341_, _tmp344_);
				_g_free0 (_tmp344_);
				_tmp345_ = writer;
				pdf_writer_write_string (_tmp345_, "<<\n");
				_tmp346_ = writer;
				_tmp347_ = command;
				_tmp348_ = strlen (_tmp347_);
				_tmp349_ = _tmp348_;
				_tmp350_ = g_strdup_printf ("/Length %d\n", _tmp349_);
				_tmp351_ = _tmp350_;
				pdf_writer_write_string (_tmp346_, _tmp351_);
				_g_free0 (_tmp351_);
				_tmp352_ = writer;
				pdf_writer_write_string (_tmp352_, ">>\n");
				_tmp353_ = writer;
				pdf_writer_write_string (_tmp353_, "stream\n");
				_tmp354_ = writer;
				_tmp355_ = command;
				pdf_writer_write_string (_tmp354_, _tmp355_);
				_tmp356_ = writer;
				pdf_writer_write_string (_tmp356_, "\n");
				_tmp357_ = writer;
				pdf_writer_write_string (_tmp357_, "endstream\n");
				_tmp358_ = writer;
				pdf_writer_write_string (_tmp358_, "endobj\n");
				_tmp359_ = i;
				g_signal_emit_by_name (self, "saving", _tmp359_);
				_g_free0 (command);
				compressed_data = (g_free (compressed_data), NULL);
				data = (g_free (data), NULL);
				height_buffer = (g_free (height_buffer), NULL);
				width_buffer = (g_free (width_buffer), NULL);
				_g_free0 (filter);
				_g_free0 (color_space);
				_g_object_unref0 (image);
				_page_unref0 (page);
			}
		}
	}
	_tmp360_ = writer;
	pdf_writer_write_string (_tmp360_, "\n");
	_tmp361_ = writer;
	_tmp362_ = pdf_writer_start_object (_tmp361_);
	info_number = _tmp362_;
	_tmp363_ = writer;
	_tmp364_ = info_number;
	_tmp365_ = g_strdup_printf ("%u 0 obj\n", _tmp364_);
	_tmp366_ = _tmp365_;
	pdf_writer_write_string (_tmp363_, _tmp366_);
	_g_free0 (_tmp366_);
	_tmp367_ = writer;
	pdf_writer_write_string (_tmp367_, "<<\n");
	_tmp368_ = writer;
	_tmp369_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
	_tmp370_ = _tmp369_;
	pdf_writer_write_string (_tmp368_, _tmp370_);
	_g_free0 (_tmp370_);
	_tmp371_ = writer;
	pdf_writer_write_string (_tmp371_, ">>\n");
	_tmp372_ = writer;
	pdf_writer_write_string (_tmp372_, "endobj\n");
	_tmp373_ = writer;
	pdf_writer_write_string (_tmp373_, "\n");
	_tmp374_ = writer;
	_tmp375_ = _tmp374_->offset;
	xref_offset = _tmp375_;
	_tmp376_ = writer;
	pdf_writer_write_string (_tmp376_, "xref\n");
	_tmp377_ = writer;
	_tmp378_ = writer;
	_tmp379_ = _tmp378_->object_offsets;
	_tmp380_ = g_list_length (_tmp379_);
	_tmp381_ = g_strdup_printf ("0 %zu\n", (gsize) (_tmp380_ + 1));
	_tmp382_ = _tmp381_;
	pdf_writer_write_string (_tmp377_, _tmp382_);
	_g_free0 (_tmp382_);
	_tmp383_ = writer;
	pdf_writer_write_string (_tmp383_, "0000000000 65535 f \n");
	_tmp384_ = writer;
	_tmp385_ = _tmp384_->object_offsets;
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
		offset_collection = _tmp385_;
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
			guint offset = 0U;
			offset = (guint) ((guintptr) offset_it->data);
			{
				PDFWriter* _tmp386_ = NULL;
				guint _tmp387_ = 0U;
				gchar* _tmp388_ = NULL;
				gchar* _tmp389_ = NULL;
				_tmp386_ = writer;
				_tmp387_ = offset;
				_tmp388_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp387_);
				_tmp389_ = _tmp388_;
				pdf_writer_write_string (_tmp386_, _tmp389_);
				_g_free0 (_tmp389_);
			}
		}
	}
	_tmp390_ = writer;
	pdf_writer_write_string (_tmp390_, "\n");
	_tmp391_ = writer;
	pdf_writer_write_string (_tmp391_, "trailer\n");
	_tmp392_ = writer;
	pdf_writer_write_string (_tmp392_, "<<\n");
	_tmp393_ = writer;
	_tmp394_ = writer;
	_tmp395_ = _tmp394_->object_offsets;
	_tmp396_ = g_list_length (_tmp395_);
	_tmp397_ = g_strdup_printf ("/Size %zu\n", (gsize) (_tmp396_ + 1));
	_tmp398_ = _tmp397_;
	pdf_writer_write_string (_tmp393_, _tmp398_);
	_g_free0 (_tmp398_);
	_tmp399_ = writer;
	_tmp400_ = info_number;
	_tmp401_ = g_strdup_printf ("/Info %u 0 R\n", _tmp400_);
	_tmp402_ = _tmp401_;
	pdf_writer_write_string (_tmp399_, _tmp402_);
	_g_free0 (_tmp402_);
	_tmp403_ = writer;
	_tmp404_ = catalog_number;
	_tmp405_ = g_strdup_printf ("/Root %u 0 R\n", _tmp404_);
	_tmp406_ = _tmp405_;
	pdf_writer_write_string (_tmp403_, _tmp406_);
	_g_free0 (_tmp406_);
	_tmp407_ = writer;
	_tmp408_ = id;
	_tmp409_ = id;
	_tmp410_ = g_strdup_printf ("/ID [<%s> <%s>]\n", _tmp408_, _tmp409_);
	_tmp411_ = _tmp410_;
	pdf_writer_write_string (_tmp407_, _tmp411_);
	_g_free0 (_tmp411_);
	_tmp412_ = writer;
	pdf_writer_write_string (_tmp412_, ">>\n");
	_tmp413_ = writer;
	pdf_writer_write_string (_tmp413_, "startxref\n");
	_tmp414_ = writer;
	_tmp415_ = xref_offset;
	_tmp416_ = g_strdup_printf ("%zu\n", _tmp415_);
	_tmp417_ = _tmp416_;
	pdf_writer_write_string (_tmp414_, _tmp417_);
	_g_free0 (_tmp417_);
	_tmp418_ = writer;
	pdf_writer_write_string (_tmp418_, "%%EOF\n");
	_pdf_writer_unref0 (writer);
	_g_object_unref0 (stream);
	_g_free0 (id);
}


void book_save (Book* self, const gchar* type, GFile* file, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = type;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jpeg")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("png"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tiff"))))) {
		switch (0) {
			default:
			{
				const gchar* _tmp4_ = NULL;
				GFile* _tmp5_ = NULL;
				_tmp4_ = type;
				_tmp5_ = file;
				book_save_multi_file (self, _tmp4_, _tmp5_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ps")))) {
		switch (0) {
			default:
			{
				GFile* _tmp6_ = NULL;
				_tmp6_ = file;
				book_save_ps (self, _tmp6_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("pdf")))) {
		switch (0) {
			default:
			{
				GFile* _tmp7_ = NULL;
				_tmp7_ = file;
				book_save_pdf (self, _tmp7_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				break;
			}
		}
	}
}


void book_set_needs_saving (Book* self, gboolean needs_saving) {
	gboolean needed_saving = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->needs_saving;
	needed_saving = _tmp0_;
	_tmp1_ = needs_saving;
	self->priv->needs_saving = _tmp1_;
	_tmp2_ = needed_saving;
	_tmp3_ = needs_saving;
	if (_tmp2_ != _tmp3_) {
		g_signal_emit_by_name (self, "needs-saving-changed");
	}
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->needs_saving;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_page (param_values + 1), data2);
}


static void value_book_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_book_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		book_unref (value->data[0].v_pointer);
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Book* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = book_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = book_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_book (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
	return value->data[0].v_pointer;
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		book_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		book_unref (old);
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		book_unref (old);
	}
}


static void book_class_init (BookClass * klass) {
	book_parent_class = g_type_class_peek_parent (klass);
	BOOK_CLASS (klass)->finalize = book_finalize;
	g_type_class_add_private (klass, sizeof (BookPrivate));
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("saving", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void book_instance_init (Book * self) {
	self->priv = BOOK_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void book_finalize (Book* obj) {
	Book * self;
	GList* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
	_tmp0_ = self->priv->pages;
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
		page_collection = _tmp0_;
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
			Page* _tmp1_ = NULL;
			Page* page = NULL;
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
			page = _tmp1_;
			{
				Page* _tmp2_ = NULL;
				guint _tmp3_ = 0U;
				Page* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				_tmp2_ = page;
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
				_tmp4_ = page;
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
				_page_unref0 (page);
			}
		}
	}
	__g_list_free__page_unref0_0 (self->priv->pages);
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BOOK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (PDFWriter*) g_type_create_instance (object_type);
	_tmp0_ = stream;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = _tmp1_;
	return self;
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_ = 0UL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp0_ = self->priv->stream;
		_tmp1_ = data;
		_tmp1__length1 = data_length1;
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("book.vala:571: Error writing PDF: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->offset;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	self->offset = _tmp4_ + _tmp5__length1;
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
	_tmp3_ = (guint8*) _tmp2_;
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guint8);
	pdf_writer_write (self, _tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guint8));
	_tmp3_ = (g_free (_tmp3_), NULL);
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_ = 0UL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->offset;
	self->object_offsets = g_list_append (self->object_offsets, (gpointer) ((guintptr) ((guint) _tmp0_)));
	_tmp1_ = self->object_offsets;
	_tmp2_ = g_list_length (_tmp1_);
	result = _tmp2_;
	return result;
}


static void value_pdf_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_pdf_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		pdf_writer_unref (value->data[0].v_pointer);
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PDFWriter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pdf_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_pdf_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
	return value->data[0].v_pointer;
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pdf_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdf_writer_unref (old);
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pdf_writer_unref (old);
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
	PDF_WRITER_CLASS (klass)->finalize = pdf_writer_finalize;
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
}


static void pdf_writer_instance_init (PDFWriter * self) {
	self->priv = PDF_WRITER_GET_PRIVATE (self);
	self->offset = (gsize) 0;
	self->ref_count = 1;
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
	_g_list_free0 (self->object_offsets);
	_g_object_unref0 (self->priv->stream);
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PDF_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data (self, data, data_length1);
	return result;
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	g_return_val_if_fail (stream != NULL, NULL);
	self = (PsWriter*) g_type_create_instance (object_type);
	_tmp0_ = stream;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->stream);
	self->stream = _tmp1_;
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
	_cairo_surface_destroy0 (self->surface);
	self->surface = _tmp2_;
	return self;
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
	return ps_writer_construct (TYPE_PS_WRITER, stream);
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	{
		GFileOutputStream* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp0_ = self->stream;
		_tmp1_ = data;
		_tmp1__length1 = data_length1;
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("book.vala:607: Error writing data: %s", _tmp3_);
		result = CAIRO_STATUS_WRITE_ERROR;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = CAIRO_STATUS_SUCCESS;
	return result;
}


static void value_ps_writer_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_ps_writer_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ps_writer_unref (value->data[0].v_pointer);
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PsWriter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ps_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ps_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_ps_writer (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
	return value->data[0].v_pointer;
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ps_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ps_writer_unref (old);
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ps_writer_unref (old);
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
	ps_writer_parent_class = g_type_class_peek_parent (klass);
	PS_WRITER_CLASS (klass)->finalize = ps_writer_finalize;
}


static void ps_writer_instance_init (PsWriter * self) {
	self->ref_count = 1;
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
	_cairo_surface_destroy0 (self->surface);
	_g_object_unref0 (self->stream);
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PS_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



