/* simple-scan.c generated by valac 0.40.9, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gusb.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include "colord.h"
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>


#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
enum  {
	SIMPLE_SCAN_0_PROPERTY,
	SIMPLE_SCAN_NUM_PROPERTIES
};
static GParamSpec* simple_scan_properties[SIMPLE_SCAN_NUM_PROPERTIES];
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _SimpleScan {
	GtkApplication parent_instance;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	GtkApplicationClass parent_class;
};

struct _SimpleScanPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUsbContext* usb_context;
	UserInterface* ui;
	Scanner* scanner;
	Book* book;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};


static gpointer simple_scan_parent_class = NULL;
static gboolean simple_scan_show_version;
static gboolean simple_scan_show_version = FALSE;
static gboolean simple_scan_debug_enabled;
static gboolean simple_scan_debug_enabled = FALSE;
static gchar* simple_scan_fix_pdf_filename;
static gchar* simple_scan_fix_pdf_filename = NULL;
static GTimer* simple_scan_log_timer;
static GTimer* simple_scan_log_timer = NULL;
static FILE* simple_scan_log_file;
static FILE* simple_scan_log_file = NULL;

GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_scan_device (GValue* value,
                            gpointer v_object);
void value_take_scan_device (GValue* value,
                             gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
GType user_interface_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_scanner (GValue* value,
                        gpointer v_object);
void value_take_scanner (GValue* value,
                         gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_book (GValue* value,
                     gpointer v_object);
void value_take_book (GValue* value,
                      gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define SIMPLE_SCAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_SCAN, SimpleScanPrivate))
SimpleScan* simple_scan_new (ScanDevice* device);
SimpleScan* simple_scan_construct (GType object_type,
                                   ScanDevice* device);
static void simple_scan_real_startup (GApplication* base);
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* user_interface_get_book (UserInterface* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_scan_options (GValue* value,
                             gpointer v_object);
void value_take_scan_options (GValue* value,
                              gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static void simple_scan_scan_cb (SimpleScan* self,
                          UserInterface* ui,
                          const gchar* device,
                          ScanOptions* options);
static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender,
                                                     const gchar* device,
                                                     ScanOptions* options,
                                                     gpointer self);
static void simple_scan_cancel_cb (SimpleScan* self,
                            UserInterface* ui);
static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender,
                                                      gpointer self);
static void simple_scan_email_cb (SimpleScan* self,
                           UserInterface* ui,
                           const gchar* profile,
                           gint quality);
static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender,
                                                 const gchar* profile,
                                                 gint quality,
                                                 gpointer self);
Scanner* scanner_get_instance (void);
static void simple_scan_update_scan_devices_cb (SimpleScan* self,
                                         Scanner* scanner,
                                         GList* devices);
static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender,
                                                                 GList* devices,
                                                                 gpointer self);
static void simple_scan_authorize_cb (SimpleScan* self,
                               Scanner* scanner,
                               const gchar* resource);
static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender,
                                                              const gchar* resource,
                                                              gpointer self);
static void simple_scan_scanner_new_page_cb (SimpleScan* self,
                                      Scanner* scanner);
static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender,
                                                           gpointer self);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_scan_page_info (GValue* value,
                               gpointer v_object);
void value_take_scan_page_info (GValue* value,
                                gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_page_info_cb (SimpleScan* self,
                                       Scanner* scanner,
                                       ScanPageInfo* info);
static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender,
                                                              ScanPageInfo* info,
                                                              gpointer self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_scan_line (GValue* value,
                          gpointer v_object);
void value_take_scan_line (GValue* value,
                           gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_line_cb (SimpleScan* self,
                                  Scanner* scanner,
                                  ScanLine* line);
static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender,
                                                    ScanLine* line,
                                                    gpointer self);
static void simple_scan_scanner_page_done_cb (SimpleScan* self,
                                       Scanner* scanner);
static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender,
                                                          gpointer self);
static void simple_scan_scanner_document_done_cb (SimpleScan* self,
                                           Scanner* scanner);
static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender,
                                                                  gpointer self);
static void simple_scan_scanner_failed_cb (SimpleScan* self,
                                    Scanner* scanner,
                                    gint error_code,
                                    const gchar* error_string);
static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender,
                                                         gint error_code,
                                                         const gchar* error_string,
                                                         gpointer self);
static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self,
                                              Scanner* scanner);
static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender,
                                                                        gpointer self);
static void ___lambda22_ (SimpleScan* self);
void scanner_redetect (Scanner* self);
static void ____lambda22__g_usb_context_device_added (GUsbContext* _sender,
                                               GUsbDevice* device,
                                               gpointer self);
static void ___lambda23_ (SimpleScan* self);
static void ____lambda23__g_usb_context_device_removed (GUsbContext* _sender,
                                                 GUsbDevice* device,
                                                 gpointer self);
void user_interface_set_scan_devices (UserInterface* self,
                                      GList* devices,
                                      const gchar* missing_driver);
void user_interface_set_selected_device (UserInterface* self,
                                         const gchar* value);
static void _scan_device_unref0_ (gpointer var);
static inline void _g_list_free__scan_device_unref0_ (GList* self);
static void simple_scan_real_activate (GApplication* base);
void user_interface_start (UserInterface* self);
void scanner_start (Scanner* self);
static void simple_scan_real_shutdown (GApplication* base);
void scanner_free (Scanner* self);
gchar* simple_scan_suggest_driver (SimpleScan* self);
static void _g_free0_ (gpointer var);
static void simple_scan_add_devices (SimpleScan* self,
                              GHashTable* map,
                              guint32* devices,
                              int devices_length1,
                              const gchar* driver);
void user_interface_authorize (UserInterface* self,
                               const gchar* resource,
                               gchar* * username,
                               gchar* * password);
void scanner_authorize (Scanner* self,
                        const gchar* username,
                        const gchar* password);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_page (GValue* value,
                     gpointer v_object);
void value_take_page (GValue* value,
                      gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static Page* simple_scan_append_page (SimpleScan* self);
Page* book_get_page (Book* self,
                     gint page_number);
gboolean page_get_has_data (Page* self);
void user_interface_set_selected_page (UserInterface* self,
                                       Page* value);
void page_start (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
gboolean page_get_has_crop (Page* self);
const gchar* page_get_crop_name (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
Page* page_new (gint width,
                gint height,
                gint dpi,
                ScanDirection scan_direction);
Page* page_construct (GType object_type,
                      gint width,
                      gint height,
                      gint dpi,
                      ScanDirection scan_direction);
void book_append_page (Book* self,
                       Page* page);
void page_set_named_crop (Page* self,
                          const gchar* name);
void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
void page_move_crop (Page* self,
                     gint x,
                     gint y);
static gchar* simple_scan_get_profile_for_device (SimpleScan* self,
                                           const gchar* device_name);
void page_set_page_info (Page* self,
                         ScanPageInfo* info);
void page_set_color_profile (Page* self,
                             const gchar* value);
guint book_get_n_pages (Book* self);
void page_parse_scan_line (Page* self,
                           ScanLine* line);
void page_finish (Page* self);
static void simple_scan_remove_empty_page (SimpleScan* self);
void book_delete_page (Book* self,
                       Page* page);
void user_interface_show_error (UserInterface* self,
                                const gchar* error_title,
                                const gchar* error_text,
                                gboolean change_scanner_hint);
gboolean scanner_is_scanning (Scanner* self);
void user_interface_set_scanning (UserInterface* self,
                                  gboolean value);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
void scanner_scan (Scanner* self,
                   const gchar* device,
                   ScanOptions* options);
void scanner_cancel (Scanner* self);
static gchar* simple_scan_get_temporary_filename (SimpleScan* self,
                                           const gchar* prefix,
                                           const gchar* extension);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self,
                const gchar* type,
                gint quality,
                GFile* file,
                GError** error);
void user_interface_hide_progress_dialog (UserInterface* self);
void page_save (Page* self,
                const gchar* type,
                gint quality,
                GFile* file,
                GError** error);
static void simple_scan_log_cb (const gchar* log_domain,
                         GLogLevelFlags log_level,
                         const gchar* message);
static void simple_scan_fix_pdf (const gchar* filename,
                          GError** error);
gint simple_scan_main (gchar** args,
                       int args_length1);
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void _simple_scan_log_cb_glog_func (const gchar* log_domain,
                                    GLogLevelFlags log_levels,
                                    const gchar* message,
                                    gpointer self);
static void simple_scan_finalize (GObject * obj);

const GOptionEntry SIMPLE_SCAN_options[4] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &simple_scan_show_version, N_ ("Show release version"), NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &simple_scan_debug_enabled, N_ ("Print debugging messages"), NULL}, {"fix-pdf", (gchar) 0, 0, G_OPTION_ARG_STRING, &simple_scan_fix_pdf_filename, N_ ("Fix PDF files generated with older versions of Simple Scan"), "FILENAME..."}, {NULL}};
static const guint32 SIMPLE_SCAN_brscan_devices[56] = {(guint32) 0x04f90110, (guint32) 0x04f90111, (guint32) 0x04f90112, (guint32) 0x04f9011d, (guint32) 0x04f9011e, (guint32) 0x04f9011f, (guint32) 0x04f9012b, (guint32) 0x04f90124, (guint32) 0x04f90153, (guint32) 0x04f90125, (guint32) 0x04f90113, (guint32) 0x04f90114, (guint32) 0x04f90115, (guint32) 0x04f90116, (guint32) 0x04f90119, (guint32) 0x04f9011a, (guint32) 0x04f9011b, (guint32) 0x04f9011c, (guint32) 0x04f9012e, (guint32) 0x04f9012f, (guint32) 0x04f90130, (guint32) 0x04f90128, (guint32) 0x04f90127, (guint32) 0x04f90142, (guint32) 0x04f90143, (guint32) 0x04f90140, (guint32) 0x04f90141, (guint32) 0x04f9014e, (guint32) 0x04f9014f, (guint32) 0x04f90150, (guint32) 0x04f90151, (guint32) 0x04f9010e, (guint32) 0x04f9013a, (guint32) 0x04f90120, (guint32) 0x04f9010f, (guint32) 0x04f90121, (guint32) 0x04f90122, (guint32) 0x04f90132, (guint32) 0x04f9013d, (guint32) 0x04f9013c, (guint32) 0x04f90136, (guint32) 0x04f90135, (guint32) 0x04f9013e, (guint32) 0x04f9013f, (guint32) 0x04f90144, (guint32) 0x04f90146, (guint32) 0x04f90148, (guint32) 0x04f9014a, (guint32) 0x04f9014b, (guint32) 0x04f9014c, (guint32) 0x04f90157, (guint32) 0x04f90158, (guint32) 0x04f9015d, (guint32) 0x04f9015e, (guint32) 0x04f9015f, (guint32) 0x04f90160};
static const guint32 SIMPLE_SCAN_brscan2_devices[31] = {(guint32) 0x04f901c9, (guint32) 0x04f901ca, (guint32) 0x04f901cb, (guint32) 0x04f901cc, (guint32) 0x04f901ec, (guint32) 0x04f901e4, (guint32) 0x04f901e3, (guint32) 0x04f901e2, (guint32) 0x04f901e1, (guint32) 0x04f901e0, (guint32) 0x04f901df, (guint32) 0x04f901de, (guint32) 0x04f901dd, (guint32) 0x04f901dc, (guint32) 0x04f901db, (guint32) 0x04f901da, (guint32) 0x04f901d9, (guint32) 0x04f901d8, (guint32) 0x04f901d7, (guint32) 0x04f901d6, (guint32) 0x04f901d5, (guint32) 0x04f901d4, (guint32) 0x04f901d3, (guint32) 0x04f901d2, (guint32) 0x04f901d1, (guint32) 0x04f901d0, (guint32) 0x04f901cf, (guint32) 0x04f901ce, (guint32) 0x04f9020d, (guint32) 0x04f9020c, (guint32) 0x04f9020a};
static const guint32 SIMPLE_SCAN_brscan3_devices[58] = {(guint32) 0x04f90222, (guint32) 0x04f90223, (guint32) 0x04f90224, (guint32) 0x04f90225, (guint32) 0x04f90229, (guint32) 0x04f9022a, (guint32) 0x04f9022c, (guint32) 0x04f90228, (guint32) 0x04f90236, (guint32) 0x04f90227, (guint32) 0x04f9022b, (guint32) 0x04f9022d, (guint32) 0x04f9022e, (guint32) 0x04f9022f, (guint32) 0x04f90230, (guint32) 0x04f9021b, (guint32) 0x04f9021a, (guint32) 0x04f90219, (guint32) 0x04f9023f, (guint32) 0x04f90216, (guint32) 0x04f9021d, (guint32) 0x04f9021c, (guint32) 0x04f90220, (guint32) 0x04f9021e, (guint32) 0x04f9023e, (guint32) 0x04f90235, (guint32) 0x04f9023a, (guint32) 0x04f901c9, (guint32) 0x04f901ca, (guint32) 0x04f901cb, (guint32) 0x04f901cc, (guint32) 0x04f901ec, (guint32) 0x04f9020d, (guint32) 0x04f9020c, (guint32) 0x04f90257, (guint32) 0x04f9025d, (guint32) 0x04f90254, (guint32) 0x04f9025b, (guint32) 0x04f9026b, (guint32) 0x04f90258, (guint32) 0x04f9025e, (guint32) 0x04f90256, (guint32) 0x04f90240, (guint32) 0x04f9025f, (guint32) 0x04f90260, (guint32) 0x04f90261, (guint32) 0x04f90278, (guint32) 0x04f9026f, (guint32) 0x04f9026e, (guint32) 0x04f9026d, (guint32) 0x04f90234, (guint32) 0x04f90239, (guint32) 0x04f90253, (guint32) 0x04f90255, (guint32) 0x04f90259, (guint32) 0x04f9025a, (guint32) 0x04f9025c, (guint32) 0x04f90276};
static const guint32 SIMPLE_SCAN_brscan4_devices[224] = {(guint32) 0x04f90314, (guint32) 0x04f90313, (guint32) 0x04f90312, (guint32) 0x04f90311, (guint32) 0x04f90310, (guint32) 0x04f9030f, (guint32) 0x04f90366, (guint32) 0x04f90365, (guint32) 0x04f90364, (guint32) 0x04f90350, (guint32) 0x04f9034f, (guint32) 0x04f9034e, (guint32) 0x04f9034b, (guint32) 0x04f90349, (guint32) 0x04f90347, (guint32) 0x04f90346, (guint32) 0x04f90343, (guint32) 0x04f90342, (guint32) 0x04f90341, (guint32) 0x04f90340, (guint32) 0x04f9033d, (guint32) 0x04f9033c, (guint32) 0x04f9033a, (guint32) 0x04f90339, (guint32) 0x04f90392, (guint32) 0x04f90373, (guint32) 0x04f9036e, (guint32) 0x04f9036d, (guint32) 0x04f9036c, (guint32) 0x04f9036b, (guint32) 0x04f9036a, (guint32) 0x04f90369, (guint32) 0x04f90368, (guint32) 0x04f90367, (guint32) 0x04f90338, (guint32) 0x04f90337, (guint32) 0x04f90335, (guint32) 0x04f90331, (guint32) 0x04f90330, (guint32) 0x04f90329, (guint32) 0x04f90328, (guint32) 0x04f90326, (guint32) 0x04f90324, (guint32) 0x04f90322, (guint32) 0x04f90321, (guint32) 0x04f90320, (guint32) 0x04f90372, (guint32) 0x04f90371, (guint32) 0x04f90370, (guint32) 0x04f9036f, (guint32) 0x04f90361, (guint32) 0x04f90360, (guint32) 0x04f9035e, (guint32) 0x04f9035d, (guint32) 0x04f9035c, (guint32) 0x04f9035b, (guint32) 0x04f90379, (guint32) 0x04f90378, (guint32) 0x04f90376, (guint32) 0x04f9037a, (guint32) 0x04f9037b, (guint32) 0x04f90377, (guint32) 0x04f9037f, (guint32) 0x04f9037e, (guint32) 0x04f9037d, (guint32) 0x04f9037c, (guint32) 0x04f9035a, (guint32) 0x04f90359, (guint32) 0x04f90358, (guint32) 0x04f90357, (guint32) 0x04f90356, (guint32) 0x04f90355, (guint32) 0x04f90354, (guint32) 0x04f90353, (guint32) 0x04f90351, (guint32) 0x04f90390, (guint32) 0x04f903b3, (guint32) 0x04f90396, (guint32) 0x04f90395, (guint32) 0x04f90394, (guint32) 0x04f90393, (guint32) 0x04f90380, (guint32) 0x04f90381, (guint32) 0x04f903bd, (guint32) 0x04f90383, (guint32) 0x04f90397, (guint32) 0x04f90386, (guint32) 0x04f90384, (guint32) 0x04f90385, (guint32) 0x04f90388, (guint32) 0x04f90389, (guint32) 0x04f9038b, (guint32) 0x04f9038a, (guint32) 0x04f9038c, (guint32) 0x04f9038e, (guint32) 0x04f9038f, (guint32) 0x04f9038d, (guint32) 0x04f903bc, (guint32) 0x04f903bb, (guint32) 0x04f903b6, (guint32) 0x04f903b5, (guint32) 0x04f903b4, (guint32) 0x04f90290, (guint32) 0x04f9028f, (guint32) 0x04f9028d, (guint32) 0x04f9028a, (guint32) 0x04f90284, (guint32) 0x04f90283, (guint32) 0x04f90282, (guint32) 0x04f90281, (guint32) 0x04f9027e, (guint32) 0x04f9027d, (guint32) 0x04f9027c, (guint32) 0x04f9027b, (guint32) 0x04f90280, (guint32) 0x04f9027a, (guint32) 0x04f90279, (guint32) 0x04f9027f, (guint32) 0x04f90285, (guint32) 0x04f9029a, (guint32) 0x04f9029f, (guint32) 0x04f9029e, (guint32) 0x04f90289, (guint32) 0x04f90288, (guint32) 0x04f960a0, (guint32) 0x04f960a1, (guint32) 0x04f90293, (guint32) 0x04f902b7, (guint32) 0x04f90294, (guint32) 0x04f90296, (guint32) 0x04f90298, (guint32) 0x04f902ba, (guint32) 0x04f90299, (guint32) 0x04f902bb, (guint32) 0x04f902d4, (guint32) 0x04f90291, (guint32) 0x04f902ac, (guint32) 0x04f902b5, (guint32) 0x04f90292, (guint32) 0x04f902b6, (guint32) 0x04f90295, (guint32) 0x04f902b8, (guint32) 0x04f9029c, (guint32) 0x04f902cb, (guint32) 0x04f902ca, (guint32) 0x04f902a6, (guint32) 0x04f902a7, (guint32) 0x04f902ab, (guint32) 0x04f902a5, (guint32) 0x04f902a8, (guint32) 0x04f902a0, (guint32) 0x04f902c1, (guint32) 0x04f902c0, (guint32) 0x04f902bf, (guint32) 0x04f902be, (guint32) 0x04f902bd, (guint32) 0x04f902bc, (guint32) 0x04f902b2, (guint32) 0x04f90287, (guint32) 0x04f902cf, (guint32) 0x04f902ce, (guint32) 0x04f902cd, (guint32) 0x04f902c7, (guint32) 0x04f902c6, (guint32) 0x04f902c5, (guint32) 0x04f902c4, (guint32) 0x04f902b4, (guint32) 0x04f902b3, (guint32) 0x04f902c2, (guint32) 0x04f960a4, (guint32) 0x04f960a5, (guint32) 0x04f902cc, (guint32) 0x04f902c8, (guint32) 0x04f902c3, (guint32) 0x04f902d3, (guint32) 0x04f902b1, (guint32) 0x04f902b0, (guint32) 0x04f902af, (guint32) 0x04f902ae, (guint32) 0x04f902ad, (guint32) 0x04f902d1, (guint32) 0x04f902d0, (guint32) 0x04f902fb, (guint32) 0x04f902f1, (guint32) 0x04f902f0, (guint32) 0x04f902ef, (guint32) 0x04f902ed, (guint32) 0x04f902ec, (guint32) 0x04f902ee, (guint32) 0x04f902eb, (guint32) 0x04f902e9, (guint32) 0x04f902e8, (guint32) 0x04f902fa, (guint32) 0x04f902ea, (guint32) 0x04f902e6, (guint32) 0x04f902e5, (guint32) 0x04f902e4, (guint32) 0x04f902e3, (guint32) 0x04f902e2, (guint32) 0x04f902f9, (guint32) 0x04f902de, (guint32) 0x04f902e0, (guint32) 0x04f902df, (guint32) 0x04f902e1, (guint32) 0x04f902e7, (guint32) 0x04f902fc, (guint32) 0x04f902fd, (guint32) 0x04f902fe, (guint32) 0x04f902dd, (guint32) 0x04f902c9, (guint32) 0x04f902ff, (guint32) 0x04f90300, (guint32) 0x04f902f2, (guint32) 0x04f902f3, (guint32) 0x04f902f4, (guint32) 0x04f902f8, (guint32) 0x04f902f5, (guint32) 0x04f902f6, (guint32) 0x04f902f7, (guint32) 0x04f90318, (guint32) 0x04f960a6, (guint32) 0x04f960a7, (guint32) 0x04f960a8, (guint32) 0x04f960a9};
static const guint32 SIMPLE_SCAN_samsung_devices[69] = {(guint32) 0x04e83425, (guint32) 0x04e8341c, (guint32) 0x04e8342a, (guint32) 0x04e8343d, (guint32) 0x04e83456, (guint32) 0x04e8345a, (guint32) 0x04e83427, (guint32) 0x04e8343a, (guint32) 0x04e83428, (guint32) 0x04e8343b, (guint32) 0x04e83455, (guint32) 0x04e83421, (guint32) 0x04e83439, (guint32) 0x04e83444, (guint32) 0x04e8343f, (guint32) 0x04e8344e, (guint32) 0x04e83431, (guint32) 0x04e8345c, (guint32) 0x04e8344d, (guint32) 0x04e83462, (guint32) 0x04e83464, (guint32) 0x04e83461, (guint32) 0x04e83460, (guint32) 0x04e8340e, (guint32) 0x04e83435, (guint32) 0x04e8340f, (guint32) 0x04e83441, (guint32) 0x04e8344f, (guint32) 0x04e83413, (guint32) 0x04e8341b, (guint32) 0x04e8342e, (guint32) 0x04e83426, (guint32) 0x04e8342b, (guint32) 0x04e83433, (guint32) 0x04e83440, (guint32) 0x04e83434, (guint32) 0x04e8345b, (guint32) 0x04e83457, (guint32) 0x04e8341f, (guint32) 0x04e83453, (guint32) 0x04e8344b, (guint32) 0x04e83409, (guint32) 0x04e83412, (guint32) 0x04e83419, (guint32) 0x04e8342c, (guint32) 0x04e8343c, (guint32) 0x04e83432, (guint32) 0x04e8342d, (guint32) 0x04e83430, (guint32) 0x04e8342f, (guint32) 0x04e83446, (guint32) 0x04e8341a, (guint32) 0x04e83437, (guint32) 0x04e83442, (guint32) 0x04e83466, (guint32) 0x04e8340d, (guint32) 0x04e8341d, (guint32) 0x04e83420, (guint32) 0x04e83429, (guint32) 0x04e83443, (guint32) 0x04e83438, (guint32) 0x04e8344c, (guint32) 0x04e8345d, (guint32) 0x04e83463, (guint32) 0x04e83465, (guint32) 0x04e83450, (guint32) 0x04e83468, (guint32) 0x04e83469, (guint32) 0x04e83471};
static const guint32 SIMPLE_SCAN_hpaio_devices[520] = {(guint32) 0x03f02311, (guint32) 0x03f09711, (guint32) 0x03f01311, (guint32) 0x03f01011, (guint32) 0x03f00f11, (guint32) 0x03f01911, (guint32) 0x03f00011, (guint32) 0x03f00111, (guint32) 0x03f00611, (guint32) 0x03f00511, (guint32) 0x03f00811, (guint32) 0x03f00711, (guint32) 0x03f00211, (guint32) 0x03f00311, (guint32) 0x03f00411, (guint32) 0x03f0062a, (guint32) 0x03f04912, (guint32) 0x03f09911, (guint32) 0x03f03802, (guint32) 0x03f07a11, (guint32) 0x03f08311, (guint32) 0x03f07b11, (guint32) 0x03f0a711, (guint32) 0x03f08d11, (guint32) 0x03f08a11, (guint32) 0x03f0bb11, (guint32) 0x03f0222a, (guint32) 0x03f0322a, (guint32) 0x03f03902, (guint32) 0x03f01002, (guint32) 0x03f0242a, (guint32) 0x03f0332a, (guint32) 0x03f0122a, (guint32) 0x03f00c2a, (guint32) 0x03f0132a, (guint32) 0x03f02c2a, (guint32) 0x03f07e11, (guint32) 0x03f07811, (guint32) 0x03f08e11, (guint32) 0x03f02d2a, (guint32) 0x03f03502, (guint32) 0x03f01102, (guint32) 0x03f06112, (guint32) 0x03f06212, (guint32) 0x03f05511, (guint32) 0x03f00f2a, (guint32) 0x03f0082a, (guint32) 0x03f07311, (guint32) 0x03f07c11, (guint32) 0x03f07d11, (guint32) 0x03f01d02, (guint32) 0x03f01202, (guint32) 0x03f01e02, (guint32) 0x03f01602, (guint32) 0x03f01302, (guint32) 0x03f01702, (guint32) 0x03f0152a, (guint32) 0x03f0142a, (guint32) 0x03f09611, (guint32) 0x03f01502, (guint32) 0x03f01902, (guint32) 0x03f01f02, (guint32) 0x03f00512, (guint32) 0x03f0aa11, (guint32) 0x03f0a311, (guint32) 0x03f01312, (guint32) 0x03f01802, (guint32) 0x03f02812, (guint32) 0x03f0bf11, (guint32) 0x03f0c011, (guint32) 0x03f0342a, (guint32) 0x03f09e17, (guint32) 0x03f09f17, (guint32) 0x03f0252a, (guint32) 0x03f0a417, (guint32) 0x03f01a02, (guint32) 0x03f09e11, (guint32) 0x03f09011, (guint32) 0x03f02602, (guint32) 0x03f0272a, (guint32) 0x03f02b02, (guint32) 0x03f01812, (guint32) 0x03f0b211, (guint32) 0x03f0352a, (guint32) 0x03f02b2a, (guint32) 0x03f0362a, (guint32) 0x03f0a517, (guint32) 0x03f01b02, (guint32) 0x03f02702, (guint32) 0x03f02c02, (guint32) 0x03f0282a, (guint32) 0x03f02104, (guint32) 0x03f0432a, (guint32) 0x03f02004, (guint32) 0x03f01a2a, (guint32) 0x03f02304, (guint32) 0x03f01b2a, (guint32) 0x03f0442a, (guint32) 0x03f08904, (guint32) 0x03f0a617, (guint32) 0x03f09a17, (guint32) 0x03f0312a, (guint32) 0x03f0452a, (guint32) 0x03f01c02, (guint32) 0x03f01811, (guint32) 0x03f09d17, (guint32) 0x03f02804, (guint32) 0x03f02904, (guint32) 0x03f01511, (guint32) 0x03f01411, (guint32) 0x03f0372a, (guint32) 0x03f00d14, (guint32) 0x03f01611, (guint32) 0x03f01711, (guint32) 0x03f00f14, (guint32) 0x03f01f2a, (guint32) 0x03f00304, (guint32) 0x03f00204, (guint32) 0x03f00804, (guint32) 0x03f02902, (guint32) 0x03f00704, (guint32) 0x03f01e2a, (guint32) 0x03f00404, (guint32) 0x03f00604, (guint32) 0x03f00904, (guint32) 0x03f01512, (guint32) 0x03f01c2a, (guint32) 0x03f00104, (guint32) 0x03f01d2a, (guint32) 0x03f00004, (guint32) 0x03f02604, (guint32) 0x03f02704, (guint32) 0x03f01804, (guint32) 0x03f01504, (guint32) 0x03f01f11, (guint32) 0x03f01204, (guint32) 0x03f01604, (guint32) 0x03f01704, (guint32) 0x03f01104, (guint32) 0x03f01e11, (guint32) 0x03f01304, (guint32) 0x03f01404, (guint32) 0x03f03104, (guint32) 0x03f01004, (guint32) 0x03f03004, (guint32) 0x03f03304, (guint32) 0x03f05004, (guint32) 0x03f01712, (guint32) 0x03f02e11, (guint32) 0x03f00517, (guint32) 0x03f08811, (guint32) 0x03f01317, (guint32) 0x03f04117, (guint32) 0x03f03217, (guint32) 0x03f03e17, (guint32) 0x03f00c17, (guint32) 0x03f0b511, (guint32) 0x03f04217, (guint32) 0x03f04317, (guint32) 0x03f02b17, (guint32) 0x03f03017, (guint32) 0x03f02d17, (guint32) 0x03f02c17, (guint32) 0x03f00b2a, (guint32) 0x03f0112a, (guint32) 0x03f08911, (guint32) 0x03f07c04, (guint32) 0x03f00912, (guint32) 0x03f03011, (guint32) 0x03f0032a, (guint32) 0x03f0002a, (guint32) 0x03f0102a, (guint32) 0x03f03402, (guint32) 0x03f05617, (guint32) 0x03f05717, (guint32) 0x03f0042a, (guint32) 0x03f00f17, (guint32) 0x03f04004, (guint32) 0x03f01017, (guint32) 0x03f01e17, (guint32) 0x03f00317, (guint32) 0x03f00f12, (guint32) 0x03f02f11, (guint32) 0x03f0052a, (guint32) 0x03f04717, (guint32) 0x03f03202, (guint32) 0x03f00e2a, (guint32) 0x03f0262a, (guint32) 0x03f03302, (guint32) 0x03f00417, (guint32) 0x03f00212, (guint32) 0x03f01412, (guint32) 0x03f07804, (guint32) 0x03f03b11, (guint32) 0x03f01117, (guint32) 0x03f03f11, (guint32) 0x03f04f17, (guint32) 0x03f04e17, (guint32) 0x03f03602, (guint32) 0x03f05817, (guint32) 0x03f01d17, (guint32) 0x03f03c11, (guint32) 0x03f07904, (guint32) 0x03f04d11, (guint32) 0x03f0072a, (guint32) 0x03f01417, (guint32) 0x03f04c11, (guint32) 0x03f0c111, (guint32) 0x03f04417, (guint32) 0x03f05017, (guint32) 0x03f0022a, (guint32) 0x03f0012a, (guint32) 0x03f0092a, (guint32) 0x03f07f11, (guint32) 0x03f04811, (guint32) 0x03f03a17, (guint32) 0x03f00a2a, (guint32) 0x03f00312, (guint32) 0x03f09411, (guint32) 0x03f09b11, (guint32) 0x03f03917, (guint32) 0x03f04a17, (guint32) 0x03f03817, (guint32) 0x03f0b911, (guint32) 0x03f05417, (guint32) 0x03f05217, (guint32) 0x03f05317, (guint32) 0x03f05d17, (guint32) 0x03f08711, (guint32) 0x03f05c17, (guint32) 0x03f09a11, (guint32) 0x03f02811, (guint32) 0x03f07d04, (guint32) 0x03f02a11, (guint32) 0x03f02b11, (guint32) 0x03f00217, (guint32) 0x03f02911, (guint32) 0x03f02404, (guint32) 0x03f03511, (guint32) 0x03f00812, (guint32) 0x03f00b17, (guint32) 0x03f0c302, (guint32) 0x03f05917, (guint32) 0x03f05a17, (guint32) 0x03f05b17, (guint32) 0x03f04911, (guint32) 0x03f03611, (guint32) 0x03f07611, (guint32) 0x03f07a04, (guint32) 0x03f02517, (guint32) 0x03f02917, (guint32) 0x03f02a17, (guint32) 0x03f01e04, (guint32) 0x03f00717, (guint32) 0x03f02504, (guint32) 0x03f03711, (guint32) 0x03f0ac11, (guint32) 0x03f0be11, (guint32) 0x03f0c211, (guint32) 0x03f01c17, (guint32) 0x03f04e11, (guint32) 0x03f02e17, (guint32) 0x03f04511, (guint32) 0x03f08011, (guint32) 0x03f00412, (guint32) 0x03f03617, (guint32) 0x03f02f17, (guint32) 0x03f03117, (guint32) 0x03f0c911, (guint32) 0x03f0ca11, (guint32) 0x03f04611, (guint32) 0x03f03c17, (guint32) 0x03f03717, (guint32) 0x03f02617, (guint32) 0x03f01112, (guint32) 0x03f00612, (guint32) 0x03f06717, (guint32) 0x03f09511, (guint32) 0x03f07617, (guint32) 0x03f07317, (guint32) 0x03f08d17, (guint32) 0x03f01617, (guint32) 0x03f07a17, (guint32) 0x03f07517, (guint32) 0x03f09311, (guint32) 0x03f0a011, (guint32) 0x03f03317, (guint32) 0x03f03417, (guint32) 0x03f0a211, (guint32) 0x03f05611, (guint32) 0x03f05011, (guint32) 0x03f00117, (guint32) 0x03f05111, (guint32) 0x03f00817, (guint32) 0x03f05211, (guint32) 0x03f07004, (guint32) 0x03f00917, (guint32) 0x03f01917, (guint32) 0x03f03517, (guint32) 0x03f07104, (guint32) 0x03f01517, (guint32) 0x03f03112, (guint32) 0x03f07817, (guint32) 0x03f0ad11, (guint32) 0x03f0b011, (guint32) 0x03f08517, (guint32) 0x03f08a17, (guint32) 0x03f0c711, (guint32) 0x03f06117, (guint32) 0x03f06917, (guint32) 0x03f06812, (guint32) 0x03f06d12, (guint32) 0x03f07204, (guint32) 0x03f00a17, (guint32) 0x03f07404, (guint32) 0x03f06817, (guint32) 0x03f01b04, (guint32) 0x03f01a04, (guint32) 0x03f01c04, (guint32) 0x03f01904, (guint32) 0x03f07504, (guint32) 0x03f07604, (guint32) 0x03f00714, (guint32) 0x03f09c11, (guint32) 0x03f07b17, (guint32) 0x03f08817, (guint32) 0x03f05711, (guint32) 0x03f07704, (guint32) 0x03f07e04, (guint32) 0x03f03111, (guint32) 0x03f06017, (guint32) 0x03f03d11, (guint32) 0x03f05c11, (guint32) 0x03f07b04, (guint32) 0x03f06a17, (guint32) 0x03f02417, (guint32) 0x03f05411, (guint32) 0x03f01f04, (guint32) 0x03f06711, (guint32) 0x03f07417, (guint32) 0x03f09717, (guint32) 0x03f02317, (guint32) 0x03f06611, (guint32) 0x03f06c11, (guint32) 0x03f09d11, (guint32) 0x03f07711, (guint32) 0x03f04712, (guint32) 0x03f08c11, (guint32) 0x03f05712, (guint32) 0x03f02a12, (guint32) 0x03f06b11, (guint32) 0x03f0c511, (guint32) 0x03f02e12, (guint32) 0x03f0c411, (guint32) 0x03f09917, (guint32) 0x03f09c17, (guint32) 0x03f07411, (guint32) 0x03f06c17, (guint32) 0x03f05812, (guint32) 0x03f06512, (guint32) 0x03f06612, (guint32) 0x03f06412, (guint32) 0x03f0c611, (guint32) 0x03f0c811, (guint32) 0x03f01a17, (guint32) 0x03f02b12, (guint32) 0x03f02c12, (guint32) 0x03f07511, (guint32) 0x03f06217, (guint32) 0x03f07d17, (guint32) 0x03f06317, (guint32) 0x03f07917, (guint32) 0x03f07217, (guint32) 0x03f0a117, (guint32) 0x03f0c802, (guint32) 0x03f05811, (guint32) 0x03f0c402, (guint32) 0x03f02411, (guint32) 0x03f05d11, (guint32) 0x03f06417, (guint32) 0x03f06617, (guint32) 0x03f08917, (guint32) 0x03f05117, (guint32) 0x03f07111, (guint32) 0x03f01f12, (guint32) 0x03f06811, (guint32) 0x03f02012, (guint32) 0x03f08604, (guint32) 0x03f06d11, (guint32) 0x03f03a11, (guint32) 0x03f03012, (guint32) 0x03f08211, (guint32) 0x03f07211, (guint32) 0x03f0a111, (guint32) 0x03f0b411, (guint32) 0x03f09b17, (guint32) 0x03f0b111, (guint32) 0x03f0b611, (guint32) 0x03f0c311, (guint32) 0x03f01f17, (guint32) 0x03f06004, (guint32) 0x03f04f11, (guint32) 0x03f0cc11, (guint32) 0x03f06104, (guint32) 0x03f05b11, (guint32) 0x03f08104, (guint32) 0x03f0cd11, (guint32) 0x03f0a004, (guint32) 0x03f08704, (guint32) 0x03f04312, (guint32) 0x03f04212, (guint32) 0x03f06f17, (guint32) 0x03f07c17, (guint32) 0x03f09517, (guint32) 0x03f05911, (guint32) 0x03f05e12, (guint32) 0x03f00b14, (guint32) 0x03f0c502, (guint32) 0x03f02d11, (guint32) 0x03f03404, (guint32) 0x03f04b11, (guint32) 0x03f01014, (guint32) 0x03f06a11, (guint32) 0x03f07312, (guint32) 0x03f07011, (guint32) 0x03f05311, (guint32) 0x03f03312, (guint32) 0x03f04412, (guint32) 0x03f05412, (guint32) 0x03f05512, (guint32) 0x03f04512, (guint32) 0x03f08204, (guint32) 0x03f0a511, (guint32) 0x03f0af11, (guint32) 0x03f0ba11, (guint32) 0x03f08504, (guint32) 0x03f05d12, (guint32) 0x03f05c12, (guint32) 0x03f08404, (guint32) 0x03f07412, (guint32) 0x03f07212, (guint32) 0x03f08804, (guint32) 0x03f04612, (guint32) 0x03f02611, (guint32) 0x03f05a11, (guint32) 0x03f02612, (guint32) 0x03f0c602, (guint32) 0x03f06012, (guint32) 0x03f03a02, (guint32) 0x03f06911, (guint32) 0x03f0b002, (guint32) 0x03f04111, (guint32) 0x03f06511, (guint32) 0x03f04211, (guint32) 0x03f02512, (guint32) 0x03f0c702, (guint32) 0x03f02002, (guint32) 0x03f03c02, (guint32) 0x03f04311, (guint32) 0x03f0b802, (guint32) 0x03f05e11, (guint32) 0x03f03412, (guint32) 0x03f02112, (guint32) 0x03f04812, (guint32) 0x03f06f11, (guint32) 0x03f0a611, (guint32) 0x03f0bc11, (guint32) 0x03f03e02, (guint32) 0x03f02212, (guint32) 0x03f0b202, (guint32) 0x03f06e12, (guint32) 0x03f0dc11, (guint32) 0x03f02312, (guint32) 0x03f0b402, (guint32) 0x03f0c002, (guint32) 0x03f0b602, (guint32) 0x03f05612, (guint32) 0x03f03612, (guint32) 0x03f0c102, (guint32) 0x03f0de11, (guint32) 0x03f07717, (guint32) 0x03f07117, (guint32) 0x03f05b12, (guint32) 0x03f06411, (guint32) 0x03f0ba02, (guint32) 0x03f0c202, (guint32) 0x03f0be02, (guint32) 0x03f0bb02, (guint32) 0x03f03812, (guint32) 0x03f04012, (guint32) 0x03f03912, (guint32) 0x03f0d102, (guint32) 0x03f05312, (guint32) 0x03f02712, (guint32) 0x03f05912, (guint32) 0x03f07112, (guint32) 0x03f07012, (guint32) 0x03f06f12, (guint32) 0x03f07712, (guint32) 0x03f07612, (guint32) 0x03f0bc02, (guint32) 0x03f0d002, (guint32) 0x03f08417, (guint32) 0x03f02017, (guint32) 0x03f02117, (guint32) 0x03f08317, (guint32) 0x03f09617, (guint32) 0x03f00d12, (guint32) 0x03f0bd02, (guint32) 0x03f02217, (guint32) 0x03f00b12, (guint32) 0x03f01212, (guint32) 0x03f03c2a, (guint32) 0x03f0382a, (guint32) 0x03f0582a, (guint32) 0x03f0552a, (guint32) 0x03f03e2a, (guint32) 0x03f03f2a, (guint32) 0x03f0e311, (guint32) 0x03f0e111};
static const guint32 SIMPLE_SCAN_epkowa_devices[201] = {(guint32) 0x04b80101, (guint32) 0x04b80102, (guint32) 0x04b80103, (guint32) 0x04b80104, (guint32) 0x04b80105, (guint32) 0x04b80106, (guint32) 0x04b80107, (guint32) 0x04b80108, (guint32) 0x04b80109, (guint32) 0x04b8010a, (guint32) 0x04b8010b, (guint32) 0x04b8010c, (guint32) 0x04b8010d, (guint32) 0x04b8010e, (guint32) 0x04b8010f, (guint32) 0x04b80110, (guint32) 0x04b80112, (guint32) 0x04b80114, (guint32) 0x04b80116, (guint32) 0x04b80118, (guint32) 0x04b80119, (guint32) 0x04b8011a, (guint32) 0x04b8011b, (guint32) 0x04b8011c, (guint32) 0x04b8011d, (guint32) 0x04b8011e, (guint32) 0x04b8011f, (guint32) 0x04b80120, (guint32) 0x04b80121, (guint32) 0x04b80122, (guint32) 0x04b80126, (guint32) 0x04b80128, (guint32) 0x04b80129, (guint32) 0x04b8012a, (guint32) 0x04b8012b, (guint32) 0x04b8012c, (guint32) 0x04b8012d, (guint32) 0x04b8012e, (guint32) 0x04b8012f, (guint32) 0x04b80130, (guint32) 0x04b80131, (guint32) 0x04b80133, (guint32) 0x04b80135, (guint32) 0x04b80136, (guint32) 0x04b80137, (guint32) 0x04b80138, (guint32) 0x04b8013a, (guint32) 0x04b8013b, (guint32) 0x04b8013c, (guint32) 0x04b8013d, (guint32) 0x04b80142, (guint32) 0x04b80143, (guint32) 0x04b80144, (guint32) 0x04b80147, (guint32) 0x04b8014a, (guint32) 0x04b8014b, (guint32) 0x04b80151, (guint32) 0x04b80153, (guint32) 0x04b80801, (guint32) 0x04b80802, (guint32) 0x04b80805, (guint32) 0x04b80806, (guint32) 0x04b80807, (guint32) 0x04b80808, (guint32) 0x04b8080a, (guint32) 0x04b8080c, (guint32) 0x04b8080d, (guint32) 0x04b8080e, (guint32) 0x04b8080f, (guint32) 0x04b80810, (guint32) 0x04b80811, (guint32) 0x04b80813, (guint32) 0x04b80814, (guint32) 0x04b80815, (guint32) 0x04b80817, (guint32) 0x04b80818, (guint32) 0x04b80819, (guint32) 0x04b8081a, (guint32) 0x04b8081c, (guint32) 0x04b8081d, (guint32) 0x04b8081f, (guint32) 0x04b80820, (guint32) 0x04b80821, (guint32) 0x04b80827, (guint32) 0x04b80828, (guint32) 0x04b80829, (guint32) 0x04b8082a, (guint32) 0x04b8082b, (guint32) 0x04b8082e, (guint32) 0x04b8082f, (guint32) 0x04b80830, (guint32) 0x04b80831, (guint32) 0x04b80833, (guint32) 0x04b80834, (guint32) 0x04b80835, (guint32) 0x04b80836, (guint32) 0x04b80837, (guint32) 0x04b80838, (guint32) 0x04b80839, (guint32) 0x04b8083a, (guint32) 0x04b8083c, (guint32) 0x04b8083f, (guint32) 0x04b80841, (guint32) 0x04b80843, (guint32) 0x04b80844, (guint32) 0x04b80846, (guint32) 0x04b80847, (guint32) 0x04b80848, (guint32) 0x04b80849, (guint32) 0x04b8084a, (guint32) 0x04b8084c, (guint32) 0x04b8084d, (guint32) 0x04b8084f, (guint32) 0x04b80850, (guint32) 0x04b80851, (guint32) 0x04b80852, (guint32) 0x04b80853, (guint32) 0x04b80854, (guint32) 0x04b80855, (guint32) 0x04b80856, (guint32) 0x04b8085c, (guint32) 0x04b8085d, (guint32) 0x04b8085e, (guint32) 0x04b8085f, (guint32) 0x04b80860, (guint32) 0x04b80861, (guint32) 0x04b80862, (guint32) 0x04b80863, (guint32) 0x04b80864, (guint32) 0x04b80865, (guint32) 0x04b80866, (guint32) 0x04b80869, (guint32) 0x04b8086a, (guint32) 0x04b80870, (guint32) 0x04b80871, (guint32) 0x04b80872, (guint32) 0x04b80873, (guint32) 0x04b80878, (guint32) 0x04b80879, (guint32) 0x04b8087b, (guint32) 0x04b8087c, (guint32) 0x04b8087d, (guint32) 0x04b8087e, (guint32) 0x04b8087f, (guint32) 0x04b80880, (guint32) 0x04b80881, (guint32) 0x04b80883, (guint32) 0x04b80884, (guint32) 0x04b80885, (guint32) 0x04b8088f, (guint32) 0x04b80890, (guint32) 0x04b80891, (guint32) 0x04b80892, (guint32) 0x04b80893, (guint32) 0x04b80894, (guint32) 0x04b80895, (guint32) 0x04b80896, (guint32) 0x04b80897, (guint32) 0x04b80898, (guint32) 0x04b80899, (guint32) 0x04b8089a, (guint32) 0x04b8089b, (guint32) 0x04b8089c, (guint32) 0x04b8089d, (guint32) 0x04b8089e, (guint32) 0x04b8089f, (guint32) 0x04b808a0, (guint32) 0x04b808a1, (guint32) 0x04b808a5, (guint32) 0x04b808a6, (guint32) 0x04b808a8, (guint32) 0x04b808a9, (guint32) 0x04b808aa, (guint32) 0x04b808ab, (guint32) 0x04b808ac, (guint32) 0x04b808ad, (guint32) 0x04b808ae, (guint32) 0x04b808af, (guint32) 0x04b808b0, (guint32) 0x04b808b3, (guint32) 0x04b808b4, (guint32) 0x04b808b5, (guint32) 0x04b808b6, (guint32) 0x04b808b7, (guint32) 0x04b808b8, (guint32) 0x04b808b9, (guint32) 0x04b808bd, (guint32) 0x04b808be, (guint32) 0x04b808bf, (guint32) 0x04b808c0, (guint32) 0x04b808c1, (guint32) 0x04b808c3, (guint32) 0x04b808c4, (guint32) 0x04b808c5, (guint32) 0x04b808c6, (guint32) 0x04b808c7, (guint32) 0x04b808c8, (guint32) 0x04b808c9, (guint32) 0x04b808ca, (guint32) 0x04b808cd, (guint32) 0x04b808d0};

static gpointer
_scan_device_ref0 (gpointer self)
{
#line 41 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return self ? scan_device_ref (self) : NULL;
#line 566 "simple-scan.c"
}


SimpleScan*
simple_scan_construct (GType object_type,
                       ScanDevice* device)
{
	SimpleScan * self = NULL;
	ScanDevice* _tmp0_;
#line 39 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self = (SimpleScan*) g_object_new (object_type, NULL);
#line 41 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = _scan_device_ref0 (device);
#line 41 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 41 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->default_device = _tmp0_;
#line 39 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return self;
#line 586 "simple-scan.c"
}


SimpleScan*
simple_scan_new (ScanDevice* device)
{
#line 39 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return simple_scan_construct (TYPE_SIMPLE_SCAN, device);
#line 595 "simple-scan.c"
}


static gpointer
_book_ref0 (gpointer self)
{
#line 49 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return self ? book_ref (self) : NULL;
#line 604 "simple-scan.c"
}


static void
_simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender,
                                                const gchar* device,
                                                ScanOptions* options,
                                                gpointer self)
{
#line 50 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_scan_cb ((SimpleScan*) self, _sender, device, options);
#line 616 "simple-scan.c"
}


static void
_simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender,
                                                 gpointer self)
{
#line 51 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_cancel_cb ((SimpleScan*) self, _sender);
#line 626 "simple-scan.c"
}


static void
_simple_scan_email_cb_user_interface_email (UserInterface* _sender,
                                            const gchar* profile,
                                            gint quality,
                                            gpointer self)
{
#line 52 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_email_cb ((SimpleScan*) self, _sender, profile, quality);
#line 638 "simple-scan.c"
}


static void
_simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender,
                                                            GList* devices,
                                                            gpointer self)
{
#line 55 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_update_scan_devices_cb ((SimpleScan*) self, _sender, devices);
#line 649 "simple-scan.c"
}


static void
_simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender,
                                                         const gchar* resource,
                                                         gpointer self)
{
#line 56 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_authorize_cb ((SimpleScan*) self, _sender, resource);
#line 660 "simple-scan.c"
}


static void
_simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender,
                                                      gpointer self)
{
#line 57 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_scanner_new_page_cb ((SimpleScan*) self, _sender);
#line 670 "simple-scan.c"
}


static void
_simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender,
                                                         ScanPageInfo* info,
                                                         gpointer self)
{
#line 58 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_scanner_page_info_cb ((SimpleScan*) self, _sender, info);
#line 681 "simple-scan.c"
}


static void
_simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender,
                                               ScanLine* line,
                                               gpointer self)
{
#line 59 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_scanner_line_cb ((SimpleScan*) self, _sender, line);
#line 692 "simple-scan.c"
}


static void
_simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender,
                                                     gpointer self)
{
#line 60 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_scanner_page_done_cb ((SimpleScan*) self, _sender);
#line 702 "simple-scan.c"
}


static void
_simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender,
                                                             gpointer self)
{
#line 61 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_scanner_document_done_cb ((SimpleScan*) self, _sender);
#line 712 "simple-scan.c"
}


static void
_simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender,
                                                    gint error_code,
                                                    const gchar* error_string,
                                                    gpointer self)
{
#line 62 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_scanner_failed_cb ((SimpleScan*) self, _sender, error_code, error_string);
#line 724 "simple-scan.c"
}


static void
_simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender,
                                                                   gpointer self)
{
#line 63 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_scanner_scanning_changed_cb ((SimpleScan*) self, _sender);
#line 734 "simple-scan.c"
}


static void
___lambda22_ (SimpleScan* self)
{
	Scanner* _tmp0_;
#line 68 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 68 "/home/bob/git/simple-scan/src/simple-scan.vala"
	scanner_redetect (_tmp0_);
#line 746 "simple-scan.c"
}


static void
____lambda22__g_usb_context_device_added (GUsbContext* _sender,
                                          GUsbDevice* device,
                                          gpointer self)
{
#line 68 "/home/bob/git/simple-scan/src/simple-scan.vala"
	___lambda22_ ((SimpleScan*) self);
#line 757 "simple-scan.c"
}


static void
___lambda23_ (SimpleScan* self)
{
	Scanner* _tmp0_;
#line 69 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 69 "/home/bob/git/simple-scan/src/simple-scan.vala"
	scanner_redetect (_tmp0_);
#line 769 "simple-scan.c"
}


static void
____lambda23__g_usb_context_device_removed (GUsbContext* _sender,
                                            GUsbDevice* device,
                                            gpointer self)
{
#line 69 "/home/bob/git/simple-scan/src/simple-scan.vala"
	___lambda23_ ((SimpleScan*) self);
#line 780 "simple-scan.c"
}


static void
_scan_device_unref0_ (gpointer var)
{
#line 76 "/home/bob/git/simple-scan/src/simple-scan.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 789 "simple-scan.c"
}


static inline void
_g_list_free__scan_device_unref0_ (GList* self)
{
#line 76 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_list_free_full (self, (GDestroyNotify) _scan_device_unref0_);
#line 798 "simple-scan.c"
}


static void
simple_scan_real_startup (GApplication* base)
{
	SimpleScan * self;
	UserInterface* _tmp0_;
	UserInterface* _tmp1_;
	Book* _tmp2_;
	Book* _tmp3_;
	Book* _tmp4_;
	UserInterface* _tmp5_;
	UserInterface* _tmp6_;
	UserInterface* _tmp7_;
	Scanner* _tmp8_;
	Scanner* _tmp9_;
	Scanner* _tmp10_;
	Scanner* _tmp11_;
	Scanner* _tmp12_;
	Scanner* _tmp13_;
	Scanner* _tmp14_;
	Scanner* _tmp15_;
	Scanner* _tmp16_;
	Scanner* _tmp17_;
	ScanDevice* _tmp25_;
	GError * _inner_error_ = NULL;
#line 44 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 46 "/home/bob/git/simple-scan/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 48 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = user_interface_new ();
#line 48 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_object_ref_sink (_tmp0_);
#line 48 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (self->priv->ui);
#line 48 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->ui = _tmp0_;
#line 49 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = self->priv->ui;
#line 49 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp2_ = user_interface_get_book (_tmp1_);
#line 49 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 49 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp4_ = _book_ref0 (_tmp3_);
#line 49 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 49 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->book = _tmp4_;
#line 50 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp5_ = self->priv->ui;
#line 50 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp5_, "start-scan", (GCallback) _simple_scan_scan_cb_user_interface_start_scan, self, 0);
#line 51 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp6_ = self->priv->ui;
#line 51 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp6_, "stop-scan", (GCallback) _simple_scan_cancel_cb_user_interface_stop_scan, self, 0);
#line 52 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp7_ = self->priv->ui;
#line 52 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp7_, "email", (GCallback) _simple_scan_email_cb_user_interface_email, self, 0);
#line 54 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp8_ = scanner_get_instance ();
#line 54 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 54 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->scanner = _tmp8_;
#line 55 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp9_ = self->priv->scanner;
#line 55 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp9_, "update-devices", (GCallback) _simple_scan_update_scan_devices_cb_scanner_update_devices, self, 0);
#line 56 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp10_ = self->priv->scanner;
#line 56 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp10_, "request-authorization", (GCallback) _simple_scan_authorize_cb_scanner_request_authorization, self, 0);
#line 57 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp11_ = self->priv->scanner;
#line 57 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp11_, "expect-page", (GCallback) _simple_scan_scanner_new_page_cb_scanner_expect_page, self, 0);
#line 58 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp12_ = self->priv->scanner;
#line 58 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp12_, "got-page-info", (GCallback) _simple_scan_scanner_page_info_cb_scanner_got_page_info, self, 0);
#line 59 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp13_ = self->priv->scanner;
#line 59 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp13_, "got-line", (GCallback) _simple_scan_scanner_line_cb_scanner_got_line, self, 0);
#line 60 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp14_ = self->priv->scanner;
#line 60 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp14_, "page-done", (GCallback) _simple_scan_scanner_page_done_cb_scanner_page_done, self, 0);
#line 61 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp15_ = self->priv->scanner;
#line 61 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp15_, "document-done", (GCallback) _simple_scan_scanner_document_done_cb_scanner_document_done, self, 0);
#line 62 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp16_ = self->priv->scanner;
#line 62 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp16_, "scan-failed", (GCallback) _simple_scan_scanner_failed_cb_scanner_scan_failed, self, 0);
#line 63 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp17_ = self->priv->scanner;
#line 63 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_signal_connect_object (_tmp17_, "scanning-changed", (GCallback) _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed, self, 0);
#line 904 "simple-scan.c"
	{
		GUsbContext* _tmp18_ = NULL;
		GUsbContext* _tmp19_;
		GUsbContext* _tmp20_;
		GUsbContext* _tmp21_;
		GUsbContext* _tmp22_;
#line 67 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp19_ = g_usb_context_new (&_inner_error_);
#line 67 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp18_ = _tmp19_;
#line 67 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 917 "simple-scan.c"
			goto __catch4_g_error;
		}
#line 67 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp20_ = _tmp18_;
#line 67 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp18_ = NULL;
#line 67 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (self->priv->usb_context);
#line 67 "/home/bob/git/simple-scan/src/simple-scan.vala"
		self->priv->usb_context = _tmp20_;
#line 68 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp21_ = self->priv->usb_context;
#line 68 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_signal_connect_object (_tmp21_, "device-added", (GCallback) ____lambda22__g_usb_context_device_added, self, 0);
#line 69 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp22_ = self->priv->usb_context;
#line 69 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_signal_connect_object (_tmp22_, "device-removed", (GCallback) ____lambda23__g_usb_context_device_removed, self, 0);
#line 65 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (_tmp18_);
#line 938 "simple-scan.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
#line 65 "/home/bob/git/simple-scan/src/simple-scan.vala"
		e = _inner_error_;
#line 65 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 73 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp23_ = e;
#line 73 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp24_ = _tmp23_->message;
#line 73 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_warning ("simple-scan.vala:73: Failed to create USB context: %s\n", _tmp24_);
#line 65 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_error_free0 (e);
#line 958 "simple-scan.c"
	}
	__finally4:
#line 65 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 65 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 65 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 65 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return;
#line 969 "simple-scan.c"
	}
#line 76 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp25_ = self->priv->default_device;
#line 76 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp25_ != NULL) {
#line 975 "simple-scan.c"
		GList* device_list = NULL;
		ScanDevice* _tmp26_;
		ScanDevice* _tmp27_;
		UserInterface* _tmp28_;
		GList* _tmp29_;
		UserInterface* _tmp30_;
		ScanDevice* _tmp31_;
		const gchar* _tmp32_;
#line 78 "/home/bob/git/simple-scan/src/simple-scan.vala"
		device_list = NULL;
#line 80 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp26_ = self->priv->default_device;
#line 80 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp27_ = _scan_device_ref0 (_tmp26_);
#line 80 "/home/bob/git/simple-scan/src/simple-scan.vala"
		device_list = g_list_append (device_list, _tmp27_);
#line 81 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp28_ = self->priv->ui;
#line 81 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp29_ = device_list;
#line 81 "/home/bob/git/simple-scan/src/simple-scan.vala"
		user_interface_set_scan_devices (_tmp28_, _tmp29_, NULL);
#line 82 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp30_ = self->priv->ui;
#line 82 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp31_ = self->priv->default_device;
#line 82 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp32_ = _tmp31_->name;
#line 82 "/home/bob/git/simple-scan/src/simple-scan.vala"
		user_interface_set_selected_device (_tmp30_, _tmp32_);
#line 76 "/home/bob/git/simple-scan/src/simple-scan.vala"
		(device_list == NULL) ? NULL : (device_list = (_g_list_free__scan_device_unref0_ (device_list), NULL));
#line 1008 "simple-scan.c"
	}
}


static void
simple_scan_real_activate (GApplication* base)
{
	SimpleScan * self;
	UserInterface* _tmp0_;
	Scanner* _tmp1_;
#line 86 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 88 "/home/bob/git/simple-scan/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 89 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 89 "/home/bob/git/simple-scan/src/simple-scan.vala"
	user_interface_start (_tmp0_);
#line 90 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = self->priv->scanner;
#line 90 "/home/bob/git/simple-scan/src/simple-scan.vala"
	scanner_start (_tmp1_);
#line 1031 "simple-scan.c"
}


static void
simple_scan_real_shutdown (GApplication* base)
{
	SimpleScan * self;
	Scanner* _tmp0_;
#line 93 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 95 "/home/bob/git/simple-scan/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 96 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 96 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->book = NULL;
#line 97 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (self->priv->ui);
#line 97 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->ui = NULL;
#line 98 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (self->priv->usb_context);
#line 98 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->usb_context = NULL;
#line 99 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 99 "/home/bob/git/simple-scan/src/simple-scan.vala"
	scanner_free (_tmp0_);
#line 1060 "simple-scan.c"
}


static void
simple_scan_update_scan_devices_cb (SimpleScan* self,
                                    Scanner* scanner,
                                    GList* devices)
{
	GList* devices_copy = NULL;
	GList* _tmp0_;
	ScanDevice* _tmp1_;
	GList* _tmp9_;
	gchar* missing_driver = NULL;
	gboolean _tmp10_;
	UserInterface* _tmp12_;
	GList* _tmp13_;
	const gchar* _tmp14_;
#line 102 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 104 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = g_list_copy (devices);
#line 104 "/home/bob/git/simple-scan/src/simple-scan.vala"
	devices_copy = _tmp0_;
#line 107 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = self->priv->default_device;
#line 107 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp1_ != NULL) {
#line 1090 "simple-scan.c"
		gboolean default_in_list = FALSE;
		GList* _tmp2_;
		gboolean _tmp7_;
#line 109 "/home/bob/git/simple-scan/src/simple-scan.vala"
		default_in_list = FALSE;
#line 110 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp2_ = devices_copy;
#line 1098 "simple-scan.c"
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
#line 110 "/home/bob/git/simple-scan/src/simple-scan.vala"
			device_collection = _tmp2_;
#line 110 "/home/bob/git/simple-scan/src/simple-scan.vala"
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 1106 "simple-scan.c"
				ScanDevice* device = NULL;
#line 110 "/home/bob/git/simple-scan/src/simple-scan.vala"
				device = (ScanDevice*) device_it->data;
#line 1110 "simple-scan.c"
				{
					ScanDevice* _tmp3_;
					const gchar* _tmp4_;
					ScanDevice* _tmp5_;
					const gchar* _tmp6_;
#line 112 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp3_ = device;
#line 112 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp4_ = _tmp3_->name;
#line 112 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp5_ = self->priv->default_device;
#line 112 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp6_ = _tmp5_->name;
#line 112 "/home/bob/git/simple-scan/src/simple-scan.vala"
					if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
#line 114 "/home/bob/git/simple-scan/src/simple-scan.vala"
						default_in_list = TRUE;
#line 115 "/home/bob/git/simple-scan/src/simple-scan.vala"
						break;
#line 1130 "simple-scan.c"
					}
				}
			}
		}
#line 119 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp7_ = default_in_list;
#line 119 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (!_tmp7_) {
#line 1139 "simple-scan.c"
			ScanDevice* _tmp8_;
#line 120 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp8_ = self->priv->default_device;
#line 120 "/home/bob/git/simple-scan/src/simple-scan.vala"
			devices_copy = g_list_prepend (devices_copy, _tmp8_);
#line 1145 "simple-scan.c"
		}
	}
#line 123 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp9_ = devices_copy;
#line 123 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->have_devices = g_list_length (_tmp9_) > ((guint) 0);
#line 126 "/home/bob/git/simple-scan/src/simple-scan.vala"
	missing_driver = NULL;
#line 127 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp10_ = self->priv->have_devices;
#line 127 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (!_tmp10_) {
#line 1158 "simple-scan.c"
		gchar* _tmp11_;
#line 128 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp11_ = simple_scan_suggest_driver (self);
#line 128 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (missing_driver);
#line 128 "/home/bob/git/simple-scan/src/simple-scan.vala"
		missing_driver = _tmp11_;
#line 1166 "simple-scan.c"
	}
#line 130 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp12_ = self->priv->ui;
#line 130 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp13_ = devices_copy;
#line 130 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp14_ = missing_driver;
#line 130 "/home/bob/git/simple-scan/src/simple-scan.vala"
	user_interface_set_scan_devices (_tmp12_, _tmp13_, _tmp14_);
#line 102 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (missing_driver);
#line 102 "/home/bob/git/simple-scan/src/simple-scan.vala"
	(devices_copy == NULL) ? NULL : (devices_copy = (g_list_free (devices_copy), NULL));
#line 1180 "simple-scan.c"
}


static void
_g_free0_ (gpointer var)
{
#line 186 "/home/bob/git/simple-scan/src/simple-scan.vala"
	var = (g_free (var), NULL);
#line 1189 "simple-scan.c"
}


static gint
g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	guint _tmp0_;
#line 5062 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 5062 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = self->len;
#line 5062 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = (gint) _tmp0_;
#line 5062 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1206 "simple-scan.c"
}


static void
g_ptr_array_set_length (GPtrArray* self,
                        gint value)
{
#line 5063 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_if_fail (self != NULL);
#line 5063 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_ptr_array_set_size (self, value);
#line 1218 "simple-scan.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 199 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return self ? g_object_ref (self) : NULL;
#line 1227 "simple-scan.c"
}


gchar*
simple_scan_suggest_driver (SimpleScan* self)
{
	gchar* result = NULL;
	GUsbContext* _tmp0_;
	GHashTable* driver_map = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	GHashTable* _tmp9_;
	GHashTable* _tmp10_;
	GPtrArray* devices = NULL;
	GUsbContext* _tmp11_;
	GPtrArray* _tmp12_;
#line 181 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 183 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->usb_context;
#line 183 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp0_ == NULL) {
#line 184 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = NULL;
#line 184 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 1260 "simple-scan.c"
	}
#line 186 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = g_direct_hash;
#line 186 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp2_ = g_direct_equal;
#line 186 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, NULL, _g_free0_);
#line 186 "/home/bob/git/simple-scan/src/simple-scan.vala"
	driver_map = _tmp3_;
#line 187 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp4_ = driver_map;
#line 187 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_add_devices (self, _tmp4_, SIMPLE_SCAN_brscan_devices, G_N_ELEMENTS (SIMPLE_SCAN_brscan_devices), "brscan");
#line 188 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp5_ = driver_map;
#line 188 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_add_devices (self, _tmp5_, SIMPLE_SCAN_brscan2_devices, G_N_ELEMENTS (SIMPLE_SCAN_brscan2_devices), "brscan2");
#line 189 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp6_ = driver_map;
#line 189 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_add_devices (self, _tmp6_, SIMPLE_SCAN_brscan3_devices, G_N_ELEMENTS (SIMPLE_SCAN_brscan3_devices), "brscan3");
#line 190 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp7_ = driver_map;
#line 190 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_add_devices (self, _tmp7_, SIMPLE_SCAN_brscan4_devices, G_N_ELEMENTS (SIMPLE_SCAN_brscan4_devices), "brscan4");
#line 191 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp8_ = driver_map;
#line 191 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_add_devices (self, _tmp8_, SIMPLE_SCAN_samsung_devices, G_N_ELEMENTS (SIMPLE_SCAN_samsung_devices), "samsung");
#line 192 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp9_ = driver_map;
#line 192 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_add_devices (self, _tmp9_, SIMPLE_SCAN_hpaio_devices, G_N_ELEMENTS (SIMPLE_SCAN_hpaio_devices), "hpaio");
#line 193 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp10_ = driver_map;
#line 193 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_add_devices (self, _tmp10_, SIMPLE_SCAN_epkowa_devices, G_N_ELEMENTS (SIMPLE_SCAN_epkowa_devices), "epkowa");
#line 194 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp11_ = self->priv->usb_context;
#line 194 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp12_ = g_usb_context_get_devices (_tmp11_);
#line 194 "/home/bob/git/simple-scan/src/simple-scan.vala"
	devices = _tmp12_;
#line 1304 "simple-scan.c"
	{
		gint i = 0;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
		i = 0;
#line 1309 "simple-scan.c"
		{
			gboolean _tmp13_ = FALSE;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp13_ = TRUE;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
			while (TRUE) {
#line 1316 "simple-scan.c"
				gint _tmp15_;
				GPtrArray* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				GUsbDevice* device = NULL;
				GPtrArray* _tmp19_;
				gpointer* _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				GUsbDevice* _tmp22_;
				GUsbDevice* _tmp23_;
				gchar* driver = NULL;
				GHashTable* _tmp24_;
				GUsbDevice* _tmp25_;
				GUsbDevice* _tmp26_;
				gconstpointer _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				if (!_tmp13_) {
#line 1337 "simple-scan.c"
					gint _tmp14_;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp14_ = i;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
					i = _tmp14_ + 1;
#line 1343 "simple-scan.c"
				}
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp13_ = FALSE;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp15_ = i;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp16_ = devices;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp17_ = g_ptr_array_get_length (_tmp16_);
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp18_ = _tmp17_;
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				if (!(_tmp15_ < _tmp18_)) {
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
					break;
#line 1359 "simple-scan.c"
				}
#line 199 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp19_ = devices;
#line 199 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp20_ = _tmp19_->pdata;
#line 199 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp20__length1 = (gint) _tmp19_->len;
#line 199 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp21_ = i;
#line 199 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp22_ = _tmp20_[_tmp21_];
#line 199 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp23_ = _g_object_ref0 (_tmp22_);
#line 199 "/home/bob/git/simple-scan/src/simple-scan.vala"
				device = _tmp23_;
#line 200 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp24_ = driver_map;
#line 200 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp25_ = device;
#line 200 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp26_ = device;
#line 200 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp27_ = g_hash_table_lookup (_tmp24_, (gpointer) ((guintptr) ((guint32) ((g_usb_device_get_vid (_tmp25_) << 16) | g_usb_device_get_pid (_tmp26_)))));
#line 200 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp28_ = g_strdup ((const gchar*) _tmp27_);
#line 200 "/home/bob/git/simple-scan/src/simple-scan.vala"
				driver = _tmp28_;
#line 201 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp29_ = driver;
#line 201 "/home/bob/git/simple-scan/src/simple-scan.vala"
				if (_tmp29_ != NULL) {
#line 202 "/home/bob/git/simple-scan/src/simple-scan.vala"
					result = driver;
#line 202 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_g_object_unref0 (device);
#line 202 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_g_ptr_array_unref0 (devices);
#line 202 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_g_hash_table_unref0 (driver_map);
#line 202 "/home/bob/git/simple-scan/src/simple-scan.vala"
					return result;
#line 1401 "simple-scan.c"
				}
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_free0 (driver);
#line 197 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_object_unref0 (device);
#line 1407 "simple-scan.c"
			}
		}
	}
#line 205 "/home/bob/git/simple-scan/src/simple-scan.vala"
	result = NULL;
#line 205 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_ptr_array_unref0 (devices);
#line 205 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_hash_table_unref0 (driver_map);
#line 205 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return result;
#line 1419 "simple-scan.c"
}


static void
simple_scan_add_devices (SimpleScan* self,
                         GHashTable* map,
                         guint32* devices,
                         int devices_length1,
                         const gchar* driver)
{
#line 208 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 208 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (map != NULL);
#line 208 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (driver != NULL);
#line 1436 "simple-scan.c"
	{
		gint i = 0;
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
		i = 0;
#line 1441 "simple-scan.c"
		{
			gboolean _tmp0_ = FALSE;
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp0_ = TRUE;
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
			while (TRUE) {
#line 1448 "simple-scan.c"
				gint _tmp2_;
				gint _tmp3_;
				guint32 _tmp4_;
				gchar* _tmp5_;
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
				if (!_tmp0_) {
#line 1455 "simple-scan.c"
					gint _tmp1_;
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp1_ = i;
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
					i = _tmp1_ + 1;
#line 1461 "simple-scan.c"
				}
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp0_ = FALSE;
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp2_ = i;
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
				if (!(_tmp2_ < devices_length1)) {
#line 210 "/home/bob/git/simple-scan/src/simple-scan.vala"
					break;
#line 1471 "simple-scan.c"
				}
#line 211 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp3_ = i;
#line 211 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp4_ = devices[_tmp3_];
#line 211 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp5_ = g_strdup (driver);
#line 211 "/home/bob/git/simple-scan/src/simple-scan.vala"
				g_hash_table_insert (map, (gpointer) ((guintptr) _tmp4_), _tmp5_);
#line 1481 "simple-scan.c"
			}
		}
	}
}


static void
simple_scan_authorize_cb (SimpleScan* self,
                          Scanner* scanner,
                          const gchar* resource)
{
	gchar* username = NULL;
	gchar* password = NULL;
	UserInterface* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 214 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 214 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (resource != NULL);
#line 217 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 217 "/home/bob/git/simple-scan/src/simple-scan.vala"
	user_interface_authorize (_tmp0_, resource, &_tmp1_, &_tmp2_);
#line 217 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (username);
#line 217 "/home/bob/git/simple-scan/src/simple-scan.vala"
	username = _tmp1_;
#line 217 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (password);
#line 217 "/home/bob/git/simple-scan/src/simple-scan.vala"
	password = _tmp2_;
#line 218 "/home/bob/git/simple-scan/src/simple-scan.vala"
	scanner_authorize (scanner, username, password);
#line 214 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (password);
#line 214 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (username);
#line 1522 "simple-scan.c"
}


static Page*
simple_scan_append_page (SimpleScan* self)
{
	Page* result = NULL;
	Page* page = NULL;
	Book* _tmp0_;
	Page* _tmp1_;
	gboolean _tmp2_ = FALSE;
	Page* _tmp3_;
	ScanDirection scan_direction = 0;
	gboolean do_crop = FALSE;
	gchar* named_crop = NULL;
	gint width = 0;
	gint height = 0;
	gint dpi = 0;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp10_;
	gint _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	ScanDirection _tmp46_;
	Page* _tmp47_;
	Book* _tmp48_;
	Page* _tmp49_;
	gboolean _tmp50_;
	UserInterface* _tmp60_;
	Page* _tmp61_;
	Page* _tmp62_;
#line 221 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 224 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 224 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = book_get_page (_tmp0_, -1);
#line 224 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page = _tmp1_;
#line 225 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = page;
#line 225 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp3_ != NULL) {
#line 1569 "simple-scan.c"
		Page* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
#line 225 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp4_ = page;
#line 225 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp5_ = page_get_has_data (_tmp4_);
#line 225 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp6_ = _tmp5_;
#line 225 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp2_ = !_tmp6_;
#line 1581 "simple-scan.c"
	} else {
#line 225 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp2_ = FALSE;
#line 1585 "simple-scan.c"
	}
#line 225 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp2_) {
#line 1589 "simple-scan.c"
		UserInterface* _tmp7_;
		Page* _tmp8_;
		Page* _tmp9_;
#line 227 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp7_ = self->priv->ui;
#line 227 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp8_ = page;
#line 227 "/home/bob/git/simple-scan/src/simple-scan.vala"
		user_interface_set_selected_page (_tmp7_, _tmp8_);
#line 228 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp9_ = page;
#line 228 "/home/bob/git/simple-scan/src/simple-scan.vala"
		page_start (_tmp9_);
#line 229 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = page;
#line 229 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 1607 "simple-scan.c"
	}
#line 233 "/home/bob/git/simple-scan/src/simple-scan.vala"
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 234 "/home/bob/git/simple-scan/src/simple-scan.vala"
	do_crop = FALSE;
#line 235 "/home/bob/git/simple-scan/src/simple-scan.vala"
	named_crop = NULL;
#line 236 "/home/bob/git/simple-scan/src/simple-scan.vala"
	width = 100;
#line 236 "/home/bob/git/simple-scan/src/simple-scan.vala"
	height = 100;
#line 236 "/home/bob/git/simple-scan/src/simple-scan.vala"
	dpi = 100;
#line 236 "/home/bob/git/simple-scan/src/simple-scan.vala"
	cx = 0;
#line 236 "/home/bob/git/simple-scan/src/simple-scan.vala"
	cy = 0;
#line 236 "/home/bob/git/simple-scan/src/simple-scan.vala"
	cw = 0;
#line 236 "/home/bob/git/simple-scan/src/simple-scan.vala"
	ch = 0;
#line 237 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp10_ = page;
#line 237 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp10_ != NULL) {
#line 1633 "simple-scan.c"
		Page* _tmp11_;
		ScanDirection _tmp12_;
		ScanDirection _tmp13_;
		Page* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		Page* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		Page* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		Page* _tmp23_;
		gboolean _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
#line 239 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp11_ = page;
#line 239 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp12_ = page_get_scan_direction (_tmp11_);
#line 239 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp13_ = _tmp12_;
#line 239 "/home/bob/git/simple-scan/src/simple-scan.vala"
		scan_direction = _tmp13_;
#line 240 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp14_ = page;
#line 240 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp15_ = page_get_width (_tmp14_);
#line 240 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp16_ = _tmp15_;
#line 240 "/home/bob/git/simple-scan/src/simple-scan.vala"
		width = _tmp16_;
#line 241 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp17_ = page;
#line 241 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp18_ = page_get_height (_tmp17_);
#line 241 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp19_ = _tmp18_;
#line 241 "/home/bob/git/simple-scan/src/simple-scan.vala"
		height = _tmp19_;
#line 242 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp20_ = page;
#line 242 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp21_ = page_get_dpi (_tmp20_);
#line 242 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp22_ = _tmp21_;
#line 242 "/home/bob/git/simple-scan/src/simple-scan.vala"
		dpi = _tmp22_;
#line 244 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp23_ = page;
#line 244 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp24_ = page_get_has_crop (_tmp23_);
#line 244 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp25_ = _tmp24_;
#line 244 "/home/bob/git/simple-scan/src/simple-scan.vala"
		do_crop = _tmp25_;
#line 245 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp26_ = do_crop;
#line 245 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (_tmp26_) {
#line 1694 "simple-scan.c"
			Page* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			Page* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			Page* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			Page* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			Page* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
#line 247 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp27_ = page;
#line 247 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp28_ = page_get_crop_name (_tmp27_);
#line 247 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp29_ = _tmp28_;
#line 247 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp30_ = g_strdup (_tmp29_);
#line 247 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (named_crop);
#line 247 "/home/bob/git/simple-scan/src/simple-scan.vala"
			named_crop = _tmp30_;
#line 248 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp31_ = page;
#line 248 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp32_ = page_get_crop_x (_tmp31_);
#line 248 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp33_ = _tmp32_;
#line 248 "/home/bob/git/simple-scan/src/simple-scan.vala"
			cx = _tmp33_;
#line 249 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp34_ = page;
#line 249 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp35_ = page_get_crop_y (_tmp34_);
#line 249 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp36_ = _tmp35_;
#line 249 "/home/bob/git/simple-scan/src/simple-scan.vala"
			cy = _tmp36_;
#line 250 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp37_ = page;
#line 250 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp38_ = page_get_crop_width (_tmp37_);
#line 250 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp39_ = _tmp38_;
#line 250 "/home/bob/git/simple-scan/src/simple-scan.vala"
			cw = _tmp39_;
#line 251 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp40_ = page;
#line 251 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp41_ = page_get_crop_height (_tmp40_);
#line 251 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp42_ = _tmp41_;
#line 251 "/home/bob/git/simple-scan/src/simple-scan.vala"
			ch = _tmp42_;
#line 1755 "simple-scan.c"
		}
	}
#line 255 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp43_ = width;
#line 255 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp44_ = height;
#line 255 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp45_ = dpi;
#line 255 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp46_ = scan_direction;
#line 255 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp47_ = page_new (_tmp43_, _tmp44_, _tmp45_, _tmp46_);
#line 255 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_page_unref0 (page);
#line 255 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page = _tmp47_;
#line 256 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp48_ = self->priv->book;
#line 256 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp49_ = page;
#line 256 "/home/bob/git/simple-scan/src/simple-scan.vala"
	book_append_page (_tmp48_, _tmp49_);
#line 257 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp50_ = do_crop;
#line 257 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp50_) {
#line 1782 "simple-scan.c"
		const gchar* _tmp51_;
		Page* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
#line 259 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp51_ = named_crop;
#line 259 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (_tmp51_ != NULL) {
#line 1791 "simple-scan.c"
			Page* _tmp52_;
			const gchar* _tmp53_;
#line 261 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp52_ = page;
#line 261 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp53_ = named_crop;
#line 261 "/home/bob/git/simple-scan/src/simple-scan.vala"
			page_set_named_crop (_tmp52_, _tmp53_);
#line 1800 "simple-scan.c"
		} else {
			Page* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
#line 264 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp54_ = page;
#line 264 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp55_ = cw;
#line 264 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp56_ = ch;
#line 264 "/home/bob/git/simple-scan/src/simple-scan.vala"
			page_set_custom_crop (_tmp54_, _tmp55_, _tmp56_);
#line 1813 "simple-scan.c"
		}
#line 265 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp57_ = page;
#line 265 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp58_ = cx;
#line 265 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp59_ = cy;
#line 265 "/home/bob/git/simple-scan/src/simple-scan.vala"
		page_move_crop (_tmp57_, _tmp58_, _tmp59_);
#line 1823 "simple-scan.c"
	}
#line 267 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp60_ = self->priv->ui;
#line 267 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp61_ = page;
#line 267 "/home/bob/git/simple-scan/src/simple-scan.vala"
	user_interface_set_selected_page (_tmp60_, _tmp61_);
#line 268 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp62_ = page;
#line 268 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page_start (_tmp62_);
#line 270 "/home/bob/git/simple-scan/src/simple-scan.vala"
	result = page;
#line 270 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (named_crop);
#line 270 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return result;
#line 1841 "simple-scan.c"
}


static void
simple_scan_scanner_new_page_cb (SimpleScan* self,
                                 Scanner* scanner)
{
	Page* _tmp0_;
	Page* _tmp1_;
#line 273 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 273 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 275 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = simple_scan_append_page (self);
#line 275 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = _tmp0_;
#line 275 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_page_unref0 (_tmp1_);
#line 1861 "simple-scan.c"
}


static gchar*
simple_scan_get_profile_for_device (SimpleScan* self,
                                    const gchar* device_name)
{
	gchar* result = NULL;
	gchar* device_id = NULL;
	gchar* _tmp0_;
	CdClient* client = NULL;
	CdClient* _tmp1_;
	CdDevice* device = NULL;
	CdProfile* profile = NULL;
	CdDevice* _tmp15_;
	CdProfile* _tmp16_;
	CdProfile* _tmp17_;
	CdProfile* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	CdProfile* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	CdProfile* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GError * _inner_error_ = NULL;
#line 278 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 278 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_val_if_fail (device_name != NULL, NULL);
#line 281 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = g_strdup_printf ("sane:%s", device_name);
#line 281 "/home/bob/git/simple-scan/src/simple-scan.vala"
	device_id = _tmp0_;
#line 282 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_debug ("simple-scan.vala:282: Getting color profile for device %s", device_name);
#line 284 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = cd_client_new ();
#line 284 "/home/bob/git/simple-scan/src/simple-scan.vala"
	client = _tmp1_;
#line 1904 "simple-scan.c"
	{
		CdClient* _tmp2_;
#line 287 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp2_ = client;
#line 287 "/home/bob/git/simple-scan/src/simple-scan.vala"
		cd_client_connect_sync (_tmp2_, NULL, &_inner_error_);
#line 287 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1913 "simple-scan.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 285 "/home/bob/git/simple-scan/src/simple-scan.vala"
		e = _inner_error_;
#line 285 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 291 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp3_ = e;
#line 291 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp4_ = _tmp3_->message;
#line 291 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_debug ("simple-scan.vala:291: Failed to connect to colord: %s", _tmp4_);
#line 292 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = NULL;
#line 292 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_error_free0 (e);
#line 292 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 292 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 292 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 1943 "simple-scan.c"
	}
	__finally5:
#line 285 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 285 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 285 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 285 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 285 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 285 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return NULL;
#line 1958 "simple-scan.c"
	}
	{
		CdDevice* _tmp5_ = NULL;
		CdClient* _tmp6_;
		const gchar* _tmp7_;
		CdDevice* _tmp8_;
		CdDevice* _tmp9_;
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp6_ = client;
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp7_ = device_id;
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp8_ = cd_client_find_device_by_property_sync (_tmp6_, CD_DEVICE_PROPERTY_SERIAL, _tmp7_, NULL, &_inner_error_);
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp5_ = _tmp8_;
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1976 "simple-scan.c"
			goto __catch6_g_error;
		}
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp9_ = _tmp5_;
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp5_ = NULL;
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 298 "/home/bob/git/simple-scan/src/simple-scan.vala"
		device = _tmp9_;
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (_tmp5_);
#line 1989 "simple-scan.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		e = _inner_error_;
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 302 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp10_ = e;
#line 302 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp11_ = _tmp10_->message;
#line 302 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_debug ("simple-scan.vala:302: Unable to find colord device %s: %s", device_name, _tmp11_);
#line 303 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = NULL;
#line 303 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_error_free0 (e);
#line 303 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 303 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 303 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 303 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 2019 "simple-scan.c"
	}
	__finally6:
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 296 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return NULL;
#line 2036 "simple-scan.c"
	}
	{
		CdDevice* _tmp12_;
#line 308 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp12_ = device;
#line 308 "/home/bob/git/simple-scan/src/simple-scan.vala"
		cd_device_connect_sync (_tmp12_, NULL, &_inner_error_);
#line 308 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2046 "simple-scan.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
		e = _inner_error_;
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 312 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp13_ = e;
#line 312 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp14_ = _tmp13_->message;
#line 312 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_debug ("simple-scan.vala:312: Failed to get properties from the device %s: %s", device_name, _tmp14_);
#line 313 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = NULL;
#line 313 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_error_free0 (e);
#line 313 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 313 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 313 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 313 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 2078 "simple-scan.c"
	}
	__finally7:
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 306 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return NULL;
#line 2095 "simple-scan.c"
	}
#line 316 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp15_ = device;
#line 316 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp16_ = cd_device_get_default_profile (_tmp15_);
#line 316 "/home/bob/git/simple-scan/src/simple-scan.vala"
	profile = _tmp16_;
#line 317 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp17_ = profile;
#line 317 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp17_ == NULL) {
#line 319 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_debug ("simple-scan.vala:319: No default color profile for device: %s", device_name);
#line 320 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = NULL;
#line 320 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 320 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 320 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 320 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 320 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 2121 "simple-scan.c"
	}
	{
		CdProfile* _tmp18_;
#line 325 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp18_ = profile;
#line 325 "/home/bob/git/simple-scan/src/simple-scan.vala"
		cd_profile_connect_sync (_tmp18_, NULL, &_inner_error_);
#line 325 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2131 "simple-scan.c"
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		e = _inner_error_;
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 329 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp19_ = e;
#line 329 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp20_ = _tmp19_->message;
#line 329 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_debug ("simple-scan.vala:329: Failed to get properties from the profile %s: %s", device_name, _tmp20_);
#line 330 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = NULL;
#line 330 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_error_free0 (e);
#line 330 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 330 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 330 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 330 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 330 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 2165 "simple-scan.c"
	}
	__finally8:
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 323 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return NULL;
#line 2184 "simple-scan.c"
	}
#line 333 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp21_ = profile;
#line 333 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp22_ = cd_profile_get_filename (_tmp21_);
#line 333 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp23_ = _tmp22_;
#line 333 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp23_ == NULL) {
#line 335 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_debug ("simple-scan.vala:335: No icc color profile for the device %s", device_name);
#line 336 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = NULL;
#line 336 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 336 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 336 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 336 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (device_id);
#line 336 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 2208 "simple-scan.c"
	}
#line 339 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp24_ = profile;
#line 339 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp25_ = cd_profile_get_filename (_tmp24_);
#line 339 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp26_ = _tmp25_;
#line 339 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_debug ("simple-scan.vala:339: Using color profile %s for device %s", _tmp26_, device_name);
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp27_ = profile;
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp28_ = cd_profile_get_filename (_tmp27_);
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp29_ = _tmp28_;
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp30_ = g_strdup (_tmp29_);
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	result = _tmp30_;
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (profile);
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (device);
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (client);
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (device_id);
#line 340 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return result;
#line 2238 "simple-scan.c"
}


static void
simple_scan_scanner_page_info_cb (SimpleScan* self,
                                  Scanner* scanner,
                                  ScanPageInfo* info)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Page* page = NULL;
	Page* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
#line 346 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 346 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 346 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (info != NULL);
#line 348 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = info->width;
#line 348 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = info->height;
#line 348 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp2_ = info->depth;
#line 348 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_debug ("simple-scan.vala:348: Page is %d pixels wide, %d pixels high, %d bits " \
"per pixel", _tmp0_, _tmp1_, _tmp2_);
#line 352 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = simple_scan_append_page (self);
#line 352 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page = _tmp3_;
#line 353 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page_set_page_info (page, info);
#line 358 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp4_ = info->device;
#line 358 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp5_ = simple_scan_get_profile_for_device (self, _tmp4_);
#line 358 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp6_ = _tmp5_;
#line 358 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page_set_color_profile (page, _tmp6_);
#line 358 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (_tmp6_);
#line 346 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_page_unref0 (page);
#line 2287 "simple-scan.c"
}


static void
simple_scan_scanner_line_cb (SimpleScan* self,
                             Scanner* scanner,
                             ScanLine* line)
{
	Page* page = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	Page* _tmp4_;
#line 361 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 361 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 361 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (line != NULL);
#line 363 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 363 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 363 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 363 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 363 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp4_ = book_get_page (_tmp0_, ((gint) _tmp3_) - 1);
#line 363 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page = _tmp4_;
#line 364 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page_parse_scan_line (page, line);
#line 361 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_page_unref0 (page);
#line 2324 "simple-scan.c"
}


static void
simple_scan_scanner_page_done_cb (SimpleScan* self,
                                  Scanner* scanner)
{
	Page* page = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	Page* _tmp4_;
#line 367 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 367 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 369 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 369 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 369 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 369 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 369 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp4_ = book_get_page (_tmp0_, ((gint) _tmp3_) - 1);
#line 369 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page = _tmp4_;
#line 370 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page_finish (page);
#line 367 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_page_unref0 (page);
#line 2358 "simple-scan.c"
}


static void
simple_scan_remove_empty_page (SimpleScan* self)
{
	Page* page = NULL;
	Book* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
#line 373 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 375 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 375 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 375 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 375 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 375 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp4_ = book_get_page (_tmp0_, ((gint) _tmp3_) - 1);
#line 375 "/home/bob/git/simple-scan/src/simple-scan.vala"
	page = _tmp4_;
#line 376 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp5_ = page;
#line 376 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp6_ = page_get_has_data (_tmp5_);
#line 376 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp7_ = _tmp6_;
#line 376 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (!_tmp7_) {
#line 2396 "simple-scan.c"
		Book* _tmp8_;
		Page* _tmp9_;
#line 377 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp8_ = self->priv->book;
#line 377 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp9_ = page;
#line 377 "/home/bob/git/simple-scan/src/simple-scan.vala"
		book_delete_page (_tmp8_, _tmp9_);
#line 2405 "simple-scan.c"
	}
#line 373 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_page_unref0 (page);
#line 2409 "simple-scan.c"
}


static void
simple_scan_scanner_document_done_cb (SimpleScan* self,
                                      Scanner* scanner)
{
#line 380 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 380 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 382 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_remove_empty_page (self);
#line 2423 "simple-scan.c"
}


static void
simple_scan_scanner_failed_cb (SimpleScan* self,
                               Scanner* scanner,
                               gint error_code,
                               const gchar* error_string)
{
#line 385 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 385 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 385 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (error_string != NULL);
#line 387 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_remove_empty_page (self);
#line 388 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (error_code != ((gint) SANE_STATUS_CANCELLED)) {
#line 2443 "simple-scan.c"
		UserInterface* _tmp0_;
		gboolean _tmp1_;
#line 390 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp0_ = self->priv->ui;
#line 390 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp1_ = self->priv->have_devices;
#line 390 "/home/bob/git/simple-scan/src/simple-scan.vala"
		user_interface_show_error (_tmp0_, _ ("Failed to scan"), error_string, _tmp1_);
#line 2452 "simple-scan.c"
	}
}


static void
simple_scan_scanner_scanning_changed_cb (SimpleScan* self,
                                         Scanner* scanner)
{
	UserInterface* _tmp0_;
#line 397 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 397 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 399 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 399 "/home/bob/git/simple-scan/src/simple-scan.vala"
	user_interface_set_scanning (_tmp0_, scanner_is_scanning (scanner));
#line 2470 "simple-scan.c"
}


static void
simple_scan_scan_cb (SimpleScan* self,
                     UserInterface* ui,
                     const gchar* device,
                     ScanOptions* options)
{
	gint _tmp0_;
	Scanner* _tmp1_;
	Scanner* _tmp4_;
#line 402 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 402 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 402 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (options != NULL);
#line 404 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = options->dpi;
#line 404 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_debug ("simple-scan.vala:404: Requesting scan at %d dpi from device '%s'", _tmp0_, device);
#line 406 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = self->priv->scanner;
#line 406 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (!scanner_is_scanning (_tmp1_)) {
#line 2497 "simple-scan.c"
		Page* _tmp2_;
		Page* _tmp3_;
#line 407 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp2_ = simple_scan_append_page (self);
#line 407 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp3_ = _tmp2_;
#line 407 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_page_unref0 (_tmp3_);
#line 2506 "simple-scan.c"
	}
#line 409 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp4_ = self->priv->scanner;
#line 409 "/home/bob/git/simple-scan/src/simple-scan.vala"
	scanner_scan (_tmp4_, device, options);
#line 2512 "simple-scan.c"
}


static void
simple_scan_cancel_cb (SimpleScan* self,
                       UserInterface* ui)
{
	Scanner* _tmp0_;
#line 412 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 412 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 414 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 414 "/home/bob/git/simple-scan/src/simple-scan.vala"
	scanner_cancel (_tmp0_);
#line 2529 "simple-scan.c"
}


static gchar*
simple_scan_get_temporary_filename (SimpleScan* self,
                                    const gchar* prefix,
                                    const gchar* extension)
{
	gchar* result = NULL;
	gchar* filename = NULL;
	gchar* _tmp0_;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 417 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 417 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 417 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 422 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = g_strdup_printf ("%sXXXXXX.%s", prefix, extension);
#line 422 "/home/bob/git/simple-scan/src/simple-scan.vala"
	filename = _tmp0_;
#line 2553 "simple-scan.c"
	{
		gint fd = 0;
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gint _tmp3_;
		gint _tmp4_;
#line 426 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp1_ = filename;
#line 426 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp3_ = g_file_open_tmp (_tmp1_, &_tmp2_, &_inner_error_);
#line 426 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (path);
#line 426 "/home/bob/git/simple-scan/src/simple-scan.vala"
		path = _tmp2_;
#line 426 "/home/bob/git/simple-scan/src/simple-scan.vala"
		fd = _tmp3_;
#line 426 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2572 "simple-scan.c"
			goto __catch9_g_error;
		}
#line 427 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp4_ = fd;
#line 427 "/home/bob/git/simple-scan/src/simple-scan.vala"
		close (_tmp4_);
#line 2579 "simple-scan.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 424 "/home/bob/git/simple-scan/src/simple-scan.vala"
		e = _inner_error_;
#line 424 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 431 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp5_ = e;
#line 431 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp6_ = _tmp5_->message;
#line 431 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_warning ("simple-scan.vala:431: Error saving email attachment: %s", _tmp6_);
#line 432 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = NULL;
#line 432 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_error_free0 (e);
#line 432 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (path);
#line 432 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (filename);
#line 432 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 2607 "simple-scan.c"
	}
	__finally9:
#line 424 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 424 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (path);
#line 424 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (filename);
#line 424 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 424 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 424 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return NULL;
#line 2622 "simple-scan.c"
	}
#line 435 "/home/bob/git/simple-scan/src/simple-scan.vala"
	result = path;
#line 435 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (filename);
#line 435 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return result;
#line 2630 "simple-scan.c"
}


static void
simple_scan_email_cb (SimpleScan* self,
                      UserInterface* ui,
                      const gchar* profile,
                      gint quality)
{
	gboolean saved = FALSE;
	gchar* command_line = NULL;
	gchar* _tmp0_;
	const gchar* _tmp37_;
	GError * _inner_error_ = NULL;
#line 438 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 438 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 438 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (profile != NULL);
#line 440 "/home/bob/git/simple-scan/src/simple-scan.vala"
	saved = FALSE;
#line 441 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = g_strdup ("xdg-email");
#line 441 "/home/bob/git/simple-scan/src/simple-scan.vala"
	command_line = _tmp0_;
#line 444 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (g_strcmp0 (profile, "text") == 0) {
#line 2659 "simple-scan.c"
		gchar* path = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
#line 447 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp1_ = simple_scan_get_temporary_filename (self, "scan", "pdf");
#line 447 "/home/bob/git/simple-scan/src/simple-scan.vala"
		path = _tmp1_;
#line 448 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp2_ = path;
#line 448 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (_tmp2_ != NULL) {
#line 2671 "simple-scan.c"
			GFile* file = NULL;
			const gchar* _tmp3_;
			GFile* _tmp4_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
#line 450 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp3_ = path;
#line 450 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp4_ = g_file_new_for_path (_tmp3_);
#line 450 "/home/bob/git/simple-scan/src/simple-scan.vala"
			file = _tmp4_;
#line 451 "/home/bob/git/simple-scan/src/simple-scan.vala"
			user_interface_show_progress_dialog (ui);
#line 2688 "simple-scan.c"
			{
				Book* _tmp5_;
				GFile* _tmp6_;
#line 454 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp5_ = self->priv->book;
#line 454 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp6_ = file;
#line 454 "/home/bob/git/simple-scan/src/simple-scan.vala"
				book_save (_tmp5_, "pdf", quality, _tmp6_, &_inner_error_);
#line 454 "/home/bob/git/simple-scan/src/simple-scan.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2700 "simple-scan.c"
					goto __catch10_g_error;
				}
			}
			goto __finally10;
			__catch10_g_error:
			{
				GError* e = NULL;
				GError* _tmp7_;
				const gchar* _tmp8_;
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
				e = _inner_error_;
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_inner_error_ = NULL;
#line 458 "/home/bob/git/simple-scan/src/simple-scan.vala"
				user_interface_hide_progress_dialog (ui);
#line 459 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp7_ = e;
#line 459 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp8_ = _tmp7_->message;
#line 459 "/home/bob/git/simple-scan/src/simple-scan.vala"
				g_warning ("simple-scan.vala:459: Unable to save email file: %s", _tmp8_);
#line 460 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_error_free0 (e);
#line 460 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 460 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_free0 (path);
#line 460 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_free0 (command_line);
#line 460 "/home/bob/git/simple-scan/src/simple-scan.vala"
				return;
#line 2732 "simple-scan.c"
			}
			__finally10:
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_free0 (path);
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_free0 (command_line);
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
				g_clear_error (&_inner_error_);
#line 452 "/home/bob/git/simple-scan/src/simple-scan.vala"
				return;
#line 2749 "simple-scan.c"
			}
#line 462 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp9_ = command_line;
#line 462 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp10_ = path;
#line 462 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp11_ = g_strdup_printf (" --attach %s", _tmp10_);
#line 462 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp12_ = _tmp11_;
#line 462 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
#line 462 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (command_line);
#line 462 "/home/bob/git/simple-scan/src/simple-scan.vala"
			command_line = _tmp13_;
#line 462 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (_tmp12_);
#line 448 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_object_unref0 (file);
#line 2769 "simple-scan.c"
		}
#line 444 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (path);
#line 2773 "simple-scan.c"
	} else {
		{
			gint i = 0;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
			i = 0;
#line 2779 "simple-scan.c"
			{
				gboolean _tmp14_ = FALSE;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp14_ = TRUE;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
				while (TRUE) {
#line 2786 "simple-scan.c"
					gint _tmp16_;
					Book* _tmp17_;
					guint _tmp18_;
					guint _tmp19_;
					gchar* path = NULL;
					gchar* _tmp20_;
					const gchar* _tmp21_;
					GFile* file = NULL;
					const gchar* _tmp22_;
					GFile* _tmp23_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gboolean _tmp36_;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					if (!_tmp14_) {
#line 2805 "simple-scan.c"
						gint _tmp15_;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp15_ = i;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
						i = _tmp15_ + 1;
#line 2811 "simple-scan.c"
					}
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp14_ = FALSE;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp16_ = i;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp17_ = self->priv->book;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp18_ = book_get_n_pages (_tmp17_);
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp19_ = _tmp18_;
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					if (!(((guint) _tmp16_) < _tmp19_)) {
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
						break;
#line 2827 "simple-scan.c"
					}
#line 469 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp20_ = simple_scan_get_temporary_filename (self, "scan", "jpg");
#line 469 "/home/bob/git/simple-scan/src/simple-scan.vala"
					path = _tmp20_;
#line 470 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp21_ = path;
#line 470 "/home/bob/git/simple-scan/src/simple-scan.vala"
					if (_tmp21_ == NULL) {
#line 472 "/home/bob/git/simple-scan/src/simple-scan.vala"
						saved = FALSE;
#line 473 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_free0 (path);
#line 473 "/home/bob/git/simple-scan/src/simple-scan.vala"
						break;
#line 2843 "simple-scan.c"
					}
#line 476 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp22_ = path;
#line 476 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp23_ = g_file_new_for_path (_tmp22_);
#line 476 "/home/bob/git/simple-scan/src/simple-scan.vala"
					file = _tmp23_;
#line 2851 "simple-scan.c"
					{
						Book* _tmp24_;
						gint _tmp25_;
						Page* _tmp26_;
						Page* _tmp27_;
						GFile* _tmp28_;
#line 479 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp24_ = self->priv->book;
#line 479 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp25_ = i;
#line 479 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp26_ = book_get_page (_tmp24_, _tmp25_);
#line 479 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp27_ = _tmp26_;
#line 479 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp28_ = file;
#line 479 "/home/bob/git/simple-scan/src/simple-scan.vala"
						page_save (_tmp27_, "jpeg", quality, _tmp28_, &_inner_error_);
#line 479 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_page_unref0 (_tmp27_);
#line 479 "/home/bob/git/simple-scan/src/simple-scan.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2874 "simple-scan.c"
							goto __catch11_g_error;
						}
					}
					goto __finally11;
					__catch11_g_error:
					{
						GError* e = NULL;
						GError* _tmp29_;
						const gchar* _tmp30_;
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
						e = _inner_error_;
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_inner_error_ = NULL;
#line 483 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp29_ = e;
#line 483 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp30_ = _tmp29_->message;
#line 483 "/home/bob/git/simple-scan/src/simple-scan.vala"
						g_warning ("simple-scan.vala:483: Unable to save email file: %s", _tmp30_);
#line 484 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_error_free0 (e);
#line 484 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 484 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_free0 (path);
#line 484 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_free0 (command_line);
#line 484 "/home/bob/git/simple-scan/src/simple-scan.vala"
						return;
#line 2904 "simple-scan.c"
					}
					__finally11:
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_free0 (path);
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_free0 (command_line);
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
						g_clear_error (&_inner_error_);
#line 477 "/home/bob/git/simple-scan/src/simple-scan.vala"
						return;
#line 2921 "simple-scan.c"
					}
#line 486 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp31_ = command_line;
#line 486 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp32_ = path;
#line 486 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp33_ = g_strdup_printf (" --attach %s", _tmp32_);
#line 486 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp34_ = _tmp33_;
#line 486 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp35_ = g_strconcat (_tmp31_, _tmp34_, NULL);
#line 486 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_g_free0 (command_line);
#line 486 "/home/bob/git/simple-scan/src/simple-scan.vala"
					command_line = _tmp35_;
#line 486 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_g_free0 (_tmp34_);
#line 488 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp36_ = saved;
#line 488 "/home/bob/git/simple-scan/src/simple-scan.vala"
					if (!_tmp36_) {
#line 489 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 489 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_free0 (path);
#line 489 "/home/bob/git/simple-scan/src/simple-scan.vala"
						break;
#line 2949 "simple-scan.c"
					}
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_g_object_unref0 (file);
#line 467 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_g_free0 (path);
#line 2955 "simple-scan.c"
				}
			}
		}
	}
#line 493 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp37_ = command_line;
#line 493 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_debug ("simple-scan.vala:493: Launching email client: %s", _tmp37_);
#line 2964 "simple-scan.c"
	{
		const gchar* _tmp38_;
#line 496 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp38_ = command_line;
#line 496 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_spawn_command_line_async (_tmp38_, &_inner_error_);
#line 496 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2973 "simple-scan.c"
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp39_;
		const gchar* _tmp40_;
#line 494 "/home/bob/git/simple-scan/src/simple-scan.vala"
		e = _inner_error_;
#line 494 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 500 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp39_ = e;
#line 500 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp40_ = _tmp39_->message;
#line 500 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_warning ("simple-scan.vala:500: Unable to start email: %s", _tmp40_);
#line 494 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_error_free0 (e);
#line 2995 "simple-scan.c"
	}
	__finally12:
#line 494 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 494 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (command_line);
#line 494 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 494 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 494 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return;
#line 3008 "simple-scan.c"
	}
#line 438 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (command_line);
#line 3012 "simple-scan.c"
}


static void
simple_scan_log_cb (const gchar* log_domain,
                    GLogLevelFlags log_level,
                    const gchar* message)
{
	gchar* prefix = NULL;
	FILE* _tmp7_;
	GTimer* _tmp8_;
	gdouble _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
#line 504 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (message != NULL);
#line 508 "/home/bob/git/simple-scan/src/simple-scan.vala"
	switch (log_level & G_LOG_LEVEL_MASK) {
#line 508 "/home/bob/git/simple-scan/src/simple-scan.vala"
		case G_LOG_LEVEL_ERROR:
#line 3033 "simple-scan.c"
		{
			gchar* _tmp0_;
#line 511 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp0_ = g_strdup ("ERROR:");
#line 511 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (prefix);
#line 511 "/home/bob/git/simple-scan/src/simple-scan.vala"
			prefix = _tmp0_;
#line 512 "/home/bob/git/simple-scan/src/simple-scan.vala"
			break;
#line 3044 "simple-scan.c"
		}
#line 508 "/home/bob/git/simple-scan/src/simple-scan.vala"
		case G_LOG_LEVEL_CRITICAL:
#line 3048 "simple-scan.c"
		{
			gchar* _tmp1_;
#line 514 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp1_ = g_strdup ("CRITICAL:");
#line 514 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (prefix);
#line 514 "/home/bob/git/simple-scan/src/simple-scan.vala"
			prefix = _tmp1_;
#line 515 "/home/bob/git/simple-scan/src/simple-scan.vala"
			break;
#line 3059 "simple-scan.c"
		}
#line 508 "/home/bob/git/simple-scan/src/simple-scan.vala"
		case G_LOG_LEVEL_WARNING:
#line 3063 "simple-scan.c"
		{
			gchar* _tmp2_;
#line 517 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp2_ = g_strdup ("WARNING:");
#line 517 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (prefix);
#line 517 "/home/bob/git/simple-scan/src/simple-scan.vala"
			prefix = _tmp2_;
#line 518 "/home/bob/git/simple-scan/src/simple-scan.vala"
			break;
#line 3074 "simple-scan.c"
		}
#line 508 "/home/bob/git/simple-scan/src/simple-scan.vala"
		case G_LOG_LEVEL_MESSAGE:
#line 3078 "simple-scan.c"
		{
			gchar* _tmp3_;
#line 520 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp3_ = g_strdup ("MESSAGE:");
#line 520 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (prefix);
#line 520 "/home/bob/git/simple-scan/src/simple-scan.vala"
			prefix = _tmp3_;
#line 521 "/home/bob/git/simple-scan/src/simple-scan.vala"
			break;
#line 3089 "simple-scan.c"
		}
#line 508 "/home/bob/git/simple-scan/src/simple-scan.vala"
		case G_LOG_LEVEL_INFO:
#line 3093 "simple-scan.c"
		{
			gchar* _tmp4_;
#line 523 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp4_ = g_strdup ("INFO:");
#line 523 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (prefix);
#line 523 "/home/bob/git/simple-scan/src/simple-scan.vala"
			prefix = _tmp4_;
#line 524 "/home/bob/git/simple-scan/src/simple-scan.vala"
			break;
#line 3104 "simple-scan.c"
		}
#line 508 "/home/bob/git/simple-scan/src/simple-scan.vala"
		case G_LOG_LEVEL_DEBUG:
#line 3108 "simple-scan.c"
		{
			gchar* _tmp5_;
#line 526 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp5_ = g_strdup ("DEBUG:");
#line 526 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (prefix);
#line 526 "/home/bob/git/simple-scan/src/simple-scan.vala"
			prefix = _tmp5_;
#line 527 "/home/bob/git/simple-scan/src/simple-scan.vala"
			break;
#line 3119 "simple-scan.c"
		}
		default:
		{
			gchar* _tmp6_;
#line 529 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp6_ = g_strdup ("LOG:");
#line 529 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (prefix);
#line 529 "/home/bob/git/simple-scan/src/simple-scan.vala"
			prefix = _tmp6_;
#line 530 "/home/bob/git/simple-scan/src/simple-scan.vala"
			break;
#line 3132 "simple-scan.c"
		}
	}
#line 533 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp7_ = simple_scan_log_file;
#line 533 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp8_ = simple_scan_log_timer;
#line 533 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp9_ = g_timer_elapsed (_tmp8_, NULL);
#line 533 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp10_ = prefix;
#line 533 "/home/bob/git/simple-scan/src/simple-scan.vala"
	fprintf (_tmp7_, "[%+.2fs] %s %s\n", _tmp9_, _tmp10_, message);
#line 534 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp11_ = simple_scan_debug_enabled;
#line 534 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp11_) {
#line 3149 "simple-scan.c"
		FILE* _tmp12_;
		GTimer* _tmp13_;
		gdouble _tmp14_;
		const gchar* _tmp15_;
#line 535 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp12_ = stderr;
#line 535 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp13_ = simple_scan_log_timer;
#line 535 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp14_ = g_timer_elapsed (_tmp13_, NULL);
#line 535 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp15_ = prefix;
#line 535 "/home/bob/git/simple-scan/src/simple-scan.vala"
		fprintf (_tmp12_, "[%+.2fs] %s %s\n", _tmp14_, _tmp15_, message);
#line 3164 "simple-scan.c"
	}
#line 504 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (prefix);
#line 3168 "simple-scan.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1392 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1392 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1393 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1393 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1394 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1394 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 3192 "simple-scan.c"
	} else {
		gchar* _tmp2_;
#line 1396 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1396 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1396 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 3201 "simple-scan.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1403 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1405 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1405 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 3222 "simple-scan.c"
	} else {
#line 1405 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3226 "simple-scan.c"
	}
#line 1405 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1407 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 3232 "simple-scan.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1409 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1409 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1409 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 3242 "simple-scan.c"
	}
#line 1412 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 3246 "simple-scan.c"
		glong _tmp3_;
#line 1413 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1413 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1414 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 3254 "simple-scan.c"
	} else {
		glong _tmp4_;
#line 1416 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1416 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 3261 "simple-scan.c"
	}
#line 1418 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 3265 "simple-scan.c"
		glong _tmp5_;
#line 1419 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1419 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 3271 "simple-scan.c"
	}
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1421 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1422 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 3283 "simple-scan.c"
}


static void
simple_scan_fix_pdf (const gchar* filename,
                     GError** error)
{
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guint8* _tmp0_ = NULL;
	size_t _tmp1_;
	FILE* fixed_file = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	gint offset = 0;
	gint line_number = 0;
	gint xref_offset = 0;
	gint xref_line = 0;
	gint startxref_line = 0;
	gint fixed_size = 0;
	GString* line = NULL;
	GString* _tmp6_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gboolean _tmp94_;
	GError * _inner_error_ = NULL;
#line 538 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_return_if_fail (filename != NULL);
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_file_get_contents (filename, (gchar**) (&_tmp0_), &_tmp1_, &_inner_error_);
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
	data = _tmp0_;
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
	data_length1 = _tmp1_;
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_data_size_ = data_length1;
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_propagate_error (error, _inner_error_);
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
		data = (g_free (data), NULL);
#line 541 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return;
#line 3333 "simple-scan.c"
	}
#line 543 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp2_ = g_strconcat (filename, ".fixed", NULL);
#line 543 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 543 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp4_ = g_fopen (_tmp3_, "w");
#line 543 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp5_ = _tmp4_;
#line 543 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (_tmp3_);
#line 543 "/home/bob/git/simple-scan/src/simple-scan.vala"
	fixed_file = _tmp5_;
#line 545 "/home/bob/git/simple-scan/src/simple-scan.vala"
	offset = 0;
#line 546 "/home/bob/git/simple-scan/src/simple-scan.vala"
	line_number = 0;
#line 547 "/home/bob/git/simple-scan/src/simple-scan.vala"
	xref_offset = 0;
#line 548 "/home/bob/git/simple-scan/src/simple-scan.vala"
	xref_line = -1;
#line 549 "/home/bob/git/simple-scan/src/simple-scan.vala"
	startxref_line = -1;
#line 550 "/home/bob/git/simple-scan/src/simple-scan.vala"
	fixed_size = -1;
#line 551 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp6_ = g_string_new ("");
#line 551 "/home/bob/git/simple-scan/src/simple-scan.vala"
	line = _tmp6_;
#line 552 "/home/bob/git/simple-scan/src/simple-scan.vala"
	while (TRUE) {
#line 3365 "simple-scan.c"
		gint _tmp7_;
		gint end_offset = 0;
		gint _tmp8_;
		GString* _tmp9_;
		GString* _tmp17_;
		const gchar* _tmp18_;
		GString* _tmp20_;
		const gchar* _tmp21_;
		gboolean _tmp23_ = FALSE;
		gint _tmp24_;
		gint _tmp90_;
		gint _tmp91_;
#line 552 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp7_ = offset;
#line 552 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (!(_tmp7_ < data_length1)) {
#line 552 "/home/bob/git/simple-scan/src/simple-scan.vala"
			break;
#line 3384 "simple-scan.c"
		}
#line 554 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp8_ = offset;
#line 554 "/home/bob/git/simple-scan/src/simple-scan.vala"
		end_offset = _tmp8_;
#line 555 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp9_ = line;
#line 555 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_string_assign (_tmp9_, "");
#line 556 "/home/bob/git/simple-scan/src/simple-scan.vala"
		while (TRUE) {
#line 3396 "simple-scan.c"
			gint _tmp10_;
			guint8 c = 0U;
			gint _tmp11_;
			guint8 _tmp12_;
			GString* _tmp13_;
			guint8 _tmp14_;
			gint _tmp15_;
			guint8 _tmp16_;
#line 556 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp10_ = end_offset;
#line 556 "/home/bob/git/simple-scan/src/simple-scan.vala"
			if (!(_tmp10_ < data_length1)) {
#line 556 "/home/bob/git/simple-scan/src/simple-scan.vala"
				break;
#line 3411 "simple-scan.c"
			}
#line 558 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp11_ = end_offset;
#line 558 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp12_ = data[_tmp11_];
#line 558 "/home/bob/git/simple-scan/src/simple-scan.vala"
			c = _tmp12_;
#line 559 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp13_ = line;
#line 559 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp14_ = c;
#line 559 "/home/bob/git/simple-scan/src/simple-scan.vala"
			g_string_append_c (_tmp13_, (gchar) _tmp14_);
#line 560 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp15_ = end_offset;
#line 560 "/home/bob/git/simple-scan/src/simple-scan.vala"
			end_offset = _tmp15_ + 1;
#line 561 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp16_ = c;
#line 561 "/home/bob/git/simple-scan/src/simple-scan.vala"
			if (_tmp16_ == ((guint8) '\n')) {
#line 562 "/home/bob/git/simple-scan/src/simple-scan.vala"
				break;
#line 3435 "simple-scan.c"
			}
		}
#line 565 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp17_ = line;
#line 565 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp18_ = _tmp17_->str;
#line 565 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (g_strcmp0 (_tmp18_, "startxref\n") == 0) {
#line 3444 "simple-scan.c"
			gint _tmp19_;
#line 566 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp19_ = line_number;
#line 566 "/home/bob/git/simple-scan/src/simple-scan.vala"
			startxref_line = _tmp19_;
#line 3450 "simple-scan.c"
		}
#line 568 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp20_ = line;
#line 568 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp21_ = _tmp20_->str;
#line 568 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (g_strcmp0 (_tmp21_, "xref\n") == 0) {
#line 3458 "simple-scan.c"
			gint _tmp22_;
#line 569 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp22_ = line_number;
#line 569 "/home/bob/git/simple-scan/src/simple-scan.vala"
			xref_line = _tmp22_;
#line 3464 "simple-scan.c"
		}
#line 572 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp24_ = line_number;
#line 572 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (_tmp24_ < 2) {
#line 3470 "simple-scan.c"
			GString* _tmp25_;
			const gchar* _tmp26_;
#line 572 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp25_ = line;
#line 572 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp26_ = _tmp25_->str;
#line 572 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp23_ = g_str_has_prefix (_tmp26_, "%%");
#line 3479 "simple-scan.c"
		} else {
#line 572 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp23_ = FALSE;
#line 3483 "simple-scan.c"
		}
#line 572 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (_tmp23_) {
#line 3487 "simple-scan.c"
			gint _tmp27_;
			FILE* _tmp28_;
			GString* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
#line 574 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp27_ = xref_offset;
#line 574 "/home/bob/git/simple-scan/src/simple-scan.vala"
			xref_offset = _tmp27_ - 1;
#line 575 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp28_ = fixed_file;
#line 575 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp29_ = line;
#line 575 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp30_ = _tmp29_->str;
#line 575 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp31_ = string_substring (_tmp30_, (glong) 1, (glong) -1);
#line 575 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp32_ = _tmp31_;
#line 575 "/home/bob/git/simple-scan/src/simple-scan.vala"
			fprintf (_tmp28_, "%s", _tmp32_);
#line 575 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_free0 (_tmp32_);
#line 3512 "simple-scan.c"
		} else {
			gboolean _tmp33_ = FALSE;
			gint _tmp34_;
			gint _tmp35_;
#line 579 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp34_ = line_number;
#line 579 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp35_ = xref_line;
#line 579 "/home/bob/git/simple-scan/src/simple-scan.vala"
			if (_tmp34_ == (_tmp35_ + 1)) {
#line 3523 "simple-scan.c"
				GString* _tmp36_;
				const gchar* _tmp37_;
#line 579 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp36_ = line;
#line 579 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp37_ = _tmp36_->str;
#line 579 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp33_ = g_str_has_prefix (_tmp37_, "1 ");
#line 3532 "simple-scan.c"
			} else {
#line 579 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp33_ = FALSE;
#line 3536 "simple-scan.c"
			}
#line 579 "/home/bob/git/simple-scan/src/simple-scan.vala"
			if (_tmp33_) {
#line 3540 "simple-scan.c"
				GString* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				FILE* _tmp42_;
				gint _tmp43_;
				FILE* _tmp44_;
#line 581 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp38_ = line;
#line 581 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp39_ = _tmp38_->str;
#line 581 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp40_ = string_substring (_tmp39_, (glong) 2, (glong) -1);
#line 581 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp41_ = _tmp40_;
#line 581 "/home/bob/git/simple-scan/src/simple-scan.vala"
				fixed_size = atoi (_tmp41_) + 1;
#line 581 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_g_free0 (_tmp41_);
#line 582 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp42_ = fixed_file;
#line 582 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp43_ = fixed_size;
#line 582 "/home/bob/git/simple-scan/src/simple-scan.vala"
				fprintf (_tmp42_, "0 %d\n", _tmp43_);
#line 583 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp44_ = fixed_file;
#line 583 "/home/bob/git/simple-scan/src/simple-scan.vala"
				fprintf (_tmp44_, "0000000000 65535 f \n");
#line 3570 "simple-scan.c"
			} else {
				gboolean _tmp45_ = FALSE;
				gint _tmp46_;
				gint _tmp47_;
#line 587 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp46_ = line_number;
#line 587 "/home/bob/git/simple-scan/src/simple-scan.vala"
				_tmp47_ = xref_line;
#line 587 "/home/bob/git/simple-scan/src/simple-scan.vala"
				if (_tmp46_ > _tmp47_) {
#line 3581 "simple-scan.c"
					GString* _tmp48_;
					const gchar* _tmp49_;
#line 587 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp48_ = line;
#line 587 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp49_ = _tmp48_->str;
#line 587 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp45_ = g_str_has_suffix (_tmp49_, " 0000 n\n");
#line 3590 "simple-scan.c"
				} else {
#line 587 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp45_ = FALSE;
#line 3594 "simple-scan.c"
				}
#line 587 "/home/bob/git/simple-scan/src/simple-scan.vala"
				if (_tmp45_) {
#line 3598 "simple-scan.c"
					FILE* _tmp50_;
					GString* _tmp51_;
					const gchar* _tmp52_;
					gint _tmp53_;
#line 588 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp50_ = fixed_file;
#line 588 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp51_ = line;
#line 588 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp52_ = _tmp51_->str;
#line 588 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp53_ = xref_offset;
#line 588 "/home/bob/git/simple-scan/src/simple-scan.vala"
					fprintf (_tmp50_, "%010d 00000 n \n", atoi (_tmp52_) + _tmp53_);
#line 3613 "simple-scan.c"
				} else {
					gboolean _tmp54_ = FALSE;
					gint _tmp55_;
#line 591 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp55_ = startxref_line;
#line 591 "/home/bob/git/simple-scan/src/simple-scan.vala"
					if (_tmp55_ > 0) {
#line 3621 "simple-scan.c"
						gint _tmp56_;
						gint _tmp57_;
#line 591 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp56_ = line_number;
#line 591 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp57_ = startxref_line;
#line 591 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp54_ = _tmp56_ == (_tmp57_ + 1);
#line 3630 "simple-scan.c"
					} else {
#line 591 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp54_ = FALSE;
#line 3634 "simple-scan.c"
					}
#line 591 "/home/bob/git/simple-scan/src/simple-scan.vala"
					if (_tmp54_) {
#line 3638 "simple-scan.c"
						FILE* _tmp58_;
						GString* _tmp59_;
						const gchar* _tmp60_;
						gint _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
#line 592 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp58_ = fixed_file;
#line 592 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp59_ = line;
#line 592 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp60_ = _tmp59_->str;
#line 592 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp61_ = xref_offset;
#line 592 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp62_ = g_strdup_printf ("%d\n", atoi (_tmp60_) + _tmp61_);
#line 592 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp63_ = _tmp62_;
#line 592 "/home/bob/git/simple-scan/src/simple-scan.vala"
						fprintf (_tmp58_, "%s", _tmp63_);
#line 592 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_g_free0 (_tmp63_);
#line 3661 "simple-scan.c"
					} else {
						gboolean _tmp64_ = FALSE;
						gint _tmp65_;
#line 594 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp65_ = fixed_size;
#line 594 "/home/bob/git/simple-scan/src/simple-scan.vala"
						if (_tmp65_ > 0) {
#line 3669 "simple-scan.c"
							GString* _tmp66_;
							const gchar* _tmp67_;
#line 594 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp66_ = line;
#line 594 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp67_ = _tmp66_->str;
#line 594 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp64_ = g_str_has_prefix (_tmp67_, "/Size ");
#line 3678 "simple-scan.c"
						} else {
#line 594 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp64_ = FALSE;
#line 3682 "simple-scan.c"
						}
#line 594 "/home/bob/git/simple-scan/src/simple-scan.vala"
						if (_tmp64_) {
#line 3686 "simple-scan.c"
							FILE* _tmp68_;
							gint _tmp69_;
							gchar* _tmp70_;
							gchar* _tmp71_;
#line 595 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp68_ = fixed_file;
#line 595 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp69_ = fixed_size;
#line 595 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp70_ = g_strdup_printf ("/Size %d\n", _tmp69_);
#line 595 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp71_ = _tmp70_;
#line 595 "/home/bob/git/simple-scan/src/simple-scan.vala"
							fprintf (_tmp68_, "%s", _tmp71_);
#line 595 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_g_free0 (_tmp71_);
#line 3703 "simple-scan.c"
						} else {
							gboolean _tmp72_ = FALSE;
							gint _tmp73_;
							gint _tmp74_;
#line 598 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp73_ = line_number;
#line 598 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp74_ = startxref_line;
#line 598 "/home/bob/git/simple-scan/src/simple-scan.vala"
							if (_tmp73_ == (_tmp74_ + 2)) {
#line 3714 "simple-scan.c"
								GString* _tmp75_;
								const gchar* _tmp76_;
#line 598 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp75_ = line;
#line 598 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp76_ = _tmp75_->str;
#line 598 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp72_ = g_str_has_prefix (_tmp76_, "%%%%");
#line 3723 "simple-scan.c"
							} else {
#line 598 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp72_ = FALSE;
#line 3727 "simple-scan.c"
							}
#line 598 "/home/bob/git/simple-scan/src/simple-scan.vala"
							if (_tmp72_) {
#line 3731 "simple-scan.c"
								FILE* _tmp77_;
								GString* _tmp78_;
								const gchar* _tmp79_;
								gchar* _tmp80_;
								gchar* _tmp81_;
#line 599 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp77_ = fixed_file;
#line 599 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp78_ = line;
#line 599 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp79_ = _tmp78_->str;
#line 599 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp80_ = string_substring (_tmp79_, (glong) 2, (glong) -1);
#line 599 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_tmp81_ = _tmp80_;
#line 599 "/home/bob/git/simple-scan/src/simple-scan.vala"
								fprintf (_tmp77_, "%s", _tmp81_);
#line 599 "/home/bob/git/simple-scan/src/simple-scan.vala"
								_g_free0 (_tmp81_);
#line 3751 "simple-scan.c"
							} else {
								{
									gint i = 0;
									gint _tmp82_;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
									_tmp82_ = offset;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
									i = _tmp82_;
#line 3760 "simple-scan.c"
									{
										gboolean _tmp83_ = FALSE;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
										_tmp83_ = TRUE;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
										while (TRUE) {
#line 3767 "simple-scan.c"
											gint _tmp85_;
											gint _tmp86_;
											FILE* _tmp87_;
											gint _tmp88_;
											guint8 _tmp89_;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
											if (!_tmp83_) {
#line 3775 "simple-scan.c"
												gint _tmp84_;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
												_tmp84_ = i;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
												i = _tmp84_ + 1;
#line 3781 "simple-scan.c"
											}
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
											_tmp83_ = FALSE;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
											_tmp85_ = i;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
											_tmp86_ = end_offset;
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
											if (!(_tmp85_ < _tmp86_)) {
#line 602 "/home/bob/git/simple-scan/src/simple-scan.vala"
												break;
#line 3793 "simple-scan.c"
											}
#line 603 "/home/bob/git/simple-scan/src/simple-scan.vala"
											_tmp87_ = fixed_file;
#line 603 "/home/bob/git/simple-scan/src/simple-scan.vala"
											_tmp88_ = i;
#line 603 "/home/bob/git/simple-scan/src/simple-scan.vala"
											_tmp89_ = data[_tmp88_];
#line 603 "/home/bob/git/simple-scan/src/simple-scan.vala"
											fputc ((gchar) _tmp89_, _tmp87_);
#line 3803 "simple-scan.c"
										}
									}
								}
							}
						}
					}
				}
			}
		}
#line 605 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp90_ = line_number;
#line 605 "/home/bob/git/simple-scan/src/simple-scan.vala"
		line_number = _tmp90_ + 1;
#line 606 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp91_ = end_offset;
#line 606 "/home/bob/git/simple-scan/src/simple-scan.vala"
		offset = _tmp91_;
#line 3821 "simple-scan.c"
	}
#line 609 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp92_ = g_strconcat (filename, "~", NULL);
#line 609 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp93_ = _tmp92_;
#line 609 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp94_ = g_rename (filename, _tmp93_) >= 0;
#line 609 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (_tmp93_);
#line 609 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp94_) {
#line 3833 "simple-scan.c"
		gchar* _tmp95_;
		gchar* _tmp96_;
#line 610 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp95_ = g_strconcat (filename, ".fixed", NULL);
#line 610 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp96_ = _tmp95_;
#line 610 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_rename (_tmp96_, filename);
#line 610 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (_tmp96_);
#line 3844 "simple-scan.c"
	}
#line 538 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_string_free0 (line);
#line 538 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_fclose0 (fixed_file);
#line 538 "/home/bob/git/simple-scan/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 3852 "simple-scan.c"
}


static void
_simple_scan_log_cb_glog_func (const gchar* log_domain,
                               GLogLevelFlags log_levels,
                               const gchar* message,
                               gpointer self)
{
#line 672 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_log_cb (log_domain, log_levels, message);
#line 3864 "simple-scan.c"
}


gint
simple_scan_main (gchar** args,
                  int args_length1)
{
	gint result = 0;
	GOptionContext* c = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_;
	gboolean _tmp12_;
	const gchar* _tmp14_;
	ScanDevice* device = NULL;
	GTimer* _tmp32_;
	gchar* path = NULL;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	FILE* _tmp39_;
	SimpleScan* app = NULL;
	ScanDevice* _tmp40_;
	SimpleScan* _tmp41_;
	SimpleScan* _tmp42_;
	GError * _inner_error_ = NULL;
#line 615 "/home/bob/git/simple-scan/src/simple-scan.vala"
	setlocale (LC_ALL, "");
#line 616 "/home/bob/git/simple-scan/src/simple-scan.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
#line 617 "/home/bob/git/simple-scan/src/simple-scan.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 618 "/home/bob/git/simple-scan/src/simple-scan.vala"
	textdomain (GETTEXT_PACKAGE);
#line 620 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp0_ = g_option_context_new (_ ("[DEVICE...] - Scanning utility"));
#line 620 "/home/bob/git/simple-scan/src/simple-scan.vala"
	c = _tmp0_;
#line 622 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp1_ = c;
#line 622 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_option_context_add_main_entries (_tmp1_, SIMPLE_SCAN_options, GETTEXT_PACKAGE);
#line 623 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp2_ = c;
#line 623 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp3_ = gtk_get_option_group (TRUE);
#line 623 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_option_context_add_group (_tmp2_, _tmp3_);
#line 3917 "simple-scan.c"
	{
		GOptionContext* _tmp4_;
#line 626 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp4_ = c;
#line 626 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
#line 626 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3926 "simple-scan.c"
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		FILE* _tmp10_;
#line 624 "/home/bob/git/simple-scan/src/simple-scan.vala"
		e = _inner_error_;
#line 624 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 630 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp5_ = stderr;
#line 630 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp6_ = e;
#line 630 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp7_ = _tmp6_->message;
#line 630 "/home/bob/git/simple-scan/src/simple-scan.vala"
		fprintf (_tmp5_, "%s\n", _tmp7_);
#line 631 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp8_ = stderr;
#line 631 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp9_ = args[0];
#line 631 "/home/bob/git/simple-scan/src/simple-scan.vala"
		fprintf (_tmp8_, _ ("Run '%s --help' to see a full list of available command line options."), _tmp9_);
#line 633 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp10_ = stderr;
#line 633 "/home/bob/git/simple-scan/src/simple-scan.vala"
		fprintf (_tmp10_, "\n");
#line 634 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = EXIT_FAILURE;
#line 634 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_error_free0 (e);
#line 634 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 634 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 3970 "simple-scan.c"
	}
	__finally13:
#line 624 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3975 "simple-scan.c"
		gint _tmp11_ = -1;
#line 624 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 624 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 624 "/home/bob/git/simple-scan/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 624 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return _tmp11_;
#line 3985 "simple-scan.c"
	}
#line 636 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp12_ = simple_scan_show_version;
#line 636 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp12_) {
#line 3991 "simple-scan.c"
		FILE* _tmp13_;
#line 639 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp13_ = stderr;
#line 639 "/home/bob/git/simple-scan/src/simple-scan.vala"
		fprintf (_tmp13_, "simple-scan %s\n", VERSION);
#line 640 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 640 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 640 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 4003 "simple-scan.c"
	}
#line 642 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp14_ = simple_scan_fix_pdf_filename;
#line 642 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (_tmp14_ != NULL) {
#line 4009 "simple-scan.c"
		{
			const gchar* _tmp15_;
#line 646 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp15_ = simple_scan_fix_pdf_filename;
#line 646 "/home/bob/git/simple-scan/src/simple-scan.vala"
			simple_scan_fix_pdf (_tmp15_, &_inner_error_);
#line 646 "/home/bob/git/simple-scan/src/simple-scan.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4018 "simple-scan.c"
				goto __catch14_g_error;
			}
			{
				gint i = 0;
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
				i = 1;
#line 4025 "simple-scan.c"
				{
					gboolean _tmp16_ = FALSE;
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
					_tmp16_ = TRUE;
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
					while (TRUE) {
#line 4032 "simple-scan.c"
						gint _tmp18_;
						gint _tmp19_;
						const gchar* _tmp20_;
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
						if (!_tmp16_) {
#line 4038 "simple-scan.c"
							gint _tmp17_;
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
							_tmp17_ = i;
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
							i = _tmp17_ + 1;
#line 4044 "simple-scan.c"
						}
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp16_ = FALSE;
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp18_ = i;
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
						if (!(_tmp18_ < args_length1)) {
#line 647 "/home/bob/git/simple-scan/src/simple-scan.vala"
							break;
#line 4054 "simple-scan.c"
						}
#line 648 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp19_ = i;
#line 648 "/home/bob/git/simple-scan/src/simple-scan.vala"
						_tmp20_ = args[_tmp19_];
#line 648 "/home/bob/git/simple-scan/src/simple-scan.vala"
						simple_scan_fix_pdf (_tmp20_, &_inner_error_);
#line 648 "/home/bob/git/simple-scan/src/simple-scan.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4064 "simple-scan.c"
							goto __catch14_g_error;
						}
					}
				}
			}
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* e = NULL;
			FILE* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
#line 644 "/home/bob/git/simple-scan/src/simple-scan.vala"
			e = _inner_error_;
#line 644 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_inner_error_ = NULL;
#line 652 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp21_ = stderr;
#line 652 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp22_ = e;
#line 652 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_tmp23_ = _tmp22_->message;
#line 652 "/home/bob/git/simple-scan/src/simple-scan.vala"
			fprintf (_tmp21_, "Error fixing PDF file: %s", _tmp23_);
#line 653 "/home/bob/git/simple-scan/src/simple-scan.vala"
			result = EXIT_FAILURE;
#line 653 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_error_free0 (e);
#line 653 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 653 "/home/bob/git/simple-scan/src/simple-scan.vala"
			return result;
#line 4098 "simple-scan.c"
		}
		__finally14:
#line 644 "/home/bob/git/simple-scan/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4103 "simple-scan.c"
			gint _tmp24_ = -1;
#line 644 "/home/bob/git/simple-scan/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 644 "/home/bob/git/simple-scan/src/simple-scan.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 644 "/home/bob/git/simple-scan/src/simple-scan.vala"
			g_clear_error (&_inner_error_);
#line 644 "/home/bob/git/simple-scan/src/simple-scan.vala"
			return _tmp24_;
#line 4113 "simple-scan.c"
		}
#line 655 "/home/bob/git/simple-scan/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 655 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 655 "/home/bob/git/simple-scan/src/simple-scan.vala"
		return result;
#line 4121 "simple-scan.c"
	}
#line 658 "/home/bob/git/simple-scan/src/simple-scan.vala"
	device = NULL;
#line 659 "/home/bob/git/simple-scan/src/simple-scan.vala"
	if (args_length1 > 1) {
#line 4127 "simple-scan.c"
		ScanDevice* _tmp25_;
		ScanDevice* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		ScanDevice* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
#line 661 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp25_ = scan_device_new ();
#line 661 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_scan_device_unref0 (device);
#line 661 "/home/bob/git/simple-scan/src/simple-scan.vala"
		device = _tmp25_;
#line 662 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp26_ = device;
#line 662 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp27_ = args[1];
#line 662 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp28_ = g_strdup (_tmp27_);
#line 662 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (_tmp26_->name);
#line 662 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp26_->name = _tmp28_;
#line 663 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp29_ = device;
#line 663 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp30_ = args[1];
#line 663 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp31_ = g_strdup (_tmp30_);
#line 663 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_g_free0 (_tmp29_->label);
#line 663 "/home/bob/git/simple-scan/src/simple-scan.vala"
		_tmp29_->label = _tmp31_;
#line 4161 "simple-scan.c"
	}
#line 667 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp32_ = g_timer_new ();
#line 667 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_timer_destroy0 (simple_scan_log_timer);
#line 667 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_log_timer = _tmp32_;
#line 668 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp33_ = g_get_user_cache_dir ();
#line 668 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp34_ = g_build_filename (_tmp33_, "simple-scan", NULL, NULL);
#line 668 "/home/bob/git/simple-scan/src/simple-scan.vala"
	path = _tmp34_;
#line 669 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp35_ = path;
#line 669 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_mkdir_with_parents (_tmp35_, 0700);
#line 670 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp36_ = g_get_user_cache_dir ();
#line 670 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp37_ = g_build_filename (_tmp36_, "simple-scan", "simple-scan.log", NULL, NULL);
#line 670 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (path);
#line 670 "/home/bob/git/simple-scan/src/simple-scan.vala"
	path = _tmp37_;
#line 671 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp38_ = path;
#line 671 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp39_ = g_fopen (_tmp38_, "w");
#line 671 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_fclose0 (simple_scan_log_file);
#line 671 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_log_file = _tmp39_;
#line 672 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_log_set_default_handler (_simple_scan_log_cb_glog_func, NULL);
#line 674 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_debug ("simple-scan.vala:674: Starting Simple Scan %s, PID=%i", VERSION, (gint) getpid ());
#line 676 "/home/bob/git/simple-scan/src/simple-scan.vala"
	gtk_init (&args_length1, &args);
#line 678 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp40_ = device;
#line 678 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp41_ = simple_scan_new (_tmp40_);
#line 678 "/home/bob/git/simple-scan/src/simple-scan.vala"
	app = _tmp41_;
#line 679 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_tmp42_ = app;
#line 679 "/home/bob/git/simple-scan/src/simple-scan.vala"
	result = g_application_run ((GApplication*) _tmp42_, 0, NULL);
#line 679 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (app);
#line 679 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_free0 (path);
#line 679 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_scan_device_unref0 (device);
#line 679 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_option_context_free0 (c);
#line 679 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return result;
#line 4221 "simple-scan.c"
}


int
main (int argc,
      char ** argv)
{
#line 613 "/home/bob/git/simple-scan/src/simple-scan.vala"
	return simple_scan_main (argv, argc);
#line 4231 "simple-scan.c"
}


static void
simple_scan_class_init (SimpleScanClass * klass)
{
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	simple_scan_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	g_type_class_add_private (klass, sizeof (SimpleScanPrivate));
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) simple_scan_real_startup;
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) simple_scan_real_activate;
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) simple_scan_real_shutdown;
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	G_OBJECT_CLASS (klass)->finalize = simple_scan_finalize;
#line 4250 "simple-scan.c"
}


static void
simple_scan_instance_init (SimpleScan * self)
{
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv = SIMPLE_SCAN_GET_PRIVATE (self);
#line 32 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->default_device = NULL;
#line 33 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self->priv->have_devices = FALSE;
#line 4263 "simple-scan.c"
}


static void
simple_scan_finalize (GObject * obj)
{
	SimpleScan * self;
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SCAN, SimpleScan);
#line 32 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 34 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (self->priv->usb_context);
#line 35 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_g_object_unref0 (self->priv->ui);
#line 36 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 37 "/home/bob/git/simple-scan/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 12 "/home/bob/git/simple-scan/src/simple-scan.vala"
	G_OBJECT_CLASS (simple_scan_parent_class)->finalize (obj);
#line 4285 "simple-scan.c"
}


GType
simple_scan_get_type (void)
{
	static volatile gsize simple_scan_type_id__volatile = 0;
	if (g_once_init_enter (&simple_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, NULL };
		GType simple_scan_type_id;
		simple_scan_type_id = g_type_register_static (gtk_application_get_type (), "SimpleScan", &g_define_type_info, 0);
		g_once_init_leave (&simple_scan_type_id__volatile, simple_scan_type_id);
	}
	return simple_scan_type_id__volatile;
}



