/* scanner.c generated by valac 0.40.9, the Vala compiler
 * generated from scanner.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* TODO: Could indicate the start of the next page immediately after the last page is received (i.e. before the sane_cancel()) */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include "sane/saneopts.h"
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecScanDevice ParamSpecScanDevice;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ParamSpecScanPageInfo ParamSpecScanPageInfo;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
typedef struct _ParamSpecScanLine ParamSpecScanLine;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef struct _ParamSpecScanOptions ParamSpecScanOptions;

#define TYPE_SCAN_JOB (scan_job_get_type ())
#define SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_JOB, ScanJob))
#define SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_JOB, ScanJobClass))
#define IS_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_JOB))
#define IS_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_JOB))
#define SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_JOB, ScanJobClass))

typedef struct _ScanJob ScanJob;
typedef struct _ScanJobClass ScanJobClass;
typedef struct _ScanJobPrivate ScanJobPrivate;
typedef struct _ParamSpecScanJob ParamSpecScanJob;

#define TYPE_REQUEST (request_get_type ())
#define REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST, Request))
#define REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST, RequestClass))
#define IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST))
#define IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST))
#define REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST, RequestClass))

typedef struct _Request Request;
typedef struct _RequestClass RequestClass;
typedef struct _RequestPrivate RequestPrivate;
typedef struct _ParamSpecRequest ParamSpecRequest;

#define TYPE_REQUEST_REDETECT (request_redetect_get_type ())
#define REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_REDETECT, RequestRedetect))
#define REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_REDETECT, RequestRedetectClass))
#define IS_REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_REDETECT))
#define IS_REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_REDETECT))
#define REQUEST_REDETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_REDETECT, RequestRedetectClass))

typedef struct _RequestRedetect RequestRedetect;
typedef struct _RequestRedetectClass RequestRedetectClass;
typedef struct _RequestRedetectPrivate RequestRedetectPrivate;

#define TYPE_REQUEST_CANCEL (request_cancel_get_type ())
#define REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_CANCEL, RequestCancel))
#define REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_CANCEL, RequestCancelClass))
#define IS_REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_CANCEL))
#define IS_REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_CANCEL))
#define REQUEST_CANCEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_CANCEL, RequestCancelClass))

typedef struct _RequestCancel RequestCancel;
typedef struct _RequestCancelClass RequestCancelClass;
typedef struct _RequestCancelPrivate RequestCancelPrivate;

#define TYPE_REQUEST_START_SCAN (request_start_scan_get_type ())
#define REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_START_SCAN, RequestStartScan))
#define REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_START_SCAN, RequestStartScanClass))
#define IS_REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_START_SCAN))
#define IS_REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_START_SCAN))
#define REQUEST_START_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_START_SCAN, RequestStartScanClass))

typedef struct _RequestStartScan RequestStartScan;
typedef struct _RequestStartScanClass RequestStartScanClass;
typedef struct _RequestStartScanPrivate RequestStartScanPrivate;
#define _scan_job_unref0(var) ((var == NULL) ? NULL : (var = (scan_job_unref (var), NULL)))

#define TYPE_REQUEST_QUIT (request_quit_get_type ())
#define REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_QUIT, RequestQuit))
#define REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_QUIT, RequestQuitClass))
#define IS_REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_QUIT))
#define IS_REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_QUIT))
#define REQUEST_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_QUIT, RequestQuitClass))

typedef struct _RequestQuit RequestQuit;
typedef struct _RequestQuitClass RequestQuitClass;
typedef struct _RequestQuitPrivate RequestQuitPrivate;

#define TYPE_CREDENTIALS (credentials_get_type ())
#define CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREDENTIALS, Credentials))
#define CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREDENTIALS, CredentialsClass))
#define IS_CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREDENTIALS))
#define IS_CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREDENTIALS))
#define CREDENTIALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREDENTIALS, CredentialsClass))

typedef struct _Credentials Credentials;
typedef struct _CredentialsClass CredentialsClass;
typedef struct _CredentialsPrivate CredentialsPrivate;
typedef struct _ParamSpecCredentials ParamSpecCredentials;

#define TYPE_SCAN_STATE (scan_state_get_type ())

#define TYPE_NOTIFY (notify_get_type ())
#define NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY, Notify))
#define NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY, NotifyClass))
#define IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY))
#define IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY))
#define NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY, NotifyClass))

typedef struct _Notify Notify;
typedef struct _NotifyClass NotifyClass;
typedef struct _NotifyPrivate NotifyPrivate;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;
typedef struct _ParamSpecNotify ParamSpecNotify;

#define TYPE_NOTIFY_SCANNING_CHANGED (notify_scanning_changed_get_type ())
#define NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChanged))
#define NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))
#define IS_NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCANNING_CHANGED))
#define IS_NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCANNING_CHANGED))
#define NOTIFY_SCANNING_CHANGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))

typedef struct _NotifyScanningChanged NotifyScanningChanged;
typedef struct _NotifyScanningChangedClass NotifyScanningChangedClass;
typedef struct _NotifyScanningChangedPrivate NotifyScanningChangedPrivate;

#define TYPE_NOTIFY_UPDATE_DEVICES (notify_update_devices_get_type ())
#define NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices))
#define NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))
#define IS_NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_UPDATE_DEVICES))
#define IS_NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_UPDATE_DEVICES))
#define NOTIFY_UPDATE_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))

typedef struct _NotifyUpdateDevices NotifyUpdateDevices;
typedef struct _NotifyUpdateDevicesClass NotifyUpdateDevicesClass;
typedef struct _NotifyUpdateDevicesPrivate NotifyUpdateDevicesPrivate;

#define TYPE_NOTIFY_REQUEST_AUTHORIZATION (notify_request_authorization_get_type ())
#define NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization))
#define NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))
#define IS_NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define IS_NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define NOTIFY_REQUEST_AUTHORIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))

typedef struct _NotifyRequestAuthorization NotifyRequestAuthorization;
typedef struct _NotifyRequestAuthorizationClass NotifyRequestAuthorizationClass;
typedef struct _NotifyRequestAuthorizationPrivate NotifyRequestAuthorizationPrivate;

#define TYPE_NOTIFY_SCAN_FAILED (notify_scan_failed_get_type ())
#define NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed))
#define NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))
#define IS_NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCAN_FAILED))
#define IS_NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCAN_FAILED))
#define NOTIFY_SCAN_FAILED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))

typedef struct _NotifyScanFailed NotifyScanFailed;
typedef struct _NotifyScanFailedClass NotifyScanFailedClass;
typedef struct _NotifyScanFailedPrivate NotifyScanFailedPrivate;

#define TYPE_NOTIFY_DOCUMENT_DONE (notify_document_done_get_type ())
#define NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDone))
#define NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))
#define IS_NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_DOCUMENT_DONE))
#define IS_NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_DOCUMENT_DONE))
#define NOTIFY_DOCUMENT_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))

typedef struct _NotifyDocumentDone NotifyDocumentDone;
typedef struct _NotifyDocumentDoneClass NotifyDocumentDoneClass;
typedef struct _NotifyDocumentDonePrivate NotifyDocumentDonePrivate;

#define TYPE_NOTIFY_EXPECT_PAGE (notify_expect_page_get_type ())
#define NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPage))
#define NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))
#define IS_NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_EXPECT_PAGE))
#define IS_NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_EXPECT_PAGE))
#define NOTIFY_EXPECT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))

typedef struct _NotifyExpectPage NotifyExpectPage;
typedef struct _NotifyExpectPageClass NotifyExpectPageClass;
typedef struct _NotifyExpectPagePrivate NotifyExpectPagePrivate;

#define TYPE_NOTIFY_GOT_PAGE_INFO (notify_got_page_info_get_type ())
#define NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo))
#define NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))
#define IS_NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_PAGE_INFO))
#define IS_NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_PAGE_INFO))
#define NOTIFY_GOT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))

typedef struct _NotifyGotPageInfo NotifyGotPageInfo;
typedef struct _NotifyGotPageInfoClass NotifyGotPageInfoClass;
typedef struct _NotifyGotPageInfoPrivate NotifyGotPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))
typedef struct _ScannerPrivate ScannerPrivate;

#define TYPE_NOTIFY_PAGE_DONE (notify_page_done_get_type ())
#define NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDone))
#define NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))
#define IS_NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_PAGE_DONE))
#define IS_NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_PAGE_DONE))
#define NOTIFY_PAGE_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))

typedef struct _NotifyPageDone NotifyPageDone;
typedef struct _NotifyPageDoneClass NotifyPageDoneClass;
typedef struct _NotifyPageDonePrivate NotifyPageDonePrivate;

#define TYPE_NOTIFY_GOT_LINE (notify_got_line_get_type ())
#define NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLine))
#define NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))
#define IS_NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_LINE))
#define IS_NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_LINE))
#define NOTIFY_GOT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))

typedef struct _NotifyGotLine NotifyGotLine;
typedef struct _NotifyGotLineClass NotifyGotLineClass;
typedef struct _NotifyGotLinePrivate NotifyGotLinePrivate;
#define _scan_line_unref0(var) ((var == NULL) ? NULL : (var = (scan_line_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _notify_unref0(var) ((var == NULL) ? NULL : (var = (notify_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _credentials_unref0(var) ((var == NULL) ? NULL : (var = (credentials_unref (var), NULL)))
#define _request_unref0(var) ((var == NULL) ? NULL : (var = (request_unref (var), NULL)))
typedef struct _ParamSpecScanner ParamSpecScanner;
enum  {
	SCANNER_UPDATE_DEVICES_SIGNAL,
	SCANNER_REQUEST_AUTHORIZATION_SIGNAL,
	SCANNER_EXPECT_PAGE_SIGNAL,
	SCANNER_GOT_PAGE_INFO_SIGNAL,
	SCANNER_GOT_LINE_SIGNAL,
	SCANNER_SCAN_FAILED_SIGNAL,
	SCANNER_PAGE_DONE_SIGNAL,
	SCANNER_DOCUMENT_DONE_SIGNAL,
	SCANNER_SCANNING_CHANGED_SIGNAL,
	SCANNER_NUM_SIGNALS
};
static guint scanner_signals[SCANNER_NUM_SIGNALS] = {0};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

struct _ParamSpecScanDevice {
	GParamSpec parent_instance;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecScanPageInfo {
	GParamSpec parent_instance;
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecScanLine {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecScanOptions {
	GParamSpec parent_instance;
};

struct _ScanJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanJobPrivate * priv;
	gint id;
	gchar* device;
	gdouble dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint page_width;
	gint page_height;
	gint brightness;
	gint contrast;
};

struct _ScanJobClass {
	GTypeClass parent_class;
	void (*finalize) (ScanJob *self);
};

struct _ParamSpecScanJob {
	GParamSpec parent_instance;
};

struct _Request {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RequestPrivate * priv;
};

struct _RequestClass {
	GTypeClass parent_class;
	void (*finalize) (Request *self);
};

struct _ParamSpecRequest {
	GParamSpec parent_instance;
};

struct _RequestRedetect {
	Request parent_instance;
	RequestRedetectPrivate * priv;
};

struct _RequestRedetectClass {
	RequestClass parent_class;
};

struct _RequestCancel {
	Request parent_instance;
	RequestCancelPrivate * priv;
};

struct _RequestCancelClass {
	RequestClass parent_class;
};

struct _RequestStartScan {
	Request parent_instance;
	RequestStartScanPrivate * priv;
	ScanJob* job;
};

struct _RequestStartScanClass {
	RequestClass parent_class;
};

struct _RequestQuit {
	Request parent_instance;
	RequestQuitPrivate * priv;
};

struct _RequestQuitClass {
	RequestClass parent_class;
};

struct _Credentials {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CredentialsPrivate * priv;
	gchar* username;
	gchar* password;
};

struct _CredentialsClass {
	GTypeClass parent_class;
	void (*finalize) (Credentials *self);
};

struct _ParamSpecCredentials {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_STATE_IDLE = 0,
	SCAN_STATE_REDETECT,
	SCAN_STATE_OPEN,
	SCAN_STATE_GET_OPTION,
	SCAN_STATE_START,
	SCAN_STATE_GET_PARAMETERS,
	SCAN_STATE_READ
} ScanState;

struct _Notify {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotifyPrivate * priv;
};

struct _NotifyClass {
	GTypeClass parent_class;
	void (*finalize) (Notify *self);
	void (*run) (Notify* self, Scanner* scanner);
};

struct _ParamSpecNotify {
	GParamSpec parent_instance;
};

struct _NotifyScanningChanged {
	Notify parent_instance;
	NotifyScanningChangedPrivate * priv;
};

struct _NotifyScanningChangedClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevices {
	Notify parent_instance;
	NotifyUpdateDevicesPrivate * priv;
};

struct _NotifyUpdateDevicesClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevicesPrivate {
	GList* devices;
};

struct _NotifyRequestAuthorization {
	Notify parent_instance;
	NotifyRequestAuthorizationPrivate * priv;
};

struct _NotifyRequestAuthorizationClass {
	NotifyClass parent_class;
};

struct _NotifyRequestAuthorizationPrivate {
	gchar* resource;
};

struct _NotifyScanFailed {
	Notify parent_instance;
	NotifyScanFailedPrivate * priv;
};

struct _NotifyScanFailedClass {
	NotifyClass parent_class;
};

struct _NotifyScanFailedPrivate {
	gint error_code;
	gchar* error_string;
};

struct _NotifyDocumentDone {
	Notify parent_instance;
	NotifyDocumentDonePrivate * priv;
};

struct _NotifyDocumentDoneClass {
	NotifyClass parent_class;
};

struct _NotifyExpectPage {
	Notify parent_instance;
	NotifyExpectPagePrivate * priv;
};

struct _NotifyExpectPageClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfo {
	Notify parent_instance;
	NotifyGotPageInfoPrivate * priv;
};

struct _NotifyGotPageInfoClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfoPrivate {
	gint job_id;
	ScanPageInfo* info;
};

struct _Scanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScannerPrivate * priv;
	gint first_job_id;
	gint job_id;
};

struct _ScannerClass {
	GTypeClass parent_class;
	void (*finalize) (Scanner *self);
};

struct _NotifyPageDone {
	Notify parent_instance;
	NotifyPageDonePrivate * priv;
};

struct _NotifyPageDoneClass {
	NotifyClass parent_class;
};

struct _NotifyPageDonePrivate {
	gint job_id;
};

struct _NotifyGotLine {
	Notify parent_instance;
	NotifyGotLinePrivate * priv;
};

struct _NotifyGotLineClass {
	NotifyClass parent_class;
};

struct _NotifyGotLinePrivate {
	gint job_id;
	ScanLine* line;
};

struct _ScannerPrivate {
	GThread* thread;
	GAsyncQueue* request_queue;
	GAsyncQueue* notify_queue;
	GAsyncQueue* authorize_queue;
	gchar* default_device;
	ScanState state;
	gboolean need_redetect;
	GList* job_queue;
	SANE_Handle handle;
	gboolean have_handle;
	gchar* current_device;
	SANE_Parameters parameters;
	SANE_Int option_index;
	GHashTable* options;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint n_used;
	gint line_count;
	gint pass_number;
	gint page_number;
	gint notified_page;
	gboolean scanning;
};

struct _ParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer scan_device_parent_class = NULL;
static gpointer scan_page_info_parent_class = NULL;
static gpointer scan_line_parent_class = NULL;
static gpointer scan_options_parent_class = NULL;
static gpointer scan_job_parent_class = NULL;
static gpointer request_parent_class = NULL;
static gpointer request_redetect_parent_class = NULL;
static gpointer request_cancel_parent_class = NULL;
static gpointer request_start_scan_parent_class = NULL;
static gpointer request_quit_parent_class = NULL;
static gpointer credentials_parent_class = NULL;
static gpointer notify_parent_class = NULL;
static gpointer notify_scanning_changed_parent_class = NULL;
static gpointer notify_update_devices_parent_class = NULL;
static gpointer notify_request_authorization_parent_class = NULL;
static gpointer notify_scan_failed_parent_class = NULL;
static gpointer notify_document_done_parent_class = NULL;
static gpointer notify_expect_page_parent_class = NULL;
static gpointer notify_got_page_info_parent_class = NULL;
static gpointer notify_page_done_parent_class = NULL;
static gpointer notify_got_line_parent_class = NULL;
static gpointer scanner_parent_class = NULL;
static Scanner* scanner_scanner_object;
static Scanner* scanner_scanner_object = NULL;

gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_scan_device (GValue* value,
                            gpointer v_object);
void value_take_scan_device (GValue* value,
                             gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void scan_device_finalize (ScanDevice * obj);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_scan_page_info (GValue* value,
                               gpointer v_object);
void value_take_scan_page_info (GValue* value,
                                gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
static void scan_page_info_finalize (ScanPageInfo * obj);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_scan_line (GValue* value,
                          gpointer v_object);
void value_take_scan_line (GValue* value,
                           gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
ScanLine* scan_line_new (void);
ScanLine* scan_line_construct (GType object_type);
static void scan_line_finalize (ScanLine * obj);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
void value_set_scan_options (GValue* value,
                             gpointer v_object);
void value_take_scan_options (GValue* value,
                              gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
static void scan_options_finalize (ScanOptions * obj);
gpointer scan_job_ref (gpointer instance);
void scan_job_unref (gpointer instance);
GParamSpec* param_spec_scan_job (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_scan_job (GValue* value,
                         gpointer v_object);
void value_take_scan_job (GValue* value,
                          gpointer v_object);
gpointer value_get_scan_job (const GValue* value);
GType scan_job_get_type (void) G_GNUC_CONST;
ScanJob* scan_job_new (void);
ScanJob* scan_job_construct (GType object_type);
static void scan_job_finalize (ScanJob * obj);
gpointer request_ref (gpointer instance);
void request_unref (gpointer instance);
GParamSpec* param_spec_request (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_request (GValue* value,
                        gpointer v_object);
void value_take_request (GValue* value,
                         gpointer v_object);
gpointer value_get_request (const GValue* value);
GType request_get_type (void) G_GNUC_CONST;
Request* request_new (void);
Request* request_construct (GType object_type);
static void request_finalize (Request * obj);
GType request_redetect_get_type (void) G_GNUC_CONST;
RequestRedetect* request_redetect_new (void);
RequestRedetect* request_redetect_construct (GType object_type);
GType request_cancel_get_type (void) G_GNUC_CONST;
RequestCancel* request_cancel_new (void);
RequestCancel* request_cancel_construct (GType object_type);
GType request_start_scan_get_type (void) G_GNUC_CONST;
RequestStartScan* request_start_scan_new (void);
RequestStartScan* request_start_scan_construct (GType object_type);
static void request_start_scan_finalize (Request * obj);
GType request_quit_get_type (void) G_GNUC_CONST;
RequestQuit* request_quit_new (void);
RequestQuit* request_quit_construct (GType object_type);
gpointer credentials_ref (gpointer instance);
void credentials_unref (gpointer instance);
GParamSpec* param_spec_credentials (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_credentials (GValue* value,
                            gpointer v_object);
void value_take_credentials (GValue* value,
                             gpointer v_object);
gpointer value_get_credentials (const GValue* value);
GType credentials_get_type (void) G_GNUC_CONST;
Credentials* credentials_new (void);
Credentials* credentials_construct (GType object_type);
static void credentials_finalize (Credentials * obj);
GType scan_state_get_type (void) G_GNUC_CONST;
gpointer notify_ref (gpointer instance);
void notify_unref (gpointer instance);
GParamSpec* param_spec_notify (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
void value_set_notify (GValue* value,
                       gpointer v_object);
void value_take_notify (GValue* value,
                        gpointer v_object);
gpointer value_get_notify (const GValue* value);
GType notify_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
void value_set_scanner (GValue* value,
                        gpointer v_object);
void value_take_scanner (GValue* value,
                         gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
void notify_run (Notify* self,
                 Scanner* scanner);
static void notify_real_run (Notify* self,
                      Scanner* scanner);
Notify* notify_new (void);
Notify* notify_construct (GType object_type);
static void notify_finalize (Notify * obj);
GType notify_scanning_changed_get_type (void) G_GNUC_CONST;
static void notify_scanning_changed_real_run (Notify* base,
                                       Scanner* scanner);
NotifyScanningChanged* notify_scanning_changed_new (void);
NotifyScanningChanged* notify_scanning_changed_construct (GType object_type);
GType notify_update_devices_get_type (void) G_GNUC_CONST;
#define NOTIFY_UPDATE_DEVICES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesPrivate))
static void _scan_device_unref0_ (gpointer var);
static inline void _g_list_free__scan_device_unref0_ (GList* self);
NotifyUpdateDevices* notify_update_devices_new (GList* devices);
NotifyUpdateDevices* notify_update_devices_construct (GType object_type,
                                                      GList* devices);
static void notify_update_devices_real_run (Notify* base,
                                     Scanner* scanner);
static void notify_update_devices_finalize (Notify * obj);
GType notify_request_authorization_get_type (void) G_GNUC_CONST;
#define NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationPrivate))
NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource);
NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type,
                                                                    const gchar* resource);
static void notify_request_authorization_real_run (Notify* base,
                                            Scanner* scanner);
static void notify_request_authorization_finalize (Notify * obj);
GType notify_scan_failed_get_type (void) G_GNUC_CONST;
#define NOTIFY_SCAN_FAILED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedPrivate))
NotifyScanFailed* notify_scan_failed_new (gint error_code,
                                          const gchar* error_string);
NotifyScanFailed* notify_scan_failed_construct (GType object_type,
                                                gint error_code,
                                                const gchar* error_string);
static void notify_scan_failed_real_run (Notify* base,
                                  Scanner* scanner);
static void notify_scan_failed_finalize (Notify * obj);
GType notify_document_done_get_type (void) G_GNUC_CONST;
static void notify_document_done_real_run (Notify* base,
                                    Scanner* scanner);
NotifyDocumentDone* notify_document_done_new (void);
NotifyDocumentDone* notify_document_done_construct (GType object_type);
GType notify_expect_page_get_type (void) G_GNUC_CONST;
static void notify_expect_page_real_run (Notify* base,
                                  Scanner* scanner);
NotifyExpectPage* notify_expect_page_new (void);
NotifyExpectPage* notify_expect_page_construct (GType object_type);
GType notify_got_page_info_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_PAGE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoPrivate))
NotifyGotPageInfo* notify_got_page_info_new (gint job_id,
                                             ScanPageInfo* info);
NotifyGotPageInfo* notify_got_page_info_construct (GType object_type,
                                                   gint job_id,
                                                   ScanPageInfo* info);
static void notify_got_page_info_real_run (Notify* base,
                                    Scanner* scanner);
static void notify_got_page_info_finalize (Notify * obj);
GType notify_page_done_get_type (void) G_GNUC_CONST;
#define NOTIFY_PAGE_DONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_PAGE_DONE, NotifyPageDonePrivate))
NotifyPageDone* notify_page_done_new (gint job_id);
NotifyPageDone* notify_page_done_construct (GType object_type,
                                            gint job_id);
static void notify_page_done_real_run (Notify* base,
                                Scanner* scanner);
static void notify_page_done_finalize (Notify * obj);
GType notify_got_line_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_LINE, NotifyGotLinePrivate))
NotifyGotLine* notify_got_line_new (gint job_id,
                                    ScanLine* line);
NotifyGotLine* notify_got_line_construct (GType object_type,
                                          gint job_id,
                                          ScanLine* line);
static void notify_got_line_real_run (Notify* base,
                               Scanner* scanner);
static void notify_got_line_finalize (Notify * obj);
#define SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCANNER, ScannerPrivate))
static void _scan_job_unref0_ (gpointer var);
static inline void _g_list_free__scan_job_unref0_ (GList* self);
static Scanner* scanner_new (void);
static Scanner* scanner_construct (GType object_type);
static void _request_unref0_ (gpointer var);
static void _notify_unref0_ (gpointer var);
static void _credentials_unref0_ (gpointer var);
Scanner* scanner_get_instance (void);
static gboolean scanner_notify_idle_cb (Scanner* self);
static void scanner_notify (Scanner* self,
                     Notify* notification);
static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self);
static void scanner_set_scanning (Scanner* self,
                           gboolean is_scanning);
static gint scanner_get_device_weight (const gchar* device);
static gint scanner_compare_devices (ScanDevice* device1,
                              ScanDevice* device2);
static void scanner_do_redetect (Scanner* self);
static gint _scanner_compare_devices_gcompare_func (gconstpointer a,
                                             gconstpointer b);
static gint scanner_scale_int (Scanner* self,
                        gint source_min,
                        gint source_max,
                        SANE_Option_Descriptor* option,
                        gint value);
static gboolean scanner_set_default_option (Scanner* self,
                                     SANE_Handle handle,
                                     SANE_Option_Descriptor* option,
                                     SANE_Int option_index);
static void scanner_set_bool_option (Scanner* self,
                              SANE_Handle handle,
                              SANE_Option_Descriptor* option,
                              SANE_Int option_index,
                              gboolean value,
                              gboolean* _result_);
static void scanner_set_int_option (Scanner* self,
                             SANE_Handle handle,
                             SANE_Option_Descriptor* option,
                             SANE_Int option_index,
                             gint value,
                             gint* _result_);
static void scanner_set_fixed_option (Scanner* self,
                               SANE_Handle handle,
                               SANE_Option_Descriptor* option,
                               SANE_Int option_index,
                               gdouble value,
                               gdouble* _result_);
static void scanner_set_fixed_or_int_option (Scanner* self,
                                      SANE_Handle handle,
                                      SANE_Option_Descriptor* option,
                                      SANE_Int option_index,
                                      gdouble value,
                                      gdouble* _result_);
static void scanner_set_option_to_max (Scanner* self,
                                SANE_Handle handle,
                                SANE_Option_Descriptor* option,
                                SANE_Int option_index);
static gboolean scanner_set_string_option (Scanner* self,
                                    SANE_Handle handle,
                                    SANE_Option_Descriptor* option,
                                    SANE_Int option_index,
                                    const gchar* value,
                                    gchar* * _result_);
static gboolean scanner_set_constrained_string_option (Scanner* self,
                                                SANE_Handle handle,
                                                SANE_Option_Descriptor* option,
                                                SANE_Int option_index,
                                                gchar** values,
                                                int values_length1,
                                                gchar* * _result_);
static void scanner_log_option (Scanner* self,
                         SANE_Int index,
                         SANE_Option_Descriptor* option);
static void scanner_authorization_cb (const gchar* resource,
                               gchar* username,
                               int username_length1,
                               gchar* password,
                               int password_length1);
void scanner_authorize (Scanner* self,
                        const gchar* username,
                        const gchar* password);
static void scanner_close_device (Scanner* self);
static void scanner_fail_scan (Scanner* self,
                        gint error_code,
                        const gchar* error_string);
static gboolean scanner_handle_requests (Scanner* self);
static void scanner_do_open (Scanner* self);
static void _g_free0_ (gpointer var);
static void scanner_do_get_option (Scanner* self);
static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self,
                                                    SANE_Handle handle,
                                                    const gchar* name,
                                                    gint* index);
static gdouble scanner_convert_page_size (Scanner* self,
                                   SANE_Option_Descriptor* option,
                                   gdouble size,
                                   gdouble dpi);
static void scanner_do_complete_document (Scanner* self);
static void scanner_do_start (Scanner* self);
static void scanner_do_get_parameters (Scanner* self);
static void scanner_do_complete_page (Scanner* self);
static void scanner_do_read (Scanner* self);
static void* scanner_scan_thread (Scanner* self);
static void _scanner_authorization_cb_sane_authcallback (const gchar* resource,
                                                  gchar* username,
                                                  gchar* password);
void scanner_redetect (Scanner* self);
void scanner_start (Scanner* self);
static gpointer _scanner_scan_thread_gthread_func (gpointer self);
gboolean scanner_is_scanning (Scanner* self);
static gchar* scanner_get_scan_mode_string (Scanner* self,
                                     ScanMode mode);
static gchar* scanner_get_scan_type_string (Scanner* self,
                                     ScanType type);
void scanner_scan (Scanner* self,
                   const gchar* device,
                   ScanOptions* options);
void scanner_cancel (Scanner* self);
void scanner_free (Scanner* self);
static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void scanner_finalize (Scanner * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


ScanDevice*
scan_device_construct (GType object_type)
{
	ScanDevice* self = NULL;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (ScanDevice*) g_type_create_instance (object_type);
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 1097 "scanner.c"
}


ScanDevice*
scan_device_new (void)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	return scan_device_construct (TYPE_SCAN_DEVICE);
#line 1106 "scanner.c"
}


static void
value_scan_device_init (GValue* value)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1115 "scanner.c"
}


static void
value_scan_device_free_value (GValue* value)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_device_unref (value->data[0].v_pointer);
#line 1126 "scanner.c"
	}
}


static void
value_scan_device_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_device_ref (src_value->data[0].v_pointer);
#line 1139 "scanner.c"
	} else {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1143 "scanner.c"
	}
}


static gpointer
value_scan_device_peek_pointer (const GValue* value)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1153 "scanner.c"
}


static gchar*
value_scan_device_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1165 "scanner.c"
		ScanDevice * object;
		object = collect_values[0].v_pointer;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1172 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1176 "scanner.c"
		}
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = scan_device_ref (object);
#line 1180 "scanner.c"
	} else {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1184 "scanner.c"
	}
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 1188 "scanner.c"
}


static gchar*
value_scan_device_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	ScanDevice ** object_p;
	object_p = collect_values[0].v_pointer;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1204 "scanner.c"
	}
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 1210 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1214 "scanner.c"
	} else {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = scan_device_ref (value->data[0].v_pointer);
#line 1218 "scanner.c"
	}
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 1222 "scanner.c"
}


GParamSpec*
param_spec_scan_device (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecScanDevice* spec;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1242 "scanner.c"
}


gpointer
value_get_scan_device (const GValue* value)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1253 "scanner.c"
}


void
value_set_scan_device (GValue* value,
                       gpointer v_object)
{
	ScanDevice * old;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_device_ref (value->data[0].v_pointer);
#line 1276 "scanner.c"
	} else {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1280 "scanner.c"
	}
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_device_unref (old);
#line 1286 "scanner.c"
	}
}


void
value_take_scan_device (GValue* value,
                        gpointer v_object)
{
	ScanDevice * old;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1308 "scanner.c"
	} else {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1312 "scanner.c"
	}
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_device_unref (old);
#line 1318 "scanner.c"
	}
}


static void
scan_device_class_init (ScanDeviceClass * klass)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	scan_device_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	((ScanDeviceClass *) klass)->finalize = scan_device_finalize;
#line 1330 "scanner.c"
}


static void
scan_device_instance_init (ScanDevice * self)
{
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 1339 "scanner.c"
}


static void
scan_device_finalize (ScanDevice * obj)
{
	ScanDevice * self;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_DEVICE, ScanDevice);
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 16 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->name);
#line 17 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->label);
#line 1355 "scanner.c"
}


GType
scan_device_get_type (void)
{
	static volatile gsize scan_device_type_id__volatile = 0;
	if (g_once_init_enter (&scan_device_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_device_init, value_scan_device_free_value, value_scan_device_copy_value, value_scan_device_peek_pointer, "p", value_scan_device_collect_value, "p", value_scan_device_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDevice), 0, (GInstanceInitFunc) scan_device_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_device_type_id;
		scan_device_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanDevice", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_device_type_id__volatile, scan_device_type_id);
	}
	return scan_device_type_id__volatile;
}


gpointer
scan_device_ref (gpointer instance)
{
	ScanDevice * self;
	self = instance;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 1384 "scanner.c"
}


void
scan_device_unref (gpointer instance)
{
	ScanDevice * self;
	self = instance;
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		SCAN_DEVICE_GET_CLASS (self)->finalize (self);
#line 14 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1399 "scanner.c"
	}
}


ScanPageInfo*
scan_page_info_construct (GType object_type)
{
	ScanPageInfo* self = NULL;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (ScanPageInfo*) g_type_create_instance (object_type);
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 1412 "scanner.c"
}


ScanPageInfo*
scan_page_info_new (void)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	return scan_page_info_construct (TYPE_SCAN_PAGE_INFO);
#line 1421 "scanner.c"
}


static void
value_scan_page_info_init (GValue* value)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1430 "scanner.c"
}


static void
value_scan_page_info_free_value (GValue* value)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_page_info_unref (value->data[0].v_pointer);
#line 1441 "scanner.c"
	}
}


static void
value_scan_page_info_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_page_info_ref (src_value->data[0].v_pointer);
#line 1454 "scanner.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1458 "scanner.c"
	}
}


static gpointer
value_scan_page_info_peek_pointer (const GValue* value)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1468 "scanner.c"
}


static gchar*
value_scan_page_info_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1480 "scanner.c"
		ScanPageInfo * object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1487 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1491 "scanner.c"
		}
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = scan_page_info_ref (object);
#line 1495 "scanner.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1499 "scanner.c"
	}
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 1503 "scanner.c"
}


static gchar*
value_scan_page_info_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	ScanPageInfo ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1519 "scanner.c"
	}
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 1525 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1529 "scanner.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = scan_page_info_ref (value->data[0].v_pointer);
#line 1533 "scanner.c"
	}
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 1537 "scanner.c"
}


GParamSpec*
param_spec_scan_page_info (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecScanPageInfo* spec;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1557 "scanner.c"
}


gpointer
value_get_scan_page_info (const GValue* value)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1568 "scanner.c"
}


void
value_set_scan_page_info (GValue* value,
                          gpointer v_object)
{
	ScanPageInfo * old;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_page_info_ref (value->data[0].v_pointer);
#line 1591 "scanner.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1595 "scanner.c"
	}
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_page_info_unref (old);
#line 1601 "scanner.c"
	}
}


void
value_take_scan_page_info (GValue* value,
                           gpointer v_object)
{
	ScanPageInfo * old;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1623 "scanner.c"
	} else {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1627 "scanner.c"
	}
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_page_info_unref (old);
#line 1633 "scanner.c"
	}
}


static void
scan_page_info_class_init (ScanPageInfoClass * klass)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	scan_page_info_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	((ScanPageInfoClass *) klass)->finalize = scan_page_info_finalize;
#line 1645 "scanner.c"
}


static void
scan_page_info_instance_init (ScanPageInfo * self)
{
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 1654 "scanner.c"
}


static void
scan_page_info_finalize (ScanPageInfo * obj)
{
	ScanPageInfo * self;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_PAGE_INFO, ScanPageInfo);
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 36 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->device);
#line 1668 "scanner.c"
}


GType
scan_page_info_get_type (void)
{
	static volatile gsize scan_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&scan_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_page_info_init, value_scan_page_info_free_value, value_scan_page_info_copy_value, value_scan_page_info_peek_pointer, "p", value_scan_page_info_collect_value, "p", value_scan_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanPageInfo), 0, (GInstanceInitFunc) scan_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_page_info_type_id;
		scan_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_page_info_type_id__volatile, scan_page_info_type_id);
	}
	return scan_page_info_type_id__volatile;
}


gpointer
scan_page_info_ref (gpointer instance)
{
	ScanPageInfo * self;
	self = instance;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 1697 "scanner.c"
}


void
scan_page_info_unref (gpointer instance)
{
	ScanPageInfo * self;
	self = instance;
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		SCAN_PAGE_INFO_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1712 "scanner.c"
	}
}


ScanLine*
scan_line_construct (GType object_type)
{
	ScanLine* self = NULL;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (ScanLine*) g_type_create_instance (object_type);
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 1725 "scanner.c"
}


ScanLine*
scan_line_new (void)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	return scan_line_construct (TYPE_SCAN_LINE);
#line 1734 "scanner.c"
}


static void
value_scan_line_init (GValue* value)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1743 "scanner.c"
}


static void
value_scan_line_free_value (GValue* value)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_line_unref (value->data[0].v_pointer);
#line 1754 "scanner.c"
	}
}


static void
value_scan_line_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_line_ref (src_value->data[0].v_pointer);
#line 1767 "scanner.c"
	} else {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1771 "scanner.c"
	}
}


static gpointer
value_scan_line_peek_pointer (const GValue* value)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1781 "scanner.c"
}


static gchar*
value_scan_line_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1793 "scanner.c"
		ScanLine * object;
		object = collect_values[0].v_pointer;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1800 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1804 "scanner.c"
		}
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = scan_line_ref (object);
#line 1808 "scanner.c"
	} else {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1812 "scanner.c"
	}
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 1816 "scanner.c"
}


static gchar*
value_scan_line_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	ScanLine ** object_p;
	object_p = collect_values[0].v_pointer;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1832 "scanner.c"
	}
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 1838 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1842 "scanner.c"
	} else {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = scan_line_ref (value->data[0].v_pointer);
#line 1846 "scanner.c"
	}
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 1850 "scanner.c"
}


GParamSpec*
param_spec_scan_line (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecScanLine* spec;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1870 "scanner.c"
}


gpointer
value_get_scan_line (const GValue* value)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1881 "scanner.c"
}


void
value_set_scan_line (GValue* value,
                     gpointer v_object)
{
	ScanLine * old;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_line_ref (value->data[0].v_pointer);
#line 1904 "scanner.c"
	} else {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1908 "scanner.c"
	}
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_line_unref (old);
#line 1914 "scanner.c"
	}
}


void
value_take_scan_line (GValue* value,
                      gpointer v_object)
{
	ScanLine * old;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1936 "scanner.c"
	} else {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1940 "scanner.c"
	}
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_line_unref (old);
#line 1946 "scanner.c"
	}
}


static void
scan_line_class_init (ScanLineClass * klass)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	scan_line_parent_class = g_type_class_peek_parent (klass);
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	((ScanLineClass *) klass)->finalize = scan_line_finalize;
#line 1958 "scanner.c"
}


static void
scan_line_instance_init (ScanLine * self)
{
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 1967 "scanner.c"
}


static void
scan_line_finalize (ScanLine * obj)
{
	ScanLine * self;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_LINE, ScanLine);
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 55 "/home/bob/git/simple-scan/src/scanner.vala"
	self->data = (g_free (self->data), NULL);
#line 1981 "scanner.c"
}


GType
scan_line_get_type (void)
{
	static volatile gsize scan_line_type_id__volatile = 0;
	if (g_once_init_enter (&scan_line_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_line_init, value_scan_line_free_value, value_scan_line_copy_value, value_scan_line_peek_pointer, "p", value_scan_line_collect_value, "p", value_scan_line_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanLine), 0, (GInstanceInitFunc) scan_line_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_line_type_id;
		scan_line_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanLine", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_line_type_id__volatile, scan_line_type_id);
	}
	return scan_line_type_id__volatile;
}


gpointer
scan_line_ref (gpointer instance)
{
	ScanLine * self;
	self = instance;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 2010 "scanner.c"
}


void
scan_line_unref (gpointer instance)
{
	ScanLine * self;
	self = instance;
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		SCAN_LINE_GET_CLASS (self)->finalize (self);
#line 39 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2025 "scanner.c"
	}
}


GType
scan_mode_get_type (void)
{
	static volatile gsize scan_mode_type_id__volatile = 0;
	if (g_once_init_enter (&scan_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_MODE_DEFAULT, "SCAN_MODE_DEFAULT", "default"}, {SCAN_MODE_COLOR, "SCAN_MODE_COLOR", "color"}, {SCAN_MODE_GRAY, "SCAN_MODE_GRAY", "gray"}, {SCAN_MODE_LINEART, "SCAN_MODE_LINEART", "lineart"}, {0, NULL, NULL}};
		GType scan_mode_type_id;
		scan_mode_type_id = g_enum_register_static ("ScanMode", values);
		g_once_init_leave (&scan_mode_type_id__volatile, scan_mode_type_id);
	}
	return scan_mode_type_id__volatile;
}


GType
scan_type_get_type (void)
{
	static volatile gsize scan_type_type_id__volatile = 0;
	if (g_once_init_enter (&scan_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_TYPE_SINGLE, "SCAN_TYPE_SINGLE", "single"}, {SCAN_TYPE_ADF_FRONT, "SCAN_TYPE_ADF_FRONT", "adf-front"}, {SCAN_TYPE_ADF_BACK, "SCAN_TYPE_ADF_BACK", "adf-back"}, {SCAN_TYPE_ADF_BOTH, "SCAN_TYPE_ADF_BOTH", "adf-both"}, {0, NULL, NULL}};
		GType scan_type_type_id;
		scan_type_type_id = g_enum_register_static ("ScanType", values);
		g_once_init_leave (&scan_type_type_id__volatile, scan_type_type_id);
	}
	return scan_type_type_id__volatile;
}


ScanOptions*
scan_options_construct (GType object_type)
{
	ScanOptions* self = NULL;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (ScanOptions*) g_type_create_instance (object_type);
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 2066 "scanner.c"
}


ScanOptions*
scan_options_new (void)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	return scan_options_construct (TYPE_SCAN_OPTIONS);
#line 2075 "scanner.c"
}


static void
value_scan_options_init (GValue* value)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2084 "scanner.c"
}


static void
value_scan_options_free_value (GValue* value)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_options_unref (value->data[0].v_pointer);
#line 2095 "scanner.c"
	}
}


static void
value_scan_options_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_options_ref (src_value->data[0].v_pointer);
#line 2108 "scanner.c"
	} else {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2112 "scanner.c"
	}
}


static gpointer
value_scan_options_peek_pointer (const GValue* value)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2122 "scanner.c"
}


static gchar*
value_scan_options_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2134 "scanner.c"
		ScanOptions * object;
		object = collect_values[0].v_pointer;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2141 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2145 "scanner.c"
		}
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = scan_options_ref (object);
#line 2149 "scanner.c"
	} else {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2153 "scanner.c"
	}
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 2157 "scanner.c"
}


static gchar*
value_scan_options_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	ScanOptions ** object_p;
	object_p = collect_values[0].v_pointer;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2173 "scanner.c"
	}
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 2179 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2183 "scanner.c"
	} else {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = scan_options_ref (value->data[0].v_pointer);
#line 2187 "scanner.c"
	}
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 2191 "scanner.c"
}


GParamSpec*
param_spec_scan_options (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecScanOptions* spec;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2211 "scanner.c"
}


gpointer
value_get_scan_options (const GValue* value)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2222 "scanner.c"
}


void
value_set_scan_options (GValue* value,
                        gpointer v_object)
{
	ScanOptions * old;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_options_ref (value->data[0].v_pointer);
#line 2245 "scanner.c"
	} else {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2249 "scanner.c"
	}
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_options_unref (old);
#line 2255 "scanner.c"
	}
}


void
value_take_scan_options (GValue* value,
                         gpointer v_object)
{
	ScanOptions * old;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2277 "scanner.c"
	} else {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2281 "scanner.c"
	}
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_options_unref (old);
#line 2287 "scanner.c"
	}
}


static void
scan_options_class_init (ScanOptionsClass * klass)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	scan_options_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	((ScanOptionsClass *) klass)->finalize = scan_options_finalize;
#line 2299 "scanner.c"
}


static void
scan_options_instance_init (ScanOptions * self)
{
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 2308 "scanner.c"
}


static void
scan_options_finalize (ScanOptions * obj)
{
	ScanOptions * self;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_OPTIONS, ScanOptions);
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 2320 "scanner.c"
}


GType
scan_options_get_type (void)
{
	static volatile gsize scan_options_type_id__volatile = 0;
	if (g_once_init_enter (&scan_options_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_options_init, value_scan_options_free_value, value_scan_options_copy_value, value_scan_options_peek_pointer, "p", value_scan_options_collect_value, "p", value_scan_options_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanOptions), 0, (GInstanceInitFunc) scan_options_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_options_type_id;
		scan_options_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanOptions", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_options_type_id__volatile, scan_options_type_id);
	}
	return scan_options_type_id__volatile;
}


gpointer
scan_options_ref (gpointer instance)
{
	ScanOptions * self;
	self = instance;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 2349 "scanner.c"
}


void
scan_options_unref (gpointer instance)
{
	ScanOptions * self;
	self = instance;
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		SCAN_OPTIONS_GET_CLASS (self)->finalize (self);
#line 75 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2364 "scanner.c"
	}
}


ScanJob*
scan_job_construct (GType object_type)
{
	ScanJob* self = NULL;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (ScanJob*) g_type_create_instance (object_type);
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 2377 "scanner.c"
}


ScanJob*
scan_job_new (void)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	return scan_job_construct (TYPE_SCAN_JOB);
#line 2386 "scanner.c"
}


static void
value_scan_job_init (GValue* value)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2395 "scanner.c"
}


static void
value_scan_job_free_value (GValue* value)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_job_unref (value->data[0].v_pointer);
#line 2406 "scanner.c"
	}
}


static void
value_scan_job_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_job_ref (src_value->data[0].v_pointer);
#line 2419 "scanner.c"
	} else {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2423 "scanner.c"
	}
}


static gpointer
value_scan_job_peek_pointer (const GValue* value)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2433 "scanner.c"
}


static gchar*
value_scan_job_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2445 "scanner.c"
		ScanJob * object;
		object = collect_values[0].v_pointer;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2452 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2456 "scanner.c"
		}
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = scan_job_ref (object);
#line 2460 "scanner.c"
	} else {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2464 "scanner.c"
	}
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 2468 "scanner.c"
}


static gchar*
value_scan_job_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	ScanJob ** object_p;
	object_p = collect_values[0].v_pointer;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2484 "scanner.c"
	}
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 2490 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2494 "scanner.c"
	} else {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = scan_job_ref (value->data[0].v_pointer);
#line 2498 "scanner.c"
	}
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 2502 "scanner.c"
}


GParamSpec*
param_spec_scan_job (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecScanJob* spec;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_JOB), NULL);
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2522 "scanner.c"
}


gpointer
value_get_scan_job (const GValue* value)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB), NULL);
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2533 "scanner.c"
}


void
value_set_scan_job (GValue* value,
                    gpointer v_object)
{
	ScanJob * old;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_job_ref (value->data[0].v_pointer);
#line 2556 "scanner.c"
	} else {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2560 "scanner.c"
	}
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_job_unref (old);
#line 2566 "scanner.c"
	}
}


void
value_take_scan_job (GValue* value,
                     gpointer v_object)
{
	ScanJob * old;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2588 "scanner.c"
	} else {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2592 "scanner.c"
	}
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		scan_job_unref (old);
#line 2598 "scanner.c"
	}
}


static void
scan_job_class_init (ScanJobClass * klass)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	scan_job_parent_class = g_type_class_peek_parent (klass);
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	((ScanJobClass *) klass)->finalize = scan_job_finalize;
#line 2610 "scanner.c"
}


static void
scan_job_instance_init (ScanJob * self)
{
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 2619 "scanner.c"
}


static void
scan_job_finalize (ScanJob * obj)
{
	ScanJob * self;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_JOB, ScanJob);
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 90 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->device);
#line 2633 "scanner.c"
}


GType
scan_job_get_type (void)
{
	static volatile gsize scan_job_type_id__volatile = 0;
	if (g_once_init_enter (&scan_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_job_init, value_scan_job_free_value, value_scan_job_copy_value, value_scan_job_peek_pointer, "p", value_scan_job_collect_value, "p", value_scan_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanJob), 0, (GInstanceInitFunc) scan_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_job_type_id;
		scan_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_job_type_id__volatile, scan_job_type_id);
	}
	return scan_job_type_id__volatile;
}


gpointer
scan_job_ref (gpointer instance)
{
	ScanJob * self;
	self = instance;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 2662 "scanner.c"
}


void
scan_job_unref (gpointer instance)
{
	ScanJob * self;
	self = instance;
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		SCAN_JOB_GET_CLASS (self)->finalize (self);
#line 87 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2677 "scanner.c"
	}
}


Request*
request_construct (GType object_type)
{
	Request* self = NULL;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (Request*) g_type_create_instance (object_type);
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 2690 "scanner.c"
}


Request*
request_new (void)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	return request_construct (TYPE_REQUEST);
#line 2699 "scanner.c"
}


static void
value_request_init (GValue* value)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2708 "scanner.c"
}


static void
value_request_free_value (GValue* value)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		request_unref (value->data[0].v_pointer);
#line 2719 "scanner.c"
	}
}


static void
value_request_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = request_ref (src_value->data[0].v_pointer);
#line 2732 "scanner.c"
	} else {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2736 "scanner.c"
	}
}


static gpointer
value_request_peek_pointer (const GValue* value)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2746 "scanner.c"
}


static gchar*
value_request_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2758 "scanner.c"
		Request * object;
		object = collect_values[0].v_pointer;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2765 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2769 "scanner.c"
		}
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = request_ref (object);
#line 2773 "scanner.c"
	} else {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2777 "scanner.c"
	}
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 2781 "scanner.c"
}


static gchar*
value_request_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	Request ** object_p;
	object_p = collect_values[0].v_pointer;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2797 "scanner.c"
	}
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 2803 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2807 "scanner.c"
	} else {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = request_ref (value->data[0].v_pointer);
#line 2811 "scanner.c"
	}
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 2815 "scanner.c"
}


GParamSpec*
param_spec_request (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecRequest* spec;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REQUEST), NULL);
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2835 "scanner.c"
}


gpointer
value_get_request (const GValue* value)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST), NULL);
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2846 "scanner.c"
}


void
value_set_request (GValue* value,
                   gpointer v_object)
{
	Request * old;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		request_ref (value->data[0].v_pointer);
#line 2869 "scanner.c"
	} else {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2873 "scanner.c"
	}
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		request_unref (old);
#line 2879 "scanner.c"
	}
}


void
value_take_request (GValue* value,
                    gpointer v_object)
{
	Request * old;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2901 "scanner.c"
	} else {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2905 "scanner.c"
	}
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		request_unref (old);
#line 2911 "scanner.c"
	}
}


static void
request_class_init (RequestClass * klass)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	request_parent_class = g_type_class_peek_parent (klass);
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	((RequestClass *) klass)->finalize = request_finalize;
#line 2923 "scanner.c"
}


static void
request_instance_init (Request * self)
{
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 2932 "scanner.c"
}


static void
request_finalize (Request * obj)
{
	Request * self;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST, Request);
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 2944 "scanner.c"
}


GType
request_get_type (void)
{
	static volatile gsize request_type_id__volatile = 0;
	if (g_once_init_enter (&request_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_request_init, value_request_free_value, value_request_copy_value, value_request_peek_pointer, "p", value_request_collect_value, "p", value_request_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Request), 0, (GInstanceInitFunc) request_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType request_type_id;
		request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Request", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&request_type_id__volatile, request_type_id);
	}
	return request_type_id__volatile;
}


gpointer
request_ref (gpointer instance)
{
	Request * self;
	self = instance;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 2973 "scanner.c"
}


void
request_unref (gpointer instance)
{
	Request * self;
	self = instance;
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		REQUEST_GET_CLASS (self)->finalize (self);
#line 101 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2988 "scanner.c"
	}
}


RequestRedetect*
request_redetect_construct (GType object_type)
{
	RequestRedetect* self = NULL;
#line 103 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (RequestRedetect*) request_construct (object_type);
#line 103 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 3001 "scanner.c"
}


RequestRedetect*
request_redetect_new (void)
{
#line 103 "/home/bob/git/simple-scan/src/scanner.vala"
	return request_redetect_construct (TYPE_REQUEST_REDETECT);
#line 3010 "scanner.c"
}


static void
request_redetect_class_init (RequestRedetectClass * klass)
{
#line 103 "/home/bob/git/simple-scan/src/scanner.vala"
	request_redetect_parent_class = g_type_class_peek_parent (klass);
#line 3019 "scanner.c"
}


static void
request_redetect_instance_init (RequestRedetect * self)
{
}


GType
request_redetect_get_type (void)
{
	static volatile gsize request_redetect_type_id__volatile = 0;
	if (g_once_init_enter (&request_redetect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestRedetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_redetect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestRedetect), 0, (GInstanceInitFunc) request_redetect_instance_init, NULL };
		GType request_redetect_type_id;
		request_redetect_type_id = g_type_register_static (TYPE_REQUEST, "RequestRedetect", &g_define_type_info, 0);
		g_once_init_leave (&request_redetect_type_id__volatile, request_redetect_type_id);
	}
	return request_redetect_type_id__volatile;
}


RequestCancel*
request_cancel_construct (GType object_type)
{
	RequestCancel* self = NULL;
#line 105 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (RequestCancel*) request_construct (object_type);
#line 105 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 3051 "scanner.c"
}


RequestCancel*
request_cancel_new (void)
{
#line 105 "/home/bob/git/simple-scan/src/scanner.vala"
	return request_cancel_construct (TYPE_REQUEST_CANCEL);
#line 3060 "scanner.c"
}


static void
request_cancel_class_init (RequestCancelClass * klass)
{
#line 105 "/home/bob/git/simple-scan/src/scanner.vala"
	request_cancel_parent_class = g_type_class_peek_parent (klass);
#line 3069 "scanner.c"
}


static void
request_cancel_instance_init (RequestCancel * self)
{
}


GType
request_cancel_get_type (void)
{
	static volatile gsize request_cancel_type_id__volatile = 0;
	if (g_once_init_enter (&request_cancel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestCancelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_cancel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestCancel), 0, (GInstanceInitFunc) request_cancel_instance_init, NULL };
		GType request_cancel_type_id;
		request_cancel_type_id = g_type_register_static (TYPE_REQUEST, "RequestCancel", &g_define_type_info, 0);
		g_once_init_leave (&request_cancel_type_id__volatile, request_cancel_type_id);
	}
	return request_cancel_type_id__volatile;
}


RequestStartScan*
request_start_scan_construct (GType object_type)
{
	RequestStartScan* self = NULL;
#line 107 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (RequestStartScan*) request_construct (object_type);
#line 107 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 3101 "scanner.c"
}


RequestStartScan*
request_start_scan_new (void)
{
#line 107 "/home/bob/git/simple-scan/src/scanner.vala"
	return request_start_scan_construct (TYPE_REQUEST_START_SCAN);
#line 3110 "scanner.c"
}


static void
request_start_scan_class_init (RequestStartScanClass * klass)
{
#line 107 "/home/bob/git/simple-scan/src/scanner.vala"
	request_start_scan_parent_class = g_type_class_peek_parent (klass);
#line 107 "/home/bob/git/simple-scan/src/scanner.vala"
	((RequestClass *) klass)->finalize = request_start_scan_finalize;
#line 3121 "scanner.c"
}


static void
request_start_scan_instance_init (RequestStartScan * self)
{
}


static void
request_start_scan_finalize (Request * obj)
{
	RequestStartScan * self;
#line 107 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST_START_SCAN, RequestStartScan);
#line 109 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_job_unref0 (self->job);
#line 107 "/home/bob/git/simple-scan/src/scanner.vala"
	REQUEST_CLASS (request_start_scan_parent_class)->finalize (obj);
#line 3141 "scanner.c"
}


GType
request_start_scan_get_type (void)
{
	static volatile gsize request_start_scan_type_id__volatile = 0;
	if (g_once_init_enter (&request_start_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestStartScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_start_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestStartScan), 0, (GInstanceInitFunc) request_start_scan_instance_init, NULL };
		GType request_start_scan_type_id;
		request_start_scan_type_id = g_type_register_static (TYPE_REQUEST, "RequestStartScan", &g_define_type_info, 0);
		g_once_init_leave (&request_start_scan_type_id__volatile, request_start_scan_type_id);
	}
	return request_start_scan_type_id__volatile;
}


RequestQuit*
request_quit_construct (GType object_type)
{
	RequestQuit* self = NULL;
#line 112 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (RequestQuit*) request_construct (object_type);
#line 112 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 3167 "scanner.c"
}


RequestQuit*
request_quit_new (void)
{
#line 112 "/home/bob/git/simple-scan/src/scanner.vala"
	return request_quit_construct (TYPE_REQUEST_QUIT);
#line 3176 "scanner.c"
}


static void
request_quit_class_init (RequestQuitClass * klass)
{
#line 112 "/home/bob/git/simple-scan/src/scanner.vala"
	request_quit_parent_class = g_type_class_peek_parent (klass);
#line 3185 "scanner.c"
}


static void
request_quit_instance_init (RequestQuit * self)
{
}


GType
request_quit_get_type (void)
{
	static volatile gsize request_quit_type_id__volatile = 0;
	if (g_once_init_enter (&request_quit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestQuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_quit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestQuit), 0, (GInstanceInitFunc) request_quit_instance_init, NULL };
		GType request_quit_type_id;
		request_quit_type_id = g_type_register_static (TYPE_REQUEST, "RequestQuit", &g_define_type_info, 0);
		g_once_init_leave (&request_quit_type_id__volatile, request_quit_type_id);
	}
	return request_quit_type_id__volatile;
}


Credentials*
credentials_construct (GType object_type)
{
	Credentials* self = NULL;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (Credentials*) g_type_create_instance (object_type);
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 3217 "scanner.c"
}


Credentials*
credentials_new (void)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	return credentials_construct (TYPE_CREDENTIALS);
#line 3226 "scanner.c"
}


static void
value_credentials_init (GValue* value)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 3235 "scanner.c"
}


static void
value_credentials_free_value (GValue* value)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		credentials_unref (value->data[0].v_pointer);
#line 3246 "scanner.c"
	}
}


static void
value_credentials_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = credentials_ref (src_value->data[0].v_pointer);
#line 3259 "scanner.c"
	} else {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3263 "scanner.c"
	}
}


static gpointer
value_credentials_peek_pointer (const GValue* value)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3273 "scanner.c"
}


static gchar*
value_credentials_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 3285 "scanner.c"
		Credentials * object;
		object = collect_values[0].v_pointer;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3292 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3296 "scanner.c"
		}
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = credentials_ref (object);
#line 3300 "scanner.c"
	} else {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3304 "scanner.c"
	}
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 3308 "scanner.c"
}


static gchar*
value_credentials_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	Credentials ** object_p;
	object_p = collect_values[0].v_pointer;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3324 "scanner.c"
	}
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 3330 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 3334 "scanner.c"
	} else {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = credentials_ref (value->data[0].v_pointer);
#line 3338 "scanner.c"
	}
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 3342 "scanner.c"
}


GParamSpec*
param_spec_credentials (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecCredentials* spec;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CREDENTIALS), NULL);
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 3362 "scanner.c"
}


gpointer
value_get_credentials (const GValue* value)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS), NULL);
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3373 "scanner.c"
}


void
value_set_credentials (GValue* value,
                       gpointer v_object)
{
	Credentials * old;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		credentials_ref (value->data[0].v_pointer);
#line 3396 "scanner.c"
	} else {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3400 "scanner.c"
	}
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		credentials_unref (old);
#line 3406 "scanner.c"
	}
}


void
value_take_credentials (GValue* value,
                        gpointer v_object)
{
	Credentials * old;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 3428 "scanner.c"
	} else {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3432 "scanner.c"
	}
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		credentials_unref (old);
#line 3438 "scanner.c"
	}
}


static void
credentials_class_init (CredentialsClass * klass)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	credentials_parent_class = g_type_class_peek_parent (klass);
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	((CredentialsClass *) klass)->finalize = credentials_finalize;
#line 3450 "scanner.c"
}


static void
credentials_instance_init (Credentials * self)
{
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 3459 "scanner.c"
}


static void
credentials_finalize (Credentials * obj)
{
	Credentials * self;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CREDENTIALS, Credentials);
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 116 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->username);
#line 117 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->password);
#line 3475 "scanner.c"
}


GType
credentials_get_type (void)
{
	static volatile gsize credentials_type_id__volatile = 0;
	if (g_once_init_enter (&credentials_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_credentials_init, value_credentials_free_value, value_credentials_copy_value, value_credentials_peek_pointer, "p", value_credentials_collect_value, "p", value_credentials_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Credentials), 0, (GInstanceInitFunc) credentials_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType credentials_type_id;
		credentials_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Credentials", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&credentials_type_id__volatile, credentials_type_id);
	}
	return credentials_type_id__volatile;
}


gpointer
credentials_ref (gpointer instance)
{
	Credentials * self;
	self = instance;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 3504 "scanner.c"
}


void
credentials_unref (gpointer instance)
{
	Credentials * self;
	self = instance;
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		CREDENTIALS_GET_CLASS (self)->finalize (self);
#line 114 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3519 "scanner.c"
	}
}


GType
scan_state_get_type (void)
{
	static volatile gsize scan_state_type_id__volatile = 0;
	if (g_once_init_enter (&scan_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_STATE_IDLE, "SCAN_STATE_IDLE", "idle"}, {SCAN_STATE_REDETECT, "SCAN_STATE_REDETECT", "redetect"}, {SCAN_STATE_OPEN, "SCAN_STATE_OPEN", "open"}, {SCAN_STATE_GET_OPTION, "SCAN_STATE_GET_OPTION", "get-option"}, {SCAN_STATE_START, "SCAN_STATE_START", "start"}, {SCAN_STATE_GET_PARAMETERS, "SCAN_STATE_GET_PARAMETERS", "get-parameters"}, {SCAN_STATE_READ, "SCAN_STATE_READ", "read"}, {0, NULL, NULL}};
		GType scan_state_type_id;
		scan_state_type_id = g_enum_register_static ("ScanState", values);
		g_once_init_leave (&scan_state_type_id__volatile, scan_state_type_id);
	}
	return scan_state_type_id__volatile;
}


static void
notify_real_run (Notify* self,
                 Scanner* scanner)
{
#line 133 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 3544 "scanner.c"
}


void
notify_run (Notify* self,
            Scanner* scanner)
{
#line 133 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/bob/git/simple-scan/src/scanner.vala"
	NOTIFY_GET_CLASS (self)->run (self, scanner);
#line 3556 "scanner.c"
}


Notify*
notify_construct (GType object_type)
{
	Notify* self = NULL;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (Notify*) g_type_create_instance (object_type);
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 3568 "scanner.c"
}


Notify*
notify_new (void)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_construct (TYPE_NOTIFY);
#line 3577 "scanner.c"
}


static void
value_notify_init (GValue* value)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 3586 "scanner.c"
}


static void
value_notify_free_value (GValue* value)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		notify_unref (value->data[0].v_pointer);
#line 3597 "scanner.c"
	}
}


static void
value_notify_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = notify_ref (src_value->data[0].v_pointer);
#line 3610 "scanner.c"
	} else {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3614 "scanner.c"
	}
}


static gpointer
value_notify_peek_pointer (const GValue* value)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3624 "scanner.c"
}


static gchar*
value_notify_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 3636 "scanner.c"
		Notify * object;
		object = collect_values[0].v_pointer;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3643 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3647 "scanner.c"
		}
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = notify_ref (object);
#line 3651 "scanner.c"
	} else {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3655 "scanner.c"
	}
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 3659 "scanner.c"
}


static gchar*
value_notify_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Notify ** object_p;
	object_p = collect_values[0].v_pointer;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3675 "scanner.c"
	}
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 3681 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 3685 "scanner.c"
	} else {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = notify_ref (value->data[0].v_pointer);
#line 3689 "scanner.c"
	}
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 3693 "scanner.c"
}


GParamSpec*
param_spec_notify (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecNotify* spec;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFY), NULL);
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 3713 "scanner.c"
}


gpointer
value_get_notify (const GValue* value)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY), NULL);
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3724 "scanner.c"
}


void
value_set_notify (GValue* value,
                  gpointer v_object)
{
	Notify * old;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		notify_ref (value->data[0].v_pointer);
#line 3747 "scanner.c"
	} else {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3751 "scanner.c"
	}
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		notify_unref (old);
#line 3757 "scanner.c"
	}
}


void
value_take_notify (GValue* value,
                   gpointer v_object)
{
	Notify * old;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 3779 "scanner.c"
	} else {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3783 "scanner.c"
	}
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		notify_unref (old);
#line 3789 "scanner.c"
	}
}


static void
notify_class_init (NotifyClass * klass)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_parent_class = g_type_class_peek_parent (klass);
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_finalize;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_real_run;
#line 3803 "scanner.c"
}


static void
notify_instance_init (Notify * self)
{
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 3812 "scanner.c"
}


static void
notify_finalize (Notify * obj)
{
	Notify * self;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY, Notify);
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 3824 "scanner.c"
}


GType
notify_get_type (void)
{
	static volatile gsize notify_type_id__volatile = 0;
	if (g_once_init_enter (&notify_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_notify_init, value_notify_free_value, value_notify_copy_value, value_notify_peek_pointer, "p", value_notify_collect_value, "p", value_notify_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notify), 0, (GInstanceInitFunc) notify_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType notify_type_id;
		notify_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Notify", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&notify_type_id__volatile, notify_type_id);
	}
	return notify_type_id__volatile;
}


gpointer
notify_ref (gpointer instance)
{
	Notify * self;
	self = instance;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 3853 "scanner.c"
}


void
notify_unref (gpointer instance)
{
	Notify * self;
	self = instance;
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		NOTIFY_GET_CLASS (self)->finalize (self);
#line 131 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3868 "scanner.c"
	}
}


static void
notify_scanning_changed_real_run (Notify* base,
                                  Scanner* scanner)
{
	NotifyScanningChanged * self;
#line 138 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyScanningChanged*) base;
#line 138 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 138 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_emit (scanner, scanner_signals[SCANNER_SCANNING_CHANGED_SIGNAL], 0);
#line 3884 "scanner.c"
}


NotifyScanningChanged*
notify_scanning_changed_construct (GType object_type)
{
	NotifyScanningChanged* self = NULL;
#line 136 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyScanningChanged*) notify_construct (object_type);
#line 136 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 3896 "scanner.c"
}


NotifyScanningChanged*
notify_scanning_changed_new (void)
{
#line 136 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_scanning_changed_construct (TYPE_NOTIFY_SCANNING_CHANGED);
#line 3905 "scanner.c"
}


static void
notify_scanning_changed_class_init (NotifyScanningChangedClass * klass)
{
#line 136 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_scanning_changed_parent_class = g_type_class_peek_parent (klass);
#line 136 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_scanning_changed_real_run;
#line 3916 "scanner.c"
}


static void
notify_scanning_changed_instance_init (NotifyScanningChanged * self)
{
}


GType
notify_scanning_changed_get_type (void)
{
	static volatile gsize notify_scanning_changed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scanning_changed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanningChangedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scanning_changed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanningChanged), 0, (GInstanceInitFunc) notify_scanning_changed_instance_init, NULL };
		GType notify_scanning_changed_type_id;
		notify_scanning_changed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanningChanged", &g_define_type_info, 0);
		g_once_init_leave (&notify_scanning_changed_type_id__volatile, notify_scanning_changed_type_id);
	}
	return notify_scanning_changed_type_id__volatile;
}


static void
_scan_device_unref0_ (gpointer var)
{
#line 144 "/home/bob/git/simple-scan/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 3945 "scanner.c"
}


static inline void
_g_list_free__scan_device_unref0_ (GList* self)
{
#line 144 "/home/bob/git/simple-scan/src/scanner.vala"
	g_list_free_full (self, (GDestroyNotify) _scan_device_unref0_);
#line 3954 "scanner.c"
}


NotifyUpdateDevices*
notify_update_devices_construct (GType object_type,
                                 GList* devices)
{
	NotifyUpdateDevices* self = NULL;
	GList* _tmp0_;
#line 143 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyUpdateDevices*) notify_construct (object_type);
#line 143 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = devices;
#line 143 "/home/bob/git/simple-scan/src/scanner.vala"
	devices = NULL;
#line 143 "/home/bob/git/simple-scan/src/scanner.vala"
	(self->priv->devices == NULL) ? NULL : (self->priv->devices = (_g_list_free__scan_device_unref0_ (self->priv->devices), NULL));
#line 143 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->devices = _tmp0_;
#line 143 "/home/bob/git/simple-scan/src/scanner.vala"
	(devices == NULL) ? NULL : (devices = (_g_list_free__scan_device_unref0_ (devices), NULL));
#line 143 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 3978 "scanner.c"
}


NotifyUpdateDevices*
notify_update_devices_new (GList* devices)
{
#line 143 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_update_devices_construct (TYPE_NOTIFY_UPDATE_DEVICES, devices);
#line 3987 "scanner.c"
}


static void
notify_update_devices_real_run (Notify* base,
                                Scanner* scanner)
{
	NotifyUpdateDevices * self;
	GList* _tmp0_;
#line 145 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyUpdateDevices*) base;
#line 145 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 145 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->devices;
#line 145 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_emit (scanner, scanner_signals[SCANNER_UPDATE_DEVICES_SIGNAL], 0, _tmp0_);
#line 4005 "scanner.c"
}


static void
notify_update_devices_class_init (NotifyUpdateDevicesClass * klass)
{
#line 141 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_update_devices_parent_class = g_type_class_peek_parent (klass);
#line 141 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_update_devices_finalize;
#line 141 "/home/bob/git/simple-scan/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyUpdateDevicesPrivate));
#line 141 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_update_devices_real_run;
#line 4020 "scanner.c"
}


static void
notify_update_devices_instance_init (NotifyUpdateDevices * self)
{
#line 141 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv = NOTIFY_UPDATE_DEVICES_GET_PRIVATE (self);
#line 4029 "scanner.c"
}


static void
notify_update_devices_finalize (Notify * obj)
{
	NotifyUpdateDevices * self;
#line 141 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices);
#line 144 "/home/bob/git/simple-scan/src/scanner.vala"
	(self->priv->devices == NULL) ? NULL : (self->priv->devices = (_g_list_free__scan_device_unref0_ (self->priv->devices), NULL));
#line 141 "/home/bob/git/simple-scan/src/scanner.vala"
	NOTIFY_CLASS (notify_update_devices_parent_class)->finalize (obj);
#line 4043 "scanner.c"
}


GType
notify_update_devices_get_type (void)
{
	static volatile gsize notify_update_devices_type_id__volatile = 0;
	if (g_once_init_enter (&notify_update_devices_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyUpdateDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_update_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyUpdateDevices), 0, (GInstanceInitFunc) notify_update_devices_instance_init, NULL };
		GType notify_update_devices_type_id;
		notify_update_devices_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyUpdateDevices", &g_define_type_info, 0);
		g_once_init_leave (&notify_update_devices_type_id__volatile, notify_update_devices_type_id);
	}
	return notify_update_devices_type_id__volatile;
}


NotifyRequestAuthorization*
notify_request_authorization_construct (GType object_type,
                                        const gchar* resource)
{
	NotifyRequestAuthorization* self = NULL;
	gchar* _tmp0_;
#line 150 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (resource != NULL, NULL);
#line 150 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyRequestAuthorization*) notify_construct (object_type);
#line 150 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = g_strdup (resource);
#line 150 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 150 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->resource = _tmp0_;
#line 150 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 4079 "scanner.c"
}


NotifyRequestAuthorization*
notify_request_authorization_new (const gchar* resource)
{
#line 150 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_request_authorization_construct (TYPE_NOTIFY_REQUEST_AUTHORIZATION, resource);
#line 4088 "scanner.c"
}


static void
notify_request_authorization_real_run (Notify* base,
                                       Scanner* scanner)
{
	NotifyRequestAuthorization * self;
	const gchar* _tmp0_;
#line 152 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyRequestAuthorization*) base;
#line 152 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 152 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->resource;
#line 152 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_emit (scanner, scanner_signals[SCANNER_REQUEST_AUTHORIZATION_SIGNAL], 0, _tmp0_);
#line 4106 "scanner.c"
}


static void
notify_request_authorization_class_init (NotifyRequestAuthorizationClass * klass)
{
#line 148 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_request_authorization_parent_class = g_type_class_peek_parent (klass);
#line 148 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_request_authorization_finalize;
#line 148 "/home/bob/git/simple-scan/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyRequestAuthorizationPrivate));
#line 148 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_request_authorization_real_run;
#line 4121 "scanner.c"
}


static void
notify_request_authorization_instance_init (NotifyRequestAuthorization * self)
{
#line 148 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv = NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE (self);
#line 4130 "scanner.c"
}


static void
notify_request_authorization_finalize (Notify * obj)
{
	NotifyRequestAuthorization * self;
#line 148 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization);
#line 151 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 148 "/home/bob/git/simple-scan/src/scanner.vala"
	NOTIFY_CLASS (notify_request_authorization_parent_class)->finalize (obj);
#line 4144 "scanner.c"
}


GType
notify_request_authorization_get_type (void)
{
	static volatile gsize notify_request_authorization_type_id__volatile = 0;
	if (g_once_init_enter (&notify_request_authorization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyRequestAuthorizationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_request_authorization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyRequestAuthorization), 0, (GInstanceInitFunc) notify_request_authorization_instance_init, NULL };
		GType notify_request_authorization_type_id;
		notify_request_authorization_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyRequestAuthorization", &g_define_type_info, 0);
		g_once_init_leave (&notify_request_authorization_type_id__volatile, notify_request_authorization_type_id);
	}
	return notify_request_authorization_type_id__volatile;
}


NotifyScanFailed*
notify_scan_failed_construct (GType object_type,
                              gint error_code,
                              const gchar* error_string)
{
	NotifyScanFailed* self = NULL;
	gchar* _tmp0_;
#line 157 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (error_string != NULL, NULL);
#line 157 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyScanFailed*) notify_construct (object_type);
#line 157 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->error_code = error_code;
#line 157 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = g_strdup (error_string);
#line 157 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 157 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->error_string = _tmp0_;
#line 157 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 4183 "scanner.c"
}


NotifyScanFailed*
notify_scan_failed_new (gint error_code,
                        const gchar* error_string)
{
#line 157 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_scan_failed_construct (TYPE_NOTIFY_SCAN_FAILED, error_code, error_string);
#line 4193 "scanner.c"
}


static void
notify_scan_failed_real_run (Notify* base,
                             Scanner* scanner)
{
	NotifyScanFailed * self;
	gint _tmp0_;
	const gchar* _tmp1_;
#line 160 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyScanFailed*) base;
#line 160 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 160 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->error_code;
#line 160 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = self->priv->error_string;
#line 160 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_emit (scanner, scanner_signals[SCANNER_SCAN_FAILED_SIGNAL], 0, _tmp0_, _tmp1_);
#line 4214 "scanner.c"
}


static void
notify_scan_failed_class_init (NotifyScanFailedClass * klass)
{
#line 155 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_scan_failed_parent_class = g_type_class_peek_parent (klass);
#line 155 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_scan_failed_finalize;
#line 155 "/home/bob/git/simple-scan/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyScanFailedPrivate));
#line 155 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_scan_failed_real_run;
#line 4229 "scanner.c"
}


static void
notify_scan_failed_instance_init (NotifyScanFailed * self)
{
#line 155 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv = NOTIFY_SCAN_FAILED_GET_PRIVATE (self);
#line 4238 "scanner.c"
}


static void
notify_scan_failed_finalize (Notify * obj)
{
	NotifyScanFailed * self;
#line 155 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed);
#line 159 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 155 "/home/bob/git/simple-scan/src/scanner.vala"
	NOTIFY_CLASS (notify_scan_failed_parent_class)->finalize (obj);
#line 4252 "scanner.c"
}


GType
notify_scan_failed_get_type (void)
{
	static volatile gsize notify_scan_failed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scan_failed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanFailedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scan_failed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanFailed), 0, (GInstanceInitFunc) notify_scan_failed_instance_init, NULL };
		GType notify_scan_failed_type_id;
		notify_scan_failed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanFailed", &g_define_type_info, 0);
		g_once_init_leave (&notify_scan_failed_type_id__volatile, notify_scan_failed_type_id);
	}
	return notify_scan_failed_type_id__volatile;
}


static void
notify_document_done_real_run (Notify* base,
                               Scanner* scanner)
{
	NotifyDocumentDone * self;
#line 165 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyDocumentDone*) base;
#line 165 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 165 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_emit (scanner, scanner_signals[SCANNER_DOCUMENT_DONE_SIGNAL], 0);
#line 4281 "scanner.c"
}


NotifyDocumentDone*
notify_document_done_construct (GType object_type)
{
	NotifyDocumentDone* self = NULL;
#line 163 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyDocumentDone*) notify_construct (object_type);
#line 163 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 4293 "scanner.c"
}


NotifyDocumentDone*
notify_document_done_new (void)
{
#line 163 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_document_done_construct (TYPE_NOTIFY_DOCUMENT_DONE);
#line 4302 "scanner.c"
}


static void
notify_document_done_class_init (NotifyDocumentDoneClass * klass)
{
#line 163 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_document_done_parent_class = g_type_class_peek_parent (klass);
#line 163 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_document_done_real_run;
#line 4313 "scanner.c"
}


static void
notify_document_done_instance_init (NotifyDocumentDone * self)
{
}


GType
notify_document_done_get_type (void)
{
	static volatile gsize notify_document_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_document_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyDocumentDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_document_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyDocumentDone), 0, (GInstanceInitFunc) notify_document_done_instance_init, NULL };
		GType notify_document_done_type_id;
		notify_document_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyDocumentDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_document_done_type_id__volatile, notify_document_done_type_id);
	}
	return notify_document_done_type_id__volatile;
}


static void
notify_expect_page_real_run (Notify* base,
                             Scanner* scanner)
{
	NotifyExpectPage * self;
#line 170 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyExpectPage*) base;
#line 170 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 170 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_emit (scanner, scanner_signals[SCANNER_EXPECT_PAGE_SIGNAL], 0);
#line 4348 "scanner.c"
}


NotifyExpectPage*
notify_expect_page_construct (GType object_type)
{
	NotifyExpectPage* self = NULL;
#line 168 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyExpectPage*) notify_construct (object_type);
#line 168 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 4360 "scanner.c"
}


NotifyExpectPage*
notify_expect_page_new (void)
{
#line 168 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_expect_page_construct (TYPE_NOTIFY_EXPECT_PAGE);
#line 4369 "scanner.c"
}


static void
notify_expect_page_class_init (NotifyExpectPageClass * klass)
{
#line 168 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_expect_page_parent_class = g_type_class_peek_parent (klass);
#line 168 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_expect_page_real_run;
#line 4380 "scanner.c"
}


static void
notify_expect_page_instance_init (NotifyExpectPage * self)
{
}


GType
notify_expect_page_get_type (void)
{
	static volatile gsize notify_expect_page_type_id__volatile = 0;
	if (g_once_init_enter (&notify_expect_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyExpectPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_expect_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyExpectPage), 0, (GInstanceInitFunc) notify_expect_page_instance_init, NULL };
		GType notify_expect_page_type_id;
		notify_expect_page_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyExpectPage", &g_define_type_info, 0);
		g_once_init_leave (&notify_expect_page_type_id__volatile, notify_expect_page_type_id);
	}
	return notify_expect_page_type_id__volatile;
}


static gpointer
_scan_page_info_ref0 (gpointer self)
{
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? scan_page_info_ref (self) : NULL;
#line 4409 "scanner.c"
}


NotifyGotPageInfo*
notify_got_page_info_construct (GType object_type,
                                gint job_id,
                                ScanPageInfo* info)
{
	NotifyGotPageInfo* self = NULL;
	ScanPageInfo* _tmp0_;
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyGotPageInfo*) notify_construct (object_type);
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->job_id = job_id;
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = _scan_page_info_ref0 (info);
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->info = _tmp0_;
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 4434 "scanner.c"
}


NotifyGotPageInfo*
notify_got_page_info_new (gint job_id,
                          ScanPageInfo* info)
{
#line 175 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_got_page_info_construct (TYPE_NOTIFY_GOT_PAGE_INFO, job_id, info);
#line 4444 "scanner.c"
}


static void
notify_got_page_info_real_run (Notify* base,
                               Scanner* scanner)
{
	NotifyGotPageInfo * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
#line 178 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyGotPageInfo*) base;
#line 178 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 180 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 180 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = scanner->first_job_id;
#line 180 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp1_ >= _tmp2_) {
#line 4466 "scanner.c"
		gint _tmp3_;
		gint _tmp4_;
#line 180 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = self->priv->job_id;
#line 180 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = scanner->job_id;
#line 180 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = _tmp3_ < _tmp4_;
#line 4475 "scanner.c"
	} else {
#line 180 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = FALSE;
#line 4479 "scanner.c"
	}
#line 180 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_) {
#line 4483 "scanner.c"
		ScanPageInfo* _tmp5_;
#line 181 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp5_ = self->priv->info;
#line 181 "/home/bob/git/simple-scan/src/scanner.vala"
		g_signal_emit (scanner, scanner_signals[SCANNER_GOT_PAGE_INFO_SIGNAL], 0, _tmp5_);
#line 4489 "scanner.c"
	}
}


static void
notify_got_page_info_class_init (NotifyGotPageInfoClass * klass)
{
#line 173 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_got_page_info_parent_class = g_type_class_peek_parent (klass);
#line 173 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_got_page_info_finalize;
#line 173 "/home/bob/git/simple-scan/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotPageInfoPrivate));
#line 173 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_got_page_info_real_run;
#line 4505 "scanner.c"
}


static void
notify_got_page_info_instance_init (NotifyGotPageInfo * self)
{
#line 173 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv = NOTIFY_GOT_PAGE_INFO_GET_PRIVATE (self);
#line 4514 "scanner.c"
}


static void
notify_got_page_info_finalize (Notify * obj)
{
	NotifyGotPageInfo * self;
#line 173 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo);
#line 177 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 173 "/home/bob/git/simple-scan/src/scanner.vala"
	NOTIFY_CLASS (notify_got_page_info_parent_class)->finalize (obj);
#line 4528 "scanner.c"
}


GType
notify_got_page_info_get_type (void)
{
	static volatile gsize notify_got_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_page_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotPageInfo), 0, (GInstanceInitFunc) notify_got_page_info_instance_init, NULL };
		GType notify_got_page_info_type_id;
		notify_got_page_info_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotPageInfo", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_page_info_type_id__volatile, notify_got_page_info_type_id);
	}
	return notify_got_page_info_type_id__volatile;
}


NotifyPageDone*
notify_page_done_construct (GType object_type,
                            gint job_id)
{
	NotifyPageDone* self = NULL;
#line 187 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyPageDone*) notify_construct (object_type);
#line 187 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->job_id = job_id;
#line 187 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 4557 "scanner.c"
}


NotifyPageDone*
notify_page_done_new (gint job_id)
{
#line 187 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_page_done_construct (TYPE_NOTIFY_PAGE_DONE, job_id);
#line 4566 "scanner.c"
}


static void
notify_page_done_real_run (Notify* base,
                           Scanner* scanner)
{
	NotifyPageDone * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
#line 189 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyPageDone*) base;
#line 189 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 191 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 191 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = scanner->first_job_id;
#line 191 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp1_ >= _tmp2_) {
#line 4588 "scanner.c"
		gint _tmp3_;
		gint _tmp4_;
#line 191 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = self->priv->job_id;
#line 191 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = scanner->job_id;
#line 191 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = _tmp3_ < _tmp4_;
#line 4597 "scanner.c"
	} else {
#line 191 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = FALSE;
#line 4601 "scanner.c"
	}
#line 191 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_) {
#line 192 "/home/bob/git/simple-scan/src/scanner.vala"
		g_signal_emit (scanner, scanner_signals[SCANNER_PAGE_DONE_SIGNAL], 0);
#line 4607 "scanner.c"
	}
}


static void
notify_page_done_class_init (NotifyPageDoneClass * klass)
{
#line 185 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_page_done_parent_class = g_type_class_peek_parent (klass);
#line 185 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_page_done_finalize;
#line 185 "/home/bob/git/simple-scan/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyPageDonePrivate));
#line 185 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_page_done_real_run;
#line 4623 "scanner.c"
}


static void
notify_page_done_instance_init (NotifyPageDone * self)
{
#line 185 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv = NOTIFY_PAGE_DONE_GET_PRIVATE (self);
#line 4632 "scanner.c"
}


static void
notify_page_done_finalize (Notify * obj)
{
	NotifyPageDone * self;
#line 185 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_PAGE_DONE, NotifyPageDone);
#line 185 "/home/bob/git/simple-scan/src/scanner.vala"
	NOTIFY_CLASS (notify_page_done_parent_class)->finalize (obj);
#line 4644 "scanner.c"
}


GType
notify_page_done_get_type (void)
{
	static volatile gsize notify_page_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_page_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyPageDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_page_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyPageDone), 0, (GInstanceInitFunc) notify_page_done_instance_init, NULL };
		GType notify_page_done_type_id;
		notify_page_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyPageDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_page_done_type_id__volatile, notify_page_done_type_id);
	}
	return notify_page_done_type_id__volatile;
}


static gpointer
_scan_line_ref0 (gpointer self)
{
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? scan_line_ref (self) : NULL;
#line 4667 "scanner.c"
}


NotifyGotLine*
notify_got_line_construct (GType object_type,
                           gint job_id,
                           ScanLine* line)
{
	NotifyGotLine* self = NULL;
	ScanLine* _tmp0_;
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyGotLine*) notify_construct (object_type);
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->job_id = job_id;
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = _scan_line_ref0 (line);
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->line = _tmp0_;
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 4692 "scanner.c"
}


NotifyGotLine*
notify_got_line_new (gint job_id,
                     ScanLine* line)
{
#line 198 "/home/bob/git/simple-scan/src/scanner.vala"
	return notify_got_line_construct (TYPE_NOTIFY_GOT_LINE, job_id, line);
#line 4702 "scanner.c"
}


static void
notify_got_line_real_run (Notify* base,
                          Scanner* scanner)
{
	NotifyGotLine * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
#line 201 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (NotifyGotLine*) base;
#line 201 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 203 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 203 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = scanner->first_job_id;
#line 203 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp1_ >= _tmp2_) {
#line 4724 "scanner.c"
		gint _tmp3_;
		gint _tmp4_;
#line 203 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = self->priv->job_id;
#line 203 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = scanner->job_id;
#line 203 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = _tmp3_ < _tmp4_;
#line 4733 "scanner.c"
	} else {
#line 203 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = FALSE;
#line 4737 "scanner.c"
	}
#line 203 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_) {
#line 4741 "scanner.c"
		ScanLine* _tmp5_;
#line 204 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp5_ = self->priv->line;
#line 204 "/home/bob/git/simple-scan/src/scanner.vala"
		g_signal_emit (scanner, scanner_signals[SCANNER_GOT_LINE_SIGNAL], 0, _tmp5_);
#line 4747 "scanner.c"
	}
}


static void
notify_got_line_class_init (NotifyGotLineClass * klass)
{
#line 196 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_got_line_parent_class = g_type_class_peek_parent (klass);
#line 196 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_got_line_finalize;
#line 196 "/home/bob/git/simple-scan/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotLinePrivate));
#line 196 "/home/bob/git/simple-scan/src/scanner.vala"
	((NotifyClass *) klass)->run = (void (*) (Notify *, Scanner*)) notify_got_line_real_run;
#line 4763 "scanner.c"
}


static void
notify_got_line_instance_init (NotifyGotLine * self)
{
#line 196 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv = NOTIFY_GOT_LINE_GET_PRIVATE (self);
#line 4772 "scanner.c"
}


static void
notify_got_line_finalize (Notify * obj)
{
	NotifyGotLine * self;
#line 196 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_LINE, NotifyGotLine);
#line 200 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 196 "/home/bob/git/simple-scan/src/scanner.vala"
	NOTIFY_CLASS (notify_got_line_parent_class)->finalize (obj);
#line 4786 "scanner.c"
}


GType
notify_got_line_get_type (void)
{
	static volatile gsize notify_got_line_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotLine), 0, (GInstanceInitFunc) notify_got_line_instance_init, NULL };
		GType notify_got_line_type_id;
		notify_got_line_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotLine", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_line_type_id__volatile, notify_got_line_type_id);
	}
	return notify_got_line_type_id__volatile;
}


static void
_scan_job_unref0_ (gpointer var)
{
#line 234 "/home/bob/git/simple-scan/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_job_unref (var), NULL));
#line 4809 "scanner.c"
}


static inline void
_g_list_free__scan_job_unref0_ (GList* self)
{
#line 234 "/home/bob/git/simple-scan/src/scanner.vala"
	g_list_free_full (self, (GDestroyNotify) _scan_job_unref0_);
#line 4818 "scanner.c"
}


static void
_request_unref0_ (gpointer var)
{
#line 273 "/home/bob/git/simple-scan/src/scanner.vala"
	(var == NULL) ? NULL : (var = (request_unref (var), NULL));
#line 4827 "scanner.c"
}


static void
_notify_unref0_ (gpointer var)
{
#line 274 "/home/bob/git/simple-scan/src/scanner.vala"
	(var == NULL) ? NULL : (var = (notify_unref (var), NULL));
#line 4836 "scanner.c"
}


static void
_credentials_unref0_ (gpointer var)
{
#line 275 "/home/bob/git/simple-scan/src/scanner.vala"
	(var == NULL) ? NULL : (var = (credentials_unref (var), NULL));
#line 4845 "scanner.c"
}


static Scanner*
scanner_construct (GType object_type)
{
	Scanner* self = NULL;
	GAsyncQueue* _tmp0_;
	GAsyncQueue* _tmp1_;
	GAsyncQueue* _tmp2_;
#line 271 "/home/bob/git/simple-scan/src/scanner.vala"
	self = (Scanner*) g_type_create_instance (object_type);
#line 273 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = g_async_queue_new_full (_request_unref0_);
#line 273 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 273 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->request_queue = _tmp0_;
#line 274 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = g_async_queue_new_full (_notify_unref0_);
#line 274 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 274 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->notify_queue = _tmp1_;
#line 275 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = g_async_queue_new_full (_credentials_unref0_);
#line 275 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 275 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->authorize_queue = _tmp2_;
#line 271 "/home/bob/git/simple-scan/src/scanner.vala"
	return self;
#line 4878 "scanner.c"
}


static Scanner*
scanner_new (void)
{
#line 271 "/home/bob/git/simple-scan/src/scanner.vala"
	return scanner_construct (TYPE_SCANNER);
#line 4887 "scanner.c"
}


static gpointer
_scanner_ref0 (gpointer self)
{
#line 282 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? scanner_ref (self) : NULL;
#line 4896 "scanner.c"
}


Scanner*
scanner_get_instance (void)
{
	Scanner* result = NULL;
	Scanner* _tmp0_;
	Scanner* _tmp2_;
	Scanner* _tmp3_;
#line 280 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 280 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_ == NULL) {
#line 4911 "scanner.c"
		Scanner* _tmp1_;
#line 281 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp1_ = scanner_new ();
#line 281 "/home/bob/git/simple-scan/src/scanner.vala"
		_scanner_unref0 (scanner_scanner_object);
#line 281 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_scanner_object = _tmp1_;
#line 4919 "scanner.c"
	}
#line 282 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = scanner_scanner_object;
#line 282 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = _scanner_ref0 (_tmp2_);
#line 282 "/home/bob/git/simple-scan/src/scanner.vala"
	result = _tmp3_;
#line 282 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 4929 "scanner.c"
}


static gboolean
scanner_notify_idle_cb (Scanner* self)
{
	gboolean result = FALSE;
	Notify* notification = NULL;
	GAsyncQueue* _tmp0_;
	gpointer _tmp1_;
#line 285 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 287 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 287 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = g_async_queue_pop (_tmp0_);
#line 287 "/home/bob/git/simple-scan/src/scanner.vala"
	notification = (Notify*) _tmp1_;
#line 288 "/home/bob/git/simple-scan/src/scanner.vala"
	notify_run (notification, self);
#line 289 "/home/bob/git/simple-scan/src/scanner.vala"
	result = FALSE;
#line 289 "/home/bob/git/simple-scan/src/scanner.vala"
	_notify_unref0 (notification);
#line 289 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 4956 "scanner.c"
}


static gpointer
_notify_ref0 (gpointer self)
{
#line 294 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? notify_ref (self) : NULL;
#line 4965 "scanner.c"
}


static gboolean
_scanner_notify_idle_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = scanner_notify_idle_cb ((Scanner*) self);
#line 295 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 4976 "scanner.c"
}


static void
scanner_notify (Scanner* self,
                Notify* notification)
{
	GAsyncQueue* _tmp0_;
	Notify* _tmp1_;
#line 292 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 292 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (notification != NULL);
#line 294 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 294 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = _notify_ref0 (notification);
#line 294 "/home/bob/git/simple-scan/src/scanner.vala"
	g_async_queue_push (_tmp0_, _tmp1_);
#line 295 "/home/bob/git/simple-scan/src/scanner.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scanner_notify_idle_cb_gsource_func, scanner_ref (self), scanner_unref);
#line 4998 "scanner.c"
}


static void
scanner_set_scanning (Scanner* self,
                      gboolean is_scanning)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
#line 298 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = self->priv->scanning;
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp2_) {
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp1_ = !is_scanning;
#line 5017 "scanner.c"
	} else {
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp1_ = FALSE;
#line 5021 "scanner.c"
	}
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp1_) {
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = TRUE;
#line 5027 "scanner.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = self->priv->scanning;
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
		if (!_tmp4_) {
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp3_ = is_scanning;
#line 5037 "scanner.c"
		} else {
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp3_ = FALSE;
#line 5041 "scanner.c"
		}
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = _tmp3_;
#line 5045 "scanner.c"
	}
#line 300 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_) {
#line 5049 "scanner.c"
		NotifyScanningChanged* _tmp5_;
		NotifyScanningChanged* _tmp6_;
#line 302 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->scanning = is_scanning;
#line 303 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp5_ = notify_scanning_changed_new ();
#line 303 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp6_ = _tmp5_;
#line 303 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp6_);
#line 303 "/home/bob/git/simple-scan/src/scanner.vala"
		_notify_unref0 (_tmp6_);
#line 5062 "scanner.c"
	}
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
#line 1473 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1473 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1474 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1474 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1474 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 5083 "scanner.c"
}


static gint
scanner_get_device_weight (const gchar* device)
{
	gint result = 0;
#line 307 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (device != NULL, 0);
#line 312 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_str_has_prefix (device, "vfl:")) {
#line 313 "/home/bob/git/simple-scan/src/scanner.vala"
		result = 2;
#line 313 "/home/bob/git/simple-scan/src/scanner.vala"
		return result;
#line 5099 "scanner.c"
	}
#line 316 "/home/bob/git/simple-scan/src/scanner.vala"
	if (string_contains (device, "usb")) {
#line 317 "/home/bob/git/simple-scan/src/scanner.vala"
		result = 0;
#line 317 "/home/bob/git/simple-scan/src/scanner.vala"
		return result;
#line 5107 "scanner.c"
	}
#line 319 "/home/bob/git/simple-scan/src/scanner.vala"
	result = 1;
#line 319 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 5113 "scanner.c"
}


static gint
scanner_compare_devices (ScanDevice* device1,
                         ScanDevice* device2)
{
	gint result = 0;
	gint weight1 = 0;
	const gchar* _tmp0_;
	gint weight2 = 0;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GCompareFunc _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
#line 322 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (device1 != NULL, 0);
#line 322 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (device2 != NULL, 0);
#line 326 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = device1->name;
#line 326 "/home/bob/git/simple-scan/src/scanner.vala"
	weight1 = scanner_get_device_weight (_tmp0_);
#line 327 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = device2->name;
#line 327 "/home/bob/git/simple-scan/src/scanner.vala"
	weight2 = scanner_get_device_weight (_tmp1_);
#line 328 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = weight1;
#line 328 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = weight2;
#line 328 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp2_ != _tmp3_) {
#line 5149 "scanner.c"
		gint _tmp4_;
		gint _tmp5_;
#line 329 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = weight1;
#line 329 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp5_ = weight2;
#line 329 "/home/bob/git/simple-scan/src/scanner.vala"
		result = _tmp4_ - _tmp5_;
#line 329 "/home/bob/git/simple-scan/src/scanner.vala"
		return result;
#line 5160 "scanner.c"
	}
#line 331 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp6_ = g_strcmp0;
#line 331 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp7_ = device1->label;
#line 331 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp8_ = device2->label;
#line 331 "/home/bob/git/simple-scan/src/scanner.vala"
	result = _tmp6_ (_tmp7_, _tmp8_);
#line 331 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 5172 "scanner.c"
}


static gchar*
sane_status_to_string (SANE_Status status)
{
	gchar* result = NULL;
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
	switch (status) {
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_GOOD:
#line 5184 "scanner.c"
		{
			gchar* _tmp0_;
#line 57 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp0_ = g_strdup ("SANE_STATUS_GOOD");
#line 57 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp0_;
#line 57 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5193 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_UNSUPPORTED:
#line 5197 "scanner.c"
		{
			gchar* _tmp1_;
#line 59 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_STATUS_UNSUPPORTED");
#line 59 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp1_;
#line 59 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5206 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_CANCELLED:
#line 5210 "scanner.c"
		{
			gchar* _tmp2_;
#line 61 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_STATUS_CANCELLED");
#line 61 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp2_;
#line 61 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5219 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_DEVICE_BUSY:
#line 5223 "scanner.c"
		{
			gchar* _tmp3_;
#line 63 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_STATUS_DEVICE_BUSY");
#line 63 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp3_;
#line 63 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5232 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_INVAL:
#line 5236 "scanner.c"
		{
			gchar* _tmp4_;
#line 65 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_STATUS_INVAL");
#line 65 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp4_;
#line 65 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5245 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_EOF:
#line 5249 "scanner.c"
		{
			gchar* _tmp5_;
#line 67 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_STATUS_EOF");
#line 67 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp5_;
#line 67 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5258 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_JAMMED:
#line 5262 "scanner.c"
		{
			gchar* _tmp6_;
#line 69 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp6_ = g_strdup ("SANE_STATUS_JAMMED");
#line 69 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp6_;
#line 69 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5271 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_NO_DOCS:
#line 5275 "scanner.c"
		{
			gchar* _tmp7_;
#line 71 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp7_ = g_strdup ("SANE_STATUS_NO_DOCS");
#line 71 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp7_;
#line 71 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5284 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_COVER_OPEN:
#line 5288 "scanner.c"
		{
			gchar* _tmp8_;
#line 73 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp8_ = g_strdup ("SANE_STATUS_COVER_OPEN");
#line 73 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp8_;
#line 73 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5297 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_IO_ERROR:
#line 5301 "scanner.c"
		{
			gchar* _tmp9_;
#line 75 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp9_ = g_strdup ("SANE_STATUS_IO_ERROR");
#line 75 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp9_;
#line 75 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5310 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_NO_MEM:
#line 5314 "scanner.c"
		{
			gchar* _tmp10_;
#line 77 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp10_ = g_strdup ("SANE_STATUS_NO_MEM");
#line 77 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp10_;
#line 77 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5323 "scanner.c"
		}
#line 54 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_STATUS_ACCESS_DENIED:
#line 5327 "scanner.c"
		{
			gchar* _tmp11_;
#line 79 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp11_ = g_strdup ("SANE_STATUS_ACCESS_DENIED");
#line 79 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp11_;
#line 79 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5336 "scanner.c"
		}
		default:
		{
			gchar* _tmp12_;
#line 81 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp12_ = g_strdup_printf ("SANE_STATUS(%d)", (gint) status);
#line 81 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp12_;
#line 81 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 5347 "scanner.c"
		}
	}
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 1477 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1477 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1477 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1478 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1478 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 5372 "scanner.c"
	} else {
#line 1478 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 5376 "scanner.c"
	}
#line 1478 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_) {
#line 1478 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 5382 "scanner.c"
	} else {
#line 1478 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 5386 "scanner.c"
	}
#line 1478 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 5390 "scanner.c"
		gchar* _tmp2_;
#line 1479 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1479 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp2_;
#line 1479 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 5398 "scanner.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		regex = _tmp6_;
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 5426 "scanner.c"
				goto __catch15_g_regex_error;
			}
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1482 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 5435 "scanner.c"
		}
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp8_ = regex;
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 5449 "scanner.c"
				goto __catch15_g_regex_error;
			}
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
			return NULL;
#line 5460 "scanner.c"
		}
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = _tmp10_;
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1483 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 5474 "scanner.c"
	}
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError* e = NULL;
#line 1481 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1481 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1485 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1481 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 5488 "scanner.c"
	}
	__finally15:
#line 1481 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1481 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1481 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1481 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return NULL;
#line 5499 "scanner.c"
	}
}


static gpointer
_scan_device_ref0 (gpointer self)
{
#line 365 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? scan_device_ref (self) : NULL;
#line 5509 "scanner.c"
}


static gint
_scanner_compare_devices_gcompare_func (gconstpointer a,
                                        gconstpointer b)
{
	gint result;
	result = scanner_compare_devices ((ScanDevice*) a, (ScanDevice*) b);
#line 369 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 5521 "scanner.c"
}


static void
scanner_do_redetect (Scanner* self)
{
	SANE_Device** device_list = NULL;
	gint device_list_length1;
	gint _device_list_size_;
	SANE_Status status = 0;
	SANE_Device** _tmp0_ = NULL;
	SANE_Status _tmp1_;
	SANE_Status _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SANE_Status _tmp5_;
	GList* devices = NULL;
	GList* _tmp56_;
	GList* _tmp63_;
	NotifyUpdateDevices* _tmp64_;
	NotifyUpdateDevices* _tmp65_;
#line 334 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/bob/git/simple-scan/src/scanner.vala"
	device_list = NULL;
#line 336 "/home/bob/git/simple-scan/src/scanner.vala"
	device_list_length1 = 0;
#line 336 "/home/bob/git/simple-scan/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 337 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = sane_get_devices (&_tmp0_, FALSE);
#line 337 "/home/bob/git/simple-scan/src/scanner.vala"
	device_list = _tmp0_;
#line 337 "/home/bob/git/simple-scan/src/scanner.vala"
	device_list_length1 = -1;
#line 337 "/home/bob/git/simple-scan/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 337 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp1_;
#line 338 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = status;
#line 338 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 338 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 338 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:338: sane_get_devices () -> %s", _tmp4_);
#line 338 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 339 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = status;
#line 339 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 5575 "scanner.c"
		SANE_Status _tmp6_;
		const gchar* _tmp7_;
#line 341 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp6_ = status;
#line 341 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 341 "/home/bob/git/simple-scan/src/scanner.vala"
		g_warning ("scanner.vala:341: Unable to get SANE devices: %s", _tmp7_);
#line 342 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->need_redetect = FALSE;
#line 343 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->state = SCAN_STATE_IDLE;
#line 344 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 5590 "scanner.c"
	}
#line 347 "/home/bob/git/simple-scan/src/scanner.vala"
	devices = NULL;
#line 5594 "scanner.c"
	{
		gint i = 0;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
		i = 0;
#line 5599 "scanner.c"
		{
			gboolean _tmp8_ = FALSE;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp8_ = TRUE;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
			while (TRUE) {
#line 5606 "scanner.c"
				SANE_Device** _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				SANE_Device* _tmp12_;
				SANE_Device** _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				SANE_Device* _tmp15_;
				const gchar* _tmp16_;
				SANE_Device** _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				SANE_Device* _tmp19_;
				const gchar* _tmp20_;
				SANE_Device** _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				SANE_Device* _tmp23_;
				const gchar* _tmp24_;
				SANE_Device** _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				SANE_Device* _tmp27_;
				const gchar* _tmp28_;
				ScanDevice* scan_device = NULL;
				ScanDevice* _tmp29_;
				ScanDevice* _tmp30_;
				SANE_Device** _tmp31_;
				gint _tmp31__length1;
				gint _tmp32_;
				SANE_Device* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* vendor = NULL;
				SANE_Device** _tmp36_;
				gint _tmp36__length1;
				gint _tmp37_;
				SANE_Device* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				const gchar* _tmp41_;
				ScanDevice* _tmp43_;
				const gchar* _tmp44_;
				SANE_Device** _tmp45_;
				gint _tmp45__length1;
				gint _tmp46_;
				SANE_Device* _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				ScanDevice* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				ScanDevice* _tmp54_;
				ScanDevice* _tmp55_;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				if (!_tmp8_) {
#line 5664 "scanner.c"
					gint _tmp9_;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp9_ = i;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
					i = _tmp9_ + 1;
#line 5670 "scanner.c"
				}
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp8_ = FALSE;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp10_ = device_list;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp10__length1 = device_list_length1;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp11_ = i;
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				if (!(_tmp12_ != NULL)) {
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 5686 "scanner.c"
				}
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp13_ = device_list;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp13__length1 = device_list_length1;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp14_ = i;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp15_ = _tmp13_[_tmp14_];
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp16_ = _tmp15_->name;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp17_ = device_list;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp17__length1 = device_list_length1;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp18_ = i;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp19_ = _tmp17_[_tmp18_];
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp20_ = _tmp19_->vendor;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp21_ = device_list;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp21__length1 = device_list_length1;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp22_ = i;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp24_ = _tmp23_->model;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp25_ = device_list;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp25__length1 = device_list_length1;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp26_ = i;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp27_ = _tmp25_[_tmp26_];
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp28_ = _tmp27_->type;
#line 350 "/home/bob/git/simple-scan/src/scanner.vala"
				g_debug ("scanner.vala:350: Device: name=\"%s\" vendor=\"%s\" model=\"%s\" type=" \
"\"%s\"", _tmp16_, _tmp20_, _tmp24_, _tmp28_);
#line 353 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp29_ = scan_device_new ();
#line 353 "/home/bob/git/simple-scan/src/scanner.vala"
				scan_device = _tmp29_;
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp30_ = scan_device;
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp31_ = device_list;
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp31__length1 = device_list_length1;
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp32_ = i;
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp34_ = _tmp33_->name;
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp35_ = g_strdup (_tmp34_);
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (_tmp30_->name);
#line 354 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp30_->name = _tmp35_;
#line 357 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp36_ = device_list;
#line 357 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp36__length1 = device_list_length1;
#line 357 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp37_ = i;
#line 357 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp38_ = _tmp36_[_tmp37_];
#line 357 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp39_ = _tmp38_->vendor;
#line 357 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp40_ = g_strdup (_tmp39_);
#line 357 "/home/bob/git/simple-scan/src/scanner.vala"
				vendor = _tmp40_;
#line 358 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp41_ = vendor;
#line 358 "/home/bob/git/simple-scan/src/scanner.vala"
				if (g_strcmp0 (_tmp41_, "Hewlett-Packard") == 0) {
#line 5770 "scanner.c"
					gchar* _tmp42_;
#line 359 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp42_ = g_strdup ("HP");
#line 359 "/home/bob/git/simple-scan/src/scanner.vala"
					_g_free0 (vendor);
#line 359 "/home/bob/git/simple-scan/src/scanner.vala"
					vendor = _tmp42_;
#line 5778 "scanner.c"
				}
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp43_ = scan_device;
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp44_ = vendor;
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp45_ = device_list;
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp45__length1 = device_list_length1;
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp46_ = i;
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp47_ = _tmp45_[_tmp46_];
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp48_ = _tmp47_->model;
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp49_ = g_strdup_printf ("%s %s", _tmp44_, _tmp48_);
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (_tmp43_->label);
#line 361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp43_->label = _tmp49_;
#line 363 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp50_ = scan_device;
#line 363 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp51_ = _tmp50_->label;
#line 363 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp52_ = string_replace (_tmp51_, "_", " ");
#line 363 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp53_ = _tmp52_;
#line 363 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (_tmp53_);
#line 365 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp54_ = scan_device;
#line 365 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp55_ = _scan_device_ref0 (_tmp54_);
#line 365 "/home/bob/git/simple-scan/src/scanner.vala"
				devices = g_list_append (devices, _tmp55_);
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (vendor);
#line 348 "/home/bob/git/simple-scan/src/scanner.vala"
				_scan_device_unref0 (scan_device);
#line 5820 "scanner.c"
			}
		}
	}
#line 369 "/home/bob/git/simple-scan/src/scanner.vala"
	devices = g_list_sort (devices, _scanner_compare_devices_gcompare_func);
#line 371 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->need_redetect = FALSE;
#line 372 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 374 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp56_ = devices;
#line 374 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp56_ != NULL) {
#line 5834 "scanner.c"
		ScanDevice* device = NULL;
		GList* _tmp57_;
		gconstpointer _tmp58_;
		ScanDevice* _tmp59_;
		ScanDevice* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
#line 376 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp57_ = devices;
#line 376 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp58_ = g_list_nth_data (_tmp57_, (guint) 0);
#line 376 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp59_ = _scan_device_ref0 ((ScanDevice*) _tmp58_);
#line 376 "/home/bob/git/simple-scan/src/scanner.vala"
		device = _tmp59_;
#line 377 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp60_ = device;
#line 377 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp61_ = _tmp60_->name;
#line 377 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp62_ = g_strdup (_tmp61_);
#line 377 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 377 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->default_device = _tmp62_;
#line 374 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_device_unref0 (device);
#line 5862 "scanner.c"
	} else {
#line 380 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 380 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->default_device = NULL;
#line 5868 "scanner.c"
	}
#line 382 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp63_ = devices;
#line 382 "/home/bob/git/simple-scan/src/scanner.vala"
	devices = NULL;
#line 382 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp64_ = notify_update_devices_new (_tmp63_);
#line 382 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp65_ = _tmp64_;
#line 382 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp65_);
#line 382 "/home/bob/git/simple-scan/src/scanner.vala"
	_notify_unref0 (_tmp65_);
#line 334 "/home/bob/git/simple-scan/src/scanner.vala"
	(devices == NULL) ? NULL : (devices = (_g_list_free__scan_device_unref0_ (devices), NULL));
#line 5884 "scanner.c"
}


static gint
scanner_scale_int (Scanner* self,
                   gint source_min,
                   gint source_max,
                   SANE_Option_Descriptor* option,
                   gint value)
{
	gint result = 0;
	gint v = 0;
	SANE_Value_Type _tmp0_;
	gboolean _tmp1_ = FALSE;
	SANE_Constraint_Type _tmp2_;
#line 385 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 385 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0);
#line 387 "/home/bob/git/simple-scan/src/scanner.vala"
	v = value;
#line 389 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->type;
#line 389 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (_tmp0_ == SANE_TYPE_INT, value);
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = option->constraint_type;
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp2_ == SANE_CONSTRAINT_RANGE) {
#line 5914 "scanner.c"
		SANE_Range* _tmp3_;
		SANE_Word _tmp4_;
		SANE_Range* _tmp5_;
		SANE_Word _tmp6_;
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = option->constraint.range;
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = _tmp3_->max;
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp5_ = option->constraint.range;
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp6_ = _tmp5_->min;
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp1_ = _tmp4_ != _tmp6_;
#line 5929 "scanner.c"
	} else {
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp1_ = FALSE;
#line 5933 "scanner.c"
	}
#line 391 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp1_) {
#line 5937 "scanner.c"
		gint _tmp7_;
		gint _tmp8_;
		SANE_Range* _tmp9_;
		SANE_Word _tmp10_;
		SANE_Range* _tmp11_;
		SANE_Word _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		SANE_Range* _tmp15_;
		SANE_Word _tmp16_;
		gint _tmp17_;
		SANE_Range* _tmp18_;
		SANE_Word _tmp19_;
		SANE_Range* _tmp20_;
		SANE_Word _tmp21_;
#line 393 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_ = v;
#line 393 "/home/bob/git/simple-scan/src/scanner.vala"
		v = _tmp7_ - source_min;
#line 394 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp8_ = v;
#line 394 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp9_ = option->constraint.range;
#line 394 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp10_ = _tmp9_->max;
#line 394 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp11_ = option->constraint.range;
#line 394 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp12_ = _tmp11_->min;
#line 394 "/home/bob/git/simple-scan/src/scanner.vala"
		v = _tmp8_ * ((gint) (_tmp10_ - _tmp12_));
#line 395 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp13_ = v;
#line 395 "/home/bob/git/simple-scan/src/scanner.vala"
		v = _tmp13_ / (source_max - source_min);
#line 396 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp14_ = v;
#line 396 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp15_ = option->constraint.range;
#line 396 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp16_ = _tmp15_->min;
#line 396 "/home/bob/git/simple-scan/src/scanner.vala"
		v = _tmp14_ + ((gint) _tmp16_);
#line 397 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp17_ = v;
#line 397 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp18_ = option->constraint.range;
#line 397 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp19_ = _tmp18_->min;
#line 397 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp20_ = option->constraint.range;
#line 397 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp21_ = _tmp20_->max;
#line 397 "/home/bob/git/simple-scan/src/scanner.vala"
		g_debug ("scanner.vala:397: scale_int: scaling %d [min: %d, max: %d] to %d [min:" \
" %d, max: %d]", value, source_min, source_max, _tmp17_, (gint) _tmp19_, (gint) _tmp21_);
#line 5993 "scanner.c"
	}
#line 401 "/home/bob/git/simple-scan/src/scanner.vala"
	result = v;
#line 401 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 5999 "scanner.c"
}


static gboolean
scanner_set_default_option (Scanner* self,
                            SANE_Handle handle,
                            SANE_Option_Descriptor* option,
                            SANE_Int option_index)
{
	gboolean result = FALSE;
	SANE_Int _tmp0_;
	SANE_Status status = 0;
	SANE_Status _tmp1_;
	SANE_Status _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SANE_Status _tmp5_;
	SANE_Status _tmp9_;
#line 404 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 404 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 407 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->cap;
#line 407 "/home/bob/git/simple-scan/src/scanner.vala"
	if ((_tmp0_ & SANE_CAP_AUTOMATIC) == ((SANE_Int) 0)) {
#line 408 "/home/bob/git/simple-scan/src/scanner.vala"
		result = FALSE;
#line 408 "/home/bob/git/simple-scan/src/scanner.vala"
		return result;
#line 6030 "scanner.c"
	}
#line 410 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = sane_control_option (handle, option_index, SANE_ACTION_SET_AUTO, NULL, NULL);
#line 410 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp1_;
#line 411 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = status;
#line 411 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 411 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 411 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:411: sane_control_option (%d, SANE_ACTION_SET_AUTO) -> %s", (gint) option_index, _tmp4_);
#line 411 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 412 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = status;
#line 412 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 6050 "scanner.c"
		const gchar* _tmp6_;
		SANE_Status _tmp7_;
		const gchar* _tmp8_;
#line 413 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp6_ = option->name;
#line 413 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_ = status;
#line 413 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp8_ = sane_strstatus (_tmp7_);
#line 413 "/home/bob/git/simple-scan/src/scanner.vala"
		g_warning ("scanner.vala:413: Error setting default option %s: %s", _tmp6_, _tmp8_);
#line 6062 "scanner.c"
	}
#line 415 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp9_ = status;
#line 415 "/home/bob/git/simple-scan/src/scanner.vala"
	result = _tmp9_ == SANE_STATUS_GOOD;
#line 415 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 6070 "scanner.c"
}


static void
scanner_set_bool_option (Scanner* self,
                         SANE_Handle handle,
                         SANE_Option_Descriptor* option,
                         SANE_Int option_index,
                         gboolean value,
                         gboolean* _result_)
{
	gboolean _vala_result = FALSE;
	SANE_Value_Type _tmp0_;
	SANE_Bool v = {0};
	SANE_Status status = 0;
	SANE_Status _tmp1_;
	SANE_Bool _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_;
	SANE_Status _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 418 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 418 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 420 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->type;
#line 420 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (_tmp0_ == SANE_TYPE_BOOL);
#line 422 "/home/bob/git/simple-scan/src/scanner.vala"
	v = (SANE_Bool) value;
#line 423 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v, NULL);
#line 423 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp1_;
#line 424 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = v;
#line 424 "/home/bob/git/simple-scan/src/scanner.vala"
	_vala_result = (gboolean) _tmp2_;
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value) {
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = "SANE_TRUE";
#line 6116 "scanner.c"
	} else {
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = "SANE_FALSE";
#line 6120 "scanner.c"
	}
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = _vala_result;
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp5_) {
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = "SANE_TRUE";
#line 6128 "scanner.c"
	} else {
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = "SANE_FALSE";
#line 6132 "scanner.c"
	}
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp6_ = status;
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:425: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s) " \
"-> (%s, %s)", (gint) option_index, _tmp3_, _tmp8_, _tmp4_);
#line 425 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 418 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_result_) {
#line 418 "/home/bob/git/simple-scan/src/scanner.vala"
		*_result_ = _vala_result;
#line 6148 "scanner.c"
	}
}


static void
scanner_set_int_option (Scanner* self,
                        SANE_Handle handle,
                        SANE_Option_Descriptor* option,
                        SANE_Int option_index,
                        gint value,
                        gint* _result_)
{
	gint _vala_result = 0;
	SANE_Value_Type _tmp0_;
	SANE_Int v = {0};
	SANE_Constraint_Type _tmp1_;
	SANE_Status status = 0;
	SANE_Status _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	SANE_Int _tmp37_;
	SANE_Int _tmp38_;
#line 428 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 428 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 430 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->type;
#line 430 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (_tmp0_ == SANE_TYPE_INT);
#line 432 "/home/bob/git/simple-scan/src/scanner.vala"
	v = (SANE_Int) value;
#line 433 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = option->constraint_type;
#line 433 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp1_ == SANE_CONSTRAINT_RANGE) {
#line 6185 "scanner.c"
		SANE_Range* _tmp2_;
		SANE_Word _tmp3_;
		SANE_Int _tmp7_;
		SANE_Range* _tmp8_;
		SANE_Word _tmp9_;
		SANE_Int _tmp12_;
		SANE_Range* _tmp13_;
		SANE_Word _tmp14_;
#line 435 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp2_ = option->constraint.range;
#line 435 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = _tmp2_->quant;
#line 435 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp3_ != ((SANE_Word) 0)) {
#line 6200 "scanner.c"
			SANE_Int _tmp4_;
			SANE_Range* _tmp5_;
			SANE_Word _tmp6_;
#line 436 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp4_ = v;
#line 436 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp5_ = option->constraint.range;
#line 436 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp6_ = _tmp5_->quant;
#line 436 "/home/bob/git/simple-scan/src/scanner.vala"
			v = _tmp4_ * _tmp6_;
#line 6212 "scanner.c"
		}
#line 437 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_ = v;
#line 437 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp8_ = option->constraint.range;
#line 437 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp9_ = _tmp8_->min;
#line 437 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp7_ < ((SANE_Int) _tmp9_)) {
#line 6222 "scanner.c"
			SANE_Range* _tmp10_;
			SANE_Word _tmp11_;
#line 438 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp10_ = option->constraint.range;
#line 438 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp11_ = _tmp10_->min;
#line 438 "/home/bob/git/simple-scan/src/scanner.vala"
			v = (SANE_Int) _tmp11_;
#line 6231 "scanner.c"
		}
#line 439 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp12_ = v;
#line 439 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp13_ = option->constraint.range;
#line 439 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp14_ = _tmp13_->max;
#line 439 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp12_ > ((SANE_Int) _tmp14_)) {
#line 6241 "scanner.c"
			SANE_Range* _tmp15_;
			SANE_Word _tmp16_;
#line 440 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp15_ = option->constraint.range;
#line 440 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp16_ = _tmp15_->max;
#line 440 "/home/bob/git/simple-scan/src/scanner.vala"
			v = (SANE_Int) _tmp16_;
#line 6250 "scanner.c"
		}
	} else {
		SANE_Constraint_Type _tmp17_;
#line 442 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp17_ = option->constraint_type;
#line 442 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp17_ == SANE_CONSTRAINT_WORD_LIST) {
#line 6258 "scanner.c"
			gint distance = 0;
			gint nearest = 0;
			gint _tmp33_;
#line 444 "/home/bob/git/simple-scan/src/scanner.vala"
			distance = G_MAXINT;
#line 444 "/home/bob/git/simple-scan/src/scanner.vala"
			nearest = 0;
#line 6266 "scanner.c"
			{
				gint i = 0;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
				i = 0;
#line 6271 "scanner.c"
				{
					gboolean _tmp18_ = FALSE;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp18_ = TRUE;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
					while (TRUE) {
#line 6278 "scanner.c"
						gint _tmp20_;
						SANE_Word* _tmp21_;
						gint _tmp21__length1;
						SANE_Word _tmp22_;
						gint x = 0;
						SANE_Word* _tmp23_;
						gint _tmp23__length1;
						gint _tmp24_;
						SANE_Word _tmp25_;
						gint d = 0;
						gint _tmp26_;
						SANE_Int _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp18_) {
#line 6296 "scanner.c"
							gint _tmp19_;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp19_ = i;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
							i = _tmp19_ + 1;
#line 6302 "scanner.c"
						}
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp18_ = FALSE;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp20_ = i;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp21_ = option->constraint.word_list;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp21__length1 = -1;
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp22_ = _tmp21_[0];
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!(((SANE_Word) _tmp20_) < _tmp22_)) {
#line 447 "/home/bob/git/simple-scan/src/scanner.vala"
							break;
#line 6318 "scanner.c"
						}
#line 449 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp23_ = option->constraint.word_list;
#line 449 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp23__length1 = -1;
#line 449 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp24_ = i;
#line 449 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp25_ = _tmp23_[_tmp24_ + 1];
#line 449 "/home/bob/git/simple-scan/src/scanner.vala"
						x = (gint) _tmp25_;
#line 450 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp26_ = x;
#line 450 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp27_ = v;
#line 450 "/home/bob/git/simple-scan/src/scanner.vala"
						d = (gint) (_tmp26_ - _tmp27_);
#line 451 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp28_ = d;
#line 451 "/home/bob/git/simple-scan/src/scanner.vala"
						d = abs (_tmp28_);
#line 452 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp29_ = d;
#line 452 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp30_ = distance;
#line 452 "/home/bob/git/simple-scan/src/scanner.vala"
						if (_tmp29_ < _tmp30_) {
#line 6346 "scanner.c"
							gint _tmp31_;
							gint _tmp32_;
#line 454 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp31_ = d;
#line 454 "/home/bob/git/simple-scan/src/scanner.vala"
							distance = _tmp31_;
#line 455 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp32_ = x;
#line 455 "/home/bob/git/simple-scan/src/scanner.vala"
							nearest = _tmp32_;
#line 6357 "scanner.c"
						}
					}
				}
			}
#line 458 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp33_ = nearest;
#line 458 "/home/bob/git/simple-scan/src/scanner.vala"
			v = (SANE_Int) _tmp33_;
#line 6366 "scanner.c"
		}
	}
#line 461 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp34_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v, NULL);
#line 461 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp34_;
#line 462 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp35_ = sane_status_to_string (status);
#line 462 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp36_ = _tmp35_;
#line 462 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp37_ = v;
#line 462 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:462: sane_control_option (%d, SANE_ACTION_SET_VALUE, %d) " \
"-> (%s, %d)", (gint) option_index, value, _tmp36_, (gint) _tmp37_);
#line 462 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp36_);
#line 463 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp38_ = v;
#line 463 "/home/bob/git/simple-scan/src/scanner.vala"
	_vala_result = (gint) _tmp38_;
#line 428 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_result_) {
#line 428 "/home/bob/git/simple-scan/src/scanner.vala"
		*_result_ = _vala_result;
#line 6391 "scanner.c"
	}
}


static void
scanner_set_fixed_option (Scanner* self,
                          SANE_Handle handle,
                          SANE_Option_Descriptor* option,
                          SANE_Int option_index,
                          gdouble value,
                          gdouble* _result_)
{
	gdouble _vala_result = 0.0;
	gdouble v = 0.0;
	SANE_Fixed v_fixed = {0};
	SANE_Value_Type _tmp0_;
	SANE_Constraint_Type _tmp1_;
	gdouble _tmp28_;
	SANE_Status status = 0;
	SANE_Status _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
#line 466 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 466 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 468 "/home/bob/git/simple-scan/src/scanner.vala"
	v = value;
#line 471 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->type;
#line 471 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (_tmp0_ == SANE_TYPE_FIXED);
#line 473 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = option->constraint_type;
#line 473 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp1_ == SANE_CONSTRAINT_RANGE) {
#line 6428 "scanner.c"
		gdouble min = 0.0;
		SANE_Range* _tmp2_;
		SANE_Word _tmp3_;
		gdouble max = 0.0;
		SANE_Range* _tmp4_;
		SANE_Word _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp9_;
		gdouble _tmp10_;
#line 475 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp2_ = option->constraint.range;
#line 475 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = _tmp2_->min;
#line 475 "/home/bob/git/simple-scan/src/scanner.vala"
		min = SANE_UNFIX ((SANE_Fixed) _tmp3_);
#line 476 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = option->constraint.range;
#line 476 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp5_ = _tmp4_->max;
#line 476 "/home/bob/git/simple-scan/src/scanner.vala"
		max = SANE_UNFIX ((SANE_Fixed) _tmp5_);
#line 478 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp6_ = v;
#line 478 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_ = min;
#line 478 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp6_ < _tmp7_) {
#line 6457 "scanner.c"
			gdouble _tmp8_;
#line 479 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp8_ = min;
#line 479 "/home/bob/git/simple-scan/src/scanner.vala"
			v = _tmp8_;
#line 6463 "scanner.c"
		}
#line 480 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp9_ = v;
#line 480 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp10_ = max;
#line 480 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp9_ > _tmp10_) {
#line 6471 "scanner.c"
			gdouble _tmp11_;
#line 481 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp11_ = max;
#line 481 "/home/bob/git/simple-scan/src/scanner.vala"
			v = _tmp11_;
#line 6477 "scanner.c"
		}
	} else {
		SANE_Constraint_Type _tmp12_;
#line 483 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp12_ = option->constraint_type;
#line 483 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp12_ == SANE_CONSTRAINT_WORD_LIST) {
#line 6485 "scanner.c"
			gdouble distance = 0.0;
			gdouble nearest = 0.0;
			gdouble _tmp27_;
#line 485 "/home/bob/git/simple-scan/src/scanner.vala"
			distance = DBL_MAX;
#line 485 "/home/bob/git/simple-scan/src/scanner.vala"
			nearest = 0.0;
#line 6493 "scanner.c"
			{
				gint i = 0;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
				i = 0;
#line 6498 "scanner.c"
				{
					gboolean _tmp13_ = FALSE;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp13_ = TRUE;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
					while (TRUE) {
#line 6505 "scanner.c"
						gint _tmp15_;
						SANE_Word* _tmp16_;
						gint _tmp16__length1;
						SANE_Word _tmp17_;
						gdouble x = 0.0;
						SANE_Word* _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						SANE_Word _tmp20_;
						gdouble _tmp21_;
						gdouble _tmp22_;
						gdouble _tmp23_;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp13_) {
#line 6520 "scanner.c"
							gint _tmp14_;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp14_ = i;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
							i = _tmp14_ + 1;
#line 6526 "scanner.c"
						}
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp13_ = FALSE;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp15_ = i;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp16_ = option->constraint.word_list;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp16__length1 = -1;
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp17_ = _tmp16_[0];
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!(((SANE_Word) _tmp15_) < _tmp17_)) {
#line 488 "/home/bob/git/simple-scan/src/scanner.vala"
							break;
#line 6542 "scanner.c"
						}
#line 490 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp18_ = option->constraint.word_list;
#line 490 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp18__length1 = -1;
#line 490 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp19_ = i;
#line 490 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp20_ = _tmp18_[_tmp19_ + 1];
#line 490 "/home/bob/git/simple-scan/src/scanner.vala"
						x = SANE_UNFIX ((SANE_Fixed) _tmp20_);
#line 491 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp21_ = x;
#line 491 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp22_ = v;
#line 491 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp23_ = distance;
#line 491 "/home/bob/git/simple-scan/src/scanner.vala"
						if (fabs (_tmp21_ - _tmp22_) < _tmp23_) {
#line 6562 "scanner.c"
							gdouble _tmp24_;
							gdouble _tmp25_;
							gdouble _tmp26_;
#line 493 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp24_ = x;
#line 493 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp25_ = v;
#line 493 "/home/bob/git/simple-scan/src/scanner.vala"
							distance = fabs (_tmp24_ - _tmp25_);
#line 494 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp26_ = x;
#line 494 "/home/bob/git/simple-scan/src/scanner.vala"
							nearest = _tmp26_;
#line 6576 "scanner.c"
						}
					}
				}
			}
#line 497 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp27_ = nearest;
#line 497 "/home/bob/git/simple-scan/src/scanner.vala"
			v = _tmp27_;
#line 6585 "scanner.c"
		}
	}
#line 500 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp28_ = v;
#line 500 "/home/bob/git/simple-scan/src/scanner.vala"
	v_fixed = SANE_FIX (_tmp28_);
#line 501 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp29_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &v_fixed, NULL);
#line 501 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp29_;
#line 502 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp30_ = sane_status_to_string (status);
#line 502 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp31_ = _tmp30_;
#line 502 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:502: sane_control_option (%d, SANE_ACTION_SET_VALUE, %f) " \
"-> (%s, %f)", (gint) option_index, value, _tmp31_, SANE_UNFIX (v_fixed));
#line 502 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp31_);
#line 504 "/home/bob/git/simple-scan/src/scanner.vala"
	_vala_result = SANE_UNFIX (v_fixed);
#line 466 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_result_) {
#line 466 "/home/bob/git/simple-scan/src/scanner.vala"
		*_result_ = _vala_result;
#line 6610 "scanner.c"
	}
}


static void
scanner_set_fixed_or_int_option (Scanner* self,
                                 SANE_Handle handle,
                                 SANE_Option_Descriptor* option,
                                 SANE_Int option_index,
                                 gdouble value,
                                 gdouble* _result_)
{
	gdouble _vala_result = 0.0;
	SANE_Value_Type _tmp0_;
#line 507 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 507 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 509 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->type;
#line 509 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_ == SANE_TYPE_FIXED) {
#line 6633 "scanner.c"
		gdouble _tmp1_ = 0.0;
#line 510 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_set_fixed_option (self, handle, option, option_index, value, &_tmp1_);
#line 510 "/home/bob/git/simple-scan/src/scanner.vala"
		_vala_result = _tmp1_;
#line 6639 "scanner.c"
	} else {
		SANE_Value_Type _tmp2_;
#line 511 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp2_ = option->type;
#line 511 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp2_ == SANE_TYPE_INT) {
#line 6646 "scanner.c"
			gint r = 0;
			gint _tmp3_ = 0;
			gint _tmp4_;
#line 514 "/home/bob/git/simple-scan/src/scanner.vala"
			scanner_set_int_option (self, handle, option, option_index, (gint) round (value), &_tmp3_);
#line 514 "/home/bob/git/simple-scan/src/scanner.vala"
			r = _tmp3_;
#line 515 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp4_ = r;
#line 515 "/home/bob/git/simple-scan/src/scanner.vala"
			_vala_result = (gdouble) _tmp4_;
#line 6658 "scanner.c"
		} else {
#line 519 "/home/bob/git/simple-scan/src/scanner.vala"
			_vala_result = 0.0;
#line 520 "/home/bob/git/simple-scan/src/scanner.vala"
			g_warning ("scanner.vala:520: Unable to set unsupported option type");
#line 6664 "scanner.c"
		}
	}
#line 507 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_result_) {
#line 507 "/home/bob/git/simple-scan/src/scanner.vala"
		*_result_ = _vala_result;
#line 6671 "scanner.c"
	}
}


static void
scanner_set_option_to_max (Scanner* self,
                           SANE_Handle handle,
                           SANE_Option_Descriptor* option,
                           SANE_Int option_index)
{
	SANE_Constraint_Type _tmp0_;
	SANE_Status status = 0;
	SANE_Range* _tmp1_;
	SANE_Status _tmp2_;
	SANE_Status _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 524 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 524 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 526 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->constraint_type;
#line 526 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_ != SANE_CONSTRAINT_RANGE) {
#line 527 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 6699 "scanner.c"
	}
#line 529 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = option->constraint.range;
#line 529 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, &_tmp1_->max, NULL);
#line 529 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp2_;
#line 530 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = status;
#line 530 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = sane_status_to_string (_tmp3_);
#line 530 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = _tmp4_;
#line 530 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:530: sane_control_option (%d, SANE_ACTION_SET_VALUE, opti" \
"on.range.max) -> (%s)", (gint) option_index, _tmp5_);
#line 530 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp5_);
#line 6717 "scanner.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1180 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 6735 "scanner.c"
}


static gboolean
scanner_set_string_option (Scanner* self,
                           SANE_Handle handle,
                           SANE_Option_Descriptor* option,
                           SANE_Int option_index,
                           const gchar* value,
                           gchar* * _result_)
{
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_;
	SANE_Value_Type _tmp1_;
	gchar* s = NULL;
	SANE_Int _tmp2_;
	gchar* _tmp3_;
	gint s_length1;
	gint _s_size_;
	gint i = 0;
	gchar* _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_;
	gchar _tmp16_;
	SANE_Status status = 0;
	gchar* _tmp17_;
	gint _tmp17__length1;
	SANE_Status _tmp18_;
	gchar* _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
#line 533 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 533 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 533 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (value != NULL, FALSE);
#line 535 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = g_strdup ("");
#line 535 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_vala_result);
#line 535 "/home/bob/git/simple-scan/src/scanner.vala"
	_vala_result = _tmp0_;
#line 537 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = option->type;
#line 537 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (_tmp1_ == SANE_TYPE_STRING, FALSE);
#line 539 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = option->size;
#line 539 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = g_new0 (gchar, _tmp2_);
#line 539 "/home/bob/git/simple-scan/src/scanner.vala"
	s = _tmp3_;
#line 539 "/home/bob/git/simple-scan/src/scanner.vala"
	s_length1 = _tmp2_;
#line 539 "/home/bob/git/simple-scan/src/scanner.vala"
	_s_size_ = s_length1;
#line 540 "/home/bob/git/simple-scan/src/scanner.vala"
	i = 0;
#line 6799 "scanner.c"
	{
		gboolean _tmp4_ = FALSE;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = TRUE;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
		while (TRUE) {
#line 6806 "scanner.c"
			gboolean _tmp6_ = FALSE;
			gint _tmp7_;
			SANE_Int _tmp8_;
			gchar* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gint _tmp12_;
			gchar _tmp13_;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
			if (!_tmp4_) {
#line 6817 "scanner.c"
				gint _tmp5_;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp5_ = i;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
				i = _tmp5_ + 1;
#line 6823 "scanner.c"
			}
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp4_ = FALSE;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp7_ = i;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp8_ = option->size;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
			if (((SANE_Int) _tmp7_) < (_tmp8_ - 1)) {
#line 6833 "scanner.c"
				gint _tmp9_;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp9_ = i;
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp6_ = string_get (value, (glong) _tmp9_) != '\0';
#line 6839 "scanner.c"
			} else {
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp6_ = FALSE;
#line 6843 "scanner.c"
			}
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
			if (!_tmp6_) {
#line 541 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 6849 "scanner.c"
			}
#line 542 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp10_ = s;
#line 542 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp10__length1 = s_length1;
#line 542 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp11_ = i;
#line 542 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp12_ = i;
#line 542 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp10_[_tmp11_] = string_get (value, (glong) _tmp12_);
#line 542 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 6863 "scanner.c"
		}
	}
#line 543 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp14_ = s;
#line 543 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp14__length1 = s_length1;
#line 543 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp15_ = i;
#line 543 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp14_[_tmp15_] = '\0';
#line 543 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp16_ = _tmp14_[_tmp15_];
#line 544 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp17_ = s;
#line 544 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp17__length1 = s_length1;
#line 544 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp18_ = sane_control_option (handle, option_index, SANE_ACTION_SET_VALUE, _tmp17_, NULL);
#line 544 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp18_;
#line 545 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp19_ = s;
#line 545 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp19__length1 = s_length1;
#line 545 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp20_ = g_strdup ((const gchar*) _tmp19_);
#line 545 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_vala_result);
#line 545 "/home/bob/git/simple-scan/src/scanner.vala"
	_vala_result = _tmp20_;
#line 546 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp21_ = sane_status_to_string (status);
#line 546 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp22_ = _tmp21_;
#line 546 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp23_ = _vala_result;
#line 546 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:546: sane_control_option (%d, SANE_ACTION_SET_VALUE, \"%s" \
"\") -> (%s, \"%s\")", (gint) option_index, value, _tmp22_, _tmp23_);
#line 546 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp22_);
#line 548 "/home/bob/git/simple-scan/src/scanner.vala"
	result = status == SANE_STATUS_GOOD;
#line 548 "/home/bob/git/simple-scan/src/scanner.vala"
	s = (g_free (s), NULL);
#line 548 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_result_) {
#line 548 "/home/bob/git/simple-scan/src/scanner.vala"
		*_result_ = _vala_result;
#line 6912 "scanner.c"
	} else {
#line 548 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6916 "scanner.c"
	}
#line 548 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 6920 "scanner.c"
}


static gboolean
scanner_set_constrained_string_option (Scanner* self,
                                       SANE_Handle handle,
                                       SANE_Option_Descriptor* option,
                                       SANE_Int option_index,
                                       gchar** values,
                                       int values_length1,
                                       gchar* * _result_)
{
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	SANE_Value_Type _tmp0_;
	SANE_Constraint_Type _tmp1_;
	gchar* _tmp23_;
#line 551 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 551 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 553 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->type;
#line 553 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (_tmp0_ == SANE_TYPE_STRING, FALSE);
#line 554 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = option->constraint_type;
#line 554 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (_tmp1_ == SANE_CONSTRAINT_STRING_LIST, FALSE);
#line 6950 "scanner.c"
	{
		gint i = 0;
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
		i = 0;
#line 6955 "scanner.c"
		{
			gboolean _tmp2_ = FALSE;
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp2_ = TRUE;
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
			while (TRUE) {
#line 6962 "scanner.c"
				gint _tmp4_;
				const gchar* _tmp5_;
				gint j = 0;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				const gchar* _tmp18_;
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
				if (!_tmp2_) {
#line 6972 "scanner.c"
					gint _tmp3_;
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp3_ = i;
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
					i = _tmp3_ + 1;
#line 6978 "scanner.c"
				}
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp2_ = FALSE;
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp4_ = i;
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp5_ = values[_tmp4_];
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
				if (!(_tmp5_ != NULL)) {
#line 556 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 6990 "scanner.c"
				}
#line 558 "/home/bob/git/simple-scan/src/scanner.vala"
				j = 0;
#line 6994 "scanner.c"
				{
					gboolean _tmp6_ = FALSE;
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp6_ = TRUE;
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
					while (TRUE) {
#line 7001 "scanner.c"
						gchar** _tmp8_;
						gint _tmp8__length1;
						gint _tmp9_;
						const gchar* _tmp10_;
						gint _tmp11_;
						const gchar* _tmp12_;
						gchar** _tmp13_;
						gint _tmp13__length1;
						gint _tmp14_;
						const gchar* _tmp15_;
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp6_) {
#line 7014 "scanner.c"
							gint _tmp7_;
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp7_ = j;
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
							j = _tmp7_ + 1;
#line 7020 "scanner.c"
						}
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp6_ = FALSE;
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp8_ = option->constraint.string_list;
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp8__length1 = _vala_array_length (option->constraint.string_list);
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp9_ = j;
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp10_ = _tmp8_[_tmp9_];
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!(_tmp10_ != NULL)) {
#line 559 "/home/bob/git/simple-scan/src/scanner.vala"
							break;
#line 7036 "scanner.c"
						}
#line 561 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp11_ = i;
#line 561 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp12_ = values[_tmp11_];
#line 561 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp13_ = option->constraint.string_list;
#line 561 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp13__length1 = _vala_array_length (option->constraint.string_list);
#line 561 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp14_ = j;
#line 561 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp15_ = _tmp13_[_tmp14_];
#line 561 "/home/bob/git/simple-scan/src/scanner.vala"
						if (g_strcmp0 (_tmp12_, _tmp15_) == 0) {
#line 562 "/home/bob/git/simple-scan/src/scanner.vala"
							break;
#line 7054 "scanner.c"
						}
					}
				}
#line 565 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp16_ = option->constraint.string_list;
#line 565 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp16__length1 = _vala_array_length (option->constraint.string_list);
#line 565 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp17_ = j;
#line 565 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp18_ = _tmp16_[_tmp17_];
#line 565 "/home/bob/git/simple-scan/src/scanner.vala"
				if (_tmp18_ != NULL) {
#line 7068 "scanner.c"
					gint _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_ = NULL;
					gboolean _tmp22_;
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp19_ = i;
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp20_ = values[_tmp19_];
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp22_ = scanner_set_string_option (self, handle, option, option_index, _tmp20_, &_tmp21_);
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
					_g_free0 (_vala_result);
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
					_vala_result = _tmp21_;
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
					result = _tmp22_;
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
					if (_result_) {
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
						*_result_ = _vala_result;
#line 7089 "scanner.c"
					} else {
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
						_g_free0 (_vala_result);
#line 7093 "scanner.c"
					}
#line 566 "/home/bob/git/simple-scan/src/scanner.vala"
					return result;
#line 7097 "scanner.c"
				}
			}
		}
	}
#line 569 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp23_ = g_strdup ("");
#line 569 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_vala_result);
#line 569 "/home/bob/git/simple-scan/src/scanner.vala"
	_vala_result = _tmp23_;
#line 570 "/home/bob/git/simple-scan/src/scanner.vala"
	result = FALSE;
#line 570 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_result_) {
#line 570 "/home/bob/git/simple-scan/src/scanner.vala"
		*_result_ = _vala_result;
#line 7114 "scanner.c"
	} else {
#line 570 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (_vala_result);
#line 7118 "scanner.c"
	}
#line 570 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 7122 "scanner.c"
}


static void
scanner_log_option (Scanner* self,
                    SANE_Int index,
                    SANE_Option_Descriptor* option)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	SANE_Value_Type _tmp13_;
	const gchar* _tmp31_;
	SANE_Int _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	SANE_Unit _tmp36_;
	SANE_Constraint_Type _tmp54_;
	SANE_Int cap = {0};
	SANE_Int _tmp122_;
	SANE_Int _tmp123_;
	const gchar* _tmp188_;
	const gchar* _tmp189_;
#line 573 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 573 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 575 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = g_strdup_printf ("Option %d:", (gint) index);
#line 575 "/home/bob/git/simple-scan/src/scanner.vala"
	s = _tmp0_;
#line 577 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = option->name;
#line 577 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_strcmp0 (_tmp1_, "") != 0) {
#line 7160 "scanner.c"
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 578 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp2_ = s;
#line 578 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = option->name;
#line 578 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = g_strdup_printf (" name='%s'", _tmp3_);
#line 578 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp5_ = _tmp4_;
#line 578 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp6_ = g_strconcat (_tmp2_, _tmp5_, NULL);
#line 578 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (s);
#line 578 "/home/bob/git/simple-scan/src/scanner.vala"
		s = _tmp6_;
#line 578 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (_tmp5_);
#line 7182 "scanner.c"
	}
#line 580 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp7_ = option->title;
#line 580 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_strcmp0 (_tmp7_, "") != 0) {
#line 7188 "scanner.c"
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 581 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp8_ = s;
#line 581 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp9_ = option->title;
#line 581 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp10_ = g_strdup_printf (" title='%s'", _tmp9_);
#line 581 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp11_ = _tmp10_;
#line 581 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp12_ = g_strconcat (_tmp8_, _tmp11_, NULL);
#line 581 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (s);
#line 581 "/home/bob/git/simple-scan/src/scanner.vala"
		s = _tmp12_;
#line 581 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (_tmp11_);
#line 7210 "scanner.c"
	}
#line 583 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp13_ = option->type;
#line 583 "/home/bob/git/simple-scan/src/scanner.vala"
	switch (_tmp13_) {
#line 583 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_TYPE_BOOL:
#line 7218 "scanner.c"
		{
			const gchar* _tmp14_;
			gchar* _tmp15_;
#line 586 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp14_ = s;
#line 586 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp15_ = g_strconcat (_tmp14_, " type=bool", NULL);
#line 586 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 586 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp15_;
#line 587 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7232 "scanner.c"
		}
#line 583 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_TYPE_INT:
#line 7236 "scanner.c"
		{
			const gchar* _tmp16_;
			gchar* _tmp17_;
#line 589 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp16_ = s;
#line 589 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp17_ = g_strconcat (_tmp16_, " type=int", NULL);
#line 589 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 589 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp17_;
#line 590 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7250 "scanner.c"
		}
#line 583 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_TYPE_FIXED:
#line 7254 "scanner.c"
		{
			const gchar* _tmp18_;
			gchar* _tmp19_;
#line 592 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp18_ = s;
#line 592 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp19_ = g_strconcat (_tmp18_, " type=fixed", NULL);
#line 592 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 592 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp19_;
#line 593 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7268 "scanner.c"
		}
#line 583 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_TYPE_STRING:
#line 7272 "scanner.c"
		{
			const gchar* _tmp20_;
			gchar* _tmp21_;
#line 595 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp20_ = s;
#line 595 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp21_ = g_strconcat (_tmp20_, " type=string", NULL);
#line 595 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 595 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp21_;
#line 596 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7286 "scanner.c"
		}
#line 583 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_TYPE_BUTTON:
#line 7290 "scanner.c"
		{
			const gchar* _tmp22_;
			gchar* _tmp23_;
#line 598 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp22_ = s;
#line 598 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp23_ = g_strconcat (_tmp22_, " type=button", NULL);
#line 598 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 598 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp23_;
#line 599 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7304 "scanner.c"
		}
#line 583 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_TYPE_GROUP:
#line 7308 "scanner.c"
		{
			const gchar* _tmp24_;
			gchar* _tmp25_;
#line 601 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp24_ = s;
#line 601 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp25_ = g_strconcat (_tmp24_, " type=group", NULL);
#line 601 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 601 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp25_;
#line 602 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7322 "scanner.c"
		}
		default:
		{
			const gchar* _tmp26_;
			SANE_Value_Type _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
#line 604 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp26_ = s;
#line 604 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp27_ = option->type;
#line 604 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp28_ = g_strdup_printf (" type=%d", (gint) _tmp27_);
#line 604 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_ = _tmp28_;
#line 604 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp30_ = g_strconcat (_tmp26_, _tmp29_, NULL);
#line 604 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 604 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp30_;
#line 604 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (_tmp29_);
#line 605 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7349 "scanner.c"
		}
	}
#line 608 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp31_ = s;
#line 608 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp32_ = option->size;
#line 608 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp33_ = g_strdup_printf (" size=%d", (gint) _tmp32_);
#line 608 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp34_ = _tmp33_;
#line 608 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp35_ = g_strconcat (_tmp31_, _tmp34_, NULL);
#line 608 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (s);
#line 608 "/home/bob/git/simple-scan/src/scanner.vala"
	s = _tmp35_;
#line 608 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp34_);
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp36_ = option->unit;
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
	switch (_tmp36_) {
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_UNIT_NONE:
#line 7374 "scanner.c"
		{
#line 613 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7378 "scanner.c"
		}
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_UNIT_PIXEL:
#line 7382 "scanner.c"
		{
			const gchar* _tmp37_;
			gchar* _tmp38_;
#line 615 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp37_ = s;
#line 615 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp38_ = g_strconcat (_tmp37_, " unit=pixels", NULL);
#line 615 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 615 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp38_;
#line 616 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7396 "scanner.c"
		}
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_UNIT_BIT:
#line 7400 "scanner.c"
		{
			const gchar* _tmp39_;
			gchar* _tmp40_;
#line 618 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp39_ = s;
#line 618 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp40_ = g_strconcat (_tmp39_, " unit=bits", NULL);
#line 618 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 618 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp40_;
#line 619 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7414 "scanner.c"
		}
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_UNIT_MM:
#line 7418 "scanner.c"
		{
			const gchar* _tmp41_;
			gchar* _tmp42_;
#line 621 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp41_ = s;
#line 621 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp42_ = g_strconcat (_tmp41_, " unit=mm", NULL);
#line 621 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 621 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp42_;
#line 622 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7432 "scanner.c"
		}
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_UNIT_DPI:
#line 7436 "scanner.c"
		{
			const gchar* _tmp43_;
			gchar* _tmp44_;
#line 624 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp43_ = s;
#line 624 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp44_ = g_strconcat (_tmp43_, " unit=dpi", NULL);
#line 624 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 624 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp44_;
#line 625 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7450 "scanner.c"
		}
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_UNIT_PERCENT:
#line 7454 "scanner.c"
		{
			const gchar* _tmp45_;
			gchar* _tmp46_;
#line 627 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp45_ = s;
#line 627 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp46_ = g_strconcat (_tmp45_, " unit=percent", NULL);
#line 627 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 627 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp46_;
#line 628 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7468 "scanner.c"
		}
#line 610 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_UNIT_MICROSECOND:
#line 7472 "scanner.c"
		{
			const gchar* _tmp47_;
			gchar* _tmp48_;
#line 630 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp47_ = s;
#line 630 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp48_ = g_strconcat (_tmp47_, " unit=microseconds", NULL);
#line 630 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 630 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp48_;
#line 631 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7486 "scanner.c"
		}
		default:
		{
			const gchar* _tmp49_;
			SANE_Unit _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
#line 633 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp49_ = s;
#line 633 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp50_ = option->unit;
#line 633 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp51_ = g_strdup_printf (" unit=%d", (gint) _tmp50_);
#line 633 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp52_ = _tmp51_;
#line 633 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp53_ = g_strconcat (_tmp49_, _tmp52_, NULL);
#line 633 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 633 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp53_;
#line 633 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (_tmp52_);
#line 634 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7513 "scanner.c"
		}
	}
#line 637 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp54_ = option->constraint_type;
#line 637 "/home/bob/git/simple-scan/src/scanner.vala"
	switch (_tmp54_) {
#line 637 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_CONSTRAINT_RANGE:
#line 7522 "scanner.c"
		{
			SANE_Value_Type _tmp55_;
#line 640 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp55_ = option->type;
#line 640 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp55_ == SANE_TYPE_FIXED) {
#line 7529 "scanner.c"
				const gchar* _tmp56_;
				SANE_Range* _tmp57_;
				SANE_Word _tmp58_;
				SANE_Range* _tmp59_;
				SANE_Word _tmp60_;
				SANE_Range* _tmp61_;
				SANE_Word _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp56_ = s;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp57_ = option->constraint.range;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp58_ = _tmp57_->min;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp59_ = option->constraint.range;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp60_ = _tmp59_->max;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp61_ = option->constraint.range;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp62_ = _tmp61_->quant;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp63_ = g_strdup_printf (" min=%f, max=%f, quant=%d", SANE_UNFIX ((SANE_Fixed) _tmp58_), SANE_UNFIX ((SANE_Fixed) _tmp60_), (gint) _tmp62_);
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp64_ = _tmp63_;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp65_ = g_strconcat (_tmp56_, _tmp64_, NULL);
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (s);
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				s = _tmp65_;
#line 641 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (_tmp64_);
#line 7566 "scanner.c"
			} else {
				const gchar* _tmp66_;
				SANE_Range* _tmp67_;
				SANE_Word _tmp68_;
				SANE_Range* _tmp69_;
				SANE_Word _tmp70_;
				SANE_Range* _tmp71_;
				SANE_Word _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp66_ = s;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp67_ = option->constraint.range;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp68_ = _tmp67_->min;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp69_ = option->constraint.range;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp70_ = _tmp69_->max;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp71_ = option->constraint.range;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp72_ = _tmp71_->quant;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp73_ = g_strdup_printf (" min=%d, max=%d, quant=%d", (gint) _tmp68_, (gint) _tmp70_, (gint) _tmp72_);
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp74_ = _tmp73_;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp75_ = g_strconcat (_tmp66_, _tmp74_, NULL);
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (s);
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				s = _tmp75_;
#line 643 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (_tmp74_);
#line 7604 "scanner.c"
			}
#line 644 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7608 "scanner.c"
		}
#line 637 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_CONSTRAINT_WORD_LIST:
#line 7612 "scanner.c"
		{
			const gchar* _tmp76_;
			gchar* _tmp77_;
			const gchar* _tmp101_;
			gchar* _tmp102_;
#line 646 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp76_ = s;
#line 646 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp77_ = g_strconcat (_tmp76_, " values=[", NULL);
#line 646 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 646 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp77_;
#line 7626 "scanner.c"
			{
				gint i = 0;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
				i = 0;
#line 7631 "scanner.c"
				{
					gboolean _tmp78_ = FALSE;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp78_ = TRUE;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
					while (TRUE) {
#line 7638 "scanner.c"
						gint _tmp80_;
						SANE_Word* _tmp81_;
						gint _tmp81__length1;
						SANE_Word _tmp82_;
						gint _tmp83_;
						SANE_Value_Type _tmp86_;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp78_) {
#line 7647 "scanner.c"
							gint _tmp79_;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp79_ = i;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
							i = _tmp79_ + 1;
#line 7653 "scanner.c"
						}
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp78_ = FALSE;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp80_ = i;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp81_ = option->constraint.word_list;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp81__length1 = -1;
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp82_ = _tmp81_[0];
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!(((SANE_Word) _tmp80_) < _tmp82_)) {
#line 647 "/home/bob/git/simple-scan/src/scanner.vala"
							break;
#line 7669 "scanner.c"
						}
#line 649 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp83_ = i;
#line 649 "/home/bob/git/simple-scan/src/scanner.vala"
						if (_tmp83_ != 0) {
#line 7675 "scanner.c"
							const gchar* _tmp84_;
							gchar* _tmp85_;
#line 650 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp84_ = s;
#line 650 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp85_ = g_strconcat (_tmp84_, ", ", NULL);
#line 650 "/home/bob/git/simple-scan/src/scanner.vala"
							_g_free0 (s);
#line 650 "/home/bob/git/simple-scan/src/scanner.vala"
							s = _tmp85_;
#line 7686 "scanner.c"
						}
#line 651 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp86_ = option->type;
#line 651 "/home/bob/git/simple-scan/src/scanner.vala"
						if (_tmp86_ == SANE_TYPE_INT) {
#line 7692 "scanner.c"
							const gchar* _tmp87_;
							SANE_Word* _tmp88_;
							gint _tmp88__length1;
							gint _tmp89_;
							SANE_Word _tmp90_;
							gchar* _tmp91_;
							gchar* _tmp92_;
							gchar* _tmp93_;
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp87_ = s;
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp88_ = option->constraint.word_list;
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp88__length1 = -1;
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp89_ = i;
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp90_ = _tmp88_[_tmp89_ + 1];
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp91_ = g_strdup_printf ("%d", (gint) _tmp90_);
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp92_ = _tmp91_;
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp93_ = g_strconcat (_tmp87_, _tmp92_, NULL);
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_g_free0 (s);
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							s = _tmp93_;
#line 652 "/home/bob/git/simple-scan/src/scanner.vala"
							_g_free0 (_tmp92_);
#line 7723 "scanner.c"
						} else {
							const gchar* _tmp94_;
							SANE_Word* _tmp95_;
							gint _tmp95__length1;
							gint _tmp96_;
							SANE_Word _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							gchar* _tmp100_;
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp94_ = s;
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp95_ = option->constraint.word_list;
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp95__length1 = -1;
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp96_ = i;
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp97_ = _tmp95_[_tmp96_ + 1];
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp98_ = g_strdup_printf ("%f", SANE_UNFIX ((SANE_Fixed) _tmp97_));
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp99_ = _tmp98_;
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp100_ = g_strconcat (_tmp94_, _tmp99_, NULL);
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_g_free0 (s);
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							s = _tmp100_;
#line 654 "/home/bob/git/simple-scan/src/scanner.vala"
							_g_free0 (_tmp99_);
#line 7755 "scanner.c"
						}
					}
				}
			}
#line 656 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp101_ = s;
#line 656 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp102_ = g_strconcat (_tmp101_, "]", NULL);
#line 656 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 656 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp102_;
#line 657 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7770 "scanner.c"
		}
#line 637 "/home/bob/git/simple-scan/src/scanner.vala"
		case SANE_CONSTRAINT_STRING_LIST:
#line 7774 "scanner.c"
		{
			const gchar* _tmp103_;
			gchar* _tmp104_;
			const gchar* _tmp120_;
			gchar* _tmp121_;
#line 659 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp103_ = s;
#line 659 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp104_ = g_strconcat (_tmp103_, " values=[", NULL);
#line 659 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 659 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp104_;
#line 7788 "scanner.c"
			{
				gint i = 0;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
				i = 0;
#line 7793 "scanner.c"
				{
					gboolean _tmp105_ = FALSE;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp105_ = TRUE;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
					while (TRUE) {
#line 7800 "scanner.c"
						gchar** _tmp107_;
						gint _tmp107__length1;
						gint _tmp108_;
						const gchar* _tmp109_;
						gint _tmp110_;
						const gchar* _tmp113_;
						gchar** _tmp114_;
						gint _tmp114__length1;
						gint _tmp115_;
						const gchar* _tmp116_;
						gchar* _tmp117_;
						gchar* _tmp118_;
						gchar* _tmp119_;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp105_) {
#line 7816 "scanner.c"
							gint _tmp106_;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp106_ = i;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
							i = _tmp106_ + 1;
#line 7822 "scanner.c"
						}
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp105_ = FALSE;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp107_ = option->constraint.string_list;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp107__length1 = _vala_array_length (option->constraint.string_list);
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp108_ = i;
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp109_ = _tmp107_[_tmp108_];
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!(_tmp109_ != NULL)) {
#line 660 "/home/bob/git/simple-scan/src/scanner.vala"
							break;
#line 7838 "scanner.c"
						}
#line 662 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp110_ = i;
#line 662 "/home/bob/git/simple-scan/src/scanner.vala"
						if (_tmp110_ != 0) {
#line 7844 "scanner.c"
							const gchar* _tmp111_;
							gchar* _tmp112_;
#line 663 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp111_ = s;
#line 663 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp112_ = g_strconcat (_tmp111_, ", ", NULL);
#line 663 "/home/bob/git/simple-scan/src/scanner.vala"
							_g_free0 (s);
#line 663 "/home/bob/git/simple-scan/src/scanner.vala"
							s = _tmp112_;
#line 7855 "scanner.c"
						}
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp113_ = s;
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp114_ = option->constraint.string_list;
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp114__length1 = _vala_array_length (option->constraint.string_list);
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp115_ = i;
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp116_ = _tmp114_[_tmp115_];
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp117_ = g_strdup_printf ("\"%s\"", _tmp116_);
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp118_ = _tmp117_;
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp119_ = g_strconcat (_tmp113_, _tmp118_, NULL);
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_g_free0 (s);
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						s = _tmp119_;
#line 664 "/home/bob/git/simple-scan/src/scanner.vala"
						_g_free0 (_tmp118_);
#line 7879 "scanner.c"
					}
				}
			}
#line 666 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp120_ = s;
#line 666 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp121_ = g_strconcat (_tmp120_, "]", NULL);
#line 666 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (s);
#line 666 "/home/bob/git/simple-scan/src/scanner.vala"
			s = _tmp121_;
#line 667 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7893 "scanner.c"
		}
		default:
		{
#line 669 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 7899 "scanner.c"
		}
	}
#line 672 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp122_ = option->cap;
#line 672 "/home/bob/git/simple-scan/src/scanner.vala"
	cap = _tmp122_;
#line 673 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp123_ = cap;
#line 673 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp123_ != ((SANE_Int) 0)) {
#line 7910 "scanner.c"
		gchar* caps = NULL;
		gchar* _tmp124_;
		SANE_Int _tmp125_;
		SANE_Int _tmp132_;
		SANE_Int _tmp139_;
		SANE_Int _tmp146_;
		SANE_Int _tmp153_;
		SANE_Int _tmp160_;
		SANE_Int _tmp167_;
		SANE_Int _tmp174_;
		const gchar* _tmp183_;
		const gchar* _tmp184_;
		gchar* _tmp185_;
		gchar* _tmp186_;
		gchar* _tmp187_;
#line 675 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp124_ = g_strdup ("");
#line 675 "/home/bob/git/simple-scan/src/scanner.vala"
		caps = _tmp124_;
#line 676 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp125_ = cap;
#line 676 "/home/bob/git/simple-scan/src/scanner.vala"
		if ((_tmp125_ & SANE_CAP_SOFT_SELECT) != ((SANE_Int) 0)) {
#line 7934 "scanner.c"
			const gchar* _tmp126_;
			const gchar* _tmp129_;
			gchar* _tmp130_;
			SANE_Int _tmp131_;
#line 678 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp126_ = caps;
#line 678 "/home/bob/git/simple-scan/src/scanner.vala"
			if (g_strcmp0 (_tmp126_, "") != 0) {
#line 7943 "scanner.c"
				const gchar* _tmp127_;
				gchar* _tmp128_;
#line 679 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp127_ = caps;
#line 679 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp128_ = g_strconcat (_tmp127_, ",", NULL);
#line 679 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (caps);
#line 679 "/home/bob/git/simple-scan/src/scanner.vala"
				caps = _tmp128_;
#line 7954 "scanner.c"
			}
#line 680 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp129_ = caps;
#line 680 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp130_ = g_strconcat (_tmp129_, "soft-select", NULL);
#line 680 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (caps);
#line 680 "/home/bob/git/simple-scan/src/scanner.vala"
			caps = _tmp130_;
#line 681 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp131_ = cap;
#line 681 "/home/bob/git/simple-scan/src/scanner.vala"
			cap = _tmp131_ & (~SANE_CAP_SOFT_SELECT);
#line 7968 "scanner.c"
		}
#line 683 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp132_ = cap;
#line 683 "/home/bob/git/simple-scan/src/scanner.vala"
		if ((_tmp132_ & SANE_CAP_HARD_SELECT) != ((SANE_Int) 0)) {
#line 7974 "scanner.c"
			const gchar* _tmp133_;
			const gchar* _tmp136_;
			gchar* _tmp137_;
			SANE_Int _tmp138_;
#line 685 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp133_ = caps;
#line 685 "/home/bob/git/simple-scan/src/scanner.vala"
			if (g_strcmp0 (_tmp133_, "") != 0) {
#line 7983 "scanner.c"
				const gchar* _tmp134_;
				gchar* _tmp135_;
#line 686 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp134_ = caps;
#line 686 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp135_ = g_strconcat (_tmp134_, ",", NULL);
#line 686 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (caps);
#line 686 "/home/bob/git/simple-scan/src/scanner.vala"
				caps = _tmp135_;
#line 7994 "scanner.c"
			}
#line 687 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp136_ = caps;
#line 687 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_ = g_strconcat (_tmp136_, "hard-select", NULL);
#line 687 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (caps);
#line 687 "/home/bob/git/simple-scan/src/scanner.vala"
			caps = _tmp137_;
#line 688 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp138_ = cap;
#line 688 "/home/bob/git/simple-scan/src/scanner.vala"
			cap = _tmp138_ & (~SANE_CAP_HARD_SELECT);
#line 8008 "scanner.c"
		}
#line 690 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp139_ = cap;
#line 690 "/home/bob/git/simple-scan/src/scanner.vala"
		if ((_tmp139_ & SANE_CAP_SOFT_DETECT) != ((SANE_Int) 0)) {
#line 8014 "scanner.c"
			const gchar* _tmp140_;
			const gchar* _tmp143_;
			gchar* _tmp144_;
			SANE_Int _tmp145_;
#line 692 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp140_ = caps;
#line 692 "/home/bob/git/simple-scan/src/scanner.vala"
			if (g_strcmp0 (_tmp140_, "") != 0) {
#line 8023 "scanner.c"
				const gchar* _tmp141_;
				gchar* _tmp142_;
#line 693 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp141_ = caps;
#line 693 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp142_ = g_strconcat (_tmp141_, ",", NULL);
#line 693 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (caps);
#line 693 "/home/bob/git/simple-scan/src/scanner.vala"
				caps = _tmp142_;
#line 8034 "scanner.c"
			}
#line 694 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp143_ = caps;
#line 694 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp144_ = g_strconcat (_tmp143_, "soft-detect", NULL);
#line 694 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (caps);
#line 694 "/home/bob/git/simple-scan/src/scanner.vala"
			caps = _tmp144_;
#line 695 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp145_ = cap;
#line 695 "/home/bob/git/simple-scan/src/scanner.vala"
			cap = _tmp145_ & (~SANE_CAP_SOFT_DETECT);
#line 8048 "scanner.c"
		}
#line 697 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp146_ = cap;
#line 697 "/home/bob/git/simple-scan/src/scanner.vala"
		if ((_tmp146_ & SANE_CAP_EMULATED) != ((SANE_Int) 0)) {
#line 8054 "scanner.c"
			const gchar* _tmp147_;
			const gchar* _tmp150_;
			gchar* _tmp151_;
			SANE_Int _tmp152_;
#line 699 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp147_ = caps;
#line 699 "/home/bob/git/simple-scan/src/scanner.vala"
			if (g_strcmp0 (_tmp147_, "") != 0) {
#line 8063 "scanner.c"
				const gchar* _tmp148_;
				gchar* _tmp149_;
#line 700 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp148_ = caps;
#line 700 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp149_ = g_strconcat (_tmp148_, ",", NULL);
#line 700 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (caps);
#line 700 "/home/bob/git/simple-scan/src/scanner.vala"
				caps = _tmp149_;
#line 8074 "scanner.c"
			}
#line 701 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp150_ = caps;
#line 701 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp151_ = g_strconcat (_tmp150_, "emulated", NULL);
#line 701 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (caps);
#line 701 "/home/bob/git/simple-scan/src/scanner.vala"
			caps = _tmp151_;
#line 702 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp152_ = cap;
#line 702 "/home/bob/git/simple-scan/src/scanner.vala"
			cap = _tmp152_ & (~SANE_CAP_EMULATED);
#line 8088 "scanner.c"
		}
#line 704 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp153_ = cap;
#line 704 "/home/bob/git/simple-scan/src/scanner.vala"
		if ((_tmp153_ & SANE_CAP_AUTOMATIC) != ((SANE_Int) 0)) {
#line 8094 "scanner.c"
			const gchar* _tmp154_;
			const gchar* _tmp157_;
			gchar* _tmp158_;
			SANE_Int _tmp159_;
#line 706 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp154_ = caps;
#line 706 "/home/bob/git/simple-scan/src/scanner.vala"
			if (g_strcmp0 (_tmp154_, "") != 0) {
#line 8103 "scanner.c"
				const gchar* _tmp155_;
				gchar* _tmp156_;
#line 707 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp155_ = caps;
#line 707 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp156_ = g_strconcat (_tmp155_, ",", NULL);
#line 707 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (caps);
#line 707 "/home/bob/git/simple-scan/src/scanner.vala"
				caps = _tmp156_;
#line 8114 "scanner.c"
			}
#line 708 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp157_ = caps;
#line 708 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp158_ = g_strconcat (_tmp157_, "automatic", NULL);
#line 708 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (caps);
#line 708 "/home/bob/git/simple-scan/src/scanner.vala"
			caps = _tmp158_;
#line 709 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp159_ = cap;
#line 709 "/home/bob/git/simple-scan/src/scanner.vala"
			cap = _tmp159_ & (~SANE_CAP_AUTOMATIC);
#line 8128 "scanner.c"
		}
#line 711 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp160_ = cap;
#line 711 "/home/bob/git/simple-scan/src/scanner.vala"
		if ((_tmp160_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 8134 "scanner.c"
			const gchar* _tmp161_;
			const gchar* _tmp164_;
			gchar* _tmp165_;
			SANE_Int _tmp166_;
#line 713 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp161_ = caps;
#line 713 "/home/bob/git/simple-scan/src/scanner.vala"
			if (g_strcmp0 (_tmp161_, "") != 0) {
#line 8143 "scanner.c"
				const gchar* _tmp162_;
				gchar* _tmp163_;
#line 714 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp162_ = caps;
#line 714 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp163_ = g_strconcat (_tmp162_, ",", NULL);
#line 714 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (caps);
#line 714 "/home/bob/git/simple-scan/src/scanner.vala"
				caps = _tmp163_;
#line 8154 "scanner.c"
			}
#line 715 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp164_ = caps;
#line 715 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp165_ = g_strconcat (_tmp164_, "inactive", NULL);
#line 715 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (caps);
#line 715 "/home/bob/git/simple-scan/src/scanner.vala"
			caps = _tmp165_;
#line 716 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp166_ = cap;
#line 716 "/home/bob/git/simple-scan/src/scanner.vala"
			cap = _tmp166_ & (~SANE_CAP_INACTIVE);
#line 8168 "scanner.c"
		}
#line 718 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp167_ = cap;
#line 718 "/home/bob/git/simple-scan/src/scanner.vala"
		if ((_tmp167_ & SANE_CAP_ADVANCED) != ((SANE_Int) 0)) {
#line 8174 "scanner.c"
			const gchar* _tmp168_;
			const gchar* _tmp171_;
			gchar* _tmp172_;
			SANE_Int _tmp173_;
#line 720 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp168_ = caps;
#line 720 "/home/bob/git/simple-scan/src/scanner.vala"
			if (g_strcmp0 (_tmp168_, "") != 0) {
#line 8183 "scanner.c"
				const gchar* _tmp169_;
				gchar* _tmp170_;
#line 721 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp169_ = caps;
#line 721 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp170_ = g_strconcat (_tmp169_, ",", NULL);
#line 721 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (caps);
#line 721 "/home/bob/git/simple-scan/src/scanner.vala"
				caps = _tmp170_;
#line 8194 "scanner.c"
			}
#line 722 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp171_ = caps;
#line 722 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp172_ = g_strconcat (_tmp171_, "advanced", NULL);
#line 722 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (caps);
#line 722 "/home/bob/git/simple-scan/src/scanner.vala"
			caps = _tmp172_;
#line 723 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp173_ = cap;
#line 723 "/home/bob/git/simple-scan/src/scanner.vala"
			cap = _tmp173_ & (~SANE_CAP_ADVANCED);
#line 8208 "scanner.c"
		}
#line 726 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp174_ = cap;
#line 726 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp174_ != ((SANE_Int) 0)) {
#line 8214 "scanner.c"
			const gchar* _tmp175_;
			const gchar* _tmp178_;
			SANE_Int _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
#line 728 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp175_ = caps;
#line 728 "/home/bob/git/simple-scan/src/scanner.vala"
			if (g_strcmp0 (_tmp175_, "") != 0) {
#line 8225 "scanner.c"
				const gchar* _tmp176_;
				gchar* _tmp177_;
#line 729 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp176_ = caps;
#line 729 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp177_ = g_strconcat (_tmp176_, ",", NULL);
#line 729 "/home/bob/git/simple-scan/src/scanner.vala"
				_g_free0 (caps);
#line 729 "/home/bob/git/simple-scan/src/scanner.vala"
				caps = _tmp177_;
#line 8236 "scanner.c"
			}
#line 730 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp178_ = caps;
#line 730 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp179_ = cap;
#line 730 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp180_ = g_strdup_printf ("%x", (guint) ((gint) _tmp179_));
#line 730 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp181_ = _tmp180_;
#line 730 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp182_ = g_strconcat (_tmp178_, _tmp181_, NULL);
#line 730 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (caps);
#line 730 "/home/bob/git/simple-scan/src/scanner.vala"
			caps = _tmp182_;
#line 730 "/home/bob/git/simple-scan/src/scanner.vala"
			_g_free0 (_tmp181_);
#line 8254 "scanner.c"
		}
#line 732 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp183_ = s;
#line 732 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp184_ = caps;
#line 732 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp185_ = g_strconcat (" cap=", _tmp184_, NULL);
#line 732 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp186_ = _tmp185_;
#line 732 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp187_ = g_strconcat (_tmp183_, _tmp186_, NULL);
#line 732 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (s);
#line 732 "/home/bob/git/simple-scan/src/scanner.vala"
		s = _tmp187_;
#line 732 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (_tmp186_);
#line 673 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (caps);
#line 8274 "scanner.c"
	}
#line 735 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp188_ = s;
#line 735 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:735: %s", _tmp188_);
#line 737 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp189_ = option->desc;
#line 737 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp189_ != NULL) {
#line 8284 "scanner.c"
		const gchar* _tmp190_;
#line 738 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp190_ = option->desc;
#line 738 "/home/bob/git/simple-scan/src/scanner.vala"
		g_debug ("scanner.vala:738:   Description: %s", _tmp190_);
#line 8290 "scanner.c"
	}
#line 573 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (s);
#line 8294 "scanner.c"
}


static void
scanner_authorization_cb (const gchar* resource,
                          gchar* username,
                          int username_length1,
                          gchar* password,
                          int password_length1)
{
	Scanner* _tmp0_;
	NotifyRequestAuthorization* _tmp1_;
	NotifyRequestAuthorization* _tmp2_;
	Credentials* credentials = NULL;
	Scanner* _tmp3_;
	GAsyncQueue* _tmp4_;
	gpointer _tmp5_;
#line 741 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (resource != NULL);
#line 743 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 743 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = notify_request_authorization_new (resource);
#line 743 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = _tmp1_;
#line 743 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_notify (_tmp0_, (Notify*) _tmp2_);
#line 743 "/home/bob/git/simple-scan/src/scanner.vala"
	_notify_unref0 (_tmp2_);
#line 745 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = scanner_scanner_object;
#line 745 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = _tmp3_->priv->authorize_queue;
#line 745 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = g_async_queue_pop (_tmp4_);
#line 745 "/home/bob/git/simple-scan/src/scanner.vala"
	credentials = (Credentials*) _tmp5_;
#line 8332 "scanner.c"
	{
		gint i = 0;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
		i = 0;
#line 8337 "scanner.c"
		{
			gboolean _tmp6_ = FALSE;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp6_ = TRUE;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
			while (TRUE) {
#line 8344 "scanner.c"
				gboolean _tmp8_ = FALSE;
				Credentials* _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp14_;
				Credentials* _tmp15_;
				const gchar* _tmp16_;
				gint _tmp17_;
				gchar _tmp18_;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
				if (!_tmp6_) {
#line 8356 "scanner.c"
					gint _tmp7_;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp7_ = i;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
					i = _tmp7_ + 1;
#line 8362 "scanner.c"
				}
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp6_ = FALSE;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp9_ = credentials;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp10_ = _tmp9_->username;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp11_ = i;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
				if (string_get (_tmp10_, (glong) _tmp11_) != '\0') {
#line 8374 "scanner.c"
					gint _tmp12_;
					gint _tmp13_;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp12_ = i;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp13_ = SANE_MAX_USERNAME_LEN;
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp8_ = _tmp12_ < _tmp13_;
#line 8383 "scanner.c"
				} else {
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp8_ = FALSE;
#line 8387 "scanner.c"
				}
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
				if (!_tmp8_) {
#line 746 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 8393 "scanner.c"
				}
#line 747 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp14_ = i;
#line 747 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp15_ = credentials;
#line 747 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp16_ = _tmp15_->username;
#line 747 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp17_ = i;
#line 747 "/home/bob/git/simple-scan/src/scanner.vala"
				username[_tmp14_] = string_get (_tmp16_, (glong) _tmp17_);
#line 747 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp18_ = username[_tmp14_];
#line 8407 "scanner.c"
			}
		}
	}
	{
		gint i = 0;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
		i = 0;
#line 8415 "scanner.c"
		{
			gboolean _tmp19_ = FALSE;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp19_ = TRUE;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
			while (TRUE) {
#line 8422 "scanner.c"
				gboolean _tmp21_ = FALSE;
				Credentials* _tmp22_;
				const gchar* _tmp23_;
				gint _tmp24_;
				gint _tmp27_;
				Credentials* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_;
				gchar _tmp31_;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
				if (!_tmp19_) {
#line 8434 "scanner.c"
					gint _tmp20_;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp20_ = i;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
					i = _tmp20_ + 1;
#line 8440 "scanner.c"
				}
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp19_ = FALSE;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp22_ = credentials;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp23_ = _tmp22_->password;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp24_ = i;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
				if (string_get (_tmp23_, (glong) _tmp24_) != '\0') {
#line 8452 "scanner.c"
					gint _tmp25_;
					gint _tmp26_;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp25_ = i;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp26_ = SANE_MAX_USERNAME_LEN;
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp21_ = _tmp25_ < _tmp26_;
#line 8461 "scanner.c"
				} else {
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp21_ = FALSE;
#line 8465 "scanner.c"
				}
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
				if (!_tmp21_) {
#line 748 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 8471 "scanner.c"
				}
#line 749 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp27_ = i;
#line 749 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp28_ = credentials;
#line 749 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp29_ = _tmp28_->password;
#line 749 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp30_ = i;
#line 749 "/home/bob/git/simple-scan/src/scanner.vala"
				password[_tmp27_] = string_get (_tmp29_, (glong) _tmp30_);
#line 749 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp31_ = password[_tmp27_];
#line 8485 "scanner.c"
			}
		}
	}
#line 741 "/home/bob/git/simple-scan/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8491 "scanner.c"
}


static gpointer
_credentials_ref0 (gpointer self)
{
#line 757 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? credentials_ref (self) : NULL;
#line 8500 "scanner.c"
}


void
scanner_authorize (Scanner* self,
                   const gchar* username,
                   const gchar* password)
{
	Credentials* credentials = NULL;
	Credentials* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GAsyncQueue* _tmp3_;
	Credentials* _tmp4_;
#line 752 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 752 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (username != NULL);
#line 752 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (password != NULL);
#line 754 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = credentials_new ();
#line 754 "/home/bob/git/simple-scan/src/scanner.vala"
	credentials = _tmp0_;
#line 755 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = g_strdup (username);
#line 755 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (credentials->username);
#line 755 "/home/bob/git/simple-scan/src/scanner.vala"
	credentials->username = _tmp1_;
#line 756 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = g_strdup (password);
#line 756 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (credentials->password);
#line 756 "/home/bob/git/simple-scan/src/scanner.vala"
	credentials->password = _tmp2_;
#line 757 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = self->priv->authorize_queue;
#line 757 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = _credentials_ref0 (credentials);
#line 757 "/home/bob/git/simple-scan/src/scanner.vala"
	g_async_queue_push (_tmp3_, _tmp4_);
#line 752 "/home/bob/git/simple-scan/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8545 "scanner.c"
}


static void
scanner_close_device (Scanner* self)
{
	gboolean _tmp0_;
#line 760 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 762 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->have_handle;
#line 762 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_) {
#line 8559 "scanner.c"
		SANE_Handle _tmp1_;
		SANE_Handle _tmp2_;
#line 764 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp1_ = self->priv->handle;
#line 764 "/home/bob/git/simple-scan/src/scanner.vala"
		sane_cancel (_tmp1_);
#line 765 "/home/bob/git/simple-scan/src/scanner.vala"
		g_debug ("scanner.vala:765: sane_cancel ()");
#line 767 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp2_ = self->priv->handle;
#line 767 "/home/bob/git/simple-scan/src/scanner.vala"
		sane_close (_tmp2_);
#line 768 "/home/bob/git/simple-scan/src/scanner.vala"
		g_debug ("scanner.vala:768: sane_close ()");
#line 769 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 770 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_hash_table_unref0 (self->priv->options);
#line 770 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->options = NULL;
#line 8580 "scanner.c"
	}
#line 773 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 773 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->buffer = NULL;
#line 773 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->buffer_length1 = 0;
#line 773 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 774 "/home/bob/git/simple-scan/src/scanner.vala"
	(self->priv->job_queue == NULL) ? NULL : (self->priv->job_queue = (_g_list_free__scan_job_unref0_ (self->priv->job_queue), NULL));
#line 774 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->job_queue = NULL;
#line 776 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 8596 "scanner.c"
}


static void
scanner_fail_scan (Scanner* self,
                   gint error_code,
                   const gchar* error_string)
{
	NotifyScanFailed* _tmp0_;
	NotifyScanFailed* _tmp1_;
#line 779 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 779 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (error_string != NULL);
#line 781 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_close_device (self);
#line 782 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 783 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = notify_scan_failed_new (error_code, error_string);
#line 783 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = _tmp0_;
#line 783 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp1_);
#line 783 "/home/bob/git/simple-scan/src/scanner.vala"
	_notify_unref0 (_tmp1_);
#line 8623 "scanner.c"
}


static gpointer
_request_ref0 (gpointer self)
{
#line 808 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? request_ref (self) : NULL;
#line 8632 "scanner.c"
}


static gpointer
_scan_job_ref0 (gpointer self)
{
#line 809 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? scan_job_ref (self) : NULL;
#line 8641 "scanner.c"
}


static gboolean
scanner_handle_requests (Scanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ScanState _tmp1_;
	gint request_count = 0;
#line 786 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 789 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = self->priv->state;
#line 789 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp1_ == SCAN_STATE_IDLE) {
#line 8658 "scanner.c"
		gboolean _tmp2_;
#line 789 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp2_ = self->priv->need_redetect;
#line 789 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 8664 "scanner.c"
	} else {
#line 789 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = FALSE;
#line 8668 "scanner.c"
	}
#line 789 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_) {
#line 790 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->state = SCAN_STATE_REDETECT;
#line 8674 "scanner.c"
	}
#line 793 "/home/bob/git/simple-scan/src/scanner.vala"
	request_count = 0;
#line 794 "/home/bob/git/simple-scan/src/scanner.vala"
	while (TRUE) {
#line 8680 "scanner.c"
		Request* request = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ScanState _tmp5_;
		gint _tmp10_;
		Request* _tmp11_;
#line 797 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp5_ = self->priv->state;
#line 797 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp5_ == SCAN_STATE_IDLE) {
#line 8691 "scanner.c"
			gint _tmp6_;
#line 797 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp6_ = request_count;
#line 797 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp4_ = _tmp6_ == 0;
#line 8697 "scanner.c"
		} else {
#line 797 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp4_ = FALSE;
#line 8701 "scanner.c"
		}
#line 797 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp4_) {
#line 797 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp3_ = TRUE;
#line 8707 "scanner.c"
		} else {
			GAsyncQueue* _tmp7_;
#line 798 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp7_ = self->priv->request_queue;
#line 798 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp3_ = g_async_queue_length (_tmp7_) > 0;
#line 8714 "scanner.c"
		}
#line 797 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp3_) {
#line 8718 "scanner.c"
			GAsyncQueue* _tmp8_;
			gpointer _tmp9_;
#line 799 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp8_ = self->priv->request_queue;
#line 799 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp9_ = g_async_queue_pop (_tmp8_);
#line 799 "/home/bob/git/simple-scan/src/scanner.vala"
			_request_unref0 (request);
#line 799 "/home/bob/git/simple-scan/src/scanner.vala"
			request = (Request*) _tmp9_;
#line 8729 "scanner.c"
		} else {
#line 801 "/home/bob/git/simple-scan/src/scanner.vala"
			result = TRUE;
#line 801 "/home/bob/git/simple-scan/src/scanner.vala"
			_request_unref0 (request);
#line 801 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 8737 "scanner.c"
		}
#line 803 "/home/bob/git/simple-scan/src/scanner.vala"
		g_debug ("scanner.vala:803: Processing request");
#line 804 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp10_ = request_count;
#line 804 "/home/bob/git/simple-scan/src/scanner.vala"
		request_count = _tmp10_ + 1;
#line 806 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp11_ = request;
#line 806 "/home/bob/git/simple-scan/src/scanner.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_REQUEST_START_SCAN)) {
#line 8749 "scanner.c"
			RequestStartScan* r = NULL;
			Request* _tmp12_;
			RequestStartScan* _tmp13_;
			RequestStartScan* _tmp14_;
			ScanJob* _tmp15_;
			ScanJob* _tmp16_;
#line 808 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp12_ = request;
#line 808 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp13_ = _request_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_REQUEST_START_SCAN, RequestStartScan));
#line 808 "/home/bob/git/simple-scan/src/scanner.vala"
			r = _tmp13_;
#line 809 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp14_ = r;
#line 809 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp15_ = _tmp14_->job;
#line 809 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp16_ = _scan_job_ref0 (_tmp15_);
#line 809 "/home/bob/git/simple-scan/src/scanner.vala"
			self->priv->job_queue = g_list_append (self->priv->job_queue, _tmp16_);
#line 806 "/home/bob/git/simple-scan/src/scanner.vala"
			_request_unref0 (r);
#line 8772 "scanner.c"
		} else {
			Request* _tmp17_;
#line 811 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp17_ = request;
#line 811 "/home/bob/git/simple-scan/src/scanner.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_REQUEST_CANCEL)) {
#line 813 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_fail_scan (self, (gint) SANE_STATUS_CANCELLED, "Scan cancelled - do not report this error");
#line 8781 "scanner.c"
			} else {
				Request* _tmp18_;
#line 815 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp18_ = request;
#line 815 "/home/bob/git/simple-scan/src/scanner.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, TYPE_REQUEST_QUIT)) {
#line 817 "/home/bob/git/simple-scan/src/scanner.vala"
					scanner_close_device (self);
#line 818 "/home/bob/git/simple-scan/src/scanner.vala"
					result = FALSE;
#line 818 "/home/bob/git/simple-scan/src/scanner.vala"
					_request_unref0 (request);
#line 818 "/home/bob/git/simple-scan/src/scanner.vala"
					return result;
#line 8796 "scanner.c"
				}
			}
		}
#line 794 "/home/bob/git/simple-scan/src/scanner.vala"
		_request_unref0 (request);
#line 8802 "scanner.c"
	}
}


static void
_g_free0_ (gpointer var)
{
#line 862 "/home/bob/git/simple-scan/src/scanner.vala"
	var = (g_free (var), NULL);
#line 8812 "scanner.c"
}


static void
scanner_do_open (Scanner* self)
{
	ScanJob* job = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ScanJob* _tmp4_;
	const gchar* _tmp5_;
	ScanJob* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GHashTable* _tmp19_;
	SANE_Status status = 0;
	ScanJob* _tmp20_;
	const gchar* _tmp21_;
	SANE_Handle _tmp22_ = {0};
	SANE_Status _tmp23_;
	ScanJob* _tmp24_;
	const gchar* _tmp25_;
	SANE_Status _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	SANE_Status _tmp29_;
	ScanJob* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
#line 823 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 825 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 825 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 825 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 825 "/home/bob/git/simple-scan/src/scanner.vala"
	job = _tmp2_;
#line 827 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->line_count = 0;
#line 828 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->pass_number = 0;
#line 829 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->page_number = 0;
#line 830 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->notified_page = -1;
#line 831 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->option_index = (SANE_Int) 0;
#line 833 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = job;
#line 833 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = _tmp4_->device;
#line 833 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp5_ == NULL) {
#line 8872 "scanner.c"
		const gchar* _tmp6_;
#line 833 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp6_ = self->priv->default_device;
#line 833 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 8878 "scanner.c"
	} else {
#line 833 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = FALSE;
#line 8882 "scanner.c"
	}
#line 833 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp3_) {
#line 8886 "scanner.c"
		ScanJob* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
#line 834 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_ = job;
#line 834 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp8_ = self->priv->default_device;
#line 834 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 834 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_free0 (_tmp7_->device);
#line 834 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_->device = _tmp9_;
#line 8900 "scanner.c"
	}
#line 836 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp10_ = job;
#line 836 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp11_ = _tmp10_->device;
#line 836 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp11_ == NULL) {
#line 838 "/home/bob/git/simple-scan/src/scanner.vala"
		g_warning ("scanner.vala:838: No scan device available");
#line 839 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_fail_scan (self, 0, _ ("No scanners available.  Please connect a scanner."));
#line 842 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 842 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 8916 "scanner.c"
	}
#line 846 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp12_ = self->priv->have_handle;
#line 846 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp12_) {
#line 8922 "scanner.c"
		const gchar* _tmp13_;
		ScanJob* _tmp14_;
		const gchar* _tmp15_;
		SANE_Handle _tmp16_;
#line 848 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp13_ = self->priv->current_device;
#line 848 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp14_ = job;
#line 848 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp15_ = _tmp14_->device;
#line 848 "/home/bob/git/simple-scan/src/scanner.vala"
		if (g_strcmp0 (_tmp13_, _tmp15_) == 0) {
#line 850 "/home/bob/git/simple-scan/src/scanner.vala"
			self->priv->state = SCAN_STATE_GET_OPTION;
#line 851 "/home/bob/git/simple-scan/src/scanner.vala"
			_scan_job_unref0 (job);
#line 851 "/home/bob/git/simple-scan/src/scanner.vala"
			return;
#line 8941 "scanner.c"
		}
#line 854 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp16_ = self->priv->handle;
#line 854 "/home/bob/git/simple-scan/src/scanner.vala"
		sane_close (_tmp16_);
#line 855 "/home/bob/git/simple-scan/src/scanner.vala"
		g_debug ("scanner.vala:855: sane_close ()");
#line 856 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 8951 "scanner.c"
	}
#line 859 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 859 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->current_device = NULL;
#line 861 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->have_handle = FALSE;
#line 862 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp17_ = g_str_hash;
#line 862 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp18_ = g_str_equal;
#line 862 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, _g_free0_, NULL);
#line 862 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 862 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->options = _tmp19_;
#line 863 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp20_ = job;
#line 863 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp21_ = _tmp20_->device;
#line 863 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp23_ = sane_open (_tmp21_, &_tmp22_);
#line 863 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->handle = _tmp22_;
#line 863 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp23_;
#line 864 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp24_ = job;
#line 864 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp25_ = _tmp24_->device;
#line 864 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp26_ = status;
#line 864 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp27_ = sane_status_to_string (_tmp26_);
#line 864 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp28_ = _tmp27_;
#line 864 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:864: sane_open (\"%s\") -> %s", _tmp25_, _tmp28_);
#line 864 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp28_);
#line 866 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp29_ = status;
#line 866 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp29_ != SANE_STATUS_GOOD) {
#line 8997 "scanner.c"
		SANE_Status _tmp30_;
		const gchar* _tmp31_;
		SANE_Status _tmp32_;
#line 868 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp30_ = status;
#line 868 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp31_ = sane_strstatus (_tmp30_);
#line 868 "/home/bob/git/simple-scan/src/scanner.vala"
		g_warning ("scanner.vala:868: Unable to get open device: %s", _tmp31_);
#line 869 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp32_ = status;
#line 869 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp32_, _ ("Unable to connect to scanner"));
#line 872 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 872 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 9015 "scanner.c"
	}
#line 874 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->have_handle = TRUE;
#line 876 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp33_ = job;
#line 876 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp34_ = _tmp33_->device;
#line 876 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp35_ = g_strdup (_tmp34_);
#line 876 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 876 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->current_device = _tmp35_;
#line 877 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->state = SCAN_STATE_GET_OPTION;
#line 823 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_job_unref0 (job);
#line 9033 "scanner.c"
}


static void
scanner_do_get_option (Scanner* self)
{
	ScanJob* job = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	SANE_Option_Descriptor* option = NULL;
	SANE_Handle _tmp3_;
	SANE_Int _tmp4_;
	SANE_Option_Descriptor* _tmp5_;
	SANE_Int _tmp6_;
	SANE_Int index = {0};
	SANE_Int _tmp7_;
	SANE_Int _tmp8_;
	SANE_Option_Descriptor* _tmp9_;
	SANE_Int _tmp349_;
	SANE_Option_Descriptor* _tmp350_;
	SANE_Option_Descriptor* _tmp351_;
	SANE_Value_Type _tmp352_;
	SANE_Option_Descriptor* _tmp353_;
	SANE_Int _tmp354_;
	SANE_Option_Descriptor* _tmp355_;
	const gchar* _tmp356_;
	GHashTable* _tmp357_;
	SANE_Option_Descriptor* _tmp358_;
	const gchar* _tmp359_;
	gchar* _tmp360_;
	SANE_Int _tmp361_;
#line 880 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 882 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 882 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 882 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 882 "/home/bob/git/simple-scan/src/scanner.vala"
	job = _tmp2_;
#line 884 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = self->priv->handle;
#line 884 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = self->priv->option_index;
#line 884 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = sane_get_option_descriptor (_tmp3_, _tmp4_);
#line 884 "/home/bob/git/simple-scan/src/scanner.vala"
	option = _tmp5_;
#line 885 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp6_ = self->priv->option_index;
#line 885 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:885: sane_get_option_descriptor (%d)", (gint) _tmp6_);
#line 886 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp7_ = self->priv->option_index;
#line 886 "/home/bob/git/simple-scan/src/scanner.vala"
	index = _tmp7_;
#line 887 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp8_ = self->priv->option_index;
#line 887 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->option_index = _tmp8_ + 1;
#line 890 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp9_ = option;
#line 890 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp9_ == NULL) {
#line 9100 "scanner.c"
		SANE_Handle _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_ = 0;
		SANE_Option_Descriptor* _tmp13_;
		SANE_Option_Descriptor* _tmp14_;
		SANE_Option_Descriptor* _tmp18_;
		SANE_Handle _tmp95_;
		const gchar* _tmp96_;
		gint _tmp97_ = 0;
		SANE_Option_Descriptor* _tmp98_;
		SANE_Option_Descriptor* _tmp99_;
		SANE_Handle _tmp155_;
		gint _tmp156_ = 0;
		SANE_Option_Descriptor* _tmp157_;
		SANE_Option_Descriptor* _tmp158_;
		SANE_Handle _tmp166_;
		gint _tmp167_ = 0;
		SANE_Option_Descriptor* _tmp168_;
		SANE_Option_Descriptor* _tmp169_;
		SANE_Handle _tmp177_;
		gint _tmp178_ = 0;
		SANE_Option_Descriptor* _tmp179_;
		SANE_Option_Descriptor* _tmp180_;
		SANE_Handle _tmp193_;
		const gchar* _tmp194_;
		gint _tmp195_ = 0;
		SANE_Option_Descriptor* _tmp196_;
		SANE_Option_Descriptor* _tmp197_;
		SANE_Handle _tmp217_;
		const gchar* _tmp218_;
		gint _tmp219_ = 0;
		SANE_Option_Descriptor* _tmp220_;
		SANE_Option_Descriptor* _tmp221_;
		SANE_Handle _tmp235_;
		const gchar* _tmp236_;
		gint _tmp237_ = 0;
		SANE_Option_Descriptor* _tmp238_;
		SANE_Option_Descriptor* _tmp239_;
		SANE_Handle _tmp253_;
		const gchar* _tmp254_;
		gint _tmp255_ = 0;
		SANE_Option_Descriptor* _tmp256_;
		gboolean _tmp257_ = FALSE;
		SANE_Option_Descriptor* _tmp258_;
		SANE_Handle _tmp269_;
		const gchar* _tmp270_;
		gint _tmp271_ = 0;
		SANE_Option_Descriptor* _tmp272_;
		gboolean _tmp273_ = FALSE;
		SANE_Option_Descriptor* _tmp274_;
		SANE_Handle _tmp285_;
		const gchar* _tmp286_;
		gint _tmp287_ = 0;
		SANE_Option_Descriptor* _tmp288_;
		SANE_Option_Descriptor* _tmp289_;
		SANE_Handle _tmp299_;
		const gchar* _tmp300_;
		gint _tmp301_ = 0;
		SANE_Option_Descriptor* _tmp302_;
		SANE_Option_Descriptor* _tmp303_;
		const gchar* _tmp313_;
#line 893 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp10_ = self->priv->handle;
#line 893 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp11_ = SANE_NAME_SCAN_SOURCE;
#line 893 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp13_ = scanner_get_option_by_name (self, _tmp10_, _tmp11_, &_tmp12_);
#line 893 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp12_;
#line 893 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp13_;
#line 894 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp14_ = option;
#line 894 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp14_ == NULL) {
#line 9176 "scanner.c"
			SANE_Handle _tmp15_;
			gint _tmp16_ = 0;
			SANE_Option_Descriptor* _tmp17_;
#line 896 "/home/bob/git/simple-scan/src/scanner.vala"
			g_debug ("scanner.vala:896: SCAN_SOURCE not available, trying alternative \"doc-" \
"source\"");
#line 897 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp15_ = self->priv->handle;
#line 897 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp17_ = scanner_get_option_by_name (self, _tmp15_, "doc-source", &_tmp16_);
#line 897 "/home/bob/git/simple-scan/src/scanner.vala"
			index = (SANE_Int) _tmp16_;
#line 897 "/home/bob/git/simple-scan/src/scanner.vala"
			option = _tmp17_;
#line 9190 "scanner.c"
		}
#line 899 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp18_ = option;
#line 899 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp18_ != NULL) {
#line 9196 "scanner.c"
			gchar** flatbed_sources = NULL;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar** _tmp29_;
			gint flatbed_sources_length1;
			gint _flatbed_sources_size_;
			gchar** adf_sources = NULL;
			gchar* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar** _tmp37_;
			gint adf_sources_length1;
			gint _adf_sources_size_;
			gchar** adf_front_sources = NULL;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			gchar* _tmp40_;
			gchar** _tmp41_;
			gint adf_front_sources_length1;
			gint _adf_front_sources_size_;
			gchar** adf_back_sources = NULL;
			gchar* _tmp42_;
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar** _tmp45_;
			gint adf_back_sources_length1;
			gint _adf_back_sources_size_;
			gchar** adf_duplex_sources = NULL;
			gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar** _tmp54_;
			gint adf_duplex_sources_length1;
			gint _adf_duplex_sources_size_;
			ScanJob* _tmp55_;
			ScanType _tmp56_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp19_ = g_strdup ("Auto");
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp20_ = SANE_I18N ("Auto");
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp21_ = g_strdup (_tmp20_);
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp22_ = g_strdup ("Flatbed");
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp23_ = SANE_I18N ("Flatbed");
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp24_ = g_strdup (_tmp23_);
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp25_ = g_strdup ("FlatBed");
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp26_ = g_strdup ("Normal");
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp27_ = SANE_I18N ("Normal");
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_ = g_new0 (gchar*, 7 + 1);
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_[0] = _tmp19_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_[1] = _tmp21_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_[2] = _tmp22_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_[3] = _tmp24_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_[4] = _tmp25_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_[5] = _tmp26_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp29_[6] = _tmp28_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			flatbed_sources = _tmp29_;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			flatbed_sources_length1 = 7;
#line 901 "/home/bob/git/simple-scan/src/scanner.vala"
			_flatbed_sources_size_ = flatbed_sources_length1;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp30_ = g_strdup ("Automatic Document Feeder");
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp31_ = SANE_I18N ("Automatic Document Feeder");
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp32_ = g_strdup (_tmp31_);
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp33_ = g_strdup ("ADF");
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp34_ = g_strdup ("Automatic Document Feeder(left aligned)");
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp35_ = g_strdup ("Automatic Document Feeder(centrally aligned)");
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp36_ = g_strdup ("ADF Simplex");
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp37_ = g_new0 (gchar*, 6 + 1);
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp37_[0] = _tmp30_;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp37_[1] = _tmp32_;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp37_[2] = _tmp33_;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp37_[3] = _tmp34_;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp37_[4] = _tmp35_;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp37_[5] = _tmp36_;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_sources = _tmp37_;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_sources_length1 = 6;
#line 912 "/home/bob/git/simple-scan/src/scanner.vala"
			_adf_sources_size_ = adf_sources_length1;
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp38_ = g_strdup ("ADF Front");
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp39_ = SANE_I18N ("ADF Front");
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp40_ = g_strdup (_tmp39_);
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp41_ = g_new0 (gchar*, 2 + 1);
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp41_[0] = _tmp38_;
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp41_[1] = _tmp40_;
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_front_sources = _tmp41_;
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_front_sources_length1 = 2;
#line 922 "/home/bob/git/simple-scan/src/scanner.vala"
			_adf_front_sources_size_ = adf_front_sources_length1;
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp42_ = g_strdup ("ADF Back");
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp43_ = SANE_I18N ("ADF Back");
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp44_ = g_strdup (_tmp43_);
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp45_ = g_new0 (gchar*, 2 + 1);
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp45_[0] = _tmp42_;
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp45_[1] = _tmp44_;
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_back_sources = _tmp45_;
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_back_sources_length1 = 2;
#line 928 "/home/bob/git/simple-scan/src/scanner.vala"
			_adf_back_sources_size_ = adf_back_sources_length1;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp46_ = g_strdup ("ADF Duplex");
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp47_ = SANE_I18N ("ADF Duplex");
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp48_ = g_strdup (_tmp47_);
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp49_ = g_strdup ("ADF Duplex - Long-Edge Binding");
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp50_ = g_strdup ("ADF Duplex - Short-Edge Binding");
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp51_ = g_strdup ("Duplex");
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp52_ = g_strdup ("Automatic Document Feeder(centrally aligned,Duplex)");
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp53_ = g_strdup ("Automatic Document Feeder(left aligned,Duplex)");
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp54_ = g_new0 (gchar*, 7 + 1);
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp54_[0] = _tmp46_;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp54_[1] = _tmp48_;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp54_[2] = _tmp49_;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp54_[3] = _tmp50_;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp54_[4] = _tmp51_;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp54_[5] = _tmp52_;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp54_[6] = _tmp53_;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_duplex_sources = _tmp54_;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_duplex_sources_length1 = 7;
#line 934 "/home/bob/git/simple-scan/src/scanner.vala"
			_adf_duplex_sources_size_ = adf_duplex_sources_length1;
#line 945 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp55_ = job;
#line 945 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp56_ = _tmp55_->type;
#line 945 "/home/bob/git/simple-scan/src/scanner.vala"
			switch (_tmp56_) {
#line 945 "/home/bob/git/simple-scan/src/scanner.vala"
				case SCAN_TYPE_SINGLE:
#line 9408 "scanner.c"
				{
					SANE_Handle _tmp57_;
					SANE_Option_Descriptor* _tmp58_;
					SANE_Int _tmp59_;
#line 948 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp57_ = self->priv->handle;
#line 948 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp58_ = option;
#line 948 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp59_ = index;
#line 948 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!scanner_set_default_option (self, _tmp57_, _tmp58_, _tmp59_)) {
#line 9421 "scanner.c"
						SANE_Handle _tmp60_;
						SANE_Option_Descriptor* _tmp61_;
						SANE_Int _tmp62_;
						gchar** _tmp63_;
						gint _tmp63__length1;
						gboolean _tmp64_;
#line 949 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp60_ = self->priv->handle;
#line 949 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp61_ = option;
#line 949 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp62_ = index;
#line 949 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp63_ = flatbed_sources;
#line 949 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp63__length1 = flatbed_sources_length1;
#line 949 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp64_ = scanner_set_constrained_string_option (self, _tmp60_, _tmp61_, _tmp62_, _tmp63_, _tmp63__length1, NULL);
#line 949 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp64_) {
#line 950 "/home/bob/git/simple-scan/src/scanner.vala"
							g_warning ("scanner.vala:950: Unable to set single page source, please file a bug");
#line 9444 "scanner.c"
						}
					}
#line 951 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 9449 "scanner.c"
				}
#line 945 "/home/bob/git/simple-scan/src/scanner.vala"
				case SCAN_TYPE_ADF_FRONT:
#line 9453 "scanner.c"
				{
					SANE_Handle _tmp65_;
					SANE_Option_Descriptor* _tmp66_;
					SANE_Int _tmp67_;
					gchar** _tmp68_;
					gint _tmp68__length1;
					gboolean _tmp69_;
#line 953 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp65_ = self->priv->handle;
#line 953 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp66_ = option;
#line 953 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp67_ = index;
#line 953 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp68_ = adf_front_sources;
#line 953 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp68__length1 = adf_front_sources_length1;
#line 953 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp69_ = scanner_set_constrained_string_option (self, _tmp65_, _tmp66_, _tmp67_, _tmp68_, _tmp68__length1, NULL);
#line 953 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!_tmp69_) {
#line 9475 "scanner.c"
						SANE_Handle _tmp70_;
						SANE_Option_Descriptor* _tmp71_;
						SANE_Int _tmp72_;
						gchar** _tmp73_;
						gint _tmp73__length1;
						gboolean _tmp74_;
#line 954 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp70_ = self->priv->handle;
#line 954 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp71_ = option;
#line 954 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp72_ = index;
#line 954 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp73_ = adf_sources;
#line 954 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp73__length1 = adf_sources_length1;
#line 954 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp74_ = scanner_set_constrained_string_option (self, _tmp70_, _tmp71_, _tmp72_, _tmp73_, _tmp73__length1, NULL);
#line 954 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp74_) {
#line 955 "/home/bob/git/simple-scan/src/scanner.vala"
							g_warning ("scanner.vala:955: Unable to set front ADF source, please file a bug");
#line 9498 "scanner.c"
						}
					}
#line 956 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 9503 "scanner.c"
				}
#line 945 "/home/bob/git/simple-scan/src/scanner.vala"
				case SCAN_TYPE_ADF_BACK:
#line 9507 "scanner.c"
				{
					SANE_Handle _tmp75_;
					SANE_Option_Descriptor* _tmp76_;
					SANE_Int _tmp77_;
					gchar** _tmp78_;
					gint _tmp78__length1;
					gboolean _tmp79_;
#line 958 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp75_ = self->priv->handle;
#line 958 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp76_ = option;
#line 958 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp77_ = index;
#line 958 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp78_ = adf_back_sources;
#line 958 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp78__length1 = adf_back_sources_length1;
#line 958 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp79_ = scanner_set_constrained_string_option (self, _tmp75_, _tmp76_, _tmp77_, _tmp78_, _tmp78__length1, NULL);
#line 958 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!_tmp79_) {
#line 9529 "scanner.c"
						SANE_Handle _tmp80_;
						SANE_Option_Descriptor* _tmp81_;
						SANE_Int _tmp82_;
						gchar** _tmp83_;
						gint _tmp83__length1;
						gboolean _tmp84_;
#line 959 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp80_ = self->priv->handle;
#line 959 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp81_ = option;
#line 959 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp82_ = index;
#line 959 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp83_ = adf_sources;
#line 959 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp83__length1 = adf_sources_length1;
#line 959 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp84_ = scanner_set_constrained_string_option (self, _tmp80_, _tmp81_, _tmp82_, _tmp83_, _tmp83__length1, NULL);
#line 959 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp84_) {
#line 960 "/home/bob/git/simple-scan/src/scanner.vala"
							g_warning ("scanner.vala:960: Unable to set back ADF source, please file a bug");
#line 9552 "scanner.c"
						}
					}
#line 961 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 9557 "scanner.c"
				}
#line 945 "/home/bob/git/simple-scan/src/scanner.vala"
				case SCAN_TYPE_ADF_BOTH:
#line 9561 "scanner.c"
				{
					SANE_Handle _tmp85_;
					SANE_Option_Descriptor* _tmp86_;
					SANE_Int _tmp87_;
					gchar** _tmp88_;
					gint _tmp88__length1;
					gboolean _tmp89_;
#line 963 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp85_ = self->priv->handle;
#line 963 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp86_ = option;
#line 963 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp87_ = index;
#line 963 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp88_ = adf_duplex_sources;
#line 963 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp88__length1 = adf_duplex_sources_length1;
#line 963 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp89_ = scanner_set_constrained_string_option (self, _tmp85_, _tmp86_, _tmp87_, _tmp88_, _tmp88__length1, NULL);
#line 963 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!_tmp89_) {
#line 9583 "scanner.c"
						SANE_Handle _tmp90_;
						SANE_Option_Descriptor* _tmp91_;
						SANE_Int _tmp92_;
						gchar** _tmp93_;
						gint _tmp93__length1;
						gboolean _tmp94_;
#line 964 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp90_ = self->priv->handle;
#line 964 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp91_ = option;
#line 964 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp92_ = index;
#line 964 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp93_ = adf_sources;
#line 964 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp93__length1 = adf_sources_length1;
#line 964 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp94_ = scanner_set_constrained_string_option (self, _tmp90_, _tmp91_, _tmp92_, _tmp93_, _tmp93__length1, NULL);
#line 964 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp94_) {
#line 965 "/home/bob/git/simple-scan/src/scanner.vala"
							g_warning ("scanner.vala:965: Unable to set duplex ADF source, please file a bug");
#line 9606 "scanner.c"
						}
					}
#line 966 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 9611 "scanner.c"
				}
				default:
#line 945 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 9616 "scanner.c"
			}
#line 899 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_duplex_sources = (_vala_array_free (adf_duplex_sources, adf_duplex_sources_length1, (GDestroyNotify) g_free), NULL);
#line 899 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_back_sources = (_vala_array_free (adf_back_sources, adf_back_sources_length1, (GDestroyNotify) g_free), NULL);
#line 899 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_front_sources = (_vala_array_free (adf_front_sources, adf_front_sources_length1, (GDestroyNotify) g_free), NULL);
#line 899 "/home/bob/git/simple-scan/src/scanner.vala"
			adf_sources = (_vala_array_free (adf_sources, adf_sources_length1, (GDestroyNotify) g_free), NULL);
#line 899 "/home/bob/git/simple-scan/src/scanner.vala"
			flatbed_sources = (_vala_array_free (flatbed_sources, flatbed_sources_length1, (GDestroyNotify) g_free), NULL);
#line 9628 "scanner.c"
		}
#line 971 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp95_ = self->priv->handle;
#line 971 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp96_ = SANE_NAME_SCAN_MODE;
#line 971 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp98_ = scanner_get_option_by_name (self, _tmp95_, _tmp96_, &_tmp97_);
#line 971 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp97_;
#line 971 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp98_;
#line 972 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp99_ = option;
#line 972 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp99_ != NULL) {
#line 9644 "scanner.c"
			gchar** color_scan_modes = NULL;
			const gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar** _tmp105_;
			gint color_scan_modes_length1;
			gint _color_scan_modes_size_;
			gchar** gray_scan_modes = NULL;
			const gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			const gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			gchar** _tmp114_;
			gint gray_scan_modes_length1;
			gint _gray_scan_modes_size_;
			gchar** lineart_scan_modes = NULL;
			const gchar* _tmp115_;
			gchar* _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			const gchar* _tmp119_;
			gchar* _tmp120_;
			gchar* _tmp121_;
			const gchar* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			const gchar* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			const gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			const gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			gchar** _tmp137_;
			gint lineart_scan_modes_length1;
			gint _lineart_scan_modes_size_;
			ScanJob* _tmp138_;
			ScanMode _tmp139_;
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp100_ = SANE_VALUE_SCAN_MODE_COLOR;
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp101_ = g_strdup (_tmp100_);
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp102_ = g_strdup ("Color");
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp103_ = g_strdup ("24bit Color");
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp104_ = g_strdup ("Color - 16 Million Colors");
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp105_ = g_new0 (gchar*, 4 + 1);
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp105_[0] = _tmp101_;
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp105_[1] = _tmp102_;
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp105_[2] = _tmp103_;
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp105_[3] = _tmp104_;
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			color_scan_modes = _tmp105_;
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			color_scan_modes_length1 = 4;
#line 975 "/home/bob/git/simple-scan/src/scanner.vala"
			_color_scan_modes_size_ = color_scan_modes_length1;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp106_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp107_ = g_strdup (_tmp106_);
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp108_ = g_strdup ("Gray");
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp109_ = g_strdup ("Grayscale");
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp110_ = SANE_I18N ("Grayscale");
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp111_ = g_strdup (_tmp110_);
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp112_ = g_strdup ("True Gray");
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp113_ = g_strdup ("Grayscale - 256 Levels");
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp114_ = g_new0 (gchar*, 6 + 1);
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp114_[0] = _tmp107_;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp114_[1] = _tmp108_;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp114_[2] = _tmp109_;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp114_[3] = _tmp111_;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp114_[4] = _tmp112_;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp114_[5] = _tmp113_;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			gray_scan_modes = _tmp114_;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			gray_scan_modes_length1 = 6;
#line 982 "/home/bob/git/simple-scan/src/scanner.vala"
			_gray_scan_modes_size_ = gray_scan_modes_length1;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp115_ = SANE_VALUE_SCAN_MODE_LINEART;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp116_ = g_strdup (_tmp115_);
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp117_ = g_strdup ("Lineart");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp118_ = g_strdup ("LineArt");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp119_ = SANE_I18N ("LineArt");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp120_ = g_strdup (_tmp119_);
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp121_ = g_strdup ("Black & White");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp122_ = SANE_I18N ("Black & White");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp123_ = g_strdup (_tmp122_);
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp124_ = g_strdup ("Binary");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp125_ = SANE_I18N ("Binary");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp126_ = g_strdup (_tmp125_);
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp127_ = g_strdup ("Thresholded");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp128_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp129_ = g_strdup (_tmp128_);
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp130_ = g_strdup ("Gray");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp131_ = g_strdup ("Grayscale");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp132_ = SANE_I18N ("Grayscale");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp133_ = g_strdup (_tmp132_);
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp134_ = g_strdup ("True Gray");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp135_ = g_strdup ("Black and White - Line Art");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp136_ = g_strdup ("Black and White - Halftone");
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_ = g_new0 (gchar*, 16 + 1);
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[0] = _tmp116_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[1] = _tmp117_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[2] = _tmp118_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[3] = _tmp120_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[4] = _tmp121_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[5] = _tmp123_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[6] = _tmp124_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[7] = _tmp126_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[8] = _tmp127_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[9] = _tmp129_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[10] = _tmp130_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[11] = _tmp131_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[12] = _tmp133_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[13] = _tmp134_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[14] = _tmp135_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp137_[15] = _tmp136_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			lineart_scan_modes = _tmp137_;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			lineart_scan_modes_length1 = 16;
#line 991 "/home/bob/git/simple-scan/src/scanner.vala"
			_lineart_scan_modes_size_ = lineart_scan_modes_length1;
#line 1011 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp138_ = job;
#line 1011 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp139_ = _tmp138_->scan_mode;
#line 1011 "/home/bob/git/simple-scan/src/scanner.vala"
			switch (_tmp139_) {
#line 1011 "/home/bob/git/simple-scan/src/scanner.vala"
				case SCAN_MODE_COLOR:
#line 9848 "scanner.c"
				{
					SANE_Handle _tmp140_;
					SANE_Option_Descriptor* _tmp141_;
					SANE_Int _tmp142_;
					gchar** _tmp143_;
					gint _tmp143__length1;
					gboolean _tmp144_;
#line 1014 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp140_ = self->priv->handle;
#line 1014 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp141_ = option;
#line 1014 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp142_ = index;
#line 1014 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp143_ = color_scan_modes;
#line 1014 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp143__length1 = color_scan_modes_length1;
#line 1014 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp144_ = scanner_set_constrained_string_option (self, _tmp140_, _tmp141_, _tmp142_, _tmp143_, _tmp143__length1, NULL);
#line 1014 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!_tmp144_) {
#line 1015 "/home/bob/git/simple-scan/src/scanner.vala"
						g_warning ("scanner.vala:1015: Unable to set Color mode, please file a bug");
#line 9872 "scanner.c"
					}
#line 1016 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 9876 "scanner.c"
				}
#line 1011 "/home/bob/git/simple-scan/src/scanner.vala"
				case SCAN_MODE_GRAY:
#line 9880 "scanner.c"
				{
					SANE_Handle _tmp145_;
					SANE_Option_Descriptor* _tmp146_;
					SANE_Int _tmp147_;
					gchar** _tmp148_;
					gint _tmp148__length1;
					gboolean _tmp149_;
#line 1018 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp145_ = self->priv->handle;
#line 1018 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp146_ = option;
#line 1018 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp147_ = index;
#line 1018 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp148_ = gray_scan_modes;
#line 1018 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp148__length1 = gray_scan_modes_length1;
#line 1018 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp149_ = scanner_set_constrained_string_option (self, _tmp145_, _tmp146_, _tmp147_, _tmp148_, _tmp148__length1, NULL);
#line 1018 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!_tmp149_) {
#line 1019 "/home/bob/git/simple-scan/src/scanner.vala"
						g_warning ("scanner.vala:1019: Unable to set Gray mode, please file a bug");
#line 9904 "scanner.c"
					}
#line 1020 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 9908 "scanner.c"
				}
#line 1011 "/home/bob/git/simple-scan/src/scanner.vala"
				case SCAN_MODE_LINEART:
#line 9912 "scanner.c"
				{
					SANE_Handle _tmp150_;
					SANE_Option_Descriptor* _tmp151_;
					SANE_Int _tmp152_;
					gchar** _tmp153_;
					gint _tmp153__length1;
					gboolean _tmp154_;
#line 1022 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp150_ = self->priv->handle;
#line 1022 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp151_ = option;
#line 1022 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp152_ = index;
#line 1022 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp153_ = lineart_scan_modes;
#line 1022 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp153__length1 = lineart_scan_modes_length1;
#line 1022 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp154_ = scanner_set_constrained_string_option (self, _tmp150_, _tmp151_, _tmp152_, _tmp153_, _tmp153__length1, NULL);
#line 1022 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!_tmp154_) {
#line 1023 "/home/bob/git/simple-scan/src/scanner.vala"
						g_warning ("scanner.vala:1023: Unable to set Lineart mode, please file a bug");
#line 9936 "scanner.c"
					}
#line 1024 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 9940 "scanner.c"
				}
				default:
				{
#line 1026 "/home/bob/git/simple-scan/src/scanner.vala"
					break;
#line 9946 "scanner.c"
				}
			}
#line 972 "/home/bob/git/simple-scan/src/scanner.vala"
			lineart_scan_modes = (_vala_array_free (lineart_scan_modes, lineart_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 972 "/home/bob/git/simple-scan/src/scanner.vala"
			gray_scan_modes = (_vala_array_free (gray_scan_modes, gray_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 972 "/home/bob/git/simple-scan/src/scanner.vala"
			color_scan_modes = (_vala_array_free (color_scan_modes, color_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 9955 "scanner.c"
		}
#line 1031 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp155_ = self->priv->handle;
#line 1031 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp157_ = scanner_get_option_by_name (self, _tmp155_, "duplex", &_tmp156_);
#line 1031 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp156_;
#line 1031 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp157_;
#line 1032 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp158_ = option;
#line 1032 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp158_ != NULL) {
#line 9969 "scanner.c"
			SANE_Option_Descriptor* _tmp159_;
			SANE_Value_Type _tmp160_;
#line 1034 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp159_ = option;
#line 1034 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp160_ = _tmp159_->type;
#line 1034 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp160_ == SANE_TYPE_BOOL) {
#line 9978 "scanner.c"
				SANE_Handle _tmp161_;
				SANE_Option_Descriptor* _tmp162_;
				SANE_Int _tmp163_;
				ScanJob* _tmp164_;
				ScanType _tmp165_;
#line 1035 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp161_ = self->priv->handle;
#line 1035 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp162_ = option;
#line 1035 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp163_ = index;
#line 1035 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp164_ = job;
#line 1035 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp165_ = _tmp164_->type;
#line 1035 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_bool_option (self, _tmp161_, _tmp162_, _tmp163_, _tmp165_ == SCAN_TYPE_ADF_BOTH, NULL);
#line 9996 "scanner.c"
			}
		}
#line 1039 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp166_ = self->priv->handle;
#line 1039 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp168_ = scanner_get_option_by_name (self, _tmp166_, "batch-scan", &_tmp167_);
#line 1039 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp167_;
#line 1039 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp168_;
#line 1040 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp169_ = option;
#line 1040 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp169_ != NULL) {
#line 10011 "scanner.c"
			SANE_Option_Descriptor* _tmp170_;
			SANE_Value_Type _tmp171_;
#line 1042 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp170_ = option;
#line 1042 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp171_ = _tmp170_->type;
#line 1042 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp171_ == SANE_TYPE_BOOL) {
#line 10020 "scanner.c"
				SANE_Handle _tmp172_;
				SANE_Option_Descriptor* _tmp173_;
				SANE_Int _tmp174_;
				ScanJob* _tmp175_;
				ScanType _tmp176_;
#line 1043 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp172_ = self->priv->handle;
#line 1043 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp173_ = option;
#line 1043 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp174_ = index;
#line 1043 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp175_ = job;
#line 1043 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp176_ = _tmp175_->type;
#line 1043 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_bool_option (self, _tmp172_, _tmp173_, _tmp174_, _tmp176_ != SCAN_TYPE_SINGLE, NULL);
#line 10038 "scanner.c"
			}
		}
#line 1047 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp177_ = self->priv->handle;
#line 1047 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp179_ = scanner_get_option_by_name (self, _tmp177_, "compression", &_tmp178_);
#line 1047 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp178_;
#line 1047 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp179_;
#line 1048 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp180_ = option;
#line 1048 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp180_ != NULL) {
#line 10053 "scanner.c"
			gchar** disable_compression_names = NULL;
			const gchar* _tmp181_;
			gchar* _tmp182_;
			const gchar* _tmp183_;
			gchar* _tmp184_;
			gchar* _tmp185_;
			gchar* _tmp186_;
			gchar** _tmp187_;
			gint disable_compression_names_length1;
			gint _disable_compression_names_size_;
			SANE_Handle _tmp188_;
			SANE_Option_Descriptor* _tmp189_;
			SANE_Int _tmp190_;
			gchar** _tmp191_;
			gint _tmp191__length1;
			gboolean _tmp192_;
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp181_ = SANE_I18N ("None");
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp182_ = g_strdup (_tmp181_);
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp183_ = SANE_I18N ("none");
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp184_ = g_strdup (_tmp183_);
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp185_ = g_strdup ("None");
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp186_ = g_strdup ("none");
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp187_ = g_new0 (gchar*, 4 + 1);
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp187_[0] = _tmp182_;
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp187_[1] = _tmp184_;
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp187_[2] = _tmp185_;
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp187_[3] = _tmp186_;
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			disable_compression_names = _tmp187_;
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			disable_compression_names_length1 = 4;
#line 1050 "/home/bob/git/simple-scan/src/scanner.vala"
			_disable_compression_names_size_ = disable_compression_names_length1;
#line 1058 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp188_ = self->priv->handle;
#line 1058 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp189_ = option;
#line 1058 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp190_ = index;
#line 1058 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp191_ = disable_compression_names;
#line 1058 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp191__length1 = disable_compression_names_length1;
#line 1058 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp192_ = scanner_set_constrained_string_option (self, _tmp188_, _tmp189_, _tmp190_, _tmp191_, _tmp191__length1, NULL);
#line 1058 "/home/bob/git/simple-scan/src/scanner.vala"
			if (!_tmp192_) {
#line 1059 "/home/bob/git/simple-scan/src/scanner.vala"
				g_warning ("scanner.vala:1059: Unable to disable compression, please file a bug");
#line 10114 "scanner.c"
			}
#line 1048 "/home/bob/git/simple-scan/src/scanner.vala"
			disable_compression_names = (_vala_array_free (disable_compression_names, disable_compression_names_length1, (GDestroyNotify) g_free), NULL);
#line 10118 "scanner.c"
		}
#line 1063 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp193_ = self->priv->handle;
#line 1063 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp194_ = SANE_NAME_SCAN_RESOLUTION;
#line 1063 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp196_ = scanner_get_option_by_name (self, _tmp193_, _tmp194_, &_tmp195_);
#line 1063 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp195_;
#line 1063 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp196_;
#line 1064 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp197_ = option;
#line 1064 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp197_ != NULL) {
#line 10134 "scanner.c"
			SANE_Handle _tmp198_;
			SANE_Option_Descriptor* _tmp199_;
			SANE_Int _tmp200_;
			ScanJob* _tmp201_;
			gdouble _tmp202_;
			ScanJob* _tmp203_;
			gdouble _tmp204_ = 0.0;
			SANE_Handle _tmp205_;
			const gchar* _tmp206_;
			gint _tmp207_ = 0;
			SANE_Option_Descriptor* _tmp208_;
			SANE_Option_Descriptor* _tmp209_;
#line 1066 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp198_ = self->priv->handle;
#line 1066 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp199_ = option;
#line 1066 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp200_ = index;
#line 1066 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp201_ = job;
#line 1066 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp202_ = _tmp201_->dpi;
#line 1066 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp203_ = job;
#line 1066 "/home/bob/git/simple-scan/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp198_, _tmp199_, _tmp200_, _tmp202_, &_tmp204_);
#line 1066 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp203_->dpi = _tmp204_;
#line 1067 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp205_ = self->priv->handle;
#line 1067 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp206_ = SANE_NAME_BIT_DEPTH;
#line 1067 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp208_ = scanner_get_option_by_name (self, _tmp205_, _tmp206_, &_tmp207_);
#line 1067 "/home/bob/git/simple-scan/src/scanner.vala"
			index = (SANE_Int) _tmp207_;
#line 1067 "/home/bob/git/simple-scan/src/scanner.vala"
			option = _tmp208_;
#line 1068 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp209_ = option;
#line 1068 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp209_ != NULL) {
#line 10177 "scanner.c"
				ScanJob* _tmp210_;
				gint _tmp211_;
#line 1070 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp210_ = job;
#line 1070 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp211_ = _tmp210_->depth;
#line 1070 "/home/bob/git/simple-scan/src/scanner.vala"
				if (_tmp211_ > 0) {
#line 10186 "scanner.c"
					SANE_Handle _tmp212_;
					SANE_Option_Descriptor* _tmp213_;
					SANE_Int _tmp214_;
					ScanJob* _tmp215_;
					gint _tmp216_;
#line 1071 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp212_ = self->priv->handle;
#line 1071 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp213_ = option;
#line 1071 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp214_ = index;
#line 1071 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp215_ = job;
#line 1071 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp216_ = _tmp215_->depth;
#line 1071 "/home/bob/git/simple-scan/src/scanner.vala"
					scanner_set_int_option (self, _tmp212_, _tmp213_, _tmp214_, _tmp216_, NULL);
#line 10204 "scanner.c"
				}
			}
		}
#line 1076 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp217_ = self->priv->handle;
#line 1076 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp218_ = SANE_NAME_SCAN_BR_X;
#line 1076 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp220_ = scanner_get_option_by_name (self, _tmp217_, _tmp218_, &_tmp219_);
#line 1076 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp219_;
#line 1076 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp220_;
#line 1077 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp221_ = option;
#line 1077 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp221_ != NULL) {
#line 10222 "scanner.c"
			ScanJob* _tmp222_;
			gint _tmp223_;
#line 1079 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp222_ = job;
#line 1079 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp223_ = _tmp222_->page_width;
#line 1079 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp223_ > 0) {
#line 10231 "scanner.c"
				SANE_Handle _tmp224_;
				SANE_Option_Descriptor* _tmp225_;
				SANE_Int _tmp226_;
				SANE_Option_Descriptor* _tmp227_;
				ScanJob* _tmp228_;
				gint _tmp229_;
				ScanJob* _tmp230_;
				gdouble _tmp231_;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp224_ = self->priv->handle;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp225_ = option;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp226_ = index;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp227_ = option;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp228_ = job;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp229_ = _tmp228_->page_width;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp230_ = job;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp231_ = _tmp230_->dpi;
#line 1080 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp224_, _tmp225_, _tmp226_, scanner_convert_page_size (self, _tmp227_, (gdouble) _tmp229_, _tmp231_), NULL);
#line 10258 "scanner.c"
			} else {
				SANE_Handle _tmp232_;
				SANE_Option_Descriptor* _tmp233_;
				SANE_Int _tmp234_;
#line 1082 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp232_ = self->priv->handle;
#line 1082 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp233_ = option;
#line 1082 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp234_ = index;
#line 1082 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp232_, _tmp233_, _tmp234_);
#line 10271 "scanner.c"
			}
		}
#line 1084 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp235_ = self->priv->handle;
#line 1084 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp236_ = SANE_NAME_SCAN_BR_Y;
#line 1084 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp238_ = scanner_get_option_by_name (self, _tmp235_, _tmp236_, &_tmp237_);
#line 1084 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp237_;
#line 1084 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp238_;
#line 1085 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp239_ = option;
#line 1085 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp239_ != NULL) {
#line 10288 "scanner.c"
			ScanJob* _tmp240_;
			gint _tmp241_;
#line 1087 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp240_ = job;
#line 1087 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp241_ = _tmp240_->page_height;
#line 1087 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp241_ > 0) {
#line 10297 "scanner.c"
				SANE_Handle _tmp242_;
				SANE_Option_Descriptor* _tmp243_;
				SANE_Int _tmp244_;
				SANE_Option_Descriptor* _tmp245_;
				ScanJob* _tmp246_;
				gint _tmp247_;
				ScanJob* _tmp248_;
				gdouble _tmp249_;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp242_ = self->priv->handle;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp243_ = option;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp244_ = index;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp245_ = option;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp246_ = job;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp247_ = _tmp246_->page_height;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp248_ = job;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp249_ = _tmp248_->dpi;
#line 1088 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp242_, _tmp243_, _tmp244_, scanner_convert_page_size (self, _tmp245_, (gdouble) _tmp247_, _tmp249_), NULL);
#line 10324 "scanner.c"
			} else {
				SANE_Handle _tmp250_;
				SANE_Option_Descriptor* _tmp251_;
				SANE_Int _tmp252_;
#line 1090 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp250_ = self->priv->handle;
#line 1090 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp251_ = option;
#line 1090 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp252_ = index;
#line 1090 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp250_, _tmp251_, _tmp252_);
#line 10337 "scanner.c"
			}
		}
#line 1094 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp253_ = self->priv->handle;
#line 1094 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp254_ = SANE_NAME_PAGE_WIDTH;
#line 1094 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp256_ = scanner_get_option_by_name (self, _tmp253_, _tmp254_, &_tmp255_);
#line 1094 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp255_;
#line 1094 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp256_;
#line 1095 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp258_ = option;
#line 1095 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp258_ != NULL) {
#line 10354 "scanner.c"
			ScanJob* _tmp259_;
			gint _tmp260_;
#line 1095 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp259_ = job;
#line 1095 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp260_ = _tmp259_->page_width;
#line 1095 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp257_ = ((gdouble) _tmp260_) > 0.0;
#line 10363 "scanner.c"
		} else {
#line 1095 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp257_ = FALSE;
#line 10367 "scanner.c"
		}
#line 1095 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp257_) {
#line 10371 "scanner.c"
			SANE_Handle _tmp261_;
			SANE_Option_Descriptor* _tmp262_;
			SANE_Int _tmp263_;
			SANE_Option_Descriptor* _tmp264_;
			ScanJob* _tmp265_;
			gint _tmp266_;
			ScanJob* _tmp267_;
			gdouble _tmp268_;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp261_ = self->priv->handle;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp262_ = option;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp263_ = index;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp264_ = option;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp265_ = job;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp266_ = _tmp265_->page_width;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp267_ = job;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp268_ = _tmp267_->dpi;
#line 1096 "/home/bob/git/simple-scan/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp261_, _tmp262_, _tmp263_, scanner_convert_page_size (self, _tmp264_, (gdouble) _tmp266_, _tmp268_), NULL);
#line 10398 "scanner.c"
		}
#line 1097 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp269_ = self->priv->handle;
#line 1097 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp270_ = SANE_NAME_PAGE_HEIGHT;
#line 1097 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp272_ = scanner_get_option_by_name (self, _tmp269_, _tmp270_, &_tmp271_);
#line 1097 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp271_;
#line 1097 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp272_;
#line 1098 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp274_ = option;
#line 1098 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp274_ != NULL) {
#line 10414 "scanner.c"
			ScanJob* _tmp275_;
			gint _tmp276_;
#line 1098 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp275_ = job;
#line 1098 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp276_ = _tmp275_->page_height;
#line 1098 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp273_ = ((gdouble) _tmp276_) > 0.0;
#line 10423 "scanner.c"
		} else {
#line 1098 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp273_ = FALSE;
#line 10427 "scanner.c"
		}
#line 1098 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp273_) {
#line 10431 "scanner.c"
			SANE_Handle _tmp277_;
			SANE_Option_Descriptor* _tmp278_;
			SANE_Int _tmp279_;
			SANE_Option_Descriptor* _tmp280_;
			ScanJob* _tmp281_;
			gint _tmp282_;
			ScanJob* _tmp283_;
			gdouble _tmp284_;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp277_ = self->priv->handle;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp278_ = option;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp279_ = index;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp280_ = option;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp281_ = job;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp282_ = _tmp281_->page_height;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp283_ = job;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp284_ = _tmp283_->dpi;
#line 1099 "/home/bob/git/simple-scan/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp277_, _tmp278_, _tmp279_, scanner_convert_page_size (self, _tmp280_, (gdouble) _tmp282_, _tmp284_), NULL);
#line 10458 "scanner.c"
		}
#line 1101 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp285_ = self->priv->handle;
#line 1101 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp286_ = SANE_NAME_BRIGHTNESS;
#line 1101 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp288_ = scanner_get_option_by_name (self, _tmp285_, _tmp286_, &_tmp287_);
#line 1101 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp287_;
#line 1101 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp288_;
#line 1102 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp289_ = option;
#line 1102 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp289_ != NULL) {
#line 10474 "scanner.c"
			ScanJob* _tmp290_;
			gint _tmp291_;
#line 1104 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp290_ = job;
#line 1104 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp291_ = _tmp290_->brightness;
#line 1104 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp291_ != 0) {
#line 10483 "scanner.c"
				gint brightness = 0;
				SANE_Option_Descriptor* _tmp292_;
				ScanJob* _tmp293_;
				gint _tmp294_;
				SANE_Handle _tmp295_;
				SANE_Option_Descriptor* _tmp296_;
				SANE_Int _tmp297_;
				gint _tmp298_;
#line 1106 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp292_ = option;
#line 1106 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp293_ = job;
#line 1106 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp294_ = _tmp293_->brightness;
#line 1106 "/home/bob/git/simple-scan/src/scanner.vala"
				brightness = scanner_scale_int (self, -100, 100, _tmp292_, _tmp294_);
#line 1107 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp295_ = self->priv->handle;
#line 1107 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp296_ = option;
#line 1107 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp297_ = index;
#line 1107 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp298_ = brightness;
#line 1107 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_int_option (self, _tmp295_, _tmp296_, _tmp297_, _tmp298_, NULL);
#line 10510 "scanner.c"
			}
		}
#line 1110 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp299_ = self->priv->handle;
#line 1110 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp300_ = SANE_NAME_CONTRAST;
#line 1110 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp302_ = scanner_get_option_by_name (self, _tmp299_, _tmp300_, &_tmp301_);
#line 1110 "/home/bob/git/simple-scan/src/scanner.vala"
		index = (SANE_Int) _tmp301_;
#line 1110 "/home/bob/git/simple-scan/src/scanner.vala"
		option = _tmp302_;
#line 1111 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp303_ = option;
#line 1111 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp303_ != NULL) {
#line 10527 "scanner.c"
			ScanJob* _tmp304_;
			gint _tmp305_;
#line 1113 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp304_ = job;
#line 1113 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp305_ = _tmp304_->contrast;
#line 1113 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp305_ != 0) {
#line 10536 "scanner.c"
				gint contrast = 0;
				SANE_Option_Descriptor* _tmp306_;
				ScanJob* _tmp307_;
				gint _tmp308_;
				SANE_Handle _tmp309_;
				SANE_Option_Descriptor* _tmp310_;
				SANE_Int _tmp311_;
				gint _tmp312_;
#line 1115 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp306_ = option;
#line 1115 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp307_ = job;
#line 1115 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp308_ = _tmp307_->contrast;
#line 1115 "/home/bob/git/simple-scan/src/scanner.vala"
				contrast = scanner_scale_int (self, -100, 100, _tmp306_, _tmp308_);
#line 1116 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp309_ = self->priv->handle;
#line 1116 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp310_ = option;
#line 1116 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp311_ = index;
#line 1116 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp312_ = contrast;
#line 1116 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_int_option (self, _tmp309_, _tmp310_, _tmp311_, _tmp312_, NULL);
#line 10563 "scanner.c"
			}
		}
#line 1121 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp313_ = self->priv->current_device;
#line 1121 "/home/bob/git/simple-scan/src/scanner.vala"
		if (g_strcmp0 (_tmp313_, "test") == 0) {
#line 10570 "scanner.c"
			SANE_Handle _tmp314_;
			gint _tmp315_ = 0;
			SANE_Option_Descriptor* _tmp316_;
			SANE_Option_Descriptor* _tmp317_;
			SANE_Handle _tmp321_;
			gint _tmp322_ = 0;
			SANE_Option_Descriptor* _tmp323_;
			SANE_Option_Descriptor* _tmp324_;
			SANE_Handle _tmp328_;
			gint _tmp329_ = 0;
			SANE_Option_Descriptor* _tmp330_;
			SANE_Option_Descriptor* _tmp331_;
			SANE_Handle _tmp335_;
			gint _tmp336_ = 0;
			SANE_Option_Descriptor* _tmp337_;
			SANE_Option_Descriptor* _tmp338_;
			SANE_Handle _tmp342_;
			gint _tmp343_ = 0;
			SANE_Option_Descriptor* _tmp344_;
			SANE_Option_Descriptor* _tmp345_;
#line 1123 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp314_ = self->priv->handle;
#line 1123 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp316_ = scanner_get_option_by_name (self, _tmp314_, "hand-scanner", &_tmp315_);
#line 1123 "/home/bob/git/simple-scan/src/scanner.vala"
			index = (SANE_Int) _tmp315_;
#line 1123 "/home/bob/git/simple-scan/src/scanner.vala"
			option = _tmp316_;
#line 1124 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp317_ = option;
#line 1124 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp317_ != NULL) {
#line 10603 "scanner.c"
				SANE_Handle _tmp318_;
				SANE_Option_Descriptor* _tmp319_;
				SANE_Int _tmp320_;
#line 1125 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp318_ = self->priv->handle;
#line 1125 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp319_ = option;
#line 1125 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp320_ = index;
#line 1125 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_bool_option (self, _tmp318_, _tmp319_, _tmp320_, FALSE, NULL);
#line 10615 "scanner.c"
			}
#line 1126 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp321_ = self->priv->handle;
#line 1126 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp323_ = scanner_get_option_by_name (self, _tmp321_, "three-pass", &_tmp322_);
#line 1126 "/home/bob/git/simple-scan/src/scanner.vala"
			index = (SANE_Int) _tmp322_;
#line 1126 "/home/bob/git/simple-scan/src/scanner.vala"
			option = _tmp323_;
#line 1127 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp324_ = option;
#line 1127 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp324_ != NULL) {
#line 10629 "scanner.c"
				SANE_Handle _tmp325_;
				SANE_Option_Descriptor* _tmp326_;
				SANE_Int _tmp327_;
#line 1128 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp325_ = self->priv->handle;
#line 1128 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp326_ = option;
#line 1128 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp327_ = index;
#line 1128 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_bool_option (self, _tmp325_, _tmp326_, _tmp327_, FALSE, NULL);
#line 10641 "scanner.c"
			}
#line 1129 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp328_ = self->priv->handle;
#line 1129 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp330_ = scanner_get_option_by_name (self, _tmp328_, "test-picture", &_tmp329_);
#line 1129 "/home/bob/git/simple-scan/src/scanner.vala"
			index = (SANE_Int) _tmp329_;
#line 1129 "/home/bob/git/simple-scan/src/scanner.vala"
			option = _tmp330_;
#line 1130 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp331_ = option;
#line 1130 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp331_ != NULL) {
#line 10655 "scanner.c"
				SANE_Handle _tmp332_;
				SANE_Option_Descriptor* _tmp333_;
				SANE_Int _tmp334_;
#line 1131 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp332_ = self->priv->handle;
#line 1131 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp333_ = option;
#line 1131 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp334_ = index;
#line 1131 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_string_option (self, _tmp332_, _tmp333_, _tmp334_, "Color pattern", NULL);
#line 10667 "scanner.c"
			}
#line 1132 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp335_ = self->priv->handle;
#line 1132 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp337_ = scanner_get_option_by_name (self, _tmp335_, "read-delay", &_tmp336_);
#line 1132 "/home/bob/git/simple-scan/src/scanner.vala"
			index = (SANE_Int) _tmp336_;
#line 1132 "/home/bob/git/simple-scan/src/scanner.vala"
			option = _tmp337_;
#line 1133 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp338_ = option;
#line 1133 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp338_ != NULL) {
#line 10681 "scanner.c"
				SANE_Handle _tmp339_;
				SANE_Option_Descriptor* _tmp340_;
				SANE_Int _tmp341_;
#line 1134 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp339_ = self->priv->handle;
#line 1134 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp340_ = option;
#line 1134 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp341_ = index;
#line 1134 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_bool_option (self, _tmp339_, _tmp340_, _tmp341_, TRUE, NULL);
#line 10693 "scanner.c"
			}
#line 1135 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp342_ = self->priv->handle;
#line 1135 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp344_ = scanner_get_option_by_name (self, _tmp342_, "read-delay-duration", &_tmp343_);
#line 1135 "/home/bob/git/simple-scan/src/scanner.vala"
			index = (SANE_Int) _tmp343_;
#line 1135 "/home/bob/git/simple-scan/src/scanner.vala"
			option = _tmp344_;
#line 1136 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp345_ = option;
#line 1136 "/home/bob/git/simple-scan/src/scanner.vala"
			if (_tmp345_ != NULL) {
#line 10707 "scanner.c"
				SANE_Handle _tmp346_;
				SANE_Option_Descriptor* _tmp347_;
				SANE_Int _tmp348_;
#line 1137 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp346_ = self->priv->handle;
#line 1137 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp347_ = option;
#line 1137 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp348_ = index;
#line 1137 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_set_int_option (self, _tmp346_, _tmp347_, _tmp348_, 200000, NULL);
#line 10719 "scanner.c"
			}
		}
#line 1140 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1141 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1141 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 10728 "scanner.c"
	}
#line 1144 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp349_ = index;
#line 1144 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp350_ = option;
#line 1144 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_log_option (self, _tmp349_, _tmp350_);
#line 1147 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp351_ = option;
#line 1147 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp352_ = _tmp351_->type;
#line 1147 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp352_ == SANE_TYPE_GROUP) {
#line 1148 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1148 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 10746 "scanner.c"
	}
#line 1151 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp353_ = option;
#line 1151 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp354_ = _tmp353_->cap;
#line 1151 "/home/bob/git/simple-scan/src/scanner.vala"
	if ((_tmp354_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 1152 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1152 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 10758 "scanner.c"
	}
#line 1155 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp355_ = option;
#line 1155 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp356_ = _tmp355_->name;
#line 1155 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp356_ == NULL) {
#line 1156 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1156 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 10770 "scanner.c"
	}
#line 1158 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp357_ = self->priv->options;
#line 1158 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp358_ = option;
#line 1158 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp359_ = _tmp358_->name;
#line 1158 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp360_ = g_strdup (_tmp359_);
#line 1158 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp361_ = index;
#line 1158 "/home/bob/git/simple-scan/src/scanner.vala"
	g_hash_table_insert (_tmp357_, _tmp360_, (gpointer) ((gintptr) ((gint) _tmp361_)));
#line 880 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_job_unref0 (job);
#line 10786 "scanner.c"
}


static gdouble
scanner_convert_page_size (Scanner* self,
                           SANE_Option_Descriptor* option,
                           gdouble size,
                           gdouble dpi)
{
	gdouble result = 0.0;
	SANE_Unit _tmp0_;
#line 1161 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 1161 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0.0);
#line 1163 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = option->unit;
#line 1163 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_ == SANE_UNIT_PIXEL) {
#line 1164 "/home/bob/git/simple-scan/src/scanner.vala"
		result = (dpi * size) / 254.0;
#line 1164 "/home/bob/git/simple-scan/src/scanner.vala"
		return result;
#line 10810 "scanner.c"
	} else {
		SANE_Unit _tmp1_;
#line 1165 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp1_ = option->unit;
#line 1165 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp1_ == SANE_UNIT_MM) {
#line 1166 "/home/bob/git/simple-scan/src/scanner.vala"
			result = size / 10.0;
#line 1166 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 10821 "scanner.c"
		} else {
#line 1169 "/home/bob/git/simple-scan/src/scanner.vala"
			g_warning ("scanner.vala:1169: Unable to set unsupported unit type");
#line 1170 "/home/bob/git/simple-scan/src/scanner.vala"
			result = (gdouble) 0.0f;
#line 1170 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 10829 "scanner.c"
		}
	}
}


static SANE_Option_Descriptor*
scanner_get_option_by_name (Scanner* self,
                            SANE_Handle handle,
                            const gchar* name,
                            gint* index)
{
	gint _vala_index = 0;
	SANE_Option_Descriptor* result = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	SANE_Option_Descriptor* _tmp4_;
#line 1174 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1174 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1176 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->options;
#line 1176 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
#line 1176 "/home/bob/git/simple-scan/src/scanner.vala"
	_vala_index = (gint) ((gintptr) _tmp1_);
#line 1177 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = _vala_index;
#line 1177 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp2_ == 0) {
#line 1178 "/home/bob/git/simple-scan/src/scanner.vala"
		result = NULL;
#line 1178 "/home/bob/git/simple-scan/src/scanner.vala"
		if (index) {
#line 1178 "/home/bob/git/simple-scan/src/scanner.vala"
			*index = _vala_index;
#line 10868 "scanner.c"
		}
#line 1178 "/home/bob/git/simple-scan/src/scanner.vala"
		return result;
#line 10872 "scanner.c"
	}
#line 1180 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = _vala_index;
#line 1180 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = sane_get_option_descriptor (handle, (SANE_Int) _tmp3_);
#line 1180 "/home/bob/git/simple-scan/src/scanner.vala"
	result = _tmp4_;
#line 1180 "/home/bob/git/simple-scan/src/scanner.vala"
	if (index) {
#line 1180 "/home/bob/git/simple-scan/src/scanner.vala"
		*index = _vala_index;
#line 10884 "scanner.c"
	}
#line 1180 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 10888 "scanner.c"
}


static void
scanner_do_complete_document (Scanner* self)
{
	SANE_Handle _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	NotifyDocumentDone* _tmp3_;
	NotifyDocumentDone* _tmp4_;
#line 1183 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1185 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1185 "/home/bob/git/simple-scan/src/scanner.vala"
	sane_cancel (_tmp0_);
#line 1186 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1186: sane_cancel ()");
#line 1188 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = self->priv->job_queue;
#line 1188 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->job_queue = g_list_remove_link (self->priv->job_queue, _tmp1_);
#line 1190 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1193 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = self->priv->job_queue;
#line 1193 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 1195 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->state = SCAN_STATE_OPEN;
#line 1196 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 10922 "scanner.c"
	}
#line 1202 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = notify_document_done_new ();
#line 1202 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1202 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp4_);
#line 1202 "/home/bob/git/simple-scan/src/scanner.vala"
	_notify_unref0 (_tmp4_);
#line 1203 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 10934 "scanner.c"
}


static void
scanner_do_start (Scanner* self)
{
	SANE_Status status = 0;
	NotifyExpectPage* _tmp0_;
	NotifyExpectPage* _tmp1_;
	SANE_Handle _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	SANE_Status _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	SANE_Status _tmp8_;
#line 1206 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1210 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = notify_expect_page_new ();
#line 1210 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = _tmp0_;
#line 1210 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp1_);
#line 1210 "/home/bob/git/simple-scan/src/scanner.vala"
	_notify_unref0 (_tmp1_);
#line 1212 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = self->priv->handle;
#line 1212 "/home/bob/git/simple-scan/src/scanner.vala"
	status = sane_start (_tmp2_);
#line 1213 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = self->priv->page_number;
#line 1213 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = self->priv->pass_number;
#line 1213 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = status;
#line 1213 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp6_ = sane_status_to_string (_tmp5_);
#line 1213 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp7_ = _tmp6_;
#line 1213 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1213: sane_start (page=%d, pass=%d) -> %s", _tmp3_, _tmp4_, _tmp7_);
#line 1213 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp7_);
#line 1214 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp8_ = status;
#line 1214 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp8_ == SANE_STATUS_GOOD) {
#line 1215 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->state = SCAN_STATE_GET_PARAMETERS;
#line 10985 "scanner.c"
	} else {
		SANE_Status _tmp9_;
#line 1216 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp9_ = status;
#line 1216 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp9_ == SANE_STATUS_NO_DOCS) {
#line 1217 "/home/bob/git/simple-scan/src/scanner.vala"
			scanner_do_complete_document (self);
#line 10994 "scanner.c"
		} else {
			SANE_Status _tmp10_;
			const gchar* _tmp11_;
			SANE_Status _tmp12_;
#line 1220 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp10_ = status;
#line 1220 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp11_ = sane_strstatus (_tmp10_);
#line 1220 "/home/bob/git/simple-scan/src/scanner.vala"
			g_warning ("scanner.vala:1220: Unable to start device: %s", _tmp11_);
#line 1221 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp12_ = status;
#line 1221 "/home/bob/git/simple-scan/src/scanner.vala"
			scanner_fail_scan (self, (gint) _tmp12_, _ ("Unable to start scan"));
#line 11009 "scanner.c"
		}
	}
}


static gchar*
sane_frame_to_string (SANE_Frame frame)
{
	gchar* result = NULL;
#line 103 "/home/bob/git/simple-scan/src/sane.vapi"
	switch (frame) {
#line 103 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_FRAME_GRAY:
#line 11023 "scanner.c"
		{
			gchar* _tmp0_;
#line 106 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp0_ = g_strdup ("SANE_FRAME_GRAY");
#line 106 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp0_;
#line 106 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 11032 "scanner.c"
		}
#line 103 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_FRAME_RGB:
#line 11036 "scanner.c"
		{
			gchar* _tmp1_;
#line 108 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_FRAME_RGB");
#line 108 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp1_;
#line 108 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 11045 "scanner.c"
		}
#line 103 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_FRAME_RED:
#line 11049 "scanner.c"
		{
			gchar* _tmp2_;
#line 110 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_FRAME_RED");
#line 110 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp2_;
#line 110 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 11058 "scanner.c"
		}
#line 103 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_FRAME_GREEN:
#line 11062 "scanner.c"
		{
			gchar* _tmp3_;
#line 112 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_FRAME_GREEN");
#line 112 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp3_;
#line 112 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 11071 "scanner.c"
		}
#line 103 "/home/bob/git/simple-scan/src/sane.vapi"
		case SANE_FRAME_BLUE:
#line 11075 "scanner.c"
		{
			gchar* _tmp4_;
#line 114 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_FRAME_BLUE");
#line 114 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp4_;
#line 114 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 11084 "scanner.c"
		}
		default:
		{
			gchar* _tmp5_;
#line 116 "/home/bob/git/simple-scan/src/sane.vapi"
			_tmp5_ = g_strdup_printf ("SANE_FRAME(%d)", (gint) frame);
#line 116 "/home/bob/git/simple-scan/src/sane.vapi"
			result = _tmp5_;
#line 116 "/home/bob/git/simple-scan/src/sane.vapi"
			return result;
#line 11095 "scanner.c"
		}
	}
}


static void
scanner_do_get_parameters (Scanner* self)
{
	SANE_Status status = 0;
	SANE_Handle _tmp0_;
	SANE_Parameters _tmp1_ = {0};
	SANE_Status _tmp2_;
	SANE_Status _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SANE_Status _tmp6_;
	ScanJob* job = NULL;
	GList* _tmp10_;
	gconstpointer _tmp11_;
	ScanJob* _tmp12_;
	const gchar* _tmp13_ = NULL;
	SANE_Parameters _tmp14_;
	gboolean _tmp15_;
	SANE_Parameters _tmp16_;
	SANE_Frame _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	SANE_Parameters _tmp20_;
	gint _tmp21_;
	SANE_Parameters _tmp22_;
	gint _tmp23_;
	SANE_Parameters _tmp24_;
	gint _tmp25_;
	SANE_Parameters _tmp26_;
	gint _tmp27_;
	ScanPageInfo* info = NULL;
	ScanPageInfo* _tmp28_;
	ScanPageInfo* _tmp29_;
	SANE_Parameters _tmp30_;
	gint _tmp31_;
	ScanPageInfo* _tmp32_;
	SANE_Parameters _tmp33_;
	gint _tmp34_;
	ScanPageInfo* _tmp35_;
	SANE_Parameters _tmp36_;
	gint _tmp37_;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	SANE_Parameters _tmp41_;
	gint _tmp42_;
	gint _tmp52_ = 0;
	SANE_Parameters _tmp53_;
	SANE_Frame _tmp54_;
	ScanPageInfo* _tmp55_;
	ScanPageInfo* _tmp56_;
	ScanJob* _tmp57_;
	gdouble _tmp58_;
	ScanPageInfo* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gint buffer_size = 0;
	SANE_Parameters _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	guchar* _tmp73_;
#line 1227 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1229 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1229 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = sane_get_parameters (_tmp0_, &_tmp1_);
#line 1229 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->parameters = _tmp1_;
#line 1229 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp2_;
#line 1230 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = status;
#line 1230 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = sane_status_to_string (_tmp3_);
#line 1230 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = _tmp4_;
#line 1230 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1230: sane_get_parameters () -> %s", _tmp5_);
#line 1230 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp5_);
#line 1231 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp6_ = status;
#line 1231 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp6_ != SANE_STATUS_GOOD) {
#line 11188 "scanner.c"
		SANE_Status _tmp7_;
		const gchar* _tmp8_;
		SANE_Status _tmp9_;
#line 1233 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_ = status;
#line 1233 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp8_ = sane_strstatus (_tmp7_);
#line 1233 "/home/bob/git/simple-scan/src/scanner.vala"
		g_warning ("scanner.vala:1233: Unable to get device parameters: %s", _tmp8_);
#line 1234 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp9_ = status;
#line 1234 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp9_, _ ("Error communicating with scanner"));
#line 1237 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 11204 "scanner.c"
	}
#line 1240 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp10_ = self->priv->job_queue;
#line 1240 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp11_ = _tmp10_->data;
#line 1240 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp12_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp11_, TYPE_SCAN_JOB, ScanJob));
#line 1240 "/home/bob/git/simple-scan/src/scanner.vala"
	job = _tmp12_;
#line 1244 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp14_ = self->priv->parameters;
#line 1244 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp15_ = _tmp14_.last_frame;
#line 1244 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp15_) {
#line 1244 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp13_ = "SANE_TRUE";
#line 11222 "scanner.c"
	} else {
#line 1244 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp13_ = "SANE_FALSE";
#line 11226 "scanner.c"
	}
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp16_ = self->priv->parameters;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp17_ = _tmp16_.format;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp18_ = sane_frame_to_string (_tmp17_);
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp19_ = _tmp18_;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp20_ = self->priv->parameters;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp21_ = _tmp20_.bytes_per_line;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp22_ = self->priv->parameters;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp23_ = _tmp22_.pixels_per_line;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp24_ = self->priv->parameters;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp25_ = _tmp24_.lines;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp26_ = self->priv->parameters;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp27_ = _tmp26_.depth;
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1242: Parameters: format=%s last_frame=%s bytes_per_line=" \
"%d pixels_per_line=%d lines=%d depth=%d", _tmp19_, _tmp13_, _tmp21_, _tmp23_, _tmp25_, _tmp27_);
#line 1242 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp19_);
#line 1250 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp28_ = scan_page_info_new ();
#line 1250 "/home/bob/git/simple-scan/src/scanner.vala"
	info = _tmp28_;
#line 1251 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp29_ = info;
#line 1251 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp30_ = self->priv->parameters;
#line 1251 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp31_ = _tmp30_.pixels_per_line;
#line 1251 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp29_->width = _tmp31_;
#line 1252 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp32_ = info;
#line 1252 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp33_ = self->priv->parameters;
#line 1252 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp34_ = _tmp33_.lines;
#line 1252 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp32_->height = _tmp34_;
#line 1253 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp35_ = info;
#line 1253 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp36_ = self->priv->parameters;
#line 1253 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp37_ = _tmp36_.depth;
#line 1253 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp35_->depth = _tmp37_;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp41_ = self->priv->parameters;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp42_ = _tmp41_.depth;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp42_ == 8) {
#line 11290 "scanner.c"
		SANE_Parameters _tmp43_;
		SANE_Frame _tmp44_;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp43_ = self->priv->parameters;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp44_ = _tmp43_.format;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp40_ = _tmp44_ == SANE_FRAME_GRAY;
#line 11299 "scanner.c"
	} else {
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp40_ = FALSE;
#line 11303 "scanner.c"
	}
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp40_) {
#line 11307 "scanner.c"
		ScanJob* _tmp45_;
		gint _tmp46_;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp45_ = job;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp46_ = _tmp45_->depth;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp39_ = _tmp46_ == 2;
#line 11316 "scanner.c"
	} else {
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp39_ = FALSE;
#line 11320 "scanner.c"
	}
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp39_) {
#line 11324 "scanner.c"
		ScanJob* _tmp47_;
		ScanMode _tmp48_;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp47_ = job;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp48_ = _tmp47_->scan_mode;
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp38_ = _tmp48_ == SCAN_MODE_GRAY;
#line 11333 "scanner.c"
	} else {
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp38_ = FALSE;
#line 11337 "scanner.c"
	}
#line 1256 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp38_) {
#line 11341 "scanner.c"
		ScanPageInfo* _tmp49_;
		ScanJob* _tmp50_;
		gint _tmp51_;
#line 1257 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp49_ = info;
#line 1257 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp50_ = job;
#line 1257 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp51_ = _tmp50_->depth;
#line 1257 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp49_->depth = _tmp51_;
#line 11353 "scanner.c"
	}
#line 1258 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp53_ = self->priv->parameters;
#line 1258 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp54_ = _tmp53_.format;
#line 1258 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp54_ == SANE_FRAME_GRAY) {
#line 1258 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp52_ = 1;
#line 11363 "scanner.c"
	} else {
#line 1258 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp52_ = 3;
#line 11367 "scanner.c"
	}
#line 1258 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp55_ = info;
#line 1258 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp55_->n_channels = _tmp52_;
#line 1259 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp56_ = info;
#line 1259 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp57_ = job;
#line 1259 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp58_ = _tmp57_->dpi;
#line 1259 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp56_->dpi = _tmp58_;
#line 1260 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp59_ = info;
#line 1260 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp60_ = self->priv->current_device;
#line 1260 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp61_ = g_strdup (_tmp60_);
#line 1260 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp59_->device);
#line 1260 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp59_->device = _tmp61_;
#line 1262 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp62_ = self->priv->page_number;
#line 1262 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp63_ = self->priv->notified_page;
#line 1262 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp62_ != _tmp63_) {
#line 11397 "scanner.c"
		ScanJob* _tmp64_;
		gint _tmp65_;
		ScanPageInfo* _tmp66_;
		NotifyGotPageInfo* _tmp67_;
		NotifyGotPageInfo* _tmp68_;
		gint _tmp69_;
#line 1264 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp64_ = job;
#line 1264 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp65_ = _tmp64_->id;
#line 1264 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp66_ = info;
#line 1264 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp67_ = notify_got_page_info_new (_tmp65_, _tmp66_);
#line 1264 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp68_ = _tmp67_;
#line 1264 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp68_);
#line 1264 "/home/bob/git/simple-scan/src/scanner.vala"
		_notify_unref0 (_tmp68_);
#line 1265 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp69_ = self->priv->page_number;
#line 1265 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->notified_page = _tmp69_;
#line 11422 "scanner.c"
	}
#line 1269 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp70_ = self->priv->parameters;
#line 1269 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp71_ = _tmp70_.bytes_per_line;
#line 1269 "/home/bob/git/simple-scan/src/scanner.vala"
	buffer_size = _tmp71_ + 1;
#line 1270 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp72_ = buffer_size;
#line 1270 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp73_ = g_new0 (guchar, _tmp72_);
#line 1270 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1270 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->buffer = _tmp73_;
#line 1270 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->buffer_length1 = _tmp72_;
#line 1270 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1271 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->n_used = 0;
#line 1272 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->line_count = 0;
#line 1273 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->pass_number = 0;
#line 1274 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->state = SCAN_STATE_READ;
#line 1227 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_page_info_unref0 (info);
#line 1227 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11454 "scanner.c"
}


static void
scanner_do_complete_page (Scanner* self)
{
	ScanJob* job = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	ScanJob* _tmp3_;
	gint _tmp4_;
	NotifyPageDone* _tmp5_;
	NotifyPageDone* _tmp6_;
	SANE_Parameters _tmp7_;
	gboolean _tmp8_;
	ScanJob* _tmp10_;
	ScanType _tmp11_;
#line 1277 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1279 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1279 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1279 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1279 "/home/bob/git/simple-scan/src/scanner.vala"
	job = _tmp2_;
#line 1281 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = job;
#line 1281 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = _tmp3_->id;
#line 1281 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = notify_page_done_new (_tmp4_);
#line 1281 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp6_ = _tmp5_;
#line 1281 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp6_);
#line 1281 "/home/bob/git/simple-scan/src/scanner.vala"
	_notify_unref0 (_tmp6_);
#line 1284 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp7_ = self->priv->parameters;
#line 1284 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp8_ = _tmp7_.last_frame;
#line 1284 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!_tmp8_) {
#line 11501 "scanner.c"
		gint _tmp9_;
#line 1286 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp9_ = self->priv->pass_number;
#line 1286 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->pass_number = _tmp9_ + 1;
#line 1287 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1288 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1288 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 11513 "scanner.c"
	}
#line 1292 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp10_ = job;
#line 1292 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp11_ = _tmp10_->type;
#line 1292 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp11_ != SCAN_TYPE_SINGLE) {
#line 11521 "scanner.c"
		gint _tmp12_;
		ScanJob* _tmp13_;
		gint _tmp14_;
		NotifyPageDone* _tmp15_;
		NotifyPageDone* _tmp16_;
#line 1294 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp12_ = self->priv->page_number;
#line 1294 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->page_number = _tmp12_ + 1;
#line 1295 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->pass_number = 0;
#line 1296 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp13_ = job;
#line 1296 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp14_ = _tmp13_->id;
#line 1296 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp15_ = notify_page_done_new (_tmp14_);
#line 1296 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 1296 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp16_);
#line 1296 "/home/bob/git/simple-scan/src/scanner.vala"
		_notify_unref0 (_tmp16_);
#line 1297 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1298 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1298 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 11551 "scanner.c"
	}
#line 1301 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_do_complete_document (self);
#line 1277 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11557 "scanner.c"
}


static void
scanner_do_read (Scanner* self)
{
	ScanJob* job = NULL;
	GList* _tmp0_;
	gconstpointer _tmp1_;
	ScanJob* _tmp2_;
	gint n_to_read = 0;
	guchar* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	SANE_Int n_read = {0};
	guchar* b = NULL;
	guchar* _tmp5_;
	gint _tmp5__length1;
	SANE_Status status = 0;
	SANE_Handle _tmp6_;
	guchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	SANE_Int _tmp10_ = {0};
	SANE_Status _tmp11_;
	gint _tmp12_;
	SANE_Status _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	SANE_Int _tmp16_;
	SANE_Status _tmp17_;
	SANE_Status _tmp29_;
	gboolean full_read = FALSE;
	gboolean _tmp33_ = FALSE;
	gint _tmp34_;
	gint _tmp37_;
	SANE_Int _tmp38_;
	gint _tmp39_;
	SANE_Parameters _tmp40_;
	gint _tmp41_;
#line 1304 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1306 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1306 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1306 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1306 "/home/bob/git/simple-scan/src/scanner.vala"
	job = _tmp2_;
#line 1309 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = self->priv->buffer;
#line 1309 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3__length1 = self->priv->buffer_length1;
#line 1309 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = self->priv->n_used;
#line 1309 "/home/bob/git/simple-scan/src/scanner.vala"
	n_to_read = _tmp3__length1 - _tmp4_;
#line 1312 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = self->priv->buffer;
#line 1312 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5__length1 = self->priv->buffer_length1;
#line 1312 "/home/bob/git/simple-scan/src/scanner.vala"
	b = (guchar*) _tmp5_;
#line 1313 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp6_ = self->priv->handle;
#line 1313 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp7_ = b;
#line 1313 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp8_ = self->priv->n_used;
#line 1313 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp9_ = n_to_read;
#line 1313 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp11_ = sane_read (_tmp6_, (guint8*) (_tmp7_ + _tmp8_), (SANE_Int) _tmp9_, &_tmp10_);
#line 1313 "/home/bob/git/simple-scan/src/scanner.vala"
	n_read = _tmp10_;
#line 1313 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp11_;
#line 1314 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp12_ = n_to_read;
#line 1314 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp13_ = status;
#line 1314 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp14_ = sane_status_to_string (_tmp13_);
#line 1314 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp15_ = _tmp14_;
#line 1314 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp16_ = n_read;
#line 1314 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1314: sane_read (%d) -> (%s, %d)", _tmp12_, _tmp15_, (gint) _tmp16_);
#line 1314 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp15_);
#line 1317 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp17_ = status;
#line 1317 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp17_ == SANE_STATUS_EOF) {
#line 11654 "scanner.c"
		gboolean _tmp18_ = FALSE;
		SANE_Parameters _tmp19_;
		gint _tmp20_;
		gint _tmp27_;
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp19_ = self->priv->parameters;
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp20_ = _tmp19_.lines;
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp20_ > 0) {
#line 11665 "scanner.c"
			gint _tmp21_;
			SANE_Parameters _tmp22_;
			gint _tmp23_;
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp21_ = self->priv->line_count;
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp22_ = self->priv->parameters;
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp23_ = _tmp22_.lines;
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp18_ = _tmp21_ != _tmp23_;
#line 11677 "scanner.c"
		} else {
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp18_ = FALSE;
#line 11681 "scanner.c"
		}
#line 1319 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp18_) {
#line 11685 "scanner.c"
			gint _tmp24_;
			SANE_Parameters _tmp25_;
			gint _tmp26_;
#line 1320 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp24_ = self->priv->line_count;
#line 1320 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp25_ = self->priv->parameters;
#line 1320 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp26_ = _tmp25_.lines;
#line 1320 "/home/bob/git/simple-scan/src/scanner.vala"
			g_warning ("scanner.vala:1320: Scan completed with %d lines, expected %d lines", _tmp24_, _tmp26_);
#line 11697 "scanner.c"
		}
#line 1321 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp27_ = self->priv->n_used;
#line 1321 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp27_ > 0) {
#line 11703 "scanner.c"
			gint _tmp28_;
#line 1322 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp28_ = self->priv->n_used;
#line 1322 "/home/bob/git/simple-scan/src/scanner.vala"
			g_warning ("scanner.vala:1322: Scan complete with %d bytes of unused data", _tmp28_);
#line 11709 "scanner.c"
		}
#line 1323 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_do_complete_page (self);
#line 1324 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1324 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 11717 "scanner.c"
	}
#line 1328 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp29_ = status;
#line 1328 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp29_ != SANE_STATUS_GOOD) {
#line 11723 "scanner.c"
		SANE_Status _tmp30_;
		const gchar* _tmp31_;
		SANE_Status _tmp32_;
#line 1330 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp30_ = status;
#line 1330 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp31_ = sane_strstatus (_tmp30_);
#line 1330 "/home/bob/git/simple-scan/src/scanner.vala"
		g_warning ("scanner.vala:1330: Unable to read frame from device: %s", _tmp31_);
#line 1331 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp32_ = status;
#line 1331 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp32_, _ ("Error communicating with scanner"));
#line 1334 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1334 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 11741 "scanner.c"
	}
#line 1337 "/home/bob/git/simple-scan/src/scanner.vala"
	full_read = FALSE;
#line 1338 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp34_ = self->priv->n_used;
#line 1338 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp34_ == 0) {
#line 11749 "scanner.c"
		SANE_Int _tmp35_;
		guchar* _tmp36_;
		gint _tmp36__length1;
#line 1338 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp35_ = n_read;
#line 1338 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp36_ = self->priv->buffer;
#line 1338 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp36__length1 = self->priv->buffer_length1;
#line 1338 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp33_ = _tmp35_ == ((SANE_Int) _tmp36__length1);
#line 11761 "scanner.c"
	} else {
#line 1338 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp33_ = FALSE;
#line 11765 "scanner.c"
	}
#line 1338 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp33_) {
#line 1339 "/home/bob/git/simple-scan/src/scanner.vala"
		full_read = TRUE;
#line 11771 "scanner.c"
	}
#line 1340 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp37_ = self->priv->n_used;
#line 1340 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp38_ = n_read;
#line 1340 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->n_used = _tmp37_ + ((gint) _tmp38_);
#line 1343 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp39_ = self->priv->n_used;
#line 1343 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp40_ = self->priv->parameters;
#line 1343 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp41_ = _tmp40_.bytes_per_line;
#line 1343 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp39_ >= _tmp41_) {
#line 11787 "scanner.c"
		ScanLine* line = NULL;
		ScanLine* _tmp42_;
		SANE_Parameters _tmp43_;
		SANE_Frame _tmp44_;
		ScanLine* _tmp50_;
		SANE_Parameters _tmp51_;
		gint _tmp52_;
		ScanLine* _tmp53_;
		SANE_Parameters _tmp54_;
		gint _tmp55_;
		ScanLine* _tmp56_;
		guchar* _tmp57_;
		gint _tmp57__length1;
		ScanLine* _tmp58_;
		SANE_Parameters _tmp59_;
		gint _tmp60_;
		ScanLine* _tmp61_;
		gint _tmp62_;
		ScanLine* _tmp63_;
		gint _tmp64_;
		ScanLine* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		ScanLine* _tmp68_;
		gint _tmp69_;
		gint buffer_size = 0;
		ScanLine* _tmp70_;
		guchar* _tmp71_;
		gint _tmp71__length1;
		gboolean _tmp72_;
		gint _tmp76_;
		guchar* _tmp77_;
		gint n_remaining = 0;
		gint _tmp78_;
		ScanLine* _tmp79_;
		gint _tmp80_;
		ScanLine* _tmp81_;
		gint _tmp82_;
		gboolean _tmp99_ = FALSE;
		gboolean _tmp100_ = FALSE;
		gboolean _tmp101_ = FALSE;
		SANE_Parameters _tmp102_;
		gint _tmp103_;
		ScanJob* _tmp152_;
		gint _tmp153_;
		ScanLine* _tmp154_;
		NotifyGotLine* _tmp155_;
		NotifyGotLine* _tmp156_;
#line 1345 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp42_ = scan_line_new ();
#line 1345 "/home/bob/git/simple-scan/src/scanner.vala"
		line = _tmp42_;
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp43_ = self->priv->parameters;
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp44_ = _tmp43_.format;
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
		switch (_tmp44_) {
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
			case SANE_FRAME_GRAY:
#line 11848 "scanner.c"
			{
				ScanLine* _tmp45_;
#line 1349 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp45_ = line;
#line 1349 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp45_->channel = 0;
#line 1350 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 11857 "scanner.c"
			}
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
			case SANE_FRAME_RGB:
#line 11861 "scanner.c"
			{
				ScanLine* _tmp46_;
#line 1352 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp46_ = line;
#line 1352 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp46_->channel = -1;
#line 1353 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 11870 "scanner.c"
			}
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
			case SANE_FRAME_RED:
#line 11874 "scanner.c"
			{
				ScanLine* _tmp47_;
#line 1355 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp47_ = line;
#line 1355 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp47_->channel = 0;
#line 1356 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 11883 "scanner.c"
			}
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
			case SANE_FRAME_GREEN:
#line 11887 "scanner.c"
			{
				ScanLine* _tmp48_;
#line 1358 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp48_ = line;
#line 1358 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp48_->channel = 1;
#line 1359 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 11896 "scanner.c"
			}
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
			case SANE_FRAME_BLUE:
#line 11900 "scanner.c"
			{
				ScanLine* _tmp49_;
#line 1361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp49_ = line;
#line 1361 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp49_->channel = 2;
#line 1362 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 11909 "scanner.c"
			}
			default:
#line 1346 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 11914 "scanner.c"
		}
#line 1364 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp50_ = line;
#line 1364 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp51_ = self->priv->parameters;
#line 1364 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp52_ = _tmp51_.pixels_per_line;
#line 1364 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp50_->width = _tmp52_;
#line 1365 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp53_ = line;
#line 1365 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp54_ = self->priv->parameters;
#line 1365 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp55_ = _tmp54_.depth;
#line 1365 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp53_->depth = _tmp55_;
#line 1366 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp56_ = line;
#line 1366 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp57_ = self->priv->buffer;
#line 1366 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp57__length1 = self->priv->buffer_length1;
#line 1366 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->buffer = NULL;
#line 1366 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->buffer_length1 = 0;
#line 1366 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp56_->data = (g_free (_tmp56_->data), NULL);
#line 1366 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp56_->data = _tmp57_;
#line 1366 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp56_->data_length1 = _tmp57__length1;
#line 1367 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp58_ = line;
#line 1367 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp59_ = self->priv->parameters;
#line 1367 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp60_ = _tmp59_.bytes_per_line;
#line 1367 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp58_->data_length = _tmp60_;
#line 1368 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp61_ = line;
#line 1368 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp62_ = self->priv->line_count;
#line 1368 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp61_->number = _tmp62_;
#line 1369 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp63_ = line;
#line 1369 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp64_ = self->priv->n_used;
#line 1369 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp65_ = line;
#line 1369 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp66_ = _tmp65_->data_length;
#line 1369 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp63_->n_lines = _tmp64_ / _tmp66_;
#line 1371 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp67_ = self->priv->line_count;
#line 1371 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp68_ = line;
#line 1371 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp69_ = _tmp68_->n_lines;
#line 1371 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->line_count = _tmp67_ + _tmp69_;
#line 1374 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp70_ = line;
#line 1374 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp71_ = _tmp70_->data;
#line 1374 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp71__length1 = _tmp70_->data_length1;
#line 1374 "/home/bob/git/simple-scan/src/scanner.vala"
		buffer_size = _tmp71__length1;
#line 1375 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp72_ = full_read;
#line 1375 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp72_) {
#line 11992 "scanner.c"
			gint _tmp73_;
			SANE_Parameters _tmp74_;
			gint _tmp75_;
#line 1376 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp73_ = buffer_size;
#line 1376 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp74_ = self->priv->parameters;
#line 1376 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp75_ = _tmp74_.bytes_per_line;
#line 1376 "/home/bob/git/simple-scan/src/scanner.vala"
			buffer_size = _tmp73_ + _tmp75_;
#line 12004 "scanner.c"
		}
#line 1378 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp76_ = buffer_size;
#line 1378 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp77_ = g_new0 (guchar, _tmp76_);
#line 1378 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1378 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->buffer = _tmp77_;
#line 1378 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->buffer_length1 = _tmp76_;
#line 1378 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1379 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp78_ = self->priv->n_used;
#line 1379 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp79_ = line;
#line 1379 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp80_ = _tmp79_->n_lines;
#line 1379 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp81_ = line;
#line 1379 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp82_ = _tmp81_->data_length;
#line 1379 "/home/bob/git/simple-scan/src/scanner.vala"
		n_remaining = _tmp78_ - (_tmp80_ * _tmp82_);
#line 1380 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->n_used = 0;
#line 12032 "scanner.c"
		{
			gint i = 0;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
			i = 0;
#line 12037 "scanner.c"
			{
				gboolean _tmp83_ = FALSE;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp83_ = TRUE;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
				while (TRUE) {
#line 12044 "scanner.c"
					gint _tmp85_;
					gint _tmp86_;
					guchar* _tmp87_;
					gint _tmp87__length1;
					gint _tmp88_;
					ScanLine* _tmp89_;
					guchar* _tmp90_;
					gint _tmp90__length1;
					gint _tmp91_;
					ScanLine* _tmp92_;
					gint _tmp93_;
					ScanLine* _tmp94_;
					gint _tmp95_;
					guchar _tmp96_;
					guchar _tmp97_;
					gint _tmp98_;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!_tmp83_) {
#line 12063 "scanner.c"
						gint _tmp84_;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp84_ = i;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
						i = _tmp84_ + 1;
#line 12069 "scanner.c"
					}
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp83_ = FALSE;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp85_ = i;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp86_ = n_remaining;
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
					if (!(_tmp85_ < _tmp86_)) {
#line 1381 "/home/bob/git/simple-scan/src/scanner.vala"
						break;
#line 12081 "scanner.c"
					}
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp87_ = self->priv->buffer;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp87__length1 = self->priv->buffer_length1;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp88_ = i;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp89_ = line;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp90_ = _tmp89_->data;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp90__length1 = _tmp89_->data_length1;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp91_ = i;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp92_ = line;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp93_ = _tmp92_->n_lines;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp94_ = line;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp95_ = _tmp94_->data_length;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp96_ = _tmp90_[_tmp91_ + (_tmp93_ * _tmp95_)];
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp87_[_tmp88_] = _tmp96_;
#line 1383 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp97_ = _tmp87_[_tmp88_];
#line 1384 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp98_ = self->priv->n_used;
#line 1384 "/home/bob/git/simple-scan/src/scanner.vala"
					self->priv->n_used = _tmp98_ + 1;
#line 12115 "scanner.c"
				}
			}
		}
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp102_ = self->priv->parameters;
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp103_ = _tmp102_.depth;
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp103_ == 8) {
#line 12125 "scanner.c"
			SANE_Parameters _tmp104_;
			SANE_Frame _tmp105_;
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp104_ = self->priv->parameters;
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp105_ = _tmp104_.format;
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp101_ = _tmp105_ == SANE_FRAME_GRAY;
#line 12134 "scanner.c"
		} else {
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp101_ = FALSE;
#line 12138 "scanner.c"
		}
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp101_) {
#line 12142 "scanner.c"
			ScanJob* _tmp106_;
			gint _tmp107_;
#line 1390 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp106_ = job;
#line 1390 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp107_ = _tmp106_->depth;
#line 1390 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp100_ = _tmp107_ == 2;
#line 12151 "scanner.c"
		} else {
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp100_ = FALSE;
#line 12155 "scanner.c"
		}
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp100_) {
#line 12159 "scanner.c"
			ScanJob* _tmp108_;
			ScanMode _tmp109_;
#line 1390 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp108_ = job;
#line 1390 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp109_ = _tmp108_->scan_mode;
#line 1390 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp99_ = _tmp109_ == SCAN_MODE_GRAY;
#line 12168 "scanner.c"
		} else {
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp99_ = FALSE;
#line 12172 "scanner.c"
		}
#line 1389 "/home/bob/git/simple-scan/src/scanner.vala"
		if (_tmp99_) {
#line 12176 "scanner.c"
			guchar block = '\0';
			gint write_offset = 0;
			gint block_shift = 0;
			ScanLine* _tmp149_;
			ScanLine* _tmp150_;
			gint _tmp151_;
#line 1392 "/home/bob/git/simple-scan/src/scanner.vala"
			block = (guchar) 0;
#line 1393 "/home/bob/git/simple-scan/src/scanner.vala"
			write_offset = 0;
#line 1394 "/home/bob/git/simple-scan/src/scanner.vala"
			block_shift = 6;
#line 12189 "scanner.c"
			{
				gint i = 0;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
				i = 0;
#line 12194 "scanner.c"
				{
					gboolean _tmp110_ = FALSE;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
					_tmp110_ = TRUE;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
					while (TRUE) {
#line 12201 "scanner.c"
						gint _tmp112_;
						ScanLine* _tmp113_;
						gint _tmp114_;
						gint offset = 0;
						gint _tmp115_;
						ScanLine* _tmp116_;
						gint _tmp117_;
						gint _tmp142_;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!_tmp110_) {
#line 12212 "scanner.c"
							gint _tmp111_;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp111_ = i;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
							i = _tmp111_ + 1;
#line 12218 "scanner.c"
						}
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp110_ = FALSE;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp112_ = i;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp113_ = line;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp114_ = _tmp113_->n_lines;
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
						if (!(_tmp112_ < _tmp114_)) {
#line 1395 "/home/bob/git/simple-scan/src/scanner.vala"
							break;
#line 12232 "scanner.c"
						}
#line 1397 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp115_ = i;
#line 1397 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp116_ = line;
#line 1397 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp117_ = _tmp116_->data_length;
#line 1397 "/home/bob/git/simple-scan/src/scanner.vala"
						offset = _tmp115_ * _tmp117_;
#line 12242 "scanner.c"
						{
							gint x = 0;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
							x = 0;
#line 12247 "scanner.c"
							{
								gboolean _tmp118_ = FALSE;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
								_tmp118_ = TRUE;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
								while (TRUE) {
#line 12254 "scanner.c"
									gint _tmp120_;
									ScanLine* _tmp121_;
									gint _tmp122_;
									guchar p = '\0';
									ScanLine* _tmp123_;
									guchar* _tmp124_;
									gint _tmp124__length1;
									gint _tmp125_;
									gint _tmp126_;
									guchar _tmp127_;
									guchar sample = '\0';
									guchar _tmp128_;
									guchar _tmp131_;
									guchar _tmp132_;
									gint _tmp133_;
									gint _tmp134_;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
									if (!_tmp118_) {
#line 12273 "scanner.c"
										gint _tmp119_;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp119_ = x;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
										x = _tmp119_ + 1;
#line 12279 "scanner.c"
									}
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp118_ = FALSE;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp120_ = x;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp121_ = line;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp122_ = _tmp121_->width;
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
									if (!(_tmp120_ < _tmp122_)) {
#line 1398 "/home/bob/git/simple-scan/src/scanner.vala"
										break;
#line 12293 "scanner.c"
									}
#line 1400 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp123_ = line;
#line 1400 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp124_ = _tmp123_->data;
#line 1400 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp124__length1 = _tmp123_->data_length1;
#line 1400 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp125_ = offset;
#line 1400 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp126_ = x;
#line 1400 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp127_ = _tmp124_[_tmp125_ + _tmp126_];
#line 1400 "/home/bob/git/simple-scan/src/scanner.vala"
									p = _tmp127_;
#line 1403 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp128_ = p;
#line 1403 "/home/bob/git/simple-scan/src/scanner.vala"
									if (((gint) _tmp128_) >= 192) {
#line 1404 "/home/bob/git/simple-scan/src/scanner.vala"
										sample = (guchar) 3;
#line 12315 "scanner.c"
									} else {
										guchar _tmp129_;
#line 1405 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp129_ = p;
#line 1405 "/home/bob/git/simple-scan/src/scanner.vala"
										if (((gint) _tmp129_) >= 128) {
#line 1406 "/home/bob/git/simple-scan/src/scanner.vala"
											sample = (guchar) 2;
#line 12324 "scanner.c"
										} else {
											guchar _tmp130_;
#line 1407 "/home/bob/git/simple-scan/src/scanner.vala"
											_tmp130_ = p;
#line 1407 "/home/bob/git/simple-scan/src/scanner.vala"
											if (((gint) _tmp130_) >= 64) {
#line 1408 "/home/bob/git/simple-scan/src/scanner.vala"
												sample = (guchar) 1;
#line 12333 "scanner.c"
											} else {
#line 1410 "/home/bob/git/simple-scan/src/scanner.vala"
												sample = (guchar) 0;
#line 12337 "scanner.c"
											}
										}
									}
#line 1412 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp131_ = block;
#line 1412 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp132_ = sample;
#line 1412 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp133_ = block_shift;
#line 1412 "/home/bob/git/simple-scan/src/scanner.vala"
									block = _tmp131_ | (_tmp132_ << _tmp133_);
#line 1413 "/home/bob/git/simple-scan/src/scanner.vala"
									_tmp134_ = block_shift;
#line 1413 "/home/bob/git/simple-scan/src/scanner.vala"
									if (_tmp134_ == 0) {
#line 12353 "scanner.c"
										ScanLine* _tmp135_;
										guchar* _tmp136_;
										gint _tmp136__length1;
										gint _tmp137_;
										guchar _tmp138_;
										guchar _tmp139_;
										gint _tmp140_;
#line 1415 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp135_ = line;
#line 1415 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp136_ = _tmp135_->data;
#line 1415 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp136__length1 = _tmp135_->data_length1;
#line 1415 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp137_ = write_offset;
#line 1415 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp138_ = block;
#line 1415 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp136_[_tmp137_] = _tmp138_;
#line 1415 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp139_ = _tmp136_[_tmp137_];
#line 1416 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp140_ = write_offset;
#line 1416 "/home/bob/git/simple-scan/src/scanner.vala"
										write_offset = _tmp140_ + 1;
#line 1417 "/home/bob/git/simple-scan/src/scanner.vala"
										block = (guchar) 0;
#line 1418 "/home/bob/git/simple-scan/src/scanner.vala"
										block_shift = 6;
#line 12383 "scanner.c"
									} else {
										gint _tmp141_;
#line 1421 "/home/bob/git/simple-scan/src/scanner.vala"
										_tmp141_ = block_shift;
#line 1421 "/home/bob/git/simple-scan/src/scanner.vala"
										block_shift = _tmp141_ - 2;
#line 12390 "scanner.c"
									}
								}
							}
						}
#line 1425 "/home/bob/git/simple-scan/src/scanner.vala"
						_tmp142_ = block_shift;
#line 1425 "/home/bob/git/simple-scan/src/scanner.vala"
						if (_tmp142_ != 6) {
#line 12399 "scanner.c"
							ScanLine* _tmp143_;
							guchar* _tmp144_;
							gint _tmp144__length1;
							gint _tmp145_;
							guchar _tmp146_;
							guchar _tmp147_;
							gint _tmp148_;
#line 1427 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp143_ = line;
#line 1427 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp144_ = _tmp143_->data;
#line 1427 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp144__length1 = _tmp143_->data_length1;
#line 1427 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp145_ = write_offset;
#line 1427 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp146_ = block;
#line 1427 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp144_[_tmp145_] = _tmp146_;
#line 1427 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp147_ = _tmp144_[_tmp145_];
#line 1428 "/home/bob/git/simple-scan/src/scanner.vala"
							_tmp148_ = write_offset;
#line 1428 "/home/bob/git/simple-scan/src/scanner.vala"
							write_offset = _tmp148_ + 1;
#line 1429 "/home/bob/git/simple-scan/src/scanner.vala"
							block = (guchar) 0;
#line 1430 "/home/bob/git/simple-scan/src/scanner.vala"
							block_shift = 6;
#line 12429 "scanner.c"
						}
					}
				}
			}
#line 1434 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp149_ = line;
#line 1434 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp150_ = line;
#line 1434 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp151_ = _tmp150_->width;
#line 1434 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp149_->data_length = ((_tmp151_ * 2) + 7) / 8;
#line 12442 "scanner.c"
		}
#line 1437 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp152_ = job;
#line 1437 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp153_ = _tmp152_->id;
#line 1437 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp154_ = line;
#line 1437 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp155_ = notify_got_line_new (_tmp153_, _tmp154_);
#line 1437 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp156_ = _tmp155_;
#line 1437 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp156_);
#line 1437 "/home/bob/git/simple-scan/src/scanner.vala"
		_notify_unref0 (_tmp156_);
#line 1343 "/home/bob/git/simple-scan/src/scanner.vala"
		_scan_line_unref0 (line);
#line 12460 "scanner.c"
	}
#line 1304 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_job_unref0 (job);
#line 12464 "scanner.c"
}


static void
_scanner_authorization_cb_sane_authcallback (const gchar* resource,
                                             gchar* username,
                                             gchar* password)
{
#line 1446 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_authorization_cb (resource, username, -1, password, -1);
#line 12475 "scanner.c"
}


static void*
scanner_scan_thread (Scanner* self)
{
	void* result = NULL;
	SANE_Int version_code = {0};
	SANE_Status status = 0;
	SANE_Int _tmp0_ = {0};
	SANE_Status _tmp1_;
	SANE_Status _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SANE_Status _tmp5_;
	SANE_Int _tmp8_;
	SANE_Int _tmp9_;
	SANE_Int _tmp10_;
#line 1441 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1443 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1446 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = sane_init (&_tmp0_, _scanner_authorization_cb_sane_authcallback);
#line 1446 "/home/bob/git/simple-scan/src/scanner.vala"
	version_code = _tmp0_;
#line 1446 "/home/bob/git/simple-scan/src/scanner.vala"
	status = _tmp1_;
#line 1447 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = status;
#line 1447 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 1447 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1447 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1447: sane_init () -> %s", _tmp4_);
#line 1447 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 1448 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = status;
#line 1448 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 12518 "scanner.c"
		SANE_Status _tmp6_;
		const gchar* _tmp7_;
#line 1450 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp6_ = status;
#line 1450 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 1450 "/home/bob/git/simple-scan/src/scanner.vala"
		g_warning ("scanner.vala:1450: Unable to initialize SANE backend: %s", _tmp7_);
#line 1451 "/home/bob/git/simple-scan/src/scanner.vala"
		result = NULL;
#line 1451 "/home/bob/git/simple-scan/src/scanner.vala"
		return result;
#line 12531 "scanner.c"
	}
#line 1453 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp8_ = version_code;
#line 1453 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp9_ = version_code;
#line 1453 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp10_ = version_code;
#line 1453 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1453: SANE version %d.%d.%d", SANE_VERSION_MAJOR (_tmp8_), SANE_VERSION_MINOR (_tmp9_), SANE_VERSION_BUILD (_tmp10_));
#line 1459 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_redetect (self);
#line 1461 "/home/bob/git/simple-scan/src/scanner.vala"
	while (TRUE) {
#line 12545 "scanner.c"
		ScanState _tmp11_;
#line 1461 "/home/bob/git/simple-scan/src/scanner.vala"
		if (!scanner_handle_requests (self)) {
#line 1461 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 12551 "scanner.c"
		}
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp11_ = self->priv->state;
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
		switch (_tmp11_) {
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
			case SCAN_STATE_IDLE:
#line 12559 "scanner.c"
			{
				GList* _tmp12_;
#line 1466 "/home/bob/git/simple-scan/src/scanner.vala"
				_tmp12_ = self->priv->job_queue;
#line 1466 "/home/bob/git/simple-scan/src/scanner.vala"
				if (_tmp12_ != NULL) {
#line 1468 "/home/bob/git/simple-scan/src/scanner.vala"
					scanner_set_scanning (self, TRUE);
#line 1469 "/home/bob/git/simple-scan/src/scanner.vala"
					self->priv->state = SCAN_STATE_OPEN;
#line 12570 "scanner.c"
				}
#line 1471 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 12574 "scanner.c"
			}
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
			case SCAN_STATE_REDETECT:
#line 12578 "scanner.c"
			{
#line 1473 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_do_redetect (self);
#line 1474 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 12584 "scanner.c"
			}
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
			case SCAN_STATE_OPEN:
#line 12588 "scanner.c"
			{
#line 1476 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_do_open (self);
#line 1477 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 12594 "scanner.c"
			}
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
			case SCAN_STATE_GET_OPTION:
#line 12598 "scanner.c"
			{
#line 1479 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_do_get_option (self);
#line 1480 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 12604 "scanner.c"
			}
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
			case SCAN_STATE_START:
#line 12608 "scanner.c"
			{
#line 1482 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_do_start (self);
#line 1483 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 12614 "scanner.c"
			}
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
			case SCAN_STATE_GET_PARAMETERS:
#line 12618 "scanner.c"
			{
#line 1485 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_do_get_parameters (self);
#line 1486 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 12624 "scanner.c"
			}
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
			case SCAN_STATE_READ:
#line 12628 "scanner.c"
			{
#line 1488 "/home/bob/git/simple-scan/src/scanner.vala"
				scanner_do_read (self);
#line 1489 "/home/bob/git/simple-scan/src/scanner.vala"
				break;
#line 12634 "scanner.c"
			}
			default:
#line 1463 "/home/bob/git/simple-scan/src/scanner.vala"
			break;
#line 12639 "scanner.c"
		}
	}
#line 1493 "/home/bob/git/simple-scan/src/scanner.vala"
	result = NULL;
#line 1493 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 12646 "scanner.c"
}


static gpointer
_scanner_scan_thread_gthread_func (gpointer self)
{
	gpointer result;
	result = scanner_scan_thread ((Scanner*) self);
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_unref (self);
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 12659 "scanner.c"
}


void
scanner_start (Scanner* self)
{
	GError * _inner_error_ = NULL;
#line 1496 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 12669 "scanner.c"
	{
		GThread* _tmp0_ = NULL;
		GThread* _tmp1_;
		GThread* _tmp2_;
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp1_ = g_thread_try_new ("scan-thread", _scanner_scan_thread_gthread_func, scanner_ref (self), &_inner_error_);
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = _tmp1_;
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12680 "scanner.c"
			goto __catch16_g_error;
		}
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp2_ = _tmp0_;
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = NULL;
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1500 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->thread = _tmp2_;
#line 1498 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_thread_unref0 (_tmp0_);
#line 12693 "scanner.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 1498 "/home/bob/git/simple-scan/src/scanner.vala"
		e = _inner_error_;
#line 1498 "/home/bob/git/simple-scan/src/scanner.vala"
		_inner_error_ = NULL;
#line 1504 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = e;
#line 1504 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = _tmp3_->message;
#line 1504 "/home/bob/git/simple-scan/src/scanner.vala"
		g_critical ("scanner.vala:1504: Unable to create thread: %s", _tmp4_);
#line 1498 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_error_free0 (e);
#line 12713 "scanner.c"
	}
	__finally16:
#line 1498 "/home/bob/git/simple-scan/src/scanner.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1498 "/home/bob/git/simple-scan/src/scanner.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1498 "/home/bob/git/simple-scan/src/scanner.vala"
		g_clear_error (&_inner_error_);
#line 1498 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 12724 "scanner.c"
	}
}


void
scanner_redetect (Scanner* self)
{
	gboolean _tmp0_;
	GAsyncQueue* _tmp1_;
	RequestRedetect* _tmp2_;
#line 1508 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1510 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->need_redetect;
#line 1510 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp0_) {
#line 1511 "/home/bob/git/simple-scan/src/scanner.vala"
		return;
#line 12743 "scanner.c"
	}
#line 1512 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->need_redetect = TRUE;
#line 1514 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1514: Requesting redetection of scan devices");
#line 1516 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1516 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = request_redetect_new ();
#line 1516 "/home/bob/git/simple-scan/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12755 "scanner.c"
}


gboolean
scanner_is_scanning (Scanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 1519 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1521 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->scanning;
#line 1521 "/home/bob/git/simple-scan/src/scanner.vala"
	result = _tmp0_;
#line 1521 "/home/bob/git/simple-scan/src/scanner.vala"
	return result;
#line 12772 "scanner.c"
}


static gchar*
scanner_get_scan_mode_string (Scanner* self,
                              ScanMode mode)
{
	gchar* result = NULL;
#line 1524 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1526 "/home/bob/git/simple-scan/src/scanner.vala"
	switch (mode) {
#line 1526 "/home/bob/git/simple-scan/src/scanner.vala"
		case SCAN_MODE_DEFAULT:
#line 12787 "scanner.c"
		{
			gchar* _tmp0_;
#line 1529 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp0_ = g_strdup ("ScanMode.DEFAULT");
#line 1529 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp0_;
#line 1529 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12796 "scanner.c"
		}
#line 1526 "/home/bob/git/simple-scan/src/scanner.vala"
		case SCAN_MODE_COLOR:
#line 12800 "scanner.c"
		{
			gchar* _tmp1_;
#line 1531 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanMode.COLOR");
#line 1531 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp1_;
#line 1531 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12809 "scanner.c"
		}
#line 1526 "/home/bob/git/simple-scan/src/scanner.vala"
		case SCAN_MODE_GRAY:
#line 12813 "scanner.c"
		{
			gchar* _tmp2_;
#line 1533 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanMode.GRAY");
#line 1533 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp2_;
#line 1533 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12822 "scanner.c"
		}
#line 1526 "/home/bob/git/simple-scan/src/scanner.vala"
		case SCAN_MODE_LINEART:
#line 12826 "scanner.c"
		{
			gchar* _tmp3_;
#line 1535 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanMode.LINEART");
#line 1535 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp3_;
#line 1535 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12835 "scanner.c"
		}
		default:
		{
			gchar* _tmp4_;
#line 1537 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp4_ = g_strdup_printf ("%d", (gint) mode);
#line 1537 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp4_;
#line 1537 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12846 "scanner.c"
		}
	}
}


static gchar*
scanner_get_scan_type_string (Scanner* self,
                              ScanType type)
{
	gchar* result = NULL;
#line 1541 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1543 "/home/bob/git/simple-scan/src/scanner.vala"
	switch (type) {
#line 1543 "/home/bob/git/simple-scan/src/scanner.vala"
		case SCAN_TYPE_SINGLE:
#line 12863 "scanner.c"
		{
			gchar* _tmp0_;
#line 1546 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp0_ = g_strdup ("ScanType.SINGLE");
#line 1546 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp0_;
#line 1546 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12872 "scanner.c"
		}
#line 1543 "/home/bob/git/simple-scan/src/scanner.vala"
		case SCAN_TYPE_ADF_FRONT:
#line 12876 "scanner.c"
		{
			gchar* _tmp1_;
#line 1548 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanType.ADF_FRONT");
#line 1548 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp1_;
#line 1548 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12885 "scanner.c"
		}
#line 1543 "/home/bob/git/simple-scan/src/scanner.vala"
		case SCAN_TYPE_ADF_BACK:
#line 12889 "scanner.c"
		{
			gchar* _tmp2_;
#line 1550 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanType.ADF_BACK");
#line 1550 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp2_;
#line 1550 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12898 "scanner.c"
		}
#line 1543 "/home/bob/git/simple-scan/src/scanner.vala"
		case SCAN_TYPE_ADF_BOTH:
#line 12902 "scanner.c"
		{
			gchar* _tmp3_;
#line 1552 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanType.ADF_BOTH");
#line 1552 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp3_;
#line 1552 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12911 "scanner.c"
		}
		default:
		{
			gchar* _tmp4_;
#line 1554 "/home/bob/git/simple-scan/src/scanner.vala"
			_tmp4_ = g_strdup_printf ("%d", (gint) type);
#line 1554 "/home/bob/git/simple-scan/src/scanner.vala"
			result = _tmp4_;
#line 1554 "/home/bob/git/simple-scan/src/scanner.vala"
			return result;
#line 12922 "scanner.c"
		}
	}
}


void
scanner_scan (Scanner* self,
              const gchar* device,
              ScanOptions* options)
{
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	ScanMode _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	ScanType _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	RequestStartScan* request = NULL;
	RequestStartScan* _tmp13_;
	ScanJob* _tmp14_;
	ScanJob* _tmp15_;
	gint _tmp16_;
	ScanJob* _tmp17_;
	gchar* _tmp18_;
	ScanJob* _tmp19_;
	gint _tmp20_;
	ScanJob* _tmp21_;
	ScanMode _tmp22_;
	ScanJob* _tmp23_;
	gint _tmp24_;
	ScanJob* _tmp25_;
	ScanType _tmp26_;
	ScanJob* _tmp27_;
	gint _tmp28_;
	ScanJob* _tmp29_;
	gint _tmp30_;
	ScanJob* _tmp31_;
	gint _tmp32_;
	ScanJob* _tmp33_;
	gint _tmp34_;
	GAsyncQueue* _tmp35_;
	Request* _tmp36_;
#line 1558 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1558 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (options != NULL);
#line 1561 "/home/bob/git/simple-scan/src/scanner.vala"
	if (device != NULL) {
#line 1561 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = device;
#line 12979 "scanner.c"
	} else {
#line 1561 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp0_ = "(null)";
#line 12983 "scanner.c"
	}
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = options->dpi;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = options->scan_mode;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp3_ = scanner_get_scan_mode_string (self, _tmp2_);
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp5_ = options->depth;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp6_ = options->type;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp7_ = scanner_get_scan_type_string (self, _tmp6_);
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp9_ = options->paper_width;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp10_ = options->paper_height;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp11_ = options->brightness;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp12_ = options->contrast;
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1560: Scanner.scan (\"%s\", dpi=%d, scan_mode=%s, depth=%" \
"d, type=%s, paper_width=%d, paper_height=%d, brightness=%d, contrast=%" \
"d)", _tmp0_, _tmp1_, _tmp4_, _tmp5_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_);
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 1560 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 1564 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp13_ = request_start_scan_new ();
#line 1564 "/home/bob/git/simple-scan/src/scanner.vala"
	request = _tmp13_;
#line 1565 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp14_ = scan_job_new ();
#line 1565 "/home/bob/git/simple-scan/src/scanner.vala"
	_scan_job_unref0 (request->job);
#line 1565 "/home/bob/git/simple-scan/src/scanner.vala"
	request->job = _tmp14_;
#line 1566 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp15_ = request->job;
#line 1566 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp16_ = self->job_id;
#line 1566 "/home/bob/git/simple-scan/src/scanner.vala"
	self->job_id = _tmp16_ + 1;
#line 1566 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp15_->id = _tmp16_;
#line 1567 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp17_ = request->job;
#line 1567 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp18_ = g_strdup (device);
#line 1567 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (_tmp17_->device);
#line 1567 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp17_->device = _tmp18_;
#line 1568 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp19_ = request->job;
#line 1568 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp20_ = options->dpi;
#line 1568 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp19_->dpi = (gdouble) _tmp20_;
#line 1569 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp21_ = request->job;
#line 1569 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp22_ = options->scan_mode;
#line 1569 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp21_->scan_mode = _tmp22_;
#line 1570 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp23_ = request->job;
#line 1570 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp24_ = options->depth;
#line 1570 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp23_->depth = _tmp24_;
#line 1571 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp25_ = request->job;
#line 1571 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp26_ = options->type;
#line 1571 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp25_->type = _tmp26_;
#line 1572 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp27_ = request->job;
#line 1572 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp28_ = options->paper_width;
#line 1572 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp27_->page_width = _tmp28_;
#line 1573 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp29_ = request->job;
#line 1573 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp30_ = options->paper_height;
#line 1573 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp29_->page_height = _tmp30_;
#line 1574 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp31_ = request->job;
#line 1574 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp32_ = options->brightness;
#line 1574 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp31_->brightness = _tmp32_;
#line 1575 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp33_ = request->job;
#line 1575 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp34_ = options->contrast;
#line 1575 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp33_->contrast = _tmp34_;
#line 1576 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp35_ = self->priv->request_queue;
#line 1576 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp36_ = _request_ref0 ((Request*) request);
#line 1576 "/home/bob/git/simple-scan/src/scanner.vala"
	g_async_queue_push (_tmp35_, _tmp36_);
#line 1558 "/home/bob/git/simple-scan/src/scanner.vala"
	_request_unref0 (request);
#line 13097 "scanner.c"
}


void
scanner_cancel (Scanner* self)
{
	gint _tmp0_;
	GAsyncQueue* _tmp1_;
	RequestCancel* _tmp2_;
#line 1579 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1581 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->job_id;
#line 1581 "/home/bob/git/simple-scan/src/scanner.vala"
	self->first_job_id = _tmp0_;
#line 1582 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1582 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = request_cancel_new ();
#line 1582 "/home/bob/git/simple-scan/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 13119 "scanner.c"
}


static gpointer
_g_thread_ref0 (gpointer self)
{
#line 1593 "/home/bob/git/simple-scan/src/scanner.vala"
	return self ? g_thread_ref (self) : NULL;
#line 13128 "scanner.c"
}


void
scanner_free (Scanner* self)
{
	GAsyncQueue* _tmp0_;
	RequestQuit* _tmp1_;
	GThread* _tmp2_;
#line 1585 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1587 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1587: Stopping scan thread");
#line 1589 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp0_ = self->priv->request_queue;
#line 1589 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp1_ = request_quit_new ();
#line 1589 "/home/bob/git/simple-scan/src/scanner.vala"
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
#line 1591 "/home/bob/git/simple-scan/src/scanner.vala"
	_tmp2_ = self->priv->thread;
#line 1591 "/home/bob/git/simple-scan/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 13152 "scanner.c"
		GThread* _tmp3_;
		GThread* _tmp4_;
#line 1593 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp3_ = self->priv->thread;
#line 1593 "/home/bob/git/simple-scan/src/scanner.vala"
		_tmp4_ = _g_thread_ref0 (_tmp3_);
#line 1593 "/home/bob/git/simple-scan/src/scanner.vala"
		g_thread_join (_tmp4_);
#line 1594 "/home/bob/git/simple-scan/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1594 "/home/bob/git/simple-scan/src/scanner.vala"
		self->priv->thread = NULL;
#line 13165 "scanner.c"
	}
#line 1597 "/home/bob/git/simple-scan/src/scanner.vala"
	sane_exit ();
#line 1598 "/home/bob/git/simple-scan/src/scanner.vala"
	g_debug ("scanner.vala:1598: sane_exit ()");
#line 13171 "scanner.c"
}


static void
g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__SCAN_PAGE_INFO) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_PAGE_INFO callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13197 "scanner.c"
	} else {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data2 = closure->data;
#line 13203 "scanner.c"
	}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_PAGE_INFO) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	callback (data1, value_get_scan_page_info (param_values + 1), data2);
#line 13209 "scanner.c"
}


static void
g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__SCAN_LINE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_LINE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13235 "scanner.c"
	} else {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data2 = closure->data;
#line 13241 "scanner.c"
	}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_LINE) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	callback (data1, value_get_scan_line (param_values + 1), data2);
#line 13247 "scanner.c"
}


static void
g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (n_param_values == 3);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13273 "scanner.c"
	} else {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		data2 = closure->data;
#line 13279 "scanner.c"
	}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 13285 "scanner.c"
}


static void
value_scanner_init (GValue* value)
{
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 13294 "scanner.c"
}


static void
value_scanner_free_value (GValue* value)
{
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_unref (value->data[0].v_pointer);
#line 13305 "scanner.c"
	}
}


static void
value_scanner_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = scanner_ref (src_value->data[0].v_pointer);
#line 13318 "scanner.c"
	} else {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 13322 "scanner.c"
	}
}


static gpointer
value_scanner_peek_pointer (const GValue* value)
{
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 13332 "scanner.c"
}


static gchar*
value_scanner_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 13344 "scanner.c"
		Scanner * object;
		object = collect_values[0].v_pointer;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13351 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13355 "scanner.c"
		}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = scanner_ref (object);
#line 13359 "scanner.c"
	} else {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13363 "scanner.c"
	}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 13367 "scanner.c"
}


static gchar*
value_scanner_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	Scanner ** object_p;
	object_p = collect_values[0].v_pointer;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!object_p) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 13383 "scanner.c"
	}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = NULL;
#line 13389 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 13393 "scanner.c"
	} else {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		*object_p = scanner_ref (value->data[0].v_pointer);
#line 13397 "scanner.c"
	}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	return NULL;
#line 13401 "scanner.c"
}


GParamSpec*
param_spec_scanner (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecScanner* spec;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCANNER), NULL);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 13421 "scanner.c"
}


gpointer
value_get_scanner (const GValue* value)
{
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER), NULL);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	return value->data[0].v_pointer;
#line 13432 "scanner.c"
}


void
value_set_scanner (GValue* value,
                   gpointer v_object)
{
	Scanner * old;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_ref (value->data[0].v_pointer);
#line 13455 "scanner.c"
	} else {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13459 "scanner.c"
	}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_unref (old);
#line 13465 "scanner.c"
	}
}


void
value_take_scanner (GValue* value,
                    gpointer v_object)
{
	Scanner * old;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (v_object) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 13487 "scanner.c"
	} else {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13491 "scanner.c"
	}
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (old) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		scanner_unref (old);
#line 13497 "scanner.c"
	}
}


static void
scanner_class_init (ScannerClass * klass)
{
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_parent_class = g_type_class_peek_parent (klass);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	((ScannerClass *) klass)->finalize = scanner_finalize;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (ScannerPrivate));
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_UPDATE_DEVICES_SIGNAL] = g_signal_new ("update-devices", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_REQUEST_AUTHORIZATION_SIGNAL] = g_signal_new ("request-authorization", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_EXPECT_PAGE_SIGNAL] = g_signal_new ("expect-page", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_GOT_PAGE_INFO_SIGNAL] = g_signal_new ("got-page-info", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO, G_TYPE_NONE, 1, TYPE_SCAN_PAGE_INFO);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_GOT_LINE_SIGNAL] = g_signal_new ("got-line", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_LINE, G_TYPE_NONE, 1, TYPE_SCAN_LINE);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_SCAN_FAILED_SIGNAL] = g_signal_new ("scan-failed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_PAGE_DONE_SIGNAL] = g_signal_new ("page-done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_DOCUMENT_DONE_SIGNAL] = g_signal_new ("document-done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	scanner_signals[SCANNER_SCANNING_CHANGED_SIGNAL] = g_signal_new ("scanning-changed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13529 "scanner.c"
}


static void
scanner_instance_init (Scanner * self)
{
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv = SCANNER_GET_PRIVATE (self);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	self->ref_count = 1;
#line 13540 "scanner.c"
}


static void
scanner_finalize (Scanner * obj)
{
	Scanner * self;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCANNER, Scanner);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 214 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_thread_unref0 (self->priv->thread);
#line 217 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 220 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 223 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 229 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->priv->default_device);
#line 234 "/home/bob/git/simple-scan/src/scanner.vala"
	(self->priv->job_queue == NULL) ? NULL : (self->priv->job_queue = (_g_list_free__scan_job_unref0_ (self->priv->job_queue), NULL));
#line 239 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 247 "/home/bob/git/simple-scan/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 250 "/home/bob/git/simple-scan/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 13570 "scanner.c"
}


GType
scanner_get_type (void)
{
	static volatile gsize scanner_type_id__volatile = 0;
	if (g_once_init_enter (&scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scanner_init, value_scanner_free_value, value_scanner_copy_value, value_scanner_peek_pointer, "p", value_scanner_collect_value, "p", value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scanner), 0, (GInstanceInitFunc) scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scanner_type_id;
		scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Scanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scanner_type_id__volatile, scanner_type_id);
	}
	return scanner_type_id__volatile;
}


gpointer
scanner_ref (gpointer instance)
{
	Scanner * self;
	self = instance;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	return instance;
#line 13599 "scanner.c"
}


void
scanner_unref (gpointer instance)
{
	Scanner * self;
	self = instance;
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		SCANNER_GET_CLASS (self)->finalize (self);
#line 208 "/home/bob/git/simple-scan/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 13614 "scanner.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



