/* book.c generated by valac 0.40.9, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
enum  {
	BOOK_PAGE_ADDED_SIGNAL,
	BOOK_PAGE_REMOVED_SIGNAL,
	BOOK_REORDERED_SIGNAL,
	BOOK_CLEARED_SIGNAL,
	BOOK_NEEDS_SAVING_CHANGED_SIGNAL,
	BOOK_SAVING_SIGNAL,
	BOOK_NUM_SIGNALS
};
static guint book_signals[BOOK_NUM_SIGNALS] = {0};
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving_;
	GByteArray* jpeg_data;
};

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	guint* object_offsets;
	gint object_offsets_length1;
	gint _object_offsets_size_;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_book (GValue* value,
                     gpointer v_object);
void value_take_book (GValue* value,
                      gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_page (GValue* value,
                     gpointer v_object);
void value_take_page (GValue* value,
                      gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
static void book_page_changed_cb (Book* self,
                           Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender,
                                                gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender,
                                              gpointer self);
static void _page_unref0_ (gpointer var);
static inline void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self,
                            gboolean value);
void book_append_page (Book* self,
                       Page* page);
void book_move_page (Book* self,
                     Page* page,
                     guint location);
void book_reverse (Book* self);
void book_combine_sides (Book* self);
guint book_get_n_pages (Book* self);
void book_combine_sides_reverse (Book* self);
void book_delete_page (Book* self,
                       Page* page);
Page* book_get_page (Book* self,
                     gint page_number);
guint book_get_page_index (Book* self,
                           Page* page);
static GFile* book_make_indexed_file (Book* self,
                               const gchar* uri,
                               gint i);
static void book_save_multi_file (Book* self,
                           const gchar* type,
                           gint quality,
                           GFile* file,
                           GError** error);
void page_save (Page* self,
                const gchar* type,
                gint quality,
                GFile* file,
                GError** error);
static void book_save_ps_pdf_surface (Book* self,
                               cairo_surface_t* surface,
                               GdkPixbuf* image,
                               gdouble dpi);
static void book_save_ps (Book* self,
                   GFile* file,
                   GError** error);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_ps_writer (GValue* value,
                          gpointer v_object);
void value_take_ps_writer (GValue* value,
                           gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type,
                               GFileOutputStream* stream);
GdkPixbuf* page_get_image (Page* self,
                           gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self,
                            guint8* data,
                            int data_length1,
                            int* result_length1);
static guint8* book_compress_jpeg (Book* self,
                            GdkPixbuf* image,
                            gint quality,
                            gint dpi,
                            int* result_length1);
static gboolean book_write_pixbuf_data (Book* self,
                                 guint8* buf,
                                 int buf_length1,
                                 GError** error);
static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf,
                                                       gsize buf_length1,
                                                       GError** error,
                                                       gpointer self);
static void book_save_pdf (Book* self,
                    GFile* file,
                    gint quality,
                    GError** error);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_pdf_writer (GValue* value,
                           gpointer v_object);
void value_take_pdf_writer (GValue* value,
                            gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type,
                                 GFileOutputStream* stream);
guint pdf_writer_add_object (PDFWriter* self);
void pdf_writer_write_string (PDFWriter* self,
                              const gchar* text);
void pdf_writer_start_object (PDFWriter* self,
                              guint index);
gboolean page_get_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self,
                          int length);
static guint8* _vala_array_dup2 (guint8* self,
                          int length);
void pdf_writer_write (PDFWriter* self,
                       guint8* data,
                       int data_length1);
static gint book_next_empty_object (PDFWriter* writer,
                             gint start);
void book_save (Book* self,
                const gchar* type,
                gint quality,
                GFile* file,
                GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data);
static void book_finalize (Book * obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
static void pdf_writer_finalize (PDFWriter * obj);
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self,
                                           guint8* data,
                                           int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self,
                                                               guchar* data,
                                                               int data_length1);
static void ps_writer_finalize (PsWriter * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_page_ref0 (gpointer self)
{
#line 45 "/home/bob/git/simple-scan/src/book.vala"
	return self ? page_ref (self) : NULL;
#line 346 "book.c"
}


static void
_book_page_changed_cb_page_pixels_changed (Page* _sender,
                                           gpointer self)
{
#line 47 "/home/bob/git/simple-scan/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 356 "book.c"
}


static void
_book_page_changed_cb_page_crop_changed (Page* _sender,
                                         gpointer self)
{
#line 48 "/home/bob/git/simple-scan/src/book.vala"
	book_page_changed_cb ((Book*) self, _sender);
#line 366 "book.c"
}


static void
_page_unref0_ (gpointer var)
{
#line 14 "/home/bob/git/simple-scan/src/book.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 375 "book.c"
}


static inline void
_g_list_free__page_unref0_ (GList* self)
{
#line 14 "/home/bob/git/simple-scan/src/book.vala"
	g_list_free_full (self, (GDestroyNotify) _page_unref0_);
#line 384 "book.c"
}


Book*
book_construct (GType object_type)
{
	Book* self = NULL;
#line 38 "/home/bob/git/simple-scan/src/book.vala"
	self = (Book*) g_type_create_instance (object_type);
#line 40 "/home/bob/git/simple-scan/src/book.vala"
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__page_unref0_ (self->priv->pages), NULL));
#line 40 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = NULL;
#line 38 "/home/bob/git/simple-scan/src/book.vala"
	return self;
#line 400 "book.c"
}


Book*
book_new (void)
{
#line 38 "/home/bob/git/simple-scan/src/book.vala"
	return book_construct (TYPE_BOOK);
#line 409 "book.c"
}


void
book_clear (Book* self)
{
	GList* _tmp0_;
#line 52 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 421 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 54 "/home/bob/git/simple-scan/src/book.vala"
		page_collection = _tmp0_;
#line 54 "/home/bob/git/simple-scan/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 429 "book.c"
			Page* _tmp1_;
			Page* page = NULL;
#line 54 "/home/bob/git/simple-scan/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 54 "/home/bob/git/simple-scan/src/book.vala"
			page = _tmp1_;
#line 436 "book.c"
			{
				Page* _tmp2_;
				guint _tmp3_;
				Page* _tmp4_;
				guint _tmp5_;
#line 56 "/home/bob/git/simple-scan/src/book.vala"
				_tmp2_ = page;
#line 56 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 56 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 57 "/home/bob/git/simple-scan/src/book.vala"
				_tmp4_ = page;
#line 57 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 57 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 54 "/home/bob/git/simple-scan/src/book.vala"
				_page_unref0 (page);
#line 456 "book.c"
			}
		}
	}
#line 59 "/home/bob/git/simple-scan/src/book.vala"
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__page_unref0_ (self->priv->pages), NULL));
#line 59 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = NULL;
#line 60 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_emit (self, book_signals[BOOK_CLEARED_SIGNAL], 0);
#line 466 "book.c"
}


static void
book_page_changed_cb (Book* self,
                      Page* page)
{
#line 63 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (page != NULL);
#line 65 "/home/bob/git/simple-scan/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 480 "book.c"
}


void
book_append_page (Book* self,
                  Page* page)
{
	Page* _tmp0_;
#line 68 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (page != NULL);
#line 70 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_connect (page, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 71 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_connect (page, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 73 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = _page_ref0 (page);
#line 73 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = g_list_append (self->priv->pages, _tmp0_);
#line 74 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_emit (self, book_signals[BOOK_PAGE_ADDED_SIGNAL], 0, page);
#line 75 "/home/bob/git/simple-scan/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 505 "book.c"
}


void
book_move_page (Book* self,
                Page* page,
                guint location)
{
	Page* _tmp0_;
#line 78 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (page != NULL);
#line 80 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, page);
#line 81 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = _page_ref0 (page);
#line 81 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = g_list_insert (self->priv->pages, _tmp0_, (gint) location);
#line 82 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
#line 83 "/home/bob/git/simple-scan/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 529 "book.c"
}


void
book_reverse (Book* self)
{
	GList* new_pages = NULL;
	GList* _tmp0_;
	GList* _tmp4_;
#line 86 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 88 "/home/bob/git/simple-scan/src/book.vala"
	new_pages = NULL;
#line 89 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 545 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 89 "/home/bob/git/simple-scan/src/book.vala"
		page_collection = _tmp0_;
#line 89 "/home/bob/git/simple-scan/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 553 "book.c"
			Page* _tmp1_;
			Page* page = NULL;
#line 89 "/home/bob/git/simple-scan/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 89 "/home/bob/git/simple-scan/src/book.vala"
			page = _tmp1_;
#line 560 "book.c"
			{
				Page* _tmp2_;
				Page* _tmp3_;
#line 90 "/home/bob/git/simple-scan/src/book.vala"
				_tmp2_ = page;
#line 90 "/home/bob/git/simple-scan/src/book.vala"
				_tmp3_ = _page_ref0 (_tmp2_);
#line 90 "/home/bob/git/simple-scan/src/book.vala"
				new_pages = g_list_prepend (new_pages, _tmp3_);
#line 89 "/home/bob/git/simple-scan/src/book.vala"
				_page_unref0 (page);
#line 572 "book.c"
			}
		}
	}
#line 91 "/home/bob/git/simple-scan/src/book.vala"
	_tmp4_ = new_pages;
#line 91 "/home/bob/git/simple-scan/src/book.vala"
	new_pages = NULL;
#line 91 "/home/bob/git/simple-scan/src/book.vala"
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__page_unref0_ (self->priv->pages), NULL));
#line 91 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = _tmp4_;
#line 93 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
#line 94 "/home/bob/git/simple-scan/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 86 "/home/bob/git/simple-scan/src/book.vala"
	(new_pages == NULL) ? NULL : (new_pages = (_g_list_free__page_unref0_ (new_pages), NULL));
#line 590 "book.c"
}


void
book_combine_sides (Book* self)
{
	guint n_front = 0U;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GList* new_pages = NULL;
	GList* _tmp19_;
#line 97 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 99 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = _tmp0_;
#line 99 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = book_get_n_pages (self);
#line 99 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3_ = _tmp2_;
#line 99 "/home/bob/git/simple-scan/src/book.vala"
	n_front = _tmp1_ - (_tmp3_ / 2);
#line 100 "/home/bob/git/simple-scan/src/book.vala"
	new_pages = NULL;
#line 618 "book.c"
	{
		gint i = 0;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 623 "book.c"
		{
			gboolean _tmp4_ = FALSE;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
			_tmp4_ = TRUE;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 630 "book.c"
				gint _tmp6_;
				guint _tmp7_;
				guint _tmp8_;
				gint _tmp9_;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp4_) {
#line 637 "book.c"
					gint _tmp5_;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
					_tmp5_ = i;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp5_ + 1;
#line 643 "book.c"
				}
#line 101 "/home/bob/git/simple-scan/src/book.vala"
				_tmp4_ = FALSE;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
				_tmp6_ = i;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
				_tmp7_ = book_get_n_pages (self);
#line 101 "/home/bob/git/simple-scan/src/book.vala"
				_tmp8_ = _tmp7_;
#line 101 "/home/bob/git/simple-scan/src/book.vala"
				if (!(((guint) _tmp6_) < _tmp8_)) {
#line 101 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 657 "book.c"
				}
#line 103 "/home/bob/git/simple-scan/src/book.vala"
				_tmp9_ = i;
#line 103 "/home/bob/git/simple-scan/src/book.vala"
				if ((_tmp9_ % 2) == 0) {
#line 663 "book.c"
					GList* _tmp10_;
					gint _tmp11_;
					gconstpointer _tmp12_;
					Page* _tmp13_;
#line 104 "/home/bob/git/simple-scan/src/book.vala"
					_tmp10_ = self->priv->pages;
#line 104 "/home/bob/git/simple-scan/src/book.vala"
					_tmp11_ = i;
#line 104 "/home/bob/git/simple-scan/src/book.vala"
					_tmp12_ = g_list_nth_data (_tmp10_, (guint) (_tmp11_ / 2));
#line 104 "/home/bob/git/simple-scan/src/book.vala"
					_tmp13_ = _page_ref0 ((Page*) _tmp12_);
#line 104 "/home/bob/git/simple-scan/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp13_);
#line 678 "book.c"
				} else {
					GList* _tmp14_;
					guint _tmp15_;
					gint _tmp16_;
					gconstpointer _tmp17_;
					Page* _tmp18_;
#line 106 "/home/bob/git/simple-scan/src/book.vala"
					_tmp14_ = self->priv->pages;
#line 106 "/home/bob/git/simple-scan/src/book.vala"
					_tmp15_ = n_front;
#line 106 "/home/bob/git/simple-scan/src/book.vala"
					_tmp16_ = i;
#line 106 "/home/bob/git/simple-scan/src/book.vala"
					_tmp17_ = g_list_nth_data (_tmp14_, _tmp15_ + (_tmp16_ / 2));
#line 106 "/home/bob/git/simple-scan/src/book.vala"
					_tmp18_ = _page_ref0 ((Page*) _tmp17_);
#line 106 "/home/bob/git/simple-scan/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp18_);
#line 697 "book.c"
				}
			}
		}
	}
#line 108 "/home/bob/git/simple-scan/src/book.vala"
	_tmp19_ = new_pages;
#line 108 "/home/bob/git/simple-scan/src/book.vala"
	new_pages = NULL;
#line 108 "/home/bob/git/simple-scan/src/book.vala"
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__page_unref0_ (self->priv->pages), NULL));
#line 108 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = _tmp19_;
#line 110 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
#line 111 "/home/bob/git/simple-scan/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 97 "/home/bob/git/simple-scan/src/book.vala"
	(new_pages == NULL) ? NULL : (new_pages = (_g_list_free__page_unref0_ (new_pages), NULL));
#line 716 "book.c"
}


void
book_combine_sides_reverse (Book* self)
{
	GList* new_pages = NULL;
	GList* _tmp16_;
#line 114 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 116 "/home/bob/git/simple-scan/src/book.vala"
	new_pages = NULL;
#line 729 "book.c"
	{
		gint i = 0;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 734 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
			_tmp0_ = TRUE;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 741 "book.c"
				gint _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				gint _tmp5_;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp0_) {
#line 748 "book.c"
					gint _tmp1_;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
					_tmp1_ = i;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp1_ + 1;
#line 754 "book.c"
				}
#line 117 "/home/bob/git/simple-scan/src/book.vala"
				_tmp0_ = FALSE;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
				_tmp2_ = i;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
				_tmp3_ = book_get_n_pages (self);
#line 117 "/home/bob/git/simple-scan/src/book.vala"
				_tmp4_ = _tmp3_;
#line 117 "/home/bob/git/simple-scan/src/book.vala"
				if (!(((guint) _tmp2_) < _tmp4_)) {
#line 117 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 768 "book.c"
				}
#line 119 "/home/bob/git/simple-scan/src/book.vala"
				_tmp5_ = i;
#line 119 "/home/bob/git/simple-scan/src/book.vala"
				if ((_tmp5_ % 2) == 0) {
#line 774 "book.c"
					GList* _tmp6_;
					gint _tmp7_;
					gconstpointer _tmp8_;
					Page* _tmp9_;
#line 120 "/home/bob/git/simple-scan/src/book.vala"
					_tmp6_ = self->priv->pages;
#line 120 "/home/bob/git/simple-scan/src/book.vala"
					_tmp7_ = i;
#line 120 "/home/bob/git/simple-scan/src/book.vala"
					_tmp8_ = g_list_nth_data (_tmp6_, (guint) (_tmp7_ / 2));
#line 120 "/home/bob/git/simple-scan/src/book.vala"
					_tmp9_ = _page_ref0 ((Page*) _tmp8_);
#line 120 "/home/bob/git/simple-scan/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp9_);
#line 789 "book.c"
				} else {
					GList* _tmp10_;
					guint _tmp11_;
					guint _tmp12_;
					gint _tmp13_;
					gconstpointer _tmp14_;
					Page* _tmp15_;
#line 122 "/home/bob/git/simple-scan/src/book.vala"
					_tmp10_ = self->priv->pages;
#line 122 "/home/bob/git/simple-scan/src/book.vala"
					_tmp11_ = book_get_n_pages (self);
#line 122 "/home/bob/git/simple-scan/src/book.vala"
					_tmp12_ = _tmp11_;
#line 122 "/home/bob/git/simple-scan/src/book.vala"
					_tmp13_ = i;
#line 122 "/home/bob/git/simple-scan/src/book.vala"
					_tmp14_ = g_list_nth_data (_tmp10_, (_tmp12_ - 1) - (_tmp13_ / 2));
#line 122 "/home/bob/git/simple-scan/src/book.vala"
					_tmp15_ = _page_ref0 ((Page*) _tmp14_);
#line 122 "/home/bob/git/simple-scan/src/book.vala"
					new_pages = g_list_append (new_pages, _tmp15_);
#line 811 "book.c"
				}
			}
		}
	}
#line 124 "/home/bob/git/simple-scan/src/book.vala"
	_tmp16_ = new_pages;
#line 124 "/home/bob/git/simple-scan/src/book.vala"
	new_pages = NULL;
#line 124 "/home/bob/git/simple-scan/src/book.vala"
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__page_unref0_ (self->priv->pages), NULL));
#line 124 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = _tmp16_;
#line 126 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_emit (self, book_signals[BOOK_REORDERED_SIGNAL], 0);
#line 127 "/home/bob/git/simple-scan/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 114 "/home/bob/git/simple-scan/src/book.vala"
	(new_pages == NULL) ? NULL : (new_pages = (_g_list_free__page_unref0_ (new_pages), NULL));
#line 830 "book.c"
}


void
book_delete_page (Book* self,
                  Page* page)
{
	guint _tmp0_;
	guint _tmp1_;
#line 130 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 130 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (page != NULL);
#line 132 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp0_, NULL, FALSE);
#line 132 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_handlers_disconnect_matched (page, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 133 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 133 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_handlers_disconnect_matched (page, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 134 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, page);
#line 135 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_emit (self, book_signals[BOOK_PAGE_REMOVED_SIGNAL], 0, page);
#line 136 "/home/bob/git/simple-scan/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 858 "book.c"
}


Page*
book_get_page (Book* self,
               gint page_number)
{
	Page* result = NULL;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	Page* _tmp3_;
#line 139 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 141 "/home/bob/git/simple-scan/src/book.vala"
	if (page_number < 0) {
#line 874 "book.c"
		GList* _tmp0_;
#line 142 "/home/bob/git/simple-scan/src/book.vala"
		_tmp0_ = self->priv->pages;
#line 142 "/home/bob/git/simple-scan/src/book.vala"
		page_number = ((gint) g_list_length (_tmp0_)) + page_number;
#line 880 "book.c"
	}
#line 143 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = self->priv->pages;
#line 143 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = g_list_nth_data (_tmp1_, (guint) page_number);
#line 143 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3_ = _page_ref0 ((Page*) _tmp2_);
#line 143 "/home/bob/git/simple-scan/src/book.vala"
	result = _tmp3_;
#line 143 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 892 "book.c"
}


guint
book_get_page_index (Book* self,
                     Page* page)
{
	guint result = 0U;
	GList* _tmp0_;
#line 146 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 146 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (page != NULL, 0U);
#line 148 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 148 "/home/bob/git/simple-scan/src/book.vala"
	result = (guint) g_list_index (_tmp0_, page);
#line 148 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 912 "book.c"
}


static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1111 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1112 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1112 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1114 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1114 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 935 "book.c"
		gchar* _tmp2_;
#line 1115 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1115 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1115 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 943 "book.c"
	} else {
#line 1117 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = -1;
#line 1117 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 949 "book.c"
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
#line 1425 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1426 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1427 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 976 "book.c"
		glong _tmp2_;
#line 1428 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = string_length;
#line 1428 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		start = _tmp2_ + start;
#line 982 "book.c"
	}
#line 1430 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 986 "book.c"
		glong _tmp3_;
#line 1431 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1431 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		end = _tmp3_ + end;
#line 992 "book.c"
	}
#line 1433 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 996 "book.c"
		glong _tmp5_;
#line 1433 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1433 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = start <= _tmp5_;
#line 1002 "book.c"
	} else {
#line 1433 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = FALSE;
#line 1006 "book.c"
	}
#line 1433 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp4_, NULL);
#line 1434 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1012 "book.c"
		glong _tmp7_;
#line 1434 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = string_length;
#line 1434 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = end <= _tmp7_;
#line 1018 "book.c"
	} else {
#line 1434 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = FALSE;
#line 1022 "book.c"
	}
#line 1434 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp6_, NULL);
#line 1435 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1436 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1436 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp8_;
#line 1436 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1034 "book.c"
}


static GFile*
book_make_indexed_file (Book* self,
                        const gchar* uri,
                        gint i)
{
	GFile* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	gchar* basename = NULL;
	gchar* _tmp3_;
	gchar* prefix = NULL;
	gchar* _tmp4_;
	gchar* suffix = NULL;
	gchar* _tmp5_;
	gint extension_index = 0;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint width = 0;
	guint _tmp20_;
	guint _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gchar* number_format = NULL;
	gint _tmp27_;
	gchar* _tmp28_;
	gchar* filename = NULL;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	GFile* _tmp41_;
#line 151 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 151 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 153 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 153 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = _tmp0_;
#line 153 "/home/bob/git/simple-scan/src/book.vala"
	if (_tmp1_ == ((guint) 1)) {
#line 1090 "book.c"
		GFile* _tmp2_;
#line 154 "/home/bob/git/simple-scan/src/book.vala"
		_tmp2_ = g_file_new_for_uri (uri);
#line 154 "/home/bob/git/simple-scan/src/book.vala"
		result = _tmp2_;
#line 154 "/home/bob/git/simple-scan/src/book.vala"
		return result;
#line 1098 "book.c"
	}
#line 157 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3_ = g_path_get_basename (uri);
#line 157 "/home/bob/git/simple-scan/src/book.vala"
	basename = _tmp3_;
#line 158 "/home/bob/git/simple-scan/src/book.vala"
	_tmp4_ = g_strdup (uri);
#line 158 "/home/bob/git/simple-scan/src/book.vala"
	prefix = _tmp4_;
#line 158 "/home/bob/git/simple-scan/src/book.vala"
	_tmp5_ = g_strdup ("");
#line 158 "/home/bob/git/simple-scan/src/book.vala"
	suffix = _tmp5_;
#line 159 "/home/bob/git/simple-scan/src/book.vala"
	_tmp6_ = basename;
#line 159 "/home/bob/git/simple-scan/src/book.vala"
	extension_index = string_last_index_of_char (_tmp6_, (gunichar) '.', 0);
#line 160 "/home/bob/git/simple-scan/src/book.vala"
	_tmp7_ = extension_index;
#line 160 "/home/bob/git/simple-scan/src/book.vala"
	if (_tmp7_ >= 0) {
#line 1120 "book.c"
		const gchar* _tmp8_;
		gint _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
#line 162 "/home/bob/git/simple-scan/src/book.vala"
		_tmp8_ = basename;
#line 162 "/home/bob/git/simple-scan/src/book.vala"
		_tmp9_ = extension_index;
#line 162 "/home/bob/git/simple-scan/src/book.vala"
		_tmp10_ = basename;
#line 162 "/home/bob/git/simple-scan/src/book.vala"
		_tmp11_ = strlen (_tmp10_);
#line 162 "/home/bob/git/simple-scan/src/book.vala"
		_tmp12_ = _tmp11_;
#line 162 "/home/bob/git/simple-scan/src/book.vala"
		_tmp13_ = string_slice (_tmp8_, (glong) _tmp9_, (glong) _tmp12_);
#line 162 "/home/bob/git/simple-scan/src/book.vala"
		_g_free0 (suffix);
#line 162 "/home/bob/git/simple-scan/src/book.vala"
		suffix = _tmp13_;
#line 163 "/home/bob/git/simple-scan/src/book.vala"
		_tmp14_ = strlen (uri);
#line 163 "/home/bob/git/simple-scan/src/book.vala"
		_tmp15_ = _tmp14_;
#line 163 "/home/bob/git/simple-scan/src/book.vala"
		_tmp16_ = suffix;
#line 163 "/home/bob/git/simple-scan/src/book.vala"
		_tmp17_ = strlen (_tmp16_);
#line 163 "/home/bob/git/simple-scan/src/book.vala"
		_tmp18_ = _tmp17_;
#line 163 "/home/bob/git/simple-scan/src/book.vala"
		_tmp19_ = string_slice (uri, (glong) 0, (glong) (_tmp15_ - _tmp18_));
#line 163 "/home/bob/git/simple-scan/src/book.vala"
		_g_free0 (prefix);
#line 163 "/home/bob/git/simple-scan/src/book.vala"
		prefix = _tmp19_;
#line 1165 "book.c"
	}
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	_tmp20_ = book_get_n_pages (self);
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	_tmp21_ = _tmp20_;
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	_tmp22_ = g_strdup_printf ("%u", _tmp21_);
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	_tmp23_ = _tmp22_;
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	_tmp24_ = strlen (_tmp23_);
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	_tmp25_ = _tmp24_;
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	_tmp26_ = _tmp25_;
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp23_);
#line 165 "/home/bob/git/simple-scan/src/book.vala"
	width = _tmp26_;
#line 166 "/home/bob/git/simple-scan/src/book.vala"
	_tmp27_ = width;
#line 166 "/home/bob/git/simple-scan/src/book.vala"
	_tmp28_ = g_strdup_printf ("%%0%dd", _tmp27_);
#line 166 "/home/bob/git/simple-scan/src/book.vala"
	number_format = _tmp28_;
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp29_ = prefix;
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp30_ = g_strconcat (_tmp29_, "-", NULL);
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp31_ = _tmp30_;
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp32_ = number_format;
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp33_ = g_strdup_printf (_tmp32_, i + 1);
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp34_ = _tmp33_;
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp35_ = g_strconcat (_tmp31_, _tmp34_, NULL);
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp36_ = _tmp35_;
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp37_ = suffix;
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_tmp39_ = _tmp38_;
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp36_);
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp34_);
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp31_);
#line 167 "/home/bob/git/simple-scan/src/book.vala"
	filename = _tmp39_;
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	_tmp40_ = filename;
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	_tmp41_ = g_file_new_for_uri (_tmp40_);
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	result = _tmp41_;
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (filename);
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (number_format);
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (suffix);
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (prefix);
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (basename);
#line 168 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 1239 "book.c"
}


static void
book_save_multi_file (Book* self,
                      const gchar* type,
                      gint quality,
                      GFile* file,
                      GError** error)
{
	GError * _inner_error_ = NULL;
#line 171 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 171 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (type != NULL);
#line 171 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (file != NULL);
#line 1257 "book.c"
	{
		gint i = 0;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 1262 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
			_tmp0_ = TRUE;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 1269 "book.c"
				gint _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				Page* page = NULL;
				gint _tmp5_;
				Page* _tmp6_;
				Page* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gint _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				gint _tmp13_;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp0_) {
#line 1285 "book.c"
					gint _tmp1_;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
					_tmp1_ = i;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp1_ + 1;
#line 1291 "book.c"
				}
#line 173 "/home/bob/git/simple-scan/src/book.vala"
				_tmp0_ = FALSE;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
				_tmp2_ = i;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
				_tmp3_ = book_get_n_pages (self);
#line 173 "/home/bob/git/simple-scan/src/book.vala"
				_tmp4_ = _tmp3_;
#line 173 "/home/bob/git/simple-scan/src/book.vala"
				if (!(((guint) _tmp2_) < _tmp4_)) {
#line 173 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 1305 "book.c"
				}
#line 175 "/home/bob/git/simple-scan/src/book.vala"
				_tmp5_ = i;
#line 175 "/home/bob/git/simple-scan/src/book.vala"
				_tmp6_ = book_get_page (self, _tmp5_);
#line 175 "/home/bob/git/simple-scan/src/book.vala"
				page = _tmp6_;
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				_tmp7_ = page;
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				_tmp8_ = g_file_get_uri (file);
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				_tmp9_ = _tmp8_;
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				_tmp10_ = i;
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				_tmp11_ = book_make_indexed_file (self, _tmp9_, _tmp10_);
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				_tmp12_ = _tmp11_;
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				page_save (_tmp7_, type, quality, _tmp12_, &_inner_error_);
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				_g_object_unref0 (_tmp12_);
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp9_);
#line 176 "/home/bob/git/simple-scan/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/bob/git/simple-scan/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 176 "/home/bob/git/simple-scan/src/book.vala"
					_page_unref0 (page);
#line 176 "/home/bob/git/simple-scan/src/book.vala"
					return;
#line 1339 "book.c"
				}
#line 177 "/home/bob/git/simple-scan/src/book.vala"
				_tmp13_ = i;
#line 177 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_emit (self, book_signals[BOOK_SAVING_SIGNAL], 0, _tmp13_);
#line 173 "/home/bob/git/simple-scan/src/book.vala"
				_page_unref0 (page);
#line 1347 "book.c"
			}
		}
	}
}


static void
book_save_ps_pdf_surface (Book* self,
                          cairo_surface_t* surface,
                          GdkPixbuf* image,
                          gdouble dpi)
{
	cairo_t* context = NULL;
	cairo_t* _tmp0_;
	cairo_pattern_t* _tmp1_;
#line 181 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (surface != NULL);
#line 181 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (image != NULL);
#line 183 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = cairo_create (surface);
#line 183 "/home/bob/git/simple-scan/src/book.vala"
	context = _tmp0_;
#line 184 "/home/bob/git/simple-scan/src/book.vala"
	cairo_scale (context, 72.0 / dpi, 72.0 / dpi);
#line 185 "/home/bob/git/simple-scan/src/book.vala"
	gdk_cairo_set_source_pixbuf (context, image, (gdouble) 0, (gdouble) 0);
#line 186 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = cairo_get_source (context);
#line 186 "/home/bob/git/simple-scan/src/book.vala"
	cairo_pattern_set_filter (_tmp1_, CAIRO_FILTER_BEST);
#line 187 "/home/bob/git/simple-scan/src/book.vala"
	cairo_paint (context);
#line 181 "/home/bob/git/simple-scan/src/book.vala"
	_cairo_destroy0 (context);
#line 1385 "book.c"
}


static gpointer
_cairo_surface_reference0 (gpointer self)
{
#line 194 "/home/bob/git/simple-scan/src/book.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 1394 "book.c"
}


static void
book_save_ps (Book* self,
              GFile* file,
              GError** error)
{
	GFileOutputStream* stream = NULL;
	GFileOutputStream* _tmp0_;
	PsWriter* writer = NULL;
	PsWriter* _tmp1_;
	cairo_surface_t* surface = NULL;
	PsWriter* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	GError * _inner_error_ = NULL;
#line 190 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (file != NULL);
#line 192 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 192 "/home/bob/git/simple-scan/src/book.vala"
	stream = _tmp0_;
#line 192 "/home/bob/git/simple-scan/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/bob/git/simple-scan/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/bob/git/simple-scan/src/book.vala"
		return;
#line 1426 "book.c"
	}
#line 193 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = ps_writer_new (stream);
#line 193 "/home/bob/git/simple-scan/src/book.vala"
	writer = _tmp1_;
#line 194 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = writer;
#line 194 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3_ = _tmp2_->surface;
#line 194 "/home/bob/git/simple-scan/src/book.vala"
	_tmp4_ = _cairo_surface_reference0 (_tmp3_);
#line 194 "/home/bob/git/simple-scan/src/book.vala"
	surface = _tmp4_;
#line 1440 "book.c"
	{
		gint i = 0;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 1445 "book.c"
		{
			gboolean _tmp5_ = FALSE;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
			_tmp5_ = TRUE;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 1452 "book.c"
				gint _tmp7_;
				guint _tmp8_;
				guint _tmp9_;
				Page* page = NULL;
				gint _tmp10_;
				Page* _tmp11_;
				GdkPixbuf* image = NULL;
				Page* _tmp12_;
				GdkPixbuf* _tmp13_;
				gdouble width = 0.0;
				GdkPixbuf* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				Page* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gdouble height = 0.0;
				GdkPixbuf* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				Page* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				cairo_surface_t* _tmp26_;
				gdouble _tmp27_;
				gdouble _tmp28_;
				cairo_surface_t* _tmp29_;
				GdkPixbuf* _tmp30_;
				Page* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				cairo_surface_t* _tmp34_;
				gint _tmp35_;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp5_) {
#line 1488 "book.c"
					gint _tmp6_;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
					_tmp6_ = i;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp6_ + 1;
#line 1494 "book.c"
				}
#line 196 "/home/bob/git/simple-scan/src/book.vala"
				_tmp5_ = FALSE;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
				_tmp7_ = i;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
				_tmp8_ = book_get_n_pages (self);
#line 196 "/home/bob/git/simple-scan/src/book.vala"
				_tmp9_ = _tmp8_;
#line 196 "/home/bob/git/simple-scan/src/book.vala"
				if (!(((guint) _tmp7_) < _tmp9_)) {
#line 196 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 1508 "book.c"
				}
#line 198 "/home/bob/git/simple-scan/src/book.vala"
				_tmp10_ = i;
#line 198 "/home/bob/git/simple-scan/src/book.vala"
				_tmp11_ = book_get_page (self, _tmp10_);
#line 198 "/home/bob/git/simple-scan/src/book.vala"
				page = _tmp11_;
#line 199 "/home/bob/git/simple-scan/src/book.vala"
				_tmp12_ = page;
#line 199 "/home/bob/git/simple-scan/src/book.vala"
				_tmp13_ = page_get_image (_tmp12_, TRUE);
#line 199 "/home/bob/git/simple-scan/src/book.vala"
				image = _tmp13_;
#line 200 "/home/bob/git/simple-scan/src/book.vala"
				_tmp14_ = image;
#line 200 "/home/bob/git/simple-scan/src/book.vala"
				_tmp15_ = gdk_pixbuf_get_width (_tmp14_);
#line 200 "/home/bob/git/simple-scan/src/book.vala"
				_tmp16_ = _tmp15_;
#line 200 "/home/bob/git/simple-scan/src/book.vala"
				_tmp17_ = page;
#line 200 "/home/bob/git/simple-scan/src/book.vala"
				_tmp18_ = page_get_dpi (_tmp17_);
#line 200 "/home/bob/git/simple-scan/src/book.vala"
				_tmp19_ = _tmp18_;
#line 200 "/home/bob/git/simple-scan/src/book.vala"
				width = (_tmp16_ * 72.0) / _tmp19_;
#line 201 "/home/bob/git/simple-scan/src/book.vala"
				_tmp20_ = image;
#line 201 "/home/bob/git/simple-scan/src/book.vala"
				_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
#line 201 "/home/bob/git/simple-scan/src/book.vala"
				_tmp22_ = _tmp21_;
#line 201 "/home/bob/git/simple-scan/src/book.vala"
				_tmp23_ = page;
#line 201 "/home/bob/git/simple-scan/src/book.vala"
				_tmp24_ = page_get_dpi (_tmp23_);
#line 201 "/home/bob/git/simple-scan/src/book.vala"
				_tmp25_ = _tmp24_;
#line 201 "/home/bob/git/simple-scan/src/book.vala"
				height = (_tmp22_ * 72.0) / _tmp25_;
#line 202 "/home/bob/git/simple-scan/src/book.vala"
				_tmp26_ = surface;
#line 202 "/home/bob/git/simple-scan/src/book.vala"
				_tmp27_ = width;
#line 202 "/home/bob/git/simple-scan/src/book.vala"
				_tmp28_ = height;
#line 202 "/home/bob/git/simple-scan/src/book.vala"
				cairo_ps_surface_set_size (_tmp26_, _tmp27_, _tmp28_);
#line 203 "/home/bob/git/simple-scan/src/book.vala"
				_tmp29_ = surface;
#line 203 "/home/bob/git/simple-scan/src/book.vala"
				_tmp30_ = image;
#line 203 "/home/bob/git/simple-scan/src/book.vala"
				_tmp31_ = page;
#line 203 "/home/bob/git/simple-scan/src/book.vala"
				_tmp32_ = page_get_dpi (_tmp31_);
#line 203 "/home/bob/git/simple-scan/src/book.vala"
				_tmp33_ = _tmp32_;
#line 203 "/home/bob/git/simple-scan/src/book.vala"
				book_save_ps_pdf_surface (self, _tmp29_, _tmp30_, (gdouble) _tmp33_);
#line 204 "/home/bob/git/simple-scan/src/book.vala"
				_tmp34_ = surface;
#line 204 "/home/bob/git/simple-scan/src/book.vala"
				cairo_surface_show_page (_tmp34_);
#line 205 "/home/bob/git/simple-scan/src/book.vala"
				_tmp35_ = i;
#line 205 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_emit (self, book_signals[BOOK_SAVING_SIGNAL], 0, _tmp35_);
#line 196 "/home/bob/git/simple-scan/src/book.vala"
				_g_object_unref0 (image);
#line 196 "/home/bob/git/simple-scan/src/book.vala"
				_page_unref0 (page);
#line 1582 "book.c"
			}
		}
	}
#line 190 "/home/bob/git/simple-scan/src/book.vala"
	_cairo_surface_destroy0 (surface);
#line 190 "/home/bob/git/simple-scan/src/book.vala"
	_ps_writer_unref0 (writer);
#line 190 "/home/bob/git/simple-scan/src/book.vala"
	_g_object_unref0 (stream);
#line 1592 "book.c"
}


static guint8*
book_compress_zlib (Book* self,
                    guint8* data,
                    int data_length1,
                    int* result_length1)
{
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* out_data = NULL;
	guint8* _tmp0_;
	gint out_data_length1;
	gint _out_data_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	z_stream _tmp4_;
	guint _tmp5_;
	guint n_written = 0U;
	z_stream _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	gint _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
#line 209 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 211 "/home/bob/git/simple-scan/src/book.vala"
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
#line 212 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = g_new0 (guint8, data_length1);
#line 212 "/home/bob/git/simple-scan/src/book.vala"
	out_data = _tmp0_;
#line 212 "/home/bob/git/simple-scan/src/book.vala"
	out_data_length1 = data_length1;
#line 212 "/home/bob/git/simple-scan/src/book.vala"
	_out_data_size_ = out_data_length1;
#line 214 "/home/bob/git/simple-scan/src/book.vala"
	stream.next_in = data;
#line 214 "/home/bob/git/simple-scan/src/book.vala"
	stream.avail_in = data_length1;
#line 215 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = out_data;
#line 215 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1__length1 = out_data_length1;
#line 215 "/home/bob/git/simple-scan/src/book.vala"
	stream.next_out = _tmp1_;
#line 215 "/home/bob/git/simple-scan/src/book.vala"
	stream.avail_out = _tmp1__length1;
#line 216 "/home/bob/git/simple-scan/src/book.vala"
	while (TRUE) {
#line 1645 "book.c"
		z_stream _tmp2_;
		guint _tmp3_;
#line 216 "/home/bob/git/simple-scan/src/book.vala"
		_tmp2_ = stream;
#line 216 "/home/bob/git/simple-scan/src/book.vala"
		_tmp3_ = _tmp2_.avail_in;
#line 216 "/home/bob/git/simple-scan/src/book.vala"
		if (!(_tmp3_ > ((guint) 0))) {
#line 216 "/home/bob/git/simple-scan/src/book.vala"
			break;
#line 1656 "book.c"
		}
#line 218 "/home/bob/git/simple-scan/src/book.vala"
		if (deflate (&stream, (gint) Z_FINISH) == ((gint) Z_STREAM_ERROR)) {
#line 219 "/home/bob/git/simple-scan/src/book.vala"
			break;
#line 1662 "book.c"
		}
	}
#line 222 "/home/bob/git/simple-scan/src/book.vala"
	_tmp4_ = stream;
#line 222 "/home/bob/git/simple-scan/src/book.vala"
	_tmp5_ = _tmp4_.avail_in;
#line 222 "/home/bob/git/simple-scan/src/book.vala"
	if (_tmp5_ > ((guint) 0)) {
#line 1671 "book.c"
		guint8* _tmp6_;
		gint _tmp6__length1;
#line 223 "/home/bob/git/simple-scan/src/book.vala"
		_tmp6_ = NULL;
#line 223 "/home/bob/git/simple-scan/src/book.vala"
		_tmp6__length1 = 0;
#line 223 "/home/bob/git/simple-scan/src/book.vala"
		if (result_length1) {
#line 223 "/home/bob/git/simple-scan/src/book.vala"
			*result_length1 = _tmp6__length1;
#line 1682 "book.c"
		}
#line 223 "/home/bob/git/simple-scan/src/book.vala"
		result = _tmp6_;
#line 223 "/home/bob/git/simple-scan/src/book.vala"
		out_data = (g_free (out_data), NULL);
#line 223 "/home/bob/git/simple-scan/src/book.vala"
		deflateEnd (&stream);
#line 223 "/home/bob/git/simple-scan/src/book.vala"
		return result;
#line 1692 "book.c"
	}
#line 225 "/home/bob/git/simple-scan/src/book.vala"
	_tmp7_ = stream;
#line 225 "/home/bob/git/simple-scan/src/book.vala"
	_tmp8_ = _tmp7_.avail_out;
#line 225 "/home/bob/git/simple-scan/src/book.vala"
	n_written = data_length1 - _tmp8_;
#line 226 "/home/bob/git/simple-scan/src/book.vala"
	_tmp9_ = n_written;
#line 226 "/home/bob/git/simple-scan/src/book.vala"
	_tmp10_ = (gint) _tmp9_;
#line 226 "/home/bob/git/simple-scan/src/book.vala"
	out_data = g_renew (guint8, out_data, (gint) _tmp9_);
#line 226 "/home/bob/git/simple-scan/src/book.vala"
	(_tmp10_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp10_ - out_data_length1)) : NULL;
#line 226 "/home/bob/git/simple-scan/src/book.vala"
	out_data_length1 = _tmp10_;
#line 226 "/home/bob/git/simple-scan/src/book.vala"
	_out_data_size_ = _tmp10_;
#line 228 "/home/bob/git/simple-scan/src/book.vala"
	_tmp11_ = out_data;
#line 228 "/home/bob/git/simple-scan/src/book.vala"
	_tmp11__length1 = out_data_length1;
#line 228 "/home/bob/git/simple-scan/src/book.vala"
	if (result_length1) {
#line 228 "/home/bob/git/simple-scan/src/book.vala"
		*result_length1 = _tmp11__length1;
#line 1720 "book.c"
	}
#line 228 "/home/bob/git/simple-scan/src/book.vala"
	result = _tmp11_;
#line 228 "/home/bob/git/simple-scan/src/book.vala"
	deflateEnd (&stream);
#line 228 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 1728 "book.c"
}


static gboolean
_book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf,
                                              gsize buf_length1,
                                              GError** error,
                                              gpointer self)
{
	gboolean result;
	result = book_write_pixbuf_data ((Book*) self, buf, buf_length1, error);
#line 240 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 1742 "book.c"
}


static guint8*
book_compress_jpeg (Book* self,
                    GdkPixbuf* image,
                    gint quality,
                    gint dpi,
                    int* result_length1)
{
	guint8* result = NULL;
	GByteArray* _tmp0_;
	gchar** keys = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint keys_length1;
	gint _keys_size_;
	gchar** values = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint values_length1;
	gint _values_size_;
	guint8* data = NULL;
	GByteArray* _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
#line 233 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 233 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 235 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = g_byte_array_new ();
#line 235 "/home/bob/git/simple-scan/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 235 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->jpeg_data = _tmp0_;
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = g_strdup ("quality");
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = g_strdup ("density-unit");
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3_ = g_strdup ("x-density");
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp4_ = g_strdup ("y-density");
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp5_[0] = _tmp1_;
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp5_[1] = _tmp2_;
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp5_[2] = _tmp3_;
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp5_[3] = _tmp4_;
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_tmp5_[4] = NULL;
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	keys = _tmp5_;
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	keys_length1 = 5;
#line 236 "/home/bob/git/simple-scan/src/book.vala"
	_keys_size_ = keys_length1;
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp6_ = g_strdup_printf ("%d", quality);
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp7_ = g_strdup ("dots-per-inch");
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp8_ = g_strdup_printf ("%d", dpi);
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp9_ = g_strdup_printf ("%d", dpi);
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp10_ = g_new0 (gchar*, 5 + 1);
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp10_[0] = _tmp6_;
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp10_[1] = _tmp7_;
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp10_[2] = _tmp8_;
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp10_[3] = _tmp9_;
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_tmp10_[4] = NULL;
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	values = _tmp10_;
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	values_length1 = 5;
#line 237 "/home/bob/git/simple-scan/src/book.vala"
	_values_size_ = values_length1;
#line 1842 "book.c"
	{
#line 240 "/home/bob/git/simple-scan/src/book.vala"
		gdk_pixbuf_save_to_callbackv (image, _book_write_pixbuf_data_gdk_pixbuf_save_func, self, "jpeg", keys, values, &_inner_error_);
#line 240 "/home/bob/git/simple-scan/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1848 "book.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 238 "/home/bob/git/simple-scan/src/book.vala"
		e = _inner_error_;
#line 238 "/home/bob/git/simple-scan/src/book.vala"
		_inner_error_ = NULL;
#line 238 "/home/bob/git/simple-scan/src/book.vala"
		_g_error_free0 (e);
#line 1862 "book.c"
	}
	__finally0:
#line 238 "/home/bob/git/simple-scan/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 238 "/home/bob/git/simple-scan/src/book.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/home/bob/git/simple-scan/src/book.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 238 "/home/bob/git/simple-scan/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 238 "/home/bob/git/simple-scan/src/book.vala"
		g_clear_error (&_inner_error_);
#line 238 "/home/bob/git/simple-scan/src/book.vala"
		return NULL;
#line 1877 "book.c"
	}
#line 245 "/home/bob/git/simple-scan/src/book.vala"
	_tmp11_ = self->priv->jpeg_data;
#line 245 "/home/bob/git/simple-scan/src/book.vala"
	_tmp12_ = _tmp11_->data;
#line 245 "/home/bob/git/simple-scan/src/book.vala"
	_tmp12__length1 = _tmp11_->len;
#line 245 "/home/bob/git/simple-scan/src/book.vala"
	_tmp11_->data = NULL;
#line 245 "/home/bob/git/simple-scan/src/book.vala"
	_tmp11_->len = 0;
#line 245 "/home/bob/git/simple-scan/src/book.vala"
	data = _tmp12_;
#line 245 "/home/bob/git/simple-scan/src/book.vala"
	data_length1 = _tmp12__length1;
#line 245 "/home/bob/git/simple-scan/src/book.vala"
	_data_size_ = data_length1;
#line 246 "/home/bob/git/simple-scan/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 246 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->jpeg_data = NULL;
#line 248 "/home/bob/git/simple-scan/src/book.vala"
	_tmp13_ = data;
#line 248 "/home/bob/git/simple-scan/src/book.vala"
	_tmp13__length1 = data_length1;
#line 248 "/home/bob/git/simple-scan/src/book.vala"
	if (result_length1) {
#line 248 "/home/bob/git/simple-scan/src/book.vala"
		*result_length1 = _tmp13__length1;
#line 1907 "book.c"
	}
#line 248 "/home/bob/git/simple-scan/src/book.vala"
	result = _tmp13_;
#line 248 "/home/bob/git/simple-scan/src/book.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 248 "/home/bob/git/simple-scan/src/book.vala"
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 248 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 1917 "book.c"
}


static gboolean
book_write_pixbuf_data (Book* self,
                        guint8* buf,
                        int buf_length1,
                        GError** error)
{
	gboolean result = FALSE;
	GByteArray* _tmp0_;
#line 251 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 253 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->priv->jpeg_data;
#line 253 "/home/bob/git/simple-scan/src/book.vala"
	g_byte_array_append (_tmp0_, buf, buf_length1);
#line 254 "/home/bob/git/simple-scan/src/book.vala"
	result = TRUE;
#line 254 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 1939 "book.c"
}


static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1019 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 1019 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 1020 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = str;
#line 1020 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_unichar_to_utf8 (self, _tmp1_);
#line 1021 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = str;
#line 1021 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1962 "book.c"
}


static guint8*
_vala_array_dup1 (guint8* self,
                  int length)
{
#line 494 "/home/bob/git/simple-scan/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1972 "book.c"
}


static guint8*
_vala_array_dup2 (guint8* self,
                  int length)
{
#line 501 "/home/bob/git/simple-scan/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1982 "book.c"
}


static void
book_save_pdf (Book* self,
               GFile* file,
               gint quality,
               GError** error)
{
	gchar* id = NULL;
	gchar* _tmp0_;
	GFileOutputStream* stream = NULL;
	GFileOutputStream* _tmp8_;
	PDFWriter* writer = NULL;
	PDFWriter* _tmp9_;
	guint catalog_number = 0U;
	PDFWriter* _tmp10_;
	guint metadata_number = 0U;
	PDFWriter* _tmp11_;
	guint pages_number = 0U;
	PDFWriter* _tmp12_;
	guint info_number = 0U;
	PDFWriter* _tmp13_;
	guint* page_numbers = NULL;
	guint _tmp14_;
	guint _tmp15_;
	guint* _tmp16_;
	gint page_numbers_length1;
	gint _page_numbers_size_;
	guint* page_image_numbers = NULL;
	guint _tmp17_;
	guint _tmp18_;
	guint* _tmp19_;
	gint page_image_numbers_length1;
	gint _page_image_numbers_size_;
	guint* page_content_numbers = NULL;
	guint _tmp20_;
	guint _tmp21_;
	guint* _tmp22_;
	gint page_content_numbers_length1;
	gint _page_content_numbers_size_;
	guint struct_tree_root_number = 0U;
	PDFWriter* _tmp40_;
	PDFWriter* _tmp41_;
	PDFWriter* _tmp42_;
	PDFWriter* _tmp43_;
	guint _tmp44_;
	PDFWriter* _tmp45_;
	guint _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	PDFWriter* _tmp49_;
	PDFWriter* _tmp50_;
	PDFWriter* _tmp51_;
	guint _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	PDFWriter* _tmp55_;
	PDFWriter* _tmp56_;
	guint _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	PDFWriter* _tmp60_;
	guint _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	PDFWriter* _tmp64_;
	PDFWriter* _tmp65_;
	GDateTime* now = NULL;
	GDateTime* _tmp66_;
	gchar* date_string = NULL;
	GDateTime* _tmp67_;
	gchar* _tmp68_;
	gchar* metadata = NULL;
	gchar* _tmp69_;
	gchar* _tmp70_;
	const gchar* _tmp71_;
	const gchar* _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	PDFWriter* _tmp76_;
	PDFWriter* _tmp77_;
	guint _tmp78_;
	PDFWriter* _tmp79_;
	guint _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	PDFWriter* _tmp83_;
	PDFWriter* _tmp84_;
	PDFWriter* _tmp85_;
	PDFWriter* _tmp86_;
	const gchar* _tmp87_;
	gint _tmp88_;
	gint _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	PDFWriter* _tmp92_;
	PDFWriter* _tmp93_;
	PDFWriter* _tmp94_;
	const gchar* _tmp95_;
	PDFWriter* _tmp96_;
	PDFWriter* _tmp97_;
	PDFWriter* _tmp98_;
	PDFWriter* _tmp99_;
	PDFWriter* _tmp100_;
	guint _tmp101_;
	PDFWriter* _tmp102_;
	guint _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	PDFWriter* _tmp106_;
	PDFWriter* _tmp107_;
	PDFWriter* _tmp108_;
	PDFWriter* _tmp120_;
	PDFWriter* _tmp121_;
	guint _tmp122_;
	guint _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	PDFWriter* _tmp126_;
	PDFWriter* _tmp127_;
	PDFWriter* _tmp464_;
	PDFWriter* _tmp465_;
	guint _tmp466_;
	PDFWriter* _tmp467_;
	guint _tmp468_;
	gchar* _tmp469_;
	gchar* _tmp470_;
	PDFWriter* _tmp471_;
	PDFWriter* _tmp472_;
	gchar* _tmp473_;
	gchar* _tmp474_;
	PDFWriter* _tmp475_;
	PDFWriter* _tmp476_;
	PDFWriter* _tmp477_;
	gsize xref_offset = 0UL;
	PDFWriter* _tmp478_;
	gsize _tmp479_;
	PDFWriter* _tmp480_;
	PDFWriter* _tmp481_;
	PDFWriter* _tmp482_;
	guint* _tmp483_;
	gint _tmp483__length1;
	gchar* _tmp484_;
	gchar* _tmp485_;
	PDFWriter* _tmp486_;
	PDFWriter* _tmp487_;
	gchar* _tmp488_;
	gchar* _tmp489_;
	PDFWriter* _tmp511_;
	PDFWriter* _tmp512_;
	PDFWriter* _tmp513_;
	PDFWriter* _tmp514_;
	PDFWriter* _tmp515_;
	guint* _tmp516_;
	gint _tmp516__length1;
	gchar* _tmp517_;
	gchar* _tmp518_;
	PDFWriter* _tmp519_;
	guint _tmp520_;
	gchar* _tmp521_;
	gchar* _tmp522_;
	PDFWriter* _tmp523_;
	guint _tmp524_;
	gchar* _tmp525_;
	gchar* _tmp526_;
	PDFWriter* _tmp527_;
	const gchar* _tmp528_;
	const gchar* _tmp529_;
	gchar* _tmp530_;
	gchar* _tmp531_;
	PDFWriter* _tmp532_;
	PDFWriter* _tmp533_;
	PDFWriter* _tmp534_;
	gsize _tmp535_;
	gchar* _tmp536_;
	gchar* _tmp537_;
	PDFWriter* _tmp538_;
	GError * _inner_error_ = NULL;
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (file != NULL);
#line 260 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = g_strdup ("");
#line 260 "/home/bob/git/simple-scan/src/book.vala"
	id = _tmp0_;
#line 2171 "book.c"
	{
		gint i = 0;
#line 261 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 2176 "book.c"
		{
			gboolean _tmp1_ = FALSE;
#line 261 "/home/bob/git/simple-scan/src/book.vala"
			_tmp1_ = TRUE;
#line 261 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 2183 "book.c"
				gint _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
#line 261 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp1_) {
#line 2191 "book.c"
					gint _tmp2_;
#line 261 "/home/bob/git/simple-scan/src/book.vala"
					_tmp2_ = i;
#line 261 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp2_ + 1;
#line 2197 "book.c"
				}
#line 261 "/home/bob/git/simple-scan/src/book.vala"
				_tmp1_ = FALSE;
#line 261 "/home/bob/git/simple-scan/src/book.vala"
				_tmp3_ = i;
#line 261 "/home/bob/git/simple-scan/src/book.vala"
				if (!(_tmp3_ < 4)) {
#line 261 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 2207 "book.c"
				}
#line 262 "/home/bob/git/simple-scan/src/book.vala"
				_tmp4_ = id;
#line 262 "/home/bob/git/simple-scan/src/book.vala"
				_tmp5_ = g_strdup_printf ("%08x", (guint) g_random_int ());
#line 262 "/home/bob/git/simple-scan/src/book.vala"
				_tmp6_ = _tmp5_;
#line 262 "/home/bob/git/simple-scan/src/book.vala"
				_tmp7_ = g_strconcat (_tmp4_, _tmp6_, NULL);
#line 262 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (id);
#line 262 "/home/bob/git/simple-scan/src/book.vala"
				id = _tmp7_;
#line 262 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp6_);
#line 2223 "book.c"
			}
		}
	}
#line 264 "/home/bob/git/simple-scan/src/book.vala"
	_tmp8_ = g_file_replace (file, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 264 "/home/bob/git/simple-scan/src/book.vala"
	stream = _tmp8_;
#line 264 "/home/bob/git/simple-scan/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 264 "/home/bob/git/simple-scan/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 264 "/home/bob/git/simple-scan/src/book.vala"
		_g_free0 (id);
#line 264 "/home/bob/git/simple-scan/src/book.vala"
		return;
#line 2239 "book.c"
	}
#line 265 "/home/bob/git/simple-scan/src/book.vala"
	_tmp9_ = pdf_writer_new (stream);
#line 265 "/home/bob/git/simple-scan/src/book.vala"
	writer = _tmp9_;
#line 268 "/home/bob/git/simple-scan/src/book.vala"
	_tmp10_ = writer;
#line 268 "/home/bob/git/simple-scan/src/book.vala"
	catalog_number = pdf_writer_add_object (_tmp10_);
#line 269 "/home/bob/git/simple-scan/src/book.vala"
	_tmp11_ = writer;
#line 269 "/home/bob/git/simple-scan/src/book.vala"
	metadata_number = pdf_writer_add_object (_tmp11_);
#line 270 "/home/bob/git/simple-scan/src/book.vala"
	_tmp12_ = writer;
#line 270 "/home/bob/git/simple-scan/src/book.vala"
	pages_number = pdf_writer_add_object (_tmp12_);
#line 271 "/home/bob/git/simple-scan/src/book.vala"
	_tmp13_ = writer;
#line 271 "/home/bob/git/simple-scan/src/book.vala"
	info_number = pdf_writer_add_object (_tmp13_);
#line 272 "/home/bob/git/simple-scan/src/book.vala"
	_tmp14_ = book_get_n_pages (self);
#line 272 "/home/bob/git/simple-scan/src/book.vala"
	_tmp15_ = _tmp14_;
#line 272 "/home/bob/git/simple-scan/src/book.vala"
	_tmp16_ = g_new0 (guint, _tmp15_);
#line 272 "/home/bob/git/simple-scan/src/book.vala"
	page_numbers = _tmp16_;
#line 272 "/home/bob/git/simple-scan/src/book.vala"
	page_numbers_length1 = _tmp15_;
#line 272 "/home/bob/git/simple-scan/src/book.vala"
	_page_numbers_size_ = page_numbers_length1;
#line 273 "/home/bob/git/simple-scan/src/book.vala"
	_tmp17_ = book_get_n_pages (self);
#line 273 "/home/bob/git/simple-scan/src/book.vala"
	_tmp18_ = _tmp17_;
#line 273 "/home/bob/git/simple-scan/src/book.vala"
	_tmp19_ = g_new0 (guint, _tmp18_);
#line 273 "/home/bob/git/simple-scan/src/book.vala"
	page_image_numbers = _tmp19_;
#line 273 "/home/bob/git/simple-scan/src/book.vala"
	page_image_numbers_length1 = _tmp18_;
#line 273 "/home/bob/git/simple-scan/src/book.vala"
	_page_image_numbers_size_ = page_image_numbers_length1;
#line 274 "/home/bob/git/simple-scan/src/book.vala"
	_tmp20_ = book_get_n_pages (self);
#line 274 "/home/bob/git/simple-scan/src/book.vala"
	_tmp21_ = _tmp20_;
#line 274 "/home/bob/git/simple-scan/src/book.vala"
	_tmp22_ = g_new0 (guint, _tmp21_);
#line 274 "/home/bob/git/simple-scan/src/book.vala"
	page_content_numbers = _tmp22_;
#line 274 "/home/bob/git/simple-scan/src/book.vala"
	page_content_numbers_length1 = _tmp21_;
#line 274 "/home/bob/git/simple-scan/src/book.vala"
	_page_content_numbers_size_ = page_content_numbers_length1;
#line 2297 "book.c"
	{
		gint i = 0;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 2302 "book.c"
		{
			gboolean _tmp23_ = FALSE;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
			_tmp23_ = TRUE;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 2309 "book.c"
				gint _tmp25_;
				guint _tmp26_;
				guint _tmp27_;
				guint* _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				PDFWriter* _tmp30_;
				guint _tmp31_;
				guint* _tmp32_;
				gint _tmp32__length1;
				gint _tmp33_;
				PDFWriter* _tmp34_;
				guint _tmp35_;
				guint* _tmp36_;
				gint _tmp36__length1;
				gint _tmp37_;
				PDFWriter* _tmp38_;
				guint _tmp39_;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp23_) {
#line 2330 "book.c"
					gint _tmp24_;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
					_tmp24_ = i;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp24_ + 1;
#line 2336 "book.c"
				}
#line 275 "/home/bob/git/simple-scan/src/book.vala"
				_tmp23_ = FALSE;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
				_tmp25_ = i;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
				_tmp26_ = book_get_n_pages (self);
#line 275 "/home/bob/git/simple-scan/src/book.vala"
				_tmp27_ = _tmp26_;
#line 275 "/home/bob/git/simple-scan/src/book.vala"
				if (!(((guint) _tmp25_) < _tmp27_)) {
#line 275 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 2350 "book.c"
				}
#line 277 "/home/bob/git/simple-scan/src/book.vala"
				_tmp28_ = page_numbers;
#line 277 "/home/bob/git/simple-scan/src/book.vala"
				_tmp28__length1 = page_numbers_length1;
#line 277 "/home/bob/git/simple-scan/src/book.vala"
				_tmp29_ = i;
#line 277 "/home/bob/git/simple-scan/src/book.vala"
				_tmp30_ = writer;
#line 277 "/home/bob/git/simple-scan/src/book.vala"
				_tmp28_[_tmp29_] = pdf_writer_add_object (_tmp30_);
#line 277 "/home/bob/git/simple-scan/src/book.vala"
				_tmp31_ = _tmp28_[_tmp29_];
#line 278 "/home/bob/git/simple-scan/src/book.vala"
				_tmp32_ = page_image_numbers;
#line 278 "/home/bob/git/simple-scan/src/book.vala"
				_tmp32__length1 = page_image_numbers_length1;
#line 278 "/home/bob/git/simple-scan/src/book.vala"
				_tmp33_ = i;
#line 278 "/home/bob/git/simple-scan/src/book.vala"
				_tmp34_ = writer;
#line 278 "/home/bob/git/simple-scan/src/book.vala"
				_tmp32_[_tmp33_] = pdf_writer_add_object (_tmp34_);
#line 278 "/home/bob/git/simple-scan/src/book.vala"
				_tmp35_ = _tmp32_[_tmp33_];
#line 279 "/home/bob/git/simple-scan/src/book.vala"
				_tmp36_ = page_content_numbers;
#line 279 "/home/bob/git/simple-scan/src/book.vala"
				_tmp36__length1 = page_content_numbers_length1;
#line 279 "/home/bob/git/simple-scan/src/book.vala"
				_tmp37_ = i;
#line 279 "/home/bob/git/simple-scan/src/book.vala"
				_tmp38_ = writer;
#line 279 "/home/bob/git/simple-scan/src/book.vala"
				_tmp36_[_tmp37_] = pdf_writer_add_object (_tmp38_);
#line 279 "/home/bob/git/simple-scan/src/book.vala"
				_tmp39_ = _tmp36_[_tmp37_];
#line 2388 "book.c"
			}
		}
	}
#line 281 "/home/bob/git/simple-scan/src/book.vala"
	_tmp40_ = writer;
#line 281 "/home/bob/git/simple-scan/src/book.vala"
	struct_tree_root_number = pdf_writer_add_object (_tmp40_);
#line 284 "/home/bob/git/simple-scan/src/book.vala"
	_tmp41_ = writer;
#line 284 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp41_, "%PDF-1.3\n");
#line 287 "/home/bob/git/simple-scan/src/book.vala"
	_tmp42_ = writer;
#line 287 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp42_, "%\xe2\xe3\xcf\xd3\n");
#line 290 "/home/bob/git/simple-scan/src/book.vala"
	_tmp43_ = writer;
#line 290 "/home/bob/git/simple-scan/src/book.vala"
	_tmp44_ = catalog_number;
#line 290 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_start_object (_tmp43_, _tmp44_);
#line 291 "/home/bob/git/simple-scan/src/book.vala"
	_tmp45_ = writer;
#line 291 "/home/bob/git/simple-scan/src/book.vala"
	_tmp46_ = catalog_number;
#line 291 "/home/bob/git/simple-scan/src/book.vala"
	_tmp47_ = g_strdup_printf ("%u 0 obj\n", _tmp46_);
#line 291 "/home/bob/git/simple-scan/src/book.vala"
	_tmp48_ = _tmp47_;
#line 291 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp45_, _tmp48_);
#line 291 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp48_);
#line 292 "/home/bob/git/simple-scan/src/book.vala"
	_tmp49_ = writer;
#line 292 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp49_, "<<\n");
#line 293 "/home/bob/git/simple-scan/src/book.vala"
	_tmp50_ = writer;
#line 293 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp50_, "/Type /Catalog\n");
#line 294 "/home/bob/git/simple-scan/src/book.vala"
	_tmp51_ = writer;
#line 294 "/home/bob/git/simple-scan/src/book.vala"
	_tmp52_ = metadata_number;
#line 294 "/home/bob/git/simple-scan/src/book.vala"
	_tmp53_ = g_strdup_printf ("/Metadata %u 0 R\n", _tmp52_);
#line 294 "/home/bob/git/simple-scan/src/book.vala"
	_tmp54_ = _tmp53_;
#line 294 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp51_, _tmp54_);
#line 294 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp54_);
#line 295 "/home/bob/git/simple-scan/src/book.vala"
	_tmp55_ = writer;
#line 295 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp55_, "/MarkInfo << /Marked true >>\n");
#line 296 "/home/bob/git/simple-scan/src/book.vala"
	_tmp56_ = writer;
#line 296 "/home/bob/git/simple-scan/src/book.vala"
	_tmp57_ = struct_tree_root_number;
#line 296 "/home/bob/git/simple-scan/src/book.vala"
	_tmp58_ = g_strdup_printf ("/StructTreeRoot %u 0 R\n", _tmp57_);
#line 296 "/home/bob/git/simple-scan/src/book.vala"
	_tmp59_ = _tmp58_;
#line 296 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp56_, _tmp59_);
#line 296 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp59_);
#line 297 "/home/bob/git/simple-scan/src/book.vala"
	_tmp60_ = writer;
#line 297 "/home/bob/git/simple-scan/src/book.vala"
	_tmp61_ = pages_number;
#line 297 "/home/bob/git/simple-scan/src/book.vala"
	_tmp62_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp61_);
#line 297 "/home/bob/git/simple-scan/src/book.vala"
	_tmp63_ = _tmp62_;
#line 297 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp60_, _tmp63_);
#line 297 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp63_);
#line 298 "/home/bob/git/simple-scan/src/book.vala"
	_tmp64_ = writer;
#line 298 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp64_, ">>\n");
#line 299 "/home/bob/git/simple-scan/src/book.vala"
	_tmp65_ = writer;
#line 299 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp65_, "endobj\n");
#line 302 "/home/bob/git/simple-scan/src/book.vala"
	_tmp66_ = g_date_time_new_now_local ();
#line 302 "/home/bob/git/simple-scan/src/book.vala"
	now = _tmp66_;
#line 303 "/home/bob/git/simple-scan/src/book.vala"
	_tmp67_ = now;
#line 303 "/home/bob/git/simple-scan/src/book.vala"
	_tmp68_ = g_date_time_format (_tmp67_, "%FT%H:%M:%S%:z");
#line 303 "/home/bob/git/simple-scan/src/book.vala"
	date_string = _tmp68_;
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	_tmp69_ = g_unichar_to_string ((gunichar) 0xFEFF);
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	_tmp70_ = _tmp69_;
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	_tmp71_ = date_string;
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	_tmp72_ = date_string;
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	_tmp73_ = date_string;
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	_tmp74_ = g_strdup_printf ("<?xpacket begin=\"%s\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n" \
"<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n" \
"         xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n" \
"  <rdf:Description rdf:about=\"\"\n" \
"                   xmlns:pdfaid=\"http://www.aiim.org/pdfa/ns/id/\"\n" \
"                   xmlns:xmp=\"http://ns.adobe.com/xap/1.0/\">\n" \
"    <pdfaid:part>1</pdfaid:part>\n" \
"    <pdfaid:conformance>A</pdfaid:conformance>\n" \
"    <xmp:CreatorTool>Simple Scan %s</xmp:CreatorTool>\n" \
"    <xmp:CreateDate>%s</xmp:CreateDate>\n" \
"    <xmp:ModifyDate>%s</xmp:ModifyDate>\n" \
"    <xmp:MetadataDate>%s</xmp:MetadataDate>\n" \
"  </rdf:Description>\n" \
"</rdf:RDF>\n" \
"<?xpacket end=\"w\"?>", _tmp70_, VERSION, _tmp71_, _tmp72_, _tmp73_);
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	_tmp75_ = _tmp74_;
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp70_);
#line 305 "/home/bob/git/simple-scan/src/book.vala"
	metadata = _tmp75_;
#line 320 "/home/bob/git/simple-scan/src/book.vala"
	_tmp76_ = writer;
#line 320 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp76_, "\n");
#line 321 "/home/bob/git/simple-scan/src/book.vala"
	_tmp77_ = writer;
#line 321 "/home/bob/git/simple-scan/src/book.vala"
	_tmp78_ = metadata_number;
#line 321 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_start_object (_tmp77_, _tmp78_);
#line 322 "/home/bob/git/simple-scan/src/book.vala"
	_tmp79_ = writer;
#line 322 "/home/bob/git/simple-scan/src/book.vala"
	_tmp80_ = metadata_number;
#line 322 "/home/bob/git/simple-scan/src/book.vala"
	_tmp81_ = g_strdup_printf ("%u 0 obj\n", _tmp80_);
#line 322 "/home/bob/git/simple-scan/src/book.vala"
	_tmp82_ = _tmp81_;
#line 322 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp79_, _tmp82_);
#line 322 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp82_);
#line 323 "/home/bob/git/simple-scan/src/book.vala"
	_tmp83_ = writer;
#line 323 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp83_, "<<\n");
#line 324 "/home/bob/git/simple-scan/src/book.vala"
	_tmp84_ = writer;
#line 324 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp84_, "/Type /Metadata\n");
#line 325 "/home/bob/git/simple-scan/src/book.vala"
	_tmp85_ = writer;
#line 325 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp85_, "/Subtype /XML\n");
#line 326 "/home/bob/git/simple-scan/src/book.vala"
	_tmp86_ = writer;
#line 326 "/home/bob/git/simple-scan/src/book.vala"
	_tmp87_ = metadata;
#line 326 "/home/bob/git/simple-scan/src/book.vala"
	_tmp88_ = strlen (_tmp87_);
#line 326 "/home/bob/git/simple-scan/src/book.vala"
	_tmp89_ = _tmp88_;
#line 326 "/home/bob/git/simple-scan/src/book.vala"
	_tmp90_ = g_strdup_printf ("/Length %u\n", (guint) _tmp89_);
#line 326 "/home/bob/git/simple-scan/src/book.vala"
	_tmp91_ = _tmp90_;
#line 326 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp86_, _tmp91_);
#line 326 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp91_);
#line 327 "/home/bob/git/simple-scan/src/book.vala"
	_tmp92_ = writer;
#line 327 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp92_, ">>\n");
#line 328 "/home/bob/git/simple-scan/src/book.vala"
	_tmp93_ = writer;
#line 328 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp93_, "stream\n");
#line 329 "/home/bob/git/simple-scan/src/book.vala"
	_tmp94_ = writer;
#line 329 "/home/bob/git/simple-scan/src/book.vala"
	_tmp95_ = metadata;
#line 329 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp94_, _tmp95_);
#line 330 "/home/bob/git/simple-scan/src/book.vala"
	_tmp96_ = writer;
#line 330 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp96_, "\n");
#line 331 "/home/bob/git/simple-scan/src/book.vala"
	_tmp97_ = writer;
#line 331 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp97_, "endstream\n");
#line 332 "/home/bob/git/simple-scan/src/book.vala"
	_tmp98_ = writer;
#line 332 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp98_, "endobj\n");
#line 335 "/home/bob/git/simple-scan/src/book.vala"
	_tmp99_ = writer;
#line 335 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp99_, "\n");
#line 336 "/home/bob/git/simple-scan/src/book.vala"
	_tmp100_ = writer;
#line 336 "/home/bob/git/simple-scan/src/book.vala"
	_tmp101_ = pages_number;
#line 336 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_start_object (_tmp100_, _tmp101_);
#line 337 "/home/bob/git/simple-scan/src/book.vala"
	_tmp102_ = writer;
#line 337 "/home/bob/git/simple-scan/src/book.vala"
	_tmp103_ = pages_number;
#line 337 "/home/bob/git/simple-scan/src/book.vala"
	_tmp104_ = g_strdup_printf ("%u 0 obj\n", _tmp103_);
#line 337 "/home/bob/git/simple-scan/src/book.vala"
	_tmp105_ = _tmp104_;
#line 337 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp102_, _tmp105_);
#line 337 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp105_);
#line 338 "/home/bob/git/simple-scan/src/book.vala"
	_tmp106_ = writer;
#line 338 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp106_, "<<\n");
#line 339 "/home/bob/git/simple-scan/src/book.vala"
	_tmp107_ = writer;
#line 339 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp107_, "/Type /Pages\n");
#line 340 "/home/bob/git/simple-scan/src/book.vala"
	_tmp108_ = writer;
#line 340 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp108_, "/Kids [");
#line 2616 "book.c"
	{
		gint i = 0;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 2621 "book.c"
		{
			gboolean _tmp109_ = FALSE;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
			_tmp109_ = TRUE;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 2628 "book.c"
				gint _tmp111_;
				guint _tmp112_;
				guint _tmp113_;
				PDFWriter* _tmp114_;
				guint* _tmp115_;
				gint _tmp115__length1;
				gint _tmp116_;
				guint _tmp117_;
				gchar* _tmp118_;
				gchar* _tmp119_;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp109_) {
#line 2641 "book.c"
					gint _tmp110_;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
					_tmp110_ = i;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp110_ + 1;
#line 2647 "book.c"
				}
#line 341 "/home/bob/git/simple-scan/src/book.vala"
				_tmp109_ = FALSE;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
				_tmp111_ = i;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
				_tmp112_ = book_get_n_pages (self);
#line 341 "/home/bob/git/simple-scan/src/book.vala"
				_tmp113_ = _tmp112_;
#line 341 "/home/bob/git/simple-scan/src/book.vala"
				if (!(((guint) _tmp111_) < _tmp113_)) {
#line 341 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 2661 "book.c"
				}
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				_tmp114_ = writer;
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				_tmp115_ = page_numbers;
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				_tmp115__length1 = page_numbers_length1;
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				_tmp116_ = i;
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				_tmp117_ = _tmp115_[_tmp116_];
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				_tmp118_ = g_strdup_printf (" %u 0 R", _tmp117_);
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				_tmp119_ = _tmp118_;
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp114_, _tmp119_);
#line 342 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp119_);
#line 2681 "book.c"
			}
		}
	}
#line 343 "/home/bob/git/simple-scan/src/book.vala"
	_tmp120_ = writer;
#line 343 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp120_, " ]\n");
#line 344 "/home/bob/git/simple-scan/src/book.vala"
	_tmp121_ = writer;
#line 344 "/home/bob/git/simple-scan/src/book.vala"
	_tmp122_ = book_get_n_pages (self);
#line 344 "/home/bob/git/simple-scan/src/book.vala"
	_tmp123_ = _tmp122_;
#line 344 "/home/bob/git/simple-scan/src/book.vala"
	_tmp124_ = g_strdup_printf ("/Count %u\n", _tmp123_);
#line 344 "/home/bob/git/simple-scan/src/book.vala"
	_tmp125_ = _tmp124_;
#line 344 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp121_, _tmp125_);
#line 344 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp125_);
#line 345 "/home/bob/git/simple-scan/src/book.vala"
	_tmp126_ = writer;
#line 345 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp126_, ">>\n");
#line 346 "/home/bob/git/simple-scan/src/book.vala"
	_tmp127_ = writer;
#line 346 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp127_, "endobj\n");
#line 2711 "book.c"
	{
		gint i = 0;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 2716 "book.c"
		{
			gboolean _tmp128_ = FALSE;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
			_tmp128_ = TRUE;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 2723 "book.c"
				gint _tmp130_;
				guint _tmp131_;
				guint _tmp132_;
				Page* page = NULL;
				gint _tmp133_;
				Page* _tmp134_;
				GdkPixbuf* image = NULL;
				Page* _tmp135_;
				GdkPixbuf* _tmp136_;
				gint width = 0;
				GdkPixbuf* _tmp137_;
				gint _tmp138_;
				gint _tmp139_;
				gint height = 0;
				GdkPixbuf* _tmp140_;
				gint _tmp141_;
				gint _tmp142_;
				guint8* pixels = NULL;
				GdkPixbuf* _tmp143_;
				guint8* _tmp144_;
				gint pixels_length1;
				gint _pixels_size_;
				gdouble page_width = 0.0;
				gint _tmp145_;
				Page* _tmp146_;
				gint _tmp147_;
				gint _tmp148_;
				gdouble page_height = 0.0;
				gint _tmp149_;
				Page* _tmp150_;
				gint _tmp151_;
				gint _tmp152_;
				gint depth = 0;
				gchar* color_space = NULL;
				gchar* _tmp153_;
				gchar* filter = NULL;
				gchar* width_buffer = NULL;
				gchar* _tmp154_;
				gint width_buffer_length1;
				gint _width_buffer_size_;
				gchar* height_buffer = NULL;
				gchar* _tmp155_;
				gint height_buffer_length1;
				gint _height_buffer_size_;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp156_;
				gboolean _tmp157_;
				gboolean _tmp158_;
				guint8* compressed_data = NULL;
				guint8* _tmp312_;
				gint _tmp312__length1;
				gint _tmp313_;
				guint8* _tmp314_;
				gint compressed_data_length1;
				gint _compressed_data_size_;
				guint8* _tmp315_;
				gint _tmp315__length1;
				PDFWriter* _tmp332_;
				PDFWriter* _tmp333_;
				guint* _tmp334_;
				gint _tmp334__length1;
				gint _tmp335_;
				guint _tmp336_;
				PDFWriter* _tmp337_;
				guint* _tmp338_;
				gint _tmp338__length1;
				gint _tmp339_;
				guint _tmp340_;
				gchar* _tmp341_;
				gchar* _tmp342_;
				PDFWriter* _tmp343_;
				PDFWriter* _tmp344_;
				PDFWriter* _tmp345_;
				guint _tmp346_;
				gchar* _tmp347_;
				gchar* _tmp348_;
				PDFWriter* _tmp349_;
				gint _tmp350_;
				guint* _tmp351_;
				gint _tmp351__length1;
				gint _tmp352_;
				guint _tmp353_;
				gchar* _tmp354_;
				gchar* _tmp355_;
				PDFWriter* _tmp356_;
				gdouble _tmp357_;
				gchar* _tmp358_;
				gint _tmp358__length1;
				const gchar* _tmp359_;
				gdouble _tmp360_;
				gchar* _tmp361_;
				gint _tmp361__length1;
				const gchar* _tmp362_;
				gchar* _tmp363_;
				gchar* _tmp364_;
				PDFWriter* _tmp365_;
				guint* _tmp366_;
				gint _tmp366__length1;
				gint _tmp367_;
				guint _tmp368_;
				gchar* _tmp369_;
				gchar* _tmp370_;
				PDFWriter* _tmp371_;
				PDFWriter* _tmp372_;
				PDFWriter* _tmp373_;
				PDFWriter* _tmp374_;
				guint* _tmp375_;
				gint _tmp375__length1;
				gint _tmp376_;
				guint _tmp377_;
				PDFWriter* _tmp378_;
				guint* _tmp379_;
				gint _tmp379__length1;
				gint _tmp380_;
				guint _tmp381_;
				gchar* _tmp382_;
				gchar* _tmp383_;
				PDFWriter* _tmp384_;
				PDFWriter* _tmp385_;
				PDFWriter* _tmp386_;
				PDFWriter* _tmp387_;
				gint _tmp388_;
				gchar* _tmp389_;
				gchar* _tmp390_;
				PDFWriter* _tmp391_;
				gint _tmp392_;
				gchar* _tmp393_;
				gchar* _tmp394_;
				PDFWriter* _tmp395_;
				const gchar* _tmp396_;
				gchar* _tmp397_;
				gchar* _tmp398_;
				PDFWriter* _tmp399_;
				gint _tmp400_;
				gchar* _tmp401_;
				gchar* _tmp402_;
				PDFWriter* _tmp403_;
				guint8* _tmp404_;
				gint _tmp404__length1;
				gchar* _tmp405_;
				gchar* _tmp406_;
				const gchar* _tmp407_;
				PDFWriter* _tmp412_;
				PDFWriter* _tmp413_;
				PDFWriter* _tmp414_;
				guint8* _tmp415_;
				gint _tmp415__length1;
				PDFWriter* _tmp416_;
				PDFWriter* _tmp417_;
				PDFWriter* _tmp418_;
				PDFWriter* _tmp419_;
				PDFWriter* _tmp420_;
				guint _tmp421_;
				PDFWriter* _tmp422_;
				guint _tmp423_;
				gchar* _tmp424_;
				gchar* _tmp425_;
				PDFWriter* _tmp426_;
				PDFWriter* _tmp427_;
				PDFWriter* _tmp428_;
				PDFWriter* _tmp429_;
				gchar* command = NULL;
				gdouble _tmp430_;
				gchar* _tmp431_;
				gint _tmp431__length1;
				const gchar* _tmp432_;
				gdouble _tmp433_;
				gchar* _tmp434_;
				gint _tmp434__length1;
				const gchar* _tmp435_;
				gint _tmp436_;
				gchar* _tmp437_;
				PDFWriter* _tmp438_;
				PDFWriter* _tmp439_;
				guint* _tmp440_;
				gint _tmp440__length1;
				gint _tmp441_;
				guint _tmp442_;
				PDFWriter* _tmp443_;
				guint* _tmp444_;
				gint _tmp444__length1;
				gint _tmp445_;
				guint _tmp446_;
				gchar* _tmp447_;
				gchar* _tmp448_;
				PDFWriter* _tmp449_;
				PDFWriter* _tmp450_;
				const gchar* _tmp451_;
				gint _tmp452_;
				gint _tmp453_;
				gchar* _tmp454_;
				gchar* _tmp455_;
				PDFWriter* _tmp456_;
				PDFWriter* _tmp457_;
				PDFWriter* _tmp458_;
				const gchar* _tmp459_;
				PDFWriter* _tmp460_;
				PDFWriter* _tmp461_;
				PDFWriter* _tmp462_;
				gint _tmp463_;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp128_) {
#line 2928 "book.c"
					gint _tmp129_;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
					_tmp129_ = i;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp129_ + 1;
#line 2934 "book.c"
				}
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_tmp128_ = FALSE;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_tmp130_ = i;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_tmp131_ = book_get_n_pages (self);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_tmp132_ = _tmp131_;
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				if (!(((guint) _tmp130_) < _tmp132_)) {
#line 348 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 2948 "book.c"
				}
#line 350 "/home/bob/git/simple-scan/src/book.vala"
				_tmp133_ = i;
#line 350 "/home/bob/git/simple-scan/src/book.vala"
				_tmp134_ = book_get_page (self, _tmp133_);
#line 350 "/home/bob/git/simple-scan/src/book.vala"
				page = _tmp134_;
#line 351 "/home/bob/git/simple-scan/src/book.vala"
				_tmp135_ = page;
#line 351 "/home/bob/git/simple-scan/src/book.vala"
				_tmp136_ = page_get_image (_tmp135_, TRUE);
#line 351 "/home/bob/git/simple-scan/src/book.vala"
				image = _tmp136_;
#line 352 "/home/bob/git/simple-scan/src/book.vala"
				_tmp137_ = image;
#line 352 "/home/bob/git/simple-scan/src/book.vala"
				_tmp138_ = gdk_pixbuf_get_width (_tmp137_);
#line 352 "/home/bob/git/simple-scan/src/book.vala"
				_tmp139_ = _tmp138_;
#line 352 "/home/bob/git/simple-scan/src/book.vala"
				width = _tmp139_;
#line 353 "/home/bob/git/simple-scan/src/book.vala"
				_tmp140_ = image;
#line 353 "/home/bob/git/simple-scan/src/book.vala"
				_tmp141_ = gdk_pixbuf_get_height (_tmp140_);
#line 353 "/home/bob/git/simple-scan/src/book.vala"
				_tmp142_ = _tmp141_;
#line 353 "/home/bob/git/simple-scan/src/book.vala"
				height = _tmp142_;
#line 354 "/home/bob/git/simple-scan/src/book.vala"
				_tmp143_ = image;
#line 354 "/home/bob/git/simple-scan/src/book.vala"
				_tmp144_ = gdk_pixbuf_get_pixels (_tmp143_);
#line 354 "/home/bob/git/simple-scan/src/book.vala"
				pixels = _tmp144_;
#line 354 "/home/bob/git/simple-scan/src/book.vala"
				pixels_length1 = -1;
#line 354 "/home/bob/git/simple-scan/src/book.vala"
				_pixels_size_ = pixels_length1;
#line 355 "/home/bob/git/simple-scan/src/book.vala"
				_tmp145_ = width;
#line 355 "/home/bob/git/simple-scan/src/book.vala"
				_tmp146_ = page;
#line 355 "/home/bob/git/simple-scan/src/book.vala"
				_tmp147_ = page_get_dpi (_tmp146_);
#line 355 "/home/bob/git/simple-scan/src/book.vala"
				_tmp148_ = _tmp147_;
#line 355 "/home/bob/git/simple-scan/src/book.vala"
				page_width = (_tmp145_ * 72.0) / _tmp148_;
#line 356 "/home/bob/git/simple-scan/src/book.vala"
				_tmp149_ = height;
#line 356 "/home/bob/git/simple-scan/src/book.vala"
				_tmp150_ = page;
#line 356 "/home/bob/git/simple-scan/src/book.vala"
				_tmp151_ = page_get_dpi (_tmp150_);
#line 356 "/home/bob/git/simple-scan/src/book.vala"
				_tmp152_ = _tmp151_;
#line 356 "/home/bob/git/simple-scan/src/book.vala"
				page_height = (_tmp149_ * 72.0) / _tmp152_;
#line 358 "/home/bob/git/simple-scan/src/book.vala"
				depth = 8;
#line 359 "/home/bob/git/simple-scan/src/book.vala"
				_tmp153_ = g_strdup ("DeviceRGB");
#line 359 "/home/bob/git/simple-scan/src/book.vala"
				color_space = _tmp153_;
#line 360 "/home/bob/git/simple-scan/src/book.vala"
				filter = NULL;
#line 361 "/home/bob/git/simple-scan/src/book.vala"
				_tmp154_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 361 "/home/bob/git/simple-scan/src/book.vala"
				width_buffer = _tmp154_;
#line 361 "/home/bob/git/simple-scan/src/book.vala"
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 361 "/home/bob/git/simple-scan/src/book.vala"
				_width_buffer_size_ = width_buffer_length1;
#line 362 "/home/bob/git/simple-scan/src/book.vala"
				_tmp155_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 362 "/home/bob/git/simple-scan/src/book.vala"
				height_buffer = _tmp155_;
#line 362 "/home/bob/git/simple-scan/src/book.vala"
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 362 "/home/bob/git/simple-scan/src/book.vala"
				_height_buffer_size_ = height_buffer_length1;
#line 364 "/home/bob/git/simple-scan/src/book.vala"
				_tmp156_ = page;
#line 364 "/home/bob/git/simple-scan/src/book.vala"
				_tmp157_ = page_get_is_color (_tmp156_);
#line 364 "/home/bob/git/simple-scan/src/book.vala"
				_tmp158_ = _tmp157_;
#line 364 "/home/bob/git/simple-scan/src/book.vala"
				if (_tmp158_) {
#line 3040 "book.c"
					gchar* _tmp159_;
					gint data_length = 0;
					gint _tmp160_;
					gint _tmp161_;
					gint _tmp162_;
					guint8* _tmp163_;
#line 366 "/home/bob/git/simple-scan/src/book.vala"
					depth = 8;
#line 367 "/home/bob/git/simple-scan/src/book.vala"
					_tmp159_ = g_strdup ("DeviceRGB");
#line 367 "/home/bob/git/simple-scan/src/book.vala"
					_g_free0 (color_space);
#line 367 "/home/bob/git/simple-scan/src/book.vala"
					color_space = _tmp159_;
#line 368 "/home/bob/git/simple-scan/src/book.vala"
					_tmp160_ = height;
#line 368 "/home/bob/git/simple-scan/src/book.vala"
					_tmp161_ = width;
#line 368 "/home/bob/git/simple-scan/src/book.vala"
					data_length = (_tmp160_ * _tmp161_) * 3;
#line 369 "/home/bob/git/simple-scan/src/book.vala"
					_tmp162_ = data_length;
#line 369 "/home/bob/git/simple-scan/src/book.vala"
					_tmp163_ = g_new0 (guint8, _tmp162_);
#line 369 "/home/bob/git/simple-scan/src/book.vala"
					data = (g_free (data), NULL);
#line 369 "/home/bob/git/simple-scan/src/book.vala"
					data = _tmp163_;
#line 369 "/home/bob/git/simple-scan/src/book.vala"
					data_length1 = _tmp162_;
#line 369 "/home/bob/git/simple-scan/src/book.vala"
					_data_size_ = data_length1;
#line 3073 "book.c"
					{
						gint row = 0;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
						row = 0;
#line 3078 "book.c"
						{
							gboolean _tmp164_ = FALSE;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
							_tmp164_ = TRUE;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
							while (TRUE) {
#line 3085 "book.c"
								gint _tmp166_;
								gint _tmp167_;
								gint in_offset = 0;
								gint _tmp168_;
								GdkPixbuf* _tmp169_;
								gint _tmp170_;
								gint _tmp171_;
								gint out_offset = 0;
								gint _tmp172_;
								gint _tmp173_;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
								if (!_tmp164_) {
#line 3098 "book.c"
									gint _tmp165_;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
									_tmp165_ = row;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
									row = _tmp165_ + 1;
#line 3104 "book.c"
								}
#line 370 "/home/bob/git/simple-scan/src/book.vala"
								_tmp164_ = FALSE;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
								_tmp166_ = row;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
								_tmp167_ = height;
#line 370 "/home/bob/git/simple-scan/src/book.vala"
								if (!(_tmp166_ < _tmp167_)) {
#line 370 "/home/bob/git/simple-scan/src/book.vala"
									break;
#line 3116 "book.c"
								}
#line 372 "/home/bob/git/simple-scan/src/book.vala"
								_tmp168_ = row;
#line 372 "/home/bob/git/simple-scan/src/book.vala"
								_tmp169_ = image;
#line 372 "/home/bob/git/simple-scan/src/book.vala"
								_tmp170_ = gdk_pixbuf_get_rowstride (_tmp169_);
#line 372 "/home/bob/git/simple-scan/src/book.vala"
								_tmp171_ = _tmp170_;
#line 372 "/home/bob/git/simple-scan/src/book.vala"
								in_offset = _tmp168_ * _tmp171_;
#line 373 "/home/bob/git/simple-scan/src/book.vala"
								_tmp172_ = row;
#line 373 "/home/bob/git/simple-scan/src/book.vala"
								_tmp173_ = width;
#line 373 "/home/bob/git/simple-scan/src/book.vala"
								out_offset = (_tmp172_ * _tmp173_) * 3;
#line 3134 "book.c"
								{
									gint x = 0;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
									x = 0;
#line 3139 "book.c"
									{
										gboolean _tmp174_ = FALSE;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
										_tmp174_ = TRUE;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
										while (TRUE) {
#line 3146 "book.c"
											gint _tmp176_;
											gint _tmp177_;
											gint in_o = 0;
											gint _tmp178_;
											gint _tmp179_;
											gint out_o = 0;
											gint _tmp180_;
											gint _tmp181_;
											guint8* _tmp182_;
											gint _tmp182__length1;
											gint _tmp183_;
											guint8* _tmp184_;
											gint _tmp184__length1;
											gint _tmp185_;
											guint8 _tmp186_;
											guint8 _tmp187_;
											guint8* _tmp188_;
											gint _tmp188__length1;
											gint _tmp189_;
											guint8* _tmp190_;
											gint _tmp190__length1;
											gint _tmp191_;
											guint8 _tmp192_;
											guint8 _tmp193_;
											guint8* _tmp194_;
											gint _tmp194__length1;
											gint _tmp195_;
											guint8* _tmp196_;
											gint _tmp196__length1;
											gint _tmp197_;
											guint8 _tmp198_;
											guint8 _tmp199_;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
											if (!_tmp174_) {
#line 3181 "book.c"
												gint _tmp175_;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
												_tmp175_ = x;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
												x = _tmp175_ + 1;
#line 3187 "book.c"
											}
#line 374 "/home/bob/git/simple-scan/src/book.vala"
											_tmp174_ = FALSE;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
											_tmp176_ = x;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
											_tmp177_ = width;
#line 374 "/home/bob/git/simple-scan/src/book.vala"
											if (!(_tmp176_ < _tmp177_)) {
#line 374 "/home/bob/git/simple-scan/src/book.vala"
												break;
#line 3199 "book.c"
											}
#line 376 "/home/bob/git/simple-scan/src/book.vala"
											_tmp178_ = in_offset;
#line 376 "/home/bob/git/simple-scan/src/book.vala"
											_tmp179_ = x;
#line 376 "/home/bob/git/simple-scan/src/book.vala"
											in_o = _tmp178_ + (_tmp179_ * 3);
#line 377 "/home/bob/git/simple-scan/src/book.vala"
											_tmp180_ = out_offset;
#line 377 "/home/bob/git/simple-scan/src/book.vala"
											_tmp181_ = x;
#line 377 "/home/bob/git/simple-scan/src/book.vala"
											out_o = _tmp180_ + (_tmp181_ * 3);
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp182_ = data;
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp182__length1 = data_length1;
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp183_ = out_o;
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp184_ = pixels;
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp184__length1 = pixels_length1;
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp185_ = in_o;
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp186_ = _tmp184_[_tmp185_];
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp182_[_tmp183_] = _tmp186_;
#line 379 "/home/bob/git/simple-scan/src/book.vala"
											_tmp187_ = _tmp182_[_tmp183_];
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp188_ = data;
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp188__length1 = data_length1;
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp189_ = out_o;
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp190_ = pixels;
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp190__length1 = pixels_length1;
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp191_ = in_o;
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp192_ = _tmp190_[_tmp191_ + 1];
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp188_[_tmp189_ + 1] = _tmp192_;
#line 380 "/home/bob/git/simple-scan/src/book.vala"
											_tmp193_ = _tmp188_[_tmp189_ + 1];
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp194_ = data;
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp194__length1 = data_length1;
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp195_ = out_o;
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp196_ = pixels;
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp196__length1 = pixels_length1;
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp197_ = in_o;
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp198_ = _tmp196_[_tmp197_ + 2];
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp194_[_tmp195_ + 2] = _tmp198_;
#line 381 "/home/bob/git/simple-scan/src/book.vala"
											_tmp199_ = _tmp194_[_tmp195_ + 2];
#line 3267 "book.c"
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp200_;
					gint _tmp201_;
					gint _tmp202_;
#line 385 "/home/bob/git/simple-scan/src/book.vala"
					_tmp200_ = page;
#line 385 "/home/bob/git/simple-scan/src/book.vala"
					_tmp201_ = page_get_depth (_tmp200_);
#line 385 "/home/bob/git/simple-scan/src/book.vala"
					_tmp202_ = _tmp201_;
#line 385 "/home/bob/git/simple-scan/src/book.vala"
					if (_tmp202_ == 2) {
#line 3286 "book.c"
						gint shift_count = 0;
						gchar* _tmp203_;
						gint data_length = 0;
						gint _tmp204_;
						gint _tmp205_;
						gint _tmp206_;
						guint8* _tmp207_;
						gint offset = 0;
#line 387 "/home/bob/git/simple-scan/src/book.vala"
						shift_count = 6;
#line 388 "/home/bob/git/simple-scan/src/book.vala"
						depth = 2;
#line 389 "/home/bob/git/simple-scan/src/book.vala"
						_tmp203_ = g_strdup ("DeviceGray");
#line 389 "/home/bob/git/simple-scan/src/book.vala"
						_g_free0 (color_space);
#line 389 "/home/bob/git/simple-scan/src/book.vala"
						color_space = _tmp203_;
#line 390 "/home/bob/git/simple-scan/src/book.vala"
						_tmp204_ = height;
#line 390 "/home/bob/git/simple-scan/src/book.vala"
						_tmp205_ = width;
#line 390 "/home/bob/git/simple-scan/src/book.vala"
						data_length = _tmp204_ * (((_tmp205_ * 2) + 7) / 8);
#line 391 "/home/bob/git/simple-scan/src/book.vala"
						_tmp206_ = data_length;
#line 391 "/home/bob/git/simple-scan/src/book.vala"
						_tmp207_ = g_new0 (guint8, _tmp206_);
#line 391 "/home/bob/git/simple-scan/src/book.vala"
						data = (g_free (data), NULL);
#line 391 "/home/bob/git/simple-scan/src/book.vala"
						data = _tmp207_;
#line 391 "/home/bob/git/simple-scan/src/book.vala"
						data_length1 = _tmp206_;
#line 391 "/home/bob/git/simple-scan/src/book.vala"
						_data_size_ = data_length1;
#line 392 "/home/bob/git/simple-scan/src/book.vala"
						offset = 0;
#line 3325 "book.c"
						{
							gint row = 0;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
							row = 0;
#line 3330 "book.c"
							{
								gboolean _tmp208_ = FALSE;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
								_tmp208_ = TRUE;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
								while (TRUE) {
#line 3337 "book.c"
									gint _tmp210_;
									gint _tmp211_;
									gint _tmp212_;
									gint in_offset = 0;
									gint _tmp214_;
									GdkPixbuf* _tmp215_;
									gint _tmp216_;
									gint _tmp217_;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
									if (!_tmp208_) {
#line 3348 "book.c"
										gint _tmp209_;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
										_tmp209_ = row;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
										row = _tmp209_ + 1;
#line 3354 "book.c"
									}
#line 393 "/home/bob/git/simple-scan/src/book.vala"
									_tmp208_ = FALSE;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
									_tmp210_ = row;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
									_tmp211_ = height;
#line 393 "/home/bob/git/simple-scan/src/book.vala"
									if (!(_tmp210_ < _tmp211_)) {
#line 393 "/home/bob/git/simple-scan/src/book.vala"
										break;
#line 3366 "book.c"
									}
#line 396 "/home/bob/git/simple-scan/src/book.vala"
									_tmp212_ = shift_count;
#line 396 "/home/bob/git/simple-scan/src/book.vala"
									if (_tmp212_ != 6) {
#line 3372 "book.c"
										gint _tmp213_;
#line 398 "/home/bob/git/simple-scan/src/book.vala"
										_tmp213_ = offset;
#line 398 "/home/bob/git/simple-scan/src/book.vala"
										offset = _tmp213_ + 1;
#line 399 "/home/bob/git/simple-scan/src/book.vala"
										shift_count = 6;
#line 3380 "book.c"
									}
#line 402 "/home/bob/git/simple-scan/src/book.vala"
									_tmp214_ = row;
#line 402 "/home/bob/git/simple-scan/src/book.vala"
									_tmp215_ = image;
#line 402 "/home/bob/git/simple-scan/src/book.vala"
									_tmp216_ = gdk_pixbuf_get_rowstride (_tmp215_);
#line 402 "/home/bob/git/simple-scan/src/book.vala"
									_tmp217_ = _tmp216_;
#line 402 "/home/bob/git/simple-scan/src/book.vala"
									in_offset = _tmp214_ * _tmp217_;
#line 3392 "book.c"
									{
										gint x = 0;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
										x = 0;
#line 3397 "book.c"
										{
											gboolean _tmp218_ = FALSE;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
											_tmp218_ = TRUE;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
											while (TRUE) {
#line 3404 "book.c"
												gint _tmp220_;
												gint _tmp221_;
												gint _tmp222_;
												guint8 p = 0U;
												guint8* _tmp226_;
												gint _tmp226__length1;
												gint _tmp227_;
												gint _tmp228_;
												guint8 _tmp229_;
												guint8 _tmp230_;
												gint _tmp245_;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
												if (!_tmp218_) {
#line 3418 "book.c"
													gint _tmp219_;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
													_tmp219_ = x;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
													x = _tmp219_ + 1;
#line 3424 "book.c"
												}
#line 403 "/home/bob/git/simple-scan/src/book.vala"
												_tmp218_ = FALSE;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
												_tmp220_ = x;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
												_tmp221_ = width;
#line 403 "/home/bob/git/simple-scan/src/book.vala"
												if (!(_tmp220_ < _tmp221_)) {
#line 403 "/home/bob/git/simple-scan/src/book.vala"
													break;
#line 3436 "book.c"
												}
#line 406 "/home/bob/git/simple-scan/src/book.vala"
												_tmp222_ = shift_count;
#line 406 "/home/bob/git/simple-scan/src/book.vala"
												if (_tmp222_ == 6) {
#line 3442 "book.c"
													guint8* _tmp223_;
													gint _tmp223__length1;
													gint _tmp224_;
													guint8 _tmp225_;
#line 407 "/home/bob/git/simple-scan/src/book.vala"
													_tmp223_ = data;
#line 407 "/home/bob/git/simple-scan/src/book.vala"
													_tmp223__length1 = data_length1;
#line 407 "/home/bob/git/simple-scan/src/book.vala"
													_tmp224_ = offset;
#line 407 "/home/bob/git/simple-scan/src/book.vala"
													_tmp223_[_tmp224_] = (guint8) 0;
#line 407 "/home/bob/git/simple-scan/src/book.vala"
													_tmp225_ = _tmp223_[_tmp224_];
#line 3457 "book.c"
												}
#line 410 "/home/bob/git/simple-scan/src/book.vala"
												_tmp226_ = pixels;
#line 410 "/home/bob/git/simple-scan/src/book.vala"
												_tmp226__length1 = pixels_length1;
#line 410 "/home/bob/git/simple-scan/src/book.vala"
												_tmp227_ = in_offset;
#line 410 "/home/bob/git/simple-scan/src/book.vala"
												_tmp228_ = x;
#line 410 "/home/bob/git/simple-scan/src/book.vala"
												_tmp229_ = _tmp226_[_tmp227_ + (_tmp228_ * 3)];
#line 410 "/home/bob/git/simple-scan/src/book.vala"
												p = _tmp229_;
#line 411 "/home/bob/git/simple-scan/src/book.vala"
												_tmp230_ = p;
#line 411 "/home/bob/git/simple-scan/src/book.vala"
												if (((gint) _tmp230_) >= 192) {
#line 3475 "book.c"
													guint8* _tmp231_;
													gint _tmp231__length1;
													gint _tmp232_;
													gint _tmp233_;
													guint8 _tmp234_;
#line 412 "/home/bob/git/simple-scan/src/book.vala"
													_tmp231_ = data;
#line 412 "/home/bob/git/simple-scan/src/book.vala"
													_tmp231__length1 = data_length1;
#line 412 "/home/bob/git/simple-scan/src/book.vala"
													_tmp232_ = offset;
#line 412 "/home/bob/git/simple-scan/src/book.vala"
													_tmp233_ = shift_count;
#line 412 "/home/bob/git/simple-scan/src/book.vala"
													_tmp231_[_tmp232_] |= (guint8) (3 << _tmp233_);
#line 412 "/home/bob/git/simple-scan/src/book.vala"
													_tmp234_ = _tmp231_[_tmp232_];
#line 3493 "book.c"
												} else {
													guint8 _tmp235_;
#line 413 "/home/bob/git/simple-scan/src/book.vala"
													_tmp235_ = p;
#line 413 "/home/bob/git/simple-scan/src/book.vala"
													if (((gint) _tmp235_) >= 128) {
#line 3500 "book.c"
														guint8* _tmp236_;
														gint _tmp236__length1;
														gint _tmp237_;
														gint _tmp238_;
														guint8 _tmp239_;
#line 414 "/home/bob/git/simple-scan/src/book.vala"
														_tmp236_ = data;
#line 414 "/home/bob/git/simple-scan/src/book.vala"
														_tmp236__length1 = data_length1;
#line 414 "/home/bob/git/simple-scan/src/book.vala"
														_tmp237_ = offset;
#line 414 "/home/bob/git/simple-scan/src/book.vala"
														_tmp238_ = shift_count;
#line 414 "/home/bob/git/simple-scan/src/book.vala"
														_tmp236_[_tmp237_] |= (guint8) (2 << _tmp238_);
#line 414 "/home/bob/git/simple-scan/src/book.vala"
														_tmp239_ = _tmp236_[_tmp237_];
#line 3518 "book.c"
													} else {
														guint8 _tmp240_;
#line 415 "/home/bob/git/simple-scan/src/book.vala"
														_tmp240_ = p;
#line 415 "/home/bob/git/simple-scan/src/book.vala"
														if (((gint) _tmp240_) >= 64) {
#line 3525 "book.c"
															guint8* _tmp241_;
															gint _tmp241__length1;
															gint _tmp242_;
															gint _tmp243_;
															guint8 _tmp244_;
#line 416 "/home/bob/git/simple-scan/src/book.vala"
															_tmp241_ = data;
#line 416 "/home/bob/git/simple-scan/src/book.vala"
															_tmp241__length1 = data_length1;
#line 416 "/home/bob/git/simple-scan/src/book.vala"
															_tmp242_ = offset;
#line 416 "/home/bob/git/simple-scan/src/book.vala"
															_tmp243_ = shift_count;
#line 416 "/home/bob/git/simple-scan/src/book.vala"
															_tmp241_[_tmp242_] |= (guint8) (1 << _tmp243_);
#line 416 "/home/bob/git/simple-scan/src/book.vala"
															_tmp244_ = _tmp241_[_tmp242_];
#line 3543 "book.c"
														}
													}
												}
#line 419 "/home/bob/git/simple-scan/src/book.vala"
												_tmp245_ = shift_count;
#line 419 "/home/bob/git/simple-scan/src/book.vala"
												if (_tmp245_ == 0) {
#line 3551 "book.c"
													gint _tmp246_;
#line 421 "/home/bob/git/simple-scan/src/book.vala"
													_tmp246_ = offset;
#line 421 "/home/bob/git/simple-scan/src/book.vala"
													offset = _tmp246_ + 1;
#line 422 "/home/bob/git/simple-scan/src/book.vala"
													shift_count = 6;
#line 3559 "book.c"
												} else {
													gint _tmp247_;
#line 425 "/home/bob/git/simple-scan/src/book.vala"
													_tmp247_ = shift_count;
#line 425 "/home/bob/git/simple-scan/src/book.vala"
													shift_count = _tmp247_ - 2;
#line 3566 "book.c"
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp248_;
						gint _tmp249_;
						gint _tmp250_;
#line 429 "/home/bob/git/simple-scan/src/book.vala"
						_tmp248_ = page;
#line 429 "/home/bob/git/simple-scan/src/book.vala"
						_tmp249_ = page_get_depth (_tmp248_);
#line 429 "/home/bob/git/simple-scan/src/book.vala"
						_tmp250_ = _tmp249_;
#line 429 "/home/bob/git/simple-scan/src/book.vala"
						if (_tmp250_ == 1) {
#line 3586 "book.c"
							gint mask = 0;
							gchar* _tmp251_;
							gint data_length = 0;
							gint _tmp252_;
							gint _tmp253_;
							gint _tmp254_;
							guint8* _tmp255_;
							gint offset = 0;
#line 431 "/home/bob/git/simple-scan/src/book.vala"
							mask = 0x80;
#line 433 "/home/bob/git/simple-scan/src/book.vala"
							depth = 1;
#line 434 "/home/bob/git/simple-scan/src/book.vala"
							_tmp251_ = g_strdup ("DeviceGray");
#line 434 "/home/bob/git/simple-scan/src/book.vala"
							_g_free0 (color_space);
#line 434 "/home/bob/git/simple-scan/src/book.vala"
							color_space = _tmp251_;
#line 435 "/home/bob/git/simple-scan/src/book.vala"
							_tmp252_ = height;
#line 435 "/home/bob/git/simple-scan/src/book.vala"
							_tmp253_ = width;
#line 435 "/home/bob/git/simple-scan/src/book.vala"
							data_length = _tmp252_ * ((_tmp253_ + 7) / 8);
#line 436 "/home/bob/git/simple-scan/src/book.vala"
							_tmp254_ = data_length;
#line 436 "/home/bob/git/simple-scan/src/book.vala"
							_tmp255_ = g_new0 (guint8, _tmp254_);
#line 436 "/home/bob/git/simple-scan/src/book.vala"
							data = (g_free (data), NULL);
#line 436 "/home/bob/git/simple-scan/src/book.vala"
							data = _tmp255_;
#line 436 "/home/bob/git/simple-scan/src/book.vala"
							data_length1 = _tmp254_;
#line 436 "/home/bob/git/simple-scan/src/book.vala"
							_data_size_ = data_length1;
#line 437 "/home/bob/git/simple-scan/src/book.vala"
							offset = 0;
#line 3625 "book.c"
							{
								gint row = 0;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
								row = 0;
#line 3630 "book.c"
								{
									gboolean _tmp256_ = FALSE;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
									_tmp256_ = TRUE;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
									while (TRUE) {
#line 3637 "book.c"
										gint _tmp258_;
										gint _tmp259_;
										gint _tmp260_;
										gint in_offset = 0;
										gint _tmp262_;
										GdkPixbuf* _tmp263_;
										gint _tmp264_;
										gint _tmp265_;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
										if (!_tmp256_) {
#line 3648 "book.c"
											gint _tmp257_;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
											_tmp257_ = row;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
											row = _tmp257_ + 1;
#line 3654 "book.c"
										}
#line 438 "/home/bob/git/simple-scan/src/book.vala"
										_tmp256_ = FALSE;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
										_tmp258_ = row;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
										_tmp259_ = height;
#line 438 "/home/bob/git/simple-scan/src/book.vala"
										if (!(_tmp258_ < _tmp259_)) {
#line 438 "/home/bob/git/simple-scan/src/book.vala"
											break;
#line 3666 "book.c"
										}
#line 441 "/home/bob/git/simple-scan/src/book.vala"
										_tmp260_ = mask;
#line 441 "/home/bob/git/simple-scan/src/book.vala"
										if (_tmp260_ != 0x80) {
#line 3672 "book.c"
											gint _tmp261_;
#line 443 "/home/bob/git/simple-scan/src/book.vala"
											_tmp261_ = offset;
#line 443 "/home/bob/git/simple-scan/src/book.vala"
											offset = _tmp261_ + 1;
#line 444 "/home/bob/git/simple-scan/src/book.vala"
											mask = 0x80;
#line 3680 "book.c"
										}
#line 447 "/home/bob/git/simple-scan/src/book.vala"
										_tmp262_ = row;
#line 447 "/home/bob/git/simple-scan/src/book.vala"
										_tmp263_ = image;
#line 447 "/home/bob/git/simple-scan/src/book.vala"
										_tmp264_ = gdk_pixbuf_get_rowstride (_tmp263_);
#line 447 "/home/bob/git/simple-scan/src/book.vala"
										_tmp265_ = _tmp264_;
#line 447 "/home/bob/git/simple-scan/src/book.vala"
										in_offset = _tmp262_ * _tmp265_;
#line 3692 "book.c"
										{
											gint x = 0;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
											x = 0;
#line 3697 "book.c"
											{
												gboolean _tmp266_ = FALSE;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
												_tmp266_ = TRUE;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
												while (TRUE) {
#line 3704 "book.c"
													gint _tmp268_;
													gint _tmp269_;
													gint _tmp270_;
													guint8* _tmp274_;
													gint _tmp274__length1;
													gint _tmp275_;
													gint _tmp276_;
													guint8 _tmp277_;
													gint _tmp282_;
													gint _tmp283_;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
													if (!_tmp266_) {
#line 3717 "book.c"
														gint _tmp267_;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
														_tmp267_ = x;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
														x = _tmp267_ + 1;
#line 3723 "book.c"
													}
#line 448 "/home/bob/git/simple-scan/src/book.vala"
													_tmp266_ = FALSE;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
													_tmp268_ = x;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
													_tmp269_ = width;
#line 448 "/home/bob/git/simple-scan/src/book.vala"
													if (!(_tmp268_ < _tmp269_)) {
#line 448 "/home/bob/git/simple-scan/src/book.vala"
														break;
#line 3735 "book.c"
													}
#line 451 "/home/bob/git/simple-scan/src/book.vala"
													_tmp270_ = mask;
#line 451 "/home/bob/git/simple-scan/src/book.vala"
													if (_tmp270_ == 0x80) {
#line 3741 "book.c"
														guint8* _tmp271_;
														gint _tmp271__length1;
														gint _tmp272_;
														guint8 _tmp273_;
#line 452 "/home/bob/git/simple-scan/src/book.vala"
														_tmp271_ = data;
#line 452 "/home/bob/git/simple-scan/src/book.vala"
														_tmp271__length1 = data_length1;
#line 452 "/home/bob/git/simple-scan/src/book.vala"
														_tmp272_ = offset;
#line 452 "/home/bob/git/simple-scan/src/book.vala"
														_tmp271_[_tmp272_] = (guint8) 0;
#line 452 "/home/bob/git/simple-scan/src/book.vala"
														_tmp273_ = _tmp271_[_tmp272_];
#line 3756 "book.c"
													}
#line 455 "/home/bob/git/simple-scan/src/book.vala"
													_tmp274_ = pixels;
#line 455 "/home/bob/git/simple-scan/src/book.vala"
													_tmp274__length1 = pixels_length1;
#line 455 "/home/bob/git/simple-scan/src/book.vala"
													_tmp275_ = in_offset;
#line 455 "/home/bob/git/simple-scan/src/book.vala"
													_tmp276_ = x;
#line 455 "/home/bob/git/simple-scan/src/book.vala"
													_tmp277_ = _tmp274_[_tmp275_ + (_tmp276_ * 3)];
#line 455 "/home/bob/git/simple-scan/src/book.vala"
													if (((gint) _tmp277_) != 0) {
#line 3770 "book.c"
														guint8* _tmp278_;
														gint _tmp278__length1;
														gint _tmp279_;
														gint _tmp280_;
														guint8 _tmp281_;
#line 456 "/home/bob/git/simple-scan/src/book.vala"
														_tmp278_ = data;
#line 456 "/home/bob/git/simple-scan/src/book.vala"
														_tmp278__length1 = data_length1;
#line 456 "/home/bob/git/simple-scan/src/book.vala"
														_tmp279_ = offset;
#line 456 "/home/bob/git/simple-scan/src/book.vala"
														_tmp280_ = mask;
#line 456 "/home/bob/git/simple-scan/src/book.vala"
														_tmp278_[_tmp279_] |= (guint8) _tmp280_;
#line 456 "/home/bob/git/simple-scan/src/book.vala"
														_tmp281_ = _tmp278_[_tmp279_];
#line 3788 "book.c"
													}
#line 459 "/home/bob/git/simple-scan/src/book.vala"
													_tmp282_ = mask;
#line 459 "/home/bob/git/simple-scan/src/book.vala"
													mask = _tmp282_ >> 1;
#line 460 "/home/bob/git/simple-scan/src/book.vala"
													_tmp283_ = mask;
#line 460 "/home/bob/git/simple-scan/src/book.vala"
													if (_tmp283_ == 0) {
#line 3798 "book.c"
														gint _tmp284_;
#line 462 "/home/bob/git/simple-scan/src/book.vala"
														_tmp284_ = offset;
#line 462 "/home/bob/git/simple-scan/src/book.vala"
														offset = _tmp284_ + 1;
#line 463 "/home/bob/git/simple-scan/src/book.vala"
														mask = 0x80;
#line 3806 "book.c"
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp285_;
							gint data_length = 0;
							gint _tmp286_;
							gint _tmp287_;
							gint _tmp288_;
							guint8* _tmp289_;
#line 470 "/home/bob/git/simple-scan/src/book.vala"
							depth = 8;
#line 471 "/home/bob/git/simple-scan/src/book.vala"
							_tmp285_ = g_strdup ("DeviceGray");
#line 471 "/home/bob/git/simple-scan/src/book.vala"
							_g_free0 (color_space);
#line 471 "/home/bob/git/simple-scan/src/book.vala"
							color_space = _tmp285_;
#line 472 "/home/bob/git/simple-scan/src/book.vala"
							_tmp286_ = height;
#line 472 "/home/bob/git/simple-scan/src/book.vala"
							_tmp287_ = width;
#line 472 "/home/bob/git/simple-scan/src/book.vala"
							data_length = _tmp286_ * _tmp287_;
#line 473 "/home/bob/git/simple-scan/src/book.vala"
							_tmp288_ = data_length;
#line 473 "/home/bob/git/simple-scan/src/book.vala"
							_tmp289_ = g_new0 (guint8, _tmp288_);
#line 473 "/home/bob/git/simple-scan/src/book.vala"
							data = (g_free (data), NULL);
#line 473 "/home/bob/git/simple-scan/src/book.vala"
							data = _tmp289_;
#line 473 "/home/bob/git/simple-scan/src/book.vala"
							data_length1 = _tmp288_;
#line 473 "/home/bob/git/simple-scan/src/book.vala"
							_data_size_ = data_length1;
#line 3847 "book.c"
							{
								gint row = 0;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
								row = 0;
#line 3852 "book.c"
								{
									gboolean _tmp290_ = FALSE;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
									_tmp290_ = TRUE;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
									while (TRUE) {
#line 3859 "book.c"
										gint _tmp292_;
										gint _tmp293_;
										gint in_offset = 0;
										gint _tmp294_;
										GdkPixbuf* _tmp295_;
										gint _tmp296_;
										gint _tmp297_;
										gint out_offset = 0;
										gint _tmp298_;
										gint _tmp299_;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
										if (!_tmp290_) {
#line 3872 "book.c"
											gint _tmp291_;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
											_tmp291_ = row;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
											row = _tmp291_ + 1;
#line 3878 "book.c"
										}
#line 474 "/home/bob/git/simple-scan/src/book.vala"
										_tmp290_ = FALSE;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
										_tmp292_ = row;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
										_tmp293_ = height;
#line 474 "/home/bob/git/simple-scan/src/book.vala"
										if (!(_tmp292_ < _tmp293_)) {
#line 474 "/home/bob/git/simple-scan/src/book.vala"
											break;
#line 3890 "book.c"
										}
#line 476 "/home/bob/git/simple-scan/src/book.vala"
										_tmp294_ = row;
#line 476 "/home/bob/git/simple-scan/src/book.vala"
										_tmp295_ = image;
#line 476 "/home/bob/git/simple-scan/src/book.vala"
										_tmp296_ = gdk_pixbuf_get_rowstride (_tmp295_);
#line 476 "/home/bob/git/simple-scan/src/book.vala"
										_tmp297_ = _tmp296_;
#line 476 "/home/bob/git/simple-scan/src/book.vala"
										in_offset = _tmp294_ * _tmp297_;
#line 477 "/home/bob/git/simple-scan/src/book.vala"
										_tmp298_ = row;
#line 477 "/home/bob/git/simple-scan/src/book.vala"
										_tmp299_ = width;
#line 477 "/home/bob/git/simple-scan/src/book.vala"
										out_offset = _tmp298_ * _tmp299_;
#line 3908 "book.c"
										{
											gint x = 0;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
											x = 0;
#line 3913 "book.c"
											{
												gboolean _tmp300_ = FALSE;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
												_tmp300_ = TRUE;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
												while (TRUE) {
#line 3920 "book.c"
													gint _tmp302_;
													gint _tmp303_;
													guint8* _tmp304_;
													gint _tmp304__length1;
													gint _tmp305_;
													gint _tmp306_;
													guint8* _tmp307_;
													gint _tmp307__length1;
													gint _tmp308_;
													gint _tmp309_;
													guint8 _tmp310_;
													guint8 _tmp311_;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
													if (!_tmp300_) {
#line 3935 "book.c"
														gint _tmp301_;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
														_tmp301_ = x;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
														x = _tmp301_ + 1;
#line 3941 "book.c"
													}
#line 478 "/home/bob/git/simple-scan/src/book.vala"
													_tmp300_ = FALSE;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
													_tmp302_ = x;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
													_tmp303_ = width;
#line 478 "/home/bob/git/simple-scan/src/book.vala"
													if (!(_tmp302_ < _tmp303_)) {
#line 478 "/home/bob/git/simple-scan/src/book.vala"
														break;
#line 3953 "book.c"
													}
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp304_ = data;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp304__length1 = data_length1;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp305_ = out_offset;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp306_ = x;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp307_ = pixels;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp307__length1 = pixels_length1;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp308_ = in_offset;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp309_ = x;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp310_ = _tmp307_[_tmp308_ + (_tmp309_ * 3)];
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp304_[_tmp305_ + _tmp306_] = _tmp310_;
#line 479 "/home/bob/git/simple-scan/src/book.vala"
													_tmp311_ = _tmp304_[_tmp305_ + _tmp306_];
#line 3977 "book.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
#line 484 "/home/bob/git/simple-scan/src/book.vala"
				_tmp312_ = data;
#line 484 "/home/bob/git/simple-scan/src/book.vala"
				_tmp312__length1 = data_length1;
#line 484 "/home/bob/git/simple-scan/src/book.vala"
				_tmp314_ = book_compress_zlib (self, _tmp312_, _tmp312__length1, &_tmp313_);
#line 484 "/home/bob/git/simple-scan/src/book.vala"
				compressed_data = _tmp314_;
#line 484 "/home/bob/git/simple-scan/src/book.vala"
				compressed_data_length1 = _tmp313_;
#line 484 "/home/bob/git/simple-scan/src/book.vala"
				_compressed_data_size_ = compressed_data_length1;
#line 485 "/home/bob/git/simple-scan/src/book.vala"
				_tmp315_ = compressed_data;
#line 485 "/home/bob/git/simple-scan/src/book.vala"
				_tmp315__length1 = compressed_data_length1;
#line 485 "/home/bob/git/simple-scan/src/book.vala"
				if (_tmp315_ != NULL) {
#line 4005 "book.c"
					gint _tmp316_;
					const gchar* _tmp328_;
#line 488 "/home/bob/git/simple-scan/src/book.vala"
					_tmp316_ = depth;
#line 488 "/home/bob/git/simple-scan/src/book.vala"
					if (_tmp316_ > 1) {
#line 4012 "book.c"
						guint8* jpeg_data = NULL;
						GdkPixbuf* _tmp317_;
						Page* _tmp318_;
						gint _tmp319_;
						gint _tmp320_;
						gint _tmp321_;
						guint8* _tmp322_;
						gint jpeg_data_length1;
						gint _jpeg_data_size_;
						guint8* _tmp323_;
						gint _tmp323__length1;
						guint8* _tmp324_;
						gint _tmp324__length1;
#line 490 "/home/bob/git/simple-scan/src/book.vala"
						_tmp317_ = image;
#line 490 "/home/bob/git/simple-scan/src/book.vala"
						_tmp318_ = page;
#line 490 "/home/bob/git/simple-scan/src/book.vala"
						_tmp319_ = page_get_dpi (_tmp318_);
#line 490 "/home/bob/git/simple-scan/src/book.vala"
						_tmp320_ = _tmp319_;
#line 490 "/home/bob/git/simple-scan/src/book.vala"
						_tmp322_ = book_compress_jpeg (self, _tmp317_, quality, _tmp320_, &_tmp321_);
#line 490 "/home/bob/git/simple-scan/src/book.vala"
						jpeg_data = _tmp322_;
#line 490 "/home/bob/git/simple-scan/src/book.vala"
						jpeg_data_length1 = _tmp321_;
#line 490 "/home/bob/git/simple-scan/src/book.vala"
						_jpeg_data_size_ = jpeg_data_length1;
#line 491 "/home/bob/git/simple-scan/src/book.vala"
						_tmp323_ = jpeg_data;
#line 491 "/home/bob/git/simple-scan/src/book.vala"
						_tmp323__length1 = jpeg_data_length1;
#line 491 "/home/bob/git/simple-scan/src/book.vala"
						_tmp324_ = compressed_data;
#line 491 "/home/bob/git/simple-scan/src/book.vala"
						_tmp324__length1 = compressed_data_length1;
#line 491 "/home/bob/git/simple-scan/src/book.vala"
						if (_tmp323__length1 < _tmp324__length1) {
#line 4052 "book.c"
							gchar* _tmp325_;
							guint8* _tmp326_;
							gint _tmp326__length1;
							guint8* _tmp327_;
							gint _tmp327__length1;
#line 493 "/home/bob/git/simple-scan/src/book.vala"
							_tmp325_ = g_strdup ("DCTDecode");
#line 493 "/home/bob/git/simple-scan/src/book.vala"
							_g_free0 (filter);
#line 493 "/home/bob/git/simple-scan/src/book.vala"
							filter = _tmp325_;
#line 494 "/home/bob/git/simple-scan/src/book.vala"
							_tmp326_ = jpeg_data;
#line 494 "/home/bob/git/simple-scan/src/book.vala"
							_tmp326__length1 = jpeg_data_length1;
#line 494 "/home/bob/git/simple-scan/src/book.vala"
							_tmp327_ = (_tmp326_ != NULL) ? _vala_array_dup1 (_tmp326_, _tmp326__length1) : ((gpointer) _tmp326_);
#line 494 "/home/bob/git/simple-scan/src/book.vala"
							_tmp327__length1 = _tmp326__length1;
#line 494 "/home/bob/git/simple-scan/src/book.vala"
							data = (g_free (data), NULL);
#line 494 "/home/bob/git/simple-scan/src/book.vala"
							data = _tmp327_;
#line 494 "/home/bob/git/simple-scan/src/book.vala"
							data_length1 = _tmp327__length1;
#line 494 "/home/bob/git/simple-scan/src/book.vala"
							_data_size_ = data_length1;
#line 4080 "book.c"
						}
#line 488 "/home/bob/git/simple-scan/src/book.vala"
						jpeg_data = (g_free (jpeg_data), NULL);
#line 4084 "book.c"
					}
#line 498 "/home/bob/git/simple-scan/src/book.vala"
					_tmp328_ = filter;
#line 498 "/home/bob/git/simple-scan/src/book.vala"
					if (_tmp328_ == NULL) {
#line 4090 "book.c"
						gchar* _tmp329_;
						guint8* _tmp330_;
						gint _tmp330__length1;
						guint8* _tmp331_;
						gint _tmp331__length1;
#line 500 "/home/bob/git/simple-scan/src/book.vala"
						_tmp329_ = g_strdup ("FlateDecode");
#line 500 "/home/bob/git/simple-scan/src/book.vala"
						_g_free0 (filter);
#line 500 "/home/bob/git/simple-scan/src/book.vala"
						filter = _tmp329_;
#line 501 "/home/bob/git/simple-scan/src/book.vala"
						_tmp330_ = compressed_data;
#line 501 "/home/bob/git/simple-scan/src/book.vala"
						_tmp330__length1 = compressed_data_length1;
#line 501 "/home/bob/git/simple-scan/src/book.vala"
						_tmp331_ = (_tmp330_ != NULL) ? _vala_array_dup2 (_tmp330_, _tmp330__length1) : ((gpointer) _tmp330_);
#line 501 "/home/bob/git/simple-scan/src/book.vala"
						_tmp331__length1 = _tmp330__length1;
#line 501 "/home/bob/git/simple-scan/src/book.vala"
						data = (g_free (data), NULL);
#line 501 "/home/bob/git/simple-scan/src/book.vala"
						data = _tmp331_;
#line 501 "/home/bob/git/simple-scan/src/book.vala"
						data_length1 = _tmp331__length1;
#line 501 "/home/bob/git/simple-scan/src/book.vala"
						_data_size_ = data_length1;
#line 4118 "book.c"
					}
				}
#line 506 "/home/bob/git/simple-scan/src/book.vala"
				_tmp332_ = writer;
#line 506 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp332_, "\n");
#line 507 "/home/bob/git/simple-scan/src/book.vala"
				_tmp333_ = writer;
#line 507 "/home/bob/git/simple-scan/src/book.vala"
				_tmp334_ = page_numbers;
#line 507 "/home/bob/git/simple-scan/src/book.vala"
				_tmp334__length1 = page_numbers_length1;
#line 507 "/home/bob/git/simple-scan/src/book.vala"
				_tmp335_ = i;
#line 507 "/home/bob/git/simple-scan/src/book.vala"
				_tmp336_ = _tmp334_[_tmp335_];
#line 507 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_start_object (_tmp333_, _tmp336_);
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				_tmp337_ = writer;
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				_tmp338_ = page_numbers;
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				_tmp338__length1 = page_numbers_length1;
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				_tmp339_ = i;
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				_tmp340_ = _tmp338_[_tmp339_];
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				_tmp341_ = g_strdup_printf ("%u 0 obj\n", _tmp340_);
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				_tmp342_ = _tmp341_;
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp337_, _tmp342_);
#line 508 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp342_);
#line 509 "/home/bob/git/simple-scan/src/book.vala"
				_tmp343_ = writer;
#line 509 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp343_, "<<\n");
#line 510 "/home/bob/git/simple-scan/src/book.vala"
				_tmp344_ = writer;
#line 510 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp344_, "/Type /Page\n");
#line 511 "/home/bob/git/simple-scan/src/book.vala"
				_tmp345_ = writer;
#line 511 "/home/bob/git/simple-scan/src/book.vala"
				_tmp346_ = pages_number;
#line 511 "/home/bob/git/simple-scan/src/book.vala"
				_tmp347_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp346_);
#line 511 "/home/bob/git/simple-scan/src/book.vala"
				_tmp348_ = _tmp347_;
#line 511 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp345_, _tmp348_);
#line 511 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp348_);
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_tmp349_ = writer;
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_tmp350_ = i;
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_tmp351_ = page_image_numbers;
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_tmp351__length1 = page_image_numbers_length1;
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_tmp352_ = i;
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_tmp353_ = _tmp351_[_tmp352_];
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_tmp354_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp350_, _tmp353_);
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_tmp355_ = _tmp354_;
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp349_, _tmp355_);
#line 512 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp355_);
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp356_ = writer;
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp357_ = page_width;
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp358_ = width_buffer;
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp358__length1 = width_buffer_length1;
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp359_ = g_ascii_formatd (_tmp358_, _tmp358__length1, "%.2f", _tmp357_);
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp360_ = page_height;
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp361_ = height_buffer;
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp361__length1 = height_buffer_length1;
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp362_ = g_ascii_formatd (_tmp361_, _tmp361__length1, "%.2f", _tmp360_);
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp363_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp359_, _tmp362_);
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_tmp364_ = _tmp363_;
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp356_, _tmp364_);
#line 513 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp364_);
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				_tmp365_ = writer;
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				_tmp366_ = page_content_numbers;
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				_tmp366__length1 = page_content_numbers_length1;
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				_tmp367_ = i;
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				_tmp368_ = _tmp366_[_tmp367_];
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				_tmp369_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp368_);
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				_tmp370_ = _tmp369_;
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp365_, _tmp370_);
#line 514 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp370_);
#line 515 "/home/bob/git/simple-scan/src/book.vala"
				_tmp371_ = writer;
#line 515 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp371_, ">>\n");
#line 516 "/home/bob/git/simple-scan/src/book.vala"
				_tmp372_ = writer;
#line 516 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp372_, "endobj\n");
#line 519 "/home/bob/git/simple-scan/src/book.vala"
				_tmp373_ = writer;
#line 519 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp373_, "\n");
#line 520 "/home/bob/git/simple-scan/src/book.vala"
				_tmp374_ = writer;
#line 520 "/home/bob/git/simple-scan/src/book.vala"
				_tmp375_ = page_image_numbers;
#line 520 "/home/bob/git/simple-scan/src/book.vala"
				_tmp375__length1 = page_image_numbers_length1;
#line 520 "/home/bob/git/simple-scan/src/book.vala"
				_tmp376_ = i;
#line 520 "/home/bob/git/simple-scan/src/book.vala"
				_tmp377_ = _tmp375_[_tmp376_];
#line 520 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_start_object (_tmp374_, _tmp377_);
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				_tmp378_ = writer;
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				_tmp379_ = page_image_numbers;
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				_tmp379__length1 = page_image_numbers_length1;
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				_tmp380_ = i;
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				_tmp381_ = _tmp379_[_tmp380_];
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				_tmp382_ = g_strdup_printf ("%u 0 obj\n", _tmp381_);
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				_tmp383_ = _tmp382_;
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp378_, _tmp383_);
#line 521 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp383_);
#line 522 "/home/bob/git/simple-scan/src/book.vala"
				_tmp384_ = writer;
#line 522 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp384_, "<<\n");
#line 523 "/home/bob/git/simple-scan/src/book.vala"
				_tmp385_ = writer;
#line 523 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp385_, "/Type /XObject\n");
#line 524 "/home/bob/git/simple-scan/src/book.vala"
				_tmp386_ = writer;
#line 524 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp386_, "/Subtype /Image\n");
#line 525 "/home/bob/git/simple-scan/src/book.vala"
				_tmp387_ = writer;
#line 525 "/home/bob/git/simple-scan/src/book.vala"
				_tmp388_ = width;
#line 525 "/home/bob/git/simple-scan/src/book.vala"
				_tmp389_ = g_strdup_printf ("/Width %d\n", _tmp388_);
#line 525 "/home/bob/git/simple-scan/src/book.vala"
				_tmp390_ = _tmp389_;
#line 525 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp387_, _tmp390_);
#line 525 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp390_);
#line 526 "/home/bob/git/simple-scan/src/book.vala"
				_tmp391_ = writer;
#line 526 "/home/bob/git/simple-scan/src/book.vala"
				_tmp392_ = height;
#line 526 "/home/bob/git/simple-scan/src/book.vala"
				_tmp393_ = g_strdup_printf ("/Height %d\n", _tmp392_);
#line 526 "/home/bob/git/simple-scan/src/book.vala"
				_tmp394_ = _tmp393_;
#line 526 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp391_, _tmp394_);
#line 526 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp394_);
#line 527 "/home/bob/git/simple-scan/src/book.vala"
				_tmp395_ = writer;
#line 527 "/home/bob/git/simple-scan/src/book.vala"
				_tmp396_ = color_space;
#line 527 "/home/bob/git/simple-scan/src/book.vala"
				_tmp397_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp396_);
#line 527 "/home/bob/git/simple-scan/src/book.vala"
				_tmp398_ = _tmp397_;
#line 527 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp395_, _tmp398_);
#line 527 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp398_);
#line 528 "/home/bob/git/simple-scan/src/book.vala"
				_tmp399_ = writer;
#line 528 "/home/bob/git/simple-scan/src/book.vala"
				_tmp400_ = depth;
#line 528 "/home/bob/git/simple-scan/src/book.vala"
				_tmp401_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp400_);
#line 528 "/home/bob/git/simple-scan/src/book.vala"
				_tmp402_ = _tmp401_;
#line 528 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp399_, _tmp402_);
#line 528 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp402_);
#line 529 "/home/bob/git/simple-scan/src/book.vala"
				_tmp403_ = writer;
#line 529 "/home/bob/git/simple-scan/src/book.vala"
				_tmp404_ = data;
#line 529 "/home/bob/git/simple-scan/src/book.vala"
				_tmp404__length1 = data_length1;
#line 529 "/home/bob/git/simple-scan/src/book.vala"
				_tmp405_ = g_strdup_printf ("/Length %d\n", _tmp404__length1);
#line 529 "/home/bob/git/simple-scan/src/book.vala"
				_tmp406_ = _tmp405_;
#line 529 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp403_, _tmp406_);
#line 529 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp406_);
#line 530 "/home/bob/git/simple-scan/src/book.vala"
				_tmp407_ = filter;
#line 530 "/home/bob/git/simple-scan/src/book.vala"
				if (_tmp407_ != NULL) {
#line 4359 "book.c"
					PDFWriter* _tmp408_;
					const gchar* _tmp409_;
					gchar* _tmp410_;
					gchar* _tmp411_;
#line 531 "/home/bob/git/simple-scan/src/book.vala"
					_tmp408_ = writer;
#line 531 "/home/bob/git/simple-scan/src/book.vala"
					_tmp409_ = filter;
#line 531 "/home/bob/git/simple-scan/src/book.vala"
					_tmp410_ = g_strdup_printf ("/Filter /%s\n", _tmp409_);
#line 531 "/home/bob/git/simple-scan/src/book.vala"
					_tmp411_ = _tmp410_;
#line 531 "/home/bob/git/simple-scan/src/book.vala"
					pdf_writer_write_string (_tmp408_, _tmp411_);
#line 531 "/home/bob/git/simple-scan/src/book.vala"
					_g_free0 (_tmp411_);
#line 4376 "book.c"
				}
#line 532 "/home/bob/git/simple-scan/src/book.vala"
				_tmp412_ = writer;
#line 532 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp412_, ">>\n");
#line 533 "/home/bob/git/simple-scan/src/book.vala"
				_tmp413_ = writer;
#line 533 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp413_, "stream\n");
#line 534 "/home/bob/git/simple-scan/src/book.vala"
				_tmp414_ = writer;
#line 534 "/home/bob/git/simple-scan/src/book.vala"
				_tmp415_ = data;
#line 534 "/home/bob/git/simple-scan/src/book.vala"
				_tmp415__length1 = data_length1;
#line 534 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write (_tmp414_, _tmp415_, _tmp415__length1);
#line 535 "/home/bob/git/simple-scan/src/book.vala"
				_tmp416_ = writer;
#line 535 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp416_, "\n");
#line 536 "/home/bob/git/simple-scan/src/book.vala"
				_tmp417_ = writer;
#line 536 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp417_, "endstream\n");
#line 537 "/home/bob/git/simple-scan/src/book.vala"
				_tmp418_ = writer;
#line 537 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp418_, "endobj\n");
#line 540 "/home/bob/git/simple-scan/src/book.vala"
				_tmp419_ = writer;
#line 540 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp419_, "\n");
#line 541 "/home/bob/git/simple-scan/src/book.vala"
				_tmp420_ = writer;
#line 541 "/home/bob/git/simple-scan/src/book.vala"
				_tmp421_ = struct_tree_root_number;
#line 541 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_start_object (_tmp420_, _tmp421_);
#line 542 "/home/bob/git/simple-scan/src/book.vala"
				_tmp422_ = writer;
#line 542 "/home/bob/git/simple-scan/src/book.vala"
				_tmp423_ = struct_tree_root_number;
#line 542 "/home/bob/git/simple-scan/src/book.vala"
				_tmp424_ = g_strdup_printf ("%u 0 obj\n", _tmp423_);
#line 542 "/home/bob/git/simple-scan/src/book.vala"
				_tmp425_ = _tmp424_;
#line 542 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp422_, _tmp425_);
#line 542 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp425_);
#line 543 "/home/bob/git/simple-scan/src/book.vala"
				_tmp426_ = writer;
#line 543 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp426_, "<<\n");
#line 544 "/home/bob/git/simple-scan/src/book.vala"
				_tmp427_ = writer;
#line 544 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp427_, "/Type /StructTreeRoot\n");
#line 545 "/home/bob/git/simple-scan/src/book.vala"
				_tmp428_ = writer;
#line 545 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp428_, ">>\n");
#line 546 "/home/bob/git/simple-scan/src/book.vala"
				_tmp429_ = writer;
#line 546 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp429_, "endobj\n");
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp430_ = page_width;
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp431_ = width_buffer;
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp431__length1 = width_buffer_length1;
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp432_ = g_ascii_formatd (_tmp431_, _tmp431__length1, "%f", _tmp430_);
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp433_ = page_height;
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp434_ = height_buffer;
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp434__length1 = height_buffer_length1;
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp435_ = g_ascii_formatd (_tmp434_, _tmp434__length1, "%f", _tmp433_);
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp436_ = i;
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				_tmp437_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp432_, _tmp435_, _tmp436_);
#line 549 "/home/bob/git/simple-scan/src/book.vala"
				command = _tmp437_;
#line 550 "/home/bob/git/simple-scan/src/book.vala"
				_tmp438_ = writer;
#line 550 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp438_, "\n");
#line 551 "/home/bob/git/simple-scan/src/book.vala"
				_tmp439_ = writer;
#line 551 "/home/bob/git/simple-scan/src/book.vala"
				_tmp440_ = page_content_numbers;
#line 551 "/home/bob/git/simple-scan/src/book.vala"
				_tmp440__length1 = page_content_numbers_length1;
#line 551 "/home/bob/git/simple-scan/src/book.vala"
				_tmp441_ = i;
#line 551 "/home/bob/git/simple-scan/src/book.vala"
				_tmp442_ = _tmp440_[_tmp441_];
#line 551 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_start_object (_tmp439_, _tmp442_);
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				_tmp443_ = writer;
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				_tmp444_ = page_content_numbers;
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				_tmp444__length1 = page_content_numbers_length1;
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				_tmp445_ = i;
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				_tmp446_ = _tmp444_[_tmp445_];
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				_tmp447_ = g_strdup_printf ("%u 0 obj\n", _tmp446_);
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				_tmp448_ = _tmp447_;
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp443_, _tmp448_);
#line 552 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp448_);
#line 553 "/home/bob/git/simple-scan/src/book.vala"
				_tmp449_ = writer;
#line 553 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp449_, "<<\n");
#line 554 "/home/bob/git/simple-scan/src/book.vala"
				_tmp450_ = writer;
#line 554 "/home/bob/git/simple-scan/src/book.vala"
				_tmp451_ = command;
#line 554 "/home/bob/git/simple-scan/src/book.vala"
				_tmp452_ = strlen (_tmp451_);
#line 554 "/home/bob/git/simple-scan/src/book.vala"
				_tmp453_ = _tmp452_;
#line 554 "/home/bob/git/simple-scan/src/book.vala"
				_tmp454_ = g_strdup_printf ("/Length %d\n", _tmp453_);
#line 554 "/home/bob/git/simple-scan/src/book.vala"
				_tmp455_ = _tmp454_;
#line 554 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp450_, _tmp455_);
#line 554 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (_tmp455_);
#line 555 "/home/bob/git/simple-scan/src/book.vala"
				_tmp456_ = writer;
#line 555 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp456_, ">>\n");
#line 556 "/home/bob/git/simple-scan/src/book.vala"
				_tmp457_ = writer;
#line 556 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp457_, "stream\n");
#line 557 "/home/bob/git/simple-scan/src/book.vala"
				_tmp458_ = writer;
#line 557 "/home/bob/git/simple-scan/src/book.vala"
				_tmp459_ = command;
#line 557 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp458_, _tmp459_);
#line 558 "/home/bob/git/simple-scan/src/book.vala"
				_tmp460_ = writer;
#line 558 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp460_, "\n");
#line 559 "/home/bob/git/simple-scan/src/book.vala"
				_tmp461_ = writer;
#line 559 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp461_, "endstream\n");
#line 560 "/home/bob/git/simple-scan/src/book.vala"
				_tmp462_ = writer;
#line 560 "/home/bob/git/simple-scan/src/book.vala"
				pdf_writer_write_string (_tmp462_, "endobj\n");
#line 562 "/home/bob/git/simple-scan/src/book.vala"
				_tmp463_ = i;
#line 562 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_emit (self, book_signals[BOOK_SAVING_SIGNAL], 0, _tmp463_);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (command);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				compressed_data = (g_free (compressed_data), NULL);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				data = (g_free (data), NULL);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				height_buffer = (g_free (height_buffer), NULL);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				width_buffer = (g_free (width_buffer), NULL);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (filter);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_g_free0 (color_space);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_g_object_unref0 (image);
#line 348 "/home/bob/git/simple-scan/src/book.vala"
				_page_unref0 (page);
#line 4568 "book.c"
			}
		}
	}
#line 566 "/home/bob/git/simple-scan/src/book.vala"
	_tmp464_ = writer;
#line 566 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp464_, "\n");
#line 567 "/home/bob/git/simple-scan/src/book.vala"
	_tmp465_ = writer;
#line 567 "/home/bob/git/simple-scan/src/book.vala"
	_tmp466_ = info_number;
#line 567 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_start_object (_tmp465_, _tmp466_);
#line 568 "/home/bob/git/simple-scan/src/book.vala"
	_tmp467_ = writer;
#line 568 "/home/bob/git/simple-scan/src/book.vala"
	_tmp468_ = info_number;
#line 568 "/home/bob/git/simple-scan/src/book.vala"
	_tmp469_ = g_strdup_printf ("%u 0 obj\n", _tmp468_);
#line 568 "/home/bob/git/simple-scan/src/book.vala"
	_tmp470_ = _tmp469_;
#line 568 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp467_, _tmp470_);
#line 568 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp470_);
#line 569 "/home/bob/git/simple-scan/src/book.vala"
	_tmp471_ = writer;
#line 569 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp471_, "<<\n");
#line 570 "/home/bob/git/simple-scan/src/book.vala"
	_tmp472_ = writer;
#line 570 "/home/bob/git/simple-scan/src/book.vala"
	_tmp473_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
#line 570 "/home/bob/git/simple-scan/src/book.vala"
	_tmp474_ = _tmp473_;
#line 570 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp472_, _tmp474_);
#line 570 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp474_);
#line 571 "/home/bob/git/simple-scan/src/book.vala"
	_tmp475_ = writer;
#line 571 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp475_, ">>\n");
#line 572 "/home/bob/git/simple-scan/src/book.vala"
	_tmp476_ = writer;
#line 572 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp476_, "endobj\n");
#line 575 "/home/bob/git/simple-scan/src/book.vala"
	_tmp477_ = writer;
#line 575 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp477_, "\n");
#line 576 "/home/bob/git/simple-scan/src/book.vala"
	_tmp478_ = writer;
#line 576 "/home/bob/git/simple-scan/src/book.vala"
	_tmp479_ = _tmp478_->offset;
#line 576 "/home/bob/git/simple-scan/src/book.vala"
	xref_offset = _tmp479_;
#line 577 "/home/bob/git/simple-scan/src/book.vala"
	_tmp480_ = writer;
#line 577 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp480_, "xref\n");
#line 578 "/home/bob/git/simple-scan/src/book.vala"
	_tmp481_ = writer;
#line 578 "/home/bob/git/simple-scan/src/book.vala"
	_tmp482_ = writer;
#line 578 "/home/bob/git/simple-scan/src/book.vala"
	_tmp483_ = _tmp482_->object_offsets;
#line 578 "/home/bob/git/simple-scan/src/book.vala"
	_tmp483__length1 = _tmp482_->object_offsets_length1;
#line 578 "/home/bob/git/simple-scan/src/book.vala"
	_tmp484_ = g_strdup_printf ("0 %zu\n", (gsize) (_tmp483__length1 + 1));
#line 578 "/home/bob/git/simple-scan/src/book.vala"
	_tmp485_ = _tmp484_;
#line 578 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp481_, _tmp485_);
#line 578 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp485_);
#line 579 "/home/bob/git/simple-scan/src/book.vala"
	_tmp486_ = writer;
#line 579 "/home/bob/git/simple-scan/src/book.vala"
	_tmp487_ = writer;
#line 579 "/home/bob/git/simple-scan/src/book.vala"
	_tmp488_ = g_strdup_printf ("%010zu 65535 f \n", (gsize) book_next_empty_object (_tmp487_, 0));
#line 579 "/home/bob/git/simple-scan/src/book.vala"
	_tmp489_ = _tmp488_;
#line 579 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp486_, _tmp489_);
#line 579 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp489_);
#line 4658 "book.c"
	{
		gint i = 0;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
		i = 0;
#line 4663 "book.c"
		{
			gboolean _tmp490_ = FALSE;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
			_tmp490_ = TRUE;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 4670 "book.c"
				gint _tmp492_;
				PDFWriter* _tmp493_;
				guint* _tmp494_;
				gint _tmp494__length1;
				PDFWriter* _tmp495_;
				guint* _tmp496_;
				gint _tmp496__length1;
				gint _tmp497_;
				guint _tmp498_;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp490_) {
#line 4682 "book.c"
					gint _tmp491_;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
					_tmp491_ = i;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp491_ + 1;
#line 4688 "book.c"
				}
#line 580 "/home/bob/git/simple-scan/src/book.vala"
				_tmp490_ = FALSE;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
				_tmp492_ = i;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
				_tmp493_ = writer;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
				_tmp494_ = _tmp493_->object_offsets;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
				_tmp494__length1 = _tmp493_->object_offsets_length1;
#line 580 "/home/bob/git/simple-scan/src/book.vala"
				if (!(_tmp492_ < _tmp494__length1)) {
#line 580 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 4704 "book.c"
				}
#line 581 "/home/bob/git/simple-scan/src/book.vala"
				_tmp495_ = writer;
#line 581 "/home/bob/git/simple-scan/src/book.vala"
				_tmp496_ = _tmp495_->object_offsets;
#line 581 "/home/bob/git/simple-scan/src/book.vala"
				_tmp496__length1 = _tmp495_->object_offsets_length1;
#line 581 "/home/bob/git/simple-scan/src/book.vala"
				_tmp497_ = i;
#line 581 "/home/bob/git/simple-scan/src/book.vala"
				_tmp498_ = _tmp496_[_tmp497_];
#line 581 "/home/bob/git/simple-scan/src/book.vala"
				if (_tmp498_ == ((guint) 0)) {
#line 4718 "book.c"
					PDFWriter* _tmp499_;
					PDFWriter* _tmp500_;
					gint _tmp501_;
					gchar* _tmp502_;
					gchar* _tmp503_;
#line 582 "/home/bob/git/simple-scan/src/book.vala"
					_tmp499_ = writer;
#line 582 "/home/bob/git/simple-scan/src/book.vala"
					_tmp500_ = writer;
#line 582 "/home/bob/git/simple-scan/src/book.vala"
					_tmp501_ = i;
#line 582 "/home/bob/git/simple-scan/src/book.vala"
					_tmp502_ = g_strdup_printf ("%010zu 65535 f \n", (gsize) book_next_empty_object (_tmp500_, _tmp501_ + 1));
#line 582 "/home/bob/git/simple-scan/src/book.vala"
					_tmp503_ = _tmp502_;
#line 582 "/home/bob/git/simple-scan/src/book.vala"
					pdf_writer_write_string (_tmp499_, _tmp503_);
#line 582 "/home/bob/git/simple-scan/src/book.vala"
					_g_free0 (_tmp503_);
#line 4738 "book.c"
				} else {
					PDFWriter* _tmp504_;
					PDFWriter* _tmp505_;
					guint* _tmp506_;
					gint _tmp506__length1;
					gint _tmp507_;
					guint _tmp508_;
					gchar* _tmp509_;
					gchar* _tmp510_;
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_tmp504_ = writer;
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_tmp505_ = writer;
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_tmp506_ = _tmp505_->object_offsets;
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_tmp506__length1 = _tmp505_->object_offsets_length1;
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_tmp507_ = i;
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_tmp508_ = _tmp506_[_tmp507_];
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_tmp509_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp508_);
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_tmp510_ = _tmp509_;
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					pdf_writer_write_string (_tmp504_, _tmp510_);
#line 584 "/home/bob/git/simple-scan/src/book.vala"
					_g_free0 (_tmp510_);
#line 4768 "book.c"
				}
			}
		}
	}
#line 587 "/home/bob/git/simple-scan/src/book.vala"
	_tmp511_ = writer;
#line 587 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp511_, "\n");
#line 588 "/home/bob/git/simple-scan/src/book.vala"
	_tmp512_ = writer;
#line 588 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp512_, "trailer\n");
#line 589 "/home/bob/git/simple-scan/src/book.vala"
	_tmp513_ = writer;
#line 589 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp513_, "<<\n");
#line 590 "/home/bob/git/simple-scan/src/book.vala"
	_tmp514_ = writer;
#line 590 "/home/bob/git/simple-scan/src/book.vala"
	_tmp515_ = writer;
#line 590 "/home/bob/git/simple-scan/src/book.vala"
	_tmp516_ = _tmp515_->object_offsets;
#line 590 "/home/bob/git/simple-scan/src/book.vala"
	_tmp516__length1 = _tmp515_->object_offsets_length1;
#line 590 "/home/bob/git/simple-scan/src/book.vala"
	_tmp517_ = g_strdup_printf ("/Size %zu\n", (gsize) (_tmp516__length1 + 1));
#line 590 "/home/bob/git/simple-scan/src/book.vala"
	_tmp518_ = _tmp517_;
#line 590 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp514_, _tmp518_);
#line 590 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp518_);
#line 591 "/home/bob/git/simple-scan/src/book.vala"
	_tmp519_ = writer;
#line 591 "/home/bob/git/simple-scan/src/book.vala"
	_tmp520_ = info_number;
#line 591 "/home/bob/git/simple-scan/src/book.vala"
	_tmp521_ = g_strdup_printf ("/Info %u 0 R\n", _tmp520_);
#line 591 "/home/bob/git/simple-scan/src/book.vala"
	_tmp522_ = _tmp521_;
#line 591 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp519_, _tmp522_);
#line 591 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp522_);
#line 592 "/home/bob/git/simple-scan/src/book.vala"
	_tmp523_ = writer;
#line 592 "/home/bob/git/simple-scan/src/book.vala"
	_tmp524_ = catalog_number;
#line 592 "/home/bob/git/simple-scan/src/book.vala"
	_tmp525_ = g_strdup_printf ("/Root %u 0 R\n", _tmp524_);
#line 592 "/home/bob/git/simple-scan/src/book.vala"
	_tmp526_ = _tmp525_;
#line 592 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp523_, _tmp526_);
#line 592 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp526_);
#line 593 "/home/bob/git/simple-scan/src/book.vala"
	_tmp527_ = writer;
#line 593 "/home/bob/git/simple-scan/src/book.vala"
	_tmp528_ = id;
#line 593 "/home/bob/git/simple-scan/src/book.vala"
	_tmp529_ = id;
#line 593 "/home/bob/git/simple-scan/src/book.vala"
	_tmp530_ = g_strdup_printf ("/ID [<%s> <%s>]\n", _tmp528_, _tmp529_);
#line 593 "/home/bob/git/simple-scan/src/book.vala"
	_tmp531_ = _tmp530_;
#line 593 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp527_, _tmp531_);
#line 593 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp531_);
#line 594 "/home/bob/git/simple-scan/src/book.vala"
	_tmp532_ = writer;
#line 594 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp532_, ">>\n");
#line 595 "/home/bob/git/simple-scan/src/book.vala"
	_tmp533_ = writer;
#line 595 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp533_, "startxref\n");
#line 596 "/home/bob/git/simple-scan/src/book.vala"
	_tmp534_ = writer;
#line 596 "/home/bob/git/simple-scan/src/book.vala"
	_tmp535_ = xref_offset;
#line 596 "/home/bob/git/simple-scan/src/book.vala"
	_tmp536_ = g_strdup_printf ("%zu\n", _tmp535_);
#line 596 "/home/bob/git/simple-scan/src/book.vala"
	_tmp537_ = _tmp536_;
#line 596 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp534_, _tmp537_);
#line 596 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (_tmp537_);
#line 597 "/home/bob/git/simple-scan/src/book.vala"
	_tmp538_ = writer;
#line 597 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write_string (_tmp538_, "%%EOF\n");
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (metadata);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (date_string);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	_g_date_time_unref0 (now);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	page_content_numbers = (g_free (page_content_numbers), NULL);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	page_image_numbers = (g_free (page_image_numbers), NULL);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	page_numbers = (g_free (page_numbers), NULL);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	_pdf_writer_unref0 (writer);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	_g_object_unref0 (stream);
#line 257 "/home/bob/git/simple-scan/src/book.vala"
	_g_free0 (id);
#line 4881 "book.c"
}


static gint
book_next_empty_object (PDFWriter* writer,
                        gint start)
{
	gint result = 0;
#line 600 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (writer != NULL, 0);
#line 4892 "book.c"
	{
		gint i = 0;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
		i = start;
#line 4897 "book.c"
		{
			gboolean _tmp0_ = FALSE;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
			_tmp0_ = TRUE;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
			while (TRUE) {
#line 4904 "book.c"
				gint _tmp2_;
				guint* _tmp3_;
				gint _tmp3__length1;
				guint* _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				guint _tmp6_;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
				if (!_tmp0_) {
#line 4914 "book.c"
					gint _tmp1_;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
					_tmp1_ = i;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
					i = _tmp1_ + 1;
#line 4920 "book.c"
				}
#line 602 "/home/bob/git/simple-scan/src/book.vala"
				_tmp0_ = FALSE;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
				_tmp2_ = i;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
				_tmp3_ = writer->object_offsets;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
				_tmp3__length1 = writer->object_offsets_length1;
#line 602 "/home/bob/git/simple-scan/src/book.vala"
				if (!(_tmp2_ < _tmp3__length1)) {
#line 602 "/home/bob/git/simple-scan/src/book.vala"
					break;
#line 4934 "book.c"
				}
#line 603 "/home/bob/git/simple-scan/src/book.vala"
				_tmp4_ = writer->object_offsets;
#line 603 "/home/bob/git/simple-scan/src/book.vala"
				_tmp4__length1 = writer->object_offsets_length1;
#line 603 "/home/bob/git/simple-scan/src/book.vala"
				_tmp5_ = i;
#line 603 "/home/bob/git/simple-scan/src/book.vala"
				_tmp6_ = _tmp4_[_tmp5_];
#line 603 "/home/bob/git/simple-scan/src/book.vala"
				if (_tmp6_ == ((guint) 0)) {
#line 4946 "book.c"
					gint _tmp7_;
#line 604 "/home/bob/git/simple-scan/src/book.vala"
					_tmp7_ = i;
#line 604 "/home/bob/git/simple-scan/src/book.vala"
					result = _tmp7_ + 1;
#line 604 "/home/bob/git/simple-scan/src/book.vala"
					return result;
#line 4954 "book.c"
				}
			}
		}
	}
#line 605 "/home/bob/git/simple-scan/src/book.vala"
	result = 0;
#line 605 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 4963 "book.c"
}


void
book_save (Book* self,
           const gchar* type,
           gint quality,
           GFile* file,
           GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 610 "/home/bob/git/simple-scan/src/book.vala"
	static GQuark _tmp1_label0 = 0;
#line 610 "/home/bob/git/simple-scan/src/book.vala"
	static GQuark _tmp1_label1 = 0;
#line 610 "/home/bob/git/simple-scan/src/book.vala"
	static GQuark _tmp1_label2 = 0;
#line 610 "/home/bob/git/simple-scan/src/book.vala"
	static GQuark _tmp1_label3 = 0;
#line 610 "/home/bob/git/simple-scan/src/book.vala"
	static GQuark _tmp1_label4 = 0;
#line 4986 "book.c"
	GError * _inner_error_ = NULL;
#line 608 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 608 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (type != NULL);
#line 608 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (file != NULL);
#line 610 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = type;
#line 610 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 610 "/home/bob/git/simple-scan/src/book.vala"
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("jpeg")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("png"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("tiff"))))) {
#line 610 "/home/bob/git/simple-scan/src/book.vala"
		switch (0) {
#line 5002 "book.c"
			default:
			{
#line 615 "/home/bob/git/simple-scan/src/book.vala"
				book_save_multi_file (self, type, quality, file, &_inner_error_);
#line 615 "/home/bob/git/simple-scan/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 615 "/home/bob/git/simple-scan/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 615 "/home/bob/git/simple-scan/src/book.vala"
					return;
#line 5013 "book.c"
				}
#line 616 "/home/bob/git/simple-scan/src/book.vala"
				break;
#line 5017 "book.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("ps")))) {
#line 610 "/home/bob/git/simple-scan/src/book.vala"
		switch (0) {
#line 5023 "book.c"
			default:
			{
#line 618 "/home/bob/git/simple-scan/src/book.vala"
				book_save_ps (self, file, &_inner_error_);
#line 618 "/home/bob/git/simple-scan/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 618 "/home/bob/git/simple-scan/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 618 "/home/bob/git/simple-scan/src/book.vala"
					return;
#line 5034 "book.c"
				}
#line 619 "/home/bob/git/simple-scan/src/book.vala"
				break;
#line 5038 "book.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("pdf")))) {
#line 610 "/home/bob/git/simple-scan/src/book.vala"
		switch (0) {
#line 5044 "book.c"
			default:
			{
#line 621 "/home/bob/git/simple-scan/src/book.vala"
				book_save_pdf (self, file, quality, &_inner_error_);
#line 621 "/home/bob/git/simple-scan/src/book.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/bob/git/simple-scan/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 621 "/home/bob/git/simple-scan/src/book.vala"
					return;
#line 5055 "book.c"
				}
#line 622 "/home/bob/git/simple-scan/src/book.vala"
				break;
#line 5059 "book.c"
			}
		}
	}
}


guint
book_get_n_pages (Book* self)
{
	guint result;
	GList* _tmp0_;
#line 16 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 16 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 16 "/home/bob/git/simple-scan/src/book.vala"
	result = g_list_length (_tmp0_);
#line 16 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 5079 "book.c"
}


gboolean
book_get_needs_saving (Book* self)
{
	gboolean result;
	gboolean _tmp0_;
#line 21 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 21 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 21 "/home/bob/git/simple-scan/src/book.vala"
	result = _tmp0_;
#line 21 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 5096 "book.c"
}


void
book_set_needs_saving (Book* self,
                       gboolean value)
{
	gboolean _tmp0_;
#line 22 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 24 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 24 "/home/bob/git/simple-scan/src/book.vala"
	if (_tmp0_ == value) {
#line 25 "/home/bob/git/simple-scan/src/book.vala"
		return;
#line 5113 "book.c"
	}
#line 26 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->needs_saving_ = value;
#line 27 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_emit (self, book_signals[BOOK_NEEDS_SAVING_CHANGED_SIGNAL], 0);
#line 5119 "book.c"
}


static void
g_cclosure_user_marshal_VOID__PAGE (GClosure * closure,
                                    GValue * return_value,
                                    guint n_param_values,
                                    const GValue * param_values,
                                    gpointer invocation_hint,
                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (n_param_values == 2);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		data1 = closure->data;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		data2 = param_values->data[0].v_pointer;
#line 5145 "book.c"
	} else {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		data2 = closure->data;
#line 5151 "book.c"
	}
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 5157 "book.c"
}


static void
value_book_init (GValue* value)
{
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 5166 "book.c"
}


static void
value_book_free_value (GValue* value)
{
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		book_unref (value->data[0].v_pointer);
#line 5177 "book.c"
	}
}


static void
value_book_copy_value (const GValue* src_value,
                       GValue* dest_value)
{
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
#line 5190 "book.c"
	} else {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5194 "book.c"
	}
}


static gpointer
value_book_peek_pointer (const GValue* value)
{
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	return value->data[0].v_pointer;
#line 5204 "book.c"
}


static gchar*
value_book_collect_value (GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5216 "book.c"
		Book * object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5223 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5227 "book.c"
		}
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = book_ref (object);
#line 5231 "book.c"
	} else {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5235 "book.c"
	}
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	return NULL;
#line 5239 "book.c"
}


static gchar*
value_book_lcopy_value (const GValue* value,
                        guint n_collect_values,
                        GTypeCValue* collect_values,
                        guint collect_flags)
{
	Book ** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (!object_p) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5255 "book.c"
	}
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = NULL;
#line 5261 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5265 "book.c"
	} else {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = book_ref (value->data[0].v_pointer);
#line 5269 "book.c"
	}
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	return NULL;
#line 5273 "book.c"
}


GParamSpec*
param_spec_book (const gchar* name,
                 const gchar* nick,
                 const gchar* blurb,
                 GType object_type,
                 GParamFlags flags)
{
	ParamSpecBook* spec;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5293 "book.c"
}


gpointer
value_get_book (const GValue* value)
{
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	return value->data[0].v_pointer;
#line 5304 "book.c"
}


void
value_set_book (GValue* value,
                gpointer v_object)
{
	Book * old;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		book_ref (value->data[0].v_pointer);
#line 5327 "book.c"
	} else {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5331 "book.c"
	}
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (old) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		book_unref (old);
#line 5337 "book.c"
	}
}


void
value_take_book (GValue* value,
                 gpointer v_object)
{
	Book * old;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5359 "book.c"
	} else {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5363 "book.c"
	}
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (old) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		book_unref (old);
#line 5369 "book.c"
	}
}


static void
book_class_init (BookClass * klass)
{
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	book_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	((BookClass *) klass)->finalize = book_finalize;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	g_type_class_add_private (klass, sizeof (BookPrivate));
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	book_signals[BOOK_PAGE_ADDED_SIGNAL] = g_signal_new ("page-added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	book_signals[BOOK_PAGE_REMOVED_SIGNAL] = g_signal_new ("page-removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	book_signals[BOOK_REORDERED_SIGNAL] = g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	book_signals[BOOK_CLEARED_SIGNAL] = g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	book_signals[BOOK_NEEDS_SAVING_CHANGED_SIGNAL] = g_signal_new ("needs-saving-changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	book_signals[BOOK_SAVING_SIGNAL] = g_signal_new ("saving", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 5395 "book.c"
}


static void
book_instance_init (Book * self)
{
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	self->priv = BOOK_GET_PRIVATE (self);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	self->ref_count = 1;
#line 5406 "book.c"
}


static void
book_finalize (Book * obj)
{
	Book * self;
	GList* _tmp0_;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_handlers_destroy (self);
#line 45 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 5421 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 45 "/home/bob/git/simple-scan/src/book.vala"
		page_collection = _tmp0_;
#line 45 "/home/bob/git/simple-scan/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 5429 "book.c"
			Page* _tmp1_;
			Page* page = NULL;
#line 45 "/home/bob/git/simple-scan/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 45 "/home/bob/git/simple-scan/src/book.vala"
			page = _tmp1_;
#line 5436 "book.c"
			{
				Page* _tmp2_;
				guint _tmp3_;
				Page* _tmp4_;
				guint _tmp5_;
#line 47 "/home/bob/git/simple-scan/src/book.vala"
				_tmp2_ = page;
#line 47 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 47 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 48 "/home/bob/git/simple-scan/src/book.vala"
				_tmp4_ = page;
#line 48 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 48 "/home/bob/git/simple-scan/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 45 "/home/bob/git/simple-scan/src/book.vala"
				_page_unref0 (page);
#line 5456 "book.c"
			}
		}
	}
#line 14 "/home/bob/git/simple-scan/src/book.vala"
	(self->priv->pages == NULL) ? NULL : (self->priv->pages = (_g_list_free__page_unref0_ (self->priv->pages), NULL));
#line 231 "/home/bob/git/simple-scan/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 5464 "book.c"
}


GType
book_get_type (void)
{
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer
book_ref (gpointer instance)
{
	Book * self;
	self = instance;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	return instance;
#line 5493 "book.c"
}


void
book_unref (gpointer instance)
{
	Book * self;
	self = instance;
#line 12 "/home/bob/git/simple-scan/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		BOOK_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/git/simple-scan/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5508 "book.c"
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 635 "/home/bob/git/simple-scan/src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 5518 "book.c"
}


PDFWriter*
pdf_writer_construct (GType object_type,
                      GFileOutputStream* stream)
{
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	guint* _tmp1_;
#line 633 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 633 "/home/bob/git/simple-scan/src/book.vala"
	self = (PDFWriter*) g_type_create_instance (object_type);
#line 635 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = _g_object_ref0 (stream);
#line 635 "/home/bob/git/simple-scan/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 635 "/home/bob/git/simple-scan/src/book.vala"
	self->priv->stream = _tmp0_;
#line 636 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = g_new0 (guint, 0);
#line 636 "/home/bob/git/simple-scan/src/book.vala"
	self->object_offsets = (g_free (self->object_offsets), NULL);
#line 636 "/home/bob/git/simple-scan/src/book.vala"
	self->object_offsets = _tmp1_;
#line 636 "/home/bob/git/simple-scan/src/book.vala"
	self->object_offsets_length1 = 0;
#line 636 "/home/bob/git/simple-scan/src/book.vala"
	self->_object_offsets_size_ = self->object_offsets_length1;
#line 633 "/home/bob/git/simple-scan/src/book.vala"
	return self;
#line 5551 "book.c"
}


PDFWriter*
pdf_writer_new (GFileOutputStream* stream)
{
#line 633 "/home/bob/git/simple-scan/src/book.vala"
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
#line 5560 "book.c"
}


void
pdf_writer_write (PDFWriter* self,
                  guint8* data,
                  int data_length1)
{
	gsize _tmp3_;
	GError * _inner_error_ = NULL;
#line 639 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 5573 "book.c"
	{
		GFileOutputStream* _tmp0_;
#line 643 "/home/bob/git/simple-scan/src/book.vala"
		_tmp0_ = self->priv->stream;
#line 643 "/home/bob/git/simple-scan/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, data, (gsize) data_length1, NULL, NULL, &_inner_error_);
#line 643 "/home/bob/git/simple-scan/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5582 "book.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 641 "/home/bob/git/simple-scan/src/book.vala"
		e = _inner_error_;
#line 641 "/home/bob/git/simple-scan/src/book.vala"
		_inner_error_ = NULL;
#line 647 "/home/bob/git/simple-scan/src/book.vala"
		_tmp1_ = e;
#line 647 "/home/bob/git/simple-scan/src/book.vala"
		_tmp2_ = _tmp1_->message;
#line 647 "/home/bob/git/simple-scan/src/book.vala"
		g_warning ("book.vala:647: Error writing PDF: %s", _tmp2_);
#line 641 "/home/bob/git/simple-scan/src/book.vala"
		_g_error_free0 (e);
#line 5604 "book.c"
	}
	__finally1:
#line 641 "/home/bob/git/simple-scan/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 641 "/home/bob/git/simple-scan/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 641 "/home/bob/git/simple-scan/src/book.vala"
		g_clear_error (&_inner_error_);
#line 641 "/home/bob/git/simple-scan/src/book.vala"
		return;
#line 5615 "book.c"
	}
#line 649 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3_ = self->offset;
#line 649 "/home/bob/git/simple-scan/src/book.vala"
	self->offset = _tmp3_ + data_length1;
#line 5621 "book.c"
}


static gchar*
string_to_utf8 (const gchar* self,
                int* result_length1)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1505 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1506 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1507 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1507 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1508 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 5679 "book.c"
	}
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1509 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 5685 "book.c"
}


void
pdf_writer_write_string (PDFWriter* self,
                         const gchar* text)
{
	gint _tmp0_;
	gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 652 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 652 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (text != NULL);
#line 654 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = string_to_utf8 (text, &_tmp0_);
#line 654 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = (guint8*) _tmp1_;
#line 654 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2__length1 = (_tmp0_ * sizeof (gchar)) / sizeof (guint8);
#line 654 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_write (self, _tmp2_, (_tmp0_ * sizeof (gchar)) / sizeof (guint8));
#line 654 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = (g_free (_tmp2_), NULL);
#line 5711 "book.c"
}


guint
pdf_writer_add_object (PDFWriter* self)
{
	guint result = 0U;
	guint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp1_;
	gint index = 0;
	guint* _tmp2_;
	gint _tmp2__length1;
	guint* _tmp3_;
	gint _tmp3__length1;
	guint _tmp4_;
#line 657 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 659 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->object_offsets;
#line 659 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0__length1 = self->object_offsets_length1;
#line 659 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = _tmp0__length1 + 1;
#line 659 "/home/bob/git/simple-scan/src/book.vala"
	self->object_offsets = g_renew (guint, self->object_offsets, _tmp0__length1 + 1);
#line 659 "/home/bob/git/simple-scan/src/book.vala"
	(_tmp1_ > self->object_offsets_length1) ? memset (self->object_offsets + self->object_offsets_length1, 0, sizeof (guint) * (_tmp1_ - self->object_offsets_length1)) : NULL;
#line 659 "/home/bob/git/simple-scan/src/book.vala"
	self->object_offsets_length1 = _tmp1_;
#line 659 "/home/bob/git/simple-scan/src/book.vala"
	self->_object_offsets_size_ = _tmp1_;
#line 660 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = self->object_offsets;
#line 660 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2__length1 = self->object_offsets_length1;
#line 660 "/home/bob/git/simple-scan/src/book.vala"
	index = _tmp2__length1 - 1;
#line 661 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3_ = self->object_offsets;
#line 661 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3__length1 = self->object_offsets_length1;
#line 661 "/home/bob/git/simple-scan/src/book.vala"
	_tmp3_[index] = (guint) 0;
#line 661 "/home/bob/git/simple-scan/src/book.vala"
	_tmp4_ = _tmp3_[index];
#line 662 "/home/bob/git/simple-scan/src/book.vala"
	result = (guint) (index + 1);
#line 662 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 5762 "book.c"
}


void
pdf_writer_start_object (PDFWriter* self,
                         guint index)
{
	guint* _tmp0_;
	gint _tmp0__length1;
	gsize _tmp1_;
	guint _tmp2_;
#line 665 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (self != NULL);
#line 667 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = self->object_offsets;
#line 667 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0__length1 = self->object_offsets_length1;
#line 667 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = self->offset;
#line 667 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_[index - 1] = (guint) _tmp1_;
#line 667 "/home/bob/git/simple-scan/src/book.vala"
	_tmp2_ = _tmp0_[index - 1];
#line 5786 "book.c"
}


static void
value_pdf_writer_init (GValue* value)
{
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 5795 "book.c"
}


static void
value_pdf_writer_free_value (GValue* value)
{
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (value->data[0].v_pointer) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		pdf_writer_unref (value->data[0].v_pointer);
#line 5806 "book.c"
	}
}


static void
value_pdf_writer_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
#line 5819 "book.c"
	} else {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5823 "book.c"
	}
}


static gpointer
value_pdf_writer_peek_pointer (const GValue* value)
{
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	return value->data[0].v_pointer;
#line 5833 "book.c"
}


static gchar*
value_pdf_writer_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5845 "book.c"
		PDFWriter * object;
		object = collect_values[0].v_pointer;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5852 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5856 "book.c"
		}
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = pdf_writer_ref (object);
#line 5860 "book.c"
	} else {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5864 "book.c"
	}
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	return NULL;
#line 5868 "book.c"
}


static gchar*
value_pdf_writer_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	PDFWriter ** object_p;
	object_p = collect_values[0].v_pointer;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (!object_p) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5884 "book.c"
	}
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = NULL;
#line 5890 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5894 "book.c"
	} else {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
#line 5898 "book.c"
	}
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	return NULL;
#line 5902 "book.c"
}


GParamSpec*
param_spec_pdf_writer (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecPDFWriter* spec;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5922 "book.c"
}


gpointer
value_get_pdf_writer (const GValue* value)
{
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	return value->data[0].v_pointer;
#line 5933 "book.c"
}


void
value_set_pdf_writer (GValue* value,
                      gpointer v_object)
{
	PDFWriter * old;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	old = value->data[0].v_pointer;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (v_object) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		pdf_writer_ref (value->data[0].v_pointer);
#line 5956 "book.c"
	} else {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5960 "book.c"
	}
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (old) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		pdf_writer_unref (old);
#line 5966 "book.c"
	}
}


void
value_take_pdf_writer (GValue* value,
                       gpointer v_object)
{
	PDFWriter * old;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	old = value->data[0].v_pointer;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (v_object) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5988 "book.c"
	} else {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5992 "book.c"
	}
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (old) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		pdf_writer_unref (old);
#line 5998 "book.c"
	}
}


static void
pdf_writer_class_init (PDFWriterClass * klass)
{
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	((PDFWriterClass *) klass)->finalize = pdf_writer_finalize;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
#line 6012 "book.c"
}


static void
pdf_writer_instance_init (PDFWriter * self)
{
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	self->priv = PDF_WRITER_GET_PRIVATE (self);
#line 629 "/home/bob/git/simple-scan/src/book.vala"
	self->offset = (gsize) 0;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	self->ref_count = 1;
#line 6025 "book.c"
}


static void
pdf_writer_finalize (PDFWriter * obj)
{
	PDFWriter * self;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_handlers_destroy (self);
#line 630 "/home/bob/git/simple-scan/src/book.vala"
	self->object_offsets = (g_free (self->object_offsets), NULL);
#line 631 "/home/bob/git/simple-scan/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 6041 "book.c"
}


GType
pdf_writer_get_type (void)
{
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer
pdf_writer_ref (gpointer instance)
{
	PDFWriter * self;
	self = instance;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	return instance;
#line 6070 "book.c"
}


void
pdf_writer_unref (gpointer instance)
{
	PDFWriter * self;
	self = instance;
#line 627 "/home/bob/git/simple-scan/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		PDF_WRITER_GET_CLASS (self)->finalize (self);
#line 627 "/home/bob/git/simple-scan/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6085 "book.c"
	}
}


static cairo_status_t
_ps_writer_write_cairo_data_cairo_write_func_t (gpointer self,
                                                guchar* data,
                                                int data_length1)
{
	cairo_status_t result;
	result = ps_writer_write_cairo_data ((PsWriter*) self, data, data_length1);
#line 679 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 6099 "book.c"
}


PsWriter*
ps_writer_construct (GType object_type,
                     GFileOutputStream* stream)
{
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	cairo_surface_t* _tmp1_;
#line 676 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 676 "/home/bob/git/simple-scan/src/book.vala"
	self = (PsWriter*) g_type_create_instance (object_type);
#line 678 "/home/bob/git/simple-scan/src/book.vala"
	_tmp0_ = _g_object_ref0 (stream);
#line 678 "/home/bob/git/simple-scan/src/book.vala"
	_g_object_unref0 (self->stream);
#line 678 "/home/bob/git/simple-scan/src/book.vala"
	self->stream = _tmp0_;
#line 679 "/home/bob/git/simple-scan/src/book.vala"
	_tmp1_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
#line 679 "/home/bob/git/simple-scan/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 679 "/home/bob/git/simple-scan/src/book.vala"
	self->surface = _tmp1_;
#line 676 "/home/bob/git/simple-scan/src/book.vala"
	return self;
#line 6128 "book.c"
}


PsWriter*
ps_writer_new (GFileOutputStream* stream)
{
#line 676 "/home/bob/git/simple-scan/src/book.vala"
	return ps_writer_construct (TYPE_PS_WRITER, stream);
#line 6137 "book.c"
}


static cairo_status_t
ps_writer_write_cairo_data (PsWriter* self,
                            guint8* data,
                            int data_length1)
{
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
#line 682 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 6150 "book.c"
	{
		GFileOutputStream* _tmp0_;
#line 686 "/home/bob/git/simple-scan/src/book.vala"
		_tmp0_ = self->stream;
#line 686 "/home/bob/git/simple-scan/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, data, (gsize) data_length1, NULL, NULL, &_inner_error_);
#line 686 "/home/bob/git/simple-scan/src/book.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6159 "book.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 684 "/home/bob/git/simple-scan/src/book.vala"
		e = _inner_error_;
#line 684 "/home/bob/git/simple-scan/src/book.vala"
		_inner_error_ = NULL;
#line 690 "/home/bob/git/simple-scan/src/book.vala"
		_tmp1_ = e;
#line 690 "/home/bob/git/simple-scan/src/book.vala"
		_tmp2_ = _tmp1_->message;
#line 690 "/home/bob/git/simple-scan/src/book.vala"
		g_warning ("book.vala:690: Error writing data: %s", _tmp2_);
#line 691 "/home/bob/git/simple-scan/src/book.vala"
		result = CAIRO_STATUS_WRITE_ERROR;
#line 691 "/home/bob/git/simple-scan/src/book.vala"
		_g_error_free0 (e);
#line 691 "/home/bob/git/simple-scan/src/book.vala"
		return result;
#line 6185 "book.c"
	}
	__finally2:
#line 684 "/home/bob/git/simple-scan/src/book.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 684 "/home/bob/git/simple-scan/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 684 "/home/bob/git/simple-scan/src/book.vala"
		g_clear_error (&_inner_error_);
#line 684 "/home/bob/git/simple-scan/src/book.vala"
		return 0;
#line 6196 "book.c"
	}
#line 694 "/home/bob/git/simple-scan/src/book.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 694 "/home/bob/git/simple-scan/src/book.vala"
	return result;
#line 6202 "book.c"
}


static void
value_ps_writer_init (GValue* value)
{
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 6211 "book.c"
}


static void
value_ps_writer_free_value (GValue* value)
{
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (value->data[0].v_pointer) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		ps_writer_unref (value->data[0].v_pointer);
#line 6222 "book.c"
	}
}


static void
value_ps_writer_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
#line 6235 "book.c"
	} else {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6239 "book.c"
	}
}


static gpointer
value_ps_writer_peek_pointer (const GValue* value)
{
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	return value->data[0].v_pointer;
#line 6249 "book.c"
}


static gchar*
value_ps_writer_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 6261 "book.c"
		PsWriter * object;
		object = collect_values[0].v_pointer;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6268 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6272 "book.c"
		}
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = ps_writer_ref (object);
#line 6276 "book.c"
	} else {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 6280 "book.c"
	}
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	return NULL;
#line 6284 "book.c"
}


static gchar*
value_ps_writer_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	PsWriter ** object_p;
	object_p = collect_values[0].v_pointer;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (!object_p) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6300 "book.c"
	}
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = NULL;
#line 6306 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 6310 "book.c"
	} else {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		*object_p = ps_writer_ref (value->data[0].v_pointer);
#line 6314 "book.c"
	}
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	return NULL;
#line 6318 "book.c"
}


GParamSpec*
param_spec_ps_writer (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecPsWriter* spec;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 6338 "book.c"
}


gpointer
value_get_ps_writer (const GValue* value)
{
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	return value->data[0].v_pointer;
#line 6349 "book.c"
}


void
value_set_ps_writer (GValue* value,
                     gpointer v_object)
{
	PsWriter * old;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	old = value->data[0].v_pointer;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (v_object) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		ps_writer_ref (value->data[0].v_pointer);
#line 6372 "book.c"
	} else {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 6376 "book.c"
	}
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (old) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		ps_writer_unref (old);
#line 6382 "book.c"
	}
}


void
value_take_ps_writer (GValue* value,
                      gpointer v_object)
{
	PsWriter * old;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	old = value->data[0].v_pointer;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (v_object) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 6404 "book.c"
	} else {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 6408 "book.c"
	}
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (old) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		ps_writer_unref (old);
#line 6414 "book.c"
	}
}


static void
ps_writer_class_init (PsWriterClass * klass)
{
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	ps_writer_parent_class = g_type_class_peek_parent (klass);
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	((PsWriterClass *) klass)->finalize = ps_writer_finalize;
#line 6426 "book.c"
}


static void
ps_writer_instance_init (PsWriter * self)
{
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	self->ref_count = 1;
#line 6435 "book.c"
}


static void
ps_writer_finalize (PsWriter * obj)
{
	PsWriter * self;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	g_signal_handlers_destroy (self);
#line 673 "/home/bob/git/simple-scan/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 674 "/home/bob/git/simple-scan/src/book.vala"
	_g_object_unref0 (self->stream);
#line 6451 "book.c"
}


GType
ps_writer_get_type (void)
{
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer
ps_writer_ref (gpointer instance)
{
	PsWriter * self;
	self = instance;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	return instance;
#line 6480 "book.c"
}


void
ps_writer_unref (gpointer instance)
{
	PsWriter * self;
	self = instance;
#line 671 "/home/bob/git/simple-scan/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		PS_WRITER_GET_CLASS (self)->finalize (self);
#line 671 "/home/bob/git/simple-scan/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6495 "book.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



