/* autosave-manager.c generated by valac 0.40.9, the Vala compiler
 * generated from autosave-manager.vala, do not modify */

/*
 * Copyright (C) 2011 Timo Kluck
 * Authors: Timo Kluck <tkluck@infty.nl>
 *          Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;
typedef struct _AutosaveManagerPrivate AutosaveManagerPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecAutosaveManager ParamSpecAutosaveManager;

struct _AutosaveManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AutosaveManagerPrivate * priv;
};

struct _AutosaveManagerClass {
	GTypeClass parent_class;
	void (*finalize) (AutosaveManager *self);
};

struct _AutosaveManagerPrivate {
	guint update_timeout;
	GHashTable* page_filenames;
	Book* book_;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ParamSpecAutosaveManager {
	GParamSpec parent_instance;
};


static gpointer autosave_manager_parent_class = NULL;
static gchar* autosave_manager_AUTOSAVE_DIR;
static gchar* autosave_manager_AUTOSAVE_DIR = NULL;
static gchar* autosave_manager_AUTOSAVE_FILENAME;
static gchar* autosave_manager_AUTOSAVE_FILENAME = NULL;
static gchar* autosave_manager_AUTOSAVE_PATH;
static gchar* autosave_manager_AUTOSAVE_PATH = NULL;

gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_autosave_manager (GValue* value,
                                 gpointer v_object);
void value_take_autosave_manager (GValue* value,
                                  gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_page (GValue* value,
                     gpointer v_object);
void value_take_page (GValue* value,
                      gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
void value_set_book (GValue* value,
                     gpointer v_object);
void value_take_book (GValue* value,
                      gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define AUTOSAVE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AUTOSAVE_MANAGER, AutosaveManagerPrivate))
AutosaveManager* autosave_manager_new (void);
AutosaveManager* autosave_manager_construct (GType object_type);
static void _page_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
void autosave_manager_load (AutosaveManager* self);
Book* autosave_manager_get_book (AutosaveManager* self);
void book_clear (Book* self);
static gchar* autosave_manager_get_value (AutosaveManager* self,
                                   GKeyFile* file,
                                   const gchar* group_name,
                                   const gchar* key,
                                   const gchar* _default_);
static gint autosave_manager_get_integer (AutosaveManager* self,
                                   GKeyFile* file,
                                   const gchar* group_name,
                                   const gchar* key,
                                   gint _default_);
GType scan_direction_get_type (void) G_GNUC_CONST;
static gboolean autosave_manager_get_boolean (AutosaveManager* self,
                                       GKeyFile* file,
                                       const gchar* group_name,
                                       const gchar* key,
                                       gboolean _default_);
Page* page_new_from_data (gint scan_width,
                          gint scan_height,
                          gint rowstride,
                          gint n_channels,
                          gint depth,
                          gint dpi,
                          ScanDirection scan_direction,
                          const gchar* color_profile,
                          guchar* pixels,
                          int pixels_length1,
                          gboolean has_crop,
                          const gchar* crop_name,
                          gint crop_x,
                          gint crop_y,
                          gint crop_width,
                          gint crop_height);
Page* page_construct_from_data (GType object_type,
                                gint scan_width,
                                gint scan_height,
                                gint rowstride,
                                gint n_channels,
                                gint depth,
                                gint dpi,
                                ScanDirection scan_direction,
                                const gchar* color_profile,
                                guchar* pixels,
                                int pixels_length1,
                                gboolean has_crop,
                                const gchar* crop_name,
                                gint crop_x,
                                gint crop_y,
                                gint crop_width,
                                gint crop_height);
void book_append_page (Book* self,
                       Page* page);
void autosave_manager_cleanup (AutosaveManager* self);
void autosave_manager_on_page_added (AutosaveManager* self,
                                     Page* page);
void autosave_manager_on_scan_finished (AutosaveManager* self,
                                        Page* page);
static void _autosave_manager_on_scan_finished_page_scan_finished (Page* _sender,
                                                            gpointer self);
void autosave_manager_on_changed (AutosaveManager* self);
static void _autosave_manager_on_changed_page_crop_changed (Page* _sender,
                                                     gpointer self);
void autosave_manager_on_page_removed (AutosaveManager* self,
                                       Page* page);
static void autosave_manager_save_pixels (AutosaveManager* self,
                                   Page* page);
static void autosave_manager_save (AutosaveManager* self,
                            gboolean do_timeout);
void autosave_manager_on_cleared (AutosaveManager* self);
static gboolean ___lambda4_ (AutosaveManager* self);
static void autosave_manager_real_save (AutosaveManager* self);
static gboolean ____lambda4__gsource_func (gpointer self);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self,
                     gint page_number);
gboolean page_get_has_data (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_rowstride (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_depth (Page* self);
gint page_get_dpi (Page* self);
ScanDirection page_get_scan_direction (Page* self);
const gchar* page_get_color_profile (Page* self);
gboolean page_get_has_crop (Page* self);
const gchar* page_get_crop_name (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
guchar* page_get_pixels (Page* self,
                         int* result_length1);
void autosave_manager_set_book (AutosaveManager* self,
                                Book* value);
static void _autosave_manager_on_page_added_book_page_added (Book* _sender,
                                                      Page* page,
                                                      gpointer self);
static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender,
                                                          Page* page,
                                                          gpointer self);
static void _autosave_manager_on_changed_book_reordered (Book* _sender,
                                                  gpointer self);
static void _autosave_manager_on_cleared_book_cleared (Book* _sender,
                                                gpointer self);
static void autosave_manager_finalize (AutosaveManager * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void
_page_unref0_ (gpointer var)
{
#line 59 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 271 "autosave-manager.c"
}


static void
_g_free0_ (gpointer var)
{
#line 59 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	var = (g_free (var), NULL);
#line 280 "autosave-manager.c"
}


AutosaveManager*
autosave_manager_construct (GType object_type)
{
	AutosaveManager* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
#line 57 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self = (AutosaveManager*) g_type_create_instance (object_type);
#line 59 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = g_direct_hash;
#line 59 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp1_ = g_direct_equal;
#line 59 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _page_unref0_, _g_free0_);
#line 59 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_hash_table_unref0 (self->priv->page_filenames);
#line 59 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->priv->page_filenames = _tmp2_;
#line 57 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return self;
#line 305 "autosave-manager.c"
}


AutosaveManager*
autosave_manager_new (void)
{
#line 57 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return autosave_manager_construct (TYPE_AUTOSAVE_MANAGER);
#line 314 "autosave-manager.c"
}


static gpointer
_page_ref0 (gpointer self)
{
#line 152 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return self ? page_ref (self) : NULL;
#line 323 "autosave-manager.c"
}


void
autosave_manager_load (AutosaveManager* self)
{
	Book* _tmp0_;
	Book* _tmp1_;
	GHashTable* _tmp2_;
	GKeyFile* file = NULL;
	GKeyFile* _tmp3_;
	gchar* pages = NULL;
	GKeyFile* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	GError * _inner_error_ = NULL;
#line 62 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:64: Loading autosave information");
#line 66 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = autosave_manager_get_book (self);
#line 66 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp1_ = _tmp0_;
#line 66 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	book_clear (_tmp1_);
#line 67 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp2_ = self->priv->page_filenames;
#line 67 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_hash_table_remove_all (_tmp2_);
#line 69 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp3_ = g_key_file_new ();
#line 69 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	file = _tmp3_;
#line 360 "autosave-manager.c"
	{
		GKeyFile* _tmp4_;
		const gchar* _tmp5_;
#line 72 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp4_ = file;
#line 72 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp5_ = autosave_manager_AUTOSAVE_PATH;
#line 72 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error_);
#line 72 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 372 "autosave-manager.c"
			goto __catch29_g_error;
		}
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
#line 70 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		e = _inner_error_;
#line 70 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 76 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp6_ = e;
#line 76 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (!g_error_matches (_tmp6_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
#line 389 "autosave-manager.c"
			GError* _tmp7_;
			const gchar* _tmp8_;
#line 77 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			_tmp7_ = e;
#line 77 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			_tmp8_ = _tmp7_->message;
#line 77 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			g_warning ("autosave-manager.vala:77: Could not load autosave information; not res" \
"toring any autosaves: %s", _tmp8_);
#line 398 "autosave-manager.c"
		}
#line 78 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 78 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 78 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return;
#line 406 "autosave-manager.c"
	}
	__finally29:
#line 70 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 70 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 70 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 70 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 70 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return;
#line 419 "autosave-manager.c"
	}
#line 80 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp9_ = file;
#line 80 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp10_ = autosave_manager_get_value (self, _tmp9_, "simple-scan", "pages", "");
#line 80 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	pages = _tmp10_;
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp11_ = pages;
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, " ", 0);
#line 431 "autosave-manager.c"
	{
		gchar** page_name_collection = NULL;
		gint page_name_collection_length1 = 0;
		gint _page_name_collection_size_ = 0;
		gint page_name_it = 0;
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		page_name_collection = _tmp13_;
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		page_name_collection_length1 = _vala_array_length (_tmp12_);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		for (page_name_it = 0; page_name_it < _vala_array_length (_tmp12_); page_name_it = page_name_it + 1) {
#line 443 "autosave-manager.c"
			gchar* _tmp14_;
			gchar* page_name = NULL;
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			_tmp14_ = g_strdup (page_name_collection[page_name_it]);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			page_name = _tmp14_;
#line 450 "autosave-manager.c"
			{
				const gchar* _tmp15_;
				gint scan_width = 0;
				GKeyFile* _tmp16_;
				const gchar* _tmp17_;
				gint scan_height = 0;
				GKeyFile* _tmp18_;
				const gchar* _tmp19_;
				gint rowstride = 0;
				GKeyFile* _tmp20_;
				const gchar* _tmp21_;
				gint n_channels = 0;
				GKeyFile* _tmp22_;
				const gchar* _tmp23_;
				gint depth = 0;
				GKeyFile* _tmp24_;
				const gchar* _tmp25_;
				gint dpi = 0;
				GKeyFile* _tmp26_;
				const gchar* _tmp27_;
				gchar* scan_direction_name = NULL;
				GKeyFile* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				ScanDirection scan_direction = 0;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				GQuark _tmp34_ = 0U;
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				static GQuark _tmp33_label0 = 0;
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				static GQuark _tmp33_label1 = 0;
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				static GQuark _tmp33_label2 = 0;
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				static GQuark _tmp33_label3 = 0;
#line 487 "autosave-manager.c"
				gchar* color_profile = NULL;
				GKeyFile* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* pixels_filename = NULL;
				GKeyFile* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gboolean has_crop = FALSE;
				GKeyFile* _tmp42_;
				const gchar* _tmp43_;
				gchar* crop_name = NULL;
				GKeyFile* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				const gchar* _tmp47_;
				gint crop_x = 0;
				GKeyFile* _tmp48_;
				const gchar* _tmp49_;
				gint crop_y = 0;
				GKeyFile* _tmp50_;
				const gchar* _tmp51_;
				gint crop_width = 0;
				GKeyFile* _tmp52_;
				const gchar* _tmp53_;
				gint crop_height = 0;
				GKeyFile* _tmp54_;
				const gchar* _tmp55_;
				guchar* pixels = NULL;
				gint pixels_length1;
				gint _pixels_size_;
				const gchar* _tmp56_;
				Page* page = NULL;
				gint _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
				ScanDirection _tmp71_;
				const gchar* _tmp72_;
				guchar* _tmp73_;
				gint _tmp73__length1;
				gboolean _tmp74_;
				const gchar* _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				Page* _tmp80_;
				GHashTable* _tmp81_;
				Page* _tmp82_;
				Page* _tmp83_;
				const gchar* _tmp84_;
				gchar* _tmp85_;
				Book* _tmp86_;
				Book* _tmp87_;
				Page* _tmp88_;
#line 83 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp15_ = page_name;
#line 83 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_debug ("autosave-manager.vala:83: Loading automatically saved page %s", _tmp15_);
#line 85 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp16_ = file;
#line 85 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp17_ = page_name;
#line 85 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				scan_width = autosave_manager_get_integer (self, _tmp16_, _tmp17_, "scan-width", 0);
#line 86 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp18_ = file;
#line 86 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp19_ = page_name;
#line 86 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				scan_height = autosave_manager_get_integer (self, _tmp18_, _tmp19_, "scan-height", 0);
#line 87 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp20_ = file;
#line 87 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp21_ = page_name;
#line 87 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				rowstride = autosave_manager_get_integer (self, _tmp20_, _tmp21_, "rowstride", 0);
#line 88 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp22_ = file;
#line 88 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp23_ = page_name;
#line 88 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				n_channels = autosave_manager_get_integer (self, _tmp22_, _tmp23_, "n-channels", 0);
#line 89 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp24_ = file;
#line 89 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp25_ = page_name;
#line 89 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				depth = autosave_manager_get_integer (self, _tmp24_, _tmp25_, "depth", 0);
#line 90 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp26_ = file;
#line 90 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp27_ = page_name;
#line 90 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				dpi = autosave_manager_get_integer (self, _tmp26_, _tmp27_, "dpi", 0);
#line 91 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp28_ = file;
#line 91 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp29_ = page_name;
#line 91 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp30_ = autosave_manager_get_value (self, _tmp28_, _tmp29_, "scan-direction", "");
#line 91 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				scan_direction_name = _tmp30_;
#line 92 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp31_ = scan_direction_name;
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp32_ = _tmp31_;
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp34_ = (NULL == _tmp32_) ? 0 : g_quark_from_string (_tmp32_);
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (_tmp34_ == ((0 != _tmp33_label0) ? _tmp33_label0 : (_tmp33_label0 = g_quark_from_static_string ("TOP_TO_BOTTOM")))) {
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					switch (0) {
#line 607 "autosave-manager.c"
						default:
						{
#line 96 "/home/bob/git/simple-scan/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 97 "/home/bob/git/simple-scan/src/autosave-manager.vala"
							break;
#line 614 "autosave-manager.c"
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label1) ? _tmp33_label1 : (_tmp33_label1 = g_quark_from_static_string ("LEFT_TO_RIGHT")))) {
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					switch (0) {
#line 620 "autosave-manager.c"
						default:
						{
#line 99 "/home/bob/git/simple-scan/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 100 "/home/bob/git/simple-scan/src/autosave-manager.vala"
							break;
#line 627 "autosave-manager.c"
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label2) ? _tmp33_label2 : (_tmp33_label2 = g_quark_from_static_string ("BOTTOM_TO_TOP")))) {
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					switch (0) {
#line 633 "autosave-manager.c"
						default:
						{
#line 102 "/home/bob/git/simple-scan/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 103 "/home/bob/git/simple-scan/src/autosave-manager.vala"
							break;
#line 640 "autosave-manager.c"
						}
					}
				} else if (_tmp34_ == ((0 != _tmp33_label3) ? _tmp33_label3 : (_tmp33_label3 = g_quark_from_static_string ("RIGHT_TO_LEFT")))) {
#line 93 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					switch (0) {
#line 646 "autosave-manager.c"
						default:
						{
#line 105 "/home/bob/git/simple-scan/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 106 "/home/bob/git/simple-scan/src/autosave-manager.vala"
							break;
#line 653 "autosave-manager.c"
						}
					}
				}
#line 108 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp35_ = file;
#line 108 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp36_ = page_name;
#line 108 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp37_ = autosave_manager_get_value (self, _tmp35_, _tmp36_, "color-profile", "");
#line 108 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				color_profile = _tmp37_;
#line 109 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp38_ = color_profile;
#line 109 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp38_, "") == 0) {
#line 110 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_g_free0 (color_profile);
#line 110 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					color_profile = NULL;
#line 673 "autosave-manager.c"
				}
#line 111 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp39_ = file;
#line 111 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp40_ = page_name;
#line 111 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp41_ = autosave_manager_get_value (self, _tmp39_, _tmp40_, "pixels-filename", "");
#line 111 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				pixels_filename = _tmp41_;
#line 112 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp42_ = file;
#line 112 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp43_ = page_name;
#line 112 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				has_crop = autosave_manager_get_boolean (self, _tmp42_, _tmp43_, "has-crop", FALSE);
#line 113 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp44_ = file;
#line 113 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp45_ = page_name;
#line 113 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp46_ = autosave_manager_get_value (self, _tmp44_, _tmp45_, "crop-name", "");
#line 113 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				crop_name = _tmp46_;
#line 114 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp47_ = crop_name;
#line 114 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp47_, "") == 0) {
#line 115 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_g_free0 (crop_name);
#line 115 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					crop_name = NULL;
#line 705 "autosave-manager.c"
				}
#line 116 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp48_ = file;
#line 116 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp49_ = page_name;
#line 116 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				crop_x = autosave_manager_get_integer (self, _tmp48_, _tmp49_, "crop-x", 0);
#line 117 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp50_ = file;
#line 117 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp51_ = page_name;
#line 117 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				crop_y = autosave_manager_get_integer (self, _tmp50_, _tmp51_, "crop-y", 0);
#line 118 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp52_ = file;
#line 118 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp53_ = page_name;
#line 118 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				crop_width = autosave_manager_get_integer (self, _tmp52_, _tmp53_, "crop-width", 0);
#line 119 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp54_ = file;
#line 119 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp55_ = page_name;
#line 119 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				crop_height = autosave_manager_get_integer (self, _tmp54_, _tmp55_, "crop-height", 0);
#line 121 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				pixels = NULL;
#line 121 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				pixels_length1 = 0;
#line 121 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_pixels_size_ = pixels_length1;
#line 122 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp56_ = pixels_filename;
#line 122 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp56_, "") != 0) {
#line 741 "autosave-manager.c"
					gchar* path = NULL;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					gchar* _tmp59_;
					GFile* f = NULL;
					const gchar* _tmp60_;
					GFile* _tmp61_;
#line 124 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp57_ = autosave_manager_AUTOSAVE_DIR;
#line 124 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp58_ = pixels_filename;
#line 124 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp59_ = g_build_filename (_tmp57_, _tmp58_, NULL);
#line 124 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					path = _tmp59_;
#line 125 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp60_ = path;
#line 125 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp61_ = g_file_new_for_path (_tmp60_);
#line 125 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					f = _tmp61_;
#line 763 "autosave-manager.c"
					{
						GFile* _tmp62_;
						guint8* _tmp63_ = NULL;
						gsize _tmp64_;
#line 128 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp62_ = f;
#line 128 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						g_file_load_contents (_tmp62_, NULL, &_tmp63_, &_tmp64_, NULL, &_inner_error_);
#line 128 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 128 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						pixels = _tmp63_;
#line 128 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						pixels_length1 = _tmp64_;
#line 128 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_pixels_size_ = pixels_length1;
#line 128 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 782 "autosave-manager.c"
							goto __catch30_g_error;
						}
					}
					goto __finally30;
					__catch30_g_error:
					{
						GError* e = NULL;
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						e = _inner_error_;
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_inner_error_ = NULL;
#line 132 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						g_warning ("autosave-manager.vala:132: Failed to load pixel information");
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_error_free0 (e);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_object_unref0 (f);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (path);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (crop_name);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (pixels_filename);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (color_profile);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (scan_direction_name);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (page_name);
#line 133 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						continue;
#line 816 "autosave-manager.c"
					}
					__finally30:
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_object_unref0 (f);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (path);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (crop_name);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (pixels_filename);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (color_profile);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (scan_direction_name);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (page_name);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_free0 (pages);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_g_key_file_unref0 (file);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						g_clear_error (&_inner_error_);
#line 126 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						return;
#line 849 "autosave-manager.c"
					}
#line 122 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_g_object_unref0 (f);
#line 122 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_g_free0 (path);
#line 855 "autosave-manager.c"
				}
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp65_ = scan_width;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp66_ = scan_height;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp67_ = rowstride;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp68_ = n_channels;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp69_ = depth;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp70_ = dpi;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp71_ = scan_direction;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp72_ = color_profile;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp73_ = pixels;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp73__length1 = pixels_length1;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp74_ = has_crop;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp75_ = crop_name;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp76_ = crop_x;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp77_ = crop_y;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp78_ = crop_width;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp79_ = crop_height;
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp80_ = page_new_from_data (_tmp65_, _tmp66_, _tmp67_, _tmp68_, _tmp69_, _tmp70_, _tmp71_, _tmp72_, _tmp73_, _tmp73__length1, _tmp74_, _tmp75_, _tmp76_, _tmp77_, _tmp78_, _tmp79_);
#line 137 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				page = _tmp80_;
#line 152 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp81_ = self->priv->page_filenames;
#line 152 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp82_ = page;
#line 152 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp83_ = _page_ref0 (_tmp82_);
#line 152 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp84_ = pixels_filename;
#line 152 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp85_ = g_strdup (_tmp84_);
#line 152 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_hash_table_insert (_tmp81_, _tmp83_, _tmp85_);
#line 153 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp86_ = autosave_manager_get_book (self);
#line 153 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp87_ = _tmp86_;
#line 153 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp88_ = page;
#line 153 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				book_append_page (_tmp87_, _tmp88_);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_page_unref0 (page);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				pixels = (g_free (pixels), NULL);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_g_free0 (crop_name);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_g_free0 (pixels_filename);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_g_free0 (color_profile);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_g_free0 (scan_direction_name);
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_g_free0 (page_name);
#line 927 "autosave-manager.c"
			}
		}
#line 81 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 932 "autosave-manager.c"
	}
#line 62 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_free0 (pages);
#line 62 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_key_file_unref0 (file);
#line 938 "autosave-manager.c"
}


static gchar*
autosave_manager_get_value (AutosaveManager* self,
                            GKeyFile* file,
                            const gchar* group_name,
                            const gchar* key,
                            const gchar* _default_)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 157 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 157 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 157 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, NULL);
#line 157 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 157 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (_default_ != NULL, NULL);
#line 961 "autosave-manager.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
#line 161 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp1_ = g_key_file_get_value (file, group_name, key, &_inner_error_);
#line 161 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp0_ = _tmp1_;
#line 161 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 972 "autosave-manager.c"
			goto __catch31_g_error;
		}
#line 161 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp2_ = _tmp0_;
#line 161 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp0_ = NULL;
#line 161 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		result = _tmp2_;
#line 161 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_free0 (_tmp0_);
#line 161 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return result;
#line 985 "autosave-manager.c"
	}
	goto __finally31;
	__catch31_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
#line 159 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		e = _inner_error_;
#line 159 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 165 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp3_ = g_strdup (_default_);
#line 165 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		result = _tmp3_;
#line 165 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 165 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return result;
#line 1004 "autosave-manager.c"
	}
	__finally31:
#line 159 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 159 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 159 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return NULL;
#line 1013 "autosave-manager.c"
}


static gint
autosave_manager_get_integer (AutosaveManager* self,
                              GKeyFile* file,
                              const gchar* group_name,
                              const gchar* key,
                              gint _default_)
{
	gint result = 0;
	gint _tmp1_ = -1;
	GError * _inner_error_ = NULL;
#line 169 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 169 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, 0);
#line 169 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, 0);
#line 169 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 1035 "autosave-manager.c"
	{
		gint _tmp0_ = 0;
#line 173 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp0_ = g_key_file_get_integer (file, group_name, key, &_inner_error_);
#line 173 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1042 "autosave-manager.c"
			goto __catch32_g_error;
		}
#line 173 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		result = _tmp0_;
#line 173 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return result;
#line 1049 "autosave-manager.c"
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* e = NULL;
#line 171 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		e = _inner_error_;
#line 171 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 177 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		result = _default_;
#line 177 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 177 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return result;
#line 1065 "autosave-manager.c"
	}
	__finally32:
#line 171 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 171 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 171 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return _tmp1_;
#line 1074 "autosave-manager.c"
}


static gboolean
autosave_manager_get_boolean (AutosaveManager* self,
                              GKeyFile* file,
                              const gchar* group_name,
                              const gchar* key,
                              gboolean _default_)
{
	gboolean result = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 181 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 181 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 181 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, FALSE);
#line 181 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1096 "autosave-manager.c"
	{
		gboolean _tmp0_ = FALSE;
#line 185 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp0_ = g_key_file_get_boolean (file, group_name, key, &_inner_error_);
#line 185 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1103 "autosave-manager.c"
			goto __catch33_g_error;
		}
#line 185 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		result = _tmp0_;
#line 185 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return result;
#line 1110 "autosave-manager.c"
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* e = NULL;
#line 183 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		e = _inner_error_;
#line 183 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 189 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		result = _default_;
#line 189 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 189 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return result;
#line 1126 "autosave-manager.c"
	}
	__finally33:
#line 183 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 183 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 183 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return _tmp1_;
#line 1135 "autosave-manager.c"
}


void
autosave_manager_cleanup (AutosaveManager* self)
{
	guint _tmp0_;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
#line 193 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:195: Deleting autosave records");
#line 197 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = self->priv->update_timeout;
#line 197 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 1153 "autosave-manager.c"
		guint _tmp1_;
#line 198 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp1_ = self->priv->update_timeout;
#line 198 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_source_remove (_tmp1_);
#line 1159 "autosave-manager.c"
	}
#line 199 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 1163 "autosave-manager.c"
	{
		GDir* _tmp2_ = NULL;
		const gchar* _tmp3_;
		GDir* _tmp4_;
		GDir* _tmp5_;
#line 204 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp3_ = autosave_manager_AUTOSAVE_DIR;
#line 204 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error_);
#line 204 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp2_ = _tmp4_;
#line 204 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1177 "autosave-manager.c"
			goto __catch34_g_error;
		}
#line 204 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp5_ = _tmp2_;
#line 204 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp2_ = NULL;
#line 204 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 204 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		dir = _tmp5_;
#line 202 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_dir_close0 (_tmp2_);
#line 1190 "autosave-manager.c"
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 202 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		e = _inner_error_;
#line 202 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 208 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp6_ = e;
#line 208 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp7_ = _tmp6_->message;
#line 208 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:208: Failed to delete autosaves: %s", _tmp7_);
#line 209 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 209 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 209 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return;
#line 1214 "autosave-manager.c"
	}
	__finally34:
#line 202 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 202 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 202 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 202 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 202 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return;
#line 1227 "autosave-manager.c"
	}
#line 212 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	while (TRUE) {
#line 1231 "autosave-manager.c"
		gchar* filename = NULL;
		GDir* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* path = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
#line 214 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp8_ = dir;
#line 214 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp9_ = g_dir_read_name (_tmp8_);
#line 214 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 214 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		filename = _tmp10_;
#line 215 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp11_ = filename;
#line 215 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (_tmp11_ == NULL) {
#line 216 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			_g_free0 (filename);
#line 216 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			break;
#line 1258 "autosave-manager.c"
		}
#line 217 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp12_ = autosave_manager_AUTOSAVE_DIR;
#line 217 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp13_ = filename;
#line 217 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp14_ = g_build_filename (_tmp12_, _tmp13_, NULL);
#line 217 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		path = _tmp14_;
#line 218 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp15_ = path;
#line 218 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_unlink (_tmp15_);
#line 212 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_free0 (path);
#line 212 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_free0 (filename);
#line 1276 "autosave-manager.c"
	}
#line 193 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_dir_close0 (dir);
#line 1280 "autosave-manager.c"
}


static void
_autosave_manager_on_scan_finished_page_scan_finished (Page* _sender,
                                                       gpointer self)
{
#line 224 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_on_scan_finished ((AutosaveManager*) self, _sender);
#line 1290 "autosave-manager.c"
}


static void
_autosave_manager_on_changed_page_crop_changed (Page* _sender,
                                                gpointer self)
{
#line 225 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_on_changed ((AutosaveManager*) self);
#line 1300 "autosave-manager.c"
}


void
autosave_manager_on_page_added (AutosaveManager* self,
                                Page* page)
{
#line 222 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 222 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 224 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_connect (page, "scan-finished", (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
#line 225 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_connect (page, "crop-changed", (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
#line 1316 "autosave-manager.c"
}


void
autosave_manager_on_page_removed (AutosaveManager* self,
                                  Page* page)
{
	guint _tmp0_;
	guint _tmp1_;
	gchar* filename = NULL;
	GHashTable* _tmp2_;
	gconstpointer _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GHashTable* _tmp7_;
#line 228 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 228 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 230 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_parse_name ("scan-finished", TYPE_PAGE, &_tmp0_, NULL, FALSE);
#line 230 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (page, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
#line 231 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 231 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (page, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
#line 233 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp2_ = self->priv->page_filenames;
#line 233 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp3_ = g_hash_table_lookup (_tmp2_, page);
#line 233 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 233 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	filename = _tmp4_;
#line 234 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp5_ = filename;
#line 234 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (_tmp5_ != NULL) {
#line 1356 "autosave-manager.c"
		const gchar* _tmp6_;
#line 235 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp6_ = filename;
#line 235 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_unlink (_tmp6_);
#line 1362 "autosave-manager.c"
	}
#line 236 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp7_ = self->priv->page_filenames;
#line 236 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_hash_table_remove (_tmp7_, page);
#line 228 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_free0 (filename);
#line 1370 "autosave-manager.c"
}


void
autosave_manager_on_scan_finished (AutosaveManager* self,
                                   Page* page)
{
#line 239 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 239 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 241 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_save_pixels (self, page);
#line 242 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_save (self, FALSE);
#line 1386 "autosave-manager.c"
}


void
autosave_manager_on_changed (AutosaveManager* self)
{
#line 245 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 247 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_save (self, TRUE);
#line 1397 "autosave-manager.c"
}


void
autosave_manager_on_cleared (AutosaveManager* self)
{
	GHashTable* _tmp0_;
#line 250 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 252 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = self->priv->page_filenames;
#line 252 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_hash_table_remove_all (_tmp0_);
#line 253 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_save (self, TRUE);
#line 1413 "autosave-manager.c"
}


static gboolean
___lambda4_ (AutosaveManager* self)
{
	gboolean result = FALSE;
#line 270 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_real_save (self);
#line 271 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 272 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	result = FALSE;
#line 272 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return result;
#line 1429 "autosave-manager.c"
}


static gboolean
____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda4_ ((AutosaveManager*) self);
#line 268 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return result;
#line 1440 "autosave-manager.c"
}


static void
autosave_manager_save (AutosaveManager* self,
                       gboolean do_timeout)
{
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	guint _tmp2_;
#line 256 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 258 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp1_ = self->priv->update_timeout;
#line 258 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 258 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp0_ = do_timeout;
#line 1459 "autosave-manager.c"
	} else {
#line 258 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp0_ = FALSE;
#line 1463 "autosave-manager.c"
	}
#line 258 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (_tmp0_) {
#line 259 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_debug ("autosave-manager.vala:259: Waiting to autosave...");
#line 1469 "autosave-manager.c"
	}
#line 262 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp2_ = self->priv->update_timeout;
#line 262 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (_tmp2_ > ((guint) 0)) {
#line 1475 "autosave-manager.c"
		guint _tmp3_;
#line 263 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp3_ = self->priv->update_timeout;
#line 263 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_source_remove (_tmp3_);
#line 1481 "autosave-manager.c"
	}
#line 264 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 266 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (do_timeout) {
#line 268 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		self->priv->update_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda4__gsource_func, autosave_manager_ref (self), autosave_manager_unref);
#line 1489 "autosave-manager.c"
	} else {
#line 276 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		autosave_manager_real_save (self);
#line 1493 "autosave-manager.c"
	}
}


static void
autosave_manager_real_save (AutosaveManager* self)
{
	GKeyFile* file = NULL;
	GKeyFile* _tmp0_;
	gchar* page_names = NULL;
	gchar* _tmp1_;
	GKeyFile* _tmp109_;
	const gchar* _tmp110_;
	GError * _inner_error_ = NULL;
#line 279 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 281 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:281: Autosaving book information");
#line 283 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = g_key_file_new ();
#line 283 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	file = _tmp0_;
#line 284 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp1_ = g_strdup ("");
#line 284 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	page_names = _tmp1_;
#line 1520 "autosave-manager.c"
	{
		gint i = 0;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		i = 0;
#line 1525 "autosave-manager.c"
		{
			gboolean _tmp2_ = FALSE;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			_tmp2_ = TRUE;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			while (TRUE) {
#line 1532 "autosave-manager.c"
				gint _tmp4_;
				Book* _tmp5_;
				Book* _tmp6_;
				guint _tmp7_;
				guint _tmp8_;
				Page* page = NULL;
				Book* _tmp9_;
				Book* _tmp10_;
				gint _tmp11_;
				Page* _tmp12_;
				Page* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp15_;
				gchar* page_name = NULL;
				gint _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				GKeyFile* _tmp25_;
				const gchar* _tmp26_;
				Page* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				GKeyFile* _tmp30_;
				const gchar* _tmp31_;
				Page* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				GKeyFile* _tmp35_;
				const gchar* _tmp36_;
				Page* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				GKeyFile* _tmp40_;
				const gchar* _tmp41_;
				Page* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				GKeyFile* _tmp45_;
				const gchar* _tmp46_;
				Page* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GKeyFile* _tmp50_;
				const gchar* _tmp51_;
				Page* _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				Page* _tmp55_;
				ScanDirection _tmp56_;
				ScanDirection _tmp57_;
				const gchar* _tmp66_ = NULL;
				Page* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				GKeyFile* _tmp70_;
				const gchar* _tmp71_;
				const gchar* _tmp72_ = NULL;
				GHashTable* _tmp73_;
				Page* _tmp74_;
				gconstpointer _tmp75_;
				GKeyFile* _tmp76_;
				const gchar* _tmp77_;
				GKeyFile* _tmp78_;
				const gchar* _tmp79_;
				Page* _tmp80_;
				gboolean _tmp81_;
				gboolean _tmp82_;
				const gchar* _tmp83_ = NULL;
				Page* _tmp84_;
				const gchar* _tmp85_;
				const gchar* _tmp86_;
				GKeyFile* _tmp87_;
				const gchar* _tmp88_;
				GKeyFile* _tmp89_;
				const gchar* _tmp90_;
				Page* _tmp91_;
				gint _tmp92_;
				gint _tmp93_;
				GKeyFile* _tmp94_;
				const gchar* _tmp95_;
				Page* _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				GKeyFile* _tmp99_;
				const gchar* _tmp100_;
				Page* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				GKeyFile* _tmp104_;
				const gchar* _tmp105_;
				Page* _tmp106_;
				gint _tmp107_;
				gint _tmp108_;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (!_tmp2_) {
#line 1632 "autosave-manager.c"
					gint _tmp3_;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp3_ = i;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					i = _tmp3_ + 1;
#line 1638 "autosave-manager.c"
				}
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp2_ = FALSE;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp4_ = i;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp5_ = autosave_manager_get_book (self);
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp6_ = _tmp5_;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp7_ = book_get_n_pages (_tmp6_);
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp8_ = _tmp7_;
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (!(((guint) _tmp4_) < _tmp8_)) {
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					break;
#line 1656 "autosave-manager.c"
				}
#line 287 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp9_ = autosave_manager_get_book (self);
#line 287 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp10_ = _tmp9_;
#line 287 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp11_ = i;
#line 287 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp12_ = book_get_page (_tmp10_, _tmp11_);
#line 287 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				page = _tmp12_;
#line 290 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp13_ = page;
#line 290 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp14_ = page_get_has_data (_tmp13_);
#line 290 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp15_ = _tmp14_;
#line 290 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (!_tmp15_) {
#line 291 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_page_unref0 (page);
#line 291 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					continue;
#line 1680 "autosave-manager.c"
				}
#line 293 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp16_ = i;
#line 293 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp17_ = g_strdup_printf ("page-%d", _tmp16_);
#line 293 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				page_name = _tmp17_;
#line 294 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp18_ = page_names;
#line 294 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp18_, "") != 0) {
#line 1692 "autosave-manager.c"
					const gchar* _tmp19_;
					gchar* _tmp20_;
#line 295 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp19_ = page_names;
#line 295 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp20_ = g_strconcat (_tmp19_, " ", NULL);
#line 295 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_g_free0 (page_names);
#line 295 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					page_names = _tmp20_;
#line 1703 "autosave-manager.c"
				}
#line 296 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp21_ = page_names;
#line 296 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp22_ = page_name;
#line 296 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp23_ = g_strconcat (_tmp21_, _tmp22_, NULL);
#line 296 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_g_free0 (page_names);
#line 296 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				page_names = _tmp23_;
#line 298 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp24_ = page_name;
#line 298 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_debug ("autosave-manager.vala:298: Autosaving page %s", _tmp24_);
#line 300 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp25_ = file;
#line 300 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp26_ = page_name;
#line 300 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp27_ = page;
#line 300 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp28_ = page_get_scan_width (_tmp27_);
#line 300 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp29_ = _tmp28_;
#line 300 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp25_, _tmp26_, "scan-width", _tmp29_);
#line 301 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp30_ = file;
#line 301 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp31_ = page_name;
#line 301 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp32_ = page;
#line 301 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp33_ = page_get_scan_height (_tmp32_);
#line 301 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp34_ = _tmp33_;
#line 301 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp30_, _tmp31_, "scan-height", _tmp34_);
#line 302 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp35_ = file;
#line 302 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp36_ = page_name;
#line 302 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp37_ = page;
#line 302 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp38_ = page_get_rowstride (_tmp37_);
#line 302 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp39_ = _tmp38_;
#line 302 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp35_, _tmp36_, "rowstride", _tmp39_);
#line 303 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp40_ = file;
#line 303 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp41_ = page_name;
#line 303 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp42_ = page;
#line 303 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp43_ = page_get_n_channels (_tmp42_);
#line 303 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp44_ = _tmp43_;
#line 303 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp40_, _tmp41_, "n-channels", _tmp44_);
#line 304 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp45_ = file;
#line 304 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp46_ = page_name;
#line 304 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp47_ = page;
#line 304 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp48_ = page_get_depth (_tmp47_);
#line 304 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp49_ = _tmp48_;
#line 304 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp45_, _tmp46_, "depth", _tmp49_);
#line 305 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp50_ = file;
#line 305 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp51_ = page_name;
#line 305 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp52_ = page;
#line 305 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp53_ = page_get_dpi (_tmp52_);
#line 305 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp54_ = _tmp53_;
#line 305 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp50_, _tmp51_, "dpi", _tmp54_);
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp55_ = page;
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp56_ = page_get_scan_direction (_tmp55_);
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp57_ = _tmp56_;
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				switch (_tmp57_) {
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1801 "autosave-manager.c"
					{
						GKeyFile* _tmp58_;
						const gchar* _tmp59_;
#line 309 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp58_ = file;
#line 309 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp59_ = page_name;
#line 309 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						g_key_file_set_value (_tmp58_, _tmp59_, "scan-direction", "TOP_TO_BOTTOM");
#line 310 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						break;
#line 1813 "autosave-manager.c"
					}
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1817 "autosave-manager.c"
					{
						GKeyFile* _tmp60_;
						const gchar* _tmp61_;
#line 312 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp60_ = file;
#line 312 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp61_ = page_name;
#line 312 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						g_key_file_set_value (_tmp60_, _tmp61_, "scan-direction", "LEFT_TO_RIGHT");
#line 313 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						break;
#line 1829 "autosave-manager.c"
					}
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1833 "autosave-manager.c"
					{
						GKeyFile* _tmp62_;
						const gchar* _tmp63_;
#line 315 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp62_ = file;
#line 315 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp63_ = page_name;
#line 315 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						g_key_file_set_value (_tmp62_, _tmp63_, "scan-direction", "BOTTOM_TO_TOP");
#line 316 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						break;
#line 1845 "autosave-manager.c"
					}
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1849 "autosave-manager.c"
					{
						GKeyFile* _tmp64_;
						const gchar* _tmp65_;
#line 318 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp64_ = file;
#line 318 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp65_ = page_name;
#line 318 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						g_key_file_set_value (_tmp64_, _tmp65_, "scan-direction", "RIGHT_TO_LEFT");
#line 319 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						break;
#line 1861 "autosave-manager.c"
					}
					default:
#line 306 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					break;
#line 1866 "autosave-manager.c"
				}
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp67_ = page;
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp68_ = page_get_color_profile (_tmp67_);
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp69_ = _tmp68_;
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp66_ = _tmp69_;
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (_tmp66_ == NULL) {
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp66_ = "";
#line 1880 "autosave-manager.c"
				}
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp70_ = file;
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp71_ = page_name;
#line 321 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_value (_tmp70_, _tmp71_, "color-profile", _tmp66_);
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp73_ = self->priv->page_filenames;
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp74_ = page;
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp75_ = g_hash_table_lookup (_tmp73_, _tmp74_);
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp72_ = (const gchar*) _tmp75_;
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (_tmp72_ == NULL) {
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp72_ = "";
#line 1900 "autosave-manager.c"
				}
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp76_ = file;
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp77_ = page_name;
#line 322 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_value (_tmp76_, _tmp77_, "pixels-filename", _tmp72_);
#line 323 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp78_ = file;
#line 323 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp79_ = page_name;
#line 323 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp80_ = page;
#line 323 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp81_ = page_get_has_crop (_tmp80_);
#line 323 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp82_ = _tmp81_;
#line 323 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_boolean (_tmp78_, _tmp79_, "has-crop", _tmp82_);
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp84_ = page;
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp85_ = page_get_crop_name (_tmp84_);
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp86_ = _tmp85_;
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp83_ = _tmp86_;
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (_tmp83_ == NULL) {
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp83_ = "";
#line 1932 "autosave-manager.c"
				}
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp87_ = file;
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp88_ = page_name;
#line 324 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_value (_tmp87_, _tmp88_, "crop-name", _tmp83_);
#line 325 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp89_ = file;
#line 325 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp90_ = page_name;
#line 325 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp91_ = page;
#line 325 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp92_ = page_get_crop_x (_tmp91_);
#line 325 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp93_ = _tmp92_;
#line 325 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp89_, _tmp90_, "crop-x", _tmp93_);
#line 326 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp94_ = file;
#line 326 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp95_ = page_name;
#line 326 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp96_ = page;
#line 326 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp97_ = page_get_crop_y (_tmp96_);
#line 326 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp98_ = _tmp97_;
#line 326 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp94_, _tmp95_, "crop-y", _tmp98_);
#line 327 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp99_ = file;
#line 327 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp100_ = page_name;
#line 327 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp101_ = page;
#line 327 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp102_ = page_get_crop_width (_tmp101_);
#line 327 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp103_ = _tmp102_;
#line 327 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp99_, _tmp100_, "crop-width", _tmp103_);
#line 328 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp104_ = file;
#line 328 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp105_ = page_name;
#line 328 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp106_ = page;
#line 328 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp107_ = page_get_crop_height (_tmp106_);
#line 328 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp108_ = _tmp107_;
#line 328 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp104_, _tmp105_, "crop-height", _tmp108_);
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_g_free0 (page_name);
#line 285 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_page_unref0 (page);
#line 1992 "autosave-manager.c"
			}
		}
	}
#line 330 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp109_ = file;
#line 330 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp110_ = page_names;
#line 330 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_key_file_set_value (_tmp109_, "simple-scan", "pages", _tmp110_);
#line 2002 "autosave-manager.c"
	{
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		GKeyFile* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
#line 334 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp111_ = autosave_manager_AUTOSAVE_DIR;
#line 334 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_mkdir_with_parents (_tmp111_, 0777);
#line 335 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp112_ = autosave_manager_AUTOSAVE_PATH;
#line 335 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp113_ = file;
#line 335 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp114_ = g_key_file_to_data (_tmp113_, NULL, NULL);
#line 335 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp115_ = _tmp114_;
#line 335 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_file_set_contents (_tmp112_, _tmp115_, (gssize) -1, &_inner_error_);
#line 335 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_free0 (_tmp115_);
#line 335 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2027 "autosave-manager.c"
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
		GError* _tmp116_;
		const gchar* _tmp117_;
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		e = _inner_error_;
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 339 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp116_ = e;
#line 339 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp117_ = _tmp116_->message;
#line 339 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:339: Failed to write autosave: %s", _tmp117_);
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 2049 "autosave-manager.c"
	}
	__finally35:
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_free0 (page_names);
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 332 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return;
#line 2064 "autosave-manager.c"
	}
#line 279 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_free0 (page_names);
#line 279 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_key_file_unref0 (file);
#line 2070 "autosave-manager.c"
}


static void
autosave_manager_save_pixels (AutosaveManager* self,
                              Page* page)
{
	gchar* filename = NULL;
	GHashFunc _tmp0_;
	gchar* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	Page* _tmp5_;
	gchar* _tmp6_;
	GFile* file = NULL;
	GFile* _tmp7_;
	GError * _inner_error_ = NULL;
#line 343 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 343 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 345 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = g_direct_hash;
#line 345 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp1_ = g_strdup_printf ("%u.pixels", _tmp0_ (page));
#line 345 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	filename = _tmp1_;
#line 346 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp2_ = autosave_manager_AUTOSAVE_DIR;
#line 346 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp3_ = g_build_filename (_tmp2_, filename, NULL);
#line 346 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	path = _tmp3_;
#line 347 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp4_ = self->priv->page_filenames;
#line 347 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp5_ = _page_ref0 (page);
#line 347 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp6_ = g_strdup (filename);
#line 347 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp6_);
#line 349 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:349: Autosaving page pixels to %s", path);
#line 351 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp7_ = g_file_new_for_path (path);
#line 351 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	file = _tmp7_;
#line 2120 "autosave-manager.c"
	{
		gint _tmp8_;
		guchar* _tmp9_;
#line 354 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp9_ = page_get_pixels (page, &_tmp8_);
#line 354 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_file_replace_contents (file, _tmp9_, (gsize) _tmp8_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
#line 354 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2130 "autosave-manager.c"
			goto __catch36_g_error;
		}
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		e = _inner_error_;
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 358 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp10_ = e;
#line 358 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp11_ = _tmp10_->message;
#line 358 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:358: Failed to autosave page contents: %s", _tmp11_);
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 2152 "autosave-manager.c"
	}
	__finally36:
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_object_unref0 (file);
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_free0 (path);
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_g_free0 (filename);
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 352 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return;
#line 2169 "autosave-manager.c"
	}
#line 343 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_object_unref0 (file);
#line 343 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_free0 (path);
#line 343 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_free0 (filename);
#line 2177 "autosave-manager.c"
}


Book*
autosave_manager_get_book (AutosaveManager* self)
{
	Book* result;
	Book* _tmp0_;
#line 26 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = self->priv->book_;
#line 28 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	result = _tmp0_;
#line 28 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return result;
#line 2194 "autosave-manager.c"
}


static void
_autosave_manager_on_page_added_book_page_added (Book* _sender,
                                                 Page* page,
                                                 gpointer self)
{
#line 39 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_on_page_added ((AutosaveManager*) self, page);
#line 2205 "autosave-manager.c"
}


static void
_autosave_manager_on_page_removed_book_page_removed (Book* _sender,
                                                     Page* page,
                                                     gpointer self)
{
#line 40 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_on_page_removed ((AutosaveManager*) self, page);
#line 2216 "autosave-manager.c"
}


static void
_autosave_manager_on_changed_book_reordered (Book* _sender,
                                             gpointer self)
{
#line 41 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_on_changed ((AutosaveManager*) self);
#line 2226 "autosave-manager.c"
}


static void
_autosave_manager_on_cleared_book_cleared (Book* _sender,
                                           gpointer self)
{
#line 42 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_on_cleared ((AutosaveManager*) self);
#line 2236 "autosave-manager.c"
}


static gpointer
_book_ref0 (gpointer self)
{
#line 44 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return self ? book_ref (self) : NULL;
#line 2245 "autosave-manager.c"
}


void
autosave_manager_set_book (AutosaveManager* self,
                           Book* value)
{
	Book* _tmp0_;
	Book* _tmp19_;
	Book* _tmp20_;
	Book* _tmp21_;
	Book* _tmp22_;
	Book* _tmp23_;
#line 30 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 32 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = self->priv->book_;
#line 32 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (_tmp0_ != NULL) {
#line 2265 "autosave-manager.c"
		Book* _tmp11_;
		guint _tmp12_;
		Book* _tmp13_;
		guint _tmp14_;
		Book* _tmp15_;
		guint _tmp16_;
		Book* _tmp17_;
		guint _tmp18_;
		{
			gint i = 0;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			i = 0;
#line 2278 "autosave-manager.c"
			{
				gboolean _tmp1_ = FALSE;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp1_ = TRUE;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				while (TRUE) {
#line 2285 "autosave-manager.c"
					gint _tmp3_;
					Book* _tmp4_;
					guint _tmp5_;
					guint _tmp6_;
					Page* page = NULL;
					Book* _tmp7_;
					gint _tmp8_;
					Page* _tmp9_;
					Page* _tmp10_;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					if (!_tmp1_) {
#line 2297 "autosave-manager.c"
						gint _tmp2_;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						_tmp2_ = i;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						i = _tmp2_ + 1;
#line 2303 "autosave-manager.c"
					}
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp1_ = FALSE;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp3_ = i;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp4_ = self->priv->book_;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp5_ = book_get_n_pages (_tmp4_);
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp6_ = _tmp5_;
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					if (!(((guint) _tmp3_) < _tmp6_)) {
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
						break;
#line 2319 "autosave-manager.c"
					}
#line 36 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp7_ = self->priv->book_;
#line 36 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp8_ = i;
#line 36 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp9_ = book_get_page (_tmp7_, _tmp8_);
#line 36 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					page = _tmp9_;
#line 37 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp10_ = page;
#line 37 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					autosave_manager_on_page_removed (self, _tmp10_);
#line 34 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_page_unref0 (page);
#line 2335 "autosave-manager.c"
				}
			}
		}
#line 39 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp11_ = self->priv->book_;
#line 39 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp12_, NULL, FALSE);
#line 39 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _autosave_manager_on_page_added_book_page_added, self);
#line 40 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp13_ = self->priv->book_;
#line 40 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp14_, NULL, FALSE);
#line 40 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
#line 41 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp15_ = self->priv->book_;
#line 41 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp16_, NULL, FALSE);
#line 41 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _autosave_manager_on_changed_book_reordered, self);
#line 42 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		_tmp17_ = self->priv->book_;
#line 42 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp18_, NULL, FALSE);
#line 42 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _autosave_manager_on_cleared_book_cleared, self);
#line 2363 "autosave-manager.c"
	}
#line 44 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp19_ = _book_ref0 (value);
#line 44 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_book_unref0 (self->priv->book_);
#line 44 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->priv->book_ = _tmp19_;
#line 45 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp20_ = self->priv->book_;
#line 45 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_connect (_tmp20_, "page-added", (GCallback) _autosave_manager_on_page_added_book_page_added, self);
#line 46 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp21_ = self->priv->book_;
#line 46 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_connect (_tmp21_, "page-removed", (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
#line 47 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp22_ = self->priv->book_;
#line 47 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_connect (_tmp22_, "reordered", (GCallback) _autosave_manager_on_changed_book_reordered, self);
#line 48 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp23_ = self->priv->book_;
#line 48 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_connect (_tmp23_, "cleared", (GCallback) _autosave_manager_on_cleared_book_cleared, self);
#line 2387 "autosave-manager.c"
	{
		gint i = 0;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		i = 0;
#line 2392 "autosave-manager.c"
		{
			gboolean _tmp24_ = FALSE;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			_tmp24_ = TRUE;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			while (TRUE) {
#line 2399 "autosave-manager.c"
				gint _tmp26_;
				Book* _tmp27_;
				guint _tmp28_;
				guint _tmp29_;
				Page* page = NULL;
				Book* _tmp30_;
				gint _tmp31_;
				Page* _tmp32_;
				Page* _tmp33_;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (!_tmp24_) {
#line 2411 "autosave-manager.c"
					gint _tmp25_;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					_tmp25_ = i;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					i = _tmp25_ + 1;
#line 2417 "autosave-manager.c"
				}
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp24_ = FALSE;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp26_ = i;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp27_ = self->priv->book_;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp28_ = book_get_n_pages (_tmp27_);
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp29_ = _tmp28_;
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				if (!(((guint) _tmp26_) < _tmp29_)) {
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
					break;
#line 2433 "autosave-manager.c"
				}
#line 51 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp30_ = self->priv->book_;
#line 51 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp31_ = i;
#line 51 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp32_ = book_get_page (_tmp30_, _tmp31_);
#line 51 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				page = _tmp32_;
#line 52 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_tmp33_ = page;
#line 52 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				autosave_manager_on_page_added (self, _tmp33_);
#line 49 "/home/bob/git/simple-scan/src/autosave-manager.vala"
				_page_unref0 (page);
#line 2449 "autosave-manager.c"
			}
		}
	}
}


static void
value_autosave_manager_init (GValue* value)
{
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	value->data[0].v_pointer = NULL;
#line 2461 "autosave-manager.c"
}


static void
value_autosave_manager_free_value (GValue* value)
{
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (value->data[0].v_pointer) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		autosave_manager_unref (value->data[0].v_pointer);
#line 2472 "autosave-manager.c"
	}
}


static void
value_autosave_manager_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		dest_value->data[0].v_pointer = autosave_manager_ref (src_value->data[0].v_pointer);
#line 2485 "autosave-manager.c"
	} else {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2489 "autosave-manager.c"
	}
}


static gpointer
value_autosave_manager_peek_pointer (const GValue* value)
{
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return value->data[0].v_pointer;
#line 2499 "autosave-manager.c"
}


static gchar*
value_autosave_manager_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (collect_values[0].v_pointer) {
#line 2511 "autosave-manager.c"
		AutosaveManager * object;
		object = collect_values[0].v_pointer;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2518 "autosave-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2522 "autosave-manager.c"
		}
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		value->data[0].v_pointer = autosave_manager_ref (object);
#line 2526 "autosave-manager.c"
	} else {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2530 "autosave-manager.c"
	}
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return NULL;
#line 2534 "autosave-manager.c"
}


static gchar*
value_autosave_manager_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	AutosaveManager ** object_p;
	object_p = collect_values[0].v_pointer;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (!object_p) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2550 "autosave-manager.c"
	}
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (!value->data[0].v_pointer) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		*object_p = NULL;
#line 2556 "autosave-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 2560 "autosave-manager.c"
	} else {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		*object_p = autosave_manager_ref (value->data[0].v_pointer);
#line 2564 "autosave-manager.c"
	}
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return NULL;
#line 2568 "autosave-manager.c"
}


GParamSpec*
param_spec_autosave_manager (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecAutosaveManager* spec;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AUTOSAVE_MANAGER), NULL);
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return G_PARAM_SPEC (spec);
#line 2588 "autosave-manager.c"
}


gpointer
value_get_autosave_manager (const GValue* value)
{
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER), NULL);
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return value->data[0].v_pointer;
#line 2599 "autosave-manager.c"
}


void
value_set_autosave_manager (GValue* value,
                            gpointer v_object)
{
	AutosaveManager * old;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (v_object) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		value->data[0].v_pointer = v_object;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		autosave_manager_ref (value->data[0].v_pointer);
#line 2622 "autosave-manager.c"
	} else {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2626 "autosave-manager.c"
	}
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (old) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		autosave_manager_unref (old);
#line 2632 "autosave-manager.c"
	}
}


void
value_take_autosave_manager (GValue* value,
                             gpointer v_object)
{
	AutosaveManager * old;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (v_object) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		value->data[0].v_pointer = v_object;
#line 2654 "autosave-manager.c"
	} else {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2658 "autosave-manager.c"
	}
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (old) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		autosave_manager_unref (old);
#line 2664 "autosave-manager.c"
	}
}


static void
autosave_manager_class_init (AutosaveManagerClass * klass)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	((AutosaveManagerClass *) klass)->finalize = autosave_manager_finalize;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_type_class_add_private (klass, sizeof (AutosaveManagerPrivate));
#line 15 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 15 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "autosaves", NULL);
#line 15 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_DIR = _tmp1_;
#line 16 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp2_ = g_strdup ("autosave.book");
#line 16 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_FILENAME = _tmp2_;
#line 17 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp3_ = autosave_manager_AUTOSAVE_DIR;
#line 17 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp4_ = autosave_manager_AUTOSAVE_FILENAME;
#line 17 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
#line 17 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_PATH = _tmp5_;
#line 2702 "autosave-manager.c"
}


static void
autosave_manager_instance_init (AutosaveManager * self)
{
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->priv = AUTOSAVE_MANAGER_GET_PRIVATE (self);
#line 19 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 23 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->priv->book_ = NULL;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self->ref_count = 1;
#line 2717 "autosave-manager.c"
}


static void
autosave_manager_finalize (AutosaveManager * obj)
{
	AutosaveManager * self;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTOSAVE_MANAGER, AutosaveManager);
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_signal_handlers_destroy (self);
#line 21 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_g_hash_table_unref0 (self->priv->page_filenames);
#line 23 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	_book_unref0 (self->priv->book_);
#line 2733 "autosave-manager.c"
}


GType
autosave_manager_get_type (void)
{
	static volatile gsize autosave_manager_type_id__volatile = 0;
	if (g_once_init_enter (&autosave_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_autosave_manager_init, value_autosave_manager_free_value, value_autosave_manager_copy_value, value_autosave_manager_peek_pointer, "p", value_autosave_manager_collect_value, "p", value_autosave_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AutosaveManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) autosave_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AutosaveManager), 0, (GInstanceInitFunc) autosave_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType autosave_manager_type_id;
		autosave_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AutosaveManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&autosave_manager_type_id__volatile, autosave_manager_type_id);
	}
	return autosave_manager_type_id__volatile;
}


gpointer
autosave_manager_ref (gpointer instance)
{
	AutosaveManager * self;
	self = instance;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	return instance;
#line 2762 "autosave-manager.c"
}


void
autosave_manager_unref (gpointer instance)
{
	AutosaveManager * self;
	self = instance;
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		AUTOSAVE_MANAGER_GET_CLASS (self)->finalize (self);
#line 13 "/home/bob/git/simple-scan/src/autosave-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2777 "autosave-manager.c"
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



