/* page.c generated by valac 0.28.1, the Vala compiler
 * generated from page.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef struct _PagePrivate PagePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PIXBUF_WRITER (pixbuf_writer_get_type ())
#define PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_WRITER, PixbufWriter))
#define PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_WRITER, PixbufWriterClass))
#define IS_PIXBUF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_WRITER))
#define IS_PIXBUF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_WRITER))
#define PIXBUF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_WRITER, PixbufWriterClass))

typedef struct _PixbufWriter PixbufWriter;
typedef struct _PixbufWriterClass PixbufWriterClass;
#define _pixbuf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pixbuf_writer_unref (var), NULL)))
typedef struct _ParamSpecPage ParamSpecPage;
typedef struct _PixbufWriterPrivate PixbufWriterPrivate;
typedef struct _ParamSpecPixbufWriter ParamSpecPixbufWriter;

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _Page {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PagePrivate * priv;
};

struct _PageClass {
	GTypeClass parent_class;
	void (*finalize) (Page *self);
};

struct _PagePrivate {
	gint _dpi;
	gint expected_rows;
	gint _depth;
	gchar* _color_profile;
	gint _scan_width;
	gint _scan_height;
	gint _rowstride;
	gint _n_channels;
	guchar* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	gboolean _is_scanning;
	gboolean _has_data;
	gint _scan_line;
	ScanDirection scan_direction_;
	gboolean _has_crop;
	gchar* _crop_name;
	gint _crop_x;
	gint _crop_y;
	gint _crop_width;
	gint _crop_height;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecPage {
	GParamSpec parent_instance;
};

struct _PixbufWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PixbufWriterPrivate * priv;
	GFileOutputStream* stream;
};

struct _PixbufWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PixbufWriter *self);
};

struct _ParamSpecPixbufWriter {
	GParamSpec parent_instance;
};


static gpointer page_parent_class = NULL;
static gpointer pixbuf_writer_parent_class = NULL;

GType scan_direction_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE, PagePrivate))
enum  {
	PAGE_DUMMY_PROPERTY
};
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
static void page_set_scan_width (Page* self, gint value);
static void page_set_scan_height (Page* self, gint value);
static void page_set_dpi (Page* self, gint value);
void page_set_scan_direction (Page* self, ScanDirection value);
Page* page_new_from_data (gint scan_width, gint scan_height, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
Page* page_construct_from_data (GType object_type, gint scan_width, gint scan_height, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
static void page_set_rowstride (Page* self, gint value);
static void page_set_n_channels (Page* self, gint value);
static void page_set_depth (Page* self, gint value);
void page_set_color_profile (Page* self, const gchar* value);
static guchar* _vala_array_dup3 (guchar* self, int length);
static void page_set_has_data (Page* self, gboolean value);
static void page_set_has_crop (Page* self, gboolean value);
static void page_set_crop_name (Page* self, const gchar* value);
static void page_set_crop_x (Page* self, gint value);
static void page_set_crop_y (Page* self, gint value);
static void page_set_crop_width (Page* self, gint value);
static void page_set_crop_height (Page* self, gint value);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
void page_set_page_info (Page* self, ScanPageInfo* info);
gint page_get_scan_height (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_rowstride (Page* self);
void page_start (Page* self);
static void page_set_is_scanning (Page* self, gboolean value);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void page_parse_line (Page* self, ScanLine* line, gint n, gboolean* size_changed);
static void page_set_scan_line (Page* self, gint value);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
gint page_get_scan_line (Page* self);
void page_rotate_left (Page* self);
ScanDirection page_get_scan_direction (Page* self);
void page_rotate_right (Page* self);
void page_set_no_crop (Page* self);
gboolean page_get_has_crop (Page* self);
void page_set_custom_crop (Page* self, gint width, gint height);
const gchar* page_get_crop_name (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
void page_set_named_crop (Page* self, const gchar* name);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
void page_move_crop (Page* self, gint x, gint y);
void page_rotate_crop (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
static guchar page_get_sample (Page* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint n_channels, gint channel);
static void page_get_pixel (Page* self, gint x, gint y, guchar* pixel, int pixel_length1, gint offset);
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
static gchar* page_get_icc_data_encoded (Page* self, const gchar* icc_profile_filename);
void page_copy_to_clipboard (Page* self, GtkWindow* window);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
gpointer pixbuf_writer_ref (gpointer instance);
void pixbuf_writer_unref (gpointer instance);
GParamSpec* param_spec_pixbuf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixbuf_writer (GValue* value, gpointer v_object);
void value_take_pixbuf_writer (GValue* value, gpointer v_object);
gpointer value_get_pixbuf_writer (const GValue* value);
GType pixbuf_writer_get_type (void) G_GNUC_CONST;
PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream);
PixbufWriter* pixbuf_writer_construct (GType object_type, GFileOutputStream* stream);
const gchar* page_get_color_profile (Page* self);
void pixbuf_writer_save (PixbufWriter* self, GdkPixbuf* image, const gchar* type, gchar** option_keys, int option_keys_length1, gchar** option_values, int option_values_length1, GError** error);
gboolean page_get_is_landscape (Page* self);
gboolean page_get_is_scanning (Page* self);
gboolean page_get_has_data (Page* self);
gboolean page_get_is_color (Page* self);
static void page_finalize (Page* obj);
enum  {
	PIXBUF_WRITER_DUMMY_PROPERTY
};
static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self, guint8* buf, int buf_length1, GError** error);
static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void pixbuf_writer_finalize (PixbufWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType scan_direction_get_type (void) {
	static volatile gsize scan_direction_type_id__volatile = 0;
	if (g_once_init_enter (&scan_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_DIRECTION_TOP_TO_BOTTOM, "SCAN_DIRECTION_TOP_TO_BOTTOM", "top-to-bottom"}, {SCAN_DIRECTION_LEFT_TO_RIGHT, "SCAN_DIRECTION_LEFT_TO_RIGHT", "left-to-right"}, {SCAN_DIRECTION_BOTTOM_TO_TOP, "SCAN_DIRECTION_BOTTOM_TO_TOP", "bottom-to-top"}, {SCAN_DIRECTION_RIGHT_TO_LEFT, "SCAN_DIRECTION_RIGHT_TO_LEFT", "right-to-left"}, {0, NULL, NULL}};
		GType scan_direction_type_id;
		scan_direction_type_id = g_enum_register_static ("ScanDirection", values);
		g_once_init_leave (&scan_direction_type_id__volatile, scan_direction_type_id);
	}
	return scan_direction_type_id__volatile;
}


Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction) {
	Page* self = NULL;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_ = 0;
	gint _tmp7_ = 0;
	ScanDirection _tmp8_ = 0;
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self = (Page*) g_type_create_instance (object_type);
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = scan_direction;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp1_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = TRUE;
#line 319 "page.c"
	} else {
		ScanDirection _tmp2_ = 0;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp2_ = scan_direction;
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = _tmp2_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 326 "page.c"
	}
#line 176 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp0_) {
#line 330 "page.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = width;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_scan_width (self, _tmp3_);
#line 179 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp4_ = height;
#line 179 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_scan_height (self, _tmp4_);
#line 341 "page.c"
	} else {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 183 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp5_ = height;
#line 183 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_scan_width (self, _tmp5_);
#line 184 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = width;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_scan_height (self, _tmp6_);
#line 353 "page.c"
	}
#line 186 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7_ = dpi;
#line 186 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_dpi (self, _tmp7_);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp8_ = scan_direction;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_scan_direction (self, _tmp8_);
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return self;
#line 365 "page.c"
}


Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction) {
#line 174 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return page_construct (TYPE_PAGE, width, height, dpi, scan_direction);
#line 372 "page.c"
}


static guchar* _vala_array_dup3 (guchar* self, int length) {
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return g_memdup (self, length * sizeof (guchar));
#line 379 "page.c"
}


Page* page_construct_from_data (GType object_type, gint scan_width, gint scan_height, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height) {
	Page* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	ScanDirection _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	guchar* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guchar* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	guchar* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 190 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self = (Page*) g_type_create_instance (object_type);
#line 206 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = scan_width;
#line 206 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_scan_width (self, _tmp0_);
#line 207 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = scan_height;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_scan_height (self, _tmp1_);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = scan_height;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->expected_rows = _tmp2_;
#line 209 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = rowstride;
#line 209 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_rowstride (self, _tmp3_);
#line 210 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp4_ = n_channels;
#line 210 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_n_channels (self, _tmp4_);
#line 211 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp5_ = depth;
#line 211 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_depth (self, _tmp5_);
#line 212 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp6_ = dpi;
#line 212 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_dpi (self, _tmp6_);
#line 213 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7_ = scan_direction;
#line 213 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_scan_direction (self, _tmp7_);
#line 214 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp8_ = color_profile;
#line 214 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_color_profile (self, _tmp8_);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp9_ = pixels;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp9__length1 = pixels_length1;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup3 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp10__length1 = _tmp9__length1;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->pixels = _tmp10_;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->pixels_length1 = _tmp10__length1;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_pixels_size_ = self->priv->pixels_length1;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp11_ = pixels;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp11__length1 = pixels_length1;
#line 216 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_has_data (self, _tmp11_ != NULL);
#line 217 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp12_ = has_crop;
#line 217 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_has_crop (self, _tmp12_);
#line 218 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp13_ = crop_name;
#line 218 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_name (self, _tmp13_);
#line 219 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp14_ = crop_x;
#line 219 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_x (self, _tmp14_);
#line 220 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp15_ = crop_y;
#line 220 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_y (self, _tmp15_);
#line 221 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp16_ = crop_width;
#line 221 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_width (self, _tmp16_);
#line 222 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp17_ = crop_height;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_height (self, _tmp17_);
#line 190 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return self;
#line 492 "page.c"
}


Page* page_new_from_data (gint scan_width, gint scan_height, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height) {
#line 190 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return page_construct_from_data (TYPE_PAGE, scan_width, scan_height, rowstride, n_channels, depth, dpi, scan_direction, color_profile, pixels, pixels_length1, has_crop, crop_name, crop_x, crop_y, crop_width, crop_height);
#line 499 "page.c"
}


void page_set_page_info (Page* self, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ScanPageInfo* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	ScanPageInfo* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	ScanPageInfo* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	ScanPageInfo* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	ScanPageInfo* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	guchar* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp21_ = 0;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (info != NULL);
#line 227 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = info;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _tmp0_->height;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->expected_rows = _tmp1_;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = info;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = _tmp2_->dpi;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_dpi (self, (gint) _tmp3_);
#line 231 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp4_ = info;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp5_ = _tmp4_->width;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_scan_width (self, _tmp5_);
#line 232 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp6_ = info;
#line 232 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7_ = _tmp6_->height;
#line 232 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_scan_height (self, _tmp7_);
#line 234 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp8_ = self->priv->_scan_height;
#line 234 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp8_ < 0) {
#line 558 "page.c"
		gint _tmp9_ = 0;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp9_ = self->priv->_scan_width;
#line 235 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_scan_height (self, _tmp9_ / 2);
#line 564 "page.c"
	}
#line 236 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp10_ = info;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp11_ = _tmp10_->depth;
#line 236 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_depth (self, _tmp11_);
#line 237 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp12_ = info;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp13_ = _tmp12_->n_channels;
#line 237 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_n_channels (self, _tmp13_);
#line 238 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp14_ = self->priv->_scan_width;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp15_ = self->priv->_depth;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp16_ = self->priv->_n_channels;
#line 238 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_rowstride (self, (((_tmp14_ * _tmp15_) * _tmp16_) + 7) / 8);
#line 239 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp17_ = self->priv->_scan_height;
#line 239 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp18_ = self->priv->_rowstride;
#line 239 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp19_ = _tmp17_ * _tmp18_;
#line 239 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp17_ * _tmp18_);
#line 239 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	(_tmp19_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp19_ - self->priv->pixels_length1)) : NULL;
#line 239 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->pixels_length1 = _tmp19_;
#line 239 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_pixels_size_ = _tmp19_;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp20_ = self->priv->pixels;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp20__length1 = self->priv->pixels_length1;
#line 240 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (_tmp20_ != NULL);
#line 243 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp21_ = self->priv->_depth;
#line 243 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp21_ == 1) {
#line 610 "page.c"
		guchar* _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
#line 244 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp22_ = self->priv->pixels;
#line 244 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp22__length1 = self->priv->pixels_length1;
#line 244 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp23_ = self->priv->_scan_height;
#line 244 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_ = self->priv->_rowstride;
#line 244 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		memset (_tmp22_, 0x00, (gsize) (_tmp23_ * _tmp24_));
#line 625 "page.c"
	} else {
		guchar* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
#line 246 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp25_ = self->priv->pixels;
#line 246 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp25__length1 = self->priv->pixels_length1;
#line 246 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp26_ = self->priv->_scan_height;
#line 246 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp27_ = self->priv->_rowstride;
#line 246 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		memset (_tmp25_, 0xFF, (gsize) (_tmp26_ * _tmp27_));
#line 641 "page.c"
	}
#line 248 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 249 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "pixels-changed");
#line 647 "page.c"
}


void page_start (Page* self) {
#line 252 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 254 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_is_scanning (self, TRUE);
#line 255 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 658 "page.c"
}


static void page_parse_line (Page* self, ScanLine* line, gint n, gboolean* size_changed) {
	gboolean _vala_size_changed = FALSE;
	gint line_number = 0;
	ScanLine* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint offset = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint line_offset = 0;
	gint _tmp15_ = 0;
	ScanLine* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp32_ = 0;
#line 258 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 258 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (line != NULL);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = line;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _tmp0_->number;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = n;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	line_number = _tmp1_ + _tmp2_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_vala_size_changed = FALSE;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	while (TRUE) {
#line 692 "page.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint rows = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = line_number;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp4_ = self->priv->_scan_height;
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (!(_tmp3_ >= _tmp4_)) {
#line 264 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 712 "page.c"
		}
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp5_ = self->priv->_scan_height;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		rows = _tmp5_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = rows;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp7_ = self->priv->_scan_width;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_scan_height (self, _tmp6_ + (_tmp7_ / 2));
#line 269 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp8_ = rows;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp9_ = self->priv->_scan_height;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_debug ("page.vala:269: Extending image from %d lines to %d lines", _tmp8_, _tmp9_);
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp10_ = self->priv->_scan_height;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp11_ = self->priv->_rowstride;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp12_ = _tmp10_ * _tmp11_;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp10_ * _tmp11_);
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		(_tmp12_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp12_ - self->priv->pixels_length1)) : NULL;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		self->priv->pixels_length1 = _tmp12_;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		self->priv->_pixels_size_ = _tmp12_;
#line 272 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_vala_size_changed = TRUE;
#line 746 "page.c"
	}
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp13_ = line_number;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp14_ = self->priv->_rowstride;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	offset = _tmp13_ * _tmp14_;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp15_ = n;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp16_ = line;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp17_ = _tmp16_->data_length;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	line_offset = _tmp15_ * _tmp17_;
#line 762 "page.c"
	{
		gint i = 0;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		i = 0;
#line 767 "page.c"
		{
			gboolean _tmp18_ = FALSE;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp18_ = TRUE;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			while (TRUE) {
#line 774 "page.c"
				gint _tmp20_ = 0;
				ScanLine* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				guchar* _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				ScanLine* _tmp26_ = NULL;
				guchar* _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				guchar _tmp30_ = '\0';
				guchar _tmp31_ = '\0';
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (!_tmp18_) {
#line 791 "page.c"
					gint _tmp19_ = 0;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp19_ = i;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					i = _tmp19_ + 1;
#line 797 "page.c"
				}
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp18_ = FALSE;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp20_ = i;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp21_ = line;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp22_ = _tmp21_->data_length;
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (!(_tmp20_ < _tmp22_)) {
#line 278 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					break;
#line 811 "page.c"
				}
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp23_ = self->priv->pixels;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp23__length1 = self->priv->pixels_length1;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp24_ = offset;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp25_ = i;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp26_ = line;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp27_ = _tmp26_->data;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp27__length1 = _tmp26_->data_length1;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp28_ = line_offset;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp29_ = i;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp30_ = _tmp27_[_tmp28_ + _tmp29_];
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp23_[_tmp24_ + _tmp25_] = _tmp30_;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp31_ = _tmp23_[_tmp24_ + _tmp25_];
#line 837 "page.c"
			}
		}
	}
#line 281 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp32_ = line_number;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_scan_line (self, _tmp32_);
#line 258 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (size_changed) {
#line 258 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		*size_changed = _vala_size_changed;
#line 849 "page.c"
	}
}


void page_parse_scan_line (Page* self, ScanLine* line) {
	gboolean size_has_changed = FALSE;
	gboolean _tmp8_ = FALSE;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 284 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (line != NULL);
#line 286 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	size_has_changed = FALSE;
#line 863 "page.c"
	{
		gint i = 0;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		i = 0;
#line 868 "page.c"
		{
			gboolean _tmp0_ = FALSE;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp0_ = TRUE;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			while (TRUE) {
#line 875 "page.c"
				gint _tmp2_ = 0;
				ScanLine* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				ScanLine* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gboolean _tmp7_ = FALSE;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (!_tmp0_) {
#line 884 "page.c"
					gint _tmp1_ = 0;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp1_ = i;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					i = _tmp1_ + 1;
#line 890 "page.c"
				}
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp0_ = FALSE;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp2_ = i;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp3_ = line;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp4_ = _tmp3_->n_lines;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (!(_tmp2_ < _tmp4_)) {
#line 287 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					break;
#line 904 "page.c"
				}
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp5_ = line;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp6_ = i;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_parse_line (self, _tmp5_, _tmp6_, &_tmp7_);
#line 288 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				size_has_changed = _tmp7_;
#line 914 "page.c"
			}
		}
	}
#line 290 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_has_data (self, TRUE);
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp8_ = size_has_changed;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp8_) {
#line 293 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 926 "page.c"
	}
#line 294 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 295 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "pixels-changed");
#line 932 "page.c"
}


void page_finish (Page* self) {
	gboolean size_has_changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp11_ = FALSE;
#line 298 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	size_has_changed = FALSE;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = self->priv->expected_rows;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp1_ < 0) {
#line 949 "page.c"
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 304 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp2_ = self->priv->_scan_line;
#line 304 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = self->priv->_scan_height;
#line 304 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = _tmp2_ != _tmp3_;
#line 958 "page.c"
	} else {
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = FALSE;
#line 962 "page.c"
	}
#line 303 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp0_) {
#line 966 "page.c"
		gint rows = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp4_ = self->priv->_scan_height;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		rows = _tmp4_;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp5_ = self->priv->_scan_line;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_scan_height (self, _tmp5_);
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = self->priv->_scan_height;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp7_ = self->priv->_rowstride;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp8_ = _tmp6_ * _tmp7_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		self->priv->pixels = g_renew (guchar, self->priv->pixels, _tmp6_ * _tmp7_);
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		(_tmp8_ > self->priv->pixels_length1) ? memset (self->priv->pixels + self->priv->pixels_length1, 0, sizeof (guchar) * (_tmp8_ - self->priv->pixels_length1)) : NULL;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		self->priv->pixels_length1 = _tmp8_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		self->priv->_pixels_size_ = _tmp8_;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp9_ = rows;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp10_ = self->priv->_scan_height;
#line 309 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_debug ("page.vala:309: Trimming page from %d lines to %d lines", _tmp9_, _tmp10_);
#line 311 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		size_has_changed = TRUE;
#line 1005 "page.c"
	}
#line 313 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_is_scanning (self, FALSE);
#line 315 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp11_ = size_has_changed;
#line 315 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp11_) {
#line 316 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 1015 "page.c"
	}
#line 317 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "scan-line-changed");
#line 318 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "scan-finished");
#line 1021 "page.c"
}


void page_rotate_left (Page* self) {
	ScanDirection _tmp0_ = 0;
	ScanDirection _tmp1_ = 0;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = page_get_scan_direction (self);
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _tmp0_;
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	switch (_tmp1_) {
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1038 "page.c"
		{
#line 326 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_LEFT_TO_RIGHT);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1044 "page.c"
		}
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1048 "page.c"
		{
#line 329 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_BOTTOM_TO_TOP);
#line 330 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1054 "page.c"
		}
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1058 "page.c"
		{
#line 332 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_RIGHT_TO_LEFT);
#line 333 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1064 "page.c"
		}
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1068 "page.c"
		{
#line 335 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_TOP_TO_BOTTOM);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1074 "page.c"
		}
		default:
#line 323 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		break;
#line 1079 "page.c"
	}
}


void page_rotate_right (Page* self) {
	ScanDirection _tmp0_ = 0;
	ScanDirection _tmp1_ = 0;
#line 340 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = page_get_scan_direction (self);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _tmp0_;
#line 342 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	switch (_tmp1_) {
#line 342 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1097 "page.c"
		{
#line 345 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_RIGHT_TO_LEFT);
#line 346 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1103 "page.c"
		}
#line 342 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1107 "page.c"
		{
#line 348 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_TOP_TO_BOTTOM);
#line 349 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1113 "page.c"
		}
#line 342 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1117 "page.c"
		{
#line 351 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_LEFT_TO_RIGHT);
#line 352 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1123 "page.c"
		}
#line 342 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1127 "page.c"
		{
#line 354 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_scan_direction (self, SCAN_DIRECTION_BOTTOM_TO_TOP);
#line 355 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1133 "page.c"
		}
		default:
#line 342 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		break;
#line 1138 "page.c"
	}
}


void page_set_no_crop (Page* self) {
	gboolean _tmp0_ = FALSE;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 361 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_has_crop;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (!_tmp0_) {
#line 362 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return;
#line 1153 "page.c"
	}
#line 363 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_has_crop (self, FALSE);
#line 364 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_name (self, NULL);
#line 365 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_x (self, 0);
#line 366 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_y (self, 0);
#line 367 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_width (self, 0);
#line 368 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_height (self, 0);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1169 "page.c"
}


void page_set_custom_crop (Page* self, gint width, gint height) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 374 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = width;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (_tmp0_ >= 1);
#line 375 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = height;
#line 375 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (_tmp1_ >= 1);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp5_ = self->priv->_crop_name;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp5_ == NULL) {
#line 1196 "page.c"
		gboolean _tmp6_ = FALSE;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = self->priv->_has_crop;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp4_ = _tmp6_;
#line 1202 "page.c"
	} else {
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp4_ = FALSE;
#line 1206 "page.c"
	}
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp4_) {
#line 1210 "page.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp7_ = self->priv->_crop_width;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp8_ = width;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = _tmp7_ == _tmp8_;
#line 1219 "page.c"
	} else {
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = FALSE;
#line 1223 "page.c"
	}
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp3_) {
#line 1227 "page.c"
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp9_ = self->priv->_crop_height;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp10_ = height;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp2_ = _tmp9_ == _tmp10_;
#line 1236 "page.c"
	} else {
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp2_ = FALSE;
#line 1240 "page.c"
	}
#line 377 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp2_) {
#line 378 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return;
#line 1246 "page.c"
	}
#line 379 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_name (self, NULL);
#line 380 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_has_crop (self, TRUE);
#line 382 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp11_ = width;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_width (self, _tmp11_);
#line 383 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp12_ = height;
#line 383 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_height (self, _tmp12_);
#line 396 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1262 "page.c"
}


void page_set_named_crop (Page* self, const gchar* name) {
	gdouble w = 0.0;
	gdouble h = 0.0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	static GQuark _tmp2_label0 = 0;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	static GQuark _tmp2_label1 = 0;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	static GQuark _tmp2_label2 = 0;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	static GQuark _tmp2_label3 = 0;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	static GQuark _tmp2_label4 = 0;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	static GQuark _tmp2_label5 = 0;
#line 1284 "page.c"
	const gchar* _tmp5_ = NULL;
	gint pw = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint ph = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gdouble _tmp15_ = 0.0;
	gint _tmp16_ = 0;
	gdouble _tmp17_ = 0.0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (name != NULL);
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = name;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _tmp0_;
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("A4")))) {
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		switch (0) {
#line 1316 "page.c"
			default:
			{
#line 405 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				w = 8.3;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				h = 11.7;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 1325 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("A5")))) {
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		switch (0) {
#line 1331 "page.c"
			default:
			{
#line 409 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				w = 5.8;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				h = 8.3;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 1340 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("A6")))) {
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		switch (0) {
#line 1346 "page.c"
			default:
			{
#line 413 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				w = 4.1;
#line 414 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				h = 5.8;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 1355 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("letter")))) {
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		switch (0) {
#line 1361 "page.c"
			default:
			{
#line 417 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				w = 8.5;
#line 418 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				h = (gdouble) 11;
#line 419 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 1370 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("legal")))) {
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		switch (0) {
#line 1376 "page.c"
			default:
			{
#line 421 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				w = 8.5;
#line 422 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				h = (gdouble) 14;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 1385 "page.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("4x6")))) {
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		switch (0) {
#line 1391 "page.c"
			default:
			{
#line 425 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				w = (gdouble) 4;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				h = (gdouble) 6;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 1400 "page.c"
			}
		}
	} else {
#line 402 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		switch (0) {
#line 1406 "page.c"
			default:
			{
				const gchar* _tmp4_ = NULL;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp4_ = name;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				g_warning ("page.vala:429: Unknown paper size '%s'", _tmp4_);
#line 430 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				return;
#line 1416 "page.c"
			}
		}
	}
#line 433 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp5_ = name;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_name (self, _tmp5_);
#line 434 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_has_crop (self, TRUE);
#line 436 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp6_ = page_get_width (self);
#line 436 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7_ = _tmp6_;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	pw = _tmp7_;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp8_ = page_get_height (self);
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp9_ = _tmp8_;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	ph = _tmp9_;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp10_ = pw;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp11_ = ph;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp10_ > _tmp11_) {
#line 1444 "page.c"
		gdouble t = 0.0;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp12_ = w;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		t = _tmp12_;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp13_ = h;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		w = _tmp13_;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp14_ = t;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		h = _tmp14_;
#line 1461 "page.c"
	}
#line 448 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp15_ = w;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp16_ = self->priv->_dpi;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_width (self, (gint) ((_tmp15_ * _tmp16_) + 0.5));
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp17_ = h;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp18_ = self->priv->_dpi;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_height (self, (gint) ((_tmp17_ * _tmp18_) + 0.5));
#line 451 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp19_ = self->priv->_crop_width;
#line 451 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp20_ = pw;
#line 451 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp19_ < _tmp20_) {
#line 1481 "page.c"
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp21_ = pw;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp22_ = self->priv->_crop_width;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_crop_x (self, (_tmp21_ - _tmp22_) / 2);
#line 1490 "page.c"
	} else {
#line 454 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_crop_x (self, 0);
#line 1494 "page.c"
	}
#line 455 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp23_ = self->priv->_crop_height;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp24_ = ph;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp23_ < _tmp24_) {
#line 1502 "page.c"
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp25_ = ph;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp26_ = self->priv->_crop_height;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_crop_y (self, (_tmp25_ - _tmp26_) / 2);
#line 1511 "page.c"
	} else {
#line 458 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_set_crop_y (self, 0);
#line 1515 "page.c"
	}
#line 459 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1519 "page.c"
}


void page_move_crop (Page* self, gint x, gint y) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 464 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = x;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (_tmp0_ >= 0);
#line 465 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = y;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (_tmp1_ >= 0);
#line 466 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = x;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = page_get_width (self);
#line 466 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp4_ = _tmp3_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (_tmp2_ < _tmp4_);
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp5_ = y;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp6_ = page_get_height (self);
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7_ = _tmp6_;
#line 467 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (_tmp5_ < _tmp7_);
#line 469 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp8_ = x;
#line 469 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_x (self, _tmp8_);
#line 470 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp9_ = y;
#line 470 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_y (self, _tmp9_);
#line 471 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1570 "page.c"
}


void page_rotate_crop (Page* self) {
	gboolean _tmp0_ = FALSE;
	gint t = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_has_crop;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (!_tmp0_) {
#line 477 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return;
#line 1589 "page.c"
	}
#line 479 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = self->priv->_crop_width;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	t = _tmp1_;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = self->priv->_crop_height;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_width (self, _tmp2_);
#line 481 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = t;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_set_crop_height (self, _tmp3_);
#line 484 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp4_ = self->priv->_crop_name;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp4_ == NULL) {
#line 1607 "page.c"
		gint w = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint h = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp14_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp21_ = 0;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp5_ = page_get_width (self);
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = _tmp5_;
#line 486 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		w = _tmp6_;
#line 487 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp7_ = page_get_height (self);
#line 487 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp8_ = _tmp7_;
#line 487 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		h = _tmp8_;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp9_ = self->priv->_crop_x;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp10_ = self->priv->_crop_width;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp11_ = w;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if ((_tmp9_ + _tmp10_) > _tmp11_) {
#line 1642 "page.c"
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp12_ = w;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp13_ = self->priv->_crop_width;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_crop_x (self, _tmp12_ - _tmp13_);
#line 1651 "page.c"
		}
#line 491 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp14_ = self->priv->_crop_x;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp14_ < 0) {
#line 1657 "page.c"
			gint _tmp15_ = 0;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_crop_x (self, 0);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp15_ = w;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_crop_width (self, _tmp15_);
#line 1665 "page.c"
		}
#line 496 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp16_ = self->priv->_crop_y;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp17_ = self->priv->_crop_height;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp18_ = h;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if ((_tmp16_ + _tmp17_) > _tmp18_) {
#line 1675 "page.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp19_ = h;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp20_ = self->priv->_crop_height;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_crop_y (self, _tmp19_ - _tmp20_);
#line 1684 "page.c"
		}
#line 498 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp21_ = self->priv->_crop_y;
#line 498 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp21_ < 0) {
#line 1690 "page.c"
			gint _tmp22_ = 0;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_crop_y (self, 0);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp22_ = h;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			page_set_crop_height (self, _tmp22_);
#line 1698 "page.c"
		}
	}
#line 505 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "crop-changed");
#line 1703 "page.c"
}


guchar* page_get_pixels (Page* self, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	guchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 508 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->pixels;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0__length1 = self->priv->pixels_length1;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _tmp0_;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1__length1 = _tmp0__length1;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (result_length1) {
#line 510 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		*result_length1 = _tmp1__length1;
#line 1727 "page.c"
	}
#line 510 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp1_;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 1733 "page.c"
}


static guchar page_get_sample (Page* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint n_channels, gint channel) {
	guchar result = '\0';
#line 514 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 517 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = (guchar) 0xFF;
#line 517 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 1745 "page.c"
}


static void page_get_pixel (Page* self, gint x, gint y, guchar* pixel, int pixel_length1, gint offset) {
	ScanDirection _tmp0_ = 0;
	ScanDirection _tmp1_ = 0;
	gint line_offset = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	guchar* _tmp98_ = NULL;
	gint _tmp98__length1 = 0;
	gint _tmp99_ = 0;
	guchar* _tmp100_ = NULL;
	gint _tmp100__length1 = 0;
	gint _tmp101_ = 0;
	gint _tmp102_ = 0;
	gint _tmp103_ = 0;
	gint _tmp104_ = 0;
	guchar _tmp105_ = '\0';
	guchar _tmp106_ = '\0';
	guchar* _tmp107_ = NULL;
	gint _tmp107__length1 = 0;
	gint _tmp108_ = 0;
	guchar* _tmp109_ = NULL;
	gint _tmp109__length1 = 0;
	gint _tmp110_ = 0;
	gint _tmp111_ = 0;
	gint _tmp112_ = 0;
	gint _tmp113_ = 0;
	guchar _tmp114_ = '\0';
	guchar _tmp115_ = '\0';
	guchar* _tmp116_ = NULL;
	gint _tmp116__length1 = 0;
	gint _tmp117_ = 0;
	guchar* _tmp118_ = NULL;
	gint _tmp118__length1 = 0;
	gint _tmp119_ = 0;
	gint _tmp120_ = 0;
	gint _tmp121_ = 0;
	gint _tmp122_ = 0;
	guchar _tmp123_ = '\0';
	guchar _tmp124_ = '\0';
#line 521 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 523 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = page_get_scan_direction (self);
#line 523 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _tmp0_;
#line 523 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	switch (_tmp1_) {
#line 523 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1800 "page.c"
		{
#line 526 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1804 "page.c"
		}
#line 523 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1808 "page.c"
		{
			gint _tmp2_ = 0;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp2_ = self->priv->_scan_width;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp3_ = x;
#line 528 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			x = (_tmp2_ - _tmp3_) - 1;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp4_ = self->priv->_scan_height;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp5_ = y;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			y = (_tmp4_ - _tmp5_) - 1;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1828 "page.c"
		}
#line 523 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1832 "page.c"
		{
			gint t = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp6_ = x;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			t = _tmp6_;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp7_ = self->priv->_scan_width;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp8_ = y;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			x = (_tmp7_ - _tmp8_) - 1;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp9_ = t;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			y = _tmp9_;
#line 535 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1855 "page.c"
		}
#line 523 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1859 "page.c"
		{
			gint t = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp10_ = x;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			t = _tmp10_;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp11_ = y;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			x = _tmp11_;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp12_ = self->priv->_scan_height;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp13_ = t;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			y = (_tmp12_ - _tmp13_) - 1;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 1882 "page.c"
		}
		default:
#line 523 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		break;
#line 1887 "page.c"
	}
#line 543 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp14_ = self->priv->_rowstride;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp15_ = y;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	line_offset = _tmp14_ * _tmp15_;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp17_ = self->priv->_depth;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp17_ == 8) {
#line 1899 "page.c"
		gint _tmp18_ = 0;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp18_ = self->priv->_n_channels;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp16_ = _tmp18_ == 3;
#line 1905 "page.c"
	} else {
#line 546 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp16_ = FALSE;
#line 1909 "page.c"
	}
#line 546 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp16_) {
#line 1913 "page.c"
		gint o = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		guchar* _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		gint _tmp23_ = 0;
		guchar* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gint _tmp25_ = 0;
		guchar _tmp26_ = '\0';
		guchar _tmp27_ = '\0';
		guchar* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		guchar* _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		gint _tmp31_ = 0;
		guchar _tmp32_ = '\0';
		guchar _tmp33_ = '\0';
		guchar* _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		gint _tmp35_ = 0;
		guchar* _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		gint _tmp37_ = 0;
		guchar _tmp38_ = '\0';
		guchar _tmp39_ = '\0';
#line 548 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp19_ = line_offset;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp20_ = x;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp21_ = self->priv->_n_channels;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		o = _tmp19_ + (_tmp20_ * _tmp21_);
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp22_ = pixel;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp22__length1 = pixel_length1;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp23_ = offset;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_ = self->priv->pixels;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24__length1 = self->priv->pixels_length1;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp25_ = o;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp26_ = _tmp24_[_tmp25_];
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp22_[_tmp23_ + 0] = _tmp26_;
#line 549 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp27_ = _tmp22_[_tmp23_ + 0];
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp28_ = pixel;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp28__length1 = pixel_length1;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp29_ = offset;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp30_ = self->priv->pixels;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp30__length1 = self->priv->pixels_length1;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp31_ = o;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp32_ = _tmp30_[_tmp31_ + 1];
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp28_[_tmp29_ + 1] = _tmp32_;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp33_ = _tmp28_[_tmp29_ + 1];
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp34_ = pixel;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp34__length1 = pixel_length1;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp35_ = offset;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp36_ = self->priv->pixels;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp36__length1 = self->priv->pixels_length1;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp37_ = o;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp38_ = _tmp36_[_tmp37_ + 2];
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp34_[_tmp35_ + 2] = _tmp38_;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp39_ = _tmp34_[_tmp35_ + 2];
#line 552 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return;
#line 2006 "page.c"
	} else {
		gboolean _tmp40_ = FALSE;
		gint _tmp41_ = 0;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp41_ = self->priv->_depth;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp41_ == 8) {
#line 2014 "page.c"
			gint _tmp42_ = 0;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp42_ = self->priv->_n_channels;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp40_ = _tmp42_ == 1;
#line 2020 "page.c"
		} else {
#line 554 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp40_ = FALSE;
#line 2024 "page.c"
		}
#line 554 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp40_) {
#line 2028 "page.c"
			guchar p = '\0';
			guchar* _tmp43_ = NULL;
			gint _tmp43__length1 = 0;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			guchar _tmp46_ = '\0';
			guchar* _tmp47_ = NULL;
			gint _tmp47__length1 = 0;
			gint _tmp48_ = 0;
			guchar* _tmp49_ = NULL;
			gint _tmp49__length1 = 0;
			gint _tmp50_ = 0;
			guchar* _tmp51_ = NULL;
			gint _tmp51__length1 = 0;
			gint _tmp52_ = 0;
			guchar _tmp53_ = '\0';
			guchar _tmp54_ = '\0';
			guchar _tmp55_ = '\0';
			guchar _tmp56_ = '\0';
#line 556 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp43_ = self->priv->pixels;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp43__length1 = self->priv->pixels_length1;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp44_ = line_offset;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp45_ = x;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp46_ = _tmp43_[_tmp44_ + _tmp45_];
#line 556 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			p = _tmp46_;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp47_ = pixel;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp47__length1 = pixel_length1;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp48_ = offset;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp49_ = pixel;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp49__length1 = pixel_length1;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp50_ = offset;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp51_ = pixel;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp51__length1 = pixel_length1;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp52_ = offset;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp53_ = p;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp51_[_tmp52_ + 2] = _tmp53_;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp54_ = _tmp51_[_tmp52_ + 2];
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp49_[_tmp50_ + 1] = _tmp54_;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp55_ = _tmp49_[_tmp50_ + 1];
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp47_[_tmp48_ + 0] = _tmp55_;
#line 557 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp56_ = _tmp47_[_tmp48_ + 0];
#line 558 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			return;
#line 2094 "page.c"
		} else {
			gboolean _tmp57_ = FALSE;
			gint _tmp58_ = 0;
#line 562 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp58_ = self->priv->_depth;
#line 562 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			if (_tmp58_ == 1) {
#line 2102 "page.c"
				gint _tmp59_ = 0;
#line 562 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp59_ = self->priv->_n_channels;
#line 562 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp57_ = _tmp59_ == 1;
#line 2108 "page.c"
			} else {
#line 562 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp57_ = FALSE;
#line 2112 "page.c"
			}
#line 562 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			if (_tmp57_) {
#line 2116 "page.c"
				guchar p = '\0';
				guchar* _tmp60_ = NULL;
				gint _tmp60__length1 = 0;
				gint _tmp61_ = 0;
				gint _tmp62_ = 0;
				guchar _tmp63_ = '\0';
				gint _tmp64_ = 0;
				guchar _tmp65_ = '\0';
				gint _tmp66_ = 0;
				guchar* _tmp67_ = NULL;
				gint _tmp67__length1 = 0;
				gint _tmp68_ = 0;
				guchar* _tmp69_ = NULL;
				gint _tmp69__length1 = 0;
				gint _tmp70_ = 0;
				guchar* _tmp71_ = NULL;
				gint _tmp71__length1 = 0;
				gint _tmp72_ = 0;
				guchar _tmp73_ = '\0';
				guchar _tmp74_ = '\0';
				guchar _tmp75_ = '\0';
#line 564 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp60_ = self->priv->pixels;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp60__length1 = self->priv->pixels_length1;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp61_ = line_offset;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp62_ = x;
#line 564 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp63_ = _tmp60_[_tmp61_ + (_tmp62_ / 8)];
#line 564 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				p = _tmp63_;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp65_ = p;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp66_ = x;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (((gint) (_tmp65_ & (0x80 >> (_tmp66_ % 8)))) != 0) {
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp64_ = 0x00;
#line 2158 "page.c"
				} else {
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp64_ = 0xFF;
#line 2162 "page.c"
				}
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp67_ = pixel;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp67__length1 = pixel_length1;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp68_ = offset;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp69_ = pixel;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp69__length1 = pixel_length1;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp70_ = offset;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp71_ = pixel;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp71__length1 = pixel_length1;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp72_ = offset;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp71_[_tmp72_ + 2] = (guchar) _tmp64_;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp73_ = _tmp71_[_tmp72_ + 2];
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp69_[_tmp70_ + 1] = _tmp73_;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp74_ = _tmp69_[_tmp70_ + 1];
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp67_[_tmp68_ + 0] = _tmp74_;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp75_ = _tmp67_[_tmp68_ + 0];
#line 566 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				return;
#line 2196 "page.c"
			} else {
				gboolean _tmp76_ = FALSE;
				gint _tmp77_ = 0;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp77_ = self->priv->_depth;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (_tmp77_ == 2) {
#line 2204 "page.c"
					gint _tmp78_ = 0;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp78_ = self->priv->_n_channels;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp76_ = _tmp78_ == 1;
#line 2210 "page.c"
				} else {
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp76_ = FALSE;
#line 2214 "page.c"
				}
#line 570 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (_tmp76_) {
#line 2218 "page.c"
					gint block_shift[4] = {0};
					gint _tmp79_[4] = {0};
					guchar p = '\0';
					guchar* _tmp80_ = NULL;
					gint _tmp80__length1 = 0;
					gint _tmp81_ = 0;
					gint _tmp82_ = 0;
					guchar _tmp83_ = '\0';
					gint sample = 0;
					guchar _tmp84_ = '\0';
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					gint _tmp87_ = 0;
					guchar* _tmp88_ = NULL;
					gint _tmp88__length1 = 0;
					gint _tmp89_ = 0;
					guchar* _tmp90_ = NULL;
					gint _tmp90__length1 = 0;
					gint _tmp91_ = 0;
					guchar* _tmp92_ = NULL;
					gint _tmp92__length1 = 0;
					gint _tmp93_ = 0;
					gint _tmp94_ = 0;
					guchar _tmp95_ = '\0';
					guchar _tmp96_ = '\0';
					guchar _tmp97_ = '\0';
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp79_[0] = 6;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp79_[1] = 4;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp79_[2] = 2;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp79_[3] = 0;
#line 572 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					memcpy (block_shift, _tmp79_, 4 * sizeof (gint));
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp80_ = self->priv->pixels;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp80__length1 = self->priv->pixels_length1;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp81_ = line_offset;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp82_ = x;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp83_ = _tmp80_[_tmp81_ + (_tmp82_ / 4)];
#line 574 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					p = _tmp83_;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp84_ = p;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp85_ = x;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp86_ = block_shift[_tmp85_ % 4];
#line 575 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					sample = (_tmp84_ >> _tmp86_) & 0x3;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp87_ = sample;
#line 576 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					sample = (_tmp87_ * 255) / 3;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp88_ = pixel;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp88__length1 = pixel_length1;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp89_ = offset;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp90_ = pixel;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp90__length1 = pixel_length1;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp91_ = offset;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp92_ = pixel;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp92__length1 = pixel_length1;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp93_ = offset;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp94_ = sample;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp92_[_tmp93_ + 2] = (guchar) _tmp94_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp95_ = _tmp92_[_tmp93_ + 2];
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp90_[_tmp91_ + 1] = _tmp95_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp96_ = _tmp90_[_tmp91_ + 1];
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp88_[_tmp89_ + 0] = _tmp96_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp97_ = _tmp88_[_tmp89_ + 0];
#line 579 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					return;
#line 2313 "page.c"
				}
			}
		}
	}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp98_ = pixel;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp98__length1 = pixel_length1;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp99_ = offset;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp100_ = self->priv->pixels;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp100__length1 = self->priv->pixels_length1;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp101_ = line_offset;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp102_ = x;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp103_ = self->priv->_depth;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp104_ = self->priv->_n_channels;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp105_ = page_get_sample (self, _tmp100_, _tmp100__length1, _tmp101_, _tmp102_, _tmp103_, _tmp104_, 0);
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp98_[_tmp99_ + 0] = _tmp105_;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp106_ = _tmp98_[_tmp99_ + 0];
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp107_ = pixel;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp107__length1 = pixel_length1;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp108_ = offset;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp109_ = self->priv->pixels;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp109__length1 = self->priv->pixels_length1;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp110_ = line_offset;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp111_ = x;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp112_ = self->priv->_depth;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp113_ = self->priv->_n_channels;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp114_ = page_get_sample (self, _tmp109_, _tmp109__length1, _tmp110_, _tmp111_, _tmp112_, _tmp113_, 1);
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp107_[_tmp108_ + 1] = _tmp114_;
#line 584 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp115_ = _tmp107_[_tmp108_ + 1];
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp116_ = pixel;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp116__length1 = pixel_length1;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp117_ = offset;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp118_ = self->priv->pixels;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp118__length1 = self->priv->pixels_length1;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp119_ = line_offset;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp120_ = x;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp121_ = self->priv->_depth;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp122_ = self->priv->_n_channels;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp123_ = page_get_sample (self, _tmp118_, _tmp118__length1, _tmp119_, _tmp120_, _tmp121_, _tmp122_, 2);
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp116_[_tmp117_ + 2] = _tmp123_;
#line 585 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp124_ = _tmp116_[_tmp117_ + 2];
#line 2390 "page.c"
}


GdkPixbuf* page_get_image (Page* self, gboolean apply_crop) {
	GdkPixbuf* result = NULL;
	gint l = 0;
	gint r = 0;
	gint t = 0;
	gint b = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkPixbuf* image = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkPixbuf* _tmp29_ = NULL;
	guint8* image_pixels = NULL;
	GdkPixbuf* _tmp30_ = NULL;
	guint8* _tmp31_ = NULL;
	gint image_pixels_length1 = 0;
	gint _image_pixels_size_ = 0;
#line 588 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = apply_crop;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp1_) {
#line 2419 "page.c"
		gboolean _tmp2_ = FALSE;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp2_ = self->priv->_has_crop;
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = _tmp2_;
#line 2425 "page.c"
	} else {
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = FALSE;
#line 2429 "page.c"
	}
#line 591 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp0_) {
#line 2433 "page.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = self->priv->_crop_x;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		l = _tmp3_;
#line 594 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp4_ = l;
#line 594 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp5_ = self->priv->_crop_width;
#line 594 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		r = _tmp4_ + _tmp5_;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = self->priv->_crop_y;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		t = _tmp6_;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp7_ = t;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp8_ = self->priv->_crop_height;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		b = _tmp7_ + _tmp8_;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp9_ = l;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp9_ < 0) {
#line 599 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			l = 0;
#line 2474 "page.c"
		}
#line 600 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp10_ = r;
#line 600 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp11_ = page_get_width (self);
#line 600 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp12_ = _tmp11_;
#line 600 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp10_ > _tmp12_) {
#line 2484 "page.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp13_ = page_get_width (self);
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp14_ = _tmp13_;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			r = _tmp14_;
#line 2493 "page.c"
		}
#line 602 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp15_ = t;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp15_ < 0) {
#line 603 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			t = 0;
#line 2501 "page.c"
		}
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp16_ = b;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp17_ = page_get_height (self);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp18_ = _tmp17_;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp16_ > _tmp18_) {
#line 2511 "page.c"
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp19_ = page_get_height (self);
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp20_ = _tmp19_;
#line 605 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			b = _tmp20_;
#line 2520 "page.c"
		}
	} else {
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
#line 609 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		l = 0;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp21_ = page_get_width (self);
#line 610 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp22_ = _tmp21_;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		r = _tmp22_;
#line 611 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		t = 0;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp23_ = page_get_height (self);
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_ = _tmp23_;
#line 612 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		b = _tmp24_;
#line 2543 "page.c"
	}
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp25_ = r;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp26_ = l;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp27_ = b;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp28_ = t;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp29_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp25_ - _tmp26_, _tmp27_ - _tmp28_);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	image = _tmp29_;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp30_ = image;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp31_ = gdk_pixbuf_get_pixels (_tmp30_);
#line 616 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	image_pixels = _tmp31_;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	image_pixels_length1 = -1;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_image_pixels_size_ = image_pixels_length1;
#line 2567 "page.c"
	{
		gint y = 0;
		gint _tmp32_ = 0;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp32_ = t;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		y = _tmp32_;
#line 2575 "page.c"
		{
			gboolean _tmp33_ = FALSE;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp33_ = TRUE;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			while (TRUE) {
#line 2582 "page.c"
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gint offset = 0;
				GdkPixbuf* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (!_tmp33_) {
#line 2592 "page.c"
					gint _tmp34_ = 0;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp34_ = y;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					y = _tmp34_ + 1;
#line 2598 "page.c"
				}
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp33_ = FALSE;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp35_ = y;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp36_ = b;
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (!(_tmp35_ < _tmp36_)) {
#line 617 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					break;
#line 2610 "page.c"
				}
#line 619 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp37_ = image;
#line 619 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp38_ = gdk_pixbuf_get_rowstride (_tmp37_);
#line 619 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp39_ = y;
#line 619 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp40_ = t;
#line 619 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				offset = _tmp38_ * (_tmp39_ - _tmp40_);
#line 2622 "page.c"
				{
					gint x = 0;
					gint _tmp41_ = 0;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp41_ = l;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					x = _tmp41_;
#line 2630 "page.c"
					{
						gboolean _tmp42_ = FALSE;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
						_tmp42_ = TRUE;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
						while (TRUE) {
#line 2637 "page.c"
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							guint8* _tmp48_ = NULL;
							gint _tmp48__length1 = 0;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							if (!_tmp42_) {
#line 2649 "page.c"
								gint _tmp43_ = 0;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
								_tmp43_ = x;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
								x = _tmp43_ + 1;
#line 2655 "page.c"
							}
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp42_ = FALSE;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp44_ = x;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp45_ = r;
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							if (!(_tmp44_ < _tmp45_)) {
#line 620 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
								break;
#line 2667 "page.c"
							}
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp46_ = x;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp47_ = y;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp48_ = image_pixels;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp48__length1 = image_pixels_length1;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp49_ = offset;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp50_ = x;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							_tmp51_ = l;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
							page_get_pixel (self, _tmp46_, _tmp47_, _tmp48_, _tmp48__length1, _tmp49_ + ((_tmp50_ - _tmp51_) * 3));
#line 2685 "page.c"
						}
					}
				}
			}
		}
	}
#line 624 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = image;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 2696 "page.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 1307 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1308 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1309 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1309 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1310 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 2751 "page.c"
	}
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1311 "/usr/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 2757 "page.c"
}


static gchar* page_get_icc_data_encoded (Page* self, const gchar* icc_profile_filename) {
	gchar* result = NULL;
	gchar* contents = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (icc_profile_filename != NULL, NULL);
#line 2776 "page.c"
	{
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = icc_profile_filename;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_file_get_contents (_tmp0_, &_tmp1_, NULL, &_inner_error_);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_g_free0 (contents);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		contents = _tmp1_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2790 "page.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		e = _inner_error_;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_inner_error_ = NULL;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp2_ = e;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = _tmp2_->message;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_warning ("page.vala:637: failed to get icc profile data: %s", _tmp3_);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		result = NULL;
#line 638 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_g_error_free0 (e);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_g_free0 (contents);
#line 638 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return result;
#line 2818 "page.c"
	}
	__finally3:
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_g_free0 (contents);
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_clear_error (&_inner_error_);
#line 631 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return NULL;
#line 2831 "page.c"
	}
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp4_ = contents;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp6_ = string_to_utf8 (_tmp4_, &_tmp5_);
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7_ = (guchar*) _tmp6_;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7__length1 = (_tmp5_ * sizeof (gchar)) / sizeof (guchar);
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp8_ = g_base64_encode (_tmp7_, (_tmp5_ * sizeof (gchar)) / sizeof (guchar));
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp9_ = _tmp8_;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7_ = (g_free (_tmp7_), NULL);
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp9_;
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_free0 (contents);
#line 642 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 2853 "page.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 647 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return self ? g_object_ref (self) : NULL;
#line 2860 "page.c"
}


void page_copy_to_clipboard (Page* self, GtkWindow* window) {
	GdkDisplay* display = NULL;
	GtkWindow* _tmp0_ = NULL;
	GdkDisplay* _tmp1_ = NULL;
	GdkDisplay* _tmp2_ = NULL;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp3_ = NULL;
	GtkClipboard* _tmp4_ = NULL;
	GdkPixbuf* image = NULL;
	GdkPixbuf* _tmp5_ = NULL;
#line 645 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 645 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (window != NULL);
#line 647 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = window;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = gtk_widget_get_display ((GtkWidget*) _tmp0_);
#line 647 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 647 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	display = _tmp2_;
#line 648 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = gtk_clipboard_get_for_display (display, GDK_SELECTION_CLIPBOARD);
#line 648 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 648 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	clipboard = _tmp4_;
#line 649 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp5_ = page_get_image (self, TRUE);
#line 649 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	image = _tmp5_;
#line 650 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	gtk_clipboard_set_image (clipboard, image);
#line 645 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_object_unref0 (image);
#line 645 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_object_unref0 (clipboard);
#line 645 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_object_unref0 (display);
#line 2904 "page.c"
}


void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GFileOutputStream* stream = NULL;
	GFile* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
	PixbufWriter* writer = NULL;
	GFileOutputStream* _tmp2_ = NULL;
	PixbufWriter* _tmp3_ = NULL;
	GdkPixbuf* image = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	gchar* icc_profile_data = NULL;
	const gchar* _tmp5_ = NULL;
	GCompareFunc _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GError * _inner_error_ = NULL;
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (type != NULL);
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (file != NULL);
#line 655 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = file;
#line 655 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 655 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	stream = _tmp1_;
#line 655 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 655 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 655 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return;
#line 2941 "page.c"
	}
#line 656 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = stream;
#line 656 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = pixbuf_writer_new (_tmp2_);
#line 656 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	writer = _tmp3_;
#line 657 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp4_ = page_get_image (self, TRUE);
#line 657 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	image = _tmp4_;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	icc_profile_data = NULL;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp5_ = self->priv->_color_profile;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp5_ != NULL) {
#line 2959 "page.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 661 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = self->priv->_color_profile;
#line 661 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp7_ = page_get_icc_data_encoded (self, _tmp6_);
#line 661 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_g_free0 (icc_profile_data);
#line 661 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		icc_profile_data = _tmp7_;
#line 2970 "page.c"
	}
#line 663 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp8_ = g_strcmp0;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp9_ = type;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp10_ = _tmp8_ (_tmp9_, "jpeg");
#line 663 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp10_ == 0) {
#line 2980 "page.c"
		gchar** keys = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar** _tmp15_ = NULL;
		gint keys_length1 = 0;
		gint _keys_size_ = 0;
		gchar** values = NULL;
		gint _tmp16_ = 0;
		gchar* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint values_length1 = 0;
		gint _values_size_ = 0;
		const gchar* _tmp25_ = NULL;
		PixbufWriter* _tmp28_ = NULL;
		GdkPixbuf* _tmp29_ = NULL;
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp11_ = g_strdup ("x-dpi");
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp12_ = g_strdup ("y-dpi");
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp13_ = g_strdup ("quality");
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp14_ = g_strdup ("icc-profile");
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp15_ = g_new0 (gchar*, 5 + 1);
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp15_[0] = _tmp11_;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp15_[1] = _tmp12_;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp15_[2] = _tmp13_;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp15_[3] = _tmp14_;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp15_[4] = NULL;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		keys = _tmp15_;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		keys_length1 = 5;
#line 665 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_keys_size_ = keys_length1;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp16_ = self->priv->_dpi;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp17_ = g_strdup_printf ("%d", _tmp16_);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp18_ = self->priv->_dpi;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp19_ = g_strdup_printf ("%d", _tmp18_);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp20_ = quality;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp21_ = g_strdup_printf ("%d", _tmp20_);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp22_ = icc_profile_data;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp23_ = g_strdup (_tmp22_);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_ = g_new0 (gchar*, 5 + 1);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_[0] = _tmp17_;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_[1] = _tmp19_;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_[2] = _tmp21_;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_[3] = _tmp23_;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp24_[4] = NULL;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		values = _tmp24_;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		values_length1 = 5;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_values_size_ = values_length1;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp25_ = icc_profile_data;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp25_ == NULL) {
#line 3072 "page.c"
			gchar** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			gchar* _tmp27_ = NULL;
#line 668 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp26_ = keys;
#line 668 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp26__length1 = keys_length1;
#line 668 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_g_free0 (_tmp26_[3]);
#line 668 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp26_[3] = NULL;
#line 668 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp27_ = _tmp26_[3];
#line 3086 "page.c"
		}
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp28_ = writer;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp29_ = image;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp30_ = keys;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp30__length1 = keys_length1;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp31_ = values;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp31__length1 = values_length1;
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		pixbuf_writer_save (_tmp28_, _tmp29_, "jpeg", _tmp30_, _tmp30__length1, _tmp31_, _tmp31__length1, &_inner_error_);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			g_propagate_error (error, _inner_error_);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_g_free0 (icc_profile_data);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_g_object_unref0 (image);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_pixbuf_writer_unref0 (writer);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_g_object_unref0 (stream);
#line 669 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			return;
#line 3120 "page.c"
		}
#line 663 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 663 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3126 "page.c"
	} else {
		GCompareFunc _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		gint _tmp34_ = 0;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp32_ = g_strcmp0;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp33_ = type;
#line 671 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp34_ = _tmp32_ (_tmp33_, "png");
#line 671 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (_tmp34_ == 0) {
#line 3139 "page.c"
			gchar** keys = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar** _tmp38_ = NULL;
			gint keys_length1 = 0;
			gint _keys_size_ = 0;
			gchar** values = NULL;
			gint _tmp39_ = 0;
			gchar* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar** _tmp45_ = NULL;
			gint values_length1 = 0;
			gint _values_size_ = 0;
			const gchar* _tmp46_ = NULL;
			PixbufWriter* _tmp49_ = NULL;
			GdkPixbuf* _tmp50_ = NULL;
			gchar** _tmp51_ = NULL;
			gint _tmp51__length1 = 0;
			gchar** _tmp52_ = NULL;
			gint _tmp52__length1 = 0;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp35_ = g_strdup ("x-dpi");
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp36_ = g_strdup ("y-dpi");
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp37_ = g_strdup ("icc-profile");
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp38_ = g_new0 (gchar*, 4 + 1);
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp38_[0] = _tmp35_;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp38_[1] = _tmp36_;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp38_[2] = _tmp37_;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp38_[3] = NULL;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			keys = _tmp38_;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			keys_length1 = 4;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_keys_size_ = keys_length1;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp39_ = self->priv->_dpi;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp40_ = g_strdup_printf ("%d", _tmp39_);
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp41_ = self->priv->_dpi;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp42_ = g_strdup_printf ("%d", _tmp41_);
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp43_ = icc_profile_data;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp44_ = g_strdup (_tmp43_);
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp45_ = g_new0 (gchar*, 4 + 1);
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp45_[0] = _tmp40_;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp45_[1] = _tmp42_;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp45_[2] = _tmp44_;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp45_[3] = NULL;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			values = _tmp45_;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			values_length1 = 4;
#line 674 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_values_size_ = values_length1;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp46_ = icc_profile_data;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			if (_tmp46_ == NULL) {
#line 3218 "page.c"
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gchar* _tmp48_ = NULL;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp47_ = keys;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp47__length1 = keys_length1;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_g_free0 (_tmp47_[2]);
#line 676 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp47_[2] = NULL;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp48_ = _tmp47_[2];
#line 3232 "page.c"
			}
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp49_ = writer;
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp50_ = image;
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp51_ = keys;
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp51__length1 = keys_length1;
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp52_ = values;
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp52__length1 = values_length1;
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			pixbuf_writer_save (_tmp49_, _tmp50_, "png", _tmp51_, _tmp51__length1, _tmp52_, _tmp52__length1, &_inner_error_);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				g_propagate_error (error, _inner_error_);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_g_free0 (icc_profile_data);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_g_object_unref0 (image);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_pixbuf_writer_unref0 (writer);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_g_object_unref0 (stream);
#line 677 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				return;
#line 3266 "page.c"
			}
#line 671 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 671 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3272 "page.c"
		} else {
			GCompareFunc _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			gint _tmp55_ = 0;
#line 679 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp53_ = g_strcmp0;
#line 679 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp54_ = type;
#line 679 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			_tmp55_ = _tmp53_ (_tmp54_, "tiff");
#line 679 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			if (_tmp55_ == 0) {
#line 3285 "page.c"
				gchar** keys = NULL;
				gchar* _tmp56_ = NULL;
				gchar* _tmp57_ = NULL;
				gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				gchar** _tmp60_ = NULL;
				gint keys_length1 = 0;
				gint _keys_size_ = 0;
				gchar** values = NULL;
				gint _tmp61_ = 0;
				gchar* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				const gchar* _tmp66_ = NULL;
				gchar* _tmp67_ = NULL;
				gchar** _tmp68_ = NULL;
				gint values_length1 = 0;
				gint _values_size_ = 0;
				const gchar* _tmp69_ = NULL;
				PixbufWriter* _tmp72_ = NULL;
				GdkPixbuf* _tmp73_ = NULL;
				gchar** _tmp74_ = NULL;
				gint _tmp74__length1 = 0;
				gchar** _tmp75_ = NULL;
				gint _tmp75__length1 = 0;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp56_ = g_strdup ("x-dpi");
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp57_ = g_strdup ("y-dpi");
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp58_ = g_strdup ("compression");
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp59_ = g_strdup ("icc-profile");
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp60_ = g_new0 (gchar*, 5 + 1);
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp60_[0] = _tmp56_;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp60_[1] = _tmp57_;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp60_[2] = _tmp58_;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp60_[3] = _tmp59_;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp60_[4] = NULL;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				keys = _tmp60_;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				keys_length1 = 5;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_keys_size_ = keys_length1;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp61_ = self->priv->_dpi;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp62_ = g_strdup_printf ("%d", _tmp61_);
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp63_ = self->priv->_dpi;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp64_ = g_strdup_printf ("%d", _tmp63_);
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp65_ = g_strdup ("8");
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp66_ = icc_profile_data;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp67_ = g_strdup (_tmp66_);
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp68_ = g_new0 (gchar*, 5 + 1);
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp68_[0] = _tmp62_;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp68_[1] = _tmp64_;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp68_[2] = _tmp65_;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp68_[3] = _tmp67_;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp68_[4] = NULL;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				values = _tmp68_;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				values_length1 = 5;
#line 682 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_values_size_ = values_length1;
#line 683 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp69_ = icc_profile_data;
#line 683 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (_tmp69_ == NULL) {
#line 3374 "page.c"
					gchar** _tmp70_ = NULL;
					gint _tmp70__length1 = 0;
					gchar* _tmp71_ = NULL;
#line 684 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp70_ = keys;
#line 684 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp70__length1 = keys_length1;
#line 684 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_g_free0 (_tmp70_[3]);
#line 684 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp70_[3] = NULL;
#line 684 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_tmp71_ = _tmp70_[3];
#line 3388 "page.c"
				}
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp72_ = writer;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp73_ = image;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp74_ = keys;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp74__length1 = keys_length1;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp75_ = values;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp75__length1 = values_length1;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				pixbuf_writer_save (_tmp72_, _tmp73_, "tiff", _tmp74_, _tmp74__length1, _tmp75_, _tmp75__length1, &_inner_error_);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					g_propagate_error (error, _inner_error_);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_g_free0 (icc_profile_data);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_g_object_unref0 (image);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_pixbuf_writer_unref0 (writer);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					_g_object_unref0 (stream);
#line 685 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
					return;
#line 3422 "page.c"
				}
#line 679 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 679 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 3428 "page.c"
			} else {
				const gchar* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				GError* _tmp79_ = NULL;
				GError* _tmp80_ = NULL;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp76_ = type;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp77_ = g_strdup_printf ("Unknown file type: %s", _tmp76_);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp78_ = _tmp77_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp79_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_INVAL, _tmp78_);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp80_ = _tmp79_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_g_free0 (_tmp78_);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_inner_error_ = _tmp80_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				g_propagate_error (error, _inner_error_);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_g_free0 (icc_profile_data);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_g_object_unref0 (image);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_pixbuf_writer_unref0 (writer);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_g_object_unref0 (stream);
#line 688 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				return;
#line 3461 "page.c"
			}
		}
	}
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_free0 (icc_profile_data);
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_object_unref0 (image);
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_pixbuf_writer_unref0 (writer);
#line 653 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_object_unref0 (stream);
#line 3473 "page.c"
}


gint page_get_width (Page* self) {
	gint result;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
#line 25 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = page_get_scan_direction (self);
#line 27 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = _tmp1_;
#line 27 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp2_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 27 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = TRUE;
#line 3492 "page.c"
	} else {
		ScanDirection _tmp3_ = 0;
		ScanDirection _tmp4_ = 0;
#line 27 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = page_get_scan_direction (self);
#line 27 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp4_ = _tmp3_;
#line 27 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = _tmp4_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 3502 "page.c"
	}
#line 27 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp0_) {
#line 3506 "page.c"
		gint _tmp5_ = 0;
#line 28 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp5_ = self->priv->_scan_width;
#line 28 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		result = _tmp5_;
#line 28 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return result;
#line 3514 "page.c"
	} else {
		gint _tmp6_ = 0;
#line 30 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = self->priv->_scan_height;
#line 30 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		result = _tmp6_;
#line 30 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return result;
#line 3523 "page.c"
	}
}


gint page_get_height (Page* self) {
	gint result;
	gboolean _tmp0_ = FALSE;
	ScanDirection _tmp1_ = 0;
	ScanDirection _tmp2_ = 0;
#line 37 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = page_get_scan_direction (self);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = _tmp1_;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp2_ == SCAN_DIRECTION_TOP_TO_BOTTOM) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = TRUE;
#line 3543 "page.c"
	} else {
		ScanDirection _tmp3_ = 0;
		ScanDirection _tmp4_ = 0;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp3_ = page_get_scan_direction (self);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp4_ = _tmp3_;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp0_ = _tmp4_ == SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 3553 "page.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp0_) {
#line 3557 "page.c"
		gint _tmp5_ = 0;
#line 40 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp5_ = self->priv->_scan_height;
#line 40 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		result = _tmp5_;
#line 40 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return result;
#line 3565 "page.c"
	} else {
		gint _tmp6_ = 0;
#line 42 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp6_ = self->priv->_scan_width;
#line 42 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		result = _tmp6_;
#line 42 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return result;
#line 3574 "page.c"
	}
}


gboolean page_get_is_landscape (Page* self) {
	gboolean result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = page_get_width (self);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _tmp0_;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = page_get_height (self);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = _tmp2_;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp1_ > _tmp3_;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3599 "page.c"
}


gint page_get_dpi (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 50 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 50 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_dpi;
#line 50 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 50 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3614 "page.c"
}


static void page_set_dpi (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 50 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 50 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_dpi = _tmp0_;
#line 3626 "page.c"
}


gint page_get_depth (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_depth;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3641 "page.c"
}


static void page_set_depth (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_depth = _tmp0_;
#line 3653 "page.c"
}


const gchar* page_get_color_profile (Page* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_color_profile;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3668 "page.c"
}


void page_set_color_profile (Page* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_free0 (self->priv->_color_profile);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_color_profile = _tmp1_;
#line 3685 "page.c"
}


gint page_get_scan_width (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 62 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_scan_width;
#line 62 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 62 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3700 "page.c"
}


static void page_set_scan_width (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 62 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 62 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_scan_width = _tmp0_;
#line 3712 "page.c"
}


gint page_get_scan_height (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_scan_height;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3727 "page.c"
}


static void page_set_scan_height (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_scan_height = _tmp0_;
#line 3739 "page.c"
}


gint page_get_rowstride (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 68 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 68 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_rowstride;
#line 68 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 68 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3754 "page.c"
}


static void page_set_rowstride (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 68 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 68 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_rowstride = _tmp0_;
#line 3766 "page.c"
}


gint page_get_n_channels (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 71 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_n_channels;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3781 "page.c"
}


static void page_set_n_channels (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_n_channels = _tmp0_;
#line 3793 "page.c"
}


gboolean page_get_is_scanning (Page* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 77 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_is_scanning;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3808 "page.c"
}


static void page_set_is_scanning (Page* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_is_scanning = _tmp0_;
#line 3820 "page.c"
}


gboolean page_get_has_data (Page* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 80 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 80 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_has_data;
#line 80 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 80 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3835 "page.c"
}


static void page_set_has_data (Page* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 80 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 80 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 80 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_has_data = _tmp0_;
#line 3847 "page.c"
}


gint page_get_scan_line (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 83 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 83 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_scan_line;
#line 83 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 83 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3862 "page.c"
}


static void page_set_scan_line (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 83 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 83 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_scan_line = _tmp0_;
#line 3874 "page.c"
}


gboolean page_get_is_color (Page* self) {
	gboolean result;
	gint _tmp0_ = 0;
#line 86 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 86 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_n_channels;
#line 86 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_ > 1;
#line 86 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3889 "page.c"
}


ScanDirection page_get_scan_direction (Page* self) {
	ScanDirection result;
	ScanDirection _tmp0_ = 0;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->scan_direction_;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 92 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 3904 "page.c"
}


void page_set_scan_direction (Page* self, ScanDirection value) {
	ScanDirection _tmp0_ = 0;
	ScanDirection _tmp1_ = 0;
	gboolean size_has_changed = FALSE;
	gint left_steps = 0;
	ScanDirection _tmp2_ = 0;
	ScanDirection _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	ScanDirection _tmp35_ = 0;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
#line 94 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->scan_direction_;
#line 96 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = value;
#line 96 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp0_ == _tmp1_) {
#line 97 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return;
#line 3931 "page.c"
	}
#line 100 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	size_has_changed = FALSE;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = value;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = self->priv->scan_direction_;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	left_steps = (gint) (_tmp2_ - _tmp3_);
#line 102 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp4_ = left_steps;
#line 102 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp4_ < 0) {
#line 3945 "page.c"
		gint _tmp5_ = 0;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp5_ = left_steps;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		left_steps = _tmp5_ + 4;
#line 3951 "page.c"
	}
#line 104 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp6_ = left_steps;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp6_ != 2) {
#line 105 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		size_has_changed = TRUE;
#line 3959 "page.c"
	}
#line 108 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp7_ = self->priv->_has_crop;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp7_) {
#line 3965 "page.c"
		gint _tmp8_ = 0;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		_tmp8_ = left_steps;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		switch (_tmp8_) {
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			case 1:
#line 3973 "page.c"
			{
				gint t = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp9_ = self->priv->_crop_x;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				t = _tmp9_;
#line 115 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp10_ = self->priv->_crop_y;
#line 115 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_x (self, _tmp10_);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp11_ = page_get_width (self);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp12_ = _tmp11_;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp13_ = t;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp14_ = self->priv->_crop_width;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_y (self, _tmp12_ - (_tmp13_ + _tmp14_));
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp15_ = self->priv->_crop_width;
#line 117 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				t = _tmp15_;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp16_ = self->priv->_crop_height;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_width (self, _tmp16_);
#line 119 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp17_ = t;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_height (self, _tmp17_);
#line 120 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 4017 "page.c"
			}
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			case 2:
#line 4021 "page.c"
			{
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp18_ = page_get_width (self);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp19_ = _tmp18_;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp20_ = self->priv->_crop_x;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp21_ = self->priv->_crop_width;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_x (self, _tmp19_ - (_tmp20_ + _tmp21_));
#line 124 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp22_ = page_get_width (self);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp23_ = _tmp22_;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp24_ = self->priv->_crop_y;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp25_ = self->priv->_crop_height;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_y (self, _tmp23_ - (_tmp24_ + _tmp25_));
#line 125 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 4053 "page.c"
			}
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			case 3:
#line 4057 "page.c"
			{
				gint t = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp26_ = self->priv->_crop_y;
#line 128 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				t = _tmp26_;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp27_ = self->priv->_crop_x;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_y (self, _tmp27_);
#line 130 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp28_ = page_get_height (self);
#line 130 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp29_ = _tmp28_;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp30_ = t;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp31_ = self->priv->_crop_height;
#line 130 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_x (self, _tmp29_ - (_tmp30_ + _tmp31_));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp32_ = self->priv->_crop_width;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				t = _tmp32_;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp33_ = self->priv->_crop_height;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_width (self, _tmp33_);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				_tmp34_ = t;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				page_set_crop_height (self, _tmp34_);
#line 134 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
				break;
#line 4101 "page.c"
			}
			default:
#line 110 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			break;
#line 4106 "page.c"
		}
	}
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp35_ = value;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->scan_direction_ = _tmp35_;
#line 139 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp36_ = size_has_changed;
#line 139 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp36_) {
#line 140 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_signal_emit_by_name (self, "size-changed");
#line 4119 "page.c"
	}
#line 141 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_emit_by_name (self, "scan-direction-changed");
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp37_ = self->priv->_has_crop;
#line 142 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (_tmp37_) {
#line 143 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_signal_emit_by_name (self, "crop-changed");
#line 4129 "page.c"
	}
}


gboolean page_get_has_crop (Page* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_has_crop;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 4145 "page.c"
}


static void page_set_has_crop (Page* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_has_crop = _tmp0_;
#line 4157 "page.c"
}


const gchar* page_get_crop_name (Page* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_crop_name;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 4172 "page.c"
}


static void page_set_crop_name (Page* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_free0 (self->priv->_crop_name);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_crop_name = _tmp1_;
#line 4189 "page.c"
}


gint page_get_crop_x (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_crop_x;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 4204 "page.c"
}


static void page_set_crop_x (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_crop_x = _tmp0_;
#line 4216 "page.c"
}


gint page_get_crop_y (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_crop_y;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 4231 "page.c"
}


static void page_set_crop_y (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_crop_y = _tmp0_;
#line 4243 "page.c"
}


gint page_get_crop_width (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_crop_width;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 4258 "page.c"
}


static void page_set_crop_width (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 162 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 162 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_crop_width = _tmp0_;
#line 4270 "page.c"
}


gint page_get_crop_height (Page* self) {
	gint result;
	gint _tmp0_ = 0;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->priv->_crop_height;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = _tmp0_;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 4285 "page.c"
}


static void page_set_crop_height (Page* self, gint value) {
	gint _tmp0_ = 0;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = value;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->_crop_height = _tmp0_;
#line 4297 "page.c"
}


static void value_page_init (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	value->data[0].v_pointer = NULL;
#line 4304 "page.c"
}


static void value_page_free_value (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_unref (value->data[0].v_pointer);
#line 4313 "page.c"
	}
}


static void value_page_copy_value (const GValue* src_value, GValue* dest_value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		dest_value->data[0].v_pointer = page_ref (src_value->data[0].v_pointer);
#line 4323 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4327 "page.c"
	}
}


static gpointer value_page_peek_pointer (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return value->data[0].v_pointer;
#line 4335 "page.c"
}


static gchar* value_page_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (collect_values[0].v_pointer) {
#line 4342 "page.c"
		Page* object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4349 "page.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4353 "page.c"
		}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = page_ref (object);
#line 4357 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4361 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return NULL;
#line 4365 "page.c"
}


static gchar* value_page_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Page** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (!object_p) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4376 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		*object_p = NULL;
#line 4382 "page.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		*object_p = value->data[0].v_pointer;
#line 4386 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		*object_p = page_ref (value->data[0].v_pointer);
#line 4390 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return NULL;
#line 4394 "page.c"
}


GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPage* spec;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE), NULL);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return G_PARAM_SPEC (spec);
#line 4408 "page.c"
}


gpointer value_get_page (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE), NULL);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return value->data[0].v_pointer;
#line 4417 "page.c"
}


void value_set_page (GValue* value, gpointer v_object) {
	Page* old;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_ref (value->data[0].v_pointer);
#line 4437 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4441 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_unref (old);
#line 4447 "page.c"
	}
}


void value_take_page (GValue* value, gpointer v_object) {
	Page* old;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 4466 "page.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4470 "page.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		page_unref (old);
#line 4476 "page.c"
	}
}


static void page_class_init (PageClass * klass) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	page_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	((PageClass *) klass)->finalize = page_finalize;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_type_class_add_private (klass, sizeof (PagePrivate));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_new ("pixels_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_new ("size_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_new ("scan_line_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_new ("scan_direction_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_new ("crop_changed", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_new ("scan_finished", TYPE_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4500 "page.c"
}


static void page_instance_init (Page * self) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv = PAGE_GET_PRIVATE (self);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->ref_count = 1;
#line 4509 "page.c"
}


static void page_finalize (Page* obj) {
	Page * self;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE, Page);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_handlers_destroy (self);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_free0 (self->priv->_color_profile);
#line 74 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->priv->pixels = (g_free (self->priv->pixels), NULL);
#line 153 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_free0 (self->priv->_crop_name);
#line 4525 "page.c"
}


GType page_get_type (void) {
	static volatile gsize page_type_id__volatile = 0;
	if (g_once_init_enter (&page_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_init, value_page_free_value, value_page_copy_value, value_page_peek_pointer, "p", value_page_collect_value, "p", value_page_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Page), 0, (GInstanceInitFunc) page_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_type_id;
		page_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Page", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_type_id__volatile, page_type_id);
	}
	return page_type_id__volatile;
}


gpointer page_ref (gpointer instance) {
	Page* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return instance;
#line 4550 "page.c"
}


void page_unref (gpointer instance) {
	Page* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		PAGE_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4563 "page.c"
	}
}


PixbufWriter* pixbuf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PixbufWriter* self = NULL;
	GFileOutputStream* _tmp0_ = NULL;
	GFileOutputStream* _tmp1_ = NULL;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 696 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self = (PixbufWriter*) g_type_create_instance (object_type);
#line 698 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = stream;
#line 698 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 698 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_object_unref0 (self->stream);
#line 698 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->stream = _tmp1_;
#line 696 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return self;
#line 4586 "page.c"
}


PixbufWriter* pixbuf_writer_new (GFileOutputStream* stream) {
#line 696 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return pixbuf_writer_construct (TYPE_PIXBUF_WRITER, stream);
#line 4593 "page.c"
}


static gboolean _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = pixbuf_writer_write_pixbuf_data ((PixbufWriter*) self, buf, buf_length1, error);
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 4602 "page.c"
}


void pixbuf_writer_save (PixbufWriter* self, GdkPixbuf* image, const gchar* type, gchar** option_keys, int option_keys_length1, gchar** option_values, int option_values_length1, GError** error) {
	GdkPixbuf* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GError * _inner_error_ = NULL;
#line 701 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (self != NULL);
#line 701 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (image != NULL);
#line 701 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (type != NULL);
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = image;
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = type;
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2_ = option_keys;
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp2__length1 = option_keys_length1;
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3_ = option_values;
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp3__length1 = option_values_length1;
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	gdk_pixbuf_save_to_callbackv (_tmp0_, _pixbuf_writer_write_pixbuf_data_gdk_pixbuf_save_func, self, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 703 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return;
#line 4640 "page.c"
	}
}


static gboolean pixbuf_writer_write_pixbuf_data (PixbufWriter* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GFileOutputStream* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GError * _inner_error_ = NULL;
#line 706 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 708 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp0_ = self->stream;
#line 708 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1_ = buf;
#line 708 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_tmp1__length1 = buf_length1;
#line 708 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 708 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 708 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_propagate_error (error, _inner_error_);
#line 708 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return FALSE;
#line 4667 "page.c"
	}
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	result = TRUE;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return result;
#line 4673 "page.c"
}


static void value_pixbuf_writer_init (GValue* value) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	value->data[0].v_pointer = NULL;
#line 4680 "page.c"
}


static void value_pixbuf_writer_free_value (GValue* value) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (value->data[0].v_pointer) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		pixbuf_writer_unref (value->data[0].v_pointer);
#line 4689 "page.c"
	}
}


static void value_pixbuf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (src_value->data[0].v_pointer) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		dest_value->data[0].v_pointer = pixbuf_writer_ref (src_value->data[0].v_pointer);
#line 4699 "page.c"
	} else {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4703 "page.c"
	}
}


static gpointer value_pixbuf_writer_peek_pointer (const GValue* value) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return value->data[0].v_pointer;
#line 4711 "page.c"
}


static gchar* value_pixbuf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (collect_values[0].v_pointer) {
#line 4718 "page.c"
		PixbufWriter* object;
		object = collect_values[0].v_pointer;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		if (object->parent_instance.g_class == NULL) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4725 "page.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4729 "page.c"
		}
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = pixbuf_writer_ref (object);
#line 4733 "page.c"
	} else {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4737 "page.c"
	}
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return NULL;
#line 4741 "page.c"
}


static gchar* value_pixbuf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PixbufWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (!object_p) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4752 "page.c"
	}
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (!value->data[0].v_pointer) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		*object_p = NULL;
#line 4758 "page.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		*object_p = value->data[0].v_pointer;
#line 4762 "page.c"
	} else {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		*object_p = pixbuf_writer_ref (value->data[0].v_pointer);
#line 4766 "page.c"
	}
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return NULL;
#line 4770 "page.c"
}


GParamSpec* param_spec_pixbuf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPixbufWriter* spec;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PIXBUF_WRITER), NULL);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return G_PARAM_SPEC (spec);
#line 4784 "page.c"
}


gpointer value_get_pixbuf_writer (const GValue* value) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER), NULL);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return value->data[0].v_pointer;
#line 4793 "page.c"
}


void value_set_pixbuf_writer (GValue* value, gpointer v_object) {
	PixbufWriter* old;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	old = value->data[0].v_pointer;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (v_object) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		pixbuf_writer_ref (value->data[0].v_pointer);
#line 4813 "page.c"
	} else {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4817 "page.c"
	}
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (old) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		pixbuf_writer_unref (old);
#line 4823 "page.c"
	}
}


void value_take_pixbuf_writer (GValue* value, gpointer v_object) {
	PixbufWriter* old;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PIXBUF_WRITER));
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	old = value->data[0].v_pointer;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (v_object) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PIXBUF_WRITER));
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = v_object;
#line 4842 "page.c"
	} else {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		value->data[0].v_pointer = NULL;
#line 4846 "page.c"
	}
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (old) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		pixbuf_writer_unref (old);
#line 4852 "page.c"
	}
}


static void pixbuf_writer_class_init (PixbufWriterClass * klass) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	pixbuf_writer_parent_class = g_type_class_peek_parent (klass);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	((PixbufWriterClass *) klass)->finalize = pixbuf_writer_finalize;
#line 4862 "page.c"
}


static void pixbuf_writer_instance_init (PixbufWriter * self) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self->ref_count = 1;
#line 4869 "page.c"
}


static void pixbuf_writer_finalize (PixbufWriter* obj) {
	PixbufWriter * self;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_WRITER, PixbufWriter);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_signal_handlers_destroy (self);
#line 694 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	_g_object_unref0 (self->stream);
#line 4881 "page.c"
}


GType pixbuf_writer_get_type (void) {
	static volatile gsize pixbuf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pixbuf_writer_init, value_pixbuf_writer_free_value, value_pixbuf_writer_copy_value, value_pixbuf_writer_peek_pointer, "p", value_pixbuf_writer_collect_value, "p", value_pixbuf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PixbufWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufWriter), 0, (GInstanceInitFunc) pixbuf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pixbuf_writer_type_id;
		pixbuf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PixbufWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pixbuf_writer_type_id__volatile, pixbuf_writer_type_id);
	}
	return pixbuf_writer_type_id__volatile;
}


gpointer pixbuf_writer_ref (gpointer instance) {
	PixbufWriter* self;
	self = instance;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	g_atomic_int_inc (&self->ref_count);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	return instance;
#line 4906 "page.c"
}


void pixbuf_writer_unref (gpointer instance) {
	PixbufWriter* self;
	self = instance;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		PIXBUF_WRITER_GET_CLASS (self)->finalize (self);
#line 692 "/home/bob/bzr/simple-scan/trunk/src/page.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4919 "page.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



