/* book.c generated by valac 0.20.1, the Vala compiler
 * generated from book.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-ps.h>
#include <zlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
typedef struct _BookPrivate BookPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define __g_list_free__page_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__page_unref0_ (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_PS_WRITER (ps_writer_get_type ())
#define PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PS_WRITER, PsWriter))
#define PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PS_WRITER, PsWriterClass))
#define IS_PS_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PS_WRITER))
#define IS_PS_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PS_WRITER))
#define PS_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PS_WRITER, PsWriterClass))

typedef struct _PsWriter PsWriter;
typedef struct _PsWriterClass PsWriterClass;
typedef struct _PsWriterPrivate PsWriterPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _ps_writer_unref0(var) ((var == NULL) ? NULL : (var = (ps_writer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PDF_WRITER (pdf_writer_get_type ())
#define PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PDF_WRITER, PDFWriter))
#define PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PDF_WRITER, PDFWriterClass))
#define IS_PDF_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PDF_WRITER))
#define IS_PDF_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PDF_WRITER))
#define PDF_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PDF_WRITER, PDFWriterClass))

typedef struct _PDFWriter PDFWriter;
typedef struct _PDFWriterClass PDFWriterClass;
typedef struct _PDFWriterPrivate PDFWriterPrivate;
#define _pdf_writer_unref0(var) ((var == NULL) ? NULL : (var = (pdf_writer_unref (var), NULL)))
typedef struct _ParamSpecBook ParamSpecBook;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _ParamSpecPDFWriter ParamSpecPDFWriter;
typedef struct _ParamSpecPsWriter ParamSpecPsWriter;

struct _Book {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookPrivate * priv;
};

struct _BookClass {
	GTypeClass parent_class;
	void (*finalize) (Book *self);
};

struct _BookPrivate {
	GList* pages;
	gboolean needs_saving_;
	GByteArray* jpeg_data;
};

struct _PsWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PsWriterPrivate * priv;
	cairo_surface_t* surface;
	GFileOutputStream* stream;
};

struct _PsWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PsWriter *self);
};

struct _PDFWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PDFWriterPrivate * priv;
	gsize offset;
	GList* object_offsets;
};

struct _PDFWriterClass {
	GTypeClass parent_class;
	void (*finalize) (PDFWriter *self);
};

struct _ParamSpecBook {
	GParamSpec parent_instance;
};

struct _PDFWriterPrivate {
	GFileOutputStream* stream;
};

struct _ParamSpecPDFWriter {
	GParamSpec parent_instance;
};

struct _ParamSpecPsWriter {
	GParamSpec parent_instance;
};


static gpointer book_parent_class = NULL;
static gpointer pdf_writer_parent_class = NULL;
static gpointer ps_writer_parent_class = NULL;

gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
#define BOOK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BOOK, BookPrivate))
enum  {
	BOOK_DUMMY_PROPERTY
};
static void book_page_changed_cb (Book* self, Page* page);
static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_unref0_ (gpointer var);
static void _g_list_free__page_unref0_ (GList* self);
Book* book_new (void);
Book* book_construct (GType object_type);
void book_clear (Book* self);
void book_set_needs_saving (Book* self, gboolean value);
void book_append_page (Book* self, Page* page);
void book_move_page (Book* self, Page* page, guint location);
void book_delete_page (Book* self, Page* page);
Page* book_get_page (Book* self, gint page_number);
guint book_get_page_index (Book* self, Page* page);
static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i);
guint book_get_n_pages (Book* self);
static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi);
static void book_save_ps (Book* self, GFile* file, GError** error);
PsWriter* ps_writer_new (GFileOutputStream* stream);
PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer ps_writer_ref (gpointer instance);
void ps_writer_unref (gpointer instance);
GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ps_writer (GValue* value, gpointer v_object);
void value_take_ps_writer (GValue* value, gpointer v_object);
gpointer value_get_ps_writer (const GValue* value);
GType ps_writer_get_type (void) G_GNUC_CONST;
GdkPixbuf* page_get_image (Page* self, gboolean apply_crop);
gint page_get_dpi (Page* self);
static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1);
static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1);
static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error);
static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self);
static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error);
PDFWriter* pdf_writer_new (GFileOutputStream* stream);
PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream);
gpointer pdf_writer_ref (gpointer instance);
void pdf_writer_unref (gpointer instance);
GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pdf_writer (GValue* value, gpointer v_object);
void value_take_pdf_writer (GValue* value, gpointer v_object);
gpointer value_get_pdf_writer (const GValue* value);
GType pdf_writer_get_type (void) G_GNUC_CONST;
void pdf_writer_write_string (PDFWriter* self, const gchar* text);
guint pdf_writer_start_object (PDFWriter* self);
gboolean page_get_is_color (Page* self);
gint page_get_depth (Page* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static guint8* _vala_array_dup2 (guint8* self, int length);
void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
gboolean book_get_needs_saving (Book* self);
static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void book_finalize (Book* obj);
#define PDF_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PDF_WRITER, PDFWriterPrivate))
enum  {
	PDF_WRITER_DUMMY_PROPERTY
};
static void pdf_writer_finalize (PDFWriter* obj);
enum  {
	PS_WRITER_DUMMY_PROPERTY
};
static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1);
static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1);
static void ps_writer_finalize (PsWriter* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _page_ref0 (gpointer self) {
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? page_ref (self) : NULL;
#line 244 "book.c"
}


static void _book_page_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_page_changed_cb (self, _sender);
#line 251 "book.c"
}


static void _book_page_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_page_changed_cb (self, _sender);
#line 258 "book.c"
}


static void _page_unref0_ (gpointer var) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 265 "book.c"
}


static void _g_list_free__page_unref0_ (GList* self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_list_foreach (self, (GFunc) _page_unref0_, NULL);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_list_free (self);
#line 274 "book.c"
}


Book* book_construct (GType object_type) {
	Book* self = NULL;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (Book*) g_type_create_instance (object_type);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 40 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = NULL;
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 288 "book.c"
}


Book* book_new (void) {
#line 38 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return book_construct (TYPE_BOOK);
#line 295 "book.c"
}


void book_clear (Book* self) {
	GList* _tmp0_;
#line 52 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 305 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_collection = _tmp0_;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 313 "book.c"
			Page* _tmp1_;
			Page* page = NULL;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			page = _tmp1_;
#line 320 "book.c"
			{
				Page* _tmp2_;
				guint _tmp3_ = 0U;
				Page* _tmp4_;
				guint _tmp5_ = 0U;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = page;
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 56 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = page;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 57 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 54 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 340 "book.c"
			}
		}
	}
#line 59 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 59 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = NULL;
#line 60 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "cleared");
#line 350 "book.c"
}


static void book_page_changed_cb (Book* self, Page* page) {
#line 63 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 65 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 361 "book.c"
}


void book_append_page (Book* self, Page* page) {
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
#line 68 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 70 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 70 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_connect (_tmp0_, "pixels-changed", (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 71 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = page;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = _page_ref0 (_tmp2_);
#line 73 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_append (self->priv->pages, _tmp3_);
#line 74 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = page;
#line 74 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "page-added", _tmp4_);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 395 "book.c"
}


void book_move_page (Book* self, Page* page, guint location) {
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	guint _tmp3_;
#line 78 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 80 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 80 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp0_);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = _page_ref0 (_tmp1_);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = location;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_insert (self->priv->pages, _tmp2_, (gint) _tmp3_);
#line 82 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "reordered");
#line 83 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 424 "book.c"
}


void book_delete_page (Book* self, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Page* _tmp4_;
	Page* _tmp5_;
#line 86 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 86 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (page != NULL);
#line 88 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page;
#line 88 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 88 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = page;
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 89 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = page;
#line 90 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "page-removed", _tmp4_);
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = page;
#line 91 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->pages = g_list_remove (self->priv->pages, _tmp5_);
#line 92 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_set_needs_saving (self, TRUE);
#line 461 "book.c"
}


Page* book_get_page (Book* self, gint page_number) {
	Page* result = NULL;
	gint _tmp0_;
	GList* _tmp4_;
	gint _tmp5_;
	gconstpointer _tmp6_ = NULL;
	Page* _tmp7_;
#line 95 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 97 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = page_number;
#line 97 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp0_ < 0) {
#line 478 "book.c"
		GList* _tmp1_;
		guint _tmp2_ = 0U;
		gint _tmp3_;
#line 98 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = self->priv->pages;
#line 98 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = g_list_length (_tmp1_);
#line 98 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = page_number;
#line 98 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_number = ((gint) _tmp2_) + _tmp3_;
#line 490 "book.c"
	}
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = self->priv->pages;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = page_number;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = g_list_nth_data (_tmp4_, (guint) _tmp5_);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = _page_ref0 ((Page*) _tmp6_);
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp7_;
#line 99 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 504 "book.c"
}


guint book_get_page_index (Book* self, Page* page) {
	guint result = 0U;
	GList* _tmp0_;
	Page* _tmp1_;
	gint _tmp2_ = 0;
#line 102 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 102 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (page != NULL, 0U);
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = page;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_list_index (_tmp0_, _tmp1_);
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = (guint) _tmp2_;
#line 104 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 527 "book.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 928 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
#line 929 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 931 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 552 "book.c"
		gchar* _tmp4_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 932 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 560 "book.c"
	} else {
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = -1;
#line 934 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 566 "book.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1190 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 602 "book.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 611 "book.c"
	}
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 617 "book.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 626 "book.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 632 "book.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 641 "book.c"
	} else {
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 645 "book.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 655 "book.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 664 "book.c"
	} else {
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 668 "book.c"
	}
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 692 "book.c"
}


static GFile* book_make_indexed_file (Book* self, const gchar* uri, gint i) {
	GFile* result = NULL;
	guint _tmp0_;
	guint _tmp1_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* basename;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* prefix;
	gchar* _tmp8_;
	gchar* suffix;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	gint extension_index;
	gint _tmp11_;
	guint _tmp26_;
	guint _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gint width;
	gint _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* number_format;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	gint _tmp39_;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* filename;
	const gchar* _tmp47_;
	GFile* _tmp48_ = NULL;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 109 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = book_get_n_pages (self);
#line 109 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0_;
#line 109 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp1_ == ((guint) 1)) {
#line 748 "book.c"
		const gchar* _tmp2_;
		GFile* _tmp3_ = NULL;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = uri;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = g_file_new_for_uri (_tmp2_);
#line 110 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = _tmp3_;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 759 "book.c"
	}
#line 113 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = uri;
#line 113 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = g_path_get_basename (_tmp4_);
#line 113 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	basename = _tmp5_;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = uri;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	prefix = _tmp7_;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = g_strdup ("");
#line 114 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	suffix = _tmp8_;
#line 115 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = basename;
#line 115 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = string_last_index_of_char (_tmp9_, (gunichar) '.', 0);
#line 115 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	extension_index = _tmp10_;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = extension_index;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp11_ >= 0) {
#line 787 "book.c"
		const gchar* _tmp12_;
		gint _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp12_ = basename;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp13_ = extension_index;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp14_ = basename;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp15_ = strlen (_tmp14_);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp16_ = _tmp15_;
#line 118 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp17_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp16_);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_free0 (suffix);
#line 118 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		suffix = _tmp17_;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp18_ = uri;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp19_ = uri;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp20_ = strlen (_tmp19_);
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp21_ = _tmp20_;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp22_ = suffix;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp23_ = strlen (_tmp22_);
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp24_ = _tmp23_;
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp25_ = string_slice (_tmp18_, (glong) 0, (glong) (_tmp21_ - _tmp24_));
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_free0 (prefix);
#line 119 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		prefix = _tmp25_;
#line 838 "book.c"
	}
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp26_ = book_get_n_pages (self);
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp27_ = _tmp26_;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp28_ = g_strdup_printf ("%u", _tmp27_);
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp29_ = _tmp28_;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp30_ = strlen (_tmp29_);
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp31_ = _tmp30_;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp32_ = _tmp31_;
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp29_);
#line 121 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	width = _tmp32_;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp33_ = width;
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp34_ = g_strdup_printf ("%%0%dd", _tmp33_);
#line 122 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	number_format = _tmp34_;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp35_ = prefix;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp36_ = g_strconcat (_tmp35_, "-", NULL);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp37_ = _tmp36_;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp38_ = number_format;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp39_ = i;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp40_ = g_strdup_printf (_tmp38_, _tmp39_ + 1);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp41_ = _tmp40_;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp42_ = g_strconcat (_tmp37_, _tmp41_, NULL);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp43_ = _tmp42_;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp44_ = suffix;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp45_ = g_strconcat (_tmp43_, _tmp44_, NULL);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp46_ = _tmp45_;
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp43_);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp41_);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp37_);
#line 123 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	filename = _tmp46_;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp47_ = filename;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp48_ = g_file_new_for_uri (_tmp47_);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp48_;
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (filename);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (number_format);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (suffix);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (prefix);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (basename);
#line 124 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 914 "book.c"
}


static void book_save_multi_file (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	GError * _inner_error_ = NULL;
#line 127 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (type != NULL);
#line 127 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 926 "book.c"
	{
		gint i;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 931 "book.c"
		{
			gboolean _tmp0_;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp0_ = TRUE;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 938 "book.c"
				gboolean _tmp1_;
				gint _tmp3_;
				guint _tmp4_;
				guint _tmp5_;
				gint _tmp6_;
				Page* _tmp7_ = NULL;
				Page* page;
				Page* _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_;
				GFile* _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gint _tmp14_;
				GFile* _tmp15_ = NULL;
				GFile* _tmp16_;
				gint _tmp17_;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp1_ = _tmp0_;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp1_) {
#line 960 "book.c"
					gint _tmp2_;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp2_ = i;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp2_ + 1;
#line 966 "book.c"
				}
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp0_ = FALSE;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp3_ = i;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = book_get_n_pages (self);
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = _tmp4_;
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp3_) < _tmp5_)) {
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 980 "book.c"
				}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = i;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = book_get_page (self, _tmp6_);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp7_;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = page;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = type;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp10_ = quality;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp11_ = file;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp12_ = g_file_get_uri (_tmp11_);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp13_ = _tmp12_;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp14_ = i;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp15_ = book_make_indexed_file (self, _tmp13_, _tmp14_);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp16_ = _tmp15_;
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_save (_tmp8_, _tmp9_, _tmp10_, _tmp16_, &_inner_error_);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (_tmp16_);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp13_);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_inner_error_ != NULL) {
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_page_unref0 (page);
#line 132 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 1020 "book.c"
				}
#line 133 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp17_ = i;
#line 133 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp17_);
#line 129 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 1028 "book.c"
			}
		}
	}
}


static void book_save_ps_pdf_surface (Book* self, cairo_surface_t* surface, GdkPixbuf* image, gdouble dpi) {
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* context;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GdkPixbuf* _tmp4_;
	cairo_pattern_t* _tmp5_ = NULL;
#line 137 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 137 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (surface != NULL);
#line 137 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (image != NULL);
#line 139 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = surface;
#line 139 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = cairo_create (_tmp0_);
#line 139 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	context = _tmp1_;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = dpi;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = dpi;
#line 140 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_scale (context, 72.0 / _tmp2_, 72.0 / _tmp3_);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = image;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	gdk_cairo_set_source_pixbuf (context, _tmp4_, (gdouble) 0, (gdouble) 0);
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = cairo_get_source (context);
#line 142 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_pattern_set_filter (_tmp5_, CAIRO_FILTER_BEST);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	cairo_paint (context);
#line 137 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_destroy0 (context);
#line 1073 "book.c"
}


static gpointer _cairo_surface_reference0 (gpointer self) {
#line 150 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 1080 "book.c"
}


static void book_save_ps (Book* self, GFile* file, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	PsWriter* _tmp2_;
	PsWriter* writer;
	PsWriter* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* surface;
	GError * _inner_error_ = NULL;
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = file;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream = _tmp1_;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_inner_error_ != NULL) {
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 1111 "book.c"
	}
#line 149 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = ps_writer_new (stream);
#line 149 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	writer = _tmp2_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = writer;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = _tmp3_->surface;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = _cairo_surface_reference0 (_tmp4_);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	surface = _tmp5_;
#line 1125 "book.c"
	{
		gint i;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 1130 "book.c"
		{
			gboolean _tmp6_;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp6_ = TRUE;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 1137 "book.c"
				gboolean _tmp7_;
				gint _tmp9_;
				guint _tmp10_;
				guint _tmp11_;
				gint _tmp12_;
				Page* _tmp13_ = NULL;
				Page* page;
				Page* _tmp14_;
				GdkPixbuf* _tmp15_ = NULL;
				GdkPixbuf* image;
				GdkPixbuf* _tmp16_;
				gint _tmp17_ = 0;
				Page* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gdouble width;
				GdkPixbuf* _tmp21_;
				gint _tmp22_ = 0;
				Page* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gdouble height;
				cairo_surface_t* _tmp26_;
				gdouble _tmp27_;
				gdouble _tmp28_;
				cairo_surface_t* _tmp29_;
				GdkPixbuf* _tmp30_;
				Page* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				cairo_surface_t* _tmp34_;
				gint _tmp35_;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = _tmp6_;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp7_) {
#line 1174 "book.c"
					gint _tmp8_;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp8_ = i;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp8_ + 1;
#line 1180 "book.c"
				}
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = FALSE;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = i;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp10_ = book_get_n_pages (self);
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp11_ = _tmp10_;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp9_) < _tmp11_)) {
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 1194 "book.c"
				}
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp12_ = i;
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp13_ = book_get_page (self, _tmp12_);
#line 154 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp13_;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp14_ = page;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp15_ = page_get_image (_tmp14_, TRUE);
#line 155 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				image = _tmp15_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp16_ = image;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp17_ = gdk_pixbuf_get_width (_tmp16_);
#line 156 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp18_ = page;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp19_ = page_get_dpi (_tmp18_);
#line 156 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp20_ = _tmp19_;
#line 156 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width = (_tmp17_ * 72.0) / _tmp20_;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp21_ = image;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp22_ = gdk_pixbuf_get_height (_tmp21_);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp23_ = page;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp24_ = page_get_dpi (_tmp23_);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp25_ = _tmp24_;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height = (_tmp22_ * 72.0) / _tmp25_;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp26_ = surface;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp27_ = width;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp28_ = height;
#line 158 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				cairo_ps_surface_set_size (_tmp26_, _tmp27_, _tmp28_);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp29_ = surface;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp30_ = image;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp31_ = page;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp32_ = page_get_dpi (_tmp31_);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp33_ = _tmp32_;
#line 159 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_ps_pdf_surface (self, _tmp29_, _tmp30_, (gdouble) _tmp33_);
#line 160 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp34_ = surface;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				cairo_surface_show_page (_tmp34_);
#line 161 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp35_ = i;
#line 161 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp35_);
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (image);
#line 152 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 1264 "book.c"
			}
		}
	}
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (surface);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_ps_writer_unref0 (writer);
#line 146 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (stream);
#line 1274 "book.c"
}


static guint8* book_compress_zlib (Book* self, guint8* data, int data_length1, int* result_length1) {
	guint8* result = NULL;
	z_stream stream = {0};
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_ = NULL;
	guint8* out_data;
	gint out_data_length1;
	gint _out_data_size_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	z_stream _tmp7_;
	guint _tmp8_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	z_stream _tmp11_;
	guint _tmp12_;
	guint n_written;
	guint _tmp13_;
	gint _tmp14_ = 0;
	guint8* _tmp15_;
	gint _tmp15__length1;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	deflateInit (&stream, (gint) Z_BEST_COMPRESSION);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = data;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0__length1 = data_length1;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_new0 (guint8, _tmp0__length1);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data = _tmp1_;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data_length1 = _tmp0__length1;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_out_data_size_ = out_data_length1;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = data;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2__length1 = data_length1;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.next_in = _tmp2_;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.avail_in = _tmp2__length1;
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = out_data;
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3__length1 = out_data_length1;
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.next_out = _tmp3_;
#line 171 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream.avail_out = _tmp3__length1;
#line 172 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	while (TRUE) {
#line 1336 "book.c"
		z_stream _tmp4_;
		guint _tmp5_;
		gint _tmp6_ = 0;
#line 172 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp4_ = stream;
#line 172 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp5_ = _tmp4_.avail_in;
#line 172 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (!(_tmp5_ > ((guint) 0))) {
#line 172 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			break;
#line 1348 "book.c"
		}
#line 174 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp6_ = deflate (&stream, (gint) Z_FINISH);
#line 174 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (_tmp6_ == ((gint) Z_STREAM_ERROR)) {
#line 175 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			break;
#line 1356 "book.c"
		}
	}
#line 178 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = stream;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = _tmp7_.avail_in;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp8_ > ((guint) 0)) {
#line 1365 "book.c"
		guint8* _tmp9_;
		gint _tmp9__length1;
#line 179 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp9_ = NULL;
#line 179 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp9__length1 = 0;
#line 179 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (result_length1) {
#line 179 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			*result_length1 = _tmp9__length1;
#line 1376 "book.c"
		}
#line 179 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = _tmp9_;
#line 179 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		out_data = (g_free (out_data), NULL);
#line 179 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		deflateEnd (&stream);
#line 179 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 1386 "book.c"
	}
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = data;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10__length1 = data_length1;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = stream;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = _tmp11_.avail_out;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	n_written = _tmp10__length1 - _tmp12_;
#line 182 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = n_written;
#line 182 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp14_ = (gint) _tmp13_;
#line 182 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data = g_renew (guint8, out_data, (gint) _tmp13_);
#line 182 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	(_tmp14_ > out_data_length1) ? memset (out_data + out_data_length1, 0, sizeof (guint8) * (_tmp14_ - out_data_length1)) : NULL;
#line 182 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	out_data_length1 = _tmp14_;
#line 182 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_out_data_size_ = _tmp14_;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = out_data;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15__length1 = out_data_length1;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (result_length1) {
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*result_length1 = _tmp15__length1;
#line 1418 "book.c"
	}
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp15_;
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	deflateEnd (&stream);
#line 184 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1426 "book.c"
}


static gboolean _book_write_pixbuf_data_gdk_pixbuf_save_func (guint8* buf, gsize buf_length1, GError** error, gpointer self) {
	gboolean result;
	result = book_write_pixbuf_data (self, buf, buf_length1, error);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1435 "book.c"
}


static guint8* book_compress_jpeg (Book* self, GdkPixbuf* image, gint quality, gint dpi, int* result_length1) {
	guint8* result = NULL;
	GByteArray* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	GByteArray* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	GError * _inner_error_ = NULL;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 191 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = g_byte_array_new ();
#line 191 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 191 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->jpeg_data = _tmp0_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_strdup ("quality");
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_strdup ("density-unit");
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = g_strdup ("x-density");
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = g_strdup ("y-density");
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[0] = _tmp1_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[1] = _tmp2_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[2] = _tmp3_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[3] = _tmp4_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_[4] = NULL;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys = _tmp5_;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys_length1 = 5;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_keys_size_ = keys_length1;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = quality;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = g_strdup ("dots-per-inch");
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = dpi;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = g_strdup_printf ("%d", _tmp9_);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = dpi;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = g_strdup_printf ("%d", _tmp11_);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = g_new0 (gchar*, 5 + 1);
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[0] = _tmp7_;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[1] = _tmp8_;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[2] = _tmp10_;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[3] = _tmp12_;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_[4] = NULL;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values = _tmp13_;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values_length1 = 5;
#line 193 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_values_size_ = values_length1;
#line 1538 "book.c"
	{
		GdkPixbuf* _tmp14_;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp14_ = image;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		gdk_pixbuf_save_to_callbackv (_tmp14_, _book_write_pixbuf_data_gdk_pixbuf_save_func, self, "jpeg", keys, values, &_inner_error_);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (_inner_error_ != NULL) {
#line 1547 "book.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 1561 "book.c"
	}
	__finally0:
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_inner_error_ != NULL) {
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 194 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return NULL;
#line 1576 "book.c"
	}
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = self->priv->jpeg_data;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16_ = _tmp15_->data;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16__length1 = _tmp15_->len;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_->data = NULL;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	data = _tmp16_;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	data_length1 = _tmp16__length1;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_data_size_ = data_length1;
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 202 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->jpeg_data = NULL;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17_ = data;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17__length1 = data_length1;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (result_length1) {
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*result_length1 = _tmp17__length1;
#line 1604 "book.c"
	}
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp17_;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 204 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1614 "book.c"
}


static gboolean book_write_pixbuf_data (Book* self, guint8* buf, int buf_length1, GError** error) {
	gboolean result = FALSE;
	GByteArray* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 207 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 209 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->jpeg_data;
#line 209 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = buf;
#line 209 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1__length1 = buf_length1;
#line 209 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_byte_array_append (_tmp0_, _tmp1_, _tmp1__length1);
#line 210 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = TRUE;
#line 210 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 1637 "book.c"
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1644 "book.c"
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1651 "book.c"
}


static void book_save_pdf (Book* self, GFile* file, gint quality, GError** error) {
	GFile* _tmp0_;
	GFileOutputStream* _tmp1_ = NULL;
	GFileOutputStream* stream;
	PDFWriter* _tmp2_;
	PDFWriter* writer;
	PDFWriter* _tmp3_;
	PDFWriter* _tmp4_;
	PDFWriter* _tmp5_;
	guint _tmp6_ = 0U;
	guint catalog_number;
	PDFWriter* _tmp7_;
	guint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	PDFWriter* _tmp11_;
	PDFWriter* _tmp12_;
	PDFWriter* _tmp13_;
	guint _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	PDFWriter* _tmp17_;
	PDFWriter* _tmp18_;
	PDFWriter* _tmp19_;
	PDFWriter* _tmp20_;
	guint _tmp21_ = 0U;
	guint pages_number;
	PDFWriter* _tmp22_;
	guint _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	PDFWriter* _tmp26_;
	PDFWriter* _tmp27_;
	PDFWriter* _tmp28_;
	PDFWriter* _tmp40_;
	PDFWriter* _tmp41_;
	guint _tmp42_;
	guint _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	PDFWriter* _tmp46_;
	PDFWriter* _tmp47_;
	PDFWriter* _tmp361_;
	PDFWriter* _tmp362_;
	guint _tmp363_ = 0U;
	guint info_number;
	PDFWriter* _tmp364_;
	guint _tmp365_;
	gchar* _tmp366_ = NULL;
	gchar* _tmp367_;
	PDFWriter* _tmp368_;
	PDFWriter* _tmp369_;
	gchar* _tmp370_ = NULL;
	gchar* _tmp371_;
	PDFWriter* _tmp372_;
	PDFWriter* _tmp373_;
	PDFWriter* _tmp374_;
	gsize _tmp375_;
	gsize xref_offset;
	PDFWriter* _tmp376_;
	PDFWriter* _tmp377_;
	PDFWriter* _tmp378_;
	GList* _tmp379_;
	guint _tmp380_ = 0U;
	gchar* _tmp381_ = NULL;
	gchar* _tmp382_;
	PDFWriter* _tmp383_;
	GList* _tmp384_;
	PDFWriter* _tmp389_;
	PDFWriter* _tmp390_;
	PDFWriter* _tmp391_;
	PDFWriter* _tmp392_;
	GList* _tmp393_;
	guint _tmp394_ = 0U;
	gchar* _tmp395_ = NULL;
	gchar* _tmp396_;
	PDFWriter* _tmp397_;
	guint _tmp398_;
	gchar* _tmp399_ = NULL;
	gchar* _tmp400_;
	PDFWriter* _tmp401_;
	guint _tmp402_;
	gchar* _tmp403_ = NULL;
	gchar* _tmp404_;
	PDFWriter* _tmp405_;
	PDFWriter* _tmp406_;
	PDFWriter* _tmp407_;
	gsize _tmp408_;
	gchar* _tmp409_ = NULL;
	gchar* _tmp410_;
	PDFWriter* _tmp411_;
	GError * _inner_error_ = NULL;
#line 213 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = file;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_file_replace (_tmp0_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	stream = _tmp1_;
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_inner_error_ != NULL) {
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_propagate_error (error, _inner_error_);
#line 215 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 1763 "book.c"
	}
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = pdf_writer_new (stream);
#line 216 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	writer = _tmp2_;
#line 219 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = writer;
#line 219 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp3_, "%PDF-1.3\n");
#line 222 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = writer;
#line 222 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp4_, "%\xe2\xe3\xcf\xd3\n");
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = writer;
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp6_ = pdf_writer_start_object (_tmp5_);
#line 225 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	catalog_number = _tmp6_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp7_ = writer;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp8_ = catalog_number;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp9_ = g_strdup_printf ("%u 0 obj\n", _tmp8_);
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp10_ = _tmp9_;
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp7_, _tmp10_);
#line 226 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp10_);
#line 227 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp11_ = writer;
#line 227 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp11_, "<<\n");
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp12_ = writer;
#line 228 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp12_, "/Type /Catalog\n");
#line 230 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp13_ = writer;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp14_ = catalog_number;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp15_ = g_strdup_printf ("/Pages %u 0 R\n", _tmp14_ + 1);
#line 230 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp16_ = _tmp15_;
#line 230 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp13_, _tmp16_);
#line 230 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp16_);
#line 231 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp17_ = writer;
#line 231 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp17_, ">>\n");
#line 232 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp18_ = writer;
#line 232 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp18_, "endobj\n");
#line 250 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp19_ = writer;
#line 250 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp19_, "\n");
#line 251 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp20_ = writer;
#line 251 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp21_ = pdf_writer_start_object (_tmp20_);
#line 251 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pages_number = _tmp21_;
#line 252 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp22_ = writer;
#line 252 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp23_ = pages_number;
#line 252 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp24_ = g_strdup_printf ("%u 0 obj\n", _tmp23_);
#line 252 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp25_ = _tmp24_;
#line 252 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp22_, _tmp25_);
#line 252 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp25_);
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp26_ = writer;
#line 253 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp26_, "<<\n");
#line 254 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp27_ = writer;
#line 254 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp27_, "/Type /Pages\n");
#line 255 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp28_ = writer;
#line 255 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp28_, "/Kids [");
#line 1857 "book.c"
	{
		gint i;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 1862 "book.c"
		{
			gboolean _tmp29_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp29_ = TRUE;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 1869 "book.c"
				gboolean _tmp30_;
				gint _tmp32_;
				guint _tmp33_;
				guint _tmp34_;
				PDFWriter* _tmp35_;
				guint _tmp36_;
				gint _tmp37_;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp30_ = _tmp29_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp30_) {
#line 1883 "book.c"
					gint _tmp31_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp31_ = i;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp31_ + 1;
#line 1889 "book.c"
				}
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp29_ = FALSE;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp32_ = i;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp33_ = book_get_n_pages (self);
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp34_ = _tmp33_;
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp32_) < _tmp34_)) {
#line 256 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 1903 "book.c"
				}
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp35_ = writer;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp36_ = pages_number;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp37_ = i;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp38_ = g_strdup_printf (" %u 0 R", (_tmp36_ + 1) + (_tmp37_ * 3));
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp39_ = _tmp38_;
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp35_, _tmp39_);
#line 257 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp39_);
#line 1919 "book.c"
			}
		}
	}
#line 258 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp40_ = writer;
#line 258 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp40_, " ]\n");
#line 259 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp41_ = writer;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp42_ = book_get_n_pages (self);
#line 259 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp43_ = _tmp42_;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp44_ = g_strdup_printf ("/Count %u\n", _tmp43_);
#line 259 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp45_ = _tmp44_;
#line 259 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp41_, _tmp45_);
#line 259 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp45_);
#line 260 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp46_ = writer;
#line 260 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp46_, ">>\n");
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp47_ = writer;
#line 261 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp47_, "endobj\n");
#line 1949 "book.c"
	{
		gint i;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		i = 0;
#line 1954 "book.c"
		{
			gboolean _tmp48_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp48_ = TRUE;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			while (TRUE) {
#line 1961 "book.c"
				gboolean _tmp49_;
				gint _tmp51_;
				guint _tmp52_;
				guint _tmp53_;
				gint _tmp54_;
				Page* _tmp55_ = NULL;
				Page* page;
				Page* _tmp56_;
				GdkPixbuf* _tmp57_ = NULL;
				GdkPixbuf* image;
				GdkPixbuf* _tmp58_;
				gint _tmp59_ = 0;
				gint width;
				GdkPixbuf* _tmp60_;
				gint _tmp61_ = 0;
				gint height;
				GdkPixbuf* _tmp62_;
				guint8* _tmp63_ = NULL;
				guint8* pixels;
				gint pixels_length1;
				gint _pixels_size_;
				gint _tmp64_;
				Page* _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				gdouble page_width;
				gint _tmp68_;
				Page* _tmp69_;
				gint _tmp70_;
				gint _tmp71_;
				gdouble page_height;
				gint depth;
				gchar* _tmp72_;
				gchar* color_space;
				gchar* filter;
				gchar* _tmp73_ = NULL;
				gchar* width_buffer;
				gint width_buffer_length1;
				gint _width_buffer_size_;
				gchar* _tmp74_ = NULL;
				gchar* height_buffer;
				gint height_buffer_length1;
				gint _height_buffer_size_;
				guint8* data = NULL;
				gint data_length1 = 0;
				gint _data_size_ = 0;
				Page* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				guint8* _tmp235_;
				gint _tmp235__length1;
				gint _tmp236_ = 0;
				guint8* _tmp237_ = NULL;
				guint8* compressed_data;
				gint compressed_data_length1;
				gint _compressed_data_size_;
				guint8* _tmp238_;
				gint _tmp238__length1;
				PDFWriter* _tmp256_;
				PDFWriter* _tmp257_;
				guint _tmp258_ = 0U;
				guint number;
				PDFWriter* _tmp259_;
				guint _tmp260_;
				gchar* _tmp261_ = NULL;
				gchar* _tmp262_;
				PDFWriter* _tmp263_;
				PDFWriter* _tmp264_;
				PDFWriter* _tmp265_;
				guint _tmp266_;
				gchar* _tmp267_ = NULL;
				gchar* _tmp268_;
				PDFWriter* _tmp269_;
				gint _tmp270_;
				guint _tmp271_;
				gchar* _tmp272_ = NULL;
				gchar* _tmp273_;
				PDFWriter* _tmp274_;
				gdouble _tmp275_;
				gchar* _tmp276_;
				gint _tmp276__length1;
				const gchar* _tmp277_ = NULL;
				gdouble _tmp278_;
				gchar* _tmp279_;
				gint _tmp279__length1;
				const gchar* _tmp280_ = NULL;
				gchar* _tmp281_ = NULL;
				gchar* _tmp282_;
				PDFWriter* _tmp283_;
				guint _tmp284_;
				gchar* _tmp285_ = NULL;
				gchar* _tmp286_;
				PDFWriter* _tmp287_;
				PDFWriter* _tmp288_;
				PDFWriter* _tmp289_;
				PDFWriter* _tmp290_;
				guint _tmp291_ = 0U;
				PDFWriter* _tmp292_;
				guint _tmp293_;
				gchar* _tmp294_ = NULL;
				gchar* _tmp295_;
				PDFWriter* _tmp296_;
				PDFWriter* _tmp297_;
				PDFWriter* _tmp298_;
				PDFWriter* _tmp299_;
				gint _tmp300_;
				gchar* _tmp301_ = NULL;
				gchar* _tmp302_;
				PDFWriter* _tmp303_;
				gint _tmp304_;
				gchar* _tmp305_ = NULL;
				gchar* _tmp306_;
				PDFWriter* _tmp307_;
				const gchar* _tmp308_;
				gchar* _tmp309_ = NULL;
				gchar* _tmp310_;
				PDFWriter* _tmp311_;
				gint _tmp312_;
				gchar* _tmp313_ = NULL;
				gchar* _tmp314_;
				PDFWriter* _tmp315_;
				guint8* _tmp316_;
				gint _tmp316__length1;
				gchar* _tmp317_ = NULL;
				gchar* _tmp318_;
				const gchar* _tmp319_;
				PDFWriter* _tmp324_;
				PDFWriter* _tmp325_;
				PDFWriter* _tmp326_;
				guint8* _tmp327_;
				gint _tmp327__length1;
				PDFWriter* _tmp328_;
				PDFWriter* _tmp329_;
				PDFWriter* _tmp330_;
				gdouble _tmp331_;
				gchar* _tmp332_;
				gint _tmp332__length1;
				const gchar* _tmp333_ = NULL;
				gdouble _tmp334_;
				gchar* _tmp335_;
				gint _tmp335__length1;
				const gchar* _tmp336_ = NULL;
				gint _tmp337_;
				gchar* _tmp338_ = NULL;
				gchar* command;
				PDFWriter* _tmp339_;
				PDFWriter* _tmp340_;
				guint _tmp341_ = 0U;
				PDFWriter* _tmp342_;
				guint _tmp343_;
				gchar* _tmp344_ = NULL;
				gchar* _tmp345_;
				PDFWriter* _tmp346_;
				PDFWriter* _tmp347_;
				const gchar* _tmp348_;
				gint _tmp349_;
				gint _tmp350_;
				gchar* _tmp351_ = NULL;
				gchar* _tmp352_;
				PDFWriter* _tmp353_;
				PDFWriter* _tmp354_;
				PDFWriter* _tmp355_;
				const gchar* _tmp356_;
				PDFWriter* _tmp357_;
				PDFWriter* _tmp358_;
				PDFWriter* _tmp359_;
				gint _tmp360_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp49_ = _tmp48_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!_tmp49_) {
#line 2133 "book.c"
					gint _tmp50_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp50_ = i;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					i = _tmp50_ + 1;
#line 2139 "book.c"
				}
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp48_ = FALSE;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp51_ = i;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp52_ = book_get_n_pages (self);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp53_ = _tmp52_;
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (!(((guint) _tmp51_) < _tmp53_)) {
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					break;
#line 2153 "book.c"
				}
#line 265 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp54_ = i;
#line 265 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp55_ = book_get_page (self, _tmp54_);
#line 265 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page = _tmp55_;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp56_ = page;
#line 266 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp57_ = page_get_image (_tmp56_, TRUE);
#line 266 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				image = _tmp57_;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp58_ = image;
#line 267 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp59_ = gdk_pixbuf_get_width (_tmp58_);
#line 267 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width = _tmp59_;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp60_ = image;
#line 268 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp61_ = gdk_pixbuf_get_height (_tmp60_);
#line 268 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height = _tmp61_;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp62_ = image;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp63_ = gdk_pixbuf_get_pixels (_tmp62_);
#line 269 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pixels = _tmp63_;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pixels_length1 = -1;
#line 269 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_pixels_size_ = pixels_length1;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp64_ = width;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp65_ = page;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp66_ = page_get_dpi (_tmp65_);
#line 270 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp67_ = _tmp66_;
#line 270 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_width = (_tmp64_ * 72.0) / _tmp67_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp68_ = height;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp69_ = page;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp70_ = page_get_dpi (_tmp69_);
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp71_ = _tmp70_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				page_height = (_tmp68_ * 72.0) / _tmp71_;
#line 273 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				depth = 8;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp72_ = g_strdup ("DeviceRGB");
#line 274 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				color_space = _tmp72_;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				filter = NULL;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp73_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 276 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer = _tmp73_;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 276 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_width_buffer_size_ = width_buffer_length1;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp74_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer = _tmp74_;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer_length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 277 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_height_buffer_size_ = height_buffer_length1;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp75_ = page;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp76_ = page_get_is_color (_tmp75_);
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp77_ = _tmp76_;
#line 279 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp77_) {
#line 2241 "book.c"
					gchar* _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					gint data_length;
					gint _tmp81_;
					guint8* _tmp82_ = NULL;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					depth = 8;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp78_ = g_strdup ("DeviceRGB");
#line 282 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_g_free0 (color_space);
#line 282 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					color_space = _tmp78_;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp79_ = height;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp80_ = width;
#line 283 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data_length = (_tmp79_ * _tmp80_) * 3;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp81_ = data_length;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp82_ = g_new0 (guint8, _tmp81_);
#line 284 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data = (g_free (data), NULL);
#line 284 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data = _tmp82_;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					data_length1 = _tmp81_;
#line 284 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_data_size_ = data_length1;
#line 2274 "book.c"
					{
						gint row;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						row = 0;
#line 2279 "book.c"
						{
							gboolean _tmp83_;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp83_ = TRUE;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							while (TRUE) {
#line 2286 "book.c"
								gboolean _tmp84_;
								gint _tmp86_;
								gint _tmp87_;
								gint _tmp88_;
								GdkPixbuf* _tmp89_;
								gint _tmp90_ = 0;
								gint in_offset;
								gint _tmp91_;
								gint _tmp92_;
								gint out_offset;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp84_ = _tmp83_;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								if (!_tmp84_) {
#line 2301 "book.c"
									gint _tmp85_;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp85_ = row;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									row = _tmp85_ + 1;
#line 2307 "book.c"
								}
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp83_ = FALSE;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp86_ = row;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp87_ = height;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								if (!(_tmp86_ < _tmp87_)) {
#line 285 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									break;
#line 2319 "book.c"
								}
#line 287 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp88_ = row;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp89_ = image;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp90_ = gdk_pixbuf_get_rowstride (_tmp89_);
#line 287 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								in_offset = _tmp88_ * _tmp90_;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp91_ = row;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp92_ = width;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								out_offset = (_tmp91_ * _tmp92_) * 3;
#line 2335 "book.c"
								{
									gint x;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									x = 0;
#line 2340 "book.c"
									{
										gboolean _tmp93_;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp93_ = TRUE;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										while (TRUE) {
#line 2347 "book.c"
											gboolean _tmp94_;
											gint _tmp96_;
											gint _tmp97_;
											gint _tmp98_;
											gint _tmp99_;
											gint in_o;
											gint _tmp100_;
											gint _tmp101_;
											gint out_o;
											guint8* _tmp102_;
											gint _tmp102__length1;
											gint _tmp103_;
											guint8* _tmp104_;
											gint _tmp104__length1;
											gint _tmp105_;
											guint8 _tmp106_;
											guint8 _tmp107_;
											guint8* _tmp108_;
											gint _tmp108__length1;
											gint _tmp109_;
											guint8* _tmp110_;
											gint _tmp110__length1;
											gint _tmp111_;
											guint8 _tmp112_;
											guint8 _tmp113_;
											guint8* _tmp114_;
											gint _tmp114__length1;
											gint _tmp115_;
											guint8* _tmp116_;
											gint _tmp116__length1;
											gint _tmp117_;
											guint8 _tmp118_;
											guint8 _tmp119_;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp94_ = _tmp93_;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											if (!_tmp94_) {
#line 2385 "book.c"
												gint _tmp95_;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp95_ = x;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												x = _tmp95_ + 1;
#line 2391 "book.c"
											}
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp93_ = FALSE;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp96_ = x;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp97_ = width;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											if (!(_tmp96_ < _tmp97_)) {
#line 289 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												break;
#line 2403 "book.c"
											}
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp98_ = in_offset;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp99_ = x;
#line 291 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											in_o = _tmp98_ + (_tmp99_ * 3);
#line 292 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp100_ = out_offset;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp101_ = x;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											out_o = _tmp100_ + (_tmp101_ * 3);
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp102_ = data;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp102__length1 = data_length1;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp103_ = out_o;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp104_ = pixels;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp104__length1 = pixels_length1;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp105_ = in_o;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp106_ = _tmp104_[_tmp105_];
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp102_[_tmp103_] = _tmp106_;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp107_ = _tmp102_[_tmp103_];
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp108_ = data;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp108__length1 = data_length1;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp109_ = out_o;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp110_ = pixels;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp110__length1 = pixels_length1;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp111_ = in_o;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp112_ = _tmp110_[_tmp111_ + 1];
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp108_[_tmp109_ + 1] = _tmp112_;
#line 295 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp113_ = _tmp108_[_tmp109_ + 1];
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp114_ = data;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp114__length1 = data_length1;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp115_ = out_o;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp116_ = pixels;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp116__length1 = pixels_length1;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp117_ = in_o;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp118_ = _tmp116_[_tmp117_ + 2];
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp114_[_tmp115_ + 2] = _tmp118_;
#line 296 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp119_ = _tmp114_[_tmp115_ + 2];
#line 2471 "book.c"
										}
									}
								}
							}
						}
					}
				} else {
					Page* _tmp120_;
					gint _tmp121_;
					gint _tmp122_;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp120_ = page;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp121_ = page_get_depth (_tmp120_);
#line 300 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp122_ = _tmp121_;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp122_ == 2) {
#line 2490 "book.c"
						gint shift_count;
						gchar* _tmp123_;
						gint _tmp124_;
						gint _tmp125_;
						gint data_length;
						gint _tmp126_;
						guint8* _tmp127_ = NULL;
						gint offset;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						shift_count = 6;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						depth = 2;
#line 304 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp123_ = g_strdup ("DeviceGray");
#line 304 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_g_free0 (color_space);
#line 304 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						color_space = _tmp123_;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp124_ = height;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp125_ = width;
#line 305 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length = _tmp124_ * (((_tmp125_ * 2) + 7) / 8);
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp126_ = data_length;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp127_ = g_new0 (guint8, _tmp126_);
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = (g_free (data), NULL);
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = _tmp127_;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length1 = _tmp126_;
#line 306 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_data_size_ = data_length1;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						offset = 0;
#line 2529 "book.c"
						{
							gint row;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							row = 0;
#line 2534 "book.c"
							{
								gboolean _tmp128_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								_tmp128_ = TRUE;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								while (TRUE) {
#line 2541 "book.c"
									gboolean _tmp129_;
									gint _tmp131_;
									gint _tmp132_;
									gint _tmp133_;
									gint _tmp135_;
									GdkPixbuf* _tmp136_;
									gint _tmp137_ = 0;
									gint in_offset;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp129_ = _tmp128_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (!_tmp129_) {
#line 2554 "book.c"
										gint _tmp130_;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp130_ = row;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										row = _tmp130_ + 1;
#line 2560 "book.c"
									}
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp128_ = FALSE;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp131_ = row;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp132_ = height;
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (!(_tmp131_ < _tmp132_)) {
#line 308 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										break;
#line 2572 "book.c"
									}
#line 311 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp133_ = shift_count;
#line 311 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									if (_tmp133_ != 6) {
#line 2578 "book.c"
										gint _tmp134_;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp134_ = offset;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										offset = _tmp134_ + 1;
#line 314 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										shift_count = 6;
#line 2586 "book.c"
									}
#line 317 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp135_ = row;
#line 317 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp136_ = image;
#line 317 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp137_ = gdk_pixbuf_get_rowstride (_tmp136_);
#line 317 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									in_offset = _tmp135_ * _tmp137_;
#line 2596 "book.c"
									{
										gint x;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										x = 0;
#line 2601 "book.c"
										{
											gboolean _tmp138_;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp138_ = TRUE;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											while (TRUE) {
#line 2608 "book.c"
												gboolean _tmp139_;
												gint _tmp141_;
												gint _tmp142_;
												gint _tmp143_;
												guint8* _tmp147_;
												gint _tmp147__length1;
												gint _tmp148_;
												gint _tmp149_;
												guint8 _tmp150_;
												guint8 p;
												guint8 _tmp151_;
												gint _tmp166_;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp139_ = _tmp138_;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (!_tmp139_) {
#line 2625 "book.c"
													gint _tmp140_;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp140_ = x;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													x = _tmp140_ + 1;
#line 2631 "book.c"
												}
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp138_ = FALSE;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp141_ = x;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp142_ = width;
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (!(_tmp141_ < _tmp142_)) {
#line 318 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													break;
#line 2643 "book.c"
												}
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp143_ = shift_count;
#line 321 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (_tmp143_ == 6) {
#line 2649 "book.c"
													guint8* _tmp144_;
													gint _tmp144__length1;
													gint _tmp145_;
													guint8 _tmp146_;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp144_ = data;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp144__length1 = data_length1;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp145_ = offset;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp144_[_tmp145_] = (guint8) 0;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp146_ = _tmp144_[_tmp145_];
#line 2664 "book.c"
												}
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp147_ = pixels;
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp147__length1 = pixels_length1;
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp148_ = in_offset;
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp149_ = x;
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp150_ = _tmp147_[_tmp148_ + (_tmp149_ * 3)];
#line 325 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												p = _tmp150_;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp151_ = p;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (((gint) _tmp151_) >= 192) {
#line 2682 "book.c"
													guint8* _tmp152_;
													gint _tmp152__length1;
													gint _tmp153_;
													gint _tmp154_;
													guint8 _tmp155_;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp152_ = data;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp152__length1 = data_length1;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp153_ = offset;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp154_ = shift_count;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp152_[_tmp153_] |= (guint8) (3 << _tmp154_);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp155_ = _tmp152_[_tmp153_];
#line 2700 "book.c"
												} else {
													guint8 _tmp156_;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp156_ = p;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (((gint) _tmp156_) >= 128) {
#line 2707 "book.c"
														guint8* _tmp157_;
														gint _tmp157__length1;
														gint _tmp158_;
														gint _tmp159_;
														guint8 _tmp160_;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp157_ = data;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp157__length1 = data_length1;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp158_ = offset;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp159_ = shift_count;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp157_[_tmp158_] |= (guint8) (2 << _tmp159_);
#line 329 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp160_ = _tmp157_[_tmp158_];
#line 2725 "book.c"
													} else {
														guint8 _tmp161_;
#line 330 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp161_ = p;
#line 330 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														if (((gint) _tmp161_) >= 64) {
#line 2732 "book.c"
															guint8* _tmp162_;
															gint _tmp162__length1;
															gint _tmp163_;
															gint _tmp164_;
															guint8 _tmp165_;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp162_ = data;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp162__length1 = data_length1;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp163_ = offset;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp164_ = shift_count;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp162_[_tmp163_] |= (guint8) (1 << _tmp164_);
#line 331 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
															_tmp165_ = _tmp162_[_tmp163_];
#line 2750 "book.c"
														}
													}
												}
#line 334 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp166_ = shift_count;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												if (_tmp166_ == 0) {
#line 2758 "book.c"
													gint _tmp167_;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp167_ = offset;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													offset = _tmp167_ + 1;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													shift_count = 6;
#line 2766 "book.c"
												} else {
													gint _tmp168_;
#line 340 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp168_ = shift_count;
#line 340 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													shift_count = _tmp168_ - 2;
#line 2773 "book.c"
												}
											}
										}
									}
								}
							}
						}
					} else {
						Page* _tmp169_;
						gint _tmp170_;
						gint _tmp171_;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp169_ = page;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp170_ = page_get_depth (_tmp169_);
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp171_ = _tmp170_;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						if (_tmp171_ == 1) {
#line 2793 "book.c"
							gint mask;
							gchar* _tmp172_;
							gint _tmp173_;
							gint _tmp174_;
							gint data_length;
							gint _tmp175_;
							guint8* _tmp176_ = NULL;
							gint offset;
#line 346 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							mask = 0x80;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							depth = 1;
#line 349 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp172_ = g_strdup ("DeviceGray");
#line 349 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (color_space);
#line 349 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							color_space = _tmp172_;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp173_ = height;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp174_ = width;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length = _tmp173_ * ((_tmp174_ + 7) / 8);
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp175_ = data_length;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp176_ = g_new0 (guint8, _tmp175_);
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp176_;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp175_;
#line 351 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 352 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							offset = 0;
#line 2832 "book.c"
							{
								gint row;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								row = 0;
#line 2837 "book.c"
								{
									gboolean _tmp177_;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp177_ = TRUE;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									while (TRUE) {
#line 2844 "book.c"
										gboolean _tmp178_;
										gint _tmp180_;
										gint _tmp181_;
										gint _tmp182_;
										gint _tmp184_;
										GdkPixbuf* _tmp185_;
										gint _tmp186_ = 0;
										gint in_offset;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp178_ = _tmp177_;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!_tmp178_) {
#line 2857 "book.c"
											gint _tmp179_;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp179_ = row;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											row = _tmp179_ + 1;
#line 2863 "book.c"
										}
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp177_ = FALSE;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp180_ = row;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp181_ = height;
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!(_tmp180_ < _tmp181_)) {
#line 353 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											break;
#line 2875 "book.c"
										}
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp182_ = mask;
#line 356 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (_tmp182_ != 0x80) {
#line 2881 "book.c"
											gint _tmp183_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp183_ = offset;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											offset = _tmp183_ + 1;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											mask = 0x80;
#line 2889 "book.c"
										}
#line 362 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp184_ = row;
#line 362 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp185_ = image;
#line 362 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp186_ = gdk_pixbuf_get_rowstride (_tmp185_);
#line 362 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										in_offset = _tmp184_ * _tmp186_;
#line 2899 "book.c"
										{
											gint x;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											x = 0;
#line 2904 "book.c"
											{
												gboolean _tmp187_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp187_ = TRUE;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												while (TRUE) {
#line 2911 "book.c"
													gboolean _tmp188_;
													gint _tmp190_;
													gint _tmp191_;
													gint _tmp192_;
													guint8* _tmp196_;
													gint _tmp196__length1;
													gint _tmp197_;
													gint _tmp198_;
													guint8 _tmp199_;
													gint _tmp204_;
													gint _tmp205_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp188_ = _tmp187_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!_tmp188_) {
#line 2927 "book.c"
														gint _tmp189_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp189_ = x;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														x = _tmp189_ + 1;
#line 2933 "book.c"
													}
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp187_ = FALSE;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp190_ = x;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp191_ = width;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!(_tmp190_ < _tmp191_)) {
#line 363 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														break;
#line 2945 "book.c"
													}
#line 366 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp192_ = mask;
#line 366 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (_tmp192_ == 0x80) {
#line 2951 "book.c"
														guint8* _tmp193_;
														gint _tmp193__length1;
														gint _tmp194_;
														guint8 _tmp195_;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp193_ = data;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp193__length1 = data_length1;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp194_ = offset;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp193_[_tmp194_] = (guint8) 0;
#line 367 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp195_ = _tmp193_[_tmp194_];
#line 2966 "book.c"
													}
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp196_ = pixels;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp196__length1 = pixels_length1;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp197_ = in_offset;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp198_ = x;
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp199_ = _tmp196_[_tmp197_ + (_tmp198_ * 3)];
#line 370 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (((gint) _tmp199_) != 0) {
#line 2980 "book.c"
														guint8* _tmp200_;
														gint _tmp200__length1;
														gint _tmp201_;
														gint _tmp202_;
														guint8 _tmp203_;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp200_ = data;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp200__length1 = data_length1;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp201_ = offset;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp202_ = mask;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp200_[_tmp201_] |= (guint8) _tmp202_;
#line 371 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp203_ = _tmp200_[_tmp201_];
#line 2998 "book.c"
													}
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp204_ = mask;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													mask = _tmp204_ >> 1;
#line 375 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp205_ = mask;
#line 375 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (_tmp205_ == 0) {
#line 3008 "book.c"
														gint _tmp206_;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp206_ = offset;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														offset = _tmp206_ + 1;
#line 378 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														mask = 0x80;
#line 3016 "book.c"
													}
												}
											}
										}
									}
								}
							}
						} else {
							gchar* _tmp207_;
							gint _tmp208_;
							gint _tmp209_;
							gint data_length;
							gint _tmp210_;
							guint8* _tmp211_ = NULL;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							depth = 8;
#line 386 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp207_ = g_strdup ("DeviceGray");
#line 386 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (color_space);
#line 386 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							color_space = _tmp207_;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp208_ = height;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp209_ = width;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length = _tmp208_ * _tmp209_;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp210_ = data_length;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp211_ = g_new0 (guint8, _tmp210_);
#line 388 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 388 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp211_;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp210_;
#line 388 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 3057 "book.c"
							{
								gint row;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
								row = 0;
#line 3062 "book.c"
								{
									gboolean _tmp212_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									_tmp212_ = TRUE;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
									while (TRUE) {
#line 3069 "book.c"
										gboolean _tmp213_;
										gint _tmp215_;
										gint _tmp216_;
										gint _tmp217_;
										GdkPixbuf* _tmp218_;
										gint _tmp219_ = 0;
										gint in_offset;
										gint _tmp220_;
										gint _tmp221_;
										gint out_offset;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp213_ = _tmp212_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!_tmp213_) {
#line 3084 "book.c"
											gint _tmp214_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											_tmp214_ = row;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											row = _tmp214_ + 1;
#line 3090 "book.c"
										}
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp212_ = FALSE;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp215_ = row;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp216_ = height;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										if (!(_tmp215_ < _tmp216_)) {
#line 389 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											break;
#line 3102 "book.c"
										}
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp217_ = row;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp218_ = image;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp219_ = gdk_pixbuf_get_rowstride (_tmp218_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										in_offset = _tmp217_ * _tmp219_;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp220_ = row;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										_tmp221_ = width;
#line 392 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
										out_offset = _tmp220_ * _tmp221_;
#line 3118 "book.c"
										{
											gint x;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
											x = 0;
#line 3123 "book.c"
											{
												gboolean _tmp222_;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												_tmp222_ = TRUE;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
												while (TRUE) {
#line 3130 "book.c"
													gboolean _tmp223_;
													gint _tmp225_;
													gint _tmp226_;
													guint8* _tmp227_;
													gint _tmp227__length1;
													gint _tmp228_;
													gint _tmp229_;
													guint8* _tmp230_;
													gint _tmp230__length1;
													gint _tmp231_;
													gint _tmp232_;
													guint8 _tmp233_;
													guint8 _tmp234_;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp223_ = _tmp222_;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!_tmp223_) {
#line 3148 "book.c"
														gint _tmp224_;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														_tmp224_ = x;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														x = _tmp224_ + 1;
#line 3154 "book.c"
													}
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp222_ = FALSE;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp225_ = x;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp226_ = width;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													if (!(_tmp225_ < _tmp226_)) {
#line 393 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
														break;
#line 3166 "book.c"
													}
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp227_ = data;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp227__length1 = data_length1;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp228_ = out_offset;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp229_ = x;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp230_ = pixels;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp230__length1 = pixels_length1;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp231_ = in_offset;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp232_ = x;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp233_ = _tmp230_[_tmp231_ + (_tmp232_ * 3)];
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp227_[_tmp228_ + _tmp229_] = _tmp233_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
													_tmp234_ = _tmp227_[_tmp228_ + _tmp229_];
#line 3190 "book.c"
												}
											}
										}
									}
								}
							}
						}
					}
				}
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp235_ = data;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp235__length1 = data_length1;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp237_ = book_compress_zlib (self, _tmp235_, _tmp235__length1, &_tmp236_);
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data = _tmp237_;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data_length1 = _tmp236_;
#line 399 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_compressed_data_size_ = compressed_data_length1;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp238_ = compressed_data;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp238__length1 = compressed_data_length1;
#line 400 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp238_ != NULL) {
#line 3218 "book.c"
					gint _tmp239_;
					const gchar* _tmp252_;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp239_ = depth;
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp239_ > 1) {
#line 3225 "book.c"
						GdkPixbuf* _tmp240_;
						gint _tmp241_;
						Page* _tmp242_;
						gint _tmp243_;
						gint _tmp244_;
						gint _tmp245_ = 0;
						guint8* _tmp246_ = NULL;
						guint8* jpeg_data;
						gint jpeg_data_length1;
						gint _jpeg_data_size_;
						guint8* _tmp247_;
						gint _tmp247__length1;
						guint8* _tmp248_;
						gint _tmp248__length1;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp240_ = image;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp241_ = quality;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp242_ = page;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp243_ = page_get_dpi (_tmp242_);
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp244_ = _tmp243_;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp246_ = book_compress_jpeg (self, _tmp240_, _tmp241_, _tmp244_, &_tmp245_);
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data = _tmp246_;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data_length1 = _tmp245_;
#line 405 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_jpeg_data_size_ = jpeg_data_length1;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp247_ = jpeg_data;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp247__length1 = jpeg_data_length1;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp248_ = compressed_data;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp248__length1 = compressed_data_length1;
#line 406 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						if (_tmp247__length1 < _tmp248__length1) {
#line 3268 "book.c"
							gchar* _tmp249_;
							guint8* _tmp250_;
							gint _tmp250__length1;
							guint8* _tmp251_;
							gint _tmp251__length1;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp249_ = g_strdup ("DCTDecode");
#line 408 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_g_free0 (filter);
#line 408 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							filter = _tmp249_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp250_ = jpeg_data;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp250__length1 = jpeg_data_length1;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp251_ = (_tmp250_ != NULL) ? _vala_array_dup1 (_tmp250_, _tmp250__length1) : ((gpointer) _tmp250_);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_tmp251__length1 = _tmp250__length1;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = (g_free (data), NULL);
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data = _tmp251_;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							data_length1 = _tmp251__length1;
#line 409 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
							_data_size_ = data_length1;
#line 3296 "book.c"
						}
#line 403 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						jpeg_data = (g_free (jpeg_data), NULL);
#line 3300 "book.c"
					}
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp252_ = filter;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					if (_tmp252_ == NULL) {
#line 3306 "book.c"
						gchar* _tmp253_;
						guint8* _tmp254_;
						gint _tmp254__length1;
						guint8* _tmp255_;
						gint _tmp255__length1;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp253_ = g_strdup ("FlateDecode");
#line 415 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_g_free0 (filter);
#line 415 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						filter = _tmp253_;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp254_ = compressed_data;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp254__length1 = compressed_data_length1;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp255_ = (_tmp254_ != NULL) ? _vala_array_dup2 (_tmp254_, _tmp254__length1) : ((gpointer) _tmp254_);
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_tmp255__length1 = _tmp254__length1;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = (g_free (data), NULL);
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data = _tmp255_;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						data_length1 = _tmp255__length1;
#line 416 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
						_data_size_ = data_length1;
#line 3334 "book.c"
					}
				}
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp256_ = writer;
#line 421 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp256_, "\n");
#line 422 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp257_ = writer;
#line 422 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp258_ = pdf_writer_start_object (_tmp257_);
#line 422 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				number = _tmp258_;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp259_ = writer;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp260_ = number;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp261_ = g_strdup_printf ("%u 0 obj\n", _tmp260_);
#line 423 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp262_ = _tmp261_;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp259_, _tmp262_);
#line 423 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp262_);
#line 424 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp263_ = writer;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp263_, "<<\n");
#line 425 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp264_ = writer;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp264_, "/Type /Page\n");
#line 426 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp265_ = writer;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp266_ = pages_number;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp267_ = g_strdup_printf ("/Parent %u 0 R\n", _tmp266_);
#line 426 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp268_ = _tmp267_;
#line 426 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp265_, _tmp268_);
#line 426 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp268_);
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp269_ = writer;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp270_ = i;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp271_ = number;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp272_ = g_strdup_printf ("/Resources << /XObject << /Im%d %u 0 R >> >>\n", _tmp270_, _tmp271_ + 1);
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp273_ = _tmp272_;
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp269_, _tmp273_);
#line 427 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp273_);
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp274_ = writer;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp275_ = page_width;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp276_ = width_buffer;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp276__length1 = width_buffer_length1;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp277_ = g_ascii_formatd (_tmp276_, _tmp276__length1, "%.2f", _tmp275_);
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp278_ = page_height;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp279_ = height_buffer;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp279__length1 = height_buffer_length1;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp280_ = g_ascii_formatd (_tmp279_, _tmp279__length1, "%.2f", _tmp278_);
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp281_ = g_strdup_printf ("/MediaBox [ 0 0 %s %s ]\n", _tmp277_, _tmp280_);
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp282_ = _tmp281_;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp274_, _tmp282_);
#line 428 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp282_);
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp283_ = writer;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp284_ = number;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp285_ = g_strdup_printf ("/Contents %u 0 R\n", _tmp284_ + 2);
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp286_ = _tmp285_;
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp283_, _tmp286_);
#line 429 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp286_);
#line 430 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp287_ = writer;
#line 430 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp287_, ">>\n");
#line 431 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp288_ = writer;
#line 431 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp288_, "endobj\n");
#line 434 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp289_ = writer;
#line 434 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp289_, "\n");
#line 435 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp290_ = writer;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp291_ = pdf_writer_start_object (_tmp290_);
#line 435 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				number = _tmp291_;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp292_ = writer;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp293_ = number;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp294_ = g_strdup_printf ("%u 0 obj\n", _tmp293_);
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp295_ = _tmp294_;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp292_, _tmp295_);
#line 436 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp295_);
#line 437 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp296_ = writer;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp296_, "<<\n");
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp297_ = writer;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp297_, "/Type /XObject\n");
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp298_ = writer;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp298_, "/Subtype /Image\n");
#line 440 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp299_ = writer;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp300_ = width;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp301_ = g_strdup_printf ("/Width %d\n", _tmp300_);
#line 440 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp302_ = _tmp301_;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp299_, _tmp302_);
#line 440 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp302_);
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp303_ = writer;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp304_ = height;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp305_ = g_strdup_printf ("/Height %d\n", _tmp304_);
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp306_ = _tmp305_;
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp303_, _tmp306_);
#line 441 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp306_);
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp307_ = writer;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp308_ = color_space;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp309_ = g_strdup_printf ("/ColorSpace /%s\n", _tmp308_);
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp310_ = _tmp309_;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp307_, _tmp310_);
#line 442 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp310_);
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp311_ = writer;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp312_ = depth;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp313_ = g_strdup_printf ("/BitsPerComponent %d\n", _tmp312_);
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp314_ = _tmp313_;
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp311_, _tmp314_);
#line 443 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp314_);
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp315_ = writer;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp316_ = data;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp316__length1 = data_length1;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp317_ = g_strdup_printf ("/Length %d\n", _tmp316__length1);
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp318_ = _tmp317_;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp315_, _tmp318_);
#line 444 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp318_);
#line 445 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp319_ = filter;
#line 445 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_tmp319_ != NULL) {
#line 3539 "book.c"
					PDFWriter* _tmp320_;
					const gchar* _tmp321_;
					gchar* _tmp322_ = NULL;
					gchar* _tmp323_;
#line 446 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp320_ = writer;
#line 446 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp321_ = filter;
#line 446 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp322_ = g_strdup_printf ("/Filter /%s\n", _tmp321_);
#line 446 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_tmp323_ = _tmp322_;
#line 446 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					pdf_writer_write_string (_tmp320_, _tmp323_);
#line 446 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					_g_free0 (_tmp323_);
#line 3556 "book.c"
				}
#line 447 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp324_ = writer;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp324_, ">>\n");
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp325_ = writer;
#line 448 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp325_, "stream\n");
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp326_ = writer;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp327_ = data;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp327__length1 = data_length1;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write (_tmp326_, _tmp327_, _tmp327__length1);
#line 450 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp328_ = writer;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp328_, "\n");
#line 451 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp329_ = writer;
#line 451 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp329_, "endstream\n");
#line 452 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp330_ = writer;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp330_, "endobj\n");
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp331_ = page_width;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp332_ = width_buffer;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp332__length1 = width_buffer_length1;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp333_ = g_ascii_formatd (_tmp332_, _tmp332__length1, "%f", _tmp331_);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp334_ = page_height;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp335_ = height_buffer;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp335__length1 = height_buffer_length1;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp336_ = g_ascii_formatd (_tmp335_, _tmp335__length1, "%f", _tmp334_);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp337_ = i;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp338_ = g_strdup_printf ("q\n%s 0 0 %s 0 0 cm\n/Im%d Do\nQ", _tmp333_, _tmp336_, _tmp337_);
#line 455 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				command = _tmp338_;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp339_ = writer;
#line 456 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp339_, "\n");
#line 457 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp340_ = writer;
#line 457 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp341_ = pdf_writer_start_object (_tmp340_);
#line 457 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				number = _tmp341_;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp342_ = writer;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp343_ = number;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp344_ = g_strdup_printf ("%u 0 obj\n", _tmp343_);
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp345_ = _tmp344_;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp342_, _tmp345_);
#line 458 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp345_);
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp346_ = writer;
#line 459 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp346_, "<<\n");
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp347_ = writer;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp348_ = command;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp349_ = strlen (_tmp348_);
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp350_ = _tmp349_;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp351_ = g_strdup_printf ("/Length %d\n", _tmp350_ + 1);
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp352_ = _tmp351_;
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp347_, _tmp352_);
#line 460 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp352_);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp353_ = writer;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp353_, ">>\n");
#line 462 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp354_ = writer;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp354_, "stream\n");
#line 463 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp355_ = writer;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp356_ = command;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp355_, _tmp356_);
#line 464 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp357_ = writer;
#line 464 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp357_, "\n");
#line 465 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp358_ = writer;
#line 465 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp358_, "endstream\n");
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp359_ = writer;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp359_, "endobj\n");
#line 468 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp360_ = i;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_emit_by_name (self, "saving", _tmp360_);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (command);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				compressed_data = (g_free (compressed_data), NULL);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				data = (g_free (data), NULL);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				height_buffer = (g_free (height_buffer), NULL);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				width_buffer = (g_free (width_buffer), NULL);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (filter);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (color_space);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_object_unref0 (image);
#line 263 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 3698 "book.c"
			}
		}
	}
#line 472 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp361_ = writer;
#line 472 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp361_, "\n");
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp362_ = writer;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp363_ = pdf_writer_start_object (_tmp362_);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	info_number = _tmp363_;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp364_ = writer;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp365_ = info_number;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp366_ = g_strdup_printf ("%u 0 obj\n", _tmp365_);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp367_ = _tmp366_;
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp364_, _tmp367_);
#line 474 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp367_);
#line 475 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp368_ = writer;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp368_, "<<\n");
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp369_ = writer;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp370_ = g_strdup_printf ("/Creator (Simple Scan %s)\n", VERSION);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp371_ = _tmp370_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp369_, _tmp371_);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp371_);
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp372_ = writer;
#line 477 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp372_, ">>\n");
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp373_ = writer;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp373_, "endobj\n");
#line 481 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp374_ = writer;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp375_ = _tmp374_->offset;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	xref_offset = _tmp375_;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp376_ = writer;
#line 482 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp376_, "xref\n");
#line 483 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp377_ = writer;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp378_ = writer;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp379_ = _tmp378_->object_offsets;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp380_ = g_list_length (_tmp379_);
#line 483 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp381_ = g_strdup_printf ("1 %zu\n", (gsize) _tmp380_);
#line 483 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp382_ = _tmp381_;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp377_, _tmp382_);
#line 483 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp382_);
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp383_ = writer;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp384_ = _tmp383_->object_offsets;
#line 3776 "book.c"
	{
		GList* offset_collection = NULL;
		GList* offset_it = NULL;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		offset_collection = _tmp384_;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (offset_it = offset_collection; offset_it != NULL; offset_it = offset_it->next) {
#line 3784 "book.c"
			guint offset = 0U;
#line 484 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			offset = (guint) ((guintptr) offset_it->data);
#line 3788 "book.c"
			{
				PDFWriter* _tmp385_;
				guint _tmp386_;
				gchar* _tmp387_ = NULL;
				gchar* _tmp388_;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp385_ = writer;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp386_ = offset;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp387_ = g_strdup_printf ("%010zu 00000 n \n", (gsize) _tmp386_);
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp388_ = _tmp387_;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				pdf_writer_write_string (_tmp385_, _tmp388_);
#line 485 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_g_free0 (_tmp388_);
#line 3806 "book.c"
			}
		}
	}
#line 488 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp389_ = writer;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp389_, "trailer\n");
#line 489 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp390_ = writer;
#line 489 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp390_, "<<\n");
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp391_ = writer;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp392_ = writer;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp393_ = _tmp392_->object_offsets;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp394_ = g_list_length (_tmp393_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp395_ = g_strdup_printf ("/Size %zu\n", (gsize) _tmp394_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp396_ = _tmp395_;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp391_, _tmp396_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp396_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp397_ = writer;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp398_ = info_number;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp399_ = g_strdup_printf ("/Info %u 0 R\n", _tmp398_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp400_ = _tmp399_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp397_, _tmp400_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp400_);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp401_ = writer;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp402_ = catalog_number;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp403_ = g_strdup_printf ("/Root %u 0 R\n", _tmp402_);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp404_ = _tmp403_;
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp401_, _tmp404_);
#line 492 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp404_);
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp405_ = writer;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp405_, ">>\n");
#line 495 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp406_ = writer;
#line 495 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp406_, "startxref\n");
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp407_ = writer;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp408_ = xref_offset;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp409_ = g_strdup_printf ("%zu\n", _tmp408_);
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp410_ = _tmp409_;
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp407_, _tmp410_);
#line 496 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_free0 (_tmp410_);
#line 497 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp411_ = writer;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write_string (_tmp411_, "%%EOF\n");
#line 213 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_pdf_writer_unref0 (writer);
#line 213 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (stream);
#line 3886 "book.c"
}


void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label0 = 0;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label1 = 0;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label2 = 0;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label3 = 0;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	static GQuark _tmp2_label4 = 0;
#line 3904 "book.c"
	GError * _inner_error_ = NULL;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 500 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (type != NULL);
#line 500 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (file != NULL);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = type;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _tmp0_;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jpeg")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("png"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("tiff"))))) {
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 3922 "book.c"
			default:
			{
				const gchar* _tmp4_;
				gint _tmp5_;
				GFile* _tmp6_;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = type;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp5_ = quality;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp6_ = file;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_multi_file (self, _tmp4_, _tmp5_, _tmp6_, &_inner_error_);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_inner_error_ != NULL) {
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 3942 "book.c"
				}
#line 508 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 3946 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ps")))) {
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 3952 "book.c"
			default:
			{
				GFile* _tmp7_;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp7_ = file;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_ps (self, _tmp7_, &_inner_error_);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_inner_error_ != NULL) {
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 3966 "book.c"
				}
#line 511 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 3970 "book.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("pdf")))) {
#line 502 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		switch (0) {
#line 3976 "book.c"
			default:
			{
				GFile* _tmp8_;
				gint _tmp9_;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp8_ = file;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp9_ = quality;
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				book_save_pdf (self, _tmp8_, _tmp9_, &_inner_error_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				if (_inner_error_ != NULL) {
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					g_propagate_error (error, _inner_error_);
#line 513 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
					return;
#line 3993 "book.c"
				}
#line 514 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				break;
#line 3997 "book.c"
			}
		}
	}
}


guint book_get_n_pages (Book* self) {
	guint result;
	GList* _tmp0_;
	guint _tmp1_ = 0U;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp1_;
#line 16 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4018 "book.c"
}


gboolean book_get_needs_saving (Book* self) {
	gboolean result;
	gboolean _tmp0_;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp0_;
#line 21 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4033 "book.c"
}


void book_set_needs_saving (Book* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 22 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->needs_saving_;
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = value;
#line 24 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_tmp0_ == _tmp1_) {
#line 25 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 4051 "book.c"
	}
#line 26 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = value;
#line 26 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->needs_saving_ = _tmp2_;
#line 27 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_emit_by_name (self, "needs-saving-changed");
#line 4059 "book.c"
}


static void g_cclosure_user_marshal_VOID__PAGE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__PAGE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__PAGE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (n_param_values == 2);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data1 = closure->data;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data2 = param_values->data[0].v_pointer;
#line 4078 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		data2 = closure->data;
#line 4084 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	callback = (GMarshalFunc_VOID__PAGE) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	callback (data1, value_get_page (param_values + 1), data2);
#line 4090 "book.c"
}


static void value_book_init (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4097 "book.c"
}


static void value_book_free_value (GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (value->data[0].v_pointer);
#line 4106 "book.c"
	}
}


static void value_book_copy_value (const GValue* src_value, GValue* dest_value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = book_ref (src_value->data[0].v_pointer);
#line 4116 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4120 "book.c"
	}
}


static gpointer value_book_peek_pointer (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 4128 "book.c"
}


static gchar* value_book_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4135 "book.c"
		Book* object;
		object = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4142 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4146 "book.c"
		}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = book_ref (object);
#line 4150 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4154 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 4158 "book.c"
}


static gchar* value_book_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Book** object_p;
	object_p = collect_values[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4169 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 4175 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4179 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = book_ref (value->data[0].v_pointer);
#line 4183 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 4187 "book.c"
}


GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBook* spec;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4201 "book.c"
}


gpointer value_get_book (const GValue* value) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK), NULL);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 4210 "book.c"
}


void value_set_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_ref (value->data[0].v_pointer);
#line 4230 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4234 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (old);
#line 4240 "book.c"
	}
}


void value_take_book (GValue* value, gpointer v_object) {
	Book* old;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BOOK));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4259 "book.c"
	} else {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4263 "book.c"
	}
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		book_unref (old);
#line 4269 "book.c"
	}
}


static void book_class_init (BookClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	book_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	BOOK_CLASS (klass)->finalize = book_finalize;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_type_class_add_private (klass, sizeof (BookPrivate));
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("page_added", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("page_removed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__PAGE, G_TYPE_NONE, 1, TYPE_PAGE);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("reordered", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("cleared", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("needs_saving_changed", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_signal_new ("saving", TYPE_BOOK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 4293 "book.c"
}


static void book_instance_init (Book * self) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv = BOOK_GET_PRIVATE (self);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 4302 "book.c"
}


static void book_finalize (Book* obj) {
	Book * self;
	GList* _tmp0_;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOK, Book);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->priv->pages;
#line 4313 "book.c"
	{
		GList* page_collection = NULL;
		GList* page_it = NULL;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		page_collection = _tmp0_;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		for (page_it = page_collection; page_it != NULL; page_it = page_it->next) {
#line 4321 "book.c"
			Page* _tmp1_;
			Page* page = NULL;
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			_tmp1_ = _page_ref0 ((Page*) page_it->data);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			page = _tmp1_;
#line 4328 "book.c"
			{
				Page* _tmp2_;
				guint _tmp3_ = 0U;
				Page* _tmp4_;
				guint _tmp5_ = 0U;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp2_ = page;
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 47 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _book_page_changed_cb_page_pixels_changed, self);
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_tmp4_ = page;
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 48 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _book_page_changed_cb_page_crop_changed, self);
#line 45 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
				_page_unref0 (page);
#line 4348 "book.c"
			}
		}
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	__g_list_free__page_unref0_0 (self->priv->pages);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_byte_array_unref0 (self->priv->jpeg_data);
#line 4356 "book.c"
}


GType book_get_type (void) {
	static volatile gsize book_type_id__volatile = 0;
	if (g_once_init_enter (&book_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_book_init, value_book_free_value, value_book_copy_value, value_book_peek_pointer, "p", value_book_collect_value, "p", value_book_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Book), 0, (GInstanceInitFunc) book_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType book_type_id;
		book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Book", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&book_type_id__volatile, book_type_id);
	}
	return book_type_id__volatile;
}


gpointer book_ref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 4381 "book.c"
}


void book_unref (gpointer instance) {
	Book* self;
	self = instance;
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		BOOK_GET_CLASS (self)->finalize (self);
#line 12 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4394 "book.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 4402 "book.c"
}


PDFWriter* pdf_writer_construct (GType object_type, GFileOutputStream* stream) {
	PDFWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (PDFWriter*) g_type_create_instance (object_type);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = stream;
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 527 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv->stream = _tmp1_;
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 4424 "book.c"
}


PDFWriter* pdf_writer_new (GFileOutputStream* stream) {
#line 525 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return pdf_writer_construct (TYPE_PDF_WRITER, stream);
#line 4431 "book.c"
}


void pdf_writer_write (PDFWriter* self, guint8* data, int data_length1) {
	gsize _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 4442 "book.c"
	{
		GFileOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp0_ = self->priv->stream;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = data;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1__length1 = data_length1;
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 534 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (_inner_error_ != NULL) {
#line 4457 "book.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = e;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 538 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_warning ("book.vala:538: Error writing PDF: %s", _tmp3_);
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 4479 "book.c"
	}
	__finally1:
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_inner_error_ != NULL) {
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 532 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return;
#line 4490 "book.c"
	}
#line 540 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp4_ = self->offset;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5_ = data;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp5__length1 = data_length1;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->offset = _tmp4_ + _tmp5__length1;
#line 4500 "book.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1267 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1268 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1269 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1269 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1270 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 4555 "book.c"
	}
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1271 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 4561 "book.c"
}


void pdf_writer_write_string (PDFWriter* self, const gchar* text) {
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint8* _tmp3_;
	gint _tmp3__length1;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (self != NULL);
#line 543 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (text != NULL);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = text;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (guint8*) _tmp2_;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3__length1 = (_tmp1_ * sizeof (gchar)) / sizeof (guint8);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_write (self, _tmp3_, (_tmp1_ * sizeof (gchar)) / sizeof (guint8));
#line 545 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 4587 "book.c"
}


guint pdf_writer_start_object (PDFWriter* self) {
	guint result = 0U;
	gsize _tmp0_;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 550 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = self->offset;
#line 550 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->object_offsets = g_list_append (self->object_offsets, (gpointer) ((guintptr) ((guint) _tmp0_)));
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = self->object_offsets;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = g_list_length (_tmp1_);
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = _tmp2_;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4610 "book.c"
}


static void value_pdf_writer_init (GValue* value) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4617 "book.c"
}


static void value_pdf_writer_free_value (GValue* value) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (value->data[0].v_pointer);
#line 4626 "book.c"
	}
}


static void value_pdf_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = pdf_writer_ref (src_value->data[0].v_pointer);
#line 4636 "book.c"
	} else {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4640 "book.c"
	}
}


static gpointer value_pdf_writer_peek_pointer (const GValue* value) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 4648 "book.c"
}


static gchar* value_pdf_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 4655 "book.c"
		PDFWriter* object;
		object = collect_values[0].v_pointer;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4662 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4666 "book.c"
		}
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = pdf_writer_ref (object);
#line 4670 "book.c"
	} else {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4674 "book.c"
	}
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 4678 "book.c"
}


static gchar* value_pdf_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PDFWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4689 "book.c"
	}
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 4695 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 4699 "book.c"
	} else {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = pdf_writer_ref (value->data[0].v_pointer);
#line 4703 "book.c"
	}
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 4707 "book.c"
}


GParamSpec* param_spec_pdf_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPDFWriter* spec;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PDF_WRITER), NULL);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 4721 "book.c"
}


gpointer value_get_pdf_writer (const GValue* value) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER), NULL);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 4730 "book.c"
}


void value_set_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_ref (value->data[0].v_pointer);
#line 4750 "book.c"
	} else {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4754 "book.c"
	}
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (old);
#line 4760 "book.c"
	}
}


void value_take_pdf_writer (GValue* value, gpointer v_object) {
	PDFWriter* old;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PDF_WRITER));
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PDF_WRITER));
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 4779 "book.c"
	} else {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 4783 "book.c"
	}
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		pdf_writer_unref (old);
#line 4789 "book.c"
	}
}


static void pdf_writer_class_init (PDFWriterClass * klass) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	pdf_writer_parent_class = g_type_class_peek_parent (klass);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	PDF_WRITER_CLASS (klass)->finalize = pdf_writer_finalize;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_type_class_add_private (klass, sizeof (PDFWriterPrivate));
#line 4801 "book.c"
}


static void pdf_writer_instance_init (PDFWriter * self) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->priv = PDF_WRITER_GET_PRIVATE (self);
#line 521 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->offset = (gsize) 0;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 4812 "book.c"
}


static void pdf_writer_finalize (PDFWriter* obj) {
	PDFWriter * self;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PDF_WRITER, PDFWriter);
#line 522 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_list_free0 (self->object_offsets);
#line 523 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->priv->stream);
#line 4824 "book.c"
}


GType pdf_writer_get_type (void) {
	static volatile gsize pdf_writer_type_id__volatile = 0;
	if (g_once_init_enter (&pdf_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_pdf_writer_init, value_pdf_writer_free_value, value_pdf_writer_copy_value, value_pdf_writer_peek_pointer, "p", value_pdf_writer_collect_value, "p", value_pdf_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PDFWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdf_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PDFWriter), 0, (GInstanceInitFunc) pdf_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType pdf_writer_type_id;
		pdf_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PDFWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&pdf_writer_type_id__volatile, pdf_writer_type_id);
	}
	return pdf_writer_type_id__volatile;
}


gpointer pdf_writer_ref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 4849 "book.c"
}


void pdf_writer_unref (gpointer instance) {
	PDFWriter* self;
	self = instance;
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		PDF_WRITER_GET_CLASS (self)->finalize (self);
#line 519 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4862 "book.c"
	}
}


static cairo_status_t _ps_writer_write_cairo_data_cairo_write_func_t (gpointer self, guchar* data, int data_length1) {
	cairo_status_t result;
	result = ps_writer_write_cairo_data (self, data, data_length1);
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4872 "book.c"
}


PsWriter* ps_writer_construct (GType object_type, GFileOutputStream* stream) {
	PsWriter* self = NULL;
	GFileOutputStream* _tmp0_;
	GFileOutputStream* _tmp1_;
	cairo_surface_t* _tmp2_;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (stream != NULL, NULL);
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = (PsWriter*) g_type_create_instance (object_type);
#line 562 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp0_ = stream;
#line 562 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 562 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->stream);
#line 562 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->stream = _tmp1_;
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_tmp2_ = cairo_ps_surface_create_for_stream (_ps_writer_write_cairo_data_cairo_write_func_t, self, (gdouble) 0, (gdouble) 0);
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 563 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->surface = _tmp2_;
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return self;
#line 4901 "book.c"
}


PsWriter* ps_writer_new (GFileOutputStream* stream) {
#line 560 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return ps_writer_construct (TYPE_PS_WRITER, stream);
#line 4908 "book.c"
}


static cairo_status_t ps_writer_write_cairo_data (PsWriter* self, guint8* data, int data_length1) {
	cairo_status_t result = 0;
	GError * _inner_error_ = NULL;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 4917 "book.c"
	{
		GFileOutputStream* _tmp0_;
		guint8* _tmp1_;
		gint _tmp1__length1;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp0_ = self->stream;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1_ = data;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp1__length1 = data_length1;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_output_stream_write_all ((GOutputStream*) _tmp0_, _tmp1_, (gsize) _tmp1__length1, NULL, NULL, &_inner_error_);
#line 570 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (_inner_error_ != NULL) {
#line 4932 "book.c"
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		e = _inner_error_;
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_inner_error_ = NULL;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp2_ = e;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_tmp3_ = _tmp2_->message;
#line 574 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_warning ("book.vala:574: Error writing data: %s", _tmp3_);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		result = CAIRO_STATUS_WRITE_ERROR;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		_g_error_free0 (e);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return result;
#line 4958 "book.c"
	}
	__finally2:
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (_inner_error_ != NULL) {
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_clear_error (&_inner_error_);
#line 568 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return 0;
#line 4969 "book.c"
	}
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return result;
#line 4975 "book.c"
}


static void value_ps_writer_init (GValue* value) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	value->data[0].v_pointer = NULL;
#line 4982 "book.c"
}


static void value_ps_writer_free_value (GValue* value) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (value->data[0].v_pointer) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (value->data[0].v_pointer);
#line 4991 "book.c"
	}
}


static void value_ps_writer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = ps_writer_ref (src_value->data[0].v_pointer);
#line 5001 "book.c"
	} else {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5005 "book.c"
	}
}


static gpointer value_ps_writer_peek_pointer (const GValue* value) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5013 "book.c"
}


static gchar* value_ps_writer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (collect_values[0].v_pointer) {
#line 5020 "book.c"
		PsWriter* object;
		object = collect_values[0].v_pointer;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5027 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5031 "book.c"
		}
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = ps_writer_ref (object);
#line 5035 "book.c"
	} else {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5039 "book.c"
	}
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5043 "book.c"
}


static gchar* value_ps_writer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PsWriter** object_p;
	object_p = collect_values[0].v_pointer;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!object_p) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5054 "book.c"
	}
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (!value->data[0].v_pointer) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = NULL;
#line 5060 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 5064 "book.c"
	} else {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		*object_p = ps_writer_ref (value->data[0].v_pointer);
#line 5068 "book.c"
	}
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return NULL;
#line 5072 "book.c"
}


GParamSpec* param_spec_ps_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPsWriter* spec;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PS_WRITER), NULL);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return G_PARAM_SPEC (spec);
#line 5086 "book.c"
}


gpointer value_get_ps_writer (const GValue* value) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER), NULL);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return value->data[0].v_pointer;
#line 5095 "book.c"
}


void value_set_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_ref (value->data[0].v_pointer);
#line 5115 "book.c"
	} else {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5119 "book.c"
	}
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (old);
#line 5125 "book.c"
	}
}


void value_take_ps_writer (GValue* value, gpointer v_object) {
	PsWriter* old;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PS_WRITER));
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	old = value->data[0].v_pointer;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (v_object) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PS_WRITER));
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = v_object;
#line 5144 "book.c"
	} else {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		value->data[0].v_pointer = NULL;
#line 5148 "book.c"
	}
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (old) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		ps_writer_unref (old);
#line 5154 "book.c"
	}
}


static void ps_writer_class_init (PsWriterClass * klass) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	ps_writer_parent_class = g_type_class_peek_parent (klass);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	PS_WRITER_CLASS (klass)->finalize = ps_writer_finalize;
#line 5164 "book.c"
}


static void ps_writer_instance_init (PsWriter * self) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self->ref_count = 1;
#line 5171 "book.c"
}


static void ps_writer_finalize (PsWriter* obj) {
	PsWriter * self;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PS_WRITER, PsWriter);
#line 557 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_cairo_surface_destroy0 (self->surface);
#line 558 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	_g_object_unref0 (self->stream);
#line 5183 "book.c"
}


GType ps_writer_get_type (void) {
	static volatile gsize ps_writer_type_id__volatile = 0;
	if (g_once_init_enter (&ps_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_ps_writer_init, value_ps_writer_free_value, value_ps_writer_copy_value, value_ps_writer_peek_pointer, "p", value_ps_writer_collect_value, "p", value_ps_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PsWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ps_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PsWriter), 0, (GInstanceInitFunc) ps_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType ps_writer_type_id;
		ps_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PsWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&ps_writer_type_id__volatile, ps_writer_type_id);
	}
	return ps_writer_type_id__volatile;
}


gpointer ps_writer_ref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	return instance;
#line 5208 "book.c"
}


void ps_writer_unref (gpointer instance) {
	PsWriter* self;
	self = instance;
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		PS_WRITER_GET_CLASS (self)->finalize (self);
#line 555 "/home/bob/bzr/simple-scan/trunk/src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5221 "book.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



