/* autosave-manager.c generated by valac 0.20.1, the Vala compiler
 * generated from autosave-manager.vala, do not modify */

/*
 * Copyright (C) 2011 Timo Kluck
 * Authors: Timo Kluck <tkluck@infty.nl>
 *          Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;
typedef struct _AutosaveManagerPrivate AutosaveManagerPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _ParamSpecAutosaveManager ParamSpecAutosaveManager;

struct _AutosaveManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AutosaveManagerPrivate * priv;
};

struct _AutosaveManagerClass {
	GTypeClass parent_class;
	void (*finalize) (AutosaveManager *self);
};

struct _AutosaveManagerPrivate {
	guint update_timeout;
	GHashTable* page_filenames;
	Book* book_;
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ParamSpecAutosaveManager {
	GParamSpec parent_instance;
};


static gpointer autosave_manager_parent_class = NULL;
static gchar* autosave_manager_AUTOSAVE_DIR;
static gchar* autosave_manager_AUTOSAVE_DIR = NULL;
static gchar* autosave_manager_AUTOSAVE_FILENAME;
static gchar* autosave_manager_AUTOSAVE_FILENAME = NULL;
static gchar* autosave_manager_AUTOSAVE_PATH;
static gchar* autosave_manager_AUTOSAVE_PATH = NULL;

gpointer autosave_manager_ref (gpointer instance);
void autosave_manager_unref (gpointer instance);
GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_autosave_manager (GValue* value, gpointer v_object);
void value_take_autosave_manager (GValue* value, gpointer v_object);
gpointer value_get_autosave_manager (const GValue* value);
GType autosave_manager_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define AUTOSAVE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AUTOSAVE_MANAGER, AutosaveManagerPrivate))
enum  {
	AUTOSAVE_MANAGER_DUMMY_PROPERTY
};
AutosaveManager* autosave_manager_new (void);
AutosaveManager* autosave_manager_construct (GType object_type);
static void _page_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
void autosave_manager_load (AutosaveManager* self);
Book* autosave_manager_get_book (AutosaveManager* self);
void book_clear (Book* self);
static gchar* autosave_manager_get_value (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, const gchar* _default_);
static gint autosave_manager_get_integer (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gint _default_);
GType scan_direction_get_type (void) G_GNUC_CONST;
static gboolean autosave_manager_get_boolean (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gboolean _default_);
Page* page_new_from_data (gint width, gint n_rows, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
Page* page_construct_from_data (GType object_type, gint width, gint n_rows, gint rowstride, gint n_channels, gint depth, gint dpi, ScanDirection scan_direction, const gchar* color_profile, guchar* pixels, int pixels_length1, gboolean has_crop, const gchar* crop_name, gint crop_x, gint crop_y, gint crop_width, gint crop_height);
void book_append_page (Book* self, Page* page);
void autosave_manager_cleanup (AutosaveManager* self);
void autosave_manager_on_page_added (AutosaveManager* self, Page* page);
void autosave_manager_on_scan_finished (AutosaveManager* self, Page* page);
static void _autosave_manager_on_scan_finished_page_scan_finished (Page* _sender, gpointer self);
void autosave_manager_on_changed (AutosaveManager* self);
static void _autosave_manager_on_changed_page_crop_changed (Page* _sender, gpointer self);
void autosave_manager_on_page_removed (AutosaveManager* self, Page* page);
static void autosave_manager_save_pixels (AutosaveManager* self, Page* page);
static void autosave_manager_save (AutosaveManager* self, gboolean do_timeout);
void autosave_manager_on_cleared (AutosaveManager* self);
static gboolean ___lambda2_ (AutosaveManager* self);
static void autosave_manager_real_save (AutosaveManager* self);
static gboolean ____lambda2__gsource_func (gpointer self);
guint book_get_n_pages (Book* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_has_data (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_rowstride (Page* self);
gint page_get_n_channels (Page* self);
gint page_get_depth (Page* self);
gint page_get_dpi (Page* self);
ScanDirection page_get_scan_direction (Page* self);
gchar* page_get_color_profile (Page* self);
gboolean page_has_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
gchar* page_get_named_crop (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
void autosave_manager_set_book (AutosaveManager* self, Book* value);
static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self);
static void _autosave_manager_on_changed_book_reordered (Book* _sender, gpointer self);
static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self);
static void autosave_manager_finalize (AutosaveManager* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _page_unref0_ (gpointer var) {
#line 59 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	(var == NULL) ? NULL : (var = (page_unref (var), NULL));
#line 186 "autosave-manager.c"
}


static void _g_free0_ (gpointer var) {
#line 59 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	var = (g_free (var), NULL);
#line 193 "autosave-manager.c"
}


AutosaveManager* autosave_manager_construct (GType object_type) {
	AutosaveManager* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
#line 57 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self = (AutosaveManager*) g_type_create_instance (object_type);
#line 59 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = g_direct_hash;
#line 59 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp1_ = g_direct_equal;
#line 59 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _page_unref0_, _g_free0_);
#line 59 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_hash_table_unref0 (self->priv->page_filenames);
#line 59 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->priv->page_filenames = _tmp2_;
#line 57 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return self;
#line 216 "autosave-manager.c"
}


AutosaveManager* autosave_manager_new (void) {
#line 57 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return autosave_manager_construct (TYPE_AUTOSAVE_MANAGER);
#line 223 "autosave-manager.c"
}


static gpointer _page_ref0 (gpointer self) {
#line 151 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return self ? page_ref (self) : NULL;
#line 230 "autosave-manager.c"
}


void autosave_manager_load (AutosaveManager* self) {
	Book* _tmp0_;
	Book* _tmp1_;
	GHashTable* _tmp2_;
	GKeyFile* _tmp3_;
	GKeyFile* file;
	GKeyFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* pages;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 62 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:64: Loading autosave information");
#line 66 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = autosave_manager_get_book (self);
#line 66 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp1_ = _tmp0_;
#line 66 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	book_clear (_tmp1_);
#line 67 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp2_ = self->priv->page_filenames;
#line 67 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_hash_table_remove_all (_tmp2_);
#line 69 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp3_ = g_key_file_new ();
#line 69 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	file = _tmp3_;
#line 265 "autosave-manager.c"
	{
		GKeyFile* _tmp4_;
		const gchar* _tmp5_;
#line 72 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp4_ = file;
#line 72 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp5_ = autosave_manager_AUTOSAVE_PATH;
#line 72 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error_);
#line 72 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 277 "autosave-manager.c"
			goto __catch23_g_error;
		}
	}
	goto __finally23;
	__catch23_g_error:
	{
		GError* e = NULL;
#line 70 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		e = _inner_error_;
#line 70 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 76 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:76: Could not load autosave infomation; not rest" \
"oring any autosaves");
#line 77 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 77 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 77 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return;
#line 297 "autosave-manager.c"
	}
	__finally23:
#line 70 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_inner_error_ != NULL) {
#line 70 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 70 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 70 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 70 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return;
#line 310 "autosave-manager.c"
	}
#line 79 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp6_ = file;
#line 79 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp7_ = autosave_manager_get_value (self, _tmp6_, "simple-scan", "pages", "");
#line 79 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	pages = _tmp7_;
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp8_ = pages;
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
#line 322 "autosave-manager.c"
	{
		gchar** page_name_collection = NULL;
		gint page_name_collection_length1 = 0;
		gint _page_name_collection_size_ = 0;
		gint page_name_it = 0;
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		page_name_collection = _tmp10_;
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		page_name_collection_length1 = _vala_array_length (_tmp9_);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		for (page_name_it = 0; page_name_it < _vala_array_length (_tmp9_); page_name_it = page_name_it + 1) {
#line 334 "autosave-manager.c"
			gchar* _tmp11_;
			gchar* page_name = NULL;
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			_tmp11_ = g_strdup (page_name_collection[page_name_it]);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			page_name = _tmp11_;
#line 341 "autosave-manager.c"
			{
				const gchar* _tmp12_;
				GKeyFile* _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_ = 0;
				gint scan_width;
				GKeyFile* _tmp16_;
				const gchar* _tmp17_;
				gint _tmp18_ = 0;
				gint scan_height;
				GKeyFile* _tmp19_;
				const gchar* _tmp20_;
				gint _tmp21_ = 0;
				gint rowstride;
				GKeyFile* _tmp22_;
				const gchar* _tmp23_;
				gint _tmp24_ = 0;
				gint n_channels;
				GKeyFile* _tmp25_;
				const gchar* _tmp26_;
				gint _tmp27_ = 0;
				gint depth;
				GKeyFile* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_ = 0;
				gint dpi;
				GKeyFile* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_ = NULL;
				gchar* scan_direction_name;
				ScanDirection scan_direction;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				GQuark _tmp37_ = 0U;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				static GQuark _tmp36_label0 = 0;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				static GQuark _tmp36_label1 = 0;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				static GQuark _tmp36_label2 = 0;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				static GQuark _tmp36_label3 = 0;
#line 384 "autosave-manager.c"
				GKeyFile* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_ = NULL;
				gchar* color_profile;
				const gchar* _tmp41_;
				GKeyFile* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_ = NULL;
				gchar* pixels_filename;
				GKeyFile* _tmp45_;
				const gchar* _tmp46_;
				gboolean _tmp47_ = FALSE;
				gboolean has_crop;
				GKeyFile* _tmp48_;
				const gchar* _tmp49_;
				gchar* _tmp50_ = NULL;
				gchar* crop_name;
				const gchar* _tmp51_;
				GKeyFile* _tmp52_;
				const gchar* _tmp53_;
				gint _tmp54_ = 0;
				gint crop_x;
				GKeyFile* _tmp55_;
				const gchar* _tmp56_;
				gint _tmp57_ = 0;
				gint crop_y;
				GKeyFile* _tmp58_;
				const gchar* _tmp59_;
				gint _tmp60_ = 0;
				gint crop_width;
				GKeyFile* _tmp61_;
				const gchar* _tmp62_;
				gint _tmp63_ = 0;
				gint crop_height;
				guchar* pixels;
				gint pixels_length1;
				gint _pixels_size_;
				const gchar* _tmp64_;
				gint _tmp73_;
				gint _tmp74_;
				gint _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
				ScanDirection _tmp79_;
				const gchar* _tmp80_;
				guchar* _tmp81_;
				gint _tmp81__length1;
				gboolean _tmp82_;
				const gchar* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				Page* _tmp88_;
				Page* page;
				GHashTable* _tmp89_;
				Page* _tmp90_;
				Page* _tmp91_;
				const gchar* _tmp92_;
				gchar* _tmp93_;
				Book* _tmp94_;
				Book* _tmp95_;
				Page* _tmp96_;
#line 82 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp12_ = page_name;
#line 82 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_debug ("autosave-manager.vala:82: Loading automatically saved page %s", _tmp12_);
#line 84 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp13_ = file;
#line 84 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp14_ = page_name;
#line 84 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp15_ = autosave_manager_get_integer (self, _tmp13_, _tmp14_, "scan-width", 0);
#line 84 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				scan_width = _tmp15_;
#line 85 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp16_ = file;
#line 85 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp17_ = page_name;
#line 85 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp18_ = autosave_manager_get_integer (self, _tmp16_, _tmp17_, "scan-height", 0);
#line 85 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				scan_height = _tmp18_;
#line 86 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp19_ = file;
#line 86 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp20_ = page_name;
#line 86 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp21_ = autosave_manager_get_integer (self, _tmp19_, _tmp20_, "rowstride", 0);
#line 86 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				rowstride = _tmp21_;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp22_ = file;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp23_ = page_name;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp24_ = autosave_manager_get_integer (self, _tmp22_, _tmp23_, "n-channels", 0);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				n_channels = _tmp24_;
#line 88 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp25_ = file;
#line 88 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp26_ = page_name;
#line 88 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp27_ = autosave_manager_get_integer (self, _tmp25_, _tmp26_, "depth", 0);
#line 88 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				depth = _tmp27_;
#line 89 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp28_ = file;
#line 89 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp29_ = page_name;
#line 89 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp30_ = autosave_manager_get_integer (self, _tmp28_, _tmp29_, "dpi", 0);
#line 89 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				dpi = _tmp30_;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp31_ = file;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp32_ = page_name;
#line 90 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp33_ = autosave_manager_get_value (self, _tmp31_, _tmp32_, "scan-direction", "");
#line 90 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				scan_direction_name = _tmp33_;
#line 91 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp34_ = scan_direction_name;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp35_ = _tmp34_;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp37_ = (NULL == _tmp35_) ? 0 : g_quark_from_string (_tmp35_);
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (_tmp37_ == ((0 != _tmp36_label0) ? _tmp36_label0 : (_tmp36_label0 = g_quark_from_static_string ("TOP_TO_BOTTOM")))) {
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					switch (0) {
#line 521 "autosave-manager.c"
						default:
						{
#line 95 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 96 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
							break;
#line 528 "autosave-manager.c"
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label1) ? _tmp36_label1 : (_tmp36_label1 = g_quark_from_static_string ("LEFT_TO_RIGHT")))) {
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					switch (0) {
#line 534 "autosave-manager.c"
						default:
						{
#line 98 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_LEFT_TO_RIGHT;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
							break;
#line 541 "autosave-manager.c"
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label2) ? _tmp36_label2 : (_tmp36_label2 = g_quark_from_static_string ("BOTTOM_TO_TOP")))) {
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					switch (0) {
#line 547 "autosave-manager.c"
						default:
						{
#line 101 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_BOTTOM_TO_TOP;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
							break;
#line 554 "autosave-manager.c"
						}
					}
				} else if (_tmp37_ == ((0 != _tmp36_label3) ? _tmp36_label3 : (_tmp36_label3 = g_quark_from_static_string ("RIGHT_TO_LEFT")))) {
#line 92 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					switch (0) {
#line 560 "autosave-manager.c"
						default:
						{
#line 104 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
							scan_direction = SCAN_DIRECTION_RIGHT_TO_LEFT;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
							break;
#line 567 "autosave-manager.c"
						}
					}
				}
#line 107 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp38_ = file;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp39_ = page_name;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp40_ = autosave_manager_get_value (self, _tmp38_, _tmp39_, "color-profile", "");
#line 107 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				color_profile = _tmp40_;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp41_ = color_profile;
#line 108 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp41_, "") == 0) {
#line 109 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_g_free0 (color_profile);
#line 109 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					color_profile = NULL;
#line 587 "autosave-manager.c"
				}
#line 110 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp42_ = file;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp43_ = page_name;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp44_ = autosave_manager_get_value (self, _tmp42_, _tmp43_, "pixels-filename", "");
#line 110 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				pixels_filename = _tmp44_;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp45_ = file;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp46_ = page_name;
#line 111 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp47_ = autosave_manager_get_boolean (self, _tmp45_, _tmp46_, "has-crop", FALSE);
#line 111 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				has_crop = _tmp47_;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp48_ = file;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp49_ = page_name;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp50_ = autosave_manager_get_value (self, _tmp48_, _tmp49_, "crop-name", "");
#line 112 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				crop_name = _tmp50_;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp51_ = crop_name;
#line 113 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp51_, "") == 0) {
#line 114 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_g_free0 (crop_name);
#line 114 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					crop_name = NULL;
#line 621 "autosave-manager.c"
				}
#line 115 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp52_ = file;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp53_ = page_name;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp54_ = autosave_manager_get_integer (self, _tmp52_, _tmp53_, "crop-x", 0);
#line 115 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				crop_x = _tmp54_;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp55_ = file;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp56_ = page_name;
#line 116 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp57_ = autosave_manager_get_integer (self, _tmp55_, _tmp56_, "crop-y", 0);
#line 116 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				crop_y = _tmp57_;
#line 117 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp58_ = file;
#line 117 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp59_ = page_name;
#line 117 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp60_ = autosave_manager_get_integer (self, _tmp58_, _tmp59_, "crop-width", 0);
#line 117 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				crop_width = _tmp60_;
#line 118 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp61_ = file;
#line 118 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp62_ = page_name;
#line 118 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp63_ = autosave_manager_get_integer (self, _tmp61_, _tmp62_, "crop-height", 0);
#line 118 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				crop_height = _tmp63_;
#line 120 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				pixels = NULL;
#line 120 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				pixels_length1 = 0;
#line 120 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_pixels_size_ = pixels_length1;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp64_ = pixels_filename;
#line 121 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp64_, "") != 0) {
#line 665 "autosave-manager.c"
					const gchar* _tmp65_;
					const gchar* _tmp66_;
					gchar* _tmp67_ = NULL;
					gchar* path;
					const gchar* _tmp68_;
					GFile* _tmp69_ = NULL;
					GFile* f;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp65_ = autosave_manager_AUTOSAVE_DIR;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp66_ = pixels_filename;
#line 123 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp67_ = g_build_filename (_tmp65_, _tmp66_, NULL);
#line 123 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					path = _tmp67_;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp68_ = path;
#line 124 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp69_ = g_file_new_for_path (_tmp68_);
#line 124 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					f = _tmp69_;
#line 687 "autosave-manager.c"
					{
						GFile* _tmp70_;
						guint8* _tmp71_ = NULL;
						gsize _tmp72_;
#line 127 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp70_ = f;
#line 127 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						g_file_load_contents (_tmp70_, NULL, &_tmp71_, &_tmp72_, NULL, &_inner_error_);
#line 127 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 127 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						pixels = _tmp71_;
#line 127 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						pixels_length1 = _tmp72_;
#line 127 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_pixels_size_ = pixels_length1;
#line 127 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						if (_inner_error_ != NULL) {
#line 706 "autosave-manager.c"
							goto __catch24_g_error;
						}
					}
					goto __finally24;
					__catch24_g_error:
					{
						GError* e = NULL;
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						e = _inner_error_;
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_inner_error_ = NULL;
#line 131 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						g_warning ("autosave-manager.vala:131: Failed to load pixel information");
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_error_free0 (e);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_object_unref0 (f);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (path);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (crop_name);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (pixels_filename);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (color_profile);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (scan_direction_name);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (page_name);
#line 132 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						continue;
#line 740 "autosave-manager.c"
					}
					__finally24:
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					if (_inner_error_ != NULL) {
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_object_unref0 (f);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (path);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						pixels = (g_free (pixels), NULL);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (crop_name);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (pixels_filename);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (color_profile);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (scan_direction_name);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (page_name);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_free0 (pages);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_g_key_file_unref0 (file);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						g_clear_error (&_inner_error_);
#line 125 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						return;
#line 773 "autosave-manager.c"
					}
#line 121 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_g_object_unref0 (f);
#line 121 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_g_free0 (path);
#line 779 "autosave-manager.c"
				}
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp73_ = scan_width;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp74_ = scan_height;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp75_ = rowstride;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp76_ = n_channels;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp77_ = depth;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp78_ = dpi;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp79_ = scan_direction;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp80_ = color_profile;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp81_ = pixels;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp81__length1 = pixels_length1;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp82_ = has_crop;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp83_ = crop_name;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp84_ = crop_x;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp85_ = crop_y;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp86_ = crop_width;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp87_ = crop_height;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp88_ = page_new_from_data (_tmp73_, _tmp74_, _tmp75_, _tmp76_, _tmp77_, _tmp78_, _tmp79_, _tmp80_, _tmp81_, _tmp81__length1, _tmp82_, _tmp83_, _tmp84_, _tmp85_, _tmp86_, _tmp87_);
#line 136 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				page = _tmp88_;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp89_ = self->priv->page_filenames;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp90_ = page;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp91_ = _page_ref0 (_tmp90_);
#line 151 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp92_ = pixels_filename;
#line 151 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp93_ = g_strdup (_tmp92_);
#line 151 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_hash_table_insert (_tmp89_, _tmp91_, _tmp93_);
#line 152 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp94_ = autosave_manager_get_book (self);
#line 152 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp95_ = _tmp94_;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp96_ = page;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				book_append_page (_tmp95_, _tmp96_);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_page_unref0 (page);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				pixels = (g_free (pixels), NULL);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (crop_name);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (pixels_filename);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (color_profile);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (scan_direction_name);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (page_name);
#line 851 "autosave-manager.c"
			}
		}
#line 80 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		page_name_collection = (_vala_array_free (page_name_collection, page_name_collection_length1, (GDestroyNotify) g_free), NULL);
#line 856 "autosave-manager.c"
	}
#line 62 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_free0 (pages);
#line 62 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_key_file_unref0 (file);
#line 862 "autosave-manager.c"
}


static gchar* autosave_manager_get_value (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, const gchar* _default_) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 156 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 156 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 156 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, NULL);
#line 156 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 156 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (_default_ != NULL, NULL);
#line 879 "autosave-manager.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp0_ = file;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp1_ = group_name;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp2_ = key;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp3_ = g_key_file_get_value (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 160 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp4_ = _tmp3_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 898 "autosave-manager.c"
			goto __catch25_g_error;
		}
#line 160 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		result = _tmp4_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return result;
#line 905 "autosave-manager.c"
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 158 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		e = _inner_error_;
#line 158 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp5_ = _default_;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 164 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		result = _tmp6_;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 164 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return result;
#line 927 "autosave-manager.c"
	}
	__finally25:
#line 158 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 158 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 158 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return NULL;
#line 936 "autosave-manager.c"
}


static gint autosave_manager_get_integer (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gint _default_) {
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 168 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, 0);
#line 168 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, 0);
#line 168 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 951 "autosave-manager.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp0_ = file;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp1_ = group_name;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp2_ = key;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp3_ = g_key_file_get_integer (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 172 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp4_ = _tmp3_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 970 "autosave-manager.c"
			goto __catch26_g_error;
		}
#line 172 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		result = _tmp4_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return result;
#line 977 "autosave-manager.c"
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		gint _tmp5_;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		e = _inner_error_;
#line 170 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp5_ = _default_;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		result = _tmp5_;
#line 176 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 176 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return result;
#line 996 "autosave-manager.c"
	}
	__finally26:
#line 170 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 170 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 170 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return 0;
#line 1005 "autosave-manager.c"
}


static gboolean autosave_manager_get_boolean (AutosaveManager* self, GKeyFile* file, const gchar* group_name, const gchar* key, gboolean _default_) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 180 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (group_name != NULL, FALSE);
#line 180 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1020 "autosave-manager.c"
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp0_ = file;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp1_ = group_name;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp2_ = key;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp3_ = g_key_file_get_boolean (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 184 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp4_ = _tmp3_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 1039 "autosave-manager.c"
			goto __catch27_g_error;
		}
#line 184 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		result = _tmp4_;
#line 184 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return result;
#line 1046 "autosave-manager.c"
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		gboolean _tmp5_;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		e = _inner_error_;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp5_ = _default_;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		result = _tmp5_;
#line 188 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 188 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return result;
#line 1065 "autosave-manager.c"
	}
	__finally27:
#line 182 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 182 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_clear_error (&_inner_error_);
#line 182 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return FALSE;
#line 1074 "autosave-manager.c"
}


void autosave_manager_cleanup (AutosaveManager* self) {
	guint _tmp0_;
	GDir* dir = NULL;
	GError * _inner_error_ = NULL;
#line 192 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 194 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:194: Deleting autosave records");
#line 196 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = self->priv->update_timeout;
#line 196 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_tmp0_ > ((guint) 0)) {
#line 1090 "autosave-manager.c"
		guint _tmp1_;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp1_ = self->priv->update_timeout;
#line 197 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_source_remove (_tmp1_);
#line 1096 "autosave-manager.c"
	}
#line 198 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 1100 "autosave-manager.c"
	{
		const gchar* _tmp2_;
		GDir* _tmp3_ = NULL;
		GDir* _tmp4_;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp2_ = autosave_manager_AUTOSAVE_DIR;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error_);
#line 203 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp4_ = _tmp3_;
#line 203 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 1113 "autosave-manager.c"
			goto __catch28_g_error;
		}
#line 203 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 203 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		dir = _tmp4_;
#line 1120 "autosave-manager.c"
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		e = _inner_error_;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 207 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp5_ = e;
#line 207 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp6_ = _tmp5_->message;
#line 207 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:207: Failed to delete autosaves: %s", _tmp6_);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 208 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return;
#line 1144 "autosave-manager.c"
	}
	__finally28:
#line 201 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_inner_error_ != NULL) {
#line 201 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_dir_close0 (dir);
#line 201 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 201 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return;
#line 1157 "autosave-manager.c"
	}
#line 211 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	while (TRUE) {
#line 1161 "autosave-manager.c"
		GDir* _tmp7_;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* filename;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* path;
		const gchar* _tmp14_;
#line 213 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp7_ = dir;
#line 213 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp8_ = g_dir_read_name (_tmp7_);
#line 213 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 213 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		filename = _tmp9_;
#line 214 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp10_ = filename;
#line 214 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (_tmp10_ == NULL) {
#line 215 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			_g_free0 (filename);
#line 215 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			break;
#line 1188 "autosave-manager.c"
		}
#line 216 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp11_ = autosave_manager_AUTOSAVE_DIR;
#line 216 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp12_ = filename;
#line 216 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp13_ = g_build_filename (_tmp11_, _tmp12_, NULL);
#line 216 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		path = _tmp13_;
#line 217 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp14_ = path;
#line 217 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_unlink (_tmp14_);
#line 211 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_free0 (path);
#line 211 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_free0 (filename);
#line 1206 "autosave-manager.c"
	}
#line 192 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_dir_close0 (dir);
#line 1210 "autosave-manager.c"
}


static void _autosave_manager_on_scan_finished_page_scan_finished (Page* _sender, gpointer self) {
#line 223 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_on_scan_finished (self, _sender);
#line 1217 "autosave-manager.c"
}


static void _autosave_manager_on_changed_page_crop_changed (Page* _sender, gpointer self) {
#line 224 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_on_changed (self);
#line 1224 "autosave-manager.c"
}


void autosave_manager_on_page_added (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	Page* _tmp1_;
#line 221 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 221 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 223 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = page;
#line 223 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_connect (_tmp0_, "scan-finished", (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
#line 224 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp1_ = page;
#line 224 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_connect (_tmp1_, "crop-changed", (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
#line 1243 "autosave-manager.c"
}


void autosave_manager_on_page_removed (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	GHashTable* _tmp4_;
	Page* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* filename;
	const gchar* _tmp8_;
	GHashTable* _tmp10_;
	Page* _tmp11_;
#line 227 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 227 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 229 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = page;
#line 229 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_parse_name ("scan-finished", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 229 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _autosave_manager_on_scan_finished_page_scan_finished, self);
#line 230 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp2_ = page;
#line 230 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 230 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _autosave_manager_on_changed_page_crop_changed, self);
#line 232 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp4_ = self->priv->page_filenames;
#line 232 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp5_ = page;
#line 232 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
#line 232 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp7_ = g_strdup ((const gchar*) _tmp6_);
#line 232 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	filename = _tmp7_;
#line 233 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp8_ = filename;
#line 233 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_tmp8_ != NULL) {
#line 1290 "autosave-manager.c"
		const gchar* _tmp9_;
#line 234 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp9_ = filename;
#line 234 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_unlink (_tmp9_);
#line 1296 "autosave-manager.c"
	}
#line 235 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp10_ = self->priv->page_filenames;
#line 235 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp11_ = page;
#line 235 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_hash_table_remove (_tmp10_, _tmp11_);
#line 227 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_free0 (filename);
#line 1306 "autosave-manager.c"
}


void autosave_manager_on_scan_finished (AutosaveManager* self, Page* page) {
	Page* _tmp0_;
#line 238 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 238 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 240 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = page;
#line 240 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_save_pixels (self, _tmp0_);
#line 241 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_save (self, FALSE);
#line 1322 "autosave-manager.c"
}


void autosave_manager_on_changed (AutosaveManager* self) {
#line 244 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 246 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_save (self, TRUE);
#line 1331 "autosave-manager.c"
}


void autosave_manager_on_cleared (AutosaveManager* self) {
	GHashTable* _tmp0_;
#line 249 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 251 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = self->priv->page_filenames;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_hash_table_remove_all (_tmp0_);
#line 252 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_save (self, TRUE);
#line 1345 "autosave-manager.c"
}


static gboolean ___lambda2_ (AutosaveManager* self) {
	gboolean result = FALSE;
#line 269 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_real_save (self);
#line 270 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 271 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	result = FALSE;
#line 271 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return result;
#line 1359 "autosave-manager.c"
}


static gboolean ____lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda2_ (self);
#line 267 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return result;
#line 1368 "autosave-manager.c"
}


static void autosave_manager_save (AutosaveManager* self, gboolean do_timeout) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp3_;
	guint _tmp4_;
	gboolean _tmp6_;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp1_ = self->priv->update_timeout;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_tmp1_ == ((guint) 0)) {
#line 1384 "autosave-manager.c"
		gboolean _tmp2_;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp2_ = do_timeout;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp0_ = _tmp2_;
#line 1390 "autosave-manager.c"
	} else {
#line 257 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp0_ = FALSE;
#line 1394 "autosave-manager.c"
	}
#line 257 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp3_ = _tmp0_;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_tmp3_) {
#line 258 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_debug ("autosave-manager.vala:258: Waiting to autosave...");
#line 1402 "autosave-manager.c"
	}
#line 261 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp4_ = self->priv->update_timeout;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_tmp4_ > ((guint) 0)) {
#line 1408 "autosave-manager.c"
		guint _tmp5_;
#line 262 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp5_ = self->priv->update_timeout;
#line 262 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_source_remove (_tmp5_);
#line 1414 "autosave-manager.c"
	}
#line 263 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 265 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp6_ = do_timeout;
#line 265 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_tmp6_) {
#line 1422 "autosave-manager.c"
		guint _tmp7_ = 0U;
#line 267 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp7_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda2__gsource_func, autosave_manager_ref (self), autosave_manager_unref);
#line 267 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		self->priv->update_timeout = _tmp7_;
#line 1428 "autosave-manager.c"
	} else {
#line 275 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		autosave_manager_real_save (self);
#line 1432 "autosave-manager.c"
	}
}


static void autosave_manager_real_save (AutosaveManager* self) {
	GKeyFile* _tmp0_;
	GKeyFile* file;
	gchar* _tmp1_;
	gchar* page_names;
	GKeyFile* _tmp105_;
	const gchar* _tmp106_;
	GError * _inner_error_ = NULL;
#line 278 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 280 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:280: Autosaving book information");
#line 282 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = g_key_file_new ();
#line 282 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	file = _tmp0_;
#line 283 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp1_ = g_strdup ("");
#line 283 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	page_names = _tmp1_;
#line 1457 "autosave-manager.c"
	{
		gint i;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		i = 0;
#line 1462 "autosave-manager.c"
		{
			gboolean _tmp2_;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			_tmp2_ = TRUE;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			while (TRUE) {
#line 1469 "autosave-manager.c"
				gboolean _tmp3_;
				gint _tmp5_;
				Book* _tmp6_;
				Book* _tmp7_;
				guint _tmp8_ = 0U;
				Book* _tmp9_;
				Book* _tmp10_;
				gint _tmp11_;
				Page* _tmp12_ = NULL;
				Page* page;
				Page* _tmp13_;
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gchar* _tmp16_ = NULL;
				gchar* page_name;
				const gchar* _tmp17_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				GKeyFile* _tmp24_;
				const gchar* _tmp25_;
				Page* _tmp26_;
				gint _tmp27_ = 0;
				GKeyFile* _tmp28_;
				const gchar* _tmp29_;
				Page* _tmp30_;
				gint _tmp31_ = 0;
				GKeyFile* _tmp32_;
				const gchar* _tmp33_;
				Page* _tmp34_;
				gint _tmp35_ = 0;
				GKeyFile* _tmp36_;
				const gchar* _tmp37_;
				Page* _tmp38_;
				gint _tmp39_ = 0;
				GKeyFile* _tmp40_;
				const gchar* _tmp41_;
				Page* _tmp42_;
				gint _tmp43_ = 0;
				GKeyFile* _tmp44_;
				const gchar* _tmp45_;
				Page* _tmp46_;
				gint _tmp47_ = 0;
				Page* _tmp48_;
				ScanDirection _tmp49_ = 0;
				Page* _tmp58_;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_;
				const gchar* _tmp61_;
				GKeyFile* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				GHashTable* _tmp66_;
				Page* _tmp67_;
				gconstpointer _tmp68_ = NULL;
				gchar* _tmp69_;
				gchar* _tmp70_;
				const gchar* _tmp71_;
				GKeyFile* _tmp73_;
				const gchar* _tmp74_;
				const gchar* _tmp75_;
				GKeyFile* _tmp76_;
				const gchar* _tmp77_;
				Page* _tmp78_;
				gboolean _tmp79_ = FALSE;
				gint cx = 0;
				gint cy = 0;
				gint cw = 0;
				gint ch = 0;
				Page* _tmp80_;
				gint _tmp81_ = 0;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				Page* _tmp85_;
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_;
				const gchar* _tmp88_;
				GKeyFile* _tmp90_;
				const gchar* _tmp91_;
				const gchar* _tmp92_;
				GKeyFile* _tmp93_;
				const gchar* _tmp94_;
				gint _tmp95_;
				GKeyFile* _tmp96_;
				const gchar* _tmp97_;
				gint _tmp98_;
				GKeyFile* _tmp99_;
				const gchar* _tmp100_;
				gint _tmp101_;
				GKeyFile* _tmp102_;
				const gchar* _tmp103_;
				gint _tmp104_;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp3_ = _tmp2_;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (!_tmp3_) {
#line 1568 "autosave-manager.c"
					gint _tmp4_;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp4_ = i;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					i = _tmp4_ + 1;
#line 1574 "autosave-manager.c"
				}
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp2_ = FALSE;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp5_ = i;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp6_ = autosave_manager_get_book (self);
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp7_ = _tmp6_;
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp8_ = book_get_n_pages (_tmp7_);
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (!(((guint) _tmp5_) < _tmp8_)) {
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					break;
#line 1590 "autosave-manager.c"
				}
#line 286 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp9_ = autosave_manager_get_book (self);
#line 286 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp10_ = _tmp9_;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp11_ = i;
#line 286 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp12_ = book_get_page (_tmp10_, _tmp11_);
#line 286 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				page = _tmp12_;
#line 289 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp13_ = page;
#line 289 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp14_ = page_has_data (_tmp13_);
#line 289 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (!_tmp14_) {
#line 290 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_page_unref0 (page);
#line 290 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					continue;
#line 1612 "autosave-manager.c"
				}
#line 292 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp15_ = i;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp16_ = g_strdup_printf ("page-%d", _tmp15_);
#line 292 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				page_name = _tmp16_;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp17_ = page_names;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (g_strcmp0 (_tmp17_, "") != 0) {
#line 1624 "autosave-manager.c"
					const gchar* _tmp18_;
					gchar* _tmp19_;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp18_ = page_names;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp19_ = g_strconcat (_tmp18_, " ", NULL);
#line 294 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_g_free0 (page_names);
#line 294 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					page_names = _tmp19_;
#line 1635 "autosave-manager.c"
				}
#line 295 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp20_ = page_names;
#line 295 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp21_ = page_name;
#line 295 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
#line 295 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (page_names);
#line 295 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				page_names = _tmp22_;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp23_ = page_name;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_debug ("autosave-manager.vala:297: Autosaving page %s", _tmp23_);
#line 299 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp24_ = file;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp25_ = page_name;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp26_ = page;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp27_ = page_get_scan_width (_tmp26_);
#line 299 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp24_, _tmp25_, "scan-width", _tmp27_);
#line 300 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp28_ = file;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp29_ = page_name;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp30_ = page;
#line 300 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp31_ = page_get_scan_height (_tmp30_);
#line 300 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp28_, _tmp29_, "scan-height", _tmp31_);
#line 301 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp32_ = file;
#line 301 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp33_ = page_name;
#line 301 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp34_ = page;
#line 301 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp35_ = page_get_rowstride (_tmp34_);
#line 301 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp32_, _tmp33_, "rowstride", _tmp35_);
#line 302 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp36_ = file;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp37_ = page_name;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp38_ = page;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp39_ = page_get_n_channels (_tmp38_);
#line 302 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp36_, _tmp37_, "n-channels", _tmp39_);
#line 303 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp40_ = file;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp41_ = page_name;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp42_ = page;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp43_ = page_get_depth (_tmp42_);
#line 303 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp40_, _tmp41_, "depth", _tmp43_);
#line 304 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp44_ = file;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp45_ = page_name;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp46_ = page;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp47_ = page_get_dpi (_tmp46_);
#line 304 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp44_, _tmp45_, "dpi", _tmp47_);
#line 305 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp48_ = page;
#line 305 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp49_ = page_get_scan_direction (_tmp48_);
#line 305 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				switch (_tmp49_) {
#line 305 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 1719 "autosave-manager.c"
					{
						GKeyFile* _tmp50_;
						const gchar* _tmp51_;
#line 308 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp50_ = file;
#line 308 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp51_ = page_name;
#line 308 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						g_key_file_set_value (_tmp50_, _tmp51_, "scan-direction", "TOP_TO_BOTTOM");
#line 309 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						break;
#line 1731 "autosave-manager.c"
					}
#line 305 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 1735 "autosave-manager.c"
					{
						GKeyFile* _tmp52_;
						const gchar* _tmp53_;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp52_ = file;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp53_ = page_name;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						g_key_file_set_value (_tmp52_, _tmp53_, "scan-direction", "LEFT_TO_RIGHT");
#line 312 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						break;
#line 1747 "autosave-manager.c"
					}
#line 305 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 1751 "autosave-manager.c"
					{
						GKeyFile* _tmp54_;
						const gchar* _tmp55_;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp54_ = file;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp55_ = page_name;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						g_key_file_set_value (_tmp54_, _tmp55_, "scan-direction", "BOTTOM_TO_TOP");
#line 315 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						break;
#line 1763 "autosave-manager.c"
					}
#line 305 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 1767 "autosave-manager.c"
					{
						GKeyFile* _tmp56_;
						const gchar* _tmp57_;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp56_ = file;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp57_ = page_name;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						g_key_file_set_value (_tmp56_, _tmp57_, "scan-direction", "RIGHT_TO_LEFT");
#line 318 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						break;
#line 1779 "autosave-manager.c"
					}
					default:
#line 305 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					break;
#line 1784 "autosave-manager.c"
				}
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp58_ = page;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp59_ = page_get_color_profile (_tmp58_);
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp60_ = _tmp59_;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp61_ = _tmp60_;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (_tmp61_ == NULL) {
#line 1796 "autosave-manager.c"
					gchar* _tmp62_;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp62_ = g_strdup ("");
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_g_free0 (_tmp60_);
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp60_ = _tmp62_;
#line 1804 "autosave-manager.c"
				}
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp63_ = file;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp64_ = page_name;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp65_ = _tmp60_;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_value (_tmp63_, _tmp64_, "color-profile", _tmp65_);
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp66_ = self->priv->page_filenames;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp67_ = page;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp68_ = g_hash_table_lookup (_tmp66_, _tmp67_);
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp69_ = g_strdup ((const gchar*) _tmp68_);
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp70_ = _tmp69_;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp71_ = _tmp70_;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (_tmp71_ == NULL) {
#line 1828 "autosave-manager.c"
					gchar* _tmp72_;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp72_ = g_strdup ("");
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_g_free0 (_tmp70_);
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp70_ = _tmp72_;
#line 1836 "autosave-manager.c"
				}
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp73_ = file;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp74_ = page_name;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp75_ = _tmp70_;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_value (_tmp73_, _tmp74_, "pixels-filename", _tmp75_);
#line 322 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp76_ = file;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp77_ = page_name;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp78_ = page;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp79_ = page_has_crop (_tmp78_);
#line 322 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_boolean (_tmp76_, _tmp77_, "has-crop", _tmp79_);
#line 324 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp80_ = page;
#line 324 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				page_get_crop (_tmp80_, &_tmp81_, &_tmp82_, &_tmp83_, &_tmp84_);
#line 324 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				cx = _tmp81_;
#line 324 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				cy = _tmp82_;
#line 324 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				cw = _tmp83_;
#line 324 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				ch = _tmp84_;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp85_ = page;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp86_ = page_get_named_crop (_tmp85_);
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp87_ = _tmp86_;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp88_ = _tmp87_;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (_tmp88_ == NULL) {
#line 1878 "autosave-manager.c"
					gchar* _tmp89_;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp89_ = g_strdup ("");
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_g_free0 (_tmp87_);
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp87_ = _tmp89_;
#line 1886 "autosave-manager.c"
				}
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp90_ = file;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp91_ = page_name;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp92_ = _tmp87_;
#line 325 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_value (_tmp90_, _tmp91_, "crop-name", _tmp92_);
#line 326 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp93_ = file;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp94_ = page_name;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp95_ = cx;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp93_, _tmp94_, "crop-x", _tmp95_);
#line 327 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp96_ = file;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp97_ = page_name;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp98_ = cy;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp96_, _tmp97_, "crop-y", _tmp98_);
#line 328 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp99_ = file;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp100_ = page_name;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp101_ = cw;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp99_, _tmp100_, "crop-width", _tmp101_);
#line 329 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp102_ = file;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp103_ = page_name;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp104_ = ch;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				g_key_file_set_integer (_tmp102_, _tmp103_, "crop-height", _tmp104_);
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (_tmp87_);
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (_tmp70_);
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (_tmp60_);
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_g_free0 (page_name);
#line 284 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_page_unref0 (page);
#line 1938 "autosave-manager.c"
			}
		}
	}
#line 331 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp105_ = file;
#line 331 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp106_ = page_names;
#line 331 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_key_file_set_value (_tmp105_, "simple-scan", "pages", _tmp106_);
#line 1948 "autosave-manager.c"
	{
		const gchar* _tmp107_;
		const gchar* _tmp108_;
		GKeyFile* _tmp109_;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_;
#line 335 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp107_ = autosave_manager_AUTOSAVE_DIR;
#line 335 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_mkdir_with_parents (_tmp107_, 0777);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp108_ = autosave_manager_AUTOSAVE_PATH;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp109_ = file;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp110_ = g_key_file_to_data (_tmp109_, NULL, NULL);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp111_ = _tmp110_;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_file_set_contents (_tmp108_, _tmp111_, (gssize) (-1), &_inner_error_);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_free0 (_tmp111_);
#line 336 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 1973 "autosave-manager.c"
			goto __catch29_g_error;
		}
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp112_;
		const gchar* _tmp113_;
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		e = _inner_error_;
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 340 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp112_ = e;
#line 340 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp113_ = _tmp112_->message;
#line 340 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:340: Failed to write autosave: %s", _tmp113_);
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 1995 "autosave-manager.c"
	}
	__finally29:
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_inner_error_ != NULL) {
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_free0 (page_names);
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_key_file_unref0 (file);
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 333 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return;
#line 2010 "autosave-manager.c"
	}
#line 278 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_free0 (page_names);
#line 278 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_key_file_unref0 (file);
#line 2016 "autosave-manager.c"
}


static void autosave_manager_save_pixels (AutosaveManager* self, Page* page) {
	GHashFunc _tmp0_;
	Page* _tmp1_;
	guint _tmp2_ = 0U;
	gchar* _tmp3_ = NULL;
	gchar* filename;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* path;
	GHashTable* _tmp6_;
	Page* _tmp7_;
	Page* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
#line 344 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 344 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (page != NULL);
#line 346 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = g_direct_hash;
#line 346 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp1_ = page;
#line 346 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp2_ = _tmp0_ (_tmp1_);
#line 346 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp3_ = g_strdup_printf ("%u.pixels", _tmp2_);
#line 346 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	filename = _tmp3_;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp4_ = autosave_manager_AUTOSAVE_DIR;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp5_ = g_build_filename (_tmp4_, filename, NULL);
#line 347 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	path = _tmp5_;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp6_ = self->priv->page_filenames;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp7_ = page;
#line 348 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp8_ = _page_ref0 (_tmp7_);
#line 348 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp9_ = g_strdup (filename);
#line 348 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_hash_table_insert (_tmp6_, _tmp8_, _tmp9_);
#line 350 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_debug ("autosave-manager.vala:350: Autosaving page pixels to %s", path);
#line 352 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp10_ = g_file_new_for_path (path);
#line 352 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	file = _tmp10_;
#line 2072 "autosave-manager.c"
	{
		Page* _tmp11_;
		gint _tmp12_ = 0;
		guchar* _tmp13_ = NULL;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp11_ = page;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp13_ = page_get_pixels (_tmp11_, &_tmp12_);
#line 355 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_file_replace_contents (file, _tmp13_, (gsize) _tmp12_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
#line 355 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (_inner_error_ != NULL) {
#line 2085 "autosave-manager.c"
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		e = _inner_error_;
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_inner_error_ = NULL;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp14_ = e;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp15_ = _tmp14_->message;
#line 359 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_warning ("autosave-manager.vala:359: Failed to autosave page contents: %s", _tmp15_);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_error_free0 (e);
#line 2107 "autosave-manager.c"
	}
	__finally30:
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_inner_error_ != NULL) {
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_object_unref0 (file);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_free0 (path);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_g_free0 (filename);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_clear_error (&_inner_error_);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return;
#line 2124 "autosave-manager.c"
	}
#line 344 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_object_unref0 (file);
#line 344 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_free0 (path);
#line 344 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_free0 (filename);
#line 2132 "autosave-manager.c"
}


Book* autosave_manager_get_book (AutosaveManager* self) {
	Book* result;
	Book* _tmp0_;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 28 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = self->priv->book_;
#line 28 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	result = _tmp0_;
#line 28 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return result;
#line 2147 "autosave-manager.c"
}


static void _autosave_manager_on_page_added_book_page_added (Book* _sender, Page* page, gpointer self) {
#line 39 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_on_page_added (self, page);
#line 2154 "autosave-manager.c"
}


static void _autosave_manager_on_page_removed_book_page_removed (Book* _sender, Page* page, gpointer self) {
#line 40 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_on_page_removed (self, page);
#line 2161 "autosave-manager.c"
}


static void _autosave_manager_on_changed_book_reordered (Book* _sender, gpointer self) {
#line 41 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_on_changed (self);
#line 2168 "autosave-manager.c"
}


static void _autosave_manager_on_cleared_book_cleared (Book* _sender, gpointer self) {
#line 42 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_on_cleared (self);
#line 2175 "autosave-manager.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 44 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return self ? book_ref (self) : NULL;
#line 2182 "autosave-manager.c"
}


void autosave_manager_set_book (AutosaveManager* self, Book* value) {
	Book* _tmp0_;
	Book* _tmp19_;
	Book* _tmp20_;
	Book* _tmp21_;
	Book* _tmp22_;
	Book* _tmp23_;
	Book* _tmp24_;
#line 30 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (self != NULL);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = self->priv->book_;
#line 32 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (_tmp0_ != NULL) {
#line 2200 "autosave-manager.c"
		Book* _tmp11_;
		guint _tmp12_ = 0U;
		Book* _tmp13_;
		guint _tmp14_ = 0U;
		Book* _tmp15_;
		guint _tmp16_ = 0U;
		Book* _tmp17_;
		guint _tmp18_ = 0U;
		{
			gint i;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			i = 0;
#line 2213 "autosave-manager.c"
			{
				gboolean _tmp1_;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp1_ = TRUE;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				while (TRUE) {
#line 2220 "autosave-manager.c"
					gboolean _tmp2_;
					gint _tmp4_;
					Book* _tmp5_;
					guint _tmp6_ = 0U;
					Book* _tmp7_;
					gint _tmp8_;
					Page* _tmp9_ = NULL;
					Page* page;
					Page* _tmp10_;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp2_ = _tmp1_;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					if (!_tmp2_) {
#line 2234 "autosave-manager.c"
						gint _tmp3_;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						_tmp3_ = i;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						i = _tmp3_ + 1;
#line 2240 "autosave-manager.c"
					}
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp1_ = FALSE;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp4_ = i;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp5_ = self->priv->book_;
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp6_ = book_get_n_pages (_tmp5_);
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					if (!(((guint) _tmp4_) < _tmp6_)) {
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
						break;
#line 2254 "autosave-manager.c"
					}
#line 36 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp7_ = self->priv->book_;
#line 36 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp8_ = i;
#line 36 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp9_ = book_get_page (_tmp7_, _tmp8_);
#line 36 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					page = _tmp9_;
#line 37 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp10_ = page;
#line 37 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					autosave_manager_on_page_removed (self, _tmp10_);
#line 34 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_page_unref0 (page);
#line 2270 "autosave-manager.c"
				}
			}
		}
#line 39 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp11_ = self->priv->book_;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp12_, NULL, FALSE);
#line 39 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _autosave_manager_on_page_added_book_page_added, self);
#line 40 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp13_ = self->priv->book_;
#line 40 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp14_, NULL, FALSE);
#line 40 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp15_ = self->priv->book_;
#line 41 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp16_, NULL, FALSE);
#line 41 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _autosave_manager_on_changed_book_reordered, self);
#line 42 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		_tmp17_ = self->priv->book_;
#line 42 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_signal_parse_name ("cleared", TYPE_BOOK, &_tmp18_, NULL, FALSE);
#line 42 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_signal_handlers_disconnect_matched (_tmp17_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp18_, 0, NULL, (GCallback) _autosave_manager_on_cleared_book_cleared, self);
#line 2298 "autosave-manager.c"
	}
#line 44 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp19_ = value;
#line 44 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp20_ = _book_ref0 (_tmp19_);
#line 44 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_book_unref0 (self->priv->book_);
#line 44 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->priv->book_ = _tmp20_;
#line 45 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp21_ = self->priv->book_;
#line 45 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_connect (_tmp21_, "page-added", (GCallback) _autosave_manager_on_page_added_book_page_added, self);
#line 46 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp22_ = self->priv->book_;
#line 46 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_connect (_tmp22_, "page-removed", (GCallback) _autosave_manager_on_page_removed_book_page_removed, self);
#line 47 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp23_ = self->priv->book_;
#line 47 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_connect (_tmp23_, "reordered", (GCallback) _autosave_manager_on_changed_book_reordered, self);
#line 48 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp24_ = self->priv->book_;
#line 48 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_signal_connect (_tmp24_, "cleared", (GCallback) _autosave_manager_on_cleared_book_cleared, self);
#line 2324 "autosave-manager.c"
	{
		gint i;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		i = 0;
#line 2329 "autosave-manager.c"
		{
			gboolean _tmp25_;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			_tmp25_ = TRUE;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			while (TRUE) {
#line 2336 "autosave-manager.c"
				gboolean _tmp26_;
				gint _tmp28_;
				Book* _tmp29_;
				guint _tmp30_ = 0U;
				Book* _tmp31_;
				gint _tmp32_;
				Page* _tmp33_ = NULL;
				Page* page;
				Page* _tmp34_;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp26_ = _tmp25_;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (!_tmp26_) {
#line 2350 "autosave-manager.c"
					gint _tmp27_;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					_tmp27_ = i;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					i = _tmp27_ + 1;
#line 2356 "autosave-manager.c"
				}
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp25_ = FALSE;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp28_ = i;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp29_ = self->priv->book_;
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp30_ = book_get_n_pages (_tmp29_);
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				if (!(((guint) _tmp28_) < _tmp30_)) {
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
					break;
#line 2370 "autosave-manager.c"
				}
#line 51 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp31_ = self->priv->book_;
#line 51 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp32_ = i;
#line 51 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp33_ = book_get_page (_tmp31_, _tmp32_);
#line 51 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				page = _tmp33_;
#line 52 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_tmp34_ = page;
#line 52 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				autosave_manager_on_page_added (self, _tmp34_);
#line 49 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
				_page_unref0 (page);
#line 2386 "autosave-manager.c"
			}
		}
	}
}


static void value_autosave_manager_init (GValue* value) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	value->data[0].v_pointer = NULL;
#line 2396 "autosave-manager.c"
}


static void value_autosave_manager_free_value (GValue* value) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (value->data[0].v_pointer) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		autosave_manager_unref (value->data[0].v_pointer);
#line 2405 "autosave-manager.c"
	}
}


static void value_autosave_manager_copy_value (const GValue* src_value, GValue* dest_value) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (src_value->data[0].v_pointer) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		dest_value->data[0].v_pointer = autosave_manager_ref (src_value->data[0].v_pointer);
#line 2415 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2419 "autosave-manager.c"
	}
}


static gpointer value_autosave_manager_peek_pointer (const GValue* value) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return value->data[0].v_pointer;
#line 2427 "autosave-manager.c"
}


static gchar* value_autosave_manager_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (collect_values[0].v_pointer) {
#line 2434 "autosave-manager.c"
		AutosaveManager* object;
		object = collect_values[0].v_pointer;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		if (object->parent_instance.g_class == NULL) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2441 "autosave-manager.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2445 "autosave-manager.c"
		}
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		value->data[0].v_pointer = autosave_manager_ref (object);
#line 2449 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2453 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return NULL;
#line 2457 "autosave-manager.c"
}


static gchar* value_autosave_manager_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AutosaveManager** object_p;
	object_p = collect_values[0].v_pointer;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (!object_p) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2468 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (!value->data[0].v_pointer) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		*object_p = NULL;
#line 2474 "autosave-manager.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		*object_p = value->data[0].v_pointer;
#line 2478 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		*object_p = autosave_manager_ref (value->data[0].v_pointer);
#line 2482 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return NULL;
#line 2486 "autosave-manager.c"
}


GParamSpec* param_spec_autosave_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAutosaveManager* spec;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AUTOSAVE_MANAGER), NULL);
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return G_PARAM_SPEC (spec);
#line 2500 "autosave-manager.c"
}


gpointer value_get_autosave_manager (const GValue* value) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER), NULL);
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return value->data[0].v_pointer;
#line 2509 "autosave-manager.c"
}


void value_set_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (v_object) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		value->data[0].v_pointer = v_object;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		autosave_manager_ref (value->data[0].v_pointer);
#line 2529 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2533 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (old) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		autosave_manager_unref (old);
#line 2539 "autosave-manager.c"
	}
}


void value_take_autosave_manager (GValue* value, gpointer v_object) {
	AutosaveManager* old;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	old = value->data[0].v_pointer;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (v_object) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AUTOSAVE_MANAGER));
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		value->data[0].v_pointer = v_object;
#line 2558 "autosave-manager.c"
	} else {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		value->data[0].v_pointer = NULL;
#line 2562 "autosave-manager.c"
	}
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (old) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		autosave_manager_unref (old);
#line 2568 "autosave-manager.c"
	}
}


static void autosave_manager_class_init (AutosaveManagerClass * klass) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_parent_class = g_type_class_peek_parent (klass);
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	AUTOSAVE_MANAGER_CLASS (klass)->finalize = autosave_manager_finalize;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_type_class_add_private (klass, sizeof (AutosaveManagerPrivate));
#line 15 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp0_ = g_get_user_cache_dir ();
#line 15 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "autosaves", NULL);
#line 15 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_DIR = _tmp1_;
#line 16 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp2_ = g_strdup ("autosave.book");
#line 16 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_FILENAME = _tmp2_;
#line 17 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp3_ = autosave_manager_AUTOSAVE_DIR;
#line 17 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp4_ = autosave_manager_AUTOSAVE_FILENAME;
#line 17 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
#line 17 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	autosave_manager_AUTOSAVE_PATH = _tmp5_;
#line 2604 "autosave-manager.c"
}


static void autosave_manager_instance_init (AutosaveManager * self) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->priv = AUTOSAVE_MANAGER_GET_PRIVATE (self);
#line 19 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->priv->update_timeout = (guint) 0;
#line 23 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->priv->book_ = NULL;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self->ref_count = 1;
#line 2617 "autosave-manager.c"
}


static void autosave_manager_finalize (AutosaveManager* obj) {
	AutosaveManager * self;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AUTOSAVE_MANAGER, AutosaveManager);
#line 21 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_g_hash_table_unref0 (self->priv->page_filenames);
#line 23 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	_book_unref0 (self->priv->book_);
#line 2629 "autosave-manager.c"
}


GType autosave_manager_get_type (void) {
	static volatile gsize autosave_manager_type_id__volatile = 0;
	if (g_once_init_enter (&autosave_manager_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_autosave_manager_init, value_autosave_manager_free_value, value_autosave_manager_copy_value, value_autosave_manager_peek_pointer, "p", value_autosave_manager_collect_value, "p", value_autosave_manager_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AutosaveManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) autosave_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AutosaveManager), 0, (GInstanceInitFunc) autosave_manager_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType autosave_manager_type_id;
		autosave_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AutosaveManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&autosave_manager_type_id__volatile, autosave_manager_type_id);
	}
	return autosave_manager_type_id__volatile;
}


gpointer autosave_manager_ref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	g_atomic_int_inc (&self->ref_count);
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	return instance;
#line 2654 "autosave-manager.c"
}


void autosave_manager_unref (gpointer instance) {
	AutosaveManager* self;
	self = instance;
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		AUTOSAVE_MANAGER_GET_CLASS (self)->finalize (self);
#line 13 "/home/bob/bzr/simple-scan/3.10/src/autosave-manager.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2667 "autosave-manager.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



