/* PngSupport.c generated by valac 0.36.6, the Vala compiler
 * generated from PngSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
typedef struct _PhotoFileFormatPropertiesPrivate PhotoFileFormatPropertiesPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_FILE_FORMAT_FLAGS (photo_file_format_flags_get_type ())

#define TYPE_PNG_FILE_FORMAT_PROPERTIES (png_file_format_properties_get_type ())
#define PNG_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties))
#define PNG_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatPropertiesClass))
#define IS_PNG_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES))
#define IS_PNG_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_FILE_FORMAT_PROPERTIES))
#define PNG_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatPropertiesClass))

typedef struct _PngFileFormatProperties PngFileFormatProperties;
typedef struct _PngFileFormatPropertiesClass PngFileFormatPropertiesClass;
typedef struct _PngFileFormatPropertiesPrivate PngFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_GDK_SNIFFER (gdk_sniffer_get_type ())
#define GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_SNIFFER, GdkSniffer))
#define GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_SNIFFER, GdkSnifferClass))
#define IS_GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_SNIFFER))
#define IS_GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_SNIFFER))
#define GDK_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_SNIFFER, GdkSnifferClass))

typedef struct _GdkSniffer GdkSniffer;
typedef struct _GdkSnifferClass GdkSnifferClass;
typedef struct _GdkSnifferPrivate GdkSnifferPrivate;

#define TYPE_PNG_SNIFFER (png_sniffer_get_type ())
#define PNG_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_SNIFFER, PngSniffer))
#define PNG_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_SNIFFER, PngSnifferClass))
#define IS_PNG_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_SNIFFER))
#define IS_PNG_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_SNIFFER))
#define PNG_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_SNIFFER, PngSnifferClass))

typedef struct _PngSniffer PngSniffer;
typedef struct _PngSnifferClass PngSnifferClass;
typedef struct _PngSnifferPrivate PngSnifferPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;

#define TYPE_GDK_READER (gdk_reader_get_type ())
#define GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_READER, GdkReader))
#define GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_READER, GdkReaderClass))
#define IS_GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_READER))
#define IS_GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_READER))
#define GDK_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_READER, GdkReaderClass))

typedef struct _GdkReader GdkReader;
typedef struct _GdkReaderClass GdkReaderClass;
typedef struct _GdkReaderPrivate GdkReaderPrivate;

#define TYPE_PNG_READER (png_reader_get_type ())
#define PNG_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_READER, PngReader))
#define PNG_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_READER, PngReaderClass))
#define IS_PNG_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_READER))
#define IS_PNG_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_READER))
#define PNG_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_READER, PngReaderClass))

typedef struct _PngReader PngReader;
typedef struct _PngReaderClass PngReaderClass;
typedef struct _PngReaderPrivate PngReaderPrivate;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;
typedef struct _PhotoFileWriterPrivate PhotoFileWriterPrivate;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_PNG_WRITER (png_writer_get_type ())
#define PNG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_WRITER, PngWriter))
#define PNG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_WRITER, PngWriterClass))
#define IS_PNG_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_WRITER))
#define IS_PNG_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_WRITER))
#define PNG_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_WRITER, PngWriterClass))

typedef struct _PngWriter PngWriter;
typedef struct _PngWriterClass PngWriterClass;
typedef struct _PngWriterPrivate PngWriterPrivate;

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;
typedef struct _PhotoFileMetadataWriterPrivate PhotoFileMetadataWriterPrivate;

#define TYPE_PNG_METADATA_WRITER (png_metadata_writer_get_type ())
#define PNG_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_METADATA_WRITER, PngMetadataWriter))
#define PNG_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_METADATA_WRITER, PngMetadataWriterClass))
#define IS_PNG_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_METADATA_WRITER))
#define IS_PNG_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_METADATA_WRITER))
#define PNG_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_METADATA_WRITER, PngMetadataWriterClass))

typedef struct _PngMetadataWriter PngMetadataWriter;
typedef struct _PngMetadataWriterClass PngMetadataWriterClass;
typedef struct _PngMetadataWriterPrivate PngMetadataWriterPrivate;

#define TYPE_PHOTO_FILE_FORMAT_DRIVER (photo_file_format_driver_get_type ())
#define PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver))
#define PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))
#define IS_PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define IS_PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define PHOTO_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))

typedef struct _PhotoFileFormatDriver PhotoFileFormatDriver;
typedef struct _PhotoFileFormatDriverClass PhotoFileFormatDriverClass;
typedef struct _PhotoFileFormatDriverPrivate PhotoFileFormatDriverPrivate;

#define TYPE_PNG_FILE_FORMAT_DRIVER (png_file_format_driver_get_type ())
#define PNG_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver))
#define PNG_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriverClass))
#define IS_PNG_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PNG_FILE_FORMAT_DRIVER))
#define IS_PNG_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PNG_FILE_FORMAT_DRIVER))
#define PNG_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriverClass))

typedef struct _PngFileFormatDriver PngFileFormatDriver;
typedef struct _PngFileFormatDriverClass PngFileFormatDriverClass;
typedef struct _PngFileFormatDriverPrivate PngFileFormatDriverPrivate;
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	PHOTO_FILE_FORMAT_FLAGS_NONE = 0x00000000
} PhotoFileFormatFlags;

struct _PhotoFileFormatProperties {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatPropertiesPrivate * priv;
};

struct _PhotoFileFormatPropertiesClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatProperties *self);
	PhotoFileFormat (*get_file_format) (PhotoFileFormatProperties* self);
	PhotoFileFormatFlags (*get_flags) (PhotoFileFormatProperties* self);
	gboolean (*is_recognized_extension) (PhotoFileFormatProperties* self, const gchar* ext);
	gchar* (*get_default_extension) (PhotoFileFormatProperties* self);
	gchar** (*get_known_extensions) (PhotoFileFormatProperties* self, int* result_length1);
	gchar* (*get_default_mime_type) (PhotoFileFormatProperties* self);
	gchar** (*get_mime_types) (PhotoFileFormatProperties* self, int* result_length1);
	gchar* (*get_user_visible_name) (PhotoFileFormatProperties* self);
};

struct _PngFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	PngFileFormatPropertiesPrivate * priv;
};

struct _PngFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _GdkSniffer {
	PhotoFileSniffer parent_instance;
	GdkSnifferPrivate * priv;
};

struct _GdkSnifferClass {
	PhotoFileSnifferClass parent_class;
};

struct _PngSniffer {
	GdkSniffer parent_instance;
	PngSnifferPrivate * priv;
};

struct _PngSnifferClass {
	GdkSnifferClass parent_class;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _GdkReader {
	PhotoFileReader parent_instance;
	GdkReaderPrivate * priv;
};

struct _GdkReaderClass {
	PhotoFileReaderClass parent_class;
};

struct _PngReader {
	GdkReader parent_instance;
	PngReaderPrivate * priv;
};

struct _PngReaderClass {
	GdkReaderClass parent_class;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _PhotoFileWriter {
	PhotoFileAdapter parent_instance;
	PhotoFileWriterPrivate * priv;
};

struct _PhotoFileWriterClass {
	PhotoFileAdapterClass parent_class;
	void (*write) (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
};

struct _PngWriter {
	PhotoFileWriter parent_instance;
	PngWriterPrivate * priv;
};

struct _PngWriterClass {
	PhotoFileWriterClass parent_class;
};

struct _PhotoFileMetadataWriter {
	PhotoFileAdapter parent_instance;
	PhotoFileMetadataWriterPrivate * priv;
};

struct _PhotoFileMetadataWriterClass {
	PhotoFileAdapterClass parent_class;
	void (*write_metadata) (PhotoFileMetadataWriter* self, PhotoMetadata* metadata, GError** error);
};

struct _PngMetadataWriter {
	PhotoFileMetadataWriter parent_instance;
	PngMetadataWriterPrivate * priv;
};

struct _PngMetadataWriterClass {
	PhotoFileMetadataWriterClass parent_class;
};

struct _PhotoFileFormatDriver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatDriverPrivate * priv;
};

struct _PhotoFileFormatDriverClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatDriver *self);
	PhotoFileFormatProperties* (*get_properties) (PhotoFileFormatDriver* self);
	PhotoFileReader* (*create_reader) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoMetadata* (*create_metadata) (PhotoFileFormatDriver* self);
	gboolean (*can_write_image) (PhotoFileFormatDriver* self);
	gboolean (*can_write_metadata) (PhotoFileFormatDriver* self);
	PhotoFileWriter* (*create_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileMetadataWriter* (*create_metadata_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileSniffer* (*create_sniffer) (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
};

struct _PngFileFormatDriver {
	PhotoFileFormatDriver parent_instance;
	PngFileFormatDriverPrivate * priv;
};

struct _PngFileFormatDriverClass {
	PhotoFileFormatDriverClass parent_class;
};


static gpointer png_file_format_properties_parent_class = NULL;
static gchar** png_file_format_properties_KNOWN_EXTENSIONS;
static gint png_file_format_properties_KNOWN_EXTENSIONS_length1;
static gchar** png_file_format_properties_KNOWN_EXTENSIONS = NULL;
static gint png_file_format_properties_KNOWN_EXTENSIONS_length1 = 0;
static gint _png_file_format_properties_KNOWN_EXTENSIONS_size_ = 0;
static gchar** png_file_format_properties_KNOWN_MIME_TYPES;
static gint png_file_format_properties_KNOWN_MIME_TYPES_length1;
static gchar** png_file_format_properties_KNOWN_MIME_TYPES = NULL;
static gint png_file_format_properties_KNOWN_MIME_TYPES_length1 = 0;
static gint _png_file_format_properties_KNOWN_MIME_TYPES_size_ = 0;
static PngFileFormatProperties* png_file_format_properties_instance;
static PngFileFormatProperties* png_file_format_properties_instance = NULL;
static gpointer png_sniffer_parent_class = NULL;
static gpointer png_reader_parent_class = NULL;
static gpointer png_writer_parent_class = NULL;
static gpointer png_metadata_writer_parent_class = NULL;
static gpointer png_file_format_driver_parent_class = NULL;
static PngFileFormatDriver* png_file_format_driver_instance;
static PngFileFormatDriver* png_file_format_driver_instance = NULL;

gpointer photo_file_format_properties_ref (gpointer instance);
void photo_file_format_properties_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_properties (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_properties (GValue* value, gpointer v_object);
void value_take_photo_file_format_properties (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_properties (const GValue* value);
GType photo_file_format_properties_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType photo_file_format_flags_get_type (void) G_GNUC_CONST;
GType png_file_format_properties_get_type (void) G_GNUC_CONST;
enum  {
	PNG_FILE_FORMAT_PROPERTIES_DUMMY_PROPERTY
};
void png_file_format_properties_init (void);
PngFileFormatProperties* png_file_format_properties_new (void);
PngFileFormatProperties* png_file_format_properties_construct (GType object_type);
PngFileFormatProperties* png_file_format_properties_get_instance (void);
static PhotoFileFormat png_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags png_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* png_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static gchar* png_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** png_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base, int* result_length1);
static gchar** _vala_array_dup14 (gchar** self, int length);
static gchar* png_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** png_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base, int* result_length1);
static gchar** _vala_array_dup15 (gchar** self, int length);
PhotoFileFormatProperties* photo_file_format_properties_construct (GType object_type);
static void png_file_format_properties_finalize (PhotoFileFormatProperties * obj);
gpointer photo_file_sniffer_ref (gpointer instance);
void photo_file_sniffer_unref (gpointer instance);
GParamSpec* param_spec_photo_file_sniffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_sniffer (GValue* value, gpointer v_object);
void value_take_photo_file_sniffer (GValue* value, gpointer v_object);
gpointer value_get_photo_file_sniffer (const GValue* value);
GType photo_file_sniffer_get_type (void) G_GNUC_CONST;
gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_detected_photo_information (GValue* value, gpointer v_object);
void value_take_detected_photo_information (GValue* value, gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
GType gdk_sniffer_get_type (void) G_GNUC_CONST;
GType png_sniffer_get_type (void) G_GNUC_CONST;
enum  {
	PNG_SNIFFER_DUMMY_PROPERTY
};
PngSniffer* png_sniffer_new (GFile* file, PhotoFileSnifferOptions options);
PngSniffer* png_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
GdkSniffer* gdk_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
static gboolean png_sniffer_is_png_file (GFile* file, GError** error);
static DetectedPhotoInformation* png_sniffer_real_sniff (PhotoFileSniffer* base, gboolean* is_corrupted, GError** error);
DetectedPhotoInformation* photo_file_sniffer_sniff (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
GType gdk_reader_get_type (void) G_GNUC_CONST;
GType png_reader_get_type (void) G_GNUC_CONST;
enum  {
	PNG_READER_DUMMY_PROPERTY
};
PngReader* png_reader_new (const gchar* filepath);
PngReader* png_reader_construct (GType object_type, const gchar* filepath);
GdkReader* gdk_reader_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
static GdkPixbuf* png_reader_real_scaled_read (PhotoFileReader* base, Dimensions* full, Dimensions* scaled, GError** error);
GType scale_constraint_get_type (void) G_GNUC_CONST;
void dimensions_get_scaled_by_constraint (Dimensions *self, gint scale, ScaleConstraint constraint, Dimensions* result);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
GType png_writer_get_type (void) G_GNUC_CONST;
enum  {
	PNG_WRITER_DUMMY_PROPERTY
};
PngWriter* png_writer_new (const gchar* filepath);
PngWriter* png_writer_construct (GType object_type, const gchar* filepath);
PhotoFileWriter* photo_file_writer_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
static void png_writer_real_write (PhotoFileWriter* base, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST;
GType png_metadata_writer_get_type (void) G_GNUC_CONST;
enum  {
	PNG_METADATA_WRITER_DUMMY_PROPERTY
};
PngMetadataWriter* png_metadata_writer_new (const gchar* filepath);
PngMetadataWriter* png_metadata_writer_construct (GType object_type, const gchar* filepath);
PhotoFileMetadataWriter* photo_file_metadata_writer_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
static void png_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base, PhotoMetadata* metadata, GError** error);
void photo_metadata_write_to_file (PhotoMetadata* self, GFile* file, GError** error);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
gpointer photo_file_format_driver_ref (gpointer instance);
void photo_file_format_driver_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_driver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_driver (GValue* value, gpointer v_object);
void value_take_photo_file_format_driver (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_driver (const GValue* value);
GType photo_file_format_driver_get_type (void) G_GNUC_CONST;
GType png_file_format_driver_get_type (void) G_GNUC_CONST;
enum  {
	PNG_FILE_FORMAT_DRIVER_DUMMY_PROPERTY
};
void png_file_format_driver_init (void);
PngFileFormatDriver* png_file_format_driver_new (void);
PngFileFormatDriver* png_file_format_driver_construct (GType object_type);
PngFileFormatDriver* png_file_format_driver_get_instance (void);
static PhotoFileFormatProperties* png_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
static PhotoFileReader* png_file_format_driver_real_create_reader (PhotoFileFormatDriver* base, const gchar* filepath);
static gboolean png_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean png_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* png_file_format_driver_real_create_writer (PhotoFileFormatDriver* base, const gchar* filepath);
static PhotoFileMetadataWriter* png_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base, const gchar* filepath);
static PhotoFileSniffer* png_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base, GFile* file, PhotoFileSnifferOptions options);
static PhotoMetadata* png_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
PhotoFileFormatDriver* photo_file_format_driver_construct (GType object_type);
static void png_file_format_driver_finalize (PhotoFileFormatDriver * obj);

static const guint8 PNG_SNIFFER_MAGIC_SEQUENCE[8] = {(guint8) 137, (guint8) 80, (guint8) 78, (guint8) 71, (guint8) 13, (guint8) 10, (guint8) 26, (guint8) 10};

void png_file_format_properties_init (void) {
	PngFileFormatProperties* _tmp0_;
#line 14 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_properties_new ();
#line 14 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_photo_file_format_properties_unref0 (png_file_format_properties_instance);
#line 14 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_properties_instance = _tmp0_;
#line 627 "PngSupport.c"
}


static gpointer _photo_file_format_properties_ref0 (gpointer self) {
#line 18 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self ? photo_file_format_properties_ref (self) : NULL;
#line 634 "PngSupport.c"
}


PngFileFormatProperties* png_file_format_properties_get_instance (void) {
	PngFileFormatProperties* result = NULL;
	PngFileFormatProperties* _tmp0_;
	PngFileFormatProperties* _tmp1_;
#line 18 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_properties_instance;
#line 18 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
#line 18 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp1_;
#line 18 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 650 "PngSupport.c"
}


static PhotoFileFormat png_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base) {
	PngFileFormatProperties * self;
	PhotoFileFormat result = 0;
#line 21 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
#line 22 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = PHOTO_FILE_FORMAT_PNG;
#line 22 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 663 "PngSupport.c"
}


static PhotoFileFormatFlags png_file_format_properties_real_get_flags (PhotoFileFormatProperties* base) {
	PngFileFormatProperties * self;
	PhotoFileFormatFlags result = 0;
#line 25 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
#line 26 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
#line 26 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 676 "PngSupport.c"
}


static gchar* png_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base) {
	PngFileFormatProperties * self;
	gchar* result = NULL;
	gchar* _tmp0_;
#line 29 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
#line 30 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = g_strdup (_ ("PNG"));
#line 30 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp0_;
#line 30 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 692 "PngSupport.c"
}


static gchar* png_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base) {
	PngFileFormatProperties * self;
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 33 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
#line 34 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_properties_KNOWN_EXTENSIONS;
#line 34 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0__length1 = png_file_format_properties_KNOWN_EXTENSIONS_length1;
#line 34 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = _tmp0_[0];
#line 34 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 34 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp2_;
#line 34 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 717 "PngSupport.c"
}


static gchar** _vala_array_dup14 (gchar** self, int length) {
	gchar** result;
	int i;
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = g_new0 (gchar*, length + 1);
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	for (i = 0; i < length; i++) {
#line 728 "PngSupport.c"
		gchar* _tmp0_;
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp0_ = g_strdup (self[i]);
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		result[i] = _tmp0_;
#line 734 "PngSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 738 "PngSupport.c"
}


static gchar** png_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base, int* result_length1) {
	PngFileFormatProperties * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
#line 37 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_properties_KNOWN_EXTENSIONS;
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0__length1 = png_file_format_properties_KNOWN_EXTENSIONS_length1;
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup14 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1__length1 = _tmp0__length1;
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = _tmp1_;
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2__length1 = _tmp1__length1;
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (result_length1) {
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		*result_length1 = _tmp2__length1;
#line 769 "PngSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp2_;
#line 38 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 775 "PngSupport.c"
}


static gchar* png_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base) {
	PngFileFormatProperties * self;
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 41 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
#line 42 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_properties_KNOWN_MIME_TYPES;
#line 42 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0__length1 = png_file_format_properties_KNOWN_MIME_TYPES_length1;
#line 42 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = _tmp0_[0];
#line 42 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 42 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp2_;
#line 42 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 800 "PngSupport.c"
}


static gchar** _vala_array_dup15 (gchar** self, int length) {
	gchar** result;
	int i;
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = g_new0 (gchar*, length + 1);
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	for (i = 0; i < length; i++) {
#line 811 "PngSupport.c"
		gchar* _tmp0_;
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp0_ = g_strdup (self[i]);
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		result[i] = _tmp0_;
#line 817 "PngSupport.c"
	}
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 821 "PngSupport.c"
}


static gchar** png_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base, int* result_length1) {
	PngFileFormatProperties * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
#line 45 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_properties_KNOWN_MIME_TYPES;
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0__length1 = png_file_format_properties_KNOWN_MIME_TYPES_length1;
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup15 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1__length1 = _tmp0__length1;
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = _tmp1_;
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2__length1 = _tmp1__length1;
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (result_length1) {
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		*result_length1 = _tmp2__length1;
#line 852 "PngSupport.c"
	}
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp2_;
#line 46 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 858 "PngSupport.c"
}


PngFileFormatProperties* png_file_format_properties_construct (GType object_type) {
	PngFileFormatProperties* self = NULL;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = (PngFileFormatProperties*) photo_file_format_properties_construct (object_type);
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self;
#line 868 "PngSupport.c"
}


PngFileFormatProperties* png_file_format_properties_new (void) {
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return png_file_format_properties_construct (TYPE_PNG_FILE_FORMAT_PROPERTIES);
#line 875 "PngSupport.c"
}


static void png_file_format_properties_class_init (PngFileFormatPropertiesClass * klass) {
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_properties_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->finalize = png_file_format_properties_finalize;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = (PhotoFileFormat (*) (PhotoFileFormatProperties *)) png_file_format_properties_real_get_file_format;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = (PhotoFileFormatFlags (*) (PhotoFileFormatProperties *)) png_file_format_properties_real_get_flags;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = (gchar* (*) (PhotoFileFormatProperties *)) png_file_format_properties_real_get_user_visible_name;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = (gchar* (*) (PhotoFileFormatProperties *)) png_file_format_properties_real_get_default_extension;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = (gchar** (*) (PhotoFileFormatProperties *, int*)) png_file_format_properties_real_get_known_extensions;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = (gchar* (*) (PhotoFileFormatProperties *)) png_file_format_properties_real_get_default_mime_type;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = (gchar** (*) (PhotoFileFormatProperties *, int*)) png_file_format_properties_real_get_mime_types;
#line 8 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = g_strdup ("png");
#line 8 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = g_new0 (gchar*, 1 + 1);
#line 8 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_[0] = _tmp0_;
#line 8 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_properties_KNOWN_EXTENSIONS = _tmp1_;
#line 8 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_properties_KNOWN_EXTENSIONS_length1 = 1;
#line 9 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = g_strdup ("image/png");
#line 9 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp3_ = g_new0 (gchar*, 1 + 1);
#line 9 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp3_[0] = _tmp2_;
#line 9 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_properties_KNOWN_MIME_TYPES = _tmp3_;
#line 9 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_properties_KNOWN_MIME_TYPES_length1 = 1;
#line 922 "PngSupport.c"
}


static void png_file_format_properties_instance_init (PngFileFormatProperties * self) {
}


static void png_file_format_properties_finalize (PhotoFileFormatProperties * obj) {
	PngFileFormatProperties * self;
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PNG_FILE_FORMAT_PROPERTIES, PngFileFormatProperties);
#line 7 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (png_file_format_properties_parent_class)->finalize (obj);
#line 936 "PngSupport.c"
}


GType png_file_format_properties_get_type (void) {
	static volatile gsize png_file_format_properties_type_id__volatile = 0;
	if (g_once_init_enter (&png_file_format_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PngFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngFileFormatProperties), 0, (GInstanceInitFunc) png_file_format_properties_instance_init, NULL };
		GType png_file_format_properties_type_id;
		png_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "PngFileFormatProperties", &g_define_type_info, 0);
		g_once_init_leave (&png_file_format_properties_type_id__volatile, png_file_format_properties_type_id);
	}
	return png_file_format_properties_type_id__volatile;
}


PngSniffer* png_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options) {
	PngSniffer* self = NULL;
	GFile* _tmp0_;
	PhotoFileSnifferOptions _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 54 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = file;
#line 54 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = options;
#line 54 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = (PngSniffer*) gdk_sniffer_construct (object_type, _tmp0_, _tmp1_);
#line 53 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self;
#line 966 "PngSupport.c"
}


PngSniffer* png_sniffer_new (GFile* file, PhotoFileSnifferOptions options) {
#line 53 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return png_sniffer_construct (TYPE_PNG_SNIFFER, file, options);
#line 973 "PngSupport.c"
}


static gboolean png_sniffer_is_png_file (GFile* file, GError** error) {
	gboolean result = FALSE;
	GFileInputStream* instream = NULL;
	GFile* _tmp0_;
	GFileInputStream* _tmp1_;
	guint8* file_lead_sequence = NULL;
	guint8* _tmp3_;
	gint file_lead_sequence_length1;
	gint _file_lead_sequence_size_;
	GFileInputStream* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 58 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = file;
#line 58 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = g_file_read (_tmp0_, NULL, &_inner_error_);
#line 58 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	instream = _tmp1_;
#line 58 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1000 "PngSupport.c"
		gboolean _tmp2_ = FALSE;
#line 58 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 58 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		return _tmp2_;
#line 1006 "PngSupport.c"
	}
#line 60 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp3_ = g_new0 (guint8, G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE));
#line 60 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	file_lead_sequence = _tmp3_;
#line 60 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	file_lead_sequence_length1 = G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE);
#line 60 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_file_lead_sequence_size_ = file_lead_sequence_length1;
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp4_ = instream;
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp5_ = file_lead_sequence;
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp5__length1 = file_lead_sequence_length1;
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_input_stream_get_type (), GInputStream), _tmp5_, (gsize) _tmp5__length1, NULL, &_inner_error_);
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1026 "PngSupport.c"
		gboolean _tmp6_ = FALSE;
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		file_lead_sequence = (g_free (file_lead_sequence), NULL);
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_g_object_unref0 (instream);
#line 62 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		return _tmp6_;
#line 1036 "PngSupport.c"
	}
	{
		gint i = 0;
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		i = 0;
#line 1042 "PngSupport.c"
		{
			gboolean _tmp7_ = FALSE;
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			_tmp7_ = TRUE;
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			while (TRUE) {
#line 1049 "PngSupport.c"
				gint _tmp9_;
				guint8* _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				guint8 _tmp12_;
				gint _tmp13_;
				guint8 _tmp14_;
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				if (!_tmp7_) {
#line 1059 "PngSupport.c"
					gint _tmp8_;
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
					_tmp8_ = i;
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
					i = _tmp8_ + 1;
#line 1065 "PngSupport.c"
				}
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				_tmp7_ = FALSE;
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				_tmp9_ = i;
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				if (!(_tmp9_ < G_N_ELEMENTS (PNG_SNIFFER_MAGIC_SEQUENCE))) {
#line 64 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
					break;
#line 1075 "PngSupport.c"
				}
#line 65 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				_tmp10_ = file_lead_sequence;
#line 65 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				_tmp10__length1 = file_lead_sequence_length1;
#line 65 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				_tmp11_ = i;
#line 65 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 65 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				_tmp13_ = i;
#line 65 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				_tmp14_ = PNG_SNIFFER_MAGIC_SEQUENCE[_tmp13_];
#line 65 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
				if (_tmp12_ != _tmp14_) {
#line 66 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
					result = FALSE;
#line 66 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
					file_lead_sequence = (g_free (file_lead_sequence), NULL);
#line 66 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
					_g_object_unref0 (instream);
#line 66 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
					return result;
#line 1099 "PngSupport.c"
				}
			}
		}
	}
#line 69 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = TRUE;
#line 69 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	file_lead_sequence = (g_free (file_lead_sequence), NULL);
#line 69 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_g_object_unref0 (instream);
#line 69 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1112 "PngSupport.c"
}


static gpointer _detected_photo_information_ref0 (gpointer self) {
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self ? detected_photo_information_ref (self) : NULL;
#line 1119 "PngSupport.c"
}


static DetectedPhotoInformation* png_sniffer_real_sniff (PhotoFileSniffer* base, gboolean* is_corrupted, GError** error) {
	PngSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	DetectedPhotoInformation* result = NULL;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	gboolean _tmp2_;
	DetectedPhotoInformation* detected = NULL;
	gboolean _tmp3_ = FALSE;
	DetectedPhotoInformation* _tmp4_;
	DetectedPhotoInformation* _tmp5_;
	DetectedPhotoInformation* _tmp6_ = NULL;
	DetectedPhotoInformation* _tmp7_;
	PhotoFileFormat _tmp8_;
	DetectedPhotoInformation* _tmp10_;
	GError * _inner_error_ = NULL;
#line 72 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_SNIFFER, PngSniffer);
#line 74 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_vala_is_corrupted = FALSE;
#line 76 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 76 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = png_sniffer_is_png_file (_tmp1_, &_inner_error_);
#line 76 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = _tmp2_;
#line 76 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 76 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		return NULL;
#line 1155 "PngSupport.c"
	}
#line 76 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (!_tmp0_) {
#line 77 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		result = NULL;
#line 77 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		if (is_corrupted) {
#line 77 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			*is_corrupted = _vala_is_corrupted;
#line 1165 "PngSupport.c"
		}
#line 77 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		return result;
#line 1169 "PngSupport.c"
	}
#line 79 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp4_ = PHOTO_FILE_SNIFFER_CLASS (png_sniffer_parent_class)->sniff (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_GDK_SNIFFER, GdkSniffer), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer), &_tmp3_, &_inner_error_);
#line 79 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_vala_is_corrupted = _tmp3_;
#line 79 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	detected = _tmp4_;
#line 79 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 79 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 79 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		return NULL;
#line 1183 "PngSupport.c"
	}
#line 80 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp5_ = detected;
#line 80 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (_tmp5_ == NULL) {
#line 81 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		result = NULL;
#line 81 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_detected_photo_information_unref0 (detected);
#line 81 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		if (is_corrupted) {
#line 81 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			*is_corrupted = _vala_is_corrupted;
#line 1197 "PngSupport.c"
		}
#line 81 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		return result;
#line 1201 "PngSupport.c"
	}
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp7_ = detected;
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp8_ = _tmp7_->file_format;
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (_tmp8_ == PHOTO_FILE_FORMAT_PNG) {
#line 1209 "PngSupport.c"
		DetectedPhotoInformation* _tmp9_;
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp9_ = detected;
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp6_ = _tmp9_;
#line 1215 "PngSupport.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp6_ = NULL;
#line 1219 "PngSupport.c"
	}
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp10_ = _detected_photo_information_ref0 (_tmp6_);
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp10_;
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_detected_photo_information_unref0 (detected);
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (is_corrupted) {
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		*is_corrupted = _vala_is_corrupted;
#line 1231 "PngSupport.c"
	}
#line 83 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1235 "PngSupport.c"
}


static void png_sniffer_class_init (PngSnifferClass * klass) {
#line 50 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_sniffer_parent_class = g_type_class_peek_parent (klass);
#line 50 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileSnifferClass *) klass)->sniff = (DetectedPhotoInformation* (*) (PhotoFileSniffer *, gboolean*, GError**)) png_sniffer_real_sniff;
#line 1244 "PngSupport.c"
}


static void png_sniffer_instance_init (PngSniffer * self) {
}


GType png_sniffer_get_type (void) {
	static volatile gsize png_sniffer_type_id__volatile = 0;
	if (g_once_init_enter (&png_sniffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PngSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngSniffer), 0, (GInstanceInitFunc) png_sniffer_instance_init, NULL };
		GType png_sniffer_type_id;
		png_sniffer_type_id = g_type_register_static (TYPE_GDK_SNIFFER, "PngSniffer", &g_define_type_info, 0);
		g_once_init_leave (&png_sniffer_type_id__volatile, png_sniffer_type_id);
	}
	return png_sniffer_type_id__volatile;
}


PngReader* png_reader_construct (GType object_type, const gchar* filepath) {
	PngReader* self = NULL;
	const gchar* _tmp0_;
#line 88 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 89 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = filepath;
#line 89 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = (PngReader*) gdk_reader_construct (object_type, _tmp0_, PHOTO_FILE_FORMAT_PNG);
#line 88 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self;
#line 1275 "PngSupport.c"
}


PngReader* png_reader_new (const gchar* filepath) {
#line 88 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return png_reader_construct (TYPE_PNG_READER, filepath);
#line 1282 "PngSupport.c"
}


static GdkPixbuf* png_reader_real_scaled_read (PhotoFileReader* base, Dimensions* full, Dimensions* scaled, GError** error) {
	PngReader * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _result_ = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Dimensions _tmp2_;
	gint _tmp3_;
	GError * _inner_error_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_READER, PngReader);
#line 92 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (full != NULL, NULL);
#line 92 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (scaled != NULL, NULL);
#line 93 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_result_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = *full;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp3_ = _tmp2_.width;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (_tmp3_ > 9999) {
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp1_ = TRUE;
#line 1311 "PngSupport.c"
	} else {
		Dimensions _tmp4_;
		gint _tmp5_;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp4_ = *full;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp5_ = _tmp4_.height;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp1_ = _tmp5_ > 9999;
#line 1321 "PngSupport.c"
	}
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (_tmp1_) {
#line 1325 "PngSupport.c"
		gboolean _tmp6_ = FALSE;
		Dimensions _tmp7_;
		gint _tmp8_;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp7_ = *scaled;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp8_ = _tmp7_.width;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		if (_tmp8_ < 100) {
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			_tmp6_ = TRUE;
#line 1337 "PngSupport.c"
		} else {
			Dimensions _tmp9_;
			gint _tmp10_;
#line 103 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			_tmp9_ = *scaled;
#line 103 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			_tmp10_ = _tmp9_.height;
#line 103 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			_tmp6_ = _tmp10_ < 100;
#line 1347 "PngSupport.c"
		}
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp0_ = _tmp6_;
#line 1351 "PngSupport.c"
	} else {
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp0_ = FALSE;
#line 1355 "PngSupport.c"
	}
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (_tmp0_) {
#line 1359 "PngSupport.c"
		Dimensions prefetch_dimensions = {0};
		Dimensions _tmp11_ = {0};
		GdkPixbuf* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		Dimensions _tmp15_;
		gint _tmp16_;
		Dimensions _tmp17_;
		gint _tmp18_;
		GdkPixbuf* _tmp19_;
		GdkPixbuf* _tmp20_;
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		Dimensions _tmp23_;
		gint _tmp24_;
		Dimensions _tmp25_;
		gint _tmp26_;
		GdkPixbuf* _tmp27_;
#line 104 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		dimensions_get_scaled_by_constraint (full, 1000, SCALE_CONSTRAINT_DIMENSIONS, &_tmp11_);
#line 104 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		prefetch_dimensions = _tmp11_;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp13_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp14_ = _tmp13_;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp15_ = prefetch_dimensions;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp16_ = _tmp15_.width;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp17_ = prefetch_dimensions;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp18_ = _tmp17_.height;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp19_ = gdk_pixbuf_new_from_file_at_scale (_tmp14_, _tmp16_, _tmp18_, FALSE, &_inner_error_);
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp20_ = _tmp19_;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_g_free0 (_tmp14_);
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp12_ = _tmp20_;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			_g_object_unref0 (_result_);
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			return NULL;
#line 1410 "PngSupport.c"
		}
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp21_ = _tmp12_;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp12_ = NULL;
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_g_object_unref0 (_result_);
#line 107 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_result_ = _tmp21_;
#line 110 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp22_ = _result_;
#line 110 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp23_ = *scaled;
#line 110 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp24_ = _tmp23_.width;
#line 110 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp25_ = *scaled;
#line 110 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp26_ = _tmp25_.height;
#line 110 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp27_ = gdk_pixbuf_scale_simple (_tmp22_, _tmp24_, _tmp26_, GDK_INTERP_HYPER);
#line 110 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_g_object_unref0 (_result_);
#line 110 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_result_ = _tmp27_;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_g_object_unref0 (_tmp12_);
#line 1438 "PngSupport.c"
	} else {
		GdkPixbuf* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		Dimensions _tmp31_;
		gint _tmp32_;
		Dimensions _tmp33_;
		gint _tmp34_;
		GdkPixbuf* _tmp35_;
		GdkPixbuf* _tmp36_;
		GdkPixbuf* _tmp37_;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp29_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp30_ = _tmp29_;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp31_ = *scaled;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp32_ = _tmp31_.width;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp33_ = *scaled;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp34_ = _tmp33_.height;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp35_ = gdk_pixbuf_new_from_file_at_scale (_tmp30_, _tmp32_, _tmp34_, FALSE, &_inner_error_);
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp36_ = _tmp35_;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_g_free0 (_tmp30_);
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp28_ = _tmp36_;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			_g_object_unref0 (_result_);
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
			return NULL;
#line 1478 "PngSupport.c"
		}
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp37_ = _tmp28_;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_tmp28_ = NULL;
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_g_object_unref0 (_result_);
#line 112 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_result_ = _tmp37_;
#line 102 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		_g_object_unref0 (_tmp28_);
#line 1490 "PngSupport.c"
	}
#line 116 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _result_;
#line 116 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1496 "PngSupport.c"
}


static void png_reader_class_init (PngReaderClass * klass) {
#line 87 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_reader_parent_class = g_type_class_peek_parent (klass);
#line 87 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileReaderClass *) klass)->scaled_read = (GdkPixbuf* (*) (PhotoFileReader *, Dimensions*, Dimensions*, GError**)) png_reader_real_scaled_read;
#line 1505 "PngSupport.c"
}


static void png_reader_instance_init (PngReader * self) {
}


GType png_reader_get_type (void) {
	static volatile gsize png_reader_type_id__volatile = 0;
	if (g_once_init_enter (&png_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PngReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngReader), 0, (GInstanceInitFunc) png_reader_instance_init, NULL };
		GType png_reader_type_id;
		png_reader_type_id = g_type_register_static (TYPE_GDK_READER, "PngReader", &g_define_type_info, 0);
		g_once_init_leave (&png_reader_type_id__volatile, png_reader_type_id);
	}
	return png_reader_type_id__volatile;
}


PngWriter* png_writer_construct (GType object_type, const gchar* filepath) {
	PngWriter* self = NULL;
	const gchar* _tmp0_;
#line 121 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 122 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = filepath;
#line 122 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = (PngWriter*) photo_file_writer_construct (object_type, _tmp0_, PHOTO_FILE_FORMAT_PNG);
#line 121 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self;
#line 1536 "PngSupport.c"
}


PngWriter* png_writer_new (const gchar* filepath) {
#line 121 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return png_writer_construct (TYPE_PNG_WRITER, filepath);
#line 1543 "PngSupport.c"
}


static void png_writer_real_write (PhotoFileWriter* base, GdkPixbuf* pixbuf, JpegQuality quality, GError** error) {
	PngWriter * self;
	GdkPixbuf* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_WRITER, PngWriter);
#line 125 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 126 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = pixbuf;
#line 126 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 126 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	gdk_pixbuf_save (_tmp0_, _tmp2_, "png", &_inner_error_, "compression", "9", NULL, NULL);
#line 126 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_g_free0 (_tmp2_);
#line 126 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 126 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		return;
#line 1573 "PngSupport.c"
	}
}


static void png_writer_class_init (PngWriterClass * klass) {
#line 120 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_writer_parent_class = g_type_class_peek_parent (klass);
#line 120 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileWriterClass *) klass)->write = (void (*) (PhotoFileWriter *, GdkPixbuf*, JpegQuality, GError**)) png_writer_real_write;
#line 1583 "PngSupport.c"
}


static void png_writer_instance_init (PngWriter * self) {
}


GType png_writer_get_type (void) {
	static volatile gsize png_writer_type_id__volatile = 0;
	if (g_once_init_enter (&png_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PngWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngWriter), 0, (GInstanceInitFunc) png_writer_instance_init, NULL };
		GType png_writer_type_id;
		png_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_WRITER, "PngWriter", &g_define_type_info, 0);
		g_once_init_leave (&png_writer_type_id__volatile, png_writer_type_id);
	}
	return png_writer_type_id__volatile;
}


PngMetadataWriter* png_metadata_writer_construct (GType object_type, const gchar* filepath) {
	PngMetadataWriter* self = NULL;
	const gchar* _tmp0_;
#line 131 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 132 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = filepath;
#line 132 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = (PngMetadataWriter*) photo_file_metadata_writer_construct (object_type, _tmp0_, PHOTO_FILE_FORMAT_PNG);
#line 131 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self;
#line 1614 "PngSupport.c"
}


PngMetadataWriter* png_metadata_writer_new (const gchar* filepath) {
#line 131 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return png_metadata_writer_construct (TYPE_PNG_METADATA_WRITER, filepath);
#line 1621 "PngSupport.c"
}


static void png_metadata_writer_real_write_metadata (PhotoFileMetadataWriter* base, PhotoMetadata* metadata, GError** error) {
	PngMetadataWriter * self;
	PhotoMetadata* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError * _inner_error_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_METADATA_WRITER, PngMetadataWriter);
#line 135 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
#line 136 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = metadata;
#line 136 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 136 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = _tmp1_;
#line 136 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	photo_metadata_write_to_file (_tmp0_, _tmp2_, &_inner_error_);
#line 136 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 136 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 136 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
		return;
#line 1651 "PngSupport.c"
	}
}


static void png_metadata_writer_class_init (PngMetadataWriterClass * klass) {
#line 130 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_metadata_writer_parent_class = g_type_class_peek_parent (klass);
#line 130 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileMetadataWriterClass *) klass)->write_metadata = (void (*) (PhotoFileMetadataWriter *, PhotoMetadata*, GError**)) png_metadata_writer_real_write_metadata;
#line 1661 "PngSupport.c"
}


static void png_metadata_writer_instance_init (PngMetadataWriter * self) {
}


GType png_metadata_writer_get_type (void) {
	static volatile gsize png_metadata_writer_type_id__volatile = 0;
	if (g_once_init_enter (&png_metadata_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PngMetadataWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_metadata_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngMetadataWriter), 0, (GInstanceInitFunc) png_metadata_writer_instance_init, NULL };
		GType png_metadata_writer_type_id;
		png_metadata_writer_type_id = g_type_register_static (TYPE_PHOTO_FILE_METADATA_WRITER, "PngMetadataWriter", &g_define_type_info, 0);
		g_once_init_leave (&png_metadata_writer_type_id__volatile, png_metadata_writer_type_id);
	}
	return png_metadata_writer_type_id__volatile;
}


void png_file_format_driver_init (void) {
	PngFileFormatDriver* _tmp0_;
#line 144 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_driver_new ();
#line 144 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_photo_file_format_driver_unref0 (png_file_format_driver_instance);
#line 144 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_driver_instance = _tmp0_;
#line 145 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_properties_init ();
#line 1691 "PngSupport.c"
}


static gpointer _photo_file_format_driver_ref0 (gpointer self) {
#line 149 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self ? photo_file_format_driver_ref (self) : NULL;
#line 1698 "PngSupport.c"
}


PngFileFormatDriver* png_file_format_driver_get_instance (void) {
	PngFileFormatDriver* result = NULL;
	PngFileFormatDriver* _tmp0_;
	PngFileFormatDriver* _tmp1_;
#line 149 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_driver_instance;
#line 149 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
#line 149 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp1_;
#line 149 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1714 "PngSupport.c"
}


static PhotoFileFormatProperties* png_file_format_driver_real_get_properties (PhotoFileFormatDriver* base) {
	PngFileFormatDriver * self;
	PhotoFileFormatProperties* result = NULL;
	PngFileFormatProperties* _tmp0_;
#line 152 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 153 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = png_file_format_properties_get_instance ();
#line 153 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties);
#line 153 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1730 "PngSupport.c"
}


static PhotoFileReader* png_file_format_driver_real_create_reader (PhotoFileFormatDriver* base, const gchar* filepath) {
	PngFileFormatDriver * self;
	PhotoFileReader* result = NULL;
	const gchar* _tmp0_;
	PngReader* _tmp1_;
#line 156 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 156 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 157 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = filepath;
#line 157 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = png_reader_new (_tmp0_);
#line 157 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_READER, PhotoFileReader);
#line 157 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1751 "PngSupport.c"
}


static gboolean png_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base) {
	PngFileFormatDriver * self;
	gboolean result = FALSE;
#line 160 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 161 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = TRUE;
#line 161 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1764 "PngSupport.c"
}


static gboolean png_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base) {
	PngFileFormatDriver * self;
	gboolean result = FALSE;
#line 164 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 165 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = TRUE;
#line 165 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1777 "PngSupport.c"
}


static PhotoFileWriter* png_file_format_driver_real_create_writer (PhotoFileFormatDriver* base, const gchar* filepath) {
	PngFileFormatDriver * self;
	PhotoFileWriter* result = NULL;
	const gchar* _tmp0_;
	PngWriter* _tmp1_;
#line 168 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 168 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 169 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = filepath;
#line 169 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = png_writer_new (_tmp0_);
#line 169 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_WRITER, PhotoFileWriter);
#line 169 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1798 "PngSupport.c"
}


static PhotoFileMetadataWriter* png_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base, const gchar* filepath) {
	PngFileFormatDriver * self;
	PhotoFileMetadataWriter* result = NULL;
	const gchar* _tmp0_;
	PngMetadataWriter* _tmp1_;
#line 172 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 172 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 173 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = filepath;
#line 173 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = png_metadata_writer_new (_tmp0_);
#line 173 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter);
#line 173 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1819 "PngSupport.c"
}


static PhotoFileSniffer* png_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base, GFile* file, PhotoFileSnifferOptions options) {
	PngFileFormatDriver * self;
	PhotoFileSniffer* result = NULL;
	GFile* _tmp0_;
	PhotoFileSnifferOptions _tmp1_;
	PngSniffer* _tmp2_;
#line 176 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 176 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 177 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = file;
#line 177 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp1_ = options;
#line 177 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp2_ = png_sniffer_new (_tmp0_, _tmp1_);
#line 177 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
#line 177 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1843 "PngSupport.c"
}


static PhotoMetadata* png_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base) {
	PngFileFormatDriver * self;
	PhotoMetadata* result = NULL;
	PhotoMetadata* _tmp0_;
#line 180 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 181 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	_tmp0_ = photo_metadata_new ();
#line 181 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	result = _tmp0_;
#line 181 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return result;
#line 1859 "PngSupport.c"
}


PngFileFormatDriver* png_file_format_driver_construct (GType object_type) {
	PngFileFormatDriver* self = NULL;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = (PngFileFormatDriver*) photo_file_format_driver_construct (object_type);
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return self;
#line 1869 "PngSupport.c"
}


PngFileFormatDriver* png_file_format_driver_new (void) {
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	return png_file_format_driver_construct (TYPE_PNG_FILE_FORMAT_DRIVER);
#line 1876 "PngSupport.c"
}


static void png_file_format_driver_class_init (PngFileFormatDriverClass * klass) {
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	png_file_format_driver_parent_class = g_type_class_peek_parent (klass);
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->finalize = png_file_format_driver_finalize;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->get_properties = (PhotoFileFormatProperties* (*) (PhotoFileFormatDriver *)) png_file_format_driver_real_get_properties;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_reader = (PhotoFileReader* (*) (PhotoFileFormatDriver *, const gchar*)) png_file_format_driver_real_create_reader;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->can_write_image = (gboolean (*) (PhotoFileFormatDriver *)) png_file_format_driver_real_can_write_image;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = (gboolean (*) (PhotoFileFormatDriver *)) png_file_format_driver_real_can_write_metadata;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_writer = (PhotoFileWriter* (*) (PhotoFileFormatDriver *, const gchar*)) png_file_format_driver_real_create_writer;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = (PhotoFileMetadataWriter* (*) (PhotoFileFormatDriver *, const gchar*)) png_file_format_driver_real_create_metadata_writer;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = (PhotoFileSniffer* (*) (PhotoFileFormatDriver *, GFile*, PhotoFileSnifferOptions)) png_file_format_driver_real_create_sniffer;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_metadata = (PhotoMetadata* (*) (PhotoFileFormatDriver *)) png_file_format_driver_real_create_metadata;
#line 1901 "PngSupport.c"
}


static void png_file_format_driver_instance_init (PngFileFormatDriver * self) {
}


static void png_file_format_driver_finalize (PhotoFileFormatDriver * obj) {
	PngFileFormatDriver * self;
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PNG_FILE_FORMAT_DRIVER, PngFileFormatDriver);
#line 140 "/home/jens/Source/shotwell/src/photos/PngSupport.vala"
	PHOTO_FILE_FORMAT_DRIVER_CLASS (png_file_format_driver_parent_class)->finalize (obj);
#line 1915 "PngSupport.c"
}


GType png_file_format_driver_get_type (void) {
	static volatile gsize png_file_format_driver_type_id__volatile = 0;
	if (g_once_init_enter (&png_file_format_driver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PngFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) png_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PngFileFormatDriver), 0, (GInstanceInitFunc) png_file_format_driver_instance_init, NULL };
		GType png_file_format_driver_type_id;
		png_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "PngFileFormatDriver", &g_define_type_info, 0);
		g_once_init_leave (&png_file_format_driver_type_id__volatile, png_file_format_driver_type_id);
	}
	return png_file_format_driver_type_id__volatile;
}



