/* VideoMetadata.c generated by valac 0.36.6, the Vala compiler
 * generated from VideoMetadata.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;
typedef struct _MediaMetadataPrivate MediaMetadataPrivate;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
typedef struct _VideoMetadataPrivate VideoMetadataPrivate;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_QUICK_TIME_METADATA_LOADER (quick_time_metadata_loader_get_type ())
#define QUICK_TIME_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoader))
#define QUICK_TIME_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoaderClass))
#define IS_QUICK_TIME_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUICK_TIME_METADATA_LOADER))
#define IS_QUICK_TIME_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUICK_TIME_METADATA_LOADER))
#define QUICK_TIME_METADATA_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoaderClass))

typedef struct _QuickTimeMetadataLoader QuickTimeMetadataLoader;
typedef struct _QuickTimeMetadataLoaderClass QuickTimeMetadataLoaderClass;
#define _quick_time_metadata_loader_unref0(var) ((var == NULL) ? NULL : (var = (quick_time_metadata_loader_unref (var), NULL)))

#define TYPE_AVI_METADATA_LOADER (avi_metadata_loader_get_type ())
#define AVI_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVI_METADATA_LOADER, AVIMetadataLoader))
#define AVI_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVI_METADATA_LOADER, AVIMetadataLoaderClass))
#define IS_AVI_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVI_METADATA_LOADER))
#define IS_AVI_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVI_METADATA_LOADER))
#define AVI_METADATA_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVI_METADATA_LOADER, AVIMetadataLoaderClass))

typedef struct _AVIMetadataLoader AVIMetadataLoader;
typedef struct _AVIMetadataLoaderClass AVIMetadataLoaderClass;
#define _avi_metadata_loader_unref0(var) ((var == NULL) ? NULL : (var = (avi_metadata_loader_unref (var), NULL)))
typedef struct _QuickTimeMetadataLoaderPrivate QuickTimeMetadataLoaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_QUICK_TIME_ATOM (quick_time_atom_get_type ())
#define QUICK_TIME_ATOM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUICK_TIME_ATOM, QuickTimeAtom))
#define QUICK_TIME_ATOM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUICK_TIME_ATOM, QuickTimeAtomClass))
#define IS_QUICK_TIME_ATOM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUICK_TIME_ATOM))
#define IS_QUICK_TIME_ATOM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUICK_TIME_ATOM))
#define QUICK_TIME_ATOM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUICK_TIME_ATOM, QuickTimeAtomClass))

typedef struct _QuickTimeAtom QuickTimeAtom;
typedef struct _QuickTimeAtomClass QuickTimeAtomClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _quick_time_atom_unref0(var) ((var == NULL) ? NULL : (var = (quick_time_atom_unref (var), NULL)))
typedef struct _ParamSpecQuickTimeMetadataLoader ParamSpecQuickTimeMetadataLoader;
typedef struct _QuickTimeAtomPrivate QuickTimeAtomPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecQuickTimeAtom ParamSpecQuickTimeAtom;
typedef struct _AVIMetadataLoaderPrivate AVIMetadataLoaderPrivate;

#define TYPE_AVI_CHUNK (avi_chunk_get_type ())
#define AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVI_CHUNK, AVIChunk))
#define AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVI_CHUNK, AVIChunkClass))
#define IS_AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVI_CHUNK))
#define IS_AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVI_CHUNK))
#define AVI_CHUNK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVI_CHUNK, AVIChunkClass))

typedef struct _AVIChunk AVIChunk;
typedef struct _AVIChunkClass AVIChunkClass;
#define _avi_chunk_unref0(var) ((var == NULL) ? NULL : (var = (avi_chunk_unref (var), NULL)))
typedef struct _ParamSpecAVIMetadataLoader ParamSpecAVIMetadataLoader;
typedef struct _AVIChunkPrivate AVIChunkPrivate;
typedef struct _ParamSpecAVIChunk ParamSpecAVIChunk;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MediaMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MediaMetadataPrivate * priv;
};

struct _MediaMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (MediaMetadata *self);
	void (*read_from_file) (MediaMetadata* self, GFile* file, GError** error);
	MetadataDateTime* (*get_creation_date_time) (MediaMetadata* self);
	gchar* (*get_title) (MediaMetadata* self);
	gchar* (*get_comment) (MediaMetadata* self);
};

struct _VideoMetadata {
	MediaMetadata parent_instance;
	VideoMetadataPrivate * priv;
};

struct _VideoMetadataClass {
	MediaMetadataClass parent_class;
};

struct _VideoMetadataPrivate {
	MetadataDateTime* timestamp;
	gchar* title;
	gchar* comment;
};

struct _QuickTimeMetadataLoader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	QuickTimeMetadataLoaderPrivate * priv;
};

struct _QuickTimeMetadataLoaderClass {
	GTypeClass parent_class;
	void (*finalize) (QuickTimeMetadataLoader *self);
};

struct _QuickTimeMetadataLoaderPrivate {
	GFile* file;
};

struct _ParamSpecQuickTimeMetadataLoader {
	GParamSpec parent_instance;
};

struct _QuickTimeAtom {
	GTypeInstance parent_instance;
	volatile int ref_count;
	QuickTimeAtomPrivate * priv;
};

struct _QuickTimeAtomClass {
	GTypeClass parent_class;
	void (*finalize) (QuickTimeAtom *self);
};

struct _QuickTimeAtomPrivate {
	GFile* file;
	gchar* section_name;
	guint64 section_size;
	guint64 section_offset;
	GDataInputStream* input;
	QuickTimeAtom* parent;
};

struct _ParamSpecQuickTimeAtom {
	GParamSpec parent_instance;
};

struct _AVIMetadataLoader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AVIMetadataLoaderPrivate * priv;
};

struct _AVIMetadataLoaderClass {
	GTypeClass parent_class;
	void (*finalize) (AVIMetadataLoader *self);
};

struct _AVIMetadataLoaderPrivate {
	GFile* file;
};

struct _ParamSpecAVIMetadataLoader {
	GParamSpec parent_instance;
};

struct _AVIChunk {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AVIChunkPrivate * priv;
};

struct _AVIChunkClass {
	GTypeClass parent_class;
	void (*finalize) (AVIChunk *self);
};

struct _AVIChunkPrivate {
	GFile* file;
	gchar* section_name;
	guint64 section_size;
	guint64 section_offset;
	GDataInputStream* input;
	AVIChunk* parent;
};

struct _ParamSpecAVIChunk {
	GParamSpec parent_instance;
};


static gpointer video_metadata_parent_class = NULL;
static gpointer quick_time_metadata_loader_parent_class = NULL;
static gpointer quick_time_atom_parent_class = NULL;
static gpointer avi_metadata_loader_parent_class = NULL;
static gpointer avi_chunk_parent_class = NULL;

gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
GType video_metadata_get_type (void) G_GNUC_CONST;
#define VIDEO_METADATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_METADATA, VideoMetadataPrivate))
enum  {
	VIDEO_METADATA_DUMMY_PROPERTY
};
VideoMetadata* video_metadata_new (void);
VideoMetadata* video_metadata_construct (GType object_type);
MediaMetadata* media_metadata_construct (GType object_type);
static void video_metadata_real_read_from_file (MediaMetadata* base, GFile* file, GError** error);
gpointer quick_time_metadata_loader_ref (gpointer instance);
void quick_time_metadata_loader_unref (gpointer instance);
GParamSpec* param_spec_quick_time_metadata_loader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_quick_time_metadata_loader (GValue* value, gpointer v_object);
void value_take_quick_time_metadata_loader (GValue* value, gpointer v_object);
gpointer value_get_quick_time_metadata_loader (const GValue* value);
GType quick_time_metadata_loader_get_type (void) G_GNUC_CONST;
QuickTimeMetadataLoader* quick_time_metadata_loader_new (GFile* file);
QuickTimeMetadataLoader* quick_time_metadata_loader_construct (GType object_type, GFile* file);
gboolean quick_time_metadata_loader_is_supported (QuickTimeMetadataLoader* self);
MetadataDateTime* quick_time_metadata_loader_get_creation_date_time (QuickTimeMetadataLoader* self);
gchar* quick_time_metadata_loader_get_title (QuickTimeMetadataLoader* self);
gpointer avi_metadata_loader_ref (gpointer instance);
void avi_metadata_loader_unref (gpointer instance);
GParamSpec* param_spec_avi_metadata_loader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_avi_metadata_loader (GValue* value, gpointer v_object);
void value_take_avi_metadata_loader (GValue* value, gpointer v_object);
gpointer value_get_avi_metadata_loader (const GValue* value);
GType avi_metadata_loader_get_type (void) G_GNUC_CONST;
AVIMetadataLoader* avi_metadata_loader_new (GFile* file);
AVIMetadataLoader* avi_metadata_loader_construct (GType object_type, GFile* file);
gboolean avi_metadata_loader_is_supported (AVIMetadataLoader* self);
MetadataDateTime* avi_metadata_loader_get_creation_date_time (AVIMetadataLoader* self);
gchar* avi_metadata_loader_get_title (AVIMetadataLoader* self);
static MetadataDateTime* video_metadata_real_get_creation_date_time (MediaMetadata* base);
static gchar* video_metadata_real_get_title (MediaMetadata* base);
static gchar* video_metadata_real_get_comment (MediaMetadata* base);
static void video_metadata_finalize (MediaMetadata * obj);
#define QUICK_TIME_METADATA_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoaderPrivate))
enum  {
	QUICK_TIME_METADATA_LOADER_DUMMY_PROPERTY
};
#define QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT ((time_t) 2082844800)
static gulong quick_time_metadata_loader_get_creation_date_time_for_quicktime (QuickTimeMetadataLoader* self);
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type, time_t timestamp);
gpointer quick_time_atom_ref (gpointer instance);
void quick_time_atom_unref (gpointer instance);
GParamSpec* param_spec_quick_time_atom (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_quick_time_atom (GValue* value, gpointer v_object);
void value_take_quick_time_atom (GValue* value, gpointer v_object);
gpointer value_get_quick_time_atom (const GValue* value);
GType quick_time_atom_get_type (void) G_GNUC_CONST;
QuickTimeAtom* quick_time_atom_new (GFile* file);
QuickTimeAtom* quick_time_atom_construct (GType object_type, GFile* file);
void quick_time_atom_open_file (QuickTimeAtom* self, GError** error);
void quick_time_atom_read_atom (QuickTimeAtom* self, GError** error);
gchar* quick_time_atom_get_current_atom_name (QuickTimeAtom* self);
void quick_time_atom_next_atom (QuickTimeAtom* self, GError** error);
gboolean quick_time_atom_is_last_atom (QuickTimeAtom* self);
void quick_time_atom_close_file (QuickTimeAtom* self, GError** error);
QuickTimeAtom* quick_time_atom_get_first_child_atom (QuickTimeAtom* self);
guint64 quick_time_atom_section_size_remaining (QuickTimeAtom* self);
guint32 quick_time_atom_read_uint32 (QuickTimeAtom* self, GError** error);
static void quick_time_metadata_loader_finalize (QuickTimeMetadataLoader * obj);
#define QUICK_TIME_ATOM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_QUICK_TIME_ATOM, QuickTimeAtomPrivate))
enum  {
	QUICK_TIME_ATOM_DUMMY_PROPERTY
};
static QuickTimeAtom* quick_time_atom_new_with_input_stream (GDataInputStream* input, QuickTimeAtom* parent);
static QuickTimeAtom* quick_time_atom_construct_with_input_stream (GType object_type, GDataInputStream* input, QuickTimeAtom* parent);
static void quick_time_atom_advance_section_offset (QuickTimeAtom* self, guint64 amount);
guchar quick_time_atom_read_byte (QuickTimeAtom* self, GError** error);
guint64 quick_time_atom_read_uint64 (QuickTimeAtom* self, GError** error);
static void quick_time_atom_skip (QuickTimeAtom* self, guint64 skip_amount, GError** error);
void skip_uint64 (GInputStream* input, guint64 skip_amount, GError** error);
static void quick_time_atom_finalize (QuickTimeAtom * obj);
#define AVI_METADATA_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVI_METADATA_LOADER, AVIMetadataLoaderPrivate))
enum  {
	AVI_METADATA_LOADER_DUMMY_PROPERTY
};
#define AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH 19
#define AVI_METADATA_LOADER_NIKON_NCTG_TIMESTAMP_MARKER ((guint16) 0x13)
#define AVI_METADATA_LOADER_MAX_STRD_LENGTH 100
static gulong avi_metadata_loader_get_creation_date_time_for_avi (AVIMetadataLoader* self);
gpointer avi_chunk_ref (gpointer instance);
void avi_chunk_unref (gpointer instance);
GParamSpec* param_spec_avi_chunk (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_avi_chunk (GValue* value, gpointer v_object);
void value_take_avi_chunk (GValue* value, gpointer v_object);
gpointer value_get_avi_chunk (const GValue* value);
GType avi_chunk_get_type (void) G_GNUC_CONST;
AVIChunk* avi_chunk_new (GFile* file);
AVIChunk* avi_chunk_construct (GType object_type, GFile* file);
void avi_chunk_open_file (AVIChunk* self, GError** error);
void avi_chunk_read_chunk (AVIChunk* self, GError** error);
gchar* avi_chunk_get_current_chunk_name (AVIChunk* self);
gchar* avi_chunk_read_name (AVIChunk* self, GError** error);
void avi_chunk_close_file (AVIChunk* self, GError** error);
static gchar* avi_metadata_loader_read_nikon_nctg_tag (AVIMetadataLoader* self, AVIChunk* chunk, GError** error);
guint64 avi_chunk_section_size_remaining (AVIChunk* self);
guint16 avi_chunk_read_uint16 (AVIChunk* self, GError** error);
void avi_chunk_skip (AVIChunk* self, guint64 skip_amount, GError** error);
guchar avi_chunk_read_byte (AVIChunk* self, GError** error);
static gchar* avi_metadata_loader_read_fuji_strd_tag (AVIMetadataLoader* self, AVIChunk* chunk, GError** error);
static gchar* avi_metadata_loader_read_section (AVIMetadataLoader* self, AVIChunk* chunk, GError** error);
gchar* avi_chunk_section_to_string (AVIChunk* self, GError** error);
AVIChunk* avi_chunk_get_first_child_chunk (AVIChunk* self);
gboolean avi_chunk_is_last_chunk (AVIChunk* self);
void avi_chunk_next_chunk (AVIChunk* self, GError** error);
static gulong avi_metadata_loader_parse_date (AVIMetadataLoader* self, const gchar* sdate);
static GDateMonth avi_metadata_loader_month_from_string (AVIMetadataLoader* self, const gchar* s);
void avi_chunk_nonsection_skip (AVIChunk* self, guint64 skip_amount, GError** error);
static void avi_metadata_loader_finalize (AVIMetadataLoader * obj);
#define AVI_CHUNK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVI_CHUNK, AVIChunkPrivate))
enum  {
	AVI_CHUNK_DUMMY_PROPERTY
};
#define AVI_CHUNK_MAX_STRING_TO_SECTION_LENGTH 1024
static AVIChunk* avi_chunk_new_with_input_stream (GDataInputStream* input, AVIChunk* parent);
static AVIChunk* avi_chunk_construct_with_input_stream (GType object_type, GDataInputStream* input, AVIChunk* parent);
static void avi_chunk_advance_section_offset (AVIChunk* self, guint64 amount);
static void avi_chunk_finalize (AVIChunk * obj);


VideoMetadata* video_metadata_construct (GType object_type) {
	VideoMetadata* self = NULL;
#line 13 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (VideoMetadata*) media_metadata_construct (object_type);
#line 13 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 381 "VideoMetadata.c"
}


VideoMetadata* video_metadata_new (void) {
#line 13 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return video_metadata_construct (TYPE_VIDEO_METADATA);
#line 388 "VideoMetadata.c"
}


static void video_metadata_real_read_from_file (MediaMetadata* base, GFile* file, GError** error) {
	VideoMetadata * self;
	QuickTimeMetadataLoader* quicktime = NULL;
	GFile* _tmp0_;
	QuickTimeMetadataLoader* _tmp1_;
	QuickTimeMetadataLoader* _tmp2_;
	gboolean _tmp3_;
	AVIMetadataLoader* avi = NULL;
	GFile* _tmp8_;
	AVIMetadataLoader* _tmp9_;
	AVIMetadataLoader* _tmp10_;
	gboolean _tmp11_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	GError * _inner_error_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
#line 19 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 20 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = file;
#line 20 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quick_time_metadata_loader_new (_tmp0_);
#line 20 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quicktime = _tmp1_;
#line 21 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = quicktime;
#line 21 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = quick_time_metadata_loader_is_supported (_tmp2_);
#line 21 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp3_) {
#line 426 "VideoMetadata.c"
		QuickTimeMetadataLoader* _tmp4_;
		MetadataDateTime* _tmp5_;
		QuickTimeMetadataLoader* _tmp6_;
		gchar* _tmp7_;
#line 22 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = quicktime;
#line 22 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = quick_time_metadata_loader_get_creation_date_time (_tmp4_);
#line 22 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_metadata_date_time_unref0 (self->priv->timestamp);
#line 22 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->timestamp = _tmp5_;
#line 23 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = quicktime;
#line 23 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = quick_time_metadata_loader_get_title (_tmp6_);
#line 23 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (self->priv->title);
#line 23 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->title = _tmp7_;
#line 25 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (self->priv->comment);
#line 25 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->comment = NULL;
#line 26 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_metadata_loader_unref0 (quicktime);
#line 26 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 455 "VideoMetadata.c"
	}
#line 28 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp8_ = file;
#line 28 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp9_ = avi_metadata_loader_new (_tmp8_);
#line 28 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi = _tmp9_;
#line 29 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp10_ = avi;
#line 29 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = avi_metadata_loader_is_supported (_tmp10_);
#line 29 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp11_) {
#line 469 "VideoMetadata.c"
		AVIMetadataLoader* _tmp12_;
		MetadataDateTime* _tmp13_;
		AVIMetadataLoader* _tmp14_;
		gchar* _tmp15_;
#line 30 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp12_ = avi;
#line 30 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = avi_metadata_loader_get_creation_date_time (_tmp12_);
#line 30 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_metadata_date_time_unref0 (self->priv->timestamp);
#line 30 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->timestamp = _tmp13_;
#line 31 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp14_ = avi;
#line 31 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp15_ = avi_metadata_loader_get_title (_tmp14_);
#line 31 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (self->priv->title);
#line 31 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->title = _tmp15_;
#line 32 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (self->priv->comment);
#line 32 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->comment = NULL;
#line 33 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_metadata_loader_unref0 (avi);
#line 33 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_metadata_loader_unref0 (quicktime);
#line 33 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 500 "VideoMetadata.c"
	}
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp16_ = file;
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp17_ = g_file_get_path (_tmp16_);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp18_ = _tmp17_;
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp19_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "File %s is not a supported video format", _tmp18_);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp20_ = _tmp19_;
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (_tmp18_);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_inner_error_ = _tmp20_;
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_propagate_error (error, _inner_error_);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_metadata_loader_unref0 (avi);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_metadata_loader_unref0 (quicktime);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return;
#line 524 "VideoMetadata.c"
}


static gpointer _metadata_date_time_ref0 (gpointer self) {
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self ? metadata_date_time_ref (self) : NULL;
#line 531 "VideoMetadata.c"
}


static MetadataDateTime* video_metadata_real_get_creation_date_time (MediaMetadata* base) {
	VideoMetadata * self;
	MetadataDateTime* result = NULL;
	MetadataDateTime* _tmp0_;
	MetadataDateTime* _tmp1_;
#line 39 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->timestamp;
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _metadata_date_time_ref0 (_tmp0_);
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 550 "VideoMetadata.c"
}


static gchar* video_metadata_real_get_title (MediaMetadata* base) {
	VideoMetadata * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 43 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
#line 44 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->title;
#line 44 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 44 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 569 "VideoMetadata.c"
}


static gchar* video_metadata_real_get_comment (MediaMetadata* base) {
	VideoMetadata * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 47 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
#line 48 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->comment;
#line 48 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 48 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 588 "VideoMetadata.c"
}


static void video_metadata_class_init (VideoMetadataClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	video_metadata_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->finalize = video_metadata_finalize;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (VideoMetadataPrivate));
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->read_from_file = (void (*) (MediaMetadata *, GFile*, GError**)) video_metadata_real_read_from_file;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->get_creation_date_time = (MetadataDateTime* (*) (MediaMetadata *)) video_metadata_real_get_creation_date_time;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->get_title = (gchar* (*) (MediaMetadata *)) video_metadata_real_get_title;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->get_comment = (gchar* (*) (MediaMetadata *)) video_metadata_real_get_comment;
#line 607 "VideoMetadata.c"
}


static void video_metadata_instance_init (VideoMetadata * self) {
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = VIDEO_METADATA_GET_PRIVATE (self);
#line 9 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->timestamp = NULL;
#line 10 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->title = NULL;
#line 11 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->comment = NULL;
#line 620 "VideoMetadata.c"
}


static void video_metadata_finalize (MediaMetadata * obj) {
	VideoMetadata * self;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_METADATA, VideoMetadata);
#line 9 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_metadata_date_time_unref0 (self->priv->timestamp);
#line 10 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->title);
#line 11 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->comment);
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	MEDIA_METADATA_CLASS (video_metadata_parent_class)->finalize (obj);
#line 636 "VideoMetadata.c"
}


GType video_metadata_get_type (void) {
	static volatile gsize video_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&video_metadata_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMetadata), 0, (GInstanceInitFunc) video_metadata_instance_init, NULL };
		GType video_metadata_type_id;
		video_metadata_type_id = g_type_register_static (TYPE_MEDIA_METADATA, "VideoMetadata", &g_define_type_info, 0);
		g_once_init_leave (&video_metadata_type_id__volatile, video_metadata_type_id);
	}
	return video_metadata_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self ? g_object_ref (self) : NULL;
#line 655 "VideoMetadata.c"
}


QuickTimeMetadataLoader* quick_time_metadata_loader_construct (GType object_type, GFile* file) {
	QuickTimeMetadataLoader* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 61 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 61 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (QuickTimeMetadataLoader*) g_type_create_instance (object_type);
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = file;
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = _tmp1_;
#line 61 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 677 "VideoMetadata.c"
}


QuickTimeMetadataLoader* quick_time_metadata_loader_new (GFile* file) {
#line 61 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return quick_time_metadata_loader_construct (TYPE_QUICK_TIME_METADATA_LOADER, file);
#line 684 "VideoMetadata.c"
}


MetadataDateTime* quick_time_metadata_loader_get_creation_date_time (QuickTimeMetadataLoader* self) {
	MetadataDateTime* result = NULL;
	gulong _tmp0_;
	MetadataDateTime* _tmp1_;
#line 65 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_METADATA_LOADER (self), NULL);
#line 66 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = quick_time_metadata_loader_get_creation_date_time_for_quicktime (self);
#line 66 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = metadata_date_time_new ((time_t) _tmp0_);
#line 66 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 66 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 702 "VideoMetadata.c"
}


gchar* quick_time_metadata_loader_get_title (QuickTimeMetadataLoader* self) {
	gchar* result = NULL;
#line 69 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_METADATA_LOADER (self), NULL);
#line 71 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = NULL;
#line 71 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 714 "VideoMetadata.c"
}


gboolean quick_time_metadata_loader_is_supported (QuickTimeMetadataLoader* self) {
	gboolean result = FALSE;
	QuickTimeAtom* test = NULL;
	GFile* _tmp0_;
	QuickTimeAtom* _tmp1_;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_METADATA_LOADER (self), FALSE);
#line 76 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->file;
#line 76 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quick_time_atom_new (_tmp0_);
#line 76 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	test = _tmp1_;
#line 78 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	ret = FALSE;
#line 735 "VideoMetadata.c"
	{
		QuickTimeAtom* _tmp2_;
		QuickTimeAtom* _tmp3_;
		QuickTimeAtom* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
#line 80 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = test;
#line 80 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_open_file (_tmp2_, &_inner_error_);
#line 80 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 749 "VideoMetadata.c"
			goto __catch577_g_error;
		}
#line 81 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = test;
#line 81 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_read_atom (_tmp3_, &_inner_error_);
#line 81 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 758 "VideoMetadata.c"
			goto __catch577_g_error;
		}
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = test;
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = quick_time_atom_get_current_atom_name (_tmp4_);
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = _tmp5_;
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = g_strcmp0 ("ftyp", _tmp6_) == 0;
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp6_);
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp7_) {
#line 85 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			ret = TRUE;
#line 775 "VideoMetadata.c"
		} else {
#line 90 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			while (TRUE) {
#line 779 "VideoMetadata.c"
				QuickTimeAtom* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				QuickTimeAtom* _tmp12_;
				QuickTimeAtom* _tmp13_;
				QuickTimeAtom* _tmp14_;
				gboolean _tmp15_;
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp8_ = test;
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp9_ = quick_time_atom_get_current_atom_name (_tmp8_);
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp10_ = _tmp9_;
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp11_ = g_strcmp0 ("moov", _tmp10_) == 0;
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (_tmp10_);
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (_tmp11_) {
#line 92 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					ret = TRUE;
#line 93 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					break;
#line 804 "VideoMetadata.c"
				}
#line 95 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp12_ = test;
#line 95 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				quick_time_atom_next_atom (_tmp12_, &_inner_error_);
#line 95 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 812 "VideoMetadata.c"
					goto __catch577_g_error;
				}
#line 96 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp13_ = test;
#line 96 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				quick_time_atom_read_atom (_tmp13_, &_inner_error_);
#line 96 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 821 "VideoMetadata.c"
					goto __catch577_g_error;
				}
#line 97 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp14_ = test;
#line 97 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp15_ = quick_time_atom_is_last_atom (_tmp14_);
#line 97 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (_tmp15_) {
#line 98 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					break;
#line 832 "VideoMetadata.c"
				}
			}
		}
	}
	goto __finally577;
	__catch577_g_error:
	{
		GError* e = NULL;
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp16_ = self->priv->file;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp17_ = g_file_get_path (_tmp16_);
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp18_ = _tmp17_;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp19_ = e;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp20_ = _tmp19_->message;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:103: Error while testing for QuickTime file for %s:" \
" %s", _tmp18_, _tmp20_);
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp18_);
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 866 "VideoMetadata.c"
	}
	__finally577:
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 871 "VideoMetadata.c"
		gboolean _tmp21_ = FALSE;
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_atom_unref0 (test);
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp21_;
#line 881 "VideoMetadata.c"
	}
	{
		QuickTimeAtom* _tmp22_;
#line 107 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp22_ = test;
#line 107 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_close_file (_tmp22_, &_inner_error_);
#line 107 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 891 "VideoMetadata.c"
			goto __catch578_g_error;
		}
	}
	goto __finally578;
	__catch578_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 109 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp23_ = e;
#line 109 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp24_ = _tmp23_->message;
#line 109 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:109: Error while closing Quicktime file: %s", _tmp24_);
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 913 "VideoMetadata.c"
	}
	__finally578:
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 918 "VideoMetadata.c"
		gboolean _tmp25_ = FALSE;
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_atom_unref0 (test);
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp25_;
#line 928 "VideoMetadata.c"
	}
#line 111 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = ret;
#line 111 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_atom_unref0 (test);
#line 111 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 936 "VideoMetadata.c"
}


static gulong quick_time_metadata_loader_get_creation_date_time_for_quicktime (QuickTimeMetadataLoader* self) {
	gulong result = 0UL;
	QuickTimeAtom* test = NULL;
	GFile* _tmp0_;
	QuickTimeAtom* _tmp1_;
	time_t timestamp = 0;
	time_t _tmp37_;
	time_t _tmp39_;
	GError * _inner_error_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_METADATA_LOADER (self), 0UL);
#line 115 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->file;
#line 115 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quick_time_atom_new (_tmp0_);
#line 115 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	test = _tmp1_;
#line 116 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	timestamp = (time_t) 0;
#line 959 "VideoMetadata.c"
	{
		QuickTimeAtom* _tmp2_;
		gboolean done = FALSE;
#line 119 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = test;
#line 119 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_open_file (_tmp2_, &_inner_error_);
#line 119 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 969 "VideoMetadata.c"
			goto __catch579_g_error;
		}
#line 120 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		done = FALSE;
#line 121 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		while (TRUE) {
#line 976 "VideoMetadata.c"
			gboolean _tmp3_;
			QuickTimeAtom* _tmp4_;
			QuickTimeAtom* _tmp5_;
			gboolean _tmp6_;
			QuickTimeAtom* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			QuickTimeAtom* _tmp29_;
#line 121 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp3_ = done;
#line 121 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (!(!_tmp3_)) {
#line 121 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				break;
#line 992 "VideoMetadata.c"
			}
#line 123 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = test;
#line 123 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			quick_time_atom_read_atom (_tmp4_, &_inner_error_);
#line 123 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1000 "VideoMetadata.c"
				goto __catch579_g_error;
			}
#line 124 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp5_ = test;
#line 124 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp6_ = quick_time_atom_is_last_atom (_tmp5_);
#line 124 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (_tmp6_) {
#line 124 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				break;
#line 1011 "VideoMetadata.c"
			}
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp7_ = test;
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp8_ = quick_time_atom_get_current_atom_name (_tmp7_);
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp9_ = _tmp8_;
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp10_ = g_strcmp0 ("moov", _tmp9_) == 0;
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp9_);
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (_tmp10_) {
#line 1025 "VideoMetadata.c"
				QuickTimeAtom* child = NULL;
				QuickTimeAtom* _tmp11_;
				QuickTimeAtom* _tmp12_;
#line 126 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp11_ = test;
#line 126 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp12_ = quick_time_atom_get_first_child_atom (_tmp11_);
#line 126 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				child = _tmp12_;
#line 127 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				while (TRUE) {
#line 1037 "VideoMetadata.c"
					gboolean _tmp13_;
					QuickTimeAtom* _tmp14_;
					gboolean _tmp15_ = FALSE;
					QuickTimeAtom* _tmp16_;
					gboolean _tmp17_;
					QuickTimeAtom* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gboolean _tmp23_;
					QuickTimeAtom* _tmp28_;
#line 127 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp13_ = done;
#line 127 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (!(!_tmp13_)) {
#line 127 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						break;
#line 1054 "VideoMetadata.c"
					}
#line 129 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp14_ = child;
#line 129 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					quick_time_atom_read_atom (_tmp14_, &_inner_error_);
#line 129 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 129 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_quick_time_atom_unref0 (child);
#line 1064 "VideoMetadata.c"
						goto __catch579_g_error;
					}
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp16_ = child;
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp17_ = quick_time_atom_is_last_atom (_tmp16_);
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (_tmp17_) {
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp15_ = TRUE;
#line 1075 "VideoMetadata.c"
					} else {
						QuickTimeAtom* _tmp18_;
						guint64 _tmp19_;
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp18_ = child;
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp19_ = quick_time_atom_section_size_remaining (_tmp18_);
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp15_ = ((guint64) 0) == _tmp19_;
#line 1085 "VideoMetadata.c"
					}
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (_tmp15_) {
#line 131 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						done = TRUE;
#line 132 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						break;
#line 1093 "VideoMetadata.c"
					}
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp20_ = child;
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp21_ = quick_time_atom_get_current_atom_name (_tmp20_);
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp22_ = _tmp21_;
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp23_ = g_strcmp0 ("mvhd", _tmp22_) == 0;
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (_tmp22_);
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (_tmp23_) {
#line 1107 "VideoMetadata.c"
						QuickTimeAtom* _tmp24_;
						guint32 _tmp25_ = 0U;
						QuickTimeAtom* _tmp26_;
						guint32 _tmp27_;
#line 137 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp24_ = child;
#line 137 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						quick_time_atom_read_uint32 (_tmp24_, &_inner_error_);
#line 137 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 137 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
							_quick_time_atom_unref0 (child);
#line 1120 "VideoMetadata.c"
							goto __catch579_g_error;
						}
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp26_ = child;
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp27_ = quick_time_atom_read_uint32 (_tmp26_, &_inner_error_);
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp25_ = _tmp27_;
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
							_quick_time_atom_unref0 (child);
#line 1133 "VideoMetadata.c"
							goto __catch579_g_error;
						}
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						timestamp = _tmp25_ - QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT;
#line 140 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						done = TRUE;
#line 141 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						break;
#line 1142 "VideoMetadata.c"
					}
#line 143 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp28_ = child;
#line 143 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					quick_time_atom_next_atom (_tmp28_, &_inner_error_);
#line 143 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_quick_time_atom_unref0 (child);
#line 1152 "VideoMetadata.c"
						goto __catch579_g_error;
					}
				}
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_quick_time_atom_unref0 (child);
#line 1158 "VideoMetadata.c"
			}
#line 146 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp29_ = test;
#line 146 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			quick_time_atom_next_atom (_tmp29_, &_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1166 "VideoMetadata.c"
				goto __catch579_g_error;
			}
		}
	}
	goto __finally579;
	__catch579_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp30_ = e;
#line 149 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp31_ = _tmp30_->message;
#line 149 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:149: Error while testing for QuickTime file: %s", _tmp31_);
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 1189 "VideoMetadata.c"
	}
	__finally579:
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1194 "VideoMetadata.c"
		gulong _tmp32_ = 0UL;
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_atom_unref0 (test);
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp32_;
#line 1204 "VideoMetadata.c"
	}
	{
		QuickTimeAtom* _tmp33_;
#line 153 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp33_ = test;
#line 153 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_close_file (_tmp33_, &_inner_error_);
#line 153 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1214 "VideoMetadata.c"
			goto __catch580_g_error;
		}
	}
	goto __finally580;
	__catch580_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 155 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp34_ = e;
#line 155 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp35_ = _tmp34_->message;
#line 155 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:155: Error while closing Quicktime file: %s", _tmp35_);
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 1236 "VideoMetadata.c"
	}
	__finally580:
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1241 "VideoMetadata.c"
		gulong _tmp36_ = 0UL;
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_atom_unref0 (test);
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp36_;
#line 1251 "VideoMetadata.c"
	}
#line 166 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp37_ = timestamp;
#line 166 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp37_ < ((time_t) 0)) {
#line 1257 "VideoMetadata.c"
		time_t _tmp38_;
#line 167 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp38_ = timestamp;
#line 167 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		timestamp = _tmp38_ + QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT;
#line 1263 "VideoMetadata.c"
	}
#line 169 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp39_ = timestamp;
#line 169 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = (gulong) _tmp39_;
#line 169 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_atom_unref0 (test);
#line 169 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1273 "VideoMetadata.c"
}


static void value_quick_time_metadata_loader_init (GValue* value) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 1280 "VideoMetadata.c"
}


static void value_quick_time_metadata_loader_free_value (GValue* value) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_metadata_loader_unref (value->data[0].v_pointer);
#line 1289 "VideoMetadata.c"
	}
}


static void value_quick_time_metadata_loader_copy_value (const GValue* src_value, GValue* dest_value) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = quick_time_metadata_loader_ref (src_value->data[0].v_pointer);
#line 1299 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1303 "VideoMetadata.c"
	}
}


static gpointer value_quick_time_metadata_loader_peek_pointer (const GValue* value) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 1311 "VideoMetadata.c"
}


static gchar* value_quick_time_metadata_loader_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 1318 "VideoMetadata.c"
		QuickTimeMetadataLoader * object;
		object = collect_values[0].v_pointer;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1325 "VideoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1329 "VideoMetadata.c"
		}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = quick_time_metadata_loader_ref (object);
#line 1333 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1337 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 1341 "VideoMetadata.c"
}


static gchar* value_quick_time_metadata_loader_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	QuickTimeMetadataLoader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!object_p) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1352 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = NULL;
#line 1358 "VideoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 1362 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = quick_time_metadata_loader_ref (value->data[0].v_pointer);
#line 1366 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 1370 "VideoMetadata.c"
}


GParamSpec* param_spec_quick_time_metadata_loader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecQuickTimeMetadataLoader* spec;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_QUICK_TIME_METADATA_LOADER), NULL);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 1384 "VideoMetadata.c"
}


gpointer value_get_quick_time_metadata_loader (const GValue* value) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER), NULL);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 1393 "VideoMetadata.c"
}


void value_set_quick_time_metadata_loader (GValue* value, gpointer v_object) {
	QuickTimeMetadataLoader * old;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_METADATA_LOADER));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_metadata_loader_ref (value->data[0].v_pointer);
#line 1413 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1417 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_metadata_loader_unref (old);
#line 1423 "VideoMetadata.c"
	}
}


void value_take_quick_time_metadata_loader (GValue* value, gpointer v_object) {
	QuickTimeMetadataLoader * old;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_METADATA_LOADER));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 1442 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1446 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_metadata_loader_unref (old);
#line 1452 "VideoMetadata.c"
	}
}


static void quick_time_metadata_loader_class_init (QuickTimeMetadataLoaderClass * klass) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_metadata_loader_parent_class = g_type_class_peek_parent (klass);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((QuickTimeMetadataLoaderClass *) klass)->finalize = quick_time_metadata_loader_finalize;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (QuickTimeMetadataLoaderPrivate));
#line 1464 "VideoMetadata.c"
}


static void quick_time_metadata_loader_instance_init (QuickTimeMetadataLoader * self) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = QUICK_TIME_METADATA_LOADER_GET_PRIVATE (self);
#line 59 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = NULL;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->ref_count = 1;
#line 1475 "VideoMetadata.c"
}


static void quick_time_metadata_loader_finalize (QuickTimeMetadataLoader * obj) {
	QuickTimeMetadataLoader * self;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoader);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 59 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 1487 "VideoMetadata.c"
}


GType quick_time_metadata_loader_get_type (void) {
	static volatile gsize quick_time_metadata_loader_type_id__volatile = 0;
	if (g_once_init_enter (&quick_time_metadata_loader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_quick_time_metadata_loader_init, value_quick_time_metadata_loader_free_value, value_quick_time_metadata_loader_copy_value, value_quick_time_metadata_loader_peek_pointer, "p", value_quick_time_metadata_loader_collect_value, "p", value_quick_time_metadata_loader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (QuickTimeMetadataLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_time_metadata_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickTimeMetadataLoader), 0, (GInstanceInitFunc) quick_time_metadata_loader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType quick_time_metadata_loader_type_id;
		quick_time_metadata_loader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QuickTimeMetadataLoader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&quick_time_metadata_loader_type_id__volatile, quick_time_metadata_loader_type_id);
	}
	return quick_time_metadata_loader_type_id__volatile;
}


gpointer quick_time_metadata_loader_ref (gpointer instance) {
	QuickTimeMetadataLoader * self;
	self = instance;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return instance;
#line 1512 "VideoMetadata.c"
}


void quick_time_metadata_loader_unref (gpointer instance) {
	QuickTimeMetadataLoader * self;
	self = instance;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		QUICK_TIME_METADATA_LOADER_GET_CLASS (self)->finalize (self);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1525 "VideoMetadata.c"
	}
}


QuickTimeAtom* quick_time_atom_construct (GType object_type, GFile* file) {
	QuickTimeAtom* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 181 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 181 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (QuickTimeAtom*) g_type_create_instance (object_type);
#line 182 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = file;
#line 182 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 182 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 182 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = _tmp1_;
#line 181 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 1548 "VideoMetadata.c"
}


QuickTimeAtom* quick_time_atom_new (GFile* file) {
#line 181 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return quick_time_atom_construct (TYPE_QUICK_TIME_ATOM, file);
#line 1555 "VideoMetadata.c"
}


static gpointer _quick_time_atom_ref0 (gpointer self) {
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self ? quick_time_atom_ref (self) : NULL;
#line 1562 "VideoMetadata.c"
}


static QuickTimeAtom* quick_time_atom_construct_with_input_stream (GType object_type, GDataInputStream* input, QuickTimeAtom* parent) {
	QuickTimeAtom* self = NULL;
	GDataInputStream* _tmp0_;
	GDataInputStream* _tmp1_;
	QuickTimeAtom* _tmp2_;
	QuickTimeAtom* _tmp3_;
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_DATA_INPUT_STREAM (input), NULL);
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (parent), NULL);
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (QuickTimeAtom*) g_type_create_instance (object_type);
#line 186 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = input;
#line 186 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 186 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 186 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = _tmp1_;
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = parent;
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = _quick_time_atom_ref0 (_tmp2_);
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_atom_unref0 (self->priv->parent);
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->parent = _tmp3_;
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 1596 "VideoMetadata.c"
}


static QuickTimeAtom* quick_time_atom_new_with_input_stream (GDataInputStream* input, QuickTimeAtom* parent) {
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return quick_time_atom_construct_with_input_stream (TYPE_QUICK_TIME_ATOM, input, parent);
#line 1603 "VideoMetadata.c"
}


void quick_time_atom_open_file (QuickTimeAtom* self, GError** error) {
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 190 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 191 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_close_file (self, &_inner_error_);
#line 191 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 191 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 191 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1625 "VideoMetadata.c"
	}
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->file;
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1639 "VideoMetadata.c"
	}
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = g_data_input_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream));
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = _tmp3_;
#line 193 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = self->priv->input;
#line 193 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_data_input_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN);
#line 194 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 195 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 196 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = g_strdup ("");
#line 196 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 196 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp5_;
#line 190 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (_tmp0_);
#line 1663 "VideoMetadata.c"
}


void quick_time_atom_close_file (QuickTimeAtom* self, GError** error) {
	GDataInputStream* _tmp0_;
	GError * _inner_error_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 200 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 200 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (NULL != _tmp0_) {
#line 1676 "VideoMetadata.c"
		GDataInputStream* _tmp1_;
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = self->priv->input;
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return;
#line 1688 "VideoMetadata.c"
		}
#line 202 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_object_unref0 (self->priv->input);
#line 202 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->input = NULL;
#line 1694 "VideoMetadata.c"
	}
}


static void quick_time_atom_advance_section_offset (QuickTimeAtom* self, guint64 amount) {
	guint64 _tmp0_;
	guint64 _tmp1_;
	QuickTimeAtom* _tmp2_;
#line 206 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 207 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_offset;
#line 207 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = amount;
#line 207 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = _tmp0_ + _tmp1_;
#line 208 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = self->priv->parent;
#line 208 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (NULL != _tmp2_) {
#line 1715 "VideoMetadata.c"
		QuickTimeAtom* _tmp3_;
		guint64 _tmp4_;
#line 209 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = self->priv->parent;
#line 209 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = amount;
#line 209 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_advance_section_offset (_tmp3_, _tmp4_);
#line 1724 "VideoMetadata.c"
	}
}


QuickTimeAtom* quick_time_atom_get_first_child_atom (QuickTimeAtom* self) {
	QuickTimeAtom* result = NULL;
	GDataInputStream* _tmp0_;
	QuickTimeAtom* _tmp1_;
#line 213 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), NULL);
#line 219 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 219 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quick_time_atom_new_with_input_stream (_tmp0_, self);
#line 219 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 219 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1743 "VideoMetadata.c"
}


guchar quick_time_atom_read_byte (QuickTimeAtom* self, GError** error) {
	guchar result = '\0';
	guint8 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	guint8 _tmp2_;
	GError * _inner_error_ = NULL;
#line 222 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), '\0');
#line 223 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_advance_section_offset (self, (guint64) 1);
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1765 "VideoMetadata.c"
		guchar _tmp3_ = '\0';
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp3_;
#line 1771 "VideoMetadata.c"
	}
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = (guchar) _tmp0_;
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1777 "VideoMetadata.c"
}


guint32 quick_time_atom_read_uint32 (QuickTimeAtom* self, GError** error) {
	guint32 result = 0U;
	guint32 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	guint32 _tmp2_;
	GError * _inner_error_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0U);
#line 228 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_advance_section_offset (self, (guint64) 4);
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_data_input_stream_read_uint32 (_tmp1_, NULL, &_inner_error_);
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1799 "VideoMetadata.c"
		guint32 _tmp3_ = 0U;
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp3_;
#line 1805 "VideoMetadata.c"
	}
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_;
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1811 "VideoMetadata.c"
}


guint64 quick_time_atom_read_uint64 (QuickTimeAtom* self, GError** error) {
	guint64 result = 0ULL;
	guint64 _tmp0_ = 0ULL;
	GDataInputStream* _tmp1_;
	guint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 232 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0ULL);
#line 233 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_advance_section_offset (self, (guint64) 8);
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_data_input_stream_read_uint64 (_tmp1_, NULL, &_inner_error_);
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1833 "VideoMetadata.c"
		guint64 _tmp3_ = 0ULL;
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp3_;
#line 1839 "VideoMetadata.c"
	}
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_;
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1845 "VideoMetadata.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1110 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1111 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 1863 "VideoMetadata.c"
}


void quick_time_atom_read_atom (QuickTimeAtom* self, GError** error) {
	guint32 _tmp0_ = 0U;
	guint32 _tmp1_;
	GString* sb = NULL;
	GString* _tmp2_;
	guchar _tmp3_ = '\0';
	guchar _tmp4_;
	GString* _tmp5_;
	guchar _tmp6_ = '\0';
	guchar _tmp7_;
	GString* _tmp8_;
	guchar _tmp9_ = '\0';
	guchar _tmp10_;
	GString* _tmp11_;
	guchar _tmp12_ = '\0';
	guchar _tmp13_;
	GString* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	guint64 _tmp41_;
	GError * _inner_error_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quick_time_atom_read_uint32 (self, &_inner_error_);
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp1_;
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1904 "VideoMetadata.c"
	}
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) _tmp0_;
#line 242 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_string_new ("");
#line 242 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp2_;
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = quick_time_atom_read_byte (self, &_inner_error_);
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = _tmp4_;
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1924 "VideoMetadata.c"
	}
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = sb;
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp5_, (gchar) _tmp3_);
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp7_ = quick_time_atom_read_byte (self, &_inner_error_);
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp6_ = _tmp7_;
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1942 "VideoMetadata.c"
	}
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp8_ = sb;
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp8_, (gchar) _tmp6_);
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp10_ = quick_time_atom_read_byte (self, &_inner_error_);
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp9_ = _tmp10_;
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1960 "VideoMetadata.c"
	}
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = sb;
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp11_, (gchar) _tmp9_);
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp13_ = quick_time_atom_read_byte (self, &_inner_error_);
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = _tmp13_;
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1978 "VideoMetadata.c"
	}
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp14_ = sb;
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp14_, (gchar) _tmp12_);
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp15_ = sb;
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp16_ = _tmp15_->str;
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp17_;
#line 250 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp18_ = self->priv->section_name;
#line 250 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp19_ = strlen (_tmp18_);
#line 250 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp20_ = _tmp19_;
#line 250 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp20_ != 4) {
#line 2002 "VideoMetadata.c"
		GFile* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GError* _tmp24_;
		GError* _tmp25_;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp21_ = self->priv->file;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp22_ = g_file_get_path (_tmp21_);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp23_ = _tmp22_;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp24_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "QuickTime atom name length is invalid for %s", _tmp23_);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp25_ = _tmp24_;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp23_);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = _tmp25_;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2028 "VideoMetadata.c"
	}
	{
		gint i = 0;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		i = 0;
#line 2034 "VideoMetadata.c"
		{
			gboolean _tmp26_ = FALSE;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp26_ = TRUE;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			while (TRUE) {
#line 2041 "VideoMetadata.c"
				gint _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				const gchar* _tmp32_;
				gint _tmp33_;
				gchar _tmp34_;
				gboolean _tmp35_;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (!_tmp26_) {
#line 2052 "VideoMetadata.c"
					gint _tmp27_;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp27_ = i;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					i = _tmp27_ + 1;
#line 2058 "VideoMetadata.c"
				}
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp26_ = FALSE;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp28_ = i;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp29_ = self->priv->section_name;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp30_ = strlen (_tmp29_);
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp31_ = _tmp30_;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (!(_tmp28_ < _tmp31_)) {
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					break;
#line 2074 "VideoMetadata.c"
				}
#line 255 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp32_ = self->priv->section_name;
#line 255 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp33_ = i;
#line 255 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp34_ = string_get (_tmp32_, (glong) _tmp33_);
#line 255 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp35_ = g_ascii_isprint (_tmp34_);
#line 255 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (!_tmp35_) {
#line 2086 "VideoMetadata.c"
					GFile* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					GError* _tmp39_;
					GError* _tmp40_;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp36_ = self->priv->file;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp37_ = g_file_get_path (_tmp36_);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp38_ = _tmp37_;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp39_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Bad QuickTime atom in file %s", _tmp38_);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp40_ = _tmp39_;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (_tmp38_);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_inner_error_ = _tmp40_;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					g_propagate_error (error, _inner_error_);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_string_free0 (sb);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					return;
#line 2112 "VideoMetadata.c"
				}
			}
		}
	}
#line 260 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp41_ = self->priv->section_size;
#line 260 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (((guint64) 1) == _tmp41_) {
#line 2121 "VideoMetadata.c"
		guint64 _tmp42_ = 0ULL;
		guint64 _tmp43_;
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp43_ = quick_time_atom_read_uint64 (self, &_inner_error_);
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp42_ = _tmp43_;
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return;
#line 2136 "VideoMetadata.c"
		}
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->section_size = _tmp42_;
#line 2140 "VideoMetadata.c"
	}
#line 237 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 2144 "VideoMetadata.c"
}


static void quick_time_atom_skip (QuickTimeAtom* self, guint64 skip_amount, GError** error) {
	GDataInputStream* _tmp0_;
	guint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 267 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = skip_amount;
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), _tmp1_, &_inner_error_);
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2166 "VideoMetadata.c"
	}
}


guint64 quick_time_atom_section_size_remaining (QuickTimeAtom* self) {
	guint64 result = 0ULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
#line 271 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0ULL);
#line 272 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_size;
#line 272 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->section_offset;
#line 272 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_vala_assert (_tmp0_ >= _tmp1_, "section_size >= section_offset");
#line 273 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = self->priv->section_size;
#line 273 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = self->priv->section_offset;
#line 273 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp2_ - _tmp3_;
#line 273 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2193 "VideoMetadata.c"
}


void quick_time_atom_next_atom (QuickTimeAtom* self, GError** error) {
	guint64 _tmp0_;
	GError * _inner_error_ = NULL;
#line 276 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = quick_time_atom_section_size_remaining (self);
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_skip (self, _tmp0_, &_inner_error_);
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2212 "VideoMetadata.c"
	}
#line 278 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 279 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 2218 "VideoMetadata.c"
}


gchar* quick_time_atom_get_current_atom_name (QuickTimeAtom* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 282 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), NULL);
#line 283 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_name;
#line 283 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 283 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 283 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2236 "VideoMetadata.c"
}


gboolean quick_time_atom_is_last_atom (QuickTimeAtom* self) {
	gboolean result = FALSE;
	guint64 _tmp0_;
#line 286 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), FALSE);
#line 287 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_size;
#line 287 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = ((guint64) 0) == _tmp0_;
#line 287 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2251 "VideoMetadata.c"
}


static void value_quick_time_atom_init (GValue* value) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 2258 "VideoMetadata.c"
}


static void value_quick_time_atom_free_value (GValue* value) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_unref (value->data[0].v_pointer);
#line 2267 "VideoMetadata.c"
	}
}


static void value_quick_time_atom_copy_value (const GValue* src_value, GValue* dest_value) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = quick_time_atom_ref (src_value->data[0].v_pointer);
#line 2277 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2281 "VideoMetadata.c"
	}
}


static gpointer value_quick_time_atom_peek_pointer (const GValue* value) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 2289 "VideoMetadata.c"
}


static gchar* value_quick_time_atom_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 2296 "VideoMetadata.c"
		QuickTimeAtom * object;
		object = collect_values[0].v_pointer;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2303 "VideoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2307 "VideoMetadata.c"
		}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = quick_time_atom_ref (object);
#line 2311 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2315 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 2319 "VideoMetadata.c"
}


static gchar* value_quick_time_atom_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	QuickTimeAtom ** object_p;
	object_p = collect_values[0].v_pointer;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!object_p) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2330 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = NULL;
#line 2336 "VideoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 2340 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = quick_time_atom_ref (value->data[0].v_pointer);
#line 2344 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 2348 "VideoMetadata.c"
}


GParamSpec* param_spec_quick_time_atom (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecQuickTimeAtom* spec;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_QUICK_TIME_ATOM), NULL);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 2362 "VideoMetadata.c"
}


gpointer value_get_quick_time_atom (const GValue* value) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM), NULL);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 2371 "VideoMetadata.c"
}


void value_set_quick_time_atom (GValue* value, gpointer v_object) {
	QuickTimeAtom * old;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_ATOM));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_ref (value->data[0].v_pointer);
#line 2391 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2395 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_unref (old);
#line 2401 "VideoMetadata.c"
	}
}


void value_take_quick_time_atom (GValue* value, gpointer v_object) {
	QuickTimeAtom * old;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_ATOM));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 2420 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2424 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_unref (old);
#line 2430 "VideoMetadata.c"
	}
}


static void quick_time_atom_class_init (QuickTimeAtomClass * klass) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_parent_class = g_type_class_peek_parent (klass);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((QuickTimeAtomClass *) klass)->finalize = quick_time_atom_finalize;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (QuickTimeAtomPrivate));
#line 2442 "VideoMetadata.c"
}


static void quick_time_atom_instance_init (QuickTimeAtom * self) {
	gchar* _tmp0_;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = QUICK_TIME_ATOM_GET_PRIVATE (self);
#line 174 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = NULL;
#line 175 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_strdup ("");
#line 175 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp0_;
#line 176 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 177 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 178 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = NULL;
#line 179 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->parent = NULL;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->ref_count = 1;
#line 2466 "VideoMetadata.c"
}


static void quick_time_atom_finalize (QuickTimeAtom * obj) {
	QuickTimeAtom * self;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_QUICK_TIME_ATOM, QuickTimeAtom);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 174 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 175 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 178 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 179 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_atom_unref0 (self->priv->parent);
#line 2484 "VideoMetadata.c"
}


GType quick_time_atom_get_type (void) {
	static volatile gsize quick_time_atom_type_id__volatile = 0;
	if (g_once_init_enter (&quick_time_atom_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_quick_time_atom_init, value_quick_time_atom_free_value, value_quick_time_atom_copy_value, value_quick_time_atom_peek_pointer, "p", value_quick_time_atom_collect_value, "p", value_quick_time_atom_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (QuickTimeAtomClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_time_atom_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickTimeAtom), 0, (GInstanceInitFunc) quick_time_atom_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType quick_time_atom_type_id;
		quick_time_atom_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QuickTimeAtom", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&quick_time_atom_type_id__volatile, quick_time_atom_type_id);
	}
	return quick_time_atom_type_id__volatile;
}


gpointer quick_time_atom_ref (gpointer instance) {
	QuickTimeAtom * self;
	self = instance;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return instance;
#line 2509 "VideoMetadata.c"
}


void quick_time_atom_unref (gpointer instance) {
	QuickTimeAtom * self;
	self = instance;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		QUICK_TIME_ATOM_GET_CLASS (self)->finalize (self);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2522 "VideoMetadata.c"
	}
}


AVIMetadataLoader* avi_metadata_loader_construct (GType object_type, GFile* file) {
	AVIMetadataLoader* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 305 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 305 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (AVIMetadataLoader*) g_type_create_instance (object_type);
#line 306 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = file;
#line 306 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 306 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 306 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = _tmp1_;
#line 305 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 2545 "VideoMetadata.c"
}


AVIMetadataLoader* avi_metadata_loader_new (GFile* file) {
#line 305 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return avi_metadata_loader_construct (TYPE_AVI_METADATA_LOADER, file);
#line 2552 "VideoMetadata.c"
}


MetadataDateTime* avi_metadata_loader_get_creation_date_time (AVIMetadataLoader* self) {
	MetadataDateTime* result = NULL;
	gulong _tmp0_;
	MetadataDateTime* _tmp1_;
#line 309 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 310 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = avi_metadata_loader_get_creation_date_time_for_avi (self);
#line 310 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = metadata_date_time_new ((time_t) _tmp0_);
#line 310 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 310 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2570 "VideoMetadata.c"
}


gchar* avi_metadata_loader_get_title (AVIMetadataLoader* self) {
	gchar* result = NULL;
#line 313 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 315 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = NULL;
#line 315 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2582 "VideoMetadata.c"
}


gboolean avi_metadata_loader_is_supported (AVIMetadataLoader* self) {
	gboolean result = FALSE;
	AVIChunk* chunk = NULL;
	GFile* _tmp0_;
	AVIChunk* _tmp1_;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
#line 319 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), FALSE);
#line 320 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->file;
#line 320 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = avi_chunk_new (_tmp0_);
#line 320 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	chunk = _tmp1_;
#line 321 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	ret = FALSE;
#line 2603 "VideoMetadata.c"
	{
		AVIChunk* _tmp2_;
		AVIChunk* _tmp3_;
		gboolean _tmp4_ = FALSE;
		AVIChunk* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
#line 323 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = chunk;
#line 323 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_open_file (_tmp2_, &_inner_error_);
#line 323 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2618 "VideoMetadata.c"
			goto __catch581_g_error;
		}
#line 324 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = chunk;
#line 324 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_read_chunk (_tmp3_, &_inner_error_);
#line 324 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2627 "VideoMetadata.c"
			goto __catch581_g_error;
		}
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = chunk;
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = avi_chunk_get_current_chunk_name (_tmp5_);
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = _tmp6_;
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp8_ = g_strcmp0 ("RIFF", _tmp7_) == 0;
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp7_);
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp8_) {
#line 2642 "VideoMetadata.c"
			gchar* _tmp9_ = NULL;
			AVIChunk* _tmp10_;
			gchar* _tmp11_;
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp10_ = chunk;
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp11_ = avi_chunk_read_name (_tmp10_, &_inner_error_);
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp9_ = _tmp11_;
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2654 "VideoMetadata.c"
				goto __catch581_g_error;
			}
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = g_strcmp0 ("AVI ", _tmp9_) == 0;
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp9_);
#line 2661 "VideoMetadata.c"
		} else {
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = FALSE;
#line 2665 "VideoMetadata.c"
		}
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp4_) {
#line 328 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			ret = TRUE;
#line 2671 "VideoMetadata.c"
		}
	}
	goto __finally581;
	__catch581_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 331 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp12_ = e;
#line 331 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = _tmp12_->message;
#line 331 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:331: Error while testing for AVI file: %s", _tmp13_);
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 2692 "VideoMetadata.c"
	}
	__finally581:
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2697 "VideoMetadata.c"
		gboolean _tmp14_ = FALSE;
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_chunk_unref0 (chunk);
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp14_;
#line 2707 "VideoMetadata.c"
	}
	{
		AVIChunk* _tmp15_;
#line 335 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp15_ = chunk;
#line 335 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_close_file (_tmp15_, &_inner_error_);
#line 335 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2717 "VideoMetadata.c"
			goto __catch582_g_error;
		}
	}
	goto __finally582;
	__catch582_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 337 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp16_ = e;
#line 337 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp17_ = _tmp16_->message;
#line 337 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:337: Error while closing AVI file: %s", _tmp17_);
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 2739 "VideoMetadata.c"
	}
	__finally582:
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2744 "VideoMetadata.c"
		gboolean _tmp18_ = FALSE;
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_chunk_unref0 (chunk);
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp18_;
#line 2754 "VideoMetadata.c"
	}
#line 339 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = ret;
#line 339 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_chunk_unref0 (chunk);
#line 339 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2762 "VideoMetadata.c"
}


static gchar* avi_metadata_loader_read_nikon_nctg_tag (AVIMetadataLoader* self, AVIChunk* chunk, GError** error) {
	gchar* result = NULL;
	gboolean found_date = FALSE;
	gboolean _tmp9_;
	gchar* _tmp21_;
	GError * _inner_error_ = NULL;
#line 343 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 343 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
#line 344 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	found_date = FALSE;
#line 345 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	while (TRUE) {
#line 2780 "VideoMetadata.c"
		AVIChunk* _tmp0_;
		guint64 _tmp1_;
		guint16 tag = 0U;
		AVIChunk* _tmp2_;
		guint16 _tmp3_;
		guint16 size = 0U;
		AVIChunk* _tmp4_;
		guint16 _tmp5_;
		guint16 _tmp6_;
		AVIChunk* _tmp7_;
		guint16 _tmp8_;
#line 345 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp0_ = chunk;
#line 345 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = avi_chunk_section_size_remaining (_tmp0_);
#line 345 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (!(_tmp1_ > ((guint64) (sizeof (guint16) * 2)))) {
#line 345 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 2800 "VideoMetadata.c"
		}
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = chunk;
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = avi_chunk_read_uint16 (_tmp2_, &_inner_error_);
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		tag = _tmp3_;
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 2814 "VideoMetadata.c"
		}
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = chunk;
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = avi_chunk_read_uint16 (_tmp4_, &_inner_error_);
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		size = _tmp5_;
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 2828 "VideoMetadata.c"
		}
#line 348 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = tag;
#line 348 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (AVI_METADATA_LOADER_NIKON_NCTG_TIMESTAMP_MARKER == _tmp6_) {
#line 349 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			found_date = TRUE;
#line 350 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 2838 "VideoMetadata.c"
		}
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = chunk;
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp8_ = size;
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_skip (_tmp7_, (guint64) _tmp8_, &_inner_error_);
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 2852 "VideoMetadata.c"
		}
	}
#line 355 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp9_ = found_date;
#line 355 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp9_) {
#line 2859 "VideoMetadata.c"
		GString* sb = NULL;
		GString* _tmp10_;
		GString* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
#line 357 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp10_ = g_string_new ("");
#line 357 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		sb = _tmp10_;
#line 2869 "VideoMetadata.c"
		{
			gint i = 0;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			i = 0;
#line 2874 "VideoMetadata.c"
			{
				gboolean _tmp11_ = FALSE;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp11_ = TRUE;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				while (TRUE) {
#line 2881 "VideoMetadata.c"
					gint _tmp13_;
					guchar _tmp14_ = '\0';
					AVIChunk* _tmp15_;
					guchar _tmp16_;
					GString* _tmp17_;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (!_tmp11_) {
#line 2889 "VideoMetadata.c"
						gint _tmp12_;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp12_ = i;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						i = _tmp12_ + 1;
#line 2895 "VideoMetadata.c"
					}
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp11_ = FALSE;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp13_ = i;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (!(_tmp13_ < AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH)) {
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						break;
#line 2905 "VideoMetadata.c"
					}
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp15_ = chunk;
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp16_ = avi_chunk_read_byte (_tmp15_, &_inner_error_);
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp14_ = _tmp16_;
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						g_propagate_error (error, _inner_error_);
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_g_string_free0 (sb);
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						return NULL;
#line 2921 "VideoMetadata.c"
					}
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp17_ = sb;
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					g_string_append_c (_tmp17_, (gchar) _tmp14_);
#line 2927 "VideoMetadata.c"
				}
			}
		}
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp18_ = sb;
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp19_ = _tmp18_->str;
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		result = _tmp20_;
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return result;
#line 2943 "VideoMetadata.c"
	}
#line 363 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp21_ = g_strdup ("");
#line 363 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp21_;
#line 363 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2951 "VideoMetadata.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1322 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1323 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2974 "VideoMetadata.c"
		glong _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1324 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2982 "VideoMetadata.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1326 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		return result;
#line 2994 "VideoMetadata.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
#line 1333 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 3018 "VideoMetadata.c"
		glong _tmp2_;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 3024 "VideoMetadata.c"
	} else {
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3028 "VideoMetadata.c"
	}
#line 1335 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 3032 "VideoMetadata.c"
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1337 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 3044 "VideoMetadata.c"
	} else {
		gint _tmp6_;
		gint _tmp7_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1339 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 3054 "VideoMetadata.c"
	}
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1342 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 3060 "VideoMetadata.c"
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1343 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1344 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 3074 "VideoMetadata.c"
	} else {
		glong _tmp12_;
		glong _tmp13_;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1346 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 3084 "VideoMetadata.c"
	}
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1348 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 3090 "VideoMetadata.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1349 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 3099 "VideoMetadata.c"
	}
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1351 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1352 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 3119 "VideoMetadata.c"
}


static gchar* avi_metadata_loader_read_fuji_strd_tag (AVIMetadataLoader* self, AVIChunk* chunk, GError** error) {
	gchar* result = NULL;
	AVIChunk* _tmp0_;
	AVIChunk* _tmp1_;
	gint colons = 0;
	gint post_colons = 0;
	GString* sb = NULL;
	GString* _tmp2_;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GString* _tmp25_;
	const gchar* _tmp26_;
	GString* _tmp27_;
	const gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gchar* _tmp31_;
	GError * _inner_error_ = NULL;
#line 368 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 368 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = chunk;
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_skip (_tmp0_, (guint64) 98, &_inner_error_);
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 3157 "VideoMetadata.c"
	}
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = chunk;
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_skip (_tmp1_, (guint64) 8, &_inner_error_);
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 3169 "VideoMetadata.c"
	}
#line 372 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	colons = 0;
#line 373 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	post_colons = 0;
#line 374 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_string_new ("");
#line 374 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp2_;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	while (TRUE) {
#line 3181 "VideoMetadata.c"
		gboolean _tmp3_ = FALSE;
		gint _tmp4_;
		guchar _tmp6_ = '\0';
		AVIChunk* _tmp7_;
		guchar _tmp8_;
		gchar c = '\0';
		gint _tmp9_;
		gchar _tmp11_;
		gchar _tmp13_;
		gboolean _tmp14_;
		GString* _tmp17_;
		gssize _tmp18_;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = colons;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp4_ <= 4) {
#line 3198 "VideoMetadata.c"
			gint _tmp5_;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp5_ = post_colons;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp3_ = _tmp5_ < 2;
#line 3204 "VideoMetadata.c"
		} else {
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp3_ = FALSE;
#line 3208 "VideoMetadata.c"
		}
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (!_tmp3_) {
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 3214 "VideoMetadata.c"
		}
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = chunk;
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp8_ = avi_chunk_read_byte (_tmp7_, &_inner_error_);
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = _tmp8_;
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 3230 "VideoMetadata.c"
		}
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		c = (gchar) _tmp6_;
#line 378 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp9_ = colons;
#line 378 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (4 == _tmp9_) {
#line 3238 "VideoMetadata.c"
			gint _tmp10_;
#line 379 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp10_ = post_colons;
#line 379 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			post_colons = _tmp10_ + 1;
#line 3244 "VideoMetadata.c"
		}
#line 381 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp11_ = c;
#line 381 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (':' == _tmp11_) {
#line 3250 "VideoMetadata.c"
			gint _tmp12_;
#line 382 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp12_ = colons;
#line 382 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			colons = _tmp12_ + 1;
#line 3256 "VideoMetadata.c"
		}
#line 384 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = c;
#line 384 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp14_ = g_ascii_isprint (_tmp13_);
#line 384 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp14_) {
#line 3264 "VideoMetadata.c"
			GString* _tmp15_;
			gchar _tmp16_;
#line 385 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp15_ = sb;
#line 385 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp16_ = c;
#line 385 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_string_append_c (_tmp15_, _tmp16_);
#line 3273 "VideoMetadata.c"
		}
#line 387 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp17_ = sb;
#line 387 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp18_ = _tmp17_->len;
#line 387 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp18_ > ((gssize) AVI_METADATA_LOADER_MAX_STRD_LENGTH)) {
#line 3281 "VideoMetadata.c"
			gchar* _tmp19_;
#line 388 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp19_ = g_strdup ("");
#line 388 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = _tmp19_;
#line 388 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 388 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 3291 "VideoMetadata.c"
		}
	}
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp20_ = sb;
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp21_ = _tmp20_->str;
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp22_ = strlen (_tmp21_);
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp23_ = _tmp22_;
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp23_ < AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH) {
#line 3304 "VideoMetadata.c"
		gchar* _tmp24_;
#line 393 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp24_ = g_strdup ("");
#line 393 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		result = _tmp24_;
#line 393 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 393 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return result;
#line 3314 "VideoMetadata.c"
	}
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp25_ = sb;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp26_ = _tmp25_->str;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp27_ = sb;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp28_ = _tmp27_->str;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp29_ = strlen (_tmp28_);
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp30_ = _tmp29_;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp31_ = string_substring (_tmp26_, (glong) (_tmp30_ - AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH), (glong) -1);
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp31_;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 3336 "VideoMetadata.c"
}


static gchar* avi_metadata_loader_read_section (AVIMetadataLoader* self, AVIChunk* chunk, GError** error) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 400 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 400 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
#line 401 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	while (TRUE) {
#line 3349 "VideoMetadata.c"
		AVIChunk* _tmp0_;
		gchar* name = NULL;
		AVIChunk* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp18_;
		AVIChunk* _tmp28_;
		gboolean _tmp29_;
		AVIChunk* _tmp30_;
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp0_ = chunk;
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_read_chunk (_tmp0_, &_inner_error_);
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 3369 "VideoMetadata.c"
		}
#line 403 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = chunk;
#line 403 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = avi_chunk_get_current_chunk_name (_tmp1_);
#line 403 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		name = _tmp2_;
#line 404 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = name;
#line 404 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (g_strcmp0 ("IDIT", _tmp3_) == 0) {
#line 3381 "VideoMetadata.c"
			gchar* _tmp4_ = NULL;
			AVIChunk* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp5_ = chunk;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp6_ = avi_chunk_section_to_string (_tmp5_, &_inner_error_);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = _tmp6_;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				g_propagate_error (error, _inner_error_);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return NULL;
#line 3400 "VideoMetadata.c"
			}
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp7_ = _tmp4_;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = _tmp7_;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp4_);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (name);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 3414 "VideoMetadata.c"
		} else {
			const gchar* _tmp8_;
#line 406 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp8_ = name;
#line 406 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (g_strcmp0 ("nctg", _tmp8_) == 0) {
#line 3421 "VideoMetadata.c"
				gchar* _tmp9_ = NULL;
				AVIChunk* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp10_ = chunk;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp11_ = avi_metadata_loader_read_nikon_nctg_tag (self, _tmp10_, &_inner_error_);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp9_ = _tmp11_;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					g_propagate_error (error, _inner_error_);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (name);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					return NULL;
#line 3440 "VideoMetadata.c"
				}
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp12_ = _tmp9_;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp9_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = _tmp12_;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (_tmp9_);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3454 "VideoMetadata.c"
			} else {
				const gchar* _tmp13_;
#line 408 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp13_ = name;
#line 408 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (g_strcmp0 ("strd", _tmp13_) == 0) {
#line 3461 "VideoMetadata.c"
					gchar* _tmp14_ = NULL;
					AVIChunk* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp15_ = chunk;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp16_ = avi_metadata_loader_read_fuji_strd_tag (self, _tmp15_, &_inner_error_);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp14_ = _tmp16_;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						g_propagate_error (error, _inner_error_);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_g_free0 (name);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						return NULL;
#line 3480 "VideoMetadata.c"
					}
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp17_ = _tmp14_;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp14_ = NULL;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					result = _tmp17_;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (_tmp14_);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (name);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					return result;
#line 3494 "VideoMetadata.c"
				}
			}
		}
#line 412 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp18_ = name;
#line 412 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (g_strcmp0 ("LIST", _tmp18_) == 0) {
#line 3502 "VideoMetadata.c"
			AVIChunk* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _result_ = NULL;
			AVIChunk* _tmp22_;
			AVIChunk* _tmp23_;
			AVIChunk* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			const gchar* _tmp27_;
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp19_ = chunk;
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp20_ = avi_chunk_read_name (_tmp19_, &_inner_error_);
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp21_ = _tmp20_;
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp21_);
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				g_propagate_error (error, _inner_error_);
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return NULL;
#line 3529 "VideoMetadata.c"
			}
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp22_ = chunk;
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp23_ = avi_chunk_get_first_child_chunk (_tmp22_);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp24_ = _tmp23_;
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp25_ = avi_metadata_loader_read_section (self, _tmp24_, &_inner_error_);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp26_ = _tmp25_;
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_avi_chunk_unref0 (_tmp24_);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_result_ = _tmp26_;
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				g_propagate_error (error, _inner_error_);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return NULL;
#line 3553 "VideoMetadata.c"
			}
#line 415 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp27_ = _result_;
#line 415 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (NULL != _tmp27_) {
#line 416 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = _result_;
#line 416 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 416 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3565 "VideoMetadata.c"
			}
#line 412 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_result_);
#line 3569 "VideoMetadata.c"
		}
#line 420 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp28_ = chunk;
#line 420 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp29_ = avi_chunk_is_last_chunk (_tmp28_);
#line 420 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp29_) {
#line 421 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (name);
#line 421 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 3581 "VideoMetadata.c"
		}
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp30_ = chunk;
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_next_chunk (_tmp30_, &_inner_error_);
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (name);
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 3595 "VideoMetadata.c"
		}
#line 401 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (name);
#line 3599 "VideoMetadata.c"
	}
#line 425 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = NULL;
#line 425 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 3605 "VideoMetadata.c"
}


static gulong avi_metadata_loader_parse_date (AVIMetadataLoader* self, const gchar* sdate) {
	gulong result = 0UL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GDate date = {0};
	guint seconds = 0U;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint min = 0;
	gint sec = 0;
	gchar weekday[4] = {0};
	gchar monthstr[4] = {0};
	const gchar* _tmp3_;
	gchar _tmp4_;
	gboolean _tmp5_;
	struct tm time = {0};
	struct tm _tmp26_ = {0};
	time_t tm = 0;
	time_t _tmp27_;
	gulong _result_ = 0UL;
	time_t _tmp28_;
	guint _tmp29_;
	gulong _tmp30_;
	time_t _tmp31_;
#line 432 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), 0UL);
#line 432 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (sdate != NULL, 0UL);
#line 433 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = sdate;
#line 433 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = strlen (_tmp0_);
#line 433 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = _tmp1_;
#line 433 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp2_ == 0) {
#line 434 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		result = (gulong) 0;
#line 434 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return result;
#line 3652 "VideoMetadata.c"
	}
#line 437 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	memset (&date, 0, sizeof (GDate));
#line 438 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	seconds = (guint) 0;
#line 443 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = sdate;
#line 443 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = string_get (_tmp3_, (glong) 0);
#line 443 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = g_ascii_isdigit (_tmp4_);
#line 443 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp5_) {
#line 3666 "VideoMetadata.c"
		gchar* tmp = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _result_ = 0;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
#line 447 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = sdate;
#line 447 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 447 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		tmp = _tmp7_;
#line 448 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp8_ = tmp;
#line 448 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_strcanon (_tmp8_, "0123456789 ", ' ');
#line 449 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		sec = 0;
#line 450 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp9_ = tmp;
#line 450 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp10_ = sscanf (_tmp9_, "%d %d %d %d %d %d", &year, &month, &day, &hour, &min, &sec);
#line 450 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_result_ = _tmp10_;
#line 451 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp11_ = _result_;
#line 451 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp11_ < 5) {
#line 452 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = (gulong) 0;
#line 452 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (tmp);
#line 452 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 3709 "VideoMetadata.c"
		}
#line 454 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp12_ = day;
#line 454 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = month;
#line 454 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp14_ = year;
#line 454 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_date_set_dmy (&date, (GDateDay) _tmp12_, (gint) ((GDateMonth) _tmp13_), (GDateYear) _tmp14_);
#line 455 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp15_ = sec;
#line 455 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp16_ = min;
#line 455 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp17_ = hour;
#line 455 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		seconds = (guint) ((_tmp15_ + (_tmp16_ * 60)) + (_tmp17_ * 3600));
#line 443 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (tmp);
#line 3729 "VideoMetadata.c"
	} else {
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		GDateMonth _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
#line 458 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp18_ = sdate;
#line 458 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp19_ = sscanf (_tmp18_, "%3s %3s %d %d:%d:%d %d", weekday, monthstr, &day, &hour, &min, &sec, &year);
#line 458 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (7 != _tmp19_) {
#line 460 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = (gulong) 0;
#line 460 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 3749 "VideoMetadata.c"
		}
#line 462 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp20_ = day;
#line 462 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp21_ = avi_metadata_loader_month_from_string (self, (const gchar*) monthstr);
#line 462 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp22_ = year;
#line 462 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_date_set_dmy (&date, (GDateDay) _tmp20_, (gint) _tmp21_, (GDateYear) _tmp22_);
#line 463 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp23_ = sec;
#line 463 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp24_ = min;
#line 463 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp25_ = hour;
#line 463 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		seconds = (guint) ((_tmp23_ + (_tmp24_ * 60)) + (_tmp25_ * 3600));
#line 3767 "VideoMetadata.c"
	}
#line 466 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	memset (&time, 0, sizeof (struct tm));
#line 467 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_date_to_struct_tm (&date, &_tmp26_);
#line 467 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	time = _tmp26_;
#line 470 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp27_ = mktime (&time);
#line 470 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	tm = _tmp27_;
#line 471 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp28_ = tm;
#line 471 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp29_ = seconds;
#line 471 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_result_ = (gulong) (_tmp28_ + _tmp29_);
#line 472 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp30_ = _result_;
#line 472 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp31_ = tm;
#line 472 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp30_ < ((gulong) _tmp31_)) {
#line 3791 "VideoMetadata.c"
		GFile* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp32_ = self->priv->file;
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp33_ = g_file_get_path (_tmp32_);
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp34_ = _tmp33_;
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:473: Overflow for timestamp in video file %s", _tmp34_);
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp34_);
#line 475 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		result = (gulong) 0;
#line 475 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return result;
#line 3809 "VideoMetadata.c"
	}
#line 478 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _result_;
#line 478 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 3815 "VideoMetadata.c"
}


static GDateMonth avi_metadata_loader_month_from_string (AVIMetadataLoader* self, const gchar* s) {
	GDateMonth result = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label0 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label1 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label2 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label3 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label4 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label5 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label6 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label7 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label8 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label9 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label10 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp3_label11 = 0;
#line 481 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), 0);
#line 481 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (s != NULL, 0);
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = s;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = _tmp1_;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_free (_tmp2_);
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("jan")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3867 "VideoMetadata.c"
			default:
			{
#line 484 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_JANUARY;
#line 484 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3874 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("feb")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3880 "VideoMetadata.c"
			default:
			{
#line 486 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_FEBRUARY;
#line 486 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3887 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("mar")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3893 "VideoMetadata.c"
			default:
			{
#line 488 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_MARCH;
#line 488 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3900 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("apr")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3906 "VideoMetadata.c"
			default:
			{
#line 490 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_APRIL;
#line 490 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3913 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("may")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3919 "VideoMetadata.c"
			default:
			{
#line 492 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_MAY;
#line 492 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3926 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("jun")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3932 "VideoMetadata.c"
			default:
			{
#line 494 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_JUNE;
#line 494 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3939 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("jul")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3945 "VideoMetadata.c"
			default:
			{
#line 496 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_JULY;
#line 496 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3952 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("aug")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3958 "VideoMetadata.c"
			default:
			{
#line 498 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_AUGUST;
#line 498 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3965 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label8) ? _tmp3_label8 : (_tmp3_label8 = g_quark_from_static_string ("sep")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3971 "VideoMetadata.c"
			default:
			{
#line 500 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_SEPTEMBER;
#line 500 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3978 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label9) ? _tmp3_label9 : (_tmp3_label9 = g_quark_from_static_string ("oct")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3984 "VideoMetadata.c"
			default:
			{
#line 502 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_OCTOBER;
#line 502 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3991 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label10) ? _tmp3_label10 : (_tmp3_label10 = g_quark_from_static_string ("nov")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3997 "VideoMetadata.c"
			default:
			{
#line 504 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_NOVEMBER;
#line 504 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 4004 "VideoMetadata.c"
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label11) ? _tmp3_label11 : (_tmp3_label11 = g_quark_from_static_string ("dec")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 4010 "VideoMetadata.c"
			default:
			{
#line 506 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_DECEMBER;
#line 506 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 4017 "VideoMetadata.c"
			}
		}
	}
#line 508 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = G_DATE_BAD_MONTH;
#line 508 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4025 "VideoMetadata.c"
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1234 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1235 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1235 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1236 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1236 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1237 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _result_;
#line 1237 "/usr/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 4048 "VideoMetadata.c"
}


static gulong avi_metadata_loader_get_creation_date_time_for_avi (AVIMetadataLoader* self) {
	gulong result = 0UL;
	AVIChunk* chunk = NULL;
	GFile* _tmp0_;
	AVIChunk* _tmp1_;
	gulong timestamp = 0UL;
	GError * _inner_error_ = NULL;
#line 511 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), 0UL);
#line 512 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->file;
#line 512 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = avi_chunk_new (_tmp0_);
#line 512 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	chunk = _tmp1_;
#line 513 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	timestamp = (gulong) 0;
#line 4069 "VideoMetadata.c"
	{
		AVIChunk* _tmp2_;
		AVIChunk* _tmp3_;
		gchar* sdate = NULL;
		AVIChunk* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
#line 515 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = chunk;
#line 515 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_open_file (_tmp2_, &_inner_error_);
#line 515 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4083 "VideoMetadata.c"
			goto __catch583_g_error;
		}
#line 516 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = chunk;
#line 516 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_nonsection_skip (_tmp3_, (guint64) 12, &_inner_error_);
#line 516 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4092 "VideoMetadata.c"
			goto __catch583_g_error;
		}
#line 517 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = chunk;
#line 517 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = avi_metadata_loader_read_section (self, _tmp4_, &_inner_error_);
#line 517 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		sdate = _tmp5_;
#line 517 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4103 "VideoMetadata.c"
			goto __catch583_g_error;
		}
#line 518 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = sdate;
#line 518 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (NULL != _tmp6_) {
#line 4110 "VideoMetadata.c"
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gulong _tmp10_;
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp7_ = sdate;
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp8_ = string_strip (_tmp7_);
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp9_ = _tmp8_;
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp10_ = avi_metadata_loader_parse_date (self, _tmp9_);
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			timestamp = _tmp10_;
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp9_);
#line 4127 "VideoMetadata.c"
		}
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (sdate);
#line 4131 "VideoMetadata.c"
	}
	goto __finally583;
	__catch583_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 522 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp11_ = e;
#line 522 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp12_ = _tmp11_->message;
#line 522 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:522: Error while reading AVI file: %s", _tmp12_);
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 4151 "VideoMetadata.c"
	}
	__finally583:
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4156 "VideoMetadata.c"
		gulong _tmp13_ = 0UL;
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_chunk_unref0 (chunk);
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp13_;
#line 4166 "VideoMetadata.c"
	}
	{
		AVIChunk* _tmp14_;
#line 526 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp14_ = chunk;
#line 526 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_close_file (_tmp14_, &_inner_error_);
#line 526 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4176 "VideoMetadata.c"
			goto __catch584_g_error;
		}
	}
	goto __finally584;
	__catch584_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 528 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp15_ = e;
#line 528 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp16_ = _tmp15_->message;
#line 528 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:528: Error while closing AVI file: %s", _tmp16_);
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 4198 "VideoMetadata.c"
	}
	__finally584:
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4203 "VideoMetadata.c"
		gulong _tmp17_ = 0UL;
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_chunk_unref0 (chunk);
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp17_;
#line 4213 "VideoMetadata.c"
	}
#line 530 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = timestamp;
#line 530 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_chunk_unref0 (chunk);
#line 530 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4221 "VideoMetadata.c"
}


static void value_avi_metadata_loader_init (GValue* value) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 4228 "VideoMetadata.c"
}


static void value_avi_metadata_loader_free_value (GValue* value) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_metadata_loader_unref (value->data[0].v_pointer);
#line 4237 "VideoMetadata.c"
	}
}


static void value_avi_metadata_loader_copy_value (const GValue* src_value, GValue* dest_value) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = avi_metadata_loader_ref (src_value->data[0].v_pointer);
#line 4247 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4251 "VideoMetadata.c"
	}
}


static gpointer value_avi_metadata_loader_peek_pointer (const GValue* value) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 4259 "VideoMetadata.c"
}


static gchar* value_avi_metadata_loader_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 4266 "VideoMetadata.c"
		AVIMetadataLoader * object;
		object = collect_values[0].v_pointer;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4273 "VideoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4277 "VideoMetadata.c"
		}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = avi_metadata_loader_ref (object);
#line 4281 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 4285 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 4289 "VideoMetadata.c"
}


static gchar* value_avi_metadata_loader_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AVIMetadataLoader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!object_p) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4300 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = NULL;
#line 4306 "VideoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 4310 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = avi_metadata_loader_ref (value->data[0].v_pointer);
#line 4314 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 4318 "VideoMetadata.c"
}


GParamSpec* param_spec_avi_metadata_loader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAVIMetadataLoader* spec;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AVI_METADATA_LOADER), NULL);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 4332 "VideoMetadata.c"
}


gpointer value_get_avi_metadata_loader (const GValue* value) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER), NULL);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 4341 "VideoMetadata.c"
}


void value_set_avi_metadata_loader (GValue* value, gpointer v_object) {
	AVIMetadataLoader * old;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_METADATA_LOADER));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_metadata_loader_ref (value->data[0].v_pointer);
#line 4361 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 4365 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_metadata_loader_unref (old);
#line 4371 "VideoMetadata.c"
	}
}


void value_take_avi_metadata_loader (GValue* value, gpointer v_object) {
	AVIMetadataLoader * old;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_METADATA_LOADER));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 4390 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 4394 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_metadata_loader_unref (old);
#line 4400 "VideoMetadata.c"
	}
}


static void avi_metadata_loader_class_init (AVIMetadataLoaderClass * klass) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_metadata_loader_parent_class = g_type_class_peek_parent (klass);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((AVIMetadataLoaderClass *) klass)->finalize = avi_metadata_loader_finalize;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (AVIMetadataLoaderPrivate));
#line 4412 "VideoMetadata.c"
}


static void avi_metadata_loader_instance_init (AVIMetadataLoader * self) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = AVI_METADATA_LOADER_GET_PRIVATE (self);
#line 294 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = NULL;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->ref_count = 1;
#line 4423 "VideoMetadata.c"
}


static void avi_metadata_loader_finalize (AVIMetadataLoader * obj) {
	AVIMetadataLoader * self;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVI_METADATA_LOADER, AVIMetadataLoader);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 294 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 4435 "VideoMetadata.c"
}


GType avi_metadata_loader_get_type (void) {
	static volatile gsize avi_metadata_loader_type_id__volatile = 0;
	if (g_once_init_enter (&avi_metadata_loader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_avi_metadata_loader_init, value_avi_metadata_loader_free_value, value_avi_metadata_loader_copy_value, value_avi_metadata_loader_peek_pointer, "p", value_avi_metadata_loader_collect_value, "p", value_avi_metadata_loader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AVIMetadataLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avi_metadata_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AVIMetadataLoader), 0, (GInstanceInitFunc) avi_metadata_loader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType avi_metadata_loader_type_id;
		avi_metadata_loader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AVIMetadataLoader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&avi_metadata_loader_type_id__volatile, avi_metadata_loader_type_id);
	}
	return avi_metadata_loader_type_id__volatile;
}


gpointer avi_metadata_loader_ref (gpointer instance) {
	AVIMetadataLoader * self;
	self = instance;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return instance;
#line 4460 "VideoMetadata.c"
}


void avi_metadata_loader_unref (gpointer instance) {
	AVIMetadataLoader * self;
	self = instance;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		AVI_METADATA_LOADER_GET_CLASS (self)->finalize (self);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4473 "VideoMetadata.c"
	}
}


AVIChunk* avi_chunk_construct (GType object_type, GFile* file) {
	AVIChunk* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 543 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 543 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (AVIChunk*) g_type_create_instance (object_type);
#line 544 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = file;
#line 544 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 544 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 544 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = _tmp1_;
#line 543 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 4496 "VideoMetadata.c"
}


AVIChunk* avi_chunk_new (GFile* file) {
#line 543 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return avi_chunk_construct (TYPE_AVI_CHUNK, file);
#line 4503 "VideoMetadata.c"
}


static gpointer _avi_chunk_ref0 (gpointer self) {
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self ? avi_chunk_ref (self) : NULL;
#line 4510 "VideoMetadata.c"
}


static AVIChunk* avi_chunk_construct_with_input_stream (GType object_type, GDataInputStream* input, AVIChunk* parent) {
	AVIChunk* self = NULL;
	GDataInputStream* _tmp0_;
	GDataInputStream* _tmp1_;
	AVIChunk* _tmp2_;
	AVIChunk* _tmp3_;
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_DATA_INPUT_STREAM (input), NULL);
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (parent), NULL);
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (AVIChunk*) g_type_create_instance (object_type);
#line 548 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = input;
#line 548 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 548 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 548 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = _tmp1_;
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = parent;
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = _avi_chunk_ref0 (_tmp2_);
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_chunk_unref0 (self->priv->parent);
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->parent = _tmp3_;
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 4544 "VideoMetadata.c"
}


static AVIChunk* avi_chunk_new_with_input_stream (GDataInputStream* input, AVIChunk* parent) {
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return avi_chunk_construct_with_input_stream (TYPE_AVI_CHUNK, input, parent);
#line 4551 "VideoMetadata.c"
}


void avi_chunk_open_file (AVIChunk* self, GError** error) {
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 552 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 553 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_close_file (self, &_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 553 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4573 "VideoMetadata.c"
	}
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->file;
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4587 "VideoMetadata.c"
	}
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = g_data_input_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream));
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = _tmp3_;
#line 555 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = self->priv->input;
#line 555 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_data_input_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
#line 556 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 557 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 558 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = g_strdup ("");
#line 558 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 558 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp5_;
#line 552 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (_tmp0_);
#line 4611 "VideoMetadata.c"
}


void avi_chunk_close_file (AVIChunk* self, GError** error) {
	GDataInputStream* _tmp0_;
	GError * _inner_error_ = NULL;
#line 561 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 562 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 562 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (NULL != _tmp0_) {
#line 4624 "VideoMetadata.c"
		GDataInputStream* _tmp1_;
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = self->priv->input;
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return;
#line 4636 "VideoMetadata.c"
		}
#line 564 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_object_unref0 (self->priv->input);
#line 564 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->input = NULL;
#line 4642 "VideoMetadata.c"
	}
}


void avi_chunk_nonsection_skip (AVIChunk* self, guint64 skip_amount, GError** error) {
	GDataInputStream* _tmp0_;
	guint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 568 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = skip_amount;
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), _tmp1_, &_inner_error_);
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4665 "VideoMetadata.c"
	}
}


void avi_chunk_skip (AVIChunk* self, guint64 skip_amount, GError** error) {
	guint64 _tmp0_;
	GDataInputStream* _tmp1_;
	guint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 572 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 573 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = skip_amount;
#line 573 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_advance_section_offset (self, _tmp0_);
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = skip_amount;
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_input_stream_get_type (), GInputStream), _tmp2_, &_inner_error_);
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4693 "VideoMetadata.c"
	}
}


AVIChunk* avi_chunk_get_first_child_chunk (AVIChunk* self) {
	AVIChunk* result = NULL;
	GDataInputStream* _tmp0_;
	AVIChunk* _tmp1_;
#line 577 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
#line 578 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 578 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = avi_chunk_new_with_input_stream (_tmp0_, self);
#line 578 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 578 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4712 "VideoMetadata.c"
}


static void avi_chunk_advance_section_offset (AVIChunk* self, guint64 amount) {
	guint64 _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp5_;
	guint64 _tmp6_;
	AVIChunk* _tmp7_;
#line 581 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 582 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_offset;
#line 582 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = amount;
#line 582 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = self->priv->section_size;
#line 582 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if ((_tmp0_ + _tmp1_) > _tmp2_) {
#line 4733 "VideoMetadata.c"
		guint64 _tmp3_;
		guint64 _tmp4_;
#line 583 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = self->priv->section_size;
#line 583 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = self->priv->section_offset;
#line 583 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		amount = _tmp3_ - _tmp4_;
#line 4742 "VideoMetadata.c"
	}
#line 585 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = self->priv->section_offset;
#line 585 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp6_ = amount;
#line 585 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = _tmp5_ + _tmp6_;
#line 586 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp7_ = self->priv->parent;
#line 586 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (NULL != _tmp7_) {
#line 4754 "VideoMetadata.c"
		AVIChunk* _tmp8_;
		guint64 _tmp9_;
#line 587 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp8_ = self->priv->parent;
#line 587 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp9_ = amount;
#line 587 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_advance_section_offset (_tmp8_, _tmp9_);
#line 4763 "VideoMetadata.c"
	}
}


guchar avi_chunk_read_byte (AVIChunk* self, GError** error) {
	guchar result = '\0';
	guint8 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	guint8 _tmp2_;
	GError * _inner_error_ = NULL;
#line 591 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), '\0');
#line 592 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_advance_section_offset (self, (guint64) 1);
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error_);
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4786 "VideoMetadata.c"
		guchar _tmp3_ = '\0';
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp3_;
#line 4792 "VideoMetadata.c"
	}
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = (guchar) _tmp0_;
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4798 "VideoMetadata.c"
}


guint16 avi_chunk_read_uint16 (AVIChunk* self, GError** error) {
	guint16 result = 0U;
	guint16 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	guint16 _tmp2_;
	GError * _inner_error_ = NULL;
#line 596 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), 0U);
#line 597 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_advance_section_offset (self, (guint64) 2);
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_data_input_stream_read_uint16 (_tmp1_, NULL, &_inner_error_);
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4820 "VideoMetadata.c"
		guint16 _tmp3_ = 0U;
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp3_;
#line 4826 "VideoMetadata.c"
	}
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_;
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4832 "VideoMetadata.c"
}


void avi_chunk_read_chunk (AVIChunk* self, GError** error) {
	GString* sb = NULL;
	GString* _tmp0_;
	guint8 _tmp1_ = 0U;
	GDataInputStream* _tmp2_;
	guint8 _tmp3_;
	GString* _tmp4_;
	guint8 _tmp5_ = 0U;
	GDataInputStream* _tmp6_;
	guint8 _tmp7_;
	GString* _tmp8_;
	guint8 _tmp9_ = 0U;
	GDataInputStream* _tmp10_;
	guint8 _tmp11_;
	GString* _tmp12_;
	guint8 _tmp13_ = 0U;
	GDataInputStream* _tmp14_;
	guint8 _tmp15_;
	GString* _tmp16_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	guint32 _tmp20_ = 0U;
	GDataInputStream* _tmp21_;
	guint32 _tmp22_;
	GError * _inner_error_ = NULL;
#line 601 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 604 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_string_new ("");
#line 604 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp0_;
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = self->priv->input;
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = g_data_input_stream_read_byte (_tmp2_, NULL, &_inner_error_);
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _tmp3_;
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4882 "VideoMetadata.c"
	}
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = sb;
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp4_, (gchar) _tmp1_);
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp6_ = self->priv->input;
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp7_ = g_data_input_stream_read_byte (_tmp6_, NULL, &_inner_error_);
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = _tmp7_;
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4902 "VideoMetadata.c"
	}
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp8_ = sb;
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp8_, (gchar) _tmp5_);
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp10_ = self->priv->input;
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = g_data_input_stream_read_byte (_tmp10_, NULL, &_inner_error_);
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp9_ = _tmp11_;
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4922 "VideoMetadata.c"
	}
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = sb;
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp12_, (gchar) _tmp9_);
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp14_ = self->priv->input;
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp15_ = g_data_input_stream_read_byte (_tmp14_, NULL, &_inner_error_);
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp13_ = _tmp15_;
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4942 "VideoMetadata.c"
	}
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp16_ = sb;
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp16_, (gchar) _tmp13_);
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp17_ = sb;
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp18_ = _tmp17_->str;
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp19_ = g_strdup (_tmp18_);
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp19_;
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp21_ = self->priv->input;
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp22_ = g_data_input_stream_read_uint32 (_tmp21_, NULL, &_inner_error_);
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp20_ = _tmp22_;
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4972 "VideoMetadata.c"
	}
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) _tmp20_;
#line 611 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 601 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 4980 "VideoMetadata.c"
}


gchar* avi_chunk_read_name (AVIChunk* self, GError** error) {
	gchar* result = NULL;
	GString* sb = NULL;
	GString* _tmp0_;
	guchar _tmp1_ = '\0';
	guchar _tmp2_;
	GString* _tmp3_;
	guchar _tmp4_ = '\0';
	guchar _tmp5_;
	GString* _tmp6_;
	guchar _tmp7_ = '\0';
	guchar _tmp8_;
	GString* _tmp9_;
	guchar _tmp10_ = '\0';
	guchar _tmp11_;
	GString* _tmp12_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError * _inner_error_ = NULL;
#line 614 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
#line 615 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_string_new ("");
#line 615 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp0_;
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = avi_chunk_read_byte (self, &_inner_error_);
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _tmp2_;
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 5022 "VideoMetadata.c"
	}
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = sb;
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp3_, (gchar) _tmp1_);
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = avi_chunk_read_byte (self, &_inner_error_);
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = _tmp5_;
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 5040 "VideoMetadata.c"
	}
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp6_ = sb;
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp6_, (gchar) _tmp4_);
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp8_ = avi_chunk_read_byte (self, &_inner_error_);
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp7_ = _tmp8_;
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 5058 "VideoMetadata.c"
	}
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp9_ = sb;
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp9_, (gchar) _tmp7_);
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = avi_chunk_read_byte (self, &_inner_error_);
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp10_ = _tmp11_;
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 5076 "VideoMetadata.c"
	}
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = sb;
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp12_, (gchar) _tmp10_);
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp13_ = sb;
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp14_ = _tmp13_->str;
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp15_;
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5094 "VideoMetadata.c"
}


void avi_chunk_next_chunk (AVIChunk* self, GError** error) {
	guint64 _tmp0_;
	GError * _inner_error_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = avi_chunk_section_size_remaining (self);
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_skip (self, _tmp0_, &_inner_error_);
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 5113 "VideoMetadata.c"
	}
#line 625 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 626 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 5119 "VideoMetadata.c"
}


gchar* avi_chunk_get_current_chunk_name (AVIChunk* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 629 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
#line 630 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_name;
#line 630 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 630 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 630 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5137 "VideoMetadata.c"
}


gboolean avi_chunk_is_last_chunk (AVIChunk* self) {
	gboolean result = FALSE;
	guint64 _tmp0_;
#line 633 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), FALSE);
#line 634 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_size;
#line 634 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_ == ((guint64) 0);
#line 634 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5152 "VideoMetadata.c"
}


guint64 avi_chunk_section_size_remaining (AVIChunk* self) {
	guint64 result = 0ULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
#line 637 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), 0ULL);
#line 638 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_size;
#line 638 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->section_offset;
#line 638 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_vala_assert (_tmp0_ >= _tmp1_, "section_size >= section_offset");
#line 639 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = self->priv->section_size;
#line 639 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = self->priv->section_offset;
#line 639 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp2_ - _tmp3_;
#line 639 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5178 "VideoMetadata.c"
}


gchar* avi_chunk_section_to_string (AVIChunk* self, GError** error) {
	gchar* result = NULL;
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GError * _inner_error_ = NULL;
#line 643 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
#line 644 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_string_new ("");
#line 644 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp0_;
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	while (TRUE) {
#line 5198 "VideoMetadata.c"
		guint64 _tmp1_;
		guint64 _tmp2_;
		guchar _tmp3_ = '\0';
		guchar _tmp4_;
		GString* _tmp5_;
		GString* _tmp6_;
		gssize _tmp7_;
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = self->priv->section_offset;
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = self->priv->section_size;
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (!(_tmp1_ < _tmp2_)) {
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 5214 "VideoMetadata.c"
		}
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = avi_chunk_read_byte (self, &_inner_error_);
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = _tmp4_;
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 5228 "VideoMetadata.c"
		}
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = sb;
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_string_append_c (_tmp5_, (gchar) _tmp3_);
#line 647 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = sb;
#line 647 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = _tmp6_->len;
#line 647 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp7_ > ((gssize) AVI_CHUNK_MAX_STRING_TO_SECTION_LENGTH)) {
#line 5240 "VideoMetadata.c"
			GString* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp8_ = sb;
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp9_ = _tmp8_->str;
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = _tmp10_;
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 5256 "VideoMetadata.c"
		}
	}
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = sb;
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = _tmp11_->str;
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp13_ = g_strdup (_tmp12_);
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp13_;
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5271 "VideoMetadata.c"
}


static void value_avi_chunk_init (GValue* value) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 5278 "VideoMetadata.c"
}


static void value_avi_chunk_free_value (GValue* value) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_unref (value->data[0].v_pointer);
#line 5287 "VideoMetadata.c"
	}
}


static void value_avi_chunk_copy_value (const GValue* src_value, GValue* dest_value) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = avi_chunk_ref (src_value->data[0].v_pointer);
#line 5297 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5301 "VideoMetadata.c"
	}
}


static gpointer value_avi_chunk_peek_pointer (const GValue* value) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 5309 "VideoMetadata.c"
}


static gchar* value_avi_chunk_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 5316 "VideoMetadata.c"
		AVIChunk * object;
		object = collect_values[0].v_pointer;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5323 "VideoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5327 "VideoMetadata.c"
		}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = avi_chunk_ref (object);
#line 5331 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 5335 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 5339 "VideoMetadata.c"
}


static gchar* value_avi_chunk_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	AVIChunk ** object_p;
	object_p = collect_values[0].v_pointer;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!object_p) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5350 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = NULL;
#line 5356 "VideoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 5360 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = avi_chunk_ref (value->data[0].v_pointer);
#line 5364 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 5368 "VideoMetadata.c"
}


GParamSpec* param_spec_avi_chunk (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecAVIChunk* spec;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AVI_CHUNK), NULL);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 5382 "VideoMetadata.c"
}


gpointer value_get_avi_chunk (const GValue* value) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK), NULL);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 5391 "VideoMetadata.c"
}


void value_set_avi_chunk (GValue* value, gpointer v_object) {
	AVIChunk * old;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_CHUNK));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_ref (value->data[0].v_pointer);
#line 5411 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 5415 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_unref (old);
#line 5421 "VideoMetadata.c"
	}
}


void value_take_avi_chunk (GValue* value, gpointer v_object) {
	AVIChunk * old;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_CHUNK));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 5440 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 5444 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_unref (old);
#line 5450 "VideoMetadata.c"
	}
}


static void avi_chunk_class_init (AVIChunkClass * klass) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_parent_class = g_type_class_peek_parent (klass);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((AVIChunkClass *) klass)->finalize = avi_chunk_finalize;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (AVIChunkPrivate));
#line 5462 "VideoMetadata.c"
}


static void avi_chunk_instance_init (AVIChunk * self) {
	gchar* _tmp0_;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = AVI_CHUNK_GET_PRIVATE (self);
#line 535 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = NULL;
#line 536 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_strdup ("");
#line 536 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp0_;
#line 537 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 538 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 539 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = NULL;
#line 540 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->parent = NULL;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->ref_count = 1;
#line 5486 "VideoMetadata.c"
}


static void avi_chunk_finalize (AVIChunk * obj) {
	AVIChunk * self;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVI_CHUNK, AVIChunk);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 535 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 536 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 539 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 540 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_chunk_unref0 (self->priv->parent);
#line 5504 "VideoMetadata.c"
}


GType avi_chunk_get_type (void) {
	static volatile gsize avi_chunk_type_id__volatile = 0;
	if (g_once_init_enter (&avi_chunk_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_avi_chunk_init, value_avi_chunk_free_value, value_avi_chunk_copy_value, value_avi_chunk_peek_pointer, "p", value_avi_chunk_collect_value, "p", value_avi_chunk_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AVIChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avi_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AVIChunk), 0, (GInstanceInitFunc) avi_chunk_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType avi_chunk_type_id;
		avi_chunk_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AVIChunk", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&avi_chunk_type_id__volatile, avi_chunk_type_id);
	}
	return avi_chunk_type_id__volatile;
}


gpointer avi_chunk_ref (gpointer instance) {
	AVIChunk * self;
	self = instance;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return instance;
#line 5529 "VideoMetadata.c"
}


void avi_chunk_unref (gpointer instance) {
	AVIChunk * self;
	self = instance;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		AVI_CHUNK_GET_CLASS (self)->finalize (self);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5542 "VideoMetadata.c"
	}
}



