/* LibraryMonitor.c generated by valac 0.36.6, the Vala compiler
 * generated from LibraryMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/**/
/* LibraryMonitor uses DirectoryMonitor to track assets in the user's library directory and make*/
/* sure they're reflected in the application.*/
/**/
/* NOTE: There appears to be a bug where prior versions of Shotwell (<= 0.6.x) were not*/
/* properly loading the file modification timestamp during import.  This was no issue*/
/* before but becomes imperative now with file monitoring.  A "proper" algorithm is*/
/* to reimport an entire photo if the modification time in the database is different*/
/* than the file's, but that's Real Bad when the user first turns on monitoring, as it*/
/* will cause a lot of reimports (think of a 10,000 photo database) and will blow away*/
/* ALL transformations, as they are now suspect.*/
/**/
/* So: If the modification time is zero and filesize is the same, simply update the*/
/* timestamp in the database and move on.*/
/**/
/* TODO: Although it seems highly unlikely that a file's timestamp could change but the file size*/
/* has not and the file really be "changed", it *is* possible, even in the case of complex little*/
/* animals like photo files.  We could be more liberal and treat this case as a metadata-changed*/
/* situation (since that's a likely case).*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <time.h>
#include <gobject/gvaluecollector.h>


#define TYPE_LIBRARY_MONITOR_POOL (library_monitor_pool_get_type ())
#define LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPool))
#define LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))
#define IS_LIBRARY_MONITOR_POOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR_POOL))
#define IS_LIBRARY_MONITOR_POOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR_POOL))
#define LIBRARY_MONITOR_POOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolClass))

typedef struct _LibraryMonitorPool LibraryMonitorPool;
typedef struct _LibraryMonitorPoolClass LibraryMonitorPoolClass;
typedef struct _LibraryMonitorPoolPrivate LibraryMonitorPoolPrivate;

#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;

#define TYPE_LIBRARY_MONITOR (library_monitor_get_type ())
#define LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitor))
#define LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))
#define IS_LIBRARY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_MONITOR))
#define IS_LIBRARY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_MONITOR))
#define LIBRARY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_MONITOR, LibraryMonitorClass))

typedef struct _LibraryMonitor LibraryMonitor;
typedef struct _LibraryMonitorClass LibraryMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _library_monitor_pool_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_pool_unref (var), NULL)))
typedef struct _ParamSpecLibraryMonitorPool ParamSpecLibraryMonitorPool;
enum  {
	LIBRARY_MONITOR_POOL_MONITOR_INSTALLED_SIGNAL,
	LIBRARY_MONITOR_POOL_MONITOR_DESTROYED_SIGNAL,
	LIBRARY_MONITOR_POOL_LAST_SIGNAL
};
static guint library_monitor_pool_signals[LIBRARY_MONITOR_POOL_LAST_SIGNAL] = {0};
typedef struct _DirectoryMonitorPrivate DirectoryMonitorPrivate;
typedef struct _LibraryMonitorPrivate LibraryMonitorPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_BATCH_IMPORT (batch_import_get_type ())
#define BATCH_IMPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BATCH_IMPORT, BatchImport))
#define BATCH_IMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BATCH_IMPORT, BatchImportClass))
#define IS_BATCH_IMPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BATCH_IMPORT))
#define IS_BATCH_IMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BATCH_IMPORT))
#define BATCH_IMPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BATCH_IMPORT, BatchImportClass))

typedef struct _BatchImport BatchImport;
typedef struct _BatchImportClass BatchImportClass;

#define TYPE_BATCH_IMPORT_ROLL (batch_import_roll_get_type ())
#define BATCH_IMPORT_ROLL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BATCH_IMPORT_ROLL, BatchImportRoll))
#define BATCH_IMPORT_ROLL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BATCH_IMPORT_ROLL, BatchImportRollClass))
#define IS_BATCH_IMPORT_ROLL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BATCH_IMPORT_ROLL))
#define IS_BATCH_IMPORT_ROLL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BATCH_IMPORT_ROLL))
#define BATCH_IMPORT_ROLL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BATCH_IMPORT_ROLL, BatchImportRollClass))

typedef struct _BatchImportRoll BatchImportRoll;
typedef struct _BatchImportRollClass BatchImportRollClass;

#define LIBRARY_MONITOR_TYPE_VERIFY_JOB (library_monitor_verify_job_get_type ())
#define LIBRARY_MONITOR_VERIFY_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBRARY_MONITOR_TYPE_VERIFY_JOB, LibraryMonitorVerifyJob))
#define LIBRARY_MONITOR_VERIFY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBRARY_MONITOR_TYPE_VERIFY_JOB, LibraryMonitorVerifyJobClass))
#define LIBRARY_MONITOR_IS_VERIFY_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBRARY_MONITOR_TYPE_VERIFY_JOB))
#define LIBRARY_MONITOR_IS_VERIFY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBRARY_MONITOR_TYPE_VERIFY_JOB))
#define LIBRARY_MONITOR_VERIFY_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBRARY_MONITOR_TYPE_VERIFY_JOB, LibraryMonitorVerifyJobClass))

typedef struct _LibraryMonitorVerifyJob LibraryMonitorVerifyJob;
typedef struct _LibraryMonitorVerifyJobClass LibraryMonitorVerifyJobClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define TYPE_TIMED_QUEUE (timed_queue_get_type ())
#define TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMED_QUEUE, TimedQueue))
#define TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMED_QUEUE, TimedQueueClass))
#define IS_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMED_QUEUE))
#define IS_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMED_QUEUE))
#define TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMED_QUEUE, TimedQueueClass))

typedef struct _TimedQueue TimedQueue;
typedef struct _TimedQueueClass TimedQueueClass;

#define TYPE_HASH_TIMED_QUEUE (hash_timed_queue_get_type ())
#define HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueue))
#define HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))
#define IS_HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HASH_TIMED_QUEUE))
#define IS_HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HASH_TIMED_QUEUE))
#define HASH_TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))

typedef struct _HashTimedQueue HashTimedQueue;
typedef struct _HashTimedQueueClass HashTimedQueueClass;
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))
#define _batch_import_roll_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_roll_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_COLLECTION_REGISTRY (media_collection_registry_get_type ())
#define MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry))
#define MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))
#define IS_MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_COLLECTION_REGISTRY))
#define IS_MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_COLLECTION_REGISTRY))
#define MEDIA_COLLECTION_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))

typedef struct _MediaCollectionRegistry MediaCollectionRegistry;
typedef struct _MediaCollectionRegistryClass MediaCollectionRegistryClass;
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define MEDIA_MONITOR_TYPE_DISCOVERED_FILE (media_monitor_discovered_file_get_type ())

#define TYPE_TOMBSTONE_SOURCE_COLLECTION (tombstone_source_collection_get_type ())
#define TOMBSTONE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollection))
#define TOMBSTONE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollectionClass))
#define IS_TOMBSTONE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONE_SOURCE_COLLECTION))
#define IS_TOMBSTONE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONE_SOURCE_COLLECTION))
#define TOMBSTONE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONE_SOURCE_COLLECTION, TombstoneSourceCollectionClass))

typedef struct _TombstoneSourceCollection TombstoneSourceCollection;
typedef struct _TombstoneSourceCollectionClass TombstoneSourceCollectionClass;

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB (library_monitor_find_move_job_get_type ())
#define LIBRARY_MONITOR_FIND_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJob))
#define LIBRARY_MONITOR_FIND_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJobClass))
#define LIBRARY_MONITOR_IS_FIND_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB))
#define LIBRARY_MONITOR_IS_FIND_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB))
#define LIBRARY_MONITOR_FIND_MOVE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJobClass))

typedef struct _LibraryMonitorFindMoveJob LibraryMonitorFindMoveJob;
typedef struct _LibraryMonitorFindMoveJobClass LibraryMonitorFindMoveJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _LibraryMonitorAsyncDiscoveryCompletedData LibraryMonitorAsyncDiscoveryCompletedData;
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _LibraryMonitorFindMoveJobPrivate LibraryMonitorFindMoveJobPrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))
#define _library_monitor_verify_job_unref0(var) ((var == NULL) ? NULL : (var = (library_monitor_verify_job_unref (var), NULL)))
typedef struct _LibraryMonitorVerifyJobPrivate LibraryMonitorVerifyJobPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _LibraryMonitorVerifyMonitorableData LibraryMonitorVerifyMonitorableData;

#define TYPE_BATCH_IMPORT_JOB (batch_import_job_get_type ())
#define BATCH_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BATCH_IMPORT_JOB, BatchImportJob))
#define BATCH_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BATCH_IMPORT_JOB, BatchImportJobClass))
#define IS_BATCH_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BATCH_IMPORT_JOB))
#define IS_BATCH_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BATCH_IMPORT_JOB))
#define BATCH_IMPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BATCH_IMPORT_JOB, BatchImportJobClass))

typedef struct _BatchImportJob BatchImportJob;
typedef struct _BatchImportJobClass BatchImportJobClass;

#define TYPE_FILE_IMPORT_JOB (file_import_job_get_type ())
#define FILE_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_IMPORT_JOB, FileImportJob))
#define FILE_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_IMPORT_JOB, FileImportJobClass))
#define IS_FILE_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_IMPORT_JOB))
#define IS_FILE_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_IMPORT_JOB))
#define FILE_IMPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_IMPORT_JOB, FileImportJobClass))

typedef struct _FileImportJob FileImportJob;
typedef struct _FileImportJobClass FileImportJobClass;
#define _batch_import_job_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_job_unref (var), NULL)))

#define TYPE_IMPORT_MANIFEST (import_manifest_get_type ())
#define IMPORT_MANIFEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMPORT_MANIFEST, ImportManifest))
#define IMPORT_MANIFEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMPORT_MANIFEST, ImportManifestClass))
#define IS_IMPORT_MANIFEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMPORT_MANIFEST))
#define IS_IMPORT_MANIFEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMPORT_MANIFEST))
#define IMPORT_MANIFEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMPORT_MANIFEST, ImportManifestClass))

typedef struct _ImportManifest ImportManifest;
typedef struct _ImportManifestClass ImportManifestClass;
typedef struct _ImportManifestPrivate ImportManifestPrivate;

#define TYPE_BATCH_IMPORT_RESULT (batch_import_result_get_type ())
#define BATCH_IMPORT_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BATCH_IMPORT_RESULT, BatchImportResult))
#define BATCH_IMPORT_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BATCH_IMPORT_RESULT, BatchImportResultClass))
#define IS_BATCH_IMPORT_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BATCH_IMPORT_RESULT))
#define IS_BATCH_IMPORT_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BATCH_IMPORT_RESULT))
#define BATCH_IMPORT_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BATCH_IMPORT_RESULT, BatchImportResultClass))

typedef struct _BatchImportResult BatchImportResult;
typedef struct _BatchImportResultClass BatchImportResultClass;
typedef struct _BatchImportResultPrivate BatchImportResultPrivate;

#define TYPE_IMPORT_RESULT (import_result_get_type ())

#define TYPE_DUPLICATED_FILE (duplicated_file_get_type ())
#define DUPLICATED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICATED_FILE, DuplicatedFile))
#define DUPLICATED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICATED_FILE, DuplicatedFileClass))
#define IS_DUPLICATED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICATED_FILE))
#define IS_DUPLICATED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICATED_FILE))
#define DUPLICATED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICATED_FILE, DuplicatedFileClass))

typedef struct _DuplicatedFile DuplicatedFile;
typedef struct _DuplicatedFileClass DuplicatedFileClass;
#define _batch_import_result_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_result_unref (var), NULL)))

#define TYPE_TOMBSTONED_FILE (tombstoned_file_get_type ())
#define TOMBSTONED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONED_FILE, TombstonedFile))
#define TOMBSTONED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONED_FILE, TombstonedFileClass))
#define IS_TOMBSTONED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONED_FILE))
#define IS_TOMBSTONED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONED_FILE))
#define TOMBSTONED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONED_FILE, TombstonedFileClass))

typedef struct _TombstonedFile TombstonedFile;
typedef struct _TombstonedFileClass TombstonedFileClass;
#define _tombstoned_file_unref0(var) ((var == NULL) ? NULL : (var = (tombstoned_file_unref (var), NULL)))

#define TOMBSTONE_TYPE_REASON (tombstone_reason_get_type ())

#define LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB (library_monitor_runtime_find_move_job_get_type ())
#define LIBRARY_MONITOR_RUNTIME_FIND_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJob))
#define LIBRARY_MONITOR_RUNTIME_FIND_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJobClass))
#define LIBRARY_MONITOR_IS_RUNTIME_FIND_MOVE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB))
#define LIBRARY_MONITOR_IS_RUNTIME_FIND_MOVE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB))
#define LIBRARY_MONITOR_RUNTIME_FIND_MOVE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJobClass))

typedef struct _LibraryMonitorRuntimeFindMoveJob LibraryMonitorRuntimeFindMoveJob;
typedef struct _LibraryMonitorRuntimeFindMoveJobClass LibraryMonitorRuntimeFindMoveJobClass;
typedef struct _LibraryMonitorRuntimeFindMoveJobPrivate LibraryMonitorRuntimeFindMoveJobPrivate;

#define TYPE_TOMBSTONE (tombstone_get_type ())
#define TOMBSTONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOMBSTONE, Tombstone))
#define TOMBSTONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOMBSTONE, TombstoneClass))
#define IS_TOMBSTONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOMBSTONE))
#define IS_TOMBSTONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOMBSTONE))
#define TOMBSTONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOMBSTONE, TombstoneClass))

typedef struct _Tombstone Tombstone;
typedef struct _TombstoneClass TombstoneClass;

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
typedef struct _LibraryMonitorParamSpecVerifyJob LibraryMonitorParamSpecVerifyJob;
enum  {
	LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL,
	LIBRARY_MONITOR_AUTO_IMPORT_PREPARING_SIGNAL,
	LIBRARY_MONITOR_AUTO_IMPORT_PROGRESS_SIGNAL,
	LIBRARY_MONITOR_LAST_SIGNAL
};
static guint library_monitor_signals[LIBRARY_MONITOR_LAST_SIGNAL] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _LibraryMonitorPool {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LibraryMonitorPoolPrivate * priv;
};

struct _LibraryMonitorPoolClass {
	GTypeClass parent_class;
	void (*finalize) (LibraryMonitorPool *self);
};

struct _LibraryMonitorPoolPrivate {
	LibraryMonitor* monitor;
	guint timer_id;
};

struct _ParamSpecLibraryMonitorPool {
	GParamSpec parent_instance;
};

struct _DirectoryMonitor {
	GObject parent_instance;
	DirectoryMonitorPrivate * priv;
};

struct _DirectoryMonitorClass {
	GObjectClass parent_class;
	void (*notify_root_deleted) (DirectoryMonitor* self, GFile* root);
	void (*notify_root_moved) (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
	void (*notify_discovery_started) (DirectoryMonitor* self);
	void (*internal_notify_file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*internal_notify_directory_discovered) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_discovered) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_discovery_failed) (DirectoryMonitor* self, const gchar* reason);
	void (*notify_discovery_completed) (DirectoryMonitor* self);
	void (*notify_file_created) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_moved) (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	void (*notify_file_altered) (DirectoryMonitor* self, GFile* file);
	void (*notify_file_alteration_completed) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_attributes_altered) (DirectoryMonitor* self, GFile* file);
	void (*notify_file_deleted) (DirectoryMonitor* self, GFile* file);
	void (*notify_directory_created) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_moved) (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
	void (*notify_directory_altered) (DirectoryMonitor* self, GFile* dir);
	void (*notify_directory_alteration_completed) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_attributes_altered) (DirectoryMonitor* self, GFile* dir);
	void (*notify_directory_deleted) (DirectoryMonitor* self, GFile* dir);
	void (*notify_closed) (DirectoryMonitor* self);
	void (*close) (DirectoryMonitor* self);
	void (*root_moved) (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
	void (*root_deleted) (DirectoryMonitor* self, GFile* root);
	void (*discovery_started) (DirectoryMonitor* self);
	void (*file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*directory_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*discovery_failed) (DirectoryMonitor* self, const gchar* reason);
	void (*discovery_completed) (DirectoryMonitor* self);
	void (*file_created) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*file_moved) (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	void (*file_altered) (DirectoryMonitor* self, GFile* file);
	void (*file_alteration_completed) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*file_attributes_altered) (DirectoryMonitor* self, GFile* file);
	void (*file_deleted) (DirectoryMonitor* self, GFile* file);
	void (*directory_created) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*directory_moved) (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
	void (*directory_altered) (DirectoryMonitor* self, GFile* dir);
	void (*directory_alteration_completed) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*directory_attributes_altered) (DirectoryMonitor* self, GFile* dir);
	void (*directory_deleted) (DirectoryMonitor* self, GFile* dir);
	void (*closed) (DirectoryMonitor* self);
};

struct _LibraryMonitor {
	DirectoryMonitor parent_instance;
	LibraryMonitorPrivate * priv;
};

struct _LibraryMonitorClass {
	DirectoryMonitorClass parent_class;
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _LibraryMonitorPrivate {
	Workers* workers;
	GCancellable* cancellable;
	gboolean auto_import;
	GeeHashSet* unknown_files;
	GeeList* monitors;
	GeeHashMap* discovered;
	GeeHashSet* import_queue;
	GeeHashSet* pending_imports;
	GeeArrayList* batch_import_queue;
	BatchImportRoll* current_import_roll;
	time_t last_import_roll_use;
	BatchImport* current_batch_import;
	gint checksums_completed;
	gint checksums_total;
	guint import_queue_timer_id;
	GeeQueue* verify_queue;
	gint outstanding_verify_jobs;
	gint completed_monitorable_verifies;
	gint total_monitorable_verifies;
};

typedef void (*DequeuedCallback) (gconstpointer item, void* user_data);
typedef enum  {
	MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED,
	MEDIA_MONITOR_DISCOVERED_FILE_IGNORE,
	MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN
} MediaMonitorDiscoveredFile;

struct _LibraryMonitorAsyncDiscoveryCompletedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	LibraryMonitor* self;
	GeeHashSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* all_candidates;
	GeeArrayList* _tmp3_;
	GeeArrayList* adopted;
	GeeArrayList* _tmp4_;
	GeeIterator* _file_it;
	GeeHashSet* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	gboolean _tmp8_;
	GFile* file;
	GeeIterator* _tmp9_;
	gpointer _tmp10_;
	GFileInfo* info;
	GFile* _tmp11_;
	GFileInfo* _tmp12_;
	GFileInfo* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeCollection* candidates;
	gboolean associated;
	GeeList* _monitor_list;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	gint _monitor_size;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _monitor_index;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	MediaMonitor* monitor;
	GeeList* _tmp23_;
	gint _tmp24_;
	gpointer _tmp25_;
	MediaMonitorDiscoveredFile _result_;
	MediaMonitor* _tmp26_;
	GFile* _tmp27_;
	GFileInfo* _tmp28_;
	MediaMonitorDiscoveredFile _tmp29_;
	GeeCollection* _tmp30_;
	gboolean _tmp31_;
	MediaMonitorDiscoveredFile _tmp32_;
	MediaMonitorDiscoveredFile _tmp33_;
	GeeCollection* _tmp34_;
	GeeArrayList* _tmp35_;
	GeeCollection* _tmp36_;
	gboolean _tmp37_;
	GeeArrayList* _tmp38_;
	GFile* _tmp39_;
	GeeArrayList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GeeArrayList* job_candidates;
	GeeArrayList* _tmp43_;
	GeeArrayList* _tmp44_;
	GeeArrayList* _tmp45_;
	gint _tmp46_;
	Workers* _tmp47_;
	GFile* _tmp48_;
	GeeArrayList* _tmp49_;
	LibraryMonitorFindMoveJob* _tmp50_;
	LibraryMonitorFindMoveJob* _tmp51_;
	GeeHashSet* _tmp52_;
	GeeArrayList* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
};

typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _LibraryMonitorFindMoveJob {
	BackgroundJob parent_instance;
	LibraryMonitorFindMoveJobPrivate * priv;
	GFile* file;
	GeeCollection* candidates;
	Monitorable* match;
	GeeArrayList* losers;
	GError* err;
};

struct _LibraryMonitorFindMoveJobClass {
	BackgroundJobClass parent_class;
};

struct _LibraryMonitorVerifyJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LibraryMonitorVerifyJobPrivate * priv;
	Monitorable* monitorable;
	MediaMonitor* monitor;
};

struct _LibraryMonitorVerifyJobClass {
	GTypeClass parent_class;
	void (*finalize) (LibraryMonitorVerifyJob *self);
};

struct _LibraryMonitorVerifyMonitorableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	LibraryMonitor* self;
	Monitorable* monitorable;
	MediaMonitor* monitor;
	GFile** files;
	GFile** _tmp0_;
	gint files_length1;
	gint _files_size_;
	GFile** _tmp1_;
	gint _tmp1__length1;
	MediaMonitor* _tmp2_;
	Monitorable* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile** aux_files;
	MediaMonitor* _tmp6_;
	Monitorable* _tmp7_;
	gint _tmp8_;
	GFile** _tmp9_;
	gint aux_files_length1;
	gint _aux_files_size_;
	GFile** _tmp10_;
	gint _tmp10__length1;
	GFile** _tmp11_;
	gint _tmp11__length1;
	GFile** aux_file_collection;
	gint aux_file_collection_length1;
	gint _aux_file_collection_size_;
	gint aux_file_it;
	GFile* _tmp12_;
	GFile* aux_file;
	GFile** _tmp13_;
	gint _tmp13__length1;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gint ctr;
	gboolean _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GFile** _tmp19_;
	gint _tmp19__length1;
	GFile* file;
	GFile** _tmp20_;
	gint _tmp20__length1;
	gint _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GFileInfo* info;
	GFile* _tmp24_;
	GFileInfo* _tmp25_;
	GFileInfo* _tmp26_;
	GFileInfo* _tmp27_;
	GFile* _tmp28_;
	GCancellable* _tmp29_;
	GFileInfo* _tmp30_;
	GFileInfo* _tmp31_;
	GError* err;
	gint _tmp32_;
	gboolean _tmp33_;
	GFileInfo* _tmp34_;
	MediaMonitor* _tmp35_;
	Monitorable* _tmp36_;
	gboolean _tmp37_;
	MediaMonitor* _tmp38_;
	Monitorable* _tmp39_;
	gboolean _tmp40_;
	GFileInfo* _tmp41_;
	MediaMonitor* _tmp42_;
	Monitorable* _tmp43_;
	gboolean _tmp44_;
	MediaMonitor* _tmp45_;
	Monitorable* _tmp46_;
	MediaMonitor* _tmp47_;
	Monitorable* _tmp48_;
	GFile* _tmp49_;
	GFileInfo* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	GError * _inner_error_;
};

typedef void (*BatchImportImportReporter) (ImportManifest* manifest, BatchImportRoll* import_roll, void* user_data);
struct _ImportManifest {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ImportManifestPrivate * priv;
	GeeList* imported;
	GeeList* success;
	GeeList* camera_failed;
	GeeList* failed;
	GeeList* write_failed;
	GeeList* skipped_photos;
	GeeList* skipped_files;
	GeeList* aborted;
	GeeList* already_imported;
	GeeList* corrupt_files;
	GeeList* all;
};

struct _ImportManifestClass {
	GTypeClass parent_class;
	void (*finalize) (ImportManifest *self);
};

typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

struct _BatchImportResult {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BatchImportResultPrivate * priv;
	BatchImportJob* job;
	GFile* file;
	gchar* src_identifier;
	gchar* dest_identifier;
	ImportResult result;
	gchar* errmsg;
	DuplicatedFile* duplicate_of;
};

struct _BatchImportResultClass {
	GTypeClass parent_class;
	void (*finalize) (BatchImportResult *self);
};

typedef enum  {
	TOMBSTONE_REASON_REMOVED_BY_USER = 0,
	TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE = 1
} TombstoneReason;

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _LibraryMonitorRuntimeFindMoveJob {
	BackgroundJob parent_instance;
	LibraryMonitorRuntimeFindMoveJobPrivate * priv;
	GFile* file;
	GeeCollection* candidates;
	Monitorable* match;
	GError* err;
};

struct _LibraryMonitorRuntimeFindMoveJobClass {
	BackgroundJobClass parent_class;
};

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);
struct _LibraryMonitorParamSpecVerifyJob {
	GParamSpec parent_instance;
};


static gpointer library_monitor_pool_parent_class = NULL;
static LibraryMonitorPool* library_monitor_pool_instance;
static LibraryMonitorPool* library_monitor_pool_instance = NULL;
static gpointer library_monitor_parent_class = NULL;
static GeeHashSet* library_monitor_blacklist;
static GRecMutex __lock_library_monitor_blacklist = {0};
static GeeHashSet* library_monitor_blacklist = NULL;
static HashTimedQueue* library_monitor_to_unblacklist;
static HashTimedQueue* library_monitor_to_unblacklist = NULL;
extern TombstoneSourceCollection* tombstone_global;
extern gboolean commandline_options_no_runtime_monitoring;
static gpointer library_monitor_find_move_job_parent_class = NULL;
static gpointer library_monitor_runtime_find_move_job_parent_class = NULL;
static gpointer library_monitor_verify_job_parent_class = NULL;

gpointer library_monitor_pool_ref (gpointer instance);
void library_monitor_pool_unref (gpointer instance);
GParamSpec* param_spec_library_monitor_pool (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_library_monitor_pool (GValue* value, gpointer v_object);
void value_take_library_monitor_pool (GValue* value, gpointer v_object);
gpointer value_get_library_monitor_pool (const GValue* value);
GType library_monitor_pool_get_type (void) G_GNUC_CONST;
GType directory_monitor_get_type (void) G_GNUC_CONST;
GType library_monitor_get_type (void) G_GNUC_CONST;
#define LIBRARY_MONITOR_POOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPoolPrivate))
enum  {
	LIBRARY_MONITOR_POOL_DUMMY_PROPERTY
};
static LibraryMonitorPool* library_monitor_pool_new (void);
static LibraryMonitorPool* library_monitor_pool_construct (GType object_type);
void library_monitor_pool_init (void);
void library_monitor_pool_terminate (void);
static void library_monitor_pool_close (LibraryMonitorPool* self);
LibraryMonitorPool* library_monitor_pool_get_instance (void);
LibraryMonitor* library_monitor_pool_get_monitor (LibraryMonitorPool* self);
void library_monitor_pool_replace (LibraryMonitorPool* self, LibraryMonitor* replacement, gint start_msec_delay);
static gboolean library_monitor_pool_on_start_monitor (LibraryMonitorPool* self);
static gboolean _library_monitor_pool_on_start_monitor_gsource_func (gpointer self);
void directory_monitor_close (DirectoryMonitor* self);
void directory_monitor_start_discovery (DirectoryMonitor* self);
static void library_monitor_pool_finalize (LibraryMonitorPool * obj);
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType media_monitor_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
GType batch_import_get_type (void) G_GNUC_CONST;
gpointer batch_import_roll_ref (gpointer instance);
void batch_import_roll_unref (gpointer instance);
GParamSpec* param_spec_batch_import_roll (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_batch_import_roll (GValue* value, gpointer v_object);
void value_take_batch_import_roll (GValue* value, gpointer v_object);
gpointer value_get_batch_import_roll (const GValue* value);
GType batch_import_roll_get_type (void) G_GNUC_CONST;
static gpointer library_monitor_verify_job_ref (gpointer instance);
static void library_monitor_verify_job_unref (gpointer instance);
static GParamSpec* library_monitor_param_spec_verify_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void library_monitor_value_set_verify_job (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void library_monitor_value_take_verify_job (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer library_monitor_value_get_verify_job (const GValue* value) G_GNUC_UNUSED;
static GType library_monitor_verify_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define LIBRARY_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIBRARY_MONITOR, LibraryMonitorPrivate))
enum  {
	LIBRARY_MONITOR_DUMMY_PROPERTY
};
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
static void library_monitor_on_config_changed (LibraryMonitor* self);
static void _library_monitor_on_config_changed_configuration_facade_auto_import_from_library_changed (ConfigurationFacade* _sender, gpointer self);
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
gboolean file_equal (GFile* a, GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gpointer timed_queue_ref (gpointer instance);
void timed_queue_unref (gpointer instance);
GParamSpec* param_spec_timed_queue (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_timed_queue (GValue* value, gpointer v_object);
void value_take_timed_queue (GValue* value, gpointer v_object);
gpointer value_get_timed_queue (const GValue* value);
GType timed_queue_get_type (void) G_GNUC_CONST;
GType hash_timed_queue_get_type (void) G_GNUC_CONST;
#define LIBRARY_MONITOR_MIN_BLACKLIST_DURATION_MSEC (5 * 1000)
static void library_monitor_on_unblacklist_file (GFile* file);
static void _library_monitor_on_unblacklist_file_dequeued_callback (gconstpointer item, gpointer self);
HashTimedQueue* hash_timed_queue_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority);
HashTimedQueue* hash_timed_queue_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, guint hold_msec, DequeuedCallback callback, void* callback_target, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify, gint priority);
guint workers_thread_per_cpu_minus_one (void);
Workers* workers_new (guint max_threads, gboolean exclusive);
Workers* workers_construct (GType object_type, guint max_threads, gboolean exclusive);
#define LIBRARY_MONITOR_FLUSH_IMPORT_QUEUE_SEC 3
#define LIBRARY_MONITOR_IMPORT_ROLL_QUIET_SEC (5 * 60)
#define LIBRARY_MONITOR_MAX_VERIFY_EXISTING_MEDIA_JOBS 5
LibraryMonitor* library_monitor_new (GFile* root, gboolean recurse, gboolean monitoring);
LibraryMonitor* library_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring);
DirectoryMonitor* directory_monitor_new (GFile* root, gboolean recurse, gboolean monitoring);
DirectoryMonitor* directory_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring);
gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self);
static gboolean library_monitor_on_flush_import_queue (LibraryMonitor* self);
static gboolean _library_monitor_on_flush_import_queue_gsource_func (gpointer self);
static void library_monitor_real_close (DirectoryMonitor* base);
void media_monitor_close (MediaMonitor* self);
static void library_monitor_add_to_discovered_list (LibraryMonitor* self, MediaMonitor* monitor, Monitorable* monitorable);
static MediaMonitor* library_monitor_get_monitor_for_monitorable (LibraryMonitor* self, Monitorable* monitorable);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
MediaSourceCollection* media_monitor_get_media_source_collection (MediaMonitor* self);
gboolean source_collection_holds_type_of_source (SourceCollection* self, DataSource* source);
gchar* data_object_to_string (DataObject* self);
static void library_monitor_real_discovery_started (DirectoryMonitor* base);
gpointer media_collection_registry_ref (gpointer instance);
void media_collection_registry_unref (gpointer instance);
GParamSpec* param_spec_media_collection_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_collection_registry (GValue* value, gpointer v_object);
void value_take_media_collection_registry (GValue* value, gpointer v_object);
gpointer value_get_media_collection_registry (const GValue* value);
GType media_collection_registry_get_type (void) G_GNUC_CONST;
MediaCollectionRegistry* media_collection_registry_get_instance (void);
GeeCollection* media_collection_registry_get_all (MediaCollectionRegistry* self);
MediaMonitor* media_source_collection_create_media_monitor (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
void media_monitor_notify_discovery_started (MediaMonitor* self);
static void library_monitor_real_file_discovered (DirectoryMonitor* base, GFile* file, GFileInfo* info);
GType media_monitor_discovered_file_get_type (void) G_GNUC_CONST;
MediaMonitorDiscoveredFile media_monitor_notify_file_discovered (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable* * monitorable);
GType tombstone_source_collection_get_type (void) G_GNUC_CONST;
gboolean tombstone_source_collection_matches (TombstoneSourceCollection* self, GFile* file);
static gboolean library_monitor_is_supported_filetype (LibraryMonitor* self, GFile* file);
static void library_monitor_real_discovery_completed (DirectoryMonitor* base);
static void library_monitor_async_discovery_completed (LibraryMonitor* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void library_monitor_async_discovery_completed_finish (LibraryMonitor* self, GAsyncResult* _res_);
static void library_monitor_async_discovery_completed_data_free (gpointer _data);
static void library_monitor_async_discovery_completed_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean library_monitor_async_discovery_completed_co (LibraryMonitorAsyncDiscoveryCompletedData* _data_);
static void library_monitor_discovery_stage_completed (LibraryMonitor* self);
GFileInfo* directory_monitor_get_file_info (DirectoryMonitor* self, GFile* file);
GeeCollection* media_monitor_candidates_for_unknown_file (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background_job (GValue* value, gpointer v_object);
void value_take_background_job (GValue* value, gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
void workers_enqueue (Workers* self, BackgroundJob* job);
static LibraryMonitorFindMoveJob* library_monitor_find_move_job_new (LibraryMonitor* owner, GFile* file, GeeCollection* candidates);
static LibraryMonitorFindMoveJob* library_monitor_find_move_job_construct (GType object_type, LibraryMonitor* owner, GFile* file, GeeCollection* candidates);
static GType library_monitor_find_move_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean _library_monitor_async_discovery_completed_co_gsource_func (gpointer self);
void directory_monitor_mdbg (const gchar* msg);
static void library_monitor_report_checksum_job_completed (LibraryMonitor* self);
static void library_monitor_on_find_move_completed (LibraryMonitor* self, BackgroundJob* j);
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
void media_monitor_update_master_file (MediaMonitor* self, Monitorable* monitorable, GFile* file);
static void library_monitor_on_find_move_cancelled (LibraryMonitor* self, BackgroundJob* j);
static void library_monitor_enqueue_verify_monitorable (LibraryMonitor* self, Monitorable* monitorable, MediaMonitor* monitor);
GeeCollection* data_collection_get_all (DataCollection* self);
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
GType media_source_holding_tank_get_type (void) G_GNUC_CONST;
MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
GeeCollection* source_holding_tank_get_all (SourceHoldingTank* self);
static void library_monitor_enqueue_import_many (LibraryMonitor* self, GeeCollection* files);
void tombstone_source_collection_launch_scan (TombstoneSourceCollection* self, DirectoryMonitor* monitor, GCancellable* cancellable);
static LibraryMonitorVerifyJob* library_monitor_verify_job_new (Monitorable* monitorable, MediaMonitor* monitor);
static LibraryMonitorVerifyJob* library_monitor_verify_job_construct (GType object_type, Monitorable* monitorable, MediaMonitor* monitor);
static void library_monitor_execute_next_verify_job (LibraryMonitor* self);
static void library_monitor_verify_monitorable (LibraryMonitor* self, Monitorable* monitorable, MediaMonitor* monitor, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void library_monitor_verify_monitorable_finish (LibraryMonitor* self, GAsyncResult* _res_);
static void library_monitor_verify_monitorable_data_free (gpointer _data);
static void library_monitor_verify_monitorable_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static gboolean library_monitor_verify_monitorable_co (LibraryMonitorVerifyMonitorableData* _data_);
GFile* media_monitor_get_master_file (MediaMonitor* self, Monitorable* monitorable);
GFile** media_monitor_get_auxilliary_backing_files (MediaMonitor* self, Monitorable* monitorable, int* result_length1);
static void _vala_array_add130 (GFile** * array, int* length, int* size, GFile* value);
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
#define DIRECTORY_MONITOR_FILE_INFO_FLAGS G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS
#define DIRECTORY_MONITOR_DEFAULT_PRIORITY G_PRIORITY_LOW
static void library_monitor_verify_monitorable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean media_monitor_is_offline (MediaMonitor* self, Monitorable* monitorable);
void media_monitor_update_online (MediaMonitor* self, Monitorable* monitorable);
void media_monitor_update_offline (MediaMonitor* self, Monitorable* monitorable);
void media_monitor_update_backing_file_info (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
static gboolean _library_monitor_verify_monitorable_co_gsource_func (gpointer self);
static void library_monitor_import_unrepresented_files (LibraryMonitor* self);
static void library_monitor_cancel_batch_imports (LibraryMonitor* self);
static void library_monitor_enqueue_import (LibraryMonitor* self, GFile* file);
gboolean library_monitor_is_blacklisted (GFile* file);
static void library_monitor_remove_queued_import (LibraryMonitor* self, GFile* file);
gulong now_sec (void);
BatchImportRoll* batch_import_roll_new (void);
BatchImportRoll* batch_import_roll_construct (GType object_type);
gpointer batch_import_job_ref (gpointer instance);
void batch_import_job_unref (gpointer instance);
GParamSpec* param_spec_batch_import_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_batch_import_job (GValue* value, gpointer v_object);
void value_take_batch_import_job (GValue* value, gpointer v_object);
gpointer value_get_batch_import_job (const GValue* value);
GType batch_import_job_get_type (void) G_GNUC_CONST;
FileImportJob* file_import_job_new (GFile* file_or_dir, gboolean copy_to_library);
FileImportJob* file_import_job_construct (GType object_type, GFile* file_or_dir, gboolean copy_to_library);
GType file_import_job_get_type (void) G_GNUC_CONST;
gpointer import_manifest_ref (gpointer instance);
void import_manifest_unref (gpointer instance);
GParamSpec* param_spec_import_manifest (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_import_manifest (GValue* value, gpointer v_object);
void value_take_import_manifest (GValue* value, gpointer v_object);
gpointer value_get_import_manifest (const GValue* value);
GType import_manifest_get_type (void) G_GNUC_CONST;
BatchImport* batch_import_new (GeeIterable* jobs, const gchar* name, BatchImportImportReporter reporter, void* reporter_target, GeeArrayList* prefailed, GeeArrayList* pre_already_imported, GCancellable* cancellable, BatchImportRoll* import_roll, ImportManifest* skip_manifest);
BatchImport* batch_import_construct (GType object_type, GeeIterable* jobs, const gchar* name, BatchImportImportReporter reporter, void* reporter_target, GeeArrayList* prefailed, GeeArrayList* pre_already_imported, GCancellable* cancellable, BatchImportRoll* import_roll, ImportManifest* skip_manifest);
void batch_import_set_untrash_duplicates (BatchImport* self, gboolean untrash_duplicates);
void batch_import_set_mark_duplicates_online (BatchImport* self, gboolean mark_duplicates_online);
static void library_monitor_schedule_next_batch_import (LibraryMonitor* self);
static void library_monitor_on_import_preparing (LibraryMonitor* self);
static void _library_monitor_on_import_preparing_batch_import_preparing (BatchImport* _sender, gpointer self);
static void library_monitor_on_import_progress (LibraryMonitor* self, guint64 completed_bytes, guint64 total_bytes);
static void _library_monitor_on_import_progress_batch_import_progress (BatchImport* _sender, guint64 completed_bytes, guint64 total_bytes, gpointer self);
static void library_monitor_on_import_complete (LibraryMonitor* self, BatchImport* batch_import, ImportManifest* manifest, BatchImportRoll* import_roll);
static void _library_monitor_on_import_complete_batch_import_import_complete (BatchImport* _sender, ImportManifest* manifest, BatchImportRoll* import_roll, gpointer self);
void batch_import_schedule (BatchImport* self);
static void library_monitor_discard_current_batch_import (LibraryMonitor* self);
void batch_import_user_halt (BatchImport* self);
gpointer batch_import_result_ref (gpointer instance);
void batch_import_result_unref (gpointer instance);
GParamSpec* param_spec_batch_import_result (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_batch_import_result (GValue* value, gpointer v_object);
void value_take_batch_import_result (GValue* value, gpointer v_object);
gpointer value_get_batch_import_result (const GValue* value);
GType batch_import_result_get_type (void) G_GNUC_CONST;
GType import_result_get_type (void) G_GNUC_CONST;
GType duplicated_file_get_type (void) G_GNUC_CONST;
gpointer tombstoned_file_ref (gpointer instance);
void tombstoned_file_unref (gpointer instance);
GParamSpec* param_spec_tombstoned_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tombstoned_file (GValue* value, gpointer v_object);
void value_take_tombstoned_file (GValue* value, gpointer v_object);
gpointer value_get_tombstoned_file (const GValue* value);
GType tombstoned_file_get_type (void) G_GNUC_CONST;
TombstonedFile* tombstoned_file_new (GFile* file, gint64 filesize, const gchar* md5);
TombstonedFile* tombstoned_file_construct (GType object_type, GFile* file, gint64 filesize, const gchar* md5);
GType tombstone_reason_get_type (void) G_GNUC_CONST;
GQuark database_error_quark (void);
void tombstone_entomb_many_files (GeeCollection* files, TombstoneReason reason, GError** error);
void app_window_database_error (GError* err);
void library_monitor_blacklist_file (GFile* file, const gchar* reason);
void library_monitor_unblacklist_file (GFile* file);
gboolean timed_queue_contains (TimedQueue* self, gconstpointer item);
gboolean timed_queue_enqueue (TimedQueue* self, gconstpointer item);
MediaSourceCollection* media_collection_registry_get_collection_for_file (MediaCollectionRegistry* self, GFile* file);
GeeCollection* directory_monitor_get_files (DirectoryMonitor* self);
gboolean media_monitor_is_file_represented (MediaMonitor* self, GFile* file);
static void library_monitor_runtime_unknown_file_discovered (LibraryMonitor* self, GFile* file);
static void library_monitor_real_notify_file_created (DirectoryMonitor* base, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
gboolean media_monitor_notify_file_created (MediaMonitor* self, GFile* file, GFileInfo* info);
gchar* media_monitor_to_string (MediaMonitor* self);
const gchar* media_monitor_discovered_file_to_string (MediaMonitorDiscoveredFile self);
static LibraryMonitorRuntimeFindMoveJob* library_monitor_runtime_find_move_job_new (LibraryMonitor* owner, GFile* file, GeeCollection* candidates);
static LibraryMonitorRuntimeFindMoveJob* library_monitor_runtime_find_move_job_construct (GType object_type, LibraryMonitor* owner, GFile* file, GeeCollection* candidates);
static GType library_monitor_runtime_find_move_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void library_monitor_on_runtime_find_move_completed (LibraryMonitor* self, BackgroundJob* j);
static void library_monitor_real_notify_file_moved (DirectoryMonitor* base, GFile* old_file, GFile* new_file, GFileInfo* new_info);
void directory_monitor_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
gboolean media_monitor_notify_file_moved (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
static void library_monitor_real_notify_file_altered (DirectoryMonitor* base, GFile* file);
void directory_monitor_notify_file_altered (DirectoryMonitor* self, GFile* file);
gboolean media_monitor_notify_file_altered (MediaMonitor* self, GFile* file);
static void library_monitor_real_notify_file_attributes_altered (DirectoryMonitor* base, GFile* file);
void directory_monitor_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file);
gboolean media_monitor_notify_file_attributes_altered (MediaMonitor* self, GFile* file);
static void library_monitor_real_notify_file_alteration_completed (DirectoryMonitor* base, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
gboolean media_monitor_notify_file_alteration_completed (MediaMonitor* self, GFile* file, GFileInfo* info);
static void library_monitor_real_notify_file_deleted (DirectoryMonitor* base, GFile* file);
void directory_monitor_notify_file_deleted (DirectoryMonitor* self, GFile* file);
gboolean media_monitor_notify_file_deleted (MediaMonitor* self, GFile* file);
GType tombstone_get_type (void) G_GNUC_CONST;
Tombstone* tombstone_source_collection_locate (TombstoneSourceCollection* self, GFile* file);
void tombstone_source_collection_resurrect (TombstoneSourceCollection* self, Tombstone* tombstone);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT64_UINT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
enum  {
	LIBRARY_MONITOR_FIND_MOVE_JOB_DUMMY_PROPERTY
};
static void _library_monitor_on_find_move_completed_completion_callback (BackgroundJob* job, gpointer self);
static void _library_monitor_on_find_move_cancelled_cancellation_callback (BackgroundJob* job, gpointer self);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_abstract_semaphore (GValue* value, gpointer v_object);
void value_take_abstract_semaphore (GValue* value, gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type, GObject* owner, CompletionCallback callback, void* callback_target, GCancellable* cancellable, CancellationCallback cancellation, void* cancellation_target, AbstractSemaphore* completion_semaphore);
void background_job_set_completion_priority (BackgroundJob* self, gint priority);
static void library_monitor_find_move_job_real_execute (BackgroundJob* base);
GFile* media_source_get_master_file (MediaSource* self);
gchar* md5_file (GFile* file, GError** error);
gchar* media_source_get_master_md5 (MediaSource* self);
static void library_monitor_find_move_job_finalize (BackgroundJob * obj);
enum  {
	LIBRARY_MONITOR_RUNTIME_FIND_MOVE_JOB_DUMMY_PROPERTY
};
static void _library_monitor_on_runtime_find_move_completed_completion_callback (BackgroundJob* job, gpointer self);
static void library_monitor_runtime_find_move_job_real_execute (BackgroundJob* base);
static void library_monitor_runtime_find_move_job_finalize (BackgroundJob * obj);
enum  {
	LIBRARY_MONITOR_VERIFY_JOB_DUMMY_PROPERTY
};
static void library_monitor_verify_job_finalize (LibraryMonitorVerifyJob * obj);
static void library_monitor_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static LibraryMonitorPool* library_monitor_pool_construct (GType object_type) {
	LibraryMonitorPool* self = NULL;
#line 38 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = (LibraryMonitorPool*) g_type_create_instance (object_type);
#line 38 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self;
#line 1237 "LibraryMonitor.c"
}


static LibraryMonitorPool* library_monitor_pool_new (void) {
#line 38 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return library_monitor_pool_construct (TYPE_LIBRARY_MONITOR_POOL);
#line 1244 "LibraryMonitor.c"
}


void library_monitor_pool_init (void) {
}


void library_monitor_pool_terminate (void) {
	LibraryMonitorPool* _tmp0_;
#line 45 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = library_monitor_pool_instance;
#line 45 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_ != NULL) {
#line 1258 "LibraryMonitor.c"
		LibraryMonitorPool* _tmp1_;
#line 46 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = library_monitor_pool_instance;
#line 46 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_pool_close (_tmp1_);
#line 1264 "LibraryMonitor.c"
	}
#line 48 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_library_monitor_pool_unref0 (library_monitor_pool_instance);
#line 48 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_pool_instance = NULL;
#line 1270 "LibraryMonitor.c"
}


static gpointer _library_monitor_pool_ref0 (gpointer self) {
#line 55 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self ? library_monitor_pool_ref (self) : NULL;
#line 1277 "LibraryMonitor.c"
}


LibraryMonitorPool* library_monitor_pool_get_instance (void) {
	LibraryMonitorPool* result = NULL;
	LibraryMonitorPool* _tmp0_;
	LibraryMonitorPool* _tmp2_;
	LibraryMonitorPool* _tmp3_;
#line 52 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = library_monitor_pool_instance;
#line 52 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_ == NULL) {
#line 1290 "LibraryMonitor.c"
		LibraryMonitorPool* _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = library_monitor_pool_new ();
#line 53 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_library_monitor_pool_unref0 (library_monitor_pool_instance);
#line 53 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_pool_instance = _tmp1_;
#line 1298 "LibraryMonitor.c"
	}
#line 55 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = library_monitor_pool_instance;
#line 55 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _library_monitor_pool_ref0 (_tmp2_);
#line 55 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	result = _tmp3_;
#line 55 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 1308 "LibraryMonitor.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 59 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 1315 "LibraryMonitor.c"
}


LibraryMonitor* library_monitor_pool_get_monitor (LibraryMonitorPool* self) {
	LibraryMonitor* result = NULL;
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
#line 58 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_MONITOR_POOL (self), NULL);
#line 59 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->monitor;
#line 59 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 59 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	result = _tmp1_;
#line 59 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 1333 "LibraryMonitor.c"
}


static gboolean _library_monitor_pool_on_start_monitor_gsource_func (gpointer self) {
	gboolean result;
	result = library_monitor_pool_on_start_monitor ((LibraryMonitorPool*) self);
#line 68 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 1342 "LibraryMonitor.c"
}


void library_monitor_pool_replace (LibraryMonitorPool* self, LibraryMonitor* replacement, gint start_msec_delay) {
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	LibraryMonitor* _tmp7_;
#line 63 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR_POOL (self));
#line 63 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (replacement));
#line 64 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_pool_close (self);
#line 66 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = replacement;
#line 66 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 66 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->monitor);
#line 66 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->monitor = _tmp1_;
#line 67 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = start_msec_delay;
#line 67 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp3_ > 0) {
#line 1370 "LibraryMonitor.c"
		guint _tmp4_;
#line 67 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = self->priv->timer_id;
#line 67 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = _tmp4_ == ((guint) 0);
#line 1376 "LibraryMonitor.c"
	} else {
#line 67 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = FALSE;
#line 1380 "LibraryMonitor.c"
	}
#line 67 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp2_) {
#line 1384 "LibraryMonitor.c"
		gint _tmp5_;
		guint _tmp6_;
#line 68 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = start_msec_delay;
#line 68 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp5_, _library_monitor_pool_on_start_monitor_gsource_func, library_monitor_pool_ref (self), library_monitor_pool_unref);
#line 68 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		self->priv->timer_id = _tmp6_;
#line 1393 "LibraryMonitor.c"
	}
#line 70 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = self->priv->monitor;
#line 70 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_emit (self, library_monitor_pool_signals[LIBRARY_MONITOR_POOL_MONITOR_INSTALLED_SIGNAL], 0, _tmp7_);
#line 1399 "LibraryMonitor.c"
}


static void library_monitor_pool_close (LibraryMonitorPool* self) {
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
	LibraryMonitor* closed = NULL;
	LibraryMonitor* _tmp2_;
	LibraryMonitor* _tmp3_;
	LibraryMonitor* _tmp4_;
#line 73 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR_POOL (self));
#line 74 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->monitor;
#line 74 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_ == NULL) {
#line 75 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 1418 "LibraryMonitor.c"
	}
#line 77 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = self->priv->monitor;
#line 77 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	directory_monitor_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
#line 78 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = self->priv->monitor;
#line 78 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 78 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	closed = _tmp3_;
#line 79 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->monitor);
#line 79 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->monitor = NULL;
#line 81 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = closed;
#line 81 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_emit (self, library_monitor_pool_signals[LIBRARY_MONITOR_POOL_MONITOR_DESTROYED_SIGNAL], 0, _tmp4_);
#line 73 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (closed);
#line 1440 "LibraryMonitor.c"
}


static gboolean library_monitor_pool_on_start_monitor (LibraryMonitorPool* self) {
	gboolean result = FALSE;
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
#line 84 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_MONITOR_POOL (self), FALSE);
#line 86 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->timer_id = (guint) 0;
#line 88 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->monitor;
#line 88 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_ == NULL) {
#line 89 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		result = FALSE;
#line 89 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return result;
#line 1460 "LibraryMonitor.c"
	}
#line 91 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = self->priv->monitor;
#line 91 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	directory_monitor_start_discovery (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
#line 93 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	result = FALSE;
#line 93 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 1470 "LibraryMonitor.c"
}


static void value_library_monitor_pool_init (GValue* value) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	value->data[0].v_pointer = NULL;
#line 1477 "LibraryMonitor.c"
}


static void value_library_monitor_pool_free_value (GValue* value) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (value->data[0].v_pointer) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_pool_unref (value->data[0].v_pointer);
#line 1486 "LibraryMonitor.c"
	}
}


static void value_library_monitor_pool_copy_value (const GValue* src_value, GValue* dest_value) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (src_value->data[0].v_pointer) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		dest_value->data[0].v_pointer = library_monitor_pool_ref (src_value->data[0].v_pointer);
#line 1496 "LibraryMonitor.c"
	} else {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1500 "LibraryMonitor.c"
	}
}


static gpointer value_library_monitor_pool_peek_pointer (const GValue* value) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return value->data[0].v_pointer;
#line 1508 "LibraryMonitor.c"
}


static gchar* value_library_monitor_pool_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (collect_values[0].v_pointer) {
#line 1515 "LibraryMonitor.c"
		LibraryMonitorPool * object;
		object = collect_values[0].v_pointer;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1522 "LibraryMonitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1526 "LibraryMonitor.c"
		}
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = library_monitor_pool_ref (object);
#line 1530 "LibraryMonitor.c"
	} else {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 1534 "LibraryMonitor.c"
	}
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return NULL;
#line 1538 "LibraryMonitor.c"
}


static gchar* value_library_monitor_pool_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	LibraryMonitorPool ** object_p;
	object_p = collect_values[0].v_pointer;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!object_p) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1549 "LibraryMonitor.c"
	}
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!value->data[0].v_pointer) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		*object_p = NULL;
#line 1555 "LibraryMonitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		*object_p = value->data[0].v_pointer;
#line 1559 "LibraryMonitor.c"
	} else {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		*object_p = library_monitor_pool_ref (value->data[0].v_pointer);
#line 1563 "LibraryMonitor.c"
	}
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return NULL;
#line 1567 "LibraryMonitor.c"
}


GParamSpec* param_spec_library_monitor_pool (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecLibraryMonitorPool* spec;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LIBRARY_MONITOR_POOL), NULL);
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return G_PARAM_SPEC (spec);
#line 1581 "LibraryMonitor.c"
}


gpointer value_get_library_monitor_pool (const GValue* value) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LIBRARY_MONITOR_POOL), NULL);
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return value->data[0].v_pointer;
#line 1590 "LibraryMonitor.c"
}


void value_set_library_monitor_pool (GValue* value, gpointer v_object) {
	LibraryMonitorPool * old;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LIBRARY_MONITOR_POOL));
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (v_object) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LIBRARY_MONITOR_POOL));
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_pool_ref (value->data[0].v_pointer);
#line 1610 "LibraryMonitor.c"
	} else {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 1614 "LibraryMonitor.c"
	}
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (old) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_pool_unref (old);
#line 1620 "LibraryMonitor.c"
	}
}


void value_take_library_monitor_pool (GValue* value, gpointer v_object) {
	LibraryMonitorPool * old;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LIBRARY_MONITOR_POOL));
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	old = value->data[0].v_pointer;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (v_object) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LIBRARY_MONITOR_POOL));
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 1639 "LibraryMonitor.c"
	} else {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 1643 "LibraryMonitor.c"
	}
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (old) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_pool_unref (old);
#line 1649 "LibraryMonitor.c"
	}
}


static void library_monitor_pool_class_init (LibraryMonitorPoolClass * klass) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_pool_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((LibraryMonitorPoolClass *) klass)->finalize = library_monitor_pool_finalize;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_type_class_add_private (klass, sizeof (LibraryMonitorPoolPrivate));
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_pool_signals[LIBRARY_MONITOR_POOL_MONITOR_INSTALLED_SIGNAL] = g_signal_new ("monitor-installed", TYPE_LIBRARY_MONITOR_POOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_LIBRARY_MONITOR);
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_pool_signals[LIBRARY_MONITOR_POOL_MONITOR_DESTROYED_SIGNAL] = g_signal_new ("monitor-destroyed", TYPE_LIBRARY_MONITOR_POOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_LIBRARY_MONITOR);
#line 1665 "LibraryMonitor.c"
}


static void library_monitor_pool_instance_init (LibraryMonitorPool * self) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv = LIBRARY_MONITOR_POOL_GET_PRIVATE (self);
#line 31 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->monitor = NULL;
#line 32 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->timer_id = (guint) 0;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->ref_count = 1;
#line 1678 "LibraryMonitor.c"
}


static void library_monitor_pool_finalize (LibraryMonitorPool * obj) {
	LibraryMonitorPool * self;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_MONITOR_POOL, LibraryMonitorPool);
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_handlers_destroy (self);
#line 31 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->monitor);
#line 1690 "LibraryMonitor.c"
}


GType library_monitor_pool_get_type (void) {
	static volatile gsize library_monitor_pool_type_id__volatile = 0;
	if (g_once_init_enter (&library_monitor_pool_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_library_monitor_pool_init, value_library_monitor_pool_free_value, value_library_monitor_pool_copy_value, value_library_monitor_pool_peek_pointer, "p", value_library_monitor_pool_collect_value, "p", value_library_monitor_pool_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorPoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_pool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitorPool), 0, (GInstanceInitFunc) library_monitor_pool_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType library_monitor_pool_type_id;
		library_monitor_pool_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LibraryMonitorPool", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&library_monitor_pool_type_id__volatile, library_monitor_pool_type_id);
	}
	return library_monitor_pool_type_id__volatile;
}


gpointer library_monitor_pool_ref (gpointer instance) {
	LibraryMonitorPool * self;
	self = instance;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return instance;
#line 1715 "LibraryMonitor.c"
}


void library_monitor_pool_unref (gpointer instance) {
	LibraryMonitorPool * self;
	self = instance;
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		LIBRARY_MONITOR_POOL_GET_CLASS (self)->finalize (self);
#line 28 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1728 "LibraryMonitor.c"
	}
}


static void _library_monitor_on_config_changed_configuration_facade_auto_import_from_library_changed (ConfigurationFacade* _sender, gpointer self) {
#line 247 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_on_config_changed ((LibraryMonitor*) self);
#line 1736 "LibraryMonitor.c"
}


static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = file_hash ((GFile*) v);
#line 206 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 1745 "LibraryMonitor.c"
}


static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
#line 206 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 1754 "LibraryMonitor.c"
}


static void _library_monitor_on_unblacklist_file_dequeued_callback (gconstpointer item, gpointer self) {
#line 207 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_on_unblacklist_file ((GFile*) item);
#line 1761 "LibraryMonitor.c"
}


static gboolean _library_monitor_on_flush_import_queue_gsource_func (gpointer self) {
	gboolean result;
	result = library_monitor_on_flush_import_queue ((LibraryMonitor*) self);
#line 243 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 1770 "LibraryMonitor.c"
}


LibraryMonitor* library_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring) {
	LibraryMonitor * self = NULL;
	GFile* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ConfigFacade* _tmp3_;
	ConfigFacade* _tmp4_;
	gboolean _tmp5_;
	ConfigFacade* _tmp6_;
	ConfigFacade* _tmp7_;
	guint _tmp8_;
#line 236 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (root), NULL);
#line 237 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = root;
#line 237 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = recurse;
#line 237 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = monitoring;
#line 237 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = (LibraryMonitor*) directory_monitor_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
#line 240 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = config_facade_get_instance ();
#line 240 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 240 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = configuration_facade_get_auto_import_from_library (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 240 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->auto_import = _tmp5_;
#line 240 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_tmp4_);
#line 241 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = config_facade_get_instance ();
#line 241 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = _tmp6_;
#line 241 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "auto-import-from-library-changed", (GCallback) _library_monitor_on_config_changed_configuration_facade_auto_import_from_library_changed, self, 0);
#line 241 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_tmp7_);
#line 243 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp8_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) LIBRARY_MONITOR_FLUSH_IMPORT_QUEUE_SEC, _library_monitor_on_flush_import_queue_gsource_func, g_object_ref (self), g_object_unref);
#line 243 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->import_queue_timer_id = _tmp8_;
#line 236 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self;
#line 1819 "LibraryMonitor.c"
}


LibraryMonitor* library_monitor_new (GFile* root, gboolean recurse, gboolean monitoring) {
#line 236 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return library_monitor_construct (TYPE_LIBRARY_MONITOR, root, recurse, monitoring);
#line 1826 "LibraryMonitor.c"
}


static void library_monitor_real_close (DirectoryMonitor* base) {
	LibraryMonitor * self;
	GCancellable* _tmp0_;
	guint _tmp13_;
#line 250 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 251 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->cancellable;
#line 251 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_cancellable_cancel (_tmp0_);
#line 1840 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		gint _monitor_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _monitor_index = 0;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = self->priv->monitors;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp2_;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = _monitor_list;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _tmp4_;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp5_;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 1868 "LibraryMonitor.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			MediaMonitor* _tmp12_;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp6_ = _monitor_index;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp6_ + 1;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp7_ = _monitor_index;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _monitor_size;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 1889 "LibraryMonitor.c"
			}
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_list;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = _monitor_index;
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp11_;
#line 254 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = monitor;
#line 254 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			media_monitor_close (_tmp12_);
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 1905 "LibraryMonitor.c"
		}
#line 253 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 1909 "LibraryMonitor.c"
	}
#line 256 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp13_ = self->priv->import_queue_timer_id;
#line 256 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp13_ != ((guint) 0)) {
#line 1915 "LibraryMonitor.c"
		guint _tmp14_;
#line 257 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp14_ = self->priv->import_queue_timer_id;
#line 257 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_source_remove (_tmp14_);
#line 258 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		self->priv->import_queue_timer_id = (guint) 0;
#line 1923 "LibraryMonitor.c"
	}
#line 261 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
#line 1927 "LibraryMonitor.c"
}


static void library_monitor_add_to_discovered_list (LibraryMonitor* self, MediaMonitor* monitor, Monitorable* monitorable) {
	GeeHashMap* _tmp0_;
	MediaMonitor* _tmp1_;
	gboolean _tmp2_;
	GeeHashMap* _tmp7_;
	MediaMonitor* _tmp8_;
	gpointer _tmp9_;
	GeeSet* _tmp10_;
	Monitorable* _tmp11_;
#line 264 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 264 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (monitor));
#line 264 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 265 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->discovered;
#line 265 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = monitor;
#line 265 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 265 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp2_) {
#line 1954 "LibraryMonitor.c"
		GeeHashMap* _tmp3_;
		MediaMonitor* _tmp4_;
		GeeHashSet* _tmp5_;
		GeeHashSet* _tmp6_;
#line 266 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = self->priv->discovered;
#line 266 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = monitor;
#line 266 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = gee_hash_set_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 266 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = _tmp5_;
#line 266 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_SET, GeeSet));
#line 266 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_tmp6_);
#line 1971 "LibraryMonitor.c"
	}
#line 268 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = self->priv->discovered;
#line 268 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp8_ = monitor;
#line 268 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_);
#line 268 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp10_ = (GeeSet*) _tmp9_;
#line 268 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp11_ = monitorable;
#line 268 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
#line 268 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_tmp10_);
#line 1987 "LibraryMonitor.c"
}


static MediaMonitor* library_monitor_get_monitor_for_monitorable (LibraryMonitor* self, Monitorable* monitorable) {
	MediaMonitor* result = NULL;
	Monitorable* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
#line 271 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_MONITOR (self), NULL);
#line 271 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 2000 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _monitor_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _monitor_index = 0;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = self->priv->monitors;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp1_;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = _monitor_list;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _tmp3_;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp4_;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 2028 "LibraryMonitor.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			MediaMonitor* _tmp11_;
			MediaSourceCollection* _tmp12_;
			MediaSourceCollection* _tmp13_;
			Monitorable* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp5_ = _monitor_index;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp5_ + 1;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp6_ = _monitor_index;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp7_ = _monitor_size;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 2054 "LibraryMonitor.c"
			}
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _monitor_list;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_index;
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp10_;
#line 273 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = monitor;
#line 273 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = media_monitor_get_media_source_collection (_tmp11_);
#line 273 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = _tmp12_;
#line 273 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = monitorable;
#line 273 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = source_collection_holds_type_of_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_SOURCE_COLLECTION, SourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_DATA_SOURCE, DataSource));
#line 273 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = _tmp15_;
#line 273 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_collection_unref0 (_tmp13_);
#line 273 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp16_) {
#line 274 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				result = monitor;
#line 274 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_monitor_list);
#line 274 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				return result;
#line 2086 "LibraryMonitor.c"
			}
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 2090 "LibraryMonitor.c"
		}
#line 272 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 2094 "LibraryMonitor.c"
	}
#line 277 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp17_ = monitorable;
#line 277 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp18_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_OBJECT, DataObject));
#line 277 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp19_ = _tmp18_;
#line 277 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_error ("LibraryMonitor.vala:277: Unable to locate MediaMonitor for %s", _tmp19_);
#line 277 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_free0 (_tmp19_);
#line 2106 "LibraryMonitor.c"
}


static void library_monitor_real_discovery_started (DirectoryMonitor* base) {
	LibraryMonitor * self;
	GeeHashMap* _tmp28_;
	GeeHashSet* _tmp29_;
#line 280 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 2116 "LibraryMonitor.c"
	{
		GeeIterator* _collection_it = NULL;
		MediaCollectionRegistry* _tmp0_;
		MediaCollectionRegistry* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = media_collection_registry_get_instance ();
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = _tmp0_;
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = media_collection_registry_get_all (_tmp1_);
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = _tmp2_;
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _tmp4_;
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_media_collection_registry_unref0 (_tmp1_);
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_collection_it = _tmp5_;
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 2145 "LibraryMonitor.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			MediaSourceCollection* collection = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GeeList* _tmp10_;
			MediaSourceCollection* _tmp11_;
			Workers* _tmp12_;
			GCancellable* _tmp13_;
			MediaMonitor* _tmp14_;
			MediaMonitor* _tmp15_;
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp6_ = _collection_it;
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!_tmp7_) {
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 2165 "LibraryMonitor.c"
			}
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _collection_it;
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			collection = (MediaSourceCollection*) _tmp9_;
#line 282 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = self->priv->monitors;
#line 282 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = collection;
#line 282 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = self->priv->workers;
#line 282 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = self->priv->cancellable;
#line 282 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = media_source_collection_create_media_monitor (_tmp11_, _tmp12_, _tmp13_);
#line 282 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = _tmp14_;
#line 282 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), _tmp15_);
#line 282 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (_tmp15_);
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_collection_unref0 (collection);
#line 2191 "LibraryMonitor.c"
		}
#line 281 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_collection_it);
#line 2195 "LibraryMonitor.c"
	}
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp16_;
		GeeList* _tmp17_;
		gint _monitor_size = 0;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _monitor_index = 0;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp16_ = self->priv->monitors;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp17_ = _g_object_ref0 (_tmp16_);
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp17_;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp18_ = _monitor_list;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp19_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp20_ = _tmp19_;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp20_;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 2224 "LibraryMonitor.c"
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_;
			MediaMonitor* _tmp27_;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp21_ = _monitor_index;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp21_ + 1;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp22_ = _monitor_index;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp23_ = _monitor_size;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp22_ < _tmp23_)) {
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 2245 "LibraryMonitor.c"
			}
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp24_ = _monitor_list;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp25_ = _monitor_index;
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp26_ = gee_list_get (_tmp24_, _tmp25_);
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp26_;
#line 285 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp27_ = monitor;
#line 285 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			media_monitor_notify_discovery_started (_tmp27_);
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 2261 "LibraryMonitor.c"
		}
#line 284 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 2265 "LibraryMonitor.c"
	}
#line 287 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp28_ = gee_hash_map_new (TYPE_MEDIA_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEE_TYPE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 287 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->discovered);
#line 287 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->discovered = _tmp28_;
#line 288 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp29_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
#line 288 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->unknown_files);
#line 288 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->unknown_files = _tmp29_;
#line 290 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->discovery_started (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
#line 2281 "LibraryMonitor.c"
}


static void library_monitor_real_file_discovered (DirectoryMonitor* base, GFile* file, GFileInfo* info) {
	LibraryMonitor * self;
	Monitorable* representation = NULL;
	MediaMonitor* representing = NULL;
	gboolean ignore = FALSE;
	MediaMonitor* _tmp20_;
	GFile* _tmp36_;
	GFileInfo* _tmp37_;
#line 293 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 293 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 293 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 294 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	representation = NULL;
#line 295 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	representing = NULL;
#line 296 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	ignore = FALSE;
#line 2305 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _monitor_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _monitor_index = 0;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = self->priv->monitors;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp1_;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = _monitor_list;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _tmp3_;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp4_;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 2333 "LibraryMonitor.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			MediaMonitorDiscoveredFile _result_ = 0;
			MediaMonitor* _tmp11_;
			GFile* _tmp12_;
			GFileInfo* _tmp13_;
			Monitorable* _tmp14_ = NULL;
			MediaMonitorDiscoveredFile _tmp15_;
			MediaMonitorDiscoveredFile _tmp16_;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp5_ = _monitor_index;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp5_ + 1;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp6_ = _monitor_index;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp7_ = _monitor_size;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 2360 "LibraryMonitor.c"
			}
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _monitor_list;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_index;
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp10_;
#line 298 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = monitor;
#line 298 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = file;
#line 298 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = info;
#line 298 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = media_monitor_notify_file_discovered (_tmp11_, _tmp12_, _tmp13_, &_tmp14_);
#line 298 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (representation);
#line 298 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			representation = _tmp14_;
#line 298 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_result_ = _tmp15_;
#line 300 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = _result_;
#line 300 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp16_ == MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED) {
#line 2388 "LibraryMonitor.c"
				MediaMonitor* _tmp17_;
				MediaMonitor* _tmp18_;
#line 301 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp17_ = monitor;
#line 301 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 301 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (representing);
#line 301 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				representing = _tmp18_;
#line 303 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (monitor);
#line 303 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 2403 "LibraryMonitor.c"
			} else {
				MediaMonitorDiscoveredFile _tmp19_;
#line 304 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp19_ = _result_;
#line 304 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (_tmp19_ == MEDIA_MONITOR_DISCOVERED_FILE_IGNORE) {
#line 306 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					ignore = TRUE;
#line 308 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (monitor);
#line 308 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					break;
#line 2416 "LibraryMonitor.c"
				}
			}
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 2421 "LibraryMonitor.c"
		}
#line 297 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 2425 "LibraryMonitor.c"
	}
#line 312 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp20_ = representing;
#line 312 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp20_ != NULL) {
#line 2431 "LibraryMonitor.c"
		gboolean _tmp21_ = FALSE;
		Monitorable* _tmp22_;
		MediaMonitor* _tmp24_;
		Monitorable* _tmp25_;
#line 313 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp22_ = representation;
#line 313 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_tmp22_ != NULL) {
#line 2440 "LibraryMonitor.c"
			gboolean _tmp23_;
#line 313 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp23_ = ignore;
#line 313 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp21_ = !_tmp23_;
#line 2446 "LibraryMonitor.c"
		} else {
#line 313 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp21_ = FALSE;
#line 2450 "LibraryMonitor.c"
		}
#line 313 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_vala_assert (_tmp21_, "representation != null && !ignore");
#line 314 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp24_ = representing;
#line 314 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp25_ = representation;
#line 314 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_add_to_discovered_list (self, _tmp24_, _tmp25_);
#line 2460 "LibraryMonitor.c"
	} else {
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_;
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp28_ = ignore;
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (!_tmp28_) {
#line 2469 "LibraryMonitor.c"
			TombstoneSourceCollection* _tmp29_;
			GFile* _tmp30_;
			gboolean _tmp31_;
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp29_ = tombstone_global;
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp30_ = file;
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp31_ = tombstone_source_collection_matches (_tmp29_, _tmp30_);
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp27_ = !_tmp31_;
#line 2481 "LibraryMonitor.c"
		} else {
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp27_ = FALSE;
#line 2485 "LibraryMonitor.c"
		}
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_tmp27_) {
#line 2489 "LibraryMonitor.c"
			GFile* _tmp32_;
			gboolean _tmp33_;
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp32_ = file;
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp33_ = library_monitor_is_supported_filetype (self, _tmp32_);
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp26_ = _tmp33_;
#line 2498 "LibraryMonitor.c"
		} else {
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp26_ = FALSE;
#line 2502 "LibraryMonitor.c"
		}
#line 315 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_tmp26_) {
#line 2506 "LibraryMonitor.c"
			GeeHashSet* _tmp34_;
			GFile* _tmp35_;
#line 316 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp34_ = self->priv->unknown_files;
#line 316 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp35_ = file;
#line 316 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp35_);
#line 2515 "LibraryMonitor.c"
		}
	}
#line 319 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp36_ = file;
#line 319 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp37_ = info;
#line 319 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->file_discovered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp36_, _tmp37_);
#line 293 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (representing);
#line 293 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (representation);
#line 2528 "LibraryMonitor.c"
}


static void library_monitor_real_discovery_completed (DirectoryMonitor* base) {
	LibraryMonitor * self;
#line 322 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 323 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_async_discovery_completed (self, NULL, NULL);
#line 2538 "LibraryMonitor.c"
}


static void library_monitor_async_discovery_completed_data_free (gpointer _data) {
	LibraryMonitorAsyncDiscoveryCompletedData* _data_;
	_data_ = _data;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_slice_free (LibraryMonitorAsyncDiscoveryCompletedData, _data_);
#line 2549 "LibraryMonitor.c"
}


static void library_monitor_async_discovery_completed_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	LibraryMonitorAsyncDiscoveryCompletedData* _task_data_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_task_data_->_callback_ != NULL) {
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 2561 "LibraryMonitor.c"
	}
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_task_data_->_task_complete_ = TRUE;
#line 2565 "LibraryMonitor.c"
}


static void library_monitor_async_discovery_completed (LibraryMonitor* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LibraryMonitorAsyncDiscoveryCompletedData* _data_;
	LibraryMonitor* _tmp0_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_ = g_slice_new0 (LibraryMonitorAsyncDiscoveryCompletedData);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_callback_ = _callback_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, library_monitor_async_discovery_completed_async_ready_wrapper, _user_data_);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_callback_ == NULL) {
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_task_complete_ = TRUE;
#line 2582 "LibraryMonitor.c"
	}
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_task_set_task_data (_data_->_async_result, _data_, library_monitor_async_discovery_completed_data_free);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->self = _tmp0_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_async_discovery_completed_co (_data_);
#line 2592 "LibraryMonitor.c"
}


static void library_monitor_async_discovery_completed_finish (LibraryMonitor* self, GAsyncResult* _res_) {
	LibraryMonitorAsyncDiscoveryCompletedData* _data_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2600 "LibraryMonitor.c"
}


static gboolean _library_monitor_async_discovery_completed_co_gsource_func (gpointer self) {
	gboolean result;
	result = library_monitor_async_discovery_completed_co (self);
#line 378 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 2609 "LibraryMonitor.c"
}


static gboolean library_monitor_async_discovery_completed_co (LibraryMonitorAsyncDiscoveryCompletedData* _data_) {
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	switch (_data_->_state_) {
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		case 0:
#line 2618 "LibraryMonitor.c"
		goto _state_0;
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		case 1:
#line 2622 "LibraryMonitor.c"
		goto _state_1;
		default:
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_assert_not_reached ();
#line 2627 "LibraryMonitor.c"
	}
	_state_0:
#line 331 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp0_ = _data_->self->priv->unknown_files;
#line 331 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 331 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 331 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_data_->_tmp2_ == 0) {
#line 332 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_discovery_stage_completed (_data_->self);
#line 334 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 334 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_data_->_state_ != 0) {
#line 334 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			while (_data_->_task_complete_ != TRUE) {
#line 334 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2648 "LibraryMonitor.c"
			}
		}
#line 334 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 334 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return FALSE;
#line 2655 "LibraryMonitor.c"
	}
#line 337 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp3_ = gee_array_list_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 337 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->all_candidates = _data_->_tmp3_;
#line 338 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp4_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 338 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->adopted = _data_->_tmp4_;
#line 2665 "LibraryMonitor.c"
	{
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp5_ = _data_->self->priv->unknown_files;
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp6_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_file_it = _data_->_tmp6_;
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp7_ = _data_->_file_it;
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp8_ = gee_iterator_next (_data_->_tmp7_);
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!_data_->_tmp8_) {
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 2683 "LibraryMonitor.c"
			}
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp9_ = _data_->_file_it;
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp10_ = gee_iterator_get (_data_->_tmp9_);
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->file = (GFile*) _data_->_tmp10_;
#line 340 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp11_ = _data_->file;
#line 340 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp12_ = directory_monitor_get_file_info (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _data_->_tmp11_);
#line 340 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->info = _data_->_tmp12_;
#line 341 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp13_ = _data_->info;
#line 341 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_data_->_tmp13_ == NULL) {
#line 342 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->info);
#line 342 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->file);
#line 342 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 2707 "LibraryMonitor.c"
			}
#line 345 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp14_ = _data_->all_candidates;
#line 345 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 347 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->candidates = NULL;
#line 348 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->associated = FALSE;
#line 2717 "LibraryMonitor.c"
			{
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp15_ = _data_->self->priv->monitors;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_monitor_list = _data_->_tmp16_;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp17_ = _data_->_monitor_list;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp18_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp19_ = _data_->_tmp18_;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_monitor_size = _data_->_tmp19_;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_monitor_index = -1;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				while (TRUE) {
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp20_ = _data_->_monitor_index;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_monitor_index = _data_->_tmp20_ + 1;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp21_ = _data_->_monitor_index;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp22_ = _data_->_monitor_size;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (!(_data_->_tmp21_ < _data_->_tmp22_)) {
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						break;
#line 2749 "LibraryMonitor.c"
					}
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp23_ = _data_->_monitor_list;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp24_ = _data_->_monitor_index;
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp25_ = gee_list_get (_data_->_tmp23_, _data_->_tmp24_);
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->monitor = (MediaMonitor*) _data_->_tmp25_;
#line 351 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp26_ = _data_->monitor;
#line 351 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp27_ = _data_->file;
#line 351 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp28_ = _data_->info;
#line 351 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp29_ = 0;
#line 351 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp30_ = media_monitor_candidates_for_unknown_file (_data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_, &_data_->_tmp29_);
#line 351 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_result_ = _data_->_tmp29_;
#line 351 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (_data_->candidates);
#line 351 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->candidates = _data_->_tmp30_;
#line 352 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp32_ = _data_->_result_;
#line 352 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_data_->_tmp32_ == MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED) {
#line 352 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp31_ = TRUE;
#line 2781 "LibraryMonitor.c"
					} else {
#line 353 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp33_ = _data_->_result_;
#line 353 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp31_ = _data_->_tmp33_ == MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
#line 2787 "LibraryMonitor.c"
					}
#line 352 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_data_->_tmp31_) {
#line 354 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->associated = TRUE;
#line 356 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (_data_->monitor);
#line 356 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						break;
#line 2797 "LibraryMonitor.c"
					} else {
#line 357 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp34_ = _data_->candidates;
#line 357 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						if (_data_->_tmp34_ != NULL) {
#line 358 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp35_ = _data_->all_candidates;
#line 358 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp36_ = _data_->candidates;
#line 358 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							gee_array_list_add_all (_data_->_tmp35_, _data_->_tmp36_);
#line 2809 "LibraryMonitor.c"
						}
					}
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (_data_->monitor);
#line 2814 "LibraryMonitor.c"
				}
#line 349 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->_monitor_list);
#line 2818 "LibraryMonitor.c"
			}
#line 362 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp37_ = _data_->associated;
#line 362 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_data_->_tmp37_) {
#line 363 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp38_ = _data_->adopted;
#line 363 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp39_ = _data_->file;
#line 363 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp38_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _data_->_tmp39_);
#line 365 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->candidates);
#line 365 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->info);
#line 365 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->file);
#line 365 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 2838 "LibraryMonitor.c"
			}
#line 369 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp40_ = _data_->all_candidates;
#line 369 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp41_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 369 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp42_ = _data_->_tmp41_;
#line 369 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_data_->_tmp42_ > 0) {
#line 371 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp43_ = _data_->all_candidates;
#line 371 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp44_ = _g_object_ref0 (_data_->_tmp43_);
#line 371 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->job_candidates = _data_->_tmp44_;
#line 372 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp45_ = gee_array_list_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 372 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->all_candidates);
#line 372 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->all_candidates = _data_->_tmp45_;
#line 374 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp46_ = _data_->self->priv->checksums_total;
#line 374 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->self->priv->checksums_total = _data_->_tmp46_ + 1;
#line 375 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp47_ = _data_->self->priv->workers;
#line 375 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp48_ = _data_->file;
#line 375 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp49_ = _data_->job_candidates;
#line 375 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp50_ = library_monitor_find_move_job_new (_data_->self, _data_->_tmp48_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp49_, GEE_TYPE_COLLECTION, GeeCollection));
#line 375 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp51_ = _data_->_tmp50_;
#line 375 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				workers_enqueue (_data_->_tmp47_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp51_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 375 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_background_job_unref0 (_data_->_tmp51_);
#line 369 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->job_candidates);
#line 2880 "LibraryMonitor.c"
			}
#line 378 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _library_monitor_async_discovery_completed_co_gsource_func, _data_, NULL);
#line 379 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_state_ = 1;
#line 379 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return FALSE;
#line 2888 "LibraryMonitor.c"
			_state_1:
			;
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (_data_->candidates);
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (_data_->info);
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (_data_->file);
#line 2897 "LibraryMonitor.c"
		}
#line 339 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_data_->_file_it);
#line 2901 "LibraryMonitor.c"
	}
#line 383 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp52_ = _data_->self->priv->unknown_files;
#line 383 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp53_ = _data_->adopted;
#line 383 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp52_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp53_, GEE_TYPE_COLLECTION, GeeCollection));
#line 385 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->self->priv->checksums_completed = 0;
#line 387 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp54_ = _data_->self->priv->checksums_total;
#line 387 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_data_->_tmp54_ == 0) {
#line 388 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_discovery_stage_completed (_data_->self);
#line 2917 "LibraryMonitor.c"
	} else {
#line 390 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp55_ = _data_->self->priv->checksums_total;
#line 390 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp56_ = g_strdup_printf ("%d checksum jobs initiated to verify unknown photo files", _data_->_tmp55_);
#line 390 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp57_ = _data_->_tmp56_;
#line 390 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		directory_monitor_mdbg (_data_->_tmp57_);
#line 390 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_data_->_tmp57_);
#line 391 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp58_ = _data_->self->priv->checksums_completed;
#line 391 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp59_ = _data_->self->priv->checksums_total;
#line 391 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_signal_emit (_data_->self, library_monitor_signals[LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL], 0, _data_->_tmp58_, _data_->_tmp59_);
#line 2935 "LibraryMonitor.c"
	}
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->adopted);
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->all_candidates);
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_data_->_state_ != 0) {
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2949 "LibraryMonitor.c"
		}
	}
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 326 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return FALSE;
#line 2956 "LibraryMonitor.c"
}


static void library_monitor_report_checksum_job_completed (LibraryMonitor* self) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
#line 395 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 396 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->checksums_completed;
#line 396 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = self->priv->checksums_total;
#line 396 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_vala_assert (_tmp0_ < _tmp1_, "checksums_completed < checksums_total");
#line 397 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = self->priv->checksums_completed;
#line 397 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->checksums_completed = _tmp2_ + 1;
#line 399 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = self->priv->checksums_completed;
#line 399 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = self->priv->checksums_total;
#line 399 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_emit (self, library_monitor_signals[LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL], 0, _tmp3_, _tmp4_);
#line 401 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = self->priv->checksums_completed;
#line 401 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = self->priv->checksums_total;
#line 401 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp5_ == _tmp6_) {
#line 402 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_discovery_stage_completed (self);
#line 2994 "LibraryMonitor.c"
	}
}


static gpointer _background_job_ref0 (gpointer self) {
#line 406 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self ? background_job_ref (self) : NULL;
#line 3002 "LibraryMonitor.c"
}


static void library_monitor_on_find_move_completed (LibraryMonitor* self, BackgroundJob* j) {
	LibraryMonitorFindMoveJob* job = NULL;
	BackgroundJob* _tmp0_;
	LibraryMonitorFindMoveJob* _tmp1_;
	LibraryMonitorFindMoveJob* _tmp2_;
	Monitorable* _tmp3_;
	LibraryMonitorFindMoveJob* _tmp28_;
	GError* _tmp29_;
#line 405 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 405 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 406 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = j;
#line 406 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJob));
#line 406 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	job = _tmp1_;
#line 411 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = job;
#line 411 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _tmp2_->match;
#line 411 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp3_ != NULL) {
#line 3030 "LibraryMonitor.c"
		LibraryMonitorFindMoveJob* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		LibraryMonitorFindMoveJob* _tmp8_;
		Monitorable* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		MediaMonitor* monitor = NULL;
		LibraryMonitorFindMoveJob* _tmp14_;
		Monitorable* _tmp15_;
		MediaMonitor* _tmp16_;
		MediaMonitor* _tmp17_;
		LibraryMonitorFindMoveJob* _tmp18_;
		Monitorable* _tmp19_;
		LibraryMonitorFindMoveJob* _tmp20_;
		GFile* _tmp21_;
		GeeHashSet* _tmp22_;
		LibraryMonitorFindMoveJob* _tmp23_;
		GFile* _tmp24_;
		MediaMonitor* _tmp25_;
		LibraryMonitorFindMoveJob* _tmp26_;
		Monitorable* _tmp27_;
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = job;
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _tmp4_->file;
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = g_file_get_path (_tmp5_);
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = _tmp6_;
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = job;
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = _tmp8_->match;
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp11_ = _tmp10_;
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp12_ = g_strdup_printf ("Found moved master file: %s matches %s", _tmp7_, _tmp11_);
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp13_ = _tmp12_;
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		directory_monitor_mdbg (_tmp13_);
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp13_);
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp11_);
#line 412 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp7_);
#line 415 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp14_ = job;
#line 415 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp15_ = _tmp14_->match;
#line 415 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp16_ = library_monitor_get_monitor_for_monitorable (self, _tmp15_);
#line 415 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		monitor = _tmp16_;
#line 416 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp17_ = monitor;
#line 416 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp18_ = job;
#line 416 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp19_ = _tmp18_->match;
#line 416 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp20_ = job;
#line 416 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp21_ = _tmp20_->file;
#line 416 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		media_monitor_update_master_file (_tmp17_, _tmp19_, _tmp21_);
#line 417 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp22_ = self->priv->unknown_files;
#line 417 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp23_ = job;
#line 417 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp24_ = _tmp23_->file;
#line 417 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp24_);
#line 418 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp25_ = monitor;
#line 418 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp26_ = job;
#line 418 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp27_ = _tmp26_->match;
#line 418 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_add_to_discovered_list (self, _tmp25_, _tmp27_);
#line 411 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (monitor);
#line 3122 "LibraryMonitor.c"
	}
#line 421 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp28_ = job;
#line 421 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp29_ = _tmp28_->err;
#line 421 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp29_ != NULL) {
#line 3130 "LibraryMonitor.c"
		LibraryMonitorFindMoveJob* _tmp30_;
		GFile* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		LibraryMonitorFindMoveJob* _tmp34_;
		GError* _tmp35_;
		const gchar* _tmp36_;
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp30_ = job;
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp31_ = _tmp30_->file;
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp32_ = g_file_get_path (_tmp31_);
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp33_ = _tmp32_;
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp34_ = job;
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp35_ = _tmp34_->err;
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp36_ = _tmp35_->message;
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_warning ("LibraryMonitor.vala:422: Unable to checksum unknown media file %s: %s", _tmp33_, _tmp36_);
#line 422 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp33_);
#line 3156 "LibraryMonitor.c"
	}
#line 424 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_report_checksum_job_completed (self);
#line 405 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_background_job_unref0 (job);
#line 3162 "LibraryMonitor.c"
}


static void library_monitor_on_find_move_cancelled (LibraryMonitor* self, BackgroundJob* j) {
#line 427 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 427 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 428 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_report_checksum_job_completed (self);
#line 3173 "LibraryMonitor.c"
}


static void library_monitor_discovery_stage_completed (LibraryMonitor* self) {
	gboolean _tmp65_;
	TombstoneSourceCollection* _tmp67_;
	GCancellable* _tmp68_;
#line 431 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 3183 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _monitor_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _monitor_index = 0;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = self->priv->monitors;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp1_;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = _monitor_list;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _tmp3_;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp4_;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 3211 "LibraryMonitor.c"
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			GeeSet* monitorables = NULL;
			GeeHashMap* _tmp11_;
			MediaMonitor* _tmp12_;
			gpointer _tmp13_;
			GeeSet* _tmp14_;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp5_ = _monitor_index;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp5_ + 1;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp6_ = _monitor_index;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp7_ = _monitor_size;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 3236 "LibraryMonitor.c"
			}
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _monitor_list;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_index;
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp10_;
#line 433 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = self->priv->discovered;
#line 433 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = monitor;
#line 433 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp12_);
#line 433 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitorables = (GeeSet*) _tmp13_;
#line 434 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = monitorables;
#line 434 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp14_ != NULL) {
#line 3258 "LibraryMonitor.c"
				{
					GeeIterator* _monitorable_it = NULL;
					GeeSet* _tmp15_;
					GeeIterator* _tmp16_;
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp15_ = monitorables;
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp16_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ITERABLE, GeeIterable));
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_monitorable_it = _tmp16_;
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					while (TRUE) {
#line 3271 "LibraryMonitor.c"
						GeeIterator* _tmp17_;
						gboolean _tmp18_;
						Monitorable* monitorable = NULL;
						GeeIterator* _tmp19_;
						gpointer _tmp20_;
						Monitorable* _tmp21_;
						MediaMonitor* _tmp22_;
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp17_ = _monitorable_it;
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp18_ = gee_iterator_next (_tmp17_);
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						if (!_tmp18_) {
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							break;
#line 3287 "LibraryMonitor.c"
						}
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp19_ = _monitorable_it;
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp20_ = gee_iterator_get (_tmp19_);
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						monitorable = (Monitorable*) _tmp20_;
#line 436 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp21_ = monitorable;
#line 436 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp22_ = monitor;
#line 436 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						library_monitor_enqueue_verify_monitorable (self, _tmp21_, _tmp22_);
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (monitorable);
#line 3303 "LibraryMonitor.c"
					}
#line 435 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (_monitorable_it);
#line 3307 "LibraryMonitor.c"
				}
			}
			{
				GeeIterator* _object_it = NULL;
				MediaMonitor* _tmp23_;
				MediaSourceCollection* _tmp24_;
				MediaSourceCollection* _tmp25_;
				GeeCollection* _tmp26_;
				GeeCollection* _tmp27_;
				GeeIterator* _tmp28_;
				GeeIterator* _tmp29_;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp23_ = monitor;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp24_ = media_monitor_get_media_source_collection (_tmp23_);
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp25_ = _tmp24_;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp26_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_DATA_COLLECTION, DataCollection));
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp27_ = _tmp26_;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp28_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ITERABLE, GeeIterable));
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp29_ = _tmp28_;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_tmp27_);
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_collection_unref0 (_tmp25_);
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_object_it = _tmp29_;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				while (TRUE) {
#line 3341 "LibraryMonitor.c"
					GeeIterator* _tmp30_;
					gboolean _tmp31_;
					DataObject* object = NULL;
					GeeIterator* _tmp32_;
					gpointer _tmp33_;
					Monitorable* monitorable = NULL;
					DataObject* _tmp34_;
					Monitorable* _tmp35_;
					gboolean _tmp36_ = FALSE;
					GeeSet* _tmp37_;
					Monitorable* _tmp41_;
					MediaMonitor* _tmp42_;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp30_ = _object_it;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp31_ = gee_iterator_next (_tmp30_);
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (!_tmp31_) {
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						break;
#line 3362 "LibraryMonitor.c"
					}
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp32_ = _object_it;
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp33_ = gee_iterator_get (_tmp32_);
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					object = (DataObject*) _tmp33_;
#line 440 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp34_ = object;
#line 440 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_MONITORABLE, Monitorable));
#line 440 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					monitorable = _tmp35_;
#line 442 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp37_ = monitorables;
#line 442 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_tmp37_ != NULL) {
#line 3380 "LibraryMonitor.c"
						GeeSet* _tmp38_;
						Monitorable* _tmp39_;
						gboolean _tmp40_;
#line 442 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp38_ = monitorables;
#line 442 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp39_ = monitorable;
#line 442 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp40_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_COLLECTION, GeeCollection), _tmp39_);
#line 442 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp36_ = _tmp40_;
#line 3392 "LibraryMonitor.c"
					} else {
#line 442 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp36_ = FALSE;
#line 3396 "LibraryMonitor.c"
					}
#line 442 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_tmp36_) {
#line 443 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (monitorable);
#line 443 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (object);
#line 443 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						continue;
#line 3406 "LibraryMonitor.c"
					}
#line 445 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp41_ = monitorable;
#line 445 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp42_ = monitor;
#line 445 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					library_monitor_enqueue_verify_monitorable (self, _tmp41_, _tmp42_);
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (monitorable);
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (object);
#line 3418 "LibraryMonitor.c"
				}
#line 439 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_object_it);
#line 3422 "LibraryMonitor.c"
			}
			{
				GeeIterator* _source_it = NULL;
				MediaMonitor* _tmp43_;
				MediaSourceCollection* _tmp44_;
				MediaSourceCollection* _tmp45_;
				MediaSourceHoldingTank* _tmp46_;
				MediaSourceHoldingTank* _tmp47_;
				GeeCollection* _tmp48_;
				GeeCollection* _tmp49_;
				GeeIterator* _tmp50_;
				GeeIterator* _tmp51_;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp43_ = monitor;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp44_ = media_monitor_get_media_source_collection (_tmp43_);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp45_ = _tmp44_;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp46_ = media_source_collection_get_offline_bin (_tmp45_);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp47_ = _tmp46_;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp48_ = source_holding_tank_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank));
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp49_ = _tmp48_;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp50_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ITERABLE, GeeIterable));
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp51_ = _tmp50_;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_tmp49_);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_source_holding_tank_unref0 (_tmp47_);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_collection_unref0 (_tmp45_);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_source_it = _tmp51_;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				while (TRUE) {
#line 3463 "LibraryMonitor.c"
					GeeIterator* _tmp52_;
					gboolean _tmp53_;
					DataSource* source = NULL;
					GeeIterator* _tmp54_;
					gpointer _tmp55_;
					Monitorable* monitorable = NULL;
					DataSource* _tmp56_;
					Monitorable* _tmp57_;
					gboolean _tmp58_ = FALSE;
					GeeSet* _tmp59_;
					Monitorable* _tmp63_;
					MediaMonitor* _tmp64_;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp52_ = _source_it;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp53_ = gee_iterator_next (_tmp52_);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (!_tmp53_) {
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						break;
#line 3484 "LibraryMonitor.c"
					}
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp54_ = _source_it;
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp55_ = gee_iterator_get (_tmp54_);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					source = (DataSource*) _tmp55_;
#line 450 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp56_ = source;
#line 450 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, TYPE_MONITORABLE, Monitorable));
#line 450 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					monitorable = _tmp57_;
#line 452 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp59_ = monitorables;
#line 452 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_tmp59_ != NULL) {
#line 3502 "LibraryMonitor.c"
						GeeSet* _tmp60_;
						Monitorable* _tmp61_;
						gboolean _tmp62_;
#line 452 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp60_ = monitorables;
#line 452 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp61_ = monitorable;
#line 452 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp62_ = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, GEE_TYPE_COLLECTION, GeeCollection), _tmp61_);
#line 452 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp58_ = _tmp62_;
#line 3514 "LibraryMonitor.c"
					} else {
#line 452 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp58_ = FALSE;
#line 3518 "LibraryMonitor.c"
					}
#line 452 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_tmp58_) {
#line 453 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (monitorable);
#line 453 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (source);
#line 453 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						continue;
#line 3528 "LibraryMonitor.c"
					}
#line 455 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp63_ = monitorable;
#line 455 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp64_ = monitor;
#line 455 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					library_monitor_enqueue_verify_monitorable (self, _tmp63_, _tmp64_);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (monitorable);
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (source);
#line 3540 "LibraryMonitor.c"
				}
#line 448 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_source_it);
#line 3544 "LibraryMonitor.c"
			}
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitorables);
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 3550 "LibraryMonitor.c"
		}
#line 432 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 3554 "LibraryMonitor.c"
	}
#line 460 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp65_ = self->priv->auto_import;
#line 460 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp65_) {
#line 3560 "LibraryMonitor.c"
		GeeHashSet* _tmp66_;
#line 461 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp66_ = self->priv->unknown_files;
#line 461 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_enqueue_import_many (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, GEE_TYPE_COLLECTION, GeeCollection));
#line 3566 "LibraryMonitor.c"
	}
#line 464 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->discovered);
#line 464 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->discovered = NULL;
#line 465 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->unknown_files);
#line 465 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->unknown_files = NULL;
#line 469 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp67_ = tombstone_global;
#line 469 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp68_ = self->priv->cancellable;
#line 469 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	tombstone_source_collection_launch_scan (_tmp67_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp68_);
#line 472 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->discovery_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
#line 3584 "LibraryMonitor.c"
}


static void library_monitor_enqueue_verify_monitorable (LibraryMonitor* self, Monitorable* monitorable, MediaMonitor* monitor) {
	gboolean offered = FALSE;
	GeeQueue* _tmp0_;
	Monitorable* _tmp1_;
	MediaMonitor* _tmp2_;
	LibraryMonitorVerifyJob* _tmp3_;
	LibraryMonitorVerifyJob* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
#line 475 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 475 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_MONITORABLE (monitorable));
#line 475 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_MEDIA_MONITOR (monitor));
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->verify_queue;
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = monitorable;
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = monitor;
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = library_monitor_verify_job_new (_tmp1_, _tmp2_);
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = gee_queue_offer (_tmp0_, _tmp4_);
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = _tmp5_;
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_library_monitor_verify_job_unref0 (_tmp4_);
#line 476 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	offered = _tmp6_;
#line 477 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_vala_assert (offered, "offered");
#line 479 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_execute_next_verify_job (self);
#line 3625 "LibraryMonitor.c"
}


static void library_monitor_execute_next_verify_job (LibraryMonitor* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	LibraryMonitorVerifyJob* job = NULL;
	GeeQueue* _tmp5_;
	gpointer _tmp6_;
	LibraryMonitorVerifyJob* _tmp7_;
	gint _tmp8_;
	LibraryMonitorVerifyJob* _tmp9_;
	Monitorable* _tmp10_;
	LibraryMonitorVerifyJob* _tmp11_;
	MediaMonitor* _tmp12_;
#line 482 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 483 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = self->priv->outstanding_verify_jobs;
#line 483 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_ >= LIBRARY_MONITOR_MAX_VERIFY_EXISTING_MEDIA_JOBS) {
#line 483 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = TRUE;
#line 3649 "LibraryMonitor.c"
	} else {
		GeeQueue* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 483 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = self->priv->verify_queue;
#line 483 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 483 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _tmp3_;
#line 483 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = _tmp4_ == 0;
#line 3662 "LibraryMonitor.c"
	}
#line 483 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_) {
#line 484 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 3668 "LibraryMonitor.c"
	}
#line 486 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = self->priv->verify_queue;
#line 486 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = gee_queue_poll (_tmp5_);
#line 486 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	job = (LibraryMonitorVerifyJob*) _tmp6_;
#line 487 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = job;
#line 487 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_vala_assert (_tmp7_ != NULL, "job != null");
#line 489 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp8_ = self->priv->outstanding_verify_jobs;
#line 489 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->outstanding_verify_jobs = _tmp8_ + 1;
#line 490 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp9_ = job;
#line 490 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp10_ = _tmp9_->monitorable;
#line 490 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp11_ = job;
#line 490 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp12_ = _tmp11_->monitor;
#line 490 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_verify_monitorable (self, _tmp10_, _tmp12_, NULL, NULL);
#line 482 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_library_monitor_verify_job_unref0 (job);
#line 3696 "LibraryMonitor.c"
}


static void library_monitor_verify_monitorable_data_free (gpointer _data) {
	LibraryMonitorVerifyMonitorableData* _data_;
	_data_ = _data;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->monitorable);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->monitor);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_slice_free (LibraryMonitorVerifyMonitorableData, _data_);
#line 3711 "LibraryMonitor.c"
}


static void library_monitor_verify_monitorable_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	LibraryMonitorVerifyMonitorableData* _task_data_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_task_data_ = g_task_get_task_data (G_TASK (res));
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_task_data_->_callback_ != NULL) {
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_task_data_->_callback_ (source_object, res, user_data);
#line 3723 "LibraryMonitor.c"
	}
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_task_data_->_task_complete_ = TRUE;
#line 3727 "LibraryMonitor.c"
}


static void library_monitor_verify_monitorable (LibraryMonitor* self, Monitorable* monitorable, MediaMonitor* monitor, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LibraryMonitorVerifyMonitorableData* _data_;
	LibraryMonitor* _tmp0_;
	Monitorable* _tmp1_;
	Monitorable* _tmp2_;
	MediaMonitor* _tmp3_;
	MediaMonitor* _tmp4_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_ = g_slice_new0 (LibraryMonitorVerifyMonitorableData);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_callback_ = _callback_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, library_monitor_verify_monitorable_async_ready_wrapper, _user_data_);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_callback_ == NULL) {
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_task_complete_ = TRUE;
#line 3748 "LibraryMonitor.c"
	}
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_task_set_task_data (_data_->_async_result, _data_, library_monitor_verify_monitorable_data_free);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->self = _tmp0_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = monitorable;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->monitorable);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->monitorable = _tmp2_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = monitor;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->monitor);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->monitor = _tmp4_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_verify_monitorable_co (_data_);
#line 3774 "LibraryMonitor.c"
}


static void library_monitor_verify_monitorable_finish (LibraryMonitor* self, GAsyncResult* _res_) {
	LibraryMonitorVerifyMonitorableData* _data_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 3782 "LibraryMonitor.c"
}


static void _vala_array_add130 (GFile** * array, int* length, int* size, GFile* value) {
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if ((*length) == (*size)) {
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 3793 "LibraryMonitor.c"
	}
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	(*array)[(*length)++] = value;
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	(*array)[*length] = NULL;
#line 3799 "LibraryMonitor.c"
}


static void library_monitor_verify_monitorable_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LibraryMonitorVerifyMonitorableData* _data_;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_ = _user_data_;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_source_object_ = source_object;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_res_ = _res_;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_task_complete_ = TRUE;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_verify_monitorable_co (_data_);
#line 3815 "LibraryMonitor.c"
}


static gboolean _library_monitor_verify_monitorable_co_gsource_func (gpointer self) {
	gboolean result;
	result = library_monitor_verify_monitorable_co (self);
#line 530 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 3824 "LibraryMonitor.c"
}


static gboolean library_monitor_verify_monitorable_co (LibraryMonitorVerifyMonitorableData* _data_) {
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	switch (_data_->_state_) {
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		case 0:
#line 3833 "LibraryMonitor.c"
		goto _state_0;
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		case 1:
#line 3837 "LibraryMonitor.c"
		goto _state_1;
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		case 2:
#line 3841 "LibraryMonitor.c"
		goto _state_2;
		default:
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_assert_not_reached ();
#line 3846 "LibraryMonitor.c"
	}
	_state_0:
#line 494 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp0_ = g_new0 (GFile*, 1 + 1);
#line 494 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->files = _data_->_tmp0_;
#line 494 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->files_length1 = 1;
#line 494 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_files_size_ = _data_->files_length1;
#line 495 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp1_ = _data_->files;
#line 495 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp1__length1 = _data_->files_length1;
#line 495 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp2_ = _data_->monitor;
#line 495 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp3_ = _data_->monitorable;
#line 495 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp4_ = media_monitor_get_master_file (_data_->_tmp2_, _data_->_tmp3_);
#line 495 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_data_->_tmp1_[0]);
#line 495 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp1_[0] = _data_->_tmp4_;
#line 495 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp5_ = _data_->_tmp1_[0];
#line 497 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp6_ = _data_->monitor;
#line 497 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp7_ = _data_->monitorable;
#line 497 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp9_ = media_monitor_get_auxilliary_backing_files (_data_->_tmp6_, _data_->_tmp7_, &_data_->_tmp8_);
#line 497 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->aux_files = _data_->_tmp9_;
#line 497 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->aux_files_length1 = _data_->_tmp8_;
#line 497 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_aux_files_size_ = _data_->aux_files_length1;
#line 498 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp10_ = _data_->aux_files;
#line 498 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp10__length1 = _data_->aux_files_length1;
#line 498 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_data_->_tmp10_ != NULL) {
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp11_ = _data_->aux_files;
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->_tmp11__length1 = _data_->aux_files_length1;
#line 3895 "LibraryMonitor.c"
		{
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->aux_file_collection_length1 = 0;
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_aux_file_collection_size_ = 0;
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->aux_file_collection = _data_->_tmp11_;
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->aux_file_collection_length1 = _data_->_tmp11__length1;
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			for (_data_->aux_file_it = 0; _data_->aux_file_it < _data_->_tmp11__length1; _data_->aux_file_it = _data_->aux_file_it + 1) {
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp12_ = _g_object_ref0 (_data_->aux_file_collection[_data_->aux_file_it]);
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->aux_file = _data_->_tmp12_;
#line 3911 "LibraryMonitor.c"
				{
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp13_ = _data_->files;
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp13__length1 = _data_->files_length1;
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp14_ = _data_->aux_file;
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
#line 500 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_vala_array_add130 (&_data_->files, &_data_->files_length1, &_data_->_files_size_, _data_->_tmp15_);
#line 499 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (_data_->aux_file);
#line 3925 "LibraryMonitor.c"
				}
			}
		}
	}
	{
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_data_->ctr = 0;
#line 3933 "LibraryMonitor.c"
		{
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_data_->_tmp16_ = TRUE;
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			while (TRUE) {
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (!_data_->_tmp16_) {
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp17_ = _data_->ctr;
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->ctr = _data_->_tmp17_ + 1;
#line 3945 "LibraryMonitor.c"
				}
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp16_ = FALSE;
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp18_ = _data_->ctr;
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp19_ = _data_->files;
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp19__length1 = _data_->files_length1;
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (!(_data_->_tmp18_ < _data_->_tmp19__length1)) {
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					break;
#line 3959 "LibraryMonitor.c"
				}
#line 504 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp20_ = _data_->files;
#line 504 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp20__length1 = _data_->files_length1;
#line 504 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp21_ = _data_->ctr;
#line 504 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp22_ = _data_->_tmp20_[_data_->_tmp21_];
#line 504 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp23_ = _g_object_ref0 (_data_->_tmp22_);
#line 504 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->file = _data_->_tmp23_;
#line 506 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp24_ = _data_->file;
#line 506 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp25_ = directory_monitor_get_file_info (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _data_->_tmp24_);
#line 506 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->info = _data_->_tmp25_;
#line 507 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp26_ = _data_->info;
#line 507 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (_data_->_tmp26_ == NULL) {
#line 3983 "LibraryMonitor.c"
					{
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp28_ = _data_->file;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp29_ = _data_->self->priv->cancellable;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_state_ = 1;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						g_file_query_info_async (_data_->_tmp28_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_FILE_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp29_, library_monitor_verify_monitorable_ready, _data_);
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						return FALSE;
#line 3995 "LibraryMonitor.c"
						_state_1:
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp30_ = g_file_query_info_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error_);
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp27_ = _data_->_tmp30_;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 4003 "LibraryMonitor.c"
							goto __catch486_g_error;
						}
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp31_ = _data_->_tmp27_;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp27_ = NULL;
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (_data_->info);
#line 509 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->info = _data_->_tmp31_;
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (_data_->_tmp27_);
#line 4016 "LibraryMonitor.c"
					}
					goto __finally486;
					__catch486_g_error:
					{
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->err = _data_->_inner_error_;
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_inner_error_ = NULL;
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_error_free0 (_data_->err);
#line 4027 "LibraryMonitor.c"
					}
					__finally486:
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (_data_->info);
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (_data_->file);
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->aux_files = (_vala_array_free (_data_->aux_files, _data_->aux_files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->files = (_vala_array_free (_data_->files, _data_->files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						g_clear_error (&_data_->_inner_error_);
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						g_object_unref (_data_->_async_result);
#line 508 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						return FALSE;
#line 4048 "LibraryMonitor.c"
					}
				}
#line 517 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp32_ = _data_->ctr;
#line 517 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (_data_->_tmp32_ == 0) {
#line 518 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_data_->_tmp34_ = _data_->info;
#line 518 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_data_->_tmp34_ != NULL) {
#line 518 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp35_ = _data_->monitor;
#line 518 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp36_ = _data_->monitorable;
#line 518 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp37_ = media_monitor_is_offline (_data_->_tmp35_, _data_->_tmp36_);
#line 518 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp33_ = _data_->_tmp37_;
#line 4067 "LibraryMonitor.c"
					} else {
#line 518 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp33_ = FALSE;
#line 4071 "LibraryMonitor.c"
					}
#line 518 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_data_->_tmp33_) {
#line 519 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp38_ = _data_->monitor;
#line 519 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp39_ = _data_->monitorable;
#line 519 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						media_monitor_update_online (_data_->_tmp38_, _data_->_tmp39_);
#line 4081 "LibraryMonitor.c"
					} else {
#line 520 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_data_->_tmp41_ = _data_->info;
#line 520 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						if (_data_->_tmp41_ == NULL) {
#line 520 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp42_ = _data_->monitor;
#line 520 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp43_ = _data_->monitorable;
#line 520 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp44_ = media_monitor_is_offline (_data_->_tmp42_, _data_->_tmp43_);
#line 520 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp40_ = !_data_->_tmp44_;
#line 4095 "LibraryMonitor.c"
						} else {
#line 520 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp40_ = FALSE;
#line 4099 "LibraryMonitor.c"
						}
#line 520 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						if (_data_->_tmp40_) {
#line 521 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp45_ = _data_->monitor;
#line 521 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_data_->_tmp46_ = _data_->monitorable;
#line 521 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							media_monitor_update_offline (_data_->_tmp45_, _data_->_tmp46_);
#line 4109 "LibraryMonitor.c"
						}
					}
				}
#line 524 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp47_ = _data_->monitor;
#line 524 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp48_ = _data_->monitorable;
#line 524 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp49_ = _data_->file;
#line 524 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_data_->_tmp50_ = _data_->info;
#line 524 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				media_monitor_update_backing_file_info (_data_->_tmp47_, _data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_);
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->info);
#line 503 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_data_->file);
#line 4127 "LibraryMonitor.c"
			}
		}
	}
#line 527 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp51_ = _data_->self->priv->completed_monitorable_verifies;
#line 527 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->self->priv->completed_monitorable_verifies = _data_->_tmp51_ + 1;
#line 528 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp52_ = _data_->self->priv->completed_monitorable_verifies;
#line 528 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp53_ = _data_->self->priv->total_monitorable_verifies;
#line 528 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_emit (_data_->self, library_monitor_signals[LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL], 0, _data_->_tmp52_, _data_->_tmp53_);
#line 530 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _library_monitor_verify_monitorable_co_gsource_func, _data_, NULL);
#line 531 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_state_ = 2;
#line 531 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return FALSE;
#line 4147 "LibraryMonitor.c"
	_state_2:
	;
#line 534 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp54_ = _data_->self->priv->outstanding_verify_jobs;
#line 534 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_vala_assert (_data_->_tmp54_ > 0, "outstanding_verify_jobs > 0");
#line 535 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->_tmp55_ = _data_->self->priv->outstanding_verify_jobs;
#line 535 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->self->priv->outstanding_verify_jobs = _data_->_tmp55_ - 1;
#line 537 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_execute_next_verify_job (_data_->self);
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->aux_files = (_vala_array_free (_data_->aux_files, _data_->aux_files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_->files = (_vala_array_free (_data_->files, _data_->files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_data_->_state_ != 0) {
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (_data_->_task_complete_ != TRUE) {
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4172 "LibraryMonitor.c"
		}
	}
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 493 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return FALSE;
#line 4179 "LibraryMonitor.c"
}


static void library_monitor_on_config_changed (LibraryMonitor* self) {
	gboolean value = FALSE;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
#line 540 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 541 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = config_facade_get_instance ();
#line 541 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = _tmp0_;
#line 541 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = configuration_facade_get_auto_import_from_library (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 541 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _tmp2_;
#line 541 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_tmp1_);
#line 541 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	value = _tmp3_;
#line 543 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = self->priv->auto_import;
#line 543 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = value;
#line 543 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp4_ == _tmp5_) {
#line 544 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 4215 "LibraryMonitor.c"
	}
#line 546 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = value;
#line 546 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->auto_import = _tmp6_;
#line 547 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = self->priv->auto_import;
#line 547 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp7_) {
#line 4225 "LibraryMonitor.c"
		gboolean _tmp8_;
#line 548 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = commandline_options_no_runtime_monitoring;
#line 548 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (!_tmp8_) {
#line 549 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			library_monitor_import_unrepresented_files (self);
#line 4233 "LibraryMonitor.c"
		}
	} else {
#line 551 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_cancel_batch_imports (self);
#line 4238 "LibraryMonitor.c"
	}
}


static void library_monitor_enqueue_import (LibraryMonitor* self, GFile* file) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeHashSet* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
#line 555 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 555 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = self->priv->pending_imports;
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = file;
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp3_);
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp4_) {
#line 4261 "LibraryMonitor.c"
		GFile* _tmp5_;
		gboolean _tmp6_;
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = file;
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = library_monitor_is_supported_filetype (self, _tmp5_);
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = _tmp6_;
#line 4270 "LibraryMonitor.c"
	} else {
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = FALSE;
#line 4274 "LibraryMonitor.c"
	}
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_) {
#line 4278 "LibraryMonitor.c"
		GFile* _tmp7_;
		gboolean _tmp8_;
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = file;
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = library_monitor_is_blacklisted (_tmp7_);
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = !_tmp8_;
#line 4287 "LibraryMonitor.c"
	} else {
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = FALSE;
#line 4291 "LibraryMonitor.c"
	}
#line 556 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_) {
#line 4295 "LibraryMonitor.c"
		GeeHashSet* _tmp9_;
		GFile* _tmp10_;
#line 557 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = self->priv->import_queue;
#line 557 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp10_ = file;
#line 557 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp10_);
#line 4304 "LibraryMonitor.c"
	}
}


static void library_monitor_enqueue_import_many (LibraryMonitor* self, GeeCollection* files) {
#line 560 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 560 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (GEE_IS_COLLECTION (files));
#line 4314 "LibraryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp0_;
		GeeIterator* _tmp1_;
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = files;
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_file_it = _tmp1_;
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 4327 "LibraryMonitor.c"
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			GFile* file = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GFile* _tmp6_;
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp2_ = _file_it;
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!_tmp3_) {
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 4342 "LibraryMonitor.c"
			}
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp4_ = _file_it;
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			file = (GFile*) _tmp5_;
#line 562 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp6_ = file;
#line 562 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			library_monitor_enqueue_import (self, _tmp6_);
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (file);
#line 4356 "LibraryMonitor.c"
		}
#line 561 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 4360 "LibraryMonitor.c"
	}
}


static void library_monitor_remove_queued_import (LibraryMonitor* self, GFile* file) {
	GeeHashSet* _tmp0_;
	GFile* _tmp1_;
#line 565 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 565 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 566 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->import_queue;
#line 566 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = file;
#line 566 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
#line 4378 "LibraryMonitor.c"
}


static gboolean library_monitor_on_flush_import_queue (LibraryMonitor* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_;
	gboolean _tmp1_;
	GeeHashSet* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BatchImport* _tmp5_;
	GeeHashSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	time_t now = 0;
	gulong _tmp11_;
	gboolean _tmp12_ = FALSE;
	BatchImportRoll* _tmp13_;
	time_t _tmp17_;
	GeeArrayList* jobs = NULL;
	GeeArrayList* _tmp18_;
	GeeHashSet* _tmp33_;
	BatchImport* importer = NULL;
	GeeArrayList* _tmp34_;
	BatchImportRoll* _tmp35_;
	BatchImport* _tmp36_;
	BatchImport* _tmp37_;
	BatchImport* _tmp38_;
	GeeArrayList* _tmp39_;
	BatchImport* _tmp40_;
#line 569 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_MONITOR (self), FALSE);
#line 570 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->cancellable;
#line 570 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = g_cancellable_is_cancelled (_tmp0_);
#line 570 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_) {
#line 571 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		result = FALSE;
#line 571 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return result;
#line 4423 "LibraryMonitor.c"
	}
#line 573 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = self->priv->import_queue;
#line 573 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 573 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 573 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp4_ == 0) {
#line 574 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		result = TRUE;
#line 574 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return result;
#line 4437 "LibraryMonitor.c"
	}
#line 578 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = self->priv->current_batch_import;
#line 578 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp5_ != NULL) {
#line 579 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		result = TRUE;
#line 579 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return result;
#line 4447 "LibraryMonitor.c"
	}
#line 581 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = self->priv->import_queue;
#line 581 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 581 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp8_ = _tmp7_;
#line 581 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp9_ = g_strdup_printf ("Auto-importing %d files", _tmp8_);
#line 581 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp10_ = _tmp9_;
#line 581 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	directory_monitor_mdbg (_tmp10_);
#line 581 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_free0 (_tmp10_);
#line 586 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp11_ = now_sec ();
#line 586 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	now = (time_t) _tmp11_;
#line 587 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp13_ = self->priv->current_import_roll;
#line 587 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp13_ == NULL) {
#line 587 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp12_ = TRUE;
#line 4473 "LibraryMonitor.c"
	} else {
		time_t _tmp14_;
		time_t _tmp15_;
#line 587 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp14_ = now;
#line 587 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp15_ = self->priv->last_import_roll_use;
#line 587 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp12_ = (_tmp14_ - _tmp15_) >= ((time_t) LIBRARY_MONITOR_IMPORT_ROLL_QUIET_SEC);
#line 4483 "LibraryMonitor.c"
	}
#line 587 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp12_) {
#line 4487 "LibraryMonitor.c"
		BatchImportRoll* _tmp16_;
#line 588 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp16_ = batch_import_roll_new ();
#line 588 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_batch_import_roll_unref0 (self->priv->current_import_roll);
#line 588 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		self->priv->current_import_roll = _tmp16_;
#line 4495 "LibraryMonitor.c"
	}
#line 589 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp17_ = now;
#line 589 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->last_import_roll_use = _tmp17_;
#line 591 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp18_ = gee_array_list_new (TYPE_BATCH_IMPORT_JOB, (GBoxedCopyFunc) batch_import_job_ref, (GDestroyNotify) batch_import_job_unref, NULL, NULL, NULL);
#line 591 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	jobs = _tmp18_;
#line 4505 "LibraryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeHashSet* _tmp19_;
		GeeIterator* _tmp20_;
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp19_ = self->priv->import_queue;
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp20_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_file_it = _tmp20_;
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 4518 "LibraryMonitor.c"
			GeeIterator* _tmp21_;
			gboolean _tmp22_;
			GFile* file = NULL;
			GeeIterator* _tmp23_;
			gpointer _tmp24_;
			GFile* _tmp25_;
			gboolean _tmp26_;
			GeeArrayList* _tmp27_;
			GFile* _tmp28_;
			FileImportJob* _tmp29_;
			FileImportJob* _tmp30_;
			GeeHashSet* _tmp31_;
			GFile* _tmp32_;
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp21_ = _file_it;
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp22_ = gee_iterator_next (_tmp21_);
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!_tmp22_) {
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 4540 "LibraryMonitor.c"
			}
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp23_ = _file_it;
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp24_ = gee_iterator_get (_tmp23_);
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			file = (GFile*) _tmp24_;
#line 593 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp25_ = file;
#line 593 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp26_ = library_monitor_is_blacklisted (_tmp25_);
#line 593 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp26_) {
#line 594 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (file);
#line 594 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 4558 "LibraryMonitor.c"
			}
#line 596 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp27_ = jobs;
#line 596 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp28_ = file;
#line 596 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp29_ = file_import_job_new (_tmp28_, FALSE);
#line 596 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp30_ = _tmp29_;
#line 596 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_BATCH_IMPORT_JOB, BatchImportJob));
#line 596 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_batch_import_job_unref0 (_tmp30_);
#line 597 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp31_ = self->priv->pending_imports;
#line 597 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp32_ = file;
#line 597 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp32_);
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (file);
#line 4580 "LibraryMonitor.c"
		}
#line 592 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 4584 "LibraryMonitor.c"
	}
#line 600 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp33_ = self->priv->import_queue;
#line 600 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 602 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp34_ = jobs;
#line 602 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp35_ = self->priv->current_import_roll;
#line 602 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp36_ = batch_import_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ITERABLE, GeeIterable), "LibraryMonitor autoimport", NULL, NULL, NULL, NULL, NULL, _tmp35_, NULL);
#line 602 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	importer = _tmp36_;
#line 604 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp37_ = importer;
#line 604 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	batch_import_set_untrash_duplicates (_tmp37_, FALSE);
#line 605 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp38_ = importer;
#line 605 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	batch_import_set_mark_duplicates_online (_tmp38_, FALSE);
#line 606 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp39_ = self->priv->batch_import_queue;
#line 606 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp40_ = importer;
#line 606 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp40_);
#line 608 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_schedule_next_batch_import (self);
#line 610 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	result = TRUE;
#line 610 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (importer);
#line 610 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (jobs);
#line 610 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 4622 "LibraryMonitor.c"
}


static void _library_monitor_on_import_preparing_batch_import_preparing (BatchImport* _sender, gpointer self) {
#line 618 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_on_import_preparing ((LibraryMonitor*) self);
#line 4629 "LibraryMonitor.c"
}


static void _library_monitor_on_import_progress_batch_import_progress (BatchImport* _sender, guint64 completed_bytes, guint64 total_bytes, gpointer self) {
#line 619 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_on_import_progress ((LibraryMonitor*) self, completed_bytes, total_bytes);
#line 4636 "LibraryMonitor.c"
}


static void _library_monitor_on_import_complete_batch_import_import_complete (BatchImport* _sender, ImportManifest* manifest, BatchImportRoll* import_roll, gpointer self) {
#line 620 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_on_import_complete ((LibraryMonitor*) self, _sender, manifest, import_roll);
#line 4643 "LibraryMonitor.c"
}


static void library_monitor_schedule_next_batch_import (LibraryMonitor* self) {
	gboolean _tmp0_ = FALSE;
	BatchImport* _tmp1_;
	GeeArrayList* _tmp5_;
	gpointer _tmp6_;
	BatchImport* _tmp7_;
	BatchImport* _tmp8_;
	BatchImport* _tmp9_;
	BatchImport* _tmp10_;
#line 613 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 614 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = self->priv->current_batch_import;
#line 614 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_ != NULL) {
#line 614 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = TRUE;
#line 4664 "LibraryMonitor.c"
	} else {
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 614 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = self->priv->batch_import_queue;
#line 614 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 614 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _tmp3_;
#line 614 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = _tmp4_ == 0;
#line 4677 "LibraryMonitor.c"
	}
#line 614 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_) {
#line 615 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 4683 "LibraryMonitor.c"
	}
#line 617 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = self->priv->batch_import_queue;
#line 617 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
#line 617 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->current_batch_import);
#line 617 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->current_batch_import = (BatchImport*) _tmp6_;
#line 618 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = self->priv->current_batch_import;
#line 618 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_connect_object (_tmp7_, "preparing", (GCallback) _library_monitor_on_import_preparing_batch_import_preparing, self, 0);
#line 619 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp8_ = self->priv->current_batch_import;
#line 619 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_connect_object (_tmp8_, "progress", (GCallback) _library_monitor_on_import_progress_batch_import_progress, self, 0);
#line 620 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp9_ = self->priv->current_batch_import;
#line 620 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_connect_object (_tmp9_, "import-complete", (GCallback) _library_monitor_on_import_complete_batch_import_import_complete, self, 0);
#line 621 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp10_ = self->priv->current_batch_import;
#line 621 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	batch_import_schedule (_tmp10_);
#line 4709 "LibraryMonitor.c"
}


static void library_monitor_discard_current_batch_import (LibraryMonitor* self) {
	BatchImport* _tmp0_;
	gboolean removed = FALSE;
	GeeArrayList* _tmp1_;
	BatchImport* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	BatchImport* _tmp5_;
	guint _tmp6_;
	BatchImport* _tmp7_;
	guint _tmp8_;
	BatchImport* _tmp9_;
	guint _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
#line 624 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 625 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->current_batch_import;
#line 625 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_vala_assert (_tmp0_ != NULL, "current_batch_import != null");
#line 627 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = self->priv->batch_import_queue;
#line 627 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = self->priv->current_batch_import;
#line 627 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
#line 627 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	removed = _tmp3_;
#line 628 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = removed;
#line 628 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_vala_assert (_tmp4_, "removed");
#line 629 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = self->priv->current_batch_import;
#line 629 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_parse_name ("preparing", TYPE_BATCH_IMPORT, &_tmp6_, NULL, FALSE);
#line 629 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _library_monitor_on_import_preparing_batch_import_preparing, self);
#line 630 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = self->priv->current_batch_import;
#line 630 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_parse_name ("progress", TYPE_BATCH_IMPORT, &_tmp8_, NULL, FALSE);
#line 630 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _library_monitor_on_import_progress_batch_import_progress, self);
#line 631 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp9_ = self->priv->current_batch_import;
#line 631 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_parse_name ("import-complete", TYPE_BATCH_IMPORT, &_tmp10_, NULL, FALSE);
#line 631 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _library_monitor_on_import_complete_batch_import_import_complete, self);
#line 632 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->current_batch_import);
#line 632 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->current_batch_import = NULL;
#line 639 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp11_ = self->priv->batch_import_queue;
#line 639 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp12_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 639 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp13_ = _tmp12_;
#line 639 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp13_ == 0) {
#line 4777 "LibraryMonitor.c"
		GeeHashSet* _tmp14_;
#line 640 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp14_ = self->priv->pending_imports;
#line 640 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 4783 "LibraryMonitor.c"
	}
}


static void library_monitor_cancel_batch_imports (LibraryMonitor* self) {
	gint ctr = 0;
	BatchImport* _tmp16_;
	GeeHashSet* _tmp18_;
#line 643 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 645 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	ctr = 0;
#line 646 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	while (TRUE) {
#line 4798 "LibraryMonitor.c"
		gint _tmp0_;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gpointer _tmp6_;
		BatchImport* _tmp7_;
		BatchImport* _tmp8_;
		gboolean _tmp9_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gpointer _tmp14_;
		BatchImport* _tmp15_;
#line 646 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = ctr;
#line 646 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = self->priv->batch_import_queue;
#line 646 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 646 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = _tmp2_;
#line 646 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (!(_tmp0_ < _tmp3_)) {
#line 646 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			break;
#line 4826 "LibraryMonitor.c"
		}
#line 647 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = self->priv->batch_import_queue;
#line 647 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = ctr;
#line 647 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp5_);
#line 647 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = (BatchImport*) _tmp6_;
#line 647 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = self->priv->current_batch_import;
#line 647 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = _tmp7_ == _tmp8_;
#line 647 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_tmp7_);
#line 647 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_tmp9_) {
#line 4844 "LibraryMonitor.c"
			gint _tmp10_;
#line 648 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = ctr;
#line 648 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			ctr = _tmp10_ + 1;
#line 650 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			continue;
#line 4852 "LibraryMonitor.c"
		}
#line 653 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp11_ = self->priv->batch_import_queue;
#line 653 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp12_ = self->priv->batch_import_queue;
#line 653 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp13_ = ctr;
#line 653 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp14_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp13_);
#line 653 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp15_ = (BatchImport*) _tmp14_;
#line 653 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 653 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_tmp15_);
#line 4868 "LibraryMonitor.c"
	}
#line 657 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp16_ = self->priv->current_batch_import;
#line 657 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp16_ != NULL) {
#line 4874 "LibraryMonitor.c"
		BatchImport* _tmp17_;
#line 658 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp17_ = self->priv->current_batch_import;
#line 658 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		batch_import_user_halt (_tmp17_);
#line 4880 "LibraryMonitor.c"
	}
#line 661 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp18_ = self->priv->pending_imports;
#line 661 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 4886 "LibraryMonitor.c"
}


static void library_monitor_on_import_preparing (LibraryMonitor* self) {
#line 664 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 665 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_emit (self, library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PREPARING_SIGNAL], 0);
#line 4895 "LibraryMonitor.c"
}


static void library_monitor_on_import_progress (LibraryMonitor* self, guint64 completed_bytes, guint64 total_bytes) {
	guint64 _tmp0_;
	guint64 _tmp1_;
#line 668 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 669 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = completed_bytes;
#line 669 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = total_bytes;
#line 669 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_emit (self, library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PROGRESS_SIGNAL], 0, _tmp0_, _tmp1_);
#line 4910 "LibraryMonitor.c"
}


static void library_monitor_on_import_complete (LibraryMonitor* self, BatchImport* batch_import, ImportManifest* manifest, BatchImportRoll* import_roll) {
	BatchImport* _tmp0_;
	BatchImport* _tmp1_;
	ImportManifest* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ImportManifest* _tmp25_;
	GeeList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GeeHashSet* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GError * _inner_error_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 672 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_BATCH_IMPORT (batch_import));
#line 672 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_IMPORT_MANIFEST (manifest));
#line 672 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_BATCH_IMPORT_ROLL (import_roll));
#line 674 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = batch_import;
#line 674 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = self->priv->current_batch_import;
#line 674 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_vala_assert (_tmp0_ == _tmp1_, "batch_import == current_batch_import");
#line 676 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = manifest;
#line 676 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _tmp2_->all;
#line 676 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 676 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = _tmp4_;
#line 676 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = g_strdup_printf ("auto-import batch completed %d", _tmp5_);
#line 676 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = _tmp6_;
#line 676 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	directory_monitor_mdbg (_tmp7_);
#line 676 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_free0 (_tmp7_);
#line 677 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_emit (self, library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PROGRESS_SIGNAL], 0, (guint64) 0, (guint64) 0);
#line 4965 "LibraryMonitor.c"
	{
		GeeList* _result_list = NULL;
		ImportManifest* _tmp8_;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		gint _result_size = 0;
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _result_index = 0;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = manifest;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = _tmp8_->all;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_result_list = _tmp10_;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp11_ = _result_list;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp13_ = _tmp12_;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_result_size = _tmp13_;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_result_index = -1;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 4996 "LibraryMonitor.c"
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			BatchImportResult* _result_ = NULL;
			GeeList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			BatchImportResult* _tmp20_;
			GFile* _tmp21_;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = _result_index;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_result_index = _tmp14_ + 1;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = _result_index;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = _result_size;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp15_ < _tmp16_)) {
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 5018 "LibraryMonitor.c"
			}
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp17_ = _result_list;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp18_ = _result_index;
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_result_ = (BatchImportResult*) _tmp19_;
#line 682 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp20_ = _result_;
#line 682 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp21_ = _tmp20_->file;
#line 682 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp21_ != NULL) {
#line 5034 "LibraryMonitor.c"
				GeeHashSet* _tmp22_;
				BatchImportResult* _tmp23_;
				GFile* _tmp24_;
#line 683 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp22_ = self->priv->pending_imports;
#line 683 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp23_ = _result_;
#line 683 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp24_ = _tmp23_->file;
#line 683 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp24_);
#line 5046 "LibraryMonitor.c"
			}
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_batch_import_result_unref0 (_result_);
#line 5050 "LibraryMonitor.c"
		}
#line 679 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_result_list);
#line 5054 "LibraryMonitor.c"
	}
#line 686 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp25_ = manifest;
#line 686 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp26_ = _tmp25_->already_imported;
#line 686 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp27_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection));
#line 686 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp28_ = _tmp27_;
#line 686 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp28_ > 0) {
#line 5066 "LibraryMonitor.c"
		GeeArrayList* to_tombstone = NULL;
		GeeArrayList* _tmp29_;
#line 687 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp29_ = gee_array_list_new (TYPE_TOMBSTONED_FILE, (GBoxedCopyFunc) tombstoned_file_ref, (GDestroyNotify) tombstoned_file_unref, NULL, NULL, NULL);
#line 687 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		to_tombstone = _tmp29_;
#line 5073 "LibraryMonitor.c"
		{
			GeeList* _result_list = NULL;
			ImportManifest* _tmp30_;
			GeeList* _tmp31_;
			GeeList* _tmp32_;
			gint _result_size = 0;
			GeeList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _result_index = 0;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp30_ = manifest;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp31_ = _tmp30_->already_imported;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp32_ = _g_object_ref0 (_tmp31_);
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_result_list = _tmp32_;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp33_ = _result_list;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp34_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_COLLECTION, GeeCollection));
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp35_ = _tmp34_;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_result_size = _tmp35_;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_result_index = -1;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			while (TRUE) {
#line 5104 "LibraryMonitor.c"
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				BatchImportResult* _result_ = NULL;
				GeeList* _tmp39_;
				gint _tmp40_;
				gpointer _tmp41_;
				GFileInfo* info = NULL;
				BatchImportResult* _tmp42_;
				GFile* _tmp43_;
				GFileInfo* _tmp44_;
				GFileInfo* _tmp45_;
				GeeArrayList* _tmp50_;
				BatchImportResult* _tmp51_;
				GFile* _tmp52_;
				GFileInfo* _tmp53_;
				gint64 _tmp54_;
				TombstonedFile* _tmp55_;
				TombstonedFile* _tmp56_;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp36_ = _result_index;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_result_index = _tmp36_ + 1;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp37_ = _result_index;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp38_ = _result_size;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (!(_tmp37_ < _tmp38_)) {
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					break;
#line 5136 "LibraryMonitor.c"
				}
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp39_ = _result_list;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp40_ = _result_index;
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp41_ = gee_list_get (_tmp39_, _tmp40_);
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_result_ = (BatchImportResult*) _tmp41_;
#line 689 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp42_ = _result_;
#line 689 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp43_ = _tmp42_->file;
#line 689 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp44_ = directory_monitor_get_file_info (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp43_);
#line 689 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				info = _tmp44_;
#line 690 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp45_ = info;
#line 690 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (_tmp45_ == NULL) {
#line 5158 "LibraryMonitor.c"
					BatchImportResult* _tmp46_;
					GFile* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
#line 691 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp46_ = _result_;
#line 691 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp47_ = _tmp46_->file;
#line 691 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp48_ = g_file_get_path (_tmp47_);
#line 691 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp49_ = _tmp48_;
#line 691 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					g_warning ("LibraryMonitor.vala:691: Unable to get info for duplicate file %s", _tmp49_);
#line 691 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_free0 (_tmp49_);
#line 693 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (info);
#line 693 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_batch_import_result_unref0 (_result_);
#line 693 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					continue;
#line 5181 "LibraryMonitor.c"
				}
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp50_ = to_tombstone;
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp51_ = _result_;
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp52_ = _tmp51_->file;
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp53_ = info;
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp54_ = g_file_info_get_size (_tmp53_);
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp55_ = tombstoned_file_new (_tmp52_, _tmp54_, NULL);
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp56_ = _tmp55_;
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp56_);
#line 696 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tombstoned_file_unref0 (_tmp56_);
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (info);
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_batch_import_result_unref0 (_result_);
#line 5205 "LibraryMonitor.c"
			}
#line 688 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (_result_list);
#line 5209 "LibraryMonitor.c"
		}
		{
			GeeArrayList* _tmp57_;
#line 700 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp57_ = to_tombstone;
#line 700 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			tombstone_entomb_many_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GEE_TYPE_COLLECTION, GeeCollection), TOMBSTONE_REASON_AUTO_DETECTED_DUPLICATE, &_inner_error_);
#line 700 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 700 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 5221 "LibraryMonitor.c"
					goto __catch487_database_error;
				}
#line 700 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (to_tombstone);
#line 700 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 700 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				g_clear_error (&_inner_error_);
#line 700 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				return;
#line 5232 "LibraryMonitor.c"
			}
		}
		goto __finally487;
		__catch487_database_error:
		{
			GError* err = NULL;
			GError* _tmp58_;
#line 699 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			err = _inner_error_;
#line 699 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_inner_error_ = NULL;
#line 702 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp58_ = err;
#line 702 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			app_window_database_error (_tmp58_);
#line 699 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_error_free0 (err);
#line 5250 "LibraryMonitor.c"
		}
		__finally487:
#line 699 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 699 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (to_tombstone);
#line 699 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 699 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_clear_error (&_inner_error_);
#line 699 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return;
#line 5263 "LibraryMonitor.c"
		}
#line 686 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (to_tombstone);
#line 5267 "LibraryMonitor.c"
	}
#line 706 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp59_ = self->priv->pending_imports;
#line 706 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp60_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 706 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp61_ = _tmp60_;
#line 706 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp62_ = g_strdup_printf ("%d files remain pending for auto-import", _tmp61_);
#line 706 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp63_ = _tmp62_;
#line 706 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	directory_monitor_mdbg (_tmp63_);
#line 706 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_free0 (_tmp63_);
#line 708 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_discard_current_batch_import (self);
#line 709 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_schedule_next_batch_import (self);
#line 5287 "LibraryMonitor.c"
}


void library_monitor_blacklist_file (GFile* file, const gchar* reason) {
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 725 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 725 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (reason != NULL);
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = reason;
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = file;
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _tmp2_;
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = g_strdup_printf ("[%s] Blacklisting %s", _tmp0_, _tmp3_);
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = _tmp4_;
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	directory_monitor_mdbg (_tmp5_);
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_free0 (_tmp5_);
#line 726 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_free0 (_tmp3_);
#line 5321 "LibraryMonitor.c"
	{
		GeeHashSet* _tmp6_;
#line 727 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = library_monitor_blacklist;
#line 727 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_rec_mutex_lock (&__lock_library_monitor_blacklist);
#line 5328 "LibraryMonitor.c"
		{
			GeeHashSet* _tmp7_;
			GFile* _tmp8_;
#line 728 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp7_ = library_monitor_blacklist;
#line 728 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = file;
#line 728 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
#line 5338 "LibraryMonitor.c"
		}
		__finally488:
		{
			GeeHashSet* _tmp9_;
#line 727 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = library_monitor_blacklist;
#line 727 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_rec_mutex_unlock (&__lock_library_monitor_blacklist);
#line 5347 "LibraryMonitor.c"
		}
#line 727 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 727 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 727 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_clear_error (&_inner_error_);
#line 727 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return;
#line 5357 "LibraryMonitor.c"
		}
	}
}


void library_monitor_unblacklist_file (GFile* file) {
	GError * _inner_error_ = NULL;
#line 732 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 5367 "LibraryMonitor.c"
	{
		GeeHashSet* _tmp0_;
#line 735 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = library_monitor_blacklist;
#line 735 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_rec_mutex_lock (&__lock_library_monitor_blacklist);
#line 5374 "LibraryMonitor.c"
		{
			gboolean _tmp1_ = FALSE;
			GeeHashSet* _tmp2_;
			GFile* _tmp3_;
			gboolean _tmp4_;
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp2_ = library_monitor_blacklist;
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp3_ = file;
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp4_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp3_);
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp4_) {
#line 5388 "LibraryMonitor.c"
				HashTimedQueue* _tmp5_;
				GFile* _tmp6_;
				gboolean _tmp7_;
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp5_ = library_monitor_to_unblacklist;
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp6_ = file;
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp7_ = timed_queue_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_TIMED_QUEUE, TimedQueue), _tmp6_);
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp1_ = !_tmp7_;
#line 5400 "LibraryMonitor.c"
			} else {
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp1_ = FALSE;
#line 5404 "LibraryMonitor.c"
			}
#line 736 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp1_) {
#line 5408 "LibraryMonitor.c"
				HashTimedQueue* _tmp8_;
				GFile* _tmp9_;
#line 737 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp8_ = library_monitor_to_unblacklist;
#line 737 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp9_ = file;
#line 737 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				timed_queue_enqueue (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_TIMED_QUEUE, TimedQueue), _tmp9_);
#line 5417 "LibraryMonitor.c"
			}
		}
		__finally489:
		{
			GeeHashSet* _tmp10_;
#line 735 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = library_monitor_blacklist;
#line 735 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_rec_mutex_unlock (&__lock_library_monitor_blacklist);
#line 5427 "LibraryMonitor.c"
		}
#line 735 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 735 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 735 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_clear_error (&_inner_error_);
#line 735 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return;
#line 5437 "LibraryMonitor.c"
		}
	}
}


static void library_monitor_on_unblacklist_file (GFile* file) {
	gboolean removed = FALSE;
	GError * _inner_error_ = NULL;
#line 741 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 5448 "LibraryMonitor.c"
	{
		GeeHashSet* _tmp0_;
#line 743 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = library_monitor_blacklist;
#line 743 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_rec_mutex_lock (&__lock_library_monitor_blacklist);
#line 5455 "LibraryMonitor.c"
		{
			GeeHashSet* _tmp1_;
			GFile* _tmp2_;
			gboolean _tmp3_;
#line 744 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp1_ = library_monitor_blacklist;
#line 744 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp2_ = file;
#line 744 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp3_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
#line 744 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			removed = _tmp3_;
#line 5468 "LibraryMonitor.c"
		}
		__finally490:
		{
			GeeHashSet* _tmp4_;
#line 743 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp4_ = library_monitor_blacklist;
#line 743 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_rec_mutex_unlock (&__lock_library_monitor_blacklist);
#line 5477 "LibraryMonitor.c"
		}
#line 743 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 743 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 743 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_clear_error (&_inner_error_);
#line 743 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return;
#line 5487 "LibraryMonitor.c"
		}
	}
#line 747 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (removed) {
#line 5492 "LibraryMonitor.c"
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
#line 748 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = file;
#line 748 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = g_file_get_path (_tmp5_);
#line 748 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = _tmp6_;
#line 748 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = g_strdup_printf ("Blacklist for %s removed", _tmp7_);
#line 748 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = _tmp8_;
#line 748 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		directory_monitor_mdbg (_tmp9_);
#line 748 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp9_);
#line 748 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp7_);
#line 5514 "LibraryMonitor.c"
	} else {
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
#line 750 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp10_ = file;
#line 750 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp11_ = g_file_get_path (_tmp10_);
#line 750 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp12_ = _tmp11_;
#line 750 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_warning ("LibraryMonitor.vala:750: File %s was not blacklisted but unblacklisted", _tmp12_);
#line 750 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp12_);
#line 5529 "LibraryMonitor.c"
	}
}


gboolean library_monitor_is_blacklisted (GFile* file) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 753 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 5539 "LibraryMonitor.c"
	{
		GeeHashSet* _tmp0_;
		gboolean _tmp6_ = FALSE;
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = library_monitor_blacklist;
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_rec_mutex_lock (&__lock_library_monitor_blacklist);
#line 5547 "LibraryMonitor.c"
		{
			GeeHashSet* _tmp1_;
			GFile* _tmp2_;
			gboolean _tmp3_;
#line 755 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp1_ = library_monitor_blacklist;
#line 755 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp2_ = file;
#line 755 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp3_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp2_);
#line 755 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			result = _tmp3_;
#line 5560 "LibraryMonitor.c"
			{
				GeeHashSet* _tmp4_;
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp4_ = library_monitor_blacklist;
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				g_rec_mutex_unlock (&__lock_library_monitor_blacklist);
#line 5567 "LibraryMonitor.c"
			}
#line 755 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return result;
#line 5571 "LibraryMonitor.c"
		}
		__finally491:
		{
			GeeHashSet* _tmp5_;
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp5_ = library_monitor_blacklist;
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_rec_mutex_unlock (&__lock_library_monitor_blacklist);
#line 5580 "LibraryMonitor.c"
		}
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 754 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return _tmp6_;
#line 5588 "LibraryMonitor.c"
	}
}


static gboolean library_monitor_is_supported_filetype (LibraryMonitor* self, GFile* file) {
	gboolean result = FALSE;
	MediaCollectionRegistry* _tmp0_;
	MediaCollectionRegistry* _tmp1_;
	GFile* _tmp2_;
	MediaSourceCollection* _tmp3_;
	MediaSourceCollection* _tmp4_;
	gboolean _tmp5_;
#line 759 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_MONITOR (self), FALSE);
#line 759 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = media_collection_registry_get_instance ();
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = _tmp0_;
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = file;
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = media_collection_registry_get_collection_for_file (_tmp1_, _tmp2_);
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = _tmp4_ != NULL;
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_data_collection_unref0 (_tmp4_);
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_media_collection_registry_unref0 (_tmp1_);
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	result = _tmp5_;
#line 760 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return result;
#line 5625 "LibraryMonitor.c"
}


static void library_monitor_import_unrepresented_files (LibraryMonitor* self) {
	gboolean _tmp0_;
	GeeArrayList* to_import = NULL;
	GeeArrayList* _tmp42_;
#line 765 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 766 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->priv->auto_import;
#line 766 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp0_) {
#line 767 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 5641 "LibraryMonitor.c"
	}
#line 769 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	to_import = NULL;
#line 5645 "LibraryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = directory_monitor_get_files (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor));
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = _tmp1_;
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _tmp3_;
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_file_it = _tmp4_;
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 5666 "LibraryMonitor.c"
			GeeIterator* _tmp5_;
			gboolean _tmp6_;
			GFile* file = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GFileInfo* info = NULL;
			GFile* _tmp9_;
			GFileInfo* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GFileInfo* _tmp12_;
			GeeHashSet* _tmp15_;
			GFile* _tmp16_;
			gboolean _tmp17_;
			TombstoneSourceCollection* _tmp18_;
			GFile* _tmp19_;
			gboolean _tmp20_;
			gboolean represented = FALSE;
			gboolean _tmp35_;
			GFile* _tmp36_;
			gboolean _tmp37_;
			GeeArrayList* _tmp38_;
			GeeArrayList* _tmp40_;
			GFile* _tmp41_;
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp5_ = _file_it;
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp6_ = gee_iterator_next (_tmp5_);
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!_tmp6_) {
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 5698 "LibraryMonitor.c"
			}
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp7_ = _file_it;
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			file = (GFile*) _tmp8_;
#line 771 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = file;
#line 771 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = directory_monitor_get_file_info (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp9_);
#line 771 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			info = _tmp10_;
#line 772 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = info;
#line 772 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp12_ == NULL) {
#line 772 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp11_ = TRUE;
#line 5718 "LibraryMonitor.c"
			} else {
				GFileInfo* _tmp13_;
				GFileType _tmp14_;
#line 772 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp13_ = info;
#line 772 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp14_ = g_file_info_get_file_type (_tmp13_);
#line 772 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp11_ = _tmp14_ != G_FILE_TYPE_REGULAR;
#line 5728 "LibraryMonitor.c"
			}
#line 772 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp11_) {
#line 773 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (info);
#line 773 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (file);
#line 773 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 5738 "LibraryMonitor.c"
			}
#line 775 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = self->priv->pending_imports;
#line 775 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = file;
#line 775 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp17_ = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp16_);
#line 775 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp17_) {
#line 776 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (info);
#line 776 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (file);
#line 776 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 5754 "LibraryMonitor.c"
			}
#line 778 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp18_ = tombstone_global;
#line 778 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp19_ = file;
#line 778 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp20_ = tombstone_source_collection_matches (_tmp18_, _tmp19_);
#line 778 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp20_) {
#line 779 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (info);
#line 779 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (file);
#line 779 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 5770 "LibraryMonitor.c"
			}
#line 781 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			represented = FALSE;
#line 5774 "LibraryMonitor.c"
			{
				GeeList* _monitor_list = NULL;
				GeeList* _tmp21_;
				GeeList* _tmp22_;
				gint _monitor_size = 0;
				GeeList* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _monitor_index = 0;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp21_ = self->priv->monitors;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp22_ = _g_object_ref0 (_tmp21_);
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_monitor_list = _tmp22_;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp23_ = _monitor_list;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp24_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection));
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp25_ = _tmp24_;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_monitor_size = _tmp25_;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_monitor_index = -1;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				while (TRUE) {
#line 5802 "LibraryMonitor.c"
					gint _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					MediaMonitor* monitor = NULL;
					GeeList* _tmp29_;
					gint _tmp30_;
					gpointer _tmp31_;
					MediaMonitor* _tmp32_;
					GFile* _tmp33_;
					gboolean _tmp34_;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp26_ = _monitor_index;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_monitor_index = _tmp26_ + 1;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp27_ = _monitor_index;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp28_ = _monitor_size;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (!(_tmp27_ < _tmp28_)) {
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						break;
#line 5825 "LibraryMonitor.c"
					}
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp29_ = _monitor_list;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp30_ = _monitor_index;
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp31_ = gee_list_get (_tmp29_, _tmp30_);
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					monitor = (MediaMonitor*) _tmp31_;
#line 783 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp32_ = monitor;
#line 783 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp33_ = file;
#line 783 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp34_ = media_monitor_is_file_represented (_tmp32_, _tmp33_);
#line 783 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_tmp34_) {
#line 784 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						represented = TRUE;
#line 786 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_object_unref0 (monitor);
#line 786 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						break;
#line 5849 "LibraryMonitor.c"
					}
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (monitor);
#line 5853 "LibraryMonitor.c"
				}
#line 782 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (_monitor_list);
#line 5857 "LibraryMonitor.c"
			}
#line 790 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp35_ = represented;
#line 790 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp35_) {
#line 791 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (info);
#line 791 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (file);
#line 791 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 5869 "LibraryMonitor.c"
			}
#line 793 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp36_ = file;
#line 793 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp37_ = library_monitor_is_supported_filetype (self, _tmp36_);
#line 793 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!_tmp37_) {
#line 794 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (info);
#line 794 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (file);
#line 794 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 5883 "LibraryMonitor.c"
			}
#line 796 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp38_ = to_import;
#line 796 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp38_ == NULL) {
#line 5889 "LibraryMonitor.c"
				GeeArrayList* _tmp39_;
#line 797 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp39_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 797 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (to_import);
#line 797 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				to_import = _tmp39_;
#line 5897 "LibraryMonitor.c"
			}
#line 799 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp40_ = to_import;
#line 799 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp41_ = file;
#line 799 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp41_);
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (info);
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (file);
#line 5909 "LibraryMonitor.c"
		}
#line 770 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 5913 "LibraryMonitor.c"
	}
#line 802 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp42_ = to_import;
#line 802 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp42_ != NULL) {
#line 5919 "LibraryMonitor.c"
		GeeArrayList* _tmp43_;
#line 803 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp43_ = to_import;
#line 803 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_enqueue_import_many (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_COLLECTION, GeeCollection));
#line 5925 "LibraryMonitor.c"
	}
#line 765 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (to_import);
#line 5929 "LibraryMonitor.c"
}


static void library_monitor_runtime_unknown_file_discovered (LibraryMonitor* self, GFile* file) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
#line 808 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 808 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = self->priv->auto_import;
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp2_) {
#line 5945 "LibraryMonitor.c"
		GFile* _tmp3_;
		gboolean _tmp4_;
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = file;
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = library_monitor_is_supported_filetype (self, _tmp3_);
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = _tmp4_;
#line 5954 "LibraryMonitor.c"
	} else {
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = FALSE;
#line 5958 "LibraryMonitor.c"
	}
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_) {
#line 5962 "LibraryMonitor.c"
		TombstoneSourceCollection* _tmp5_;
		GFile* _tmp6_;
		gboolean _tmp7_;
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = tombstone_global;
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = file;
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = tombstone_source_collection_matches (_tmp5_, _tmp6_);
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = !_tmp7_;
#line 5974 "LibraryMonitor.c"
	} else {
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = FALSE;
#line 5978 "LibraryMonitor.c"
	}
#line 809 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_) {
#line 5982 "LibraryMonitor.c"
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GFile* _tmp13_;
#line 810 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = file;
#line 810 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 810 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp10_ = _tmp9_;
#line 810 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp11_ = g_strdup_printf ("Unknown file %s discovered, enqueuing for import", _tmp10_);
#line 810 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp12_ = _tmp11_;
#line 810 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		directory_monitor_mdbg (_tmp12_);
#line 810 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp12_);
#line 810 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp10_);
#line 811 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp13_ = file;
#line 811 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_enqueue_import (self, _tmp13_);
#line 6009 "LibraryMonitor.c"
	}
}


static void library_monitor_real_notify_file_created (DirectoryMonitor* base, GFile* file, GFileInfo* info) {
	LibraryMonitor * self;
	GFile* _tmp0_;
	gboolean _tmp1_;
	gboolean known = FALSE;
	gboolean _tmp19_;
	gboolean _tmp98_;
	GFile* _tmp100_;
	GFileInfo* _tmp101_;
#line 815 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 815 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 815 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 816 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = file;
#line 816 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = library_monitor_is_blacklisted (_tmp0_);
#line 816 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_) {
#line 6035 "LibraryMonitor.c"
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
#line 817 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = file;
#line 817 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = info;
#line 817 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_created (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp2_, _tmp3_);
#line 819 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 6046 "LibraryMonitor.c"
	}
#line 822 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	known = FALSE;
#line 6050 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		gint _monitor_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _monitor_index = 0;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = self->priv->monitors;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp5_;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = _monitor_list;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = _tmp7_;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp8_;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 6078 "LibraryMonitor.c"
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			MediaMonitor* _tmp15_;
			GFile* _tmp16_;
			GFileInfo* _tmp17_;
			gboolean _tmp18_;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_index;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp9_ + 1;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = _monitor_index;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = _monitor_size;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 6102 "LibraryMonitor.c"
			}
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = _monitor_list;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = _monitor_index;
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp14_;
#line 824 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = monitor;
#line 824 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = file;
#line 824 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp17_ = info;
#line 824 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp18_ = media_monitor_notify_file_created (_tmp15_, _tmp16_, _tmp17_);
#line 824 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp18_) {
#line 825 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				known = TRUE;
#line 827 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (monitor);
#line 827 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 6128 "LibraryMonitor.c"
			}
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 6132 "LibraryMonitor.c"
		}
#line 823 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 6136 "LibraryMonitor.c"
	}
#line 831 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp19_ = known;
#line 831 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp19_) {
#line 6142 "LibraryMonitor.c"
		GeeHashSet* all_candidates = NULL;
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		gboolean _tmp80_;
#line 833 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		all_candidates = NULL;
#line 6149 "LibraryMonitor.c"
		{
			GeeList* _monitor_list = NULL;
			GeeList* _tmp20_;
			GeeList* _tmp21_;
			gint _monitor_size = 0;
			GeeList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _monitor_index = 0;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp20_ = self->priv->monitors;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp21_ = _g_object_ref0 (_tmp20_);
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_list = _tmp21_;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp22_ = _monitor_list;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp23_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection));
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp24_ = _tmp23_;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_size = _tmp24_;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = -1;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			while (TRUE) {
#line 6177 "LibraryMonitor.c"
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				MediaMonitor* monitor = NULL;
				GeeList* _tmp28_;
				gint _tmp29_;
				gpointer _tmp30_;
				MediaMonitorDiscoveredFile _result_ = 0;
				GeeCollection* candidates = NULL;
				MediaMonitor* _tmp31_;
				GFile* _tmp32_;
				GFileInfo* _tmp33_;
				MediaMonitorDiscoveredFile _tmp34_ = 0;
				GeeCollection* _tmp35_;
				gboolean _tmp36_ = FALSE;
				MediaMonitorDiscoveredFile _tmp37_;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp25_ = _monitor_index;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_monitor_index = _tmp25_ + 1;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp26_ = _monitor_index;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp27_ = _monitor_size;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (!(_tmp26_ < _tmp27_)) {
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					break;
#line 6206 "LibraryMonitor.c"
				}
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp28_ = _monitor_list;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp29_ = _monitor_index;
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				monitor = (MediaMonitor*) _tmp30_;
#line 836 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp31_ = monitor;
#line 836 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp32_ = file;
#line 836 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp33_ = info;
#line 836 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp35_ = media_monitor_candidates_for_unknown_file (_tmp31_, _tmp32_, _tmp33_, &_tmp34_);
#line 836 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_result_ = _tmp34_;
#line 836 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				candidates = _tmp35_;
#line 838 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp37_ = _result_;
#line 838 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (_tmp37_ == MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED) {
#line 838 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp36_ = TRUE;
#line 6234 "LibraryMonitor.c"
				} else {
					MediaMonitorDiscoveredFile _tmp38_;
#line 839 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp38_ = _result_;
#line 839 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp36_ = _tmp38_ == MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
#line 6241 "LibraryMonitor.c"
				}
#line 838 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (_tmp36_) {
#line 6245 "LibraryMonitor.c"
					MediaMonitor* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					MediaMonitorDiscoveredFile _tmp42_;
					GEnumValue* _tmp43_;
					GFile* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp39_ = monitor;
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp40_ = media_monitor_to_string (_tmp39_);
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp41_ = _tmp40_;
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp42_ = _result_;
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp43_ = g_enum_get_value (g_type_class_ref (MEDIA_MONITOR_TYPE_DISCOVERED_FILE), _tmp42_);
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp44_ = file;
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp45_ = g_file_get_path (_tmp44_);
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp46_ = _tmp45_;
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp47_ = g_strdup_printf ("%s %s created file %s", _tmp41_, (_tmp43_ != NULL) ? _tmp43_->value_name : NULL, _tmp46_);
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp48_ = _tmp47_;
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					directory_monitor_mdbg (_tmp48_);
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_free0 (_tmp48_);
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_free0 (_tmp46_);
#line 840 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_free0 (_tmp41_);
#line 843 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					known = TRUE;
#line 845 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (candidates);
#line 845 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (monitor);
#line 845 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					break;
#line 6292 "LibraryMonitor.c"
				} else {
					gboolean _tmp49_ = FALSE;
					GeeCollection* _tmp50_;
#line 846 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp50_ = candidates;
#line 846 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_tmp50_ != NULL) {
#line 6300 "LibraryMonitor.c"
						GeeCollection* _tmp51_;
						gint _tmp52_;
						gint _tmp53_;
#line 846 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp51_ = candidates;
#line 846 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp52_ = gee_collection_get_size (_tmp51_);
#line 846 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp53_ = _tmp52_;
#line 846 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp49_ = _tmp53_ > 0;
#line 6312 "LibraryMonitor.c"
					} else {
#line 846 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp49_ = FALSE;
#line 6316 "LibraryMonitor.c"
					}
#line 846 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					if (_tmp49_) {
#line 6320 "LibraryMonitor.c"
						MediaMonitor* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						GeeCollection* _tmp57_;
						gint _tmp58_;
						gint _tmp59_;
						GFile* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						gchar* _tmp64_;
						GeeHashSet* _tmp65_;
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp54_ = monitor;
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp55_ = media_monitor_to_string (_tmp54_);
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp56_ = _tmp55_;
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp57_ = candidates;
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp58_ = gee_collection_get_size (_tmp57_);
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp59_ = _tmp58_;
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp60_ = file;
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp61_ = g_file_get_path (_tmp60_);
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp62_ = _tmp61_;
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp63_ = g_strdup_printf ("%s suggests %d candidates for created file %s", _tmp56_, _tmp59_, _tmp62_);
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp64_ = _tmp63_;
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						directory_monitor_mdbg (_tmp64_);
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_free0 (_tmp64_);
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_free0 (_tmp62_);
#line 847 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_g_free0 (_tmp56_);
#line 850 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						_tmp65_ = all_candidates;
#line 850 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
						if (_tmp65_ == NULL) {
#line 6367 "LibraryMonitor.c"
							GeeHashSet* _tmp66_;
#line 851 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_tmp66_ = gee_hash_set_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 851 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_g_object_unref0 (all_candidates);
#line 851 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							all_candidates = _tmp66_;
#line 6375 "LibraryMonitor.c"
						}
						{
							GeeIterator* _candidate_it = NULL;
							GeeCollection* _tmp67_;
							GeeIterator* _tmp68_;
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_tmp67_ = candidates;
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_tmp68_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GEE_TYPE_ITERABLE, GeeIterable));
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_candidate_it = _tmp68_;
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							while (TRUE) {
#line 6389 "LibraryMonitor.c"
								GeeIterator* _tmp69_;
								gboolean _tmp70_;
								Monitorable* candidate = NULL;
								GeeIterator* _tmp71_;
								gpointer _tmp72_;
								MediaMonitor* _tmp73_;
								Monitorable* _tmp74_;
								gboolean _tmp75_;
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								_tmp69_ = _candidate_it;
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								_tmp70_ = gee_iterator_next (_tmp69_);
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								if (!_tmp70_) {
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
									break;
#line 6406 "LibraryMonitor.c"
								}
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								_tmp71_ = _candidate_it;
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								_tmp72_ = gee_iterator_get (_tmp71_);
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								candidate = (Monitorable*) _tmp72_;
#line 854 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								_tmp73_ = monitor;
#line 854 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								_tmp74_ = candidate;
#line 854 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								_tmp75_ = media_monitor_is_offline (_tmp73_, _tmp74_);
#line 854 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								if (_tmp75_) {
#line 6422 "LibraryMonitor.c"
									GeeHashSet* _tmp76_;
									Monitorable* _tmp77_;
#line 855 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
									_tmp76_ = all_candidates;
#line 855 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
									_tmp77_ = candidate;
#line 855 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
									gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp77_);
#line 6431 "LibraryMonitor.c"
								}
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
								_g_object_unref0 (candidate);
#line 6435 "LibraryMonitor.c"
							}
#line 853 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
							_g_object_unref0 (_candidate_it);
#line 6439 "LibraryMonitor.c"
						}
					}
				}
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (candidates);
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (monitor);
#line 6447 "LibraryMonitor.c"
			}
#line 834 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (_monitor_list);
#line 6451 "LibraryMonitor.c"
		}
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp80_ = known;
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (!_tmp80_) {
#line 6457 "LibraryMonitor.c"
			GeeHashSet* _tmp81_;
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp81_ = all_candidates;
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp79_ = _tmp81_ != NULL;
#line 6463 "LibraryMonitor.c"
		} else {
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp79_ = FALSE;
#line 6467 "LibraryMonitor.c"
		}
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_tmp79_) {
#line 6471 "LibraryMonitor.c"
			GeeHashSet* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp82_ = all_candidates;
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp83_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp84_ = _tmp83_;
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp78_ = _tmp84_ > 0;
#line 6483 "LibraryMonitor.c"
		} else {
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp78_ = FALSE;
#line 6487 "LibraryMonitor.c"
		}
#line 860 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_tmp78_) {
#line 6491 "LibraryMonitor.c"
			GeeHashSet* _tmp85_;
			gint _tmp86_;
			gint _tmp87_;
			GFile* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			Workers* _tmp93_;
			GFile* _tmp94_;
			GeeHashSet* _tmp95_;
			LibraryMonitorRuntimeFindMoveJob* _tmp96_;
			LibraryMonitorRuntimeFindMoveJob* _tmp97_;
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp85_ = all_candidates;
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp86_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp87_ = _tmp86_;
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp88_ = file;
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp89_ = g_file_get_path (_tmp88_);
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp90_ = _tmp89_;
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp91_ = g_strdup_printf ("%d candidates for created file %s being checksummed", _tmp87_, _tmp90_);
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp92_ = _tmp91_;
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			directory_monitor_mdbg (_tmp92_);
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_free0 (_tmp92_);
#line 861 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_free0 (_tmp90_);
#line 864 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp93_ = self->priv->workers;
#line 864 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp94_ = file;
#line 864 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp95_ = all_candidates;
#line 864 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp96_ = library_monitor_runtime_find_move_job_new (self, _tmp94_, G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, GEE_TYPE_COLLECTION, GeeCollection));
#line 864 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp97_ = _tmp96_;
#line 864 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			workers_enqueue (_tmp93_, G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 864 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_background_job_unref0 (_tmp97_);
#line 866 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			known = TRUE;
#line 6543 "LibraryMonitor.c"
		}
#line 831 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (all_candidates);
#line 6547 "LibraryMonitor.c"
	}
#line 870 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp98_ = known;
#line 870 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp98_) {
#line 6553 "LibraryMonitor.c"
		GFile* _tmp99_;
#line 871 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp99_ = file;
#line 871 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_runtime_unknown_file_discovered (self, _tmp99_);
#line 6559 "LibraryMonitor.c"
	}
#line 873 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp100_ = file;
#line 873 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp101_ = info;
#line 873 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_created (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp100_, _tmp101_);
#line 6567 "LibraryMonitor.c"
}


static void library_monitor_on_runtime_find_move_completed (LibraryMonitor* self, BackgroundJob* j) {
	LibraryMonitorRuntimeFindMoveJob* job = NULL;
	BackgroundJob* _tmp0_;
	LibraryMonitorRuntimeFindMoveJob* _tmp1_;
	LibraryMonitorRuntimeFindMoveJob* _tmp2_;
	GError* _tmp3_;
	LibraryMonitorRuntimeFindMoveJob* _tmp11_;
	Monitorable* _tmp12_;
#line 876 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_LIBRARY_MONITOR (self));
#line 876 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 877 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = j;
#line 877 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJob));
#line 877 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	job = _tmp1_;
#line 879 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = job;
#line 879 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _tmp2_->err;
#line 879 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp3_ != NULL) {
#line 6595 "LibraryMonitor.c"
		LibraryMonitorRuntimeFindMoveJob* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		LibraryMonitorRuntimeFindMoveJob* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = job;
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _tmp4_->file;
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = g_file_get_path (_tmp5_);
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = _tmp6_;
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = job;
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = _tmp8_->err;
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp10_ = _tmp9_->message;
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_critical ("LibraryMonitor.vala:880: Error attempting to find a match at runtime f" \
"or %s: %s", _tmp7_, _tmp10_);
#line 880 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp7_);
#line 6621 "LibraryMonitor.c"
	}
#line 884 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp11_ = job;
#line 884 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp12_ = _tmp11_->match;
#line 884 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp12_ != NULL) {
#line 6629 "LibraryMonitor.c"
		MediaMonitor* monitor = NULL;
		LibraryMonitorRuntimeFindMoveJob* _tmp13_;
		Monitorable* _tmp14_;
		MediaMonitor* _tmp15_;
		MediaMonitor* _tmp16_;
		LibraryMonitorRuntimeFindMoveJob* _tmp17_;
		Monitorable* _tmp18_;
		LibraryMonitorRuntimeFindMoveJob* _tmp19_;
		GFile* _tmp20_;
		MediaMonitor* _tmp21_;
		LibraryMonitorRuntimeFindMoveJob* _tmp22_;
		Monitorable* _tmp23_;
#line 885 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp13_ = job;
#line 885 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp14_ = _tmp13_->match;
#line 885 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp15_ = library_monitor_get_monitor_for_monitorable (self, _tmp14_);
#line 885 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		monitor = _tmp15_;
#line 886 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp16_ = monitor;
#line 886 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp17_ = job;
#line 886 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp18_ = _tmp17_->match;
#line 886 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp19_ = job;
#line 886 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp20_ = _tmp19_->file;
#line 886 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		media_monitor_update_master_file (_tmp16_, _tmp18_, _tmp20_);
#line 887 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp21_ = monitor;
#line 887 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp22_ = job;
#line 887 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp23_ = _tmp22_->match;
#line 887 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		media_monitor_update_online (_tmp21_, _tmp23_);
#line 884 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (monitor);
#line 6672 "LibraryMonitor.c"
	} else {
		LibraryMonitorRuntimeFindMoveJob* _tmp24_;
		GFile* _tmp25_;
#line 890 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp24_ = job;
#line 890 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp25_ = _tmp24_->file;
#line 890 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_runtime_unknown_file_discovered (self, _tmp25_);
#line 6682 "LibraryMonitor.c"
	}
#line 876 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_background_job_unref0 (job);
#line 6686 "LibraryMonitor.c"
}


static void library_monitor_real_notify_file_moved (DirectoryMonitor* base, GFile* old_file, GFile* new_file, GFileInfo* new_info) {
	LibraryMonitor * self;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	gboolean _tmp2_;
	gboolean known = FALSE;
	gboolean _tmp24_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	GFileInfo* _tmp28_;
#line 894 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 894 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 894 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 894 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_info));
#line 895 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = old_file;
#line 895 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = library_monitor_is_blacklisted (_tmp1_);
#line 895 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp2_) {
#line 895 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = TRUE;
#line 6716 "LibraryMonitor.c"
	} else {
		GFile* _tmp3_;
		gboolean _tmp4_;
#line 895 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = new_file;
#line 895 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = library_monitor_is_blacklisted (_tmp3_);
#line 895 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = _tmp4_;
#line 6726 "LibraryMonitor.c"
	}
#line 895 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp0_) {
#line 6730 "LibraryMonitor.c"
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFileInfo* _tmp7_;
#line 896 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = old_file;
#line 896 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = new_file;
#line 896 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = new_info;
#line 896 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_moved (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp5_, _tmp6_, _tmp7_);
#line 898 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 6744 "LibraryMonitor.c"
	}
#line 901 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	known = FALSE;
#line 6748 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp8_;
		GeeList* _tmp9_;
		gint _monitor_size = 0;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _monitor_index = 0;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = self->priv->monitors;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp9_;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp10_ = _monitor_list;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp12_ = _tmp11_;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp12_;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 6776 "LibraryMonitor.c"
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			MediaMonitor* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			GFileInfo* _tmp22_;
			gboolean _tmp23_;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = _monitor_index;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp13_ + 1;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = _monitor_index;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = _monitor_size;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp14_ < _tmp15_)) {
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 6801 "LibraryMonitor.c"
			}
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = _monitor_list;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp17_ = _monitor_index;
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp18_ = gee_list_get (_tmp16_, _tmp17_);
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp18_;
#line 903 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp19_ = monitor;
#line 903 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp20_ = old_file;
#line 903 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp21_ = new_file;
#line 903 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp22_ = new_info;
#line 903 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp23_ = media_monitor_notify_file_moved (_tmp19_, _tmp20_, _tmp21_, _tmp22_);
#line 903 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp23_) {
#line 904 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				known = TRUE;
#line 906 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (monitor);
#line 906 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 6829 "LibraryMonitor.c"
			}
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 6833 "LibraryMonitor.c"
		}
#line 902 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 6837 "LibraryMonitor.c"
	}
#line 910 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp24_ = known;
#line 910 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp24_) {
#line 6843 "LibraryMonitor.c"
		GFile* _tmp25_;
#line 911 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp25_ = new_file;
#line 911 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_runtime_unknown_file_discovered (self, _tmp25_);
#line 6849 "LibraryMonitor.c"
	}
#line 913 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp26_ = old_file;
#line 913 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp27_ = new_file;
#line 913 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp28_ = new_info;
#line 913 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_moved (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp26_, _tmp27_, _tmp28_);
#line 6859 "LibraryMonitor.c"
}


static void library_monitor_real_notify_file_altered (DirectoryMonitor* base, GFile* file) {
	LibraryMonitor * self;
	GFile* _tmp0_;
	gboolean _tmp1_;
	gboolean known = FALSE;
	gboolean _tmp17_;
	GFile* _tmp19_;
#line 916 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 916 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 917 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = file;
#line 917 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = library_monitor_is_blacklisted (_tmp0_);
#line 917 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_) {
#line 6880 "LibraryMonitor.c"
		GFile* _tmp2_;
#line 918 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = file;
#line 918 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp2_);
#line 920 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 6888 "LibraryMonitor.c"
	}
#line 923 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	known = FALSE;
#line 6892 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _monitor_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _monitor_index = 0;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = self->priv->monitors;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp4_;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _monitor_list;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = _tmp6_;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp7_;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 6920 "LibraryMonitor.c"
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			MediaMonitor* _tmp14_;
			GFile* _tmp15_;
			gboolean _tmp16_;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _monitor_index;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp8_ + 1;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_index;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = _monitor_size;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 6943 "LibraryMonitor.c"
			}
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = _monitor_list;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = _monitor_index;
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp13_;
#line 925 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = monitor;
#line 925 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = file;
#line 925 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = media_monitor_notify_file_altered (_tmp14_, _tmp15_);
#line 925 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp16_) {
#line 926 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				known = TRUE;
#line 928 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (monitor);
#line 928 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 6967 "LibraryMonitor.c"
			}
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 6971 "LibraryMonitor.c"
		}
#line 924 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 6975 "LibraryMonitor.c"
	}
#line 932 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp17_ = known;
#line 932 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp17_) {
#line 6981 "LibraryMonitor.c"
		GFile* _tmp18_;
#line 933 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp18_ = file;
#line 933 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_runtime_unknown_file_discovered (self, _tmp18_);
#line 6987 "LibraryMonitor.c"
	}
#line 935 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp19_ = file;
#line 935 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp19_);
#line 6993 "LibraryMonitor.c"
}


static void library_monitor_real_notify_file_attributes_altered (DirectoryMonitor* base, GFile* file) {
	LibraryMonitor * self;
	GFile* _tmp0_;
	gboolean _tmp1_;
	gboolean known = FALSE;
	gboolean _tmp17_;
	GFile* _tmp19_;
#line 938 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 938 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 939 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = file;
#line 939 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = library_monitor_is_blacklisted (_tmp0_);
#line 939 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_) {
#line 7014 "LibraryMonitor.c"
		GFile* _tmp2_;
#line 940 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = file;
#line 940 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_attributes_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp2_);
#line 942 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 7022 "LibraryMonitor.c"
	}
#line 945 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	known = FALSE;
#line 7026 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _monitor_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _monitor_index = 0;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = self->priv->monitors;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp4_;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _monitor_list;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = _tmp6_;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp7_;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 7054 "LibraryMonitor.c"
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			MediaMonitor* _tmp14_;
			GFile* _tmp15_;
			gboolean _tmp16_;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _monitor_index;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp8_ + 1;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_index;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = _monitor_size;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 7077 "LibraryMonitor.c"
			}
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = _monitor_list;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = _monitor_index;
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp13_;
#line 947 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = monitor;
#line 947 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = file;
#line 947 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = media_monitor_notify_file_attributes_altered (_tmp14_, _tmp15_);
#line 947 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp16_) {
#line 948 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				known = TRUE;
#line 950 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (monitor);
#line 950 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 7101 "LibraryMonitor.c"
			}
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 7105 "LibraryMonitor.c"
		}
#line 946 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 7109 "LibraryMonitor.c"
	}
#line 954 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp17_ = known;
#line 954 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp17_) {
#line 7115 "LibraryMonitor.c"
		GFile* _tmp18_;
#line 955 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp18_ = file;
#line 955 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_runtime_unknown_file_discovered (self, _tmp18_);
#line 7121 "LibraryMonitor.c"
	}
#line 957 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp19_ = file;
#line 957 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_attributes_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp19_);
#line 7127 "LibraryMonitor.c"
}


static void library_monitor_real_notify_file_alteration_completed (DirectoryMonitor* base, GFile* file, GFileInfo* info) {
	LibraryMonitor * self;
	GFile* _tmp0_;
	gboolean _tmp1_;
	gboolean known = FALSE;
	gboolean _tmp19_;
	GFile* _tmp21_;
	GFileInfo* _tmp22_;
#line 960 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 960 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 960 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 961 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = file;
#line 961 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = library_monitor_is_blacklisted (_tmp0_);
#line 961 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_) {
#line 7151 "LibraryMonitor.c"
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
#line 962 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = file;
#line 962 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = info;
#line 962 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_alteration_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp2_, _tmp3_);
#line 964 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 7162 "LibraryMonitor.c"
	}
#line 967 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	known = FALSE;
#line 7166 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		gint _monitor_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _monitor_index = 0;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = self->priv->monitors;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp5_;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = _monitor_list;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = _tmp7_;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp8_;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 7194 "LibraryMonitor.c"
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			MediaMonitor* _tmp15_;
			GFile* _tmp16_;
			GFileInfo* _tmp17_;
			gboolean _tmp18_;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_index;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp9_ + 1;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = _monitor_index;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = _monitor_size;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 7218 "LibraryMonitor.c"
			}
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = _monitor_list;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = _monitor_index;
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp14_;
#line 969 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = monitor;
#line 969 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = file;
#line 969 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp17_ = info;
#line 969 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp18_ = media_monitor_notify_file_alteration_completed (_tmp15_, _tmp16_, _tmp17_);
#line 969 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp18_) {
#line 970 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				known = TRUE;
#line 972 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (monitor);
#line 972 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 7244 "LibraryMonitor.c"
			}
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 7248 "LibraryMonitor.c"
		}
#line 968 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 7252 "LibraryMonitor.c"
	}
#line 976 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp19_ = known;
#line 976 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp19_) {
#line 7258 "LibraryMonitor.c"
		GFile* _tmp20_;
#line 977 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp20_ = file;
#line 977 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_runtime_unknown_file_discovered (self, _tmp20_);
#line 7264 "LibraryMonitor.c"
	}
#line 979 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp21_ = file;
#line 979 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp22_ = info;
#line 979 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_alteration_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp21_, _tmp22_);
#line 7272 "LibraryMonitor.c"
}


static void library_monitor_real_notify_file_deleted (DirectoryMonitor* base, GFile* file) {
	LibraryMonitor * self;
	GFile* _tmp0_;
	gboolean _tmp1_;
	gboolean known = FALSE;
	gboolean _tmp17_;
	GFile* _tmp28_;
#line 982 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 982 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 983 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = file;
#line 983 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = library_monitor_is_blacklisted (_tmp0_);
#line 983 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp1_) {
#line 7293 "LibraryMonitor.c"
		GFile* _tmp2_;
#line 984 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = file;
#line 984 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_deleted (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp2_);
#line 986 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 7301 "LibraryMonitor.c"
	}
#line 989 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	known = FALSE;
#line 7305 "LibraryMonitor.c"
	{
		GeeList* _monitor_list = NULL;
		GeeList* _tmp3_;
		GeeList* _tmp4_;
		gint _monitor_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _monitor_index = 0;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = self->priv->monitors;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_list = _tmp4_;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _monitor_list;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = _tmp6_;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_size = _tmp7_;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_monitor_index = -1;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 7333 "LibraryMonitor.c"
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			MediaMonitor* monitor = NULL;
			GeeList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			MediaMonitor* _tmp14_;
			GFile* _tmp15_;
			gboolean _tmp16_;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _monitor_index;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_monitor_index = _tmp8_ + 1;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = _monitor_index;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = _monitor_size;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 7356 "LibraryMonitor.c"
			}
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = _monitor_list;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = _monitor_index;
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			monitor = (MediaMonitor*) _tmp13_;
#line 991 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = monitor;
#line 991 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = file;
#line 991 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = media_monitor_notify_file_deleted (_tmp14_, _tmp15_);
#line 991 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp16_) {
#line 992 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				known = TRUE;
#line 994 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (monitor);
#line 994 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 7380 "LibraryMonitor.c"
			}
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (monitor);
#line 7384 "LibraryMonitor.c"
		}
#line 990 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_monitor_list);
#line 7388 "LibraryMonitor.c"
	}
#line 998 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp17_ = known;
#line 998 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!_tmp17_) {
#line 7394 "LibraryMonitor.c"
		Tombstone* tombstone = NULL;
		TombstoneSourceCollection* _tmp18_;
		GFile* _tmp19_;
		Tombstone* _tmp20_;
		Tombstone* _tmp21_;
		GFile* _tmp27_;
#line 1000 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp18_ = tombstone_global;
#line 1000 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp19_ = file;
#line 1000 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp20_ = tombstone_source_collection_locate (_tmp18_, _tmp19_);
#line 1000 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		tombstone = _tmp20_;
#line 1001 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp21_ = tombstone;
#line 1001 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_tmp21_ != NULL) {
#line 7413 "LibraryMonitor.c"
			GFile* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			TombstoneSourceCollection* _tmp25_;
			Tombstone* _tmp26_;
#line 1002 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp22_ = file;
#line 1002 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp23_ = g_file_get_path (_tmp22_);
#line 1002 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp24_ = _tmp23_;
#line 1002 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			g_debug ("LibraryMonitor.vala:1002: Resurrecting tombstoned file %s", _tmp24_);
#line 1002 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_free0 (_tmp24_);
#line 1003 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp25_ = tombstone_global;
#line 1003 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp26_ = tombstone;
#line 1003 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			tombstone_source_collection_resurrect (_tmp25_, _tmp26_);
#line 7435 "LibraryMonitor.c"
		}
#line 1007 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp27_ = file;
#line 1007 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_remove_queued_import (self, _tmp27_);
#line 998 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (tombstone);
#line 7443 "LibraryMonitor.c"
	}
#line 1010 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp28_ = file;
#line 1010 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	DIRECTORY_MONITOR_CLASS (library_monitor_parent_class)->notify_file_deleted (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DIRECTORY_MONITOR, DirectoryMonitor), _tmp28_);
#line 7449 "LibraryMonitor.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (n_param_values == 3);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		data1 = closure->data;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		data2 = param_values->data[0].v_pointer;
#line 7468 "LibraryMonitor.c"
	} else {
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		data1 = param_values->data[0].v_pointer;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		data2 = closure->data;
#line 7474 "LibraryMonitor.c"
	}
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 7480 "LibraryMonitor.c"
}


static void g_cclosure_user_marshal_VOID__UINT64_UINT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT64_UINT64) (gpointer data1, guint64 arg_1, guint64 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT64_UINT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (n_param_values == 3);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		data1 = closure->data;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		data2 = param_values->data[0].v_pointer;
#line 7499 "LibraryMonitor.c"
	} else {
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		data1 = param_values->data[0].v_pointer;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		data2 = closure->data;
#line 7505 "LibraryMonitor.c"
	}
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	callback = (GMarshalFunc_VOID__UINT64_UINT64) (marshal_data ? marshal_data : cc->callback);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	callback (data1, g_value_get_uint64 (param_values + 1), g_value_get_uint64 (param_values + 2), data2);
#line 7511 "LibraryMonitor.c"
}


static void _library_monitor_on_find_move_completed_completion_callback (BackgroundJob* job, gpointer self) {
#line 111 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_on_find_move_completed ((LibraryMonitor*) self, job);
#line 7518 "LibraryMonitor.c"
}


static void _library_monitor_on_find_move_cancelled_cancellation_callback (BackgroundJob* job, gpointer self) {
#line 111 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_on_find_move_cancelled ((LibraryMonitor*) self, job);
#line 7525 "LibraryMonitor.c"
}


static LibraryMonitorFindMoveJob* library_monitor_find_move_job_construct (GType object_type, LibraryMonitor* owner, GFile* file, GeeCollection* candidates) {
	LibraryMonitorFindMoveJob* self = NULL;
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
	LibraryMonitor* _tmp2_;
	GCancellable* _tmp3_;
	LibraryMonitor* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
#line 110 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_MONITOR (owner), NULL);
#line 110 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 110 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (candidates), NULL);
#line 111 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = owner;
#line 111 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = owner;
#line 111 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = owner;
#line 111 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _tmp2_->priv->cancellable;
#line 111 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = owner;
#line 111 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = (LibraryMonitorFindMoveJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _library_monitor_on_find_move_completed_completion_callback, _tmp1_, _tmp3_, _library_monitor_on_find_move_cancelled_cancellation_callback, _tmp4_, NULL);
#line 113 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = file;
#line 113 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 113 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->file);
#line 113 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->file = _tmp6_;
#line 114 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = candidates;
#line 114 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 114 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->candidates);
#line 114 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->candidates = _tmp8_;
#line 116 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	background_job_set_completion_priority (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BACKGROUND_JOB, BackgroundJob), G_PRIORITY_LOW);
#line 110 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self;
#line 7578 "LibraryMonitor.c"
}


static LibraryMonitorFindMoveJob* library_monitor_find_move_job_new (LibraryMonitor* owner, GFile* file, GeeCollection* candidates) {
#line 110 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return library_monitor_find_move_job_construct (LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, owner, file, candidates);
#line 7585 "LibraryMonitor.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 135 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self ? g_error_copy (self) : NULL;
#line 7592 "LibraryMonitor.c"
}


static void library_monitor_find_move_job_real_execute (BackgroundJob* base) {
	LibraryMonitorFindMoveJob * self;
	GeeIterator* iter = NULL;
	GeeCollection* _tmp0_;
	GeeIterator* _tmp1_;
	GeeCollection* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* md5 = NULL;
	GError * _inner_error_ = NULL;
#line 119 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJob);
#line 121 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = self->candidates;
#line 121 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 121 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	iter = _tmp1_;
#line 122 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	while (TRUE) {
#line 7616 "LibraryMonitor.c"
		GeeIterator* _tmp2_;
		gboolean _tmp3_;
		GeeIterator* _tmp4_;
		gpointer _tmp5_;
		Monitorable* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
#line 122 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = iter;
#line 122 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = gee_iterator_next (_tmp2_);
#line 122 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (!_tmp3_) {
#line 122 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			break;
#line 7634 "LibraryMonitor.c"
		}
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = iter;
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = gee_iterator_get (_tmp4_);
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = (Monitorable*) _tmp5_;
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_SOURCE, MediaSource));
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp8_ = _tmp7_;
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp9_ = g_file_query_exists (_tmp8_, NULL);
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp10_ = _tmp9_;
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_tmp8_);
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_tmp6_);
#line 123 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (_tmp10_) {
#line 7656 "LibraryMonitor.c"
			GeeIterator* _tmp11_;
#line 124 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = iter;
#line 124 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			gee_iterator_remove (_tmp11_);
#line 7662 "LibraryMonitor.c"
		}
	}
#line 128 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp12_ = self->candidates;
#line 128 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp13_ = gee_collection_get_size (_tmp12_);
#line 128 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp14_ = _tmp13_;
#line 128 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (_tmp14_ == 0) {
#line 129 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (iter);
#line 129 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 7677 "LibraryMonitor.c"
	}
#line 131 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	md5 = NULL;
#line 7681 "LibraryMonitor.c"
	{
		gchar* _tmp15_ = NULL;
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
#line 133 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp16_ = self->file;
#line 133 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp17_ = md5_file (_tmp16_, &_inner_error_);
#line 133 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp15_ = _tmp17_;
#line 133 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7695 "LibraryMonitor.c"
			goto __catch492_g_error;
		}
#line 133 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp18_ = _tmp15_;
#line 133 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp15_ = NULL;
#line 133 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (md5);
#line 133 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		md5 = _tmp18_;
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp15_);
#line 7708 "LibraryMonitor.c"
	}
	goto __finally492;
	__catch492_g_error:
	{
		GError* err = NULL;
		GError* _tmp19_;
		GError* _tmp20_;
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		err = _inner_error_;
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_inner_error_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp19_ = err;
#line 135 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp20_ = _g_error_copy0 (_tmp19_);
#line 135 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_error_free0 (self->err);
#line 135 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		self->err = _tmp20_;
#line 137 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_error_free0 (err);
#line 137 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (md5);
#line 137 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (iter);
#line 137 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 7736 "LibraryMonitor.c"
	}
	__finally492:
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (md5);
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (iter);
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 132 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 7751 "LibraryMonitor.c"
	}
	{
		GeeIterator* _candidate_it = NULL;
		GeeCollection* _tmp21_;
		GeeIterator* _tmp22_;
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp21_ = self->candidates;
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp22_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ITERABLE, GeeIterable));
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_candidate_it = _tmp22_;
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 7765 "LibraryMonitor.c"
			GeeIterator* _tmp23_;
			gboolean _tmp24_;
			Monitorable* candidate = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			Monitorable* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_;
			Monitorable* _tmp32_;
			Monitorable* _tmp46_;
			Monitorable* _tmp47_;
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp23_ = _candidate_it;
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp24_ = gee_iterator_next (_tmp23_);
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!_tmp24_) {
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 7787 "LibraryMonitor.c"
			}
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp25_ = _candidate_it;
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp26_ = gee_iterator_get (_tmp25_);
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			candidate = (Monitorable*) _tmp26_;
#line 141 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp27_ = candidate;
#line 141 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp28_ = media_source_get_master_md5 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_MEDIA_SOURCE, MediaSource));
#line 141 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp29_ = _tmp28_;
#line 141 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp30_ = md5;
#line 141 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp31_ = g_strcmp0 (_tmp29_, _tmp30_) != 0;
#line 141 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_free0 (_tmp29_);
#line 141 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp31_) {
#line 142 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (candidate);
#line 142 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 7813 "LibraryMonitor.c"
			}
#line 144 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp32_ = self->match;
#line 144 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp32_ != NULL) {
#line 7819 "LibraryMonitor.c"
				GFile* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				Monitorable* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				Monitorable* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				GeeArrayList* _tmp42_;
				GeeArrayList* _tmp44_;
				Monitorable* _tmp45_;
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp33_ = self->file;
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp34_ = g_file_get_path (_tmp33_);
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp35_ = _tmp34_;
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp36_ = self->match;
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp37_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, TYPE_DATA_OBJECT, DataObject));
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp38_ = _tmp37_;
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp39_ = candidate;
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp40_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_DATA_OBJECT, DataObject));
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp41_ = _tmp40_;
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				g_warning ("LibraryMonitor.vala:145: Found more than one media match for %s: %s an" \
"d %s", _tmp35_, _tmp38_, _tmp41_);
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_free0 (_tmp41_);
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_free0 (_tmp38_);
#line 145 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_free0 (_tmp35_);
#line 148 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp42_ = self->losers;
#line 148 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				if (_tmp42_ == NULL) {
#line 7862 "LibraryMonitor.c"
					GeeArrayList* _tmp43_;
#line 149 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_tmp43_ = gee_array_list_new (TYPE_MONITORABLE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 149 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					_g_object_unref0 (self->losers);
#line 149 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
					self->losers = _tmp43_;
#line 7870 "LibraryMonitor.c"
				}
#line 151 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp44_ = self->losers;
#line 151 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp45_ = candidate;
#line 151 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp45_);
#line 153 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (candidate);
#line 153 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				continue;
#line 7882 "LibraryMonitor.c"
			}
#line 156 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp46_ = candidate;
#line 156 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp47_ = _g_object_ref0 (_tmp46_);
#line 156 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (self->match);
#line 156 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			self->match = _tmp47_;
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (candidate);
#line 7894 "LibraryMonitor.c"
		}
#line 140 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_candidate_it);
#line 7898 "LibraryMonitor.c"
	}
#line 119 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_free0 (md5);
#line 119 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (iter);
#line 7904 "LibraryMonitor.c"
}


static void library_monitor_find_move_job_class_init (LibraryMonitorFindMoveJobClass * klass) {
#line 103 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_find_move_job_parent_class = g_type_class_peek_parent (klass);
#line 103 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = library_monitor_find_move_job_finalize;
#line 103 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob *)) library_monitor_find_move_job_real_execute;
#line 7915 "LibraryMonitor.c"
}


static void library_monitor_find_move_job_instance_init (LibraryMonitorFindMoveJob * self) {
#line 106 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->match = NULL;
#line 107 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->losers = NULL;
#line 108 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->err = NULL;
#line 7926 "LibraryMonitor.c"
}


static void library_monitor_find_move_job_finalize (BackgroundJob * obj) {
	LibraryMonitorFindMoveJob * self;
#line 103 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_MONITOR_TYPE_FIND_MOVE_JOB, LibraryMonitorFindMoveJob);
#line 104 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->file);
#line 105 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->candidates);
#line 106 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->match);
#line 107 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->losers);
#line 108 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_error_free0 (self->err);
#line 103 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	BACKGROUND_JOB_CLASS (library_monitor_find_move_job_parent_class)->finalize (obj);
#line 7946 "LibraryMonitor.c"
}


static GType library_monitor_find_move_job_get_type (void) {
	static volatile gsize library_monitor_find_move_job_type_id__volatile = 0;
	if (g_once_init_enter (&library_monitor_find_move_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorFindMoveJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_find_move_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitorFindMoveJob), 0, (GInstanceInitFunc) library_monitor_find_move_job_instance_init, NULL };
		GType library_monitor_find_move_job_type_id;
		library_monitor_find_move_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "LibraryMonitorFindMoveJob", &g_define_type_info, 0);
		g_once_init_leave (&library_monitor_find_move_job_type_id__volatile, library_monitor_find_move_job_type_id);
	}
	return library_monitor_find_move_job_type_id__volatile;
}


static void _library_monitor_on_runtime_find_move_completed_completion_callback (BackgroundJob* job, gpointer self) {
#line 168 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_on_runtime_find_move_completed ((LibraryMonitor*) self, job);
#line 7965 "LibraryMonitor.c"
}


static LibraryMonitorRuntimeFindMoveJob* library_monitor_runtime_find_move_job_construct (GType object_type, LibraryMonitor* owner, GFile* file, GeeCollection* candidates) {
	LibraryMonitorRuntimeFindMoveJob* self = NULL;
	LibraryMonitor* _tmp0_;
	LibraryMonitor* _tmp1_;
	LibraryMonitor* _tmp2_;
	GCancellable* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
#line 167 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_LIBRARY_MONITOR (owner), NULL);
#line 167 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 167 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (candidates), NULL);
#line 168 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = owner;
#line 168 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = owner;
#line 168 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = owner;
#line 168 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _tmp2_->priv->cancellable;
#line 168 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = (LibraryMonitorRuntimeFindMoveJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _library_monitor_on_runtime_find_move_completed_completion_callback, _tmp1_, _tmp3_, NULL, NULL, NULL);
#line 170 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = file;
#line 170 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 170 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->file);
#line 170 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->file = _tmp5_;
#line 171 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = candidates;
#line 171 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 171 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->candidates);
#line 171 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->candidates = _tmp7_;
#line 173 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	background_job_set_completion_priority (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BACKGROUND_JOB, BackgroundJob), G_PRIORITY_LOW);
#line 167 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self;
#line 8015 "LibraryMonitor.c"
}


static LibraryMonitorRuntimeFindMoveJob* library_monitor_runtime_find_move_job_new (LibraryMonitor* owner, GFile* file, GeeCollection* candidates) {
#line 167 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return library_monitor_runtime_find_move_job_construct (LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, owner, file, candidates);
#line 8022 "LibraryMonitor.c"
}


static void library_monitor_runtime_find_move_job_real_execute (BackgroundJob* base) {
	LibraryMonitorRuntimeFindMoveJob * self;
	gchar* md5 = NULL;
	GError * _inner_error_ = NULL;
#line 176 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJob);
#line 177 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	md5 = NULL;
#line 8034 "LibraryMonitor.c"
	{
		gchar* _tmp0_ = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 179 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp1_ = self->file;
#line 179 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp2_ = md5_file (_tmp1_, &_inner_error_);
#line 179 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = _tmp2_;
#line 179 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8048 "LibraryMonitor.c"
			goto __catch493_g_error;
		}
#line 179 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp3_ = _tmp0_;
#line 179 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp0_ = NULL;
#line 179 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (md5);
#line 179 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		md5 = _tmp3_;
#line 178 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (_tmp0_);
#line 8061 "LibraryMonitor.c"
	}
	goto __finally493;
	__catch493_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
#line 178 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		err = _inner_error_;
#line 178 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_inner_error_ = NULL;
#line 181 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp4_ = err;
#line 181 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 181 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_error_free0 (self->err);
#line 181 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		self->err = _tmp5_;
#line 183 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_error_free0 (err);
#line 183 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (md5);
#line 183 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 8087 "LibraryMonitor.c"
	}
	__finally493:
#line 178 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 178 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_free0 (md5);
#line 178 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 178 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return;
#line 8100 "LibraryMonitor.c"
	}
	{
		GeeIterator* _candidate_it = NULL;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp6_ = self->candidates;
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_candidate_it = _tmp7_;
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		while (TRUE) {
#line 8114 "LibraryMonitor.c"
			GeeIterator* _tmp8_;
			gboolean _tmp9_;
			Monitorable* candidate = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			Monitorable* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gboolean _tmp16_;
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp8_ = _candidate_it;
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp9_ = gee_iterator_next (_tmp8_);
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (!_tmp9_) {
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 8133 "LibraryMonitor.c"
			}
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp10_ = _candidate_it;
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp11_ = gee_iterator_get (_tmp10_);
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			candidate = (Monitorable*) _tmp11_;
#line 187 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp12_ = candidate;
#line 187 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp13_ = media_source_get_master_md5 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_MEDIA_SOURCE, MediaSource));
#line 187 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp14_ = _tmp13_;
#line 187 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp15_ = md5;
#line 187 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_tmp16_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 187 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_free0 (_tmp14_);
#line 187 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			if (_tmp16_) {
#line 8155 "LibraryMonitor.c"
				Monitorable* _tmp17_;
				Monitorable* _tmp18_;
#line 188 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp17_ = candidate;
#line 188 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 188 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (self->match);
#line 188 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				self->match = _tmp18_;
#line 190 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				_g_object_unref0 (candidate);
#line 190 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
				break;
#line 8170 "LibraryMonitor.c"
			}
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			_g_object_unref0 (candidate);
#line 8174 "LibraryMonitor.c"
		}
#line 186 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		_g_object_unref0 (_candidate_it);
#line 8178 "LibraryMonitor.c"
	}
#line 176 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_free0 (md5);
#line 8182 "LibraryMonitor.c"
}


static void library_monitor_runtime_find_move_job_class_init (LibraryMonitorRuntimeFindMoveJobClass * klass) {
#line 161 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_runtime_find_move_job_parent_class = g_type_class_peek_parent (klass);
#line 161 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((BackgroundJobClass *) klass)->finalize = library_monitor_runtime_find_move_job_finalize;
#line 161 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob *)) library_monitor_runtime_find_move_job_real_execute;
#line 8193 "LibraryMonitor.c"
}


static void library_monitor_runtime_find_move_job_instance_init (LibraryMonitorRuntimeFindMoveJob * self) {
#line 164 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->match = NULL;
#line 165 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->err = NULL;
#line 8202 "LibraryMonitor.c"
}


static void library_monitor_runtime_find_move_job_finalize (BackgroundJob * obj) {
	LibraryMonitorRuntimeFindMoveJob * self;
#line 161 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_MONITOR_TYPE_RUNTIME_FIND_MOVE_JOB, LibraryMonitorRuntimeFindMoveJob);
#line 162 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->file);
#line 163 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->candidates);
#line 164 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->match);
#line 165 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_error_free0 (self->err);
#line 161 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	BACKGROUND_JOB_CLASS (library_monitor_runtime_find_move_job_parent_class)->finalize (obj);
#line 8220 "LibraryMonitor.c"
}


static GType library_monitor_runtime_find_move_job_get_type (void) {
	static volatile gsize library_monitor_runtime_find_move_job_type_id__volatile = 0;
	if (g_once_init_enter (&library_monitor_runtime_find_move_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorRuntimeFindMoveJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_runtime_find_move_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitorRuntimeFindMoveJob), 0, (GInstanceInitFunc) library_monitor_runtime_find_move_job_instance_init, NULL };
		GType library_monitor_runtime_find_move_job_type_id;
		library_monitor_runtime_find_move_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "LibraryMonitorRuntimeFindMoveJob", &g_define_type_info, 0);
		g_once_init_leave (&library_monitor_runtime_find_move_job_type_id__volatile, library_monitor_runtime_find_move_job_type_id);
	}
	return library_monitor_runtime_find_move_job_type_id__volatile;
}


static LibraryMonitorVerifyJob* library_monitor_verify_job_construct (GType object_type, Monitorable* monitorable, MediaMonitor* monitor) {
	LibraryMonitorVerifyJob* self = NULL;
	Monitorable* _tmp0_;
	Monitorable* _tmp1_;
	MediaMonitor* _tmp2_;
	MediaMonitor* _tmp3_;
#line 200 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
#line 200 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (IS_MEDIA_MONITOR (monitor), NULL);
#line 200 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = (LibraryMonitorVerifyJob*) g_type_create_instance (object_type);
#line 201 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = monitorable;
#line 201 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 201 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->monitorable);
#line 201 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->monitorable = _tmp1_;
#line 202 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = monitor;
#line 202 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 202 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->monitor);
#line 202 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->monitor = _tmp3_;
#line 200 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return self;
#line 8266 "LibraryMonitor.c"
}


static LibraryMonitorVerifyJob* library_monitor_verify_job_new (Monitorable* monitorable, MediaMonitor* monitor) {
#line 200 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return library_monitor_verify_job_construct (LIBRARY_MONITOR_TYPE_VERIFY_JOB, monitorable, monitor);
#line 8273 "LibraryMonitor.c"
}


static void library_monitor_value_verify_job_init (GValue* value) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	value->data[0].v_pointer = NULL;
#line 8280 "LibraryMonitor.c"
}


static void library_monitor_value_verify_job_free_value (GValue* value) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (value->data[0].v_pointer) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_verify_job_unref (value->data[0].v_pointer);
#line 8289 "LibraryMonitor.c"
	}
}


static void library_monitor_value_verify_job_copy_value (const GValue* src_value, GValue* dest_value) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (src_value->data[0].v_pointer) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		dest_value->data[0].v_pointer = library_monitor_verify_job_ref (src_value->data[0].v_pointer);
#line 8299 "LibraryMonitor.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 8303 "LibraryMonitor.c"
	}
}


static gpointer library_monitor_value_verify_job_peek_pointer (const GValue* value) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return value->data[0].v_pointer;
#line 8311 "LibraryMonitor.c"
}


static gchar* library_monitor_value_verify_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (collect_values[0].v_pointer) {
#line 8318 "LibraryMonitor.c"
		LibraryMonitorVerifyJob * object;
		object = collect_values[0].v_pointer;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8325 "LibraryMonitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 8329 "LibraryMonitor.c"
		}
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = library_monitor_verify_job_ref (object);
#line 8333 "LibraryMonitor.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 8337 "LibraryMonitor.c"
	}
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return NULL;
#line 8341 "LibraryMonitor.c"
}


static gchar* library_monitor_value_verify_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	LibraryMonitorVerifyJob ** object_p;
	object_p = collect_values[0].v_pointer;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!object_p) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 8352 "LibraryMonitor.c"
	}
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (!value->data[0].v_pointer) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		*object_p = NULL;
#line 8358 "LibraryMonitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		*object_p = value->data[0].v_pointer;
#line 8362 "LibraryMonitor.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		*object_p = library_monitor_verify_job_ref (value->data[0].v_pointer);
#line 8366 "LibraryMonitor.c"
	}
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return NULL;
#line 8370 "LibraryMonitor.c"
}


static GParamSpec* library_monitor_param_spec_verify_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	LibraryMonitorParamSpecVerifyJob* spec;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, LIBRARY_MONITOR_TYPE_VERIFY_JOB), NULL);
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return G_PARAM_SPEC (spec);
#line 8384 "LibraryMonitor.c"
}


static gpointer library_monitor_value_get_verify_job (const GValue* value) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LIBRARY_MONITOR_TYPE_VERIFY_JOB), NULL);
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return value->data[0].v_pointer;
#line 8393 "LibraryMonitor.c"
}


static void library_monitor_value_set_verify_job (GValue* value, gpointer v_object) {
	LibraryMonitorVerifyJob * old;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LIBRARY_MONITOR_TYPE_VERIFY_JOB));
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	old = value->data[0].v_pointer;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (v_object) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, LIBRARY_MONITOR_TYPE_VERIFY_JOB));
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_verify_job_ref (value->data[0].v_pointer);
#line 8413 "LibraryMonitor.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 8417 "LibraryMonitor.c"
	}
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (old) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_verify_job_unref (old);
#line 8423 "LibraryMonitor.c"
	}
}


static void library_monitor_value_take_verify_job (GValue* value, gpointer v_object) {
	LibraryMonitorVerifyJob * old;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, LIBRARY_MONITOR_TYPE_VERIFY_JOB));
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	old = value->data[0].v_pointer;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (v_object) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, LIBRARY_MONITOR_TYPE_VERIFY_JOB));
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 8442 "LibraryMonitor.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 8446 "LibraryMonitor.c"
	}
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (old) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		library_monitor_verify_job_unref (old);
#line 8452 "LibraryMonitor.c"
	}
}


static void library_monitor_verify_job_class_init (LibraryMonitorVerifyJobClass * klass) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_verify_job_parent_class = g_type_class_peek_parent (klass);
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((LibraryMonitorVerifyJobClass *) klass)->finalize = library_monitor_verify_job_finalize;
#line 8462 "LibraryMonitor.c"
}


static void library_monitor_verify_job_instance_init (LibraryMonitorVerifyJob * self) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->ref_count = 1;
#line 8469 "LibraryMonitor.c"
}


static void library_monitor_verify_job_finalize (LibraryMonitorVerifyJob * obj) {
	LibraryMonitorVerifyJob * self;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, LIBRARY_MONITOR_TYPE_VERIFY_JOB, LibraryMonitorVerifyJob);
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_handlers_destroy (self);
#line 197 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->monitorable);
#line 198 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->monitor);
#line 8483 "LibraryMonitor.c"
}


static GType library_monitor_verify_job_get_type (void) {
	static volatile gsize library_monitor_verify_job_type_id__volatile = 0;
	if (g_once_init_enter (&library_monitor_verify_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { library_monitor_value_verify_job_init, library_monitor_value_verify_job_free_value, library_monitor_value_verify_job_copy_value, library_monitor_value_verify_job_peek_pointer, "p", library_monitor_value_verify_job_collect_value, "p", library_monitor_value_verify_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorVerifyJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_verify_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitorVerifyJob), 0, (GInstanceInitFunc) library_monitor_verify_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType library_monitor_verify_job_type_id;
		library_monitor_verify_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LibraryMonitorVerifyJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&library_monitor_verify_job_type_id__volatile, library_monitor_verify_job_type_id);
	}
	return library_monitor_verify_job_type_id__volatile;
}


static gpointer library_monitor_verify_job_ref (gpointer instance) {
	LibraryMonitorVerifyJob * self;
	self = instance;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	return instance;
#line 8508 "LibraryMonitor.c"
}


static void library_monitor_verify_job_unref (gpointer instance) {
	LibraryMonitorVerifyJob * self;
	self = instance;
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		LIBRARY_MONITOR_VERIFY_JOB_GET_CLASS (self)->finalize (self);
#line 196 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 8521 "LibraryMonitor.c"
	}
}


static void library_monitor_class_init (LibraryMonitorClass * klass) {
	GeeHashSet* _tmp0_;
	HashTimedQueue* _tmp1_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_parent_class = g_type_class_peek_parent (klass);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_type_class_add_private (klass, sizeof (LibraryMonitorPrivate));
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->close = (void (*) (DirectoryMonitor *)) library_monitor_real_close;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->discovery_started = (void (*) (DirectoryMonitor *)) library_monitor_real_discovery_started;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_discovered = (void (*) (DirectoryMonitor *, GFile*, GFileInfo*)) library_monitor_real_file_discovered;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->discovery_completed = (void (*) (DirectoryMonitor *)) library_monitor_real_discovery_completed;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_created = (void (*) (DirectoryMonitor *, GFile*, GFileInfo*)) library_monitor_real_notify_file_created;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_moved = (void (*) (DirectoryMonitor *, GFile*, GFile*, GFileInfo*)) library_monitor_real_notify_file_moved;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_altered = (void (*) (DirectoryMonitor *, GFile*)) library_monitor_real_notify_file_altered;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_attributes_altered = (void (*) (DirectoryMonitor *, GFile*)) library_monitor_real_notify_file_attributes_altered;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_alteration_completed = (void (*) (DirectoryMonitor *, GFile*, GFileInfo*)) library_monitor_real_notify_file_alteration_completed;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_deleted = (void (*) (DirectoryMonitor *, GFile*)) library_monitor_real_notify_file_deleted;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	G_OBJECT_CLASS (klass)->finalize = library_monitor_finalize;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_signals[LIBRARY_MONITOR_AUTO_UPDATE_PROGRESS_SIGNAL] = g_signal_new ("auto-update-progress", TYPE_LIBRARY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PREPARING_SIGNAL] = g_signal_new ("auto-import-preparing", TYPE_LIBRARY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_signals[LIBRARY_MONITOR_AUTO_IMPORT_PROGRESS_SIGNAL] = g_signal_new ("auto-import-progress", TYPE_LIBRARY_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT64_UINT64, G_TYPE_NONE, 2, G_TYPE_UINT64, G_TYPE_UINT64);
#line 206 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_rec_mutex_init (&__lock_library_monitor_blacklist);
#line 206 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
#line 206 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_blacklist = _tmp0_;
#line 207 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = hash_timed_queue_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (guint) LIBRARY_MONITOR_MIN_BLACKLIST_DURATION_MSEC, _library_monitor_on_unblacklist_file_dequeued_callback, NULL, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, G_PRIORITY_LOW);
#line 207 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	library_monitor_to_unblacklist = _tmp1_;
#line 8571 "LibraryMonitor.c"
}


static void library_monitor_instance_init (LibraryMonitor * self) {
	guint _tmp0_;
	Workers* _tmp1_;
	GCancellable* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeLinkedList* _tmp7_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv = LIBRARY_MONITOR_GET_PRIVATE (self);
#line 210 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = workers_thread_per_cpu_minus_one ();
#line 210 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = workers_new (_tmp0_, FALSE);
#line 210 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->workers = _tmp1_;
#line 211 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp2_ = g_cancellable_new ();
#line 211 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->cancellable = _tmp2_;
#line 212 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->auto_import = FALSE;
#line 213 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->unknown_files = NULL;
#line 214 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp3_ = gee_array_list_new (TYPE_MEDIA_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 214 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->monitors = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_LIST, GeeList);
#line 215 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->discovered = NULL;
#line 216 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp4_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
#line 216 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->import_queue = _tmp4_;
#line 217 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp5_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
#line 217 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->pending_imports = _tmp5_;
#line 218 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp6_ = gee_array_list_new (TYPE_BATCH_IMPORT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 218 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->batch_import_queue = _tmp6_;
#line 219 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->current_import_roll = NULL;
#line 220 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->last_import_roll_use = (time_t) 0;
#line 221 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->current_batch_import = NULL;
#line 222 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->checksums_completed = 0;
#line 223 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->checksums_total = 0;
#line 224 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->import_queue_timer_id = (guint) 0;
#line 225 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp7_ = gee_linked_list_new (LIBRARY_MONITOR_TYPE_VERIFY_JOB, (GBoxedCopyFunc) library_monitor_verify_job_ref, (GDestroyNotify) library_monitor_verify_job_unref, NULL, NULL, NULL);
#line 225 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->verify_queue = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_QUEUE, GeeQueue);
#line 226 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->outstanding_verify_jobs = 0;
#line 227 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->completed_monitorable_verifies = 0;
#line 228 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self->priv->total_monitorable_verifies = 0;
#line 8640 "LibraryMonitor.c"
}


static void library_monitor_finalize (GObject * obj) {
	LibraryMonitor * self;
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	guint _tmp2_;
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_MONITOR, LibraryMonitor);
#line 247 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp0_ = config_facade_get_instance ();
#line 247 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_tmp1_ = _tmp0_;
#line 247 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_parse_name ("auto-import-from-library-changed", TYPE_CONFIGURATION_FACADE, &_tmp2_, NULL, FALSE);
#line 247 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _library_monitor_on_config_changed_configuration_facade_auto_import_from_library_changed, self);
#line 247 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (_tmp1_);
#line 210 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_workers_unref0 (self->priv->workers);
#line 211 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 213 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->unknown_files);
#line 214 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->monitors);
#line 215 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->discovered);
#line 216 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->import_queue);
#line 217 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->pending_imports);
#line 218 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->batch_import_queue);
#line 219 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_batch_import_roll_unref0 (self->priv->current_import_roll);
#line 221 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->current_batch_import);
#line 225 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	_g_object_unref0 (self->priv->verify_queue);
#line 97 "/home/jens/Source/shotwell/src/LibraryMonitor.vala"
	G_OBJECT_CLASS (library_monitor_parent_class)->finalize (obj);
#line 8685 "LibraryMonitor.c"
}


GType library_monitor_get_type (void) {
	static volatile gsize library_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&library_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LibraryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryMonitor), 0, (GInstanceInitFunc) library_monitor_instance_init, NULL };
		GType library_monitor_type_id;
		library_monitor_type_id = g_type_register_static (TYPE_DIRECTORY_MONITOR, "LibraryMonitor", &g_define_type_info, 0);
		g_once_init_leave (&library_monitor_type_id__volatile, library_monitor_type_id);
	}
	return library_monitor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



