/* DirectoryMonitor.c generated by valac 0.34.7, the Vala compiler
 * generated from DirectoryMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/**/
/* DirectoryMonitor will monitor an entire directory for changes to all files and directories*/
/* within it.  It uses FileMonitor to monitor all directories it discovers at initialization*/
/* and reports changes to the files and directories just as FileMonitor reports them.  Subclasses*/
/* can override the notify_* methods to filter or monitor events before the signal is fired,*/
/* or can override the signals themselves to be notified afterwards.*/
/**/
/* start_discovery() must be called to initiate monitoring.  Directories and files will be reported*/
/* as they're discovered.  Directories will be monitored as they're discovered as well.  Discovery*/
/* can only be initiated once.*/
/**/
/* All signals are virtual and have a corresponding notify_* protected virtual function.*/
/* Subclasses can either override the notify or the signal to decide when they want to process*/
/* the event.*/
/**/
/* DirectoryMonitor also adds a level of intelligence to GLib's monitoring API.Because certain*/
/* file/directory events are decomposed by FileMonitor into more atomic events, it's difficult*/
/* to know when these "composed" events have occurred.  (For example, a file move is reported*/
/* as a DELETED event followed by a CREATED event, with no clue that the two are related.)  Later*/
/* versions added the MOVE event, but we can't rely on those being installed.  Also, documentation*/
/* suggests it's only available with certain back-ends.*/
/**/
/* DirectoryMonitor attempts to solve this by deducing when a set of events actually equals*/
/* a composite event.  It requires more memory in order to do this (i.e. it stores all files and*/
/* their information), but the trade-off is easier file/directory monitoring via familiar*/
/* semantics.*/
/**/
/* DirectoryMonitor also will synthesize events when normal monitor events don't produce expected*/
/* results.  For example, if a directory is moved out of DirectoryMonitor's root, it is reported*/
/* as a delete event, but none of its children are reported as deleted.  Similarly, a directory*/
/* rename can be captured as a move, but notifications for all its children are not fired and*/
/* are synthesized by DirectoryMonitor.  DirectoryMonitor will fire delete and move notifications*/
/* for all the directory's children in depth-first order.*/
/**/
/* In general, DirectoryMonitor attempts to preserve ordering of events, so that (for example) a*/
/* file-altered event doesn't fire before a file-created, and so on.*/
/**/
/* Because of these requirements, DirectoryMonitor maintains a FileInfo struct on all directories */
/* and files being monitored.  (It maintains the attributes gather during the discovery phase, i.e. */
/* SUPPLIED_ATTRIBUTES.)  This information can be retrieved via get_info(), get_file_id(), and*/
/* get_etag().  These calls can be made at any time; the information is stored before any signal*/
/* is fired.*/
/**/
/* Note that DirectoryMonitor currently only supports files and directories.  Other file types*/
/* (special, symbolic links, shortcuts, and mount points) are not supported.  It has been seen*/
/* when a temporary file is created for its file type to be reported as "unknown" and when it's*/
/* altered/deleted to be reported as a regular file.  This means it's possible for a file not to*/
/* be reported as discovered or created but to be reported as altered and/or deleted.*/
/**/
/* DirectoryMonitor can be configured to not recurse (in which case it only discovers/monitors*/
/* the root directory) and to not monitor (in which case only discovery occurs).*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DIRECTORY_MONITOR (directory_monitor_get_type ())
#define DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitor))
#define DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))
#define IS_DIRECTORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY_MONITOR))
#define IS_DIRECTORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY_MONITOR))
#define DIRECTORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY_MONITOR, DirectoryMonitorClass))

typedef struct _DirectoryMonitor DirectoryMonitor;
typedef struct _DirectoryMonitorClass DirectoryMonitorClass;
typedef struct _DirectoryMonitorPrivate DirectoryMonitorPrivate;

#define DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT (directory_monitor_query_info_queue_element_get_type ())
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElement))
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElementClass))
#define DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT))
#define DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT))
#define DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElementClass))

typedef struct _DirectoryMonitorQueryInfoQueueElement DirectoryMonitorQueryInfoQueueElement;
typedef struct _DirectoryMonitorQueryInfoQueueElementClass DirectoryMonitorQueryInfoQueueElementClass;

#define DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP (directory_monitor_file_info_map_get_type ())
#define DIRECTORY_MONITOR_FILE_INFO_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMap))
#define DIRECTORY_MONITOR_FILE_INFO_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMapClass))
#define DIRECTORY_MONITOR_IS_FILE_INFO_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP))
#define DIRECTORY_MONITOR_IS_FILE_INFO_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP))
#define DIRECTORY_MONITOR_FILE_INFO_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMapClass))

typedef struct _DirectoryMonitorFileInfoMap DirectoryMonitorFileInfoMap;
typedef struct _DirectoryMonitorFileInfoMapClass DirectoryMonitorFileInfoMapClass;

#define DIRECTORY_MONITOR_TYPE_FTYPE (directory_monitor_ftype_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _directory_monitor_file_info_map_unref0(var) ((var == NULL) ? NULL : (var = (directory_monitor_file_info_map_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DirectoryMonitorAsyncInternalNotifyDirectoryMovedData DirectoryMonitorAsyncInternalNotifyDirectoryMovedData;
typedef struct _DirectoryMonitorAsyncNotifyDirectoryDeletedData DirectoryMonitorAsyncNotifyDirectoryDeletedData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _DirectoryMonitorExploreAsyncData DirectoryMonitorExploreAsyncData;
typedef struct _DirectoryMonitorNotifyDirectoryFilesData DirectoryMonitorNotifyDirectoryFilesData;
typedef struct _DirectoryMonitorQueryInfoQueueElementPrivate DirectoryMonitorQueryInfoQueueElementPrivate;
#define _directory_monitor_query_info_queue_element_unref0(var) ((var == NULL) ? NULL : (var = (directory_monitor_query_info_queue_element_unref (var), NULL)))
typedef struct _DirectoryMonitorParamSpecQueryInfoQueueElement DirectoryMonitorParamSpecQueryInfoQueueElement;
typedef struct _DirectoryMonitorFileInfoMapPrivate DirectoryMonitorFileInfoMapPrivate;
typedef struct _DirectoryMonitorParamSpecFileInfoMap DirectoryMonitorParamSpecFileInfoMap;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DirectoryMonitor {
	GObject parent_instance;
	DirectoryMonitorPrivate * priv;
};

struct _DirectoryMonitorClass {
	GObjectClass parent_class;
	void (*notify_root_deleted) (DirectoryMonitor* self, GFile* root);
	void (*notify_root_moved) (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
	void (*notify_discovery_started) (DirectoryMonitor* self);
	void (*internal_notify_file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*internal_notify_directory_discovered) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_discovered) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_discovery_failed) (DirectoryMonitor* self, const gchar* reason);
	void (*notify_discovery_completed) (DirectoryMonitor* self);
	void (*notify_file_created) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_moved) (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	void (*notify_file_altered) (DirectoryMonitor* self, GFile* file);
	void (*notify_file_alteration_completed) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*notify_file_attributes_altered) (DirectoryMonitor* self, GFile* file);
	void (*notify_file_deleted) (DirectoryMonitor* self, GFile* file);
	void (*notify_directory_created) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_moved) (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
	void (*notify_directory_altered) (DirectoryMonitor* self, GFile* dir);
	void (*notify_directory_alteration_completed) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*notify_directory_attributes_altered) (DirectoryMonitor* self, GFile* dir);
	void (*notify_directory_deleted) (DirectoryMonitor* self, GFile* dir);
	void (*notify_closed) (DirectoryMonitor* self);
	void (*close) (DirectoryMonitor* self);
	void (*root_moved) (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
	void (*root_deleted) (DirectoryMonitor* self, GFile* root);
	void (*discovery_started) (DirectoryMonitor* self);
	void (*file_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*directory_discovered) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*discovery_failed) (DirectoryMonitor* self, const gchar* reason);
	void (*discovery_completed) (DirectoryMonitor* self);
	void (*file_created) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*file_moved) (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	void (*file_altered) (DirectoryMonitor* self, GFile* file);
	void (*file_alteration_completed) (DirectoryMonitor* self, GFile* file, GFileInfo* info);
	void (*file_attributes_altered) (DirectoryMonitor* self, GFile* file);
	void (*file_deleted) (DirectoryMonitor* self, GFile* file);
	void (*directory_created) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*directory_moved) (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
	void (*directory_altered) (DirectoryMonitor* self, GFile* dir);
	void (*directory_alteration_completed) (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
	void (*directory_attributes_altered) (DirectoryMonitor* self, GFile* dir);
	void (*directory_deleted) (DirectoryMonitor* self, GFile* dir);
	void (*closed) (DirectoryMonitor* self);
};

struct _DirectoryMonitorPrivate {
	GFile* root;
	gboolean recurse;
	gboolean monitoring;
	GeeHashMap* monitors;
	GeeQueue* query_info_queue;
	DirectoryMonitorFileInfoMap* files;
	DirectoryMonitorFileInfoMap* parent_moved;
	GCancellable* cancellable;
	gint outstanding_exploration_dirs;
	gboolean started;
	gboolean has_discovery_started;
	guint delete_timer_id;
};

typedef enum  {
	DIRECTORY_MONITOR_FTYPE_FILE,
	DIRECTORY_MONITOR_FTYPE_DIRECTORY,
	DIRECTORY_MONITOR_FTYPE_UNSUPPORTED
} DirectoryMonitorFType;

struct _DirectoryMonitorAsyncInternalNotifyDirectoryMovedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DirectoryMonitor* self;
	GFile* old_dir;
	GFileInfo* old_dir_info;
	GFile* new_dir;
	GFileInfo* new_dir_info;
	GeeArrayList* file_children;
	GeeArrayList* _tmp0_;
	GeeArrayList* dir_children;
	GeeArrayList* _tmp1_;
	gint count;
	DirectoryMonitorFileInfoMap* _tmp2_;
	GFile* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _dir_child_list;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _dir_child_size;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _dir_child_index;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GFile* dir_child;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gpointer _tmp18_;
	GFileInfo* dir_info;
	DirectoryMonitorFileInfoMap* _tmp19_;
	GFile* _tmp20_;
	GFileInfo* _tmp21_;
	GFileInfo* _tmp22_;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GFile* _tmp26_;
	GFileInfo* _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	GFileInfo* _tmp34_;
	GeeArrayList* _file_child_list;
	GeeArrayList* _tmp35_;
	GeeArrayList* _tmp36_;
	gint _file_child_size;
	GeeArrayList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	gint _file_child_index;
	gint _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	GFile* file_child;
	GeeArrayList* _tmp43_;
	gint _tmp44_;
	gpointer _tmp45_;
	GFileInfo* file_info;
	DirectoryMonitorFileInfoMap* _tmp46_;
	GFile* _tmp47_;
	GFileInfo* _tmp48_;
	GFileInfo* _tmp49_;
	GFile* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GFile* _tmp53_;
	GFile* _tmp54_;
	GFile* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GFile* _tmp58_;
	GFile* _tmp59_;
	GFileInfo* _tmp60_;
	DirectoryMonitorFileInfoMap* _tmp61_;
	GFile* _tmp62_;
	gboolean updated;
	DirectoryMonitorFileInfoMap* _tmp63_;
	GFile* _tmp64_;
	GFileInfo* _tmp65_;
	gboolean _tmp66_;
	GFile* _tmp67_;
	GFileInfo* _tmp68_;
	GFile* _tmp69_;
	GFileInfo* _tmp70_;
	GFile* _tmp71_;
	GFile* _tmp72_;
	GFileInfo* _tmp73_;
};

struct _DirectoryMonitorAsyncNotifyDirectoryDeletedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DirectoryMonitor* self;
	GFile* dir;
	gboolean already_removed;
	GeeArrayList* file_children;
	GeeArrayList* _tmp0_;
	GeeArrayList* dir_children;
	GeeArrayList* _tmp1_;
	gint count;
	DirectoryMonitorFileInfoMap* _tmp2_;
	GFile* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _dir_child_list;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _dir_child_size;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _dir_child_index;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GFile* dir_child;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gpointer _tmp18_;
	GFile* _tmp19_;
	GeeArrayList* _file_child_list;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	gint _file_child_size;
	GeeArrayList* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gint _file_child_index;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GFile* file_child;
	GeeArrayList* _tmp28_;
	gint _tmp29_;
	gpointer _tmp30_;
	DirectoryMonitorFileInfoMap* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	gboolean _tmp34_;
	DirectoryMonitorFileInfoMap* _tmp35_;
	GFile* _tmp36_;
	GFile* _tmp37_;
};

struct _DirectoryMonitorExploreAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DirectoryMonitor* self;
	GFile* dir;
	GFileInfo* dir_info;
	gboolean in_discovery;
	DirectoryMonitorFileInfoMap* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	gboolean _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	GFileInfo* local_dir_info;
	GFileInfo* _tmp8_;
	GFileInfo* _tmp9_;
	GFileInfo* _tmp10_;
	GFileInfo* _tmp11_;
	GFile* _tmp12_;
	GCancellable* _tmp13_;
	GFileInfo* _tmp14_;
	GFileInfo* _tmp15_;
	GError* err;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	GFileInfo* _tmp22_;
	gboolean _tmp23_;
	GFile* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	GFileInfo* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gboolean _tmp31_;
	GFile* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gboolean _tmp35_;
	GFileInfo* _tmp36_;
	GFileType _tmp37_;
	const gchar* _tmp38_;
	GFile* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GFileInfo* _tmp42_;
	GFileType _tmp43_;
	GEnumValue* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gboolean _tmp47_;
	GeeHashMap* dir_map;
	GeeHashMap* file_map;
	GFileEnumerator* enumerator;
	GFile* _tmp48_;
	GCancellable* _tmp49_;
	GFileEnumerator* _tmp50_;
	gboolean _tmp51_;
	GList* infos;
	GFileEnumerator* _tmp52_;
	GCancellable* _tmp53_;
	GList* _tmp54_;
	GList* _tmp55_;
	GList* _tmp56_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp57_;
	GFileInfo* info;
	GFileInfo* _tmp58_;
	gboolean _tmp59_;
	GFile* _tmp60_;
	GFileInfo* _tmp61_;
	const gchar* _tmp62_;
	GFile* _tmp63_;
	GFile* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	GFileInfo* _tmp67_;
	gboolean _tmp68_;
	GFileInfo* _tmp69_;
	GFileType _tmp70_;
	GeeHashMap* _tmp71_;
	GeeHashMap* _tmp72_;
	GeeHashMap* _tmp73_;
	GFile* _tmp74_;
	GFileInfo* _tmp75_;
	const gchar* _tmp76_;
	GFile* _tmp77_;
	GFile* _tmp78_;
	GFileInfo* _tmp79_;
	GeeHashMap* _tmp80_;
	GeeHashMap* _tmp81_;
	GeeHashMap* _tmp82_;
	GFile* _tmp83_;
	GFileInfo* _tmp84_;
	const gchar* _tmp85_;
	GFile* _tmp86_;
	GFile* _tmp87_;
	GFileInfo* _tmp88_;
	GError* err2;
	GFile* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	GError* _tmp92_;
	const gchar* _tmp93_;
	gboolean _tmp94_;
	gboolean _tmp95_;
	GFile* _tmp96_;
	GFileInfo* _tmp97_;
	GFile* _tmp98_;
	GFileInfo* _tmp99_;
	GFile* _tmp100_;
	GFileInfo* _tmp101_;
	GeeHashMap* _tmp102_;
	GeeHashMap* _tmp103_;
	gboolean _tmp104_;
	gboolean _tmp105_;
	gboolean _tmp106_;
	GeeHashMap* _tmp107_;
	GeeIterator* _subdir_it;
	GeeHashMap* _tmp108_;
	GeeSet* _tmp109_;
	GeeSet* _tmp110_;
	GeeSet* _tmp111_;
	GeeIterator* _tmp112_;
	GeeIterator* _tmp113_;
	GeeIterator* _tmp114_;
	gboolean _tmp115_;
	GFile* subdir;
	GeeIterator* _tmp116_;
	gpointer _tmp117_;
	gint _tmp118_;
	gint _tmp119_;
	GFile* _tmp120_;
	GeeHashMap* _tmp121_;
	GFile* _tmp122_;
	gpointer _tmp123_;
	GFileInfo* _tmp124_;
	gboolean _tmp125_;
	GFile* _tmp126_;
	GeeHashMap* _tmp127_;
	GFile* _tmp128_;
	gpointer _tmp129_;
	GFileInfo* _tmp130_;
	gboolean _tmp131_;
	gboolean _tmp132_;
	GError * _inner_error_;
};

struct _DirectoryMonitorNotifyDirectoryFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DirectoryMonitor* self;
	GeeMap* map;
	gboolean in_discovery;
	GeeMapIterator* iter;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	GeeMapIterator* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeMapIterator* _tmp5_;
	gpointer _tmp6_;
	GFile* _tmp7_;
	GeeMapIterator* _tmp8_;
	gpointer _tmp9_;
	GFileInfo* _tmp10_;
	GeeMapIterator* _tmp11_;
	gpointer _tmp12_;
	GFile* _tmp13_;
	GeeMapIterator* _tmp14_;
	gpointer _tmp15_;
	GFileInfo* _tmp16_;
};

struct _DirectoryMonitorQueryInfoQueueElement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DirectoryMonitorQueryInfoQueueElementPrivate * priv;
	DirectoryMonitor* owner;
	GFile* file;
	GFile* other_file;
	GFileMonitorEvent event;
	guint position;
	gulong time_created_msec;
	GFileInfo* info;
	GError* err;
	gboolean completed;
};

struct _DirectoryMonitorQueryInfoQueueElementClass {
	GTypeClass parent_class;
	void (*finalize) (DirectoryMonitorQueryInfoQueueElement *self);
};

struct _DirectoryMonitorParamSpecQueryInfoQueueElement {
	GParamSpec parent_instance;
};

struct _DirectoryMonitorFileInfoMap {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DirectoryMonitorFileInfoMapPrivate * priv;
};

struct _DirectoryMonitorFileInfoMapClass {
	GTypeClass parent_class;
	void (*finalize) (DirectoryMonitorFileInfoMap *self);
};

struct _DirectoryMonitorFileInfoMapPrivate {
	GeeHashMap* map;
	GeeHashMap* id_map;
};

struct _DirectoryMonitorParamSpecFileInfoMap {
	GParamSpec parent_instance;
};


static gpointer directory_monitor_parent_class = NULL;
static gpointer directory_monitor_query_info_queue_element_parent_class = NULL;
static guint directory_monitor_query_info_queue_element_current;
static guint directory_monitor_query_info_queue_element_current = (guint) 0;
static gpointer directory_monitor_file_info_map_parent_class = NULL;

GType directory_monitor_get_type (void) G_GNUC_CONST;
static gpointer directory_monitor_query_info_queue_element_ref (gpointer instance);
static void directory_monitor_query_info_queue_element_unref (gpointer instance);
static GParamSpec* directory_monitor_param_spec_query_info_queue_element (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void directory_monitor_value_set_query_info_queue_element (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void directory_monitor_value_take_query_info_queue_element (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer directory_monitor_value_get_query_info_queue_element (const GValue* value) G_GNUC_UNUSED;
static GType directory_monitor_query_info_queue_element_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer directory_monitor_file_info_map_ref (gpointer instance);
static void directory_monitor_file_info_map_unref (gpointer instance);
static GParamSpec* directory_monitor_param_spec_file_info_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void directory_monitor_value_set_file_info_map (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void directory_monitor_value_take_file_info_map (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer directory_monitor_value_get_file_info_map (const GValue* value) G_GNUC_UNUSED;
static GType directory_monitor_file_info_map_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define DIRECTORY_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIRECTORY_MONITOR, DirectoryMonitorPrivate))
enum  {
	DIRECTORY_MONITOR_DUMMY_PROPERTY
};
static GType directory_monitor_ftype_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_new (void);
static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_construct (GType object_type);
#define DIRECTORY_MONITOR_DEFAULT_PRIORITY G_PRIORITY_LOW
#define DIRECTORY_MONITOR_DIR_INFO_FLAGS G_FILE_QUERY_INFO_NONE
#define DIRECTORY_MONITOR_FILE_INFO_FLAGS G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS
#define DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS G_FILE_QUERY_INFO_NONE
#define DIRECTORY_MONITOR_SUPPORT_DIR_SYMLINKS TRUE
#define DIRECTORY_MONITOR_SUPPORT_FILE_SYMLINKS FALSE
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
#define DIRECTORY_MONITOR_FILE_MONITOR_FLAGS G_FILE_MONITOR_SEND_MOVED
#define DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC ((guint) 500)
#define DIRECTORY_MONITOR_MAX_EXPLORATION_DIRS 5
DirectoryMonitor* directory_monitor_new (GFile* root, gboolean recurse, gboolean monitoring);
DirectoryMonitor* directory_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring);
void directory_monitor_mdbg (const gchar* msg);
gboolean directory_monitor_is_recursive (DirectoryMonitor* self);
gboolean directory_monitor_is_monitoring (DirectoryMonitor* self);
void directory_monitor_notify_root_deleted (DirectoryMonitor* self, GFile* root);
static void directory_monitor_real_notify_root_deleted (DirectoryMonitor* self, GFile* root);
static void directory_monitor_internal_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
static gboolean directory_monitor_file_info_map_remove (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info);
static gboolean directory_monitor_file_info_map_update (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
static void directory_monitor_real_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
void directory_monitor_notify_discovery_started (DirectoryMonitor* self);
static void directory_monitor_real_notify_discovery_started (DirectoryMonitor* self);
void directory_monitor_internal_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_internal_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_internal_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_internal_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_discovery_failed (DirectoryMonitor* self, const gchar* reason);
static void directory_monitor_real_notify_discovery_failed (DirectoryMonitor* self, const gchar* reason);
void directory_monitor_notify_discovery_completed (DirectoryMonitor* self);
static void directory_monitor_real_notify_discovery_completed (DirectoryMonitor* self);
static void directory_monitor_internal_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static gboolean directory_monitor_is_file_create_move (DirectoryMonitor* self, GFile* file, GFileInfo* info, GFile** old_file, GFileInfo** old_file_info);
static void directory_monitor_internal_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
void directory_monitor_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
static void directory_monitor_real_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
void directory_monitor_notify_file_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_notify_file_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_internal_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
void directory_monitor_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_internal_notify_file_deleted (DirectoryMonitor* self, GFile* file);
void directory_monitor_notify_file_deleted (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_notify_file_deleted (DirectoryMonitor* self, GFile* file);
static void directory_monitor_internal_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_file_info_map_remove_descendents (DirectoryMonitorFileInfoMap* self, GFile* root, DirectoryMonitorFileInfoMap* descendents);
static void directory_monitor_internal_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFileInfo* old_dir_info, GFile* new_dir, GFileInfo* new_dir_info);
void directory_monitor_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_async_internal_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFileInfo* old_dir_info, GFile* new_dir, GFileInfo* new_dir_info, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void directory_monitor_async_internal_notify_directory_moved_finish (DirectoryMonitor* self, GAsyncResult* _res_);
static void directory_monitor_async_internal_notify_directory_moved_data_free (gpointer _data);
static gboolean directory_monitor_async_internal_notify_directory_moved_co (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_);
gboolean file_equal (GFile* a, GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint directory_monitor_file_info_map_get_children (DirectoryMonitorFileInfoMap* self, GFile* root, GeeCollection* files, GeeCollection* dirs);
static GFileInfo* directory_monitor_file_info_map_get_info (DirectoryMonitorFileInfoMap* self, GFile* file);
static void directory_monitor_async_internal_notify_directory_moved_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _directory_monitor_async_internal_notify_directory_moved_co_gsource_func (gpointer self);
static gboolean directory_monitor_remove_monitor (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static gboolean directory_monitor_add_monitor (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
static void directory_monitor_real_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
void directory_monitor_notify_directory_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_notify_directory_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_internal_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
void directory_monitor_notify_directory_attributes_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_notify_directory_attributes_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_internal_notify_directory_deleted (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_async_notify_directory_deleted (DirectoryMonitor* self, GFile* dir, gboolean already_removed, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void directory_monitor_async_notify_directory_deleted_finish (DirectoryMonitor* self, GAsyncResult* _res_);
static void directory_monitor_async_notify_directory_deleted_data_free (gpointer _data);
static gboolean directory_monitor_async_notify_directory_deleted_co (DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_);
static void directory_monitor_async_notify_directory_deleted_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean _directory_monitor_async_notify_directory_deleted_co_gsource_func (gpointer self);
void directory_monitor_notify_directory_deleted (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_notify_directory_deleted (DirectoryMonitor* self, GFile* dir);
void directory_monitor_notify_closed (DirectoryMonitor* self);
static void directory_monitor_real_notify_closed (DirectoryMonitor* self);
GFile* directory_monitor_get_root (DirectoryMonitor* self);
gboolean directory_monitor_is_in_root (DirectoryMonitor* self, GFile* file);
gboolean directory_monitor_has_started (DirectoryMonitor* self);
void directory_monitor_start_discovery (DirectoryMonitor* self);
static void directory_monitor_explore_async (DirectoryMonitor* self, GFile* dir, GFileInfo* dir_info, gboolean in_discovery, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void directory_monitor_explore_finish (DirectoryMonitor* self, GAsyncResult* _res_);
void directory_monitor_close (DirectoryMonitor* self);
static void directory_monitor_real_close (DirectoryMonitor* self);
static void directory_monitor_cancel_monitor (DirectoryMonitor* self, GFileMonitor* monitor);
static DirectoryMonitorFType directory_monitor_get_ftype (GFileInfo* info);
const gchar* g_file_type_to_string (GFileType self);
static void directory_monitor_explore_async_data_free (gpointer _data);
static gboolean directory_monitor_explore_async_co (DirectoryMonitorExploreAsyncData* _data_);
static gboolean directory_monitor_file_info_map_contains (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info);
static void directory_monitor_explore_directory_completed (DirectoryMonitor* self, gboolean in_discovery);
static void directory_monitor_explore_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* get_file_info_id (GFileInfo* info);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
gboolean directory_monitor_is_file_symlink_supported (GFileInfo* info);
guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
static void directory_monitor_notify_directory_files (DirectoryMonitor* self, GeeMap* map, gboolean in_discovery, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void directory_monitor_notify_directory_files_finish (DirectoryMonitor* self, GAsyncResult* _res_);
static void directory_monitor_notify_directory_files_data_free (gpointer _data);
static gboolean directory_monitor_notify_directory_files_co (DirectoryMonitorNotifyDirectoryFilesData* _data_);
static gboolean _directory_monitor_notify_directory_files_co_gsource_func (gpointer self);
static gchar* directory_monitor_file_info_map_get_id (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info);
static void directory_monitor_on_monitor_notification (DirectoryMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void _directory_monitor_on_monitor_notification_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
const gchar* g_file_monitor_event_to_string (GFileMonitorEvent self);
static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_new (DirectoryMonitor* owner, GFile* file, GFile* other_file, GFileMonitorEvent event);
static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_construct (GType object_type, DirectoryMonitor* owner, GFile* file, GFile* other_file, GFileMonitorEvent event);
static void directory_monitor_query_info_queue_element_on_completed (DirectoryMonitorQueryInfoQueueElement* self, GObject* source, GAsyncResult* aresult);
static void _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean directory_monitor_check_for_expired_delete_events (DirectoryMonitor* self);
static gboolean _directory_monitor_check_for_expired_delete_events_gsource_func (gpointer self);
static void directory_monitor_process_query_queue (DirectoryMonitor* self, DirectoryMonitorQueryInfoQueueElement* query_info);
static GFile* directory_monitor_file_info_map_find_match (DirectoryMonitorFileInfoMap* self, GFileInfo* match);
static void directory_monitor_on_monitor_notification_ready (DirectoryMonitor* self, GFile* file, GFile* other_file, GFileInfo* info, GFileMonitorEvent event);
GFileInfo* directory_monitor_get_file_info (DirectoryMonitor* self, GFile* file);
gulong now_ms (void);
GeeCollection* directory_monitor_get_files (DirectoryMonitor* self);
static GeeCollection* directory_monitor_file_info_map_get_all (DirectoryMonitorFileInfoMap* self);
GFileInfo* directory_monitor_query_file_info (DirectoryMonitor* self, GFile* file);
static GFileInfo* directory_monitor_file_info_map_query_info (DirectoryMonitorFileInfoMap* self, GFile* file, GCancellable* cancellable);
static void directory_monitor_real_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void directory_monitor_real_root_deleted (DirectoryMonitor* self, GFile* root);
static void directory_monitor_real_discovery_started (DirectoryMonitor* self);
static void directory_monitor_real_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void directory_monitor_real_directory_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_discovery_failed (DirectoryMonitor* self, const gchar* reason);
static void directory_monitor_real_discovery_completed (DirectoryMonitor* self);
static void directory_monitor_real_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
static void directory_monitor_real_file_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info);
static void directory_monitor_real_file_attributes_altered (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_file_deleted (DirectoryMonitor* self, GFile* file);
static void directory_monitor_real_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info);
static void directory_monitor_real_directory_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info);
static void directory_monitor_real_directory_attributes_altered (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_directory_deleted (DirectoryMonitor* self, GFile* dir);
static void directory_monitor_real_closed (DirectoryMonitor* self);
enum  {
	DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_DUMMY_PROPERTY
};
static void directory_monitor_query_info_queue_element_finalize (DirectoryMonitorQueryInfoQueueElement* obj);
#define DIRECTORY_MONITOR_FILE_INFO_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMapPrivate))
enum  {
	DIRECTORY_MONITOR_FILE_INFO_MAP_DUMMY_PROPERTY
};
static gboolean directory_monitor_file_info_map_normalize_file (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info, GFile** normalized, gchar** id);
static void directory_monitor_file_info_map_remove_all (DirectoryMonitorFileInfoMap* self, GeeCollection* files);
static void directory_monitor_file_info_map_finalize (DirectoryMonitorFileInfoMap* obj);
static void directory_monitor_finalize (GObject* obj);


static GType directory_monitor_ftype_get_type (void) {
	static volatile gsize directory_monitor_ftype_type_id__volatile = 0;
	if (g_once_init_enter (&directory_monitor_ftype_type_id__volatile)) {
		static const GEnumValue values[] = {{DIRECTORY_MONITOR_FTYPE_FILE, "DIRECTORY_MONITOR_FTYPE_FILE", "file"}, {DIRECTORY_MONITOR_FTYPE_DIRECTORY, "DIRECTORY_MONITOR_FTYPE_DIRECTORY", "directory"}, {DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "DIRECTORY_MONITOR_FTYPE_UNSUPPORTED", "unsupported"}, {0, NULL, NULL}};
		GType directory_monitor_ftype_type_id;
		directory_monitor_ftype_type_id = g_enum_register_static ("DirectoryMonitorFType", values);
		g_once_init_leave (&directory_monitor_ftype_type_id__volatile, directory_monitor_ftype_type_id);
	}
	return directory_monitor_ftype_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 459 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self ? g_object_ref (self) : NULL;
#line 802 "DirectoryMonitor.c"
}


DirectoryMonitor* directory_monitor_construct (GType object_type, GFile* root, gboolean recurse, gboolean monitoring) {
	DirectoryMonitor * self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 458 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (root), NULL);
#line 458 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = (DirectoryMonitor*) g_object_new (object_type, NULL);
#line 459 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = root;
#line 459 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 459 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->root);
#line 459 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->root = _tmp1_;
#line 460 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = recurse;
#line 460 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->recurse = _tmp2_;
#line 461 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = monitoring;
#line 461 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->monitoring = _tmp3_;
#line 458 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self;
#line 834 "DirectoryMonitor.c"
}


DirectoryMonitor* directory_monitor_new (GFile* root, gboolean recurse, gboolean monitoring) {
#line 458 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return directory_monitor_construct (TYPE_DIRECTORY_MONITOR, root, recurse, monitoring);
#line 841 "DirectoryMonitor.c"
}


void directory_monitor_mdbg (const gchar* msg) {
#line 464 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (msg != NULL);
#line 848 "DirectoryMonitor.c"
}


gboolean directory_monitor_is_recursive (DirectoryMonitor* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 470 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 471 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->recurse;
#line 471 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp0_;
#line 471 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 863 "DirectoryMonitor.c"
}


gboolean directory_monitor_is_monitoring (DirectoryMonitor* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 474 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 475 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->monitoring;
#line 475 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp0_;
#line 475 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 878 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_root_deleted (DirectoryMonitor* self, GFile* root) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
#line 478 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (root));
#line 479 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->root;
#line 479 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = root;
#line 479 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = g_file_equal (_tmp0_, _tmp1_);
#line 479 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_tmp2_, "this.root.equal(root)");
#line 481 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg ("root deleted");
#line 482 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = root;
#line 482 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "root-deleted", _tmp3_);
#line 903 "DirectoryMonitor.c"
}


void directory_monitor_notify_root_deleted (DirectoryMonitor* self, GFile* root) {
#line 478 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 478 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_root_deleted (self, root);
#line 912 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info) {
	gboolean removed = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFileInfo* _tmp11_ = NULL;
#line 485 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 485 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_root));
#line 485 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_root));
#line 485 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_root_info));
#line 486 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 486 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_root;
#line 486 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_remove (_tmp0_, _tmp1_, NULL);
#line 486 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	removed = _tmp2_;
#line 487 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (removed, "removed");
#line 489 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = self->priv->files;
#line 489 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = new_root;
#line 489 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = new_root_info;
#line 489 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = directory_monitor_file_info_map_update (_tmp3_, _tmp4_, _tmp5_);
#line 489 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp6_;
#line 490 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 492 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = new_root;
#line 492 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 492 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->root);
#line 492 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->root = _tmp8_;
#line 494 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = old_root;
#line 494 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = new_root;
#line 494 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = new_root_info;
#line 494 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_root_moved (self, _tmp9_, _tmp10_, _tmp11_);
#line 977 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GFileInfo* _tmp13_ = NULL;
#line 497 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_root));
#line 497 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_root));
#line 497 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_root_info));
#line 498 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->root;
#line 498 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_root;
#line 498 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = g_file_equal (_tmp0_, _tmp1_);
#line 498 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_tmp2_, "this.root.equal(old_root)");
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = old_root;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = _tmp4_;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = new_root;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = g_file_get_path (_tmp6_);
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = _tmp7_;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = g_strdup_printf ("root moved: %s -> %s", _tmp5_, _tmp8_);
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = _tmp9_;
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp10_);
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp10_);
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp8_);
#line 500 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp5_);
#line 501 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = old_root;
#line 501 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = new_root;
#line 501 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = new_root_info;
#line 501 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "root-moved", _tmp11_, _tmp12_, _tmp13_);
#line 1042 "DirectoryMonitor.c"
}


void directory_monitor_notify_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info) {
#line 497 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 497 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_root_moved (self, old_root, new_root, new_root_info);
#line 1051 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_discovery_started (DirectoryMonitor* self) {
#line 505 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg ("discovery started");
#line 506 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "discovery-started");
#line 1060 "DirectoryMonitor.c"
}


void directory_monitor_notify_discovery_started (DirectoryMonitor* self) {
#line 504 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 504 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_discovery_started (self);
#line 1069 "DirectoryMonitor.c"
}


static void directory_monitor_real_internal_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp7_ = NULL;
	GFileInfo* _tmp8_ = NULL;
#line 509 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 509 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 510 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 510 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 510 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 510 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_update (_tmp0_, _tmp1_, _tmp2_);
#line 510 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp3_) {
#line 1094 "DirectoryMonitor.c"
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 511 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = file;
#line 511 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 511 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = _tmp5_;
#line 511 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_debug ("DirectoryMonitor.vala:511: DirectoryMonitor.internal_notify_file_disco" \
"vered: %s discovered but not added to file map", _tmp6_);
#line 511 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp6_);
#line 514 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return;
#line 1110 "DirectoryMonitor.c"
	}
#line 517 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = file;
#line 517 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = info;
#line 517 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_file_discovered (self, _tmp7_, _tmp8_);
#line 1118 "DirectoryMonitor.c"
}


void directory_monitor_internal_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 509 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 509 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->internal_notify_file_discovered (self, file, info);
#line 1127 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 520 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 520 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 521 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 521 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 521 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 521 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file discovered: %s", _tmp2_);
#line 521 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 521 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 521 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 521 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 522 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 522 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 522 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-discovered", _tmp5_, _tmp6_);
#line 1165 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 520 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 520 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_discovered (self, file, info);
#line 1174 "DirectoryMonitor.c"
}


static void directory_monitor_real_internal_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
#line 525 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 525 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_update (_tmp0_, _tmp1_, _tmp2_);
#line 526 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp3_;
#line 527 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 529 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = dir;
#line 529 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = info;
#line 529 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_discovered (self, _tmp4_, _tmp5_);
#line 1208 "DirectoryMonitor.c"
}


void directory_monitor_internal_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 525 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 525 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->internal_notify_directory_discovered (self, dir, info);
#line 1217 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory discovered: %s", _tmp2_);
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 533 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 534 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 534 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 534 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-discovered", _tmp5_, _tmp6_);
#line 1255 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_discovered (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 532 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_discovered (self, dir, info);
#line 1264 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_discovery_failed (DirectoryMonitor* self, const gchar* reason) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 537 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (reason != NULL);
#line 538 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = reason;
#line 538 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_warning ("DirectoryMonitor.vala:538: discovery failed: %s", _tmp0_);
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = reason;
#line 539 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "discovery-failed", _tmp1_);
#line 1281 "DirectoryMonitor.c"
}


void directory_monitor_notify_discovery_failed (DirectoryMonitor* self, const gchar* reason) {
#line 537 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 537 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_discovery_failed (self, reason);
#line 1290 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_discovery_completed (DirectoryMonitor* self) {
#line 543 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "discovery-completed");
#line 1297 "DirectoryMonitor.c"
}


void directory_monitor_notify_discovery_completed (DirectoryMonitor* self) {
#line 542 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 542 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_discovery_completed (self);
#line 1306 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	GFile* old_file = NULL;
	GFileInfo* old_file_info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 546 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 546 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 546 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_is_file_create_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_file);
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old_file = _tmp2_;
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_file_info);
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old_file_info = _tmp3_;
#line 549 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp4_) {
#line 1340 "DirectoryMonitor.c"
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFileInfo* _tmp7_ = NULL;
#line 550 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = old_file;
#line 550 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = file;
#line 550 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = info;
#line 550 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_file_moved (self, _tmp5_, _tmp6_, _tmp7_);
#line 1352 "DirectoryMonitor.c"
	} else {
		gboolean updated = FALSE;
		DirectoryMonitorFileInfoMap* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		GFileInfo* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		GFile* _tmp13_ = NULL;
		GFileInfo* _tmp14_ = NULL;
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = self->priv->files;
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = file;
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = info;
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = directory_monitor_file_info_map_update (_tmp8_, _tmp9_, _tmp10_);
#line 552 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		updated = _tmp11_;
#line 553 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = updated;
#line 553 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_assert (_tmp12_, "updated");
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp13_ = file;
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = info;
#line 555 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_file_created (self, _tmp13_, _tmp14_);
#line 1382 "DirectoryMonitor.c"
	}
#line 546 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_file_info);
#line 546 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_file);
#line 1388 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 559 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 559 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 560 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 560 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 560 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 560 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file created: %s", _tmp2_);
#line 560 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 560 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 560 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 560 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 561 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 561 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 561 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-created", _tmp5_, _tmp6_);
#line 1426 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 559 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 559 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_created (self, file, info);
#line 1435 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GFileInfo* _tmp8_ = NULL;
#line 564 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 564 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 564 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 564 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_file_info));
#line 567 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 567 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_file;
#line 567 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_file_info_map_remove (_tmp0_, _tmp1_, NULL);
#line 569 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = self->priv->files;
#line 569 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = new_file;
#line 569 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = new_file_info;
#line 569 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = directory_monitor_file_info_map_update (_tmp2_, _tmp3_, _tmp4_);
#line 569 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp5_;
#line 570 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 572 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = old_file;
#line 572 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = new_file;
#line 572 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = new_file_info;
#line 572 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_file_moved (self, _tmp6_, _tmp7_, _tmp8_);
#line 1484 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFileInfo* _tmp10_ = NULL;
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_file_info));
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = old_file;
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = new_file;
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = _tmp4_;
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = g_strdup_printf ("file moved: %s -> %s", _tmp2_, _tmp5_);
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = _tmp6_;
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp7_);
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp7_);
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp5_);
#line 576 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 577 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = old_file;
#line 577 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = new_file;
#line 577 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = new_file_info;
#line 577 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-moved", _tmp8_, _tmp9_, _tmp10_);
#line 1538 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 575 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_moved (self, old_file, new_file, new_file_info);
#line 1547 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_altered (DirectoryMonitor* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file altered: %s", _tmp2_);
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 581 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 582 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-altered", _tmp5_);
#line 1580 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_altered (DirectoryMonitor* self, GFile* file) {
#line 580 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 580 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_altered (self, file);
#line 1589 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
#line 585 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 585 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 585 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 586 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 586 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 586 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 586 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_update (_tmp0_, _tmp1_, _tmp2_);
#line 586 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp3_;
#line 587 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 589 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = file;
#line 589 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = info;
#line 589 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_file_alteration_completed (self, _tmp4_, _tmp5_);
#line 1625 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file alteration completed: %s", _tmp2_);
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 593 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 594 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 594 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 594 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-alteration-completed", _tmp5_, _tmp6_);
#line 1663 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 592 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_alteration_completed (self, file, info);
#line 1672 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 597 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file attributes altered: %s", _tmp2_);
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 598 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 599 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-attributes-altered", _tmp5_);
#line 1705 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_attributes_altered (DirectoryMonitor* self, GFile* file) {
#line 597 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 597 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_attributes_altered (self, file);
#line 1714 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_file_deleted (DirectoryMonitor* self, GFile* file) {
	gboolean removed = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_ = NULL;
#line 602 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 602 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 603 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 603 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 603 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_remove (_tmp0_, _tmp1_, NULL);
#line 603 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	removed = _tmp2_;
#line 604 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (removed, "removed");
#line 606 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = file;
#line 606 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_file_deleted (self, _tmp3_);
#line 1742 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_file_deleted (DirectoryMonitor* self, GFile* file) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 609 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("file deleted: %s", _tmp2_);
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 610 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 611 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = file;
#line 611 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "file-deleted", _tmp5_);
#line 1775 "DirectoryMonitor.c"
}


void directory_monitor_notify_file_deleted (DirectoryMonitor* self, GFile* file) {
#line 609 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 609 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_file_deleted (self, file);
#line 1784 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	GFile* old_dir = NULL;
	GFileInfo* old_dir_info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 614 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 614 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 614 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_is_file_create_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_dir);
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old_dir = _tmp2_;
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_dir_info);
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old_dir_info = _tmp3_;
#line 617 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp4_) {
#line 1818 "DirectoryMonitor.c"
		DirectoryMonitorFileInfoMap* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		DirectoryMonitorFileInfoMap* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFileInfo* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFileInfo* _tmp11_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = self->priv->files;
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = old_dir;
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = self->priv->parent_moved;
#line 623 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_remove_descendents (_tmp5_, _tmp6_, _tmp7_);
#line 625 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = old_dir;
#line 625 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = old_dir_info;
#line 625 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = dir;
#line 625 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = info;
#line 625 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_directory_moved (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 1844 "DirectoryMonitor.c"
	} else {
		gboolean updated = FALSE;
		DirectoryMonitorFileInfoMap* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFileInfo* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		GFile* _tmp17_ = NULL;
		GFileInfo* _tmp18_ = NULL;
#line 627 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = self->priv->files;
#line 627 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp13_ = dir;
#line 627 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = info;
#line 627 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = directory_monitor_file_info_map_update (_tmp12_, _tmp13_, _tmp14_);
#line 627 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		updated = _tmp15_;
#line 628 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp16_ = updated;
#line 628 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_assert (_tmp16_, "updated");
#line 630 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp17_ = dir;
#line 630 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp18_ = info;
#line 630 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_directory_created (self, _tmp17_, _tmp18_);
#line 1874 "DirectoryMonitor.c"
	}
#line 614 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_dir_info);
#line 614 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (old_dir);
#line 1880 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 634 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 634 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 635 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 635 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 635 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 635 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory created: %s", _tmp2_);
#line 635 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 635 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 635 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 635 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 636 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 636 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 636 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-created", _tmp5_, _tmp6_);
#line 1918 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 634 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 634 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_created (self, dir, info);
#line 1927 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFileInfo* old_dir_info, GFile* new_dir, GFileInfo* new_dir_info) {
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
#line 639 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 639 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_dir));
#line 639 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (old_dir_info));
#line 639 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_dir));
#line 639 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_dir_info));
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = old_dir;
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_dir_info;
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = new_dir;
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = new_dir_info;
#line 641 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_internal_notify_directory_moved (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL, NULL);
#line 1956 "DirectoryMonitor.c"
}


static void directory_monitor_async_internal_notify_directory_moved_data_free (gpointer _data) {
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
	_data_ = _data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->old_dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->old_dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->new_dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->new_dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_slice_free (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData, _data_);
#line 1975 "DirectoryMonitor.c"
}


static void directory_monitor_async_internal_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFileInfo* old_dir_info, GFile* new_dir, GFileInfo* new_dir_info, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
	DirectoryMonitor* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFileInfo* _tmp7_ = NULL;
	GFileInfo* _tmp8_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_slice_new0 (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, directory_monitor_async_internal_notify_directory_moved);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, directory_monitor_async_internal_notify_directory_moved_data_free);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->self = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = old_dir;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->old_dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->old_dir = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = old_dir_info;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->old_dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->old_dir_info = _tmp4_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = new_dir;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->new_dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->new_dir = _tmp6_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = new_dir_info;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->new_dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->new_dir_info = _tmp8_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_internal_notify_directory_moved_co (_data_);
#line 2034 "DirectoryMonitor.c"
}


static void directory_monitor_async_internal_notify_directory_moved_finish (DirectoryMonitor* self, GAsyncResult* _res_) {
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2042 "DirectoryMonitor.c"
}


static gboolean _file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
#line 646 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 2051 "DirectoryMonitor.c"
}


static void directory_monitor_async_internal_notify_directory_moved_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = _user_data_;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_source_object_ = source_object;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_res_ = _res_;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_internal_notify_directory_moved_co (_data_);
#line 2065 "DirectoryMonitor.c"
}


static gboolean _directory_monitor_async_internal_notify_directory_moved_co_gsource_func (gpointer self) {
	gboolean result;
	result = directory_monitor_async_internal_notify_directory_moved_co (self);
#line 677 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 2074 "DirectoryMonitor.c"
}


static gboolean directory_monitor_async_internal_notify_directory_moved_co (DirectoryMonitorAsyncInternalNotifyDirectoryMovedData* _data_) {
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_data_->_state_) {
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 0:
#line 2083 "DirectoryMonitor.c"
		goto _state_0;
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 1:
#line 2087 "DirectoryMonitor.c"
		goto _state_1;
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 2:
#line 2091 "DirectoryMonitor.c"
		goto _state_2;
		default:
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_assert_not_reached ();
#line 2096 "DirectoryMonitor.c"
	}
	_state_0:
#line 646 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = NULL;
#line 646 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 646 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->file_children = _data_->_tmp0_;
#line 647 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = NULL;
#line 647 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 647 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir_children = _data_->_tmp1_;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = NULL;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = _data_->self->priv->files;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = NULL;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = _data_->old_dir;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp4_ = NULL;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp4_ = _data_->file_children;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp5_ = NULL;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp5_ = _data_->dir_children;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp6_ = 0;
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp6_ = directory_monitor_file_info_map_get_children (_data_->_tmp2_, _data_->_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 648 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->count = _data_->_tmp6_;
#line 649 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp7_ = 0;
#line 649 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp7_ = _data_->count;
#line 649 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp7_ > 0) {
#line 2139 "DirectoryMonitor.c"
		{
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = NULL;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = _data_->dir_children;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = NULL;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_list = _data_->_tmp9_;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = NULL;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = _data_->_dir_child_list;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = 0;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = 0;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_size = _data_->_tmp12_;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_index = -1;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp13_ = 0;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp13_ = _data_->_dir_child_index;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_dir_child_index = _data_->_tmp13_ + 1;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp14_ = 0;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp14_ = _data_->_dir_child_index;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp15_ = 0;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp15_ = _data_->_dir_child_size;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_data_->_tmp14_ < _data_->_tmp15_)) {
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 2187 "DirectoryMonitor.c"
				}
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp16_ = NULL;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp16_ = _data_->_dir_child_list;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp17_ = 0;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp17_ = _data_->_dir_child_index;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp18_ = NULL;
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp18_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_tmp17_);
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->dir_child = (GFile*) _data_->_tmp18_;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp19_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp19_ = _data_->self->priv->files;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp20_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp20_ = _data_->dir_child;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp21_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp21_ = directory_monitor_file_info_map_get_info (_data_->_tmp19_, _data_->_tmp20_);
#line 654 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->dir_info = _data_->_tmp21_;
#line 655 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp22_ = NULL;
#line 655 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp22_ = _data_->dir_info;
#line 655 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_data_->_tmp22_ == NULL) {
#line 656 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp23_ = NULL;
#line 656 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp23_ = _data_->dir_child;
#line 656 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp24_ = NULL;
#line 656 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp24_ = g_file_get_path (_data_->_tmp23_);
#line 656 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp25_ = NULL;
#line 656 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp25_ = _data_->_tmp24_;
#line 656 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					g_warning ("DirectoryMonitor.vala:656: Unable to retrieve directory-moved info for" \
" %s", _data_->_tmp25_);
#line 656 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_data_->_tmp25_);
#line 658 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->dir_info);
#line 658 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->dir_child);
#line 658 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					continue;
#line 2245 "DirectoryMonitor.c"
				}
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp26_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp26_ = _data_->dir_child;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp27_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp27_ = _data_->dir_info;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp28_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp28_ = _data_->new_dir;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp29_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp29_ = _data_->dir_child;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp30_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp30_ = g_file_get_basename (_data_->_tmp29_);
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp31_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp31_ = _data_->_tmp30_;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp32_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp32_ = g_file_get_child (_data_->_tmp28_, _data_->_tmp31_);
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp33_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp33_ = _data_->_tmp32_;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp34_ = NULL;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp34_ = _data_->dir_info;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 1;
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_async_internal_notify_directory_moved (_data_->self, _data_->_tmp26_, _data_->_tmp27_, _data_->_tmp33_, _data_->_tmp34_, directory_monitor_async_internal_notify_directory_moved_ready, _data_);
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 2289 "DirectoryMonitor.c"
				_state_1:
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_async_internal_notify_directory_moved_finish (_data_->self, _data_->_res_);
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->_tmp33_);
#line 661 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_data_->_tmp31_);
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->dir_info);
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->dir_child);
#line 2301 "DirectoryMonitor.c"
			}
#line 653 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_dir_child_list);
#line 2305 "DirectoryMonitor.c"
		}
		{
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp35_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp35_ = _data_->file_children;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp36_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp36_ = _g_object_ref0 (_data_->_tmp35_);
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_list = _data_->_tmp36_;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp37_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp37_ = _data_->_file_child_list;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp38_ = 0;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp38_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp37_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp39_ = 0;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp39_ = _data_->_tmp38_;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_size = _data_->_tmp39_;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_index = -1;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp40_ = 0;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp40_ = _data_->_file_child_index;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_file_child_index = _data_->_tmp40_ + 1;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp41_ = 0;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp41_ = _data_->_file_child_index;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp42_ = 0;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp42_ = _data_->_file_child_size;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_data_->_tmp41_ < _data_->_tmp42_)) {
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 2354 "DirectoryMonitor.c"
				}
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp43_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp43_ = _data_->_file_child_list;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp44_ = 0;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp44_ = _data_->_file_child_index;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp45_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp45_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_tmp44_);
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->file_child = (GFile*) _data_->_tmp45_;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp46_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp46_ = _data_->self->priv->files;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp47_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp47_ = _data_->file_child;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp48_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp48_ = directory_monitor_file_info_map_get_info (_data_->_tmp46_, _data_->_tmp47_);
#line 667 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->file_info = _data_->_tmp48_;
#line 668 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp49_ = NULL;
#line 668 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp49_ = _data_->file_info;
#line 668 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_data_->_tmp49_ == NULL) {
#line 669 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp50_ = NULL;
#line 669 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp50_ = _data_->file_child;
#line 669 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp51_ = NULL;
#line 669 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp51_ = g_file_get_path (_data_->_tmp50_);
#line 669 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp52_ = NULL;
#line 669 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp52_ = _data_->_tmp51_;
#line 669 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					g_warning ("DirectoryMonitor.vala:669: Unable to retrieve directory-moved info for" \
" %s", _data_->_tmp52_);
#line 669 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_data_->_tmp52_);
#line 671 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->file_info);
#line 671 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->file_child);
#line 671 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					continue;
#line 2412 "DirectoryMonitor.c"
				}
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp53_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp53_ = _data_->file_child;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp54_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp54_ = _data_->new_dir;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp55_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp55_ = _data_->file_child;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp56_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp56_ = g_file_get_basename (_data_->_tmp55_);
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp57_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp57_ = _data_->_tmp56_;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp58_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp58_ = g_file_get_child (_data_->_tmp54_, _data_->_tmp57_);
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp59_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp59_ = _data_->_tmp58_;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp60_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp60_ = _data_->file_info;
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_internal_notify_file_moved (_data_->self, _data_->_tmp53_, _data_->_tmp59_, _data_->_tmp60_);
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->_tmp59_);
#line 674 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_data_->_tmp57_);
#line 677 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_async_internal_notify_directory_moved_co_gsource_func, _data_, NULL);
#line 678 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 2;
#line 678 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 2458 "DirectoryMonitor.c"
				_state_2:
				;
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->file_info);
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->file_child);
#line 2465 "DirectoryMonitor.c"
			}
#line 666 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_file_child_list);
#line 2469 "DirectoryMonitor.c"
		}
	}
#line 684 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp61_ = NULL;
#line 684 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp61_ = _data_->self->priv->files;
#line 684 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp62_ = NULL;
#line 684 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp62_ = _data_->old_dir;
#line 684 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_file_info_map_remove (_data_->_tmp61_, _data_->_tmp62_, NULL);
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp63_ = NULL;
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp63_ = _data_->self->priv->files;
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp64_ = NULL;
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp64_ = _data_->new_dir;
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp65_ = NULL;
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp65_ = _data_->new_dir_info;
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp66_ = FALSE;
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp66_ = directory_monitor_file_info_map_update (_data_->_tmp63_, _data_->_tmp64_, _data_->_tmp65_);
#line 686 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->updated = _data_->_tmp66_;
#line 687 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_data_->updated, "updated");
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp67_ = NULL;
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp67_ = _data_->old_dir;
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp68_ = NULL;
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp68_ = _data_->old_dir_info;
#line 690 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_remove_monitor (_data_->self, _data_->_tmp67_, _data_->_tmp68_);
#line 691 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp69_ = NULL;
#line 691 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp69_ = _data_->new_dir;
#line 691 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp70_ = NULL;
#line 691 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp70_ = _data_->new_dir_info;
#line 691 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_add_monitor (_data_->self, _data_->_tmp69_, _data_->_tmp70_);
#line 693 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp71_ = NULL;
#line 693 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp71_ = _data_->old_dir;
#line 693 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp72_ = NULL;
#line 693 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp72_ = _data_->new_dir;
#line 693 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp73_ = NULL;
#line 693 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp73_ = _data_->new_dir_info;
#line 693 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_moved (_data_->self, _data_->_tmp71_, _data_->_tmp72_, _data_->_tmp73_);
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_children);
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->file_children);
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_state_ == 0) {
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2544 "DirectoryMonitor.c"
	} else {
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2548 "DirectoryMonitor.c"
	}
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 644 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return FALSE;
#line 2554 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFileInfo* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_dir));
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_dir));
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_dir_info));
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = old_dir;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = new_dir;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = _tmp4_;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = g_strdup_printf ("directory moved: %s -> %s", _tmp2_, _tmp5_);
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = _tmp6_;
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp7_);
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp7_);
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp5_);
#line 697 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 698 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = old_dir;
#line 698 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = new_dir;
#line 698 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = new_dir_info;
#line 698 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-moved", _tmp8_, _tmp9_, _tmp10_);
#line 700 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = old_dir;
#line 700 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = self->priv->root;
#line 700 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = g_file_equal (_tmp11_, _tmp12_);
#line 700 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp13_) {
#line 2619 "DirectoryMonitor.c"
		GFile* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		GFileInfo* _tmp16_ = NULL;
#line 701 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = old_dir;
#line 701 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = new_dir;
#line 701 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp16_ = new_dir_info;
#line 701 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_root_moved (self, _tmp14_, _tmp15_, _tmp16_);
#line 2631 "DirectoryMonitor.c"
	}
}


void directory_monitor_notify_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info) {
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 696 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_moved (self, old_dir, new_dir, new_dir_info);
#line 2641 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_altered (DirectoryMonitor* self, GFile* dir) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 704 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 705 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 705 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 705 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 705 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory altered: %s", _tmp2_);
#line 705 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 705 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 705 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 705 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 706 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 706 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-altered", _tmp5_);
#line 2674 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_altered (DirectoryMonitor* self, GFile* dir) {
#line 704 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 704 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_altered (self, dir);
#line 2683 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	gboolean updated = FALSE;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	GFileInfo* _tmp5_ = NULL;
#line 709 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 709 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 709 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 710 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 710 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 710 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 710 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_update (_tmp0_, _tmp1_, _tmp2_);
#line 710 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	updated = _tmp3_;
#line 711 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (updated, "updated");
#line 713 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = dir;
#line 713 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = info;
#line 713 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_alteration_completed (self, _tmp4_, _tmp5_);
#line 2719 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileInfo* _tmp6_ = NULL;
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory alteration completed: %s", _tmp2_);
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 717 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 718 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 718 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = info;
#line 718 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-alteration-completed", _tmp5_, _tmp6_);
#line 2757 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 716 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_alteration_completed (self, dir, info);
#line 2766 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_attributes_altered (DirectoryMonitor* self, GFile* dir) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory attributes altered: %s", _tmp2_);
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 722 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 723 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-attributes-altered", _tmp5_);
#line 2799 "DirectoryMonitor.c"
}


void directory_monitor_notify_directory_attributes_altered (DirectoryMonitor* self, GFile* dir) {
#line 721 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 721 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_attributes_altered (self, dir);
#line 2808 "DirectoryMonitor.c"
}


static void directory_monitor_internal_notify_directory_deleted (DirectoryMonitor* self, GFile* dir) {
	GFileInfo* info = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
#line 726 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 726 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 727 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 727 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 727 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_get_info (_tmp0_, _tmp1_);
#line 727 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	info = _tmp2_;
#line 728 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (info != NULL, "info != null");
#line 731 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = dir;
#line 731 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_remove_monitor (self, _tmp3_, info);
#line 733 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = dir;
#line 733 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_notify_directory_deleted (self, _tmp4_, FALSE, NULL, NULL);
#line 726 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (info);
#line 2843 "DirectoryMonitor.c"
}


static void directory_monitor_async_notify_directory_deleted_data_free (gpointer _data) {
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
	_data_ = _data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_slice_free (DirectoryMonitorAsyncNotifyDirectoryDeletedData, _data_);
#line 2856 "DirectoryMonitor.c"
}


static void directory_monitor_async_notify_directory_deleted (DirectoryMonitor* self, GFile* dir, gboolean already_removed, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
	DirectoryMonitor* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_slice_new0 (DirectoryMonitorAsyncNotifyDirectoryDeletedData);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, directory_monitor_async_notify_directory_deleted);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, directory_monitor_async_notify_directory_deleted_data_free);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->self = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = already_removed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->already_removed = _tmp3_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_notify_directory_deleted_co (_data_);
#line 2890 "DirectoryMonitor.c"
}


static void directory_monitor_async_notify_directory_deleted_finish (DirectoryMonitor* self, GAsyncResult* _res_) {
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 2898 "DirectoryMonitor.c"
}


static void directory_monitor_async_notify_directory_deleted_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_;
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = _user_data_;
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_source_object_ = source_object;
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_res_ = _res_;
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_async_notify_directory_deleted_co (_data_);
#line 2912 "DirectoryMonitor.c"
}


static gboolean _directory_monitor_async_notify_directory_deleted_co_gsource_func (gpointer self) {
	gboolean result;
	result = directory_monitor_async_notify_directory_deleted_co (self);
#line 765 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 2921 "DirectoryMonitor.c"
}


static gboolean directory_monitor_async_notify_directory_deleted_co (DirectoryMonitorAsyncNotifyDirectoryDeletedData* _data_) {
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_data_->_state_) {
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 0:
#line 2930 "DirectoryMonitor.c"
		goto _state_0;
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 1:
#line 2934 "DirectoryMonitor.c"
		goto _state_1;
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 2:
#line 2938 "DirectoryMonitor.c"
		goto _state_2;
		default:
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_assert_not_reached ();
#line 2943 "DirectoryMonitor.c"
	}
	_state_0:
#line 744 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = NULL;
#line 744 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 744 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->file_children = _data_->_tmp0_;
#line 745 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = NULL;
#line 745 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_equal_gee_equal_data_func, NULL, NULL);
#line 745 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir_children = _data_->_tmp1_;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = NULL;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = _data_->self->priv->files;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = NULL;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = _data_->dir;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp4_ = NULL;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp4_ = _data_->file_children;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp5_ = NULL;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp5_ = _data_->dir_children;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp6_ = 0;
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp6_ = directory_monitor_file_info_map_get_children (_data_->_tmp2_, _data_->_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 746 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->count = _data_->_tmp6_;
#line 747 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp7_ = 0;
#line 747 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp7_ = _data_->count;
#line 747 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp7_ > 0) {
#line 2986 "DirectoryMonitor.c"
		{
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = _data_->dir_children;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_list = _data_->_tmp9_;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = _data_->_dir_child_list;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = 0;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = 0;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = _data_->_tmp11_;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_size = _data_->_tmp12_;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_dir_child_index = -1;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp13_ = 0;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp13_ = _data_->_dir_child_index;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_dir_child_index = _data_->_tmp13_ + 1;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp14_ = 0;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp14_ = _data_->_dir_child_index;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp15_ = 0;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp15_ = _data_->_dir_child_size;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_data_->_tmp14_ < _data_->_tmp15_)) {
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 3034 "DirectoryMonitor.c"
				}
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp16_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp16_ = _data_->_dir_child_list;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp17_ = 0;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp17_ = _data_->_dir_child_index;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp18_ = NULL;
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp18_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_tmp17_);
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->dir_child = (GFile*) _data_->_tmp18_;
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp19_ = NULL;
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp19_ = _data_->dir_child;
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 1;
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_async_notify_directory_deleted (_data_->self, _data_->_tmp19_, FALSE, directory_monitor_async_notify_directory_deleted_ready, _data_);
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 3060 "DirectoryMonitor.c"
				_state_1:
#line 756 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_async_notify_directory_deleted_finish (_data_->self, _data_->_res_);
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->dir_child);
#line 3066 "DirectoryMonitor.c"
			}
#line 755 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_dir_child_list);
#line 3070 "DirectoryMonitor.c"
		}
		{
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp20_ = NULL;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp20_ = _data_->file_children;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp21_ = NULL;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp21_ = _g_object_ref0 (_data_->_tmp20_);
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_list = _data_->_tmp21_;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp22_ = NULL;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp22_ = _data_->_file_child_list;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp23_ = 0;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp23_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp24_ = 0;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp24_ = _data_->_tmp23_;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_size = _data_->_tmp24_;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_file_child_index = -1;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp25_ = 0;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp25_ = _data_->_file_child_index;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_file_child_index = _data_->_tmp25_ + 1;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp26_ = 0;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp26_ = _data_->_file_child_index;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp27_ = 0;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp27_ = _data_->_file_child_size;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_data_->_tmp26_ < _data_->_tmp27_)) {
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 3119 "DirectoryMonitor.c"
				}
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp28_ = NULL;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp28_ = _data_->_file_child_list;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp29_ = 0;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp29_ = _data_->_file_child_index;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp30_ = NULL;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp30_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp28_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _data_->_tmp29_);
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->file_child = (GFile*) _data_->_tmp30_;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp31_ = NULL;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp31_ = _data_->self->priv->files;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp32_ = NULL;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp32_ = _data_->file_child;
#line 761 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_file_info_map_remove (_data_->_tmp31_, _data_->_tmp32_, NULL);
#line 763 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp33_ = NULL;
#line 763 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp33_ = _data_->file_child;
#line 763 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_notify_file_deleted (_data_->self, _data_->_tmp33_);
#line 765 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_async_notify_directory_deleted_co_gsource_func, _data_, NULL);
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 2;
#line 766 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 3157 "DirectoryMonitor.c"
				_state_2:
				;
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->file_child);
#line 3162 "DirectoryMonitor.c"
			}
#line 760 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_file_child_list);
#line 3166 "DirectoryMonitor.c"
		}
	}
#line 770 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp34_ = FALSE;
#line 770 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp34_ = _data_->already_removed;
#line 770 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_data_->_tmp34_) {
#line 771 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp35_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp35_ = _data_->self->priv->files;
#line 771 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp36_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp36_ = _data_->dir;
#line 771 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_remove (_data_->_tmp35_, _data_->_tmp36_, NULL);
#line 3185 "DirectoryMonitor.c"
	}
#line 773 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp37_ = NULL;
#line 773 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp37_ = _data_->dir;
#line 773 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_deleted (_data_->self, _data_->_tmp37_);
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_children);
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->file_children);
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_state_ == 0) {
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3201 "DirectoryMonitor.c"
	} else {
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 3205 "DirectoryMonitor.c"
	}
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 736 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return FALSE;
#line 3211 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_directory_deleted (DirectoryMonitor* self, GFile* dir) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 776 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = dir;
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("directory deleted: %s", _tmp2_);
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 777 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 778 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = dir;
#line 778 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "directory-deleted", _tmp5_);
#line 780 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = dir;
#line 780 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = self->priv->root;
#line 780 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = g_file_equal (_tmp6_, _tmp7_);
#line 780 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp8_) {
#line 3255 "DirectoryMonitor.c"
		GFile* _tmp9_ = NULL;
#line 781 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = dir;
#line 781 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_root_deleted (self, _tmp9_);
#line 3261 "DirectoryMonitor.c"
	}
}


void directory_monitor_notify_directory_deleted (DirectoryMonitor* self, GFile* dir) {
#line 776 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 776 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_directory_deleted (self, dir);
#line 3271 "DirectoryMonitor.c"
}


static void directory_monitor_real_notify_closed (DirectoryMonitor* self) {
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 785 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->root;
#line 785 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 785 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 785 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = g_strdup_printf ("monitoring of %s closed", _tmp2_);
#line 785 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _tmp3_;
#line 785 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp4_);
#line 785 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp4_);
#line 785 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp2_);
#line 786 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_emit_by_name (self, "closed");
#line 3299 "DirectoryMonitor.c"
}


void directory_monitor_notify_closed (DirectoryMonitor* self) {
#line 784 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 784 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->notify_closed (self);
#line 3308 "DirectoryMonitor.c"
}


GFile* directory_monitor_get_root (DirectoryMonitor* self) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 789 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
#line 790 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->root;
#line 790 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 790 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp1_;
#line 790 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 3326 "DirectoryMonitor.c"
}


gboolean directory_monitor_is_in_root (DirectoryMonitor* self, GFile* file) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 793 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 793 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 794 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 794 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->root;
#line 794 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
#line 794 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp2_;
#line 794 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 3349 "DirectoryMonitor.c"
}


gboolean directory_monitor_has_started (DirectoryMonitor* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 797 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 798 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->started;
#line 798 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp0_;
#line 798 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 3364 "DirectoryMonitor.c"
}


void directory_monitor_start_discovery (DirectoryMonitor* self) {
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
#line 801 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 802 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->started;
#line 802 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (!_tmp0_, "!started");
#line 804 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->has_discovery_started = TRUE;
#line 805 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->started = TRUE;
#line 807 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_discovery_started (self);
#line 810 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->outstanding_exploration_dirs = 1;
#line 811 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->root;
#line 811 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_explore_async (self, _tmp1_, NULL, TRUE, NULL, NULL);
#line 3389 "DirectoryMonitor.c"
}


static void directory_monitor_real_close (DirectoryMonitor* self) {
	GCancellable* _tmp0_ = NULL;
	GeeHashMap* _tmp12_ = NULL;
#line 818 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->cancellable;
#line 818 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_cancellable_cancel (_tmp0_);
#line 3400 "DirectoryMonitor.c"
	{
		GeeIterator* _monitor_it = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = self->priv->monitors;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = _tmp2_;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = _tmp3_;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = _tmp5_;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp4_);
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_monitor_it = _tmp6_;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 3427 "DirectoryMonitor.c"
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			GFileMonitor* monitor = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			GFileMonitor* _tmp11_ = NULL;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp7_ = _monitor_it;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp8_) {
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 3442 "DirectoryMonitor.c"
			}
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp9_ = _monitor_it;
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			monitor = (GFileMonitor*) _tmp10_;
#line 822 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = monitor;
#line 822 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_cancel_monitor (self, _tmp11_);
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (monitor);
#line 3456 "DirectoryMonitor.c"
		}
#line 821 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_monitor_it);
#line 3460 "DirectoryMonitor.c"
	}
#line 824 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = self->priv->monitors;
#line 824 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 826 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_closed (self);
#line 3468 "DirectoryMonitor.c"
}


void directory_monitor_close (DirectoryMonitor* self) {
#line 816 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 816 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	DIRECTORY_MONITOR_GET_CLASS (self)->close (self);
#line 3477 "DirectoryMonitor.c"
}


static DirectoryMonitorFType directory_monitor_get_ftype (GFileInfo* info) {
	DirectoryMonitorFType result = 0;
	GFileType file_type = 0;
	GFileInfo* _tmp0_ = NULL;
	GFileType _tmp1_ = 0;
	GFileType _tmp2_ = 0;
#line 829 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), 0);
#line 830 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = info;
#line 830 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_info_get_file_type (_tmp0_);
#line 830 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	file_type = _tmp1_;
#line 831 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = file_type;
#line 831 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_tmp2_) {
#line 831 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_TYPE_REGULAR:
#line 3501 "DirectoryMonitor.c"
		{
#line 833 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_FTYPE_FILE;
#line 833 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 3507 "DirectoryMonitor.c"
		}
#line 831 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_TYPE_DIRECTORY:
#line 3511 "DirectoryMonitor.c"
		{
#line 836 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_FTYPE_DIRECTORY;
#line 836 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 3517 "DirectoryMonitor.c"
		}
		default:
		{
			GFileType _tmp3_ = 0;
			GEnumValue* _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 839 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp3_ = file_type;
#line 839 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp4_ = g_enum_get_value (g_type_class_ref (g_file_type_get_type ()), _tmp3_);
#line 839 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp5_ = g_strdup_printf ("query_ftype: Unknown file type %s", (_tmp4_ != NULL) ? _tmp4_->value_name : NULL);
#line 839 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = _tmp5_;
#line 839 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_mdbg (_tmp6_);
#line 839 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp6_);
#line 840 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_FTYPE_UNSUPPORTED;
#line 840 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 3541 "DirectoryMonitor.c"
		}
	}
}


static void directory_monitor_explore_async_data_free (gpointer _data) {
	DirectoryMonitorExploreAsyncData* _data_;
	_data_ = _data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_slice_free (DirectoryMonitorExploreAsyncData, _data_);
#line 3558 "DirectoryMonitor.c"
}


static void directory_monitor_explore_async (DirectoryMonitor* self, GFile* dir, GFileInfo* dir_info, gboolean in_discovery, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DirectoryMonitorExploreAsyncData* _data_;
	DirectoryMonitor* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_slice_new0 (DirectoryMonitorExploreAsyncData);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, directory_monitor_explore_async);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, directory_monitor_explore_async_data_free);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->self = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = dir;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = dir_info;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_info);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir_info = _tmp4_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = in_discovery;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->in_discovery = _tmp5_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_explore_async_co (_data_);
#line 3602 "DirectoryMonitor.c"
}


static void directory_monitor_explore_finish (DirectoryMonitor* self, GAsyncResult* _res_) {
	DirectoryMonitorExploreAsyncData* _data_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 3610 "DirectoryMonitor.c"
}


static void directory_monitor_explore_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DirectoryMonitorExploreAsyncData* _data_;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = _user_data_;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_source_object_ = source_object;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_res_ = _res_;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_explore_async_co (_data_);
#line 3624 "DirectoryMonitor.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 911 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 3631 "DirectoryMonitor.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 911 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 911 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_list_free (self);
#line 3640 "DirectoryMonitor.c"
}


static guint _file_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = file_hash ((GFile*) v);
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 3649 "DirectoryMonitor.c"
}


static gboolean directory_monitor_explore_async_co (DirectoryMonitorExploreAsyncData* _data_) {
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_data_->_state_) {
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 0:
#line 3658 "DirectoryMonitor.c"
		goto _state_0;
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 1:
#line 3662 "DirectoryMonitor.c"
		goto _state_1;
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 2:
#line 3666 "DirectoryMonitor.c"
		goto _state_2;
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 3:
#line 3670 "DirectoryMonitor.c"
		goto _state_3;
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 4:
#line 3674 "DirectoryMonitor.c"
		goto _state_4;
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 5:
#line 3678 "DirectoryMonitor.c"
		goto _state_5;
		default:
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_assert_not_reached ();
#line 3683 "DirectoryMonitor.c"
	}
	_state_0:
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = _data_->self->priv->files;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = _data_->dir;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = NULL;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp2_ = _data_->dir_info;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = FALSE;
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp3_ = directory_monitor_file_info_map_contains (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
#line 845 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp3_) {
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp4_ = NULL;
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp4_ = _data_->dir;
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp5_ = NULL;
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp5_ = g_file_get_path (_data_->_tmp4_);
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp6_ = NULL;
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:846: Directory loop detected at %s, not explorin" \
"g", _data_->_tmp6_);
#line 846 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp6_);
#line 848 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp7_ = FALSE;
#line 848 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp7_ = _data_->in_discovery;
#line 848 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp7_);
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3730 "DirectoryMonitor.c"
		} else {
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3734 "DirectoryMonitor.c"
		}
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 850 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 3740 "DirectoryMonitor.c"
	}
#line 854 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp8_ = NULL;
#line 854 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp8_ = _data_->dir_info;
#line 854 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp9_ = NULL;
#line 854 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
#line 854 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->local_dir_info = _data_->_tmp9_;
#line 855 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp10_ = NULL;
#line 855 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp10_ = _data_->local_dir_info;
#line 855 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp10_ == NULL) {
#line 3758 "DirectoryMonitor.c"
		{
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = _data_->dir;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp13_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp13_ = _data_->self->priv->cancellable;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_state_ = 1;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_file_query_info_async (_data_->_tmp12_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_DIR_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp13_, directory_monitor_explore_async_ready, _data_);
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return FALSE;
#line 3774 "DirectoryMonitor.c"
			_state_1:
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp14_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp14_ = g_file_query_info_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = _data_->_tmp14_;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 3784 "DirectoryMonitor.c"
				goto __catch480_g_error;
			}
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp15_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp15_ = _data_->_tmp11_;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->local_dir_info);
#line 857 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->local_dir_info = _data_->_tmp15_;
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp11_);
#line 3799 "DirectoryMonitor.c"
		}
		goto __finally480;
		__catch480_g_error:
		{
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->err = _data_->_inner_error_;
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_inner_error_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp16_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp16_ = _data_->dir;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp17_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp17_ = g_file_get_path (_data_->_tmp16_);
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp18_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp18_ = _data_->_tmp17_;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp19_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp19_ = _data_->err;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp20_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp20_ = _data_->_tmp19_->message;
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_warning ("DirectoryMonitor.vala:860: Unable to retrieve info on %s: %s", _data_->_tmp18_, _data_->_tmp20_);
#line 860 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_data_->_tmp18_);
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp21_ = FALSE;
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp21_ = _data_->in_discovery;
#line 862 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp21_);
#line 864 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_error_free0 (_data_->err);
#line 864 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->local_dir_info);
#line 864 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_data_->_state_ == 0) {
#line 864 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3846 "DirectoryMonitor.c"
			} else {
#line 864 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 3850 "DirectoryMonitor.c"
			}
#line 864 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_object_unref (_data_->_async_result);
#line 864 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return FALSE;
#line 3856 "DirectoryMonitor.c"
		}
		__finally480:
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->local_dir_info);
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_clear_error (&_data_->_inner_error_);
#line 856 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return FALSE;
#line 3869 "DirectoryMonitor.c"
		}
	}
#line 868 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp22_ = NULL;
#line 868 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp22_ = _data_->local_dir_info;
#line 868 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp23_ = FALSE;
#line 868 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp23_ = g_file_info_get_is_hidden (_data_->_tmp22_);
#line 868 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp23_) {
#line 869 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp24_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp24_ = _data_->dir;
#line 869 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp25_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp25_ = g_file_get_path (_data_->_tmp24_);
#line 869 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp26_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp26_ = _data_->_tmp25_;
#line 869 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:869: Ignoring hidden directory %s", _data_->_tmp26_);
#line 869 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp26_);
#line 871 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp27_ = FALSE;
#line 871 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp27_ = _data_->in_discovery;
#line 871 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp27_);
#line 873 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 873 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 873 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3910 "DirectoryMonitor.c"
		} else {
#line 873 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3914 "DirectoryMonitor.c"
		}
#line 873 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 873 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 3920 "DirectoryMonitor.c"
	}
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp28_ = NULL;
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp28_ = _data_->local_dir_info;
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp29_ = NULL;
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp29_ = get_file_info_id (_data_->_tmp28_);
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp30_ = NULL;
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp30_ = _data_->_tmp29_;
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp31_ = FALSE;
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp31_ = _data_->_tmp30_ == NULL;
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_data_->_tmp30_);
#line 879 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp31_) {
#line 880 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp32_ = NULL;
#line 880 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp32_ = _data_->dir;
#line 880 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp33_ = NULL;
#line 880 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp33_ = g_file_get_path (_data_->_tmp32_);
#line 880 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp34_ = NULL;
#line 880 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp34_ = _data_->_tmp33_;
#line 880 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:880: Unable to retrieve file ID on %s: skipping", _data_->_tmp34_);
#line 880 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp34_);
#line 882 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp35_ = FALSE;
#line 882 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp35_ = _data_->in_discovery;
#line 882 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp35_);
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 3970 "DirectoryMonitor.c"
		} else {
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 3974 "DirectoryMonitor.c"
		}
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 884 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 3980 "DirectoryMonitor.c"
	}
#line 888 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp36_ = NULL;
#line 888 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp36_ = _data_->local_dir_info;
#line 888 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp37_ = 0;
#line 888 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp37_ = g_file_info_get_file_type (_data_->_tmp36_);
#line 888 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp37_ != G_FILE_TYPE_DIRECTORY) {
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp38_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp38_ = _ ("Unable to monitor %s: Not a directory (%s)");
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp39_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp39_ = _data_->dir;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp40_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp40_ = g_file_get_path (_data_->_tmp39_);
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp41_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp41_ = _data_->_tmp40_;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp42_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp42_ = _data_->local_dir_info;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp43_ = 0;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp43_ = g_file_info_get_file_type (_data_->_tmp42_);
#line 890 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		memset (&_data_->_tmp44_, 0, sizeof (GEnumValue*));
#line 890 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp44_ = g_enum_get_value (g_type_class_ref (g_file_type_get_type ()), _data_->_tmp43_);
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp45_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp45_ = g_strdup_printf (_data_->_tmp38_, _data_->_tmp41_, (_data_->_tmp44_ != NULL) ? _data_->_tmp44_->value_name : NULL);
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp46_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp46_ = _data_->_tmp45_;
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_discovery_failed (_data_->self, _data_->_tmp46_);
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp46_);
#line 889 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp41_);
#line 892 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp47_ = FALSE;
#line 892 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp47_ = _data_->in_discovery;
#line 892 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp47_);
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4046 "DirectoryMonitor.c"
		} else {
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4050 "DirectoryMonitor.c"
		}
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 894 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4056 "DirectoryMonitor.c"
	}
#line 901 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->dir_map = NULL;
#line 902 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->file_map = NULL;
#line 4062 "DirectoryMonitor.c"
	{
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp48_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp48_ = _data_->dir;
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp49_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp49_ = _data_->self->priv->cancellable;
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_state_ = 2;
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_file_enumerate_children_async (_data_->_tmp48_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp49_, directory_monitor_explore_async_ready, _data_);
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4078 "DirectoryMonitor.c"
		_state_2:
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp50_ = NULL;
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp50_ = g_file_enumerate_children_finish (_data_->_tmp48_, _data_->_res_, &_data_->_inner_error_);
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->enumerator = _data_->_tmp50_;
#line 905 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 4088 "DirectoryMonitor.c"
			goto __catch481_g_error;
		}
		{
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp51_ = TRUE;
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!_data_->_tmp51_) {
#line 4098 "DirectoryMonitor.c"
				}
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp51_ = FALSE;
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp52_ = NULL;
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp52_ = _data_->enumerator;
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp53_ = NULL;
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp53_ = _data_->self->priv->cancellable;
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_state_ = 3;
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_file_enumerator_next_files_async (_data_->_tmp52_, 10, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _data_->_tmp53_, directory_monitor_explore_async_ready, _data_);
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return FALSE;
#line 4116 "DirectoryMonitor.c"
				_state_3:
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp54_ = NULL;
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp54_ = g_file_enumerator_next_files_finish (_data_->_tmp52_, _data_->_res_, &_data_->_inner_error_);
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->infos = _data_->_tmp54_;
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 908 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->enumerator);
#line 4128 "DirectoryMonitor.c"
					goto __catch481_g_error;
				}
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp55_ = NULL;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp55_ = _data_->infos;
#line 910 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_data_->_tmp55_ == NULL) {
#line 911 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					__g_list_free__g_object_unref0_0 (_data_->infos);
#line 911 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 4141 "DirectoryMonitor.c"
				}
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp56_ = NULL;
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp56_ = _data_->infos;
#line 4147 "DirectoryMonitor.c"
				{
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->info_collection = _data_->_tmp56_;
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_data_->_tmp57_ = NULL;
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_data_->_tmp57_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_data_->info = _data_->_tmp57_;
#line 4159 "DirectoryMonitor.c"
						{
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp58_ = NULL;
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp58_ = _data_->info;
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp59_ = FALSE;
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp59_ = g_file_info_get_is_hidden (_data_->_tmp58_);
#line 915 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							if (_data_->_tmp59_) {
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp60_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp60_ = _data_->dir;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp61_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp61_ = _data_->info;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp62_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp62_ = g_file_info_get_name (_data_->_tmp61_);
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp63_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp63_ = g_file_get_child (_data_->_tmp60_, _data_->_tmp62_);
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp64_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp64_ = _data_->_tmp63_;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp65_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp65_ = g_file_get_path (_data_->_tmp64_);
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp66_ = NULL;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_data_->_tmp66_ = _data_->_tmp65_;
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								g_warning ("DirectoryMonitor.vala:916: Skipping hidden file/directory %s", _data_->_tmp66_);
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_free0 (_data_->_tmp66_);
#line 916 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_object_unref0 (_data_->_tmp64_);
#line 919 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_object_unref0 (_data_->info);
#line 919 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								continue;
#line 4209 "DirectoryMonitor.c"
							}
#line 923 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp67_ = NULL;
#line 923 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp67_ = _data_->info;
#line 923 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp68_ = FALSE;
#line 923 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp68_ = directory_monitor_is_file_symlink_supported (_data_->_tmp67_);
#line 923 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							if (!_data_->_tmp68_) {
#line 924 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								_g_object_unref0 (_data_->info);
#line 924 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								continue;
#line 4225 "DirectoryMonitor.c"
							}
#line 926 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp69_ = NULL;
#line 926 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp69_ = _data_->info;
#line 926 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp70_ = 0;
#line 926 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_data_->_tmp70_ = g_file_info_get_file_type (_data_->_tmp69_);
#line 926 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							switch (_data_->_tmp70_) {
#line 926 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								case G_FILE_TYPE_REGULAR:
#line 4239 "DirectoryMonitor.c"
								{
#line 928 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp71_ = NULL;
#line 928 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp71_ = _data_->file_map;
#line 928 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									if (_data_->_tmp71_ == NULL) {
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->_tmp72_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->_tmp72_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_g_object_unref0 (_data_->file_map);
#line 929 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->file_map = _data_->_tmp72_;
#line 4255 "DirectoryMonitor.c"
									}
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp73_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp73_ = _data_->file_map;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp74_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp74_ = _data_->dir;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp75_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp75_ = _data_->info;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp76_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp76_ = g_file_info_get_name (_data_->_tmp75_);
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp77_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp77_ = g_file_get_child (_data_->_tmp74_, _data_->_tmp76_);
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp78_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp78_ = _data_->_tmp77_;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp79_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp79_ = _data_->info;
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp73_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp78_, _data_->_tmp79_);
#line 931 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_g_object_unref0 (_data_->_tmp78_);
#line 932 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									break;
#line 4291 "DirectoryMonitor.c"
								}
#line 926 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
								case G_FILE_TYPE_DIRECTORY:
#line 4295 "DirectoryMonitor.c"
								{
#line 935 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp80_ = NULL;
#line 935 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp80_ = _data_->dir_map;
#line 935 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									if (_data_->_tmp80_ == NULL) {
#line 936 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->_tmp81_ = NULL;
#line 936 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->_tmp81_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 936 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_g_object_unref0 (_data_->dir_map);
#line 936 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
										_data_->dir_map = _data_->_tmp81_;
#line 4311 "DirectoryMonitor.c"
									}
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp82_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp82_ = _data_->dir_map;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp83_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp83_ = _data_->dir;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp84_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp84_ = _data_->info;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp85_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp85_ = g_file_info_get_name (_data_->_tmp84_);
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp86_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp86_ = g_file_get_child (_data_->_tmp83_, _data_->_tmp85_);
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp87_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp87_ = _data_->_tmp86_;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp88_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_data_->_tmp88_ = _data_->info;
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp82_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp87_, _data_->_tmp88_);
#line 938 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									_g_object_unref0 (_data_->_tmp87_);
#line 939 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									break;
#line 4347 "DirectoryMonitor.c"
								}
								default:
								{
#line 943 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
									break;
#line 4353 "DirectoryMonitor.c"
								}
							}
#line 913 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
							_g_object_unref0 (_data_->info);
#line 4358 "DirectoryMonitor.c"
						}
					}
				}
#line 907 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				__g_list_free__g_object_unref0_0 (_data_->infos);
#line 4364 "DirectoryMonitor.c"
			}
		}
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->enumerator);
#line 4369 "DirectoryMonitor.c"
	}
	goto __finally481;
	__catch481_g_error:
	{
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->err2 = _data_->_inner_error_;
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_inner_error_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp89_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp89_ = _data_->dir;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp90_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp90_ = g_file_get_path (_data_->_tmp89_);
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp91_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp91_ = _data_->_tmp90_;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp92_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp92_ = _data_->err2;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp93_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp93_ = _data_->_tmp92_->message;
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:948: Aborted directory traversal of %s: %s", _data_->_tmp91_, _data_->_tmp93_);
#line 948 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_data_->_tmp91_);
#line 950 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp94_ = FALSE;
#line 950 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp94_ = _data_->in_discovery;
#line 950 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp94_);
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (_data_->err2);
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->file_map);
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->dir_map);
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_state_ == 0) {
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4420 "DirectoryMonitor.c"
		} else {
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 4424 "DirectoryMonitor.c"
		}
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_object_unref (_data_->_async_result);
#line 952 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4430 "DirectoryMonitor.c"
	}
	__finally481:
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->file_map);
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->dir_map);
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_data_->local_dir_info);
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_clear_error (&_data_->_inner_error_);
#line 904 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4447 "DirectoryMonitor.c"
	}
#line 956 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp95_ = FALSE;
#line 956 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp95_ = _data_->in_discovery;
#line 956 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp95_) {
#line 957 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp96_ = NULL;
#line 957 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp96_ = _data_->dir;
#line 957 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp97_ = NULL;
#line 957 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp97_ = _data_->local_dir_info;
#line 957 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_directory_discovered (_data_->self, _data_->_tmp96_, _data_->_tmp97_);
#line 4465 "DirectoryMonitor.c"
	} else {
#line 959 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp98_ = NULL;
#line 959 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp98_ = _data_->dir;
#line 959 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp99_ = NULL;
#line 959 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp99_ = _data_->local_dir_info;
#line 959 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_internal_notify_directory_created (_data_->self, _data_->_tmp98_, _data_->_tmp99_);
#line 4477 "DirectoryMonitor.c"
	}
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp100_ = NULL;
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp100_ = _data_->dir;
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp101_ = NULL;
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp101_ = _data_->local_dir_info;
#line 963 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_add_monitor (_data_->self, _data_->_tmp100_, _data_->_tmp101_);
#line 966 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp102_ = NULL;
#line 966 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp102_ = _data_->file_map;
#line 966 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp102_ != NULL) {
#line 967 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp103_ = NULL;
#line 967 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp103_ = _data_->file_map;
#line 967 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp104_ = FALSE;
#line 967 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp104_ = _data_->in_discovery;
#line 967 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_state_ = 4;
#line 967 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_directory_files (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp103_, GEE_TYPE_MAP, GeeMap), _data_->_tmp104_, directory_monitor_explore_async_ready, _data_);
#line 967 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4509 "DirectoryMonitor.c"
		_state_4:
#line 967 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_directory_files_finish (_data_->self, _data_->_res_);
#line 4513 "DirectoryMonitor.c"
	}
#line 970 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp106_ = FALSE;
#line 970 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp106_ = _data_->self->priv->recurse;
#line 970 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp106_) {
#line 970 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp107_ = NULL;
#line 970 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp107_ = _data_->dir_map;
#line 970 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp105_ = _data_->_tmp107_ != NULL;
#line 4527 "DirectoryMonitor.c"
	} else {
#line 970 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp105_ = FALSE;
#line 4531 "DirectoryMonitor.c"
	}
#line 970 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_tmp105_) {
#line 4535 "DirectoryMonitor.c"
		{
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp108_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp108_ = _data_->dir_map;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp109_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp109_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp108_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp110_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp110_ = _data_->_tmp109_;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp111_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp111_ = _data_->_tmp110_;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp112_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp112_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp111_, GEE_TYPE_ITERABLE, GeeIterable));
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp113_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp113_ = _data_->_tmp112_;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp111_);
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_subdir_it = _data_->_tmp113_;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp114_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp114_ = _data_->_subdir_it;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp115_ = FALSE;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp115_ = gee_iterator_next (_data_->_tmp114_);
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!_data_->_tmp115_) {
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 4579 "DirectoryMonitor.c"
				}
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp116_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp116_ = _data_->_subdir_it;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp117_ = NULL;
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp117_ = gee_iterator_get (_data_->_tmp116_);
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->subdir = (GFile*) _data_->_tmp117_;
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp118_ = 0;
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp118_ = _data_->self->priv->outstanding_exploration_dirs;
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->self->priv->outstanding_exploration_dirs = _data_->_tmp118_ + 1;
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp119_ = 0;
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_data_->_tmp119_ = _data_->self->priv->outstanding_exploration_dirs;
#line 972 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_data_->_tmp119_ > DIRECTORY_MONITOR_MAX_EXPLORATION_DIRS) {
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp120_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp120_ = _data_->subdir;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp121_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp121_ = _data_->dir_map;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp122_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp122_ = _data_->subdir;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp123_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp123_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp121_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp122_);
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp124_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp124_ = (GFileInfo*) _data_->_tmp123_;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp125_ = FALSE;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp125_ = _data_->in_discovery;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_state_ = 5;
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_explore_async (_data_->self, _data_->_tmp120_, _data_->_tmp124_, _data_->_tmp125_, directory_monitor_explore_async_ready, _data_);
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					return FALSE;
#line 4633 "DirectoryMonitor.c"
					_state_5:
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_explore_finish (_data_->self, _data_->_res_);
#line 973 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->_tmp124_);
#line 4639 "DirectoryMonitor.c"
				} else {
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp126_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp126_ = _data_->subdir;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp127_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp127_ = _data_->dir_map;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp128_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp128_ = _data_->subdir;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp129_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp129_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp127_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _data_->_tmp128_);
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp130_ = NULL;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp130_ = (GFileInfo*) _data_->_tmp129_;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp131_ = FALSE;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_data_->_tmp131_ = _data_->in_discovery;
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_explore_async (_data_->self, _data_->_tmp126_, _data_->_tmp130_, _data_->_tmp131_, NULL, NULL);
#line 975 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_data_->_tmp130_);
#line 4669 "DirectoryMonitor.c"
				}
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_data_->subdir);
#line 4673 "DirectoryMonitor.c"
			}
#line 971 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_subdir_it);
#line 4677 "DirectoryMonitor.c"
		}
	}
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp132_ = FALSE;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp132_ = _data_->in_discovery;
#line 979 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_explore_directory_completed (_data_->self, _data_->_tmp132_);
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->file_map);
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->dir_map);
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->local_dir_info);
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_state_ == 0) {
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4696 "DirectoryMonitor.c"
	} else {
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4700 "DirectoryMonitor.c"
	}
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 844 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return FALSE;
#line 4706 "DirectoryMonitor.c"
}


static void directory_monitor_notify_directory_files_data_free (gpointer _data) {
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
	_data_ = _data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->map);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_slice_free (DirectoryMonitorNotifyDirectoryFilesData, _data_);
#line 4719 "DirectoryMonitor.c"
}


static void directory_monitor_notify_directory_files (DirectoryMonitor* self, GeeMap* map, gboolean in_discovery, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
	DirectoryMonitor* _tmp0_ = NULL;
	GeeMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_slice_new0 (DirectoryMonitorNotifyDirectoryFilesData);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, directory_monitor_notify_directory_files);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, directory_monitor_notify_directory_files_data_free);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->self = _tmp0_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = map;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->map);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->map = _tmp2_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = in_discovery;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->in_discovery = _tmp3_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_notify_directory_files_co (_data_);
#line 4753 "DirectoryMonitor.c"
}


static void directory_monitor_notify_directory_files_finish (DirectoryMonitor* self, GAsyncResult* _res_) {
	DirectoryMonitorNotifyDirectoryFilesData* _data_;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 4761 "DirectoryMonitor.c"
}


static gboolean _directory_monitor_notify_directory_files_co_gsource_func (gpointer self) {
	gboolean result;
	result = directory_monitor_notify_directory_files_co (self);
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 4770 "DirectoryMonitor.c"
}


static gboolean directory_monitor_notify_directory_files_co (DirectoryMonitorNotifyDirectoryFilesData* _data_) {
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_data_->_state_) {
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 0:
#line 4779 "DirectoryMonitor.c"
		goto _state_0;
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case 1:
#line 4783 "DirectoryMonitor.c"
		goto _state_1;
		default:
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_assert_not_reached ();
#line 4788 "DirectoryMonitor.c"
	}
	_state_0:
#line 983 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = NULL;
#line 983 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp0_ = _data_->map;
#line 983 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = NULL;
#line 983 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->_tmp1_ = gee_map_map_iterator (_data_->_tmp0_);
#line 983 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_data_->iter = _data_->_tmp1_;
#line 984 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	while (TRUE) {
#line 984 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp2_ = NULL;
#line 984 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp2_ = _data_->iter;
#line 984 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp3_ = FALSE;
#line 984 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp3_ = gee_map_iterator_next (_data_->_tmp2_);
#line 984 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (!_data_->_tmp3_) {
#line 984 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 4815 "DirectoryMonitor.c"
		}
#line 985 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp4_ = FALSE;
#line 985 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_tmp4_ = _data_->in_discovery;
#line 985 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_data_->_tmp4_) {
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp5_ = NULL;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp5_ = _data_->iter;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp6_ = NULL;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp6_ = gee_map_iterator_get_key (_data_->_tmp5_);
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp7_ = NULL;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp7_ = (GFile*) _data_->_tmp6_;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = NULL;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp8_ = _data_->iter;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = NULL;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp9_ = gee_map_iterator_get_value (_data_->_tmp8_);
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = NULL;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp10_ = (GFileInfo*) _data_->_tmp9_;
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_internal_notify_file_discovered (_data_->self, _data_->_tmp7_, _data_->_tmp10_);
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp10_);
#line 986 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp7_);
#line 4853 "DirectoryMonitor.c"
		} else {
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp11_ = _data_->iter;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp12_ = gee_map_iterator_get_key (_data_->_tmp11_);
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp13_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp13_ = (GFile*) _data_->_tmp12_;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp14_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp14_ = _data_->iter;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp15_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp15_ = gee_map_iterator_get_value (_data_->_tmp14_);
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp16_ = NULL;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_data_->_tmp16_ = (GFileInfo*) _data_->_tmp15_;
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_internal_notify_file_created (_data_->self, _data_->_tmp13_, _data_->_tmp16_);
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp16_);
#line 988 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_data_->_tmp13_);
#line 4885 "DirectoryMonitor.c"
		}
#line 990 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_idle_add_full (DIRECTORY_MONITOR_DEFAULT_PRIORITY, _directory_monitor_notify_directory_files_co_gsource_func, _data_, NULL);
#line 991 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_data_->_state_ = 1;
#line 991 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return FALSE;
#line 4893 "DirectoryMonitor.c"
		_state_1:
		;
	}
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_data_->iter);
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_data_->_state_ == 0) {
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 4903 "DirectoryMonitor.c"
	} else {
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 4907 "DirectoryMonitor.c"
	}
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_object_unref (_data_->_async_result);
#line 982 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return FALSE;
#line 4913 "DirectoryMonitor.c"
}


static void directory_monitor_explore_directory_completed (DirectoryMonitor* self, gboolean in_discovery) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 997 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 998 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->outstanding_exploration_dirs;
#line 998 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_tmp0_ > 0, "outstanding_exploration_dirs > 0");
#line 999 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->outstanding_exploration_dirs;
#line 999 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->outstanding_exploration_dirs = _tmp1_ - 1;
#line 1001 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = in_discovery;
#line 1001 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp3_) {
#line 4936 "DirectoryMonitor.c"
		gint _tmp4_ = 0;
#line 1001 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = self->priv->outstanding_exploration_dirs;
#line 1001 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = _tmp4_ == 0;
#line 4942 "DirectoryMonitor.c"
	} else {
#line 1001 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = FALSE;
#line 4946 "DirectoryMonitor.c"
	}
#line 1001 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_) {
#line 1002 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_notify_discovery_completed (self);
#line 4952 "DirectoryMonitor.c"
	}
}


static void _directory_monitor_on_monitor_notification_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_on_monitor_notification ((DirectoryMonitor*) self, file, other_file, event_type);
#line 4960 "DirectoryMonitor.c"
}


static gboolean directory_monitor_add_monitor (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* id = NULL;
	DirectoryMonitorFileInfoMap* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GFileMonitor* monitor = NULL;
	GeeHashMap* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GFileMonitor* _tmp21_ = NULL;
	GFileMonitor* _tmp22_ = NULL;
	GFile* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
#line 1008 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 1008 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (dir), FALSE);
#line 1008 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1009 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->monitoring;
#line 1009 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp0_) {
#line 1010 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1010 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5001 "DirectoryMonitor.c"
	}
#line 1012 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->files;
#line 1012 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = dir;
#line 1012 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = info;
#line 1012 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_file_info_map_get_id (_tmp1_, _tmp2_, _tmp3_);
#line 1012 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp4_;
#line 1013 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = id;
#line 1013 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp5_ == NULL) {
#line 1014 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1014 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1014 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5023 "DirectoryMonitor.c"
	}
#line 1017 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = self->priv->monitors;
#line 1017 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = id;
#line 1017 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 1017 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp8_) {
#line 1018 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1018 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1018 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5039 "DirectoryMonitor.c"
	}
#line 1020 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	monitor = NULL;
#line 5043 "DirectoryMonitor.c"
	{
		GFileMonitor* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFileMonitor* _tmp11_ = NULL;
		GFileMonitor* _tmp12_ = NULL;
#line 1022 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = dir;
#line 1022 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = g_file_monitor_directory (_tmp10_, DIRECTORY_MONITOR_FILE_MONITOR_FLAGS, NULL, &_inner_error_);
#line 1022 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp11_;
#line 1022 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5057 "DirectoryMonitor.c"
			goto __catch482_g_error;
		}
#line 1022 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = _tmp9_;
#line 1022 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = NULL;
#line 1022 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (monitor);
#line 1022 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		monitor = _tmp12_;
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp9_);
#line 5070 "DirectoryMonitor.c"
	}
	goto __finally482;
	__catch482_g_error:
	{
		GError* err = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		err = _inner_error_;
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_inner_error_ = NULL;
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp13_ = dir;
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = g_file_get_path (_tmp13_);
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = _tmp14_;
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp16_ = err;
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp17_ = _tmp16_->message;
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:1024: Unable to monitor %s: %s", _tmp15_, _tmp17_);
#line 1024 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp15_);
#line 1026 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1026 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (err);
#line 1026 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (monitor);
#line 1026 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1026 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5109 "DirectoryMonitor.c"
	}
	__finally482:
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5114 "DirectoryMonitor.c"
		gboolean _tmp18_ = FALSE;
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (monitor);
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 1021 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return _tmp18_;
#line 5126 "DirectoryMonitor.c"
	}
#line 1029 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = self->priv->monitors;
#line 1029 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp20_ = id;
#line 1029 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp21_ = monitor;
#line 1029 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp20_, _tmp21_);
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp22_ = monitor;
#line 1030 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_connect_object (_tmp22_, "changed", (GCallback) _directory_monitor_on_monitor_notification_g_file_monitor_changed, self, 0);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp23_ = dir;
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp24_ = g_file_get_path (_tmp23_);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp25_ = _tmp24_;
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp26_ = g_strdup_printf ("Added monitor for %s", _tmp25_);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp27_ = _tmp26_;
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp27_);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp27_);
#line 1032 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp25_);
#line 1034 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 1034 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (monitor);
#line 1034 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 1034 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 5164 "DirectoryMonitor.c"
}


static gboolean directory_monitor_remove_monitor (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* id = NULL;
	DirectoryMonitorFileInfoMap* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GFileMonitor* monitor = NULL;
	GeeHashMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gpointer _tmp8_ = NULL;
	GFileMonitor* _tmp9_ = NULL;
	gboolean removed = FALSE;
	GeeHashMap* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GFileMonitor* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (dir), FALSE);
#line 1038 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1039 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->monitoring;
#line 1039 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp0_) {
#line 1040 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1040 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5207 "DirectoryMonitor.c"
	}
#line 1042 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = self->priv->files;
#line 1042 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = dir;
#line 1042 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = info;
#line 1042 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_file_info_map_get_id (_tmp1_, _tmp2_, _tmp3_);
#line 1042 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp4_;
#line 1043 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = id;
#line 1043 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp5_ == NULL) {
#line 1044 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1044 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1044 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5229 "DirectoryMonitor.c"
	}
#line 1046 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = self->priv->monitors;
#line 1046 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = id;
#line 1046 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp7_);
#line 1046 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	monitor = (GFileMonitor*) _tmp8_;
#line 1047 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = monitor;
#line 1047 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp9_ == NULL) {
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (monitor);
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 1048 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 5251 "DirectoryMonitor.c"
	}
#line 1050 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = self->priv->monitors;
#line 1050 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = id;
#line 1050 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, NULL);
#line 1050 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	removed = _tmp12_;
#line 1051 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = removed;
#line 1051 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_assert (_tmp13_, "removed");
#line 1053 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = monitor;
#line 1053 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_cancel_monitor (self, _tmp14_);
#line 1055 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp15_ = dir;
#line 1055 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = g_file_get_path (_tmp15_);
#line 1055 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp17_ = _tmp16_;
#line 1055 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp18_ = g_strdup_printf ("Removed monitor for %s", _tmp17_);
#line 1055 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = _tmp18_;
#line 1055 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp19_);
#line 1055 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp19_);
#line 1055 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp17_);
#line 1057 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 1057 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (monitor);
#line 1057 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 1057 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 5293 "DirectoryMonitor.c"
}


static void directory_monitor_cancel_monitor (DirectoryMonitor* self, GFileMonitor* monitor) {
	GFileMonitor* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GFileMonitor* _tmp2_ = NULL;
#line 1060 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1060 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_MONITOR (monitor));
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = monitor;
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp1_, NULL, FALSE);
#line 1061 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _directory_monitor_on_monitor_notification_g_file_monitor_changed, self);
#line 1062 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = monitor;
#line 1062 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_file_monitor_cancel (_tmp2_);
#line 5315 "DirectoryMonitor.c"
}


static void _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_query_info_queue_element_on_completed ((DirectoryMonitorQueryInfoQueueElement*) self, source_object, res);
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_query_info_queue_element_unref (self);
#line 5324 "DirectoryMonitor.c"
}


static gboolean _directory_monitor_check_for_expired_delete_events_gsource_func (gpointer self) {
	gboolean result;
	result = directory_monitor_check_for_expired_delete_events ((DirectoryMonitor*) self);
#line 1091 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 5333 "DirectoryMonitor.c"
}


static void directory_monitor_on_monitor_notification (DirectoryMonitor* self, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileMonitorEvent _tmp5_ = 0;
	GEnumValue* _tmp6_;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	DirectoryMonitorQueryInfoQueueElement* query_info = NULL;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	GFileMonitorEvent _tmp14_ = 0;
	DirectoryMonitorQueryInfoQueueElement* _tmp15_ = NULL;
	GeeQueue* _tmp16_ = NULL;
	DirectoryMonitorQueryInfoQueueElement* _tmp17_ = NULL;
	GFileMonitorEvent _tmp18_ = 0;
#line 1065 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1065 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1065 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((other_file == NULL) || G_IS_FILE (other_file));
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = other_file;
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp1_ != NULL) {
#line 5365 "DirectoryMonitor.c"
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = other_file;
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp0_);
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp3_;
#line 5376 "DirectoryMonitor.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = g_strdup ("(none)");
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp0_);
#line 1067 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp4_;
#line 5385 "DirectoryMonitor.c"
	}
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = event;
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp5_);
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = file;
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = _tmp8_;
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = g_strdup_printf ("NOTIFY %s: file=%s other_file=%s", (_tmp6_ != NULL) ? _tmp6_->value_name : NULL, _tmp9_, _tmp0_);
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = _tmp10_;
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp11_);
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp11_);
#line 1066 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp9_);
#line 1076 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = file;
#line 1076 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = other_file;
#line 1076 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = event;
#line 1076 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp15_ = directory_monitor_query_info_queue_element_new (self, _tmp12_, _tmp13_, _tmp14_);
#line 1076 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	query_info = _tmp15_;
#line 1077 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = self->priv->query_info_queue;
#line 1077 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp17_ = query_info;
#line 1077 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_queue_offer (_tmp16_, _tmp17_);
#line 1079 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp18_ = event;
#line 1079 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_tmp18_) {
#line 1079 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CREATED:
#line 1079 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
#line 5431 "DirectoryMonitor.c"
		{
			GFile* _tmp19_ = NULL;
			GCancellable* _tmp20_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp21_ = NULL;
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp19_ = file;
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp20_ = self->priv->cancellable;
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp21_ = query_info;
#line 1082 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_file_query_info_async (_tmp19_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _tmp20_, _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback, directory_monitor_query_info_queue_element_ref (_tmp21_));
#line 1084 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 5446 "DirectoryMonitor.c"
		}
#line 1079 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_DELETED:
#line 5450 "DirectoryMonitor.c"
		{
			guint _tmp22_ = 0U;
#line 1090 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp22_ = self->priv->delete_timer_id;
#line 1090 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp22_ == ((guint) 0)) {
#line 5457 "DirectoryMonitor.c"
				guint _tmp23_ = 0U;
#line 1091 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp23_ = g_timeout_add_full (G_PRIORITY_DEFAULT, DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC / 2, _directory_monitor_check_for_expired_delete_events_gsource_func, g_object_ref (self), g_object_unref);
#line 1091 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				self->priv->delete_timer_id = _tmp23_;
#line 5463 "DirectoryMonitor.c"
			}
#line 1092 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 5467 "DirectoryMonitor.c"
		}
#line 1079 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_MOVED:
#line 5471 "DirectoryMonitor.c"
		{
			GFile* _tmp24_ = NULL;
#line 1097 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp24_ = other_file;
#line 1097 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp24_ != NULL) {
#line 5478 "DirectoryMonitor.c"
				GFile* _tmp25_ = NULL;
				GCancellable* _tmp26_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp27_ = NULL;
#line 1098 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp25_ = other_file;
#line 1098 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp26_ = self->priv->cancellable;
#line 1098 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp27_ = query_info;
#line 1098 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_file_query_info_async (_tmp25_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, DIRECTORY_MONITOR_DEFAULT_PRIORITY, _tmp26_, _directory_monitor_query_info_queue_element_on_completed_gasync_ready_callback, directory_monitor_query_info_queue_element_ref (_tmp27_));
#line 5490 "DirectoryMonitor.c"
			} else {
				GeeQueue* _tmp28_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp29_ = NULL;
#line 1101 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_warning ("DirectoryMonitor.vala:1101: Unable to process MOVED event: no other_fi" \
"le");
#line 1102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp28_ = self->priv->query_info_queue;
#line 1102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp29_ = query_info;
#line 1102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_COLLECTION, GeeCollection), _tmp29_);
#line 5502 "DirectoryMonitor.c"
			}
#line 1104 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 5506 "DirectoryMonitor.c"
		}
		default:
		{
			DirectoryMonitorQueryInfoQueueElement* _tmp30_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp31_ = NULL;
#line 1108 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp30_ = query_info;
#line 1108 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp30_->completed = TRUE;
#line 1109 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp31_ = query_info;
#line 1109 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_process_query_queue (self, _tmp31_);
#line 1110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 5522 "DirectoryMonitor.c"
		}
	}
#line 1065 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_directory_monitor_query_info_queue_element_unref0 (query_info);
#line 1065 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp0_);
#line 5529 "DirectoryMonitor.c"
}


static void directory_monitor_process_query_queue (DirectoryMonitor* self, DirectoryMonitorQueryInfoQueueElement* query_info) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	DirectoryMonitorQueryInfoQueueElement* _tmp2_ = NULL;
#line 1114 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1114 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((query_info == NULL) || DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT (query_info));
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = query_info;
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_ != NULL) {
#line 5545 "DirectoryMonitor.c"
		DirectoryMonitorQueryInfoQueueElement* _tmp3_ = NULL;
		GFileInfo* _tmp4_ = NULL;
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = query_info;
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = _tmp3_->info;
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 5554 "DirectoryMonitor.c"
	} else {
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = FALSE;
#line 5558 "DirectoryMonitor.c"
	}
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp1_) {
#line 5562 "DirectoryMonitor.c"
		DirectoryMonitorQueryInfoQueueElement* _tmp5_ = NULL;
		GFileMonitorEvent _tmp6_ = 0;
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = query_info;
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = _tmp5_->event;
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp6_ == G_FILE_MONITOR_EVENT_CREATED;
#line 5571 "DirectoryMonitor.c"
	} else {
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = FALSE;
#line 5575 "DirectoryMonitor.c"
	}
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp0_) {
#line 5579 "DirectoryMonitor.c"
		GFile* match = NULL;
		DirectoryMonitorFileInfoMap* _tmp7_ = NULL;
		DirectoryMonitorQueryInfoQueueElement* _tmp8_ = NULL;
		GFileInfo* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFile* _tmp11_ = NULL;
#line 1120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = self->priv->files;
#line 1120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = query_info;
#line 1120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp8_->info;
#line 1120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = directory_monitor_file_info_map_find_match (_tmp7_, _tmp9_);
#line 1120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		match = _tmp10_;
#line 1121 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = match;
#line 1121 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_tmp11_ != NULL) {
#line 5600 "DirectoryMonitor.c"
			gboolean matched = FALSE;
			gboolean _tmp48_ = FALSE;
#line 1122 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			matched = FALSE;
#line 5605 "DirectoryMonitor.c"
			{
				GeeIterator* _enqueued_it = NULL;
				GeeQueue* _tmp12_ = NULL;
				GeeIterator* _tmp13_ = NULL;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp12_ = self->priv->query_info_queue;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_enqueued_it = _tmp13_;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				while (TRUE) {
#line 5618 "DirectoryMonitor.c"
					GeeIterator* _tmp14_ = NULL;
					gboolean _tmp15_ = FALSE;
					DirectoryMonitorQueryInfoQueueElement* enqueued = NULL;
					GeeIterator* _tmp16_ = NULL;
					gpointer _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					DirectoryMonitorQueryInfoQueueElement* _tmp20_ = NULL;
					GFileMonitorEvent _tmp21_ = 0;
					DirectoryMonitorQueryInfoQueueElement* _tmp28_ = NULL;
					GFile* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp32_ = NULL;
					GFile* _tmp33_ = NULL;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp38_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp39_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp40_ = NULL;
					GFile* _tmp41_ = NULL;
					GFile* _tmp42_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp43_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp44_ = NULL;
					GFileInfo* _tmp45_ = NULL;
					GFileInfo* _tmp46_ = NULL;
					DirectoryMonitorQueryInfoQueueElement* _tmp47_ = NULL;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp14_ = _enqueued_it;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp15_ = gee_iterator_next (_tmp14_);
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (!_tmp15_) {
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						break;
#line 5656 "DirectoryMonitor.c"
					}
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp16_ = _enqueued_it;
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp17_ = gee_iterator_get (_tmp16_);
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					enqueued = (DirectoryMonitorQueryInfoQueueElement*) _tmp17_;
#line 1124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp20_ = enqueued;
#line 1124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp21_ = _tmp20_->event;
#line 1124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp21_ != G_FILE_MONITOR_EVENT_DELETED) {
#line 1124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp19_ = TRUE;
#line 5672 "DirectoryMonitor.c"
					} else {
						DirectoryMonitorQueryInfoQueueElement* _tmp22_ = NULL;
						gboolean _tmp23_ = FALSE;
#line 1125 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp22_ = enqueued;
#line 1125 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp23_ = _tmp22_->completed;
#line 1125 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp19_ = _tmp23_;
#line 5682 "DirectoryMonitor.c"
					}
#line 1124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp19_) {
#line 1124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp18_ = TRUE;
#line 5688 "DirectoryMonitor.c"
					} else {
						GFile* _tmp24_ = NULL;
						DirectoryMonitorQueryInfoQueueElement* _tmp25_ = NULL;
						GFile* _tmp26_ = NULL;
						gboolean _tmp27_ = FALSE;
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp24_ = match;
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp25_ = enqueued;
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp26_ = _tmp25_->file;
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp27_ = g_file_equal (_tmp24_, _tmp26_);
#line 1126 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp18_ = !_tmp27_;
#line 5704 "DirectoryMonitor.c"
					}
#line 1124 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp18_) {
#line 1127 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_directory_monitor_query_info_queue_element_unref0 (enqueued);
#line 1127 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						continue;
#line 5712 "DirectoryMonitor.c"
					}
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp28_ = query_info;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp29_ = _tmp28_->file;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp30_ = g_file_get_path (_tmp29_);
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp31_ = _tmp30_;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp32_ = enqueued;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp33_ = _tmp32_->file;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp34_ = g_file_get_path (_tmp33_);
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp35_ = _tmp34_;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp36_ = g_strdup_printf ("Matching CREATED %s to DELETED %s for MOVED", _tmp31_, _tmp35_);
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp37_ = _tmp36_;
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_mdbg (_tmp37_);
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_tmp37_);
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_tmp35_);
#line 1130 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_free0 (_tmp31_);
#line 1133 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp38_ = enqueued;
#line 1133 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp38_->event = G_FILE_MONITOR_EVENT_MOVED;
#line 1134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp39_ = enqueued;
#line 1134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp40_ = query_info;
#line 1134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp41_ = _tmp40_->file;
#line 1134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp42_ = _g_object_ref0 (_tmp41_);
#line 1134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_tmp39_->other_file);
#line 1134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp39_->other_file = _tmp42_;
#line 1135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp43_ = enqueued;
#line 1135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp44_ = query_info;
#line 1135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp45_ = _tmp44_->info;
#line 1135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp46_ = _g_object_ref0 (_tmp45_);
#line 1135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_tmp43_->info);
#line 1135 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp43_->info = _tmp46_;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp47_ = enqueued;
#line 1136 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp47_->completed = TRUE;
#line 1138 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					matched = TRUE;
#line 1140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_directory_monitor_query_info_queue_element_unref0 (enqueued);
#line 1140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 5780 "DirectoryMonitor.c"
				}
#line 1123 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_enqueued_it);
#line 5784 "DirectoryMonitor.c"
			}
#line 1143 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp48_ = matched;
#line 1143 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp48_) {
#line 5790 "DirectoryMonitor.c"
				GeeQueue* _tmp49_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp50_ = NULL;
#line 1144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp49_ = self->priv->query_info_queue;
#line 1144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp50_ = query_info;
#line 1144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_COLLECTION, GeeCollection), _tmp50_);
#line 5799 "DirectoryMonitor.c"
			}
		}
#line 1117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (match);
#line 5804 "DirectoryMonitor.c"
	}
	{
		gboolean _tmp51_ = FALSE;
#line 1149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp51_ = TRUE;
#line 1149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 5812 "DirectoryMonitor.c"
			DirectoryMonitorQueryInfoQueueElement* next = NULL;
			GeeQueue* _tmp52_ = NULL;
			gpointer _tmp53_ = NULL;
			gboolean _tmp54_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp55_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* n = NULL;
			GeeQueue* _tmp58_ = NULL;
			gpointer _tmp59_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp60_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp61_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp62_ = NULL;
			guint _tmp63_ = 0U;
			DirectoryMonitorQueryInfoQueueElement* _tmp64_ = NULL;
			GFileMonitorEvent _tmp65_ = 0;
			GEnumValue* _tmp66_;
			DirectoryMonitorQueryInfoQueueElement* _tmp67_ = NULL;
			GFile* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_ = NULL;
			gchar* _tmp72_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp73_ = NULL;
			GError* _tmp74_ = NULL;
			gboolean _tmp87_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp88_ = NULL;
			GFileInfo* _tmp89_ = NULL;
			gboolean _tmp103_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* _tmp104_ = NULL;
			GFileInfo* _tmp105_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp118_ = NULL;
			GFile* _tmp119_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp120_ = NULL;
			GFile* _tmp121_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp122_ = NULL;
			GFileInfo* _tmp123_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp124_ = NULL;
			GFileMonitorEvent _tmp125_ = 0;
#line 1149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp51_) {
#line 5852 "DirectoryMonitor.c"
			}
#line 1149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp51_ = FALSE;
#line 1151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp52_ = self->priv->query_info_queue;
#line 1151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp53_ = gee_queue_peek (_tmp52_);
#line 1151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			next = (DirectoryMonitorQueryInfoQueueElement*) _tmp53_;
#line 1152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp55_ = next;
#line 1152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp55_ == NULL) {
#line 1152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp54_ = TRUE;
#line 5868 "DirectoryMonitor.c"
			} else {
				DirectoryMonitorQueryInfoQueueElement* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
#line 1152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp56_ = next;
#line 1152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp57_ = _tmp56_->completed;
#line 1152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp54_ = !_tmp57_;
#line 5878 "DirectoryMonitor.c"
			}
#line 1152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp54_) {
#line 1153 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (next);
#line 1153 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 5886 "DirectoryMonitor.c"
			}
#line 1156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp58_ = self->priv->query_info_queue;
#line 1156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp59_ = gee_queue_poll (_tmp58_);
#line 1156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			n = (DirectoryMonitorQueryInfoQueueElement*) _tmp59_;
#line 1157 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp60_ = next;
#line 1157 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp61_ = n;
#line 1157 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp60_ == _tmp61_, "next == n");
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp62_ = next;
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp63_ = _tmp62_->position;
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp64_ = next;
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp65_ = _tmp64_->event;
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp66_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp65_);
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp67_ = next;
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp68_ = _tmp67_->file;
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp69_ = g_file_get_path (_tmp68_);
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp70_ = _tmp69_;
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp71_ = g_strdup_printf ("Completed info query %u for %s on %s", _tmp63_, (_tmp66_ != NULL) ? _tmp66_->value_name : NULL, _tmp70_);
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp72_ = _tmp71_;
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_mdbg (_tmp72_);
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp72_);
#line 1159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp70_);
#line 1162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp73_ = next;
#line 1162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp74_ = _tmp73_->err;
#line 1162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp74_ != NULL) {
#line 5934 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp75_ = NULL;
				GFile* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp79_ = NULL;
				GFileMonitorEvent _tmp80_ = 0;
				GEnumValue* _tmp81_;
				DirectoryMonitorQueryInfoQueueElement* _tmp82_ = NULL;
				GError* _tmp83_ = NULL;
				const gchar* _tmp84_ = NULL;
				gchar* _tmp85_ = NULL;
				gchar* _tmp86_ = NULL;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp75_ = next;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp76_ = _tmp75_->file;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp77_ = g_file_get_path (_tmp76_);
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp78_ = _tmp77_;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp79_ = next;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp80_ = _tmp79_->event;
#line 1164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp81_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp80_);
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp82_ = next;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp83_ = _tmp82_->err;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp84_ = _tmp83_->message;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp85_ = g_strdup_printf ("Unable to retrieve file information for %s, dropping %s: %s", _tmp78_, (_tmp81_ != NULL) ? _tmp81_->value_name : NULL, _tmp84_);
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp86_ = _tmp85_;
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_mdbg (_tmp86_);
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp86_);
#line 1163 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp78_);
#line 1166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (n);
#line 1166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (next);
#line 1166 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 5983 "DirectoryMonitor.c"
			}
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp88_ = next;
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp89_ = _tmp88_->info;
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp89_ != NULL) {
#line 5991 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp90_ = NULL;
				GFileInfo* _tmp91_ = NULL;
				gchar* _tmp92_ = NULL;
				gchar* _tmp93_ = NULL;
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp90_ = next;
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp91_ = _tmp90_->info;
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp92_ = get_file_info_id (_tmp91_);
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp93_ = _tmp92_;
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp87_ = _tmp93_ == NULL;
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp93_);
#line 6008 "DirectoryMonitor.c"
			} else {
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp87_ = FALSE;
#line 6012 "DirectoryMonitor.c"
			}
#line 1170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp87_) {
#line 6016 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp94_ = NULL;
				GFile* _tmp95_ = NULL;
				gchar* _tmp96_ = NULL;
				gchar* _tmp97_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp98_ = NULL;
				GFileMonitorEvent _tmp99_ = 0;
				GEnumValue* _tmp100_;
				gchar* _tmp101_ = NULL;
				gchar* _tmp102_ = NULL;
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp94_ = next;
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp95_ = _tmp94_->file;
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp96_ = g_file_get_path (_tmp95_);
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp97_ = _tmp96_;
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp98_ = next;
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp99_ = _tmp98_->event;
#line 1172 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp100_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp99_);
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp101_ = g_strdup_printf ("Unable to retrieve file ID for %s, dropping %s", _tmp97_, (_tmp100_ != NULL) ? _tmp100_->value_name : NULL);
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp102_ = _tmp101_;
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_mdbg (_tmp102_);
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp102_);
#line 1171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp97_);
#line 1174 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (n);
#line 1174 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (next);
#line 1174 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 6056 "DirectoryMonitor.c"
			}
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp104_ = next;
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp105_ = _tmp104_->info;
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp105_ != NULL) {
#line 6064 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp106_ = NULL;
				GFileInfo* _tmp107_ = NULL;
				gboolean _tmp108_ = FALSE;
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp106_ = next;
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp107_ = _tmp106_->info;
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp108_ = directory_monitor_is_file_symlink_supported (_tmp107_);
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp103_ = !_tmp108_;
#line 6076 "DirectoryMonitor.c"
			} else {
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp103_ = FALSE;
#line 6080 "DirectoryMonitor.c"
			}
#line 1178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp103_) {
#line 6084 "DirectoryMonitor.c"
				DirectoryMonitorQueryInfoQueueElement* _tmp109_ = NULL;
				GFile* _tmp110_ = NULL;
				gchar* _tmp111_ = NULL;
				gchar* _tmp112_ = NULL;
				DirectoryMonitorQueryInfoQueueElement* _tmp113_ = NULL;
				GFileMonitorEvent _tmp114_ = 0;
				GEnumValue* _tmp115_;
				gchar* _tmp116_ = NULL;
				gchar* _tmp117_ = NULL;
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp109_ = next;
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp110_ = _tmp109_->file;
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp111_ = g_file_get_path (_tmp110_);
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp112_ = _tmp111_;
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp113_ = next;
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp114_ = _tmp113_->event;
#line 1180 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp115_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp114_);
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp116_ = g_strdup_printf ("No symlink support for %s, dropping %s", _tmp112_, (_tmp115_ != NULL) ? _tmp115_->value_name : NULL);
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp117_ = _tmp116_;
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_mdbg (_tmp117_);
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp117_);
#line 1179 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp112_);
#line 1182 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (n);
#line 1182 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (next);
#line 1182 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 6124 "DirectoryMonitor.c"
			}
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp118_ = next;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp119_ = _tmp118_->file;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp120_ = next;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp121_ = _tmp120_->other_file;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp122_ = next;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp123_ = _tmp122_->info;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp124_ = next;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp125_ = _tmp124_->event;
#line 1185 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_on_monitor_notification_ready (self, _tmp119_, _tmp121_, _tmp123_, _tmp125_);
#line 1149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_directory_monitor_query_info_queue_element_unref0 (n);
#line 1149 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_directory_monitor_query_info_queue_element_unref0 (next);
#line 6148 "DirectoryMonitor.c"
		}
	}
}


static void directory_monitor_on_monitor_notification_ready (DirectoryMonitor* self, GFile* file, GFile* other_file, GFileInfo* info, GFileMonitorEvent event) {
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileMonitorEvent _tmp5_ = 0;
	GEnumValue* _tmp6_;
	GFile* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GFileMonitorEvent _tmp12_ = 0;
#line 1189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (IS_DIRECTORY_MONITOR (self));
#line 1189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((other_file == NULL) || G_IS_FILE (other_file));
#line 1189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((info == NULL) || G_IS_FILE_INFO (info));
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = other_file;
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp1_ != NULL) {
#line 6177 "DirectoryMonitor.c"
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = other_file;
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = g_file_get_path (_tmp2_);
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp0_);
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp3_;
#line 6188 "DirectoryMonitor.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = g_strdup ("(null)");
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp0_);
#line 1192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = _tmp4_;
#line 6197 "DirectoryMonitor.c"
	}
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = event;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp5_);
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = file;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = g_file_get_path (_tmp7_);
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = _tmp8_;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = g_strdup_printf ("READY %s: file=%s other_file=%s", (_tmp6_ != NULL) ? _tmp6_->value_name : NULL, _tmp9_, _tmp0_);
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = _tmp10_;
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg (_tmp11_);
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp11_);
#line 1191 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp9_);
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = event;
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_tmp12_) {
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CREATED:
#line 6225 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp13_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp14_ = NULL;
			DirectoryMonitorFType _tmp15_ = 0;
			DirectoryMonitorFType _tmp16_ = 0;
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp13_ = info;
#line 1198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp13_ != NULL, "info != null");
#line 1200 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp14_ = info;
#line 1200 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp15_ = directory_monitor_get_ftype (_tmp14_);
#line 1200 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp15_;
#line 1201 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp16_ = ftype;
#line 1201 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp16_) {
#line 1201 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6248 "DirectoryMonitor.c"
				{
					GFile* _tmp17_ = NULL;
					GFileInfo* _tmp18_ = NULL;
#line 1203 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp17_ = file;
#line 1203 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp18_ = info;
#line 1203 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_file_created (self, _tmp17_, _tmp18_);
#line 1204 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6260 "DirectoryMonitor.c"
				}
#line 1201 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6264 "DirectoryMonitor.c"
				{
					gint _tmp19_ = 0;
					GFile* _tmp20_ = NULL;
					GFileInfo* _tmp21_ = NULL;
#line 1211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp19_ = self->priv->outstanding_exploration_dirs;
#line 1211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					self->priv->outstanding_exploration_dirs = _tmp19_ + 1;
#line 1212 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp20_ = file;
#line 1212 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp21_ = info;
#line 1212 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_explore_async (self, _tmp20_, _tmp21_, FALSE, NULL, NULL);
#line 1213 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6281 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp22_ = 0;
#line 1216 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp22_ = ftype;
#line 1216 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp22_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6292 "DirectoryMonitor.c"
				}
			}
#line 1219 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6297 "DirectoryMonitor.c"
		}
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CHANGED:
#line 6301 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp23_ = NULL;
			GFileInfo* local_info = NULL;
			GFile* _tmp24_ = NULL;
			GFileInfo* _tmp25_ = NULL;
			GFileInfo* _tmp26_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp32_ = NULL;
			DirectoryMonitorFType _tmp33_ = 0;
			DirectoryMonitorFType _tmp34_ = 0;
#line 1223 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp23_ = info;
#line 1223 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp23_ == NULL, "info == null");
#line 1225 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp24_ = file;
#line 1225 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp25_ = directory_monitor_get_file_info (self, _tmp24_);
#line 1225 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			local_info = _tmp25_;
#line 1226 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp26_ = local_info;
#line 1226 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp26_ == NULL) {
#line 6326 "DirectoryMonitor.c"
				GFile* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
#line 1227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp27_ = file;
#line 1227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp28_ = g_file_get_path (_tmp27_);
#line 1227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp29_ = _tmp28_;
#line 1227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp30_ = g_strdup_printf ("Changed event for unknown file %s", _tmp29_);
#line 1227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp31_ = _tmp30_;
#line 1227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				directory_monitor_mdbg (_tmp31_);
#line 1227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp31_);
#line 1227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp29_);
#line 1229 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (local_info);
#line 1229 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 6352 "DirectoryMonitor.c"
			}
#line 1232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp32_ = local_info;
#line 1232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp33_ = directory_monitor_get_ftype (_tmp32_);
#line 1232 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp33_;
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp34_ = ftype;
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp34_) {
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6366 "DirectoryMonitor.c"
				{
					GFile* _tmp35_ = NULL;
#line 1235 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp35_ = file;
#line 1235 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_notify_file_altered (self, _tmp35_);
#line 1236 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6375 "DirectoryMonitor.c"
				}
#line 1233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6379 "DirectoryMonitor.c"
				{
					GFile* _tmp36_ = NULL;
#line 1239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp36_ = file;
#line 1239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_notify_directory_altered (self, _tmp36_);
#line 1240 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6388 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp37_ = 0;
#line 1243 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp37_ = ftype;
#line 1243 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp37_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1244 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6399 "DirectoryMonitor.c"
				}
			}
#line 1246 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (local_info);
#line 1246 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6406 "DirectoryMonitor.c"
		}
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
#line 6410 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp38_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp39_ = NULL;
			DirectoryMonitorFType _tmp40_ = 0;
			DirectoryMonitorFType _tmp41_ = 0;
#line 1249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp38_ = info;
#line 1249 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp38_ != NULL, "info != null");
#line 1251 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp39_ = info;
#line 1251 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp40_ = directory_monitor_get_ftype (_tmp39_);
#line 1251 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp40_;
#line 1252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp41_ = ftype;
#line 1252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp41_) {
#line 1252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6433 "DirectoryMonitor.c"
				{
					GFile* _tmp42_ = NULL;
					GFileInfo* _tmp43_ = NULL;
#line 1254 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp42_ = file;
#line 1254 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp43_ = info;
#line 1254 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_file_alteration_completed (self, _tmp42_, _tmp43_);
#line 1255 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6445 "DirectoryMonitor.c"
				}
#line 1252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6449 "DirectoryMonitor.c"
				{
					GFile* _tmp44_ = NULL;
					GFileInfo* _tmp45_ = NULL;
#line 1258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp44_ = file;
#line 1258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp45_ = info;
#line 1258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_directory_alteration_completed (self, _tmp44_, _tmp45_);
#line 1259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6461 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp46_ = 0;
#line 1262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp46_ = ftype;
#line 1262 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp46_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6472 "DirectoryMonitor.c"
				}
			}
#line 1265 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6477 "DirectoryMonitor.c"
		}
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_MOVED:
#line 6481 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp47_ = NULL;
			GFile* _tmp48_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp49_ = NULL;
			DirectoryMonitorFType _tmp50_ = 0;
			DirectoryMonitorFType _tmp51_ = 0;
#line 1268 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp47_ = info;
#line 1268 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp47_ != NULL, "info != null");
#line 1269 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp48_ = other_file;
#line 1269 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp48_ != NULL, "other_file != null");
#line 1273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp49_ = info;
#line 1273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp50_ = directory_monitor_get_ftype (_tmp49_);
#line 1273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp50_;
#line 1274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp51_ = ftype;
#line 1274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp51_) {
#line 1274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6509 "DirectoryMonitor.c"
				{
					GFile* _tmp52_ = NULL;
					GFile* _tmp53_ = NULL;
					GFileInfo* _tmp54_ = NULL;
#line 1276 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp52_ = file;
#line 1276 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp53_ = other_file;
#line 1276 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp54_ = info;
#line 1276 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_file_moved (self, _tmp52_, _tmp53_, _tmp54_);
#line 1277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6524 "DirectoryMonitor.c"
				}
#line 1274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6528 "DirectoryMonitor.c"
				{
					GFileInfo* old_dir_info = NULL;
					DirectoryMonitorFileInfoMap* _tmp55_ = NULL;
					GFile* _tmp56_ = NULL;
					GFileInfo* _tmp57_ = NULL;
					GFileInfo* _tmp58_ = NULL;
					GFile* _tmp62_ = NULL;
					GFileInfo* _tmp63_ = NULL;
					GFile* _tmp64_ = NULL;
					GFileInfo* _tmp65_ = NULL;
#line 1281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp55_ = self->priv->files;
#line 1281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp56_ = file;
#line 1281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp57_ = directory_monitor_file_info_map_get_info (_tmp55_, _tmp56_);
#line 1281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					old_dir_info = _tmp57_;
#line 1282 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp58_ = old_dir_info;
#line 1282 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp58_ == NULL) {
#line 6551 "DirectoryMonitor.c"
						GFile* _tmp59_ = NULL;
						gchar* _tmp60_ = NULL;
						gchar* _tmp61_ = NULL;
#line 1283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp59_ = file;
#line 1283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp60_ = g_file_get_path (_tmp59_);
#line 1283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp61_ = _tmp60_;
#line 1283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						g_warning ("DirectoryMonitor.vala:1283: Directory moved event for unknown file %s", _tmp61_);
#line 1283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_g_free0 (_tmp61_);
#line 1285 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_g_object_unref0 (old_dir_info);
#line 1285 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						break;
#line 6569 "DirectoryMonitor.c"
					}
#line 1288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp62_ = file;
#line 1288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp63_ = old_dir_info;
#line 1288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp64_ = other_file;
#line 1288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp65_ = info;
#line 1288 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_directory_moved (self, _tmp62_, _tmp63_, _tmp64_, _tmp65_);
#line 1289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (old_dir_info);
#line 1289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6585 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp66_ = 0;
#line 1292 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp66_ = ftype;
#line 1292 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp66_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6596 "DirectoryMonitor.c"
				}
			}
#line 1295 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6601 "DirectoryMonitor.c"
		}
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_DELETED:
#line 6605 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp67_ = NULL;
			GFileInfo* local_info = NULL;
			GFile* _tmp68_ = NULL;
			GFileInfo* _tmp69_ = NULL;
			GFileInfo* _tmp70_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp74_ = NULL;
			DirectoryMonitorFType _tmp75_ = 0;
			DirectoryMonitorFType _tmp76_ = 0;
#line 1298 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp67_ = info;
#line 1298 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp67_ == NULL, "info == null");
#line 1300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp68_ = file;
#line 1300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp69_ = directory_monitor_get_file_info (self, _tmp68_);
#line 1300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			local_info = _tmp69_;
#line 1301 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp70_ = local_info;
#line 1301 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp70_ == NULL) {
#line 6630 "DirectoryMonitor.c"
				GFile* _tmp71_ = NULL;
				gchar* _tmp72_ = NULL;
				gchar* _tmp73_ = NULL;
#line 1302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp71_ = file;
#line 1302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp72_ = g_file_get_path (_tmp71_);
#line 1302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp73_ = _tmp72_;
#line 1302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_warning ("DirectoryMonitor.vala:1302: Deleted event for unknown file %s", _tmp73_);
#line 1302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp73_);
#line 1304 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (local_info);
#line 1304 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 6648 "DirectoryMonitor.c"
			}
#line 1307 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp74_ = local_info;
#line 1307 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp75_ = directory_monitor_get_ftype (_tmp74_);
#line 1307 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp75_;
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp76_ = ftype;
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp76_) {
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6662 "DirectoryMonitor.c"
				{
					GFile* _tmp77_ = NULL;
#line 1310 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp77_ = file;
#line 1310 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_file_deleted (self, _tmp77_);
#line 1311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6671 "DirectoryMonitor.c"
				}
#line 1308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6675 "DirectoryMonitor.c"
				{
					GFile* _tmp78_ = NULL;
#line 1314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp78_ = file;
#line 1314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_internal_notify_directory_deleted (self, _tmp78_);
#line 1315 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6684 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp79_ = 0;
#line 1318 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp79_ = ftype;
#line 1318 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp79_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1319 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6695 "DirectoryMonitor.c"
				}
			}
#line 1321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (local_info);
#line 1321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6702 "DirectoryMonitor.c"
		}
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
#line 6706 "DirectoryMonitor.c"
		{
			GFileInfo* _tmp80_ = NULL;
			GFileInfo* local_info = NULL;
			GFile* _tmp81_ = NULL;
			GFileInfo* _tmp82_ = NULL;
			GFileInfo* _tmp83_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GFileInfo* _tmp87_ = NULL;
			DirectoryMonitorFType _tmp88_ = 0;
			DirectoryMonitorFType _tmp89_ = 0;
#line 1325 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp80_ = info;
#line 1325 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp80_ == NULL, "info == null");
#line 1327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp81_ = file;
#line 1327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp82_ = directory_monitor_get_file_info (self, _tmp81_);
#line 1327 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			local_info = _tmp82_;
#line 1328 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp83_ = local_info;
#line 1328 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp83_ == NULL) {
#line 6731 "DirectoryMonitor.c"
				GFile* _tmp84_ = NULL;
				gchar* _tmp85_ = NULL;
				gchar* _tmp86_ = NULL;
#line 1329 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp84_ = file;
#line 1329 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp85_ = g_file_get_path (_tmp84_);
#line 1329 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp86_ = _tmp85_;
#line 1329 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				g_warning ("DirectoryMonitor.vala:1329: Attribute changed event for unknown file %" \
"s", _tmp86_);
#line 1329 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_tmp86_);
#line 1331 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (local_info);
#line 1331 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 6749 "DirectoryMonitor.c"
			}
#line 1334 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp87_ = local_info;
#line 1334 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp88_ = directory_monitor_get_ftype (_tmp87_);
#line 1334 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp88_;
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp89_ = ftype;
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp89_) {
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 6763 "DirectoryMonitor.c"
				{
					GFile* _tmp90_ = NULL;
#line 1337 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp90_ = file;
#line 1337 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_notify_file_attributes_altered (self, _tmp90_);
#line 1338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6772 "DirectoryMonitor.c"
				}
#line 1335 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 6776 "DirectoryMonitor.c"
				{
					GFile* _tmp91_ = NULL;
#line 1341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp91_ = file;
#line 1341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_notify_directory_attributes_altered (self, _tmp91_);
#line 1342 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6785 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp92_ = 0;
#line 1345 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp92_ = ftype;
#line 1345 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp92_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 6796 "DirectoryMonitor.c"
				}
			}
#line 1348 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (local_info);
#line 1348 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6803 "DirectoryMonitor.c"
		}
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_PRE_UNMOUNT:
#line 1196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case G_FILE_MONITOR_EVENT_UNMOUNTED:
#line 6809 "DirectoryMonitor.c"
		{
#line 1353 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6813 "DirectoryMonitor.c"
		}
		default:
		{
			GFileMonitorEvent _tmp93_ = 0;
			GEnumValue* _tmp94_;
#line 1356 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp93_ = event;
#line 1356 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp94_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), _tmp93_);
#line 1356 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_warning ("DirectoryMonitor.vala:1356: Unknown directory monitor event %s", (_tmp94_ != NULL) ? _tmp94_->value_name : NULL);
#line 1357 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			break;
#line 6827 "DirectoryMonitor.c"
		}
	}
#line 1189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_tmp0_);
#line 6832 "DirectoryMonitor.c"
}


static gboolean directory_monitor_is_file_create_move (DirectoryMonitor* self, GFile* file, GFileInfo* info, GFile** old_file, GFileInfo** old_file_info) {
	GFile* _vala_old_file = NULL;
	GFileInfo* _vala_old_file_info = NULL;
	gboolean result = FALSE;
	GFile* match = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 1363 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 1363 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1363 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1366 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->parent_moved;
#line 1366 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 1366 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_find_match (_tmp0_, _tmp1_);
#line 1366 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	match = _tmp2_;
#line 1367 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = match;
#line 1367 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp3_ != NULL) {
#line 6863 "DirectoryMonitor.c"
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		DirectoryMonitorFileInfoMap* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GFileInfo* _tmp8_ = NULL;
		DirectoryMonitorFileInfoMap* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFileInfo* _tmp11_ = NULL;
#line 1368 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = match;
#line 1368 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 1368 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_old_file);
#line 1368 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_old_file = _tmp5_;
#line 1369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = self->priv->parent_moved;
#line 1369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = match;
#line 1369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = directory_monitor_file_info_map_get_info (_tmp6_, _tmp7_);
#line 1369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_old_file_info);
#line 1369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_old_file_info = _tmp8_;
#line 1371 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = self->priv->parent_moved;
#line 1371 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = match;
#line 1371 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = info;
#line 1371 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_remove (_tmp9_, _tmp10_, _tmp11_);
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = TRUE;
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (match);
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (old_file) {
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			*old_file = _vala_old_file;
#line 6906 "DirectoryMonitor.c"
		} else {
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_vala_old_file);
#line 6910 "DirectoryMonitor.c"
		}
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (old_file_info) {
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			*old_file_info = _vala_old_file_info;
#line 6916 "DirectoryMonitor.c"
		} else {
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_vala_old_file_info);
#line 6920 "DirectoryMonitor.c"
		}
#line 1373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 6924 "DirectoryMonitor.c"
	}
#line 1376 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_vala_old_file);
#line 1376 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_old_file = NULL;
#line 1377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_vala_old_file_info);
#line 1377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_old_file_info = NULL;
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = FALSE;
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (match);
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old_file) {
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*old_file = _vala_old_file;
#line 6942 "DirectoryMonitor.c"
	} else {
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_old_file);
#line 6946 "DirectoryMonitor.c"
	}
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old_file_info) {
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*old_file_info = _vala_old_file_info;
#line 6952 "DirectoryMonitor.c"
	} else {
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_old_file_info);
#line 6956 "DirectoryMonitor.c"
	}
#line 1379 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 6960 "DirectoryMonitor.c"
}


static gboolean directory_monitor_check_for_expired_delete_events (DirectoryMonitor* self) {
	gboolean result = FALSE;
	gulong expiration = 0UL;
	gulong _tmp0_ = 0UL;
	gboolean any_deleted = FALSE;
	gboolean any_expired = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
#line 1382 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), FALSE);
#line 1383 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = now_ms ();
#line 1383 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	expiration = _tmp0_ - DIRECTORY_MONITOR_DELETED_EXPIRATION_MSEC;
#line 1385 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	any_deleted = FALSE;
#line 1386 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	any_expired = FALSE;
#line 6982 "DirectoryMonitor.c"
	{
		GeeIterator* _element_it = NULL;
		GeeQueue* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = self->priv->query_info_queue;
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_element_it = _tmp2_;
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 6995 "DirectoryMonitor.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			DirectoryMonitorQueryInfoQueueElement* element = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			DirectoryMonitorQueryInfoQueueElement* _tmp7_ = NULL;
			GFileMonitorEvent _tmp8_ = 0;
			DirectoryMonitorQueryInfoQueueElement* _tmp9_ = NULL;
			gulong _tmp10_ = 0UL;
			gulong _tmp11_ = 0UL;
			DirectoryMonitorQueryInfoQueueElement* _tmp12_ = NULL;
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp3_ = _element_it;
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp4_) {
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 7015 "DirectoryMonitor.c"
			}
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp5_ = _element_it;
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			element = (DirectoryMonitorQueryInfoQueueElement*) _tmp6_;
#line 1388 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp7_ = element;
#line 1388 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp8_ = _tmp7_->event;
#line 1388 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp8_ != G_FILE_MONITOR_EVENT_DELETED) {
#line 1389 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (element);
#line 1389 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 7033 "DirectoryMonitor.c"
			}
#line 1391 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			any_deleted = TRUE;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp9_ = element;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = _tmp9_->time_created_msec;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = expiration;
#line 1393 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp10_ > _tmp11_) {
#line 1394 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_directory_monitor_query_info_queue_element_unref0 (element);
#line 1394 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 7049 "DirectoryMonitor.c"
			}
#line 1397 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp12_ = element;
#line 1397 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp12_->completed = TRUE;
#line 1398 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			any_expired = TRUE;
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_directory_monitor_query_info_queue_element_unref0 (element);
#line 7059 "DirectoryMonitor.c"
		}
#line 1387 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_element_it);
#line 7063 "DirectoryMonitor.c"
	}
#line 1401 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = any_expired;
#line 1401 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp13_) {
#line 1402 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_process_query_queue (self, NULL);
#line 7071 "DirectoryMonitor.c"
	}
#line 1404 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = any_deleted;
#line 1404 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp14_) {
#line 1405 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		self->priv->delete_timer_id = (guint) 0;
#line 7079 "DirectoryMonitor.c"
	}
#line 1407 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = any_deleted;
#line 1407 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 7085 "DirectoryMonitor.c"
}


GFileInfo* directory_monitor_get_file_info (DirectoryMonitor* self, GFile* file) {
	GFileInfo* result = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
#line 1411 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
#line 1411 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1412 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 1412 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 1412 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_get_info (_tmp0_, _tmp1_);
#line 1412 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp2_;
#line 1412 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 7108 "DirectoryMonitor.c"
}


GeeCollection* directory_monitor_get_files (DirectoryMonitor* self) {
	GeeCollection* result = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 1417 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = directory_monitor_file_info_map_get_all (_tmp0_);
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp1_;
#line 1418 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 7126 "DirectoryMonitor.c"
}


GFileInfo* directory_monitor_query_file_info (DirectoryMonitor* self, GFile* file) {
	GFileInfo* result = NULL;
	DirectoryMonitorFileInfoMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
#line 1424 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (self), NULL);
#line 1424 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1425 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->files;
#line 1425 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 1425 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = self->priv->cancellable;
#line 1425 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_query_info (_tmp0_, _tmp1_, _tmp2_);
#line 1425 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp3_;
#line 1425 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 7152 "DirectoryMonitor.c"
}


gboolean directory_monitor_is_file_symlink_supported (GFileInfo* info) {
	gboolean result = FALSE;
	GFileInfo* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	DirectoryMonitorFType ftype = 0;
	GFileInfo* _tmp2_ = NULL;
	DirectoryMonitorFType _tmp3_ = 0;
	DirectoryMonitorFType _tmp4_ = 0;
#line 1435 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1436 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = info;
#line 1436 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = g_file_info_get_is_symlink (_tmp0_);
#line 1436 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp1_) {
#line 1437 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = TRUE;
#line 1437 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 7176 "DirectoryMonitor.c"
	}
#line 1439 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 1439 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_get_ftype (_tmp2_);
#line 1439 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	ftype = _tmp3_;
#line 1440 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = ftype;
#line 1440 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	switch (_tmp4_) {
#line 1440 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 7190 "DirectoryMonitor.c"
		{
#line 1442 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_SUPPORT_DIR_SYMLINKS;
#line 1442 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 7196 "DirectoryMonitor.c"
		}
#line 1440 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		case DIRECTORY_MONITOR_FTYPE_FILE:
#line 7200 "DirectoryMonitor.c"
		{
#line 1445 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = DIRECTORY_MONITOR_SUPPORT_FILE_SYMLINKS;
#line 1445 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 7206 "DirectoryMonitor.c"
		}
		default:
		{
			DirectoryMonitorFType _tmp5_ = 0;
#line 1448 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp5_ = ftype;
#line 1448 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_assert (_tmp5_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 1450 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = FALSE;
#line 1450 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 7219 "DirectoryMonitor.c"
		}
	}
}


static void directory_monitor_real_root_moved (DirectoryMonitor* self, GFile* old_root, GFile* new_root, GFileInfo* new_root_info) {
#line 380 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_root));
#line 380 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_root));
#line 380 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_root_info));
#line 7232 "DirectoryMonitor.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (n_param_values == 4);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data1 = closure->data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data2 = param_values->data[0].v_pointer;
#line 7251 "DirectoryMonitor.c"
	} else {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data1 = param_values->data[0].v_pointer;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data2 = closure->data;
#line 7257 "DirectoryMonitor.c"
	}
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_object (param_values + 3), data2);
#line 7263 "DirectoryMonitor.c"
}


static void directory_monitor_real_root_deleted (DirectoryMonitor* self, GFile* root) {
#line 388 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (root));
#line 7270 "DirectoryMonitor.c"
}


static void directory_monitor_real_discovery_started (DirectoryMonitor* self) {
}


static void directory_monitor_real_file_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 394 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 394 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7283 "DirectoryMonitor.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (n_param_values == 3);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data1 = closure->data;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data2 = param_values->data[0].v_pointer;
#line 7302 "DirectoryMonitor.c"
	} else {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data1 = param_values->data[0].v_pointer;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		data2 = closure->data;
#line 7308 "DirectoryMonitor.c"
	}
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 7314 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_discovered (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 397 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 397 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7323 "DirectoryMonitor.c"
}


static void directory_monitor_real_discovery_failed (DirectoryMonitor* self, const gchar* reason) {
#line 402 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (reason != NULL);
#line 7330 "DirectoryMonitor.c"
}


static void directory_monitor_real_discovery_completed (DirectoryMonitor* self) {
#line 406 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->has_discovery_started = FALSE;
#line 407 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_mdbg ("discovery completed");
#line 7339 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_created (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 410 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 410 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7348 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_moved (DirectoryMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info) {
#line 413 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_file));
#line 413 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_file));
#line 413 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_file_info));
#line 7359 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_altered (DirectoryMonitor* self, GFile* file) {
#line 417 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 7366 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_alteration_completed (DirectoryMonitor* self, GFile* file, GFileInfo* info) {
#line 422 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 422 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7375 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_attributes_altered (DirectoryMonitor* self, GFile* file) {
#line 425 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 7382 "DirectoryMonitor.c"
}


static void directory_monitor_real_file_deleted (DirectoryMonitor* self, GFile* file) {
#line 428 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 7389 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_created (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 432 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 432 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7398 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_moved (DirectoryMonitor* self, GFile* old_dir, GFile* new_dir, GFileInfo* new_dir_info) {
#line 436 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (old_dir));
#line 436 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (new_dir));
#line 436 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (new_dir_info));
#line 7409 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_altered (DirectoryMonitor* self, GFile* dir) {
#line 440 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 7416 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_alteration_completed (DirectoryMonitor* self, GFile* dir, GFileInfo* info) {
#line 445 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 445 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 7425 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_attributes_altered (DirectoryMonitor* self, GFile* dir) {
#line 448 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 7432 "DirectoryMonitor.c"
}


static void directory_monitor_real_directory_deleted (DirectoryMonitor* self, GFile* dir) {
#line 452 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (dir));
#line 7439 "DirectoryMonitor.c"
}


static void directory_monitor_real_closed (DirectoryMonitor* self) {
}


static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_construct (GType object_type, DirectoryMonitor* owner, GFile* file, GFile* other_file, GFileMonitorEvent event) {
	DirectoryMonitorQueryInfoQueueElement* self = NULL;
	DirectoryMonitor* _tmp0_ = NULL;
	DirectoryMonitor* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFileMonitorEvent _tmp6_ = 0;
	guint _tmp7_ = 0U;
	gulong _tmp8_ = 0UL;
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (IS_DIRECTORY_MONITOR (owner), NULL);
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((other_file == NULL) || G_IS_FILE (other_file), NULL);
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = (DirectoryMonitorQueryInfoQueueElement*) g_type_create_instance (object_type);
#line 98 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = owner;
#line 98 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 98 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->owner);
#line 98 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->owner = _tmp1_;
#line 99 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = file;
#line 99 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 99 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->file);
#line 99 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->file = _tmp3_;
#line 100 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = other_file;
#line 100 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 100 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->other_file);
#line 100 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->other_file = _tmp5_;
#line 101 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = event;
#line 101 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->event = _tmp6_;
#line 102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = directory_monitor_query_info_queue_element_current;
#line 102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_query_info_queue_element_current = _tmp7_ + 1;
#line 102 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->position = _tmp7_;
#line 103 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = now_ms ();
#line 103 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->time_created_msec = _tmp8_;
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self;
#line 7506 "DirectoryMonitor.c"
}


static DirectoryMonitorQueryInfoQueueElement* directory_monitor_query_info_queue_element_new (DirectoryMonitor* owner, GFile* file, GFile* other_file, GFileMonitorEvent event) {
#line 96 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return directory_monitor_query_info_queue_element_construct (DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, owner, file, other_file, event);
#line 7513 "DirectoryMonitor.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self ? g_error_copy (self) : NULL;
#line 7520 "DirectoryMonitor.c"
}


static void directory_monitor_query_info_queue_element_on_completed (DirectoryMonitorQueryInfoQueueElement* self, GObject* source, GAsyncResult* aresult) {
	GFile* source_file = NULL;
	GObject* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	DirectoryMonitor* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (DIRECTORY_MONITOR_IS_QUERY_INFO_QUEUE_ELEMENT (self));
#line 106 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail ((source == NULL) || G_IS_OBJECT (source));
#line 106 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_ASYNC_RESULT (aresult));
#line 107 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = source;
#line 107 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_file_get_type (), GFile));
#line 107 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	source_file = _tmp1_;
#line 7542 "DirectoryMonitor.c"
	{
		GFileInfo* _tmp2_ = NULL;
		GAsyncResult* _tmp3_ = NULL;
		GFileInfo* _tmp4_ = NULL;
		GFileInfo* _tmp5_ = NULL;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = aresult;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = g_file_query_info_finish (source_file, _tmp3_, &_inner_error_);
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = _tmp4_;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7556 "DirectoryMonitor.c"
			goto __catch483_g_error;
		}
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = _tmp2_;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = NULL;
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (self->info);
#line 111 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		self->info = _tmp5_;
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp2_);
#line 7569 "DirectoryMonitor.c"
	}
	goto __finally483;
	__catch483_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		err = _inner_error_;
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_inner_error_ = NULL;
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = err;
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = _g_error_copy0 (_tmp6_);
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (self->err);
#line 113 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		self->err = _tmp7_;
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (err);
#line 7591 "DirectoryMonitor.c"
	}
	__finally483:
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (source_file);
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 110 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return;
#line 7604 "DirectoryMonitor.c"
	}
#line 117 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->completed = TRUE;
#line 120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = self->owner;
#line 120 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_process_query_queue (_tmp8_, self);
#line 106 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (source_file);
#line 7614 "DirectoryMonitor.c"
}


static void directory_monitor_value_query_info_queue_element_init (GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	value->data[0].v_pointer = NULL;
#line 7621 "DirectoryMonitor.c"
}


static void directory_monitor_value_query_info_queue_element_free_value (GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_query_info_queue_element_unref (value->data[0].v_pointer);
#line 7630 "DirectoryMonitor.c"
	}
}


static void directory_monitor_value_query_info_queue_element_copy_value (const GValue* src_value, GValue* dest_value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (src_value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		dest_value->data[0].v_pointer = directory_monitor_query_info_queue_element_ref (src_value->data[0].v_pointer);
#line 7640 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7644 "DirectoryMonitor.c"
	}
}


static gpointer directory_monitor_value_query_info_queue_element_peek_pointer (const GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return value->data[0].v_pointer;
#line 7652 "DirectoryMonitor.c"
}


static gchar* directory_monitor_value_query_info_queue_element_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (collect_values[0].v_pointer) {
#line 7659 "DirectoryMonitor.c"
		DirectoryMonitorQueryInfoQueueElement* object;
		object = collect_values[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7666 "DirectoryMonitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7670 "DirectoryMonitor.c"
		}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = directory_monitor_query_info_queue_element_ref (object);
#line 7674 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 7678 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return NULL;
#line 7682 "DirectoryMonitor.c"
}


static gchar* directory_monitor_value_query_info_queue_element_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DirectoryMonitorQueryInfoQueueElement** object_p;
	object_p = collect_values[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!object_p) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7693 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!value->data[0].v_pointer) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = NULL;
#line 7699 "DirectoryMonitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = value->data[0].v_pointer;
#line 7703 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = directory_monitor_query_info_queue_element_ref (value->data[0].v_pointer);
#line 7707 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return NULL;
#line 7711 "DirectoryMonitor.c"
}


static GParamSpec* directory_monitor_param_spec_query_info_queue_element (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DirectoryMonitorParamSpecQueryInfoQueueElement* spec;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT), NULL);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return G_PARAM_SPEC (spec);
#line 7725 "DirectoryMonitor.c"
}


static gpointer directory_monitor_value_get_query_info_queue_element (const GValue* value) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT), NULL);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return value->data[0].v_pointer;
#line 7734 "DirectoryMonitor.c"
}


static void directory_monitor_value_set_query_info_queue_element (GValue* value, gpointer v_object) {
	DirectoryMonitorQueryInfoQueueElement* old;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old = value->data[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (v_object) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_query_info_queue_element_ref (value->data[0].v_pointer);
#line 7754 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 7758 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_query_info_queue_element_unref (old);
#line 7764 "DirectoryMonitor.c"
	}
}


static void directory_monitor_value_take_query_info_queue_element (GValue* value, gpointer v_object) {
	DirectoryMonitorQueryInfoQueueElement* old;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old = value->data[0].v_pointer;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (v_object) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 7783 "DirectoryMonitor.c"
	} else {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 7787 "DirectoryMonitor.c"
	}
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_query_info_queue_element_unref (old);
#line 7793 "DirectoryMonitor.c"
	}
}


static void directory_monitor_query_info_queue_element_class_init (DirectoryMonitorQueryInfoQueueElementClass * klass) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_query_info_queue_element_parent_class = g_type_class_peek_parent (klass);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorQueryInfoQueueElementClass *) klass)->finalize = directory_monitor_query_info_queue_element_finalize;
#line 7803 "DirectoryMonitor.c"
}


static void directory_monitor_query_info_queue_element_instance_init (DirectoryMonitorQueryInfoQueueElement * self) {
#line 92 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->info = NULL;
#line 93 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->err = NULL;
#line 94 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->completed = FALSE;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->ref_count = 1;
#line 7816 "DirectoryMonitor.c"
}


static void directory_monitor_query_info_queue_element_finalize (DirectoryMonitorQueryInfoQueueElement* obj) {
	DirectoryMonitorQueryInfoQueueElement * self;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, DirectoryMonitorQueryInfoQueueElement);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_handlers_destroy (self);
#line 86 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->owner);
#line 87 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->file);
#line 88 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->other_file);
#line 92 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->info);
#line 93 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_error_free0 (self->err);
#line 7836 "DirectoryMonitor.c"
}


static GType directory_monitor_query_info_queue_element_get_type (void) {
	static volatile gsize directory_monitor_query_info_queue_element_type_id__volatile = 0;
	if (g_once_init_enter (&directory_monitor_query_info_queue_element_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { directory_monitor_value_query_info_queue_element_init, directory_monitor_value_query_info_queue_element_free_value, directory_monitor_value_query_info_queue_element_copy_value, directory_monitor_value_query_info_queue_element_peek_pointer, "p", directory_monitor_value_query_info_queue_element_collect_value, "p", directory_monitor_value_query_info_queue_element_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorQueryInfoQueueElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_query_info_queue_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitorQueryInfoQueueElement), 0, (GInstanceInitFunc) directory_monitor_query_info_queue_element_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType directory_monitor_query_info_queue_element_type_id;
		directory_monitor_query_info_queue_element_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DirectoryMonitorQueryInfoQueueElement", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&directory_monitor_query_info_queue_element_type_id__volatile, directory_monitor_query_info_queue_element_type_id);
	}
	return directory_monitor_query_info_queue_element_type_id__volatile;
}


static gpointer directory_monitor_query_info_queue_element_ref (gpointer instance) {
	DirectoryMonitorQueryInfoQueueElement* self;
	self = instance;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return instance;
#line 7861 "DirectoryMonitor.c"
}


static void directory_monitor_query_info_queue_element_unref (gpointer instance) {
	DirectoryMonitorQueryInfoQueueElement* self;
	self = instance;
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		DIRECTORY_MONITOR_QUERY_INFO_QUEUE_ELEMENT_GET_CLASS (self)->finalize (self);
#line 83 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 7874 "DirectoryMonitor.c"
	}
}


static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_construct (GType object_type) {
	DirectoryMonitorFileInfoMap* self = NULL;
#line 134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = (DirectoryMonitorFileInfoMap*) g_type_create_instance (object_type);
#line 134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return self;
#line 7885 "DirectoryMonitor.c"
}


static DirectoryMonitorFileInfoMap* directory_monitor_file_info_map_new (void) {
#line 134 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return directory_monitor_file_info_map_construct (DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP);
#line 7892 "DirectoryMonitor.c"
}


static gboolean directory_monitor_file_info_map_normalize_file (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info, GFile** normalized, gchar** id) {
	GFile* _vala_normalized = NULL;
	gchar* _vala_id = NULL;
	gboolean result = FALSE;
	GFileInfo* local_info = NULL;
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	gchar* file_id = NULL;
	GFileInfo* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GFile* known_file = NULL;
	GeeHashMap* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GFile* _tmp15_ = NULL;
	GFile* _tmp16_ = NULL;
	GFile* _tmp19_ = NULL;
#line 137 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
#line 137 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 137 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((info == NULL) || G_IS_FILE_INFO (info), FALSE);
#line 140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = info;
#line 140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 140 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	local_info = _tmp1_;
#line 141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = local_info;
#line 141 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_ == NULL) {
#line 7933 "DirectoryMonitor.c"
		GeeHashMap* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = self->priv->map;
#line 142 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = file;
#line 142 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_);
#line 142 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (local_info);
#line 142 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		local_info = (GFileInfo*) _tmp5_;
#line 143 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = local_info;
#line 143 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (_tmp6_ == NULL) {
#line 144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_vala_normalized);
#line 144 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_normalized = NULL;
#line 145 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_vala_id);
#line 145 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_vala_id = NULL;
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = FALSE;
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (local_info);
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (normalized) {
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				*normalized = _vala_normalized;
#line 7968 "DirectoryMonitor.c"
			} else {
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_vala_normalized);
#line 7972 "DirectoryMonitor.c"
			}
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (id) {
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				*id = _vala_id;
#line 7978 "DirectoryMonitor.c"
			} else {
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (_vala_id);
#line 7982 "DirectoryMonitor.c"
			}
#line 147 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 7986 "DirectoryMonitor.c"
		}
	}
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = local_info;
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = get_file_info_id (_tmp7_);
#line 151 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	file_id = _tmp8_;
#line 152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = file_id;
#line 152 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp9_ == NULL) {
#line 153 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_normalized);
#line 153 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_normalized = NULL;
#line 154 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_vala_id);
#line 154 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_id = NULL;
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (file_id);
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (local_info);
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (normalized) {
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			*normalized = _vala_normalized;
#line 8017 "DirectoryMonitor.c"
		} else {
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_vala_normalized);
#line 8021 "DirectoryMonitor.c"
		}
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (id) {
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			*id = _vala_id;
#line 8027 "DirectoryMonitor.c"
		} else {
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_vala_id);
#line 8031 "DirectoryMonitor.c"
		}
#line 156 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8035 "DirectoryMonitor.c"
	}
#line 159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = self->priv->id_map;
#line 159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp11_ = file_id;
#line 159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp12_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_);
#line 159 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	known_file = (GFile*) _tmp12_;
#line 161 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = file_id;
#line 161 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = g_strdup ((const gchar*) _tmp13_);
#line 161 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (_vala_id);
#line 161 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_id = _tmp14_;
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = known_file;
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp16_ != NULL) {
#line 8057 "DirectoryMonitor.c"
		GFile* _tmp17_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp17_ = known_file;
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = _tmp17_;
#line 8063 "DirectoryMonitor.c"
	} else {
		GFile* _tmp18_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp18_ = file;
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = _tmp18_;
#line 8070 "DirectoryMonitor.c"
	}
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = _g_object_ref0 (_tmp15_);
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (_vala_normalized);
#line 162 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_vala_normalized = _tmp19_;
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (known_file);
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (file_id);
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (local_info);
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (normalized) {
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*normalized = _vala_normalized;
#line 8090 "DirectoryMonitor.c"
	} else {
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_vala_normalized);
#line 8094 "DirectoryMonitor.c"
	}
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (id) {
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*id = _vala_id;
#line 8100 "DirectoryMonitor.c"
	} else {
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_vala_id);
#line 8104 "DirectoryMonitor.c"
	}
#line 164 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8108 "DirectoryMonitor.c"
}


static gboolean directory_monitor_file_info_map_update (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* existing_id = NULL;
	GFileInfo* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp18_ = NULL;
	GFileInfo* _tmp19_ = NULL;
	GFile* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GeeHashMap* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	GFileInfo* _tmp25_ = NULL;
	GeeHashMap* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
#line 167 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 167 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->map;
#line 169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 169 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_) {
#line 8149 "DirectoryMonitor.c"
		gboolean removed = FALSE;
		GeeHashMap* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = self->priv->map;
#line 170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = file;
#line 170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp4_, NULL);
#line 170 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		removed = _tmp5_;
#line 171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = removed;
#line 171 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_assert (_tmp6_, "removed");
#line 8167 "DirectoryMonitor.c"
	}
#line 175 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = info;
#line 175 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = get_file_info_id (_tmp7_);
#line 175 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	existing_id = _tmp8_;
#line 176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = existing_id;
#line 176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp10_ != NULL) {
#line 8179 "DirectoryMonitor.c"
		GeeHashMap* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = self->priv->id_map;
#line 176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = existing_id;
#line 176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp13_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp12_);
#line 176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp13_;
#line 8191 "DirectoryMonitor.c"
	} else {
#line 176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = FALSE;
#line 8195 "DirectoryMonitor.c"
	}
#line 176 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp9_) {
#line 8199 "DirectoryMonitor.c"
		gboolean removed = FALSE;
		GeeHashMap* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
#line 177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp14_ = self->priv->id_map;
#line 177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp15_ = existing_id;
#line 177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp16_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_, NULL);
#line 177 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		removed = _tmp16_;
#line 178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp17_ = removed;
#line 178 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_vala_assert (_tmp17_, "removed");
#line 8217 "DirectoryMonitor.c"
	}
#line 183 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp18_ = file;
#line 183 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = info;
#line 183 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp22_ = directory_monitor_file_info_map_normalize_file (self, _tmp18_, _tmp19_, &_tmp20_, &_tmp21_);
#line 183 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 183 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp20_;
#line 183 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 183 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp21_;
#line 183 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp22_) {
#line 184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (existing_id);
#line 184 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8245 "DirectoryMonitor.c"
	}
#line 186 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp23_ = self->priv->map;
#line 186 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp24_ = normalized;
#line 186 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp25_ = info;
#line 186 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_, _tmp25_);
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp26_ = self->priv->id_map;
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp27_ = id;
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp28_ = normalized;
#line 187 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp27_, _tmp28_);
#line 189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (existing_id);
#line 189 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8273 "DirectoryMonitor.c"
}


static gboolean directory_monitor_file_info_map_remove (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
#line 192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 192 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((info == NULL) || G_IS_FILE_INFO (info), FALSE);
#line 195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_file_info_map_normalize_file (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp2_;
#line 195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp3_;
#line 195 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp4_) {
#line 196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 196 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8320 "DirectoryMonitor.c"
	}
#line 198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = self->priv->map;
#line 198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = normalized;
#line 198 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_, NULL);
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = self->priv->id_map;
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = id;
#line 199 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, NULL);
#line 201 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = TRUE;
#line 201 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 201 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 201 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8342 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_remove_all (DirectoryMonitorFileInfoMap* self, GeeCollection* files) {
#line 206 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self));
#line 206 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (GEE_IS_COLLECTION (files));
#line 8351 "DirectoryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = files;
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_file_it = _tmp1_;
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 8364 "DirectoryMonitor.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp2_ = _file_it;
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp3_) {
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 8379 "DirectoryMonitor.c"
			}
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp4_ = _file_it;
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			file = (GFile*) _tmp5_;
#line 208 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = file;
#line 208 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			directory_monitor_file_info_map_remove (self, _tmp6_, NULL);
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (file);
#line 8393 "DirectoryMonitor.c"
		}
#line 207 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 8397 "DirectoryMonitor.c"
	}
}


static gboolean directory_monitor_file_info_map_contains (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), FALSE);
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 211 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((info == NULL) || G_IS_FILE_INFO (info), FALSE);
#line 214 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 214 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = info;
#line 214 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = directory_monitor_file_info_map_normalize_file (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 214 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 214 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp2_;
#line 214 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 214 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp3_;
#line 214 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp4_) {
#line 215 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = FALSE;
#line 215 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 215 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 215 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8444 "DirectoryMonitor.c"
	}
#line 217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = self->priv->id_map;
#line 217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = id;
#line 217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_);
#line 217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = _tmp7_;
#line 217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 217 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8460 "DirectoryMonitor.c"
}


static gchar* directory_monitor_file_info_map_get_id (DirectoryMonitorFileInfoMap* self, GFile* file, GFileInfo* info) {
	gchar* result = NULL;
	GFileInfo* _tmp0_ = NULL;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 220 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 220 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 220 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((info == NULL) || G_IS_FILE_INFO (info), NULL);
#line 222 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = info;
#line 222 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp0_ != NULL) {
#line 8483 "DirectoryMonitor.c"
		GFileInfo* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = info;
#line 223 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = get_file_info_id (_tmp1_);
#line 223 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = _tmp2_;
#line 223 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8494 "DirectoryMonitor.c"
	}
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = file;
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp6_ = directory_monitor_file_info_map_normalize_file (self, _tmp3_, NULL, &_tmp4_, &_tmp5_);
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp4_;
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp5_;
#line 227 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp6_) {
#line 228 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 228 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 228 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 228 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8518 "DirectoryMonitor.c"
	}
#line 230 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = id;
#line 230 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 230 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8526 "DirectoryMonitor.c"
}


static GeeCollection* directory_monitor_file_info_map_get_all (DirectoryMonitorFileInfoMap* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _tmp2_ = NULL;
#line 233 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 234 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->map;
#line 234 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 234 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = _tmp1_;
#line 234 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 234 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8547 "DirectoryMonitor.c"
}


static GFileInfo* directory_monitor_file_info_map_get_info (DirectoryMonitorFileInfoMap* self, GFile* file) {
	GFileInfo* result = NULL;
	GFileInfo* info = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	gchar* id = NULL;
	GFile* normalized = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GeeHashMap* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 237 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = self->priv->map;
#line 239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = file;
#line 239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 239 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	info = (GFileInfo*) _tmp2_;
#line 240 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = info;
#line 240 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp3_ != NULL) {
#line 241 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = info;
#line 241 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8587 "DirectoryMonitor.c"
	}
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = file;
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp7_ = directory_monitor_file_info_map_normalize_file (self, _tmp4_, NULL, &_tmp5_, &_tmp6_);
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = _tmp5_;
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp6_;
#line 245 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp7_) {
#line 246 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 246 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 246 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 246 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 246 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8613 "DirectoryMonitor.c"
	}
#line 248 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp8_ = self->priv->map;
#line 248 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp9_ = normalized;
#line 248 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp10_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_);
#line 248 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = (GFileInfo*) _tmp10_;
#line 248 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 248 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 248 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (info);
#line 248 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8631 "DirectoryMonitor.c"
}


static GFileInfo* directory_monitor_file_info_map_query_info (DirectoryMonitorFileInfoMap* self, GFile* file, GCancellable* cancellable) {
	GFileInfo* result = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFileInfo* _tmp2_ = NULL;
	GFileInfo* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gchar* id = NULL;
	GFileInfo* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GFile* normalized = NULL;
	GeeHashMap* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gpointer _tmp21_ = NULL;
	GFile* _tmp22_ = NULL;
	GeeHashMap* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	gpointer _tmp25_ = NULL;
	GError * _inner_error_ = NULL;
#line 251 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 251 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 251 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable), NULL);
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = file;
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = directory_monitor_file_info_map_get_info (self, _tmp0_);
#line 252 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	info = _tmp1_;
#line 253 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = info;
#line 253 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_ != NULL) {
#line 254 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = info;
#line 254 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8677 "DirectoryMonitor.c"
	}
	{
		GFileInfo* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GCancellable* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
		GFileInfo* _tmp7_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = file;
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = cancellable;
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp6_ = g_file_query_info (_tmp4_, G_FILE_ATTRIBUTE_ID_FILE, DIRECTORY_MONITOR_UNKNOWN_INFO_FLAGS, _tmp5_, &_inner_error_);
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = _tmp6_;
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8695 "DirectoryMonitor.c"
			goto __catch484_g_error;
		}
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = _tmp3_;
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 259 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		info = _tmp7_;
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 8708 "DirectoryMonitor.c"
	}
	goto __finally484;
	__catch484_g_error:
	{
		GError* err = NULL;
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		err = _inner_error_;
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_inner_error_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = file;
#line 261 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 261 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = _tmp9_;
#line 261 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = err;
#line 261 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = _tmp11_->message;
#line 261 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_warning ("DirectoryMonitor.vala:261: Unable to query file ID of %s: %s", _tmp10_, _tmp12_);
#line 261 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (_tmp10_);
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_error_free0 (err);
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 263 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8745 "DirectoryMonitor.c"
	}
	__finally484:
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_clear_error (&_inner_error_);
#line 258 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return NULL;
#line 8758 "DirectoryMonitor.c"
	}
#line 266 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp13_ = info;
#line 266 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp14_ = directory_monitor_is_file_symlink_supported (_tmp13_);
#line 266 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!_tmp14_) {
#line 267 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 267 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 267 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8772 "DirectoryMonitor.c"
	}
#line 269 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp15_ = info;
#line 269 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp16_ = g_file_info_get_attribute_string (_tmp15_, G_FILE_ATTRIBUTE_ID_FILE);
#line 269 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 269 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	id = _tmp17_;
#line 270 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp18_ = id;
#line 270 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp18_ == NULL) {
#line 271 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 271 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 271 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 271 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8794 "DirectoryMonitor.c"
	}
#line 273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp19_ = self->priv->id_map;
#line 273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp20_ = id;
#line 273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp21_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp20_);
#line 273 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	normalized = (GFile*) _tmp21_;
#line 274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp22_ = normalized;
#line 274 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp22_ == NULL) {
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (normalized);
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (id);
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (info);
#line 275 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8818 "DirectoryMonitor.c"
	}
#line 277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp23_ = self->priv->map;
#line 277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp24_ = file;
#line 277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp25_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_);
#line 277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = (GFileInfo*) _tmp25_;
#line 277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (normalized);
#line 277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (id);
#line 277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (info);
#line 277 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 8836 "DirectoryMonitor.c"
}


static GFile* directory_monitor_file_info_map_find_match (DirectoryMonitorFileInfoMap* self, GFileInfo* match) {
	GFile* result = NULL;
	gchar* match_id = NULL;
	GFileInfo* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint64 match_size = 0LL;
	GFileInfo* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	GTimeVal match_time = {0};
	GFileInfo* _tmp5_ = NULL;
	GTimeVal _tmp6_ = {0};
#line 280 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), NULL);
#line 280 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (match), NULL);
#line 281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = match;
#line 281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = get_file_info_id (_tmp0_);
#line 281 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	match_id = _tmp1_;
#line 282 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = match_id;
#line 282 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp2_ == NULL) {
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		result = NULL;
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_free0 (match_id);
#line 283 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return result;
#line 8872 "DirectoryMonitor.c"
	}
#line 286 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = match;
#line 286 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_file_info_get_size (_tmp3_);
#line 286 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	match_size = _tmp4_;
#line 287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp5_ = match;
#line 287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_file_info_get_modification_time (_tmp5_, &_tmp6_);
#line 287 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	match_time = _tmp6_;
#line 8886 "DirectoryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp7_ = NULL;
		GeeSet* _tmp8_ = NULL;
		GeeSet* _tmp9_ = NULL;
		GeeSet* _tmp10_ = NULL;
		GeeIterator* _tmp11_ = NULL;
		GeeIterator* _tmp12_ = NULL;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp7_ = self->priv->map;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp8_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp9_ = _tmp8_;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp10_ = _tmp9_;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp11_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ITERABLE, GeeIterable));
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp12_ = _tmp11_;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp10_);
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_file_it = _tmp12_;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 8913 "DirectoryMonitor.c"
			GeeIterator* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp15_ = NULL;
			gpointer _tmp16_ = NULL;
			GFileInfo* info = NULL;
			GeeHashMap* _tmp17_ = NULL;
			GFile* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			GFileInfo* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			gint64 _tmp25_ = 0LL;
			GFileInfo* _tmp26_ = NULL;
			gint64 _tmp27_ = 0LL;
			GTimeVal time = {0};
			GFileInfo* _tmp28_ = NULL;
			GTimeVal _tmp29_ = {0};
			GTimeVal _tmp30_ = {0};
			glong _tmp31_ = 0L;
			GTimeVal _tmp32_ = {0};
			glong _tmp33_ = 0L;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp13_ = _file_it;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp14_ = gee_iterator_next (_tmp13_);
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp14_) {
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 8946 "DirectoryMonitor.c"
			}
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp15_ = _file_it;
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp16_ = gee_iterator_get (_tmp15_);
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			file = (GFile*) _tmp16_;
#line 290 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp17_ = self->priv->map;
#line 290 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp18_ = file;
#line 290 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp19_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp18_);
#line 290 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			info = (GFileInfo*) _tmp19_;
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp20_ = info;
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp21_ = get_file_info_id (_tmp20_);
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp22_ = _tmp21_;
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp23_ = match_id;
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp24_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (_tmp22_);
#line 293 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp24_) {
#line 294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				result = file;
#line 294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (info);
#line 294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (_file_it);
#line 294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_free0 (match_id);
#line 294 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				return result;
#line 8986 "DirectoryMonitor.c"
			}
#line 297 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp25_ = match_size;
#line 297 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp26_ = info;
#line 297 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp27_ = g_file_info_get_size (_tmp26_);
#line 297 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp25_ != _tmp27_) {
#line 298 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (info);
#line 298 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (file);
#line 298 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 9002 "DirectoryMonitor.c"
			}
#line 300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp28_ = info;
#line 300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			g_file_info_get_modification_time (_tmp28_, &_tmp29_);
#line 300 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			time = _tmp29_;
#line 302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp30_ = time;
#line 302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp31_ = _tmp30_.tv_sec;
#line 302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp32_ = match_time;
#line 302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp33_ = _tmp32_.tv_sec;
#line 302 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp31_ != _tmp33_) {
#line 303 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (info);
#line 303 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (file);
#line 303 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 9026 "DirectoryMonitor.c"
			}
#line 305 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			result = file;
#line 305 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (info);
#line 305 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_file_it);
#line 305 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_free0 (match_id);
#line 305 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return result;
#line 9038 "DirectoryMonitor.c"
		}
#line 289 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 9042 "DirectoryMonitor.c"
	}
#line 308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = NULL;
#line 308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_free0 (match_id);
#line 308 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 9050 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_remove_descendents (DirectoryMonitorFileInfoMap* self, GFile* root, DirectoryMonitorFileInfoMap* descendents) {
	GeeArrayList* pruned = NULL;
	GeeArrayList* _tmp28_ = NULL;
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self));
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_IS_FILE (root));
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (descendents));
#line 312 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	pruned = NULL;
#line 9065 "DirectoryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = self->priv->map;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = _tmp1_;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = _tmp2_;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = _tmp4_;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_file_it = _tmp5_;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 9092 "DirectoryMonitor.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			GFile* parent = NULL;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = _file_it;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp7_) {
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 9109 "DirectoryMonitor.c"
			}
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp8_ = _file_it;
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			file = (GFile*) _tmp9_;
#line 314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = file;
#line 314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = g_file_get_parent (_tmp10_);
#line 314 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			parent = _tmp11_;
#line 315 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			while (TRUE) {
#line 9125 "DirectoryMonitor.c"
				GFile* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
				GFile* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				GFile* _tmp26_ = NULL;
				GFile* _tmp27_ = NULL;
#line 315 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp12_ = parent;
#line 315 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (!(_tmp12_ != NULL)) {
#line 315 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9138 "DirectoryMonitor.c"
				}
#line 316 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp13_ = parent;
#line 316 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp14_ = root;
#line 316 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp15_ = g_file_equal (_tmp13_, _tmp14_);
#line 316 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				if (_tmp15_) {
#line 9148 "DirectoryMonitor.c"
					GeeArrayList* _tmp16_ = NULL;
					GeeArrayList* _tmp18_ = NULL;
					GFile* _tmp19_ = NULL;
					DirectoryMonitorFileInfoMap* _tmp20_ = NULL;
					GFile* _tmp21_ = NULL;
					GeeHashMap* _tmp22_ = NULL;
					GFile* _tmp23_ = NULL;
					gpointer _tmp24_ = NULL;
					GFileInfo* _tmp25_ = NULL;
#line 317 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp16_ = pruned;
#line 317 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					if (_tmp16_ == NULL) {
#line 9162 "DirectoryMonitor.c"
						GeeArrayList* _tmp17_ = NULL;
#line 318 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_tmp17_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 318 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						_g_object_unref0 (pruned);
#line 318 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
						pruned = _tmp17_;
#line 9170 "DirectoryMonitor.c"
					}
#line 320 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp18_ = pruned;
#line 320 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp19_ = file;
#line 320 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp19_);
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp20_ = descendents;
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp21_ = file;
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp22_ = self->priv->map;
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp23_ = file;
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp24_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp23_);
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp25_ = (GFileInfo*) _tmp24_;
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					directory_monitor_file_info_map_update (_tmp20_, _tmp21_, _tmp25_);
#line 321 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_g_object_unref0 (_tmp25_);
#line 323 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9196 "DirectoryMonitor.c"
				}
#line 326 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp26_ = parent;
#line 326 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp27_ = g_file_get_parent (_tmp26_);
#line 326 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (parent);
#line 326 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				parent = _tmp27_;
#line 9206 "DirectoryMonitor.c"
			}
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (parent);
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (file);
#line 9212 "DirectoryMonitor.c"
		}
#line 313 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 9216 "DirectoryMonitor.c"
	}
#line 330 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp28_ = pruned;
#line 330 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (_tmp28_ != NULL) {
#line 9222 "DirectoryMonitor.c"
		GeeArrayList* _tmp29_ = NULL;
#line 331 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp29_ = pruned;
#line 331 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_remove_all (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection));
#line 9228 "DirectoryMonitor.c"
	}
#line 311 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (pruned);
#line 9232 "DirectoryMonitor.c"
}


static gint directory_monitor_file_info_map_get_children (DirectoryMonitorFileInfoMap* self, GFile* root, GeeCollection* files, GeeCollection* dirs) {
	gint result = 0;
	gint count = 0;
#line 336 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (DIRECTORY_MONITOR_IS_FILE_INFO_MAP (self), 0);
#line 336 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_IS_FILE (root), 0);
#line 336 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (files), 0);
#line 336 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (dirs), 0);
#line 337 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	count = 0;
#line 9249 "DirectoryMonitor.c"
	{
		GeeIterator* _file_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp0_ = self->priv->map;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp2_ = _tmp1_;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp3_ = _tmp2_;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_tmp5_ = _tmp4_;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_tmp3_);
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_file_it = _tmp5_;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		while (TRUE) {
#line 9276 "DirectoryMonitor.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GFile* file = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			GFile* parent = NULL;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			GFile* _tmp13_ = NULL;
			DirectoryMonitorFType ftype = 0;
			GeeHashMap* _tmp17_ = NULL;
			GFile* _tmp18_ = NULL;
			gpointer _tmp19_ = NULL;
			GFileInfo* _tmp20_ = NULL;
			DirectoryMonitorFType _tmp21_ = 0;
			DirectoryMonitorFType _tmp22_ = 0;
			DirectoryMonitorFType _tmp23_ = 0;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp6_ = _file_it;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (!_tmp7_) {
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				break;
#line 9303 "DirectoryMonitor.c"
			}
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp8_ = _file_it;
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			file = (GFile*) _tmp9_;
#line 339 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp10_ = file;
#line 339 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp11_ = g_file_get_parent (_tmp10_);
#line 339 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			parent = _tmp11_;
#line 340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp13_ = parent;
#line 340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp13_ == NULL) {
#line 340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp12_ = TRUE;
#line 9323 "DirectoryMonitor.c"
			} else {
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp14_ = parent;
#line 340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp15_ = root;
#line 340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp16_ = g_file_equal (_tmp14_, _tmp15_);
#line 340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_tmp12_ = !_tmp16_;
#line 9336 "DirectoryMonitor.c"
			}
#line 340 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			if (_tmp12_) {
#line 341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (parent);
#line 341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				_g_object_unref0 (file);
#line 341 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				continue;
#line 9346 "DirectoryMonitor.c"
			}
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp17_ = self->priv->map;
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp18_ = file;
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp19_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp18_);
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp20_ = (GFileInfo*) _tmp19_;
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp21_ = directory_monitor_get_ftype (_tmp20_);
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp22_ = _tmp21_;
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (_tmp20_);
#line 343 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			ftype = _tmp22_;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_tmp23_ = ftype;
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			switch (_tmp23_) {
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_FILE:
#line 9370 "DirectoryMonitor.c"
				{
					GeeCollection* _tmp24_ = NULL;
					GFile* _tmp25_ = NULL;
					gint _tmp26_ = 0;
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp24_ = files;
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp25_ = file;
#line 346 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					gee_collection_add (_tmp24_, _tmp25_);
#line 347 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp26_ = count;
#line 347 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					count = _tmp26_ + 1;
#line 348 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9387 "DirectoryMonitor.c"
				}
#line 344 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
				case DIRECTORY_MONITOR_FTYPE_DIRECTORY:
#line 9391 "DirectoryMonitor.c"
				{
					GeeCollection* _tmp27_ = NULL;
					GFile* _tmp28_ = NULL;
					gint _tmp29_ = 0;
#line 351 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp27_ = dirs;
#line 351 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp28_ = file;
#line 351 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					gee_collection_add (_tmp27_, _tmp28_);
#line 352 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp29_ = count;
#line 352 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					count = _tmp29_ + 1;
#line 353 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9408 "DirectoryMonitor.c"
				}
				default:
				{
					DirectoryMonitorFType _tmp30_ = 0;
#line 356 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_tmp30_ = ftype;
#line 356 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					_vala_assert (_tmp30_ == DIRECTORY_MONITOR_FTYPE_UNSUPPORTED, "ftype == FType.UNSUPPORTED");
#line 357 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
					break;
#line 9419 "DirectoryMonitor.c"
				}
			}
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (parent);
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			_g_object_unref0 (file);
#line 9426 "DirectoryMonitor.c"
		}
#line 338 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		_g_object_unref0 (_file_it);
#line 9430 "DirectoryMonitor.c"
	}
#line 361 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	result = count;
#line 361 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return result;
#line 9436 "DirectoryMonitor.c"
}


static void directory_monitor_value_file_info_map_init (GValue* value) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	value->data[0].v_pointer = NULL;
#line 9443 "DirectoryMonitor.c"
}


static void directory_monitor_value_file_info_map_free_value (GValue* value) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (value->data[0].v_pointer) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_unref (value->data[0].v_pointer);
#line 9452 "DirectoryMonitor.c"
	}
}


static void directory_monitor_value_file_info_map_copy_value (const GValue* src_value, GValue* dest_value) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (src_value->data[0].v_pointer) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		dest_value->data[0].v_pointer = directory_monitor_file_info_map_ref (src_value->data[0].v_pointer);
#line 9462 "DirectoryMonitor.c"
	} else {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		dest_value->data[0].v_pointer = NULL;
#line 9466 "DirectoryMonitor.c"
	}
}


static gpointer directory_monitor_value_file_info_map_peek_pointer (const GValue* value) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return value->data[0].v_pointer;
#line 9474 "DirectoryMonitor.c"
}


static gchar* directory_monitor_value_file_info_map_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (collect_values[0].v_pointer) {
#line 9481 "DirectoryMonitor.c"
		DirectoryMonitorFileInfoMap* object;
		object = collect_values[0].v_pointer;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		if (object->parent_instance.g_class == NULL) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9488 "DirectoryMonitor.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9492 "DirectoryMonitor.c"
		}
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = directory_monitor_file_info_map_ref (object);
#line 9496 "DirectoryMonitor.c"
	} else {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 9500 "DirectoryMonitor.c"
	}
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return NULL;
#line 9504 "DirectoryMonitor.c"
}


static gchar* directory_monitor_value_file_info_map_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DirectoryMonitorFileInfoMap** object_p;
	object_p = collect_values[0].v_pointer;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!object_p) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 9515 "DirectoryMonitor.c"
	}
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (!value->data[0].v_pointer) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = NULL;
#line 9521 "DirectoryMonitor.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = value->data[0].v_pointer;
#line 9525 "DirectoryMonitor.c"
	} else {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		*object_p = directory_monitor_file_info_map_ref (value->data[0].v_pointer);
#line 9529 "DirectoryMonitor.c"
	}
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return NULL;
#line 9533 "DirectoryMonitor.c"
}


static GParamSpec* directory_monitor_param_spec_file_info_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	DirectoryMonitorParamSpecFileInfoMap* spec;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (g_type_is_a (object_type, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP), NULL);
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return G_PARAM_SPEC (spec);
#line 9547 "DirectoryMonitor.c"
}


static gpointer directory_monitor_value_get_file_info_map (const GValue* value) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP), NULL);
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return value->data[0].v_pointer;
#line 9556 "DirectoryMonitor.c"
}


static void directory_monitor_value_set_file_info_map (GValue* value, gpointer v_object) {
	DirectoryMonitorFileInfoMap* old;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old = value->data[0].v_pointer;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (v_object) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_ref (value->data[0].v_pointer);
#line 9576 "DirectoryMonitor.c"
	} else {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 9580 "DirectoryMonitor.c"
	}
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_unref (old);
#line 9586 "DirectoryMonitor.c"
	}
}


static void directory_monitor_value_take_file_info_map (GValue* value, gpointer v_object) {
	DirectoryMonitorFileInfoMap* old;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	old = value->data[0].v_pointer;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (v_object) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP));
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = v_object;
#line 9605 "DirectoryMonitor.c"
	} else {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		value->data[0].v_pointer = NULL;
#line 9609 "DirectoryMonitor.c"
	}
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (old) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		directory_monitor_file_info_map_unref (old);
#line 9615 "DirectoryMonitor.c"
	}
}


static void directory_monitor_file_info_map_class_init (DirectoryMonitorFileInfoMapClass * klass) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_file_info_map_parent_class = g_type_class_peek_parent (klass);
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorFileInfoMapClass *) klass)->finalize = directory_monitor_file_info_map_finalize;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_type_class_add_private (klass, sizeof (DirectoryMonitorFileInfoMapPrivate));
#line 9627 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_instance_init (DirectoryMonitorFileInfoMap * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv = DIRECTORY_MONITOR_FILE_INFO_MAP_GET_PRIVATE (self);
#line 129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
#line 129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->map = _tmp0_;
#line 131 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
#line 131 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->id_map = _tmp1_;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->ref_count = 1;
#line 9646 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_finalize (DirectoryMonitorFileInfoMap* obj) {
	DirectoryMonitorFileInfoMap * self;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DIRECTORY_MONITOR_TYPE_FILE_INFO_MAP, DirectoryMonitorFileInfoMap);
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_handlers_destroy (self);
#line 129 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->map);
#line 131 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->id_map);
#line 9660 "DirectoryMonitor.c"
}


static GType directory_monitor_file_info_map_get_type (void) {
	static volatile gsize directory_monitor_file_info_map_type_id__volatile = 0;
	if (g_once_init_enter (&directory_monitor_file_info_map_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { directory_monitor_value_file_info_map_init, directory_monitor_value_file_info_map_free_value, directory_monitor_value_file_info_map_copy_value, directory_monitor_value_file_info_map_peek_pointer, "p", directory_monitor_value_file_info_map_collect_value, "p", directory_monitor_value_file_info_map_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorFileInfoMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_file_info_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitorFileInfoMap), 0, (GInstanceInitFunc) directory_monitor_file_info_map_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType directory_monitor_file_info_map_type_id;
		directory_monitor_file_info_map_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DirectoryMonitorFileInfoMap", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&directory_monitor_file_info_map_type_id__volatile, directory_monitor_file_info_map_type_id);
	}
	return directory_monitor_file_info_map_type_id__volatile;
}


static gpointer directory_monitor_file_info_map_ref (gpointer instance) {
	DirectoryMonitorFileInfoMap* self;
	self = instance;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_atomic_int_inc (&self->ref_count);
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	return instance;
#line 9685 "DirectoryMonitor.c"
}


static void directory_monitor_file_info_map_unref (gpointer instance) {
	DirectoryMonitorFileInfoMap* self;
	self = instance;
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		DIRECTORY_MONITOR_FILE_INFO_MAP_GET_CLASS (self)->finalize (self);
#line 128 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 9698 "DirectoryMonitor.c"
	}
}


static void directory_monitor_class_init (DirectoryMonitorClass * klass) {
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	directory_monitor_parent_class = g_type_class_peek_parent (klass);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_type_class_add_private (klass, sizeof (DirectoryMonitorPrivate));
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_root_deleted = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_root_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_root_moved = (void (*)(DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_root_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_discovery_started = (void (*)(DirectoryMonitor*)) directory_monitor_real_notify_discovery_started;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->internal_notify_file_discovered = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_internal_notify_file_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_discovered = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->internal_notify_directory_discovered = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_internal_notify_directory_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_discovered = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_discovery_failed = (void (*)(DirectoryMonitor*, const gchar*)) directory_monitor_real_notify_discovery_failed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_discovery_completed = (void (*)(DirectoryMonitor*)) directory_monitor_real_notify_discovery_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_created = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_created;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_moved = (void (*)(DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_altered = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_alteration_completed = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_file_alteration_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_attributes_altered = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_attributes_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_file_deleted = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_file_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_created = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_created;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_moved = (void (*)(DirectoryMonitor*, GFile*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_altered = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_alteration_completed = (void (*)(DirectoryMonitor*, GFile*, GFileInfo*)) directory_monitor_real_notify_directory_alteration_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_attributes_altered = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_attributes_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_directory_deleted = (void (*)(DirectoryMonitor*, GFile*)) directory_monitor_real_notify_directory_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->notify_closed = (void (*)(DirectoryMonitor*)) directory_monitor_real_notify_closed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->close = (void (*)(DirectoryMonitor*)) directory_monitor_real_close;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->root_moved = directory_monitor_real_root_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->root_deleted = directory_monitor_real_root_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->discovery_started = directory_monitor_real_discovery_started;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_discovered = directory_monitor_real_file_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_discovered = directory_monitor_real_directory_discovered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->discovery_failed = directory_monitor_real_discovery_failed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->discovery_completed = directory_monitor_real_discovery_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_created = directory_monitor_real_file_created;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_moved = directory_monitor_real_file_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_altered = directory_monitor_real_file_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_alteration_completed = directory_monitor_real_file_alteration_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_attributes_altered = directory_monitor_real_file_attributes_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->file_deleted = directory_monitor_real_file_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_created = directory_monitor_real_directory_created;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_moved = directory_monitor_real_directory_moved;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_altered = directory_monitor_real_directory_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_alteration_completed = directory_monitor_real_directory_alteration_completed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_attributes_altered = directory_monitor_real_directory_attributes_altered;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->directory_deleted = directory_monitor_real_directory_deleted;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	((DirectoryMonitorClass *) klass)->closed = directory_monitor_real_closed;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	G_OBJECT_CLASS (klass)->finalize = directory_monitor_finalize;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("root_moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, root_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("root_deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, root_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("discovery_started", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_started), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_discovered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_discovered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_discovered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_discovered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("discovery_failed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_failed), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("discovery_completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, discovery_completed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_created", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_created), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_alteration_completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_alteration_completed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_attributes_altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_attributes_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("file_deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, file_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_created", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_created), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_moved", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_moved), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_OBJECT, G_TYPE_NONE, 3, g_file_get_type (), g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_alteration_completed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_alteration_completed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_info_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_attributes_altered", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_attributes_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("directory_deleted", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, directory_deleted), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	g_signal_new ("closed", TYPE_DIRECTORY_MONITOR, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DirectoryMonitorClass, closed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 9836 "DirectoryMonitor.c"
}


static void directory_monitor_instance_init (DirectoryMonitor * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	DirectoryMonitorFileInfoMap* _tmp2_ = NULL;
	DirectoryMonitorFileInfoMap* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv = DIRECTORY_MONITOR_GET_PRIVATE (self);
#line 368 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 368 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->monitors = _tmp0_;
#line 369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp1_ = gee_linked_list_new (DIRECTORY_MONITOR_TYPE_QUERY_INFO_QUEUE_ELEMENT, (GBoxedCopyFunc) directory_monitor_query_info_queue_element_ref, (GDestroyNotify) directory_monitor_query_info_queue_element_unref, NULL, NULL, NULL);
#line 369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->query_info_queue = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_QUEUE, GeeQueue);
#line 371 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp2_ = directory_monitor_file_info_map_new ();
#line 371 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->files = _tmp2_;
#line 372 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp3_ = directory_monitor_file_info_map_new ();
#line 372 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->parent_moved = _tmp3_;
#line 373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_tmp4_ = g_cancellable_new ();
#line 373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->cancellable = _tmp4_;
#line 374 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->outstanding_exploration_dirs = 0;
#line 375 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->started = FALSE;
#line 376 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->has_discovery_started = FALSE;
#line 377 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self->priv->delete_timer_id = (guint) 0;
#line 9876 "DirectoryMonitor.c"
}


static void directory_monitor_finalize (GObject* obj) {
	DirectoryMonitor * self;
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECTORY_MONITOR, DirectoryMonitor);
#line 365 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->root);
#line 368 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->monitors);
#line 369 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->query_info_queue);
#line 371 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_directory_monitor_file_info_map_unref0 (self->priv->files);
#line 372 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_directory_monitor_file_info_map_unref0 (self->priv->parent_moved);
#line 373 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 60 "/home/jens/Source/shotwell/src/DirectoryMonitor.vala"
	G_OBJECT_CLASS (directory_monitor_parent_class)->finalize (obj);
#line 9898 "DirectoryMonitor.c"
}


GType directory_monitor_get_type (void) {
	static volatile gsize directory_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&directory_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DirectoryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DirectoryMonitor), 0, (GInstanceInitFunc) directory_monitor_instance_init, NULL };
		GType directory_monitor_type_id;
		directory_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "DirectoryMonitor", &g_define_type_info, 0);
		g_once_init_leave (&directory_monitor_type_id__volatile, directory_monitor_type_id);
	}
	return directory_monitor_type_id__volatile;
}



