/* GPhoto.c generated by valac 0.34.4, the Vala compiler
 * generated from GPhoto.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gphoto2/gphoto2-context.h>
#include <gphoto.h>
#include <gphoto2/gphoto2-camera.h>
#include <gphoto2/gphoto2-filesys.h>
#include <gphoto2/gphoto2-result.h>
#include <gphoto2/gphoto2-port-result.h>
#include <gphoto2/gphoto2-port-info-list.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gphoto2/gphoto2-file.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define GP_TYPE_CONTEXT_WRAPPER (gp_context_wrapper_get_type ())
#define GP_CONTEXT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper))
#define GP_CONTEXT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapperClass))
#define GP_IS_CONTEXT_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GP_TYPE_CONTEXT_WRAPPER))
#define GP_IS_CONTEXT_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GP_TYPE_CONTEXT_WRAPPER))
#define GP_CONTEXT_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GP_TYPE_CONTEXT_WRAPPER, GPContextWrapperClass))

typedef struct _GPContextWrapper GPContextWrapper;
typedef struct _GPContextWrapperClass GPContextWrapperClass;
typedef struct _GPContextWrapperPrivate GPContextWrapperPrivate;
#define _gp_context_unref0(var) ((var == NULL) ? NULL : (var = (gp_context_unref (var), NULL)))
typedef struct _GPParamSpecContextWrapper GPParamSpecContextWrapper;

#define GP_TYPE_SPIN_IDLE_WRAPPER (gp_spin_idle_wrapper_get_type ())
#define GP_SPIN_IDLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper))
#define GP_SPIN_IDLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapperClass))
#define GP_IS_SPIN_IDLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GP_TYPE_SPIN_IDLE_WRAPPER))
#define GP_IS_SPIN_IDLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GP_TYPE_SPIN_IDLE_WRAPPER))
#define GP_SPIN_IDLE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapperClass))

typedef struct _GPSpinIdleWrapper GPSpinIdleWrapper;
typedef struct _GPSpinIdleWrapperClass GPSpinIdleWrapperClass;
typedef struct _GPSpinIdleWrapperPrivate GPSpinIdleWrapperPrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))

#define JPEG_TYPE_MARKER (jpeg_marker_get_type ())
#define _gp_file_unref0(var) ((var == NULL) ? NULL : (var = (gp_file_unref (var), NULL)))

typedef enum  {
	GPHOTO_ERROR_LIBRARY
} GPhotoError;
#define GPHOTO_ERROR gphoto_error_quark ()
struct _GPContextWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPContextWrapperPrivate * priv;
	GPContext* context;
};

struct _GPContextWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (GPContextWrapper *self);
	void (*idle) (GPContextWrapper* self);
	void (*error) (GPContextWrapper* self, const gchar* text, void* data);
	void (*status) (GPContextWrapper* self, const gchar* text, void* data);
	void (*message) (GPContextWrapper* self, const gchar* text, void* data);
	void (*progress_start) (GPContextWrapper* self, gfloat current, const gchar* text, void* data);
	void (*progress_update) (GPContextWrapper* self, gfloat current, void* data);
	void (*progress_stop) (GPContextWrapper* self);
};

struct _GPParamSpecContextWrapper {
	GParamSpec parent_instance;
};

struct _GPSpinIdleWrapper {
	GPContextWrapper parent_instance;
	GPSpinIdleWrapperPrivate * priv;
};

struct _GPSpinIdleWrapperClass {
	GPContextWrapperClass parent_class;
};

typedef enum  {
	JPEG_MARKER_INVALID = 0x00,
	JPEG_MARKER_SOI = 0xD8,
	JPEG_MARKER_EOI = 0xD9,
	JPEG_MARKER_APP0 = 0xE0,
	JPEG_MARKER_APP1 = 0xE1
} JpegMarker;


static gpointer gp_context_wrapper_parent_class = NULL;
static gpointer gp_spin_idle_wrapper_parent_class = NULL;

GQuark gphoto_error_quark (void);
gpointer gp_context_wrapper_ref (gpointer instance);
void gp_context_wrapper_unref (gpointer instance);
GParamSpec* gp_param_spec_context_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gp_value_set_context_wrapper (GValue* value, gpointer v_object);
void gp_value_take_context_wrapper (GValue* value, gpointer v_object);
gpointer gp_value_get_context_wrapper (const GValue* value);
GType gp_context_wrapper_get_type (void) G_GNUC_CONST;
enum  {
	GP_CONTEXT_WRAPPER_DUMMY_PROPERTY
};
GPContextWrapper* gp_context_wrapper_new (void);
GPContextWrapper* gp_context_wrapper_construct (GType object_type);
static void gp_context_wrapper_on_idle (GPContextWrapper* self, GPContext* context);
static void _gp_context_wrapper_on_idle_gp_context_idle_func (GPContext* context, gpointer self);
static void gp_context_wrapper_on_error (GPContextWrapper* self, GPContext* context, const gchar* text);
static void _gp_context_wrapper_on_error_gp_context_error_func (GPContext* context, const gchar* text, gpointer self);
static void gp_context_wrapper_on_status (GPContextWrapper* self, GPContext* context, const gchar* text);
static void _gp_context_wrapper_on_status_gp_context_status_func (GPContext* context, const gchar* text, gpointer self);
static void gp_context_wrapper_on_message (GPContextWrapper* self, GPContext* context, const gchar* text);
static void _gp_context_wrapper_on_message_gp_context_message_func (GPContext* context, const gchar* text, gpointer self);
static guint gp_context_wrapper_on_progress_start (GPContextWrapper* self, GPContext* context, gfloat target, const gchar* text);
static guint _gp_context_wrapper_on_progress_start_gp_context_progress_start_func (GPContext* context, gfloat target, const gchar* text, gpointer self);
static void gp_context_wrapper_on_progress_update (GPContextWrapper* self, GPContext* context, guint id, gfloat current);
static void _gp_context_wrapper_on_progress_update_gp_context_progress_update_func (GPContext* context, guint id, gfloat current, gpointer self);
static void gp_context_wrapper_on_progress_stop (GPContextWrapper* self, GPContext* context, guint id);
static void _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func (GPContext* context, guint id, gpointer self);
void gp_context_wrapper_idle (GPContextWrapper* self);
static void gp_context_wrapper_real_idle (GPContextWrapper* self);
void gp_context_wrapper_error (GPContextWrapper* self, const gchar* text, void* data);
static void gp_context_wrapper_real_error (GPContextWrapper* self, const gchar* text, void* data);
void gp_context_wrapper_status (GPContextWrapper* self, const gchar* text, void* data);
static void gp_context_wrapper_real_status (GPContextWrapper* self, const gchar* text, void* data);
void gp_context_wrapper_message (GPContextWrapper* self, const gchar* text, void* data);
static void gp_context_wrapper_real_message (GPContextWrapper* self, const gchar* text, void* data);
void gp_context_wrapper_progress_start (GPContextWrapper* self, gfloat current, const gchar* text, void* data);
static void gp_context_wrapper_real_progress_start (GPContextWrapper* self, gfloat current, const gchar* text, void* data);
void gp_context_wrapper_progress_update (GPContextWrapper* self, gfloat current, void* data);
static void gp_context_wrapper_real_progress_update (GPContextWrapper* self, gfloat current, void* data);
void gp_context_wrapper_progress_stop (GPContextWrapper* self);
static void gp_context_wrapper_real_progress_stop (GPContextWrapper* self);
static void gp_context_wrapper_finalize (GPContextWrapper* obj);
GType gp_spin_idle_wrapper_get_type (void) G_GNUC_CONST;
enum  {
	GP_SPIN_IDLE_WRAPPER_DUMMY_PROPERTY
};
GPSpinIdleWrapper* gp_spin_idle_wrapper_new (void);
GPSpinIdleWrapper* gp_spin_idle_wrapper_construct (GType object_type);
static void gp_spin_idle_wrapper_real_idle (GPContextWrapper* base);
void spin_event_loop (void);
static void gp_spin_idle_wrapper_real_progress_update (GPContextWrapper* base, gfloat current, void* data);
#define GP_MAX_FILENAME_LENGTH 63
#define GP_MAX_BASEDIR_LENGTH 255
gboolean gp_get_info (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileInfo* info, GError** error);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* gp_get_fallback_metadata (Camera* camera, GPContext* context, const gchar* folder, const gchar* filename);
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self, GFile* file, GError** error);
GdkPixbuf* gp_load_preview (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, guint8** raw, int* raw_length1, gsize* raw_length, GError** error);
guint8* gp_load_file_into_buffer (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileType filetype, int* result_length1, GError** error);
guint photo_metadata_get_preview_count (PhotoMetadata* self);
gpointer photo_preview_ref (gpointer instance);
void photo_preview_unref (gpointer instance);
GParamSpec* param_spec_photo_preview (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_preview (GValue* value, gpointer v_object);
void value_take_photo_preview (GValue* value, gpointer v_object);
gpointer value_get_photo_preview (const GValue* value);
GType photo_preview_get_type (void) G_GNUC_CONST;
PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self, guint number);
guint8* photo_preview_flatten (PhotoPreview* self, int* result_length1, GError** error);
#define JPEG_MARKER_PREFIX ((guint8) 0xFF)
GType jpeg_marker_get_type (void) G_GNUC_CONST;
static guint8* _vala_array_dup23 (guint8* self, int length);
#define IMPORT_PREVIEW_MAX_SCALE 128
GdkPixbuf* gp_load_image (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GError** error);
GInputStream* gp_load_file_into_stream (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileType filetype, GError** error);
void gp_save_image (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GFile* dest_file, GError** error);
PhotoMetadata* gp_load_metadata (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GError** error);
void photo_metadata_read_from_app1_segment (PhotoMetadata* self, guint8* buffer, int buffer_length1, gint length, GError** error);
static guint8* _vala_array_dup24 (guint8* self, int length);
void gp_on_mins_destroyed (void* data);
static void _gp_on_mins_destroyed_gdestroy_notify (void* data);
GFile* app_dirs_get_temp_dir (void);


GQuark gphoto_error_quark (void) {
	return g_quark_from_static_string ("gphoto_error-quark");
}


static void _gp_context_wrapper_on_idle_gp_context_idle_func (GPContext* context, gpointer self) {
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_idle ((GPContextWrapper*) self, context);
#line 244 "GPhoto.c"
}


static void _gp_context_wrapper_on_error_gp_context_error_func (GPContext* context, const gchar* text, gpointer self) {
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_error ((GPContextWrapper*) self, context, text);
#line 251 "GPhoto.c"
}


static void _gp_context_wrapper_on_status_gp_context_status_func (GPContext* context, const gchar* text, gpointer self) {
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_status ((GPContextWrapper*) self, context, text);
#line 258 "GPhoto.c"
}


static void _gp_context_wrapper_on_message_gp_context_message_func (GPContext* context, const gchar* text, gpointer self) {
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_message ((GPContextWrapper*) self, context, text);
#line 265 "GPhoto.c"
}


static guint _gp_context_wrapper_on_progress_start_gp_context_progress_start_func (GPContext* context, gfloat target, const gchar* text, gpointer self) {
	guint result;
	result = gp_context_wrapper_on_progress_start ((GPContextWrapper*) self, context, target, text);
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 274 "GPhoto.c"
}


static void _gp_context_wrapper_on_progress_update_gp_context_progress_update_func (GPContext* context, guint id, gfloat current, gpointer self) {
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_progress_update ((GPContextWrapper*) self, context, id, current);
#line 281 "GPhoto.c"
}


static void _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func (GPContext* context, guint id, gpointer self) {
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_on_progress_stop ((GPContextWrapper*) self, context, id);
#line 288 "GPhoto.c"
}


GPContextWrapper* gp_context_wrapper_construct (GType object_type) {
	GPContextWrapper* self = NULL;
	GPContext* _tmp0_ = NULL;
	GPContext* _tmp1_ = NULL;
	GPContext* _tmp2_ = NULL;
	GPContext* _tmp3_ = NULL;
	GPContext* _tmp4_ = NULL;
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = (GPContextWrapper*) g_type_create_instance (object_type);
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = self->context;
#line 18 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_idle_func (_tmp0_, _gp_context_wrapper_on_idle_gp_context_idle_func, self);
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = self->context;
#line 19 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_error_func (_tmp1_, _gp_context_wrapper_on_error_gp_context_error_func, self);
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = self->context;
#line 20 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_status_func (_tmp2_, _gp_context_wrapper_on_status_gp_context_status_func, self);
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = self->context;
#line 21 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_message_func (_tmp3_, _gp_context_wrapper_on_message_gp_context_message_func, self);
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = self->context;
#line 22 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_set_progress_funcs (_tmp4_, _gp_context_wrapper_on_progress_start_gp_context_progress_start_func, _gp_context_wrapper_on_progress_update_gp_context_progress_update_func, _gp_context_wrapper_on_progress_stop_gp_context_progress_stop_func, self);
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self;
#line 323 "GPhoto.c"
}


GPContextWrapper* gp_context_wrapper_new (void) {
#line 17 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return gp_context_wrapper_construct (GP_TYPE_CONTEXT_WRAPPER);
#line 330 "GPhoto.c"
}


static void gp_context_wrapper_real_idle (GPContextWrapper* self) {
}


void gp_context_wrapper_idle (GPContextWrapper* self) {
#line 25 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 25 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->idle (self);
#line 343 "GPhoto.c"
}


static void gp_context_wrapper_real_error (GPContextWrapper* self, const gchar* text, void* data) {
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 350 "GPhoto.c"
}


void gp_context_wrapper_error (GPContextWrapper* self, const gchar* text, void* data) {
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 28 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->error (self, text, data);
#line 359 "GPhoto.c"
}


static void gp_context_wrapper_real_status (GPContextWrapper* self, const gchar* text, void* data) {
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 366 "GPhoto.c"
}


void gp_context_wrapper_status (GPContextWrapper* self, const gchar* text, void* data) {
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 31 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->status (self, text, data);
#line 375 "GPhoto.c"
}


static void gp_context_wrapper_real_message (GPContextWrapper* self, const gchar* text, void* data) {
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 382 "GPhoto.c"
}


void gp_context_wrapper_message (GPContextWrapper* self, const gchar* text, void* data) {
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 34 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->message (self, text, data);
#line 391 "GPhoto.c"
}


static void gp_context_wrapper_real_progress_start (GPContextWrapper* self, gfloat current, const gchar* text, void* data) {
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 398 "GPhoto.c"
}


void gp_context_wrapper_progress_start (GPContextWrapper* self, gfloat current, const gchar* text, void* data) {
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 37 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_start (self, current, text, data);
#line 407 "GPhoto.c"
}


static void gp_context_wrapper_real_progress_update (GPContextWrapper* self, gfloat current, void* data) {
}


void gp_context_wrapper_progress_update (GPContextWrapper* self, gfloat current, void* data) {
#line 40 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 40 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_update (self, current, data);
#line 420 "GPhoto.c"
}


static void gp_context_wrapper_real_progress_stop (GPContextWrapper* self) {
}


void gp_context_wrapper_progress_stop (GPContextWrapper* self) {
#line 43 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 43 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_GET_CLASS (self)->progress_stop (self);
#line 433 "GPhoto.c"
}


static void gp_context_wrapper_on_idle (GPContextWrapper* self, GPContext* context) {
#line 46 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 46 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 47 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_idle (self);
#line 444 "GPhoto.c"
}


static void gp_context_wrapper_on_error (GPContextWrapper* self, GPContext* context, const gchar* text) {
	const gchar* _tmp0_ = NULL;
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 50 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 51 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = text;
#line 51 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_error (self, _tmp0_, NULL);
#line 460 "GPhoto.c"
}


static void gp_context_wrapper_on_status (GPContextWrapper* self, GPContext* context, const gchar* text) {
	const gchar* _tmp0_ = NULL;
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 54 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 55 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = text;
#line 55 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_status (self, _tmp0_, NULL);
#line 476 "GPhoto.c"
}


static void gp_context_wrapper_on_message (GPContextWrapper* self, GPContext* context, const gchar* text) {
	const gchar* _tmp0_ = NULL;
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 58 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (text != NULL);
#line 59 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = text;
#line 59 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_message (self, _tmp0_, NULL);
#line 492 "GPhoto.c"
}


static guint gp_context_wrapper_on_progress_start (GPContextWrapper* self, GPContext* context, gfloat target, const gchar* text) {
	guint result = 0U;
	gfloat _tmp0_ = 0.0F;
	const gchar* _tmp1_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (GP_IS_CONTEXT_WRAPPER (self), 0U);
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, 0U);
#line 62 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (text != NULL, 0U);
#line 63 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = target;
#line 63 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = text;
#line 63 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_start (self, _tmp0_, _tmp1_, NULL);
#line 65 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = (guint) 0;
#line 65 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 516 "GPhoto.c"
}


static void gp_context_wrapper_on_progress_update (GPContextWrapper* self, GPContext* context, guint id, gfloat current) {
	gfloat _tmp0_ = 0.0F;
#line 68 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 68 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 69 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = current;
#line 69 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_update (self, _tmp0_, NULL);
#line 530 "GPhoto.c"
}


static void gp_context_wrapper_on_progress_stop (GPContextWrapper* self, GPContext* context, guint id) {
#line 72 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (GP_IS_CONTEXT_WRAPPER (self));
#line 72 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 73 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_progress_stop (self);
#line 541 "GPhoto.c"
}


static void gp_value_context_wrapper_init (GValue* value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	value->data[0].v_pointer = NULL;
#line 548 "GPhoto.c"
}


static void gp_value_context_wrapper_free_value (GValue* value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (value->data[0].v_pointer);
#line 557 "GPhoto.c"
	}
}


static void gp_value_context_wrapper_copy_value (const GValue* src_value, GValue* dest_value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (src_value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		dest_value->data[0].v_pointer = gp_context_wrapper_ref (src_value->data[0].v_pointer);
#line 567 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		dest_value->data[0].v_pointer = NULL;
#line 571 "GPhoto.c"
	}
}


static gpointer gp_value_context_wrapper_peek_pointer (const GValue* value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return value->data[0].v_pointer;
#line 579 "GPhoto.c"
}


static gchar* gp_value_context_wrapper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (collect_values[0].v_pointer) {
#line 586 "GPhoto.c"
		GPContextWrapper* object;
		object = collect_values[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (object->parent_instance.g_class == NULL) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 593 "GPhoto.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 597 "GPhoto.c"
		}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = gp_context_wrapper_ref (object);
#line 601 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 605 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return NULL;
#line 609 "GPhoto.c"
}


static gchar* gp_value_context_wrapper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GPContextWrapper** object_p;
	object_p = collect_values[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (!object_p) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 620 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (!value->data[0].v_pointer) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = NULL;
#line 626 "GPhoto.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = value->data[0].v_pointer;
#line 630 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*object_p = gp_context_wrapper_ref (value->data[0].v_pointer);
#line 634 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return NULL;
#line 638 "GPhoto.c"
}


GParamSpec* gp_param_spec_context_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GPParamSpecContextWrapper* spec;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (g_type_is_a (object_type, GP_TYPE_CONTEXT_WRAPPER), NULL);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return G_PARAM_SPEC (spec);
#line 652 "GPhoto.c"
}


gpointer gp_value_get_context_wrapper (const GValue* value) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER), NULL);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return value->data[0].v_pointer;
#line 661 "GPhoto.c"
}


void gp_value_set_context_wrapper (GValue* value, gpointer v_object) {
	GPContextWrapper* old;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (v_object) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = v_object;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_ref (value->data[0].v_pointer);
#line 681 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 685 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (old) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (old);
#line 691 "GPhoto.c"
	}
}


void gp_value_take_context_wrapper (GValue* value, gpointer v_object) {
	GPContextWrapper* old;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (v_object) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GP_TYPE_CONTEXT_WRAPPER));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = v_object;
#line 710 "GPhoto.c"
	} else {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		value->data[0].v_pointer = NULL;
#line 714 "GPhoto.c"
	}
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (old) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		gp_context_wrapper_unref (old);
#line 720 "GPhoto.c"
	}
}


static void gp_context_wrapper_class_init (GPContextWrapperClass * klass) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_context_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->finalize = gp_context_wrapper_finalize;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->idle = gp_context_wrapper_real_idle;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->error = gp_context_wrapper_real_error;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->status = gp_context_wrapper_real_status;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->message = gp_context_wrapper_real_message;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_start = gp_context_wrapper_real_progress_start;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_update = gp_context_wrapper_real_progress_update;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_stop = gp_context_wrapper_real_progress_stop;
#line 744 "GPhoto.c"
}


static void gp_context_wrapper_instance_init (GPContextWrapper * self) {
	GPContext* _tmp0_ = NULL;
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = gp_context_new ();
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self->context = _tmp0_;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self->ref_count = 1;
#line 756 "GPhoto.c"
}


static void gp_context_wrapper_finalize (GPContextWrapper* obj) {
	GPContextWrapper * self;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_signal_handlers_destroy (self);
#line 15 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_context_unref0 (self->context);
#line 768 "GPhoto.c"
}


GType gp_context_wrapper_get_type (void) {
	static volatile gsize gp_context_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&gp_context_wrapper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gp_value_context_wrapper_init, gp_value_context_wrapper_free_value, gp_value_context_wrapper_copy_value, gp_value_context_wrapper_peek_pointer, "p", gp_value_context_wrapper_collect_value, "p", gp_value_context_wrapper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GPContextWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gp_context_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPContextWrapper), 0, (GInstanceInitFunc) gp_context_wrapper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gp_context_wrapper_type_id;
		gp_context_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GPContextWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gp_context_wrapper_type_id__volatile, gp_context_wrapper_type_id);
	}
	return gp_context_wrapper_type_id__volatile;
}


gpointer gp_context_wrapper_ref (gpointer instance) {
	GPContextWrapper* self;
	self = instance;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_atomic_int_inc (&self->ref_count);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return instance;
#line 793 "GPhoto.c"
}


void gp_context_wrapper_unref (gpointer instance) {
	GPContextWrapper* self;
	self = instance;
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		GP_CONTEXT_WRAPPER_GET_CLASS (self)->finalize (self);
#line 14 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 806 "GPhoto.c"
	}
}


GPSpinIdleWrapper* gp_spin_idle_wrapper_construct (GType object_type) {
	GPSpinIdleWrapper* self = NULL;
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = (GPSpinIdleWrapper*) gp_context_wrapper_construct (object_type);
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return self;
#line 817 "GPhoto.c"
}


GPSpinIdleWrapper* gp_spin_idle_wrapper_new (void) {
#line 79 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return gp_spin_idle_wrapper_construct (GP_TYPE_SPIN_IDLE_WRAPPER);
#line 824 "GPhoto.c"
}


static void gp_spin_idle_wrapper_real_idle (GPContextWrapper* base) {
	GPSpinIdleWrapper * self;
#line 82 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper);
#line 83 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_CLASS (gp_spin_idle_wrapper_parent_class)->idle (G_TYPE_CHECK_INSTANCE_CAST (self, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper));
#line 85 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spin_event_loop ();
#line 836 "GPhoto.c"
}


static void gp_spin_idle_wrapper_real_progress_update (GPContextWrapper* base, gfloat current, void* data) {
	GPSpinIdleWrapper * self;
	gfloat _tmp0_ = 0.0F;
	void* _tmp1_ = NULL;
#line 88 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GP_TYPE_SPIN_IDLE_WRAPPER, GPSpinIdleWrapper);
#line 89 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = current;
#line 89 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = data;
#line 89 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	GP_CONTEXT_WRAPPER_CLASS (gp_spin_idle_wrapper_parent_class)->progress_update (G_TYPE_CHECK_INSTANCE_CAST (self, GP_TYPE_CONTEXT_WRAPPER, GPContextWrapper), _tmp0_, _tmp1_);
#line 91 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	spin_event_loop ();
#line 854 "GPhoto.c"
}


static void gp_spin_idle_wrapper_class_init (GPSpinIdleWrapperClass * klass) {
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_spin_idle_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->idle = gp_spin_idle_wrapper_real_idle;
#line 78 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	((GPContextWrapperClass *) klass)->progress_update = gp_spin_idle_wrapper_real_progress_update;
#line 865 "GPhoto.c"
}


static void gp_spin_idle_wrapper_instance_init (GPSpinIdleWrapper * self) {
}


GType gp_spin_idle_wrapper_get_type (void) {
	static volatile gsize gp_spin_idle_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&gp_spin_idle_wrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GPSpinIdleWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gp_spin_idle_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GPSpinIdleWrapper), 0, (GInstanceInitFunc) gp_spin_idle_wrapper_instance_init, NULL };
		GType gp_spin_idle_wrapper_type_id;
		gp_spin_idle_wrapper_type_id = g_type_register_static (GP_TYPE_CONTEXT_WRAPPER, "GPSpinIdleWrapper", &g_define_type_info, 0);
		g_once_init_leave (&gp_spin_idle_wrapper_type_id__volatile, gp_spin_idle_wrapper_type_id);
	}
	return gp_spin_idle_wrapper_type_id__volatile;
}


gboolean gp_get_info (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileInfo* info, GError** error) {
	CameraFileInfo _vala_info = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	int res = 0;
	Camera* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GPContext* _tmp11_ = NULL;
	CameraFileInfo _tmp12_ = {0};
	int _tmp13_ = 0;
	int _tmp14_ = 0;
	GError * _inner_error_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = folder;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = strlen (_tmp1_);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = _tmp2_;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp3_ > GP_MAX_BASEDIR_LENGTH) {
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = TRUE;
#line 919 "GPhoto.c"
	} else {
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = filename;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = strlen (_tmp4_);
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = _tmp5_;
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp6_ > GP_MAX_FILENAME_LENGTH;
#line 932 "GPhoto.c"
	}
#line 104 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp0_) {
#line 936 "GPhoto.c"
		CameraFileInfo _tmp7_ = {0};
#line 105 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (_vala_info);
#line 105 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_info = _tmp7_;
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = FALSE;
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (info) {
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			*info = _vala_info;
#line 948 "GPhoto.c"
		} else {
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			 (_vala_info);
#line 952 "GPhoto.c"
		}
#line 107 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 956 "GPhoto.c"
	}
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = camera;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = folder;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp10_ = filename;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = context;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = gp_camera_file_get_info (_tmp8_, _tmp9_, _tmp10_, &_tmp12_, _tmp11_);
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (_vala_info);
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_info = _tmp12_;
#line 110 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp13_;
#line 111 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14_ = res;
#line 111 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp14_ != GP_OK) {
#line 978 "GPhoto.c"
		int _tmp15_ = 0;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		int _tmp18_ = 0;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = res;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = folder;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = filename;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = res;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = gp_port_result_as_string (_tmp18_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file information for %s/%s: %s", (gint) _tmp15_, _tmp16_, _tmp17_, _tmp19_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp20_;
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 112 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return FALSE;
#line 1003 "GPhoto.c"
	}
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = TRUE;
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (info) {
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*info = _vala_info;
#line 1011 "GPhoto.c"
	} else {
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (_vala_info);
#line 1015 "GPhoto.c"
	}
#line 115 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1019 "GPhoto.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1328 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1052 "GPhoto.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1061 "GPhoto.c"
	}
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1067 "GPhoto.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1076 "GPhoto.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1082 "GPhoto.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1091 "GPhoto.c"
	} else {
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1095 "GPhoto.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1103 "GPhoto.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1112 "GPhoto.c"
	} else {
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1116 "GPhoto.c"
	}
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1138 "GPhoto.c"
}


PhotoMetadata* gp_get_fallback_metadata (Camera* camera, GPContext* context, const gchar* folder, const gchar* filename) {
	PhotoMetadata* result = NULL;
	CameraStorageInformation* sifs = NULL;
	gint count = 0;
	Camera* _tmp0_ = NULL;
	GPContext* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GPPortInfo port_info = {0};
	Camera* _tmp3_ = NULL;
	GPPortInfo _tmp4_ = {0};
	gchar* path = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* prefix = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
#line 121 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 121 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 121 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 121 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 122 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	sifs = NULL;
#line 123 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	count = 0;
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = camera;
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = context;
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_camera_get_storageinfo (_tmp0_, &sifs, &_tmp2_, _tmp1_);
#line 124 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	count = _tmp2_;
#line 127 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = camera;
#line 127 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_camera_get_port_info (_tmp3_, &_tmp4_);
#line 127 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (port_info);
#line 127 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	port_info = _tmp4_;
#line 130 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_port_info_get_path (port_info, &_tmp5_);
#line 130 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (path);
#line 130 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 130 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	path = _tmp6_;
#line 132 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = g_strdup ("disk:");
#line 132 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	prefix = _tmp7_;
#line 133 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = path;
#line 133 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = g_str_has_prefix (_tmp8_, prefix);
#line 133 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp9_) {
#line 1208 "GPhoto.c"
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = path;
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = strlen (prefix);
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = _tmp11_;
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp13_ = path;
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = strlen (_tmp13_);
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = _tmp14_;
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = string_slice (_tmp10_, (glong) _tmp12_, (glong) _tmp15_);
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 134 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		path = _tmp16_;
#line 1234 "GPhoto.c"
	} else {
#line 136 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 136 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (prefix);
#line 136 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 136 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (port_info);
#line 136 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1246 "GPhoto.c"
	}
#line 138 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp17_ = photo_metadata_new ();
#line 138 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	metadata = _tmp17_;
#line 1252 "GPhoto.c"
	{
		PhotoMetadata* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		GFile* _tmp28_ = NULL;
		GFile* _tmp29_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = metadata;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = path;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = folder;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp22_ = _tmp21_;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp23_ = g_strconcat (_tmp22_, "/", NULL);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp24_ = _tmp23_;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp25_ = filename;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp27_ = _tmp26_;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp28_ = g_file_new_for_path (_tmp27_);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp29_ = _tmp28_;
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp29_, &_inner_error_);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (_tmp29_);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp27_);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp24_);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp22_);
#line 140 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1302 "GPhoto.c"
			goto __catch61_g_error;
		}
	}
	goto __finally61;
	__catch61_g_error:
	{
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 142 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		metadata = NULL;
#line 1317 "GPhoto.c"
	}
	__finally61:
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (prefix);
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (path);
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		 (port_info);
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 139 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1336 "GPhoto.c"
	}
#line 145 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = metadata;
#line 145 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (prefix);
#line 145 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (path);
#line 145 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	 (port_info);
#line 145 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1348 "GPhoto.c"
}


static guint8* _vala_array_dup23 (guint8* self, int length) {
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1355 "GPhoto.c"
}


GdkPixbuf* gp_load_preview (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, guint8** raw, int* raw_length1, gsize* raw_length, GError** error) {
	guint8* _vala_raw = NULL;
	int _vala_raw_length1 = 0;
	gsize _vala_raw_length = 0UL;
	GdkPixbuf* result = NULL;
	guint8* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	guint8* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gsize _tmp27_ = 0UL;
	GMemoryInputStream* mins = NULL;
	guint8* _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	guint8* _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	GMemoryInputStream* _tmp44_ = NULL;
	GdkPixbuf* _tmp45_ = NULL;
	GMemoryInputStream* _tmp46_ = NULL;
	GdkPixbuf* _tmp47_ = NULL;
	GdkPixbuf* _tmp48_ = NULL;
	GError * _inner_error_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 148 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 148 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 148 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_raw = (g_free (_vala_raw), NULL);
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_raw = NULL;
#line 150 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_raw_length1 = 0;
#line 151 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_raw_length = (gsize) 0;
#line 1396 "GPhoto.c"
	{
		guint8* _tmp0_ = NULL;
		GPContext* _tmp1_ = NULL;
		Camera* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		guint8* _tmp6_ = NULL;
		gint _tmp0__length1 = 0;
		gint __tmp0__size_ = 0;
		guint8* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp1_ = context;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp2_ = camera;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = folder;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = filename;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = gp_load_file_into_buffer (_tmp1_, _tmp2_, _tmp3_, _tmp4_, GP_FILE_TYPE_PREVIEW, &_tmp5_, &_inner_error_);
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp6_;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0__length1 = _tmp5_;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		__tmp0__size_ = _tmp0__length1;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1427 "GPhoto.c"
			goto __catch62_g_error;
		}
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = _tmp0_;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7__length1 = _tmp0__length1;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0__length1 = 0;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_raw = (g_free (_vala_raw), NULL);
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_raw = _tmp7_;
#line 154 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_raw_length1 = _tmp7__length1;
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = (g_free (_tmp0_), NULL);
#line 1446 "GPhoto.c"
	}
	goto __finally62;
	__catch62_g_error:
	{
		PhotoMetadata* metadata = NULL;
		Camera* _tmp8_ = NULL;
		GPContext* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		PhotoMetadata* _tmp12_ = NULL;
		PhotoMetadata* _tmp13_ = NULL;
		PhotoMetadata* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		PhotoPreview* preview = NULL;
		PhotoMetadata* _tmp16_ = NULL;
		PhotoMetadata* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		PhotoPreview* _tmp19_ = NULL;
		guint8* _tmp20_ = NULL;
		PhotoPreview* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		guint8* _tmp23_ = NULL;
		gint _tmp20__length1 = 0;
		gint __tmp20__size_ = 0;
		guint8* _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = camera;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = context;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = folder;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = filename;
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = gp_get_fallback_metadata (_tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 156 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		metadata = _tmp12_;
#line 157 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp13_ = metadata;
#line 157 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (NULL == _tmp13_) {
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			result = NULL;
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (raw) {
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*raw = _vala_raw;
#line 1501 "GPhoto.c"
			} else {
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				_vala_raw = (g_free (_vala_raw), NULL);
#line 1505 "GPhoto.c"
			}
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (raw_length1) {
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*raw_length1 = _vala_raw_length1;
#line 1511 "GPhoto.c"
			}
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (raw_length) {
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*raw_length = _vala_raw_length;
#line 1517 "GPhoto.c"
			}
#line 158 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return result;
#line 1521 "GPhoto.c"
		}
#line 159 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = metadata;
#line 159 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = photo_metadata_get_preview_count (_tmp14_);
#line 159 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (((guint) 0) == _tmp15_) {
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			result = NULL;
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (raw) {
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*raw = _vala_raw;
#line 1537 "GPhoto.c"
			} else {
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				_vala_raw = (g_free (_vala_raw), NULL);
#line 1541 "GPhoto.c"
			}
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (raw_length1) {
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*raw_length1 = _vala_raw_length1;
#line 1547 "GPhoto.c"
			}
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			if (raw_length) {
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				*raw_length = _vala_raw_length;
#line 1553 "GPhoto.c"
			}
#line 160 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			return result;
#line 1557 "GPhoto.c"
		}
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = metadata;
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = metadata;
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = photo_metadata_get_preview_count (_tmp17_);
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = photo_metadata_get_preview (_tmp16_, _tmp18_ - 1);
#line 161 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		preview = _tmp19_;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp21_ = preview;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp23_ = photo_preview_flatten (_tmp21_, &_tmp22_, &_inner_error_);
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = _tmp23_;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20__length1 = _tmp22_;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		__tmp20__size_ = _tmp20__length1;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_photo_preview_unref0 (preview);
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_media_metadata_unref0 (metadata);
#line 1585 "GPhoto.c"
			goto __finally62;
		}
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp24_ = _tmp20_;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp24__length1 = _tmp20__length1;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20__length1 = 0;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_raw = (g_free (_vala_raw), NULL);
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_raw = _tmp24_;
#line 162 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_raw_length1 = _tmp24__length1;
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = (g_free (_tmp20_), NULL);
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_photo_preview_unref0 (preview);
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 1608 "GPhoto.c"
	}
	__finally62:
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 153 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1617 "GPhoto.c"
	}
#line 165 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp25_ = _vala_raw;
#line 165 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp25__length1 = _vala_raw_length1;
#line 165 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp25_ == NULL) {
#line 166 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_raw_length = (gsize) 0;
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (raw) {
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			*raw = _vala_raw;
#line 1633 "GPhoto.c"
		} else {
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_vala_raw = (g_free (_vala_raw), NULL);
#line 1637 "GPhoto.c"
		}
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (raw_length1) {
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			*raw_length1 = _vala_raw_length1;
#line 1643 "GPhoto.c"
		}
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (raw_length) {
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			*raw_length = _vala_raw_length;
#line 1649 "GPhoto.c"
		}
#line 167 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1653 "GPhoto.c"
	}
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp26_ = _vala_raw;
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp26__length1 = _vala_raw_length1;
#line 170 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_vala_raw_length = (gsize) _tmp26__length1;
#line 176 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp27_ = _vala_raw_length;
#line 176 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp27_ > ((gsize) 32)) {
#line 1665 "GPhoto.c"
		{
			gsize i = 0UL;
			gsize _tmp28_ = 0UL;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			_tmp28_ = _vala_raw_length;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			i = _tmp28_ - 2;
#line 1673 "GPhoto.c"
			{
				gboolean _tmp29_ = FALSE;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				_tmp29_ = TRUE;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
				while (TRUE) {
#line 1680 "GPhoto.c"
					gsize _tmp31_ = 0UL;
					gsize _tmp32_ = 0UL;
					gboolean _tmp33_ = FALSE;
					guint8* _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
					gsize _tmp35_ = 0UL;
					guint8 _tmp36_ = 0U;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					if (!_tmp29_) {
#line 1690 "GPhoto.c"
						gsize _tmp30_ = 0UL;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp30_ = i;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						i = _tmp30_ - 1;
#line 1696 "GPhoto.c"
					}
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					_tmp29_ = FALSE;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					_tmp31_ = i;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					_tmp32_ = _vala_raw_length;
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					if (!(_tmp31_ > (_tmp32_ - 32))) {
#line 177 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						break;
#line 1708 "GPhoto.c"
					}
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					_tmp34_ = _vala_raw;
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					_tmp34__length1 = _vala_raw_length1;
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					_tmp35_ = i;
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					_tmp36_ = _tmp34_[_tmp35_];
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					if (_tmp36_ == JPEG_MARKER_PREFIX) {
#line 1720 "GPhoto.c"
						guint8* _tmp37_ = NULL;
						gint _tmp37__length1 = 0;
						gsize _tmp38_ = 0UL;
						guint8 _tmp39_ = 0U;
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp37_ = _vala_raw;
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp37__length1 = _vala_raw_length1;
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp38_ = i;
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp39_ = _tmp37_[_tmp38_ + 1];
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp33_ = _tmp39_ == JPEG_MARKER_EOI;
#line 1735 "GPhoto.c"
					} else {
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp33_ = FALSE;
#line 1739 "GPhoto.c"
					}
#line 178 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
					if (_tmp33_) {
#line 1743 "GPhoto.c"
						const gchar* _tmp40_ = NULL;
						gsize _tmp41_ = 0UL;
#line 179 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp40_ = filename;
#line 179 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						g_debug ("GPhoto.vala:179: Adjusted length of thumbnail for: %s", _tmp40_);
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_tmp41_ = i;
#line 180 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						_vala_raw_length = _tmp41_ + 2;
#line 181 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
						break;
#line 1756 "GPhoto.c"
					}
				}
			}
		}
	}
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp42_ = _vala_raw;
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp42__length1 = _vala_raw_length1;
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup23 (_tmp42_, _tmp42__length1) : ((gpointer) _tmp42_);
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp43__length1 = _tmp42__length1;
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp44_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp43_, _tmp43__length1, NULL);
#line 186 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	mins = _tmp44_;
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp46_ = mins;
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp47_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, g_input_stream_get_type (), GInputStream), IMPORT_PREVIEW_MAX_SCALE, IMPORT_PREVIEW_MAX_SCALE, TRUE, NULL, &_inner_error_);
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp45_ = _tmp47_;
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (mins);
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1788 "GPhoto.c"
	}
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp48_ = _tmp45_;
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp45_ = NULL;
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp48_;
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp45_);
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (mins);
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (raw) {
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*raw = _vala_raw;
#line 1804 "GPhoto.c"
	} else {
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_vala_raw = (g_free (_vala_raw), NULL);
#line 1808 "GPhoto.c"
	}
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (raw_length1) {
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*raw_length1 = _vala_raw_length1;
#line 1814 "GPhoto.c"
	}
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (raw_length) {
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*raw_length = _vala_raw_length;
#line 1820 "GPhoto.c"
	}
#line 187 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1824 "GPhoto.c"
}


GdkPixbuf* gp_load_image (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GError** error) {
	GdkPixbuf* result = NULL;
	GInputStream* ins = NULL;
	GPContext* _tmp0_ = NULL;
	Camera* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GInputStream* _tmp4_ = NULL;
	GInputStream* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GInputStream* _tmp7_ = NULL;
	GdkPixbuf* _tmp8_ = NULL;
	GdkPixbuf* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 190 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = context;
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = camera;
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = folder;
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = filename;
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = gp_load_file_into_stream (_tmp0_, _tmp1_, _tmp2_, _tmp3_, GP_FILE_TYPE_NORMAL, &_inner_error_);
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	ins = _tmp4_;
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1868 "GPhoto.c"
	}
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = ins;
#line 193 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp5_ == NULL) {
#line 194 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 194 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (ins);
#line 194 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 1880 "GPhoto.c"
	}
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = ins;
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = gdk_pixbuf_new_from_stream (_tmp7_, NULL, &_inner_error_);
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp6_ = _tmp8_;
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (ins);
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 1896 "GPhoto.c"
	}
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = _tmp6_;
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp6_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp9_;
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp6_);
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (ins);
#line 196 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 1910 "GPhoto.c"
}


void gp_save_image (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GFile* dest_file, GError** error) {
	gint fd = 0;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	CameraFile* camera_file = NULL;
	int res = 0;
	gint _tmp12_ = 0;
	CameraFile* _tmp13_ = NULL;
	int _tmp14_ = 0;
	int _tmp15_ = 0;
	Camera* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	CameraFile* _tmp24_ = NULL;
	GPContext* _tmp25_ = NULL;
	int _tmp26_ = 0;
	int _tmp27_ = 0;
	gint _tmp35_ = 0;
	GError * _inner_error_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (context != NULL);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (camera != NULL);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (folder != NULL);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (filename != NULL);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_if_fail (G_IS_FILE (dest_file));
#line 200 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = dest_file;
#line 200 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 200 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = _tmp1_;
#line 200 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp3_ = creat (_tmp2_, (mode_t) 0640);
#line 200 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp4_ = _tmp3_;
#line 200 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_tmp2_);
#line 200 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	fd = _tmp4_;
#line 201 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp5_ = fd;
#line 201 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp5_ < 0) {
#line 1965 "GPhoto.c"
		gint _tmp6_ = 0;
		GFile* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = errno;
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = dest_file;
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = g_file_get_path (_tmp7_);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = _tmp8_;
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "[%d] Error creating file %s: %m", _tmp6_, _tmp9_);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = _tmp10_;
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp9_);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp11_;
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 202 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 1992 "GPhoto.c"
	}
#line 206 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp12_ = fd;
#line 206 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14_ = gp_file_new_from_fd (&_tmp13_, _tmp12_);
#line 206 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 206 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp13_;
#line 206 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp14_;
#line 207 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp15_ = res;
#line 207 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp15_ != GP_OK) {
#line 2008 "GPhoto.c"
		gint _tmp16_ = 0;
		int _tmp17_ = 0;
		int _tmp18_ = 0;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
#line 208 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = fd;
#line 208 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		close (_tmp16_);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = res;
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = res;
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = gp_port_result_as_string (_tmp18_);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp17_, _tmp19_);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp20_;
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 209 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 2034 "GPhoto.c"
	}
#line 212 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp21_ = camera;
#line 212 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp22_ = folder;
#line 212 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp23_ = filename;
#line 212 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp24_ = camera_file;
#line 212 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp25_ = context;
#line 212 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp26_ = gp_camera_file_get (_tmp21_, _tmp22_, _tmp23_, GP_FILE_TYPE_NORMAL, _tmp24_, _tmp25_);
#line 212 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp26_;
#line 213 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp27_ = res;
#line 213 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp27_ != GP_OK) {
#line 2054 "GPhoto.c"
		gint _tmp28_ = 0;
		int _tmp29_ = 0;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		int _tmp32_ = 0;
		const gchar* _tmp33_ = NULL;
		GError* _tmp34_ = NULL;
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp28_ = fd;
#line 214 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		close (_tmp28_);
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp29_ = res;
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp30_ = folder;
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp31_ = filename;
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp32_ = res;
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp33_ = gp_port_result_as_string (_tmp32_);
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp34_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp29_, _tmp30_, _tmp31_, _tmp33_);
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp34_;
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 215 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return;
#line 2086 "GPhoto.c"
	}
#line 219 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp35_ = fd;
#line 219 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	close (_tmp35_);
#line 199 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 2094 "GPhoto.c"
}


PhotoMetadata* gp_load_metadata (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, GError** error) {
	PhotoMetadata* result = NULL;
	guint8* camera_raw = NULL;
	gint camera_raw_length1 = 0;
	gint _camera_raw_size_ = 0;
	gboolean _tmp13_ = FALSE;
	guint8* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp16_ = NULL;
	PhotoMetadata* _tmp17_ = NULL;
	guint8* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	GError * _inner_error_ = NULL;
#line 222 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 222 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 222 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 222 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_raw = NULL;
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_raw_length1 = 0;
#line 224 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_camera_raw_size_ = camera_raw_length1;
#line 2126 "GPhoto.c"
	{
		guint8* _tmp0_ = NULL;
		GPContext* _tmp1_ = NULL;
		Camera* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		guint8* _tmp6_ = NULL;
		gint _tmp0__length1 = 0;
		gint __tmp0__size_ = 0;
		guint8* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp1_ = context;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp2_ = camera;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = folder;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = filename;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = gp_load_file_into_buffer (_tmp1_, _tmp2_, _tmp3_, _tmp4_, GP_FILE_TYPE_EXIF, &_tmp5_, &_inner_error_);
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = _tmp6_;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0__length1 = _tmp5_;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		__tmp0__size_ = _tmp0__length1;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2157 "GPhoto.c"
			goto __catch63_g_error;
		}
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7_ = _tmp0_;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp7__length1 = _tmp0__length1;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = NULL;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0__length1 = 0;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw = (g_free (camera_raw), NULL);
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw = _tmp7_;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw_length1 = _tmp7__length1;
#line 226 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_camera_raw_size_ = camera_raw_length1;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp0_ = (g_free (_tmp0_), NULL);
#line 2178 "GPhoto.c"
	}
	goto __finally63;
	__catch63_g_error:
	{
		Camera* _tmp8_ = NULL;
		GPContext* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		PhotoMetadata* _tmp12_ = NULL;
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_clear_error (&_inner_error_);
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = NULL;
#line 228 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp8_ = camera;
#line 228 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp9_ = context;
#line 228 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp10_ = folder;
#line 228 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp11_ = filename;
#line 228 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp12_ = gp_get_fallback_metadata (_tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 228 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = _tmp12_;
#line 228 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw = (g_free (camera_raw), NULL);
#line 228 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2208 "GPhoto.c"
	}
	__finally63:
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw = (g_free (camera_raw), NULL);
#line 225 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2219 "GPhoto.c"
	}
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14_ = camera_raw;
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14__length1 = camera_raw_length1;
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp14_ == NULL) {
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp13_ = TRUE;
#line 2229 "GPhoto.c"
	} else {
		guint8* _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = camera_raw;
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15__length1 = camera_raw_length1;
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp13_ = _tmp15__length1 == 0;
#line 2239 "GPhoto.c"
	}
#line 231 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp13_) {
#line 232 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = NULL;
#line 232 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw = (g_free (camera_raw), NULL);
#line 232 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2249 "GPhoto.c"
	}
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp16_ = photo_metadata_new ();
#line 234 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	metadata = _tmp16_;
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp17_ = metadata;
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp18_ = camera_raw;
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp18__length1 = camera_raw_length1;
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	photo_metadata_read_from_app1_segment (_tmp17_, _tmp18_, _tmp18__length1, 0, &_inner_error_);
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_media_metadata_unref0 (metadata);
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		camera_raw = (g_free (camera_raw), NULL);
#line 235 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2273 "GPhoto.c"
	}
#line 237 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = metadata;
#line 237 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_raw = (g_free (camera_raw), NULL);
#line 237 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2281 "GPhoto.c"
}


static guint8* _vala_array_dup24 (guint8* self, int length) {
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 2288 "GPhoto.c"
}


static void _gp_on_mins_destroyed_gdestroy_notify (void* data) {
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	gp_on_mins_destroyed (data);
#line 2295 "GPhoto.c"
}


GInputStream* gp_load_file_into_stream (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileType filetype, GError** error) {
	GInputStream* result = NULL;
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp0_ = NULL;
	int _tmp1_ = 0;
	int _tmp2_ = 0;
	Camera* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	CameraFileType _tmp10_ = 0;
	GPContext* _tmp11_ = NULL;
	int _tmp12_ = 0;
	int _tmp13_ = 0;
	guint8* data = NULL;
	gulong data_len = 0UL;
	guint8* _tmp20_ = NULL;
	gulong _tmp21_ = 0UL;
	int _tmp22_ = 0;
	int _tmp23_ = 0;
	GFile* temp = NULL;
	GFile* _tmp32_ = NULL;
	GFile* _tmp33_ = NULL;
	GFile* _tmp34_ = NULL;
	GFile* _tmp35_ = NULL;
	GFile* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	int _tmp39_ = 0;
	int _tmp40_ = 0;
	GFileInputStream* _tmp51_ = NULL;
	GFile* _tmp52_ = NULL;
	GFileInputStream* _tmp53_ = NULL;
	GFileInputStream* _tmp54_ = NULL;
	GError * _inner_error_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 242 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 242 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 242 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 245 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = gp_file_new (&_tmp0_);
#line 245 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 245 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp0_;
#line 245 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp1_;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = res;
#line 246 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp2_ != GP_OK) {
#line 2354 "GPhoto.c"
		int _tmp3_ = 0;
		int _tmp4_ = 0;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 247 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = res;
#line 247 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = res;
#line 247 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = gp_port_result_as_string (_tmp4_);
#line 247 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp3_, _tmp5_);
#line 247 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp6_;
#line 247 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 247 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 247 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2375 "GPhoto.c"
	}
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = camera;
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = folder;
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = filename;
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp10_ = filetype;
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = context;
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp12_ = gp_camera_file_get (_tmp7_, _tmp8_, _tmp9_, _tmp10_, camera_file, _tmp11_);
#line 249 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp12_;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = res;
#line 250 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp13_ != GP_OK) {
#line 2395 "GPhoto.c"
		int _tmp14_ = 0;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		int _tmp17_ = 0;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp14_ = res;
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = folder;
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = filename;
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = res;
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = gp_port_result_as_string (_tmp17_);
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp14_, _tmp15_, _tmp16_, _tmp18_);
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp19_;
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 251 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2422 "GPhoto.c"
	}
#line 259 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp22_ = gp_file_get_data_and_size (camera_file, &_tmp20_, &_tmp21_);
#line 259 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	data = _tmp20_;
#line 259 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	data_len = _tmp21_;
#line 259 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp22_;
#line 260 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp23_ = res;
#line 260 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp23_ == GP_OK) {
#line 2436 "GPhoto.c"
		guint8* buffer = NULL;
		gulong _tmp24_ = 0UL;
		guint8* _tmp25_ = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		guint8* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		guint8* _tmp27_ = NULL;
		guint8* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		guint8* _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		guint8* _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		GMemoryInputStream* _tmp31_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp24_ = data_len;
#line 261 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp25_ = g_new0 (guint8, _tmp24_);
#line 261 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		buffer = _tmp25_;
#line 261 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		buffer_length1 = _tmp24_;
#line 261 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_buffer_size_ = buffer_length1;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp26_ = buffer;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp26__length1 = buffer_length1;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp27_ = data;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp28_ = buffer;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp28__length1 = buffer_length1;
#line 262 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		memcpy (_tmp26_, _tmp27_, (gsize) _tmp28__length1);
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp29_ = buffer;
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp29__length1 = buffer_length1;
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp30_ = (_tmp29_ != NULL) ? _vala_array_dup24 (_tmp29_, _tmp29__length1) : ((gpointer) _tmp29_);
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp30__length1 = _tmp29__length1;
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp31_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp30_, _tmp30__length1, _gp_on_mins_destroyed_gdestroy_notify);
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, g_input_stream_get_type (), GInputStream);
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		buffer = (g_free (buffer), NULL);
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 264 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2492 "GPhoto.c"
	}
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp32_ = app_dirs_get_temp_dir ();
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp33_ = _tmp32_;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp34_ = g_file_get_child (_tmp33_, "import.tmp");
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp35_ = _tmp34_;
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp33_);
#line 268 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	temp = _tmp35_;
#line 269 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp36_ = temp;
#line 269 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp37_ = g_file_get_path (_tmp36_);
#line 269 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp38_ = _tmp37_;
#line 269 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp39_ = gp_file_save (camera_file, _tmp38_);
#line 269 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp39_;
#line 269 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_free0 (_tmp38_);
#line 270 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp40_ = res;
#line 270 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp40_ != GP_OK) {
#line 2522 "GPhoto.c"
		int _tmp41_ = 0;
		const gchar* _tmp42_ = NULL;
		const gchar* _tmp43_ = NULL;
		GFile* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		int _tmp47_ = 0;
		const gchar* _tmp48_ = NULL;
		GError* _tmp49_ = NULL;
		GError* _tmp50_ = NULL;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp41_ = res;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp42_ = folder;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp43_ = filename;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp44_ = temp;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp45_ = g_file_get_path (_tmp44_);
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp46_ = _tmp45_;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp47_ = res;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp48_ = gp_port_result_as_string (_tmp47_);
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp49_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error copying file %s/%s to %s: %s", (gint) _tmp41_, _tmp42_, _tmp43_, _tmp46_, _tmp48_);
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp50_ = _tmp49_;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_free0 (_tmp46_);
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp50_;
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (temp);
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 271 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2565 "GPhoto.c"
	}
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp52_ = temp;
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp53_ = g_file_read (_tmp52_, NULL, &_inner_error_);
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp51_ = _tmp53_;
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_g_object_unref0 (temp);
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2583 "GPhoto.c"
	}
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp54_ = _tmp51_;
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp51_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, g_input_stream_get_type (), GInputStream);
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (_tmp51_);
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_g_object_unref0 (temp);
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 274 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2599 "GPhoto.c"
}


void gp_on_mins_destroyed (void* data) {
	void* _tmp0_ = NULL;
#line 278 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp0_ = data;
#line 278 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_free (_tmp0_);
#line 2609 "GPhoto.c"
}


guint8* gp_load_file_into_buffer (GPContext* context, Camera* camera, const gchar* folder, const gchar* filename, CameraFileType filetype, int* result_length1, GError** error) {
	guint8* result = NULL;
	CameraFile* camera_file = NULL;
	int res = 0;
	CameraFile* _tmp0_ = NULL;
	int _tmp1_ = 0;
	int _tmp2_ = 0;
	Camera* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	CameraFileType _tmp10_ = 0;
	CameraFile* _tmp11_ = NULL;
	GPContext* _tmp12_ = NULL;
	int _tmp13_ = 0;
	int _tmp14_ = 0;
	guint8* data = NULL;
	gulong data_len = 0UL;
	CameraFile* _tmp21_ = NULL;
	guint8* _tmp22_ = NULL;
	gulong _tmp23_ = 0UL;
	int _tmp24_ = 0;
	int _tmp25_ = 0;
	guint8* buffer = NULL;
	gulong _tmp27_ = 0UL;
	guint8* _tmp28_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	guint8* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	guint8* _tmp30_ = NULL;
	guint8* _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	guint8* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	GError * _inner_error_ = NULL;
#line 282 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (context != NULL, NULL);
#line 282 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (camera != NULL, NULL);
#line 282 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (folder != NULL, NULL);
#line 282 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 285 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp1_ = gp_file_new (&_tmp0_);
#line 285 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 285 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	camera_file = _tmp0_;
#line 285 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp1_;
#line 286 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp2_ = res;
#line 286 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp2_ != GP_OK) {
#line 2668 "GPhoto.c"
		int _tmp3_ = 0;
		int _tmp4_ = 0;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
#line 287 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp3_ = res;
#line 287 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp4_ = res;
#line 287 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp5_ = gp_port_result_as_string (_tmp4_);
#line 287 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp6_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error allocating camera file: %s", (gint) _tmp3_, _tmp5_);
#line 287 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp6_;
#line 287 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 287 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 287 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2689 "GPhoto.c"
	}
#line 289 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp7_ = camera;
#line 289 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp8_ = folder;
#line 289 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp9_ = filename;
#line 289 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp10_ = filetype;
#line 289 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp11_ = camera_file;
#line 289 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp12_ = context;
#line 289 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp13_ = gp_camera_file_get (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_);
#line 289 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp13_;
#line 290 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp14_ = res;
#line 290 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp14_ != GP_OK) {
#line 2711 "GPhoto.c"
		int _tmp15_ = 0;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		int _tmp18_ = 0;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_ = NULL;
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp15_ = res;
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp16_ = folder;
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp17_ = filename;
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp18_ = res;
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp19_ = gp_port_result_as_string (_tmp18_);
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp20_ = g_error_new (GPHOTO_ERROR, GPHOTO_ERROR_LIBRARY, "[%d] Error retrieving file object for %s/%s: %s", (gint) _tmp15_, _tmp16_, _tmp17_, _tmp19_);
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_inner_error_ = _tmp20_;
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		g_propagate_error (error, _inner_error_);
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 291 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return NULL;
#line 2738 "GPhoto.c"
	}
#line 298 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp21_ = camera_file;
#line 298 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp24_ = gp_file_get_data_and_size (_tmp21_, &_tmp22_, &_tmp23_);
#line 298 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	data = _tmp22_;
#line 298 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	data_len = _tmp23_;
#line 298 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	res = _tmp24_;
#line 299 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp25_ = res;
#line 299 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (_tmp25_ != GP_OK) {
#line 2754 "GPhoto.c"
		guint8* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
#line 300 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp26_ = NULL;
#line 300 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_tmp26__length1 = 0;
#line 300 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		if (result_length1) {
#line 300 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
			*result_length1 = _tmp26__length1;
#line 2765 "GPhoto.c"
		}
#line 300 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		result = _tmp26_;
#line 300 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		_gp_file_unref0 (camera_file);
#line 300 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		return result;
#line 2773 "GPhoto.c"
	}
#line 302 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp27_ = data_len;
#line 302 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp28_ = g_new0 (guint8, _tmp27_);
#line 302 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	buffer = _tmp28_;
#line 302 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	buffer_length1 = _tmp27_;
#line 302 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_buffer_size_ = buffer_length1;
#line 303 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp29_ = buffer;
#line 303 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp29__length1 = buffer_length1;
#line 303 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp30_ = data;
#line 303 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp31_ = buffer;
#line 303 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp31__length1 = buffer_length1;
#line 303 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	memcpy (_tmp29_, _tmp30_, (gsize) _tmp31__length1);
#line 305 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp32_ = buffer;
#line 305 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_tmp32__length1 = buffer_length1;
#line 305 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	if (result_length1) {
#line 305 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
		*result_length1 = _tmp32__length1;
#line 2805 "GPhoto.c"
	}
#line 305 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	result = _tmp32_;
#line 305 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	_gp_file_unref0 (camera_file);
#line 305 "/home/jens/Source/shotwell/src/camera/GPhoto.vala"
	return result;
#line 2813 "GPhoto.c"
}



