/* EventDirectoryItem.c generated by valac 0.32.1, the Vala compiler
 * generated from EventDirectoryItem.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_EVENT_DIRECTORY_ITEM (event_directory_item_get_type ())
#define EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem))
#define EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))
#define IS_EVENT_DIRECTORY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_DIRECTORY_ITEM))
#define IS_EVENT_DIRECTORY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_DIRECTORY_ITEM))
#define EVENT_DIRECTORY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemClass))

typedef struct _EventDirectoryItem EventDirectoryItem;
typedef struct _EventDirectoryItemClass EventDirectoryItemClass;
typedef struct _EventDirectoryItemPrivate EventDirectoryItemPrivate;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_EVENT_SOURCE_COLLECTION (event_source_collection_get_type ())
#define EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollection))
#define EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))
#define IS_EVENT_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE_COLLECTION))
#define IS_EVENT_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE_COLLECTION))
#define EVENT_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE_COLLECTION, EventSourceCollectionClass))

typedef struct _EventSourceCollection EventSourceCollection;
typedef struct _EventSourceCollectionClass EventSourceCollectionClass;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _EventDirectoryItem {
	CheckerboardItem parent_instance;
	EventDirectoryItemPrivate * priv;
	Event* event;
};

struct _EventDirectoryItemClass {
	CheckerboardItemClass parent_class;
};

struct _EventDirectoryItemPrivate {
	GdkRectangle paul_lynde;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;


static gpointer event_directory_item_parent_class = NULL;
extern EventSourceCollection* event_global;
extern Scaling event_directory_item_squared_scaling;
Scaling event_directory_item_squared_scaling = {0};

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType event_directory_item_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
#define EVENT_DIRECTORY_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItemPrivate))
enum  {
	EVENT_DIRECTORY_ITEM_DUMMY_PROPERTY
};
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType event_source_collection_get_type (void) G_GNUC_CONST;
static void event_directory_item_on_events_altered (EventDirectoryItem* self, GeeMap* map);
static void _event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_to_fill_viewport (Dimensions* viewport, Scaling* result);
static gint event_directory_item_get_CROPPED_SCALE (void);
void dimensions_init (Dimensions *self, gint width, gint height);
EventDirectoryItem* event_directory_item_new (Event* event);
EventDirectoryItem* event_directory_item_construct (GType object_type, Event* event);
static gchar* event_directory_item_get_formatted_title (Event* event);
gchar* event_source_get_comment (EventSource* self);
CheckerboardItem* checkerboard_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
GType media_source_get_type (void) G_GNUC_CONST;
static void event_directory_item_get_paul_lynde_rect (MediaSource* source, GdkRectangle* result);
MediaSource* event_get_primary_source (Event* self);
void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim);
void dimensions_for_rectangle (GdkRectangle* rect, Dimensions* result);
void scaling_get_scaled_dimensions (Scaling *self, Dimensions* original, Dimensions* result);
GType photo_exception_get_type (void) G_GNUC_CONST;
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
static GdkPixbuf* event_directory_item_get_paul_lynde (MediaSource* media, GdkRectangle* paul_lynde, GError** error);
GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self, Scaling* scaling, GError** error);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
void clamp_rectangle (GdkRectangle* original, Dimensions* max, GdkRectangle* result);
gboolean media_source_collection_has_photo (GeeCollection* media);
GeeCollection* event_source_get_media (EventSource* self);
gboolean media_source_collection_has_video (GeeCollection* media);
gint event_source_get_media_count (EventSource* self);
gchar* event_get_formatted_daterange (Event* self);
gchar* data_object_get_name (DataObject* self);
gchar* guarded_markup_escape_text (const gchar* plain);
static void event_directory_item_real_exposed (CheckerboardItem* base);
gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf);
gchar* data_object_to_string (DataObject* self);
static void event_directory_item_update_comment (EventDirectoryItem* self, gboolean init);
void checkerboard_item_exposed (CheckerboardItem* self);
static void event_directory_item_real_unexposed (CheckerboardItem* base);
void checkerboard_item_unexposed (CheckerboardItem* self);
void checkerboard_item_set_title (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void event_directory_item_real_thumbnail_altered (ThumbnailView* base);
static void event_directory_item_real_paint_shadow (CheckerboardItem* base, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
void checkerboard_item_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
static void event_directory_item_real_paint_border (CheckerboardItem* base, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
void checkerboard_item_get_border_dimensions (Dimensions* object_dim, gint border_width, Dimensions* result);
void checkerboard_item_get_border_origin (GdkPoint* object_origin, gint border_width, GdkPoint* result);
void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
static void event_directory_item_real_paint_image (CheckerboardItem* base, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
void context_rounded_corners (cairo_t* cx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
gboolean is_string_empty (const gchar* s);
void checkerboard_item_clear_comment (CheckerboardItem* self);
void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
static void event_directory_item_finalize (GObject* obj);
static void _vala_event_directory_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _event_directory_item_on_events_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_on_events_altered ((EventDirectoryItem*) self, items);
#line 457 "EventDirectoryItem.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return self ? g_object_ref (self) : NULL;
#line 464 "EventDirectoryItem.c"
}


EventDirectoryItem* event_directory_item_construct (GType object_type, Event* event) {
	EventDirectoryItem * self = NULL;
	Event* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Dimensions _tmp5_ = {0};
	Event* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	Event* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	Event* _tmp12_ = NULL;
	Event* _tmp13_ = NULL;
	Event* _tmp14_ = NULL;
	MediaSource* _tmp15_ = NULL;
	MediaSource* _tmp16_ = NULL;
	GdkRectangle _tmp17_ = {0};
	GdkRectangle _tmp18_ = {0};
	Dimensions _tmp19_ = {0};
	EventSourceCollection* _tmp20_ = NULL;
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_EVENT (event), NULL);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_directory_item_get_CROPPED_SCALE ();
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = _tmp1_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = event_directory_item_get_CROPPED_SCALE ();
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = _tmp3_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&_tmp5_, _tmp2_, _tmp4_);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = event;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = event_directory_item_get_formatted_title (_tmp6_);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = _tmp7_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = event;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_EVENT_SOURCE, EventSource));
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = _tmp10_;
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = (EventDirectoryItem*) checkerboard_item_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_tmp5_, _tmp8_, _tmp11_, TRUE, PANGO_ALIGN_CENTER);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (_tmp11_);
#line 23 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (_tmp8_);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = event;
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (self->event);
#line 26 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->event = _tmp13_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = event;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp15_ = event_get_primary_source (_tmp14_);
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp16_ = _tmp15_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_get_paul_lynde_rect (_tmp16_, &_tmp17_);
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv->paul_lynde = _tmp17_;
#line 29 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp16_);
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp18_ = self->priv->paul_lynde;
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_rectangle (&_tmp18_, &_tmp19_);
#line 32 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp19_);
#line 35 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp20_ = event_global;
#line 35 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self, 0);
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return self;
#line 555 "EventDirectoryItem.c"
}


EventDirectoryItem* event_directory_item_new (Event* event) {
#line 22 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return event_directory_item_construct (TYPE_EVENT_DIRECTORY_ITEM, event);
#line 562 "EventDirectoryItem.c"
}


static void event_directory_item_get_paul_lynde_rect (MediaSource* source, GdkRectangle* result) {
	Dimensions scaled = {0};
	MediaSource* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	Dimensions _tmp2_ = {0};
	GdkRectangle paul_lynde = {0};
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Dimensions _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Dimensions _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	Dimensions _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
#line 43 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_MEDIA_SOURCE (source));
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = source;
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	media_source_get_dimensions (_tmp0_, PHOTO_EXCEPTION_NONE, &_tmp1_);
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaling_get_scaled_dimensions (&event_directory_item_squared_scaling, &_tmp1_, &_tmp2_);
#line 44 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaled = _tmp2_;
#line 46 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	memset (&paul_lynde, 0, sizeof (GdkRectangle));
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = scaled;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = _tmp3_.width;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = event_directory_item_get_CROPPED_SCALE ();
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = _tmp5_;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = scaled;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = _tmp7_.width;
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = CLAMP (_tmp4_ - _tmp6_, 0, _tmp8_);
#line 47 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.x = _tmp9_ / 2;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = scaled;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = _tmp10_.height;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = event_directory_item_get_CROPPED_SCALE ();
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = _tmp12_;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = scaled;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp15_ = _tmp14_.height;
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp16_ = CLAMP (_tmp11_ - _tmp13_, 0, _tmp15_);
#line 48 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.y = _tmp16_ / 2;
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp17_ = event_directory_item_get_CROPPED_SCALE ();
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp18_ = _tmp17_;
#line 49 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.width = _tmp18_;
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp19_ = event_directory_item_get_CROPPED_SCALE ();
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp20_ = _tmp19_;
#line 50 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	paul_lynde.height = _tmp20_;
#line 52 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	*result = paul_lynde;
#line 52 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return;
#line 650 "EventDirectoryItem.c"
}


static GdkPixbuf* event_directory_item_get_paul_lynde (MediaSource* media, GdkRectangle* paul_lynde, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	MediaSource* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	GdkPixbuf* _tmp2_ = NULL;
	Dimensions thumbnail_dimensions = {0};
	GdkPixbuf* _tmp3_ = NULL;
	Dimensions _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	Dimensions _tmp6_ = {0};
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	gint _tmp9_ = 0;
	GdkRectangle _tmp23_ = {0};
	Dimensions _tmp24_ = {0};
	GdkRectangle _tmp25_ = {0};
	GdkPixbuf* _tmp26_ = NULL;
	GdkRectangle _tmp27_ = {0};
	gint _tmp28_ = 0;
	GdkRectangle _tmp29_ = {0};
	gint _tmp30_ = 0;
	GdkRectangle _tmp31_ = {0};
	gint _tmp32_ = 0;
	GdkRectangle _tmp33_ = {0};
	gint _tmp34_ = 0;
	GdkPixbuf* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
#line 56 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
#line 56 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (paul_lynde != NULL, NULL);
#line 57 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = media;
#line 57 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_directory_item_squared_scaling;
#line 57 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = media_source_get_preview_pixbuf (_tmp0_, &_tmp1_, &_inner_error_);
#line 57 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	pixbuf = _tmp2_;
#line 57 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 57 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return NULL;
#line 700 "EventDirectoryItem.c"
	}
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = pixbuf;
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_pixbuf (_tmp3_, &_tmp4_);
#line 59 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	thumbnail_dimensions = _tmp4_;
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = thumbnail_dimensions;
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = _tmp6_.width;
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = *paul_lynde;
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = _tmp8_.width;
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp7_ > (2 * _tmp9_)) {
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = TRUE;
#line 720 "EventDirectoryItem.c"
	} else {
		Dimensions _tmp10_ = {0};
		gint _tmp11_ = 0;
		GdkRectangle _tmp12_ = {0};
		gint _tmp13_ = 0;
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp10_ = thumbnail_dimensions;
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp11_ = _tmp10_.height;
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp12_ = *paul_lynde;
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp13_ = _tmp12_.height;
#line 62 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = _tmp11_ > (_tmp13_ * 2);
#line 736 "EventDirectoryItem.c"
	}
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp5_) {
#line 740 "EventDirectoryItem.c"
		LibraryPhoto* photo = NULL;
		MediaSource* _tmp14_ = NULL;
		LibraryPhoto* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
		LibraryPhoto* _tmp17_ = NULL;
		Scaling _tmp18_ = {0};
		GdkPixbuf* _tmp19_ = NULL;
		GdkPixbuf* _tmp20_ = NULL;
		GdkPixbuf* _tmp21_ = NULL;
		Dimensions _tmp22_ = {0};
#line 63 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp14_ = media;
#line 63 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 63 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		photo = _tmp15_;
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp17_ = photo;
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp18_ = event_directory_item_squared_scaling;
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp19_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp18_, &_inner_error_);
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp16_ = _tmp19_;
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_propagate_error (error, _inner_error_);
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (photo);
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (pixbuf);
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			return NULL;
#line 775 "EventDirectoryItem.c"
		}
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp20_ = _tmp16_;
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp16_ = NULL;
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (pixbuf);
#line 64 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		pixbuf = _tmp20_;
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp21_ = pixbuf;
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		dimensions_for_pixbuf (_tmp21_, &_tmp22_);
#line 65 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		thumbnail_dimensions = _tmp22_;
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp16_);
#line 61 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (photo);
#line 795 "EventDirectoryItem.c"
	}
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp23_ = *paul_lynde;
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp24_ = thumbnail_dimensions;
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	clamp_rectangle (&_tmp23_, &_tmp24_, &_tmp25_);
#line 69 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	*paul_lynde = _tmp25_;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp26_ = pixbuf;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp27_ = *paul_lynde;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp28_ = _tmp27_.x;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp29_ = *paul_lynde;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp30_ = _tmp29_.y;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp31_ = *paul_lynde;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp32_ = _tmp31_.width;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp33_ = *paul_lynde;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp34_ = _tmp33_.height;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp35_ = gdk_pixbuf_new_subpixbuf (_tmp26_, _tmp28_, _tmp30_, _tmp32_, _tmp34_);
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	result = _tmp35_;
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (pixbuf);
#line 72 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return result;
#line 831 "EventDirectoryItem.c"
}


static gchar* event_directory_item_get_formatted_title (Event* event) {
	gchar* result = NULL;
	gboolean has_photos = FALSE;
	Event* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean has_videos = FALSE;
	Event* _tmp5_ = NULL;
	GeeCollection* _tmp6_ = NULL;
	GeeCollection* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint count = 0;
	Event* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gchar* count_text = NULL;
	gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gchar* daterange = NULL;
	Event* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* name = NULL;
	Event* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp34_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_val_if_fail (IS_EVENT (event), NULL);
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event;
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT_SOURCE, EventSource));
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = _tmp1_;
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = media_source_collection_has_photo (_tmp2_);
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = _tmp3_;
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp2_);
#line 77 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	has_photos = _tmp4_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = event;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = event_source_get_media (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_EVENT_SOURCE, EventSource));
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = _tmp6_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = media_source_collection_has_video (_tmp7_);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = _tmp8_;
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (_tmp7_);
#line 78 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	has_videos = _tmp9_;
#line 80 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = event;
#line 80 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = event_source_get_media_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_EVENT_SOURCE, EventSource));
#line 80 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	count = _tmp11_;
#line 81 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = g_strdup ("");
#line 81 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	count_text = _tmp12_;
#line 82 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = has_photos;
#line 82 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp14_) {
#line 908 "EventDirectoryItem.c"
		gboolean _tmp15_ = FALSE;
#line 82 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp15_ = has_videos;
#line 82 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp13_ = _tmp15_;
#line 914 "EventDirectoryItem.c"
	} else {
#line 82 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp13_ = FALSE;
#line 918 "EventDirectoryItem.c"
	}
#line 82 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp13_) {
#line 922 "EventDirectoryItem.c"
		gint _tmp16_ = 0;
		const gchar* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp16_ = count;
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp17_ = ngettext ("%d Photo/Video", "%d Photos/Videos", (gulong) _tmp16_);
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp18_ = count;
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp19_ = g_strdup_printf (_tmp17_, _tmp18_);
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 83 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		count_text = _tmp19_;
#line 939 "EventDirectoryItem.c"
	} else {
		gboolean _tmp20_ = FALSE;
#line 84 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp20_ = has_videos;
#line 84 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (_tmp20_) {
#line 946 "EventDirectoryItem.c"
			gint _tmp21_ = 0;
			const gchar* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gchar* _tmp24_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp21_ = count;
#line 85 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp22_ = ngettext ("%d Video", "%d Videos", (gulong) _tmp21_);
#line 85 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp23_ = count;
#line 85 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp24_ = g_strdup_printf (_tmp22_, _tmp23_);
#line 85 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (count_text);
#line 85 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			count_text = _tmp24_;
#line 963 "EventDirectoryItem.c"
		} else {
			gint _tmp25_ = 0;
			const gchar* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gchar* _tmp28_ = NULL;
#line 87 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp25_ = count;
#line 87 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp26_ = ngettext ("%d Photo", "%d Photos", (gulong) _tmp25_);
#line 87 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp27_ = count;
#line 87 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp28_ = g_strdup_printf (_tmp26_, _tmp27_);
#line 87 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (count_text);
#line 87 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			count_text = _tmp28_;
#line 981 "EventDirectoryItem.c"
		}
	}
#line 89 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp29_ = event;
#line 89 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp30_ = event_get_formatted_daterange (_tmp29_);
#line 89 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	daterange = _tmp30_;
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp31_ = event;
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp32_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_DATA_OBJECT, DataObject));
#line 90 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	name = _tmp32_;
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp34_ = daterange;
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp34_ == NULL) {
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp33_ = TRUE;
#line 1002 "EventDirectoryItem.c"
	} else {
		const gchar* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp35_ = daterange;
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp36_ = name;
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp33_ = g_strcmp0 (_tmp35_, _tmp36_) == 0;
#line 1012 "EventDirectoryItem.c"
	}
#line 94 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp33_) {
#line 1016 "EventDirectoryItem.c"
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp37_ = name;
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp38_ = guarded_markup_escape_text (_tmp37_);
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp39_ = _tmp38_;
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp40_ = count_text;
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp41_ = guarded_markup_escape_text (_tmp40_);
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp42_ = _tmp41_;
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp43_ = g_strdup_printf ("<b>%s</b>\n%s", _tmp39_, _tmp42_);
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp44_ = _tmp43_;
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp42_);
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp39_);
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		result = _tmp44_;
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (name);
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (daterange);
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 95 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return result;
#line 1055 "EventDirectoryItem.c"
	} else {
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp45_ = name;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp46_ = guarded_markup_escape_text (_tmp45_);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp47_ = _tmp46_;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp48_ = count_text;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp49_ = guarded_markup_escape_text (_tmp48_);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp50_ = _tmp49_;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp51_ = daterange;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp52_ = guarded_markup_escape_text (_tmp51_);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp53_ = _tmp52_;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp54_ = g_strdup_printf ("<b>%s</b>\n%s\n%s", _tmp47_, _tmp50_, _tmp53_);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp55_ = _tmp54_;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp53_);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp50_);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp47_);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		result = _tmp55_;
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (name);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (daterange);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (count_text);
#line 98 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return result;
#line 1106 "EventDirectoryItem.c"
	}
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (name);
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (daterange);
#line 76 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (count_text);
#line 1114 "EventDirectoryItem.c"
}


static void event_directory_item_real_exposed (CheckerboardItem* base) {
	EventDirectoryItem * self;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 103 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 103 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp0_) {
#line 104 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1130 "EventDirectoryItem.c"
	}
	{
		GdkPixbuf* _tmp1_ = NULL;
		Event* _tmp2_ = NULL;
		MediaSource* _tmp3_ = NULL;
		MediaSource* _tmp4_ = NULL;
		GdkRectangle _tmp5_ = {0};
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp2_ = self->event;
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp3_ = event_get_primary_source (_tmp2_);
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = _tmp3_;
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = self->priv->paul_lynde;
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp6_ = event_directory_item_get_paul_lynde (_tmp4_, &_tmp5_, &_inner_error_);
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp7_ = _tmp6_;
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp4_);
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp1_ = _tmp7_;
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1158 "EventDirectoryItem.c"
			goto __catch49_g_error;
		}
#line 107 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp1_);
#line 106 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_object_unref0 (_tmp1_);
#line 1165 "EventDirectoryItem.c"
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* err = NULL;
		Event* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		err = _inner_error_;
#line 106 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_inner_error_ = NULL;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp8_ = self->event;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_OBJECT, DataObject));
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp10_ = _tmp9_;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp11_ = err;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp12_ = _tmp11_->message;
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_critical ("EventDirectoryItem.vala:109: Unable to fetch preview for %s: %s", _tmp10_, _tmp12_);
#line 109 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp10_);
#line 106 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_error_free0 (err);
#line 1196 "EventDirectoryItem.c"
	}
	__finally49:
#line 106 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 106 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1207 "EventDirectoryItem.c"
	}
#line 112 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_update_comment (self, FALSE);
#line 114 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1213 "EventDirectoryItem.c"
}


static void event_directory_item_real_unexposed (CheckerboardItem* base) {
	EventDirectoryItem * self;
	gboolean _tmp0_ = FALSE;
	GdkRectangle _tmp1_ = {0};
	Dimensions _tmp2_ = {0};
#line 117 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 118 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 118 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (!_tmp0_) {
#line 119 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		return;
#line 1230 "EventDirectoryItem.c"
	}
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = self->priv->paul_lynde;
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_rectangle (&_tmp1_, &_tmp2_);
#line 121 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp2_);
#line 123 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1240 "EventDirectoryItem.c"
}


static void event_directory_item_on_events_altered (EventDirectoryItem* self, GeeMap* map) {
	GeeMap* _tmp0_ = NULL;
	Event* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 126 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
#line 126 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (GEE_IS_MAP (map));
#line 127 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_update_comment (self, FALSE);
#line 128 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = map;
#line 128 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = self->event;
#line 128 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = gee_map_has_key (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_OBJECT, DataObject));
#line 128 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp2_) {
#line 1262 "EventDirectoryItem.c"
		Event* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp3_ = self->event;
#line 129 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = event_directory_item_get_formatted_title (_tmp3_);
#line 129 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = _tmp4_;
#line 129 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp5_, TRUE, PANGO_ALIGN_CENTER);
#line 129 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_g_free0 (_tmp5_);
#line 1276 "EventDirectoryItem.c"
	}
}


static void event_directory_item_real_thumbnail_altered (ThumbnailView* base) {
	EventDirectoryItem * self;
	MediaSource* media = NULL;
	Event* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	MediaSource* _tmp2_ = NULL;
	GdkRectangle _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
#line 132 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 133 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = self->event;
#line 133 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_get_primary_source (_tmp0_);
#line 133 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	media = _tmp1_;
#line 136 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = media;
#line 136 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_get_paul_lynde_rect (_tmp2_, &_tmp3_);
#line 136 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv->paul_lynde = _tmp3_;
#line 138 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = checkerboard_item_is_exposed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 138 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp4_) {
#line 1308 "EventDirectoryItem.c"
		{
			GdkPixbuf* _tmp5_ = NULL;
			MediaSource* _tmp6_ = NULL;
			GdkRectangle _tmp7_ = {0};
			GdkPixbuf* _tmp8_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp6_ = media;
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp7_ = self->priv->paul_lynde;
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp8_ = event_directory_item_get_paul_lynde (_tmp6_, &_tmp7_, &_inner_error_);
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp5_ = _tmp8_;
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1324 "EventDirectoryItem.c"
				goto __catch50_g_error;
			}
#line 140 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp5_);
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (_tmp5_);
#line 1331 "EventDirectoryItem.c"
		}
		goto __finally50;
		__catch50_g_error:
		{
			GError* err = NULL;
			Event* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			err = _inner_error_;
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_inner_error_ = NULL;
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp9_ = self->event;
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp11_ = _tmp10_;
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp12_ = err;
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp13_ = _tmp12_->message;
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_critical ("EventDirectoryItem.vala:142: Unable to fetch preview for %s: %s", _tmp11_, _tmp13_);
#line 142 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_free0 (_tmp11_);
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_error_free0 (err);
#line 1362 "EventDirectoryItem.c"
		}
		__finally50:
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_g_object_unref0 (media);
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			g_clear_error (&_inner_error_);
#line 139 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			return;
#line 1375 "EventDirectoryItem.c"
		}
	} else {
		GdkRectangle _tmp14_ = {0};
		Dimensions _tmp15_ = {0};
#line 145 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp14_ = self->priv->paul_lynde;
#line 145 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		dimensions_for_rectangle (&_tmp14_, &_tmp15_);
#line 145 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp15_);
#line 1386 "EventDirectoryItem.c"
	}
#line 148 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	THUMBNAIL_VIEW_CLASS (event_directory_item_parent_class)->thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), TYPE_THUMBNAIL_VIEW, ThumbnailView));
#line 132 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (media);
#line 1392 "EventDirectoryItem.c"
}


static void event_directory_item_real_paint_shadow (CheckerboardItem* base, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha) {
	EventDirectoryItem * self;
	Dimensions altered = {0};
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gint _tmp3_ = 0;
	cairo_t* _tmp4_ = NULL;
	Dimensions _tmp5_ = {0};
	GdkPoint _tmp6_ = {0};
	gfloat _tmp7_ = 0.0F;
#line 151 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 151 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 151 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (dimensions != NULL);
#line 151 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (origin != NULL);
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = *dimensions;
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = _tmp0_.width;
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = *dimensions;
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = _tmp2_.height;
#line 153 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&altered, _tmp1_ - 25, _tmp3_ - 25);
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = ctx;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp5_ = altered;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = *origin;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = initial_alpha;
#line 154 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	CHECKERBOARD_ITEM_CLASS (event_directory_item_parent_class)->paint_shadow (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp4_, &_tmp5_, &_tmp6_, 36, _tmp7_);
#line 1435 "EventDirectoryItem.c"
}


static void event_directory_item_real_paint_border (CheckerboardItem* base, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width) {
	EventDirectoryItem * self;
	Dimensions dimensions = {0};
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	GdkPoint origin = {0};
	GdkPoint _tmp3_ = {0};
	gint _tmp4_ = 0;
	GdkPoint _tmp5_ = {0};
	cairo_t* _tmp6_ = NULL;
	Dimensions _tmp7_ = {0};
	GdkPoint _tmp8_ = {0};
#line 157 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 157 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 157 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (object_dimensions != NULL);
#line 157 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (object_origin != NULL);
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = *object_dimensions;
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = border_width;
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_get_border_dimensions (&_tmp0_, _tmp1_, &_tmp2_);
#line 159 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions = _tmp2_;
#line 160 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = *object_origin;
#line 160 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp4_ = border_width;
#line 160 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	checkerboard_item_get_border_origin (&_tmp3_, _tmp4_, &_tmp5_);
#line 160 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	origin = _tmp5_;
#line 162 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp6_ = ctx;
#line 162 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = dimensions;
#line 162 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = origin;
#line 162 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	draw_rounded_corners_filled (_tmp6_, &_tmp7_, &_tmp8_, 6.0);
#line 1484 "EventDirectoryItem.c"
}


static void event_directory_item_real_paint_image (CheckerboardItem* base, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin) {
	EventDirectoryItem * self;
	Dimensions dimensions = {0};
	GdkPixbuf* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	GdkPixbuf* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	cairo_t* _tmp7_ = NULL;
	Dimensions _tmp8_ = {0};
	GdkPoint _tmp9_ = {0};
	cairo_t* _tmp10_ = NULL;
	GdkPixbuf* _tmp11_ = NULL;
	GdkPoint _tmp12_ = {0};
	gint _tmp13_ = 0;
	GdkPoint _tmp14_ = {0};
	gint _tmp15_ = 0;
	cairo_t* _tmp16_ = NULL;
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (ctx != NULL);
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 165 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (origin != NULL);
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = pixbuf;
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_for_pixbuf (_tmp0_, &_tmp1_);
#line 167 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions = _tmp1_;
#line 169 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = pixbuf;
#line 169 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = gdk_pixbuf_get_has_alpha (_tmp2_);
#line 169 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp3_) {
#line 1525 "EventDirectoryItem.c"
		cairo_t* _tmp4_ = NULL;
		Dimensions _tmp5_ = {0};
		GdkPoint _tmp6_ = {0};
#line 170 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = ctx;
#line 170 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp5_ = dimensions;
#line 170 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp6_ = *origin;
#line 170 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		draw_rounded_corners_filled (_tmp4_, &_tmp5_, &_tmp6_, 6.0);
#line 1537 "EventDirectoryItem.c"
	}
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp7_ = ctx;
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp8_ = dimensions;
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp9_ = *origin;
#line 173 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	context_rounded_corners (_tmp7_, &_tmp8_, &_tmp9_, 6.0);
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp10_ = ctx;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp11_ = pixbuf;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp12_ = *origin;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp13_ = _tmp12_.x;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp14_ = *origin;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp15_ = _tmp14_.y;
#line 174 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	gdk_cairo_set_source_pixbuf (_tmp10_, _tmp11_, (gdouble) _tmp13_, (gdouble) _tmp15_);
#line 175 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp16_ = ctx;
#line 175 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	cairo_paint (_tmp16_);
#line 1565 "EventDirectoryItem.c"
}


static void event_directory_item_update_comment (EventDirectoryItem* self, gboolean init) {
	gchar* comment = NULL;
	Event* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 178 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_return_if_fail (IS_EVENT_DIRECTORY_ITEM (self));
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = self->event;
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_EVENT_SOURCE, EventSource));
#line 179 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	comment = _tmp1_;
#line 180 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = comment;
#line 180 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 180 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	if (_tmp3_) {
#line 181 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		checkerboard_item_clear_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1591 "EventDirectoryItem.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 182 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		_tmp4_ = init;
#line 182 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		if (!_tmp4_) {
#line 1598 "EventDirectoryItem.c"
			const gchar* _tmp5_ = NULL;
#line 183 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			_tmp5_ = comment;
#line 183 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp5_, FALSE, PANGO_ALIGN_LEFT);
#line 1604 "EventDirectoryItem.c"
		} else {
#line 185 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), "", FALSE, PANGO_ALIGN_LEFT);
#line 1608 "EventDirectoryItem.c"
		}
	}
#line 178 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_free0 (comment);
#line 1613 "EventDirectoryItem.c"
}


static gint event_directory_item_get_CROPPED_SCALE (void) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_BIG);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	result = _tmp0_ + ((_tmp1_ - _tmp2_) / 2);
#line 10 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	return result;
#line 1632 "EventDirectoryItem.c"
}


static void event_directory_item_class_init (EventDirectoryItemClass * klass) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Dimensions _tmp4_ = {0};
	Scaling _tmp5_ = {0};
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_type_class_add_private (klass, sizeof (EventDirectoryItemPrivate));
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->exposed = event_directory_item_real_exposed;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->unexposed = event_directory_item_real_unexposed;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((ThumbnailViewClass *) klass)->thumbnail_altered = event_directory_item_real_thumbnail_altered;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_shadow = event_directory_item_real_paint_shadow;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_border = event_directory_item_real_paint_border;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	((CheckerboardItemClass *) klass)->paint_image = event_directory_item_real_paint_image;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_event_directory_item_get_property;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (klass)->finalize = event_directory_item_finalize;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event_directory_item_get_CROPPED_SCALE ();
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp1_ = _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp2_ = event_directory_item_get_CROPPED_SCALE ();
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp3_ = _tmp2_;
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	scaling_to_fill_viewport (&_tmp4_, &_tmp5_);
#line 15 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	event_directory_item_squared_scaling = _tmp5_;
#line 1677 "EventDirectoryItem.c"
}


static void event_directory_item_instance_init (EventDirectoryItem * self) {
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self->priv = EVENT_DIRECTORY_ITEM_GET_PRIVATE (self);
#line 20 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	memset (&self->priv->paul_lynde, 0, sizeof (GdkRectangle));
#line 1686 "EventDirectoryItem.c"
}


static void event_directory_item_finalize (GObject* obj) {
	EventDirectoryItem * self;
	EventSourceCollection* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_tmp0_ = event_global;
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 39 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _event_directory_item_on_events_altered_data_collection_items_altered, self);
#line 18 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	_g_object_unref0 (self->event);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	G_OBJECT_CLASS (event_directory_item_parent_class)->finalize (obj);
#line 1706 "EventDirectoryItem.c"
}


GType event_directory_item_get_type (void) {
	static volatile gsize event_directory_item_type_id__volatile = 0;
	if (g_once_init_enter (&event_directory_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EventDirectoryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_directory_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventDirectoryItem), 0, (GInstanceInitFunc) event_directory_item_instance_init, NULL };
		GType event_directory_item_type_id;
		event_directory_item_type_id = g_type_register_static (TYPE_CHECKERBOARD_ITEM, "EventDirectoryItem", &g_define_type_info, 0);
		g_once_init_leave (&event_directory_item_type_id__volatile, event_directory_item_type_id);
	}
	return event_directory_item_type_id__volatile;
}


static void _vala_event_directory_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	EventDirectoryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EVENT_DIRECTORY_ITEM, EventDirectoryItem);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
	switch (property_id) {
#line 1727 "EventDirectoryItem.c"
		default:
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 7 "/home/jens/Source/shotwell/src/events/EventDirectoryItem.vala"
		break;
#line 1733 "EventDirectoryItem.c"
	}
}



