/* Workers.c generated by valac 0.34.2, the Vala compiler
 * generated from Workers.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
typedef struct _SortedListPrivate SortedListPrivate;

#define TYPE_BACKGROUND_JOB_BATCH (background_job_batch_get_type ())
#define BACKGROUND_JOB_BATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB_BATCH, BackgroundJobBatch))
#define BACKGROUND_JOB_BATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB_BATCH, BackgroundJobBatchClass))
#define IS_BACKGROUND_JOB_BATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB_BATCH))
#define IS_BACKGROUND_JOB_BATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB_BATCH))
#define BACKGROUND_JOB_BATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB_BATCH, BackgroundJobBatchClass))

typedef struct _BackgroundJobBatch BackgroundJobBatch;
typedef struct _BackgroundJobBatchClass BackgroundJobBatchClass;
typedef struct _BackgroundJobBatchPrivate BackgroundJobBatchPrivate;

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;
typedef struct _WorkersPrivate WorkersPrivate;

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_EVENT_SEMAPHORE (event_semaphore_get_type ())
#define EVENT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SEMAPHORE, EventSemaphore))
#define EVENT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SEMAPHORE, EventSemaphoreClass))
#define IS_EVENT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SEMAPHORE))
#define IS_EVENT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SEMAPHORE))
#define EVENT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SEMAPHORE, EventSemaphoreClass))

typedef struct _EventSemaphore EventSemaphore;
typedef struct _EventSemaphoreClass EventSemaphoreClass;
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _abstract_semaphore_unref0(var) ((var == NULL) ? NULL : (var = (abstract_semaphore_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecWorkers ParamSpecWorkers;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SortedList {
	GObject parent_instance;
	SortedListPrivate * priv;
};

struct _SortedListClass {
	GObjectClass parent_class;
};

struct _BackgroundJobBatch {
	SortedList parent_instance;
	BackgroundJobBatchPrivate * priv;
};

struct _BackgroundJobBatchClass {
	SortedListClass parent_class;
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
struct _Workers {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WorkersPrivate * priv;
};

struct _WorkersClass {
	GTypeClass parent_class;
	void (*finalize) (Workers *self);
};

struct _WorkersPrivate {
	GThreadPool* thread_pool;
	GAsyncQueue* queue;
	GRecMutex __lock_queue;
	EventSemaphore* empty_event;
	gint enqueued;
};

struct _ParamSpecWorkers {
	GParamSpec parent_instance;
};


static gpointer background_job_batch_parent_class = NULL;
static gpointer workers_parent_class = NULL;

GType sorted_list_get_type (void) G_GNUC_CONST;
GType background_job_batch_get_type (void) G_GNUC_CONST;
enum  {
	BACKGROUND_JOB_BATCH_DUMMY_PROPERTY
};
BackgroundJobBatch* background_job_batch_new (void);
BackgroundJobBatch* background_job_batch_construct (GType object_type);
gint64 background_job_priority_comparator (void* a, void* b);
static gint64 _background_job_priority_comparator_comparator (void* a, void* b, gpointer self);
SortedList* sorted_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
SortedList* sorted_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, Comparator cmp, void* cmp_target);
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background_job (GValue* value, gpointer v_object);
void value_take_background_job (GValue* value, gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_abstract_semaphore (GValue* value, gpointer v_object);
void value_take_abstract_semaphore (GValue* value, gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
GType event_semaphore_get_type (void) G_GNUC_CONST;
#define WORKERS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_WORKERS, WorkersPrivate))
enum  {
	WORKERS_DUMMY_PROPERTY
};
static void _background_job_unref0_ (gpointer var);
EventSemaphore* event_semaphore_new (void);
EventSemaphore* event_semaphore_construct (GType object_type);
#define WORKERS_UNLIMITED_THREADS -1
Workers* workers_new (guint max_threads, gboolean exclusive);
Workers* workers_construct (GType object_type, guint max_threads, gboolean exclusive);
void abstract_semaphore_notify (AbstractSemaphore* self);
static void workers_thread_start (Workers* self, void* ignored);
static void _workers_thread_start_gfunc (gpointer data, gpointer self);
guint workers_threads_per_cpu (gint per, gint max);
guint workers_thread_per_cpu_minus_one (void);
void workers_enqueue (Workers* self, BackgroundJob* job);
gboolean abstract_semaphore_reset (AbstractSemaphore* self);
gint background_job_priority_compare_func (BackgroundJob* a, BackgroundJob* b);
static gint _background_job_priority_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
void workers_enqueue_many (Workers* self, BackgroundJobBatch* batch);
void workers_wait_for_empty_queue (Workers* self);
void abstract_semaphore_wait (AbstractSemaphore* self);
gint workers_get_pending_job_count (Workers* self);
gboolean background_job_is_cancelled (BackgroundJob* self);
void background_job_execute (BackgroundJob* self);
void background_job_internal_notify_completion (BackgroundJob* self);
static void workers_finalize (Workers* obj);


static gint64 _background_job_priority_comparator_comparator (void* a, void* b, gpointer self) {
	gint64 result;
	result = background_job_priority_comparator (a, b);
#line 10 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return result;
#line 204 "Workers.c"
}


BackgroundJobBatch* background_job_batch_construct (GType object_type) {
	BackgroundJobBatch * self = NULL;
#line 10 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	self = (BackgroundJobBatch*) sorted_list_construct (object_type, TYPE_BACKGROUND_JOB, (GBoxedCopyFunc) background_job_ref, background_job_unref, _background_job_priority_comparator_comparator, NULL);
#line 9 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return self;
#line 214 "Workers.c"
}


BackgroundJobBatch* background_job_batch_new (void) {
#line 9 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return background_job_batch_construct (TYPE_BACKGROUND_JOB_BATCH);
#line 221 "Workers.c"
}


static void background_job_batch_class_init (BackgroundJobBatchClass * klass) {
#line 8 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	background_job_batch_parent_class = g_type_class_peek_parent (klass);
#line 228 "Workers.c"
}


static void background_job_batch_instance_init (BackgroundJobBatch * self) {
}


GType background_job_batch_get_type (void) {
	static volatile gsize background_job_batch_type_id__volatile = 0;
	if (g_once_init_enter (&background_job_batch_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BackgroundJobBatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_job_batch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundJobBatch), 0, (GInstanceInitFunc) background_job_batch_instance_init, NULL };
		GType background_job_batch_type_id;
		background_job_batch_type_id = g_type_register_static (TYPE_SORTED_LIST, "BackgroundJobBatch", &g_define_type_info, 0);
		g_once_init_leave (&background_job_batch_type_id__volatile, background_job_batch_type_id);
	}
	return background_job_batch_type_id__volatile;
}


static void _background_job_unref0_ (gpointer var) {
#line 19 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	(var == NULL) ? NULL : (var = (background_job_unref (var), NULL));
#line 251 "Workers.c"
}


static void _workers_thread_start_gfunc (gpointer data, gpointer self) {
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	workers_thread_start ((Workers*) self, data);
#line 258 "Workers.c"
}


Workers* workers_construct (GType object_type, guint max_threads, gboolean exclusive) {
	Workers* self = NULL;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	EventSemaphore* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 23 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	self = (Workers*) g_type_create_instance (object_type);
#line 24 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp1_ = max_threads;
#line 24 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (_tmp1_ <= ((guint) 0)) {
#line 274 "Workers.c"
		guint _tmp2_ = 0U;
#line 24 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp2_ = max_threads;
#line 24 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp0_ = _tmp2_ != ((guint) WORKERS_UNLIMITED_THREADS);
#line 280 "Workers.c"
	} else {
#line 24 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp0_ = FALSE;
#line 284 "Workers.c"
	}
#line 24 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (_tmp0_) {
#line 25 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		max_threads = (guint) 1;
#line 290 "Workers.c"
	}
#line 28 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp3_ = self->priv->empty_event;
#line 28 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	abstract_semaphore_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
#line 296 "Workers.c"
	{
		GThreadPool* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
		GThreadPool* _tmp7_ = NULL;
		GThreadPool* _tmp8_ = NULL;
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp5_ = max_threads;
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp6_ = exclusive;
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp7_ = g_thread_pool_new (_workers_thread_start_gfunc, self, (gint) _tmp5_, _tmp6_, &_inner_error_);
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp4_ = _tmp7_;
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 315 "Workers.c"
				goto __catch6_g_thread_error;
			}
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_clear_error (&_inner_error_);
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			return NULL;
#line 324 "Workers.c"
		}
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp8_ = _tmp4_;
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp4_ = NULL;
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_g_thread_pool_free0 (self->priv->thread_pool);
#line 31 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		self->priv->thread_pool = _tmp8_;
#line 30 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_g_thread_pool_free0 (_tmp4_);
#line 336 "Workers.c"
	}
	goto __finally6;
	__catch6_g_thread_error:
	{
		GError* err = NULL;
		const gchar* _tmp9_ = NULL;
#line 30 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		err = _inner_error_;
#line 30 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_inner_error_ = NULL;
#line 33 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp9_ = err->message;
#line 33 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_error ("Workers.vala:33: Unable to create thread pool: %s", _tmp9_);
#line 30 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_g_error_free0 (err);
#line 353 "Workers.c"
	}
	__finally6:
#line 30 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 30 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 30 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_clear_error (&_inner_error_);
#line 30 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		return NULL;
#line 364 "Workers.c"
	}
#line 23 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return self;
#line 368 "Workers.c"
}


Workers* workers_new (guint max_threads, gboolean exclusive) {
#line 23 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return workers_construct (TYPE_WORKERS, max_threads, exclusive);
#line 375 "Workers.c"
}


guint workers_threads_per_cpu (gint per, gint max) {
	guint result = 0U;
	gint _tmp0_ = 0;
	guint count = 0U;
	guint _tmp1_ = 0U;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
#line 37 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp0_ = per;
#line 37 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_vala_return_val_if_fail (_tmp0_ > 0, "per > 0", 0U);
#line 38 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp1_ = g_get_num_processors ();
#line 38 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp2_ = per;
#line 38 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	count = _tmp1_ * _tmp2_;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp4_ = max;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (_tmp4_ < 0) {
#line 403 "Workers.c"
		guint _tmp5_ = 0U;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp5_ = count;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp3_ = _tmp5_;
#line 409 "Workers.c"
	} else {
		guint _tmp6_ = 0U;
		gint _tmp7_ = 0;
		guint _tmp8_ = 0U;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp6_ = count;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp7_ = max;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp8_ = CLAMP (_tmp6_, (guint) 0, (guint) _tmp7_);
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp3_ = _tmp8_;
#line 422 "Workers.c"
	}
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	result = _tmp3_;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp9_ = result;
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_vala_warn_if_fail (_tmp9_ > ((guint) 0), "result > 0");
#line 40 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return result;
#line 432 "Workers.c"
}


guint workers_thread_per_cpu_minus_one (void) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
#line 46 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp0_ = g_get_num_processors ();
#line 46 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp1_ = CLAMP (_tmp0_ - 1, (guint) 1, (guint) G_MAXINT);
#line 46 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	result = _tmp1_;
#line 46 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp2_ = result;
#line 46 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_vala_warn_if_fail (_tmp2_ > ((guint) 0), "result > 0");
#line 46 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return result;
#line 454 "Workers.c"
}


static gpointer _background_job_ref0 (gpointer self) {
#line 55 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return self ? background_job_ref (self) : NULL;
#line 461 "Workers.c"
}


static gint _background_job_priority_compare_func_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = background_job_priority_compare_func ((BackgroundJob*) a, (BackgroundJob*) b);
#line 55 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return result;
#line 470 "Workers.c"
}


void workers_enqueue (Workers* self, BackgroundJob* job) {
	EventSemaphore* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 51 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_if_fail (IS_WORKERS (self));
#line 51 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (job));
#line 52 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp0_ = self->priv->empty_event;
#line 52 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	abstract_semaphore_reset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
#line 485 "Workers.c"
	{
		GAsyncQueue* _tmp1_ = NULL;
#line 54 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp1_ = self->priv->queue;
#line 54 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_rec_mutex_lock (&self->priv->__lock_queue);
#line 492 "Workers.c"
		{
			GAsyncQueue* _tmp2_ = NULL;
			BackgroundJob* _tmp3_ = NULL;
			BackgroundJob* _tmp4_ = NULL;
			gint _tmp5_ = 0;
#line 55 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp2_ = self->priv->queue;
#line 55 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp3_ = job;
#line 55 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp4_ = _background_job_ref0 (_tmp3_);
#line 55 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_async_queue_push_sorted (_tmp2_, _tmp4_, _background_job_priority_compare_func_gcompare_data_func, NULL);
#line 56 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp5_ = self->priv->enqueued;
#line 56 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			self->priv->enqueued = _tmp5_ + 1;
#line 510 "Workers.c"
		}
		__finally7:
		{
			GAsyncQueue* _tmp6_ = NULL;
#line 54 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp6_ = self->priv->queue;
#line 54 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_rec_mutex_unlock (&self->priv->__lock_queue);
#line 519 "Workers.c"
		}
#line 54 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 54 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 54 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_clear_error (&_inner_error_);
#line 54 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			return;
#line 529 "Workers.c"
		}
	}
	{
		GThreadPool* _tmp7_ = NULL;
		BackgroundJob* _tmp8_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp7_ = self->priv->thread_pool;
#line 60 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp8_ = job;
#line 60 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_thread_pool_push (_tmp7_, _tmp8_, &_inner_error_);
#line 60 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 60 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 545 "Workers.c"
				goto __catch8_g_thread_error;
			}
#line 60 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 60 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_clear_error (&_inner_error_);
#line 60 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			return;
#line 554 "Workers.c"
		}
	}
	goto __finally8;
	__catch8_g_thread_error:
	{
		GError* err = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 59 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		err = _inner_error_;
#line 59 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_inner_error_ = NULL;
#line 64 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp9_ = err;
#line 64 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp10_ = _tmp9_->message;
#line 64 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_warning ("Workers.vala:64: Unable to create worker thread: %s", _tmp10_);
#line 59 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_g_error_free0 (err);
#line 575 "Workers.c"
	}
	__finally8:
#line 59 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 59 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_clear_error (&_inner_error_);
#line 59 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		return;
#line 586 "Workers.c"
	}
}


void workers_enqueue_many (Workers* self, BackgroundJobBatch* batch) {
#line 68 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_if_fail (IS_WORKERS (self));
#line 68 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_if_fail (IS_BACKGROUND_JOB_BATCH (batch));
#line 596 "Workers.c"
	{
		GeeIterator* _job_it = NULL;
		BackgroundJobBatch* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp0_ = batch;
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_job_it = _tmp1_;
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		while (TRUE) {
#line 609 "Workers.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			BackgroundJob* job = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			BackgroundJob* _tmp6_ = NULL;
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp2_ = _job_it;
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			if (!_tmp3_) {
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
				break;
#line 624 "Workers.c"
			}
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp4_ = _job_it;
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			job = (BackgroundJob*) _tmp5_;
#line 70 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp6_ = job;
#line 70 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			workers_enqueue (self, _tmp6_);
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_background_job_unref0 (job);
#line 638 "Workers.c"
		}
#line 69 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_g_object_unref0 (_job_it);
#line 642 "Workers.c"
	}
}


void workers_wait_for_empty_queue (Workers* self) {
	EventSemaphore* _tmp0_ = NULL;
#line 73 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_if_fail (IS_WORKERS (self));
#line 74 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp0_ = self->priv->empty_event;
#line 74 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	abstract_semaphore_wait (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
#line 655 "Workers.c"
}


gint workers_get_pending_job_count (Workers* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_val_if_fail (IS_WORKERS (self), 0);
#line 664 "Workers.c"
	{
		GAsyncQueue* _tmp0_ = NULL;
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp0_ = self->priv->queue;
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_rec_mutex_lock (&self->priv->__lock_queue);
#line 671 "Workers.c"
		{
			gint _tmp1_ = 0;
#line 80 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp1_ = self->priv->enqueued;
#line 80 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			result = _tmp1_;
#line 678 "Workers.c"
			{
				GAsyncQueue* _tmp2_ = NULL;
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
				_tmp2_ = self->priv->queue;
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
				g_rec_mutex_unlock (&self->priv->__lock_queue);
#line 685 "Workers.c"
			}
#line 80 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			return result;
#line 689 "Workers.c"
		}
		__finally9:
		{
			GAsyncQueue* _tmp3_ = NULL;
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp3_ = self->priv->queue;
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_rec_mutex_unlock (&self->priv->__lock_queue);
#line 698 "Workers.c"
		}
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_clear_error (&_inner_error_);
#line 79 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		return 0;
#line 706 "Workers.c"
	}
}


static void workers_thread_start (Workers* self, void* ignored) {
	BackgroundJob* job = NULL;
	gboolean empty = FALSE;
	gboolean _tmp7_ = FALSE;
	GError * _inner_error_ = NULL;
#line 84 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_if_fail (IS_WORKERS (self));
#line 718 "Workers.c"
	{
		GAsyncQueue* _tmp0_ = NULL;
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp0_ = self->priv->queue;
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_rec_mutex_lock (&self->priv->__lock_queue);
#line 725 "Workers.c"
		{
			GAsyncQueue* _tmp1_ = NULL;
			gpointer _tmp2_ = NULL;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			gint _tmp5_ = 0;
#line 88 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp1_ = self->priv->queue;
#line 88 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp2_ = g_async_queue_try_pop (_tmp1_);
#line 88 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_background_job_unref0 (job);
#line 88 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			job = (BackgroundJob*) _tmp2_;
#line 89 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_vala_assert (job != NULL, "job != null");
#line 91 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp3_ = self->priv->enqueued;
#line 91 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_vala_assert (_tmp3_ > 0, "enqueued > 0");
#line 92 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp4_ = self->priv->enqueued;
#line 92 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			self->priv->enqueued = _tmp4_ - 1;
#line 92 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp5_ = self->priv->enqueued;
#line 92 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			empty = _tmp5_ == 0;
#line 754 "Workers.c"
		}
		__finally10:
		{
			GAsyncQueue* _tmp6_ = NULL;
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_tmp6_ = self->priv->queue;
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_rec_mutex_unlock (&self->priv->__lock_queue);
#line 763 "Workers.c"
		}
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			_background_job_unref0 (job);
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			g_clear_error (&_inner_error_);
#line 87 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			return;
#line 775 "Workers.c"
		}
	}
#line 95 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp7_ = background_job_is_cancelled (job);
#line 95 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (!_tmp7_) {
#line 96 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		background_job_execute (job);
#line 784 "Workers.c"
	}
#line 98 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	background_job_internal_notify_completion (job);
#line 100 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (empty) {
#line 790 "Workers.c"
		EventSemaphore* _tmp8_ = NULL;
#line 101 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		_tmp8_ = self->priv->empty_event;
#line 101 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		abstract_semaphore_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore));
#line 796 "Workers.c"
	}
#line 84 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_background_job_unref0 (job);
#line 800 "Workers.c"
}


static void value_workers_init (GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	value->data[0].v_pointer = NULL;
#line 807 "Workers.c"
}


static void value_workers_free_value (GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		workers_unref (value->data[0].v_pointer);
#line 816 "Workers.c"
	}
}


static void value_workers_copy_value (const GValue* src_value, GValue* dest_value) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (src_value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		dest_value->data[0].v_pointer = workers_ref (src_value->data[0].v_pointer);
#line 826 "Workers.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		dest_value->data[0].v_pointer = NULL;
#line 830 "Workers.c"
	}
}


static gpointer value_workers_peek_pointer (const GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return value->data[0].v_pointer;
#line 838 "Workers.c"
}


static gchar* value_workers_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (collect_values[0].v_pointer) {
#line 845 "Workers.c"
		Workers* object;
		object = collect_values[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		if (object->parent_instance.g_class == NULL) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 852 "Workers.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 856 "Workers.c"
		}
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		value->data[0].v_pointer = workers_ref (object);
#line 860 "Workers.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		value->data[0].v_pointer = NULL;
#line 864 "Workers.c"
	}
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return NULL;
#line 868 "Workers.c"
}


static gchar* value_workers_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Workers** object_p;
	object_p = collect_values[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (!object_p) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 879 "Workers.c"
	}
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (!value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		*object_p = NULL;
#line 885 "Workers.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		*object_p = value->data[0].v_pointer;
#line 889 "Workers.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		*object_p = workers_ref (value->data[0].v_pointer);
#line 893 "Workers.c"
	}
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return NULL;
#line 897 "Workers.c"
}


GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecWorkers* spec;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_WORKERS), NULL);
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return G_PARAM_SPEC (spec);
#line 911 "Workers.c"
}


gpointer value_get_workers (const GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WORKERS), NULL);
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return value->data[0].v_pointer;
#line 920 "Workers.c"
}


void value_set_workers (GValue* value, gpointer v_object) {
	Workers* old;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WORKERS));
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	old = value->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (v_object) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WORKERS));
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		value->data[0].v_pointer = v_object;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		workers_ref (value->data[0].v_pointer);
#line 940 "Workers.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		value->data[0].v_pointer = NULL;
#line 944 "Workers.c"
	}
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (old) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		workers_unref (old);
#line 950 "Workers.c"
	}
}


void value_take_workers (GValue* value, gpointer v_object) {
	Workers* old;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_WORKERS));
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	old = value->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (v_object) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_WORKERS));
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		value->data[0].v_pointer = v_object;
#line 969 "Workers.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		value->data[0].v_pointer = NULL;
#line 973 "Workers.c"
	}
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (old) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		workers_unref (old);
#line 979 "Workers.c"
	}
}


static void workers_class_init (WorkersClass * klass) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	workers_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	((WorkersClass *) klass)->finalize = workers_finalize;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_type_class_add_private (klass, sizeof (WorkersPrivate));
#line 991 "Workers.c"
}


static void workers_instance_init (Workers * self) {
	GAsyncQueue* _tmp0_ = NULL;
	EventSemaphore* _tmp1_ = NULL;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	self->priv = WORKERS_GET_PRIVATE (self);
#line 19 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_rec_mutex_init (&self->priv->__lock_queue);
#line 19 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp0_ = g_async_queue_new_full (_background_job_unref0_);
#line 19 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	self->priv->queue = _tmp0_;
#line 20 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_tmp1_ = event_semaphore_new ();
#line 20 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	self->priv->empty_event = _tmp1_;
#line 21 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	self->priv->enqueued = 0;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	self->ref_count = 1;
#line 1014 "Workers.c"
}


static void workers_finalize (Workers* obj) {
	Workers * self;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORKERS, Workers);
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_signal_handlers_destroy (self);
#line 18 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_g_thread_pool_free0 (self->priv->thread_pool);
#line 19 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_rec_mutex_clear (&self->priv->__lock_queue);
#line 19 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_g_async_queue_unref0 (self->priv->queue);
#line 20 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	_abstract_semaphore_unref0 (self->priv->empty_event);
#line 1032 "Workers.c"
}


GType workers_get_type (void) {
	static volatile gsize workers_type_id__volatile = 0;
	if (g_once_init_enter (&workers_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_workers_init, value_workers_free_value, value_workers_copy_value, value_workers_peek_pointer, "p", value_workers_collect_value, "p", value_workers_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (WorkersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) workers_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Workers), 0, (GInstanceInitFunc) workers_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType workers_type_id;
		workers_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Workers", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&workers_type_id__volatile, workers_type_id);
	}
	return workers_type_id__volatile;
}


gpointer workers_ref (gpointer instance) {
	Workers* self;
	self = instance;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	g_atomic_int_inc (&self->ref_count);
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	return instance;
#line 1057 "Workers.c"
}


void workers_unref (gpointer instance) {
	Workers* self;
	self = instance;
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		WORKERS_GET_CLASS (self)->finalize (self);
#line 15 "/home/jens/Source/shotwell/src/threads/Workers.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1070 "Workers.c"
	}
}



