/* image.c generated by valac 0.34.1, the Vala compiler
 * generated from image.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* XPM */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_PIXEL_TRANSFORMER (pixel_transformer_get_type ())
#define PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformer))
#define PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))
#define IS_PIXEL_TRANSFORMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMER))
#define IS_PIXEL_TRANSFORMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMER))
#define PIXEL_TRANSFORMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMER, PixelTransformerClass))

typedef struct _PixelTransformer PixelTransformer;
typedef struct _PixelTransformerClass PixelTransformerClass;

#define TYPE_PIXEL_TRANSFORMATION (pixel_transformation_get_type ())
#define PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformation))
#define PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))
#define IS_PIXEL_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXEL_TRANSFORMATION))
#define IS_PIXEL_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXEL_TRANSFORMATION))
#define PIXEL_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXEL_TRANSFORMATION, PixelTransformationClass))

typedef struct _PixelTransformation PixelTransformation;
typedef struct _PixelTransformationClass PixelTransformationClass;

#define TYPE_RGB_TRANSFORMATION (rgb_transformation_get_type ())
#define RGB_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_TRANSFORMATION, RGBTransformation))
#define RGB_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_TRANSFORMATION, RGBTransformationClass))
#define IS_RGB_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_TRANSFORMATION))
#define IS_RGB_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_TRANSFORMATION))
#define RGB_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_TRANSFORMATION, RGBTransformationClass))

typedef struct _RGBTransformation RGBTransformation;
typedef struct _RGBTransformationClass RGBTransformationClass;

#define TYPE_SATURATION_TRANSFORMATION (saturation_transformation_get_type ())
#define SATURATION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SATURATION_TRANSFORMATION, SaturationTransformation))
#define SATURATION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationClass))
#define IS_SATURATION_TRANSFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SATURATION_TRANSFORMATION))
#define IS_SATURATION_TRANSFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SATURATION_TRANSFORMATION))
#define SATURATION_TRANSFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SATURATION_TRANSFORMATION, SaturationTransformationClass))

typedef struct _SaturationTransformation SaturationTransformation;
typedef struct _SaturationTransformationClass SaturationTransformationClass;
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Dimensions {
	gint width;
	gint height;
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};



gboolean is_color_parsable (const gchar* spec);
void parse_color (const gchar* spec, GdkRGBA* result);
void fetch_color (const gchar* spec, GdkRGBA* result);
void set_source_color_from_string (cairo_t* ctx, const gchar* spec);
#define MIN_SCALED_WIDTH 10
#define MIN_SCALED_HEIGHT 10
GdkPixbuf* get_placeholder_pixbuf (void);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf, gint scale, GdkInterpType interp, gboolean scale_up);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
void dimensions_get_scaled (Dimensions *self, gint scale, gboolean scale_up, Dimensions* result);
void dimensions_with_min (Dimensions *self, gint min_width, gint min_height, Dimensions* result);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
#define DEGREE (G_PI / 180.0)
void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
void context_rounded_corners (cairo_t* cx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
gint dimensions_minor_axis (Dimensions *self);
guchar shift_color_byte (gint b, gint shift);
void shift_colors (GdkPixbuf* pixbuf, gint red, gint green, gint blue, gint alpha);
void dim_pixbuf (GdkPixbuf* pixbuf);
gpointer pixel_transformer_ref (gpointer instance);
void pixel_transformer_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformer (GValue* value, gpointer v_object);
void value_take_pixel_transformer (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformer (const GValue* value);
GType pixel_transformer_get_type (void) G_GNUC_CONST;
PixelTransformer* pixel_transformer_new (void);
PixelTransformer* pixel_transformer_construct (GType object_type);
gpointer pixel_transformation_ref (gpointer instance);
void pixel_transformation_unref (gpointer instance);
GParamSpec* param_spec_pixel_transformation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pixel_transformation (GValue* value, gpointer v_object);
void value_take_pixel_transformation (GValue* value, gpointer v_object);
gpointer value_get_pixel_transformation (const GValue* value);
GType pixel_transformation_get_type (void) G_GNUC_CONST;
GType rgb_transformation_get_type (void) G_GNUC_CONST;
GType saturation_transformation_get_type (void) G_GNUC_CONST;
#define SATURATION_TRANSFORMATION_MIN_PARAMETER (-16.0f)
SaturationTransformation* saturation_transformation_new (gfloat client_parameter);
SaturationTransformation* saturation_transformation_construct (GType object_type, gfloat client_parameter);
void pixel_transformer_attach_transformation (PixelTransformer* self, PixelTransformation* trans);
void pixel_transformer_transform_pixbuf (PixelTransformer* self, GdkPixbuf* pixbuf, GCancellable* cancellable);
gboolean coord_in_rectangle (gint x, gint y, GdkRectangle* rect);
gboolean rectangles_equal (GdkRectangle* a, GdkRectangle* b);
gchar* rectangle_to_string (GdkRectangle* rect);
void clamp_rectangle (GdkRectangle* original, Dimensions* max, GdkRectangle* result);
void scale_point (GdkPoint* p, gdouble factor, GdkPoint* result);
void add_points (GdkPoint* p1, GdkPoint* p2, GdkPoint* result);
void subtract_points (GdkPoint* p1, GdkPoint* p2, GdkPoint* result);
void fix_cairo_pixbuf (GdkPixbuf* pixbuf);
void compute_arb_rotated_size (gdouble src_width, gdouble src_height, gdouble angle, gdouble* dest_width, gdouble* dest_height);
gdouble degrees_to_radians (gdouble theta);
GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf, gdouble angle);
void rotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, gboolean invert, GdkPoint* result);
void derotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, GdkPoint* result);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void clamp_inside_rotated_image (Box* src, gint img_w, gint img_h, gdouble angle_deg, gboolean preserve_geom, Box* result);
void box_get_offset (Box *self, gint xofs, gint yofs, Box* result);
void box_init (Box *self, gint left, gint top, gint right, gint bottom);

const gchar* fallback_image_missing[103] = {"48 48 54 1 ", "  c #6A6D67", ". c #6C6E69", "X c #72746F", "o c #747672", "O c #777974", "+ c #797B77", "@ c #7C7E7A", "# c #7F817C", "$ c #81837F", "% c #848682", "& c #878984", "* c #888A86", "= c #8C8D8A", "- c #8F908C", "; c #90928E", ": c #949591", "> c #969894", ", c #999B96", "< c #9C9E9A", "1 c #9FA09C", "2 c #A1A39E", "3 c #A4A6A2", "4 c #A6A9A4", "5 c #A9ABA6", "6 c #ACADA9", "7 c #AEB1AB", "8 c #B1B2AF", "9 c #B3B4B1", "0 c #B6B9B3", "q c #B9BCB6", "w c #BDBEBA", "e c #BEC2BB", "r c #C1C4BE", "t c #C5C5C2", "y c #C6C9C3", "u c #C9CCC6", "i c #CCCDCB", "p c #CED2CA", "a c #D2D6CE", "s c #D5D5D3", "d c #D7D8D5", "f c #D9D9D6", "g c #DCDCDA", "h c #DFE0DD", "j c #E0E0DE", "k c #E4E4E2", "l c #E7E8E5", "z c #E9E9E7", "x c #EDEDEC", "c c #EFF0EE", "v c #F1F1EF", "b c #F2F2F1", "n c #FFFFFF", "m c None", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmaaaaaaaaaasaisaaaaaaaaaaaaaaaaaaapppiipuuuuumm", "mannnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnym", "manbbbbbbbbbvbbvvvvxvvvbvvvvvvvvccccccxxvxvxxnym", "manbt89898888988888888888999999999999999999txnrm", "manb6======================-;;=;;;;;;;;;;=:7znrm", "manv6&%%**%*%%%%*%%****=======;==;;;;=;=;==7znem", "manv4%%%%$%%%%%%%%%%%=****=======;==-======6znwm", "manx3%%#$$$$##%#$%%%*%**==========-=--=====6znqm", "manx1$@%#$@$###%%%%=****=*===--;;----====*=5lnqm", "manx<@@@@@@@@##%$%%%%****========-==-======5kn0m", "manz<@@@+@+@@@#$%%%%%=%=%===;=:=--------=-*4kn8m", "manz>O+O+O+@@@#$$%%%%========;;=--------=*=3kn9m", "mpnl:OOOOO+@@$##%%%%%=%=====;=;;--;-----===3kn8m", "munl;OooOOO@@@#$%%%%%======;;;;;:;;;;;---==1hn7m", "munl;oXoOO+@###$%%=%=======;::;::::;;---&#+-gn7m", "mynk*XXooOO+$$#$%%%%=%===;;:;:::::;:-$#XooX-fn5m", "mynk*XXOOO@@$$$$%%=%====;::::>::;*#OXXXXXXX*dn5m", "mrnk*oOO@@@#$$$$%=====::::>>>=%@OXOooXXXooo&dn3m", "mrnj*++@$$$$**$===-;;::>>:=@Ooo@XOOoo#o#OOO=fn3m", "menj*@#$$$$$**===;;:::=%@@@@@@O@#O#Oo#o#++@;gn2m", "menj*$$$$&**===;:;=*#@@@@@@@@@@@#######o##%>gn2m", "menh*$$%**===;=*%###########%@@@###$####$%=,gn1m", "m0nj=%***=**&$$$%$$$%$$%$$$$%$$$$$$$$$$%*;:2hn<m", "m0nj****&&&$$&&$%%%%%%%%%%%%%%%%$$*$%%%*;>13gn,m", "m0ng****&&&&&&&&&&&&*%*%*%%*%******%**-:,136kz;m", "m0nh***$&&&&&&&&&&&&%**********%*$***;:,1358r7*m", "m8ng*&&&&&&&&&*$&*&&&&$=$=$=&&&&&&**=:,<11>$65mm", "m7ng*&&&&&&&&&**&&&&&&**=$-$&&&&&&*-:,1..&1wi:mm", "m7ng&&&&&&&&=$*$&&&&&***$$$$&&&***=>,1<onxsi6*mm", "m6nf*&&&&&*&$***&&&&*$*$--$-&&&%*=;,13,:ztw9%mmm", "m5nf*%&&&&&&=$=$%*&&**%*$$&&&&**=>,225;5srw%mmmm", "m4nf3*&&**&&$-$-*******%$;&&*&*->,2365+ui7$mmmmm", "m3nsfffdddsddaffssssdassgaaaassddfgjg4wu;ommmmmm", "m3nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnvq3<$.mmmmmmm", "mm2211111,<,,,,,,>>>>:::;::;----=====@mmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm", "mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm"};

gboolean is_color_parsable (const gchar* spec) {
	gboolean result = FALSE;
	GdkColor color = {0};
	const gchar* _tmp0_ = NULL;
	GdkColor _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 117 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (spec != NULL, FALSE);
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = spec;
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = gdk_color_parse (_tmp0_, &_tmp1_);
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	color = _tmp1_;
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp2_;
#line 119 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 180 "image.c"
}


void parse_color (const gchar* spec, GdkRGBA* result) {
	const gchar* _tmp0_ = NULL;
	GdkRGBA _tmp1_ = {0};
#line 122 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = spec;
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	fetch_color (_tmp0_, &_tmp1_);
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp1_;
#line 123 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 197 "image.c"
}


void fetch_color (const gchar* spec, GdkRGBA* result) {
	GdkRGBA rgba = {0};
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 126 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 127 "/home/jens/Source/shotwell/src/util/image.vala"
	memset (&rgba, 0, sizeof (GdkRGBA));
#line 128 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = spec;
#line 128 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = gdk_rgba_parse (&rgba, _tmp0_);
#line 128 "/home/jens/Source/shotwell/src/util/image.vala"
	if (!_tmp1_) {
#line 215 "image.c"
		const gchar* _tmp2_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = spec;
#line 129 "/home/jens/Source/shotwell/src/util/image.vala"
		g_error ("image.vala:129: Can't parse color %s", _tmp2_);
#line 221 "image.c"
	}
#line 131 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = rgba;
#line 131 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 227 "image.c"
}


void set_source_color_from_string (cairo_t* ctx, const gchar* spec) {
	GdkRGBA rgba = {0};
	const gchar* _tmp0_ = NULL;
	GdkRGBA _tmp1_ = {0};
	cairo_t* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	GdkRGBA _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	GdkRGBA _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	GdkRGBA _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
#line 134 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (ctx != NULL);
#line 134 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (spec != NULL);
#line 135 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = spec;
#line 135 "/home/jens/Source/shotwell/src/util/image.vala"
	fetch_color (_tmp0_, &_tmp1_);
#line 135 "/home/jens/Source/shotwell/src/util/image.vala"
	rgba = _tmp1_;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = ctx;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.red;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.green;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.blue;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = rgba;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = _tmp9_.alpha;
#line 136 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp10_);
#line 274 "image.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
	return self ? g_object_ref (self) : NULL;
#line 281 "image.c"
}


GdkPixbuf* get_placeholder_pixbuf (void) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GError * _inner_error_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/util/image.vala"
	pixbuf = NULL;
#line 291 "image.c"
	{
		GtkIconTheme* icon_theme = NULL;
		GtkIconTheme* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = gtk_icon_theme_get_default ();
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 147 "/home/jens/Source/shotwell/src/util/image.vala"
		icon_theme = _tmp1_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = gtk_icon_theme_load_icon (icon_theme, "image-missing", (gint) GTK_ICON_SIZE_DIALOG, 0, &_inner_error_);
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp3_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
			_g_object_unref0 (icon_theme);
#line 313 "image.c"
			goto __catch4_g_error;
		}
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp4_ = _tmp2_;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 148 "/home/jens/Source/shotwell/src/util/image.vala"
		pixbuf = _tmp4_;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (_tmp2_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (icon_theme);
#line 328 "image.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		GdkPixbuf* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_error_ = _inner_error_;
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_inner_error_ = NULL;
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = gdk_pixbuf_new_from_xpm_data (fallback_image_missing);
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 151 "/home/jens/Source/shotwell/src/util/image.vala"
		pixbuf = _tmp5_;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = _error_;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = _tmp6_->message;
#line 152 "/home/jens/Source/shotwell/src/util/image.vala"
		g_warning ("image.vala:152: Could not load icon from theme: %s", _tmp7_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_error_free0 (_error_);
#line 355 "image.c"
	}
	__finally4:
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		_g_object_unref0 (pixbuf);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/util/image.vala"
		return NULL;
#line 368 "image.c"
	}
#line 155 "/home/jens/Source/shotwell/src/util/image.vala"
	result = pixbuf;
#line 155 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 374 "image.c"
}


GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf, gint scale, GdkInterpType interp, gboolean scale_up) {
	GdkPixbuf* result = NULL;
	Dimensions original = {0};
	GdkPixbuf* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	Dimensions scaled = {0};
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	Dimensions _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	Dimensions _tmp6_ = {0};
	gint _tmp7_ = 0;
	Dimensions _tmp8_ = {0};
	gint _tmp9_ = 0;
	Dimensions _tmp16_ = {0};
	GdkPixbuf* _tmp17_ = NULL;
	Dimensions _tmp18_ = {0};
	gint _tmp19_ = 0;
	Dimensions _tmp20_ = {0};
	gint _tmp21_ = 0;
	GdkInterpType _tmp22_ = 0;
	GdkPixbuf* _tmp23_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 159 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = pixbuf;
#line 159 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_for_pixbuf (_tmp0_, &_tmp1_);
#line 159 "/home/jens/Source/shotwell/src/util/image.vala"
	original = _tmp1_;
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = scale;
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = scale_up;
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_get_scaled (&original, _tmp2_, _tmp3_, &_tmp4_);
#line 160 "/home/jens/Source/shotwell/src/util/image.vala"
	scaled = _tmp4_;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = original;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.width;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = scaled;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = _tmp8_.width;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp7_ == _tmp9_) {
#line 426 "image.c"
		Dimensions _tmp10_ = {0};
		gint _tmp11_ = 0;
		Dimensions _tmp12_ = {0};
		gint _tmp13_ = 0;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = original;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = _tmp10_.height;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = scaled;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = _tmp12_.height;
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = _tmp11_ == _tmp13_;
#line 441 "image.c"
	} else {
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = FALSE;
#line 445 "image.c"
	}
#line 161 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp5_) {
#line 449 "image.c"
		GdkPixbuf* _tmp14_ = NULL;
		GdkPixbuf* _tmp15_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = pixbuf;
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp15_;
#line 162 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 460 "image.c"
	}
#line 165 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_with_min (&scaled, MIN_SCALED_WIDTH, MIN_SCALED_HEIGHT, &_tmp16_);
#line 165 "/home/jens/Source/shotwell/src/util/image.vala"
	scaled = _tmp16_;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = pixbuf;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = scaled;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = _tmp18_.width;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = scaled;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = _tmp20_.height;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_ = interp;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = gdk_pixbuf_scale_simple (_tmp17_, _tmp19_, _tmp21_, _tmp22_);
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp23_;
#line 167 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 484 "image.c"
}


GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp) {
	GdkPixbuf* result = NULL;
	Dimensions original = {0};
	GdkPixbuf* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	Dimensions _tmp5_ = {0};
	gint _tmp6_ = 0;
	Dimensions _tmp13_ = {0};
	GdkPixbuf* _tmp14_ = NULL;
	Dimensions _tmp15_ = {0};
	gint _tmp16_ = 0;
	Dimensions _tmp17_ = {0};
	gint _tmp18_ = 0;
	GdkInterpType _tmp19_ = 0;
	GdkPixbuf* _tmp20_ = NULL;
#line 170 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 170 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (resized != NULL, NULL);
#line 171 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = pixbuf;
#line 171 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_for_pixbuf (_tmp0_, &_tmp1_);
#line 171 "/home/jens/Source/shotwell/src/util/image.vala"
	original = _tmp1_;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = original;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.width;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *resized;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.width;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp4_ == _tmp6_) {
#line 526 "image.c"
		Dimensions _tmp7_ = {0};
		gint _tmp8_ = 0;
		Dimensions _tmp9_ = {0};
		gint _tmp10_ = 0;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = original;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.height;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = *resized;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.height;
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp8_ == _tmp10_;
#line 541 "image.c"
	} else {
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 545 "image.c"
	}
#line 172 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 549 "image.c"
		GdkPixbuf* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_ = NULL;
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = pixbuf;
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp12_;
#line 173 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 560 "image.c"
	}
#line 176 "/home/jens/Source/shotwell/src/util/image.vala"
	dimensions_with_min (resized, MIN_SCALED_WIDTH, MIN_SCALED_HEIGHT, &_tmp13_);
#line 176 "/home/jens/Source/shotwell/src/util/image.vala"
	*resized = _tmp13_;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = pixbuf;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = *resized;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = _tmp15_.width;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = *resized;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = _tmp17_.height;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = interp;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = gdk_pixbuf_scale_simple (_tmp14_, _tmp16_, _tmp18_, _tmp19_);
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp20_;
#line 178 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 584 "image.c"
}


void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion) {
	cairo_t* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	GdkPoint _tmp2_ = {0};
	gdouble _tmp3_ = 0.0;
	cairo_t* _tmp4_ = NULL;
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (ctx != NULL);
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (dim != NULL);
#line 183 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (origin != NULL);
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = ctx;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *dim;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *origin;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = radius_proportion;
#line 185 "/home/jens/Source/shotwell/src/util/image.vala"
	context_rounded_corners (_tmp0_, &_tmp1_, &_tmp2_, _tmp3_);
#line 186 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = ctx;
#line 186 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_paint (_tmp4_);
#line 614 "image.c"
}


void context_rounded_corners (cairo_t* cx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion) {
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble left = 0.0;
	GdkPoint _tmp2_ = {0};
	gint _tmp3_ = 0;
	gdouble top = 0.0;
	GdkPoint _tmp4_ = {0};
	gint _tmp5_ = 0;
	gdouble right = 0.0;
	GdkPoint _tmp6_ = {0};
	gint _tmp7_ = 0;
	Dimensions _tmp8_ = {0};
	gint _tmp9_ = 0;
	gdouble bottom = 0.0;
	GdkPoint _tmp10_ = {0};
	gint _tmp11_ = 0;
	Dimensions _tmp12_ = {0};
	gint _tmp13_ = 0;
	gdouble radius = 0.0;
	gint _tmp14_ = 0;
	gdouble _tmp15_ = 0.0;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (cx != NULL);
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (dim != NULL);
#line 189 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (origin != NULL);
#line 192 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = radius_proportion;
#line 192 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = CLAMP (_tmp0_, 2.0, 100.0);
#line 192 "/home/jens/Source/shotwell/src/util/image.vala"
	radius_proportion = _tmp1_;
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *origin;
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.x;
#line 194 "/home/jens/Source/shotwell/src/util/image.vala"
	left = (gdouble) _tmp3_;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *origin;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.y;
#line 195 "/home/jens/Source/shotwell/src/util/image.vala"
	top = (gdouble) _tmp5_;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = *origin;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.x;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = *dim;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = _tmp8_.width;
#line 196 "/home/jens/Source/shotwell/src/util/image.vala"
	right = (gdouble) (_tmp7_ + _tmp9_);
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = *origin;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = _tmp10_.y;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = *dim;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = _tmp12_.height;
#line 197 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom = (gdouble) (_tmp11_ + _tmp13_);
#line 200 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = dimensions_minor_axis (dim);
#line 200 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = radius_proportion;
#line 200 "/home/jens/Source/shotwell/src/util/image.vala"
	radius = ((gdouble) _tmp14_) / _tmp15_;
#line 204 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = cx;
#line 204 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_move_to (_tmp16_, left, top);
#line 205 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = cx;
#line 205 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (_tmp17_, right - radius, top + radius, radius, -90 * DEGREE, 0 * DEGREE);
#line 206 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = cx;
#line 206 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (_tmp18_, right - radius, bottom - radius, radius, 0 * DEGREE, 90 * DEGREE);
#line 207 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = cx;
#line 207 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (_tmp19_, left + radius, bottom - radius, radius, 90 * DEGREE, 180 * DEGREE);
#line 208 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = cx;
#line 208 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_arc (_tmp20_, left + radius, top + radius, radius, 180 * DEGREE, 270 * DEGREE);
#line 209 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = cx;
#line 209 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_clip (_tmp21_);
#line 720 "image.c"
}


inline guchar shift_color_byte (gint b, gint shift) {
	guchar result = '\0';
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = b;
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = shift;
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = CLAMP (_tmp0_ + _tmp1_, 0, 255);
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	result = (guchar) _tmp2_;
#line 213 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 739 "image.c"
}


void shift_colors (GdkPixbuf* pixbuf, gint red, gint green, gint blue, gint alpha) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gint width = 0;
	GdkPixbuf* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint height = 0;
	GdkPixbuf* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint rowstride = 0;
	GdkPixbuf* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint channels = 0;
	GdkPixbuf* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	guchar* pixels = NULL;
	GdkPixbuf* _tmp20_ = NULL;
	guint8* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GdkPixbuf* _tmp23_ = NULL;
	GdkColorspace _tmp24_ = 0;
	GdkPixbuf* _tmp25_ = NULL;
	gint _tmp26_ = 0;
#line 216 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = red;
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_ >= -255) {
#line 778 "image.c"
		gint _tmp2_ = 0;
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = red;
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = _tmp2_ <= 255;
#line 784 "image.c"
	} else {
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 788 "image.c"
	}
#line 217 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp0_, "red >= -255 && red <= 255");
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = green;
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp4_ >= -255) {
#line 796 "image.c"
		gint _tmp5_ = 0;
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp5_ = green;
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = _tmp5_ <= 255;
#line 802 "image.c"
	} else {
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp3_ = FALSE;
#line 806 "image.c"
	}
#line 218 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp3_, "green >= -255 && green <= 255");
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = blue;
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp7_ >= -255) {
#line 814 "image.c"
		gint _tmp8_ = 0;
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = blue;
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = _tmp8_ <= 255;
#line 820 "image.c"
	} else {
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = FALSE;
#line 824 "image.c"
	}
#line 219 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp6_, "blue >= -255 && blue <= 255");
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = alpha;
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp10_ >= -255) {
#line 832 "image.c"
		gint _tmp11_ = 0;
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = alpha;
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = _tmp11_ <= 255;
#line 838 "image.c"
	} else {
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = FALSE;
#line 842 "image.c"
	}
#line 220 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp9_, "alpha >= -255 && alpha <= 255");
#line 222 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = pixbuf;
#line 222 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = gdk_pixbuf_get_width (_tmp12_);
#line 222 "/home/jens/Source/shotwell/src/util/image.vala"
	width = _tmp13_;
#line 223 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = pixbuf;
#line 223 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
#line 223 "/home/jens/Source/shotwell/src/util/image.vala"
	height = _tmp15_;
#line 224 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = pixbuf;
#line 224 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = gdk_pixbuf_get_rowstride (_tmp16_);
#line 224 "/home/jens/Source/shotwell/src/util/image.vala"
	rowstride = _tmp17_;
#line 225 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = pixbuf;
#line 225 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = gdk_pixbuf_get_n_channels (_tmp18_);
#line 225 "/home/jens/Source/shotwell/src/util/image.vala"
	channels = _tmp19_;
#line 226 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = pixbuf;
#line 226 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = gdk_pixbuf_get_pixels (_tmp20_);
#line 226 "/home/jens/Source/shotwell/src/util/image.vala"
	pixels = _tmp21_;
#line 228 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_ = channels;
#line 228 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp22_ >= 3, "channels >= 3");
#line 229 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = pixbuf;
#line 229 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp24_ = gdk_pixbuf_get_colorspace (_tmp23_);
#line 229 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp24_ == GDK_COLORSPACE_RGB, "pixbuf.get_colorspace() == Gdk.Colorspace.RGB");
#line 230 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp25_ = pixbuf;
#line 230 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp26_ = gdk_pixbuf_get_bits_per_sample (_tmp25_);
#line 230 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp26_ == 8, "pixbuf.get_bits_per_sample() == 8");
#line 892 "image.c"
	{
		gint y = 0;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
		y = 0;
#line 897 "image.c"
		{
			gboolean _tmp27_ = FALSE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
			_tmp27_ = TRUE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
			while (TRUE) {
#line 904 "image.c"
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint y_offset = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!_tmp27_) {
#line 912 "image.c"
					gint _tmp28_ = 0;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp28_ = y;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					y = _tmp28_ + 1;
#line 918 "image.c"
				}
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp27_ = FALSE;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp29_ = y;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp30_ = height;
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!(_tmp29_ < _tmp30_)) {
#line 232 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 930 "image.c"
				}
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp31_ = y;
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp32_ = rowstride;
#line 233 "/home/jens/Source/shotwell/src/util/image.vala"
				y_offset = _tmp31_ * _tmp32_;
#line 938 "image.c"
				{
					gint x = 0;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
					x = 0;
#line 943 "image.c"
					{
						gboolean _tmp33_ = FALSE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
						_tmp33_ = TRUE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
						while (TRUE) {
#line 950 "image.c"
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint offset = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp49_ = 0;
							gint _tmp58_ = 0;
							gboolean _tmp67_ = FALSE;
							gint _tmp68_ = 0;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							if (!_tmp33_) {
#line 964 "image.c"
								gint _tmp34_ = 0;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp34_ = x;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								x = _tmp34_ + 1;
#line 970 "image.c"
							}
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp33_ = FALSE;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp35_ = x;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp36_ = width;
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
							if (!(_tmp35_ < _tmp36_)) {
#line 235 "/home/jens/Source/shotwell/src/util/image.vala"
								break;
#line 982 "image.c"
							}
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp37_ = y_offset;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp38_ = x;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp39_ = channels;
#line 236 "/home/jens/Source/shotwell/src/util/image.vala"
							offset = _tmp37_ + (_tmp38_ * _tmp39_);
#line 238 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp40_ = red;
#line 238 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp40_ != 0) {
#line 996 "image.c"
								guchar* _tmp41_ = NULL;
								gint _tmp42_ = 0;
								guchar* _tmp43_ = NULL;
								gint _tmp44_ = 0;
								guchar _tmp45_ = '\0';
								gint _tmp46_ = 0;
								guchar _tmp47_ = '\0';
								guchar _tmp48_ = '\0';
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp41_ = pixels;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp42_ = offset;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp43_ = pixels;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp44_ = offset;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp45_ = _tmp43_[_tmp44_];
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp46_ = red;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp47_ = shift_color_byte ((gint) _tmp45_, _tmp46_);
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp41_[_tmp42_] = _tmp47_;
#line 239 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp48_ = _tmp41_[_tmp42_];
#line 1023 "image.c"
							}
#line 241 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp49_ = green;
#line 241 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp49_ != 0) {
#line 1029 "image.c"
								guchar* _tmp50_ = NULL;
								gint _tmp51_ = 0;
								guchar* _tmp52_ = NULL;
								gint _tmp53_ = 0;
								guchar _tmp54_ = '\0';
								gint _tmp55_ = 0;
								guchar _tmp56_ = '\0';
								guchar _tmp57_ = '\0';
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp50_ = pixels;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp51_ = offset;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp52_ = pixels;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp53_ = offset;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp54_ = _tmp52_[_tmp53_ + 1];
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp55_ = green;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp56_ = shift_color_byte ((gint) _tmp54_, _tmp55_);
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp50_[_tmp51_ + 1] = _tmp56_;
#line 242 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp57_ = _tmp50_[_tmp51_ + 1];
#line 1056 "image.c"
							}
#line 244 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp58_ = blue;
#line 244 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp58_ != 0) {
#line 1062 "image.c"
								guchar* _tmp59_ = NULL;
								gint _tmp60_ = 0;
								guchar* _tmp61_ = NULL;
								gint _tmp62_ = 0;
								guchar _tmp63_ = '\0';
								gint _tmp64_ = 0;
								guchar _tmp65_ = '\0';
								guchar _tmp66_ = '\0';
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp59_ = pixels;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp60_ = offset;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp61_ = pixels;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp62_ = offset;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp63_ = _tmp61_[_tmp62_ + 2];
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp64_ = blue;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp65_ = shift_color_byte ((gint) _tmp63_, _tmp64_);
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp59_[_tmp60_ + 2] = _tmp65_;
#line 245 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp66_ = _tmp59_[_tmp60_ + 2];
#line 1089 "image.c"
							}
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
							_tmp68_ = alpha;
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp68_ != 0) {
#line 1095 "image.c"
								gint _tmp69_ = 0;
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp69_ = channels;
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp67_ = _tmp69_ >= 4;
#line 1101 "image.c"
							} else {
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp67_ = FALSE;
#line 1105 "image.c"
							}
#line 247 "/home/jens/Source/shotwell/src/util/image.vala"
							if (_tmp67_) {
#line 1109 "image.c"
								guchar* _tmp70_ = NULL;
								gint _tmp71_ = 0;
								guchar* _tmp72_ = NULL;
								gint _tmp73_ = 0;
								guchar _tmp74_ = '\0';
								gint _tmp75_ = 0;
								guchar _tmp76_ = '\0';
								guchar _tmp77_ = '\0';
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp70_ = pixels;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp71_ = offset;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp72_ = pixels;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp73_ = offset;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp74_ = _tmp72_[_tmp73_ + 3];
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp75_ = alpha;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp76_ = shift_color_byte ((gint) _tmp74_, _tmp75_);
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp70_[_tmp71_ + 3] = _tmp76_;
#line 248 "/home/jens/Source/shotwell/src/util/image.vala"
								_tmp77_ = _tmp70_[_tmp71_ + 3];
#line 1136 "image.c"
							}
						}
					}
				}
			}
		}
	}
}


void dim_pixbuf (GdkPixbuf* pixbuf) {
	PixelTransformer* transformer = NULL;
	PixelTransformer* _tmp0_ = NULL;
	SaturationTransformation* sat = NULL;
	SaturationTransformation* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
#line 253 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = pixel_transformer_new ();
#line 254 "/home/jens/Source/shotwell/src/util/image.vala"
	transformer = _tmp0_;
#line 255 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = saturation_transformation_new (SATURATION_TRANSFORMATION_MIN_PARAMETER);
#line 255 "/home/jens/Source/shotwell/src/util/image.vala"
	sat = _tmp1_;
#line 256 "/home/jens/Source/shotwell/src/util/image.vala"
	pixel_transformer_attach_transformation (transformer, G_TYPE_CHECK_INSTANCE_CAST (sat, TYPE_PIXEL_TRANSFORMATION, PixelTransformation));
#line 257 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = pixbuf;
#line 257 "/home/jens/Source/shotwell/src/util/image.vala"
	pixel_transformer_transform_pixbuf (transformer, _tmp2_, NULL);
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = pixbuf;
#line 258 "/home/jens/Source/shotwell/src/util/image.vala"
	shift_colors (_tmp3_, 0, 0, 0, -100);
#line 253 "/home/jens/Source/shotwell/src/util/image.vala"
	_pixel_transformation_unref0 (sat);
#line 253 "/home/jens/Source/shotwell/src/util/image.vala"
	_pixel_transformer_unref0 (transformer);
#line 1178 "image.c"
}


gboolean coord_in_rectangle (gint x, gint y, GdkRectangle* rect) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_ = 0;
#line 261 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (rect != NULL, FALSE);
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = x;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.x;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp3_ >= _tmp5_) {
#line 1200 "image.c"
		gint _tmp6_ = 0;
		GdkRectangle _tmp7_ = {0};
		gint _tmp8_ = 0;
		GdkRectangle _tmp9_ = {0};
		gint _tmp10_ = 0;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp6_ = x;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.x;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.width;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp6_ < (_tmp8_ + _tmp10_);
#line 1218 "image.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 1222 "image.c"
	}
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 1226 "image.c"
		gint _tmp11_ = 0;
		GdkRectangle _tmp12_ = {0};
		gint _tmp13_ = 0;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = y;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = _tmp12_.y;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _tmp11_ >= _tmp13_;
#line 1238 "image.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = FALSE;
#line 1242 "image.c"
	}
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_) {
#line 1246 "image.c"
		gint _tmp14_ = 0;
		GdkRectangle _tmp15_ = {0};
		gint _tmp16_ = 0;
		GdkRectangle _tmp17_ = {0};
		gint _tmp18_ = 0;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = y;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp15_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp16_ = _tmp15_.y;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = *rect;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp18_ = _tmp17_.height;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = _tmp14_ <= (_tmp16_ + _tmp18_);
#line 1264 "image.c"
	} else {
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 1268 "image.c"
	}
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp0_;
#line 262 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1274 "image.c"
}


gboolean rectangles_equal (GdkRectangle* a, GdkRectangle* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 265 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 265 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *a;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *b;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.x;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp4_ == _tmp6_) {
#line 1301 "image.c"
		GdkRectangle _tmp7_ = {0};
		gint _tmp8_ = 0;
		GdkRectangle _tmp9_ = {0};
		gint _tmp10_ = 0;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp7_ = *a;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp8_ = _tmp7_.y;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp9_ = *b;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp10_ = _tmp9_.y;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _tmp8_ == _tmp10_;
#line 1316 "image.c"
	} else {
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = FALSE;
#line 1320 "image.c"
	}
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp2_) {
#line 1324 "image.c"
		GdkRectangle _tmp11_ = {0};
		gint _tmp12_ = 0;
		GdkRectangle _tmp13_ = {0};
		gint _tmp14_ = 0;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp11_ = *a;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp12_ = _tmp11_.width;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp13_ = *b;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = _tmp13_.width;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = _tmp12_ == _tmp14_;
#line 1339 "image.c"
	} else {
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = FALSE;
#line 1343 "image.c"
	}
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp1_) {
#line 1347 "image.c"
		GdkRectangle _tmp15_ = {0};
		gint _tmp16_ = 0;
		GdkRectangle _tmp17_ = {0};
		gint _tmp18_ = 0;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp15_ = *a;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp16_ = _tmp15_.height;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = *b;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp18_ = _tmp17_.height;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = _tmp16_ == _tmp18_;
#line 1362 "image.c"
	} else {
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp0_ = FALSE;
#line 1366 "image.c"
	}
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp0_;
#line 266 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1372 "image.c"
}


gchar* rectangle_to_string (GdkRectangle* rect) {
	gchar* result = NULL;
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_ = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
#line 269 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (rect != NULL, NULL);
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *rect;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.x;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *rect;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.y;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = *rect;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_.width;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = *rect;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = _tmp6_.height;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = g_strdup_printf ("%d,%d %dx%d", _tmp1_, _tmp3_, _tmp5_, _tmp7_);
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	result = _tmp8_;
#line 270 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 1411 "image.c"
}


void clamp_rectangle (GdkRectangle* original, Dimensions* max, GdkRectangle* result) {
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	Dimensions _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GdkRectangle _tmp10_ = {0};
	gint _tmp11_ = 0;
	Dimensions _tmp12_ = {0};
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GdkRectangle _tmp15_ = {0};
	gint _tmp16_ = 0;
	Dimensions _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 273 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (original != NULL);
#line 273 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (max != NULL);
#line 274 "/home/jens/Source/shotwell/src/util/image.vala"
	memset (&rect, 0, sizeof (GdkRectangle));
#line 275 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *original;
#line 275 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.x;
#line 275 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *max;
#line 275 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.width;
#line 275 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = CLAMP (_tmp1_, 0, _tmp3_);
#line 275 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.x = _tmp4_;
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *original;
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *max;
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.height;
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = CLAMP (_tmp6_, 0, _tmp8_);
#line 276 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.y = _tmp9_;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = *original;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = _tmp10_.width;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = *max;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = _tmp12_.width;
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = CLAMP (_tmp11_, 0, _tmp13_);
#line 277 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.width = _tmp14_;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = *original;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = _tmp15_.height;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = *max;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = _tmp17_.height;
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = CLAMP (_tmp16_, 0, _tmp18_);
#line 278 "/home/jens/Source/shotwell/src/util/image.vala"
	rect.height = _tmp19_;
#line 280 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = rect;
#line 280 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1495 "image.c"
}


void scale_point (GdkPoint* p, gdouble factor, GdkPoint* result) {
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	GdkPoint _tmp2_ = {0};
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	GdkPoint _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 283 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p != NULL);
#line 284 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 284 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = factor;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *p;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.x;
#line 285 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = (gint) ((_tmp1_ * _tmp3_) + 0.5);
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = factor;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *p;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 286 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = (gint) ((_tmp4_ * _tmp6_) + 0.5);
#line 288 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 288 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1534 "image.c"
}


void add_points (GdkPoint* p1, GdkPoint* p2, GdkPoint* result) {
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkPoint _tmp3_ = {0};
	gint _tmp4_ = 0;
	GdkPoint _tmp5_ = {0};
	gint _tmp6_ = 0;
	GdkPoint _tmp7_ = {0};
	gint _tmp8_ = 0;
#line 291 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p1 != NULL);
#line 291 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p2 != NULL);
#line 292 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 292 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *p1;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_.x;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *p2;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 293 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = _tmp2_ + _tmp4_;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *p1;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *p2;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.y;
#line 294 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = _tmp6_ + _tmp8_;
#line 296 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 296 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1581 "image.c"
}


void subtract_points (GdkPoint* p1, GdkPoint* p2, GdkPoint* result) {
	GdkPoint _result_ = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkPoint _tmp3_ = {0};
	gint _tmp4_ = 0;
	GdkPoint _tmp5_ = {0};
	gint _tmp6_ = 0;
	GdkPoint _tmp7_ = {0};
	gint _tmp8_ = 0;
#line 299 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p1 != NULL);
#line 299 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (p2 != NULL);
#line 300 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_.x = 0;
#line 300 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_ = _tmp0_;
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = *p1;
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_.x;
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = *p2;
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = _tmp3_.x;
#line 301 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.x = _tmp2_ - _tmp4_;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = *p1;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = _tmp5_.y;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = *p2;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_.y;
#line 302 "/home/jens/Source/shotwell/src/util/image.vala"
	_result_.y = _tmp6_ - _tmp8_;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _result_;
#line 304 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 1628 "image.c"
}


void fix_cairo_pixbuf (GdkPixbuf* pixbuf) {
	guchar* gdk_pixels = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	void* _tmp2_ = NULL;
#line 308 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = pixbuf;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = gdk_pixbuf_get_pixels (_tmp0_);
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = _tmp1_;
#line 309 "/home/jens/Source/shotwell/src/util/image.vala"
	gdk_pixels = _tmp2_;
#line 1647 "image.c"
	{
		gint j = 0;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
		j = 0;
#line 1652 "image.c"
		{
			gboolean _tmp3_ = FALSE;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
			_tmp3_ = TRUE;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
			while (TRUE) {
#line 1659 "image.c"
				gint _tmp5_ = 0;
				GdkPixbuf* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				guchar* p = NULL;
				guchar* _tmp9_ = NULL;
				guchar* end = NULL;
				guchar* _tmp10_ = NULL;
				GdkPixbuf* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				guchar* _tmp26_ = NULL;
				GdkPixbuf* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!_tmp3_) {
#line 1677 "image.c"
					gint _tmp4_ = 0;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp4_ = j;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					j = _tmp4_ + 1;
#line 1683 "image.c"
				}
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp3_ = FALSE;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp5_ = j;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp6_ = pixbuf;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp8_ = _tmp7_;
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 310 "/home/jens/Source/shotwell/src/util/image.vala"
					break;
#line 1699 "image.c"
				}
#line 311 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp9_ = gdk_pixels;
#line 311 "/home/jens/Source/shotwell/src/util/image.vala"
				p = _tmp9_;
#line 312 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp10_ = p;
#line 312 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp11_ = pixbuf;
#line 312 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp12_ = gdk_pixbuf_get_width (_tmp11_);
#line 312 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp13_ = _tmp12_;
#line 312 "/home/jens/Source/shotwell/src/util/image.vala"
				end = _tmp10_ + (4 * _tmp13_);
#line 314 "/home/jens/Source/shotwell/src/util/image.vala"
				while (TRUE) {
#line 1717 "image.c"
					guchar* _tmp14_ = NULL;
					guchar* _tmp15_ = NULL;
					guchar tmp = '\0';
					guchar* _tmp16_ = NULL;
					guchar _tmp17_ = '\0';
					guchar* _tmp18_ = NULL;
					guchar* _tmp19_ = NULL;
					guchar _tmp20_ = '\0';
					guchar _tmp21_ = '\0';
					guchar* _tmp22_ = NULL;
					guchar _tmp23_ = '\0';
					guchar _tmp24_ = '\0';
					guchar* _tmp25_ = NULL;
#line 314 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp14_ = p;
#line 314 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp15_ = end;
#line 314 "/home/jens/Source/shotwell/src/util/image.vala"
					if (!(_tmp14_ < _tmp15_)) {
#line 314 "/home/jens/Source/shotwell/src/util/image.vala"
						break;
#line 1739 "image.c"
					}
#line 315 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp16_ = p;
#line 315 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp17_ = _tmp16_[0];
#line 315 "/home/jens/Source/shotwell/src/util/image.vala"
					tmp = _tmp17_;
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp18_ = p;
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp19_ = p;
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp20_ = _tmp19_[2];
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp18_[0] = _tmp20_;
#line 317 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp21_ = _tmp18_[0];
#line 318 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp22_ = p;
#line 318 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp23_ = tmp;
#line 318 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp22_[2] = _tmp23_;
#line 318 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp24_ = _tmp22_[2];
#line 325 "/home/jens/Source/shotwell/src/util/image.vala"
					_tmp25_ = p;
#line 325 "/home/jens/Source/shotwell/src/util/image.vala"
					p = _tmp25_ + 4;
#line 1769 "image.c"
				}
#line 328 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp26_ = gdk_pixels;
#line 328 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp27_ = pixbuf;
#line 328 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp28_ = gdk_pixbuf_get_rowstride (_tmp27_);
#line 328 "/home/jens/Source/shotwell/src/util/image.vala"
				_tmp29_ = _tmp28_;
#line 328 "/home/jens/Source/shotwell/src/util/image.vala"
				gdk_pixels = _tmp26_ + _tmp29_;
#line 1781 "image.c"
			}
		}
	}
}


/**
 * Finds the size of the smallest axially-aligned rectangle that could contain
 * a rectangle src_width by src_height, rotated by angle.
 *
 * @param src_width The width of the incoming rectangle.
 * @param src_height The height of the incoming rectangle.
 * @param angle The amount to rotate by, given in degrees.
 * @param dest_width The width of the computed rectangle.
 * @param dest_height The height of the computed rectangle.
 */
void compute_arb_rotated_size (gdouble src_width, gdouble src_height, gdouble angle, gdouble* dest_width, gdouble* dest_height) {
	gdouble _vala_dest_width = 0.0;
	gdouble _vala_dest_height = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
#line 345 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = angle;
#line 345 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = degrees_to_radians (_tmp0_);
#line 345 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = fabs (_tmp1_);
#line 345 "/home/jens/Source/shotwell/src/util/image.vala"
	angle = _tmp2_;
#line 346 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = angle;
#line 346 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_assert (_tmp3_ <= G_PI_2, "angle <= Math.PI_2");
#line 347 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = src_width;
#line 347 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = angle;
#line 347 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = cos (_tmp5_);
#line 347 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = src_height;
#line 347 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = angle;
#line 347 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = sin (_tmp8_);
#line 347 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_dest_width = (_tmp4_ * _tmp6_) + (_tmp7_ * _tmp9_);
#line 348 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = src_height;
#line 348 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = angle;
#line 348 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = cos (_tmp11_);
#line 348 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = src_width;
#line 348 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = angle;
#line 348 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = sin (_tmp14_);
#line 348 "/home/jens/Source/shotwell/src/util/image.vala"
	_vala_dest_height = (_tmp10_ * _tmp12_) + (_tmp13_ * _tmp15_);
#line 342 "/home/jens/Source/shotwell/src/util/image.vala"
	if (dest_width) {
#line 342 "/home/jens/Source/shotwell/src/util/image.vala"
		*dest_width = _vala_dest_width;
#line 1861 "image.c"
	}
#line 342 "/home/jens/Source/shotwell/src/util/image.vala"
	if (dest_height) {
#line 342 "/home/jens/Source/shotwell/src/util/image.vala"
		*dest_height = _vala_dest_height;
#line 1867 "image.c"
	}
}


/**
 * @brief Rotates a pixbuf to an arbitrary angle, given in degrees, and returns the rotated pixbuf.
 *
 * @param source_pixbuf The source image that needs to be angled.
 * @param angle The angle the source image should be rotated by.
 */
GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf, gdouble angle) {
	GdkPixbuf* result = NULL;
	gdouble _tmp0_ = 0.0;
	gdouble x_tmp = 0.0;
	gdouble y_tmp = 0.0;
	GdkPixbuf* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GdkPixbuf* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	GdkPixbuf* dest_pixbuf = NULL;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	GdkPixbuf* _tmp16_ = NULL;
	cairo_format_t _tmp17_ = 0;
	GdkPixbuf* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	cairo_surface_t* surface = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	void* _tmp22_ = NULL;
	void* _tmp23_ = NULL;
	GdkPixbuf* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	GdkPixbuf* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	GdkPixbuf* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	cairo_surface_t* _tmp33_ = NULL;
	cairo_t* context = NULL;
	cairo_surface_t* _tmp34_ = NULL;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	GdkPixbuf* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	GdkPixbuf* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	cairo_t* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	GdkPixbuf* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	GdkPixbuf* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	cairo_t* _tmp52_ = NULL;
	gdouble _tmp53_ = 0.0;
	gdouble _tmp54_ = 0.0;
	cairo_t* _tmp55_ = NULL;
	GdkPixbuf* _tmp56_ = NULL;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	GdkPixbuf* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint _tmp61_ = 0;
	cairo_t* _tmp62_ = NULL;
	GdkPixbuf* _tmp63_ = NULL;
	cairo_t* _tmp64_ = NULL;
	cairo_pattern_t* _tmp65_ = NULL;
	cairo_t* _tmp66_ = NULL;
	GdkPixbuf* _tmp67_ = NULL;
#line 357 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (source_pixbuf), NULL);
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = angle;
#line 361 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp0_ == 0.0) {
#line 1957 "image.c"
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
#line 362 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = source_pixbuf;
#line 362 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 362 "/home/jens/Source/shotwell/src/util/image.vala"
		result = _tmp2_;
#line 362 "/home/jens/Source/shotwell/src/util/image.vala"
		return result;
#line 1968 "image.c"
	}
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = source_pixbuf;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = gdk_pixbuf_get_width (_tmp3_);
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = _tmp4_;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = source_pixbuf;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = _tmp7_;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = angle;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	compute_arb_rotated_size ((gdouble) _tmp5_, (gdouble) _tmp8_, _tmp9_, &_tmp10_, &_tmp11_);
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	x_tmp = _tmp10_;
#line 369 "/home/jens/Source/shotwell/src/util/image.vala"
	y_tmp = _tmp11_;
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = x_tmp;
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = round (_tmp12_);
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = y_tmp;
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = round (_tmp14_);
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, (gint) _tmp13_, (gint) _tmp15_);
#line 372 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_pixbuf = _tmp16_;
#line 377 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = source_pixbuf;
#line 377 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = gdk_pixbuf_get_has_alpha (_tmp18_);
#line 377 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = _tmp19_;
#line 377 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp20_) {
#line 377 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = CAIRO_FORMAT_ARGB32;
#line 2012 "image.c"
	} else {
#line 377 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp17_ = CAIRO_FORMAT_RGB24;
#line 2016 "image.c"
	}
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = dest_pixbuf;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_ = gdk_pixbuf_get_pixels (_tmp21_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = _tmp22_;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp24_ = dest_pixbuf;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp25_ = gdk_pixbuf_get_width (_tmp24_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp26_ = _tmp25_;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp27_ = dest_pixbuf;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp28_ = gdk_pixbuf_get_height (_tmp27_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp29_ = _tmp28_;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp30_ = dest_pixbuf;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_ = gdk_pixbuf_get_rowstride (_tmp30_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp32_ = _tmp31_;
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp33_ = cairo_image_surface_create_for_data ((guchar*) _tmp23_, _tmp17_, _tmp26_, _tmp29_, _tmp32_);
#line 375 "/home/jens/Source/shotwell/src/util/image.vala"
	surface = _tmp33_;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp34_ = surface;
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp35_ = cairo_create (_tmp34_);
#line 380 "/home/jens/Source/shotwell/src/util/image.vala"
	context = _tmp35_;
#line 382 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp36_ = context;
#line 382 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_set_source_rgb (_tmp36_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp37_ = context;
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp38_ = dest_pixbuf;
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp39_ = gdk_pixbuf_get_width (_tmp38_);
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp40_ = _tmp39_;
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp41_ = dest_pixbuf;
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp42_ = gdk_pixbuf_get_height (_tmp41_);
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp43_ = _tmp42_;
#line 383 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_rectangle (_tmp37_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp40_, (gdouble) _tmp43_);
#line 384 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp44_ = context;
#line 384 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_fill (_tmp44_);
#line 386 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp45_ = context;
#line 386 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp46_ = dest_pixbuf;
#line 386 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp47_ = gdk_pixbuf_get_width (_tmp46_);
#line 386 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp48_ = _tmp47_;
#line 386 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp49_ = dest_pixbuf;
#line 386 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp50_ = gdk_pixbuf_get_height (_tmp49_);
#line 386 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp51_ = _tmp50_;
#line 386 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_translate (_tmp45_, (gdouble) (_tmp48_ / 2), (gdouble) (_tmp51_ / 2));
#line 387 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp52_ = context;
#line 387 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp53_ = angle;
#line 387 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp54_ = degrees_to_radians (_tmp53_);
#line 387 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_rotate (_tmp52_, _tmp54_);
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp55_ = context;
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp56_ = source_pixbuf;
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp57_ = gdk_pixbuf_get_width (_tmp56_);
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp58_ = _tmp57_;
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp59_ = source_pixbuf;
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp60_ = gdk_pixbuf_get_height (_tmp59_);
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp61_ = _tmp60_;
#line 388 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_translate (_tmp55_, (gdouble) ((-_tmp58_) / 2), (gdouble) ((-_tmp61_) / 2));
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp62_ = context;
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp63_ = source_pixbuf;
#line 390 "/home/jens/Source/shotwell/src/util/image.vala"
	gdk_cairo_set_source_pixbuf (_tmp62_, _tmp63_, (gdouble) 0, (gdouble) 0);
#line 391 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp64_ = context;
#line 391 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp65_ = cairo_get_source (_tmp64_);
#line 391 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_pattern_set_filter (_tmp65_, CAIRO_FILTER_BEST);
#line 392 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp66_ = context;
#line 392 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_paint (_tmp66_);
#line 396 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp67_ = dest_pixbuf;
#line 396 "/home/jens/Source/shotwell/src/util/image.vala"
	fix_cairo_pixbuf (_tmp67_);
#line 398 "/home/jens/Source/shotwell/src/util/image.vala"
	result = dest_pixbuf;
#line 398 "/home/jens/Source/shotwell/src/util/image.vala"
	_cairo_destroy0 (context);
#line 398 "/home/jens/Source/shotwell/src/util/image.vala"
	_cairo_surface_destroy0 (surface);
#line 398 "/home/jens/Source/shotwell/src/util/image.vala"
	return result;
#line 2144 "image.c"
}


/**
 * @brief Rotates a point around the upper left corner of an image to an arbitrary angle,
 * given in degrees, and returns the rotated point, translated such that it, along with its attendant
 * image, are in positive x, positive y.
 *
 * @note May be subject to slight inaccuracy as Gdk points' coordinates may only be in whole pixels,
 * so the fractional component is lost.
 *
 * @param source_point The point to be rotated and scaled.
 * @param img_w The width of the source image (unrotated).
 * @param img_h The height of the source image (unrotated).
 * @param angle The angle the source image is to be rotated by to straighten it.
 */
void rotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, gboolean invert, GdkPoint* result) {
	gdouble _tmp0_ = 0.0;
	gdouble dest_width = 0.0;
	gdouble dest_height = 0.0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	cairo_matrix_t matrix = {0};
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gdouble dest_x = 0.0;
	GdkPoint _tmp15_ = {0};
	gint _tmp16_ = 0;
	gdouble dest_y = 0.0;
	GdkPoint _tmp17_ = {0};
	gint _tmp18_ = 0;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	GdkPoint _tmp21_ = {0};
#line 414 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (source_point != NULL);
#line 417 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = angle;
#line 417 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp0_ == 0.0) {
#line 2193 "image.c"
		GdkPoint _tmp1_ = {0};
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp1_ = *source_point;
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
		*result = _tmp1_;
#line 419 "/home/jens/Source/shotwell/src/util/image.vala"
		return;
#line 2201 "image.c"
	}
#line 424 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = img_w;
#line 424 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = img_h;
#line 424 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_ = angle;
#line 424 "/home/jens/Source/shotwell/src/util/image.vala"
	compute_arb_rotated_size ((gdouble) _tmp2_, (gdouble) _tmp3_, _tmp4_, &_tmp5_, &_tmp6_);
#line 424 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_width = _tmp5_;
#line 424 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_height = _tmp6_;
#line 426 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_init_identity (&matrix);
#line 427 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = dest_width;
#line 427 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp8_ = dest_height;
#line 427 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_translate (&matrix, _tmp7_ / 2, _tmp8_ / 2);
#line 428 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = angle;
#line 428 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = degrees_to_radians (_tmp9_);
#line 428 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_rotate (&matrix, _tmp10_);
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = img_w;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = img_h;
#line 429 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_translate (&matrix, (gdouble) ((-_tmp11_) / 2), (gdouble) ((-_tmp12_) / 2));
#line 430 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_ = invert;
#line 430 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp13_) {
#line 2239 "image.c"
		cairo_status_t _tmp14_ = 0;
#line 431 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp14_ = cairo_matrix_invert (&matrix);
#line 431 "/home/jens/Source/shotwell/src/util/image.vala"
		_vala_assert (_tmp14_ == CAIRO_STATUS_SUCCESS, "matrix.invert() == Cairo.Status.SUCCESS");
#line 2245 "image.c"
	}
#line 433 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = *source_point;
#line 433 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = _tmp15_.x;
#line 433 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_x = (gdouble) _tmp16_;
#line 434 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp17_ = *source_point;
#line 434 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = _tmp17_.y;
#line 434 "/home/jens/Source/shotwell/src/util/image.vala"
	dest_y = (gdouble) _tmp18_;
#line 435 "/home/jens/Source/shotwell/src/util/image.vala"
	cairo_matrix_transform_point (&matrix, &dest_x, &dest_y);
#line 437 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = dest_x;
#line 437 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = dest_y;
#line 437 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_.x = (gint) _tmp19_;
#line 437 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_.y = (gint) _tmp20_;
#line 437 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp21_;
#line 437 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 2273 "image.c"
}


/**
 * @brief <u>De</u>rotates a point around the upper left corner of an image from an arbitrary angle,
 * given in degrees, and returns the de-rotated point, taking into account any translation necessary
 * to make sure all of the rotated image stays in positive x, positive y.
 *
 * @note May be subject to slight inaccuracy as Gdk points' coordinates may only be in whole pixels,
 * so the fractional component is lost.
 *
 * @param source_point The point to be de-rotated.
 * @param img_w The width of the source image (unrotated).
 * @param img_h The height of the source image (unrotated).
 * @param angle The angle the source image is to be rotated by to straighten it.
 */
void derotate_point_arb (GdkPoint* source_point, gint img_w, gint img_h, gdouble angle, GdkPoint* result) {
	GdkPoint _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gdouble _tmp3_ = 0.0;
	GdkPoint _tmp4_ = {0};
#line 453 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (source_point != NULL);
#line 454 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *source_point;
#line 454 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = img_w;
#line 454 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = img_h;
#line 454 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = angle;
#line 454 "/home/jens/Source/shotwell/src/util/image.vala"
	rotate_point_arb (&_tmp0_, _tmp1_, _tmp2_, _tmp3_, TRUE, &_tmp4_);
#line 454 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp4_;
#line 454 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 2312 "image.c"
}


void clamp_inside_rotated_image (Box* src, gint img_w, gint img_h, gdouble angle_deg, gboolean preserve_geom, Box* result) {
	GdkPoint top_left = {0};
	Box _tmp0_ = {0};
	gint _tmp1_ = 0;
	Box _tmp2_ = {0};
	gint _tmp3_ = 0;
	GdkPoint _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	GdkPoint _tmp8_ = {0};
	GdkPoint top_right = {0};
	Box _tmp9_ = {0};
	gint _tmp10_ = 0;
	Box _tmp11_ = {0};
	gint _tmp12_ = 0;
	GdkPoint _tmp13_ = {0};
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gdouble _tmp16_ = 0.0;
	GdkPoint _tmp17_ = {0};
	GdkPoint bottom_left = {0};
	Box _tmp18_ = {0};
	gint _tmp19_ = 0;
	Box _tmp20_ = {0};
	gint _tmp21_ = 0;
	GdkPoint _tmp22_ = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gdouble _tmp25_ = 0.0;
	GdkPoint _tmp26_ = {0};
	GdkPoint bottom_right = {0};
	Box _tmp27_ = {0};
	gint _tmp28_ = 0;
	Box _tmp29_ = {0};
	gint _tmp30_ = 0;
	GdkPoint _tmp31_ = {0};
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gdouble _tmp34_ = 0.0;
	GdkPoint _tmp35_ = {0};
	gdouble angle = 0.0;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gint top_offset = 0;
	gint bottom_offset = 0;
	gint left_offset = 0;
	gint right_offset = 0;
	gint top = 0;
	GdkPoint _tmp38_ = {0};
	gint _tmp39_ = 0;
	GdkPoint _tmp40_ = {0};
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint bottom = 0;
	GdkPoint _tmp47_ = {0};
	gint _tmp48_ = 0;
	GdkPoint _tmp49_ = {0};
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gint left = 0;
	GdkPoint _tmp58_ = {0};
	gint _tmp59_ = 0;
	GdkPoint _tmp60_ = {0};
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	gint right = 0;
	GdkPoint _tmp67_ = {0};
	gint _tmp68_ = 0;
	GdkPoint _tmp69_ = {0};
	gint _tmp70_ = 0;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	Box _tmp78_ = {0};
	gboolean _tmp79_ = FALSE;
#line 459 "/home/jens/Source/shotwell/src/util/image.vala"
	g_return_if_fail (src != NULL);
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp0_ = *src;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp1_ = _tmp0_.left;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp2_ = *src;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp3_ = _tmp2_.top;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_.x = _tmp1_;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp4_.y = _tmp3_;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp5_ = img_w;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp6_ = img_h;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp7_ = angle_deg;
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp4_, _tmp5_, _tmp6_, _tmp7_, &_tmp8_);
#line 462 "/home/jens/Source/shotwell/src/util/image.vala"
	top_left = _tmp8_;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp9_ = *src;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp10_ = _tmp9_.right;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp11_ = *src;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp12_ = _tmp11_.top;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_.x = _tmp10_;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp13_.y = _tmp12_;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp14_ = img_w;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp15_ = img_h;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp16_ = angle_deg;
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp13_, _tmp14_, _tmp15_, _tmp16_, &_tmp17_);
#line 463 "/home/jens/Source/shotwell/src/util/image.vala"
	top_right = _tmp17_;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp18_ = *src;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp19_ = _tmp18_.left;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp20_ = *src;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp21_ = _tmp20_.bottom;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_.x = _tmp19_;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp22_.y = _tmp21_;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp23_ = img_w;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp24_ = img_h;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp25_ = angle_deg;
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp22_, _tmp23_, _tmp24_, _tmp25_, &_tmp26_);
#line 464 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_left = _tmp26_;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp27_ = *src;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp28_ = _tmp27_.right;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp29_ = *src;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp30_ = _tmp29_.bottom;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_.x = _tmp28_;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp31_.y = _tmp30_;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp32_ = img_w;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp33_ = img_h;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp34_ = angle_deg;
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	derotate_point_arb (&_tmp31_, _tmp32_, _tmp33_, _tmp34_, &_tmp35_);
#line 465 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_right = _tmp35_;
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp36_ = angle_deg;
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp37_ = degrees_to_radians (_tmp36_);
#line 467 "/home/jens/Source/shotwell/src/util/image.vala"
	angle = _tmp37_;
#line 468 "/home/jens/Source/shotwell/src/util/image.vala"
	top_offset = 0;
#line 468 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom_offset = 0;
#line 468 "/home/jens/Source/shotwell/src/util/image.vala"
	left_offset = 0;
#line 468 "/home/jens/Source/shotwell/src/util/image.vala"
	right_offset = 0;
#line 470 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp38_ = top_left;
#line 470 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp39_ = _tmp38_.y;
#line 470 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp40_ = top_right;
#line 470 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp41_ = _tmp40_.y;
#line 470 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp42_ = MIN (_tmp39_, _tmp41_);
#line 470 "/home/jens/Source/shotwell/src/util/image.vala"
	top = _tmp42_;
#line 471 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp43_ = top;
#line 471 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp43_ < 0) {
#line 2516 "image.c"
		gint _tmp44_ = 0;
		gdouble _tmp45_ = 0.0;
		gdouble _tmp46_ = 0.0;
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp44_ = top;
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp45_ = angle;
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp46_ = cos (_tmp45_);
#line 472 "/home/jens/Source/shotwell/src/util/image.vala"
		top_offset = (gint) ((0 - _tmp44_) * _tmp46_);
#line 2528 "image.c"
	}
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp47_ = bottom_left;
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp48_ = _tmp47_.y;
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp49_ = bottom_right;
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp50_ = _tmp49_.y;
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp51_ = MAX (_tmp48_, _tmp50_);
#line 474 "/home/jens/Source/shotwell/src/util/image.vala"
	bottom = _tmp51_;
#line 475 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp52_ = bottom;
#line 475 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp53_ = img_h;
#line 475 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp52_ > _tmp53_) {
#line 2548 "image.c"
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gdouble _tmp56_ = 0.0;
		gdouble _tmp57_ = 0.0;
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp54_ = img_h;
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp55_ = bottom;
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp56_ = angle;
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp57_ = cos (_tmp56_);
#line 476 "/home/jens/Source/shotwell/src/util/image.vala"
		bottom_offset = (gint) ((_tmp54_ - _tmp55_) * _tmp57_);
#line 2563 "image.c"
	}
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp58_ = top_left;
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp59_ = _tmp58_.x;
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp60_ = bottom_left;
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp61_ = _tmp60_.x;
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp62_ = MIN (_tmp59_, _tmp61_);
#line 478 "/home/jens/Source/shotwell/src/util/image.vala"
	left = _tmp62_;
#line 479 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp63_ = left;
#line 479 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp63_ < 0) {
#line 2581 "image.c"
		gint _tmp64_ = 0;
		gdouble _tmp65_ = 0.0;
		gdouble _tmp66_ = 0.0;
#line 480 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp64_ = left;
#line 480 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp65_ = angle;
#line 480 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp66_ = cos (_tmp65_);
#line 480 "/home/jens/Source/shotwell/src/util/image.vala"
		left_offset = (gint) ((0 - _tmp64_) * _tmp66_);
#line 2593 "image.c"
	}
#line 482 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp67_ = top_right;
#line 482 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp68_ = _tmp67_.x;
#line 482 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp69_ = bottom_right;
#line 482 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp70_ = _tmp69_.x;
#line 482 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp71_ = MAX (_tmp68_, _tmp70_);
#line 482 "/home/jens/Source/shotwell/src/util/image.vala"
	right = _tmp71_;
#line 483 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp72_ = right;
#line 483 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp73_ = img_w;
#line 483 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp72_ > _tmp73_) {
#line 2613 "image.c"
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gdouble _tmp76_ = 0.0;
		gdouble _tmp77_ = 0.0;
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp74_ = img_w;
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp75_ = right;
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp76_ = angle;
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp77_ = cos (_tmp76_);
#line 484 "/home/jens/Source/shotwell/src/util/image.vala"
		right_offset = (gint) ((_tmp74_ - _tmp75_) * _tmp77_);
#line 2628 "image.c"
	}
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
	_tmp79_ = preserve_geom;
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
	if (_tmp79_) {
#line 2634 "image.c"
		gint _tmp80_ = 0;
		gint _tmp81_ = 0;
		gint _tmp82_ = 0;
		gint _tmp83_ = 0;
		Box _tmp84_ = {0};
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp80_ = left_offset;
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp81_ = right_offset;
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp82_ = top_offset;
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp83_ = bottom_offset;
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
		box_get_offset (src, _tmp80_ + _tmp81_, _tmp82_ + _tmp83_, &_tmp84_);
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp78_ = _tmp84_;
#line 2652 "image.c"
	} else {
		Box _tmp85_ = {0};
		gint _tmp86_ = 0;
		gint _tmp87_ = 0;
		Box _tmp88_ = {0};
		gint _tmp89_ = 0;
		gint _tmp90_ = 0;
		Box _tmp91_ = {0};
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		Box _tmp94_ = {0};
		gint _tmp95_ = 0;
		gint _tmp96_ = 0;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp85_ = *src;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp86_ = _tmp85_.left;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp87_ = left_offset;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp88_ = *src;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp89_ = _tmp88_.top;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp90_ = top_offset;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp91_ = *src;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp92_ = _tmp91_.right;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp93_ = right_offset;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp94_ = *src;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp95_ = _tmp94_.bottom;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		_tmp96_ = bottom_offset;
#line 487 "/home/jens/Source/shotwell/src/util/image.vala"
		box_init (&_tmp78_, _tmp86_ + _tmp87_, _tmp89_ + _tmp90_, _tmp92_ + _tmp93_, _tmp95_ + _tmp96_);
#line 2692 "image.c"
	}
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
	*result = _tmp78_;
#line 486 "/home/jens/Source/shotwell/src/util/image.vala"
	return;
#line 2698 "image.c"
}



