/* VideoTable.c generated by valac 0.34.1, the Vala compiler
 * generated from VideoTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <sqlite3.h>
#include <gee.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;

#define TYPE_VIDEO_ROW (video_row_get_type ())
#define VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_ROW, VideoRow))
#define VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_ROW, VideoRowClass))
#define IS_VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_ROW))
#define IS_VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_ROW))
#define VIDEO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_ROW, VideoRowClass))

typedef struct _VideoRow VideoRow;
typedef struct _VideoRowClass VideoRowClass;
typedef struct _VideoRowPrivate VideoRowPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_RATING (rating_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecVideoRow ParamSpecVideoRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_VIDEO_TABLE (video_table_get_type ())
#define VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_TABLE, VideoTable))
#define VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_TABLE, VideoTableClass))
#define IS_VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_TABLE))
#define IS_VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_TABLE))
#define VIDEO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_TABLE, VideoTableClass))

typedef struct _VideoTable VideoTable;
typedef struct _VideoTableClass VideoTableClass;
typedef struct _VideoTablePrivate VideoTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _VideoID {
	gint64 id;
};

struct _ImportID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _VideoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoRowPrivate * priv;
	VideoID video_id;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	gint width;
	gint height;
	gdouble clip_duration;
	gboolean is_interpretable;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	gchar* md5;
	time_t time_created;
	Rating rating;
	gchar* title;
	gchar* backlinks;
	time_t time_reimported;
	guint64 flags;
	gchar* comment;
};

struct _VideoRowClass {
	GTypeClass parent_class;
	void (*finalize) (VideoRow *self);
};

struct _ParamSpecVideoRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _VideoTable {
	DatabaseTable parent_instance;
	VideoTablePrivate * priv;
};

struct _VideoTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer video_row_parent_class = NULL;
static gpointer video_table_parent_class = NULL;
static VideoTable* video_table_instance;
static VideoTable* video_table_instance = NULL;
extern sqlite3* database_table_db;

GType video_id_get_type (void) G_GNUC_CONST;
VideoID* video_id_dup (const VideoID* self);
void video_id_free (VideoID* self);
#define VIDEO_ID_INVALID ((gint64) -1)
void video_id_init (VideoID *self, gint64 id);
gboolean video_id_is_invalid (VideoID *self);
gboolean video_id_is_valid (VideoID *self);
guint video_id_hash (VideoID* a);
guint int64_hash (gint64* n);
gboolean video_id_equal (void* a, void* b);
gchar* video_id_upgrade_video_id_to_source_id (VideoID* video_id);
#define VIDEO_TYPENAME "video"
gpointer video_row_ref (gpointer instance);
void video_row_unref (gpointer instance);
GParamSpec* param_spec_video_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_row (GValue* value, gpointer v_object);
void value_take_video_row (GValue* value, gpointer v_object);
gpointer value_get_video_row (const GValue* value);
GType video_row_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType rating_get_type (void) G_GNUC_CONST;
enum  {
	VIDEO_ROW_DUMMY_PROPERTY
};
VideoRow* video_row_new (void);
VideoRow* video_row_construct (GType object_type);
static void video_row_finalize (VideoRow* obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType video_table_get_type (void) G_GNUC_CONST;
enum  {
	VIDEO_TABLE_DUMMY_PROPERTY
};
static VideoTable* video_table_new (void);
static VideoTable* video_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_fatal (const gchar* op, gint res);
void database_table_set_table_name (DatabaseTable* self, const gchar* table_name);
VideoTable* video_table_get_instance (void);
GQuark database_error_quark (void);
void video_table_add (VideoTable* self, VideoRow* video_row, VideoID* result, GError** error);
gulong now_sec (void);
#define EVENT_ID_INVALID ((gint64) -1)
void database_table_throw_error (const gchar* method, gint res, GError** error);
void event_id_init (EventID *self, gint64 id);
gboolean video_table_drop_event (VideoTable* self, EventID* event_id);
VideoRow* video_table_get_row (VideoTable* self, VideoID* video_id);
Rating rating_unserialize (gint value);
GeeArrayList* video_table_get_all (VideoTable* self);
void video_table_set_filepath (VideoTable* self, VideoID* video_id, const gchar* filepath, GError** error);
void database_table_update_text_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text, GError** error);
void video_table_set_title (VideoTable* self, VideoID* video_id, const gchar* new_title, GError** error);
void video_table_set_comment (VideoTable* self, VideoID* video_id, const gchar* new_comment, GError** error);
void video_table_set_exposure_time (VideoTable* self, VideoID* video_id, time_t time, GError** error);
void database_table_update_int64_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint64 value, GError** error);
void video_table_set_rating (VideoTable* self, VideoID* video_id, Rating rating, GError** error);
gint rating_serialize (Rating self);
void video_table_set_flags (VideoTable* self, VideoID* video_id, guint64 flags, GError** error);
void video_table_update_backlinks (VideoTable* self, VideoID* video_id, const gchar* backlinks, GError** error);
void video_table_update_is_interpretable (VideoTable* self, VideoID* video_id, gboolean is_interpretable, GError** error);
void database_table_update_int_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint value, GError** error);
gboolean video_table_set_event (VideoTable* self, VideoID* video_id, EventID* event_id);
gboolean database_table_update_int64_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint64 value);
void video_table_remove_by_file (VideoTable* self, GFile* file, GError** error);
void video_table_remove (VideoTable* self, VideoID* videoID, GError** error);
gboolean video_table_is_video_stored (VideoTable* self, GFile* file);
void video_table_get_id (VideoTable* self, GFile* file, VideoID* result);
GeeArrayList* video_table_get_videos (VideoTable* self, GError** error);
static sqlite3_stmt* video_table_get_duplicate_stmt (VideoTable* self, GFile* file, const gchar* md5);
gboolean video_table_has_duplicate (VideoTable* self, GFile* file, const gchar* md5);
VideoID* video_table_get_duplicate_ids (VideoTable* self, GFile* file, const gchar* md5, int* result_length1);
static void _vala_array_add3 (VideoID** array, int* length, int* size, const VideoID* value);
GeeArrayList* video_table_get_event_source_ids (VideoTable* self, EventID* event_id);
void video_table_set_timestamp (VideoTable* self, VideoID* video_id, time_t timestamp, GError** error);
static void video_table_finalize (DatabaseTable* obj);


void video_id_init (VideoID *self, gint64 id) {
	gint64 _tmp0_ = 0LL;
#line 12 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	memset (self, 0, sizeof (VideoID));
#line 13 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = id;
#line 13 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	(*self).id = _tmp0_;
#line 266 "VideoTable.c"
}


gboolean video_id_is_invalid (VideoID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 17 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp0_ == VIDEO_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 279 "VideoTable.c"
}


gboolean video_id_is_valid (VideoID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 21 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp0_ != VIDEO_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 292 "VideoTable.c"
}


guint video_id_hash (VideoID* a) {
	guint result = 0U;
	VideoID* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	guint _tmp2_ = 0U;
#line 25 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = a;
#line 25 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = (*_tmp0_).id;
#line 25 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = int64_hash (&_tmp1_);
#line 25 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp2_;
#line 25 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 311 "VideoTable.c"
}


gboolean video_id_equal (void* a, void* b) {
	gboolean result = FALSE;
	void* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	void* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = a;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = (*((VideoID*) _tmp0_)).id;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = b;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = (*((VideoID*) _tmp2_)).id;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp1_ == _tmp3_;
#line 29 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 333 "VideoTable.c"
}


gchar* video_id_upgrade_video_id_to_source_id (VideoID* video_id) {
	gchar* result = NULL;
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
#line 32 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (video_id != NULL, NULL);
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = g_strdup_printf ("%s-%016" G_GINT64_MODIFIER "x", VIDEO_TYPENAME, _tmp1_);
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp2_;
#line 33 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 354 "VideoTable.c"
}


VideoID* video_id_dup (const VideoID* self) {
	VideoID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	dup = g_new0 (VideoID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	memcpy (dup, self, sizeof (VideoID));
#line 7 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return dup;
#line 366 "VideoTable.c"
}


void video_id_free (VideoID* self) {
#line 7 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_free (self);
#line 373 "VideoTable.c"
}


GType video_id_get_type (void) {
	static volatile gsize video_id_type_id__volatile = 0;
	if (g_once_init_enter (&video_id_type_id__volatile)) {
		GType video_id_type_id;
		video_id_type_id = g_boxed_type_register_static ("VideoID", (GBoxedCopyFunc) video_id_dup, (GBoxedFreeFunc) video_id_free);
		g_once_init_leave (&video_id_type_id__volatile, video_id_type_id);
	}
	return video_id_type_id__volatile;
}


VideoRow* video_row_construct (GType object_type) {
	VideoRow* self = NULL;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self = (VideoRow*) g_type_create_instance (object_type);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return self;
#line 394 "VideoTable.c"
}


VideoRow* video_row_new (void) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return video_row_construct (TYPE_VIDEO_ROW);
#line 401 "VideoTable.c"
}


static void value_video_row_init (GValue* value) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	value->data[0].v_pointer = NULL;
#line 408 "VideoTable.c"
}


static void value_video_row_free_value (GValue* value) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (value->data[0].v_pointer) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_row_unref (value->data[0].v_pointer);
#line 417 "VideoTable.c"
	}
}


static void value_video_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (src_value->data[0].v_pointer) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		dest_value->data[0].v_pointer = video_row_ref (src_value->data[0].v_pointer);
#line 427 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 431 "VideoTable.c"
	}
}


static gpointer value_video_row_peek_pointer (const GValue* value) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return value->data[0].v_pointer;
#line 439 "VideoTable.c"
}


static gchar* value_video_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (collect_values[0].v_pointer) {
#line 446 "VideoTable.c"
		VideoRow* object;
		object = collect_values[0].v_pointer;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 453 "VideoTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 457 "VideoTable.c"
		}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = video_row_ref (object);
#line 461 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = NULL;
#line 465 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return NULL;
#line 469 "VideoTable.c"
}


static gchar* value_video_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VideoRow** object_p;
	object_p = collect_values[0].v_pointer;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (!object_p) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 480 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (!value->data[0].v_pointer) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*object_p = NULL;
#line 486 "VideoTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*object_p = value->data[0].v_pointer;
#line 490 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*object_p = video_row_ref (value->data[0].v_pointer);
#line 494 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return NULL;
#line 498 "VideoTable.c"
}


GParamSpec* param_spec_video_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecVideoRow* spec;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_ROW), NULL);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return G_PARAM_SPEC (spec);
#line 512 "VideoTable.c"
}


gpointer value_get_video_row (const GValue* value) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW), NULL);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return value->data[0].v_pointer;
#line 521 "VideoTable.c"
}


void value_set_video_row (GValue* value, gpointer v_object) {
	VideoRow* old;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	old = value->data[0].v_pointer;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (v_object) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_ROW));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = v_object;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_row_ref (value->data[0].v_pointer);
#line 541 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = NULL;
#line 545 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (old) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_row_unref (old);
#line 551 "VideoTable.c"
	}
}


void value_take_video_row (GValue* value, gpointer v_object) {
	VideoRow* old;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_ROW));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	old = value->data[0].v_pointer;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (v_object) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_ROW));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = v_object;
#line 570 "VideoTable.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		value->data[0].v_pointer = NULL;
#line 574 "VideoTable.c"
	}
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (old) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_row_unref (old);
#line 580 "VideoTable.c"
	}
}


static void video_row_class_init (VideoRowClass * klass) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_row_parent_class = g_type_class_peek_parent (klass);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	((VideoRowClass *) klass)->finalize = video_row_finalize;
#line 590 "VideoTable.c"
}


static void video_row_instance_init (VideoRow * self) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self->ref_count = 1;
#line 597 "VideoTable.c"
}


static void video_row_finalize (VideoRow* obj) {
	VideoRow * self;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_ROW, VideoRow);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_signal_handlers_destroy (self);
#line 39 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->filepath);
#line 49 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->md5);
#line 52 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->title);
#line 53 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->backlinks);
#line 56 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (self->comment);
#line 617 "VideoTable.c"
}


GType video_row_get_type (void) {
	static volatile gsize video_row_type_id__volatile = 0;
	if (g_once_init_enter (&video_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_video_row_init, value_video_row_free_value, value_video_row_copy_value, value_video_row_peek_pointer, "p", value_video_row_collect_value, "p", value_video_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoRow), 0, (GInstanceInitFunc) video_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_row_type_id;
		video_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_row_type_id__volatile, video_row_type_id);
	}
	return video_row_type_id__volatile;
}


gpointer video_row_ref (gpointer instance) {
	VideoRow* self;
	self = instance;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return instance;
#line 642 "VideoTable.c"
}


void video_row_unref (gpointer instance) {
	VideoRow* self;
	self = instance;
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		VIDEO_ROW_GET_CLASS (self)->finalize (self);
#line 37 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 655 "VideoTable.c"
	}
}


static VideoTable* video_table_construct (GType object_type) {
	VideoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3_stmt* stmt2 = NULL;
	gint res2 = 0;
	sqlite3* _tmp8_ = NULL;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self = (VideoTable*) database_table_construct (object_type);
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS VideoTable (" "id INTEGER PRIMARY KEY, " "filename TEXT UNIQUE NOT NULL, " "width INTEGER, " "height INTEGER, " "clip_duration REAL, " "is_interpretable INTEGER, " "filesize INTEGER, " "timestamp INTEGER, " "exposure_time INTEGER, " "import_id INTEGER, " "event_id INTEGER, " "md5 TEXT, " "time_created INTEGER, " "rating INTEGER DEFAULT 0, " "title TEXT, " "backlinks TEXT, " "time_reimported INTEGER, " "flags INTEGER DEFAULT 0, " "comment TEXT " ")", -1, &_tmp1_, NULL);
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 64 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 85 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 85 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 87 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 87 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = sqlite3_step (_tmp4_);
#line 87 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp5_;
#line 88 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = res;
#line 88 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp6_ != SQLITE_DONE) {
#line 706 "VideoTable.c"
		gint _tmp7_ = 0;
#line 89 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp7_ = res;
#line 89 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_fatal ("VideoTable constructor", _tmp7_);
#line 712 "VideoTable.c"
	}
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = database_table_db;
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = sqlite3_prepare_v2 (_tmp8_, "CREATE INDEX IF NOT EXISTS VideoEventIDIndex ON VideoTable (event_id)", -1, &_tmp9_, NULL);
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt2);
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt2 = _tmp9_;
#line 93 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res2 = _tmp10_;
#line 95 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = res2;
#line 95 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res2 == Sqlite.OK");
#line 97 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = stmt2;
#line 97 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 97 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res2 = _tmp13_;
#line 98 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp14_ = res2;
#line 98 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp14_ != SQLITE_DONE) {
#line 738 "VideoTable.c"
		gint _tmp15_ = 0;
#line 99 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp15_ = res2;
#line 99 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_fatal ("VideoTable constructor", _tmp15_);
#line 744 "VideoTable.c"
	}
#line 101 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "VideoTable");
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt2);
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return self;
#line 754 "VideoTable.c"
}


static VideoTable* video_table_new (void) {
#line 62 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return video_table_construct (TYPE_VIDEO_TABLE);
#line 761 "VideoTable.c"
}


static gpointer _database_table_ref0 (gpointer self) {
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 768 "VideoTable.c"
}


VideoTable* video_table_get_instance (void) {
	VideoTable* result = NULL;
	VideoTable* _tmp0_ = NULL;
	VideoTable* _tmp2_ = NULL;
	VideoTable* _tmp3_ = NULL;
#line 105 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = video_table_instance;
#line 105 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp0_ == NULL) {
#line 781 "VideoTable.c"
		VideoTable* _tmp1_ = NULL;
#line 106 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp1_ = video_table_new ();
#line 106 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_database_table_unref0 (video_table_instance);
#line 106 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_table_instance = _tmp1_;
#line 789 "VideoTable.c"
	}
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = video_table_instance;
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp3_;
#line 108 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 799 "VideoTable.c"
}


void video_table_add (VideoTable* self, VideoRow* video_row, VideoID* result, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gulong time_created = 0UL;
	gulong _tmp4_ = 0UL;
	sqlite3_stmt* _tmp5_ = NULL;
	VideoRow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GDestroyNotify _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	VideoRow* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	sqlite3_stmt* _tmp17_ = NULL;
	VideoRow* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	sqlite3_stmt* _tmp22_ = NULL;
	VideoRow* _tmp23_ = NULL;
	gdouble _tmp24_ = 0.0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	VideoRow* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	sqlite3_stmt* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	sqlite3_stmt* _tmp33_ = NULL;
	VideoRow* _tmp34_ = NULL;
	gint64 _tmp35_ = 0LL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	sqlite3_stmt* _tmp38_ = NULL;
	VideoRow* _tmp39_ = NULL;
	time_t _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	sqlite3_stmt* _tmp43_ = NULL;
	VideoRow* _tmp44_ = NULL;
	time_t _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	sqlite3_stmt* _tmp48_ = NULL;
	VideoRow* _tmp49_ = NULL;
	ImportID _tmp50_ = {0};
	gint64 _tmp51_ = 0LL;
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	sqlite3_stmt* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	sqlite3_stmt* _tmp57_ = NULL;
	VideoRow* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	GDestroyNotify _tmp61_ = NULL;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	sqlite3_stmt* _tmp64_ = NULL;
	gulong _tmp65_ = 0UL;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	sqlite3_stmt* _tmp68_ = NULL;
	VideoRow* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	gchar* _tmp71_ = NULL;
	GDestroyNotify _tmp72_ = NULL;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	sqlite3_stmt* _tmp75_ = NULL;
	VideoRow* _tmp76_ = NULL;
	const gchar* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
	GDestroyNotify _tmp79_ = NULL;
	gint _tmp80_ = 0;
	gint _tmp81_ = 0;
	sqlite3_stmt* _tmp82_ = NULL;
	gint _tmp83_ = 0;
	gint _tmp84_ = 0;
	VideoRow* _tmp87_ = NULL;
	sqlite3* _tmp88_ = NULL;
	gint64 _tmp89_ = 0LL;
	VideoRow* _tmp90_ = NULL;
	VideoRow* _tmp91_ = NULL;
	gulong _tmp92_ = 0UL;
	VideoRow* _tmp93_ = NULL;
	VideoRow* _tmp94_ = NULL;
	VideoID _tmp95_ = {0};
	GError * _inner_error_ = NULL;
#line 113 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 113 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_ROW (video_row));
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO VideoTable (filename, width, height, clip_duration, is_int" \
"erpretable, " "filesize, timestamp, exposure_time, import_id, event_id, md5, time_cre" \
"ated, title, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 115 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 120 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 120 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 122 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = now_sec ();
#line 122 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	time_created = _tmp4_;
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = stmt;
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = video_row;
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = _tmp6_->filepath;
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = g_free;
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = sqlite3_bind_text (_tmp5_, 1, _tmp8_, -1, _tmp9_);
#line 124 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp10_;
#line 125 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = res;
#line 125 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 126 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = stmt;
#line 126 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = video_row;
#line 126 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp14_ = _tmp13_->width;
#line 126 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp15_ = sqlite3_bind_int (_tmp12_, 2, _tmp14_);
#line 126 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp15_;
#line 127 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp16_ = res;
#line 127 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp16_ == SQLITE_OK, "res == Sqlite.OK");
#line 128 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp17_ = stmt;
#line 128 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp18_ = video_row;
#line 128 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp19_ = _tmp18_->height;
#line 128 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp20_ = sqlite3_bind_int (_tmp17_, 3, _tmp19_);
#line 128 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp20_;
#line 129 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp21_ = res;
#line 129 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp21_ == SQLITE_OK, "res == Sqlite.OK");
#line 130 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp22_ = stmt;
#line 130 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp23_ = video_row;
#line 130 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp24_ = _tmp23_->clip_duration;
#line 130 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp25_ = sqlite3_bind_double (_tmp22_, 4, _tmp24_);
#line 130 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp25_;
#line 131 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp26_ = res;
#line 131 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp26_ == SQLITE_OK, "res == Sqlite.OK");
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp28_ = video_row;
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp29_ = _tmp28_->is_interpretable;
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp29_) {
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp27_ = 1;
#line 992 "VideoTable.c"
	} else {
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp27_ = 0;
#line 996 "VideoTable.c"
	}
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp30_ = stmt;
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp31_ = sqlite3_bind_int (_tmp30_, 5, _tmp27_);
#line 132 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp31_;
#line 133 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp32_ = res;
#line 133 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp32_ == SQLITE_OK, "res == Sqlite.OK");
#line 134 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp33_ = stmt;
#line 134 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp34_ = video_row;
#line 134 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp35_ = _tmp34_->filesize;
#line 134 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp36_ = sqlite3_bind_int64 (_tmp33_, 6, _tmp35_);
#line 134 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp36_;
#line 135 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp37_ = res;
#line 135 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp37_ == SQLITE_OK, "res == Sqlite.OK");
#line 136 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp38_ = stmt;
#line 136 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp39_ = video_row;
#line 136 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp40_ = _tmp39_->timestamp;
#line 136 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp41_ = sqlite3_bind_int64 (_tmp38_, 7, (gint64) _tmp40_);
#line 136 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp41_;
#line 137 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp42_ = res;
#line 137 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp42_ == SQLITE_OK, "res == Sqlite.OK");
#line 138 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp43_ = stmt;
#line 138 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp44_ = video_row;
#line 138 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp45_ = _tmp44_->exposure_time;
#line 138 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp46_ = sqlite3_bind_int64 (_tmp43_, 8, (gint64) _tmp45_);
#line 138 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp46_;
#line 139 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp47_ = res;
#line 139 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp47_ == SQLITE_OK, "res == Sqlite.OK");
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp48_ = stmt;
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp49_ = video_row;
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp50_ = _tmp49_->import_id;
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp51_ = _tmp50_.id;
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp52_ = sqlite3_bind_int64 (_tmp48_, 9, _tmp51_);
#line 140 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp52_;
#line 141 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp53_ = res;
#line 141 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp53_ == SQLITE_OK, "res == Sqlite.OK");
#line 142 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp54_ = stmt;
#line 142 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp55_ = sqlite3_bind_int64 (_tmp54_, 10, EVENT_ID_INVALID);
#line 142 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp55_;
#line 143 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp56_ = res;
#line 143 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp56_ == SQLITE_OK, "res == Sqlite.OK");
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp57_ = stmt;
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp58_ = video_row;
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp59_ = _tmp58_->md5;
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp60_ = g_strdup (_tmp59_);
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp61_ = g_free;
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp62_ = sqlite3_bind_text (_tmp57_, 11, _tmp60_, -1, _tmp61_);
#line 144 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp62_;
#line 145 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp63_ = res;
#line 145 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp63_ == SQLITE_OK, "res == Sqlite.OK");
#line 146 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp64_ = stmt;
#line 146 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp65_ = time_created;
#line 146 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp66_ = sqlite3_bind_int64 (_tmp64_, 12, (gint64) _tmp65_);
#line 146 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp66_;
#line 147 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp67_ = res;
#line 147 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp67_ == SQLITE_OK, "res == Sqlite.OK");
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp68_ = stmt;
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp69_ = video_row;
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp70_ = _tmp69_->title;
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp71_ = g_strdup (_tmp70_);
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp72_ = g_free;
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp73_ = sqlite3_bind_text (_tmp68_, 13, _tmp71_, -1, _tmp72_);
#line 148 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp73_;
#line 149 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp74_ = res;
#line 149 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp74_ == SQLITE_OK, "res == Sqlite.OK");
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp75_ = stmt;
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp76_ = video_row;
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp77_ = _tmp76_->comment;
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp78_ = g_strdup (_tmp77_);
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp79_ = g_free;
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp80_ = sqlite3_bind_text (_tmp75_, 14, _tmp78_, -1, _tmp79_);
#line 150 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp80_;
#line 151 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp81_ = res;
#line 151 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp81_ == SQLITE_OK, "res == Sqlite.OK");
#line 153 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp82_ = stmt;
#line 153 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp83_ = sqlite3_step (_tmp82_);
#line 153 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp83_;
#line 154 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp84_ = res;
#line 154 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp84_ != SQLITE_DONE) {
#line 1152 "VideoTable.c"
		gint _tmp85_ = 0;
#line 155 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp85_ = res;
#line 155 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_tmp85_ != SQLITE_CONSTRAINT) {
#line 1158 "VideoTable.c"
			gint _tmp86_ = 0;
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp86_ = res;
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			database_table_throw_error ("VideoTable.add", _tmp86_, &_inner_error_);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					_sqlite3_finalize0 (stmt);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					return;
#line 1174 "VideoTable.c"
				} else {
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					_sqlite3_finalize0 (stmt);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					g_clear_error (&_inner_error_);
#line 156 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					return;
#line 1184 "VideoTable.c"
				}
			}
		}
	}
#line 160 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp87_ = video_row;
#line 160 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp88_ = database_table_db;
#line 160 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp89_ = sqlite3_last_insert_rowid (_tmp88_);
#line 160 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_id_init (&_tmp87_->video_id, _tmp89_);
#line 161 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp90_ = video_row;
#line 161 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	event_id_init (&_tmp90_->event_id, EVENT_ID_INVALID);
#line 162 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp91_ = video_row;
#line 162 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp92_ = time_created;
#line 162 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp91_->time_created = (time_t) _tmp92_;
#line 163 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp93_ = video_row;
#line 163 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp93_->flags = (guint64) 0;
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp94_ = video_row;
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp95_ = _tmp94_->video_id;
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	*result = _tmp95_;
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 165 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return;
#line 1221 "VideoTable.c"
}


gboolean video_table_drop_event (VideoTable* self, EventID* event_id) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3_stmt* _tmp7_ = NULL;
	EventID _tmp8_ = {0};
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
#line 168 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
#line 168 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE VideoTable SET event_id = ? WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 170 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 171 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 171 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 173 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 173 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = sqlite3_bind_int64 (_tmp4_, 1, EVENT_ID_INVALID);
#line 173 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp5_;
#line 174 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = res;
#line 174 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = stmt;
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = *event_id;
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = _tmp8_.id;
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp7_, 2, _tmp9_);
#line 175 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp10_;
#line 176 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = res;
#line 176 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 178 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = stmt;
#line 178 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 178 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp13_;
#line 179 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp14_ = res;
#line 179 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp14_ != SQLITE_DONE) {
#line 1296 "VideoTable.c"
		gint _tmp15_ = 0;
#line 180 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp15_ = res;
#line 180 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_fatal ("VideoTable.drop_event", _tmp15_);
#line 182 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		result = FALSE;
#line 182 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 182 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		return result;
#line 1308 "VideoTable.c"
	}
#line 185 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = TRUE;
#line 185 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 185 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 1316 "VideoTable.c"
}


VideoRow* video_table_get_row (VideoTable* self, VideoID* video_id) {
	VideoRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	VideoID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	VideoRow* row = NULL;
	VideoRow* _tmp11_ = NULL;
	VideoRow* _tmp12_ = NULL;
	VideoID _tmp13_ = {0};
	VideoRow* _tmp14_ = NULL;
	sqlite3_stmt* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	VideoRow* _tmp18_ = NULL;
	sqlite3_stmt* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	VideoRow* _tmp21_ = NULL;
	sqlite3_stmt* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	VideoRow* _tmp24_ = NULL;
	sqlite3_stmt* _tmp25_ = NULL;
	gdouble _tmp26_ = 0.0;
	VideoRow* _tmp27_ = NULL;
	sqlite3_stmt* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	VideoRow* _tmp30_ = NULL;
	sqlite3_stmt* _tmp31_ = NULL;
	gint64 _tmp32_ = 0LL;
	VideoRow* _tmp33_ = NULL;
	sqlite3_stmt* _tmp34_ = NULL;
	gint64 _tmp35_ = 0LL;
	VideoRow* _tmp36_ = NULL;
	sqlite3_stmt* _tmp37_ = NULL;
	gint64 _tmp38_ = 0LL;
	VideoRow* _tmp39_ = NULL;
	sqlite3_stmt* _tmp40_ = NULL;
	gint64 _tmp41_ = 0LL;
	VideoRow* _tmp42_ = NULL;
	sqlite3_stmt* _tmp43_ = NULL;
	gint64 _tmp44_ = 0LL;
	VideoRow* _tmp45_ = NULL;
	sqlite3_stmt* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	VideoRow* _tmp49_ = NULL;
	sqlite3_stmt* _tmp50_ = NULL;
	gint64 _tmp51_ = 0LL;
	VideoRow* _tmp52_ = NULL;
	sqlite3_stmt* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	Rating _tmp55_ = 0;
	VideoRow* _tmp56_ = NULL;
	sqlite3_stmt* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	VideoRow* _tmp60_ = NULL;
	sqlite3_stmt* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	VideoRow* _tmp64_ = NULL;
	sqlite3_stmt* _tmp65_ = NULL;
	gint64 _tmp66_ = 0LL;
	VideoRow* _tmp67_ = NULL;
	sqlite3_stmt* _tmp68_ = NULL;
	gint64 _tmp69_ = 0LL;
	VideoRow* _tmp70_ = NULL;
	sqlite3_stmt* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
#line 188 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 188 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (video_id != NULL, NULL);
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filename, width, height, clip_duration, is_interpretable, files" \
"ize, timestamp, " "exposure_time, import_id, event_id, md5, time_created, rating, title, " \
"backlinks, " "time_reimported, flags, comment FROM VideoTable WHERE id=?", -1, &_tmp1_, NULL);
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 190 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 195 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 195 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = *video_id;
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 197 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp7_;
#line 198 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = res;
#line 198 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 200 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = stmt;
#line 200 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 200 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp10_ != SQLITE_ROW) {
#line 201 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		result = NULL;
#line 201 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 201 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		return result;
#line 1443 "VideoTable.c"
	}
#line 203 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = video_row_new ();
#line 203 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	row = _tmp11_;
#line 204 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = row;
#line 204 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = *video_id;
#line 204 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_->video_id = _tmp13_;
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp14_ = row;
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp15_ = stmt;
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp16_ = sqlite3_column_text (_tmp15_, 0);
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp14_->filepath);
#line 205 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp14_->filepath = _tmp17_;
#line 206 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp18_ = row;
#line 206 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp19_ = stmt;
#line 206 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp20_ = sqlite3_column_int (_tmp19_, 1);
#line 206 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp18_->width = _tmp20_;
#line 207 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp21_ = row;
#line 207 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp22_ = stmt;
#line 207 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp23_ = sqlite3_column_int (_tmp22_, 2);
#line 207 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp21_->height = _tmp23_;
#line 208 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp24_ = row;
#line 208 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp25_ = stmt;
#line 208 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp26_ = sqlite3_column_double (_tmp25_, 3);
#line 208 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp24_->clip_duration = _tmp26_;
#line 209 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp27_ = row;
#line 209 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp28_ = stmt;
#line 209 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp29_ = sqlite3_column_int (_tmp28_, 4);
#line 209 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp27_->is_interpretable = _tmp29_ == 1;
#line 210 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp30_ = row;
#line 210 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp31_ = stmt;
#line 210 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp32_ = sqlite3_column_int64 (_tmp31_, 5);
#line 210 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp30_->filesize = _tmp32_;
#line 211 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp33_ = row;
#line 211 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp34_ = stmt;
#line 211 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp35_ = sqlite3_column_int64 (_tmp34_, 6);
#line 211 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp33_->timestamp = (time_t) _tmp35_;
#line 212 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp36_ = row;
#line 212 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp37_ = stmt;
#line 212 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp38_ = sqlite3_column_int64 (_tmp37_, 7);
#line 212 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp36_->exposure_time = (time_t) _tmp38_;
#line 213 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp39_ = row;
#line 213 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp40_ = stmt;
#line 213 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp41_ = sqlite3_column_int64 (_tmp40_, 8);
#line 213 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp39_->import_id.id = _tmp41_;
#line 214 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp42_ = row;
#line 214 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp43_ = stmt;
#line 214 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp44_ = sqlite3_column_int64 (_tmp43_, 9);
#line 214 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp42_->event_id.id = _tmp44_;
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp45_ = row;
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp46_ = stmt;
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp47_ = sqlite3_column_text (_tmp46_, 10);
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp48_ = g_strdup (_tmp47_);
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp45_->md5);
#line 215 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp45_->md5 = _tmp48_;
#line 216 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp49_ = row;
#line 216 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp50_ = stmt;
#line 216 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp51_ = sqlite3_column_int64 (_tmp50_, 11);
#line 216 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp49_->time_created = (time_t) _tmp51_;
#line 217 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp52_ = row;
#line 217 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp53_ = stmt;
#line 217 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp54_ = sqlite3_column_int (_tmp53_, 12);
#line 217 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp55_ = rating_unserialize (_tmp54_);
#line 217 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp52_->rating = _tmp55_;
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp56_ = row;
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp57_ = stmt;
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp58_ = sqlite3_column_text (_tmp57_, 13);
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp59_ = g_strdup (_tmp58_);
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp56_->title);
#line 218 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp56_->title = _tmp59_;
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp60_ = row;
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp61_ = stmt;
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp62_ = sqlite3_column_text (_tmp61_, 14);
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp63_ = g_strdup (_tmp62_);
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp60_->backlinks);
#line 219 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp60_->backlinks = _tmp63_;
#line 220 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp64_ = row;
#line 220 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp65_ = stmt;
#line 220 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp66_ = sqlite3_column_int64 (_tmp65_, 15);
#line 220 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp64_->time_reimported = (time_t) _tmp66_;
#line 221 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp67_ = row;
#line 221 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp68_ = stmt;
#line 221 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp69_ = sqlite3_column_int64 (_tmp68_, 16);
#line 221 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp67_->flags = (guint64) _tmp69_;
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp70_ = row;
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp71_ = stmt;
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp72_ = sqlite3_column_text (_tmp71_, 17);
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp73_ = g_strdup (_tmp72_);
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (_tmp70_->comment);
#line 222 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp70_->comment = _tmp73_;
#line 224 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = row;
#line 224 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 224 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 1627 "VideoTable.c"
}


GeeArrayList* video_table_get_all (VideoTable* self) {
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, filename, width, height, clip_duration, is_interpretable, f" \
"ilesize, " "timestamp, exposure_time, import_id, event_id, md5, time_created, rati" \
"ng, title, " "backlinks, time_reimported, flags, comment FROM VideoTable", -1, &_tmp1_, NULL);
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 229 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 234 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 234 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 236 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_VIDEO_ROW, (GBoxedCopyFunc) video_row_ref, video_row_unref, NULL, NULL, NULL);
#line 236 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	all = _tmp4_;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	while (TRUE) {
#line 1663 "VideoTable.c"
		sqlite3_stmt* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		VideoRow* row = NULL;
		VideoRow* _tmp8_ = NULL;
		VideoRow* _tmp9_ = NULL;
		sqlite3_stmt* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
		VideoRow* _tmp12_ = NULL;
		sqlite3_stmt* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		VideoRow* _tmp16_ = NULL;
		sqlite3_stmt* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		VideoRow* _tmp19_ = NULL;
		sqlite3_stmt* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		VideoRow* _tmp22_ = NULL;
		sqlite3_stmt* _tmp23_ = NULL;
		gdouble _tmp24_ = 0.0;
		VideoRow* _tmp25_ = NULL;
		sqlite3_stmt* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		VideoRow* _tmp28_ = NULL;
		sqlite3_stmt* _tmp29_ = NULL;
		gint64 _tmp30_ = 0LL;
		VideoRow* _tmp31_ = NULL;
		sqlite3_stmt* _tmp32_ = NULL;
		gint64 _tmp33_ = 0LL;
		VideoRow* _tmp34_ = NULL;
		sqlite3_stmt* _tmp35_ = NULL;
		gint64 _tmp36_ = 0LL;
		VideoRow* _tmp37_ = NULL;
		sqlite3_stmt* _tmp38_ = NULL;
		gint64 _tmp39_ = 0LL;
		VideoRow* _tmp40_ = NULL;
		sqlite3_stmt* _tmp41_ = NULL;
		gint64 _tmp42_ = 0LL;
		VideoRow* _tmp43_ = NULL;
		sqlite3_stmt* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		VideoRow* _tmp47_ = NULL;
		sqlite3_stmt* _tmp48_ = NULL;
		gint64 _tmp49_ = 0LL;
		VideoRow* _tmp50_ = NULL;
		sqlite3_stmt* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		Rating _tmp53_ = 0;
		VideoRow* _tmp54_ = NULL;
		sqlite3_stmt* _tmp55_ = NULL;
		const gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		VideoRow* _tmp58_ = NULL;
		sqlite3_stmt* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		VideoRow* _tmp62_ = NULL;
		sqlite3_stmt* _tmp63_ = NULL;
		gint64 _tmp64_ = 0LL;
		VideoRow* _tmp65_ = NULL;
		sqlite3_stmt* _tmp66_ = NULL;
		gint64 _tmp67_ = 0LL;
		VideoRow* _tmp68_ = NULL;
		sqlite3_stmt* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		GeeArrayList* _tmp72_ = NULL;
		VideoRow* _tmp73_ = NULL;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp5_ = stmt;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp6_ = sqlite3_step (_tmp5_);
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		res = _tmp6_;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp7_ = res;
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (!(_tmp7_ == SQLITE_ROW)) {
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			break;
#line 1746 "VideoTable.c"
		}
#line 239 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp8_ = video_row_new ();
#line 239 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		row = _tmp8_;
#line 240 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp9_ = row;
#line 240 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp10_ = stmt;
#line 240 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp11_ = sqlite3_column_int64 (_tmp10_, 0);
#line 240 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp9_->video_id.id = _tmp11_;
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp12_ = row;
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp13_ = stmt;
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp14_ = sqlite3_column_text (_tmp13_, 1);
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp12_->filepath);
#line 241 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp12_->filepath = _tmp15_;
#line 242 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp16_ = row;
#line 242 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp17_ = stmt;
#line 242 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp18_ = sqlite3_column_int (_tmp17_, 2);
#line 242 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp16_->width = _tmp18_;
#line 243 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp19_ = row;
#line 243 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp20_ = stmt;
#line 243 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp21_ = sqlite3_column_int (_tmp20_, 3);
#line 243 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp19_->height = _tmp21_;
#line 244 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp22_ = row;
#line 244 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp23_ = stmt;
#line 244 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp24_ = sqlite3_column_double (_tmp23_, 4);
#line 244 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp22_->clip_duration = _tmp24_;
#line 245 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp25_ = row;
#line 245 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp26_ = stmt;
#line 245 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp27_ = sqlite3_column_int (_tmp26_, 5);
#line 245 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp25_->is_interpretable = _tmp27_ == 1;
#line 246 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp28_ = row;
#line 246 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp29_ = stmt;
#line 246 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp30_ = sqlite3_column_int64 (_tmp29_, 6);
#line 246 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp28_->filesize = _tmp30_;
#line 247 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp31_ = row;
#line 247 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp32_ = stmt;
#line 247 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp33_ = sqlite3_column_int64 (_tmp32_, 7);
#line 247 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp31_->timestamp = (time_t) _tmp33_;
#line 248 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp34_ = row;
#line 248 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp35_ = stmt;
#line 248 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp36_ = sqlite3_column_int64 (_tmp35_, 8);
#line 248 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp34_->exposure_time = (time_t) _tmp36_;
#line 249 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp37_ = row;
#line 249 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp38_ = stmt;
#line 249 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp39_ = sqlite3_column_int64 (_tmp38_, 9);
#line 249 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp37_->import_id.id = _tmp39_;
#line 250 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp40_ = row;
#line 250 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp41_ = stmt;
#line 250 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp42_ = sqlite3_column_int64 (_tmp41_, 10);
#line 250 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp40_->event_id.id = _tmp42_;
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp43_ = row;
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp44_ = stmt;
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp45_ = sqlite3_column_text (_tmp44_, 11);
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp46_ = g_strdup (_tmp45_);
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp43_->md5);
#line 251 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp43_->md5 = _tmp46_;
#line 252 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp47_ = row;
#line 252 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp48_ = stmt;
#line 252 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp49_ = sqlite3_column_int64 (_tmp48_, 12);
#line 252 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp47_->time_created = (time_t) _tmp49_;
#line 253 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp50_ = row;
#line 253 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp51_ = stmt;
#line 253 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp52_ = sqlite3_column_int (_tmp51_, 13);
#line 253 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp53_ = rating_unserialize (_tmp52_);
#line 253 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp50_->rating = _tmp53_;
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp54_ = row;
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp55_ = stmt;
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp56_ = sqlite3_column_text (_tmp55_, 14);
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp57_ = g_strdup (_tmp56_);
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp54_->title);
#line 254 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp54_->title = _tmp57_;
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp58_ = row;
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp59_ = stmt;
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp60_ = sqlite3_column_text (_tmp59_, 15);
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp61_ = g_strdup (_tmp60_);
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp58_->backlinks);
#line 255 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp58_->backlinks = _tmp61_;
#line 256 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp62_ = row;
#line 256 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp63_ = stmt;
#line 256 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp64_ = sqlite3_column_int64 (_tmp63_, 16);
#line 256 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp62_->time_reimported = (time_t) _tmp64_;
#line 257 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp65_ = row;
#line 257 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp66_ = stmt;
#line 257 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp67_ = sqlite3_column_int64 (_tmp66_, 17);
#line 257 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp65_->flags = (guint64) _tmp67_;
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp68_ = row;
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp69_ = stmt;
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp70_ = sqlite3_column_text (_tmp69_, 18);
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp71_ = g_strdup (_tmp70_);
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (_tmp68_->comment);
#line 258 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp68_->comment = _tmp71_;
#line 260 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp72_ = all;
#line 260 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp73_ = row;
#line 260 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp73_);
#line 238 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_video_row_unref0 (row);
#line 1934 "VideoTable.c"
	}
#line 263 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = all;
#line 263 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 263 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 1942 "VideoTable.c"
}


void video_table_set_filepath (VideoTable* self, VideoID* video_id, const gchar* filepath, GError** error) {
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 266 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 266 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 266 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (filepath != NULL);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = filepath;
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "filename", _tmp2_, &_inner_error_);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 1973 "VideoTable.c"
		} else {
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 267 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 1981 "VideoTable.c"
		}
	}
}


void video_table_set_title (VideoTable* self, VideoID* video_id, const gchar* new_title, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	VideoID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	GError * _inner_error_ = NULL;
#line 270 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 270 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = new_title;
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp1_ != NULL) {
#line 2001 "VideoTable.c"
		const gchar* _tmp2_ = NULL;
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp2_ = new_title;
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = _tmp2_;
#line 2007 "VideoTable.c"
	} else {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = "";
#line 2011 "VideoTable.c"
	}
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = *video_id;
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = _tmp3_.id;
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_, "title", _tmp0_, &_inner_error_);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2027 "VideoTable.c"
		} else {
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 271 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2035 "VideoTable.c"
		}
	}
}


void video_table_set_comment (VideoTable* self, VideoID* video_id, const gchar* new_comment, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	VideoID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	GError * _inner_error_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 274 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = new_comment;
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp1_ != NULL) {
#line 2055 "VideoTable.c"
		const gchar* _tmp2_ = NULL;
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp2_ = new_comment;
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = _tmp2_;
#line 2061 "VideoTable.c"
	} else {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = "";
#line 2065 "VideoTable.c"
	}
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = *video_id;
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = _tmp3_.id;
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_, "comment", _tmp0_, &_inner_error_);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2081 "VideoTable.c"
		} else {
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 275 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2089 "VideoTable.c"
		}
	}
}


void video_table_set_exposure_time (VideoTable* self, VideoID* video_id, time_t time, GError** error) {
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	time_t _tmp2_ = 0;
	GError * _inner_error_ = NULL;
#line 278 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 278 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = time;
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "exposure_time", (gint64) _tmp2_, &_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2120 "VideoTable.c"
		} else {
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 279 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2128 "VideoTable.c"
		}
	}
}


void video_table_set_rating (VideoTable* self, VideoID* video_id, Rating rating, GError** error) {
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	Rating _tmp2_ = 0;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
#line 282 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 282 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = rating;
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = rating_serialize (_tmp2_);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "rating", (gint64) _tmp3_, &_inner_error_);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2162 "VideoTable.c"
		} else {
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 283 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2170 "VideoTable.c"
		}
	}
}


void video_table_set_flags (VideoTable* self, VideoID* video_id, guint64 flags, GError** error) {
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	guint64 _tmp2_ = 0ULL;
	GError * _inner_error_ = NULL;
#line 286 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 286 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = flags;
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "flags", (gint64) _tmp2_, &_inner_error_);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2201 "VideoTable.c"
		} else {
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 287 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2209 "VideoTable.c"
		}
	}
}


void video_table_update_backlinks (VideoTable* self, VideoID* video_id, const gchar* backlinks, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	VideoID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	GError * _inner_error_ = NULL;
#line 290 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 290 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = backlinks;
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp1_ != NULL) {
#line 2229 "VideoTable.c"
		const gchar* _tmp2_ = NULL;
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp2_ = backlinks;
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = _tmp2_;
#line 2235 "VideoTable.c"
	} else {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = "";
#line 2239 "VideoTable.c"
	}
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = *video_id;
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = _tmp3_.id;
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_, "backlinks", _tmp0_, &_inner_error_);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2255 "VideoTable.c"
		} else {
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 291 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2263 "VideoTable.c"
		}
	}
}


void video_table_update_is_interpretable (VideoTable* self, VideoID* video_id, gboolean is_interpretable, GError** error) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	VideoID _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	GError * _inner_error_ = NULL;
#line 294 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 294 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = is_interpretable;
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp1_) {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = 1;
#line 2285 "VideoTable.c"
	} else {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = 0;
#line 2289 "VideoTable.c"
	}
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = *video_id;
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp3_, "is_interpretable", _tmp0_, &_inner_error_);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2305 "VideoTable.c"
		} else {
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 295 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 2313 "VideoTable.c"
		}
	}
}


gboolean video_table_set_event (VideoTable* self, VideoID* video_id, EventID* event_id) {
	gboolean result = FALSE;
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	EventID _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_ = FALSE;
#line 298 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
#line 298 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (video_id != NULL, FALSE);
#line 298 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = *event_id;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "event_id", _tmp3_);
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp4_;
#line 299 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2346 "VideoTable.c"
}


void video_table_remove_by_file (VideoTable* self, GFile* file, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GDestroyNotify _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	GError * _inner_error_ = NULL;
#line 302 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 302 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM VideoTable WHERE filename=?", -1, &_tmp1_, NULL);
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 304 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 305 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 305 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = file;
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = g_free;
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
#line 307 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp8_;
#line 308 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = res;
#line 308 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 310 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = stmt;
#line 310 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = sqlite3_step (_tmp10_);
#line 310 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp11_;
#line 311 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp12_ = res;
#line 311 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 2411 "VideoTable.c"
		gint _tmp13_ = 0;
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp13_ = res;
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_throw_error ("VideoTable.remove_by_file", _tmp13_, &_inner_error_);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				return;
#line 2427 "VideoTable.c"
			} else {
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_clear_error (&_inner_error_);
#line 312 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				return;
#line 2437 "VideoTable.c"
			}
		}
	}
#line 302 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 2443 "VideoTable.c"
}


void video_table_remove (VideoTable* self, VideoID* videoID, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	VideoID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
#line 315 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 315 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (videoID != NULL);
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM VideoTable WHERE id=?", -1, &_tmp1_, NULL);
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 317 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 318 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 318 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = *videoID;
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 320 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp7_;
#line 321 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = res;
#line 321 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 323 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = stmt;
#line 323 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 323 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp10_;
#line 324 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = res;
#line 324 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp11_ != SQLITE_DONE) {
#line 2505 "VideoTable.c"
		gint _tmp12_ = 0;
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp12_ = res;
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		database_table_throw_error ("VideoTable.remove", _tmp12_, &_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				return;
#line 2521 "VideoTable.c"
			} else {
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				g_clear_error (&_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				return;
#line 2531 "VideoTable.c"
			}
		}
	}
#line 315 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 2537 "VideoTable.c"
}


gboolean video_table_is_video_stored (VideoTable* self, GFile* file) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	VideoID _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 328 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
#line 328 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 329 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = file;
#line 329 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_table_get_id (self, _tmp0_, &_tmp1_);
#line 329 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = video_id_is_valid (&_tmp1_);
#line 329 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp2_;
#line 329 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2560 "VideoTable.c"
}


void video_table_get_id (VideoTable* self, GFile* file, VideoID* result) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GDestroyNotify _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	VideoID _tmp12_ = {0};
	gint _tmp13_ = 0;
#line 332 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 332 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT ID FROM VideoTable WHERE filename=?", -1, &_tmp1_, NULL);
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 334 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 335 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 335 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = file;
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = g_free;
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
#line 337 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp8_;
#line 338 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = res;
#line 338 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 340 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp10_ = stmt;
#line 340 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp11_ = sqlite3_step (_tmp10_);
#line 340 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp11_;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = res;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp13_ == SQLITE_ROW) {
#line 2625 "VideoTable.c"
		sqlite3_stmt* _tmp14_ = NULL;
		gint64 _tmp15_ = 0LL;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp14_ = stmt;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp15_ = sqlite3_column_int64 (_tmp14_, 0);
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_id_init (&_tmp12_, _tmp15_);
#line 2634 "VideoTable.c"
	} else {
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_id_init (&_tmp12_, VIDEO_ID_INVALID);
#line 2638 "VideoTable.c"
	}
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	*result = _tmp12_;
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 342 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return;
#line 2646 "VideoTable.c"
}


GeeArrayList* video_table_get_videos (VideoTable* self, GError** error) {
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeArrayList* video_ids = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 345 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM VideoTable", -1, &_tmp1_, NULL);
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 347 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 348 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 348 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 350 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_VIDEO_ID, (GBoxedCopyFunc) video_id_dup, video_id_free, NULL, NULL, NULL);
#line 350 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_ids = _tmp4_;
#line 2681 "VideoTable.c"
	{
		gboolean _tmp5_ = FALSE;
#line 351 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp5_ = TRUE;
#line 351 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		while (TRUE) {
#line 2688 "VideoTable.c"
			sqlite3_stmt* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			GeeArrayList* _tmp11_ = NULL;
			sqlite3_stmt* _tmp12_ = NULL;
			gint64 _tmp13_ = 0LL;
			VideoID _tmp14_ = {0};
#line 351 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (!_tmp5_) {
#line 2698 "VideoTable.c"
			}
#line 351 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp5_ = FALSE;
#line 352 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp6_ = stmt;
#line 352 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp7_ = sqlite3_step (_tmp6_);
#line 352 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			res = _tmp7_;
#line 353 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp8_ = res;
#line 353 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (_tmp8_ == SQLITE_DONE) {
#line 354 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				break;
#line 2714 "VideoTable.c"
			} else {
				gint _tmp9_ = 0;
#line 355 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_tmp9_ = res;
#line 355 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				if (_tmp9_ != SQLITE_ROW) {
#line 2721 "VideoTable.c"
					gint _tmp10_ = 0;
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					_tmp10_ = res;
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					database_table_throw_error ("VideoTable.get_videos", _tmp10_, &_inner_error_);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							g_propagate_error (error, _inner_error_);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							_g_object_unref0 (video_ids);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							_sqlite3_finalize0 (stmt);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							return NULL;
#line 2739 "VideoTable.c"
						} else {
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							_g_object_unref0 (video_ids);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							_sqlite3_finalize0 (stmt);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							g_clear_error (&_inner_error_);
#line 356 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
							return NULL;
#line 2751 "VideoTable.c"
						}
					}
				}
			}
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp11_ = video_ids;
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp12_ = stmt;
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp13_ = sqlite3_column_int64 (_tmp12_, 0);
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			video_id_init (&_tmp14_, _tmp13_);
#line 359 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp14_);
#line 2766 "VideoTable.c"
		}
	}
#line 362 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = video_ids;
#line 362 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 362 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2775 "VideoTable.c"
}


static sqlite3_stmt* video_table_get_duplicate_stmt (VideoTable* self, GFile* file, const gchar* md5) {
	sqlite3_stmt* result = NULL;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	gchar* sql = NULL;
	gchar* _tmp3_ = NULL;
	gboolean first = FALSE;
	GFile* _tmp4_ = NULL;
	const gchar* _tmp7_ = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	sqlite3_stmt* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint col = 0;
	GFile* _tmp18_ = NULL;
	const gchar* _tmp26_ = NULL;
#line 365 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 365 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = file;
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp1_ != NULL) {
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = TRUE;
#line 2808 "VideoTable.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp2_ = md5;
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 2815 "VideoTable.c"
	}
#line 366 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp0_, "file != null || md5 != null");
#line 368 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = g_strdup ("SELECT id FROM VideoTable WHERE");
#line 368 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	sql = _tmp3_;
#line 369 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	first = TRUE;
#line 371 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = file;
#line 371 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp4_ != NULL) {
#line 2829 "VideoTable.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 372 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp5_ = sql;
#line 372 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp6_ = g_strconcat (_tmp5_, " filename=?", NULL);
#line 372 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (sql);
#line 372 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		sql = _tmp6_;
#line 373 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		first = FALSE;
#line 2842 "VideoTable.c"
	}
#line 376 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = md5;
#line 376 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp7_ != NULL) {
#line 2848 "VideoTable.c"
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 377 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp8_ = first;
#line 377 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (!_tmp8_) {
#line 2856 "VideoTable.c"
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
#line 378 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp9_ = sql;
#line 378 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp10_ = g_strconcat (_tmp9_, " OR ", NULL);
#line 378 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_g_free0 (sql);
#line 378 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			sql = _tmp10_;
#line 2867 "VideoTable.c"
		}
#line 380 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp11_ = sql;
#line 380 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp12_ = g_strconcat (_tmp11_, " md5=?", NULL);
#line 380 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_g_free0 (sql);
#line 380 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		sql = _tmp12_;
#line 2877 "VideoTable.c"
	}
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = database_table_db;
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp14_ = sql;
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp16_ = sqlite3_prepare_v2 (_tmp13_, _tmp14_, -1, &_tmp15_, NULL);
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp15_;
#line 384 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp16_;
#line 385 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp17_ = res;
#line 385 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 387 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	col = 1;
#line 389 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp18_ = file;
#line 389 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp18_ != NULL) {
#line 2901 "VideoTable.c"
		sqlite3_stmt* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		GFile* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		GDestroyNotify _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp19_ = stmt;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp20_ = col;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		col = _tmp20_ + 1;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp21_ = file;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp22_ = g_file_get_path (_tmp21_);
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp23_ = g_free;
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp24_ = sqlite3_bind_text (_tmp19_, _tmp20_, _tmp22_, -1, _tmp23_);
#line 390 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		res = _tmp24_;
#line 391 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp25_ = res;
#line 391 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_vala_assert (_tmp25_ == SQLITE_OK, "res == Sqlite.OK");
#line 2929 "VideoTable.c"
	}
#line 394 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp26_ = md5;
#line 394 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp26_ != NULL) {
#line 2935 "VideoTable.c"
		sqlite3_stmt* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		GDestroyNotify _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp27_ = stmt;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp28_ = col;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		col = _tmp28_ + 1;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp29_ = md5;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp30_ = g_strdup (_tmp29_);
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp31_ = g_free;
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp32_ = sqlite3_bind_text (_tmp27_, _tmp28_, _tmp30_, -1, _tmp31_);
#line 395 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		res = _tmp32_;
#line 396 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp33_ = res;
#line 396 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_vala_assert (_tmp33_ == SQLITE_OK, "res == Sqlite.OK");
#line 2963 "VideoTable.c"
	}
#line 399 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = stmt;
#line 399 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_g_free0 (sql);
#line 399 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 2971 "VideoTable.c"
}


gboolean video_table_has_duplicate (VideoTable* self, GFile* file, const gchar* md5) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	GFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 402 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), FALSE);
#line 402 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 403 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = file;
#line 403 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = md5;
#line 403 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = video_table_get_duplicate_stmt (self, _tmp0_, _tmp1_);
#line 403 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp2_;
#line 404 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = stmt;
#line 404 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = sqlite3_step (_tmp3_);
#line 404 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp4_;
#line 406 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = res;
#line 406 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (_tmp5_ == SQLITE_DONE) {
#line 408 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		result = FALSE;
#line 408 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 408 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		return result;
#line 3013 "VideoTable.c"
	} else {
		gint _tmp6_ = 0;
#line 409 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp6_ = res;
#line 409 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_tmp6_ == SQLITE_ROW) {
#line 411 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			result = TRUE;
#line 411 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_sqlite3_finalize0 (stmt);
#line 411 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return result;
#line 3026 "VideoTable.c"
		} else {
			gint _tmp7_ = 0;
#line 413 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp7_ = res;
#line 413 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			database_table_fatal ("VideoTable.has_duplicate", _tmp7_);
#line 3033 "VideoTable.c"
		}
	}
#line 416 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = FALSE;
#line 416 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 416 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 3042 "VideoTable.c"
}


static void _vala_array_add3 (VideoID** array, int* length, int* size, const VideoID* value) {
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if ((*length) == (*size)) {
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*array = g_renew (VideoID, *array, *size);
#line 3053 "VideoTable.c"
	}
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	(*array)[(*length)++] = *value;
#line 3057 "VideoTable.c"
}


VideoID* video_table_get_duplicate_ids (VideoTable* self, GFile* file, const gchar* md5, int* result_length1) {
	VideoID* result = NULL;
	sqlite3_stmt* stmt = NULL;
	GFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	VideoID* ids = NULL;
	VideoID* _tmp3_ = NULL;
	gint ids_length1 = 0;
	gint _ids_size_ = 0;
	gint res = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	VideoID* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
#line 419 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 419 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 420 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = file;
#line 420 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = md5;
#line 420 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = video_table_get_duplicate_stmt (self, _tmp0_, _tmp1_);
#line 420 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp2_;
#line 422 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = g_new0 (VideoID, 0);
#line 422 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	ids = _tmp3_;
#line 422 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	ids_length1 = 0;
#line 422 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_ids_size_ = ids_length1;
#line 424 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 424 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = sqlite3_step (_tmp4_);
#line 424 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp5_;
#line 425 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	while (TRUE) {
#line 3104 "VideoTable.c"
		gint _tmp6_ = 0;
		VideoID* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		sqlite3_stmt* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		VideoID _tmp10_ = {0};
		sqlite3_stmt* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 425 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp6_ = res;
#line 425 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (!(_tmp6_ == SQLITE_ROW)) {
#line 425 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			break;
#line 3119 "VideoTable.c"
		}
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp7_ = ids;
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp7__length1 = ids_length1;
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp8_ = stmt;
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp9_ = sqlite3_column_int64 (_tmp8_, 0);
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		video_id_init (&_tmp10_, _tmp9_);
#line 426 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_vala_array_add3 (&ids, &ids_length1, &_ids_size_, &_tmp10_);
#line 427 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp11_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp12_ = sqlite3_step (_tmp11_);
#line 427 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		res = _tmp12_;
#line 3139 "VideoTable.c"
	}
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13_ = ids;
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp13__length1 = ids_length1;
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (result_length1) {
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		*result_length1 = _tmp13__length1;
#line 3149 "VideoTable.c"
	}
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _tmp13_;
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 430 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 3157 "VideoTable.c"
}


GeeArrayList* video_table_get_event_source_ids (VideoTable* self, EventID* event_id) {
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	EventID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
#line 433 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (IS_VIDEO_TABLE (self), NULL);
#line 433 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = database_table_db;
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM VideoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	stmt = _tmp1_;
#line 435 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp2_;
#line 436 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp3_ = res;
#line 436 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp4_ = stmt;
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp5_ = *event_id;
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 438 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	res = _tmp7_;
#line 439 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp8_ = res;
#line 439 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 441 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp9_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 441 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_result_ = _tmp9_;
#line 3212 "VideoTable.c"
	{
		gboolean _tmp10_ = FALSE;
#line 442 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		_tmp10_ = TRUE;
#line 442 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		while (TRUE) {
#line 3219 "VideoTable.c"
			sqlite3_stmt* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			GeeArrayList* _tmp16_ = NULL;
			sqlite3_stmt* _tmp17_ = NULL;
			gint64 _tmp18_ = 0LL;
			VideoID _tmp19_ = {0};
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (!_tmp10_) {
#line 3231 "VideoTable.c"
			}
#line 442 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp10_ = FALSE;
#line 443 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp11_ = stmt;
#line 443 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp12_ = sqlite3_step (_tmp11_);
#line 443 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			res = _tmp12_;
#line 444 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp13_ = res;
#line 444 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			if (_tmp13_ == SQLITE_DONE) {
#line 445 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				break;
#line 3247 "VideoTable.c"
			} else {
				gint _tmp14_ = 0;
#line 446 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				_tmp14_ = res;
#line 446 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
				if (_tmp14_ != SQLITE_ROW) {
#line 3254 "VideoTable.c"
					gint _tmp15_ = 0;
#line 447 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					_tmp15_ = res;
#line 447 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					database_table_fatal ("get_event_source_ids", _tmp15_);
#line 449 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
					break;
#line 3262 "VideoTable.c"
				}
			}
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp16_ = _result_;
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp17_ = stmt;
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp18_ = sqlite3_column_int64 (_tmp17_, 0);
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			video_id_init (&_tmp19_, _tmp18_);
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp20_ = video_id_upgrade_video_id_to_source_id (&_tmp19_);
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_tmp21_ = _tmp20_;
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
#line 452 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			_g_free0 (_tmp21_);
#line 3281 "VideoTable.c"
		}
	}
#line 455 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	result = _result_;
#line 455 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 455 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	return result;
#line 3290 "VideoTable.c"
}


void video_table_set_timestamp (VideoTable* self, VideoID* video_id, time_t timestamp, GError** error) {
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	time_t _tmp2_ = 0;
	GError * _inner_error_ = NULL;
#line 458 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (IS_VIDEO_TABLE (self));
#line 458 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	g_return_if_fail (video_id != NULL);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp0_ = *video_id;
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	_tmp2_ = timestamp;
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "timestamp", (gint64) _tmp2_, &_inner_error_);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 3319 "VideoTable.c"
		} else {
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			g_clear_error (&_inner_error_);
#line 459 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
			return;
#line 3327 "VideoTable.c"
		}
	}
}


static void video_table_class_init (VideoTableClass * klass) {
#line 59 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	video_table_parent_class = g_type_class_peek_parent (klass);
#line 59 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	((DatabaseTableClass *) klass)->finalize = video_table_finalize;
#line 3338 "VideoTable.c"
}


static void video_table_instance_init (VideoTable * self) {
}


static void video_table_finalize (DatabaseTable* obj) {
	VideoTable * self;
#line 59 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_TABLE, VideoTable);
#line 59 "/home/jens/Source/shotwell/src/db/VideoTable.vala"
	DATABASE_TABLE_CLASS (video_table_parent_class)->finalize (obj);
#line 3352 "VideoTable.c"
}


GType video_table_get_type (void) {
	static volatile gsize video_table_type_id__volatile = 0;
	if (g_once_init_enter (&video_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoTable), 0, (GInstanceInitFunc) video_table_instance_init, NULL };
		GType video_table_type_id;
		video_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "VideoTable", &g_define_type_info, 0);
		g_once_init_leave (&video_table_type_id__volatile, video_table_type_id);
	}
	return video_table_type_id__volatile;
}



