/* Exporter.c generated by valac 0.32.1, the Vala compiler
 * generated from Exporter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;
typedef struct _ExporterPrivate ExporterPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _Scaling Scaling;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define EXPORTER_TYPE_OVERWRITE (exporter_overwrite_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define EXPORTER_TYPE_EXPORT_JOB (exporter_export_job_get_type ())
#define EXPORTER_EXPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob))
#define EXPORTER_EXPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJobClass))
#define EXPORTER_IS_EXPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EXPORTER_TYPE_EXPORT_JOB))
#define EXPORTER_IS_EXPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EXPORTER_TYPE_EXPORT_JOB))
#define EXPORTER_EXPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EXPORTER_TYPE_EXPORT_JOB, ExporterExportJobClass))

typedef struct _ExporterExportJob ExporterExportJob;
typedef struct _ExporterExportJobClass ExporterExportJobClass;
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _ExporterExportJobPrivate ExporterExportJobPrivate;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scaling_free0(var) ((var == NULL) ? NULL : (var = (scaling_free (var), NULL)))

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;
typedef struct _ExporterUIPrivate ExporterUIPrivate;

#define TYPE_PROGRESS_DIALOG (progress_dialog_get_type ())
#define PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_DIALOG, ProgressDialog))
#define PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_DIALOG, ProgressDialogClass))
#define IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_DIALOG))
#define IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_DIALOG))
#define PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_DIALOG, ProgressDialogClass))

typedef struct _ProgressDialog ProgressDialog;
typedef struct _ProgressDialogClass ProgressDialogClass;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _ParamSpecExporterUI ParamSpecExporterUI;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

struct _Exporter {
	GObject parent_instance;
	ExporterPrivate * priv;
};

struct _ExporterClass {
	GObjectClass parent_class;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, void* user_data);
typedef gboolean (*ExporterExportFailedCallback) (Exporter* exporter, GFile* file, gint remaining, GError* err, void* user_data);
typedef enum  {
	EXPORTER_OVERWRITE_YES,
	EXPORTER_OVERWRITE_NO,
	EXPORTER_OVERWRITE_CANCEL,
	EXPORTER_OVERWRITE_REPLACE_ALL
} ExporterOverwrite;

typedef ExporterOverwrite (*ExporterOverwriteCallback) (Exporter* exporter, GFile* file, void* user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _ExporterPrivate {
	GeeCollection* to_export;
	GFile** exported_files;
	gint exported_files_length1;
	gint _exported_files_size_;
	GFile* dir;
	Scaling scaling;
	gint completed_count;
	Workers* workers;
	ExporterCompletionCallback completion_callback;
	gpointer completion_callback_target;
	ExporterExportFailedCallback error_callback;
	gpointer error_callback_target;
	ExporterOverwriteCallback overwrite_callback;
	gpointer overwrite_callback_target;
	ProgressMonitor monitor;
	gpointer monitor_target;
	GCancellable* cancellable;
	gboolean replace_all;
	gboolean aborted;
	ExportFormatParameters export_params;
};

typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _ExporterExportJob {
	BackgroundJob parent_instance;
	ExporterExportJobPrivate * priv;
	MediaSource* media;
	GFile* dest;
	Scaling* scaling;
	JpegQuality* quality;
	PhotoFileFormat* format;
	GError* err;
	gboolean direct_copy_unmodified;
	gboolean export_metadata;
};

struct _ExporterExportJobClass {
	BackgroundJobClass parent_class;
};

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);
struct _ExporterUI {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExporterUIPrivate * priv;
};

struct _ExporterUIClass {
	GTypeClass parent_class;
	void (*finalize) (ExporterUI *self);
};

struct _ExporterUIPrivate {
	Exporter* exporter;
	GCancellable* cancellable;
	ProgressDialog* progress_dialog;
	ExporterCompletionCallback completion_callback;
	gpointer completion_callback_target;
};

struct _ParamSpecExporterUI {
	GParamSpec parent_instance;
};


static gpointer exporter_parent_class = NULL;
static gpointer exporter_export_job_parent_class = NULL;
static gpointer exporter_ui_parent_class = NULL;

GType export_format_mode_get_type (void) G_GNUC_CONST;
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
static void export_format_parameters_init (ExportFormatParameters *self, ExportFormatMode mode, PhotoFileFormat specified_format, JpegQuality quality);
void export_format_parameters_current (ExportFormatParameters* result);
PhotoFileFormat photo_file_format_get_system_default_format (void);
void export_format_parameters_unmodified (ExportFormatParameters* result);
void export_format_parameters_for_format (PhotoFileFormat format, ExportFormatParameters* result);
void export_format_parameters_last (ExportFormatParameters* result);
void export_format_parameters_for_JPEG (JpegQuality quality, ExportFormatParameters* result);
GType exporter_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType exporter_overwrite_get_type (void) G_GNUC_CONST;
#define EXPORTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPORTER, ExporterPrivate))
enum  {
	EXPORTER_DUMMY_PROPERTY
};
guint workers_threads_per_cpu (gint per, gint max);
Workers* workers_new (guint max_threads, gboolean exclusive);
Workers* workers_construct (GType object_type, guint max_threads, gboolean exclusive);
Exporter* exporter_new (GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all);
Exporter* exporter_construct (GType object_type, GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all);
Exporter* exporter_new_for_temp_file (GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params);
Exporter* exporter_construct_for_temp_file (GType object_type, GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params);
void exporter_export (Exporter* self, ExporterCompletionCallback completion_callback, void* completion_callback_target, ExporterExportFailedCallback error_callback, void* error_callback_target, ExporterOverwriteCallback overwrite_callback, void* overwrite_callback_target, GCancellable* cancellable, ProgressMonitor monitor, void* monitor_target);
static gboolean exporter_process_queue (Exporter* self);
static void exporter_export_completed (Exporter* self, gboolean is_cancelled);
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background_job (GValue* value, gpointer v_object);
void value_take_background_job (GValue* value, gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
static void exporter_on_exported (Exporter* self, BackgroundJob* j);
static GType exporter_export_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
static void _vala_array_add294 (GFile*** array, int* length, int* size, GFile* value);
static void exporter_on_export_cancelled (Exporter* self, BackgroundJob* j);
GFile** exporter_get_exported_files (Exporter* self, int* result_length1);
static GFile** _vala_array_dup31 (GFile** self, int length);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_get_export_format_for_parameters (Photo* self, ExportFormatParameters* params);
gchar* photo_get_export_basename_for_parameters (Photo* self, ExportFormatParameters* params);
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
gchar* media_source_get_basename (MediaSource* self);
static void _vala_array_add295 (GFile*** array, int* length, int* size, GFile* value);
GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error);
GFile* app_dirs_get_temp_dir (void);
void app_window_error_message (const gchar* message, GtkWindow* parent);
GFile* media_source_get_file (MediaSource* self);
void workers_enqueue (Workers* self, BackgroundJob* job);
static ExporterExportJob* exporter_export_job_new (Exporter* owner, MediaSource* media, GFile* dest, Scaling* scaling, JpegQuality* quality, PhotoFileFormat* format, GCancellable* cancellable, gboolean direct_copy_unmodified, gboolean export_metadata);
static ExporterExportJob* exporter_export_job_construct (GType object_type, Exporter* owner, MediaSource* media, GFile* dest, Scaling* scaling, JpegQuality* quality, PhotoFileFormat* format, GCancellable* cancellable, gboolean direct_copy_unmodified, gboolean export_metadata);
enum  {
	EXPORTER_EXPORT_JOB_DUMMY_PROPERTY
};
static void _exporter_on_exported_completion_callback (BackgroundJob* job, gpointer self);
static void _exporter_on_export_cancelled_cancellation_callback (BackgroundJob* job, gpointer self);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_abstract_semaphore (GValue* value, gpointer v_object);
void value_take_abstract_semaphore (GValue* value, gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type, GObject* owner, CompletionCallback callback, void* callback_target, GCancellable* cancellable, CancellationCallback cancellation, void* cancellation_target, AbstractSemaphore* completion_semaphore);
static JpegQuality* _jpeg_quality_dup (JpegQuality* self);
static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self);
static void exporter_export_job_real_execute (BackgroundJob* base);
void photo_export (Photo* self, GFile* dest_file, Scaling* scaling, JpegQuality quality, PhotoFileFormat export_format, gboolean direct_copy_unmodified, gboolean export_metadata, GError** error);
void video_export (Video* self, GFile* dest_file, GError** error);
static void exporter_export_job_finalize (BackgroundJob* obj);
static void exporter_finalize (GObject* obj);
gpointer exporter_ui_ref (gpointer instance);
void exporter_ui_unref (gpointer instance);
GParamSpec* param_spec_exporter_ui (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_exporter_ui (GValue* value, gpointer v_object);
void value_take_exporter_ui (GValue* value, gpointer v_object);
gpointer value_get_exporter_ui (const GValue* value);
GType exporter_ui_get_type (void) G_GNUC_CONST;
GType progress_dialog_get_type (void) G_GNUC_CONST;
#define EXPORTER_UI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPORTER_UI, ExporterUIPrivate))
enum  {
	EXPORTER_UI_DUMMY_PROPERTY
};
ExporterUI* exporter_ui_new (Exporter* exporter);
ExporterUI* exporter_ui_construct (GType object_type, Exporter* exporter);
void exporter_ui_export (ExporterUI* self, ExporterCompletionCallback completion_callback, void* completion_callback_target);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
ProgressDialog* progress_dialog_new (GtkWindow* owner, const gchar* text, GCancellable* cancellable);
ProgressDialog* progress_dialog_construct (GType object_type, GtkWindow* owner, const gchar* text, GCancellable* cancellable);
static void exporter_ui_on_export_completed (ExporterUI* self, Exporter* exporter, gboolean is_cancelled);
static void _exporter_ui_on_export_completed_exporter_completion_callback (Exporter* exporter, gboolean is_cancelled, gpointer self);
static gboolean exporter_ui_on_export_failed (ExporterUI* self, Exporter* exporter, GFile* file, gint remaining, GError* err);
static gboolean _exporter_ui_on_export_failed_exporter_export_failed_callback (Exporter* exporter, GFile* file, gint remaining, GError* err, gpointer self);
static ExporterOverwrite exporter_ui_on_export_overwrite (ExporterUI* self, Exporter* exporter, GFile* file);
static ExporterOverwrite _exporter_ui_on_export_overwrite_exporter_overwrite_callback (Exporter* exporter, GFile* file, gpointer self);
gboolean progress_dialog_monitor (ProgressDialog* self, guint64 count, guint64 total, gboolean do_event_loop);
static gboolean _progress_dialog_monitor_progress_monitor (guint64 current, guint64 total, gboolean do_event_loop, gpointer self);
void progress_dialog_close (ProgressDialog* self);
void page_window_set_normal_cursor (PageWindow* self);
GtkResponseType app_window_negate_affirm_all_cancel_question (const gchar* message, const gchar* negative, const gchar* affirmative, const gchar* affirmative_all, const gchar* title, GtkWindow* parent);
GtkResponseType export_error_dialog (GFile* dest, gboolean photos_remaining);
static void exporter_ui_finalize (ExporterUI* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType export_format_mode_get_type (void) {
	static volatile gsize export_format_mode_type_id__volatile = 0;
	if (g_once_init_enter (&export_format_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{EXPORT_FORMAT_MODE_UNMODIFIED, "EXPORT_FORMAT_MODE_UNMODIFIED", "unmodified"}, {EXPORT_FORMAT_MODE_CURRENT, "EXPORT_FORMAT_MODE_CURRENT", "current"}, {EXPORT_FORMAT_MODE_SPECIFIED, "EXPORT_FORMAT_MODE_SPECIFIED", "specified"}, {EXPORT_FORMAT_MODE_LAST, "EXPORT_FORMAT_MODE_LAST", "last"}, {0, NULL, NULL}};
		GType export_format_mode_type_id;
		export_format_mode_type_id = g_enum_register_static ("ExportFormatMode", values);
		g_once_init_leave (&export_format_mode_type_id__volatile, export_format_mode_type_id);
	}
	return export_format_mode_type_id__volatile;
}


static void export_format_parameters_init (ExportFormatParameters *self, ExportFormatMode mode, PhotoFileFormat specified_format, JpegQuality quality) {
	ExportFormatMode _tmp0_ = 0;
	PhotoFileFormat _tmp1_ = 0;
	JpegQuality _tmp2_ = 0;
#line 20 "/home/jens/Source/shotwell/src/Exporter.vala"
	memset (self, 0, sizeof (ExportFormatParameters));
#line 22 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = mode;
#line 22 "/home/jens/Source/shotwell/src/Exporter.vala"
	(*self).mode = _tmp0_;
#line 23 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = specified_format;
#line 23 "/home/jens/Source/shotwell/src/Exporter.vala"
	(*self).specified_format = _tmp1_;
#line 24 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = quality;
#line 24 "/home/jens/Source/shotwell/src/Exporter.vala"
	(*self).quality = _tmp2_;
#line 25 "/home/jens/Source/shotwell/src/Exporter.vala"
	(*self).export_metadata = TRUE;
#line 555 "Exporter.c"
}


void export_format_parameters_current (ExportFormatParameters* result) {
	PhotoFileFormat _tmp0_ = 0;
	ExportFormatParameters _tmp1_ = {0};
#line 29 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = photo_file_format_get_system_default_format ();
#line 29 "/home/jens/Source/shotwell/src/Exporter.vala"
	export_format_parameters_init (&_tmp1_, EXPORT_FORMAT_MODE_CURRENT, _tmp0_, JPEG_QUALITY_HIGH);
#line 29 "/home/jens/Source/shotwell/src/Exporter.vala"
	*result = _tmp1_;
#line 29 "/home/jens/Source/shotwell/src/Exporter.vala"
	return;
#line 570 "Exporter.c"
}


void export_format_parameters_unmodified (ExportFormatParameters* result) {
	PhotoFileFormat _tmp0_ = 0;
	ExportFormatParameters _tmp1_ = {0};
#line 34 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = photo_file_format_get_system_default_format ();
#line 34 "/home/jens/Source/shotwell/src/Exporter.vala"
	export_format_parameters_init (&_tmp1_, EXPORT_FORMAT_MODE_UNMODIFIED, _tmp0_, JPEG_QUALITY_HIGH);
#line 34 "/home/jens/Source/shotwell/src/Exporter.vala"
	*result = _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/Exporter.vala"
	return;
#line 585 "Exporter.c"
}


void export_format_parameters_for_format (PhotoFileFormat format, ExportFormatParameters* result) {
	PhotoFileFormat _tmp0_ = 0;
	ExportFormatParameters _tmp1_ = {0};
#line 39 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = format;
#line 39 "/home/jens/Source/shotwell/src/Exporter.vala"
	export_format_parameters_init (&_tmp1_, EXPORT_FORMAT_MODE_SPECIFIED, _tmp0_, JPEG_QUALITY_HIGH);
#line 39 "/home/jens/Source/shotwell/src/Exporter.vala"
	*result = _tmp1_;
#line 39 "/home/jens/Source/shotwell/src/Exporter.vala"
	return;
#line 600 "Exporter.c"
}


void export_format_parameters_last (ExportFormatParameters* result) {
	PhotoFileFormat _tmp0_ = 0;
	ExportFormatParameters _tmp1_ = {0};
#line 43 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = photo_file_format_get_system_default_format ();
#line 43 "/home/jens/Source/shotwell/src/Exporter.vala"
	export_format_parameters_init (&_tmp1_, EXPORT_FORMAT_MODE_LAST, _tmp0_, JPEG_QUALITY_HIGH);
#line 43 "/home/jens/Source/shotwell/src/Exporter.vala"
	*result = _tmp1_;
#line 43 "/home/jens/Source/shotwell/src/Exporter.vala"
	return;
#line 615 "Exporter.c"
}


void export_format_parameters_for_JPEG (JpegQuality quality, ExportFormatParameters* result) {
	JpegQuality _tmp0_ = 0;
	ExportFormatParameters _tmp1_ = {0};
#line 48 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = quality;
#line 48 "/home/jens/Source/shotwell/src/Exporter.vala"
	export_format_parameters_init (&_tmp1_, EXPORT_FORMAT_MODE_SPECIFIED, PHOTO_FILE_FORMAT_JFIF, _tmp0_);
#line 48 "/home/jens/Source/shotwell/src/Exporter.vala"
	*result = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/Exporter.vala"
	return;
#line 630 "Exporter.c"
}


ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self) {
	ExportFormatParameters* dup;
#line 14 "/home/jens/Source/shotwell/src/Exporter.vala"
	dup = g_new0 (ExportFormatParameters, 1);
#line 14 "/home/jens/Source/shotwell/src/Exporter.vala"
	memcpy (dup, self, sizeof (ExportFormatParameters));
#line 14 "/home/jens/Source/shotwell/src/Exporter.vala"
	return dup;
#line 642 "Exporter.c"
}


void export_format_parameters_free (ExportFormatParameters* self) {
#line 14 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_free (self);
#line 649 "Exporter.c"
}


GType export_format_parameters_get_type (void) {
	static volatile gsize export_format_parameters_type_id__volatile = 0;
	if (g_once_init_enter (&export_format_parameters_type_id__volatile)) {
		GType export_format_parameters_type_id;
		export_format_parameters_type_id = g_boxed_type_register_static ("ExportFormatParameters", (GBoxedCopyFunc) export_format_parameters_dup, (GBoxedFreeFunc) export_format_parameters_free);
		g_once_init_leave (&export_format_parameters_type_id__volatile, export_format_parameters_type_id);
	}
	return export_format_parameters_type_id__volatile;
}


GType exporter_overwrite_get_type (void) {
	static volatile gsize exporter_overwrite_type_id__volatile = 0;
	if (g_once_init_enter (&exporter_overwrite_type_id__volatile)) {
		static const GEnumValue values[] = {{EXPORTER_OVERWRITE_YES, "EXPORTER_OVERWRITE_YES", "yes"}, {EXPORTER_OVERWRITE_NO, "EXPORTER_OVERWRITE_NO", "no"}, {EXPORTER_OVERWRITE_CANCEL, "EXPORTER_OVERWRITE_CANCEL", "cancel"}, {EXPORTER_OVERWRITE_REPLACE_ALL, "EXPORTER_OVERWRITE_REPLACE_ALL", "replace-all"}, {0, NULL, NULL}};
		GType exporter_overwrite_type_id;
		exporter_overwrite_type_id = g_enum_register_static ("ExporterOverwrite", values);
		g_once_init_leave (&exporter_overwrite_type_id__volatile, exporter_overwrite_type_id);
	}
	return exporter_overwrite_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 125 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self ? g_object_ref (self) : NULL;
#line 679 "Exporter.c"
}


Exporter* exporter_construct (GType object_type, GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all) {
	Exporter * self = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	Scaling _tmp4_ = {0};
	ExportFormatParameters _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
#line 122 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (to_export), NULL);
#line 122 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail ((dir == NULL) || G_IS_FILE (dir), NULL);
#line 122 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 122 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (export_params != NULL, NULL);
#line 122 "/home/jens/Source/shotwell/src/Exporter.vala"
	self = (Exporter*) g_object_new (object_type, NULL);
#line 124 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = self->priv->to_export;
#line 124 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = to_export;
#line 124 "/home/jens/Source/shotwell/src/Exporter.vala"
	gee_collection_add_all (_tmp0_, _tmp1_);
#line 125 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = dir;
#line 125 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 125 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->dir);
#line 125 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->dir = _tmp3_;
#line 126 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ = *scaling;
#line 126 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->scaling = _tmp4_;
#line 127 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp5_ = *export_params;
#line 127 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->export_params = _tmp5_;
#line 128 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp6_ = auto_replace_all;
#line 128 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->replace_all = _tmp6_;
#line 122 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self;
#line 730 "Exporter.c"
}


Exporter* exporter_new (GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all) {
#line 122 "/home/jens/Source/shotwell/src/Exporter.vala"
	return exporter_construct (TYPE_EXPORTER, to_export, dir, scaling, export_params, auto_replace_all);
#line 737 "Exporter.c"
}


Exporter* exporter_construct_for_temp_file (GType object_type, GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params) {
	Exporter * self = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	Scaling _tmp2_ = {0};
	ExportFormatParameters _tmp3_ = {0};
#line 131 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (to_export), NULL);
#line 131 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 131 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (export_params != NULL, NULL);
#line 131 "/home/jens/Source/shotwell/src/Exporter.vala"
	self = (Exporter*) g_object_new (object_type, NULL);
#line 133 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = self->priv->to_export;
#line 133 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = to_export;
#line 133 "/home/jens/Source/shotwell/src/Exporter.vala"
	gee_collection_add_all (_tmp0_, _tmp1_);
#line 134 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->dir);
#line 134 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->dir = NULL;
#line 135 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = *scaling;
#line 135 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->scaling = _tmp2_;
#line 136 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = *export_params;
#line 136 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->export_params = _tmp3_;
#line 131 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self;
#line 775 "Exporter.c"
}


Exporter* exporter_new_for_temp_file (GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params) {
#line 131 "/home/jens/Source/shotwell/src/Exporter.vala"
	return exporter_construct_for_temp_file (TYPE_EXPORTER, to_export, scaling, export_params);
#line 782 "Exporter.c"
}


void exporter_export (Exporter* self, ExporterCompletionCallback completion_callback, void* completion_callback_target, ExporterExportFailedCallback error_callback, void* error_callback_target, ExporterOverwriteCallback overwrite_callback, void* overwrite_callback_target, GCancellable* cancellable, ProgressMonitor monitor, void* monitor_target) {
	ExporterCompletionCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	ExporterExportFailedCallback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	ExporterOverwriteCallback _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	ProgressMonitor _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	GCancellable* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	GCancellable* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
#line 140 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_EXPORTER (self));
#line 140 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 142 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = completion_callback;
#line 142 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0__target = completion_callback_target;
#line 142 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completion_callback = _tmp0_;
#line 142 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completion_callback_target = _tmp0__target;
#line 143 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = error_callback;
#line 143 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1__target = error_callback_target;
#line 143 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->error_callback = _tmp1_;
#line 143 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->error_callback_target = _tmp1__target;
#line 144 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = overwrite_callback;
#line 144 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2__target = overwrite_callback_target;
#line 144 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->overwrite_callback = _tmp2_;
#line 144 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->overwrite_callback_target = _tmp2__target;
#line 145 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = monitor;
#line 145 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3__target = monitor_target;
#line 145 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->monitor = _tmp3_;
#line 145 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->monitor_target = _tmp3__target;
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp5_ = cancellable;
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ = _tmp6_;
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (_tmp4_ == NULL) {
#line 844 "Exporter.c"
		GCancellable* _tmp7_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp7_ = g_cancellable_new ();
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
		_g_object_unref0 (_tmp4_);
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp4_ = _tmp7_;
#line 852 "Exporter.c"
	}
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp8_ = _tmp4_;
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 146 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->cancellable = _tmp8_;
#line 148 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp9_ = exporter_process_queue (self);
#line 148 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (!_tmp9_) {
#line 149 "/home/jens/Source/shotwell/src/Exporter.vala"
		exporter_export_completed (self, TRUE);
#line 868 "Exporter.c"
	}
#line 140 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (_tmp4_);
#line 872 "Exporter.c"
}


static gpointer _background_job_ref0 (gpointer self) {
#line 153 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self ? background_job_ref (self) : NULL;
#line 879 "Exporter.c"
}


static void _vala_array_add294 (GFile*** array, int* length, int* size, GFile* value) {
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
	if ((*length) == (*size)) {
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 890 "Exporter.c"
	}
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
	(*array)[(*length)++] = value;
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
	(*array)[*length] = NULL;
#line 896 "Exporter.c"
}


static void exporter_on_exported (Exporter* self, BackgroundJob* j) {
	ExporterExportJob* job = NULL;
	BackgroundJob* _tmp0_ = NULL;
	ExporterExportJob* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean completed = FALSE;
	gint _tmp3_ = 0;
	GeeCollection* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp36_ = FALSE;
#line 152 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_EXPORTER (self));
#line 152 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 153 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = j;
#line 153 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob));
#line 153 "/home/jens/Source/shotwell/src/Exporter.vala"
	job = _tmp1_;
#line 155 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = self->priv->completed_count;
#line 155 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completed_count = _tmp2_ + 1;
#line 159 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = self->priv->completed_count;
#line 159 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ = self->priv->to_export;
#line 159 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp5_ = gee_collection_get_size (_tmp4_);
#line 159 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp6_ = _tmp5_;
#line 159 "/home/jens/Source/shotwell/src/Exporter.vala"
	completed = _tmp3_ == _tmp6_;
#line 161 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp8_ = self->priv->aborted;
#line 161 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (!_tmp8_) {
#line 943 "Exporter.c"
		ExporterExportJob* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
#line 161 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp9_ = job;
#line 161 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp10_ = _tmp9_->err;
#line 161 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp7_ = _tmp10_ != NULL;
#line 952 "Exporter.c"
	} else {
#line 161 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp7_ = FALSE;
#line 956 "Exporter.c"
	}
#line 161 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (_tmp7_) {
#line 960 "Exporter.c"
		ExporterExportFailedCallback _tmp11_ = NULL;
		void* _tmp11__target = NULL;
		ExporterExportJob* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GeeCollection* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		ExporterExportJob* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp11_ = self->priv->error_callback;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp11__target = self->priv->error_callback_target;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp12_ = job;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp13_ = _tmp12_->dest;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp14_ = self->priv->to_export;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp15_ = gee_collection_get_size (_tmp14_);
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp16_ = _tmp15_;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp17_ = self->priv->completed_count;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp18_ = job;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp19_ = _tmp18_->err;
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp20_ = _tmp11_ (self, _tmp13_, _tmp16_ - _tmp17_, _tmp19_, _tmp11__target);
#line 162 "/home/jens/Source/shotwell/src/Exporter.vala"
		if (!_tmp20_) {
#line 996 "Exporter.c"
			gboolean _tmp21_ = FALSE;
#line 163 "/home/jens/Source/shotwell/src/Exporter.vala"
			self->priv->aborted = TRUE;
#line 165 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp21_ = completed;
#line 165 "/home/jens/Source/shotwell/src/Exporter.vala"
			if (!_tmp21_) {
#line 166 "/home/jens/Source/shotwell/src/Exporter.vala"
				_background_job_unref0 (job);
#line 166 "/home/jens/Source/shotwell/src/Exporter.vala"
				return;
#line 1008 "Exporter.c"
			}
		}
	}
#line 170 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp23_ = self->priv->aborted;
#line 170 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (!_tmp23_) {
#line 1016 "Exporter.c"
		ProgressMonitor _tmp24_ = NULL;
		void* _tmp24__target = NULL;
#line 170 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp24_ = self->priv->monitor;
#line 170 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp24__target = self->priv->monitor_target;
#line 170 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp22_ = _tmp24_ != NULL;
#line 1025 "Exporter.c"
	} else {
#line 170 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp22_ = FALSE;
#line 1029 "Exporter.c"
	}
#line 170 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (_tmp22_) {
#line 1033 "Exporter.c"
		ProgressMonitor _tmp25_ = NULL;
		void* _tmp25__target = NULL;
		gint _tmp26_ = 0;
		GeeCollection* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gboolean _tmp30_ = FALSE;
#line 171 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp25_ = self->priv->monitor;
#line 171 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp25__target = self->priv->monitor_target;
#line 171 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp26_ = self->priv->completed_count;
#line 171 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp27_ = self->priv->to_export;
#line 171 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp28_ = gee_collection_get_size (_tmp27_);
#line 171 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp29_ = _tmp28_;
#line 171 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp30_ = _tmp25_ ((guint64) _tmp26_, (guint64) _tmp29_, FALSE, _tmp25__target);
#line 171 "/home/jens/Source/shotwell/src/Exporter.vala"
		if (!_tmp30_) {
#line 1057 "Exporter.c"
			gboolean _tmp31_ = FALSE;
#line 172 "/home/jens/Source/shotwell/src/Exporter.vala"
			self->priv->aborted = TRUE;
#line 174 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp31_ = completed;
#line 174 "/home/jens/Source/shotwell/src/Exporter.vala"
			if (!_tmp31_) {
#line 175 "/home/jens/Source/shotwell/src/Exporter.vala"
				_background_job_unref0 (job);
#line 175 "/home/jens/Source/shotwell/src/Exporter.vala"
				return;
#line 1069 "Exporter.c"
			}
		} else {
			GFile** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			ExporterExportJob* _tmp33_ = NULL;
			GFile* _tmp34_ = NULL;
			GFile* _tmp35_ = NULL;
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp32_ = self->priv->exported_files;
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp32__length1 = self->priv->exported_files_length1;
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp33_ = job;
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp34_ = _tmp33_->dest;
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp35_ = _g_object_ref0 (_tmp34_);
#line 177 "/home/jens/Source/shotwell/src/Exporter.vala"
			_vala_array_add294 (&self->priv->exported_files, &self->priv->exported_files_length1, &self->priv->_exported_files_size_, _tmp35_);
#line 1089 "Exporter.c"
		}
	}
#line 181 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp36_ = completed;
#line 181 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (_tmp36_) {
#line 182 "/home/jens/Source/shotwell/src/Exporter.vala"
		exporter_export_completed (self, FALSE);
#line 1098 "Exporter.c"
	}
#line 152 "/home/jens/Source/shotwell/src/Exporter.vala"
	_background_job_unref0 (job);
#line 1102 "Exporter.c"
}


static void exporter_on_export_cancelled (Exporter* self, BackgroundJob* j) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GeeCollection* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 185 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_EXPORTER (self));
#line 185 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (j));
#line 186 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = self->priv->completed_count;
#line 186 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completed_count = _tmp0_ + 1;
#line 186 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = self->priv->completed_count;
#line 186 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = self->priv->to_export;
#line 186 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = gee_collection_get_size (_tmp2_);
#line 186 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ = _tmp3_;
#line 186 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (_tmp1_ == _tmp4_) {
#line 187 "/home/jens/Source/shotwell/src/Exporter.vala"
		exporter_export_completed (self, TRUE);
#line 1132 "Exporter.c"
	}
}


static GFile** _vala_array_dup31 (GFile** self, int length) {
	GFile** result;
	int i;
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	result = g_new0 (GFile*, length + 1);
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	for (i = 0; i < length; i++) {
#line 1144 "Exporter.c"
		GFile* _tmp0_ = NULL;
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
		result[i] = _tmp0_;
#line 1150 "Exporter.c"
	}
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	return result;
#line 1154 "Exporter.c"
}


GFile** exporter_get_exported_files (Exporter* self, int* result_length1) {
	GFile** result = NULL;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GFile** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GFile** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 190 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_EXPORTER (self), NULL);
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = self->priv->exported_files;
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0__length1 = self->priv->exported_files_length1;
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup31 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1__length1 = _tmp0__length1;
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = _tmp1_;
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2__length1 = _tmp1__length1;
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (result_length1) {
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
		*result_length1 = _tmp2__length1;
#line 1184 "Exporter.c"
	}
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	result = _tmp2_;
#line 191 "/home/jens/Source/shotwell/src/Exporter.vala"
	return result;
#line 1190 "Exporter.c"
}


static void _vala_array_add295 (GFile*** array, int* length, int* size, GFile* value) {
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
	if ((*length) == (*size)) {
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 1201 "Exporter.c"
	}
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
	(*array)[(*length)++] = value;
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
	(*array)[*length] = NULL;
#line 1207 "Exporter.c"
}


static gboolean exporter_process_queue (Exporter* self) {
	gboolean result = FALSE;
	gint submitted = 0;
	gint _tmp89_ = 0;
	GError * _inner_error_ = NULL;
#line 194 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_EXPORTER (self), FALSE);
#line 195 "/home/jens/Source/shotwell/src/Exporter.vala"
	submitted = 0;
#line 1220 "Exporter.c"
	{
		GeeIterator* _source_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp0_ = self->priv->to_export;
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
		_source_it = _tmp1_;
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
		while (TRUE) {
#line 1233 "Exporter.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			MediaSource* source = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			GFile* use_source_file = NULL;
			PhotoFileFormat real_export_format = 0;
			PhotoFileFormat _tmp6_ = 0;
			gchar* basename = NULL;
			MediaSource* _tmp7_ = NULL;
			const gchar* _tmp19_ = NULL;
			GFile* _tmp20_ = NULL;
			GFile* export_dir = NULL;
			GFile* _tmp33_ = NULL;
			GFile* _tmp34_ = NULL;
			GFile* dest = NULL;
			GFile* _tmp35_ = NULL;
			Workers* _tmp74_ = NULL;
			MediaSource* _tmp75_ = NULL;
			GFile* _tmp76_ = NULL;
			Scaling _tmp77_ = {0};
			ExportFormatParameters _tmp78_ = {0};
			JpegQuality _tmp79_ = 0;
			PhotoFileFormat _tmp80_ = 0;
			GCancellable* _tmp81_ = NULL;
			ExportFormatParameters _tmp82_ = {0};
			ExportFormatMode _tmp83_ = 0;
			ExportFormatParameters _tmp84_ = {0};
			gboolean _tmp85_ = FALSE;
			ExporterExportJob* _tmp86_ = NULL;
			ExporterExportJob* _tmp87_ = NULL;
			gint _tmp88_ = 0;
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp2_ = _source_it;
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			if (!_tmp3_) {
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
				break;
#line 1274 "Exporter.c"
			}
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp4_ = _source_it;
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			source = (MediaSource*) _tmp5_;
#line 197 "/home/jens/Source/shotwell/src/Exporter.vala"
			use_source_file = NULL;
#line 198 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp6_ = photo_file_format_get_system_default_format ();
#line 198 "/home/jens/Source/shotwell/src/Exporter.vala"
			real_export_format = _tmp6_;
#line 199 "/home/jens/Source/shotwell/src/Exporter.vala"
			basename = NULL;
#line 200 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp7_ = source;
#line 200 "/home/jens/Source/shotwell/src/Exporter.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_PHOTO)) {
#line 1294 "Exporter.c"
				Photo* photo = NULL;
				MediaSource* _tmp8_ = NULL;
				Photo* _tmp9_ = NULL;
				Photo* _tmp10_ = NULL;
				ExportFormatParameters _tmp11_ = {0};
				PhotoFileFormat _tmp12_ = 0;
				Photo* _tmp13_ = NULL;
				ExportFormatParameters _tmp14_ = {0};
				gchar* _tmp15_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp8_ = source;
#line 201 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO, Photo));
#line 201 "/home/jens/Source/shotwell/src/Exporter.vala"
				photo = _tmp9_;
#line 202 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp10_ = photo;
#line 202 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp11_ = self->priv->export_params;
#line 202 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp12_ = photo_get_export_format_for_parameters (_tmp10_, &_tmp11_);
#line 202 "/home/jens/Source/shotwell/src/Exporter.vala"
				real_export_format = _tmp12_;
#line 203 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp13_ = photo;
#line 203 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp14_ = self->priv->export_params;
#line 203 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp15_ = photo_get_export_basename_for_parameters (_tmp13_, &_tmp14_);
#line 203 "/home/jens/Source/shotwell/src/Exporter.vala"
				_g_free0 (basename);
#line 203 "/home/jens/Source/shotwell/src/Exporter.vala"
				basename = _tmp15_;
#line 200 "/home/jens/Source/shotwell/src/Exporter.vala"
				_g_object_unref0 (photo);
#line 1330 "Exporter.c"
			} else {
				MediaSource* _tmp16_ = NULL;
#line 204 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp16_ = source;
#line 204 "/home/jens/Source/shotwell/src/Exporter.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_VIDEO)) {
#line 1337 "Exporter.c"
					MediaSource* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
#line 205 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp17_ = source;
#line 205 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp18_ = media_source_get_basename (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
#line 205 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_free0 (basename);
#line 205 "/home/jens/Source/shotwell/src/Exporter.vala"
					basename = _tmp18_;
#line 1348 "Exporter.c"
				}
			}
#line 207 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp19_ = basename;
#line 207 "/home/jens/Source/shotwell/src/Exporter.vala"
			_vala_assert (_tmp19_ != NULL, "basename != null");
#line 209 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp20_ = use_source_file;
#line 209 "/home/jens/Source/shotwell/src/Exporter.vala"
			if (_tmp20_ != NULL) {
#line 1359 "Exporter.c"
				GFile** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				GFile* _tmp22_ = NULL;
				GFile* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				ProgressMonitor _tmp25_ = NULL;
				void* _tmp25__target = NULL;
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp21_ = self->priv->exported_files;
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp21__length1 = self->priv->exported_files_length1;
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp22_ = use_source_file;
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp23_ = _g_object_ref0 (_tmp22_);
#line 210 "/home/jens/Source/shotwell/src/Exporter.vala"
				_vala_array_add295 (&self->priv->exported_files, &self->priv->exported_files_length1, &self->priv->_exported_files_size_, _tmp23_);
#line 212 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp24_ = self->priv->completed_count;
#line 212 "/home/jens/Source/shotwell/src/Exporter.vala"
				self->priv->completed_count = _tmp24_ + 1;
#line 213 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp25_ = self->priv->monitor;
#line 213 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp25__target = self->priv->monitor_target;
#line 213 "/home/jens/Source/shotwell/src/Exporter.vala"
				if (_tmp25_ != NULL) {
#line 1387 "Exporter.c"
					ProgressMonitor _tmp26_ = NULL;
					void* _tmp26__target = NULL;
					gint _tmp27_ = 0;
					GeeCollection* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gboolean _tmp31_ = FALSE;
#line 214 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp26_ = self->priv->monitor;
#line 214 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp26__target = self->priv->monitor_target;
#line 214 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp27_ = self->priv->completed_count;
#line 214 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp28_ = self->priv->to_export;
#line 214 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp29_ = gee_collection_get_size (_tmp28_);
#line 214 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp30_ = _tmp29_;
#line 214 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp31_ = _tmp26_ ((guint64) _tmp27_, (guint64) _tmp30_, TRUE, _tmp26__target);
#line 214 "/home/jens/Source/shotwell/src/Exporter.vala"
					if (!_tmp31_) {
#line 1411 "Exporter.c"
						GCancellable* _tmp32_ = NULL;
#line 215 "/home/jens/Source/shotwell/src/Exporter.vala"
						_tmp32_ = self->priv->cancellable;
#line 215 "/home/jens/Source/shotwell/src/Exporter.vala"
						g_cancellable_cancel (_tmp32_);
#line 217 "/home/jens/Source/shotwell/src/Exporter.vala"
						result = FALSE;
#line 217 "/home/jens/Source/shotwell/src/Exporter.vala"
						_g_free0 (basename);
#line 217 "/home/jens/Source/shotwell/src/Exporter.vala"
						_g_object_unref0 (use_source_file);
#line 217 "/home/jens/Source/shotwell/src/Exporter.vala"
						_g_object_unref0 (source);
#line 217 "/home/jens/Source/shotwell/src/Exporter.vala"
						_g_object_unref0 (_source_it);
#line 217 "/home/jens/Source/shotwell/src/Exporter.vala"
						return result;
#line 1429 "Exporter.c"
					}
				}
#line 221 "/home/jens/Source/shotwell/src/Exporter.vala"
				_g_free0 (basename);
#line 221 "/home/jens/Source/shotwell/src/Exporter.vala"
				_g_object_unref0 (use_source_file);
#line 221 "/home/jens/Source/shotwell/src/Exporter.vala"
				_g_object_unref0 (source);
#line 221 "/home/jens/Source/shotwell/src/Exporter.vala"
				continue;
#line 1440 "Exporter.c"
			}
#line 224 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp33_ = self->priv->dir;
#line 224 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp34_ = _g_object_ref0 (_tmp33_);
#line 224 "/home/jens/Source/shotwell/src/Exporter.vala"
			export_dir = _tmp34_;
#line 225 "/home/jens/Source/shotwell/src/Exporter.vala"
			dest = NULL;
#line 227 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp35_ = export_dir;
#line 227 "/home/jens/Source/shotwell/src/Exporter.vala"
			if (_tmp35_ == NULL) {
#line 1454 "Exporter.c"
				{
					gboolean collision = FALSE;
					GFile* _tmp36_ = NULL;
					GFile* _tmp37_ = NULL;
					GFile* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
					gboolean _tmp40_ = FALSE;
					GFile* _tmp41_ = NULL;
					GFile* _tmp42_ = NULL;
					GFile* _tmp43_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp37_ = app_dirs_get_temp_dir ();
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp38_ = _tmp37_;
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp39_ = basename;
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp41_ = generate_unique_file (_tmp38_, _tmp39_, &_tmp40_, &_inner_error_);
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					collision = _tmp40_;
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp42_ = _tmp41_;
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (_tmp38_);
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp36_ = _tmp42_;
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1483 "Exporter.c"
						goto __catch467_g_error;
					}
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp43_ = _tmp36_;
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp36_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (dest);
#line 230 "/home/jens/Source/shotwell/src/Exporter.vala"
					dest = _tmp43_;
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (_tmp36_);
#line 1496 "Exporter.c"
				}
				goto __finally467;
				__catch467_g_error:
				{
					GError* err = NULL;
					const gchar* _tmp44_ = NULL;
					MediaSource* _tmp45_ = NULL;
					GFile* _tmp46_ = NULL;
					GFile* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					GError* _tmp50_ = NULL;
					const gchar* _tmp51_ = NULL;
					gchar* _tmp52_ = NULL;
					gchar* _tmp53_ = NULL;
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					err = _inner_error_;
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					_inner_error_ = NULL;
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp44_ = _ ("Unable to generate a temporary file for %s: %s");
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp45_ = source;
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp46_ = media_source_get_file (_tmp45_);
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp47_ = _tmp46_;
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp48_ = g_file_get_basename (_tmp47_);
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp49_ = _tmp48_;
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp50_ = err;
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp51_ = _tmp50_->message;
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp52_ = g_strdup_printf (_tmp44_, _tmp49_, _tmp51_);
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp53_ = _tmp52_;
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					app_window_error_message (_tmp53_, NULL);
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_free0 (_tmp53_);
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_free0 (_tmp49_);
#line 232 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (_tmp47_);
#line 235 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_error_free0 (err);
#line 235 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (dest);
#line 235 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (export_dir);
#line 235 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_free0 (basename);
#line 235 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (use_source_file);
#line 235 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (source);
#line 235 "/home/jens/Source/shotwell/src/Exporter.vala"
					break;
#line 1558 "Exporter.c"
				}
				__finally467:
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (dest);
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (export_dir);
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_free0 (basename);
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (use_source_file);
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (source);
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					_g_object_unref0 (_source_it);
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					g_clear_error (&_inner_error_);
#line 228 "/home/jens/Source/shotwell/src/Exporter.vala"
					return FALSE;
#line 1581 "Exporter.c"
				}
			} else {
				GFile* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				GFile* _tmp56_ = NULL;
				gboolean _tmp57_ = FALSE;
				gboolean _tmp58_ = FALSE;
#line 238 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp54_ = self->priv->dir;
#line 238 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp55_ = basename;
#line 238 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp56_ = g_file_get_child (_tmp54_, _tmp55_);
#line 238 "/home/jens/Source/shotwell/src/Exporter.vala"
				_g_object_unref0 (dest);
#line 238 "/home/jens/Source/shotwell/src/Exporter.vala"
				dest = _tmp56_;
#line 240 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp58_ = self->priv->replace_all;
#line 240 "/home/jens/Source/shotwell/src/Exporter.vala"
				if (!_tmp58_) {
#line 1603 "Exporter.c"
					GFile* _tmp59_ = NULL;
					gboolean _tmp60_ = FALSE;
#line 240 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp59_ = dest;
#line 240 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp60_ = g_file_query_exists (_tmp59_, NULL);
#line 240 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp57_ = _tmp60_;
#line 1612 "Exporter.c"
				} else {
#line 240 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp57_ = FALSE;
#line 1616 "Exporter.c"
				}
#line 240 "/home/jens/Source/shotwell/src/Exporter.vala"
				if (_tmp57_) {
#line 1620 "Exporter.c"
					ExporterOverwriteCallback _tmp61_ = NULL;
					void* _tmp61__target = NULL;
					GFile* _tmp62_ = NULL;
					ExporterOverwrite _tmp63_ = 0;
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp61_ = self->priv->overwrite_callback;
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp61__target = self->priv->overwrite_callback_target;
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp62_ = dest;
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
					_tmp63_ = _tmp61_ (self, _tmp62_, _tmp61__target);
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
					switch (_tmp63_) {
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
						case EXPORTER_OVERWRITE_YES:
#line 1637 "Exporter.c"
						{
#line 244 "/home/jens/Source/shotwell/src/Exporter.vala"
							break;
#line 1641 "Exporter.c"
						}
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
						case EXPORTER_OVERWRITE_REPLACE_ALL:
#line 1645 "Exporter.c"
						{
#line 247 "/home/jens/Source/shotwell/src/Exporter.vala"
							self->priv->replace_all = TRUE;
#line 248 "/home/jens/Source/shotwell/src/Exporter.vala"
							break;
#line 1651 "Exporter.c"
						}
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
						case EXPORTER_OVERWRITE_CANCEL:
#line 1655 "Exporter.c"
						{
							GCancellable* _tmp64_ = NULL;
#line 251 "/home/jens/Source/shotwell/src/Exporter.vala"
							_tmp64_ = self->priv->cancellable;
#line 251 "/home/jens/Source/shotwell/src/Exporter.vala"
							g_cancellable_cancel (_tmp64_);
#line 253 "/home/jens/Source/shotwell/src/Exporter.vala"
							result = FALSE;
#line 253 "/home/jens/Source/shotwell/src/Exporter.vala"
							_g_object_unref0 (dest);
#line 253 "/home/jens/Source/shotwell/src/Exporter.vala"
							_g_object_unref0 (export_dir);
#line 253 "/home/jens/Source/shotwell/src/Exporter.vala"
							_g_free0 (basename);
#line 253 "/home/jens/Source/shotwell/src/Exporter.vala"
							_g_object_unref0 (use_source_file);
#line 253 "/home/jens/Source/shotwell/src/Exporter.vala"
							_g_object_unref0 (source);
#line 253 "/home/jens/Source/shotwell/src/Exporter.vala"
							_g_object_unref0 (_source_it);
#line 253 "/home/jens/Source/shotwell/src/Exporter.vala"
							return result;
#line 1678 "Exporter.c"
						}
						default:
#line 241 "/home/jens/Source/shotwell/src/Exporter.vala"
						case EXPORTER_OVERWRITE_NO:
#line 1683 "Exporter.c"
						{
							gint _tmp65_ = 0;
							ProgressMonitor _tmp66_ = NULL;
							void* _tmp66__target = NULL;
#line 257 "/home/jens/Source/shotwell/src/Exporter.vala"
							_tmp65_ = self->priv->completed_count;
#line 257 "/home/jens/Source/shotwell/src/Exporter.vala"
							self->priv->completed_count = _tmp65_ + 1;
#line 258 "/home/jens/Source/shotwell/src/Exporter.vala"
							_tmp66_ = self->priv->monitor;
#line 258 "/home/jens/Source/shotwell/src/Exporter.vala"
							_tmp66__target = self->priv->monitor_target;
#line 258 "/home/jens/Source/shotwell/src/Exporter.vala"
							if (_tmp66_ != NULL) {
#line 1698 "Exporter.c"
								ProgressMonitor _tmp67_ = NULL;
								void* _tmp67__target = NULL;
								gint _tmp68_ = 0;
								GeeCollection* _tmp69_ = NULL;
								gint _tmp70_ = 0;
								gint _tmp71_ = 0;
								gboolean _tmp72_ = FALSE;
#line 259 "/home/jens/Source/shotwell/src/Exporter.vala"
								_tmp67_ = self->priv->monitor;
#line 259 "/home/jens/Source/shotwell/src/Exporter.vala"
								_tmp67__target = self->priv->monitor_target;
#line 259 "/home/jens/Source/shotwell/src/Exporter.vala"
								_tmp68_ = self->priv->completed_count;
#line 259 "/home/jens/Source/shotwell/src/Exporter.vala"
								_tmp69_ = self->priv->to_export;
#line 259 "/home/jens/Source/shotwell/src/Exporter.vala"
								_tmp70_ = gee_collection_get_size (_tmp69_);
#line 259 "/home/jens/Source/shotwell/src/Exporter.vala"
								_tmp71_ = _tmp70_;
#line 259 "/home/jens/Source/shotwell/src/Exporter.vala"
								_tmp72_ = _tmp67_ ((guint64) _tmp68_, (guint64) _tmp71_, TRUE, _tmp67__target);
#line 259 "/home/jens/Source/shotwell/src/Exporter.vala"
								if (!_tmp72_) {
#line 1722 "Exporter.c"
									GCancellable* _tmp73_ = NULL;
#line 260 "/home/jens/Source/shotwell/src/Exporter.vala"
									_tmp73_ = self->priv->cancellable;
#line 260 "/home/jens/Source/shotwell/src/Exporter.vala"
									g_cancellable_cancel (_tmp73_);
#line 262 "/home/jens/Source/shotwell/src/Exporter.vala"
									result = FALSE;
#line 262 "/home/jens/Source/shotwell/src/Exporter.vala"
									_g_object_unref0 (dest);
#line 262 "/home/jens/Source/shotwell/src/Exporter.vala"
									_g_object_unref0 (export_dir);
#line 262 "/home/jens/Source/shotwell/src/Exporter.vala"
									_g_free0 (basename);
#line 262 "/home/jens/Source/shotwell/src/Exporter.vala"
									_g_object_unref0 (use_source_file);
#line 262 "/home/jens/Source/shotwell/src/Exporter.vala"
									_g_object_unref0 (source);
#line 262 "/home/jens/Source/shotwell/src/Exporter.vala"
									_g_object_unref0 (_source_it);
#line 262 "/home/jens/Source/shotwell/src/Exporter.vala"
									return result;
#line 1744 "Exporter.c"
								}
							}
#line 266 "/home/jens/Source/shotwell/src/Exporter.vala"
							continue;
#line 1749 "Exporter.c"
						}
					}
				}
			}
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp74_ = self->priv->workers;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp75_ = source;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp76_ = dest;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp77_ = self->priv->scaling;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp78_ = self->priv->export_params;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp79_ = _tmp78_.quality;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp80_ = real_export_format;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp81_ = self->priv->cancellable;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp82_ = self->priv->export_params;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp83_ = _tmp82_.mode;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp84_ = self->priv->export_params;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp85_ = _tmp84_.export_metadata;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp86_ = exporter_export_job_new (self, _tmp75_, _tmp76_, &_tmp77_, &_tmp79_, &_tmp80_, _tmp81_, _tmp83_ == EXPORT_FORMAT_MODE_UNMODIFIED, _tmp85_);
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp87_ = _tmp86_;
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			workers_enqueue (_tmp74_, G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 271 "/home/jens/Source/shotwell/src/Exporter.vala"
			_background_job_unref0 (_tmp87_);
#line 273 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp88_ = submitted;
#line 273 "/home/jens/Source/shotwell/src/Exporter.vala"
			submitted = _tmp88_ + 1;
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_object_unref0 (dest);
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_object_unref0 (export_dir);
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_free0 (basename);
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_object_unref0 (use_source_file);
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_object_unref0 (source);
#line 1800 "Exporter.c"
		}
#line 196 "/home/jens/Source/shotwell/src/Exporter.vala"
		_g_object_unref0 (_source_it);
#line 1804 "Exporter.c"
	}
#line 276 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp89_ = submitted;
#line 276 "/home/jens/Source/shotwell/src/Exporter.vala"
	result = _tmp89_ > 0;
#line 276 "/home/jens/Source/shotwell/src/Exporter.vala"
	return result;
#line 1812 "Exporter.c"
}


static void exporter_export_completed (Exporter* self, gboolean is_cancelled) {
	ExporterCompletionCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gboolean _tmp1_ = FALSE;
#line 279 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_EXPORTER (self));
#line 280 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = self->priv->completion_callback;
#line 280 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0__target = self->priv->completion_callback_target;
#line 280 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = is_cancelled;
#line 280 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ (self, _tmp1_, _tmp0__target);
#line 1830 "Exporter.c"
}


static void _exporter_on_exported_completion_callback (BackgroundJob* job, gpointer self) {
#line 81 "/home/jens/Source/shotwell/src/Exporter.vala"
	exporter_on_exported ((Exporter*) self, job);
#line 1837 "Exporter.c"
}


static void _exporter_on_export_cancelled_cancellation_callback (BackgroundJob* job, gpointer self) {
#line 81 "/home/jens/Source/shotwell/src/Exporter.vala"
	exporter_on_export_cancelled ((Exporter*) self, job);
#line 1844 "Exporter.c"
}


static gpointer _scaling_dup0 (gpointer self) {
#line 87 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self ? scaling_dup (self) : NULL;
#line 1851 "Exporter.c"
}


static JpegQuality* _jpeg_quality_dup (JpegQuality* self) {
	JpegQuality* dup;
#line 88 "/home/jens/Source/shotwell/src/Exporter.vala"
	dup = g_new0 (JpegQuality, 1);
#line 88 "/home/jens/Source/shotwell/src/Exporter.vala"
	memcpy (dup, self, sizeof (JpegQuality));
#line 88 "/home/jens/Source/shotwell/src/Exporter.vala"
	return dup;
#line 1863 "Exporter.c"
}


static gpointer __jpeg_quality_dup0 (gpointer self) {
#line 88 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self ? _jpeg_quality_dup (self) : NULL;
#line 1870 "Exporter.c"
}


static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self) {
	PhotoFileFormat* dup;
#line 89 "/home/jens/Source/shotwell/src/Exporter.vala"
	dup = g_new0 (PhotoFileFormat, 1);
#line 89 "/home/jens/Source/shotwell/src/Exporter.vala"
	memcpy (dup, self, sizeof (PhotoFileFormat));
#line 89 "/home/jens/Source/shotwell/src/Exporter.vala"
	return dup;
#line 1882 "Exporter.c"
}


static gpointer __photo_file_format_dup0 (gpointer self) {
#line 89 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self ? _photo_file_format_dup (self) : NULL;
#line 1889 "Exporter.c"
}


static ExporterExportJob* exporter_export_job_construct (GType object_type, Exporter* owner, MediaSource* media, GFile* dest, Scaling* scaling, JpegQuality* quality, PhotoFileFormat* format, GCancellable* cancellable, gboolean direct_copy_unmodified, gboolean export_metadata) {
	ExporterExportJob* self = NULL;
	Exporter* _tmp0_ = NULL;
	Exporter* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	Exporter* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	MediaSource* _tmp5_ = NULL;
	MediaSource* _tmp7_ = NULL;
	MediaSource* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	Scaling* _tmp11_ = NULL;
	Scaling* _tmp12_ = NULL;
	JpegQuality* _tmp13_ = NULL;
	JpegQuality* _tmp14_ = NULL;
	PhotoFileFormat* _tmp15_ = NULL;
	PhotoFileFormat* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
#line 78 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_EXPORTER (owner), NULL);
#line 78 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
#line 78 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (G_IS_FILE (dest), NULL);
#line 78 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (G_IS_CANCELLABLE (cancellable), NULL);
#line 81 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = owner;
#line 81 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = owner;
#line 81 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = cancellable;
#line 81 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = owner;
#line 81 "/home/jens/Source/shotwell/src/Exporter.vala"
	self = (ExporterExportJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _exporter_on_exported_completion_callback, _tmp1_, _tmp2_, _exporter_on_export_cancelled_cancellation_callback, _tmp3_, NULL);
#line 83 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp5_ = media;
#line 83 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_PHOTO)) {
#line 83 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp4_ = TRUE;
#line 1937 "Exporter.c"
	} else {
		MediaSource* _tmp6_ = NULL;
#line 83 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp6_ = media;
#line 83 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_VIDEO);
#line 1944 "Exporter.c"
	}
#line 83 "/home/jens/Source/shotwell/src/Exporter.vala"
	_vala_assert (_tmp4_, "media is Photo || media is Video");
#line 85 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp7_ = media;
#line 85 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 85 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->media);
#line 85 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->media = _tmp8_;
#line 86 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp9_ = dest;
#line 86 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 86 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->dest);
#line 86 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->dest = _tmp10_;
#line 87 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp11_ = scaling;
#line 87 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp12_ = _scaling_dup0 (_tmp11_);
#line 87 "/home/jens/Source/shotwell/src/Exporter.vala"
	_scaling_free0 (self->scaling);
#line 87 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->scaling = _tmp12_;
#line 88 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp13_ = quality;
#line 88 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp14_ = __jpeg_quality_dup0 (_tmp13_);
#line 88 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_free0 (self->quality);
#line 88 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->quality = _tmp14_;
#line 89 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp15_ = format;
#line 89 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp16_ = __photo_file_format_dup0 (_tmp15_);
#line 89 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_free0 (self->format);
#line 89 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->format = _tmp16_;
#line 90 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp17_ = direct_copy_unmodified;
#line 90 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->direct_copy_unmodified = _tmp17_;
#line 91 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp18_ = export_metadata;
#line 91 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->export_metadata = _tmp18_;
#line 78 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self;
#line 1998 "Exporter.c"
}


static ExporterExportJob* exporter_export_job_new (Exporter* owner, MediaSource* media, GFile* dest, Scaling* scaling, JpegQuality* quality, PhotoFileFormat* format, GCancellable* cancellable, gboolean direct_copy_unmodified, gboolean export_metadata) {
#line 78 "/home/jens/Source/shotwell/src/Exporter.vala"
	return exporter_export_job_construct (EXPORTER_TYPE_EXPORT_JOB, owner, media, dest, scaling, quality, format, cancellable, direct_copy_unmodified, export_metadata);
#line 2005 "Exporter.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 102 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self ? g_error_copy (self) : NULL;
#line 2012 "Exporter.c"
}


static void exporter_export_job_real_execute (BackgroundJob* base) {
	ExporterExportJob * self;
	GError * _inner_error_ = NULL;
#line 94 "/home/jens/Source/shotwell/src/Exporter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob);
#line 2021 "Exporter.c"
	{
		MediaSource* _tmp0_ = NULL;
#line 96 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp0_ = self->media;
#line 96 "/home/jens/Source/shotwell/src/Exporter.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_PHOTO)) {
#line 2028 "Exporter.c"
			MediaSource* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			Scaling* _tmp3_ = NULL;
			JpegQuality* _tmp4_ = NULL;
			PhotoFileFormat* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			Scaling _tmp8_ = {0};
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp1_ = self->media;
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp2_ = self->dest;
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp3_ = self->scaling;
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp4_ = self->quality;
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp5_ = self->format;
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp6_ = self->direct_copy_unmodified;
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp7_ = self->export_metadata;
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp8_ = *_tmp3_;
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			photo_export (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO, Photo), _tmp2_, &_tmp8_, *_tmp4_, *_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
#line 97 "/home/jens/Source/shotwell/src/Exporter.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2057 "Exporter.c"
				goto __catch468_g_error;
			}
		} else {
			MediaSource* _tmp9_ = NULL;
#line 98 "/home/jens/Source/shotwell/src/Exporter.vala"
			_tmp9_ = self->media;
#line 98 "/home/jens/Source/shotwell/src/Exporter.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_VIDEO)) {
#line 2066 "Exporter.c"
				MediaSource* _tmp10_ = NULL;
				GFile* _tmp11_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp10_ = self->media;
#line 99 "/home/jens/Source/shotwell/src/Exporter.vala"
				_tmp11_ = self->dest;
#line 99 "/home/jens/Source/shotwell/src/Exporter.vala"
				video_export (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_VIDEO, Video), _tmp11_, &_inner_error_);
#line 99 "/home/jens/Source/shotwell/src/Exporter.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2077 "Exporter.c"
					goto __catch468_g_error;
				}
			}
		}
	}
	goto __finally468;
	__catch468_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/Exporter.vala"
		err = _inner_error_;
#line 95 "/home/jens/Source/shotwell/src/Exporter.vala"
		_inner_error_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp12_ = err;
#line 102 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp13_ = _g_error_copy0 (_tmp12_);
#line 102 "/home/jens/Source/shotwell/src/Exporter.vala"
		_g_error_free0 (self->err);
#line 102 "/home/jens/Source/shotwell/src/Exporter.vala"
		self->err = _tmp13_;
#line 95 "/home/jens/Source/shotwell/src/Exporter.vala"
		_g_error_free0 (err);
#line 2103 "Exporter.c"
	}
	__finally468:
#line 95 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/jens/Source/shotwell/src/Exporter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 95 "/home/jens/Source/shotwell/src/Exporter.vala"
		g_clear_error (&_inner_error_);
#line 95 "/home/jens/Source/shotwell/src/Exporter.vala"
		return;
#line 2114 "Exporter.c"
	}
}


static void exporter_export_job_class_init (ExporterExportJobClass * klass) {
#line 68 "/home/jens/Source/shotwell/src/Exporter.vala"
	exporter_export_job_parent_class = g_type_class_peek_parent (klass);
#line 68 "/home/jens/Source/shotwell/src/Exporter.vala"
	((BackgroundJobClass *) klass)->finalize = exporter_export_job_finalize;
#line 68 "/home/jens/Source/shotwell/src/Exporter.vala"
	((BackgroundJobClass *) klass)->execute = exporter_export_job_real_execute;
#line 2126 "Exporter.c"
}


static void exporter_export_job_instance_init (ExporterExportJob * self) {
#line 74 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->err = NULL;
#line 75 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->direct_copy_unmodified = FALSE;
#line 76 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->export_metadata = TRUE;
#line 2137 "Exporter.c"
}


static void exporter_export_job_finalize (BackgroundJob* obj) {
	ExporterExportJob * self;
#line 68 "/home/jens/Source/shotwell/src/Exporter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EXPORTER_TYPE_EXPORT_JOB, ExporterExportJob);
#line 69 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->media);
#line 70 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->dest);
#line 71 "/home/jens/Source/shotwell/src/Exporter.vala"
	_scaling_free0 (self->scaling);
#line 72 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_free0 (self->quality);
#line 73 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_free0 (self->format);
#line 74 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_error_free0 (self->err);
#line 68 "/home/jens/Source/shotwell/src/Exporter.vala"
	BACKGROUND_JOB_CLASS (exporter_export_job_parent_class)->finalize (obj);
#line 2159 "Exporter.c"
}


static GType exporter_export_job_get_type (void) {
	static volatile gsize exporter_export_job_type_id__volatile = 0;
	if (g_once_init_enter (&exporter_export_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExporterExportJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_export_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExporterExportJob), 0, (GInstanceInitFunc) exporter_export_job_instance_init, NULL };
		GType exporter_export_job_type_id;
		exporter_export_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "ExporterExportJob", &g_define_type_info, 0);
		g_once_init_leave (&exporter_export_job_type_id__volatile, exporter_export_job_type_id);
	}
	return exporter_export_job_type_id__volatile;
}


static void exporter_class_init (ExporterClass * klass) {
#line 53 "/home/jens/Source/shotwell/src/Exporter.vala"
	exporter_parent_class = g_type_class_peek_parent (klass);
#line 53 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_type_class_add_private (klass, sizeof (ExporterPrivate));
#line 53 "/home/jens/Source/shotwell/src/Exporter.vala"
	G_OBJECT_CLASS (klass)->finalize = exporter_finalize;
#line 2182 "Exporter.c"
}


static void exporter_instance_init (Exporter * self) {
	GeeArrayList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Workers* _tmp2_ = NULL;
#line 53 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv = EXPORTER_GET_PRIVATE (self);
#line 107 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 107 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->to_export = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
#line 111 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completed_count = 0;
#line 112 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = workers_threads_per_cpu (1, 4);
#line 112 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = workers_new (_tmp1_, FALSE);
#line 112 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->workers = _tmp2_;
#line 113 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completion_callback = NULL;
#line 114 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->error_callback = NULL;
#line 115 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->overwrite_callback = NULL;
#line 116 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->monitor = NULL;
#line 118 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->replace_all = FALSE;
#line 119 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->aborted = FALSE;
#line 2216 "Exporter.c"
}


static void exporter_finalize (GObject* obj) {
	Exporter * self;
#line 53 "/home/jens/Source/shotwell/src/Exporter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORTER, Exporter);
#line 107 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->to_export);
#line 108 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->exported_files = (_vala_array_free (self->priv->exported_files, self->priv->exported_files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 109 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->dir);
#line 112 "/home/jens/Source/shotwell/src/Exporter.vala"
	_workers_unref0 (self->priv->workers);
#line 117 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 53 "/home/jens/Source/shotwell/src/Exporter.vala"
	G_OBJECT_CLASS (exporter_parent_class)->finalize (obj);
#line 2236 "Exporter.c"
}


GType exporter_get_type (void) {
	static volatile gsize exporter_type_id__volatile = 0;
	if (g_once_init_enter (&exporter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Exporter), 0, (GInstanceInitFunc) exporter_instance_init, NULL };
		GType exporter_type_id;
		exporter_type_id = g_type_register_static (G_TYPE_OBJECT, "Exporter", &g_define_type_info, 0);
		g_once_init_leave (&exporter_type_id__volatile, exporter_type_id);
	}
	return exporter_type_id__volatile;
}


ExporterUI* exporter_ui_construct (GType object_type, Exporter* exporter) {
	ExporterUI* self = NULL;
	Exporter* _tmp0_ = NULL;
	Exporter* _tmp1_ = NULL;
#line 290 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_EXPORTER (exporter), NULL);
#line 290 "/home/jens/Source/shotwell/src/Exporter.vala"
	self = (ExporterUI*) g_type_create_instance (object_type);
#line 291 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = exporter;
#line 291 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 291 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->exporter);
#line 291 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->exporter = _tmp1_;
#line 290 "/home/jens/Source/shotwell/src/Exporter.vala"
	return self;
#line 2270 "Exporter.c"
}


ExporterUI* exporter_ui_new (Exporter* exporter) {
#line 290 "/home/jens/Source/shotwell/src/Exporter.vala"
	return exporter_ui_construct (TYPE_EXPORTER_UI, exporter);
#line 2277 "Exporter.c"
}


static void _exporter_ui_on_export_completed_exporter_completion_callback (Exporter* exporter, gboolean is_cancelled, gpointer self) {
#line 300 "/home/jens/Source/shotwell/src/Exporter.vala"
	exporter_ui_on_export_completed ((ExporterUI*) self, exporter, is_cancelled);
#line 2284 "Exporter.c"
}


static gboolean _exporter_ui_on_export_failed_exporter_export_failed_callback (Exporter* exporter, GFile* file, gint remaining, GError* err, gpointer self) {
	gboolean result;
	result = exporter_ui_on_export_failed ((ExporterUI*) self, exporter, file, remaining, err);
#line 300 "/home/jens/Source/shotwell/src/Exporter.vala"
	return result;
#line 2293 "Exporter.c"
}


static ExporterOverwrite _exporter_ui_on_export_overwrite_exporter_overwrite_callback (Exporter* exporter, GFile* file, gpointer self) {
	ExporterOverwrite result;
	result = exporter_ui_on_export_overwrite ((ExporterUI*) self, exporter, file);
#line 300 "/home/jens/Source/shotwell/src/Exporter.vala"
	return result;
#line 2302 "Exporter.c"
}


static gboolean _progress_dialog_monitor_progress_monitor (guint64 current, guint64 total, gboolean do_event_loop, gpointer self) {
	gboolean result;
	result = progress_dialog_monitor ((ProgressDialog*) self, current, total, do_event_loop);
#line 300 "/home/jens/Source/shotwell/src/Exporter.vala"
	return result;
#line 2311 "Exporter.c"
}


void exporter_ui_export (ExporterUI* self, ExporterCompletionCallback completion_callback, void* completion_callback_target) {
	ExporterCompletionCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	AppWindow* _tmp1_ = NULL;
	AppWindow* _tmp2_ = NULL;
	AppWindow* _tmp3_ = NULL;
	AppWindow* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GCancellable* _tmp6_ = NULL;
	ProgressDialog* _tmp7_ = NULL;
	Exporter* _tmp8_ = NULL;
	GCancellable* _tmp9_ = NULL;
	ProgressDialog* _tmp10_ = NULL;
#line 294 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_EXPORTER_UI (self));
#line 295 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = completion_callback;
#line 295 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0__target = completion_callback_target;
#line 295 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completion_callback = _tmp0_;
#line 295 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completion_callback_target = _tmp0__target;
#line 297 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = app_window_get_instance ();
#line 297 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = _tmp1_;
#line 297 "/home/jens/Source/shotwell/src/Exporter.vala"
	page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PAGE_WINDOW, PageWindow));
#line 297 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (_tmp2_);
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = app_window_get_instance ();
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ = _tmp3_;
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp5_ = _ ("Exporting");
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp6_ = self->priv->cancellable;
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp7_ = progress_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), _tmp5_, _tmp6_);
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_object_ref_sink (_tmp7_);
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->progress_dialog = _tmp7_;
#line 299 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (_tmp4_);
#line 300 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp8_ = self->priv->exporter;
#line 300 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp9_ = self->priv->cancellable;
#line 300 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp10_ = self->priv->progress_dialog;
#line 300 "/home/jens/Source/shotwell/src/Exporter.vala"
	exporter_export (_tmp8_, _exporter_ui_on_export_completed_exporter_completion_callback, self, _exporter_ui_on_export_failed_exporter_export_failed_callback, self, _exporter_ui_on_export_overwrite_exporter_overwrite_callback, self, _tmp9_, _progress_dialog_monitor_progress_monitor, _tmp10_);
#line 2372 "Exporter.c"
}


static void exporter_ui_on_export_completed (ExporterUI* self, Exporter* exporter, gboolean is_cancelled) {
	ProgressDialog* _tmp0_ = NULL;
	AppWindow* _tmp2_ = NULL;
	AppWindow* _tmp3_ = NULL;
	ExporterCompletionCallback _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	Exporter* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 304 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_EXPORTER_UI (self));
#line 304 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (IS_EXPORTER (exporter));
#line 305 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 305 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (_tmp0_ != NULL) {
#line 2392 "Exporter.c"
		ProgressDialog* _tmp1_ = NULL;
#line 306 "/home/jens/Source/shotwell/src/Exporter.vala"
		_tmp1_ = self->priv->progress_dialog;
#line 306 "/home/jens/Source/shotwell/src/Exporter.vala"
		progress_dialog_close (_tmp1_);
#line 307 "/home/jens/Source/shotwell/src/Exporter.vala"
		_g_object_unref0 (self->priv->progress_dialog);
#line 307 "/home/jens/Source/shotwell/src/Exporter.vala"
		self->priv->progress_dialog = NULL;
#line 2402 "Exporter.c"
	}
#line 310 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = app_window_get_instance ();
#line 310 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = _tmp2_;
#line 310 "/home/jens/Source/shotwell/src/Exporter.vala"
	page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PAGE_WINDOW, PageWindow));
#line 310 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (_tmp3_);
#line 312 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ = self->priv->completion_callback;
#line 312 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4__target = self->priv->completion_callback_target;
#line 312 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp5_ = exporter;
#line 312 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp6_ = is_cancelled;
#line 312 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ (_tmp5_, _tmp6_, _tmp4__target);
#line 2422 "Exporter.c"
}


static ExporterOverwrite exporter_ui_on_export_overwrite (ExporterUI* self, Exporter* exporter, GFile* file) {
	ExporterOverwrite result = 0;
	ProgressDialog* _tmp0_ = NULL;
	gchar* question = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkResponseType response = 0;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkResponseType _tmp12_ = 0;
	ProgressDialog* _tmp13_ = NULL;
	GtkResponseType _tmp14_ = 0;
#line 315 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_EXPORTER_UI (self), 0);
#line 315 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_EXPORTER (exporter), 0);
#line 315 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (G_IS_FILE (file), 0);
#line 316 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = self->priv->progress_dialog;
#line 316 "/home/jens/Source/shotwell/src/Exporter.vala"
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), FALSE);
#line 317 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = _ ("File %s already exists.  Replace?");
#line 317 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = file;
#line 317 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp3_ = g_file_get_basename (_tmp2_);
#line 317 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp4_ = _tmp3_;
#line 317 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp5_ = g_strdup_printf (_tmp1_, _tmp4_);
#line 317 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp6_ = _tmp5_;
#line 317 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_free0 (_tmp4_);
#line 317 "/home/jens/Source/shotwell/src/Exporter.vala"
	question = _tmp6_;
#line 318 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp7_ = question;
#line 318 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp8_ = _ ("_Skip");
#line 318 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp9_ = _ ("_Replace");
#line 318 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp10_ = _ ("Replace _All");
#line 318 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp11_ = _ ("Export");
#line 318 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp12_ = app_window_negate_affirm_all_cancel_question (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, NULL);
#line 318 "/home/jens/Source/shotwell/src/Exporter.vala"
	response = _tmp12_;
#line 321 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp13_ = self->priv->progress_dialog;
#line 321 "/home/jens/Source/shotwell/src/Exporter.vala"
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_window_get_type (), GtkWindow), TRUE);
#line 323 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp14_ = response;
#line 323 "/home/jens/Source/shotwell/src/Exporter.vala"
	switch (_tmp14_) {
#line 323 "/home/jens/Source/shotwell/src/Exporter.vala"
		case GTK_RESPONSE_APPLY:
#line 2495 "Exporter.c"
		{
#line 325 "/home/jens/Source/shotwell/src/Exporter.vala"
			result = EXPORTER_OVERWRITE_REPLACE_ALL;
#line 325 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_free0 (question);
#line 325 "/home/jens/Source/shotwell/src/Exporter.vala"
			return result;
#line 2503 "Exporter.c"
		}
#line 323 "/home/jens/Source/shotwell/src/Exporter.vala"
		case GTK_RESPONSE_YES:
#line 2507 "Exporter.c"
		{
#line 328 "/home/jens/Source/shotwell/src/Exporter.vala"
			result = EXPORTER_OVERWRITE_YES;
#line 328 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_free0 (question);
#line 328 "/home/jens/Source/shotwell/src/Exporter.vala"
			return result;
#line 2515 "Exporter.c"
		}
#line 323 "/home/jens/Source/shotwell/src/Exporter.vala"
		case GTK_RESPONSE_CANCEL:
#line 2519 "Exporter.c"
		{
#line 331 "/home/jens/Source/shotwell/src/Exporter.vala"
			result = EXPORTER_OVERWRITE_CANCEL;
#line 331 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_free0 (question);
#line 331 "/home/jens/Source/shotwell/src/Exporter.vala"
			return result;
#line 2527 "Exporter.c"
		}
		default:
#line 323 "/home/jens/Source/shotwell/src/Exporter.vala"
		case GTK_RESPONSE_NO:
#line 2532 "Exporter.c"
		{
#line 335 "/home/jens/Source/shotwell/src/Exporter.vala"
			result = EXPORTER_OVERWRITE_NO;
#line 335 "/home/jens/Source/shotwell/src/Exporter.vala"
			_g_free0 (question);
#line 335 "/home/jens/Source/shotwell/src/Exporter.vala"
			return result;
#line 2540 "Exporter.c"
		}
	}
#line 315 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_free0 (question);
#line 2545 "Exporter.c"
}


static gboolean exporter_ui_on_export_failed (ExporterUI* self, Exporter* exporter, GFile* file, gint remaining, GError* err) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkResponseType _tmp2_ = 0;
#line 339 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_EXPORTER_UI (self), FALSE);
#line 339 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (IS_EXPORTER (exporter), FALSE);
#line 339 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 340 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = file;
#line 340 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp1_ = remaining;
#line 340 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp2_ = export_error_dialog (_tmp0_, _tmp1_ > 0);
#line 340 "/home/jens/Source/shotwell/src/Exporter.vala"
	result = _tmp2_ != GTK_RESPONSE_CANCEL;
#line 340 "/home/jens/Source/shotwell/src/Exporter.vala"
	return result;
#line 2570 "Exporter.c"
}


static void value_exporter_ui_init (GValue* value) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	value->data[0].v_pointer = NULL;
#line 2577 "Exporter.c"
}


static void value_exporter_ui_free_value (GValue* value) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (value->data[0].v_pointer) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		exporter_ui_unref (value->data[0].v_pointer);
#line 2586 "Exporter.c"
	}
}


static void value_exporter_ui_copy_value (const GValue* src_value, GValue* dest_value) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (src_value->data[0].v_pointer) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		dest_value->data[0].v_pointer = exporter_ui_ref (src_value->data[0].v_pointer);
#line 2596 "Exporter.c"
	} else {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2600 "Exporter.c"
	}
}


static gpointer value_exporter_ui_peek_pointer (const GValue* value) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	return value->data[0].v_pointer;
#line 2608 "Exporter.c"
}


static gchar* value_exporter_ui_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (collect_values[0].v_pointer) {
#line 2615 "Exporter.c"
		ExporterUI* object;
		object = collect_values[0].v_pointer;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		if (object->parent_instance.g_class == NULL) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2622 "Exporter.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2626 "Exporter.c"
		}
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		value->data[0].v_pointer = exporter_ui_ref (object);
#line 2630 "Exporter.c"
	} else {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		value->data[0].v_pointer = NULL;
#line 2634 "Exporter.c"
	}
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	return NULL;
#line 2638 "Exporter.c"
}


static gchar* value_exporter_ui_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ExporterUI** object_p;
	object_p = collect_values[0].v_pointer;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (!object_p) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2649 "Exporter.c"
	}
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (!value->data[0].v_pointer) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		*object_p = NULL;
#line 2655 "Exporter.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		*object_p = value->data[0].v_pointer;
#line 2659 "Exporter.c"
	} else {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		*object_p = exporter_ui_ref (value->data[0].v_pointer);
#line 2663 "Exporter.c"
	}
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	return NULL;
#line 2667 "Exporter.c"
}


GParamSpec* param_spec_exporter_ui (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecExporterUI* spec;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPORTER_UI), NULL);
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	return G_PARAM_SPEC (spec);
#line 2681 "Exporter.c"
}


gpointer value_get_exporter_ui (const GValue* value) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI), NULL);
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	return value->data[0].v_pointer;
#line 2690 "Exporter.c"
}


void value_set_exporter_ui (GValue* value, gpointer v_object) {
	ExporterUI* old;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI));
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	old = value->data[0].v_pointer;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (v_object) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPORTER_UI));
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		value->data[0].v_pointer = v_object;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		exporter_ui_ref (value->data[0].v_pointer);
#line 2710 "Exporter.c"
	} else {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		value->data[0].v_pointer = NULL;
#line 2714 "Exporter.c"
	}
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (old) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		exporter_ui_unref (old);
#line 2720 "Exporter.c"
	}
}


void value_take_exporter_ui (GValue* value, gpointer v_object) {
	ExporterUI* old;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORTER_UI));
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	old = value->data[0].v_pointer;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (v_object) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPORTER_UI));
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		value->data[0].v_pointer = v_object;
#line 2739 "Exporter.c"
	} else {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		value->data[0].v_pointer = NULL;
#line 2743 "Exporter.c"
	}
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (old) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		exporter_ui_unref (old);
#line 2749 "Exporter.c"
	}
}


static void exporter_ui_class_init (ExporterUIClass * klass) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	exporter_ui_parent_class = g_type_class_peek_parent (klass);
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	((ExporterUIClass *) klass)->finalize = exporter_ui_finalize;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_type_class_add_private (klass, sizeof (ExporterUIPrivate));
#line 2761 "Exporter.c"
}


static void exporter_ui_instance_init (ExporterUI * self) {
	GCancellable* _tmp0_ = NULL;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv = EXPORTER_UI_GET_PRIVATE (self);
#line 286 "/home/jens/Source/shotwell/src/Exporter.vala"
	_tmp0_ = g_cancellable_new ();
#line 286 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->cancellable = _tmp0_;
#line 287 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->progress_dialog = NULL;
#line 288 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->priv->completion_callback = NULL;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	self->ref_count = 1;
#line 2779 "Exporter.c"
}


static void exporter_ui_finalize (ExporterUI* obj) {
	ExporterUI * self;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORTER_UI, ExporterUI);
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_signal_handlers_destroy (self);
#line 285 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->exporter);
#line 286 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 287 "/home/jens/Source/shotwell/src/Exporter.vala"
	_g_object_unref0 (self->priv->progress_dialog);
#line 2795 "Exporter.c"
}


GType exporter_ui_get_type (void) {
	static volatile gsize exporter_ui_type_id__volatile = 0;
	if (g_once_init_enter (&exporter_ui_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_exporter_ui_init, value_exporter_ui_free_value, value_exporter_ui_copy_value, value_exporter_ui_peek_pointer, "p", value_exporter_ui_collect_value, "p", value_exporter_ui_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ExporterUIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exporter_ui_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExporterUI), 0, (GInstanceInitFunc) exporter_ui_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType exporter_ui_type_id;
		exporter_ui_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ExporterUI", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&exporter_ui_type_id__volatile, exporter_ui_type_id);
	}
	return exporter_ui_type_id__volatile;
}


gpointer exporter_ui_ref (gpointer instance) {
	ExporterUI* self;
	self = instance;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	g_atomic_int_inc (&self->ref_count);
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	return instance;
#line 2820 "Exporter.c"
}


void exporter_ui_unref (gpointer instance) {
	ExporterUI* self;
	self = instance;
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		EXPORTER_UI_GET_CLASS (self)->finalize (self);
#line 284 "/home/jens/Source/shotwell/src/Exporter.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2833 "Exporter.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



