/* CheckerboardLayout.c generated by valac 0.32.1, the Vala compiler
 * generated from CheckerboardLayout.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pangocairo.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CHECKERBOARD_ITEM_TEXT (checkerboard_item_text_get_type ())
#define CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText))
#define CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))
#define IS_CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM_TEXT))
#define IS_CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM_TEXT))
#define CHECKERBOARD_ITEM_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))

typedef struct _CheckerboardItemText CheckerboardItemText;
typedef struct _CheckerboardItemTextClass CheckerboardItemTextClass;
typedef struct _CheckerboardItemTextPrivate CheckerboardItemTextPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _ParamSpecCheckerboardItemText ParamSpecCheckerboardItemText;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _checkerboard_item_text_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_item_text_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

#define TYPE_CHECKERBOARD_LAYOUT (checkerboard_layout_get_type ())
#define CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout))
#define CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))
#define IS_CHECKERBOARD_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_LAYOUT))
#define IS_CHECKERBOARD_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_LAYOUT))
#define CHECKERBOARD_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutClass))

typedef struct _CheckerboardLayout CheckerboardLayout;
typedef struct _CheckerboardLayoutClass CheckerboardLayoutClass;
typedef struct _CheckerboardLayoutPrivate CheckerboardLayoutPrivate;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW (checkerboard_layout_layout_row_get_type ())
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_IS_LAYOUT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW))
#define CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRowClass))

typedef struct _CheckerboardLayoutLayoutRow CheckerboardLayoutLayoutRow;
typedef struct _CheckerboardLayoutLayoutRowClass CheckerboardLayoutLayoutRowClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _CheckerboardLayoutLayoutRowPrivate CheckerboardLayoutLayoutRowPrivate;
#define _checkerboard_layout_layout_row_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_layout_layout_row_unref (var), NULL)))

#define TYPE_COMPASS_POINT (compass_point_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
typedef struct _CheckerboardLayoutParamSpecLayoutRow CheckerboardLayoutParamSpecLayoutRow;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CheckerboardItemText {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardItemTextPrivate * priv;
	GdkRectangle allocation;
};

struct _CheckerboardItemTextClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardItemText *self);
};

struct _CheckerboardItemTextPrivate {
	gchar* text;
	gboolean marked_up;
	PangoAlignment alignment;
	PangoLayout* layout;
	gboolean single_line;
	gint height;
};

struct _ParamSpecCheckerboardItemText {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _CheckerboardItemPrivate {
	gboolean exposure;
	CheckerboardItemText* title;
	gboolean title_visible;
	CheckerboardItemText* comment;
	gboolean comment_visible;
	CheckerboardItemText* subtitle;
	gboolean subtitle_visible;
	gboolean is_cursor;
	GdkPixbuf* pixbuf;
	GdkPixbuf* display_pixbuf;
	GdkPixbuf* brightened;
	Dimensions pixbuf_dim;
	gint col;
	gint row;
	gint horizontal_trinket_offset;
};

struct _CheckerboardLayout {
	GtkDrawingArea parent_instance;
	CheckerboardLayoutPrivate * priv;
};

struct _CheckerboardLayoutClass {
	GtkDrawingAreaClass parent_class;
};

struct _CheckerboardLayoutPrivate {
	ViewCollection* view;
	gchar* page_name;
	CheckerboardLayoutLayoutRow** item_rows;
	gint item_rows_length1;
	gint _item_rows_size_;
	GeeHashSet* exposed_items;
	GtkAdjustment* hadjustment;
	GtkAdjustment* vadjustment;
	gchar* message;
	GdkRGBA selected_color;
	GdkRGBA unselected_color;
	GdkRGBA border_color;
	GdkRGBA bg_color;
	GdkRectangle visible_page;
	gint last_width;
	gint columns;
	gint rows;
	GdkPoint drag_origin;
	GdkPoint drag_endpoint;
	GdkRectangle selection_band;
	gint scale;
	gboolean flow_scheduled;
	gboolean exposure_dirty;
	CheckerboardItem* anchor;
	CheckerboardItem* cursor;
	gboolean in_center_on_anchor;
	gboolean size_allocate_due_to_reflow;
	gboolean is_in_view;
	gboolean reflow_needed;
};

struct _CheckerboardLayoutLayoutRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardLayoutLayoutRowPrivate * priv;
	gint y;
	gint height;
	CheckerboardItem** items;
	gint items_length1;
	gint _items_size_;
};

struct _CheckerboardLayoutLayoutRowClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardLayoutLayoutRow *self);
};

typedef enum  {
	COMPASS_POINT_NORTH,
	COMPASS_POINT_SOUTH,
	COMPASS_POINT_EAST,
	COMPASS_POINT_WEST
} CompassPoint;

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _CheckerboardLayoutParamSpecLayoutRow {
	GParamSpec parent_instance;
};


static gpointer checkerboard_item_text_parent_class = NULL;
static gint checkerboard_item_text_one_line_height;
static gint checkerboard_item_text_one_line_height = 0;
static gpointer checkerboard_item_parent_class = NULL;
static gpointer checkerboard_layout_parent_class = NULL;
static gpointer checkerboard_layout_layout_row_parent_class = NULL;

gpointer checkerboard_item_text_ref (gpointer instance);
void checkerboard_item_text_unref (gpointer instance);
GParamSpec* param_spec_checkerboard_item_text (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_checkerboard_item_text (GValue* value, gpointer v_object);
void value_take_checkerboard_item_text (GValue* value, gpointer v_object);
gpointer value_get_checkerboard_item_text (const GValue* value);
GType checkerboard_item_text_get_type (void) G_GNUC_CONST;
#define CHECKERBOARD_ITEM_TEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextPrivate))
enum  {
	CHECKERBOARD_ITEM_TEXT_DUMMY_PROPERTY
};
CheckerboardItemText* checkerboard_item_text_new (const gchar* text, PangoAlignment alignment, gboolean marked_up);
CheckerboardItemText* checkerboard_item_text_construct (GType object_type, const gchar* text, PangoAlignment alignment, gboolean marked_up);
static gboolean checkerboard_item_text_is_single_line (CheckerboardItemText* self);
gboolean string_contains_char (const gchar* haystack, gunichar needle);
gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self);
gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
gchar* checkerboard_item_text_get_text (CheckerboardItemText* self);
gint checkerboard_item_text_get_height (CheckerboardItemText* self);
static void checkerboard_item_text_update_height (CheckerboardItemText* self);
PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self, gint max_width);
static void checkerboard_item_text_create_pango (CheckerboardItemText* self);
void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
static void checkerboard_item_text_finalize (CheckerboardItemText* obj);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
#define CHECKERBOARD_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_ITEM, CheckerboardItemPrivate))
enum  {
	CHECKERBOARD_ITEM_DUMMY_PROPERTY
};
void dimensions_init (Dimensions *self, gint width, gint height);
#define CHECKERBOARD_ITEM_PROP_SHOW_TITLES "show-titles"
#define CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS "show-comments"
#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define CHECKERBOARD_ITEM_FRAME_WIDTH 8
#define CHECKERBOARD_ITEM_LABEL_PADDING 4
#define CHECKERBOARD_ITEM_BORDER_WIDTH 1
#define CHECKERBOARD_ITEM_SHADOW_RADIUS 4
#define CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA 0.5f
#define CHECKERBOARD_ITEM_TRINKET_SCALE 12
#define CHECKERBOARD_ITEM_TRINKET_PADDING 1
#define CHECKERBOARD_ITEM_BRIGHTEN_SHIFT 0x18
GType thumbnail_source_get_type (void) G_GNUC_CONST;
CheckerboardItem* checkerboard_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
ThumbnailView* thumbnail_view_new (ThumbnailSource* source);
ThumbnailView* thumbnail_view_construct (GType object_type, ThumbnailSource* source);
static gchar* checkerboard_item_real_get_name (DataObject* base);
gchar* data_object_get_name (DataObject* self);
gchar* checkerboard_item_get_title (CheckerboardItem* self);
gchar* checkerboard_item_get_comment (CheckerboardItem* self);
void checkerboard_item_set_title (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void checkerboard_item_recalc_size (CheckerboardItem* self, const gchar* reason);
void data_view_notify_view_altered (DataView* self);
void checkerboard_item_clear_title (CheckerboardItem* self);
static void checkerboard_item_set_title_visible (CheckerboardItem* self, gboolean visible);
void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
void checkerboard_item_clear_comment (CheckerboardItem* self);
static void checkerboard_item_set_comment_visible (CheckerboardItem* self, gboolean visible);
gchar* checkerboard_item_get_subtitle (CheckerboardItem* self);
void checkerboard_item_set_subtitle (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
void checkerboard_item_clear_subtitle (CheckerboardItem* self);
static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self, gboolean visible);
void checkerboard_item_set_is_cursor (CheckerboardItem* self, gboolean is_cursor);
gboolean checkerboard_item_get_is_cusor (CheckerboardItem* self);
static void checkerboard_item_real_notify_membership_changed (DataObject* base, DataCollection* collection);
GValue* data_object_get_collection_property (DataObject* self, const gchar* name, GValue* def);
static void _vala_GValue_free (GValue* self);
gboolean dimensions_has_area (Dimensions *self);
void data_object_notify_membership_changed (DataObject* self, DataCollection* collection);
static void checkerboard_item_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val);
void data_object_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val);
gint checkerboard_item_get_alignment_point (CheckerboardItem* self);
void checkerboard_item_exposed (CheckerboardItem* self);
static void checkerboard_item_real_exposed (CheckerboardItem* self);
void checkerboard_item_unexposed (CheckerboardItem* self);
static void checkerboard_item_real_unexposed (CheckerboardItem* self);
gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self);
gboolean checkerboard_item_has_image (CheckerboardItem* self);
GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim);
gint checkerboard_item_get_max_width (gint scale);
gboolean dimensions_approx_equals (Dimensions *self, Dimensions* dim, gint fudge);
void data_view_notify_geometry_altered (DataView* self);
void checkerboard_item_get_border_dimensions (Dimensions* object_dim, gint border_width, Dimensions* result);
void checkerboard_item_get_border_origin (GdkPoint* object_origin, gint border_width, GdkPoint* result);
void checkerboard_item_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
static void checkerboard_item_real_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
void checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self, cairo_t* ctx, gint x, gint y, gdouble rgb_all, gfloat radius, gfloat initial_alpha, gdouble arc1, gdouble arc2);
void checkerboard_item_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
static void checkerboard_item_real_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
void draw_rounded_corners_filled (cairo_t* ctx, Dimensions* dim, GdkPoint* origin, gdouble radius_proportion);
void checkerboard_item_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
static void checkerboard_item_real_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
static gint checkerboard_item_get_selection_border_width (CheckerboardItem* self, gint scale);
gint thumbnail_get_MIN_SCALE (void);
gint thumbnail_get_MAX_SCALE (void);
GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self, gint scale);
GdkPixbuf* checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self, gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self, gint scale);
void checkerboard_item_paint (CheckerboardItem* self, cairo_t* ctx, GdkRGBA* bg_color, GdkRGBA* selected_color, GdkRGBA* text_color, GdkRGBA* border_color);
gboolean data_view_is_selected (DataView* self);
gint checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self);
void checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self, gint horizontal_trinket_offset);
void checkerboard_item_set_grid_coordinates (CheckerboardItem* self, gint col, gint row);
gint checkerboard_item_get_column (CheckerboardItem* self);
gint checkerboard_item_get_row (CheckerboardItem* self);
void checkerboard_item_brighten (CheckerboardItem* self);
void shift_colors (GdkPixbuf* pixbuf, gint red, gint green, gint blue, gint alpha);
void checkerboard_item_unbrighten (CheckerboardItem* self);
static void checkerboard_item_real_visibility_changed (DataView* base, gboolean visible);
static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self, CheckerboardItemText* text, GtkTooltip* tooltip);
gboolean checkerboard_item_query_tooltip (CheckerboardItem* self, gint x, gint y, GtkTooltip* tooltip);
gboolean coord_in_rectangle (gint x, gint y, GdkRectangle* rect);
static void checkerboard_item_finalize (GObject* obj);
GType checkerboard_layout_get_type (void) G_GNUC_CONST;
GType view_collection_get_type (void) G_GNUC_CONST;
static gpointer checkerboard_layout_layout_row_ref (gpointer instance);
static void checkerboard_layout_layout_row_unref (gpointer instance);
static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void checkerboard_layout_value_set_layout_row (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void checkerboard_layout_value_take_layout_row (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) G_GNUC_UNUSED;
static GType checkerboard_layout_layout_row_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define CHECKERBOARD_LAYOUT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayoutPrivate))
enum  {
	CHECKERBOARD_LAYOUT_DUMMY_PROPERTY
};
static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self, GeeIterable* added, GeeIterable* removed);
static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender, GeeIterable* added, GeeIterable* removed, gpointer self);
static void checkerboard_layout_on_items_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self, GeeIterable* changed);
static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender, GeeIterable* changed, gpointer self);
static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self, GeeIterable* changed);
static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender, GeeCollection* changed, gpointer self);
static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender, gpointer self);
static void checkerboard_layout_on_views_altered (CheckerboardLayout* self, GeeCollection* altered);
static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender, GeeCollection* views, gpointer self);
static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self);
static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender, GeeCollection* views, gpointer self);
static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender, GeeIterable* selected, gpointer self);
static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender, GeeIterable* unselected, gpointer self);
static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self);
static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
static void checkerboard_layout_on_colors_changed (CheckerboardLayout* self);
static void _checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender, gpointer self);
#define CHECKERBOARD_LAYOUT_TOP_PADDING 16
#define CHECKERBOARD_LAYOUT_BOTTOM_PADDING 16
#define CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING 24
#define CHECKERBOARD_LAYOUT_SELECTION_ALPHA 0.40
#define CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH 1
CheckerboardLayout* checkerboard_layout_new (ViewCollection* view);
CheckerboardLayout* checkerboard_layout_construct (GType object_type, ViewCollection* view);
void checkerboard_layout_clear_drag_select (CheckerboardLayout* self);
void config_facade_get_bg_color (ConfigFacade* self, GdkRGBA* result);
void checkerboard_layout_set_adjustments (CheckerboardLayout* self, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment);
void checkerboard_layout_set_scale (CheckerboardLayout* self, gint scale);
gint checkerboard_layout_get_scale (CheckerboardLayout* self);
void checkerboard_layout_set_name (CheckerboardLayout* self, const gchar* name);
static void checkerboard_layout_viewport_resized (CheckerboardLayout* self);
static void checkerboard_layout_clear_anchor (CheckerboardLayout* self);
static void checkerboard_layout_update_visible_page (CheckerboardLayout* self);
static void checkerboard_layout_need_exposure (CheckerboardLayout* self, const gchar* caller);
static void checkerboard_layout_update_anchor (CheckerboardLayout* self);
GeeList* checkerboard_layout_intersection (CheckerboardLayout* self, GdkRectangle* area);
static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self, gdouble upper);
void checkerboard_layout_set_cursor (CheckerboardLayout* self, CheckerboardItem* item);
gboolean data_collection_contains (DataCollection* self, DataObject* object);
CheckerboardItem* checkerboard_layout_get_cursor (CheckerboardLayout* self);
static void checkerboard_layout_need_reflow (CheckerboardLayout* self, const gchar* caller);
static void checkerboard_layout_items_dirty (CheckerboardLayout* self, const gchar* reason, GeeIterable* items);
static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self);
static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self);
static void checkerboard_layout_reflow (CheckerboardLayout* self, const gchar* caller);
void checkerboard_layout_set_message (CheckerboardLayout* self, const gchar* text);
void checkerboard_layout_unset_message (CheckerboardLayout* self);
void get_adjustment_page (GtkAdjustment* hadj, GtkAdjustment* vadj, GdkRectangle* result);
void checkerboard_layout_set_in_view (CheckerboardLayout* self, gboolean in_view);
static void checkerboard_layout_unexpose_items (CheckerboardLayout* self, const gchar* caller);
CheckerboardItem* checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self, gdouble xd, gdouble yd);
GeeList* checkerboard_layout_get_visible_items (CheckerboardLayout* self);
GType compass_point_get_type (void) G_GNUC_CONST;
CheckerboardItem* checkerboard_layout_get_item_relative_to (CheckerboardLayout* self, CheckerboardItem* item, CompassPoint point);
gint data_collection_get_count (DataCollection* self);
CheckerboardItem* checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self, gint col, gint row);
DataView* view_collection_get_last (ViewCollection* self);
void checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self, gint x, gint y);
void checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self, gint x, gint y);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
void box_from_points (GdkPoint* corner1, GdkPoint* corner2, Box* result);
void box_get_rectangle (Box *self, GdkRectangle* result);
GeeList* checkerboard_layout_items_in_selection_band (CheckerboardLayout* self);
void dimensions_for_rectangle (GdkRectangle* rect, Dimensions* result);
gboolean checkerboard_layout_is_drag_select_active (CheckerboardLayout* self);
static void checkerboard_layout_expose_items (CheckerboardLayout* self, const gchar* caller);
void data_collection_freeze_notifications (DataCollection* self);
void data_collection_thaw_notifications (DataCollection* self);
gboolean data_view_is_visible (DataView* self);
DataObject* data_collection_get_at (DataCollection* self, gint index);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y, gint height, gint num_in_row);
static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type, gint y, gint height, gint num_in_row);
static void checkerboard_layout_real_map (GtkWidget* base);
static void checkerboard_layout_set_colors (CheckerboardLayout* self, gboolean in_focus);
void config_facade_get_selected_color (ConfigFacade* self, gboolean in_focus, GdkRGBA* result);
void config_facade_get_unselected_color (ConfigFacade* self, GdkRGBA* result);
void config_facade_get_border_color (ConfigFacade* self, GdkRGBA* result);
static void checkerboard_layout_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static gboolean checkerboard_layout_real_draw (GtkWidget* base, cairo_t* ctx);
static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self, cairo_t* ctx);
static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip);
static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base, GdkEventFocus* event);
GeeList* view_collection_get_selected (ViewCollection* self);
static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base, GdkEventFocus* event);
enum  {
	CHECKERBOARD_LAYOUT_LAYOUT_ROW_DUMMY_PROPERTY
};
static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow* obj);
static void checkerboard_layout_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


CheckerboardItemText* checkerboard_item_text_construct (GType object_type, const gchar* text, PangoAlignment alignment, gboolean marked_up) {
	CheckerboardItemText* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	PangoAlignment _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardItemText*) g_type_create_instance (object_type);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->text);
#line 21 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->text = _tmp1_;
#line 22 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = marked_up;
#line 22 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->marked_up = _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = alignment;
#line 23 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->alignment = _tmp3_;
#line 25 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = checkerboard_item_text_is_single_line (self);
#line 25 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->single_line = _tmp4_;
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 708 "CheckerboardLayout.c"
}


CheckerboardItemText* checkerboard_item_text_new (const gchar* text, PangoAlignment alignment, gboolean marked_up) {
#line 19 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_item_text_construct (TYPE_CHECKERBOARD_ITEM_TEXT, text, alignment, marked_up);
#line 715 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_text_is_single_line (CheckerboardItemText* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 28 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->text;
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = string_contains_char (_tmp0_, (gunichar) '\n');
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = !_tmp1_;
#line 29 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 733 "CheckerboardLayout.c"
}


gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 32 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->marked_up;
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 33 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 748 "CheckerboardLayout.c"
}


gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 36 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), FALSE);
#line 36 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->marked_up;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = marked_up;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ == _tmp3_) {
#line 768 "CheckerboardLayout.c"
		PangoAlignment _tmp4_ = 0;
		PangoAlignment _tmp5_ = 0;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->alignment;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp4_ == _tmp5_;
#line 777 "CheckerboardLayout.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 781 "CheckerboardLayout.c"
	}
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 785 "CheckerboardLayout.c"
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->text;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = text;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
#line 794 "CheckerboardLayout.c"
	} else {
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 798 "CheckerboardLayout.c"
	}
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 804 "CheckerboardLayout.c"
}


gchar* checkerboard_item_text_get_text (CheckerboardItemText* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 40 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), NULL);
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->text;
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 822 "CheckerboardLayout.c"
}


gint checkerboard_item_text_get_height (CheckerboardItemText* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 44 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), 0);
#line 45 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->height;
#line 45 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == 0) {
#line 46 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_update_height (self);
#line 838 "CheckerboardLayout.c"
	}
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->height;
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 846 "CheckerboardLayout.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? g_object_ref (self) : NULL;
#line 853 "CheckerboardLayout.c"
}


PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self, gint max_width) {
	PangoLayout* result = NULL;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	PangoLayout* _tmp4_ = NULL;
	PangoLayout* _tmp5_ = NULL;
#line 51 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self), NULL);
#line 52 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->layout;
#line 52 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 53 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_create_pango (self);
#line 871 "CheckerboardLayout.c"
	}
#line 55 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = max_width;
#line 55 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ > 0) {
#line 877 "CheckerboardLayout.c"
		PangoLayout* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->layout;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = max_width;
#line 56 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_width (_tmp2_, _tmp3_ * PANGO_SCALE);
#line 886 "CheckerboardLayout.c"
	}
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->layout;
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp5_;
#line 58 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 896 "CheckerboardLayout.c"
}


void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self) {
#line 61 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 62 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 62 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = NULL;
#line 907 "CheckerboardLayout.c"
}


static void checkerboard_item_text_update_height (CheckerboardItemText* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
#line 65 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_text_one_line_height;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != 0) {
#line 920 "CheckerboardLayout.c"
		gboolean _tmp2_ = FALSE;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->single_line;
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_;
#line 926 "CheckerboardLayout.c"
	} else {
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 930 "CheckerboardLayout.c"
	}
#line 66 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 934 "CheckerboardLayout.c"
		gint _tmp3_ = 0;
#line 67 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_one_line_height;
#line 67 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp3_;
#line 940 "CheckerboardLayout.c"
	} else {
#line 69 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_create_pango (self);
#line 944 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_text_create_pango (CheckerboardItemText* self) {
	AppWindow* _tmp0_ = NULL;
	AppWindow* _tmp1_ = NULL;
	PangoLayout* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	PangoLayout* _tmp8_ = NULL;
	PangoLayout* _tmp9_ = NULL;
	PangoAlignment _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
#line 72 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM_TEXT (self));
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = app_window_get_instance ();
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), NULL);
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = _tmp2_;
#line 74 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 75 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->marked_up;
#line 75 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp3_) {
#line 977 "CheckerboardLayout.c"
		PangoLayout* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->layout;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->text;
#line 76 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_text (_tmp4_, _tmp5_, -1);
#line 986 "CheckerboardLayout.c"
	} else {
		PangoLayout* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->layout;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->text;
#line 78 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_set_markup (_tmp6_, _tmp7_, -1);
#line 996 "CheckerboardLayout.c"
	}
#line 80 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->layout;
#line 80 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pango_layout_set_ellipsize (_tmp8_, PANGO_ELLIPSIZE_END);
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->layout;
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->alignment;
#line 81 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pango_layout_set_alignment (_tmp9_, _tmp10_);
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = checkerboard_item_text_one_line_height;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ != 0) {
#line 1012 "CheckerboardLayout.c"
		gboolean _tmp13_ = FALSE;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = self->priv->single_line;
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = _tmp13_;
#line 1018 "CheckerboardLayout.c"
	} else {
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = FALSE;
#line 1022 "CheckerboardLayout.c"
	}
#line 85 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 1026 "CheckerboardLayout.c"
		gint _tmp14_ = 0;
#line 86 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = checkerboard_item_text_one_line_height;
#line 86 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp14_;
#line 1032 "CheckerboardLayout.c"
	} else {
		gint width = 0;
		PangoLayout* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean _tmp18_ = FALSE;
		gint _tmp19_ = 0;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = self->priv->layout;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_get_pixel_size (_tmp15_, &_tmp16_, &_tmp17_);
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		width = _tmp16_;
#line 89 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->height = _tmp17_;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = checkerboard_item_text_one_line_height;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp19_ == 0) {
#line 1052 "CheckerboardLayout.c"
			gboolean _tmp20_ = FALSE;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp20_ = self->priv->single_line;
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = _tmp20_;
#line 1058 "CheckerboardLayout.c"
		} else {
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = FALSE;
#line 1062 "CheckerboardLayout.c"
		}
#line 92 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp18_) {
#line 1066 "CheckerboardLayout.c"
			gint _tmp21_ = 0;
#line 93 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = self->priv->height;
#line 93 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_text_one_line_height = _tmp21_;
#line 1072 "CheckerboardLayout.c"
		}
	}
}


static void value_checkerboard_item_text_init (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	value->data[0].v_pointer = NULL;
#line 1081 "CheckerboardLayout.c"
}


static void value_checkerboard_item_text_free_value (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (value->data[0].v_pointer);
#line 1090 "CheckerboardLayout.c"
	}
}


static void value_checkerboard_item_text_copy_value (const GValue* src_value, GValue* dest_value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = checkerboard_item_text_ref (src_value->data[0].v_pointer);
#line 1100 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1104 "CheckerboardLayout.c"
	}
}


static gpointer value_checkerboard_item_text_peek_pointer (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 1112 "CheckerboardLayout.c"
}


static gchar* value_checkerboard_item_text_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (collect_values[0].v_pointer) {
#line 1119 "CheckerboardLayout.c"
		CheckerboardItemText* object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1126 "CheckerboardLayout.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1130 "CheckerboardLayout.c"
		}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = checkerboard_item_text_ref (object);
#line 1134 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1138 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 1142 "CheckerboardLayout.c"
}


static gchar* value_checkerboard_item_text_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CheckerboardItemText** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1153 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = NULL;
#line 1159 "CheckerboardLayout.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = value->data[0].v_pointer;
#line 1163 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = checkerboard_item_text_ref (value->data[0].v_pointer);
#line 1167 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 1171 "CheckerboardLayout.c"
}


GParamSpec* param_spec_checkerboard_item_text (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCheckerboardItemText* spec;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHECKERBOARD_ITEM_TEXT), NULL);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return G_PARAM_SPEC (spec);
#line 1185 "CheckerboardLayout.c"
}


gpointer value_get_checkerboard_item_text (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT), NULL);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 1194 "CheckerboardLayout.c"
}


void value_set_checkerboard_item_text (GValue* value, gpointer v_object) {
	CheckerboardItemText* old;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_ref (value->data[0].v_pointer);
#line 1214 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1218 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (old);
#line 1224 "CheckerboardLayout.c"
	}
}


void value_take_checkerboard_item_text (GValue* value, gpointer v_object) {
	CheckerboardItemText* old;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHECKERBOARD_ITEM_TEXT));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 1243 "CheckerboardLayout.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 1247 "CheckerboardLayout.c"
	}
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_unref (old);
#line 1253 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_text_class_init (CheckerboardItemTextClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_text_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemTextClass *) klass)->finalize = checkerboard_item_text_finalize;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardItemTextPrivate));
#line 1265 "CheckerboardLayout.c"
}


static void checkerboard_item_text_instance_init (CheckerboardItemText * self) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_ITEM_TEXT_GET_PRIVATE (self);
#line 13 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->layout = NULL;
#line 14 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->single_line = TRUE;
#line 15 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->height = 0;
#line 17 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->allocation, 0, sizeof (GdkRectangle));
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->ref_count = 1;
#line 1282 "CheckerboardLayout.c"
}


static void checkerboard_item_text_finalize (CheckerboardItemText* obj) {
	CheckerboardItemText * self;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_destroy (self);
#line 10 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->text);
#line 13 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->layout);
#line 1296 "CheckerboardLayout.c"
}


GType checkerboard_item_text_get_type (void) {
	static volatile gsize checkerboard_item_text_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_item_text_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_checkerboard_item_text_init, value_checkerboard_item_text_free_value, value_checkerboard_item_text_copy_value, value_checkerboard_item_text_peek_pointer, "p", value_checkerboard_item_text_collect_value, "p", value_checkerboard_item_text_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemTextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_text_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItemText), 0, (GInstanceInitFunc) checkerboard_item_text_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType checkerboard_item_text_type_id;
		checkerboard_item_text_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardItemText", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&checkerboard_item_text_type_id__volatile, checkerboard_item_text_type_id);
	}
	return checkerboard_item_text_type_id__volatile;
}


gpointer checkerboard_item_text_ref (gpointer instance) {
	CheckerboardItemText* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return instance;
#line 1321 "CheckerboardLayout.c"
}


void checkerboard_item_text_unref (gpointer instance) {
	CheckerboardItemText* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		CHECKERBOARD_ITEM_TEXT_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1334 "CheckerboardLayout.c"
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1380 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1380 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1380 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1348 "CheckerboardLayout.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1379 "CheckerboardLayout.c"
				goto __catch227_g_regex_error;
			}
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1382 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			return NULL;
#line 1388 "CheckerboardLayout.c"
		}
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1404 "CheckerboardLayout.c"
				goto __catch227_g_regex_error;
			}
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
			return NULL;
#line 1415 "CheckerboardLayout.c"
		}
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		return result;
#line 1429 "CheckerboardLayout.c"
	}
	goto __finally227;
	__catch227_g_regex_error:
	{
		GError* e = NULL;
#line 1381 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1381 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1385 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1381 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1443 "CheckerboardLayout.c"
	}
	__finally227:
#line 1381 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1381 "/usr/share/vala-0.32/vapi/glib-2.0.vapi"
		return NULL;
#line 1454 "CheckerboardLayout.c"
	}
}


CheckerboardItem* checkerboard_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment) {
	CheckerboardItem * self = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	PangoAlignment _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	CheckerboardItemText* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (initial_pixbuf_dim != NULL, NULL);
#line 138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = source;
#line 140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardItem*) thumbnail_view_construct (object_type, _tmp0_);
#line 142 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *initial_pixbuf_dim;
#line 142 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp1_;
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = title;
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = alignment;
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = marked_up;
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_item_text_new (_tmp2_, _tmp3_, _tmp4_);
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = _tmp5_;
#line 149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = comment;
#line 149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ != NULL) {
#line 1498 "CheckerboardLayout.c"
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		PangoAlignment _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		CheckerboardItemText* _tmp12_ = NULL;
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = comment;
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = string_replace (_tmp7_, "\n", " ");
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = _tmp8_;
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = alignment;
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = marked_up;
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_text_new (_tmp9_, _tmp10_, _tmp11_);
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_item_text_unref0 (self->priv->comment);
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->comment = _tmp12_;
#line 150 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp9_);
#line 1523 "CheckerboardLayout.c"
	}
#line 138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 1527 "CheckerboardLayout.c"
}


static gchar* checkerboard_item_real_get_name (DataObject* base) {
	CheckerboardItem * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1542 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1553 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = DATA_OBJECT_CLASS (checkerboard_item_parent_class)->get_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject));
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1562 "CheckerboardLayout.c"
	}
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 159 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1568 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_title (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1582 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1593 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1602 "CheckerboardLayout.c"
	}
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 163 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1608 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_comment (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment;
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1622 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->comment;
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1633 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1642 "CheckerboardLayout.c"
	}
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 167 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1648 "CheckerboardLayout.c"
}


void checkerboard_item_set_title (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_ = NULL;
	const gchar* _tmp7_ = NULL;
	PangoAlignment _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	CheckerboardItemText* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 170 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 170 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1668 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		PangoAlignment _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->title;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 1686 "CheckerboardLayout.c"
	} else {
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1690 "CheckerboardLayout.c"
	}
#line 172 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 173 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1696 "CheckerboardLayout.c"
	}
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = alignment;
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = marked_up;
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = checkerboard_item_text_new (_tmp7_, _tmp8_, _tmp9_);
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 175 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = _tmp10_;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->title_visible;
#line 177 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_title");
#line 179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1718 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_title (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title;
#line 184 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 185 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1734 "CheckerboardLayout.c"
	}
#line 187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = NULL;
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->title_visible;
#line 189 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_title");
#line 191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1748 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_title_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 195 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title_visible;
#line 196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1767 "CheckerboardLayout.c"
	}
#line 199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title_visible = _tmp2_;
#line 201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_title_visible");
#line 202 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1777 "CheckerboardLayout.c"
}


void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	PangoAlignment _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	CheckerboardItemText* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 205 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 205 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment;
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1799 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		PangoAlignment _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->comment;
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 1817 "CheckerboardLayout.c"
	} else {
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1821 "CheckerboardLayout.c"
	}
#line 207 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 208 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1827 "CheckerboardLayout.c"
	}
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = string_replace (_tmp7_, "\n", " ");
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_;
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = alignment;
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = marked_up;
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = checkerboard_item_text_new (_tmp9_, _tmp10_, _tmp11_);
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = _tmp12_;
#line 210 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (_tmp9_);
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = self->priv->comment_visible;
#line 212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 213 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_comment");
#line 214 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1855 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_comment (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 219 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->comment;
#line 219 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1871 "CheckerboardLayout.c"
	}
#line 222 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 222 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = NULL;
#line 224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->comment_visible;
#line 224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 225 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_comment");
#line 226 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1885 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_comment_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 231 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->comment_visible;
#line 231 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 231 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 232 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 1904 "CheckerboardLayout.c"
	}
#line 234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment_visible = _tmp2_;
#line 236 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_comment_visible");
#line 237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 1914 "CheckerboardLayout.c"
}


gchar* checkerboard_item_get_subtitle (CheckerboardItem* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_ = NULL;
#line 241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle;
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1928 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp3_;
#line 1939 "CheckerboardLayout.c"
	} else {
		gchar* _tmp4_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = g_strdup ("");
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp0_);
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_;
#line 1948 "CheckerboardLayout.c"
	}
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 242 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 1954 "CheckerboardLayout.c"
}


void checkerboard_item_set_subtitle (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment) {
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_ = NULL;
	const gchar* _tmp7_ = NULL;
	PangoAlignment _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	CheckerboardItemText* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
#line 245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 245 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text != NULL);
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1974 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		PangoAlignment _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->subtitle;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = text;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = marked_up;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = alignment;
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_is_set_to (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp6_;
#line 1992 "CheckerboardLayout.c"
	} else {
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 1996 "CheckerboardLayout.c"
	}
#line 247 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 248 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2002 "CheckerboardLayout.c"
	}
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = text;
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = alignment;
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = marked_up;
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = checkerboard_item_text_new (_tmp7_, _tmp8_, _tmp9_);
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 250 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = _tmp10_;
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->subtitle_visible;
#line 252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp11_) {
#line 253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "set_subtitle");
#line 254 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2024 "CheckerboardLayout.c"
	}
}


void checkerboard_item_clear_subtitle (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle;
#line 259 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 260 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2040 "CheckerboardLayout.c"
	}
#line 262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = NULL;
#line 264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->subtitle_visible;
#line 264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 265 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "clear_subtitle");
#line 266 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2054 "CheckerboardLayout.c"
	}
}


static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 270 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->subtitle_visible;
#line 271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 271 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == _tmp1_) {
#line 272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 2073 "CheckerboardLayout.c"
	}
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = visible;
#line 274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle_visible = _tmp2_;
#line 276 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_subtitle_visible");
#line 277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2083 "CheckerboardLayout.c"
}


void checkerboard_item_set_is_cursor (CheckerboardItem* self, gboolean is_cursor) {
	gboolean _tmp0_ = FALSE;
#line 280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = is_cursor;
#line 281 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_cursor = _tmp0_;
#line 2095 "CheckerboardLayout.c"
}


gboolean checkerboard_item_get_is_cusor (CheckerboardItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 284 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->is_cursor;
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 285 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2110 "CheckerboardLayout.c"
}


static void _vala_GValue_free (GValue* self) {
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_unset (self);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_free (self);
#line 2119 "CheckerboardLayout.c"
}


static void checkerboard_item_real_notify_membership_changed (DataObject* base, DataCollection* collection) {
	CheckerboardItem * self;
	gboolean title_visible = FALSE;
	GValue* _tmp0_ = NULL;
	GValue* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean comment_visible = FALSE;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean subtitle_visible = FALSE;
	GValue* _tmp6_ = NULL;
	GValue* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean altered = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	DataCollection* _tmp21_ = NULL;
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_new0 (GValue, 1);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp0_, G_TYPE_BOOLEAN);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp0_, TRUE);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_TITLES, _tmp0_);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = g_value_get_boolean (_tmp1_);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp0_);
#line 289 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	title_visible = _tmp2_;
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_new0 (GValue, 1);
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp3_, G_TYPE_BOOLEAN);
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp3_, TRUE);
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS, _tmp3_);
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = g_value_get_boolean (_tmp4_);
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp3_);
#line 290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	comment_visible = _tmp5_;
#line 291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = g_new0 (GValue, 1);
#line 291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_init (_tmp6_, G_TYPE_BOOLEAN);
#line 291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_value_set_boolean (_tmp6_, FALSE);
#line 291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES, _tmp6_);
#line 291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = g_value_get_boolean (_tmp7_);
#line 291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	__vala_GValue_free0 (_tmp6_);
#line 291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	subtitle_visible = _tmp8_;
#line 293 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	altered = FALSE;
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->title_visible;
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = title_visible;
#line 294 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ != _tmp10_) {
#line 2201 "CheckerboardLayout.c"
		gboolean _tmp11_ = FALSE;
#line 295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = title_visible;
#line 295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->title_visible = _tmp11_;
#line 296 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2209 "CheckerboardLayout.c"
	}
#line 299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->comment_visible;
#line 299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = comment_visible;
#line 299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ != _tmp13_) {
#line 2217 "CheckerboardLayout.c"
		gboolean _tmp14_ = FALSE;
#line 300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = comment_visible;
#line 300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->comment_visible = _tmp14_;
#line 301 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2225 "CheckerboardLayout.c"
	}
#line 304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle_visible;
#line 304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = subtitle_visible;
#line 304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != _tmp16_) {
#line 2233 "CheckerboardLayout.c"
		gboolean _tmp17_ = FALSE;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = subtitle_visible;
#line 305 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->subtitle_visible = _tmp17_;
#line 306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		altered = TRUE;
#line 2241 "CheckerboardLayout.c"
	}
#line 309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = altered;
#line 309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp19_) {
#line 309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = TRUE;
#line 2249 "CheckerboardLayout.c"
	} else {
		gboolean _tmp20_ = FALSE;
#line 309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = dimensions_has_area (&self->requisition);
#line 309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = !_tmp20_;
#line 2256 "CheckerboardLayout.c"
	}
#line 309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_) {
#line 310 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_recalc_size (self, "notify_membership_changed");
#line 311 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2264 "CheckerboardLayout.c"
	}
#line 314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = collection;
#line 314 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), _tmp21_);
#line 2270 "CheckerboardLayout.c"
}


static void checkerboard_item_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val) {
	CheckerboardItem * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	const gchar* _tmp7_ = NULL;
	GValue* _tmp8_ = NULL;
	GValue _tmp9_ = {0};
#line 317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (name != NULL);
#line 317 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (val != NULL);
#line 318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = name;
#line 318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_TITLES)) {
#line 318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2298 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp4_ = {0};
#line 320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = *val;
#line 320 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_title_visible (self, g_value_get_boolean (&_tmp4_));
#line 321 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2308 "CheckerboardLayout.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS)) {
#line 318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2314 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp5_ = {0};
#line 324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = *val;
#line 324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_comment_visible (self, g_value_get_boolean (&_tmp5_));
#line 325 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2324 "CheckerboardLayout.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES)) {
#line 318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		switch (0) {
#line 2330 "CheckerboardLayout.c"
			default:
			{
				GValue _tmp6_ = {0};
#line 328 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = *val;
#line 328 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_subtitle_visible (self, g_value_get_boolean (&_tmp6_));
#line 329 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 2340 "CheckerboardLayout.c"
			}
		}
	}
#line 332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = name;
#line 332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = old;
#line 332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = *val;
#line 332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), _tmp7_, _tmp8_, &_tmp9_);
#line 2352 "CheckerboardLayout.c"
}


gint checkerboard_item_get_alignment_point (CheckerboardItem* self) {
	gint result = 0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
#line 338 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf_dim;
#line 339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.height;
#line 339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH + CHECKERBOARD_ITEM_BORDER_WIDTH) + _tmp1_;
#line 339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2370 "CheckerboardLayout.c"
}


static void checkerboard_item_real_exposed (CheckerboardItem* self) {
#line 343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = TRUE;
#line 2377 "CheckerboardLayout.c"
}


void checkerboard_item_exposed (CheckerboardItem* self) {
#line 342 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 342 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->exposed (self);
#line 2386 "CheckerboardLayout.c"
}


static void checkerboard_item_real_unexposed (CheckerboardItem* self) {
	CheckerboardItemText* _tmp0_ = NULL;
	CheckerboardItemText* _tmp2_ = NULL;
	CheckerboardItemText* _tmp4_ = NULL;
#line 347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = FALSE;
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->title;
#line 349 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 2400 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp1_ = NULL;
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->title;
#line 350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp1_);
#line 2406 "CheckerboardLayout.c"
	}
#line 352 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->comment;
#line 352 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 2412 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp3_ = NULL;
#line 353 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->comment;
#line 353 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp3_);
#line 2418 "CheckerboardLayout.c"
	}
#line 355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->subtitle;
#line 355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 2424 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp5_ = NULL;
#line 356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->subtitle;
#line 356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_text_clear_pango_layout (_tmp5_);
#line 2430 "CheckerboardLayout.c"
	}
}


void checkerboard_item_unexposed (CheckerboardItem* self) {
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 346 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->unexposed (self);
#line 2440 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->exposure;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 360 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2453 "CheckerboardLayout.c"
}


gboolean checkerboard_item_is_exposed (CheckerboardItem* self) {
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->is_exposed (self);
#line 2462 "CheckerboardLayout.c"
}


gboolean checkerboard_item_has_image (CheckerboardItem* self) {
	gboolean result = FALSE;
	GdkPixbuf* _tmp0_ = NULL;
#line 363 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_ != NULL;
#line 364 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2477 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
#line 367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 368 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 368 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 368 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 368 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2495 "CheckerboardLayout.c"
}


void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	Dimensions _tmp5_ = {0};
#line 371 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 371 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = pixbuf;
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = _tmp1_;
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = pixbuf;
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 373 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp3_;
#line 374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = pixbuf;
#line 374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_for_pixbuf (_tmp4_, &_tmp5_);
#line 374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp5_;
#line 376 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "set_image");
#line 377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2536 "CheckerboardLayout.c"
}


void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim) {
	gboolean had_image = FALSE;
	GdkPixbuf* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
#line 380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 380 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (dim != NULL);
#line 381 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->pixbuf;
#line 381 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	had_image = _tmp0_ != NULL;
#line 383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 383 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = NULL;
#line 384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = NULL;
#line 385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *dim;
#line 385 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf_dim = _tmp1_;
#line 387 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_recalc_size (self, "clear_image");
#line 389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = had_image;
#line 389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 390 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2573 "CheckerboardLayout.c"
	}
}


gint checkerboard_item_get_max_width (gint scale) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 396 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = scale;
#line 396 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + _tmp0_;
#line 396 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 2587 "CheckerboardLayout.c"
}


static void checkerboard_item_recalc_size (CheckerboardItem* self, const gchar* reason) {
	Dimensions old_requisition = {0};
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	CheckerboardItemText* _tmp3_ = NULL;
	gint title_height = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	CheckerboardItemText* _tmp9_ = NULL;
	gint comment_height = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	CheckerboardItemText* _tmp15_ = NULL;
	gint subtitle_height = 0;
	Dimensions _tmp19_ = {0};
	gint _tmp20_ = 0;
	Dimensions _tmp21_ = {0};
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	Dimensions _tmp26_ = {0};
	gboolean _tmp27_ = FALSE;
#line 399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (reason != NULL);
#line 400 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->requisition;
#line 400 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old_requisition = _tmp0_;
#line 403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->title;
#line 403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp3_ != NULL) {
#line 2627 "CheckerboardLayout.c"
		gboolean _tmp4_ = FALSE;
#line 403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->title_visible;
#line 403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp4_;
#line 2633 "CheckerboardLayout.c"
	} else {
#line 403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = FALSE;
#line 2637 "CheckerboardLayout.c"
	}
#line 403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_) {
#line 2641 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->title;
#line 404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = checkerboard_item_text_get_height (_tmp5_);
#line 404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp6_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 2650 "CheckerboardLayout.c"
	} else {
#line 404 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = 0;
#line 2654 "CheckerboardLayout.c"
	}
#line 403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	title_height = _tmp1_;
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->comment;
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ != NULL) {
#line 2662 "CheckerboardLayout.c"
		gboolean _tmp10_ = FALSE;
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = self->priv->comment_visible;
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp10_;
#line 2668 "CheckerboardLayout.c"
	} else {
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = FALSE;
#line 2672 "CheckerboardLayout.c"
	}
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp8_) {
#line 2676 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->comment;
#line 406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_text_get_height (_tmp11_);
#line 406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp12_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 2685 "CheckerboardLayout.c"
	} else {
#line 406 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = 0;
#line 2689 "CheckerboardLayout.c"
	}
#line 405 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	comment_height = _tmp7_;
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->subtitle;
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ != NULL) {
#line 2697 "CheckerboardLayout.c"
		gboolean _tmp16_ = FALSE;
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->subtitle_visible;
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp16_;
#line 2703 "CheckerboardLayout.c"
	} else {
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = FALSE;
#line 2707 "CheckerboardLayout.c"
	}
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_) {
#line 2711 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp17_ = NULL;
		gint _tmp18_ = 0;
#line 408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = self->priv->subtitle;
#line 408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = checkerboard_item_text_get_height (_tmp17_);
#line 408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp18_ + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 2720 "CheckerboardLayout.c"
	} else {
#line 408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = 0;
#line 2724 "CheckerboardLayout.c"
	}
#line 407 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	subtitle_height = _tmp13_;
#line 412 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = self->priv->pixbuf_dim;
#line 412 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = _tmp19_.width;
#line 412 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->requisition.width = ((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp20_;
#line 416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->pixbuf_dim;
#line 416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = _tmp21_.height;
#line 416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = title_height;
#line 416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = comment_height;
#line 416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = subtitle_height;
#line 416 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->requisition.height = (((((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp22_) + _tmp23_) + _tmp24_) + _tmp25_;
#line 425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = old_requisition;
#line 425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = dimensions_approx_equals (&self->requisition, &_tmp26_, 1);
#line 425 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp27_) {
#line 429 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		data_view_notify_geometry_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 2754 "CheckerboardLayout.c"
	}
}


void checkerboard_item_get_border_dimensions (Dimensions* object_dim, gint border_width, Dimensions* result) {
	Dimensions dimensions = {0};
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 433 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_dim != NULL);
#line 434 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&dimensions, 0, 0);
#line 435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *object_dim;
#line 435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.width;
#line 435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = border_width;
#line 435 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions.width = _tmp1_ + (_tmp2_ * 2);
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *object_dim;
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.height;
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = border_width;
#line 436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions.height = _tmp4_ + (_tmp5_ * 2);
#line 437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = dimensions;
#line 437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 2791 "CheckerboardLayout.c"
}


void checkerboard_item_get_border_origin (GdkPoint* object_origin, gint border_width, GdkPoint* result) {
	GdkPoint origin = {0};
	GdkPoint _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkPoint _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_origin != NULL);
#line 441 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&origin, 0, sizeof (GdkPoint));
#line 442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *object_origin;
#line 442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = border_width;
#line 442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	origin.x = _tmp1_ - _tmp2_;
#line 443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *object_origin;
#line 443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.y;
#line 443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = border_width;
#line 443 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	origin.y = _tmp4_ - _tmp5_;
#line 444 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	*result = origin;
#line 444 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return;
#line 2827 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha) {
	gdouble rgb_all = 0.0;
	cairo_t* _tmp0_ = NULL;
	GdkPoint _tmp1_ = {0};
	gint _tmp2_ = 0;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	GdkPoint _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gfloat _tmp9_ = 0.0F;
	cairo_t* _tmp10_ = NULL;
	GdkPoint _tmp11_ = {0};
	gint _tmp12_ = 0;
	Dimensions _tmp13_ = {0};
	gint _tmp14_ = 0;
	GdkPoint _tmp15_ = {0};
	gint _tmp16_ = 0;
	Dimensions _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gfloat _tmp20_ = 0.0F;
	cairo_t* _tmp21_ = NULL;
	GdkPoint _tmp22_ = {0};
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	GdkPoint _tmp25_ = {0};
	gint _tmp26_ = 0;
	Dimensions _tmp27_ = {0};
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gfloat _tmp30_ = 0.0F;
	cairo_pattern_t* lr = NULL;
	GdkPoint _tmp31_ = {0};
	gint _tmp32_ = 0;
	Dimensions _tmp33_ = {0};
	gint _tmp34_ = 0;
	GdkPoint _tmp35_ = {0};
	gint _tmp36_ = 0;
	Dimensions _tmp37_ = {0};
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	cairo_pattern_t* _tmp40_ = NULL;
	gfloat _tmp41_ = 0.0F;
	cairo_t* _tmp42_ = NULL;
	cairo_t* _tmp43_ = NULL;
	GdkPoint _tmp44_ = {0};
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	GdkPoint _tmp47_ = {0};
	gint _tmp48_ = 0;
	Dimensions _tmp49_ = {0};
	gint _tmp50_ = 0;
	Dimensions _tmp51_ = {0};
	gint _tmp52_ = 0;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	cairo_t* _tmp55_ = NULL;
	cairo_pattern_t* td = NULL;
	GdkPoint _tmp56_ = {0};
	gint _tmp57_ = 0;
	Dimensions _tmp58_ = {0};
	gint _tmp59_ = 0;
	GdkPoint _tmp60_ = {0};
	gint _tmp61_ = 0;
	Dimensions _tmp62_ = {0};
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	cairo_pattern_t* _tmp65_ = NULL;
	gfloat _tmp66_ = 0.0F;
	cairo_t* _tmp67_ = NULL;
	cairo_t* _tmp68_ = NULL;
	GdkPoint _tmp69_ = {0};
	gint _tmp70_ = 0;
	Dimensions _tmp71_ = {0};
	gint _tmp72_ = 0;
	GdkPoint _tmp73_ = {0};
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	Dimensions _tmp77_ = {0};
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	cairo_t* _tmp80_ = NULL;
#line 447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (dimensions != NULL);
#line 447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (origin != NULL);
#line 449 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	rgb_all = 0.0;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = ctx;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = *origin;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.x;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = *dimensions;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = *origin;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.y;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = radius;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = radius;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = initial_alpha;
#line 452 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp0_, _tmp2_ + _tmp4_, _tmp6_ + _tmp7_, rgb_all, (gfloat) _tmp8_, _tmp9_, (-0.5) * G_PI, (gdouble) 0);
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = ctx;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = *origin;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = _tmp11_.x;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = *dimensions;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = _tmp13_.width;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = *origin;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = _tmp15_.y;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = *dimensions;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = _tmp17_.height;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = radius;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = initial_alpha;
#line 455 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp10_, _tmp12_ + _tmp14_, _tmp16_ + _tmp18_, rgb_all, (gfloat) _tmp19_, _tmp20_, (gdouble) 0, 0.5 * G_PI);
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = ctx;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = *origin;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = _tmp22_.x;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = radius;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = *origin;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = _tmp25_.y;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = *dimensions;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = _tmp27_.height;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = radius;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = initial_alpha;
#line 458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_paint_shadow_in_corner (self, _tmp21_, _tmp23_ + _tmp24_, _tmp26_ + _tmp28_, rgb_all, (gfloat) _tmp29_, _tmp30_, 0.5 * G_PI, G_PI);
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = *origin;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = _tmp31_.y;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp33_ = *dimensions;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp34_ = _tmp33_.height;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = *origin;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = _tmp35_.y;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = *dimensions;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = _tmp37_.height;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = radius;
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp40_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) (_tmp32_ + _tmp34_), (gdouble) 0, (gdouble) ((_tmp36_ + _tmp38_) + _tmp39_));
#line 462 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	lr = _tmp40_;
#line 464 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = initial_alpha;
#line 464 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (lr, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) _tmp41_);
#line 465 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (lr, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
#line 466 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp42_ = ctx;
#line 466 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp42_, lr);
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp43_ = ctx;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp44_ = *origin;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = _tmp44_.x;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp46_ = radius;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp47_ = *origin;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = _tmp47_.y;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp49_ = *dimensions;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp50_ = _tmp49_.height;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = *dimensions;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp52_ = _tmp51_.width;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp53_ = radius;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp54_ = radius;
#line 467 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp43_, (gdouble) (_tmp45_ + _tmp46_), (gdouble) (_tmp48_ + _tmp50_), (gdouble) (_tmp52_ - _tmp53_), (gdouble) _tmp54_);
#line 468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp55_ = ctx;
#line 468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp55_);
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp56_ = *origin;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp57_ = _tmp56_.x;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp58_ = *dimensions;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp59_ = _tmp58_.width;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp60_ = *origin;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp61_ = _tmp60_.x;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp62_ = *dimensions;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp63_ = _tmp62_.width;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp64_ = radius;
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp65_ = cairo_pattern_create_linear ((gdouble) (_tmp57_ + _tmp59_), (gdouble) 0, (gdouble) ((_tmp61_ + _tmp63_) + _tmp64_), (gdouble) 0);
#line 471 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	td = _tmp65_;
#line 473 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp66_ = initial_alpha;
#line 473 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (td, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) _tmp66_);
#line 474 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (td, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
#line 475 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp67_ = ctx;
#line 475 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp67_, td);
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp68_ = ctx;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp69_ = *origin;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp70_ = _tmp69_.x;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp71_ = *dimensions;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = _tmp71_.width;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp73_ = *origin;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp74_ = _tmp73_.y;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp75_ = radius;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp76_ = radius;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp77_ = *dimensions;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp78_ = _tmp77_.height;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp79_ = radius;
#line 476 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp68_, (gdouble) (_tmp70_ + _tmp72_), (gdouble) (_tmp74_ + _tmp75_), (gdouble) _tmp76_, (gdouble) (_tmp78_ - _tmp79_));
#line 478 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp80_ = ctx;
#line 478 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp80_);
#line 447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (td);
#line 447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (lr);
#line 3120 "CheckerboardLayout.c"
}


void checkerboard_item_paint_shadow (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha) {
#line 447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 447 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_shadow (self, ctx, dimensions, origin, radius, initial_alpha);
#line 3129 "CheckerboardLayout.c"
}


void checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self, cairo_t* ctx, gint x, gint y, gdouble rgb_all, gfloat radius, gfloat initial_alpha, gdouble arc1, gdouble arc2) {
	cairo_pattern_t* p = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gfloat _tmp4_ = 0.0F;
	cairo_pattern_t* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gfloat _tmp9_ = 0.0F;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	cairo_t* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gfloat _tmp20_ = 0.0F;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	cairo_t* _tmp23_ = NULL;
	cairo_t* _tmp24_ = NULL;
#line 481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = x;
#line 483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = y;
#line 483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = x;
#line 483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = y;
#line 483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = radius;
#line 483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = cairo_pattern_create_radial ((gdouble) _tmp0_, (gdouble) _tmp1_, (gdouble) 0, (gdouble) _tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
#line 483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	p = _tmp5_;
#line 484 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = rgb_all;
#line 484 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = rgb_all;
#line 484 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = rgb_all;
#line 484 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = initial_alpha;
#line 484 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (p, 0.0, _tmp6_, _tmp7_, _tmp8_, (gdouble) _tmp9_);
#line 485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = rgb_all;
#line 485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = rgb_all;
#line 485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = rgb_all;
#line 485 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_pattern_add_color_stop_rgba (p, 1.0, _tmp10_, _tmp11_, _tmp12_, (gdouble) 0);
#line 486 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = ctx;
#line 486 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source (_tmp13_, p);
#line 487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = ctx;
#line 487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = x;
#line 487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = y;
#line 487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_move_to (_tmp14_, (gdouble) _tmp15_, (gdouble) _tmp16_);
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = ctx;
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = x;
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = y;
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp20_ = radius;
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = arc1;
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = arc2;
#line 488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_arc (_tmp17_, (gdouble) _tmp18_, (gdouble) _tmp19_, (gdouble) _tmp20_, _tmp21_, _tmp22_);
#line 489 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = ctx;
#line 489 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_close_path (_tmp23_);
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = ctx;
#line 490 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_fill (_tmp24_);
#line 481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_cairo_pattern_destroy0 (p);
#line 3232 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width) {
	gint _tmp0_ = 0;
#line 493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_dimensions != NULL);
#line 493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (object_origin != NULL);
#line 495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = border_width;
#line 495 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == 1) {
#line 3248 "CheckerboardLayout.c"
		cairo_t* _tmp1_ = NULL;
		GdkPoint _tmp2_ = {0};
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GdkPoint _tmp5_ = {0};
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		Dimensions _tmp8_ = {0};
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Dimensions _tmp11_ = {0};
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		cairo_t* _tmp14_ = NULL;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = ctx;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = *object_origin;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp2_.x;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = border_width;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = *object_origin;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.y;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = border_width;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = *object_dimensions;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = _tmp8_.width;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = border_width;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = *object_dimensions;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp11_.height;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = border_width;
#line 496 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp1_, (gdouble) (_tmp3_ - _tmp4_), (gdouble) (_tmp6_ - _tmp7_), (gdouble) (_tmp9_ + (_tmp10_ * 2)), (gdouble) (_tmp12_ + (_tmp13_ * 2)));
#line 499 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = ctx;
#line 499 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp14_);
#line 3295 "CheckerboardLayout.c"
	} else {
		Dimensions dimensions = {0};
		Dimensions _tmp15_ = {0};
		gint _tmp16_ = 0;
		Dimensions _tmp17_ = {0};
		GdkPoint origin = {0};
		GdkPoint _tmp18_ = {0};
		gint _tmp19_ = 0;
		GdkPoint _tmp20_ = {0};
		gdouble scale = 0.0;
		Dimensions _tmp21_ = {0};
		gint _tmp22_ = 0;
		Dimensions _tmp23_ = {0};
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		cairo_t* _tmp26_ = NULL;
		Dimensions _tmp27_ = {0};
		GdkPoint _tmp28_ = {0};
		gdouble _tmp29_ = 0.0;
#line 501 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = *object_dimensions;
#line 501 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = border_width;
#line 501 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_get_border_dimensions (&_tmp15_, _tmp16_, &_tmp17_);
#line 501 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dimensions = _tmp17_;
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = *object_origin;
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = border_width;
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_get_border_origin (&_tmp18_, _tmp19_, &_tmp20_);
#line 502 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		origin = _tmp20_;
#line 505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = *object_dimensions;
#line 505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.width;
#line 505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = *object_dimensions;
#line 505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.height;
#line 505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = MAX (_tmp22_, _tmp24_);
#line 505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		scale = (gdouble) _tmp25_;
#line 506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = ctx;
#line 506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = dimensions;
#line 506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = origin;
#line 506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = scale;
#line 506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		draw_rounded_corners_filled (_tmp26_, &_tmp27_, &_tmp28_, 0.25 * _tmp29_);
#line 3353 "CheckerboardLayout.c"
	}
}


void checkerboard_item_paint_border (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width) {
#line 493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_border (self, ctx, object_dimensions, object_origin, border_width);
#line 3363 "CheckerboardLayout.c"
}


static void checkerboard_item_real_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin) {
	GdkPixbuf* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	cairo_t* _tmp12_ = NULL;
	GdkPixbuf* _tmp13_ = NULL;
	GdkPoint _tmp14_ = {0};
	gint _tmp15_ = 0;
	GdkPoint _tmp16_ = {0};
	gint _tmp17_ = 0;
	cairo_t* _tmp18_ = NULL;
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (origin != NULL);
#line 511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = pixbuf;
#line 511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gdk_pixbuf_get_has_alpha (_tmp0_);
#line 511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 3389 "CheckerboardLayout.c"
		cairo_t* _tmp2_ = NULL;
		GdkPoint _tmp3_ = {0};
		gint _tmp4_ = 0;
		GdkPoint _tmp5_ = {0};
		gint _tmp6_ = 0;
		GdkPixbuf* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		GdkPixbuf* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		cairo_t* _tmp11_ = NULL;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = ctx;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = *origin;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.x;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = *origin;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.y;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = pixbuf;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = gdk_pixbuf_get_width (_tmp7_);
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = pixbuf;
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = gdk_pixbuf_get_height (_tmp9_);
#line 512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp2_, (gdouble) _tmp4_, (gdouble) _tmp6_, (gdouble) _tmp8_, (gdouble) _tmp10_);
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = ctx;
#line 513 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp11_);
#line 3424 "CheckerboardLayout.c"
	}
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = ctx;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = pixbuf;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = *origin;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_.x;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = *origin;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = _tmp16_.y;
#line 515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gdk_cairo_set_source_pixbuf (_tmp12_, _tmp13_, (gdouble) _tmp15_, (gdouble) _tmp17_);
#line 516 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = ctx;
#line 516 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_paint (_tmp18_);
#line 3444 "CheckerboardLayout.c"
}


void checkerboard_item_paint_image (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin) {
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	CHECKERBOARD_ITEM_GET_CLASS (self)->paint_image (self, ctx, pixbuf, origin);
#line 3453 "CheckerboardLayout.c"
}


static gint checkerboard_item_get_selection_border_width (CheckerboardItem* self, gint scale) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = scale;
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = thumbnail_get_MIN_SCALE ();
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_;
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = thumbnail_get_MAX_SCALE ();
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ <= ((_tmp3_ + _tmp5_) / 3)) {
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = 2;
#line 3481 "CheckerboardLayout.c"
	} else {
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = 3;
#line 3485 "CheckerboardLayout.c"
	}
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3491 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3501 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self, gint scale) {
#line 524 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 524 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_top_left_trinket (self, scale);
#line 3510 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3520 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self, gint scale) {
#line 528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 528 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_top_right_trinket (self, scale);
#line 3529 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 533 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3539 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self, gint scale) {
#line 532 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 532 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_bottom_left_trinket (self, scale);
#line 3548 "CheckerboardLayout.c"
}


static GdkPixbuf* checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self, gint scale) {
	GdkPixbuf* result = NULL;
#line 537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 3558 "CheckerboardLayout.c"
}


GdkPixbuf* checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self, gint scale) {
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
#line 536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return CHECKERBOARD_ITEM_GET_CLASS (self)->get_bottom_right_trinket (self, scale);
#line 3567 "CheckerboardLayout.c"
}


void checkerboard_item_paint (CheckerboardItem* self, cairo_t* ctx, GdkRGBA* bg_color, GdkRGBA* selected_color, GdkRGBA* text_color, GdkRGBA* border_color) {
	GdkPoint pixbuf_origin = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	cairo_t* _tmp4_ = NULL;
	cairo_t* _tmp5_ = NULL;
	GdkRGBA _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	GdkRGBA _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	GdkRGBA _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	GdkRGBA _tmp12_ = {0};
	gdouble _tmp13_ = 0.0;
	GdkRGBA* _tmp14_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp45_ = FALSE;
	GdkRGBA* _tmp57_ = NULL;
	GdkPixbuf* _tmp72_ = NULL;
	cairo_t* _tmp87_ = NULL;
	GdkRGBA _tmp88_ = {0};
	gdouble _tmp89_ = 0.0;
	GdkRGBA _tmp90_ = {0};
	gdouble _tmp91_ = 0.0;
	GdkRGBA _tmp92_ = {0};
	gdouble _tmp93_ = 0.0;
	GdkRGBA _tmp94_ = {0};
	gdouble _tmp95_ = 0.0;
	gint text_y = 0;
	GdkRectangle _tmp96_ = {0};
	gint _tmp97_ = 0;
	Dimensions _tmp98_ = {0};
	gint _tmp99_ = 0;
	gboolean _tmp100_ = FALSE;
	CheckerboardItemText* _tmp101_ = NULL;
	gboolean _tmp130_ = FALSE;
	CheckerboardItemText* _tmp131_ = NULL;
	gboolean _tmp160_ = FALSE;
	CheckerboardItemText* _tmp161_ = NULL;
	cairo_t* _tmp187_ = NULL;
	GdkRGBA _tmp188_ = {0};
	gdouble _tmp189_ = 0.0;
	GdkRGBA _tmp190_ = {0};
	gdouble _tmp191_ = 0.0;
	GdkRGBA _tmp192_ = {0};
	gdouble _tmp193_ = 0.0;
	GdkRGBA _tmp194_ = {0};
	gdouble _tmp195_ = 0.0;
	GdkPixbuf* trinket = NULL;
	GdkPixbuf* _tmp196_ = NULL;
	GdkPixbuf* _tmp197_ = NULL;
	GdkPixbuf* _tmp219_ = NULL;
	GdkPixbuf* _tmp220_ = NULL;
	GdkPixbuf* _tmp238_ = NULL;
	GdkPixbuf* _tmp239_ = NULL;
	GdkPixbuf* _tmp262_ = NULL;
	GdkPixbuf* _tmp263_ = NULL;
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (bg_color != NULL);
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (selected_color != NULL);
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (text_color != NULL);
#line 543 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&pixbuf_origin, 0, sizeof (GdkPoint));
#line 544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->allocation;
#line 544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.x;
#line 544 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pixbuf_origin.x = (_tmp1_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->allocation;
#line 545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	pixbuf_origin.y = (_tmp3_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 547 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = ctx;
#line 547 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_width (_tmp4_, (gdouble) CHECKERBOARD_ITEM_FRAME_WIDTH);
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = ctx;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = *selected_color;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.red;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = *selected_color;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_.green;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = *selected_color;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = _tmp10_.blue;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = *selected_color;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = _tmp12_.alpha;
#line 548 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp5_, _tmp7_, _tmp9_, _tmp11_, _tmp13_);
#line 552 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = border_color;
#line 552 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 3682 "CheckerboardLayout.c"
		cairo_t* _tmp15_ = NULL;
		Dimensions shadow_dim = {0};
		Dimensions _tmp16_ = {0};
		gint _tmp17_ = 0;
		Dimensions _tmp18_ = {0};
		gint _tmp19_ = 0;
		cairo_t* _tmp20_ = NULL;
		Dimensions _tmp21_ = {0};
		GdkPoint _tmp22_ = {0};
		cairo_t* _tmp23_ = NULL;
#line 553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = ctx;
#line 553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp15_);
#line 554 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dimensions_init (&shadow_dim, 0, 0);
#line 555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = self->priv->pixbuf_dim;
#line 555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _tmp16_.width;
#line 555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		shadow_dim.width = _tmp17_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = self->priv->pixbuf_dim;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _tmp18_.height;
#line 556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		shadow_dim.height = _tmp19_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = ctx;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = shadow_dim;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = pixbuf_origin;
#line 557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_shadow (self, _tmp20_, &_tmp21_, &_tmp22_, CHECKERBOARD_ITEM_SHADOW_RADIUS, CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA);
#line 558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = ctx;
#line 558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp23_);
#line 3723 "CheckerboardLayout.c"
	}
#line 562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = self->priv->is_cursor;
#line 562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp24_) {
#line 3729 "CheckerboardLayout.c"
		cairo_t* _tmp25_ = NULL;
		cairo_t* _tmp26_ = NULL;
		GdkRGBA* _tmp27_ = NULL;
		gdouble _tmp28_ = 0.0;
		GdkRGBA* _tmp29_ = NULL;
		gdouble _tmp30_ = 0.0;
		GdkRGBA* _tmp31_ = NULL;
		gdouble _tmp32_ = 0.0;
		GdkRGBA* _tmp33_ = NULL;
		gdouble _tmp34_ = 0.0;
		cairo_t* _tmp35_ = NULL;
		Dimensions _tmp36_ = {0};
		GdkPoint _tmp37_ = {0};
		Dimensions _tmp38_ = {0};
		gint _tmp39_ = 0;
		Dimensions _tmp40_ = {0};
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		cairo_t* _tmp44_ = NULL;
#line 563 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = ctx;
#line 563 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp25_);
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = ctx;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = border_color;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = (*_tmp27_).red;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = border_color;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = (*_tmp29_).green;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = border_color;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = (*_tmp31_).blue;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = border_color;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = (*_tmp33_).alpha;
#line 564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp26_, _tmp28_, _tmp30_, _tmp32_, _tmp34_);
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = ctx;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp36_ = self->priv->pixbuf_dim;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = pixbuf_origin;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = self->priv->pixbuf_dim;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = _tmp38_.width;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = self->priv->pixbuf_dim;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = _tmp40_.height;
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = MAX (_tmp39_, _tmp41_);
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = checkerboard_item_get_selection_border_width (self, _tmp42_);
#line 566 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp35_, &_tmp36_, &_tmp37_, _tmp43_);
#line 568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = ctx;
#line 568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp44_);
#line 3798 "CheckerboardLayout.c"
	}
#line 572 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 572 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp45_) {
#line 3804 "CheckerboardLayout.c"
		cairo_t* _tmp46_ = NULL;
		cairo_t* _tmp47_ = NULL;
		Dimensions _tmp48_ = {0};
		GdkPoint _tmp49_ = {0};
		Dimensions _tmp50_ = {0};
		gint _tmp51_ = 0;
		Dimensions _tmp52_ = {0};
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		cairo_t* _tmp56_ = NULL;
#line 574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = ctx;
#line 574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp46_);
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = ctx;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp48_ = self->priv->pixbuf_dim;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = pixbuf_origin;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = self->priv->pixbuf_dim;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp51_ = _tmp50_.width;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp52_ = self->priv->pixbuf_dim;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp53_ = _tmp52_.height;
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp54_ = MAX (_tmp51_, _tmp53_);
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp55_ = checkerboard_item_get_selection_border_width (self, _tmp54_);
#line 575 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp47_, &_tmp48_, &_tmp49_, _tmp55_);
#line 577 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp56_ = ctx;
#line 577 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp56_);
#line 3844 "CheckerboardLayout.c"
	}
#line 581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp57_ = border_color;
#line 581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp57_ != NULL) {
#line 3850 "CheckerboardLayout.c"
		cairo_t* _tmp58_ = NULL;
		cairo_t* _tmp59_ = NULL;
		GdkRGBA* _tmp60_ = NULL;
		gdouble _tmp61_ = 0.0;
		GdkRGBA* _tmp62_ = NULL;
		gdouble _tmp63_ = 0.0;
		GdkRGBA* _tmp64_ = NULL;
		gdouble _tmp65_ = 0.0;
		GdkRGBA* _tmp66_ = NULL;
		gdouble _tmp67_ = 0.0;
		cairo_t* _tmp68_ = NULL;
		Dimensions _tmp69_ = {0};
		GdkPoint _tmp70_ = {0};
		cairo_t* _tmp71_ = NULL;
#line 582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp58_ = ctx;
#line 582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp58_);
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp59_ = ctx;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = border_color;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = (*_tmp60_).red;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = border_color;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp63_ = (*_tmp62_).green;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp64_ = border_color;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp65_ = (*_tmp64_).blue;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp66_ = border_color;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp67_ = (*_tmp66_).alpha;
#line 583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp59_, _tmp61_, _tmp63_, _tmp65_, _tmp67_);
#line 585 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp68_ = ctx;
#line 585 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp69_ = self->priv->pixbuf_dim;
#line 585 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp70_ = pixbuf_origin;
#line 585 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_border (self, _tmp68_, &_tmp69_, &_tmp70_, CHECKERBOARD_ITEM_BORDER_WIDTH);
#line 586 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp71_ = ctx;
#line 586 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp71_);
#line 3901 "CheckerboardLayout.c"
	}
#line 589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = self->priv->display_pixbuf;
#line 589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp72_ != NULL) {
#line 3907 "CheckerboardLayout.c"
		cairo_t* _tmp73_ = NULL;
		cairo_t* _tmp74_ = NULL;
		GdkRGBA _tmp75_ = {0};
		gdouble _tmp76_ = 0.0;
		GdkRGBA _tmp77_ = {0};
		gdouble _tmp78_ = 0.0;
		GdkRGBA _tmp79_ = {0};
		gdouble _tmp80_ = 0.0;
		GdkRGBA _tmp81_ = {0};
		gdouble _tmp82_ = 0.0;
		cairo_t* _tmp83_ = NULL;
		GdkPixbuf* _tmp84_ = NULL;
		GdkPoint _tmp85_ = {0};
		cairo_t* _tmp86_ = NULL;
#line 590 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp73_ = ctx;
#line 590 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_save (_tmp73_);
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp74_ = ctx;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp75_ = *bg_color;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp76_ = _tmp75_.red;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp77_ = *bg_color;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp78_ = _tmp77_.green;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp79_ = *bg_color;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp80_ = _tmp79_.blue;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp81_ = *bg_color;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp82_ = _tmp81_.alpha;
#line 591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp74_, _tmp76_, _tmp78_, _tmp80_, _tmp82_);
#line 592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp83_ = ctx;
#line 592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp84_ = self->priv->display_pixbuf;
#line 592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp85_ = pixbuf_origin;
#line 592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_paint_image (self, _tmp83_, _tmp84_, &_tmp85_);
#line 593 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp86_ = ctx;
#line 593 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_restore (_tmp86_);
#line 3958 "CheckerboardLayout.c"
	}
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp87_ = ctx;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp88_ = *text_color;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp89_ = _tmp88_.red;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp90_ = *text_color;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp91_ = _tmp90_.green;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp92_ = *text_color;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp93_ = _tmp92_.blue;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp94_ = *text_color;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp95_ = _tmp94_.alpha;
#line 596 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp87_, _tmp89_, _tmp91_, _tmp93_, _tmp95_);
#line 599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp96_ = self->allocation;
#line 599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp97_ = _tmp96_.y;
#line 599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp98_ = self->priv->pixbuf_dim;
#line 599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp99_ = _tmp98_.height;
#line 599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	text_y = (((_tmp97_ + CHECKERBOARD_ITEM_FRAME_WIDTH) + _tmp99_) + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_LABEL_PADDING;
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp101_ = self->priv->title;
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp101_ != NULL) {
#line 3994 "CheckerboardLayout.c"
		gboolean _tmp102_ = FALSE;
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp102_ = self->priv->title_visible;
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp100_ = _tmp102_;
#line 4000 "CheckerboardLayout.c"
	} else {
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp100_ = FALSE;
#line 4004 "CheckerboardLayout.c"
	}
#line 600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp100_) {
#line 4008 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp103_ = NULL;
		GdkRectangle _tmp104_ = {0};
		gint _tmp105_ = 0;
		CheckerboardItemText* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		CheckerboardItemText* _tmp108_ = NULL;
		Dimensions _tmp109_ = {0};
		gint _tmp110_ = 0;
		CheckerboardItemText* _tmp111_ = NULL;
		CheckerboardItemText* _tmp112_ = NULL;
		gint _tmp113_ = 0;
		cairo_t* _tmp114_ = NULL;
		CheckerboardItemText* _tmp115_ = NULL;
		GdkRectangle _tmp116_ = {0};
		gint _tmp117_ = 0;
		CheckerboardItemText* _tmp118_ = NULL;
		GdkRectangle _tmp119_ = {0};
		gint _tmp120_ = 0;
		cairo_t* _tmp121_ = NULL;
		CheckerboardItemText* _tmp122_ = NULL;
		Dimensions _tmp123_ = {0};
		gint _tmp124_ = 0;
		PangoLayout* _tmp125_ = NULL;
		PangoLayout* _tmp126_ = NULL;
		gint _tmp127_ = 0;
		CheckerboardItemText* _tmp128_ = NULL;
		gint _tmp129_ = 0;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp103_ = self->priv->title;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp104_ = self->allocation;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp105_ = _tmp104_.x;
#line 603 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp103_->allocation.x = _tmp105_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp106_ = self->priv->title;
#line 604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp107_ = text_y;
#line 604 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp106_->allocation.y = _tmp107_;
#line 605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp108_ = self->priv->title;
#line 605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp109_ = self->priv->pixbuf_dim;
#line 605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp110_ = _tmp109_.width;
#line 605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp108_->allocation.width = _tmp110_;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp111_ = self->priv->title;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp112_ = self->priv->title;
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp113_ = checkerboard_item_text_get_height (_tmp112_);
#line 606 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp111_->allocation.height = _tmp113_;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp114_ = ctx;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp115_ = self->priv->title;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp116_ = _tmp115_->allocation;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp117_ = _tmp116_.x;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp118_ = self->priv->title;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp119_ = _tmp118_->allocation;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp120_ = _tmp119_.y;
#line 608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp114_, (gdouble) _tmp117_, (gdouble) _tmp120_);
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp121_ = ctx;
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp122_ = self->priv->title;
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp123_ = self->priv->pixbuf_dim;
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp124_ = _tmp123_.width;
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp125_ = checkerboard_item_text_get_pango_layout (_tmp122_, _tmp124_);
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp126_ = _tmp125_;
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp121_, _tmp126_);
#line 609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp126_);
#line 611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp127_ = text_y;
#line 611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp128_ = self->priv->title;
#line 611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp129_ = checkerboard_item_text_get_height (_tmp128_);
#line 611 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_y = _tmp127_ + (_tmp129_ + CHECKERBOARD_ITEM_LABEL_PADDING);
#line 4106 "CheckerboardLayout.c"
	}
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp131_ = self->priv->comment;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp131_ != NULL) {
#line 4112 "CheckerboardLayout.c"
		gboolean _tmp132_ = FALSE;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp132_ = self->priv->comment_visible;
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp130_ = _tmp132_;
#line 4118 "CheckerboardLayout.c"
	} else {
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp130_ = FALSE;
#line 4122 "CheckerboardLayout.c"
	}
#line 614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp130_) {
#line 4126 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp133_ = NULL;
		GdkRectangle _tmp134_ = {0};
		gint _tmp135_ = 0;
		CheckerboardItemText* _tmp136_ = NULL;
		gint _tmp137_ = 0;
		CheckerboardItemText* _tmp138_ = NULL;
		Dimensions _tmp139_ = {0};
		gint _tmp140_ = 0;
		CheckerboardItemText* _tmp141_ = NULL;
		CheckerboardItemText* _tmp142_ = NULL;
		gint _tmp143_ = 0;
		cairo_t* _tmp144_ = NULL;
		CheckerboardItemText* _tmp145_ = NULL;
		GdkRectangle _tmp146_ = {0};
		gint _tmp147_ = 0;
		CheckerboardItemText* _tmp148_ = NULL;
		GdkRectangle _tmp149_ = {0};
		gint _tmp150_ = 0;
		cairo_t* _tmp151_ = NULL;
		CheckerboardItemText* _tmp152_ = NULL;
		Dimensions _tmp153_ = {0};
		gint _tmp154_ = 0;
		PangoLayout* _tmp155_ = NULL;
		PangoLayout* _tmp156_ = NULL;
		gint _tmp157_ = 0;
		CheckerboardItemText* _tmp158_ = NULL;
		gint _tmp159_ = 0;
#line 615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp133_ = self->priv->comment;
#line 615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp134_ = self->allocation;
#line 615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp135_ = _tmp134_.x;
#line 615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp133_->allocation.x = _tmp135_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp136_ = self->priv->comment;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp137_ = text_y;
#line 616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp136_->allocation.y = _tmp137_;
#line 617 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp138_ = self->priv->comment;
#line 617 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp139_ = self->priv->pixbuf_dim;
#line 617 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp140_ = _tmp139_.width;
#line 617 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp138_->allocation.width = _tmp140_;
#line 618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp141_ = self->priv->comment;
#line 618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp142_ = self->priv->comment;
#line 618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp143_ = checkerboard_item_text_get_height (_tmp142_);
#line 618 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp141_->allocation.height = _tmp143_;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp144_ = ctx;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp145_ = self->priv->comment;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp146_ = _tmp145_->allocation;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp147_ = _tmp146_.x;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp148_ = self->priv->comment;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp149_ = _tmp148_->allocation;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp150_ = _tmp149_.y;
#line 620 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp144_, (gdouble) _tmp147_, (gdouble) _tmp150_);
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp151_ = ctx;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp152_ = self->priv->comment;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp153_ = self->priv->pixbuf_dim;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp154_ = _tmp153_.width;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp155_ = checkerboard_item_text_get_pango_layout (_tmp152_, _tmp154_);
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp156_ = _tmp155_;
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp151_, _tmp156_);
#line 621 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp156_);
#line 623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp157_ = text_y;
#line 623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp158_ = self->priv->comment;
#line 623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp159_ = checkerboard_item_text_get_height (_tmp158_);
#line 623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_y = _tmp157_ + (_tmp159_ + CHECKERBOARD_ITEM_LABEL_PADDING);
#line 4224 "CheckerboardLayout.c"
	}
#line 626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp161_ = self->priv->subtitle;
#line 626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp161_ != NULL) {
#line 4230 "CheckerboardLayout.c"
		gboolean _tmp162_ = FALSE;
#line 626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp162_ = self->priv->subtitle_visible;
#line 626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp160_ = _tmp162_;
#line 4236 "CheckerboardLayout.c"
	} else {
#line 626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp160_ = FALSE;
#line 4240 "CheckerboardLayout.c"
	}
#line 626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp160_) {
#line 4244 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp163_ = NULL;
		GdkRectangle _tmp164_ = {0};
		gint _tmp165_ = 0;
		CheckerboardItemText* _tmp166_ = NULL;
		gint _tmp167_ = 0;
		CheckerboardItemText* _tmp168_ = NULL;
		Dimensions _tmp169_ = {0};
		gint _tmp170_ = 0;
		CheckerboardItemText* _tmp171_ = NULL;
		CheckerboardItemText* _tmp172_ = NULL;
		gint _tmp173_ = 0;
		cairo_t* _tmp174_ = NULL;
		CheckerboardItemText* _tmp175_ = NULL;
		GdkRectangle _tmp176_ = {0};
		gint _tmp177_ = 0;
		CheckerboardItemText* _tmp178_ = NULL;
		GdkRectangle _tmp179_ = {0};
		gint _tmp180_ = 0;
		cairo_t* _tmp181_ = NULL;
		CheckerboardItemText* _tmp182_ = NULL;
		Dimensions _tmp183_ = {0};
		gint _tmp184_ = 0;
		PangoLayout* _tmp185_ = NULL;
		PangoLayout* _tmp186_ = NULL;
#line 627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp163_ = self->priv->subtitle;
#line 627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp164_ = self->allocation;
#line 627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp165_ = _tmp164_.x;
#line 627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp163_->allocation.x = _tmp165_ + CHECKERBOARD_ITEM_FRAME_WIDTH;
#line 628 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp166_ = self->priv->subtitle;
#line 628 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp167_ = text_y;
#line 628 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp166_->allocation.y = _tmp167_;
#line 629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp168_ = self->priv->subtitle;
#line 629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp169_ = self->priv->pixbuf_dim;
#line 629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp170_ = _tmp169_.width;
#line 629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp168_->allocation.width = _tmp170_;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp171_ = self->priv->subtitle;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp172_ = self->priv->subtitle;
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp173_ = checkerboard_item_text_get_height (_tmp172_);
#line 630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp171_->allocation.height = _tmp173_;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp174_ = ctx;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp175_ = self->priv->subtitle;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp176_ = _tmp175_->allocation;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp177_ = _tmp176_.x;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp178_ = self->priv->subtitle;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp179_ = _tmp178_->allocation;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp180_ = _tmp179_.y;
#line 632 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp174_, (gdouble) _tmp177_, (gdouble) _tmp180_);
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp181_ = ctx;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp182_ = self->priv->subtitle;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp183_ = self->priv->pixbuf_dim;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp184_ = _tmp183_.width;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp185_ = checkerboard_item_text_get_pango_layout (_tmp182_, _tmp184_);
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp186_ = _tmp185_;
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp181_, _tmp186_);
#line 633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_tmp186_);
#line 4331 "CheckerboardLayout.c"
	}
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp187_ = ctx;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp188_ = *selected_color;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp189_ = _tmp188_.red;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp190_ = *selected_color;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp191_ = _tmp190_.green;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp192_ = *selected_color;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp193_ = _tmp192_.blue;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp194_ = *selected_color;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp195_ = _tmp194_.alpha;
#line 638 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgba (_tmp187_, _tmp189_, _tmp191_, _tmp193_, _tmp195_);
#line 642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp196_ = checkerboard_item_get_bottom_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 642 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp196_;
#line 643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp197_ = trinket;
#line 643 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp197_ != NULL) {
#line 4361 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp198_ = {0};
		gint _tmp199_ = 0;
		gint _tmp200_ = 0;
		gint y = 0;
		GdkPoint _tmp201_ = {0};
		gint _tmp202_ = 0;
		Dimensions _tmp203_ = {0};
		gint _tmp204_ = 0;
		GdkPixbuf* _tmp205_ = NULL;
		gint _tmp206_ = 0;
		cairo_t* _tmp207_ = NULL;
		GdkPixbuf* _tmp208_ = NULL;
		gint _tmp209_ = 0;
		gint _tmp210_ = 0;
		cairo_t* _tmp211_ = NULL;
		gint _tmp212_ = 0;
		gint _tmp213_ = 0;
		GdkPixbuf* _tmp214_ = NULL;
		gint _tmp215_ = 0;
		GdkPixbuf* _tmp216_ = NULL;
		gint _tmp217_ = 0;
		cairo_t* _tmp218_ = NULL;
#line 644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp198_ = pixbuf_origin;
#line 644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp199_ = _tmp198_.x;
#line 644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp200_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 644 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (_tmp199_ + CHECKERBOARD_ITEM_TRINKET_PADDING) + _tmp200_;
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp201_ = pixbuf_origin;
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp202_ = _tmp201_.y;
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp203_ = self->priv->pixbuf_dim;
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp204_ = _tmp203_.height;
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp205_ = trinket;
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp206_ = gdk_pixbuf_get_height (_tmp205_);
#line 645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = ((_tmp202_ + _tmp204_) - _tmp206_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp207_ = ctx;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp208_ = trinket;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp209_ = x;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp210_ = y;
#line 647 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp207_, _tmp208_, (gdouble) _tmp209_, (gdouble) _tmp210_);
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp211_ = ctx;
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp212_ = x;
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp213_ = y;
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp214_ = trinket;
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp215_ = gdk_pixbuf_get_width (_tmp214_);
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp216_ = trinket;
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp217_ = gdk_pixbuf_get_height (_tmp216_);
#line 648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp211_, (gdouble) _tmp212_, (gdouble) _tmp213_, (gdouble) _tmp215_, (gdouble) _tmp217_);
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp218_ = ctx;
#line 649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp218_);
#line 4437 "CheckerboardLayout.c"
	}
#line 652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp219_ = checkerboard_item_get_top_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 652 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp219_;
#line 653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp220_ = trinket;
#line 653 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp220_ != NULL) {
#line 4449 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp221_ = {0};
		gint _tmp222_ = 0;
		gint _tmp223_ = 0;
		gint y = 0;
		GdkPoint _tmp224_ = {0};
		gint _tmp225_ = 0;
		cairo_t* _tmp226_ = NULL;
		GdkPixbuf* _tmp227_ = NULL;
		gint _tmp228_ = 0;
		gint _tmp229_ = 0;
		cairo_t* _tmp230_ = NULL;
		gint _tmp231_ = 0;
		gint _tmp232_ = 0;
		GdkPixbuf* _tmp233_ = NULL;
		gint _tmp234_ = 0;
		GdkPixbuf* _tmp235_ = NULL;
		gint _tmp236_ = 0;
		cairo_t* _tmp237_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp221_ = pixbuf_origin;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp222_ = _tmp221_.x;
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp223_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 654 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (_tmp222_ + CHECKERBOARD_ITEM_TRINKET_PADDING) + _tmp223_;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp224_ = pixbuf_origin;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp225_ = _tmp224_.y;
#line 655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp225_ + CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp226_ = ctx;
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp227_ = trinket;
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp228_ = x;
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp229_ = y;
#line 656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp226_, _tmp227_, (gdouble) _tmp228_, (gdouble) _tmp229_);
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp230_ = ctx;
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp231_ = x;
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp232_ = y;
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp233_ = trinket;
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp234_ = gdk_pixbuf_get_width (_tmp233_);
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp235_ = trinket;
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp236_ = gdk_pixbuf_get_height (_tmp235_);
#line 657 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp230_, (gdouble) _tmp231_, (gdouble) _tmp232_, (gdouble) _tmp234_, (gdouble) _tmp236_);
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp237_ = ctx;
#line 658 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp237_);
#line 4513 "CheckerboardLayout.c"
	}
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp238_ = checkerboard_item_get_top_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 661 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp238_;
#line 662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp239_ = trinket;
#line 662 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp239_ != NULL) {
#line 4525 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp240_ = {0};
		gint _tmp241_ = 0;
		Dimensions _tmp242_ = {0};
		gint _tmp243_ = 0;
		GdkPixbuf* _tmp244_ = NULL;
		gint _tmp245_ = 0;
		gint _tmp246_ = 0;
		gint _tmp247_ = 0;
		gint y = 0;
		GdkPoint _tmp248_ = {0};
		gint _tmp249_ = 0;
		cairo_t* _tmp250_ = NULL;
		GdkPixbuf* _tmp251_ = NULL;
		gint _tmp252_ = 0;
		gint _tmp253_ = 0;
		cairo_t* _tmp254_ = NULL;
		gint _tmp255_ = 0;
		gint _tmp256_ = 0;
		GdkPixbuf* _tmp257_ = NULL;
		gint _tmp258_ = 0;
		GdkPixbuf* _tmp259_ = NULL;
		gint _tmp260_ = 0;
		cairo_t* _tmp261_ = NULL;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp240_ = pixbuf_origin;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp241_ = _tmp240_.x;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp242_ = self->priv->pixbuf_dim;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp243_ = _tmp242_.width;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp244_ = trinket;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp245_ = gdk_pixbuf_get_width (_tmp244_);
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp246_ = _tmp245_;
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp247_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 663 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (((_tmp241_ + _tmp243_) - _tmp246_) - _tmp247_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 665 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp248_ = pixbuf_origin;
#line 665 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp249_ = _tmp248_.y;
#line 665 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp249_ + CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp250_ = ctx;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp251_ = trinket;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp252_ = x;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp253_ = y;
#line 666 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp250_, _tmp251_, (gdouble) _tmp252_, (gdouble) _tmp253_);
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp254_ = ctx;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp255_ = x;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_ = y;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp257_ = trinket;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp258_ = gdk_pixbuf_get_width (_tmp257_);
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp259_ = trinket;
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp260_ = gdk_pixbuf_get_height (_tmp259_);
#line 667 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp254_, (gdouble) _tmp255_, (gdouble) _tmp256_, (gdouble) _tmp258_, (gdouble) _tmp260_);
#line 668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp261_ = ctx;
#line 668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp261_);
#line 4604 "CheckerboardLayout.c"
	}
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp262_ = checkerboard_item_get_bottom_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 671 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	trinket = _tmp262_;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp263_ = trinket;
#line 672 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp263_ != NULL) {
#line 4616 "CheckerboardLayout.c"
		gint x = 0;
		GdkPoint _tmp264_ = {0};
		gint _tmp265_ = 0;
		Dimensions _tmp266_ = {0};
		gint _tmp267_ = 0;
		GdkPixbuf* _tmp268_ = NULL;
		gint _tmp269_ = 0;
		gint _tmp270_ = 0;
		gint _tmp271_ = 0;
		gint y = 0;
		GdkPoint _tmp272_ = {0};
		gint _tmp273_ = 0;
		Dimensions _tmp274_ = {0};
		gint _tmp275_ = 0;
		GdkPixbuf* _tmp276_ = NULL;
		gint _tmp277_ = 0;
		gint _tmp278_ = 0;
		cairo_t* _tmp279_ = NULL;
		GdkPixbuf* _tmp280_ = NULL;
		gint _tmp281_ = 0;
		gint _tmp282_ = 0;
		cairo_t* _tmp283_ = NULL;
		gint _tmp284_ = 0;
		gint _tmp285_ = 0;
		GdkPixbuf* _tmp286_ = NULL;
		gint _tmp287_ = 0;
		GdkPixbuf* _tmp288_ = NULL;
		gint _tmp289_ = 0;
		cairo_t* _tmp290_ = NULL;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp264_ = pixbuf_origin;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp265_ = _tmp264_.x;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp266_ = self->priv->pixbuf_dim;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp267_ = _tmp266_.width;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp268_ = trinket;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = gdk_pixbuf_get_width (_tmp268_);
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp270_ = _tmp269_;
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp271_ = checkerboard_item_get_horizontal_trinket_offset (self);
#line 673 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = (((_tmp265_ + _tmp267_) - _tmp270_) - _tmp271_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp272_ = pixbuf_origin;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp273_ = _tmp272_.y;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp274_ = self->priv->pixbuf_dim;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp275_ = _tmp274_.height;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp276_ = trinket;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp277_ = gdk_pixbuf_get_height (_tmp276_);
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp278_ = _tmp277_;
#line 675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = ((_tmp273_ + _tmp275_) - _tmp278_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp279_ = ctx;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp280_ = trinket;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp281_ = x;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp282_ = y;
#line 677 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_cairo_set_source_pixbuf (_tmp279_, _tmp280_, (gdouble) _tmp281_, (gdouble) _tmp282_);
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp283_ = ctx;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp284_ = x;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp285_ = y;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp286_ = trinket;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp287_ = gdk_pixbuf_get_width (_tmp286_);
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp288_ = trinket;
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp289_ = gdk_pixbuf_get_height (_tmp288_);
#line 678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp283_, (gdouble) _tmp284_, (gdouble) _tmp285_, (gdouble) _tmp287_, (gdouble) _tmp289_);
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp290_ = ctx;
#line 679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp290_);
#line 4710 "CheckerboardLayout.c"
	}
#line 540 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (trinket);
#line 4714 "CheckerboardLayout.c"
}


void checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self, gint horizontal_trinket_offset) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 683 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = horizontal_trinket_offset;
#line 684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp0_ >= 0, "horizontal_trinket_offset >= 0");
#line 685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = horizontal_trinket_offset;
#line 685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->horizontal_trinket_offset = _tmp1_;
#line 4731 "CheckerboardLayout.c"
}


gint checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 688 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->horizontal_trinket_offset;
#line 689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 4746 "CheckerboardLayout.c"
}


void checkerboard_item_set_grid_coordinates (CheckerboardItem* self, gint col, gint row) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 692 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = col;
#line 693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->col = _tmp0_;
#line 694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = row;
#line 694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->row = _tmp1_;
#line 4763 "CheckerboardLayout.c"
}


gint checkerboard_item_get_column (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->col;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 4778 "CheckerboardLayout.c"
}


gint checkerboard_item_get_row (CheckerboardItem* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 701 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->row;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 702 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 4793 "CheckerboardLayout.c"
}


void checkerboard_item_brighten (CheckerboardItem* self) {
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->brightened;
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 4813 "CheckerboardLayout.c"
	} else {
		GdkPixbuf* _tmp2_ = NULL;
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->pixbuf;
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 4820 "CheckerboardLayout.c"
	}
#line 707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 708 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 4826 "CheckerboardLayout.c"
	}
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->pixbuf;
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 711 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = _tmp4_;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->brightened;
#line 712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	shift_colors (_tmp5_, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, 0);
#line 714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->brightened;
#line 714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp7_;
#line 716 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 4850 "CheckerboardLayout.c"
}


void checkerboard_item_unbrighten (CheckerboardItem* self) {
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
#line 719 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->brightened;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ == NULL) {
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 4867 "CheckerboardLayout.c"
	} else {
		GdkPixbuf* _tmp2_ = NULL;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->pixbuf;
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 4874 "CheckerboardLayout.c"
	}
#line 721 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 722 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 4880 "CheckerboardLayout.c"
	}
#line 724 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 724 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = NULL;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->pixbuf;
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 727 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = _tmp4_;
#line 729 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 4896 "CheckerboardLayout.c"
}


static void checkerboard_item_real_visibility_changed (DataView* base, gboolean visible) {
	CheckerboardItem * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 732 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 734 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = visible;
#line 734 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp0_) {
#line 735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_unbrighten (self);
#line 4912 "CheckerboardLayout.c"
	}
#line 737 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = visible;
#line 737 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	DATA_VIEW_CLASS (checkerboard_item_parent_class)->visibility_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_VIEW, DataView), _tmp1_);
#line 4918 "CheckerboardLayout.c"
}


static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self, CheckerboardItemText* text, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	CheckerboardItemText* _tmp0_ = NULL;
	PangoLayout* _tmp1_ = NULL;
	PangoLayout* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	CheckerboardItemText* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (text), FALSE);
#line 740 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_item_text_get_pango_layout (_tmp0_, 0);
#line 741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = pango_layout_is_ellipsized (_tmp2_);
#line 741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = !_tmp3_;
#line 741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_) {
#line 742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = FALSE;
#line 742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 4955 "CheckerboardLayout.c"
	}
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = text;
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = checkerboard_item_text_is_marked_up (_tmp5_);
#line 744 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_) {
#line 4963 "CheckerboardLayout.c"
		GtkTooltip* _tmp7_ = NULL;
		CheckerboardItemText* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = tooltip;
#line 745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = text;
#line 745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_text_get_text (_tmp8_);
#line 745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_tooltip_set_markup (_tmp7_, _tmp10_);
#line 745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp10_);
#line 4980 "CheckerboardLayout.c"
	} else {
		GtkTooltip* _tmp11_ = NULL;
		CheckerboardItemText* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = tooltip;
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = text;
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = checkerboard_item_text_get_text (_tmp12_);
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp13_;
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_tooltip_set_text (_tmp11_, _tmp14_);
#line 747 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp14_);
#line 4998 "CheckerboardLayout.c"
	}
#line 749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = TRUE;
#line 749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5004 "CheckerboardLayout.c"
}


gboolean checkerboard_item_query_tooltip (CheckerboardItem* self, gint x, gint y, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CheckerboardItemText* _tmp2_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	CheckerboardItemText* _tmp14_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	CheckerboardItemText* _tmp26_ = NULL;
#line 752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
#line 752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->title;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ != NULL) {
#line 5027 "CheckerboardLayout.c"
		gboolean _tmp3_ = FALSE;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->title_visible;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = _tmp3_;
#line 5033 "CheckerboardLayout.c"
	} else {
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = FALSE;
#line 5037 "CheckerboardLayout.c"
	}
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 5041 "CheckerboardLayout.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		CheckerboardItemText* _tmp6_ = NULL;
		GdkRectangle _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = x;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = y;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = self->priv->title;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_->allocation;
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = coord_in_rectangle (_tmp4_, _tmp5_, &_tmp7_);
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp8_;
#line 5059 "CheckerboardLayout.c"
	} else {
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 5063 "CheckerboardLayout.c"
	}
#line 753 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 5067 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp9_ = NULL;
		GtkTooltip* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = self->priv->title;
#line 754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = tooltip;
#line 754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = checkerboard_item_query_tooltip_on_text (self, _tmp9_, _tmp10_);
#line 754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp11_;
#line 754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5081 "CheckerboardLayout.c"
	}
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = self->priv->comment;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 5087 "CheckerboardLayout.c"
		gboolean _tmp15_ = FALSE;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = self->priv->comment_visible;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp15_;
#line 5093 "CheckerboardLayout.c"
	} else {
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = FALSE;
#line 5097 "CheckerboardLayout.c"
	}
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 5101 "CheckerboardLayout.c"
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		CheckerboardItemText* _tmp18_ = NULL;
		GdkRectangle _tmp19_ = {0};
		gboolean _tmp20_ = FALSE;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = x;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = y;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = self->priv->comment;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _tmp18_->allocation;
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = coord_in_rectangle (_tmp16_, _tmp17_, &_tmp19_);
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp20_;
#line 5119 "CheckerboardLayout.c"
	} else {
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = FALSE;
#line 5123 "CheckerboardLayout.c"
	}
#line 756 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_) {
#line 5127 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp21_ = NULL;
		GtkTooltip* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->comment;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = tooltip;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = checkerboard_item_query_tooltip_on_text (self, _tmp21_, _tmp22_);
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp23_;
#line 757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5141 "CheckerboardLayout.c"
	}
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = self->priv->subtitle;
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp26_ != NULL) {
#line 5147 "CheckerboardLayout.c"
		gboolean _tmp27_ = FALSE;
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = self->priv->subtitle_visible;
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = _tmp27_;
#line 5153 "CheckerboardLayout.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = FALSE;
#line 5157 "CheckerboardLayout.c"
	}
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp25_) {
#line 5161 "CheckerboardLayout.c"
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		CheckerboardItemText* _tmp30_ = NULL;
		GdkRectangle _tmp31_ = {0};
		gboolean _tmp32_ = FALSE;
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = x;
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = y;
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = self->priv->subtitle;
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = _tmp30_->allocation;
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = coord_in_rectangle (_tmp28_, _tmp29_, &_tmp31_);
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp32_;
#line 5179 "CheckerboardLayout.c"
	} else {
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = FALSE;
#line 5183 "CheckerboardLayout.c"
	}
#line 759 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp24_) {
#line 5187 "CheckerboardLayout.c"
		CheckerboardItemText* _tmp33_ = NULL;
		GtkTooltip* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
#line 760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = self->priv->subtitle;
#line 760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = tooltip;
#line 760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = checkerboard_item_query_tooltip_on_text (self, _tmp33_, _tmp34_);
#line 760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = _tmp35_;
#line 760 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 5201 "CheckerboardLayout.c"
	}
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5207 "CheckerboardLayout.c"
}


static void checkerboard_item_class_init (CheckerboardItemClass * klass) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_parent_class = g_type_class_peek_parent (klass);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardItemPrivate));
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->get_name = checkerboard_item_real_get_name;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->notify_membership_changed = checkerboard_item_real_notify_membership_changed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataObjectClass *) klass)->notify_collection_property_set = checkerboard_item_real_notify_collection_property_set;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->exposed = checkerboard_item_real_exposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->unexposed = checkerboard_item_real_unexposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->is_exposed = checkerboard_item_real_is_exposed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_shadow = checkerboard_item_real_paint_shadow;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_border = checkerboard_item_real_paint_border;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->paint_image = checkerboard_item_real_paint_image;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_top_left_trinket = checkerboard_item_real_get_top_left_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_top_right_trinket = checkerboard_item_real_get_top_right_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = checkerboard_item_real_get_bottom_left_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardItemClass *) klass)->get_bottom_right_trinket = checkerboard_item_real_get_bottom_right_trinket;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((DataViewClass *) klass)->visibility_changed = checkerboard_item_real_visibility_changed;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->finalize = checkerboard_item_finalize;
#line 5246 "CheckerboardLayout.c"
}


static void checkerboard_item_instance_init (CheckerboardItem * self) {
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_ITEM_GET_PRIVATE (self);
#line 119 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&self->requisition, 0, 0);
#line 120 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->allocation, 0, sizeof (GdkRectangle));
#line 122 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure = FALSE;
#line 123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title = NULL;
#line 124 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->title_visible = TRUE;
#line 125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment = NULL;
#line 126 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->comment_visible = TRUE;
#line 127 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle = NULL;
#line 128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->subtitle_visible = FALSE;
#line 129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_cursor = FALSE;
#line 130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->pixbuf = NULL;
#line 131 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->display_pixbuf = NULL;
#line 132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->brightened = NULL;
#line 133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_init (&self->priv->pixbuf_dim, 0, 0);
#line 134 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->col = -1;
#line 135 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->row = -1;
#line 136 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->horizontal_trinket_offset = 0;
#line 5287 "CheckerboardLayout.c"
}


static void checkerboard_item_finalize (GObject* obj) {
	CheckerboardItem * self;
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->title);
#line 125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->comment);
#line 127 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_item_text_unref0 (self->priv->subtitle);
#line 130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->pixbuf);
#line 131 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->display_pixbuf);
#line 132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->brightened);
#line 98 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (checkerboard_item_parent_class)->finalize (obj);
#line 5309 "CheckerboardLayout.c"
}


GType checkerboard_item_get_type (void) {
	static volatile gsize checkerboard_item_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItem), 0, (GInstanceInitFunc) checkerboard_item_instance_init, NULL };
		GType checkerboard_item_type_id;
		checkerboard_item_type_id = g_type_register_static (TYPE_THUMBNAIL_VIEW, "CheckerboardItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&checkerboard_item_type_id__volatile, checkerboard_item_type_id);
	}
	return checkerboard_item_type_id__volatile;
}


static void _checkerboard_layout_on_contents_altered_data_collection_contents_altered (DataCollection* _sender, GeeIterable* added, GeeIterable* removed, gpointer self) {
#line 852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_contents_altered ((CheckerboardLayout*) self, added, removed);
#line 5328 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_altered ((CheckerboardLayout*) self);
#line 5335 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed (ViewCollection* _sender, GeeIterable* changed, gpointer self) {
#line 854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_state_changed ((CheckerboardLayout*) self, changed);
#line 5342 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed (ViewCollection* _sender, GeeCollection* changed, gpointer self) {
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_visibility_changed ((CheckerboardLayout*) self, changed);
#line 5349 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed (DataCollection* _sender, gpointer self) {
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_ordering_changed ((CheckerboardLayout*) self);
#line 5356 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_views_altered_view_collection_views_altered (ViewCollection* _sender, GeeCollection* views, gpointer self) {
#line 857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_views_altered ((CheckerboardLayout*) self, views);
#line 5363 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered (ViewCollection* _sender, GeeCollection* views, gpointer self) {
#line 858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_geometries_altered ((CheckerboardLayout*) self);
#line 5370 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_selection_changed_view_collection_items_selected (ViewCollection* _sender, GeeIterable* selected, gpointer self) {
#line 859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
#line 5377 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected (ViewCollection* _sender, GeeIterable* unselected, gpointer self) {
#line 860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_selection_changed ((CheckerboardLayout*) self);
#line 5384 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_viewport_shifted ((CheckerboardLayout*) self);
#line 5391 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 869 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_viewport_resized ((CheckerboardLayout*) self);
#line 5398 "CheckerboardLayout.c"
}


static void _checkerboard_layout_on_colors_changed_config_facade_colors_changed (ConfigFacade* _sender, gpointer self) {
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_colors_changed ((CheckerboardLayout*) self);
#line 5405 "CheckerboardLayout.c"
}


static gpointer _data_collection_ref0 (gpointer self) {
#line 824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? data_collection_ref (self) : NULL;
#line 5412 "CheckerboardLayout.c"
}


CheckerboardLayout* checkerboard_layout_construct (GType object_type, ViewCollection* view) {
	CheckerboardLayout * self = NULL;
	ViewCollection* _tmp0_ = NULL;
	ViewCollection* _tmp1_ = NULL;
	ViewCollection* _tmp2_ = NULL;
	ViewCollection* _tmp3_ = NULL;
	ViewCollection* _tmp4_ = NULL;
	ViewCollection* _tmp5_ = NULL;
	ViewCollection* _tmp6_ = NULL;
	ViewCollection* _tmp7_ = NULL;
	ViewCollection* _tmp8_ = NULL;
	ViewCollection* _tmp9_ = NULL;
	ViewCollection* _tmp10_ = NULL;
	ConfigFacade* _tmp11_ = NULL;
	ConfigFacade* _tmp12_ = NULL;
	GdkRGBA _tmp13_ = {0};
	ConfigFacade* _tmp14_ = NULL;
	ConfigFacade* _tmp15_ = NULL;
#line 823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_VIEW_COLLECTION (view), NULL);
#line 823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardLayout*) g_object_new (object_type, NULL);
#line 824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = view;
#line 824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _data_collection_ref0 (_tmp0_);
#line 824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_data_collection_unref0 (self->priv->view);
#line 824 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->view = _tmp1_;
#line 826 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_drag_select (self);
#line 829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = view;
#line 829 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), "contents-altered", (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self, 0);
#line 830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = view;
#line 830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self, 0);
#line 831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = view;
#line 831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp4_, "items-state-changed", (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self, 0);
#line 832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = view;
#line 832 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp5_, "items-visibility-changed", (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self, 0);
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = view;
#line 833 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_DATA_COLLECTION, DataCollection), "ordering-changed", (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self, 0);
#line 834 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = view;
#line 834 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp7_, "views-altered", (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self, 0);
#line 835 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = view;
#line 835 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp8_, "geometries-altered", (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self, 0);
#line 836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = view;
#line 836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp9_, "items-selected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self, 0);
#line 837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = view;
#line 837 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp10_, "items-unselected", (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self, 0);
#line 839 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = config_facade_get_instance ();
#line 839 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = _tmp11_;
#line 839 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_bg_color (_tmp12_, &_tmp13_);
#line 839 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp13_);
#line 839 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp12_);
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = config_facade_get_instance ();
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_;
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp15_, "colors-changed", (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self, 0);
#line 841 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp15_);
#line 844 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_set_has_tooltip (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
#line 823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 5506 "CheckerboardLayout.c"
}


CheckerboardLayout* checkerboard_layout_new (ViewCollection* view) {
#line 823 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_layout_construct (TYPE_CHECKERBOARD_LAYOUT, view);
#line 5513 "CheckerboardLayout.c"
}


void checkerboard_layout_set_adjustments (CheckerboardLayout* self, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment) {
	GtkAdjustment* _tmp0_ = NULL;
	GtkAdjustment* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	GtkAdjustment* _tmp4_ = NULL;
	GtkAdjustment* _tmp5_ = NULL;
	GtkContainer* _tmp6_ = NULL;
	GtkContainer* _tmp7_ = NULL;
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GTK_IS_ADJUSTMENT (hadjustment));
#line 874 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GTK_IS_ADJUSTMENT (vadjustment));
#line 875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = hadjustment;
#line 875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->hadjustment);
#line 875 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->hadjustment = _tmp1_;
#line 876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = vadjustment;
#line 876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->vadjustment);
#line 876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->vadjustment = _tmp3_;
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = hadjustment;
#line 879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp4_, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
#line 880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = vadjustment;
#line 880 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (_tmp5_, "value-changed", (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self, 0);
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_;
#line 883 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self, 0);
#line 5562 "CheckerboardLayout.c"
}


void checkerboard_layout_set_scale (CheckerboardLayout* self, gint scale) {
	gint _tmp0_ = 0;
#line 888 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = scale;
#line 889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->scale = _tmp0_;
#line 5574 "CheckerboardLayout.c"
}


gint checkerboard_layout_get_scale (CheckerboardLayout* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), 0);
#line 893 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->scale;
#line 893 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 893 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 5589 "CheckerboardLayout.c"
}


void checkerboard_layout_set_name (CheckerboardLayout* self, const gchar* name) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (name != NULL);
#line 897 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = name;
#line 897 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 897 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->page_name);
#line 897 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->page_name = _tmp1_;
#line 5608 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_viewport_resized (CheckerboardLayout* self) {
	GtkRequisition req = {0};
	GtkRequisition _tmp0_ = {0};
	GtkAllocation parent_allocation = {0};
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_ = NULL;
	GtkAllocation _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 900 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), NULL, &_tmp0_);
#line 902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	req = _tmp0_;
#line 905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), &_tmp3_);
#line 905 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	parent_allocation = _tmp3_;
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->message;
#line 907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ == NULL) {
#line 5639 "CheckerboardLayout.c"
		GtkRequisition _tmp5_ = {0};
		gint _tmp6_ = 0;
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = req;
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.height;
#line 916 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp6_ != 0) {
#line 5648 "CheckerboardLayout.c"
			GtkAllocation _tmp7_ = {0};
			gint _tmp8_ = 0;
			GtkRequisition _tmp9_ = {0};
			gint _tmp10_ = 0;
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = parent_allocation;
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _tmp7_.width;
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = req;
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _tmp9_.height;
#line 917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp8_ - CHECKERBOARD_LAYOUT_SCROLLBAR_PLACEHOLDER_WIDTH, _tmp10_);
#line 5663 "CheckerboardLayout.c"
		}
	} else {
		GtkAllocation _tmp11_ = {0};
		gint _tmp12_ = 0;
		GtkAllocation _tmp13_ = {0};
		gint _tmp14_ = 0;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = parent_allocation;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = _tmp11_.width;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = parent_allocation;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = _tmp13_.height;
#line 921 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp12_, _tmp14_);
#line 5680 "CheckerboardLayout.c"
	}
#line 926 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_viewport_resized (self);
#line 928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->size_allocate_due_to_reflow;
#line 928 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp15_) {
#line 929 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_clear_anchor (self);
#line 5690 "CheckerboardLayout.c"
	} else {
#line 931 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->size_allocate_due_to_reflow = FALSE;
#line 5694 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_on_viewport_shifted (CheckerboardLayout* self) {
#line 934 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 935 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_update_visible_page (self);
#line 936 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_exposure (self, "on_viewport_shift");
#line 938 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_anchor (self);
#line 5708 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_selection_changed (CheckerboardLayout* self) {
#line 941 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 942 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_anchor (self);
#line 5717 "CheckerboardLayout.c"
}


static void checkerboard_layout_clear_anchor (CheckerboardLayout* self) {
	gboolean _tmp0_ = FALSE;
#line 945 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->in_center_on_anchor;
#line 946 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 947 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5731 "CheckerboardLayout.c"
	}
#line 949 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 949 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = NULL;
#line 5737 "CheckerboardLayout.c"
}


static void checkerboard_layout_update_anchor (CheckerboardLayout* self) {
	gboolean _tmp0_ = FALSE;
	GeeList* items_on_page = NULL;
	GdkRectangle _tmp1_ = {0};
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkAdjustment* _tmp21_ = NULL;
	gdouble _tmp22_ = 0.0;
	GeeList* _tmp23_ = NULL;
	GeeList* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gpointer _tmp27_ = NULL;
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->in_center_on_anchor;
#line 953 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (!_tmp0_, "!in_center_on_anchor");
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->visible_page;
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_intersection (self, &_tmp1_);
#line 955 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	items_on_page = _tmp2_;
#line 956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = items_on_page;
#line 956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 956 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_ == 0) {
#line 957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->anchor);
#line 957 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->anchor = NULL;
#line 958 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (items_on_page);
#line 958 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5784 "CheckerboardLayout.c"
	}
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
		gint _item_size = 0;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _item_index = 0;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = items_on_page;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_list = _tmp7_;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _item_list;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_size = _tmp10_;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_index = -1;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 5813 "CheckerboardLayout.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			CheckerboardItem* item = NULL;
			GeeList* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			CheckerboardItem* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_index;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = _tmp11_ + 1;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _item_index;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _item_size;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 5835 "CheckerboardLayout.c"
			}
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = _item_list;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = _item_index;
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp16_;
#line 962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = item;
#line 962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_VIEW, DataView));
#line 962 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp18_) {
#line 5851 "CheckerboardLayout.c"
				CheckerboardItem* _tmp19_ = NULL;
				CheckerboardItem* _tmp20_ = NULL;
#line 963 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = item;
#line 963 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = _g_object_ref0 (_tmp19_);
#line 963 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (self->priv->anchor);
#line 963 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				self->priv->anchor = _tmp20_;
#line 964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_item_list);
#line 964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (items_on_page);
#line 964 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				return;
#line 5870 "CheckerboardLayout.c"
			}
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 5874 "CheckerboardLayout.c"
		}
#line 961 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_list);
#line 5878 "CheckerboardLayout.c"
	}
#line 968 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->vadjustment;
#line 968 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp22_ = gtk_adjustment_get_value (_tmp21_);
#line 968 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp22_ == ((gdouble) 0)) {
#line 969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (self->priv->anchor);
#line 969 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->anchor = NULL;
#line 970 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (items_on_page);
#line 970 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5894 "CheckerboardLayout.c"
	}
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp23_ = items_on_page;
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = items_on_page;
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_COLLECTION, GeeCollection));
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp26_ = _tmp25_;
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = gee_list_get (_tmp23_, ((gint) _tmp26_) / 2);
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 975 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = (CheckerboardItem*) _tmp27_;
#line 952 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (items_on_page);
#line 5912 "CheckerboardLayout.c"
}


static void checkerboard_layout_center_on_anchor (CheckerboardLayout* self, gdouble upper) {
	CheckerboardItem* _tmp0_ = NULL;
	gdouble anchor_pos = 0.0;
	CheckerboardItem* _tmp1_ = NULL;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	CheckerboardItem* _tmp4_ = NULL;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	GtkAdjustment* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GtkAdjustment* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	GtkAdjustment* _tmp11_ = NULL;
	gdouble _tmp12_ = 0.0;
	GtkAdjustment* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	GtkAdjustment* _tmp15_ = NULL;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
#line 978 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->anchor;
#line 979 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ == NULL) {
#line 980 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 5944 "CheckerboardLayout.c"
	}
#line 982 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = TRUE;
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->anchor;
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_->allocation;
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.y;
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->anchor;
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_->allocation;
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.height;
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->vadjustment;
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = gtk_adjustment_get_page_size (_tmp7_);
#line 984 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	anchor_pos = (_tmp3_ + (_tmp6_ / 2)) - (_tmp8_ / 2);
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->vadjustment;
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = anchor_pos;
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->vadjustment;
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = gtk_adjustment_get_lower (_tmp11_);
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = self->priv->vadjustment;
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = gtk_adjustment_get_upper (_tmp13_);
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = self->priv->vadjustment;
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = gtk_adjustment_get_page_size (_tmp15_);
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp17_ = CLAMP (_tmp10_, _tmp12_, _tmp14_ - _tmp16_);
#line 986 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_adjustment_set_value (_tmp9_, _tmp17_);
#line 989 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = FALSE;
#line 5988 "CheckerboardLayout.c"
}


void checkerboard_layout_set_cursor (CheckerboardLayout* self, CheckerboardItem* item) {
	GeeHashSet* collection = NULL;
	GeeHashSet* _tmp0_ = NULL;
	CheckerboardItem* _tmp1_ = NULL;
	CheckerboardItem* _tmp8_ = NULL;
	CheckerboardItem* _tmp9_ = NULL;
	CheckerboardItem* _tmp10_ = NULL;
	GeeHashSet* _tmp11_ = NULL;
	CheckerboardItem* _tmp12_ = NULL;
	GeeHashSet* _tmp13_ = NULL;
#line 992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_ITEM (item));
#line 993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_hash_set_new (TYPE_DATA_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 993 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	collection = _tmp0_;
#line 994 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->cursor;
#line 994 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6014 "CheckerboardLayout.c"
		CheckerboardItem* _tmp2_ = NULL;
		ViewCollection* _tmp3_ = NULL;
		CheckerboardItem* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->cursor;
#line 995 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_item_set_is_cursor (_tmp2_, FALSE);
#line 997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->view;
#line 997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->cursor;
#line 997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_OBJECT, DataObject));
#line 997 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp5_) {
#line 6031 "CheckerboardLayout.c"
			GeeHashSet* _tmp6_ = NULL;
			CheckerboardItem* _tmp7_ = NULL;
#line 998 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = collection;
#line 998 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = self->priv->cursor;
#line 998 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_VIEW, DataView));
#line 6040 "CheckerboardLayout.c"
		}
	}
#line 1001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = item;
#line 1001 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_item_set_is_cursor (_tmp8_, TRUE);
#line 1002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = item;
#line 1002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 1002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->cursor);
#line 1002 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->cursor = _tmp10_;
#line 1003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = collection;
#line 1003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = item;
#line 1003 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_DATA_VIEW, DataView));
#line 1004 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = collection;
#line 1004 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_on_items_state_changed (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ITERABLE, GeeIterable));
#line 992 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (collection);
#line 6067 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_cursor (CheckerboardLayout* self) {
	CheckerboardItem* result = NULL;
	CheckerboardItem* _tmp0_ = NULL;
	CheckerboardItem* _tmp1_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->cursor;
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 1008 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6085 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_contents_altered (CheckerboardLayout* self, GeeIterable* added, GeeIterable* removed) {
	GeeIterable* _tmp0_ = NULL;
	GeeIterable* _tmp1_ = NULL;
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 1012 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = added;
#line 1014 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 1015 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (self->priv->message);
#line 1015 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->message = NULL;
#line 6106 "CheckerboardLayout.c"
	}
#line 1017 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = removed;
#line 1017 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6112 "CheckerboardLayout.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp2_ = NULL;
			GeeIterator* _tmp3_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp2_ = removed;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = gee_iterable_iterator (_tmp2_);
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_object_it = _tmp3_;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 6125 "CheckerboardLayout.c"
				GeeIterator* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				DataObject* object = NULL;
				GeeIterator* _tmp6_ = NULL;
				gpointer _tmp7_ = NULL;
				GeeHashSet* _tmp8_ = NULL;
				DataObject* _tmp9_ = NULL;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = _object_it;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = gee_iterator_next (_tmp4_);
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp5_) {
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 6141 "CheckerboardLayout.c"
				}
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = _object_it;
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp7_ = gee_iterator_get (_tmp6_);
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				object = (DataObject*) _tmp7_;
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp8_ = self->priv->exposed_items;
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = object;
#line 1019 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (object);
#line 6157 "CheckerboardLayout.c"
			}
#line 1018 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (_object_it);
#line 6161 "CheckerboardLayout.c"
		}
	}
#line 1024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 1024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 1024 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1026 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_contents_altered");
#line 6174 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_altered (CheckerboardLayout* self) {
#line 1029 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1030 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_items_altered");
#line 6183 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_state_changed (CheckerboardLayout* self, GeeIterable* changed) {
	GeeIterable* _tmp0_ = NULL;
#line 1033 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1033 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = changed;
#line 1034 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "on_items_state_changed", _tmp0_);
#line 6197 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_items_visibility_changed (CheckerboardLayout* self, GeeIterable* changed) {
#line 1037 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1037 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (changed));
#line 1038 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_items_visibility_changed");
#line 6208 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_ordering_changed (CheckerboardLayout* self) {
#line 1041 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1042 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_ordering_changed");
#line 6217 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_views_altered (CheckerboardLayout* self, GeeCollection* altered) {
	GeeCollection* _tmp0_ = NULL;
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1045 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_COLLECTION (altered));
#line 1046 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = altered;
#line 1046 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "on_views_altered", G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ITERABLE, GeeIterable));
#line 6231 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_geometries_altered (CheckerboardLayout* self) {
#line 1049 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1050 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_reflow (self, "on_geometries_altered");
#line 6240 "CheckerboardLayout.c"
}


static gboolean _checkerboard_layout_do_reflow_gsource_func (gpointer self) {
	gboolean result;
	result = checkerboard_layout_do_reflow ((CheckerboardLayout*) self);
#line 1066 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6249 "CheckerboardLayout.c"
}


static void checkerboard_layout_need_reflow (CheckerboardLayout* self, const gchar* caller) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1053 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1054 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->flow_scheduled;
#line 1054 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1055 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6266 "CheckerboardLayout.c"
	}
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->is_in_view;
#line 1057 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp1_) {
#line 1058 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->reflow_needed = TRUE;
#line 1059 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6276 "CheckerboardLayout.c"
	}
#line 1065 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = TRUE;
#line 1066 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_idle_add_full (G_PRIORITY_HIGH, _checkerboard_layout_do_reflow_gsource_func, g_object_ref (self), g_object_unref);
#line 6282 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_do_reflow (CheckerboardLayout* self) {
	gboolean result = FALSE;
#line 1069 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1070 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_reflow (self, "do_reflow");
#line 1071 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_need_exposure (self, "do_reflow");
#line 1073 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = FALSE;
#line 1075 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = FALSE;
#line 1075 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6300 "CheckerboardLayout.c"
}


static void checkerboard_layout_need_exposure (CheckerboardLayout* self, const gchar* caller) {
#line 1078 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1078 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1082 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = TRUE;
#line 1083 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 6313 "CheckerboardLayout.c"
}


void checkerboard_layout_set_message (CheckerboardLayout* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 1086 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1087 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = text;
#line 1087 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->message;
#line 1087 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 1088 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 6333 "CheckerboardLayout.c"
	}
#line 1090 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = text;
#line 1090 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1090 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->message);
#line 1090 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->message = _tmp3_;
#line 1092 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = text;
#line 1092 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 6347 "CheckerboardLayout.c"
		GtkContainer* _tmp5_ = NULL;
		GtkContainer* _tmp6_ = NULL;
#line 1095 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1095 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_;
#line 1095 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp6_ != NULL) {
#line 6356 "CheckerboardLayout.c"
			GtkAllocation parent_allocation = {0};
			GtkContainer* _tmp7_ = NULL;
			GtkContainer* _tmp8_ = NULL;
			GtkAllocation _tmp9_ = {0};
			GtkAllocation _tmp10_ = {0};
			gint _tmp11_ = 0;
			GtkAllocation _tmp12_ = {0};
			gint _tmp13_ = 0;
#line 1097 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1097 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _tmp7_;
#line 1097 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), &_tmp9_);
#line 1097 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			parent_allocation = _tmp9_;
#line 1099 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = parent_allocation;
#line 1099 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _tmp10_.width;
#line 1099 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = parent_allocation;
#line 1099 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _tmp12_.height;
#line 1099 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp11_, _tmp13_);
#line 6383 "CheckerboardLayout.c"
		}
	} else {
#line 1103 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_reflow (self, "set_message");
#line 6388 "CheckerboardLayout.c"
	}
}


void checkerboard_layout_unset_message (CheckerboardLayout* self) {
#line 1107 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1108 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_message (self, NULL);
#line 6398 "CheckerboardLayout.c"
}


static void checkerboard_layout_update_visible_page (CheckerboardLayout* self) {
	gboolean _tmp0_ = FALSE;
	GtkAdjustment* _tmp1_ = NULL;
#line 1111 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->hadjustment;
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 6411 "CheckerboardLayout.c"
		GtkAdjustment* _tmp2_ = NULL;
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->vadjustment;
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 6417 "CheckerboardLayout.c"
	} else {
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 6421 "CheckerboardLayout.c"
	}
#line 1112 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 6425 "CheckerboardLayout.c"
		GtkAdjustment* _tmp3_ = NULL;
		GtkAdjustment* _tmp4_ = NULL;
		GdkRectangle _tmp5_ = {0};
#line 1113 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->hadjustment;
#line 1113 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->vadjustment;
#line 1113 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		get_adjustment_page (_tmp3_, _tmp4_, &_tmp5_);
#line 1113 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->visible_page = _tmp5_;
#line 6437 "CheckerboardLayout.c"
	}
}


void checkerboard_layout_set_in_view (CheckerboardLayout* self, gboolean in_view) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 1116 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1117 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = in_view;
#line 1117 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_in_view = _tmp0_;
#line 1119 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = in_view;
#line 1119 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_) {
#line 6455 "CheckerboardLayout.c"
		gboolean _tmp2_ = FALSE;
#line 1120 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->reflow_needed;
#line 1120 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp2_) {
#line 1121 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_need_reflow (self, "set_in_view (true)");
#line 6463 "CheckerboardLayout.c"
		} else {
#line 1123 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_need_exposure (self, "set_in_view (true)");
#line 6467 "CheckerboardLayout.c"
		}
	} else {
#line 1125 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_unexpose_items (self, "set_in_view (false)");
#line 6472 "CheckerboardLayout.c"
	}
}


static gpointer _checkerboard_layout_layout_row_ref0 (gpointer self) {
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self ? checkerboard_layout_layout_row_ref (self) : NULL;
#line 6480 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_at_pixel (CheckerboardLayout* self, gdouble xd, gdouble yd) {
	CheckerboardItem* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gint x = 0;
	gdouble _tmp3_ = 0.0;
	gint y = 0;
	gdouble _tmp4_ = 0.0;
	CheckerboardLayoutLayoutRow* in_range = NULL;
	gint min = 0;
	gint max = 0;
	CheckerboardLayoutLayoutRow** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	CheckerboardLayoutLayoutRow* _tmp30_ = NULL;
	CheckerboardLayoutLayoutRow* _tmp31_ = NULL;
	CheckerboardItem** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
#line 1128 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->message;
#line 1129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != NULL) {
#line 1129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 6509 "CheckerboardLayout.c"
	} else {
		CheckerboardLayoutLayoutRow** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
#line 1129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = self->priv->item_rows;
#line 1129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2__length1 = self->priv->item_rows_length1;
#line 1129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 6519 "CheckerboardLayout.c"
	}
#line 1129 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1130 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 6527 "CheckerboardLayout.c"
	}
#line 1132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = xd;
#line 1132 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	x = (gint) _tmp3_;
#line 1133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = yd;
#line 1133 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	y = (gint) _tmp4_;
#line 1136 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	in_range = NULL;
#line 1137 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	min = 0;
#line 1138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = self->priv->item_rows;
#line 1138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5__length1 = self->priv->item_rows_length1;
#line 1138 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max = _tmp5__length1;
#line 6547 "CheckerboardLayout.c"
	{
		gboolean _tmp6_ = FALSE;
#line 1139 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = TRUE;
#line 1139 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 6554 "CheckerboardLayout.c"
			gint mid = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			CheckerboardLayoutLayoutRow* row = NULL;
			CheckerboardLayoutLayoutRow** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp11_ = 0;
			CheckerboardLayoutLayoutRow* _tmp12_ = NULL;
			CheckerboardLayoutLayoutRow* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			CheckerboardLayoutLayoutRow* _tmp15_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 1139 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp6_) {
#line 6571 "CheckerboardLayout.c"
			}
#line 1139 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = FALSE;
#line 1140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = min;
#line 1140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = max;
#line 1140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = min;
#line 1140 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			mid = _tmp7_ + ((_tmp8_ - _tmp9_) / 2);
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = self->priv->item_rows;
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10__length1 = self->priv->item_rows_length1;
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = mid;
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _tmp10_[_tmp11_];
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _checkerboard_layout_layout_row_ref0 (_tmp12_);
#line 1141 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp13_;
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = row;
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp15_ == NULL) {
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = TRUE;
#line 6601 "CheckerboardLayout.c"
			} else {
				gint _tmp16_ = 0;
				CheckerboardLayoutLayoutRow* _tmp17_ = NULL;
				gint _tmp18_ = 0;
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = y;
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = row;
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->y;
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _tmp16_ < _tmp18_;
#line 6614 "CheckerboardLayout.c"
			}
#line 1143 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp14_) {
#line 6618 "CheckerboardLayout.c"
				gint _tmp19_ = 0;
#line 1146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = mid;
#line 1146 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max = _tmp19_ - 1;
#line 6624 "CheckerboardLayout.c"
			} else {
				gint _tmp20_ = 0;
				CheckerboardLayoutLayoutRow* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				CheckerboardLayoutLayoutRow* _tmp23_ = NULL;
				gint _tmp24_ = 0;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = y;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = row;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_->y;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = row;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = _tmp23_->height;
#line 1147 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp20_ > (_tmp22_ + _tmp24_)) {
#line 6643 "CheckerboardLayout.c"
					gint _tmp25_ = 0;
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp25_ = mid;
#line 1149 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					min = _tmp25_ + 1;
#line 6649 "CheckerboardLayout.c"
				} else {
					CheckerboardLayoutLayoutRow* _tmp26_ = NULL;
					CheckerboardLayoutLayoutRow* _tmp27_ = NULL;
#line 1152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = row;
#line 1152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _checkerboard_layout_layout_row_ref0 (_tmp26_);
#line 1152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (in_range);
#line 1152 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					in_range = _tmp27_;
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1154 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 6665 "CheckerboardLayout.c"
				}
			}
#line 1157 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp28_ = min;
#line 1157 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = max;
#line 1157 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp28_ > _tmp29_) {
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_checkerboard_layout_layout_row_unref0 (row);
#line 1158 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 6678 "CheckerboardLayout.c"
			}
#line 1139 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_checkerboard_layout_layout_row_unref0 (row);
#line 6682 "CheckerboardLayout.c"
		}
	}
#line 1161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = in_range;
#line 1161 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp30_ == NULL) {
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (in_range);
#line 1162 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 6695 "CheckerboardLayout.c"
	}
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp31_ = in_range;
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32_ = _tmp31_->items;
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp32__length1 = _tmp31_->items_length1;
#line 6703 "CheckerboardLayout.c"
	{
		CheckerboardItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		item_collection = _tmp32_;
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		item_collection_length1 = _tmp32__length1;
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		for (item_it = 0; item_it < _tmp32__length1; item_it = item_it + 1) {
#line 6715 "CheckerboardLayout.c"
			CheckerboardItem* _tmp33_ = NULL;
			CheckerboardItem* item = NULL;
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp33_ = _g_object_ref0 (item_collection[item_it]);
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = _tmp33_;
#line 6722 "CheckerboardLayout.c"
			{
				CheckerboardItem* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				CheckerboardItem* _tmp36_ = NULL;
				GdkRectangle _tmp37_ = {0};
				gint _tmp38_ = 0;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_ = FALSE;
				gint _tmp41_ = 0;
				CheckerboardItem* _tmp42_ = NULL;
				GdkRectangle _tmp43_ = {0};
				gint _tmp44_ = 0;
				CheckerboardItem* _tmp45_ = NULL;
				GdkRectangle _tmp46_ = {0};
				gint _tmp47_ = 0;
#line 1168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp34_ = item;
#line 1168 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp34_ == NULL) {
#line 1169 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 1169 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 6746 "CheckerboardLayout.c"
				}
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp35_ = x;
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = item;
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp37_ = _tmp36_->allocation;
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp38_ = _tmp37_.x;
#line 1171 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp35_ < _tmp38_) {
#line 1173 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 1173 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 6762 "CheckerboardLayout.c"
				}
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp41_ = x;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp42_ = item;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp43_ = _tmp42_->allocation;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp44_ = _tmp43_.x;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp45_ = item;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp46_ = _tmp45_->allocation;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp47_ = _tmp46_.width;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp41_ <= (_tmp44_ + _tmp47_)) {
#line 6780 "CheckerboardLayout.c"
					gint _tmp48_ = 0;
					CheckerboardItem* _tmp49_ = NULL;
					GdkRectangle _tmp50_ = {0};
					gint _tmp51_ = 0;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = y;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = item;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp50_ = _tmp49_->allocation;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp51_ = _tmp50_.y;
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = _tmp48_ >= _tmp51_;
#line 6795 "CheckerboardLayout.c"
				} else {
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = FALSE;
#line 6799 "CheckerboardLayout.c"
				}
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp40_) {
#line 6803 "CheckerboardLayout.c"
					gint _tmp52_ = 0;
					CheckerboardItem* _tmp53_ = NULL;
					GdkRectangle _tmp54_ = {0};
					gint _tmp55_ = 0;
					CheckerboardItem* _tmp56_ = NULL;
					GdkRectangle _tmp57_ = {0};
					gint _tmp58_ = 0;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp52_ = y;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp53_ = item;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp54_ = _tmp53_->allocation;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp55_ = _tmp54_.y;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp56_ = item;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp57_ = _tmp56_->allocation;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp58_ = _tmp57_.height;
#line 1179 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = _tmp52_ <= (_tmp55_ + _tmp58_);
#line 6827 "CheckerboardLayout.c"
				} else {
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = FALSE;
#line 6831 "CheckerboardLayout.c"
				}
#line 1178 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp39_) {
#line 1180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					result = item;
#line 1180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (in_range);
#line 1180 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					return result;
#line 6841 "CheckerboardLayout.c"
				}
#line 1165 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 6845 "CheckerboardLayout.c"
			}
		}
	}
#line 1183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = NULL;
#line 1183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (in_range);
#line 1183 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6855 "CheckerboardLayout.c"
}


GeeList* checkerboard_layout_get_visible_items (CheckerboardLayout* self) {
	GeeList* result = NULL;
	GdkRectangle _tmp0_ = {0};
	GeeList* _tmp1_ = NULL;
#line 1186 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->visible_page;
#line 1187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = checkerboard_layout_intersection (self, &_tmp0_);
#line 1187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp1_;
#line 1187 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 6873 "CheckerboardLayout.c"
}


GeeList* checkerboard_layout_intersection (CheckerboardLayout* self, GdkRectangle* area) {
	GeeList* result = NULL;
	GeeArrayList* intersects = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRectangle bitbucket = {0};
	CheckerboardLayoutLayoutRow** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 1190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1190 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (area != NULL, NULL);
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_array_list_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 1191 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	intersects = _tmp0_;
#line 1194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
#line 1194 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp1_;
#line 1196 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&bitbucket, 0, sizeof (GdkRectangle));
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->item_rows;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2__length1 = self->priv->item_rows_length1;
#line 6904 "CheckerboardLayout.c"
	{
		CheckerboardLayoutLayoutRow** row_collection = NULL;
		gint row_collection_length1 = 0;
		gint _row_collection_size_ = 0;
		gint row_it = 0;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_collection = _tmp2_;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_collection_length1 = _tmp2__length1;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		for (row_it = 0; row_it < _tmp2__length1; row_it = row_it + 1) {
#line 6916 "CheckerboardLayout.c"
			CheckerboardLayoutLayoutRow* _tmp3_ = NULL;
			CheckerboardLayoutLayoutRow* row = NULL;
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = _checkerboard_layout_layout_row_ref0 (row_collection[row_it]);
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp3_;
#line 6923 "CheckerboardLayout.c"
			{
				CheckerboardLayoutLayoutRow* _tmp4_ = NULL;
				GdkRectangle _tmp5_ = {0};
				gint _tmp6_ = 0;
				GdkRectangle _tmp7_ = {0};
				gint _tmp8_ = 0;
				CheckerboardLayoutLayoutRow* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				CheckerboardLayoutLayoutRow* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				CheckerboardLayoutLayoutRow* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				GdkRectangle _tmp15_ = {0};
				gint _tmp16_ = 0;
				GdkRectangle row_rect = {0};
				CheckerboardLayoutLayoutRow* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				GtkAllocation _tmp19_ = {0};
				gint _tmp20_ = 0;
				CheckerboardLayoutLayoutRow* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				GdkRectangle _tmp23_ = {0};
				GdkRectangle _tmp24_ = {0};
				gboolean _tmp25_ = FALSE;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp4_ = row;
#line 1198 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp4_ == NULL) {
#line 1199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1199 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 6956 "CheckerboardLayout.c"
				}
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp5_ = *area;
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp6_ = _tmp5_.y;
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp7_ = *area;
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp8_ = _tmp7_.height;
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp9_ = row;
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp10_ = _tmp9_->y;
#line 1201 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if ((_tmp6_ + _tmp8_) < _tmp10_) {
#line 1203 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1203 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 6976 "CheckerboardLayout.c"
				}
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp11_ = row;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp12_ = _tmp11_->y;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = row;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _tmp13_->height;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = *area;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _tmp15_.y;
#line 1206 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if ((_tmp12_ + _tmp14_) < _tmp16_) {
#line 1208 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (row);
#line 1208 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					continue;
#line 6996 "CheckerboardLayout.c"
				}
#line 1212 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				memset (&row_rect, 0, sizeof (GdkRectangle));
#line 1213 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.x = 0;
#line 1214 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = row;
#line 1214 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->y;
#line 1214 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.y = _tmp18_;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = allocation;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = _tmp19_.width;
#line 1215 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.width = _tmp20_;
#line 1216 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = row;
#line 1216 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_->height;
#line 1216 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_rect.height = _tmp22_;
#line 1218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp23_ = row_rect;
#line 1218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = gdk_rectangle_intersect (area, &_tmp23_, &_tmp24_);
#line 1218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				bitbucket = _tmp24_;
#line 1218 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp25_) {
#line 7028 "CheckerboardLayout.c"
					CheckerboardLayoutLayoutRow* _tmp26_ = NULL;
					CheckerboardItem** _tmp27_ = NULL;
					gint _tmp27__length1 = 0;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp26_ = row;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = _tmp26_->items;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27__length1 = _tmp26_->items_length1;
#line 7038 "CheckerboardLayout.c"
					{
						CheckerboardItem** item_collection = NULL;
						gint item_collection_length1 = 0;
						gint _item_collection_size_ = 0;
						gint item_it = 0;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item_collection = _tmp27_;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item_collection_length1 = _tmp27__length1;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						for (item_it = 0; item_it < _tmp27__length1; item_it = item_it + 1) {
#line 7050 "CheckerboardLayout.c"
							CheckerboardItem* _tmp28_ = NULL;
							CheckerboardItem* item = NULL;
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp28_ = _g_object_ref0 (item_collection[item_it]);
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							item = _tmp28_;
#line 7057 "CheckerboardLayout.c"
							{
								CheckerboardItem* _tmp29_ = NULL;
								CheckerboardItem* _tmp30_ = NULL;
								GdkRectangle _tmp31_ = {0};
								GdkRectangle _tmp32_ = {0};
								gboolean _tmp33_ = FALSE;
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp29_ = item;
#line 1221 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								if (_tmp29_ == NULL) {
#line 1222 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_g_object_unref0 (item);
#line 1222 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									continue;
#line 7072 "CheckerboardLayout.c"
								}
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp30_ = item;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp31_ = _tmp30_->allocation;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_tmp33_ = gdk_rectangle_intersect (area, &_tmp31_, &_tmp32_);
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								bitbucket = _tmp32_;
#line 1224 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								if (_tmp33_) {
#line 7084 "CheckerboardLayout.c"
									GeeArrayList* _tmp34_ = NULL;
									CheckerboardItem* _tmp35_ = NULL;
#line 1225 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_tmp34_ = intersects;
#line 1225 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									_tmp35_ = item;
#line 1225 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
									gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp35_);
#line 7093 "CheckerboardLayout.c"
								}
#line 1220 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
								_g_object_unref0 (item);
#line 7097 "CheckerboardLayout.c"
							}
						}
					}
				}
#line 1197 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_checkerboard_layout_layout_row_unref0 (row);
#line 7104 "CheckerboardLayout.c"
			}
		}
	}
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (intersects, GEE_TYPE_LIST, GeeList);
#line 1230 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7112 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_relative_to (CheckerboardLayout* self, CheckerboardItem* item, CompassPoint point) {
	CheckerboardItem* result = NULL;
	ViewCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint col = 0;
	CheckerboardItem* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint row = 0;
	CheckerboardItem* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_ = 0;
	CompassPoint _tmp14_ = 0;
	CheckerboardItem* new_item = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	CheckerboardItem* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	CheckerboardItem* _tmp39_ = NULL;
	CheckerboardItem* _tmp47_ = NULL;
	CheckerboardItem* _tmp48_ = NULL;
	CheckerboardItem* _tmp51_ = NULL;
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1233 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (item), NULL);
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 1234 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ == 0) {
#line 1235 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1235 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7154 "CheckerboardLayout.c"
	}
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->columns;
#line 1237 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp2_ > 0, "columns > 0");
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->rows;
#line 1238 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp3_ > 0, "rows > 0");
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = item;
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = checkerboard_item_get_column (_tmp4_);
#line 1240 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = _tmp5_;
#line 1241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = item;
#line 1241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = checkerboard_item_get_row (_tmp6_);
#line 1241 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = _tmp7_;
#line 1243 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = col;
#line 1243 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ < 0) {
#line 1243 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = TRUE;
#line 7182 "CheckerboardLayout.c"
	} else {
		gint _tmp10_ = 0;
#line 1243 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = row;
#line 1243 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp10_ < 0;
#line 7189 "CheckerboardLayout.c"
	}
#line 1243 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp8_) {
#line 7193 "CheckerboardLayout.c"
		CheckerboardItem* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = item;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = checkerboard_item_get_title (_tmp11_);
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_;
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_critical ("CheckerboardLayout.vala:1244: Attempting to locate item not placed in " \
"layout: %s", _tmp13_);
#line 1244 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp13_);
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1246 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7211 "CheckerboardLayout.c"
	}
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = point;
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	switch (_tmp14_) {
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_NORTH:
#line 7219 "CheckerboardLayout.c"
		{
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = row;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp15_ - 1;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = row;
#line 1251 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp16_ < 0) {
#line 1252 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = 0;
#line 7233 "CheckerboardLayout.c"
			}
#line 1253 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 7237 "CheckerboardLayout.c"
		}
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_SOUTH:
#line 7241 "CheckerboardLayout.c"
		{
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = row;
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			row = _tmp17_ + 1;
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = row;
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp19_ = self->priv->rows;
#line 1256 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp18_ >= _tmp19_) {
#line 7256 "CheckerboardLayout.c"
				gint _tmp20_ = 0;
#line 1257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = self->priv->rows;
#line 1257 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp20_ - 1;
#line 7262 "CheckerboardLayout.c"
			}
#line 1258 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 7266 "CheckerboardLayout.c"
		}
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_EAST:
#line 7270 "CheckerboardLayout.c"
		{
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp21_ = col;
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			col = _tmp21_ + 1;
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp22_ = col;
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = self->priv->columns;
#line 1261 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp22_ >= _tmp23_) {
#line 7285 "CheckerboardLayout.c"
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp24_ = row;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp24_ + 1;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = row;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = self->priv->rows;
#line 1262 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp25_ >= _tmp26_) {
#line 7299 "CheckerboardLayout.c"
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp27_ = self->priv->rows;
#line 1263 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp27_ - 1;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp28_ = self->priv->columns;
#line 1264 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp28_ - 1;
#line 7310 "CheckerboardLayout.c"
				} else {
#line 1266 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 7314 "CheckerboardLayout.c"
				}
			}
#line 1269 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 7319 "CheckerboardLayout.c"
		}
#line 1249 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		case COMPASS_POINT_WEST:
#line 7323 "CheckerboardLayout.c"
		{
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = col;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			col = _tmp29_ - 1;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp30_ = col;
#line 1272 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp30_ < 0) {
#line 7335 "CheckerboardLayout.c"
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = row;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = _tmp31_ - 1;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = row;
#line 1273 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp32_ < 0) {
#line 1274 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = 0;
#line 1275 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 7350 "CheckerboardLayout.c"
				} else {
					gint _tmp33_ = 0;
#line 1277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp33_ = self->priv->columns;
#line 1277 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp33_ - 1;
#line 7357 "CheckerboardLayout.c"
				}
			}
#line 1280 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			break;
#line 7362 "CheckerboardLayout.c"
		}
		default:
		{
			CompassPoint _tmp34_ = 0;
#line 1283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp34_ = point;
#line 1283 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			g_error ("CheckerboardLayout.vala:1283: Bad compass point %d", (gint) _tmp34_);
#line 7371 "CheckerboardLayout.c"
		}
	}
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = col;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = row;
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = checkerboard_layout_get_item_at_coordinate (self, _tmp35_, _tmp36_);
#line 1286 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	new_item = _tmp37_;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = new_item;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp39_ == NULL) {
#line 7386 "CheckerboardLayout.c"
		CompassPoint _tmp40_ = 0;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = point;
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = _tmp40_ == COMPASS_POINT_SOUTH;
#line 7392 "CheckerboardLayout.c"
	} else {
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = FALSE;
#line 7396 "CheckerboardLayout.c"
	}
#line 1288 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp38_) {
#line 7400 "CheckerboardLayout.c"
		ViewCollection* _tmp41_ = NULL;
		DataView* _tmp42_ = NULL;
		CheckerboardItem* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		CheckerboardItem* _tmp45_ = NULL;
		gint _tmp46_ = 0;
#line 1290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = self->priv->view;
#line 1290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = view_collection_get_last (_tmp41_);
#line 1290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (new_item);
#line 1290 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		new_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = new_item;
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = checkerboard_item_get_row (_tmp43_);
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp45_ = item;
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = checkerboard_item_get_row (_tmp45_);
#line 1291 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp44_ <= _tmp46_) {
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (new_item);
#line 1292 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			new_item = NULL;
#line 7429 "CheckerboardLayout.c"
		}
	}
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = new_item;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp48_ != NULL) {
#line 7436 "CheckerboardLayout.c"
		CheckerboardItem* _tmp49_ = NULL;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = new_item;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp49_;
#line 7442 "CheckerboardLayout.c"
	} else {
		CheckerboardItem* _tmp50_ = NULL;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = item;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp50_;
#line 7449 "CheckerboardLayout.c"
	}
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = _g_object_ref0 (_tmp47_);
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp51_;
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (new_item);
#line 1295 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7459 "CheckerboardLayout.c"
}


CheckerboardItem* checkerboard_layout_get_item_at_coordinate (CheckerboardLayout* self, gint col, gint row) {
	CheckerboardItem* result = NULL;
	gint _tmp0_ = 0;
	CheckerboardLayoutLayoutRow** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	CheckerboardLayoutLayoutRow* item_row = NULL;
	CheckerboardLayoutLayoutRow** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	CheckerboardLayoutLayoutRow* _tmp4_ = NULL;
	CheckerboardLayoutLayoutRow* _tmp5_ = NULL;
	CheckerboardLayoutLayoutRow* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	CheckerboardLayoutLayoutRow* _tmp8_ = NULL;
	CheckerboardItem** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	CheckerboardLayoutLayoutRow* _tmp10_ = NULL;
	CheckerboardItem** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp12_ = 0;
	CheckerboardItem* _tmp13_ = NULL;
	CheckerboardItem* _tmp14_ = NULL;
#line 1298 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = row;
#line 1299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->item_rows;
#line 1299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1__length1 = self->priv->item_rows_length1;
#line 1299 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ >= _tmp1__length1) {
#line 1300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1300 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7499 "CheckerboardLayout.c"
	}
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->item_rows;
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2__length1 = self->priv->item_rows_length1;
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = row;
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp2_[_tmp3_];
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _checkerboard_layout_layout_row_ref0 (_tmp4_);
#line 1302 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	item_row = _tmp5_;
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = item_row;
#line 1303 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ == NULL) {
#line 1304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (item_row);
#line 1304 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7523 "CheckerboardLayout.c"
	}
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = col;
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = item_row;
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = _tmp8_->items;
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9__length1 = _tmp8_->items_length1;
#line 1306 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_ >= _tmp9__length1) {
#line 1307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (item_row);
#line 1307 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7541 "CheckerboardLayout.c"
	}
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = item_row;
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = _tmp10_->items;
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11__length1 = _tmp10_->items_length1;
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = col;
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp13_ = _tmp11_[_tmp12_];
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp14_;
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (item_row);
#line 1309 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7561 "CheckerboardLayout.c"
}


void checkerboard_layout_set_drag_select_origin (CheckerboardLayout* self, gint x, gint y) {
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 1312 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1313 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_clear_drag_select (self);
#line 1316 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1316 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = x;
#line 1318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = allocation;
#line 1318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.width;
#line 1318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = CLAMP (_tmp1_, 0, _tmp3_);
#line 1318 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.x = _tmp4_;
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = y;
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = allocation;
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.height;
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = CLAMP (_tmp5_, 0, _tmp7_);
#line 1319 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.y = _tmp8_;
#line 7604 "CheckerboardLayout.c"
}


void checkerboard_layout_set_drag_select_endpoint (CheckerboardLayout* self, gint x, gint y) {
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GdkRectangle old_selection_band = {0};
	GdkRectangle _tmp9_ = {0};
	GdkPoint _tmp10_ = {0};
	GdkPoint _tmp11_ = {0};
	Box _tmp12_ = {0};
	GdkRectangle _tmp13_ = {0};
	GdkWindow* _tmp14_ = NULL;
#line 1322 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1324 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = x;
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = allocation;
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = _tmp2_.width;
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = CLAMP (_tmp1_, 0, _tmp3_);
#line 1326 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.x = _tmp4_;
#line 1327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = y;
#line 1327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = allocation;
#line 1327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = _tmp6_.height;
#line 1327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = CLAMP (_tmp5_, 0, _tmp7_);
#line 1327 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.y = _tmp8_;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->selection_band;
#line 1331 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old_selection_band = _tmp9_;
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->drag_origin;
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->drag_endpoint;
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	box_from_points (&_tmp10_, &_tmp11_, &_tmp12_);
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	box_get_rectangle (&_tmp12_, &_tmp13_);
#line 1332 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->selection_band = _tmp13_;
#line 1335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1335 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp14_ != NULL) {
#line 7670 "CheckerboardLayout.c"
		GdkRectangle _union_ = {0};
		GdkRectangle _tmp15_ = {0};
		GdkRectangle _tmp16_ = {0};
		GdkRectangle _tmp17_ = {0};
		gint _tmp18_ = 0;
		GdkRectangle _tmp19_ = {0};
		gint _tmp20_ = 0;
		GdkRectangle _tmp21_ = {0};
		gint _tmp22_ = 0;
		GdkRectangle _tmp23_ = {0};
		gint _tmp24_ = 0;
#line 1337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = old_selection_band;
#line 1337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gdk_rectangle_union (&self->priv->selection_band, &_tmp15_, &_tmp16_);
#line 1337 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_union_ = _tmp16_;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _union_;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = _tmp17_.x;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = _union_;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = _tmp19_.y;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = _union_;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.width;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = _union_;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.height;
#line 1339 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp18_, _tmp20_, _tmp22_, _tmp24_);
#line 7706 "CheckerboardLayout.c"
	}
}


GeeList* checkerboard_layout_items_in_selection_band (CheckerboardLayout* self) {
	GeeList* result = NULL;
	GdkRectangle _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GdkRectangle _tmp3_ = {0};
	GeeList* _tmp4_ = NULL;
#line 1343 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), NULL);
#line 1344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->selection_band;
#line 1344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	dimensions_for_rectangle (&_tmp0_, &_tmp1_);
#line 1344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = dimensions_has_area (&_tmp1_);
#line 1344 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!_tmp2_) {
#line 1345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		result = NULL;
#line 1345 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return result;
#line 7732 "CheckerboardLayout.c"
	}
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->selection_band;
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = checkerboard_layout_intersection (self, &_tmp3_);
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 1347 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7742 "CheckerboardLayout.c"
}


gboolean checkerboard_layout_is_drag_select_active (CheckerboardLayout* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkPoint _tmp1_ = {0};
	gint _tmp2_ = 0;
#line 1350 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (IS_CHECKERBOARD_LAYOUT (self), FALSE);
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->drag_origin;
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.x;
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ >= 0) {
#line 7759 "CheckerboardLayout.c"
		GdkPoint _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->drag_origin;
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.y;
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ >= 0;
#line 7768 "CheckerboardLayout.c"
	} else {
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = FALSE;
#line 7772 "CheckerboardLayout.c"
	}
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp0_;
#line 1351 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 7778 "CheckerboardLayout.c"
}


void checkerboard_layout_clear_drag_select (CheckerboardLayout* self) {
#line 1354 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1355 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
#line 1356 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.x = -1;
#line 1357 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_origin.y = -1;
#line 1358 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.x = -1;
#line 1359 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->drag_endpoint.y = -1;
#line 1362 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 7797 "CheckerboardLayout.c"
}


static void checkerboard_layout_viewport_resized (CheckerboardLayout* self) {
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 1365 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1367 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_update_visible_page (self);
#line 1370 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->visible_page;
#line 1370 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_.width;
#line 1370 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->last_width;
#line 1370 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp1_ != _tmp2_) {
#line 7817 "CheckerboardLayout.c"
		gint old_width = 0;
		gint _tmp3_ = 0;
		GdkRectangle _tmp4_ = {0};
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkRectangle _tmp7_ = {0};
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 1371 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->last_width;
#line 1371 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		old_width = _tmp3_;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = self->priv->visible_page;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp4_.width;
#line 1372 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->last_width = _tmp5_;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = old_width;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->visible_page;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp7_.width;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = g_strdup_printf ("viewport_resized (%d -> %d)", _tmp6_, _tmp8_);
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp10_ = _tmp9_;
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_reflow (self, _tmp10_);
#line 1374 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp10_);
#line 7851 "CheckerboardLayout.c"
	} else {
		gint _tmp11_ = 0;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp11_ = self->priv->last_width;
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp12_ = g_strdup_printf ("viewport_resized (same width=%d)", _tmp11_);
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp12_;
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_need_exposure (self, _tmp13_);
#line 1377 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_free0 (_tmp13_);
#line 7866 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_expose_items (CheckerboardLayout* self, const gchar* caller) {
	GeeHashSet* new_exposed_items = NULL;
	GeeHashSet* _tmp0_ = NULL;
	ViewCollection* _tmp1_ = NULL;
	GeeList* items = NULL;
	GeeList* _tmp2_ = NULL;
	GeeHashSet* _tmp27_ = NULL;
	GeeHashSet* _tmp28_ = NULL;
	ViewCollection* _tmp29_ = NULL;
#line 1381 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1381 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1384 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	new_exposed_items = _tmp0_;
#line 1386 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->view;
#line 1386 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
#line 1388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_get_visible_items (self);
#line 1388 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	items = _tmp2_;
#line 7896 "CheckerboardLayout.c"
	{
		GeeList* _item_list = NULL;
		GeeList* _tmp3_ = NULL;
		GeeList* _tmp4_ = NULL;
		gint _item_size = 0;
		GeeList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _item_index = 0;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = items;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_list = _tmp4_;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _item_list;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = _tmp6_;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_size = _tmp7_;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_index = -1;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 7924 "CheckerboardLayout.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			CheckerboardItem* item = NULL;
			GeeList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gpointer _tmp13_ = NULL;
			GeeHashSet* _tmp14_ = NULL;
			CheckerboardItem* _tmp15_ = NULL;
			GeeHashSet* _tmp16_ = NULL;
			CheckerboardItem* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = _item_index;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = _tmp8_ + 1;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = _item_index;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = _item_size;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!(_tmp9_ < _tmp10_)) {
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 7949 "CheckerboardLayout.c"
			}
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_list;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = _item_index;
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = gee_list_get (_tmp11_, _tmp12_);
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp13_;
#line 1390 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = new_exposed_items;
#line 1390 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = item;
#line 1390 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 1393 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = self->priv->exposed_items;
#line 1393 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp17_ = item;
#line 1393 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp18_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
#line 1393 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp18_) {
#line 7973 "CheckerboardLayout.c"
				CheckerboardItem* _tmp19_ = NULL;
#line 1394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = item;
#line 1394 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_exposed (_tmp19_);
#line 7979 "CheckerboardLayout.c"
			}
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 7983 "CheckerboardLayout.c"
		}
#line 1389 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_list);
#line 7987 "CheckerboardLayout.c"
	}
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp20_ = NULL;
		GeeIterator* _tmp21_ = NULL;
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = self->priv->exposed_items;
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_it = _tmp21_;
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 8001 "CheckerboardLayout.c"
			GeeIterator* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp24_ = NULL;
			gpointer _tmp25_ = NULL;
			CheckerboardItem* _tmp26_ = NULL;
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp22_ = _item_it;
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = gee_iterator_next (_tmp22_);
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp23_) {
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 8016 "CheckerboardLayout.c"
			}
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = _item_it;
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp25_ = gee_iterator_get (_tmp24_);
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp25_;
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp26_ = item;
#line 1399 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_unexposed (_tmp26_);
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 8030 "CheckerboardLayout.c"
		}
#line 1398 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_it);
#line 8034 "CheckerboardLayout.c"
	}
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp27_ = new_exposed_items;
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp28_ = _g_object_ref0 (_tmp27_);
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->exposed_items);
#line 1402 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposed_items = _tmp28_;
#line 1403 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = FALSE;
#line 1408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = self->priv->view;
#line 1408 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_DATA_COLLECTION, DataCollection));
#line 1381 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (items);
#line 1381 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (new_exposed_items);
#line 8054 "CheckerboardLayout.c"
}


static void checkerboard_layout_unexpose_items (CheckerboardLayout* self, const gchar* caller) {
	ViewCollection* _tmp0_ = NULL;
	GeeHashSet* _tmp8_ = NULL;
	ViewCollection* _tmp9_ = NULL;
#line 1414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1414 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1415 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection));
#line 8070 "CheckerboardLayout.c"
	{
		GeeIterator* _item_it = NULL;
		GeeHashSet* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = self->priv->exposed_items;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_item_it = _tmp2_;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 8083 "CheckerboardLayout.c"
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			CheckerboardItem* item = NULL;
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			CheckerboardItem* _tmp7_ = NULL;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = _item_it;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = gee_iterator_next (_tmp3_);
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp4_) {
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 8098 "CheckerboardLayout.c"
			}
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = _item_it;
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = (CheckerboardItem*) _tmp6_;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = item;
#line 1418 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_item_unexposed (_tmp7_);
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 8112 "CheckerboardLayout.c"
		}
#line 1417 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_item_it);
#line 8116 "CheckerboardLayout.c"
	}
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->exposed_items;
#line 1420 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 1421 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = FALSE;
#line 1426 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->view;
#line 1426 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_COLLECTION, DataCollection));
#line 8128 "CheckerboardLayout.c"
}


static void checkerboard_layout_reflow (CheckerboardLayout* self, const gchar* caller) {
	const gchar* _tmp0_ = NULL;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint visible_width = 0;
	gint _tmp9_ = 0;
	gint total_items = 0;
	ViewCollection* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp15_ = FALSE;
	CheckerboardItem* _tmp16_ = NULL;
	gint max_cols = 0;
	gint _tmp19_ = 0;
	gint _tmp64_ = 0;
	gint max_rows = 0;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint row = 0;
	gint tallest = 0;
	gint widest = 0;
	gint row_alignment_point = 0;
	gint total_width = 0;
	gint col = 0;
	gint* column_widths = NULL;
	gint _tmp67_ = 0;
	gint* _tmp68_ = NULL;
	gint column_widths_length1 = 0;
	gint _column_widths_size_ = 0;
	gint* row_heights = NULL;
	gint _tmp69_ = 0;
	gint* _tmp70_ = NULL;
	gint row_heights_length1 = 0;
	gint _row_heights_size_ = 0;
	gint* alignment_points = NULL;
	gint _tmp71_ = 0;
	gint* _tmp72_ = NULL;
	gint alignment_points_length1 = 0;
	gint _alignment_points_size_ = 0;
	gint gutter = 0;
	gint _tmp183_ = 0;
	CheckerboardLayoutLayoutRow** _tmp184_ = NULL;
	gint x = 0;
	gint _tmp185_ = 0;
	gint y = 0;
	CheckerboardLayoutLayoutRow* current_row = NULL;
	CheckerboardLayoutLayoutRow* _tmp255_ = NULL;
	gint _tmp261_ = 0;
	gint _tmp262_ = 0;
	gint _tmp263_ = 0;
	gint _tmp264_ = 0;
	gint total_height = 0;
	gint _tmp265_ = 0;
	gint* _tmp266_ = NULL;
	gint _tmp266__length1 = 0;
	gint _tmp267_ = 0;
	gint _tmp268_ = 0;
	gboolean _tmp269_ = FALSE;
	gint _tmp270_ = 0;
	GtkAllocation _tmp271_ = {0};
	gint _tmp272_ = 0;
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (caller != NULL);
#line 1433 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->reflow_needed = FALSE;
#line 1436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->message;
#line 1436 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_ != NULL) {
#line 1437 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 8208 "CheckerboardLayout.c"
	}
#line 1440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
#line 1440 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp1_;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = self->priv->visible_page;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ > 0) {
#line 8220 "CheckerboardLayout.c"
		GdkRectangle _tmp5_ = {0};
		gint _tmp6_ = 0;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = self->priv->visible_page;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = _tmp5_.width;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp6_;
#line 8229 "CheckerboardLayout.c"
	} else {
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = allocation;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = _tmp7_.width;
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp2_ = _tmp8_;
#line 8239 "CheckerboardLayout.c"
	}
#line 1442 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_width = _tmp2_;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = visible_width;
#line 1450 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp9_ <= 1) {
#line 1451 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 8249 "CheckerboardLayout.c"
	}
#line 1453 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->view;
#line 1453 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = data_collection_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection));
#line 1453 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_items = _tmp11_;
#line 1456 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = total_items;
#line 1456 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp12_ == 0) {
#line 8261 "CheckerboardLayout.c"
		gint _tmp13_ = 0;
		CheckerboardLayoutLayoutRow** _tmp14_ = NULL;
#line 1457 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = visible_width;
#line 1457 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp13_, 0);
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp14_ = g_new0 (CheckerboardLayoutLayoutRow*, 0 + 1);
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows = _tmp14_;
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->item_rows_length1 = 0;
#line 1458 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1460 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 8280 "CheckerboardLayout.c"
	}
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->anchor;
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp16_ == NULL) {
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = TRUE;
#line 8288 "CheckerboardLayout.c"
	} else {
		CheckerboardItem* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = self->priv->anchor;
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DATA_VIEW, DataView));
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp15_ = !_tmp18_;
#line 8298 "CheckerboardLayout.c"
	}
#line 1468 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_) {
#line 1469 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_update_anchor (self);
#line 8304 "CheckerboardLayout.c"
	}
#line 1472 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1472 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 1472 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 1472 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1477 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max_cols = 0;
#line 1478 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp19_ = self->priv->scale;
#line 1478 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp19_ > 0) {
#line 8320 "CheckerboardLayout.c"
		gint remaining_width = 0;
		gint _tmp20_ = 0;
		gint max_item_width = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 1480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = visible_width;
#line 1480 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		remaining_width = _tmp20_ - (CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING * 2);
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->scale;
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = checkerboard_item_get_max_width (_tmp21_);
#line 1481 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		max_item_width = _tmp22_;
#line 1482 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = remaining_width;
#line 1482 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = max_item_width;
#line 1482 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		max_cols = _tmp23_ / _tmp24_;
#line 1483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = max_cols;
#line 1483 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp25_ <= 0) {
#line 1484 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = 1;
#line 8353 "CheckerboardLayout.c"
		}
#line 1487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 8357 "CheckerboardLayout.c"
			gboolean _tmp26_ = FALSE;
			gint _tmp27_ = 0;
			gint _tmp32_ = 0;
#line 1487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp27_ = max_cols;
#line 1487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp27_ > 1) {
#line 8365 "CheckerboardLayout.c"
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp28_ = max_cols;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp29_ = max_item_width;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp30_ = max_cols;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = remaining_width;
#line 1488 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = ((_tmp28_ * _tmp29_) + ((_tmp30_ - 1) * CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING)) > _tmp31_;
#line 8380 "CheckerboardLayout.c"
			} else {
#line 1487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = FALSE;
#line 8384 "CheckerboardLayout.c"
			}
#line 1487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp26_) {
#line 1487 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 8390 "CheckerboardLayout.c"
			}
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp32_ = max_cols;
#line 1493 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp32_ - 1;
#line 8396 "CheckerboardLayout.c"
		}
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = total_items;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = max_cols;
#line 1497 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp33_ < _tmp34_) {
#line 8404 "CheckerboardLayout.c"
			gint _tmp35_ = 0;
#line 1498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp35_ = total_items;
#line 1498 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp35_;
#line 8410 "CheckerboardLayout.c"
		}
	} else {
		gint x = 0;
		gint col = 0;
		gint row_width = 0;
		gint widest_row = 0;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
#line 1505 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
#line 1506 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		col = 0;
#line 1507 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		row_width = 0;
#line 1508 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		widest_row = 0;
#line 8427 "CheckerboardLayout.c"
		{
			gint ctr = 0;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			ctr = 0;
#line 8432 "CheckerboardLayout.c"
			{
				gboolean _tmp36_ = FALSE;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp36_ = TRUE;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				while (TRUE) {
#line 8439 "CheckerboardLayout.c"
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					CheckerboardItem* item = NULL;
					ViewCollection* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					DataObject* _tmp42_ = NULL;
					Dimensions req = {0};
					CheckerboardItem* _tmp43_ = NULL;
					Dimensions _tmp44_ = {0};
					gboolean _tmp45_ = FALSE;
					gint _tmp46_ = 0;
					Dimensions _tmp47_ = {0};
					gint _tmp48_ = 0;
					gint _tmp49_ = 0;
					gint _tmp54_ = 0;
					Dimensions _tmp55_ = {0};
					gint _tmp56_ = 0;
					gint _tmp57_ = 0;
					Dimensions _tmp58_ = {0};
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (!_tmp36_) {
#line 8463 "CheckerboardLayout.c"
						gint _tmp37_ = 0;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp37_ = ctr;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						ctr = _tmp37_ + 1;
#line 8469 "CheckerboardLayout.c"
					}
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp36_ = FALSE;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp38_ = ctr;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp39_ = total_items;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (!(_tmp38_ < _tmp39_)) {
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						break;
#line 8481 "CheckerboardLayout.c"
					}
#line 1511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp40_ = self->priv->view;
#line 1511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp41_ = ctr;
#line 1511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp42_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_DATA_COLLECTION, DataCollection), _tmp41_);
#line 1511 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					item = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp43_ = item;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp44_ = _tmp43_->requisition;
#line 1512 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					req = _tmp44_;
#line 1515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp45_ = dimensions_has_area (&req);
#line 1515 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_vala_assert (_tmp45_, "req.has_area()");
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp46_ = x;
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp47_ = req;
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp48_ = _tmp47_.width;
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp49_ = visible_width;
#line 1518 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					if (((_tmp46_ + _tmp48_) + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) > _tmp49_) {
#line 8511 "CheckerboardLayout.c"
						gint _tmp50_ = 0;
						gint _tmp51_ = 0;
#line 1519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp50_ = row_width;
#line 1519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp51_ = widest_row;
#line 1519 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp50_ > _tmp51_) {
#line 8520 "CheckerboardLayout.c"
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
#line 1520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp52_ = row_width;
#line 1520 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							widest_row = _tmp52_;
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp53_ = col;
#line 1521 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							max_cols = _tmp53_;
#line 8531 "CheckerboardLayout.c"
						}
#line 1524 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						col = 0;
#line 1525 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						x = CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING;
#line 1526 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						row_width = 0;
#line 8539 "CheckerboardLayout.c"
					}
#line 1529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp54_ = x;
#line 1529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp55_ = req;
#line 1529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp56_ = _tmp55_.width;
#line 1529 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					x = _tmp54_ + (_tmp56_ + CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING);
#line 1530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp57_ = row_width;
#line 1530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp58_ = req;
#line 1530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp59_ = _tmp58_.width;
#line 1530 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row_width = _tmp57_ + _tmp59_;
#line 1532 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp60_ = col;
#line 1532 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = _tmp60_ + 1;
#line 1510 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_g_object_unref0 (item);
#line 8563 "CheckerboardLayout.c"
				}
			}
		}
#line 1536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = row_width;
#line 1536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = widest_row;
#line 1536 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp61_ > _tmp62_) {
#line 8573 "CheckerboardLayout.c"
			gint _tmp63_ = 0;
#line 1537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp63_ = col;
#line 1537 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			max_cols = _tmp63_;
#line 8579 "CheckerboardLayout.c"
		}
	}
#line 1545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp64_ = max_cols;
#line 1545 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp64_ > 0, "max_cols > 0");
#line 1546 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp65_ = total_items;
#line 1546 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp66_ = max_cols;
#line 1546 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	max_rows = (_tmp65_ / _tmp66_) + 1;
#line 1550 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 1551 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	tallest = 0;
#line 1552 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	widest = 0;
#line 1553 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_alignment_point = 0;
#line 1554 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_width = 0;
#line 1555 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp67_ = max_cols;
#line 1556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp68_ = g_new0 (gint, _tmp67_);
#line 1556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths = _tmp68_;
#line 1556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths_length1 = _tmp67_;
#line 1556 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_column_widths_size_ = column_widths_length1;
#line 1557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp69_ = max_rows;
#line 1557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp70_ = g_new0 (gint, _tmp69_);
#line 1557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights = _tmp70_;
#line 1557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights_length1 = _tmp69_;
#line 1557 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_row_heights_size_ = row_heights_length1;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp71_ = max_rows;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp72_ = g_new0 (gint, _tmp71_);
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points = _tmp72_;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points_length1 = _tmp71_;
#line 1558 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_alignment_points_size_ = alignment_points_length1;
#line 1559 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gutter = 0;
#line 8636 "CheckerboardLayout.c"
	{
		gboolean _tmp73_ = FALSE;
#line 1561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp73_ = TRUE;
#line 1561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 8643 "CheckerboardLayout.c"
			gint _tmp129_ = 0;
			gint _tmp138_ = 0;
			gint _tmp139_ = 0;
			gint _tmp140_ = 0;
			gint _tmp141_ = 0;
			gint _tmp142_ = 0;
#line 1561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp73_) {
#line 8652 "CheckerboardLayout.c"
			}
#line 1561 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp73_ = FALSE;
#line 8656 "CheckerboardLayout.c"
			{
				gint ctr = 0;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				ctr = 0;
#line 8661 "CheckerboardLayout.c"
				{
					gboolean _tmp74_ = FALSE;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp74_ = TRUE;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					while (TRUE) {
#line 8668 "CheckerboardLayout.c"
						gint _tmp76_ = 0;
						gint _tmp77_ = 0;
						CheckerboardItem* item = NULL;
						ViewCollection* _tmp78_ = NULL;
						gint _tmp79_ = 0;
						DataObject* _tmp80_ = NULL;
						Dimensions req = {0};
						CheckerboardItem* _tmp81_ = NULL;
						Dimensions _tmp82_ = {0};
						gint alignment_point = 0;
						CheckerboardItem* _tmp83_ = NULL;
						gint _tmp84_ = 0;
						gint _tmp85_ = 0;
						Dimensions _tmp86_ = {0};
						gint _tmp87_ = 0;
						Dimensions _tmp88_ = {0};
						gint _tmp89_ = 0;
						gint _tmp90_ = 0;
						Dimensions _tmp93_ = {0};
						gint _tmp94_ = 0;
						gint _tmp95_ = 0;
						gint _tmp98_ = 0;
						gint _tmp99_ = 0;
						gint* _tmp101_ = NULL;
						gint _tmp101__length1 = 0;
						gint _tmp102_ = 0;
						gint _tmp103_ = 0;
						Dimensions _tmp104_ = {0};
						gint _tmp105_ = 0;
						gint _tmp118_ = 0;
						gint _tmp119_ = 0;
						gint _tmp120_ = 0;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (!_tmp74_) {
#line 8703 "CheckerboardLayout.c"
							gint _tmp75_ = 0;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp75_ = ctr;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							ctr = _tmp75_ + 1;
#line 8709 "CheckerboardLayout.c"
						}
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp74_ = FALSE;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp76_ = ctr;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp77_ = total_items;
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (!(_tmp76_ < _tmp77_)) {
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							break;
#line 8721 "CheckerboardLayout.c"
						}
#line 1563 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp78_ = self->priv->view;
#line 1563 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp79_ = ctr;
#line 1563 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp80_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, TYPE_DATA_COLLECTION, DataCollection), _tmp79_);
#line 1563 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						item = G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp81_ = item;
#line 1564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp82_ = _tmp81_->requisition;
#line 1564 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						req = _tmp82_;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp83_ = item;
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp84_ = checkerboard_item_get_alignment_point (_tmp83_);
#line 1565 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						alignment_point = _tmp84_;
#line 1568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp85_ = alignment_point;
#line 1568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp86_ = req;
#line 1568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp87_ = _tmp86_.height;
#line 1568 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_vala_assert (_tmp85_ < _tmp87_, "alignment_point < req.height");
#line 1570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp88_ = req;
#line 1570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp89_ = _tmp88_.height;
#line 1570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp90_ = tallest;
#line 1570 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp89_ > _tmp90_) {
#line 8759 "CheckerboardLayout.c"
							Dimensions _tmp91_ = {0};
							gint _tmp92_ = 0;
#line 1571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp91_ = req;
#line 1571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp92_ = _tmp91_.height;
#line 1571 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							tallest = _tmp92_;
#line 8768 "CheckerboardLayout.c"
						}
#line 1573 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp93_ = req;
#line 1573 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp94_ = _tmp93_.width;
#line 1573 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp95_ = widest;
#line 1573 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp94_ > _tmp95_) {
#line 8778 "CheckerboardLayout.c"
							Dimensions _tmp96_ = {0};
							gint _tmp97_ = 0;
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp96_ = req;
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp97_ = _tmp96_.width;
#line 1574 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							widest = _tmp97_;
#line 8787 "CheckerboardLayout.c"
						}
#line 1576 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp98_ = alignment_point;
#line 1576 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp99_ = row_alignment_point;
#line 1576 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp98_ > _tmp99_) {
#line 8795 "CheckerboardLayout.c"
							gint _tmp100_ = 0;
#line 1577 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp100_ = alignment_point;
#line 1577 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row_alignment_point = _tmp100_;
#line 8801 "CheckerboardLayout.c"
						}
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp101_ = column_widths;
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp101__length1 = column_widths_length1;
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp102_ = col;
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp103_ = _tmp101_[_tmp102_];
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp104_ = req;
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp105_ = _tmp104_.width;
#line 1581 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp103_ < _tmp105_) {
#line 8817 "CheckerboardLayout.c"
							gint _tmp106_ = 0;
							gint* _tmp107_ = NULL;
							gint _tmp107__length1 = 0;
							gint _tmp108_ = 0;
							gint _tmp109_ = 0;
							gint* _tmp110_ = NULL;
							gint _tmp110__length1 = 0;
							gint _tmp111_ = 0;
							Dimensions _tmp112_ = {0};
							gint _tmp113_ = 0;
							gint _tmp114_ = 0;
							gint _tmp115_ = 0;
							Dimensions _tmp116_ = {0};
							gint _tmp117_ = 0;
#line 1582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp106_ = total_width;
#line 1582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp107_ = column_widths;
#line 1582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp107__length1 = column_widths_length1;
#line 1582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp108_ = col;
#line 1582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp109_ = _tmp107_[_tmp108_];
#line 1582 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							total_width = _tmp106_ - _tmp109_;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110_ = column_widths;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110__length1 = column_widths_length1;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp111_ = col;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp112_ = req;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp113_ = _tmp112_.width;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp110_[_tmp111_] = _tmp113_;
#line 1583 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp114_ = _tmp110_[_tmp111_];
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp115_ = total_width;
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp116_ = req;
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp117_ = _tmp116_.width;
#line 1584 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							total_width = _tmp115_ + _tmp117_;
#line 8866 "CheckerboardLayout.c"
						}
#line 1587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp118_ = col;
#line 1587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						col = _tmp118_ + 1;
#line 1587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp119_ = col;
#line 1587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_tmp120_ = max_cols;
#line 1587 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						if (_tmp119_ >= _tmp120_) {
#line 8878 "CheckerboardLayout.c"
							gint* _tmp121_ = NULL;
							gint _tmp121__length1 = 0;
							gint _tmp122_ = 0;
							gint _tmp123_ = 0;
							gint _tmp124_ = 0;
							gint* _tmp125_ = NULL;
							gint _tmp125__length1 = 0;
							gint _tmp126_ = 0;
							gint _tmp127_ = 0;
							gint _tmp128_ = 0;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121_ = alignment_points;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121__length1 = alignment_points_length1;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp122_ = row;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp123_ = row_alignment_point;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp121_[_tmp122_] = _tmp123_;
#line 1588 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp124_ = _tmp121_[_tmp122_];
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125_ = row_heights;
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125__length1 = row_heights_length1;
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp126_ = row;
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row = _tmp126_ + 1;
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp127_ = tallest;
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp125_[_tmp126_] = _tmp127_;
#line 1589 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							_tmp128_ = _tmp125_[_tmp126_];
#line 1591 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							col = 0;
#line 1592 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							row_alignment_point = 0;
#line 1593 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
							tallest = 0;
#line 8921 "CheckerboardLayout.c"
						}
#line 1562 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
						_g_object_unref0 (item);
#line 8925 "CheckerboardLayout.c"
					}
				}
			}
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp129_ = col;
#line 1598 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp129_ != 0) {
#line 8933 "CheckerboardLayout.c"
				gint* _tmp130_ = NULL;
				gint _tmp130__length1 = 0;
				gint _tmp131_ = 0;
				gint _tmp132_ = 0;
				gint _tmp133_ = 0;
				gint* _tmp134_ = NULL;
				gint _tmp134__length1 = 0;
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
				gint _tmp137_ = 0;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130_ = alignment_points;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130__length1 = alignment_points_length1;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp131_ = row;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp132_ = row_alignment_point;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp130_[_tmp131_] = _tmp132_;
#line 1599 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp133_ = _tmp130_[_tmp131_];
#line 1600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134_ = row_heights;
#line 1600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134__length1 = row_heights_length1;
#line 1600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp135_ = row;
#line 1600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp136_ = tallest;
#line 1600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp134_[_tmp135_] = _tmp136_;
#line 1600 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp137_ = _tmp134_[_tmp135_];
#line 8968 "CheckerboardLayout.c"
			}
#line 1605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp138_ = visible_width;
#line 1605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp139_ = total_width;
#line 1605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp140_ = max_cols;
#line 1605 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			gutter = (_tmp138_ - _tmp139_) / (_tmp140_ + 1);
#line 1608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp141_ = max_cols;
#line 1608 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp141_ == 1) {
#line 1609 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 8984 "CheckerboardLayout.c"
			}
#line 1614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp142_ = gutter;
#line 1614 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp142_ < CHECKERBOARD_LAYOUT_COLUMN_GUTTER_PADDING) {
#line 8990 "CheckerboardLayout.c"
				gint _tmp143_ = 0;
				gint _tmp144_ = 0;
				gint _tmp145_ = 0;
				gint _tmp146_ = 0;
				gint* _tmp147_ = NULL;
				gint _tmp148_ = 0;
				gint* _tmp149_ = NULL;
				gint _tmp150_ = 0;
				gint* _tmp151_ = NULL;
#line 1615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp143_ = max_cols;
#line 1615 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max_cols = _tmp143_ - 1;
#line 1616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp144_ = total_items;
#line 1616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp145_ = max_cols;
#line 1616 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				max_rows = (_tmp144_ / _tmp145_) + 1;
#line 1623 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = 0;
#line 1624 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row = 0;
#line 1625 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				tallest = 0;
#line 1626 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				widest = 0;
#line 1627 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				total_width = 0;
#line 1628 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_alignment_point = 0;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp146_ = max_cols;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp147_ = g_new0 (gint, _tmp146_);
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths = (g_free (column_widths), NULL);
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths = _tmp147_;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				column_widths_length1 = _tmp146_;
#line 1629 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_column_widths_size_ = column_widths_length1;
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp148_ = max_rows;
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp149_ = g_new0 (gint, _tmp148_);
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights = (g_free (row_heights), NULL);
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights = _tmp149_;
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				row_heights_length1 = _tmp148_;
#line 1630 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_row_heights_size_ = row_heights_length1;
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp150_ = max_rows;
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp151_ = g_new0 (gint, _tmp150_);
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points = (g_free (alignment_points), NULL);
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points = _tmp151_;
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				alignment_points_length1 = _tmp150_;
#line 1631 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_alignment_points_size_ = alignment_points_length1;
#line 9058 "CheckerboardLayout.c"
			} else {
#line 1633 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9062 "CheckerboardLayout.c"
			}
		}
	}
#line 1645 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1646 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 9070 "CheckerboardLayout.c"
	{
		gint ctr = 0;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		ctr = 0;
#line 9075 "CheckerboardLayout.c"
		{
			gboolean _tmp152_ = FALSE;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp152_ = TRUE;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 9082 "CheckerboardLayout.c"
				gint _tmp154_ = 0;
				gint _tmp155_ = 0;
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp156_ = NULL;
				gint _tmp157_ = 0;
				DataObject* _tmp158_ = NULL;
				Dimensions req = {0};
				CheckerboardItem* _tmp159_ = NULL;
				Dimensions _tmp160_ = {0};
				gint true_height = 0;
				Dimensions _tmp161_ = {0};
				gint _tmp162_ = 0;
				gint* _tmp163_ = NULL;
				gint _tmp163__length1 = 0;
				gint _tmp164_ = 0;
				gint _tmp165_ = 0;
				CheckerboardItem* _tmp166_ = NULL;
				gint _tmp167_ = 0;
				gint _tmp168_ = 0;
				Dimensions _tmp169_ = {0};
				gint _tmp170_ = 0;
				gint _tmp171_ = 0;
				gint* _tmp172_ = NULL;
				gint _tmp172__length1 = 0;
				gint _tmp173_ = 0;
				gint _tmp174_ = 0;
				gint _tmp179_ = 0;
				gint _tmp180_ = 0;
				gint _tmp181_ = 0;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp152_) {
#line 9114 "CheckerboardLayout.c"
					gint _tmp153_ = 0;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp153_ = ctr;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					ctr = _tmp153_ + 1;
#line 9120 "CheckerboardLayout.c"
				}
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp152_ = FALSE;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp154_ = ctr;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp155_ = total_items;
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp154_ < _tmp155_)) {
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 9132 "CheckerboardLayout.c"
				}
#line 1649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp156_ = self->priv->view;
#line 1649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp157_ = ctr;
#line 1649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp158_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, TYPE_DATA_COLLECTION, DataCollection), _tmp157_);
#line 1649 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp159_ = item;
#line 1650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp160_ = _tmp159_->requisition;
#line 1650 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				req = _tmp160_;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp161_ = req;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp162_ = _tmp161_.height;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp163_ = alignment_points;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp163__length1 = alignment_points_length1;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp164_ = row;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp165_ = _tmp163_[_tmp164_];
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp166_ = item;
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp167_ = checkerboard_item_get_alignment_point (_tmp166_);
#line 1655 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				true_height = _tmp162_ + (_tmp165_ - _tmp167_);
#line 1656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp168_ = true_height;
#line 1656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp169_ = req;
#line 1656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp170_ = _tmp169_.height;
#line 1656 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp168_ >= _tmp170_, "true_height >= req.height");
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp171_ = true_height;
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp172_ = row_heights;
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp172__length1 = row_heights_length1;
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp173_ = row;
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp174_ = _tmp172_[_tmp173_];
#line 1659 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp171_ > _tmp174_) {
#line 9186 "CheckerboardLayout.c"
					gint* _tmp175_ = NULL;
					gint _tmp175__length1 = 0;
					gint _tmp176_ = 0;
					gint _tmp177_ = 0;
					gint _tmp178_ = 0;
#line 1664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175_ = row_heights;
#line 1664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175__length1 = row_heights_length1;
#line 1664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp176_ = row;
#line 1664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp177_ = true_height;
#line 1664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp175_[_tmp176_] = _tmp177_;
#line 1664 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp178_ = _tmp175_[_tmp176_];
#line 9204 "CheckerboardLayout.c"
				}
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp179_ = col;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = _tmp179_ + 1;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp180_ = col;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp181_ = max_cols;
#line 1668 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp180_ >= _tmp181_) {
#line 9216 "CheckerboardLayout.c"
					gint _tmp182_ = 0;
#line 1669 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 1670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp182_ = row;
#line 1670 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp182_ + 1;
#line 9224 "CheckerboardLayout.c"
				}
#line 1648 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 9228 "CheckerboardLayout.c"
			}
		}
	}
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp183_ = max_rows;
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp184_ = g_new0 (CheckerboardLayoutLayoutRow*, _tmp183_ + 1);
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = _tmp184_;
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = _tmp183_;
#line 1675 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp185_ = gutter;
#line 1678 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	x = _tmp185_;
#line 1679 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	y = CHECKERBOARD_LAYOUT_TOP_PADDING;
#line 1680 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	col = 0;
#line 1681 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row = 0;
#line 1682 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	current_row = NULL;
#line 9256 "CheckerboardLayout.c"
	{
		gint ctr = 0;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		ctr = 0;
#line 9261 "CheckerboardLayout.c"
		{
			gboolean _tmp186_ = FALSE;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp186_ = TRUE;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 9268 "CheckerboardLayout.c"
				gint _tmp188_ = 0;
				gint _tmp189_ = 0;
				CheckerboardItem* item = NULL;
				ViewCollection* _tmp190_ = NULL;
				gint _tmp191_ = 0;
				DataObject* _tmp192_ = NULL;
				Dimensions req = {0};
				CheckerboardItem* _tmp193_ = NULL;
				Dimensions _tmp194_ = {0};
				gint xpadding = 0;
				gint* _tmp195_ = NULL;
				gint _tmp195__length1 = 0;
				gint _tmp196_ = 0;
				gint _tmp197_ = 0;
				Dimensions _tmp198_ = {0};
				gint _tmp199_ = 0;
				gint _tmp200_ = 0;
				gint ypadding = 0;
				gint* _tmp201_ = NULL;
				gint _tmp201__length1 = 0;
				gint _tmp202_ = 0;
				gint _tmp203_ = 0;
				CheckerboardItem* _tmp204_ = NULL;
				gint _tmp205_ = 0;
				gint _tmp206_ = 0;
				CheckerboardItem* _tmp207_ = NULL;
				gint _tmp208_ = 0;
				gint _tmp209_ = 0;
				CheckerboardItem* _tmp210_ = NULL;
				gint _tmp211_ = 0;
				gint _tmp212_ = 0;
				CheckerboardItem* _tmp213_ = NULL;
				Dimensions _tmp214_ = {0};
				gint _tmp215_ = 0;
				CheckerboardItem* _tmp216_ = NULL;
				Dimensions _tmp217_ = {0};
				gint _tmp218_ = 0;
				CheckerboardItem* _tmp219_ = NULL;
				gint _tmp220_ = 0;
				gint _tmp221_ = 0;
				CheckerboardLayoutLayoutRow* _tmp222_ = NULL;
				CheckerboardLayoutLayoutRow* _tmp229_ = NULL;
				CheckerboardItem** _tmp230_ = NULL;
				gint _tmp230__length1 = 0;
				gint _tmp231_ = 0;
				CheckerboardItem* _tmp232_ = NULL;
				CheckerboardItem* _tmp233_ = NULL;
				CheckerboardItem* _tmp234_ = NULL;
				gint _tmp235_ = 0;
				gint* _tmp236_ = NULL;
				gint _tmp236__length1 = 0;
				gint _tmp237_ = 0;
				gint _tmp238_ = 0;
				gint _tmp239_ = 0;
				gint _tmp240_ = 0;
				gint _tmp241_ = 0;
				gint _tmp242_ = 0;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!_tmp186_) {
#line 9328 "CheckerboardLayout.c"
					gint _tmp187_ = 0;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp187_ = ctr;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					ctr = _tmp187_ + 1;
#line 9334 "CheckerboardLayout.c"
				}
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp186_ = FALSE;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp188_ = ctr;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp189_ = total_items;
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp188_ < _tmp189_)) {
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 9346 "CheckerboardLayout.c"
				}
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp190_ = self->priv->view;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp191_ = ctr;
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp192_ = data_collection_get_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp190_, TYPE_DATA_COLLECTION, DataCollection), _tmp191_);
#line 1685 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp193_ = item;
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp194_ = _tmp193_->requisition;
#line 1686 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				req = _tmp194_;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp195_ = column_widths;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp195__length1 = column_widths_length1;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp196_ = col;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp197_ = _tmp195_[_tmp196_];
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp198_ = req;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp199_ = _tmp198_.width;
#line 1689 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				xpadding = (_tmp197_ - _tmp199_) / 2;
#line 1690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp200_ = xpadding;
#line 1690 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp200_ >= 0, "xpadding >= 0");
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp201_ = alignment_points;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp201__length1 = alignment_points_length1;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp202_ = row;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp203_ = _tmp201_[_tmp202_];
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp204_ = item;
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp205_ = checkerboard_item_get_alignment_point (_tmp204_);
#line 1693 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				ypadding = _tmp203_ - _tmp205_;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp206_ = ypadding;
#line 1694 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_vala_assert (_tmp206_ >= 0, "ypadding >= 0");
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp207_ = item;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp208_ = x;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp209_ = xpadding;
#line 1697 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp207_->allocation.x = _tmp208_ + _tmp209_;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp210_ = item;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp211_ = y;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp212_ = ypadding;
#line 1698 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp210_->allocation.y = _tmp211_ + _tmp212_;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp213_ = item;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp214_ = req;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp215_ = _tmp214_.width;
#line 1699 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp213_->allocation.width = _tmp215_;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp216_ = item;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp217_ = req;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp218_ = _tmp217_.height;
#line 1700 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp216_->allocation.height = _tmp218_;
#line 1701 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp219_ = item;
#line 1701 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp220_ = col;
#line 1701 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp221_ = row;
#line 1701 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_set_grid_coordinates (_tmp219_, _tmp220_, _tmp221_);
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp222_ = current_row;
#line 1704 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp222_ == NULL) {
#line 9442 "CheckerboardLayout.c"
					gint _tmp223_ = 0;
					gint* _tmp224_ = NULL;
					gint _tmp224__length1 = 0;
					gint _tmp225_ = 0;
					gint _tmp226_ = 0;
					gint _tmp227_ = 0;
					CheckerboardLayoutLayoutRow* _tmp228_ = NULL;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp223_ = y;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp224_ = row_heights;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp224__length1 = row_heights_length1;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp225_ = row;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp226_ = _tmp224_[_tmp225_];
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp227_ = max_cols;
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp228_ = checkerboard_layout_layout_row_new (_tmp223_, _tmp226_, _tmp227_);
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (current_row);
#line 1705 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					current_row = _tmp228_;
#line 9468 "CheckerboardLayout.c"
				}
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp229_ = current_row;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230_ = _tmp229_->items;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230__length1 = _tmp229_->items_length1;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp231_ = col;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp232_ = item;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp233_ = _g_object_ref0 (_tmp232_);
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_tmp230_[_tmp231_]);
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp230_[_tmp231_] = _tmp233_;
#line 1707 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp234_ = _tmp230_[_tmp231_];
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp235_ = x;
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp236_ = column_widths;
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp236__length1 = column_widths_length1;
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp237_ = col;
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp238_ = _tmp236_[_tmp237_];
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp239_ = gutter;
#line 1709 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				x = _tmp235_ + (_tmp238_ + _tmp239_);
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp240_ = col;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				col = _tmp240_ + 1;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp241_ = col;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp242_ = max_cols;
#line 1712 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp241_ >= _tmp242_) {
#line 9512 "CheckerboardLayout.c"
					CheckerboardLayoutLayoutRow* _tmp243_ = NULL;
					CheckerboardLayoutLayoutRow** _tmp244_ = NULL;
					gint _tmp244__length1 = 0;
					gint _tmp245_ = 0;
					CheckerboardLayoutLayoutRow* _tmp246_ = NULL;
					CheckerboardLayoutLayoutRow* _tmp247_ = NULL;
					CheckerboardLayoutLayoutRow* _tmp248_ = NULL;
					gint _tmp249_ = 0;
					gint _tmp250_ = 0;
					gint* _tmp251_ = NULL;
					gint _tmp251__length1 = 0;
					gint _tmp252_ = 0;
					gint _tmp253_ = 0;
					gint _tmp254_ = 0;
#line 1713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp243_ = current_row;
#line 1713 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_vala_assert (_tmp243_ != NULL, "current_row != null");
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244_ = self->priv->item_rows;
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244__length1 = self->priv->item_rows_length1;
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp245_ = row;
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp246_ = current_row;
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp247_ = _checkerboard_layout_layout_row_ref0 (_tmp246_);
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (_tmp244_[_tmp245_]);
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp244_[_tmp245_] = _tmp247_;
#line 1714 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp248_ = _tmp244_[_tmp245_];
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_checkerboard_layout_layout_row_unref0 (current_row);
#line 1715 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					current_row = NULL;
#line 1717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp249_ = gutter;
#line 1717 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					x = _tmp249_;
#line 1718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp250_ = y;
#line 1718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp251_ = row_heights;
#line 1718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp251__length1 = row_heights_length1;
#line 1718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp252_ = row;
#line 1718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp253_ = _tmp251_[_tmp252_];
#line 1718 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					y = _tmp250_ + (_tmp253_ + CHECKERBOARD_LAYOUT_ROW_GUTTER_PADDING);
#line 1719 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					col = 0;
#line 1720 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp254_ = row;
#line 1720 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					row = _tmp254_ + 1;
#line 9573 "CheckerboardLayout.c"
				}
#line 1684 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 9577 "CheckerboardLayout.c"
			}
		}
	}
#line 1725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp255_ = current_row;
#line 1725 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp255_ != NULL) {
#line 9585 "CheckerboardLayout.c"
		CheckerboardLayoutLayoutRow** _tmp256_ = NULL;
		gint _tmp256__length1 = 0;
		gint _tmp257_ = 0;
		CheckerboardLayoutLayoutRow* _tmp258_ = NULL;
		CheckerboardLayoutLayoutRow* _tmp259_ = NULL;
		CheckerboardLayoutLayoutRow* _tmp260_ = NULL;
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_ = self->priv->item_rows;
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256__length1 = self->priv->item_rows_length1;
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp257_ = row;
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp258_ = current_row;
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp259_ = _checkerboard_layout_layout_row_ref0 (_tmp258_);
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_checkerboard_layout_layout_row_unref0 (_tmp256_[_tmp257_]);
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp256_[_tmp257_] = _tmp259_;
#line 1726 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp260_ = _tmp256_[_tmp257_];
#line 9608 "CheckerboardLayout.c"
	}
#line 1729 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp261_ = max_cols;
#line 1729 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->columns = _tmp261_;
#line 1730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp262_ = row;
#line 1730 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->rows = _tmp262_ + 1;
#line 1731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp263_ = self->priv->rows;
#line 1731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp264_ = max_rows;
#line 1731 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_vala_assert (_tmp263_ == _tmp264_, "rows == max_rows");
#line 1735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp265_ = y;
#line 1735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp266_ = row_heights;
#line 1735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp266__length1 = row_heights_length1;
#line 1735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp267_ = row;
#line 1735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp268_ = _tmp266_[_tmp267_];
#line 1735 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	total_height = (_tmp265_ + _tmp268_) + CHECKERBOARD_LAYOUT_BOTTOM_PADDING;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp270_ = visible_width;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp271_ = allocation;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp272_ = _tmp271_.width;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp270_ != _tmp272_) {
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = TRUE;
#line 9646 "CheckerboardLayout.c"
	} else {
		gint _tmp273_ = 0;
		GtkAllocation _tmp274_ = {0};
		gint _tmp275_ = 0;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp273_ = total_height;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp274_ = allocation;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp275_ = _tmp274_.height;
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp269_ = _tmp273_ != _tmp275_;
#line 9659 "CheckerboardLayout.c"
	}
#line 1736 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp269_) {
#line 9663 "CheckerboardLayout.c"
		gint _tmp276_ = 0;
		gint _tmp277_ = 0;
		gint _tmp278_ = 0;
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp276_ = visible_width;
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp277_ = total_height;
#line 1741 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp276_, _tmp277_);
#line 1742 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		self->priv->size_allocate_due_to_reflow = TRUE;
#line 1745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp278_ = total_height;
#line 1745 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_center_on_anchor (self, (gdouble) _tmp278_);
#line 9679 "CheckerboardLayout.c"
	}
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_checkerboard_layout_layout_row_unref0 (current_row);
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	alignment_points = (g_free (alignment_points), NULL);
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	row_heights = (g_free (row_heights), NULL);
#line 1432 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	column_widths = (g_free (column_widths), NULL);
#line 9689 "CheckerboardLayout.c"
}


static void checkerboard_layout_items_dirty (CheckerboardLayout* self, const gchar* reason, GeeIterable* items) {
	GdkRectangle dirty = {0};
	gboolean _tmp35_ = FALSE;
	GdkRectangle _tmp36_ = {0};
	gint _tmp37_ = 0;
#line 1749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (reason != NULL);
#line 1749 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (GEE_IS_ITERABLE (items));
#line 1750 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&dirty, 0, sizeof (GdkRectangle));
#line 9706 "CheckerboardLayout.c"
	{
		GeeIterator* _data_view_it = NULL;
		GeeIterable* _tmp0_ = NULL;
		GeeIterator* _tmp1_ = NULL;
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = items;
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp1_ = gee_iterable_iterator (_tmp0_);
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_data_view_it = _tmp1_;
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		while (TRUE) {
#line 9719 "CheckerboardLayout.c"
			GeeIterator* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			DataView* data_view = NULL;
			GeeIterator* _tmp4_ = NULL;
			gpointer _tmp5_ = NULL;
			CheckerboardItem* item = NULL;
			DataView* _tmp6_ = NULL;
			CheckerboardItem* _tmp7_ = NULL;
			CheckerboardItem* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			ViewCollection* _tmp10_ = NULL;
			CheckerboardItem* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			CheckerboardItem* _tmp14_ = NULL;
			GdkRectangle _tmp15_ = {0};
			gint _tmp16_ = 0;
			GdkRectangle intersection = {0};
			CheckerboardItem* _tmp23_ = NULL;
			GdkRectangle _tmp24_ = {0};
			GdkRectangle _tmp25_ = {0};
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			GdkRectangle _tmp28_ = {0};
			gint _tmp29_ = 0;
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp2_ = _data_view_it;
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp3_ = gee_iterator_next (_tmp2_);
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp3_) {
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				break;
#line 9753 "CheckerboardLayout.c"
			}
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp4_ = _data_view_it;
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp5_ = gee_iterator_get (_tmp4_);
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			data_view = (DataView*) _tmp5_;
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp6_ = data_view;
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1752 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			item = _tmp7_;
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp8_ = item;
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = data_view_is_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_VIEW, DataView));
#line 1754 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp9_) {
#line 1755 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1755 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1755 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				continue;
#line 9779 "CheckerboardLayout.c"
			}
#line 1757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = self->priv->view;
#line 1757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = item;
#line 1757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = data_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
#line 1757 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_vala_assert (_tmp12_, "view.contains(item)");
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp14_ = item;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp15_ = _tmp14_->allocation;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp16_ = _tmp15_.width;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp16_ <= 0) {
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = TRUE;
#line 9799 "CheckerboardLayout.c"
			} else {
				CheckerboardItem* _tmp17_ = NULL;
				GdkRectangle _tmp18_ = {0};
				gint _tmp19_ = 0;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = item;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _tmp17_->allocation;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = _tmp18_.height;
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp13_ = _tmp19_ <= 0;
#line 9812 "CheckerboardLayout.c"
			}
#line 1761 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp13_) {
#line 9816 "CheckerboardLayout.c"
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
#line 1762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp20_ = reason;
#line 1762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = g_strdup_printf ("items_dirty: %s", _tmp20_);
#line 1762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = _tmp21_;
#line 1762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_layout_need_reflow (self, _tmp22_);
#line 1762 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_free0 (_tmp22_);
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (_data_view_it);
#line 1764 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				return;
#line 9838 "CheckerboardLayout.c"
			}
#line 1768 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			memset (&intersection, 0, sizeof (GdkRectangle));
#line 1769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp23_ = item;
#line 1769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp24_ = _tmp23_->allocation;
#line 1769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp26_ = gdk_rectangle_intersect (&self->priv->visible_page, &_tmp24_, &_tmp25_);
#line 1769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			intersection = _tmp25_;
#line 1769 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (!_tmp26_) {
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (data_view);
#line 1770 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				continue;
#line 9858 "CheckerboardLayout.c"
			}
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp28_ = dirty;
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp29_ = _tmp28_.width;
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp29_ == 0) {
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = TRUE;
#line 9868 "CheckerboardLayout.c"
			} else {
				GdkRectangle _tmp30_ = {0};
				gint _tmp31_ = 0;
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp30_ = dirty;
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp31_ = _tmp30_.height;
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = _tmp31_ == 0;
#line 9878 "CheckerboardLayout.c"
			}
#line 1773 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			if (_tmp27_) {
#line 9882 "CheckerboardLayout.c"
				GdkRectangle _tmp32_ = {0};
#line 1774 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp32_ = intersection;
#line 1774 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				dirty = _tmp32_;
#line 9888 "CheckerboardLayout.c"
			} else {
				GdkRectangle _tmp33_ = {0};
				GdkRectangle _tmp34_ = {0};
#line 1776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp33_ = intersection;
#line 1776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				gdk_rectangle_union (&dirty, &_tmp33_, &_tmp34_);
#line 1776 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				dirty = _tmp34_;
#line 9898 "CheckerboardLayout.c"
			}
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (item);
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (data_view);
#line 9904 "CheckerboardLayout.c"
		}
#line 1751 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (_data_view_it);
#line 9908 "CheckerboardLayout.c"
	}
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = dirty;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = _tmp36_.width;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp37_ > 0) {
#line 9916 "CheckerboardLayout.c"
		GdkRectangle _tmp38_ = {0};
		gint _tmp39_ = 0;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = dirty;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp39_ = _tmp38_.height;
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = _tmp39_ > 0;
#line 9925 "CheckerboardLayout.c"
	} else {
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp35_ = FALSE;
#line 9929 "CheckerboardLayout.c"
	}
#line 1779 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp35_) {
#line 9933 "CheckerboardLayout.c"
		GdkRectangle _tmp40_ = {0};
		gint _tmp41_ = 0;
		GdkRectangle _tmp42_ = {0};
		gint _tmp43_ = 0;
		GdkRectangle _tmp44_ = {0};
		gint _tmp45_ = 0;
		GdkRectangle _tmp46_ = {0};
		gint _tmp47_ = 0;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = dirty;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp41_ = _tmp40_.x;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = dirty;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = _tmp42_.y;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = dirty;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp45_ = _tmp44_.width;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = dirty;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp47_ = _tmp46_.height;
#line 1784 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_queue_draw_area (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp41_, _tmp43_, _tmp45_, _tmp47_);
#line 9960 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_real_map (GtkWidget* base) {
	CheckerboardLayout * self;
#line 1788 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1789 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->map (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget));
#line 1791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 9973 "CheckerboardLayout.c"
}


static void checkerboard_layout_set_colors (CheckerboardLayout* self, gboolean in_focus) {
	ConfigFacade* _tmp0_ = NULL;
	ConfigFacade* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GdkRGBA _tmp3_ = {0};
	ConfigFacade* _tmp4_ = NULL;
	ConfigFacade* _tmp5_ = NULL;
	GdkRGBA _tmp6_ = {0};
	ConfigFacade* _tmp7_ = NULL;
	ConfigFacade* _tmp8_ = NULL;
	GdkRGBA _tmp9_ = {0};
	GtkStyleContext* _tmp10_ = NULL;
	GdkRGBA _tmp11_ = {0};
#line 1794 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = config_facade_get_instance ();
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = in_focus;
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_selected_color (_tmp1_, _tmp2_, &_tmp3_);
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->selected_color = _tmp3_;
#line 1796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = config_facade_get_instance ();
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = _tmp4_;
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_unselected_color (_tmp5_, &_tmp6_);
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->unselected_color = _tmp6_;
#line 1797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp5_);
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = config_facade_get_instance ();
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = _tmp7_;
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_border_color (_tmp8_, &_tmp9_);
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->border_color = _tmp9_;
#line 1798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp8_);
#line 1799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_style_context_get_background_color (_tmp10_, GTK_STATE_FLAG_NORMAL, &_tmp11_);
#line 1799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->bg_color = _tmp11_;
#line 10030 "CheckerboardLayout.c"
}


static void checkerboard_layout_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	CheckerboardLayout * self;
	GtkAllocation _tmp0_ = {0};
#line 1802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1802 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (allocation != NULL);
#line 1803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = *allocation;
#line 1803 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1805 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_viewport_resized (self);
#line 10047 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_draw (GtkWidget* base, cairo_t* ctx) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkStyleContext* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp60_ = FALSE;
	gboolean _result_ = FALSE;
	cairo_t* _tmp63_ = NULL;
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 1817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
#line 1817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	allocation = _tmp0_;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = ctx;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = allocation;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = _tmp3_.width;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp5_ = allocation;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = _tmp5_.height;
#line 1818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_render_background (_tmp1_, _tmp2_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp4_, (gdouble) _tmp6_);
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp7_ = self->priv->message;
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp7_ == NULL) {
#line 10092 "CheckerboardLayout.c"
		gboolean _tmp8_ = FALSE;
#line 1826 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = self->priv->exposure_dirty;
#line 1826 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp8_) {
#line 1827 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			checkerboard_layout_expose_items (self, "draw");
#line 10100 "CheckerboardLayout.c"
		}
		{
			GeeList* _item_list = NULL;
			GdkRectangle _tmp9_ = {0};
			GeeList* _tmp10_ = NULL;
			gint _item_size = 0;
			GeeList* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _item_index = 0;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp9_ = self->priv->visible_page;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp10_ = checkerboard_layout_intersection (self, &_tmp9_);
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_list = _tmp10_;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp11_ = _item_list;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp12_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_COLLECTION, GeeCollection));
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp13_ = _tmp12_;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_size = _tmp13_;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_item_index = -1;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			while (TRUE) {
#line 10129 "CheckerboardLayout.c"
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				CheckerboardItem* item = NULL;
				GeeList* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gpointer _tmp19_ = NULL;
				GdkRGBA _tmp20_ = {0};
				CheckerboardItem* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				CheckerboardItem* _tmp25_ = NULL;
				cairo_t* _tmp26_ = NULL;
				GdkRGBA _tmp27_ = {0};
				GdkRGBA _tmp28_ = {0};
				GdkRGBA _tmp29_ = {0};
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp14_ = _item_index;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_item_index = _tmp14_ + 1;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp15_ = _item_index;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp16_ = _item_size;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (!(_tmp15_ < _tmp16_)) {
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					break;
#line 10157 "CheckerboardLayout.c"
				}
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp17_ = _item_list;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp18_ = _item_index;
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				item = (CheckerboardItem*) _tmp19_;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp21_ = item;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp22_ = data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TYPE_DATA_VIEW, DataView));
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				if (_tmp22_) {
#line 10173 "CheckerboardLayout.c"
					GdkRGBA _tmp23_ = {0};
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp23_ = self->priv->selected_color;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = _tmp23_;
#line 10179 "CheckerboardLayout.c"
				} else {
					GdkRGBA _tmp24_ = {0};
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp24_ = self->priv->unselected_color;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
					_tmp20_ = _tmp24_;
#line 10186 "CheckerboardLayout.c"
				}
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp25_ = item;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp26_ = ctx;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp27_ = self->priv->bg_color;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp28_ = self->priv->unselected_color;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_tmp29_ = self->priv->border_color;
#line 1831 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				checkerboard_item_paint (_tmp25_, _tmp26_, &_tmp27_, &_tmp20_, &_tmp28_, &_tmp29_);
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
				_g_object_unref0 (item);
#line 10202 "CheckerboardLayout.c"
			}
#line 1830 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_g_object_unref0 (_item_list);
#line 10206 "CheckerboardLayout.c"
		}
	} else {
		PangoLayout* pango_layout = NULL;
		const gchar* _tmp30_ = NULL;
		PangoLayout* _tmp31_ = NULL;
		gint text_width = 0;
		gint text_height = 0;
		PangoLayout* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		GtkAllocation _tmp35_ = {0};
		gint x = 0;
		GtkAllocation _tmp36_ = {0};
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint y = 0;
		GtkAllocation _tmp42_ = {0};
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		gint _tmp46_ = 0;
		cairo_t* _tmp48_ = NULL;
		GdkRGBA _tmp49_ = {0};
		gdouble _tmp50_ = 0.0;
		GdkRGBA _tmp51_ = {0};
		gdouble _tmp52_ = 0.0;
		GdkRGBA _tmp53_ = {0};
		gdouble _tmp54_ = 0.0;
		cairo_t* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		cairo_t* _tmp58_ = NULL;
		PangoLayout* _tmp59_ = NULL;
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = self->priv->message;
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = gtk_widget_create_pango_layout (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp30_);
#line 1836 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout = _tmp31_;
#line 1838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = pango_layout;
#line 1838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_layout_get_pixel_size (_tmp32_, &_tmp33_, &_tmp34_);
#line 1838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_width = _tmp33_;
#line 1838 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		text_height = _tmp34_;
#line 1840 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp35_);
#line 1840 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		allocation = _tmp35_;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp36_ = allocation;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp37_ = _tmp36_.width;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp38_ = text_width;
#line 1842 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = _tmp37_ - _tmp38_;
#line 1843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp40_ = x;
#line 1843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp40_ > 0) {
#line 10272 "CheckerboardLayout.c"
			gint _tmp41_ = 0;
#line 1843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp41_ = x;
#line 1843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp39_ = _tmp41_ / 2;
#line 10278 "CheckerboardLayout.c"
		} else {
#line 1843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp39_ = 0;
#line 10282 "CheckerboardLayout.c"
		}
#line 1843 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		x = _tmp39_;
#line 1845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp42_ = allocation;
#line 1845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp43_ = _tmp42_.height;
#line 1845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp44_ = text_height;
#line 1845 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp43_ - _tmp44_;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp46_ = y;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (_tmp46_ > 0) {
#line 10298 "CheckerboardLayout.c"
			gint _tmp47_ = 0;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp47_ = y;
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp45_ = _tmp47_ / 2;
#line 10304 "CheckerboardLayout.c"
		} else {
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			_tmp45_ = 0;
#line 10308 "CheckerboardLayout.c"
		}
#line 1846 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		y = _tmp45_;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp48_ = ctx;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp49_ = self->priv->unselected_color;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp50_ = _tmp49_.red;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp51_ = self->priv->unselected_color;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp52_ = _tmp51_.green;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp53_ = self->priv->unselected_color;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp54_ = _tmp53_.blue;
#line 1848 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgb (_tmp48_, _tmp50_, _tmp52_, _tmp54_);
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp55_ = ctx;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp56_ = x;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp57_ = y;
#line 1849 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_move_to (_tmp55_, (gdouble) _tmp56_, (gdouble) _tmp57_);
#line 1850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp58_ = ctx;
#line 1850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp59_ = pango_layout;
#line 1850 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		pango_cairo_show_layout (_tmp58_, _tmp59_);
#line 1821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_g_object_unref0 (pango_layout);
#line 10344 "CheckerboardLayout.c"
	}
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw != NULL) {
#line 10348 "CheckerboardLayout.c"
		cairo_t* _tmp61_ = NULL;
		gboolean _tmp62_ = FALSE;
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp61_ = ctx;
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp62_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp61_);
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = _tmp62_;
#line 10357 "CheckerboardLayout.c"
	} else {
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp60_ = TRUE;
#line 10361 "CheckerboardLayout.c"
	}
#line 1853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_result_ = _tmp60_;
#line 1856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp63_ = ctx;
#line 1856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_draw_selection_band (self, _tmp63_);
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _result_;
#line 1858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 10373 "CheckerboardLayout.c"
}


static void checkerboard_layout_draw_selection_band (CheckerboardLayout* self, cairo_t* ctx) {
	gboolean _tmp0_ = FALSE;
	GdkRectangle _tmp1_ = {0};
	gint _tmp2_ = 0;
	gboolean _tmp5_ = FALSE;
	GtkAdjustment* _tmp6_ = NULL;
	GdkRectangle visible_page = {0};
	GtkAdjustment* _tmp8_ = NULL;
	GtkAdjustment* _tmp9_ = NULL;
	GdkRectangle _tmp10_ = {0};
	GdkRectangle visible_band = {0};
	GdkRectangle _tmp11_ = {0};
	GdkRectangle _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	GdkRectangle _tmp14_ = {0};
	gint _tmp15_ = 0;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	cairo_t* _tmp37_ = NULL;
	GdkRGBA _tmp38_ = {0};
	gdouble _tmp39_ = 0.0;
	GdkRGBA _tmp40_ = {0};
	gdouble _tmp41_ = 0.0;
	GdkRGBA _tmp42_ = {0};
	gdouble _tmp43_ = 0.0;
	cairo_t* _tmp44_ = NULL;
	GdkRectangle _tmp45_ = {0};
	gint _tmp46_ = 0;
	GdkRectangle _tmp47_ = {0};
	gint _tmp48_ = 0;
	GdkRectangle _tmp49_ = {0};
	gint _tmp50_ = 0;
	GdkRectangle _tmp51_ = {0};
	gint _tmp52_ = 0;
	cairo_t* _tmp53_ = NULL;
#line 1861 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1861 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (ctx != NULL);
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = self->priv->selection_band;
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_.width;
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp2_ <= 1) {
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = TRUE;
#line 10424 "CheckerboardLayout.c"
	} else {
		GdkRectangle _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = self->priv->selection_band;
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp4_ = _tmp3_.height;
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp0_ = _tmp4_ <= 1;
#line 10434 "CheckerboardLayout.c"
	}
#line 1863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp0_) {
#line 1864 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 10440 "CheckerboardLayout.c"
	}
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->hadjustment;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp6_ == NULL) {
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = TRUE;
#line 10448 "CheckerboardLayout.c"
	} else {
		GtkAdjustment* _tmp7_ = NULL;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = self->priv->vadjustment;
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = _tmp7_ == NULL;
#line 10455 "CheckerboardLayout.c"
	}
#line 1867 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp5_) {
#line 1868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return;
#line 10461 "CheckerboardLayout.c"
	}
#line 1871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->hadjustment;
#line 1871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp9_ = self->priv->vadjustment;
#line 1871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	get_adjustment_page (_tmp8_, _tmp9_, &_tmp10_);
#line 1871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_page = _tmp10_;
#line 1872 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&visible_band, 0, sizeof (GdkRectangle));
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp11_ = self->priv->selection_band;
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gdk_rectangle_intersect (&visible_page, &_tmp11_, &_tmp12_);
#line 1873 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	visible_band = _tmp12_;
#line 1876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = visible_band;
#line 1876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp15_ = _tmp14_.width;
#line 1876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp15_ > 1) {
#line 10485 "CheckerboardLayout.c"
		GdkRectangle _tmp16_ = {0};
		gint _tmp17_ = 0;
#line 1876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp16_ = visible_band;
#line 1876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp17_ = _tmp16_.height;
#line 1876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = _tmp17_ > 1;
#line 10494 "CheckerboardLayout.c"
	} else {
#line 1876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp13_ = FALSE;
#line 10498 "CheckerboardLayout.c"
	}
#line 1876 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp13_) {
#line 10502 "CheckerboardLayout.c"
		cairo_t* _tmp18_ = NULL;
		GdkRGBA _tmp19_ = {0};
		gdouble _tmp20_ = 0.0;
		GdkRGBA _tmp21_ = {0};
		gdouble _tmp22_ = 0.0;
		GdkRGBA _tmp23_ = {0};
		gdouble _tmp24_ = 0.0;
		cairo_t* _tmp25_ = NULL;
		GdkRectangle _tmp26_ = {0};
		gint _tmp27_ = 0;
		GdkRectangle _tmp28_ = {0};
		gint _tmp29_ = 0;
		GdkRectangle _tmp30_ = {0};
		gint _tmp31_ = 0;
		GdkRectangle _tmp32_ = {0};
		gint _tmp33_ = 0;
		cairo_t* _tmp34_ = NULL;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp18_ = ctx;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->selected_color;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp20_ = _tmp19_.red;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp21_ = self->priv->selected_color;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = _tmp21_.green;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp23_ = self->priv->selected_color;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp24_ = _tmp23_.blue;
#line 1877 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_set_source_rgba (_tmp18_, _tmp20_, _tmp22_, _tmp24_, CHECKERBOARD_LAYOUT_SELECTION_ALPHA);
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp25_ = ctx;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = visible_band;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = _tmp26_.x;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp28_ = visible_band;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp29_ = _tmp28_.y;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp30_ = visible_band;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp31_ = _tmp30_.width;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp32_ = visible_band;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp33_ = _tmp32_.height;
#line 1879 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_rectangle (_tmp25_, (gdouble) _tmp27_, (gdouble) _tmp29_, (gdouble) _tmp31_, (gdouble) _tmp33_);
#line 1881 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp34_ = ctx;
#line 1881 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		cairo_fill (_tmp34_);
#line 10560 "CheckerboardLayout.c"
	}
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp35_ = ctx;
#line 1887 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_width (_tmp35_, 1.0);
#line 1888 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp36_ = ctx;
#line 1888 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_line_cap (_tmp36_, CAIRO_LINE_CAP_SQUARE);
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp37_ = ctx;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp38_ = self->priv->selected_color;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp39_ = _tmp38_.red;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp40_ = self->priv->selected_color;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp41_ = _tmp40_.green;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp42_ = self->priv->selected_color;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp43_ = _tmp42_.blue;
#line 1889 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_set_source_rgb (_tmp37_, _tmp39_, _tmp41_, _tmp43_);
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp44_ = ctx;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp45_ = self->priv->selection_band;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp46_ = _tmp45_.x;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp47_ = self->priv->selection_band;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp48_ = _tmp47_.y;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp49_ = self->priv->selection_band;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp50_ = _tmp49_.width;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp51_ = self->priv->selection_band;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp52_ = _tmp51_.height;
#line 1890 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_rectangle (_tmp44_, ((gdouble) _tmp46_) + 0.5, ((gdouble) _tmp48_) + 0.5, ((gdouble) _tmp50_) - 1.0, ((gdouble) _tmp52_) - 1.0);
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp53_ = ctx;
#line 1892 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	cairo_stroke (_tmp53_);
#line 10610 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	CheckerboardItem* item = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	CheckerboardItem* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	CheckerboardItem* _tmp4_ = NULL;
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1895 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (GTK_IS_TOOLTIP (tooltip), FALSE);
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = x;
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = y;
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = checkerboard_layout_get_item_at_pixel (self, (gdouble) _tmp0_, (gdouble) _tmp1_);
#line 1896 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	item = _tmp2_;
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = item;
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp4_ != NULL) {
#line 10639 "CheckerboardLayout.c"
		CheckerboardItem* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		GtkTooltip* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp5_ = item;
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp6_ = x;
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp7_ = y;
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp8_ = tooltip;
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp9_ = checkerboard_item_query_tooltip (_tmp5_, _tmp6_, _tmp7_, _tmp8_);
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = _tmp9_;
#line 10657 "CheckerboardLayout.c"
	} else {
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp3_ = FALSE;
#line 10661 "CheckerboardLayout.c"
	}
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp3_;
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (item);
#line 1898 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 10669 "CheckerboardLayout.c"
}


static void checkerboard_layout_on_colors_changed (CheckerboardLayout* self) {
	ConfigFacade* _tmp0_ = NULL;
	ConfigFacade* _tmp1_ = NULL;
	GdkRGBA _tmp2_ = {0};
#line 1901 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (IS_CHECKERBOARD_LAYOUT (self));
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = config_facade_get_instance ();
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = _tmp0_;
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	config_facade_get_bg_color (_tmp1_, &_tmp2_);
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	gtk_widget_override_background_color (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GTK_STATE_FLAG_NORMAL, &_tmp2_);
#line 1902 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp1_);
#line 1903 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 10691 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_focus_in_event (GtkWidget* base, GdkEventFocus* event) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	ViewCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GdkEventFocus* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 1906 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1906 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1907 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, TRUE);
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = view_collection_get_selected (_tmp0_);
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "focus_in_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1908 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 1910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = event;
#line 1910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_in_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp3_);
#line 1910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 1910 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 10727 "CheckerboardLayout.c"
}


static gboolean checkerboard_layout_real_focus_out_event (GtkWidget* base, GdkEventFocus* event) {
	CheckerboardLayout * self;
	gboolean result = FALSE;
	ViewCollection* _tmp0_ = NULL;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GdkEventFocus* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 1913 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1914 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_set_colors (self, FALSE);
#line 1915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 1915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = view_collection_get_selected (_tmp0_);
#line 1915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = _tmp1_;
#line 1915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_items_dirty (self, "focus_out_event", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1915 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp2_);
#line 1917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = event;
#line 1917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = GTK_WIDGET_CLASS (checkerboard_layout_parent_class)->focus_out_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), _tmp3_);
#line 1917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	result = _tmp4_;
#line 1917 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return result;
#line 10763 "CheckerboardLayout.c"
}


static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_construct (GType object_type, gint y, gint height, gint num_in_row) {
	CheckerboardLayoutLayoutRow* self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	CheckerboardItem** _tmp3_ = NULL;
#line 788 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = (CheckerboardLayoutLayoutRow*) g_type_create_instance (object_type);
#line 789 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = y;
#line 789 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->y = _tmp0_;
#line 790 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = height;
#line 790 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->height = _tmp1_;
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = num_in_row;
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp3_ = g_new0 (CheckerboardItem*, _tmp2_ + 1);
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = _tmp3_;
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items_length1 = _tmp2_;
#line 791 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->_items_size_ = self->items_length1;
#line 788 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return self;
#line 10797 "CheckerboardLayout.c"
}


static CheckerboardLayoutLayoutRow* checkerboard_layout_layout_row_new (gint y, gint height, gint num_in_row) {
#line 788 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return checkerboard_layout_layout_row_construct (CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, y, height, num_in_row);
#line 10804 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_layout_row_init (GValue* value) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	value->data[0].v_pointer = NULL;
#line 10811 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_layout_row_free_value (GValue* value) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (value->data[0].v_pointer) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (value->data[0].v_pointer);
#line 10820 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_value_layout_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (src_value->data[0].v_pointer) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = checkerboard_layout_layout_row_ref (src_value->data[0].v_pointer);
#line 10830 "CheckerboardLayout.c"
	} else {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		dest_value->data[0].v_pointer = NULL;
#line 10834 "CheckerboardLayout.c"
	}
}


static gpointer checkerboard_layout_value_layout_row_peek_pointer (const GValue* value) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 10842 "CheckerboardLayout.c"
}


static gchar* checkerboard_layout_value_layout_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (collect_values[0].v_pointer) {
#line 10849 "CheckerboardLayout.c"
		CheckerboardLayoutLayoutRow* object;
		object = collect_values[0].v_pointer;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		if (object->parent_instance.g_class == NULL) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 10856 "CheckerboardLayout.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 10860 "CheckerboardLayout.c"
		}
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = checkerboard_layout_layout_row_ref (object);
#line 10864 "CheckerboardLayout.c"
	} else {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 10868 "CheckerboardLayout.c"
	}
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 10872 "CheckerboardLayout.c"
}


static gchar* checkerboard_layout_value_layout_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CheckerboardLayoutLayoutRow** object_p;
	object_p = collect_values[0].v_pointer;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!object_p) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 10883 "CheckerboardLayout.c"
	}
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (!value->data[0].v_pointer) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = NULL;
#line 10889 "CheckerboardLayout.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = value->data[0].v_pointer;
#line 10893 "CheckerboardLayout.c"
	} else {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		*object_p = checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
#line 10897 "CheckerboardLayout.c"
	}
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return NULL;
#line 10901 "CheckerboardLayout.c"
}


static GParamSpec* checkerboard_layout_param_spec_layout_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	CheckerboardLayoutParamSpecLayoutRow* spec;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (g_type_is_a (object_type, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return G_PARAM_SPEC (spec);
#line 10915 "CheckerboardLayout.c"
}


static gpointer checkerboard_layout_value_get_layout_row (const GValue* value) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW), NULL);
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return value->data[0].v_pointer;
#line 10924 "CheckerboardLayout.c"
}


static void checkerboard_layout_value_set_layout_row (GValue* value, gpointer v_object) {
	CheckerboardLayoutLayoutRow* old;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_ref (value->data[0].v_pointer);
#line 10944 "CheckerboardLayout.c"
	} else {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 10948 "CheckerboardLayout.c"
	}
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (old);
#line 10954 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_value_take_layout_row (GValue* value, gpointer v_object) {
	CheckerboardLayoutLayoutRow* old;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	old = value->data[0].v_pointer;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (v_object) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW));
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = v_object;
#line 10973 "CheckerboardLayout.c"
	} else {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		value->data[0].v_pointer = NULL;
#line 10977 "CheckerboardLayout.c"
	}
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (old) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		checkerboard_layout_layout_row_unref (old);
#line 10983 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_layout_row_class_init (CheckerboardLayoutLayoutRowClass * klass) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_layout_row_parent_class = g_type_class_peek_parent (klass);
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((CheckerboardLayoutLayoutRowClass *) klass)->finalize = checkerboard_layout_layout_row_finalize;
#line 10993 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_instance_init (CheckerboardLayoutLayoutRow * self) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->ref_count = 1;
#line 11000 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_finalize (CheckerboardLayoutLayoutRow* obj) {
	CheckerboardLayoutLayoutRow * self;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECKERBOARD_LAYOUT_TYPE_LAYOUT_ROW, CheckerboardLayoutLayoutRow);
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_destroy (self);
#line 786 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->items = (_vala_array_free (self->items, self->items_length1, (GDestroyNotify) g_object_unref), NULL);
#line 11012 "CheckerboardLayout.c"
}


static GType checkerboard_layout_layout_row_get_type (void) {
	static volatile gsize checkerboard_layout_layout_row_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_layout_layout_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { checkerboard_layout_value_layout_row_init, checkerboard_layout_value_layout_row_free_value, checkerboard_layout_value_layout_row_copy_value, checkerboard_layout_value_layout_row_peek_pointer, "p", checkerboard_layout_value_layout_row_collect_value, "p", checkerboard_layout_value_layout_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutLayoutRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_layout_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayoutLayoutRow), 0, (GInstanceInitFunc) checkerboard_layout_layout_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType checkerboard_layout_layout_row_type_id;
		checkerboard_layout_layout_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CheckerboardLayoutLayoutRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&checkerboard_layout_layout_row_type_id__volatile, checkerboard_layout_layout_row_type_id);
	}
	return checkerboard_layout_layout_row_type_id__volatile;
}


static gpointer checkerboard_layout_layout_row_ref (gpointer instance) {
	CheckerboardLayoutLayoutRow* self;
	self = instance;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_atomic_int_inc (&self->ref_count);
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	return instance;
#line 11037 "CheckerboardLayout.c"
}


static void checkerboard_layout_layout_row_unref (gpointer instance) {
	CheckerboardLayoutLayoutRow* self;
	self = instance;
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		CHECKERBOARD_LAYOUT_LAYOUT_ROW_GET_CLASS (self)->finalize (self);
#line 783 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 11050 "CheckerboardLayout.c"
	}
}


static void checkerboard_layout_class_init (CheckerboardLayoutClass * klass) {
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	checkerboard_layout_parent_class = g_type_class_peek_parent (klass);
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_type_class_add_private (klass, sizeof (CheckerboardLayoutPrivate));
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->map = checkerboard_layout_real_map;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->size_allocate = checkerboard_layout_real_size_allocate;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->draw = checkerboard_layout_real_draw;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->query_tooltip = checkerboard_layout_real_query_tooltip;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->focus_in_event = checkerboard_layout_real_focus_in_event;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	((GtkWidgetClass *) klass)->focus_out_event = checkerboard_layout_real_focus_out_event;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (klass)->finalize = checkerboard_layout_finalize;
#line 11074 "CheckerboardLayout.c"
}


static void checkerboard_layout_instance_init (CheckerboardLayout * self) {
	gchar* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv = CHECKERBOARD_LAYOUT_GET_PRIVATE (self);
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = g_strdup ("");
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->page_name = _tmp0_;
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = NULL;
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows_length1 = 0;
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->_item_rows_size_ = self->priv->item_rows_length1;
#line 798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp1_ = gee_hash_set_new (TYPE_CHECKERBOARD_ITEM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
#line 798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposed_items = _tmp1_;
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->hadjustment = NULL;
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->vadjustment = NULL;
#line 801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->message = NULL;
#line 806 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->visible_page, 0, sizeof (GdkRectangle));
#line 807 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->last_width = 0;
#line 808 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->columns = 0;
#line 809 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->rows = 0;
#line 810 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->drag_origin, 0, sizeof (GdkPoint));
#line 811 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->drag_endpoint, 0, sizeof (GdkPoint));
#line 812 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	memset (&self->priv->selection_band, 0, sizeof (GdkRectangle));
#line 813 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->scale = 0;
#line 814 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->flow_scheduled = FALSE;
#line 815 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->exposure_dirty = TRUE;
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->anchor = NULL;
#line 817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->cursor = NULL;
#line 818 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->in_center_on_anchor = FALSE;
#line 819 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->size_allocate_due_to_reflow = FALSE;
#line 820 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->is_in_view = FALSE;
#line 821 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->reflow_needed = FALSE;
#line 11135 "CheckerboardLayout.c"
}


static void checkerboard_layout_finalize (GObject* obj) {
	CheckerboardLayout * self;
	ViewCollection* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	ViewCollection* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	ViewCollection* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	ViewCollection* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	ViewCollection* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	ViewCollection* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	ViewCollection* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	ViewCollection* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	ViewCollection* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	GtkAdjustment* _tmp18_ = NULL;
	GtkAdjustment* _tmp21_ = NULL;
	GtkContainer* _tmp24_ = NULL;
	GtkContainer* _tmp25_ = NULL;
	ConfigFacade* _tmp29_ = NULL;
	ConfigFacade* _tmp30_ = NULL;
	guint _tmp31_ = 0U;
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_LAYOUT, CheckerboardLayout);
#line 852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp0_ = self->priv->view;
#line 852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("contents-altered", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
#line 852 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _checkerboard_layout_on_contents_altered_data_collection_contents_altered, self);
#line 853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp2_ = self->priv->view;
#line 853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp3_, NULL, FALSE);
#line 853 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _checkerboard_layout_on_items_altered_data_collection_items_altered, self);
#line 854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp4_ = self->priv->view;
#line 854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-state-changed", TYPE_VIEW_COLLECTION, &_tmp5_, NULL, FALSE);
#line 854 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _checkerboard_layout_on_items_state_changed_view_collection_items_state_changed, self);
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp6_ = self->priv->view;
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-visibility-changed", TYPE_VIEW_COLLECTION, &_tmp7_, NULL, FALSE);
#line 855 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _checkerboard_layout_on_items_visibility_changed_view_collection_items_visibility_changed, self);
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp8_ = self->priv->view;
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("ordering-changed", TYPE_DATA_COLLECTION, &_tmp9_, NULL, FALSE);
#line 856 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _checkerboard_layout_on_ordering_changed_data_collection_ordering_changed, self);
#line 857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp10_ = self->priv->view;
#line 857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("views-altered", TYPE_VIEW_COLLECTION, &_tmp11_, NULL, FALSE);
#line 857 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _checkerboard_layout_on_views_altered_view_collection_views_altered, self);
#line 858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp12_ = self->priv->view;
#line 858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("geometries-altered", TYPE_VIEW_COLLECTION, &_tmp13_, NULL, FALSE);
#line 858 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _checkerboard_layout_on_geometries_altered_view_collection_geometries_altered, self);
#line 859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp14_ = self->priv->view;
#line 859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-selected", TYPE_VIEW_COLLECTION, &_tmp15_, NULL, FALSE);
#line 859 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_selected, self);
#line 860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp16_ = self->priv->view;
#line 860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("items-unselected", TYPE_VIEW_COLLECTION, &_tmp17_, NULL, FALSE);
#line 860 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _checkerboard_layout_on_items_selection_changed_view_collection_items_unselected, self);
#line 862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp18_ = self->priv->hadjustment;
#line 862 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp18_ != NULL) {
#line 11226 "CheckerboardLayout.c"
		GtkAdjustment* _tmp19_ = NULL;
		guint _tmp20_ = 0U;
#line 863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp19_ = self->priv->hadjustment;
#line 863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp20_, NULL, FALSE);
#line 863 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (_tmp19_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp20_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
#line 11235 "CheckerboardLayout.c"
	}
#line 865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp21_ = self->priv->vadjustment;
#line 865 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp21_ != NULL) {
#line 11241 "CheckerboardLayout.c"
		GtkAdjustment* _tmp22_ = NULL;
		guint _tmp23_ = 0U;
#line 866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp22_ = self->priv->vadjustment;
#line 866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("value-changed", gtk_adjustment_get_type (), &_tmp23_, NULL, FALSE);
#line 866 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (_tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_shifted_gtk_adjustment_value_changed, self);
#line 11250 "CheckerboardLayout.c"
	}
#line 868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp24_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp25_ = _tmp24_;
#line 868 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	if (_tmp25_ != NULL) {
#line 11258 "CheckerboardLayout.c"
		GtkContainer* _tmp26_ = NULL;
		GtkContainer* _tmp27_ = NULL;
		guint _tmp28_ = 0U;
#line 869 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp26_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 869 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		_tmp27_ = _tmp26_;
#line 869 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp28_, NULL, FALSE);
#line 869 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp28_, 0, NULL, (GCallback) _checkerboard_layout_on_viewport_resized_gtk_widget_size_allocate, self);
#line 11270 "CheckerboardLayout.c"
	}
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp29_ = config_facade_get_instance ();
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_tmp30_ = _tmp29_;
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_parse_name ("colors-changed", CONFIG_TYPE_FACADE, &_tmp31_, NULL, FALSE);
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	g_signal_handlers_disconnect_matched (_tmp30_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp31_, 0, NULL, (GCallback) _checkerboard_layout_on_colors_changed_config_facade_colors_changed, self);
#line 871 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (_tmp30_);
#line 795 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_data_collection_unref0 (self->priv->view);
#line 796 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->page_name);
#line 797 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	self->priv->item_rows = (_vala_array_free (self->priv->item_rows, self->priv->item_rows_length1, (GDestroyNotify) checkerboard_layout_layout_row_unref), NULL);
#line 798 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->exposed_items);
#line 799 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->hadjustment);
#line 800 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->vadjustment);
#line 801 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_free0 (self->priv->message);
#line 816 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->anchor);
#line 817 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	_g_object_unref0 (self->priv->cursor);
#line 766 "/home/jens/Source/shotwell/src/CheckerboardLayout.vala"
	G_OBJECT_CLASS (checkerboard_layout_parent_class)->finalize (obj);
#line 11302 "CheckerboardLayout.c"
}


GType checkerboard_layout_get_type (void) {
	static volatile gsize checkerboard_layout_type_id__volatile = 0;
	if (g_once_init_enter (&checkerboard_layout_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckerboardLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardLayout), 0, (GInstanceInitFunc) checkerboard_layout_instance_init, NULL };
		GType checkerboard_layout_type_id;
		checkerboard_layout_type_id = g_type_register_static (gtk_drawing_area_get_type (), "CheckerboardLayout", &g_define_type_info, 0);
		g_once_init_leave (&checkerboard_layout_type_id__volatile, checkerboard_layout_type_id);
	}
	return checkerboard_layout_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



