/* PublishingInterfaces.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from PublishingInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>


#define SPIT_PUBLISHING_TYPE_PUBLISHER (spit_publishing_publisher_get_type ())
#define SPIT_PUBLISHING_PUBLISHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_PUBLISHER, SpitPublishingPublisher))
#define SPIT_PUBLISHING_IS_PUBLISHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_PUBLISHER))
#define SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_PUBLISHER, SpitPublishingPublisherIface))

typedef struct _SpitPublishingPublisher SpitPublishingPublisher;
typedef struct _SpitPublishingPublisherIface SpitPublishingPublisherIface;

#define SPIT_TYPE_PLUGGABLE (spit_pluggable_get_type ())
#define SPIT_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggable))
#define SPIT_IS_PLUGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_PLUGGABLE))
#define SPIT_PLUGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_PLUGGABLE, SpitPluggableIface))

typedef struct _SpitPluggable SpitPluggable;
typedef struct _SpitPluggableIface SpitPluggableIface;

#define SPIT_TYPE_PLUGGABLE_INFO (spit_pluggable_info_get_type ())
typedef struct _SpitPluggableInfo SpitPluggableInfo;

#define SPIT_PUBLISHING_TYPE_SERVICE (spit_publishing_service_get_type ())
#define SPIT_PUBLISHING_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_SERVICE, SpitPublishingService))
#define SPIT_PUBLISHING_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_SERVICE))
#define SPIT_PUBLISHING_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_SERVICE, SpitPublishingServiceIface))

typedef struct _SpitPublishingService SpitPublishingService;
typedef struct _SpitPublishingServiceIface SpitPublishingServiceIface;

#define SPIT_TYPE_HOST_INTERFACE (spit_host_interface_get_type ())
#define SPIT_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterface))
#define SPIT_IS_HOST_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_TYPE_HOST_INTERFACE))
#define SPIT_HOST_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_TYPE_HOST_INTERFACE, SpitHostInterfaceIface))

typedef struct _SpitHostInterface SpitHostInterface;
typedef struct _SpitHostInterfaceIface SpitHostInterfaceIface;

#define SPIT_PUBLISHING_TYPE_PLUGIN_HOST (spit_publishing_plugin_host_get_type ())
#define SPIT_PUBLISHING_PLUGIN_HOST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_PLUGIN_HOST, SpitPublishingPluginHost))
#define SPIT_PUBLISHING_IS_PLUGIN_HOST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_PLUGIN_HOST))
#define SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_PLUGIN_HOST, SpitPublishingPluginHostIface))

typedef struct _SpitPublishingPluginHost SpitPublishingPluginHost;
typedef struct _SpitPublishingPluginHostIface SpitPublishingPluginHostIface;

#define SPIT_PUBLISHING_TYPE_DIALOG_PANE (spit_publishing_dialog_pane_get_type ())
#define SPIT_PUBLISHING_DIALOG_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_DIALOG_PANE, SpitPublishingDialogPane))
#define SPIT_PUBLISHING_IS_DIALOG_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_DIALOG_PANE))
#define SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_DIALOG_PANE, SpitPublishingDialogPaneIface))

typedef struct _SpitPublishingDialogPane SpitPublishingDialogPane;
typedef struct _SpitPublishingDialogPaneIface SpitPublishingDialogPaneIface;

#define SPIT_PUBLISHING_DIALOG_PANE_TYPE_GEOMETRY_OPTIONS (spit_publishing_dialog_pane_geometry_options_get_type ())

#define SPIT_PUBLISHING_PLUGIN_HOST_TYPE_BUTTON_MODE (spit_publishing_plugin_host_button_mode_get_type ())

#define SPIT_PUBLISHING_TYPE_PUBLISHABLE (spit_publishing_publishable_get_type ())
#define SPIT_PUBLISHING_PUBLISHABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPIT_PUBLISHING_TYPE_PUBLISHABLE, SpitPublishingPublishable))
#define SPIT_PUBLISHING_IS_PUBLISHABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPIT_PUBLISHING_TYPE_PUBLISHABLE))
#define SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), SPIT_PUBLISHING_TYPE_PUBLISHABLE, SpitPublishingPublishableIface))

typedef struct _SpitPublishingPublishable SpitPublishingPublishable;
typedef struct _SpitPublishingPublishableIface SpitPublishingPublishableIface;

#define SPIT_PUBLISHING_PUBLISHER_TYPE_MEDIA_TYPE (spit_publishing_publisher_media_type_get_type ())

/**
 * Defines different kinds of errors that can occur during publishing.
 */
typedef enum  {
	SPIT_PUBLISHING_PUBLISHING_ERROR_NO_ANSWER,
	SPIT_PUBLISHING_PUBLISHING_ERROR_COMMUNICATION_FAILED,
	SPIT_PUBLISHING_PUBLISHING_ERROR_PROTOCOL_ERROR,
	SPIT_PUBLISHING_PUBLISHING_ERROR_SERVICE_ERROR,
	SPIT_PUBLISHING_PUBLISHING_ERROR_MALFORMED_RESPONSE,
	SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR,
	SPIT_PUBLISHING_PUBLISHING_ERROR_EXPIRED_SESSION
} SpitPublishingPublishingError;
#define SPIT_PUBLISHING_PUBLISHING_ERROR spit_publishing_publishing_error_quark ()
struct _SpitPluggableInfo {
	gchar* version;
	gchar* brief_description;
	gchar* authors;
	gchar* copyright;
	gchar* license;
	gboolean is_license_wordwrapped;
	gchar* website_url;
	gchar* website_name;
	gchar* translators;
	GdkPixbuf** icons;
	gint icons_length1;
};

struct _SpitPluggableIface {
	GTypeInterface parent_iface;
	gint (*get_pluggable_interface) (SpitPluggable* self, gint min_host_interface, gint max_host_interface);
	const gchar* (*get_id) (SpitPluggable* self);
	const gchar* (*get_pluggable_name) (SpitPluggable* self);
	void (*get_info) (SpitPluggable* self, SpitPluggableInfo* info);
	void (*activation) (SpitPluggable* self, gboolean enabled);
	void (*reserved0) (SpitPluggable* self);
	void (*reserved1) (SpitPluggable* self);
	void (*reserved2) (SpitPluggable* self);
	void (*reserved3) (SpitPluggable* self);
	void (*reserved4) (SpitPluggable* self);
	void (*reserved5) (SpitPluggable* self);
	void (*reserved6) (SpitPluggable* self);
	void (*reserved7) (SpitPluggable* self);
};

struct _SpitHostInterfaceIface {
	GTypeInterface parent_iface;
	GFile* (*get_module_file) (SpitHostInterface* self);
	gboolean (*get_config_bool) (SpitHostInterface* self, const gchar* key, gboolean def);
	void (*set_config_bool) (SpitHostInterface* self, const gchar* key, gboolean val);
	gint (*get_config_int) (SpitHostInterface* self, const gchar* key, gint def);
	void (*set_config_int) (SpitHostInterface* self, const gchar* key, gint val);
	gchar* (*get_config_string) (SpitHostInterface* self, const gchar* key, const gchar* def);
	void (*set_config_string) (SpitHostInterface* self, const gchar* key, const gchar* val);
	gdouble (*get_config_double) (SpitHostInterface* self, const gchar* key, gdouble def);
	void (*set_config_double) (SpitHostInterface* self, const gchar* key, gdouble val);
	void (*unset_config_key) (SpitHostInterface* self, const gchar* key);
	void (*reserved0) (SpitHostInterface* self);
	void (*reserved1) (SpitHostInterface* self);
	void (*reserved2) (SpitHostInterface* self);
	void (*reserved3) (SpitHostInterface* self);
	void (*reserved4) (SpitHostInterface* self);
	void (*reserved5) (SpitHostInterface* self);
	void (*reserved6) (SpitHostInterface* self);
	void (*reserved7) (SpitHostInterface* self);
};

typedef enum  {
	SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_NONE = 0,
	SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE = 1 << 0,
	SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE = 1 << 1,
	SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE = 1 << 2
} SpitPublishingDialogPaneGeometryOptions;

struct _SpitPublishingDialogPaneIface {
	GTypeInterface parent_iface;
	GtkWidget* (*get_widget) (SpitPublishingDialogPane* self);
	SpitPublishingDialogPaneGeometryOptions (*get_preferred_geometry) (SpitPublishingDialogPane* self);
	void (*on_pane_installed) (SpitPublishingDialogPane* self);
	void (*on_pane_uninstalled) (SpitPublishingDialogPane* self);
	void (*reserved0) (SpitPublishingDialogPane* self);
	void (*reserved1) (SpitPublishingDialogPane* self);
	void (*reserved2) (SpitPublishingDialogPane* self);
	void (*reserved3) (SpitPublishingDialogPane* self);
	void (*reserved4) (SpitPublishingDialogPane* self);
	void (*reserved5) (SpitPublishingDialogPane* self);
	void (*reserved6) (SpitPublishingDialogPane* self);
	void (*reserved7) (SpitPublishingDialogPane* self);
};

typedef enum  {
	SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CLOSE = 0,
	SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL = 1
} SpitPublishingPluginHostButtonMode;

typedef void (*SpitPublishingLoginCallback) (void* user_data);
typedef enum  {
	SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE = 0,
	SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO = 1 << 0,
	SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO = 1 << 1
} SpitPublishingPublisherMediaType;

struct _SpitPublishingPublishableIface {
	GTypeInterface parent_iface;
	GFile* (*get_serialized_file) (SpitPublishingPublishable* self);
	gchar* (*get_publishing_name) (SpitPublishingPublishable* self);
	gchar* (*get_param_string) (SpitPublishingPublishable* self, const gchar* name);
	gchar** (*get_publishing_keywords) (SpitPublishingPublishable* self, int* result_length1);
	SpitPublishingPublisherMediaType (*get_media_type) (SpitPublishingPublishable* self);
	GDateTime* (*get_exposure_date_time) (SpitPublishingPublishable* self);
	void (*reserved0) (SpitPublishingPublishable* self);
	void (*reserved1) (SpitPublishingPublishable* self);
	void (*reserved2) (SpitPublishingPublishable* self);
	void (*reserved3) (SpitPublishingPublishable* self);
	void (*reserved4) (SpitPublishingPublishable* self);
	void (*reserved5) (SpitPublishingPublishable* self);
	void (*reserved6) (SpitPublishingPublishable* self);
	void (*reserved7) (SpitPublishingPublishable* self);
};

typedef void (*SpitPublishingProgressCallback) (gint file_number, gdouble fraction_complete, void* user_data);
struct _SpitPublishingPluginHostIface {
	GTypeInterface parent_iface;
	void (*post_error) (SpitPublishingPluginHost* self, GError* err);
	void (*stop_publishing) (SpitPublishingPluginHost* self);
	SpitPublishingPublisher* (*get_publisher) (SpitPublishingPluginHost* self);
	void (*install_dialog_pane) (SpitPublishingPluginHost* self, SpitPublishingDialogPane* pane, SpitPublishingPluginHostButtonMode mode);
	void (*install_static_message_pane) (SpitPublishingPluginHost* self, const gchar* message, SpitPublishingPluginHostButtonMode mode);
	void (*install_pango_message_pane) (SpitPublishingPluginHost* self, const gchar* markup, SpitPublishingPluginHostButtonMode mode);
	void (*install_success_pane) (SpitPublishingPluginHost* self);
	void (*install_account_fetch_wait_pane) (SpitPublishingPluginHost* self);
	void (*install_login_wait_pane) (SpitPublishingPluginHost* self);
	void (*install_welcome_pane) (SpitPublishingPluginHost* self, const gchar* welcome_message, SpitPublishingLoginCallback on_login_clicked, void* on_login_clicked_target);
	void (*set_service_locked) (SpitPublishingPluginHost* self, gboolean is_locked);
	void (*set_dialog_default_widget) (SpitPublishingPluginHost* self, GtkWidget* widget);
	SpitPublishingPublishable** (*get_publishables) (SpitPublishingPluginHost* self, int* result_length1);
	SpitPublishingProgressCallback (*serialize_publishables) (SpitPublishingPluginHost* self, gint content_major_axis, gboolean strip_metadata, void** result_target, GDestroyNotify* result_target_destroy_notify);
	SpitPublishingPublisherMediaType (*get_publishable_media_type) (SpitPublishingPluginHost* self);
	void (*reserved0) (SpitPublishingPluginHost* self);
	void (*reserved1) (SpitPublishingPluginHost* self);
	void (*reserved2) (SpitPublishingPluginHost* self);
	void (*reserved3) (SpitPublishingPluginHost* self);
	void (*reserved4) (SpitPublishingPluginHost* self);
	void (*reserved5) (SpitPublishingPluginHost* self);
	void (*reserved6) (SpitPublishingPluginHost* self);
	void (*reserved7) (SpitPublishingPluginHost* self);
};

struct _SpitPublishingServiceIface {
	GTypeInterface parent_iface;
	SpitPublishingPublisher* (*create_publisher) (SpitPublishingService* self, SpitPublishingPluginHost* host);
	SpitPublishingPublisherMediaType (*get_supported_media) (SpitPublishingService* self);
	void (*reserved0) (SpitPublishingService* self);
	void (*reserved1) (SpitPublishingService* self);
	void (*reserved2) (SpitPublishingService* self);
	void (*reserved3) (SpitPublishingService* self);
	void (*reserved4) (SpitPublishingService* self);
	void (*reserved5) (SpitPublishingService* self);
	void (*reserved6) (SpitPublishingService* self);
	void (*reserved7) (SpitPublishingService* self);
};

struct _SpitPublishingPublisherIface {
	GTypeInterface parent_iface;
	SpitPublishingService* (*get_service) (SpitPublishingPublisher* self);
	void (*start) (SpitPublishingPublisher* self);
	gboolean (*is_running) (SpitPublishingPublisher* self);
	void (*stop) (SpitPublishingPublisher* self);
	void (*reserved0) (SpitPublishingPublisher* self);
	void (*reserved1) (SpitPublishingPublisher* self);
	void (*reserved2) (SpitPublishingPublisher* self);
	void (*reserved3) (SpitPublishingPublisher* self);
	void (*reserved4) (SpitPublishingPublisher* self);
	void (*reserved5) (SpitPublishingPublisher* self);
	void (*reserved6) (SpitPublishingPublisher* self);
	void (*reserved7) (SpitPublishingPublisher* self);
};



#define SPIT_PUBLISHING_CURRENT_INTERFACE 0
GQuark spit_publishing_publishing_error_quark (void);
GType spit_pluggable_info_get_type (void) G_GNUC_CONST;
SpitPluggableInfo* spit_pluggable_info_dup (const SpitPluggableInfo* self);
void spit_pluggable_info_free (SpitPluggableInfo* self);
void spit_pluggable_info_copy (const SpitPluggableInfo* self, SpitPluggableInfo* dest);
void spit_pluggable_info_destroy (SpitPluggableInfo* self);
GType spit_pluggable_get_type (void) G_GNUC_CONST;
GType spit_host_interface_get_type (void) G_GNUC_CONST;
GType spit_publishing_dialog_pane_geometry_options_get_type (void) G_GNUC_CONST;
GType spit_publishing_dialog_pane_get_type (void) G_GNUC_CONST;
GType spit_publishing_plugin_host_button_mode_get_type (void) G_GNUC_CONST;
GType spit_publishing_publisher_media_type_get_type (void) G_GNUC_CONST;
GType spit_publishing_publishable_get_type (void) G_GNUC_CONST;
GType spit_publishing_plugin_host_get_type (void) G_GNUC_CONST;
GType spit_publishing_service_get_type (void) G_GNUC_CONST;
GType spit_publishing_publisher_get_type (void) G_GNUC_CONST;
SpitPublishingService* spit_publishing_publisher_get_service (SpitPublishingPublisher* self);
void spit_publishing_publisher_start (SpitPublishingPublisher* self);
gboolean spit_publishing_publisher_is_running (SpitPublishingPublisher* self);
void spit_publishing_publisher_stop (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved0 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved0 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved1 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved1 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved2 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved2 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved3 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved3 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved4 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved4 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved5 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved5 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved6 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved6 (SpitPublishingPublisher* self);
void spit_publishing_publisher_reserved7 (SpitPublishingPublisher* self);
static void spit_publishing_publisher_real_reserved7 (SpitPublishingPublisher* self);
GtkWidget* spit_publishing_dialog_pane_get_widget (SpitPublishingDialogPane* self);
SpitPublishingDialogPaneGeometryOptions spit_publishing_dialog_pane_get_preferred_geometry (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_on_pane_installed (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_on_pane_uninstalled (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved0 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved0 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved1 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved1 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved2 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved2 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved3 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved3 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved4 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved4 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved5 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved5 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved6 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved6 (SpitPublishingDialogPane* self);
void spit_publishing_dialog_pane_reserved7 (SpitPublishingDialogPane* self);
static void spit_publishing_dialog_pane_real_reserved7 (SpitPublishingDialogPane* self);
void spit_publishing_plugin_host_post_error (SpitPublishingPluginHost* self, GError* err);
void spit_publishing_plugin_host_stop_publishing (SpitPublishingPluginHost* self);
SpitPublishingPublisher* spit_publishing_plugin_host_get_publisher (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_install_dialog_pane (SpitPublishingPluginHost* self, SpitPublishingDialogPane* pane, SpitPublishingPluginHostButtonMode mode);
void spit_publishing_plugin_host_install_static_message_pane (SpitPublishingPluginHost* self, const gchar* message, SpitPublishingPluginHostButtonMode mode);
void spit_publishing_plugin_host_install_pango_message_pane (SpitPublishingPluginHost* self, const gchar* markup, SpitPublishingPluginHostButtonMode mode);
void spit_publishing_plugin_host_install_success_pane (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_install_account_fetch_wait_pane (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_install_login_wait_pane (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_install_welcome_pane (SpitPublishingPluginHost* self, const gchar* welcome_message, SpitPublishingLoginCallback on_login_clicked, void* on_login_clicked_target);
void spit_publishing_plugin_host_set_service_locked (SpitPublishingPluginHost* self, gboolean is_locked);
void spit_publishing_plugin_host_set_dialog_default_widget (SpitPublishingPluginHost* self, GtkWidget* widget);
SpitPublishingPublishable** spit_publishing_plugin_host_get_publishables (SpitPublishingPluginHost* self, int* result_length1);
SpitPublishingProgressCallback spit_publishing_plugin_host_serialize_publishables (SpitPublishingPluginHost* self, gint content_major_axis, gboolean strip_metadata, void** result_target, GDestroyNotify* result_target_destroy_notify);
SpitPublishingPublisherMediaType spit_publishing_plugin_host_get_publishable_media_type (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved0 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved0 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved1 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved1 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved2 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved2 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved3 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved3 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved4 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved4 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved5 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved5 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved6 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved6 (SpitPublishingPluginHost* self);
void spit_publishing_plugin_host_reserved7 (SpitPublishingPluginHost* self);
static void spit_publishing_plugin_host_real_reserved7 (SpitPublishingPluginHost* self);
GFile* spit_publishing_publishable_get_serialized_file (SpitPublishingPublishable* self);
gchar* spit_publishing_publishable_get_publishing_name (SpitPublishingPublishable* self);
gchar* spit_publishing_publishable_get_param_string (SpitPublishingPublishable* self, const gchar* name);
gchar** spit_publishing_publishable_get_publishing_keywords (SpitPublishingPublishable* self, int* result_length1);
SpitPublishingPublisherMediaType spit_publishing_publishable_get_media_type (SpitPublishingPublishable* self);
GDateTime* spit_publishing_publishable_get_exposure_date_time (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved0 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved0 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved1 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved1 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved2 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved2 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved3 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved3 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved4 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved4 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved5 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved5 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved6 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved6 (SpitPublishingPublishable* self);
void spit_publishing_publishable_reserved7 (SpitPublishingPublishable* self);
static void spit_publishing_publishable_real_reserved7 (SpitPublishingPublishable* self);
#define SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_BASENAME "basename"
#define SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_TITLE "title"
#define SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_COMMENT "comment"
#define SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_EVENTCOMMENT "eventcomment"
SpitPublishingPublisher* spit_publishing_service_create_publisher (SpitPublishingService* self, SpitPublishingPluginHost* host);
SpitPublishingPublisherMediaType spit_publishing_service_get_supported_media (SpitPublishingService* self);
void spit_publishing_service_reserved0 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved0 (SpitPublishingService* self);
void spit_publishing_service_reserved1 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved1 (SpitPublishingService* self);
void spit_publishing_service_reserved2 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved2 (SpitPublishingService* self);
void spit_publishing_service_reserved3 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved3 (SpitPublishingService* self);
void spit_publishing_service_reserved4 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved4 (SpitPublishingService* self);
void spit_publishing_service_reserved5 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved5 (SpitPublishingService* self);
void spit_publishing_service_reserved6 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved6 (SpitPublishingService* self);
void spit_publishing_service_reserved7 (SpitPublishingService* self);
static void spit_publishing_service_real_reserved7 (SpitPublishingService* self);


GQuark spit_publishing_publishing_error_quark (void) {
	return g_quark_from_static_string ("spit_publishing_publishing_error-quark");
}


/**
     * Describes the kinds of media a publishing service supports.
     *
     * Values can be masked together, for example: {{{(MediaType.PHOTO | MediaType.VIDEO)}}}
     * indicates that a publishing service supports the upload of both photos and videos.
     */
GType spit_publishing_publisher_media_type_get_type (void) {
	static volatile gsize spit_publishing_publisher_media_type_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_publisher_media_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE", "none"}, {SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO", "photo"}, {SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO, "SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO", "video"}, {0, NULL, NULL}};
		GType spit_publishing_publisher_media_type_type_id;
		spit_publishing_publisher_media_type_type_id = g_enum_register_static ("SpitPublishingPublisherMediaType", values);
		g_once_init_leave (&spit_publishing_publisher_media_type_type_id__volatile, spit_publishing_publisher_media_type_type_id);
	}
	return spit_publishing_publisher_media_type_type_id__volatile;
}


/**
     * Returns a {@link Service} object describing the service to which this connects.
     */
SpitPublishingService* spit_publishing_publisher_get_service (SpitPublishingPublisher* self) {
#line 114 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self), NULL);
#line 114 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->get_service (self);
#line 431 "PublishingInterfaces.c"
}


/**
     * Makes this publisher enter the running state and endows it with exclusive access
     * to the shared services provided by the {@link PluginHost}. Through the host’s interface,
     * this publisher can install user interface panes and query configuration information.
     * Only running services should perform network operations.
     */
void spit_publishing_publisher_start (SpitPublishingPublisher* self) {
#line 122 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 122 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->start (self);
#line 446 "PublishingInterfaces.c"
}


/**
     * Returns true if this publisher is in the running state; false otherwise.
     */
gboolean spit_publishing_publisher_is_running (SpitPublishingPublisher* self) {
#line 127 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self), FALSE);
#line 127 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->is_running (self);
#line 458 "PublishingInterfaces.c"
}


/**
     * Causes this publisher to enter a non-running state. This publisher should stop all
     * network operations and cease use of the shared services provided by the {@link PluginHost}.
     */
void spit_publishing_publisher_stop (SpitPublishingPublisher* self) {
#line 133 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 133 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->stop (self);
#line 471 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved0 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved0 (SpitPublishingPublisher* self) {
#line 138 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 138 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved0 (self);
#line 484 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved1 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved1 (SpitPublishingPublisher* self) {
#line 139 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 139 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved1 (self);
#line 497 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved2 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved2 (SpitPublishingPublisher* self) {
#line 140 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 140 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved2 (self);
#line 510 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved3 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved3 (SpitPublishingPublisher* self) {
#line 141 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 141 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved3 (self);
#line 523 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved4 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved4 (SpitPublishingPublisher* self) {
#line 142 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 142 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved4 (self);
#line 536 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved5 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved5 (SpitPublishingPublisher* self) {
#line 143 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 143 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved5 (self);
#line 549 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved6 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved6 (SpitPublishingPublisher* self) {
#line 144 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 144 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved6 (self);
#line 562 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_real_reserved7 (SpitPublishingPublisher* self) {
}


void spit_publishing_publisher_reserved7 (SpitPublishingPublisher* self) {
#line 145 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHER (self));
#line 145 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHER_GET_INTERFACE (self)->reserved7 (self);
#line 575 "PublishingInterfaces.c"
}


static void spit_publishing_publisher_base_init (SpitPublishingPublisherIface * iface) {
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_publisher_real_reserved0;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_publisher_real_reserved1;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_publisher_real_reserved2;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_publisher_real_reserved3;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_publisher_real_reserved4;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_publisher_real_reserved5;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_publisher_real_reserved6;
#line 98 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_publisher_real_reserved7;
#line 602 "PublishingInterfaces.c"
	}
}


/** 
 * Represents a connection to a publishing service.
 *
 * Developers of publishing plugins provide a class that implements this interface. At
 * any given time, only one Publisher can be running. When a publisher is running, it is
 * allowed to access the network and has exclusive use of the shared user-interface and
 * configuration services provided by the {@link PluginHost}. Publishers are created in
 * a non-running state and do not begin running until start( ) is invoked. Publishers
 * run until stop( ) is invoked.
 */
GType spit_publishing_publisher_get_type (void) {
	static volatile gsize spit_publishing_publisher_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_publisher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPublisherIface), (GBaseInitFunc) spit_publishing_publisher_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_publisher_type_id;
		spit_publishing_publisher_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPublisher", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_publisher_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_publishing_publisher_type_id__volatile, spit_publishing_publisher_type_id);
	}
	return spit_publishing_publisher_type_id__volatile;
}


/**
     * Describes how the on-screen publishing dialog box should look and behave when an associated
     * pane is installed in the on-screen publishing dialog box.
     */
GType spit_publishing_dialog_pane_geometry_options_get_type (void) {
	static volatile gsize spit_publishing_dialog_pane_geometry_options_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_dialog_pane_geometry_options_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_NONE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_NONE", "none"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_EXTENDED_SIZE", "extended-size"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_RESIZABLE", "resizable"}, {SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE, "SPIT_PUBLISHING_DIALOG_PANE_GEOMETRY_OPTIONS_COLOSSAL_SIZE", "colossal-size"}, {0, NULL, NULL}};
		GType spit_publishing_dialog_pane_geometry_options_type_id;
		spit_publishing_dialog_pane_geometry_options_type_id = g_enum_register_static ("SpitPublishingDialogPaneGeometryOptions", values);
		g_once_init_leave (&spit_publishing_dialog_pane_geometry_options_type_id__volatile, spit_publishing_dialog_pane_geometry_options_type_id);
	}
	return spit_publishing_dialog_pane_geometry_options_type_id__volatile;
}


/**
     * Returns the Gtk.Widget that is this pane's on-screen representation.
     */
GtkWidget* spit_publishing_dialog_pane_get_widget (SpitPublishingDialogPane* self) {
#line 190 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self), NULL);
#line 190 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->get_widget (self);
#line 654 "PublishingInterfaces.c"
}


/**
     * Returns a {@link GeometryOptions} bitfield describing how the on-screen publishing dialog
     * box should look and behave when this pane is installed.
     */
SpitPublishingDialogPaneGeometryOptions spit_publishing_dialog_pane_get_preferred_geometry (SpitPublishingDialogPane* self) {
#line 196 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self), 0);
#line 196 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->get_preferred_geometry (self);
#line 667 "PublishingInterfaces.c"
}


/**
     * Invoked automatically by Shotwell when this pane has been installed into the on-screen
     * publishing dialog box and become visible to the user.
     */
void spit_publishing_dialog_pane_on_pane_installed (SpitPublishingDialogPane* self) {
#line 202 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 202 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->on_pane_installed (self);
#line 680 "PublishingInterfaces.c"
}


/**
     * Invoked automatically by Shotwell when this pane has been removed from the on-screen
     * publishing dialog box and is no longer visible to the user.
     */
void spit_publishing_dialog_pane_on_pane_uninstalled (SpitPublishingDialogPane* self) {
#line 208 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 208 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->on_pane_uninstalled (self);
#line 693 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved0 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved0 (SpitPublishingDialogPane* self) {
#line 213 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 213 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved0 (self);
#line 706 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved1 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved1 (SpitPublishingDialogPane* self) {
#line 214 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 214 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved1 (self);
#line 719 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved2 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved2 (SpitPublishingDialogPane* self) {
#line 215 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 215 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved2 (self);
#line 732 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved3 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved3 (SpitPublishingDialogPane* self) {
#line 216 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 216 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved3 (self);
#line 745 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved4 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved4 (SpitPublishingDialogPane* self) {
#line 217 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 217 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved4 (self);
#line 758 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved5 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved5 (SpitPublishingDialogPane* self) {
#line 218 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 218 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved5 (self);
#line 771 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved6 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved6 (SpitPublishingDialogPane* self) {
#line 219 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 219 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved6 (self);
#line 784 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_real_reserved7 (SpitPublishingDialogPane* self) {
}


void spit_publishing_dialog_pane_reserved7 (SpitPublishingDialogPane* self) {
#line 220 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_DIALOG_PANE (self));
#line 220 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_DIALOG_PANE_GET_INTERFACE (self)->reserved7 (self);
#line 797 "PublishingInterfaces.c"
}


static void spit_publishing_dialog_pane_base_init (SpitPublishingDialogPaneIface * iface) {
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_dialog_pane_real_reserved0;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_dialog_pane_real_reserved1;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_dialog_pane_real_reserved2;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_dialog_pane_real_reserved3;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_dialog_pane_real_reserved4;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_dialog_pane_real_reserved5;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_dialog_pane_real_reserved6;
#line 153 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_dialog_pane_real_reserved7;
#line 824 "PublishingInterfaces.c"
	}
}


/**
 * Encapsulates a pane that can be installed in the on-screen publishing dialog box to
 * communicate status to and to get information from the user.
 *
 */
GType spit_publishing_dialog_pane_get_type (void) {
	static volatile gsize spit_publishing_dialog_pane_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_dialog_pane_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingDialogPaneIface), (GBaseInitFunc) spit_publishing_dialog_pane_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_dialog_pane_type_id;
		spit_publishing_dialog_pane_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingDialogPane", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_dialog_pane_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_publishing_dialog_pane_type_id__volatile, spit_publishing_dialog_pane_type_id);
	}
	return spit_publishing_dialog_pane_type_id__volatile;
}


/**
     * Specifies the label text on the push button control that appears in the
     * lower-right-hand corner of the on-screen publishing dialog box.
     */
GType spit_publishing_plugin_host_button_mode_get_type (void) {
	static volatile gsize spit_publishing_plugin_host_button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_plugin_host_button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CLOSE, "SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CLOSE", "close"}, {SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL, "SPIT_PUBLISHING_PLUGIN_HOST_BUTTON_MODE_CANCEL", "cancel"}, {0, NULL, NULL}};
		GType spit_publishing_plugin_host_button_mode_type_id;
		spit_publishing_plugin_host_button_mode_type_id = g_enum_register_static ("SpitPublishingPluginHostButtonMode", values);
		g_once_init_leave (&spit_publishing_plugin_host_button_mode_type_id__volatile, spit_publishing_plugin_host_button_mode_type_id);
	}
	return spit_publishing_plugin_host_button_mode_type_id__volatile;
}


/**
     * Notifies the user that an unrecoverable publishing error has occurred and halts
     * the publishing process.
     *
     * @param err An error object that describes the kind of error that occurred.
     */
void spit_publishing_plugin_host_post_error (SpitPublishingPluginHost* self, GError* err) {
#line 270 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 270 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->post_error (self, err);
#line 874 "PublishingInterfaces.c"
}


/**
     * Halts the publishing process.
     *
     * Calling this method stops all network activity and hides the on-screen publishing
     * dialog box.
     */
void spit_publishing_plugin_host_stop_publishing (SpitPublishingPluginHost* self) {
#line 278 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 278 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->stop_publishing (self);
#line 889 "PublishingInterfaces.c"
}


/**
     * Returns a reference to the {@link Publisher} object that this is currently hosting.
     */
SpitPublishingPublisher* spit_publishing_plugin_host_get_publisher (SpitPublishingPluginHost* self) {
#line 283 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
#line 283 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->get_publisher (self);
#line 901 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane in the on-screen publishing dialog box, making the pane visible
     * and allowing it to interact with the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param pane the pane to install
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void spit_publishing_plugin_host_install_dialog_pane (SpitPublishingPluginHost* self, SpitPublishingDialogPane* pane, SpitPublishingPluginHostButtonMode mode) {
#line 303 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 303 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_dialog_pane (self, pane, mode);
#line 928 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane in the on-screen publishing dialog box that contains
     * static text.
     *
     * The text appears centered in the publishing dialog box and is drawn in
     * the system font. This is a convenience method only; similar results could be
     * achieved by manually constructing a Gtk.Label widget, wrapping it inside a
     * {@link DialogPane}, and installing it manually with a call to
     * install_dialog_pane( ). To provide visual consistency across publishing services,
     * however, always use this convenience method instead of constructing label panes when
     * you need to display static text to the user.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param message the text to show in the pane
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void spit_publishing_plugin_host_install_static_message_pane (SpitPublishingPluginHost* self, const gchar* message, SpitPublishingPluginHostButtonMode mode) {
#line 332 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 332 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_static_message_pane (self, message, mode);
#line 963 "PublishingInterfaces.c"
}


/**
     * Works just like {@link install_static_message_pane} but allows markup to contain
     * Pango text formatting tags as well as unstyled text.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     * 
     * @param markup the text to show in the pane, marked up with Pango formatting tags.
     *
     * @param mode allows you to set the text displayed on the close/cancel button in the
     * lower-right-hand corner of the on-screen publishing dialog box when pane is installed.
     * If mode is ButtonMode.CLOSE, the button will have the title "Close." If mode is
     * ButtonMode.CANCEL, the button will be titled "Cancel." You should set mode depending on
     * whether a cancellable action is in progress. For example, if your publisher is in the
     * middle of uploading 3 of 8 videos, then mode should be ButtonMode.CANCEL. However, if
     * the publishing operation has completed and the success pane is displayed, then mode
     * should be ButtonMode.CLOSE, because all cancellable publishing actions have already
     * occurred.
     */
void spit_publishing_plugin_host_install_pango_message_pane (SpitPublishingPluginHost* self, const gchar* markup, SpitPublishingPluginHostButtonMode mode) {
#line 353 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 353 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_pango_message_pane (self, markup, mode);
#line 990 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane in the on-screen publishing dialog box notifying the user
     * that his or her publishing operation completed successfully.
     * 
     * The text displayed depends on the type of media the current publishing service
     * supports. To provide visual consistency across publishing services and to allow
     * Shotwell to handle internationalization, always use this convenience method; don’t
     * contruct and install success panes manually.
     *
     * If an error has posted, the {@link PluginHost} will not honor
     * this request.
     */
void spit_publishing_plugin_host_install_success_pane (SpitPublishingPluginHost* self) {
#line 368 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 368 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_success_pane (self);
#line 1011 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane displaying the static text “Fetching account information...”
     * in the on-screen publishing dialog box, making it visible to the user.
     *
     * This is a convenience method only; similar results could be achieved by calling
     * {@link install_static_message_pane} with an appropriate text argument. To provide
     * visual consistency across publishing services and to allow Shotwell to handle
     * internationalization, however, you should always use this convenience method whenever
     * you need to tell the user that you’re querying account information over the network.
     * Queries such as this are almost always performed immediately after the user has logged
     * in to the remote service.
     * 
     * If an error has posted, the {@link PluginHost} will not honor this request.
     */
void spit_publishing_plugin_host_install_account_fetch_wait_pane (SpitPublishingPluginHost* self) {
#line 384 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 384 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_account_fetch_wait_pane (self);
#line 1034 "PublishingInterfaces.c"
}


/**
     * Works just like {@link install_account_fetch_wait_pane} but displays the static text
     * “Logging in...“
     * 
     * As with {@link install_account_fetch_wait_pane}, this is a convenience method, but
     * you should you use it provide to visual consistency and to let Shotwell handle
     * internationalization. See the description of {@link install_account_fetch_wait_pane}
     * for more information.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     */
void spit_publishing_plugin_host_install_login_wait_pane (SpitPublishingPluginHost* self) {
#line 398 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 398 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_login_wait_pane (self);
#line 1054 "PublishingInterfaces.c"
}


/**
     * Attempts to install a pane displaying the text 'welcome_message' above a push
     * button labeled “Login” in the on-screen publishing dialog box, making it visible to the
     * user.
     *
     * When the user clicks the “Login” button, you’ll be notified of the user’s action through
     * the callback 'on_login_clicked'. Every Publisher should provide a welcome pane to
     * introduce the service and explain service-specific features or restrictions. To provide
     * visual consistency across publishing services and to allow Shotwell to handle
     * internationalization, always use this convenience method; don’t contruct and install
     * welcome panes manually.
     *
     * If an error has posted, the {@link PluginHost} will not honor this request.
     *
     * @param welcome_message the text to be displayed above a push button labeled “Login”
     * in the on-screen publishing dialog box.
     *
     * @param on_login_clicked specifies the callback that is invoked when the user clicks
     * the “Login” button.
     */
void spit_publishing_plugin_host_install_welcome_pane (SpitPublishingPluginHost* self, const gchar* welcome_message, SpitPublishingLoginCallback on_login_clicked, void* on_login_clicked_target) {
#line 420 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 420 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->install_welcome_pane (self, welcome_message, on_login_clicked, on_login_clicked_target);
#line 1083 "PublishingInterfaces.c"
}


/**
     * Toggles whether the service selector combo box in the upper-right-hand corner of the
     * on-screen publishing dialog box is sensitive to input.
     *
     * Publishers should make the service selector box insensitive to input when they are performing
     * non-interruptible file or network operations, since switching to another publishing
     * service will halt whatever service is currently running. Under certain circumstances,
     * the {@link PluginHost} may not honor this request.
     *
     * @param is_locked when is_locked is true, the service selector combo box is made insensitive.
     * It appears greyed out and the user is prevented from switching to another publishing service.
     * When is_locked is false, the combo box is sensitive, allowing the user to freely switch
     * from the current service to another service. 
     */
void spit_publishing_plugin_host_set_service_locked (SpitPublishingPluginHost* self, gboolean is_locked) {
#line 437 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 437 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->set_service_locked (self, is_locked);
#line 1106 "PublishingInterfaces.c"
}


/**
     * Makes the designated widget the default widget for the publishing dialog.
     *
     * After a call to this method, the designated widget will be activated whenever the user
     * presses the [ENTER] key anywhere in the on-screen publishing dialog box. Under certain
     * circumstances, the {@link PluginHost} may not honor this request.
     *
     * @param widget a reference to the widget to designate as the default widget for the
     *               publishing dialog.
     */
void spit_publishing_plugin_host_set_dialog_default_widget (SpitPublishingPluginHost* self, GtkWidget* widget) {
#line 449 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 449 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->set_dialog_default_widget (self, widget);
#line 1125 "PublishingInterfaces.c"
}


/**
     * Returns an array of the publishable media items that the user has selected for upload to the
     * remote service.
     */
SpitPublishingPublishable** spit_publishing_plugin_host_get_publishables (SpitPublishingPluginHost* self, int* result_length1) {
#line 455 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
#line 455 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->get_publishables (self, result_length1);
#line 1138 "PublishingInterfaces.c"
}


/**
     * Writes all of the publishable media items that the user has selected for upload to the
     * remote service to a temporary directory on a local disk.
     *
     * You should call this method immediately before sending the publishable media items to the
     * remote service over the network. Because serializing several megabytes of data is a
     * potentially lengthy operation, calling this method installs an activity status pane in
     * the on-screen publishing dialog box. The activity status pane displays a progress bar along
     * with a string of informational text.
     *
     * Because sending items over the network to the remote service is also a potentially lengthy
     * operation, you should leave the activity status pane installed in the on-screen publishing
     * dialog box until this task is finished. Periodically during the sending process, you should
     * report to the user on the progress of his or her upload. You can do this by invoking the
     * returned {@link ProgressCallback} delegate.
     *
     * After calling this method, the activity status pane that this method installs remains
     * displayed in the on-screen publishing dialog box until you install a new pane.
     *
     * @param content_major_axis when serializing publishable media items that are photos,
     *                           ensure that neither the width nor the height of the serialized
     *                           photo is greater than content_major_axis pixels. The value of
     *                           this parameter has no effect on video publishables.
     *
     * @param strip_metadata when serializing publishable media items that are photos, if
     *                       strip_metadata is true, all EXIF, IPTC, and XMP metadata will be
     *                       removed from the serialized file. If strip_metadata is false, all
     *                       metadata will be left intact. The value of this parameter has no
     *                       effect on video publishables.
     */
SpitPublishingProgressCallback spit_publishing_plugin_host_serialize_publishables (SpitPublishingPluginHost* self, gint content_major_axis, gboolean strip_metadata, void** result_target, GDestroyNotify* result_target_destroy_notify) {
#line 487 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), NULL);
#line 487 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->serialize_publishables (self, content_major_axis, strip_metadata, result_target, result_target_destroy_notify);
#line 1177 "PublishingInterfaces.c"
}


/**
     * Returns a {@link Publisher.MediaType} bitfield describing which kinds of media are present
     * in the set of publishable media items that the user has selected for upload to the remote
     * service.
     */
SpitPublishingPublisherMediaType spit_publishing_plugin_host_get_publishable_media_type (SpitPublishingPluginHost* self) {
#line 495 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self), 0);
#line 495 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->get_publishable_media_type (self);
#line 1191 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved0 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved0 (SpitPublishingPluginHost* self) {
#line 500 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 500 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved0 (self);
#line 1204 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved1 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved1 (SpitPublishingPluginHost* self) {
#line 501 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 501 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved1 (self);
#line 1217 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved2 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved2 (SpitPublishingPluginHost* self) {
#line 502 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 502 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved2 (self);
#line 1230 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved3 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved3 (SpitPublishingPluginHost* self) {
#line 503 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 503 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved3 (self);
#line 1243 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved4 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved4 (SpitPublishingPluginHost* self) {
#line 504 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 504 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved4 (self);
#line 1256 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved5 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved5 (SpitPublishingPluginHost* self) {
#line 505 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 505 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved5 (self);
#line 1269 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved6 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved6 (SpitPublishingPluginHost* self) {
#line 506 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 506 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved6 (self);
#line 1282 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_real_reserved7 (SpitPublishingPluginHost* self) {
}


void spit_publishing_plugin_host_reserved7 (SpitPublishingPluginHost* self) {
#line 507 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PLUGIN_HOST (self));
#line 507 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PLUGIN_HOST_GET_INTERFACE (self)->reserved7 (self);
#line 1295 "PublishingInterfaces.c"
}


static void spit_publishing_plugin_host_base_init (SpitPublishingPluginHostIface * iface) {
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_plugin_host_real_reserved0;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_plugin_host_real_reserved1;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_plugin_host_real_reserved2;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_plugin_host_real_reserved3;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_plugin_host_real_reserved4;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_plugin_host_real_reserved5;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_plugin_host_real_reserved6;
#line 253 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_plugin_host_real_reserved7;
#line 1322 "PublishingInterfaces.c"
	}
}


/**
 * Manages and provides services for publishing plugins.
 *
 * Implemented inside Shotwell, the PluginHost provides an interface through which the
 * developers of publishing plugins can query and make changes to the publishing
 * environment. For example, through the PluginHost, plugins can get a list of the photos
 * and videos to be published, install and remove user-interface panes in the publishing
 * dialog box, and request that the items to be uploaded be serialized to a temporary
 * directory on disk. Plugins can use the services of the PluginHost only when their
 * {@link Publisher} is in the running state. This ensures that non-running publishers
 * don’t destructively interfere with the actively running publisher.
 */
GType spit_publishing_plugin_host_get_type (void) {
	static volatile gsize spit_publishing_plugin_host_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_plugin_host_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPluginHostIface), (GBaseInitFunc) spit_publishing_plugin_host_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_plugin_host_type_id;
		spit_publishing_plugin_host_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPluginHost", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_plugin_host_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (spit_publishing_plugin_host_type_id, SPIT_TYPE_HOST_INTERFACE);
		g_once_init_leave (&spit_publishing_plugin_host_type_id__volatile, spit_publishing_plugin_host_type_id);
	}
	return spit_publishing_plugin_host_type_id__volatile;
}


/**
     * Returns a handle to the file on disk to which this publishable's data has been
     * serialized.
     *
     * You should use this file handle to read into memory the binary data you will send over
     * the network to the remote publishing service when this publishable is uploaded.
     */
GFile* spit_publishing_publishable_get_serialized_file (SpitPublishingPublishable* self) {
#line 528 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 528 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_serialized_file (self);
#line 1365 "PublishingInterfaces.c"
}


/**
     * Returns a name that can be used to identify this publishable to the remote service.
     * If the publishing host cannot derive a sensible name, this method will
     * return an empty string. Plugins should be able to handle that situation
     * and provide a fallback value. One possible option for a fallback is:
     * get_param_string(Spit.Publishing.Publishable.PARAM_STRING_BASENAME)
     */
gchar* spit_publishing_publishable_get_publishing_name (SpitPublishingPublishable* self) {
#line 537 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 537 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_publishing_name (self);
#line 1381 "PublishingInterfaces.c"
}


/**
     * Returns a string value from the publishable corresponding with the parameter name 
     * provided, or null if there is no value for this name.
     */
gchar* spit_publishing_publishable_get_param_string (SpitPublishingPublishable* self, const gchar* name) {
#line 543 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 543 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_param_string (self, name);
#line 1394 "PublishingInterfaces.c"
}


/**
     * Returns an array of strings that should be used to tag or mark this publishable on the
     * remote service, or null if this publishable has no tags or markings.
     */
gchar** spit_publishing_publishable_get_publishing_keywords (SpitPublishingPublishable* self, int* result_length1) {
#line 549 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 549 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_publishing_keywords (self, result_length1);
#line 1407 "PublishingInterfaces.c"
}


/**
     * Returns the kind of media item this publishable encapsulates.
     */
SpitPublishingPublisherMediaType spit_publishing_publishable_get_media_type (SpitPublishingPublishable* self) {
#line 554 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), 0);
#line 554 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_media_type (self);
#line 1419 "PublishingInterfaces.c"
}


/**
     * Returns the creation timestamp on the file.
     */
GDateTime* spit_publishing_publishable_get_exposure_date_time (SpitPublishingPublishable* self) {
#line 559 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self), NULL);
#line 559 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->get_exposure_date_time (self);
#line 1431 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved0 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved0 (SpitPublishingPublishable* self) {
#line 564 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 564 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved0 (self);
#line 1444 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved1 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved1 (SpitPublishingPublishable* self) {
#line 565 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 565 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved1 (self);
#line 1457 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved2 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved2 (SpitPublishingPublishable* self) {
#line 566 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 566 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved2 (self);
#line 1470 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved3 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved3 (SpitPublishingPublishable* self) {
#line 567 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 567 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved3 (self);
#line 1483 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved4 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved4 (SpitPublishingPublishable* self) {
#line 568 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 568 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved4 (self);
#line 1496 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved5 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved5 (SpitPublishingPublishable* self) {
#line 569 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 569 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved5 (self);
#line 1509 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved6 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved6 (SpitPublishingPublishable* self) {
#line 570 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 570 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved6 (self);
#line 1522 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_real_reserved7 (SpitPublishingPublishable* self) {
}


void spit_publishing_publishable_reserved7 (SpitPublishingPublishable* self) {
#line 571 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (self));
#line 571 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_PUBLISHABLE_GET_INTERFACE (self)->reserved7 (self);
#line 1535 "PublishingInterfaces.c"
}


static void spit_publishing_publishable_base_init (SpitPublishingPublishableIface * iface) {
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_publishable_real_reserved0;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_publishable_real_reserved1;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_publishable_real_reserved2;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_publishable_real_reserved3;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_publishable_real_reserved4;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_publishable_real_reserved5;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_publishable_real_reserved6;
#line 514 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_publishable_real_reserved7;
#line 1562 "PublishingInterfaces.c"
	}
}


/**
 * Describes an underlying media item (such as a photo or a video) that your plugin
 * uploads to a remote publishing service.
 */
GType spit_publishing_publishable_get_type (void) {
	static volatile gsize spit_publishing_publishable_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_publishable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingPublishableIface), (GBaseInitFunc) spit_publishing_publishable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_publishable_type_id;
		spit_publishing_publishable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingPublishable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_publishable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&spit_publishing_publishable_type_id__volatile, spit_publishing_publishable_type_id);
	}
	return spit_publishing_publishable_type_id__volatile;
}


/**
     * A factory method that instantiates and returns a new {@link Publisher} object that
     * encapsulates a connection to the remote publishing service that this Service describes.
     */
SpitPublishingPublisher* spit_publishing_service_create_publisher (SpitPublishingService* self, SpitPublishingPluginHost* host) {
#line 584 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_SERVICE (self), NULL);
#line 584 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->create_publisher (self, host);
#line 1593 "PublishingInterfaces.c"
}


/**
     * Returns the kinds of media that this service can work with.
     */
SpitPublishingPublisherMediaType spit_publishing_service_get_supported_media (SpitPublishingService* self) {
#line 589 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_SERVICE (self), 0);
#line 589 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	return SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->get_supported_media (self);
#line 1605 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved0 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved0 (SpitPublishingService* self) {
#line 594 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 594 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved0 (self);
#line 1618 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved1 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved1 (SpitPublishingService* self) {
#line 595 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 595 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved1 (self);
#line 1631 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved2 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved2 (SpitPublishingService* self) {
#line 596 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 596 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved2 (self);
#line 1644 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved3 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved3 (SpitPublishingService* self) {
#line 597 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 597 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved3 (self);
#line 1657 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved4 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved4 (SpitPublishingService* self) {
#line 598 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 598 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved4 (self);
#line 1670 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved5 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved5 (SpitPublishingService* self) {
#line 599 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 599 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved5 (self);
#line 1683 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved6 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved6 (SpitPublishingService* self) {
#line 600 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 600 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved6 (self);
#line 1696 "PublishingInterfaces.c"
}


static void spit_publishing_service_real_reserved7 (SpitPublishingService* self) {
}


void spit_publishing_service_reserved7 (SpitPublishingService* self) {
#line 601 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	g_return_if_fail (SPIT_PUBLISHING_IS_SERVICE (self));
#line 601 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	SPIT_PUBLISHING_SERVICE_GET_INTERFACE (self)->reserved7 (self);
#line 1709 "PublishingInterfaces.c"
}


static void spit_publishing_service_base_init (SpitPublishingServiceIface * iface) {
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	static gboolean initialized = FALSE;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
	if (!initialized) {
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		initialized = TRUE;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved0 = spit_publishing_service_real_reserved0;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved1 = spit_publishing_service_real_reserved1;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved2 = spit_publishing_service_real_reserved2;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved3 = spit_publishing_service_real_reserved3;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved4 = spit_publishing_service_real_reserved4;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved5 = spit_publishing_service_real_reserved5;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved6 = spit_publishing_service_real_reserved6;
#line 579 "/home/jens/Source/shotwell/src/plugins/PublishingInterfaces.vala"
		iface->reserved7 = spit_publishing_service_real_reserved7;
#line 1736 "PublishingInterfaces.c"
	}
}


/**
 * Describes the features and capabilities of a remote publishing service.
 *
 * Developers of publishing plugins provide a class that implements this interface.
 */
GType spit_publishing_service_get_type (void) {
	static volatile gsize spit_publishing_service_type_id__volatile = 0;
	if (g_once_init_enter (&spit_publishing_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SpitPublishingServiceIface), (GBaseInitFunc) spit_publishing_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType spit_publishing_service_type_id;
		spit_publishing_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "SpitPublishingService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (spit_publishing_service_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (spit_publishing_service_type_id, SPIT_TYPE_PLUGGABLE);
		g_once_init_leave (&spit_publishing_service_type_id__volatile, spit_publishing_service_type_id);
	}
	return spit_publishing_service_type_id__volatile;
}



