/* RawSupport.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from RawSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libraw/libraw.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define TYPE_PHOTO_FILE_FORMAT_DRIVER (photo_file_format_driver_get_type ())
#define PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriver))
#define PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))
#define IS_PHOTO_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define IS_PHOTO_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_DRIVER))
#define PHOTO_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_DRIVER, PhotoFileFormatDriverClass))

typedef struct _PhotoFileFormatDriver PhotoFileFormatDriver;
typedef struct _PhotoFileFormatDriverClass PhotoFileFormatDriverClass;
typedef struct _PhotoFileFormatDriverPrivate PhotoFileFormatDriverPrivate;

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;

#define TYPE_RAW_FILE_FORMAT_DRIVER (raw_file_format_driver_get_type ())
#define RAW_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver))
#define RAW_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriverClass))
#define IS_RAW_FILE_FORMAT_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_FILE_FORMAT_DRIVER))
#define IS_RAW_FILE_FORMAT_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_FILE_FORMAT_DRIVER))
#define RAW_FILE_FORMAT_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriverClass))

typedef struct _RawFileFormatDriver RawFileFormatDriver;
typedef struct _RawFileFormatDriverClass RawFileFormatDriverClass;
typedef struct _RawFileFormatDriverPrivate RawFileFormatDriverPrivate;
#define _photo_file_format_driver_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_driver_unref (var), NULL)))

#define TYPE_RAW_FILE_FORMAT_PROPERTIES (raw_file_format_properties_get_type ())
#define RAW_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties))
#define RAW_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatPropertiesClass))
#define IS_RAW_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES))
#define IS_RAW_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_FILE_FORMAT_PROPERTIES))
#define RAW_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatPropertiesClass))

typedef struct _RawFileFormatProperties RawFileFormatProperties;
typedef struct _RawFileFormatPropertiesClass RawFileFormatPropertiesClass;

#define TYPE_RAW_READER (raw_reader_get_type ())
#define RAW_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_READER, RawReader))
#define RAW_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_READER, RawReaderClass))
#define IS_RAW_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_READER))
#define IS_RAW_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_READER))
#define RAW_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_READER, RawReaderClass))

typedef struct _RawReader RawReader;
typedef struct _RawReaderClass RawReaderClass;

#define TYPE_RAW_SNIFFER (raw_sniffer_get_type ())
#define RAW_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAW_SNIFFER, RawSniffer))
#define RAW_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RAW_SNIFFER, RawSnifferClass))
#define IS_RAW_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAW_SNIFFER))
#define IS_RAW_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RAW_SNIFFER))
#define RAW_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RAW_SNIFFER, RawSnifferClass))

typedef struct _RawSniffer RawSniffer;
typedef struct _RawSnifferClass RawSnifferClass;
typedef struct _PhotoFileFormatPropertiesPrivate PhotoFileFormatPropertiesPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_FILE_FORMAT_FLAGS (photo_file_format_flags_get_type ())
typedef struct _RawFileFormatPropertiesPrivate RawFileFormatPropertiesPrivate;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
typedef struct _RawSnifferPrivate RawSnifferPrivate;

#define GRAW_TYPE_PROCESSOR (graw_processor_get_type ())
#define GRAW_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSOR, GRawProcessor))
#define GRAW_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSOR, GRawProcessorClass))
#define GRAW_IS_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSOR))
#define GRAW_IS_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSOR))
#define GRAW_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSOR, GRawProcessorClass))

typedef struct _GRawProcessor GRawProcessor;
typedef struct _GRawProcessorClass GRawProcessorClass;

#define GRAW_TYPE_FLIP (graw_flip_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _graw_processor_unref0(var) ((var == NULL) ? NULL : (var = (graw_processor_unref (var), NULL)))
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;
typedef struct _RawReaderPrivate RawReaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GRAW_TYPE_PROCESSED_IMAGE (graw_processed_image_get_type ())
#define GRAW_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImage))
#define GRAW_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))
#define GRAW_IS_PROCESSED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_IS_PROCESSED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRAW_TYPE_PROCESSED_IMAGE))
#define GRAW_PROCESSED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRAW_TYPE_PROCESSED_IMAGE, GRawProcessedImageClass))

typedef struct _GRawProcessedImage GRawProcessedImage;
typedef struct _GRawProcessedImageClass GRawProcessedImageClass;
#define _graw_processed_image_unref0(var) ((var == NULL) ? NULL : (var = (graw_processed_image_unref (var), NULL)))

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_ORIENTATION (orientation_get_type ())

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoFileFormatDriver {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatDriverPrivate * priv;
};

struct _PhotoFileFormatDriverClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatDriver *self);
	PhotoFileFormatProperties* (*get_properties) (PhotoFileFormatDriver* self);
	PhotoFileReader* (*create_reader) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoMetadata* (*create_metadata) (PhotoFileFormatDriver* self);
	gboolean (*can_write_image) (PhotoFileFormatDriver* self);
	gboolean (*can_write_metadata) (PhotoFileFormatDriver* self);
	PhotoFileWriter* (*create_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileMetadataWriter* (*create_metadata_writer) (PhotoFileFormatDriver* self, const gchar* filepath);
	PhotoFileSniffer* (*create_sniffer) (PhotoFileFormatDriver* self, GFile* file, PhotoFileSnifferOptions options);
};

struct _RawFileFormatDriver {
	PhotoFileFormatDriver parent_instance;
	RawFileFormatDriverPrivate * priv;
};

struct _RawFileFormatDriverClass {
	PhotoFileFormatDriverClass parent_class;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	PHOTO_FILE_FORMAT_FLAGS_NONE = 0x00000000
} PhotoFileFormatFlags;

struct _PhotoFileFormatProperties {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileFormatPropertiesPrivate * priv;
};

struct _PhotoFileFormatPropertiesClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileFormatProperties *self);
	PhotoFileFormat (*get_file_format) (PhotoFileFormatProperties* self);
	PhotoFileFormatFlags (*get_flags) (PhotoFileFormatProperties* self);
	gboolean (*is_recognized_extension) (PhotoFileFormatProperties* self, const gchar* ext);
	gchar* (*get_default_extension) (PhotoFileFormatProperties* self);
	gchar** (*get_known_extensions) (PhotoFileFormatProperties* self, int* result_length1);
	gchar* (*get_default_mime_type) (PhotoFileFormatProperties* self);
	gchar** (*get_mime_types) (PhotoFileFormatProperties* self, int* result_length1);
	gchar* (*get_user_visible_name) (PhotoFileFormatProperties* self);
};

struct _RawFileFormatProperties {
	PhotoFileFormatProperties parent_instance;
	RawFileFormatPropertiesPrivate * priv;
};

struct _RawFileFormatPropertiesClass {
	PhotoFileFormatPropertiesClass parent_class;
};

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _RawSniffer {
	PhotoFileSniffer parent_instance;
	RawSnifferPrivate * priv;
};

struct _RawSnifferClass {
	PhotoFileSnifferClass parent_class;
};

typedef enum  {
	GRAW_FLIP_FROM_SOURCE = -1,
	GRAW_FLIP_NONE = 0,
	GRAW_FLIP_UPSIDE_DOWN = 3,
	GRAW_FLIP_COUNTERCLOCKWISE = 5,
	GRAW_FLIP_CLOCKWISE = 6
} GRawFlip;

typedef enum  {
	GRAW_EXCEPTION_UNSPECIFIED,
	GRAW_EXCEPTION_UNSUPPORTED_FILE,
	GRAW_EXCEPTION_NONEXISTANT_IMAGE,
	GRAW_EXCEPTION_OUT_OF_ORDER_CALL,
	GRAW_EXCEPTION_NO_THUMBNAIL,
	GRAW_EXCEPTION_UNSUPPORTED_THUMBNAIL,
	GRAW_EXCEPTION_OUT_OF_MEMORY,
	GRAW_EXCEPTION_DATA_ERROR,
	GRAW_EXCEPTION_IO_ERROR,
	GRAW_EXCEPTION_CANCELLED_BY_CALLBACK,
	GRAW_EXCEPTION_BAD_CROP,
	GRAW_EXCEPTION_SYSTEM_ERROR
} GRawException;
#define GRAW_EXCEPTION graw_exception_quark ()
struct _Dimensions {
	gint width;
	gint height;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _RawReader {
	PhotoFileReader parent_instance;
	RawReaderPrivate * priv;
};

struct _RawReaderClass {
	PhotoFileReaderClass parent_class;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};


static gpointer raw_file_format_driver_parent_class = NULL;
static RawFileFormatDriver* raw_file_format_driver_instance;
static RawFileFormatDriver* raw_file_format_driver_instance = NULL;
static gpointer raw_file_format_properties_parent_class = NULL;
static gchar** raw_file_format_properties_KNOWN_EXTENSIONS;
static gint raw_file_format_properties_KNOWN_EXTENSIONS_length1;
static gchar** raw_file_format_properties_KNOWN_EXTENSIONS = NULL;
static gint raw_file_format_properties_KNOWN_EXTENSIONS_length1 = 0;
static gint _raw_file_format_properties_KNOWN_EXTENSIONS_size_ = 0;
static gchar** raw_file_format_properties_KNOWN_MIME_TYPES;
static gint raw_file_format_properties_KNOWN_MIME_TYPES_length1;
static gchar** raw_file_format_properties_KNOWN_MIME_TYPES = NULL;
static gint raw_file_format_properties_KNOWN_MIME_TYPES_length1 = 0;
static gint _raw_file_format_properties_KNOWN_MIME_TYPES_size_ = 0;
static RawFileFormatProperties* raw_file_format_properties_instance;
static RawFileFormatProperties* raw_file_format_properties_instance = NULL;
static gpointer raw_sniffer_parent_class = NULL;
static gpointer raw_reader_parent_class = NULL;

gpointer photo_file_format_driver_ref (gpointer instance);
void photo_file_format_driver_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_driver (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_driver (GValue* value, gpointer v_object);
void value_take_photo_file_format_driver (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_driver (const GValue* value);
GType photo_file_format_driver_get_type (void) G_GNUC_CONST;
gpointer photo_file_format_properties_ref (gpointer instance);
void photo_file_format_properties_unref (gpointer instance);
GParamSpec* param_spec_photo_file_format_properties (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_format_properties (GValue* value, gpointer v_object);
void value_take_photo_file_format_properties (GValue* value, gpointer v_object);
gpointer value_get_photo_file_format_properties (const GValue* value);
GType photo_file_format_properties_get_type (void) G_GNUC_CONST;
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST;
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
gpointer photo_file_sniffer_ref (gpointer instance);
void photo_file_sniffer_unref (gpointer instance);
GParamSpec* param_spec_photo_file_sniffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_sniffer (GValue* value, gpointer v_object);
void value_take_photo_file_sniffer (GValue* value, gpointer v_object);
gpointer value_get_photo_file_sniffer (const GValue* value);
GType photo_file_sniffer_get_type (void) G_GNUC_CONST;
GType raw_file_format_driver_get_type (void) G_GNUC_CONST;
enum  {
	RAW_FILE_FORMAT_DRIVER_DUMMY_PROPERTY
};
void raw_file_format_driver_init (void);
RawFileFormatDriver* raw_file_format_driver_new (void);
RawFileFormatDriver* raw_file_format_driver_construct (GType object_type);
void raw_file_format_properties_init (void);
RawFileFormatDriver* raw_file_format_driver_get_instance (void);
static PhotoFileFormatProperties* raw_file_format_driver_real_get_properties (PhotoFileFormatDriver* base);
GType raw_file_format_properties_get_type (void) G_GNUC_CONST;
RawFileFormatProperties* raw_file_format_properties_get_instance (void);
static PhotoFileReader* raw_file_format_driver_real_create_reader (PhotoFileFormatDriver* base, const gchar* filepath);
RawReader* raw_reader_new (const gchar* filepath);
RawReader* raw_reader_construct (GType object_type, const gchar* filepath);
GType raw_reader_get_type (void) G_GNUC_CONST;
static PhotoMetadata* raw_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base);
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
static gboolean raw_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base);
static gboolean raw_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base);
static PhotoFileWriter* raw_file_format_driver_real_create_writer (PhotoFileFormatDriver* base, const gchar* filepath);
static PhotoFileMetadataWriter* raw_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base, const gchar* filepath);
static PhotoFileSniffer* raw_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base, GFile* file, PhotoFileSnifferOptions options);
RawSniffer* raw_sniffer_new (GFile* file, PhotoFileSnifferOptions options);
RawSniffer* raw_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
GType raw_sniffer_get_type (void) G_GNUC_CONST;
PhotoFileFormatDriver* photo_file_format_driver_construct (GType object_type);
static void raw_file_format_driver_finalize (PhotoFileFormatDriver* obj);
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType photo_file_format_flags_get_type (void) G_GNUC_CONST;
enum  {
	RAW_FILE_FORMAT_PROPERTIES_DUMMY_PROPERTY
};
RawFileFormatProperties* raw_file_format_properties_new (void);
RawFileFormatProperties* raw_file_format_properties_construct (GType object_type);
static PhotoFileFormat raw_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base);
static gchar* raw_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base);
static PhotoFileFormatFlags raw_file_format_properties_real_get_flags (PhotoFileFormatProperties* base);
static gchar* raw_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base);
static gchar** raw_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base, int* result_length1);
static gchar** _vala_array_dup12 (gchar** self, int length);
static gchar* raw_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base);
static gchar** raw_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base, int* result_length1);
static gchar** _vala_array_dup13 (gchar** self, int length);
PhotoFileFormatProperties* photo_file_format_properties_construct (GType object_type);
static void raw_file_format_properties_finalize (PhotoFileFormatProperties* obj);
gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_detected_photo_information (GValue* value, gpointer v_object);
void value_take_detected_photo_information (GValue* value, gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
enum  {
	RAW_SNIFFER_DUMMY_PROPERTY
};
PhotoFileSniffer* photo_file_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
static DetectedPhotoInformation* raw_sniffer_real_sniff (PhotoFileSniffer* base, gboolean* is_corrupted, GError** error);
DetectedPhotoInformation* detected_photo_information_new (void);
DetectedPhotoInformation* detected_photo_information_construct (GType object_type);
gpointer graw_processor_ref (gpointer instance);
void graw_processor_unref (gpointer instance);
GParamSpec* graw_param_spec_processor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void graw_value_set_processor (GValue* value, gpointer v_object);
void graw_value_take_processor (GValue* value, gpointer v_object);
gpointer graw_value_get_processor (const GValue* value);
GType graw_processor_get_type (void) G_GNUC_CONST;
GRawProcessor* graw_processor_new (enum LibRaw_constructor_flags options);
GRawProcessor* graw_processor_construct (GType object_type, enum LibRaw_constructor_flags options);
libraw_output_params_t* graw_processor_get_output_params (GRawProcessor* self);
GType graw_flip_get_type (void) G_GNUC_CONST;
GQuark graw_exception_quark (void);
void graw_processor_open_file (GRawProcessor* self, const gchar* filename, GError** error);
void graw_processor_unpack (GRawProcessor* self, GError** error);
void graw_processor_adjust_sizes_info_only (GRawProcessor* self, GError** error);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
libraw_image_sizes_t graw_processor_get_sizes (GRawProcessor* self);
void dimensions_init (Dimensions *self, gint width, gint height);
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self, GError** error);
guint8* photo_metadata_flatten_exif (PhotoMetadata* self, gboolean include_preview, int* result_length1);
gchar* md5_binary (guint8* buffer, gsize length);
guint8* photo_metadata_flatten_exif_preview (PhotoMetadata* self, int* result_length1);
gchar* md5_file (GFile* file, GError** error);
enum  {
	RAW_READER_DUMMY_PROPERTY
};
PhotoFileReader* photo_file_reader_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
static PhotoMetadata* raw_reader_real_read_metadata (PhotoFileReader* base, GError** error);
void media_metadata_read_from_file (MediaMetadata* self, GFile* file, GError** error);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static GdkPixbuf* raw_reader_real_unscaled_read (PhotoFileReader* base, GError** error);
void graw_processor_configure_for_rgb_display (GRawProcessor* self, gboolean half_size);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
void graw_processor_process (GRawProcessor* self, GError** error);
gpointer graw_processed_image_ref (gpointer instance);
void graw_processed_image_unref (gpointer instance);
GParamSpec* graw_param_spec_processed_image (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void graw_value_set_processed_image (GValue* value, gpointer v_object);
void graw_value_take_processed_image (GValue* value, gpointer v_object);
gpointer graw_value_get_processed_image (const GValue* value);
GType graw_processed_image_get_type (void) G_GNUC_CONST;
GRawProcessedImage* graw_processor_make_mem_image (GRawProcessor* self, GError** error);
GdkPixbuf* graw_processed_image_get_pixbuf_copy (GRawProcessedImage* self);
static GdkPixbuf* raw_reader_real_scaled_read (PhotoFileReader* base, Dimensions* full, Dimensions* scaled, GError** error);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
GType raw_developer_get_type (void) G_GNUC_CONST;
RawDeveloper* raw_developer_as_array (int* result_length1);
gchar* raw_developer_to_string (RawDeveloper self);
RawDeveloper raw_developer_from_string (const gchar* value);
gchar* raw_developer_get_label (RawDeveloper self);
gboolean raw_developer_is_equivalent (RawDeveloper self, RawDeveloper d);
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self, const gchar* raw_filepath, const gchar* camera_development_filename, GError** error);
BackingPhotoRow* backing_photo_row_new (void);
BackingPhotoRow* backing_photo_row_construct (GType object_type);
void disassemble_filename (const gchar* basename, gchar** name, gchar** ext);
GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error);
gboolean claim_file (GFile* file, GError** error);
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType orientation_get_type (void) G_GNUC_CONST;


void raw_file_format_driver_init (void) {
	RawFileFormatDriver* _tmp0_ = NULL;
#line 11 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_driver_new ();
#line 11 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_photo_file_format_driver_unref0 (raw_file_format_driver_instance);
#line 11 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_driver_instance = _tmp0_;
#line 12 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_init ();
#line 658 "RawSupport.c"
}


static gpointer _photo_file_format_driver_ref0 (gpointer self) {
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self ? photo_file_format_driver_ref (self) : NULL;
#line 665 "RawSupport.c"
}


RawFileFormatDriver* raw_file_format_driver_get_instance (void) {
	RawFileFormatDriver* result = NULL;
	RawFileFormatDriver* _tmp0_ = NULL;
	RawFileFormatDriver* _tmp1_ = NULL;
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_driver_instance;
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _photo_file_format_driver_ref0 (_tmp0_);
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp1_;
#line 16 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 681 "RawSupport.c"
}


static PhotoFileFormatProperties* raw_file_format_driver_real_get_properties (PhotoFileFormatDriver* base) {
	RawFileFormatDriver * self;
	PhotoFileFormatProperties* result = NULL;
	RawFileFormatProperties* _tmp0_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 20 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_get_instance ();
#line 20 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties);
#line 20 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 697 "RawSupport.c"
}


static PhotoFileReader* raw_file_format_driver_real_create_reader (PhotoFileFormatDriver* base, const gchar* filepath) {
	RawFileFormatDriver * self;
	PhotoFileReader* result = NULL;
	const gchar* _tmp0_ = NULL;
	RawReader* _tmp1_ = NULL;
#line 23 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 23 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 24 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = filepath;
#line 24 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = raw_reader_new (_tmp0_);
#line 24 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_READER, PhotoFileReader);
#line 24 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 718 "RawSupport.c"
}


static PhotoMetadata* raw_file_format_driver_real_create_metadata (PhotoFileFormatDriver* base) {
	RawFileFormatDriver * self;
	PhotoMetadata* result = NULL;
	PhotoMetadata* _tmp0_ = NULL;
#line 27 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 28 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = photo_metadata_new ();
#line 28 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 734 "RawSupport.c"
}


static gboolean raw_file_format_driver_real_can_write_image (PhotoFileFormatDriver* base) {
	RawFileFormatDriver * self;
	gboolean result = FALSE;
#line 31 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 32 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = FALSE;
#line 32 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 747 "RawSupport.c"
}


static gboolean raw_file_format_driver_real_can_write_metadata (PhotoFileFormatDriver* base) {
	RawFileFormatDriver * self;
	gboolean result = FALSE;
#line 35 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 36 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = FALSE;
#line 36 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 760 "RawSupport.c"
}


static PhotoFileWriter* raw_file_format_driver_real_create_writer (PhotoFileFormatDriver* base, const gchar* filepath) {
	RawFileFormatDriver * self;
	PhotoFileWriter* result = NULL;
#line 39 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 39 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 40 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = NULL;
#line 40 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 775 "RawSupport.c"
}


static PhotoFileMetadataWriter* raw_file_format_driver_real_create_metadata_writer (PhotoFileFormatDriver* base, const gchar* filepath) {
	RawFileFormatDriver * self;
	PhotoFileMetadataWriter* result = NULL;
#line 43 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 43 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 44 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = NULL;
#line 44 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 790 "RawSupport.c"
}


static PhotoFileSniffer* raw_file_format_driver_real_create_sniffer (PhotoFileFormatDriver* base, GFile* file, PhotoFileSnifferOptions options) {
	RawFileFormatDriver * self;
	PhotoFileSniffer* result = NULL;
	GFile* _tmp0_ = NULL;
	PhotoFileSnifferOptions _tmp1_ = 0;
	RawSniffer* _tmp2_ = NULL;
#line 47 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 47 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = file;
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = options;
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = raw_sniffer_new (_tmp0_, _tmp1_);
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
#line 48 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 814 "RawSupport.c"
}


RawFileFormatDriver* raw_file_format_driver_construct (GType object_type) {
	RawFileFormatDriver* self = NULL;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = (RawFileFormatDriver*) photo_file_format_driver_construct (object_type);
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self;
#line 824 "RawSupport.c"
}


RawFileFormatDriver* raw_file_format_driver_new (void) {
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return raw_file_format_driver_construct (TYPE_RAW_FILE_FORMAT_DRIVER);
#line 831 "RawSupport.c"
}


static void raw_file_format_driver_class_init (RawFileFormatDriverClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_driver_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->finalize = raw_file_format_driver_finalize;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->get_properties = raw_file_format_driver_real_get_properties;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_reader = raw_file_format_driver_real_create_reader;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_metadata = raw_file_format_driver_real_create_metadata;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->can_write_image = raw_file_format_driver_real_can_write_image;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->can_write_metadata = raw_file_format_driver_real_can_write_metadata;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_writer = raw_file_format_driver_real_create_writer;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_metadata_writer = raw_file_format_driver_real_create_metadata_writer;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatDriverClass *) klass)->create_sniffer = raw_file_format_driver_real_create_sniffer;
#line 856 "RawSupport.c"
}


static void raw_file_format_driver_instance_init (RawFileFormatDriver * self) {
}


static void raw_file_format_driver_finalize (PhotoFileFormatDriver* obj) {
	RawFileFormatDriver * self;
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_FILE_FORMAT_DRIVER, RawFileFormatDriver);
#line 7 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	PHOTO_FILE_FORMAT_DRIVER_CLASS (raw_file_format_driver_parent_class)->finalize (obj);
#line 870 "RawSupport.c"
}


GType raw_file_format_driver_get_type (void) {
	static volatile gsize raw_file_format_driver_type_id__volatile = 0;
	if (g_once_init_enter (&raw_file_format_driver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RawFileFormatDriverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_file_format_driver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawFileFormatDriver), 0, (GInstanceInitFunc) raw_file_format_driver_instance_init, NULL };
		GType raw_file_format_driver_type_id;
		raw_file_format_driver_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_DRIVER, "RawFileFormatDriver", &g_define_type_info, 0);
		g_once_init_leave (&raw_file_format_driver_type_id__volatile, raw_file_format_driver_type_id);
	}
	return raw_file_format_driver_type_id__volatile;
}


void raw_file_format_properties_init (void) {
	RawFileFormatProperties* _tmp0_ = NULL;
#line 122 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_new ();
#line 122 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_photo_file_format_properties_unref0 (raw_file_format_properties_instance);
#line 122 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_instance = _tmp0_;
#line 894 "RawSupport.c"
}


static gpointer _photo_file_format_properties_ref0 (gpointer self) {
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self ? photo_file_format_properties_ref (self) : NULL;
#line 901 "RawSupport.c"
}


RawFileFormatProperties* raw_file_format_properties_get_instance (void) {
	RawFileFormatProperties* result = NULL;
	RawFileFormatProperties* _tmp0_ = NULL;
	RawFileFormatProperties* _tmp1_ = NULL;
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_instance;
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _photo_file_format_properties_ref0 (_tmp0_);
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp1_;
#line 126 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 917 "RawSupport.c"
}


static PhotoFileFormat raw_file_format_properties_real_get_file_format (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	PhotoFileFormat result = 0;
#line 129 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 130 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = PHOTO_FILE_FORMAT_RAW;
#line 130 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 930 "RawSupport.c"
}


static gchar* raw_file_format_properties_real_get_user_visible_name (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 133 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 134 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = _ ("RAW");
#line 134 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 134 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp1_;
#line 134 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 949 "RawSupport.c"
}


static PhotoFileFormatFlags raw_file_format_properties_real_get_flags (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	PhotoFileFormatFlags result = 0;
#line 137 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 138 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = PHOTO_FILE_FORMAT_FLAGS_NONE;
#line 138 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 962 "RawSupport.c"
}


static gchar* raw_file_format_properties_real_get_default_extension (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 141 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 145 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = g_strdup ("raw");
#line 145 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp0_;
#line 145 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 978 "RawSupport.c"
}


static gchar** _vala_array_dup12 (gchar** self, int length) {
	gchar** result;
	int i;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = g_new0 (gchar*, length + 1);
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	for (i = 0; i < length; i++) {
#line 989 "RawSupport.c"
		gchar* _tmp0_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp0_ = g_strdup (self[i]);
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		result[i] = _tmp0_;
#line 995 "RawSupport.c"
	}
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 999 "RawSupport.c"
}


static gchar** raw_file_format_properties_real_get_known_extensions (PhotoFileFormatProperties* base, int* result_length1) {
	RawFileFormatProperties * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 148 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_KNOWN_EXTENSIONS;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0__length1 = raw_file_format_properties_KNOWN_EXTENSIONS_length1;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup12 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1__length1 = _tmp0__length1;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = _tmp1_;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2__length1 = _tmp1__length1;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (result_length1) {
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		*result_length1 = _tmp2__length1;
#line 1030 "RawSupport.c"
	}
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp2_;
#line 149 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1036 "RawSupport.c"
}


static gchar* raw_file_format_properties_real_get_default_mime_type (PhotoFileFormatProperties* base) {
	RawFileFormatProperties * self;
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_KNOWN_MIME_TYPES;
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0__length1 = raw_file_format_properties_KNOWN_MIME_TYPES_length1;
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _tmp0_[0];
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp2_;
#line 153 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1061 "RawSupport.c"
}


static gchar** _vala_array_dup13 (gchar** self, int length) {
	gchar** result;
	int i;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = g_new0 (gchar*, length + 1);
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	for (i = 0; i < length; i++) {
#line 1072 "RawSupport.c"
		gchar* _tmp0_ = NULL;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp0_ = g_strdup (self[i]);
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		result[i] = _tmp0_;
#line 1078 "RawSupport.c"
	}
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1082 "RawSupport.c"
}


static gchar** raw_file_format_properties_real_get_mime_types (PhotoFileFormatProperties* base, int* result_length1) {
	RawFileFormatProperties * self;
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 156 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = raw_file_format_properties_KNOWN_MIME_TYPES;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0__length1 = raw_file_format_properties_KNOWN_MIME_TYPES_length1;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup13 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1__length1 = _tmp0__length1;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = _tmp1_;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2__length1 = _tmp1__length1;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (result_length1) {
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		*result_length1 = _tmp2__length1;
#line 1113 "RawSupport.c"
	}
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp2_;
#line 157 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 1119 "RawSupport.c"
}


RawFileFormatProperties* raw_file_format_properties_construct (GType object_type) {
	RawFileFormatProperties* self = NULL;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = (RawFileFormatProperties*) photo_file_format_properties_construct (object_type);
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self;
#line 1129 "RawSupport.c"
}


RawFileFormatProperties* raw_file_format_properties_new (void) {
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return raw_file_format_properties_construct (TYPE_RAW_FILE_FORMAT_PROPERTIES);
#line 1136 "RawSupport.c"
}


static void raw_file_format_properties_class_init (RawFileFormatPropertiesClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar** _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	gchar* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	gchar* _tmp71_ = NULL;
	gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_ = NULL;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	gchar* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	gchar* _tmp80_ = NULL;
	gchar* _tmp81_ = NULL;
	gchar* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	gchar* _tmp86_ = NULL;
	gchar* _tmp87_ = NULL;
	gchar** _tmp88_ = NULL;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_parent_class = g_type_class_peek_parent (klass);
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->finalize = raw_file_format_properties_finalize;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_file_format = raw_file_format_properties_real_get_file_format;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_user_visible_name = raw_file_format_properties_real_get_user_visible_name;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_flags = raw_file_format_properties_real_get_flags;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_default_extension = raw_file_format_properties_real_get_default_extension;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_known_extensions = raw_file_format_properties_real_get_known_extensions;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_default_mime_type = raw_file_format_properties_real_get_default_mime_type;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileFormatPropertiesClass *) klass)->get_mime_types = raw_file_format_properties_real_get_mime_types;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = g_strdup ("3fr");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = g_strdup ("arw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = g_strdup ("srf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = g_strdup ("sr2");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = g_strdup ("bay");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp5_ = g_strdup ("crw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp6_ = g_strdup ("cr2");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp7_ = g_strdup ("cap");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp8_ = g_strdup ("iiq");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp9_ = g_strdup ("eip");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp10_ = g_strdup ("dcs");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp11_ = g_strdup ("dcr");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp12_ = g_strdup ("drf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp13_ = g_strdup ("k25");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp14_ = g_strdup ("kdc");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp15_ = g_strdup ("dng");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp16_ = g_strdup ("erf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp17_ = g_strdup ("fff");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp18_ = g_strdup ("mef");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp19_ = g_strdup ("mos");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp20_ = g_strdup ("mrw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp21_ = g_strdup ("nef");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp22_ = g_strdup ("nrw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp23_ = g_strdup ("orf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp24_ = g_strdup ("ptx");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp25_ = g_strdup ("pef");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp26_ = g_strdup ("pxn");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp27_ = g_strdup ("r3d");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp28_ = g_strdup ("raf");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp29_ = g_strdup ("raw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp30_ = g_strdup ("rw2");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp31_ = g_strdup ("raw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp32_ = g_strdup ("rwl");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp33_ = g_strdup ("rwz");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp34_ = g_strdup ("x3f");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp35_ = g_strdup ("srw");
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_ = g_new0 (gchar*, 36 + 1);
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[0] = _tmp0_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[1] = _tmp1_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[2] = _tmp2_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[3] = _tmp3_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[4] = _tmp4_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[5] = _tmp5_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[6] = _tmp6_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[7] = _tmp7_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[8] = _tmp8_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[9] = _tmp9_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[10] = _tmp10_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[11] = _tmp11_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[12] = _tmp12_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[13] = _tmp13_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[14] = _tmp14_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[15] = _tmp15_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[16] = _tmp16_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[17] = _tmp17_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[18] = _tmp18_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[19] = _tmp19_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[20] = _tmp20_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[21] = _tmp21_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[22] = _tmp22_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[23] = _tmp23_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[24] = _tmp24_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[25] = _tmp25_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[26] = _tmp26_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[27] = _tmp27_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[28] = _tmp28_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[29] = _tmp29_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[30] = _tmp30_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[31] = _tmp31_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[32] = _tmp32_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[33] = _tmp33_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[34] = _tmp34_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_[35] = _tmp35_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_KNOWN_EXTENSIONS = _tmp36_;
#line 53 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_KNOWN_EXTENSIONS_length1 = 36;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp37_ = g_strdup ("image/x-dcraw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp38_ = g_strdup ("image/x-canon-cr2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp39_ = g_strdup ("image/x-canon-crw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp40_ = g_strdup ("image/x-fuji-raf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp41_ = g_strdup ("image/x-adobe-dng");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp42_ = g_strdup ("image/x-panasonic-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp43_ = g_strdup ("image/x-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp44_ = g_strdup ("image/x-minolta-mrw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp45_ = g_strdup ("image/x-nikon-nef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp46_ = g_strdup ("image/x-olympus-orf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp47_ = g_strdup ("image/x-pentax-pef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp48_ = g_strdup ("image/x-sony-arw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp49_ = g_strdup ("image/x-sony-srf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp50_ = g_strdup ("image/x-sony-sr2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp51_ = g_strdup ("image/x-samsung-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp52_ = g_strdup ("image/x-3fr");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp53_ = g_strdup ("image/x-arw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp54_ = g_strdup ("image/x-srf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp55_ = g_strdup ("image/x-sr2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp56_ = g_strdup ("image/x-bay");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp57_ = g_strdup ("image/x-crw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp58_ = g_strdup ("image/x-cr2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp59_ = g_strdup ("image/x-cap");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp60_ = g_strdup ("image/x-iiq");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp61_ = g_strdup ("image/x-eip");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp62_ = g_strdup ("image/x-dcs");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp63_ = g_strdup ("image/x-dcr");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp64_ = g_strdup ("image/x-drf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp65_ = g_strdup ("image/x-k25");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp66_ = g_strdup ("image/x-kdc");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp67_ = g_strdup ("image/x-dng");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp68_ = g_strdup ("image/x-erf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp69_ = g_strdup ("image/x-fff");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp70_ = g_strdup ("image/x-mef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp71_ = g_strdup ("image/x-mos");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp72_ = g_strdup ("image/x-mrw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp73_ = g_strdup ("image/x-nef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp74_ = g_strdup ("image/x-nrw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp75_ = g_strdup ("image/x-orf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp76_ = g_strdup ("image/x-ptx");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp77_ = g_strdup ("image/x-pef");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp78_ = g_strdup ("image/x-pxn");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp79_ = g_strdup ("image/x-r3d");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp80_ = g_strdup ("image/x-raf");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp81_ = g_strdup ("image/x-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp82_ = g_strdup ("image/x-rw2");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp83_ = g_strdup ("image/x-raw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp84_ = g_strdup ("image/x-rwl");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp85_ = g_strdup ("image/x-rwz");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp86_ = g_strdup ("image/x-x3f");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp87_ = g_strdup ("image/x-srw");
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_ = g_new0 (gchar*, 51 + 1);
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[0] = _tmp37_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[1] = _tmp38_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[2] = _tmp39_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[3] = _tmp40_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[4] = _tmp41_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[5] = _tmp42_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[6] = _tmp43_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[7] = _tmp44_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[8] = _tmp45_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[9] = _tmp46_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[10] = _tmp47_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[11] = _tmp48_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[12] = _tmp49_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[13] = _tmp50_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[14] = _tmp51_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[15] = _tmp52_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[16] = _tmp53_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[17] = _tmp54_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[18] = _tmp55_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[19] = _tmp56_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[20] = _tmp57_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[21] = _tmp58_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[22] = _tmp59_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[23] = _tmp60_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[24] = _tmp61_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[25] = _tmp62_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[26] = _tmp63_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[27] = _tmp64_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[28] = _tmp65_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[29] = _tmp66_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[30] = _tmp67_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[31] = _tmp68_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[32] = _tmp69_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[33] = _tmp70_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[34] = _tmp71_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[35] = _tmp72_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[36] = _tmp73_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[37] = _tmp74_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[38] = _tmp75_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[39] = _tmp76_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[40] = _tmp77_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[41] = _tmp78_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[42] = _tmp79_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[43] = _tmp80_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[44] = _tmp81_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[45] = _tmp82_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[46] = _tmp83_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[47] = _tmp84_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[48] = _tmp85_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[49] = _tmp86_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp88_[50] = _tmp87_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_KNOWN_MIME_TYPES = _tmp88_;
#line 59 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_file_format_properties_KNOWN_MIME_TYPES_length1 = 51;
#line 1608 "RawSupport.c"
}


static void raw_file_format_properties_instance_init (RawFileFormatProperties * self) {
}


static void raw_file_format_properties_finalize (PhotoFileFormatProperties* obj) {
	RawFileFormatProperties * self;
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RAW_FILE_FORMAT_PROPERTIES, RawFileFormatProperties);
#line 52 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	PHOTO_FILE_FORMAT_PROPERTIES_CLASS (raw_file_format_properties_parent_class)->finalize (obj);
#line 1622 "RawSupport.c"
}


GType raw_file_format_properties_get_type (void) {
	static volatile gsize raw_file_format_properties_type_id__volatile = 0;
	if (g_once_init_enter (&raw_file_format_properties_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RawFileFormatPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_file_format_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawFileFormatProperties), 0, (GInstanceInitFunc) raw_file_format_properties_instance_init, NULL };
		GType raw_file_format_properties_type_id;
		raw_file_format_properties_type_id = g_type_register_static (TYPE_PHOTO_FILE_FORMAT_PROPERTIES, "RawFileFormatProperties", &g_define_type_info, 0);
		g_once_init_leave (&raw_file_format_properties_type_id__volatile, raw_file_format_properties_type_id);
	}
	return raw_file_format_properties_type_id__volatile;
}


RawSniffer* raw_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options) {
	RawSniffer* self = NULL;
	GFile* _tmp0_ = NULL;
	PhotoFileSnifferOptions _tmp1_ = 0;
#line 162 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 163 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = file;
#line 163 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = options;
#line 163 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = (RawSniffer*) photo_file_sniffer_construct (object_type, _tmp0_, _tmp1_);
#line 162 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self;
#line 1652 "RawSupport.c"
}


RawSniffer* raw_sniffer_new (GFile* file, PhotoFileSnifferOptions options) {
#line 162 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return raw_sniffer_construct (TYPE_RAW_SNIFFER, file, options);
#line 1659 "RawSupport.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self ? g_error_copy (self) : NULL;
#line 1666 "RawSupport.c"
}


static DetectedPhotoInformation* raw_sniffer_real_sniff (PhotoFileSniffer* base, gboolean* is_corrupted, GError** error) {
	RawSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	DetectedPhotoInformation* result = NULL;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp0_ = NULL;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp1_ = NULL;
	GRawProcessor* _tmp2_ = NULL;
	libraw_output_params_t* _tmp3_ = NULL;
	libraw_output_params_t* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp14_ = NULL;
	GRawProcessor* _tmp15_ = NULL;
	libraw_image_sizes_t _tmp16_ = {0};
	gushort _tmp17_ = 0U;
	GRawProcessor* _tmp18_ = NULL;
	libraw_image_sizes_t _tmp19_ = {0};
	gushort _tmp20_ = 0U;
	DetectedPhotoInformation* _tmp21_ = NULL;
	DetectedPhotoInformation* _tmp22_ = NULL;
	DetectedPhotoInformation* _tmp23_ = NULL;
	RawReader* reader = NULL;
	GFile* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	RawReader* _tmp27_ = NULL;
	RawReader* _tmp28_ = NULL;
	DetectedPhotoInformation* _tmp34_ = NULL;
	PhotoMetadata* _tmp35_ = NULL;
	gboolean _tmp58_ = FALSE;
	DetectedPhotoInformation* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	DetectedPhotoInformation* _tmp66_ = NULL;
	GError * _inner_error_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_SNIFFER, RawSniffer);
#line 168 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_vala_is_corrupted = FALSE;
#line 170 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = detected_photo_information_new ();
#line 170 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	detected = _tmp0_;
#line 172 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
#line 172 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	processor = _tmp1_;
#line 173 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = processor;
#line 173 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = graw_processor_get_output_params (_tmp2_);
#line 173 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = _tmp3_;
#line 173 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	(*_tmp4_).user_flip = (gint) GRAW_FLIP_NONE;
#line 1724 "RawSupport.c"
	{
		GRawProcessor* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GRawProcessor* _tmp9_ = NULL;
		GRawProcessor* _tmp10_ = NULL;
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp5_ = processor;
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp7_ = g_file_get_path (_tmp6_);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp8_ = _tmp7_;
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		graw_processor_open_file (_tmp5_, _tmp8_, &_inner_error_);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp8_);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 1748 "RawSupport.c"
				goto __catch29_graw_exception;
			}
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_clear_error (&_inner_error_);
#line 176 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return NULL;
#line 1761 "RawSupport.c"
		}
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp9_ = processor;
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		graw_processor_unpack (_tmp9_, &_inner_error_);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 1771 "RawSupport.c"
				goto __catch29_graw_exception;
			}
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_clear_error (&_inner_error_);
#line 177 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return NULL;
#line 1784 "RawSupport.c"
		}
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp10_ = processor;
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		graw_processor_adjust_sizes_info_only (_tmp10_, &_inner_error_);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (_inner_error_->domain == GRAW_EXCEPTION) {
#line 1794 "RawSupport.c"
				goto __catch29_graw_exception;
			}
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_clear_error (&_inner_error_);
#line 178 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return NULL;
#line 1807 "RawSupport.c"
		}
	}
	goto __finally29;
	__catch29_graw_exception:
	{
		GError* exception = NULL;
		GError* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		exception = _inner_error_;
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_inner_error_ = NULL;
#line 180 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp11_ = exception;
#line 180 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (g_error_matches (_tmp11_, GRAW_EXCEPTION, GRAW_EXCEPTION_UNSUPPORTED_FILE)) {
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = NULL;
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_error_free0 (exception);
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			if (is_corrupted) {
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				*is_corrupted = _vala_is_corrupted;
#line 1837 "RawSupport.c"
			}
#line 181 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 1841 "RawSupport.c"
		}
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp12_ = exception;
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp13_ = _g_error_copy0 (_tmp12_);
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_inner_error_ = _tmp13_;
#line 183 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_error_free0 (exception);
#line 1851 "RawSupport.c"
		goto __finally29;
	}
	__finally29:
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_detected_photo_information_unref0 (detected);
#line 175 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 1865 "RawSupport.c"
	}
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp14_ = detected;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp15_ = processor;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp16_ = graw_processor_get_sizes (_tmp15_);
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp17_ = _tmp16_.iwidth;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp18_ = processor;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp19_ = graw_processor_get_sizes (_tmp18_);
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp20_ = _tmp19_.iheight;
#line 186 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	dimensions_init (&_tmp14_->image_dim, (gint) _tmp17_, (gint) _tmp20_);
#line 187 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp21_ = detected;
#line 187 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp21_->colorspace = GDK_COLORSPACE_RGB;
#line 188 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp22_ = detected;
#line 188 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp22_->channels = 3;
#line 189 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp23_ = detected;
#line 189 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp23_->bits_per_channel = 8;
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp24_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp25_ = g_file_get_path (_tmp24_);
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp26_ = _tmp25_;
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp27_ = raw_reader_new (_tmp26_);
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp28_ = _tmp27_;
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp26_);
#line 191 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	reader = _tmp28_;
#line 1909 "RawSupport.c"
	{
		PhotoMetadata* _tmp29_ = NULL;
		RawReader* _tmp30_ = NULL;
		PhotoMetadata* _tmp31_ = NULL;
		DetectedPhotoInformation* _tmp32_ = NULL;
		PhotoMetadata* _tmp33_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp30_ = reader;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp31_ = photo_file_reader_read_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PHOTO_FILE_READER, PhotoFileReader), &_inner_error_);
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp29_ = _tmp31_;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1924 "RawSupport.c"
			goto __catch30_g_error;
		}
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp32_ = detected;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp33_ = _tmp29_;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp29_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_media_metadata_unref0 (_tmp32_->metadata);
#line 193 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp32_->metadata = _tmp33_;
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_media_metadata_unref0 (_tmp29_);
#line 1939 "RawSupport.c"
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* err = NULL;
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		err = _inner_error_;
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_inner_error_ = NULL;
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_error_free0 (err);
#line 1951 "RawSupport.c"
	}
	__finally30:
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_photo_file_adapter_unref0 (reader);
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_detected_photo_information_unref0 (detected);
#line 192 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 1966 "RawSupport.c"
	}
#line 198 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp34_ = detected;
#line 198 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp35_ = _tmp34_->metadata;
#line 198 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp35_ != NULL) {
#line 1974 "RawSupport.c"
		guint8* flattened_sans_thumbnail = NULL;
		DetectedPhotoInformation* _tmp36_ = NULL;
		PhotoMetadata* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		guint8* _tmp39_ = NULL;
		gint flattened_sans_thumbnail_length1 = 0;
		gint _flattened_sans_thumbnail_size_ = 0;
		gboolean _tmp40_ = FALSE;
		guint8* _tmp41_ = NULL;
		gint _tmp41__length1 = 0;
		guint8* flattened_thumbnail = NULL;
		DetectedPhotoInformation* _tmp47_ = NULL;
		PhotoMetadata* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		guint8* _tmp50_ = NULL;
		gint flattened_thumbnail_length1 = 0;
		gint _flattened_thumbnail_size_ = 0;
		gboolean _tmp51_ = FALSE;
		guint8* _tmp52_ = NULL;
		gint _tmp52__length1 = 0;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp36_ = detected;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp37_ = _tmp36_->metadata;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp39_ = photo_metadata_flatten_exif (_tmp37_, FALSE, &_tmp38_);
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		flattened_sans_thumbnail = _tmp39_;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		flattened_sans_thumbnail_length1 = _tmp38_;
#line 199 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_flattened_sans_thumbnail_size_ = flattened_sans_thumbnail_length1;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp41_ = flattened_sans_thumbnail;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp41__length1 = flattened_sans_thumbnail_length1;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (_tmp41_ != NULL) {
#line 2013 "RawSupport.c"
			guint8* _tmp42_ = NULL;
			gint _tmp42__length1 = 0;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp42_ = flattened_sans_thumbnail;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp42__length1 = flattened_sans_thumbnail_length1;
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp40_ = _tmp42__length1 > 0;
#line 2022 "RawSupport.c"
		} else {
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp40_ = FALSE;
#line 2026 "RawSupport.c"
		}
#line 200 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (_tmp40_) {
#line 2030 "RawSupport.c"
			DetectedPhotoInformation* _tmp43_ = NULL;
			guint8* _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			guint8* _tmp45_ = NULL;
			gint _tmp45__length1 = 0;
			gchar* _tmp46_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp43_ = detected;
#line 201 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp44_ = flattened_sans_thumbnail;
#line 201 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp44__length1 = flattened_sans_thumbnail_length1;
#line 201 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp45_ = flattened_sans_thumbnail;
#line 201 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp45__length1 = flattened_sans_thumbnail_length1;
#line 201 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp46_ = md5_binary (_tmp44_, (gsize) _tmp45__length1);
#line 201 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp43_->exif_md5);
#line 201 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp43_->exif_md5 = _tmp46_;
#line 2053 "RawSupport.c"
		}
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp47_ = detected;
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp48_ = _tmp47_->metadata;
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp50_ = photo_metadata_flatten_exif_preview (_tmp48_, &_tmp49_);
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		flattened_thumbnail = _tmp50_;
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		flattened_thumbnail_length1 = _tmp49_;
#line 203 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_flattened_thumbnail_size_ = flattened_thumbnail_length1;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp52_ = flattened_thumbnail;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp52__length1 = flattened_thumbnail_length1;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (_tmp52_ != NULL) {
#line 2073 "RawSupport.c"
			guint8* _tmp53_ = NULL;
			gint _tmp53__length1 = 0;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp53_ = flattened_thumbnail;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp53__length1 = flattened_thumbnail_length1;
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp51_ = _tmp53__length1 > 0;
#line 2082 "RawSupport.c"
		} else {
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp51_ = FALSE;
#line 2086 "RawSupport.c"
		}
#line 204 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (_tmp51_) {
#line 2090 "RawSupport.c"
			DetectedPhotoInformation* _tmp54_ = NULL;
			guint8* _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			guint8* _tmp56_ = NULL;
			gint _tmp56__length1 = 0;
			gchar* _tmp57_ = NULL;
#line 205 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp54_ = detected;
#line 205 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp55_ = flattened_thumbnail;
#line 205 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp55__length1 = flattened_thumbnail_length1;
#line 205 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp56_ = flattened_thumbnail;
#line 205 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp56__length1 = flattened_thumbnail_length1;
#line 205 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp57_ = md5_binary (_tmp55_, (gsize) _tmp56__length1);
#line 205 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp54_->thumbnail_md5);
#line 205 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp54_->thumbnail_md5 = _tmp57_;
#line 2113 "RawSupport.c"
		}
#line 198 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		flattened_thumbnail = (g_free (flattened_thumbnail), NULL);
#line 198 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		flattened_sans_thumbnail = (g_free (flattened_sans_thumbnail), NULL);
#line 2119 "RawSupport.c"
	}
#line 208 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp58_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 208 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp58_) {
#line 2125 "RawSupport.c"
		gchar* _tmp59_ = NULL;
		GFile* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		DetectedPhotoInformation* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp60_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp61_ = md5_file (_tmp60_, &_inner_error_);
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp59_ = _tmp61_;
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_photo_file_adapter_unref0 (reader);
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_graw_processor_unref0 (processor);
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_detected_photo_information_unref0 (detected);
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return NULL;
#line 2149 "RawSupport.c"
		}
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp62_ = detected;
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp63_ = _tmp59_;
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp59_ = NULL;
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp62_->md5);
#line 209 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp62_->md5 = _tmp63_;
#line 208 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp59_);
#line 2163 "RawSupport.c"
	}
#line 211 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp64_ = detected;
#line 211 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp65_ = g_strdup ("raw");
#line 211 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp64_->format_name);
#line 211 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp64_->format_name = _tmp65_;
#line 212 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp66_ = detected;
#line 212 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp66_->file_format = PHOTO_FILE_FORMAT_RAW;
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = detected;
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_photo_file_adapter_unref0 (reader);
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processor_unref0 (processor);
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (is_corrupted) {
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		*is_corrupted = _vala_is_corrupted;
#line 2187 "RawSupport.c"
	}
#line 214 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2191 "RawSupport.c"
}


static void raw_sniffer_class_init (RawSnifferClass * klass) {
#line 161 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_sniffer_parent_class = g_type_class_peek_parent (klass);
#line 161 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileSnifferClass *) klass)->sniff = raw_sniffer_real_sniff;
#line 2200 "RawSupport.c"
}


static void raw_sniffer_instance_init (RawSniffer * self) {
}


GType raw_sniffer_get_type (void) {
	static volatile gsize raw_sniffer_type_id__volatile = 0;
	if (g_once_init_enter (&raw_sniffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RawSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawSniffer), 0, (GInstanceInitFunc) raw_sniffer_instance_init, NULL };
		GType raw_sniffer_type_id;
		raw_sniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "RawSniffer", &g_define_type_info, 0);
		g_once_init_leave (&raw_sniffer_type_id__volatile, raw_sniffer_type_id);
	}
	return raw_sniffer_type_id__volatile;
}


RawReader* raw_reader_construct (GType object_type, const gchar* filepath) {
	RawReader* self = NULL;
	const gchar* _tmp0_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = filepath;
#line 220 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = (RawReader*) photo_file_reader_construct (object_type, _tmp0_, PHOTO_FILE_FORMAT_RAW);
#line 219 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return self;
#line 2231 "RawSupport.c"
}


RawReader* raw_reader_new (const gchar* filepath) {
#line 219 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return raw_reader_construct (TYPE_RAW_READER, filepath);
#line 2238 "RawSupport.c"
}


static PhotoMetadata* raw_reader_real_read_metadata (PhotoFileReader* base, GError** error) {
	RawReader * self;
	PhotoMetadata* result = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
#line 224 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = photo_metadata_new ();
#line 224 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	metadata = _tmp0_;
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = _tmp1_;
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp2_, &_inner_error_);
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_media_metadata_unref0 (metadata);
#line 225 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2272 "RawSupport.c"
	}
#line 227 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = metadata;
#line 227 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2278 "RawSupport.c"
}


static GdkPixbuf* raw_reader_real_unscaled_read (PhotoFileReader* base, GError** error) {
	RawReader * self;
	GdkPixbuf* result = NULL;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp0_ = NULL;
	GRawProcessor* _tmp1_ = NULL;
	GRawProcessor* _tmp2_ = NULL;
	libraw_output_params_t* _tmp3_ = NULL;
	libraw_output_params_t* _tmp4_ = NULL;
	GRawProcessor* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GRawProcessor* _tmp8_ = NULL;
	GRawProcessor* _tmp9_ = NULL;
	GRawProcessedImage* _tmp10_ = NULL;
	GRawProcessor* _tmp11_ = NULL;
	GRawProcessedImage* _tmp12_ = NULL;
	GRawProcessedImage* _tmp13_ = NULL;
	GRawProcessedImage* _tmp14_ = NULL;
	GdkPixbuf* _tmp15_ = NULL;
	GdkPixbuf* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
#line 231 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
#line 231 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	processor = _tmp0_;
#line 232 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = processor;
#line 232 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_configure_for_rgb_display (_tmp1_, FALSE);
#line 233 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = processor;
#line 233 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = graw_processor_get_output_params (_tmp2_);
#line 233 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = _tmp3_;
#line 233 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	(*_tmp4_).user_flip = (gint) GRAW_FLIP_NONE;
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp5_ = processor;
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp6_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp7_ = _tmp6_;
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_open_file (_tmp5_, _tmp7_, &_inner_error_);
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp7_);
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 235 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2340 "RawSupport.c"
	}
#line 236 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp8_ = processor;
#line 236 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_unpack (_tmp8_, &_inner_error_);
#line 236 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 236 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 236 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 236 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2354 "RawSupport.c"
	}
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp9_ = processor;
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_process (_tmp9_, &_inner_error_);
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 237 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2368 "RawSupport.c"
	}
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp11_ = processor;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp12_ = graw_processor_make_mem_image (_tmp11_, &_inner_error_);
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp10_ = _tmp12_;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2384 "RawSupport.c"
	}
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp13_ = _tmp10_;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp10_ = NULL;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp14_ = _tmp13_;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp15_ = graw_processed_image_get_pixbuf_copy (_tmp14_);
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp16_ = _tmp15_;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processed_image_unref0 (_tmp14_);
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp16_;
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processed_image_unref0 (_tmp10_);
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processor_unref0 (processor);
#line 239 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2406 "RawSupport.c"
}


static GdkPixbuf* raw_reader_real_scaled_read (PhotoFileReader* base, Dimensions* full, Dimensions* scaled, GError** error) {
	RawReader * self;
	GdkPixbuf* result = NULL;
	gdouble width_proportion = 0.0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gint _tmp3_ = 0;
	gdouble height_proportion = 0.0;
	Dimensions _tmp4_ = {0};
	gint _tmp5_ = 0;
	Dimensions _tmp6_ = {0};
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gdouble _tmp9_ = 0.0;
	gboolean half_size = FALSE;
	GRawProcessor* processor = NULL;
	GRawProcessor* _tmp11_ = NULL;
	GRawProcessor* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GRawProcessor* _tmp14_ = NULL;
	libraw_output_params_t* _tmp15_ = NULL;
	libraw_output_params_t* _tmp16_ = NULL;
	GRawProcessor* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GRawProcessor* _tmp20_ = NULL;
	GRawProcessor* _tmp21_ = NULL;
	GRawProcessedImage* image = NULL;
	GRawProcessor* _tmp22_ = NULL;
	GRawProcessedImage* _tmp23_ = NULL;
	GRawProcessedImage* _tmp24_ = NULL;
	GdkPixbuf* _tmp25_ = NULL;
	GdkPixbuf* _tmp26_ = NULL;
	Dimensions _tmp27_ = {0};
	GdkPixbuf* _tmp28_ = NULL;
	GdkPixbuf* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
#line 242 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RAW_READER, RawReader);
#line 242 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (full != NULL, NULL);
#line 242 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (scaled != NULL, NULL);
#line 243 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = *scaled;
#line 243 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _tmp0_.width;
#line 243 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = *full;
#line 243 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = _tmp2_.width;
#line 243 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	width_proportion = ((gdouble) _tmp1_) / ((gdouble) _tmp3_);
#line 244 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = *scaled;
#line 244 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp5_ = _tmp4_.height;
#line 244 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp6_ = *full;
#line 244 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp7_ = _tmp6_.height;
#line 244 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	height_proportion = ((gdouble) _tmp5_) / ((gdouble) _tmp7_);
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp9_ = width_proportion;
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp9_ < 0.5) {
#line 2478 "RawSupport.c"
		gdouble _tmp10_ = 0.0;
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp10_ = height_proportion;
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp8_ = _tmp10_ < 0.5;
#line 2484 "RawSupport.c"
	} else {
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp8_ = FALSE;
#line 2488 "RawSupport.c"
	}
#line 245 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	half_size = _tmp8_;
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp11_ = graw_processor_new (LIBRAW_OPTIONS_NONE);
#line 247 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	processor = _tmp11_;
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp12_ = processor;
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp13_ = half_size;
#line 248 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_configure_for_rgb_display (_tmp12_, _tmp13_);
#line 249 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp14_ = processor;
#line 249 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp15_ = graw_processor_get_output_params (_tmp14_);
#line 249 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp16_ = _tmp15_;
#line 249 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	(*_tmp16_).user_flip = (gint) GRAW_FLIP_NONE;
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp17_ = processor;
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp18_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp19_ = _tmp18_;
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_open_file (_tmp17_, _tmp19_, &_inner_error_);
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp19_);
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 251 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2528 "RawSupport.c"
	}
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp20_ = processor;
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_unpack (_tmp20_, &_inner_error_);
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 252 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2542 "RawSupport.c"
	}
#line 253 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp21_ = processor;
#line 253 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	graw_processor_process (_tmp21_, &_inner_error_);
#line 253 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 253 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 253 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 253 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2556 "RawSupport.c"
	}
#line 255 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp22_ = processor;
#line 255 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp23_ = graw_processor_make_mem_image (_tmp22_, &_inner_error_);
#line 255 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	image = _tmp23_;
#line 255 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 255 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 255 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_graw_processor_unref0 (processor);
#line 255 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 2572 "RawSupport.c"
	}
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp24_ = image;
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp25_ = graw_processed_image_get_pixbuf_copy (_tmp24_);
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp26_ = _tmp25_;
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp27_ = *scaled;
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp28_ = resize_pixbuf (_tmp26_, &_tmp27_, GDK_INTERP_BILINEAR);
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp29_ = _tmp28_;
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (_tmp26_);
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp29_;
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processed_image_unref0 (image);
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_graw_processor_unref0 (processor);
#line 257 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2596 "RawSupport.c"
}


static void raw_reader_class_init (RawReaderClass * klass) {
#line 218 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	raw_reader_parent_class = g_type_class_peek_parent (klass);
#line 218 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileReaderClass *) klass)->read_metadata = raw_reader_real_read_metadata;
#line 218 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileReaderClass *) klass)->unscaled_read = raw_reader_real_unscaled_read;
#line 218 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	((PhotoFileReaderClass *) klass)->scaled_read = raw_reader_real_scaled_read;
#line 2609 "RawSupport.c"
}


static void raw_reader_instance_init (RawReader * self) {
}


GType raw_reader_get_type (void) {
	static volatile gsize raw_reader_type_id__volatile = 0;
	if (g_once_init_enter (&raw_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RawReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) raw_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RawReader), 0, (GInstanceInitFunc) raw_reader_instance_init, NULL };
		GType raw_reader_type_id;
		raw_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "RawReader", &g_define_type_info, 0);
		g_once_init_leave (&raw_reader_type_id__volatile, raw_reader_type_id);
	}
	return raw_reader_type_id__volatile;
}


RawDeveloper* raw_developer_as_array (int* result_length1) {
	RawDeveloper* result = NULL;
	RawDeveloper* _tmp0_ = NULL;
	RawDeveloper* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = g_new0 (RawDeveloper, 3);
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_[0] = RAW_DEVELOPER_SHOTWELL;
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_[1] = RAW_DEVELOPER_CAMERA;
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_[2] = RAW_DEVELOPER_EMBEDDED;
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _tmp0_;
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1__length1 = 3;
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (result_length1) {
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		*result_length1 = _tmp1__length1;
#line 2650 "RawSupport.c"
	}
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = _tmp1_;
#line 268 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2656 "RawSupport.c"
}


gchar* raw_developer_to_string (RawDeveloper self) {
	gchar* result = NULL;
#line 272 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	switch (self) {
#line 272 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 2666 "RawSupport.c"
		{
			gchar* _tmp0_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp0_ = g_strdup ("SHOTWELL");
#line 274 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp0_;
#line 274 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2675 "RawSupport.c"
		}
#line 272 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_CAMERA:
#line 2679 "RawSupport.c"
		{
			gchar* _tmp1_ = NULL;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp1_ = g_strdup ("CAMERA");
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp1_;
#line 276 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2688 "RawSupport.c"
		}
#line 272 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 2692 "RawSupport.c"
		{
			gchar* _tmp2_ = NULL;
#line 278 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp2_ = g_strdup ("EMBEDDED");
#line 278 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp2_;
#line 278 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2701 "RawSupport.c"
		}
		default:
		{
#line 280 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_assert_not_reached ();
#line 2707 "RawSupport.c"
		}
	}
}


RawDeveloper raw_developer_from_string (const gchar* value) {
	RawDeveloper result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	static GQuark _tmp2_label0 = 0;
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	static GQuark _tmp2_label1 = 0;
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	static GQuark _tmp2_label2 = 0;
#line 284 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (value != NULL, 0);
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = value;
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = _tmp0_;
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("SHOTWELL")))) {
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		switch (0) {
#line 2736 "RawSupport.c"
			default:
			{
#line 287 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				result = RAW_DEVELOPER_SHOTWELL;
#line 287 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				return result;
#line 2743 "RawSupport.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("CAMERA")))) {
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		switch (0) {
#line 2749 "RawSupport.c"
			default:
			{
#line 289 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				result = RAW_DEVELOPER_CAMERA;
#line 289 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				return result;
#line 2756 "RawSupport.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("EMBEDDED")))) {
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		switch (0) {
#line 2762 "RawSupport.c"
			default:
			{
#line 291 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				result = RAW_DEVELOPER_EMBEDDED;
#line 291 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				return result;
#line 2769 "RawSupport.c"
			}
		}
	} else {
#line 285 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		switch (0) {
#line 2775 "RawSupport.c"
			default:
			{
#line 293 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
				g_assert_not_reached ();
#line 2780 "RawSupport.c"
			}
		}
	}
}


gchar* raw_developer_get_label (RawDeveloper self) {
	gchar* result = NULL;
#line 298 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	switch (self) {
#line 298 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 2793 "RawSupport.c"
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
#line 300 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp0_ = _ ("Shotwell");
#line 300 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp1_ = g_strdup (_tmp0_);
#line 300 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp1_;
#line 300 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2805 "RawSupport.c"
		}
#line 298 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_CAMERA:
#line 298 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 2811 "RawSupport.c"
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 303 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp2_ = _ ("Camera");
#line 303 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 303 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			result = _tmp3_;
#line 303 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			return result;
#line 2823 "RawSupport.c"
		}
		default:
		{
#line 305 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			g_assert_not_reached ();
#line 2829 "RawSupport.c"
		}
	}
}


gboolean raw_developer_is_equivalent (RawDeveloper self, RawDeveloper d) {
	gboolean result = FALSE;
	RawDeveloper _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 312 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = d;
#line 312 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (self == _tmp0_) {
#line 313 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		result = TRUE;
#line 313 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return result;
#line 2848 "RawSupport.c"
	}
#line 315 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (self == RAW_DEVELOPER_CAMERA) {
#line 2852 "RawSupport.c"
		RawDeveloper _tmp3_ = 0;
#line 315 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp3_ = d;
#line 315 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp2_ = _tmp3_ == RAW_DEVELOPER_EMBEDDED;
#line 2858 "RawSupport.c"
	} else {
#line 315 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp2_ = FALSE;
#line 2862 "RawSupport.c"
	}
#line 315 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp2_) {
#line 315 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp1_ = TRUE;
#line 2868 "RawSupport.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 316 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (self == RAW_DEVELOPER_EMBEDDED) {
#line 2873 "RawSupport.c"
			RawDeveloper _tmp5_ = 0;
#line 316 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp5_ = d;
#line 316 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp4_ = _tmp5_ == RAW_DEVELOPER_CAMERA;
#line 2879 "RawSupport.c"
		} else {
#line 316 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp4_ = FALSE;
#line 2883 "RawSupport.c"
		}
#line 316 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp1_ = _tmp4_;
#line 2887 "RawSupport.c"
	}
#line 315 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp1_) {
#line 317 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		result = TRUE;
#line 317 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return result;
#line 2895 "RawSupport.c"
	}
#line 319 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = FALSE;
#line 319 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 2901 "RawSupport.c"
}


BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self, const gchar* raw_filepath, const gchar* camera_development_filename, GError** error) {
	BackingPhotoRow* result = NULL;
	BackingPhotoRow* ns = NULL;
	BackingPhotoRow* _tmp0_ = NULL;
	GFile* master = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* name = NULL;
	gchar* ext = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* basename = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean c = FALSE;
	GFile* new_back = NULL;
	GFile* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
	GFile* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GFile* _tmp32_ = NULL;
	GFile* _tmp33_ = NULL;
	GFile* _tmp34_ = NULL;
	BackingPhotoRow* _tmp35_ = NULL;
	BackingPhotoRow* _tmp36_ = NULL;
	GFile* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
#line 324 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	g_return_val_if_fail (raw_filepath != NULL, NULL);
#line 326 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp0_ = backing_photo_row_new ();
#line 326 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	ns = _tmp0_;
#line 327 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp1_ = raw_filepath;
#line 327 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 327 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	master = _tmp2_;
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp3_ = master;
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp4_ = g_file_get_basename (_tmp3_);
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp5_ = _tmp4_;
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	disassemble_filename (_tmp5_, &_tmp6_, &_tmp7_);
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (name);
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	name = _tmp6_;
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (ext);
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	ext = _tmp7_;
#line 329 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp5_);
#line 335 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp8_ = camera_development_filename;
#line 335 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (_tmp8_ == NULL) {
#line 2970 "RawSupport.c"
		gchar* _tmp9_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		if (self != RAW_DEVELOPER_CAMERA) {
#line 2983 "RawSupport.c"
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp10_ = raw_developer_to_string (self);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp11_ = _tmp10_;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp13_ = _tmp12_;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp14_ = g_strconcat ("_", _tmp13_, NULL);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp9_);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp9_ = _tmp14_;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp13_);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp11_);
#line 3007 "RawSupport.c"
		} else {
			gchar* _tmp15_ = NULL;
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp15_ = g_strdup ("");
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_g_free0 (_tmp9_);
#line 337 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
			_tmp9_ = _tmp15_;
#line 3016 "RawSupport.c"
		}
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp16_ = name;
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp17_ = g_strconcat (_tmp16_, "_", NULL);
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp18_ = _tmp17_;
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp19_ = ext;
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp21_ = _tmp20_;
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp22_ = g_strconcat (_tmp21_, _tmp9_, NULL);
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp23_ = _tmp22_;
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp24_ = g_strconcat (_tmp23_, ".jpg", NULL);
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (basename);
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		basename = _tmp24_;
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp23_);
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp21_);
#line 336 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp18_);
#line 335 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (_tmp9_);
#line 3048 "RawSupport.c"
	} else {
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 339 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp25_ = camera_development_filename;
#line 339 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_tmp26_ = g_strdup (_tmp25_);
#line 339 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (basename);
#line 339 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		basename = _tmp26_;
#line 3060 "RawSupport.c"
	}
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp27_ = master;
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp28_ = g_file_get_parent (_tmp27_);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp29_ = _tmp28_;
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp30_ = basename;
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp32_ = generate_unique_file (_tmp29_, _tmp30_, &_tmp31_, &_inner_error_);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	c = _tmp31_;
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp33_ = _tmp32_;
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (_tmp29_);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	new_back = _tmp33_;
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (basename);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (ext);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (name);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_object_unref0 (master);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_backing_photo_row_unref0 (ns);
#line 343 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 3096 "RawSupport.c"
	}
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp34_ = new_back;
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	claim_file (_tmp34_, &_inner_error_);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_object_unref0 (new_back);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (basename);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (ext);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_free0 (name);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_g_object_unref0 (master);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		_backing_photo_row_unref0 (ns);
#line 344 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
		return NULL;
#line 3120 "RawSupport.c"
	}
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp35_ = ns;
#line 345 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp35_->file_format = PHOTO_FILE_FORMAT_JFIF;
#line 346 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_ = ns;
#line 346 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp37_ = new_back;
#line 346 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp38_ = g_file_get_path (_tmp37_);
#line 346 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (_tmp36_->filepath);
#line 346 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_tmp36_->filepath = _tmp38_;
#line 348 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	result = ns;
#line 348 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (new_back);
#line 348 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (basename);
#line 348 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (ext);
#line 348 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_free0 (name);
#line 348 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	_g_object_unref0 (master);
#line 348 "/home/jens/Source/shotwell/src/photos/RawSupport.vala"
	return result;
#line 3150 "RawSupport.c"
}


GType raw_developer_get_type (void) {
	static volatile gsize raw_developer_type_id__volatile = 0;
	if (g_once_init_enter (&raw_developer_type_id__volatile)) {
		static const GEnumValue values[] = {{RAW_DEVELOPER_SHOTWELL, "RAW_DEVELOPER_SHOTWELL", "shotwell"}, {RAW_DEVELOPER_CAMERA, "RAW_DEVELOPER_CAMERA", "camera"}, {RAW_DEVELOPER_EMBEDDED, "RAW_DEVELOPER_EMBEDDED", "embedded"}, {0, NULL, NULL}};
		GType raw_developer_type_id;
		raw_developer_type_id = g_enum_register_static ("RawDeveloper", values);
		g_once_init_leave (&raw_developer_type_id__volatile, raw_developer_type_id);
	}
	return raw_developer_type_id__volatile;
}



