/* Thumbnail.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from Thumbnail.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gee.h>
#include <pango/pango.h>
#include <time.h>


#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_MEDIA_SOURCE_ITEM (media_source_item_get_type ())
#define MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem))
#define MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))
#define IS_MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_ITEM))
#define IS_MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_ITEM))
#define MEDIA_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))

typedef struct _MediaSourceItem MediaSourceItem;
typedef struct _MediaSourceItemClass MediaSourceItemClass;
typedef struct _MediaSourceItemPrivate MediaSourceItemPrivate;

#define TYPE_THUMBNAIL (thumbnail_get_type ())
#define THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL, Thumbnail))
#define THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL, ThumbnailClass))
#define IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL))
#define IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL))
#define THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL, ThumbnailClass))

typedef struct _Thumbnail Thumbnail;
typedef struct _ThumbnailClass ThumbnailClass;
typedef struct _ThumbnailPrivate ThumbnailPrivate;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_RATING (rating_get_type ())

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _MediaSourceItem {
	CheckerboardItem parent_instance;
	MediaSourceItemPrivate * priv;
};

struct _MediaSourceItemClass {
	CheckerboardItemClass parent_class;
};

struct _Thumbnail {
	MediaSourceItem parent_instance;
	ThumbnailPrivate * priv;
};

struct _ThumbnailClass {
	MediaSourceItemClass parent_class;
};

struct _ThumbnailPrivate {
	MediaSource* media;
	gint scale;
	Dimensions original_dim;
	Dimensions dim;
	GdkPixbuf* unscaled_pixbuf;
	GCancellable* cancellable;
	gboolean hq_scheduled;
	gboolean hq_reschedule;
	gboolean exposure;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, void* user_data);
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};


static gpointer thumbnail_parent_class = NULL;
extern TagSourceCollection* tag_global;

GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType media_source_item_get_type (void) G_GNUC_CONST;
GType thumbnail_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
#define THUMBNAIL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THUMBNAIL, ThumbnailPrivate))
enum  {
	THUMBNAIL_DUMMY_PROPERTY
};
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType container_source_get_type (void) G_GNUC_CONST;
static void thumbnail_on_tag_contents_altered (Thumbnail* self, ContainerSource* container, GeeCollection* added, gboolean relinking, GeeCollection* removed, gboolean unlinking);
static void _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked, gpointer self);
static void thumbnail_on_tags_altered (Thumbnail* self, GeeMap* altered);
static void _thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self);
#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define THUMBNAIL_PROP_SHOW_TAGS CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES
#define THUMBNAIL_PROP_SIZE "thumbnail-size"
#define THUMBNAIL_PROP_SHOW_RATINGS "show-ratings"
#define THUMBNAIL_LOW_QUALITY_INTERP GDK_INTERP_NEAREST
#define THUMBNAIL_HIGH_QUALITY_INTERP GDK_INTERP_BILINEAR
#define THUMBNAIL_HQ_IMPROVEMENT_MSEC 100
Thumbnail* thumbnail_new (MediaSource* media, gint scale);
Thumbnail* thumbnail_construct (GType object_type, MediaSource* media, gint scale);
GType photo_exception_get_type (void) G_GNUC_CONST;
void media_source_get_dimensions (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
void dimensions_get_scaled (Dimensions *self, gint scale, gboolean scale_up, Dimensions* result);
gchar* data_object_get_name (DataObject* self);
gchar* media_source_get_comment (MediaSource* self);
MediaSourceItem* media_source_item_new (ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
MediaSourceItem* media_source_item_construct (GType object_type, ThumbnailSource* source, Dimensions* initial_pixbuf_dim, const gchar* title, const gchar* comment, gboolean marked_up, PangoAlignment alignment);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
void media_source_item_set_enable_sprockets (MediaSourceItem* self, gboolean enable_sprockets);
static void thumbnail_update_title (Thumbnail* self, gboolean init);
static void thumbnail_update_comment (Thumbnail* self, gboolean init);
static void thumbnail_update_tags (Thumbnail* self, gboolean init);
GType tag_get_type (void) G_GNUC_CONST;
GeeSortedSet* tag_source_collection_fetch_sorted_for_source (TagSourceCollection* self, MediaSource* photo);
void checkerboard_item_clear_subtitle (CheckerboardItem* self);
void checkerboard_item_set_subtitle (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
gchar* tag_make_tag_string (GeeCollection* tags, const gchar* start, const gchar* separator, const gchar* end, gboolean escape);
gboolean tag_contains (Tag* self, MediaSource* source);
gboolean is_string_empty (const gchar* s);
void checkerboard_item_clear_title (CheckerboardItem* self);
void media_source_item_set_title (MediaSourceItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
void checkerboard_item_clear_comment (CheckerboardItem* self);
void checkerboard_item_set_comment (CheckerboardItem* self, const gchar* text, gboolean marked_up, PangoAlignment alignment);
static void thumbnail_real_notify_altered (DataObject* base, Alteration* alteration);
gboolean alteration_has_detail (Alteration* self, const gchar* subject, const gchar* detail);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
MediaSource* thumbnail_get_media_source (Thumbnail* self);
gint64 thumbnail_photo_id_ascending_comparator (void* a, void* b);
gint64 data_source_get_instance_id (DataSource* self);
gint64 thumbnail_photo_id_descending_comparator (void* a, void* b);
gint64 thumbnail_title_ascending_comparator (void* a, void* b);
gchar* media_source_item_get_natural_collation_key (MediaSourceItem* self);
gint64 thumbnail_title_descending_comparator (void* a, void* b);
gboolean thumbnail_title_comparator_predicate (DataObject* object, Alteration* alteration);
gint64 thumbnail_exposure_time_ascending_comparator (void* a, void* b);
time_t media_source_get_exposure_time (MediaSource* self);
gint64 thumbnail_filename_ascending_comparator (void* a, void* b);
gint64 thumbnail_exposure_time_desending_comparator (void* a, void* b);
gint64 thumbnail_filename_descending_comparator (void* a, void* b);
gboolean thumbnail_exposure_time_comparator_predicate (DataObject* object, Alteration* alteration);
gboolean thumbnail_filename_comparator_predicate (DataObject* object, Alteration* alteration);
GFile* media_source_get_file (MediaSource* self);
gchar* g_utf8_collate_key_for_filename (const gchar* str, gssize len);
gint64 thumbnail_rating_ascending_comparator (void* a, void* b);
GType rating_get_type (void) G_GNUC_CONST;
Rating media_source_get_rating (MediaSource* self);
gint64 thumbnail_rating_descending_comparator (void* a, void* b);
gboolean thumbnail_rating_comparator_predicate (DataObject* object, Alteration* alteration);
static void thumbnail_real_thumbnail_altered (ThumbnailView* base);
static void thumbnail_delayed_high_quality_fetch (Thumbnail* self);
static void thumbnail_paint_empty (Thumbnail* self);
static void thumbnail_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val);
static void thumbnail_resize (Thumbnail* self, gint new_scale);
void data_view_notify_view_altered (DataView* self);
void data_object_notify_collection_property_set (DataObject* self, const gchar* name, GValue* old, GValue* val);
gint thumbnail_get_MIN_SCALE (void);
gint thumbnail_get_MAX_SCALE (void);
static void thumbnail_cancel_async_fetch (Thumbnail* self);
gboolean checkerboard_item_has_image (CheckerboardItem* self);
GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
void checkerboard_item_set_image (CheckerboardItem* self, GdkPixbuf* pixbuf);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
void checkerboard_item_clear_image (CheckerboardItem* self, Dimensions* dim);
static void thumbnail_schedule_low_quality_fetch (Thumbnail* self);
void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source, gint scale, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
static void thumbnail_on_low_quality_fetched (Thumbnail* self, GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err);
static void _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self);
static gboolean thumbnail_on_schedule_high_quality (Thumbnail* self);
static gboolean _thumbnail_on_schedule_high_quality_gsource_func (gpointer self);
static void thumbnail_on_high_quality_fetched (Thumbnail* self, GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err);
static void _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self);
gchar* data_object_to_string (DataObject* self);
static void thumbnail_real_exposed (CheckerboardItem* base);
void checkerboard_item_exposed (CheckerboardItem* self);
static void thumbnail_real_unexposed (CheckerboardItem* base);
void checkerboard_item_unexposed (CheckerboardItem* self);
static GdkPixbuf* thumbnail_real_get_top_right_trinket (CheckerboardItem* base, gint scale);
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
GdkPixbuf* resources_get_icon (const gchar* name, gint scale);
#define RESOURCES_ICON_FLAGGED_TRINKET "flag-trinket.png"
#define RESOURCES_DEFAULT_ICON_SCALE 24
static GdkPixbuf* thumbnail_real_get_bottom_left_trinket (CheckerboardItem* base, gint scale);
GValue* data_object_get_collection_property (DataObject* self, const gchar* name, GValue* def);
static void _vala_GValue_free (GValue* self);
GdkPixbuf* resources_get_rating_trinket (Rating rating, gint scale);
gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
gint thumbnail_get_DEFAULT_SCALE (void);
static void thumbnail_finalize (GObject* obj);
static void _vala_thumbnail_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered (ContainerSourceCollection* _sender, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked, gpointer self) {
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_tag_contents_altered ((Thumbnail*) self, container, added, relinked, removed, unlinked);
#line 587 "Thumbnail.c"
}


static void _thumbnail_on_tags_altered_data_collection_items_altered (DataCollection* _sender, GeeMap* items, gpointer self) {
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_tags_altered ((Thumbnail*) self, items);
#line 594 "Thumbnail.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return self ? g_object_ref (self) : NULL;
#line 601 "Thumbnail.c"
}


Thumbnail* thumbnail_construct (GType object_type, MediaSource* media, gint scale) {
	Thumbnail * self = NULL;
	MediaSource* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	Dimensions _tmp2_ = {0};
	gint _tmp3_ = 0;
	Dimensions _tmp4_ = {0};
	MediaSource* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	MediaSource* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	MediaSource* _tmp11_ = NULL;
	MediaSource* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	TagSourceCollection* _tmp14_ = NULL;
	TagSourceCollection* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	MediaSource* _tmp17_ = NULL;
	MediaSource* _tmp19_ = NULL;
	MediaSource* _tmp20_ = NULL;
	Dimensions _tmp21_ = {0};
	gint _tmp22_ = 0;
	Dimensions _tmp23_ = {0};
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (media), NULL);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = media;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (_tmp1_, PHOTO_EXCEPTION_NONE, &_tmp2_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = scale;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&_tmp2_, _tmp3_, TRUE, &_tmp4_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = media;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_OBJECT, DataObject));
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _tmp6_;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = media;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = media_source_get_comment (_tmp8_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp10_ = _tmp9_;
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = (Thumbnail*) media_source_item_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), &_tmp4_, _tmp7_, _tmp10_, FALSE, PANGO_ALIGN_LEFT);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp10_);
#line 50 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp7_);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp11_ = media;
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->media);
#line 53 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->media = _tmp12_;
#line 54 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp13_ = scale;
#line 54 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->scale = _tmp13_;
#line 56 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp14_ = tag_global;
#line 56 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), "container-contents-altered", (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self, 0);
#line 57 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp15_ = tag_global;
#line 57 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_DATA_COLLECTION, DataCollection), "items-altered", (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self, 0);
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp17_ = media;
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, TYPE_LIBRARY_PHOTO)) {
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp16_ = TRUE;
#line 686 "Thumbnail.c"
	} else {
		MediaSource* _tmp18_ = NULL;
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp18_ = media;
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, TYPE_VIDEO);
#line 693 "Thumbnail.c"
	}
#line 59 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (_tmp16_, "(media is LibraryPhoto) || (media is Video)");
#line 60 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp19_ = media;
#line 60 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_item_set_enable_sprockets (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, TYPE_VIDEO));
#line 62 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp20_ = media;
#line 62 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (_tmp20_, PHOTO_EXCEPTION_NONE, &_tmp21_);
#line 62 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->original_dim = _tmp21_;
#line 63 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp22_ = scale;
#line 63 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, _tmp22_, TRUE, &_tmp23_);
#line 63 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp23_;
#line 67 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_title (self, TRUE);
#line 68 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_comment (self, TRUE);
#line 69 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_tags (self, TRUE);
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return self;
#line 721 "Thumbnail.c"
}


Thumbnail* thumbnail_new (MediaSource* media, gint scale) {
#line 49 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return thumbnail_construct (TYPE_THUMBNAIL, media, scale);
#line 728 "Thumbnail.c"
}


static void thumbnail_update_tags (Thumbnail* self, gboolean init) {
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	GeeSortedSet* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp4_ = NULL;
#line 80 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = tag_global;
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->media;
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = tag_source_collection_fetch_sorted_for_source (_tmp0_, _tmp1_);
#line 81 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = tags;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ == NULL) {
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = TRUE;
#line 755 "Thumbnail.c"
	} else {
		GeeCollection* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = tags;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = gee_collection_get_size (_tmp5_);
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = _tmp6_;
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp7_ == 0;
#line 768 "Thumbnail.c"
	}
#line 82 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 83 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_subtitle (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 774 "Thumbnail.c"
	} else {
		gboolean _tmp8_ = FALSE;
#line 84 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = init;
#line 84 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (!_tmp8_) {
#line 781 "Thumbnail.c"
			GeeCollection* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp9_ = tags;
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp10_ = tag_make_tag_string (_tmp9_, "<small>", ", ", "</small>", TRUE);
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp11_ = _tmp10_;
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_subtitle (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp11_, TRUE, PANGO_ALIGN_LEFT);
#line 85 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_free0 (_tmp11_);
#line 795 "Thumbnail.c"
		} else {
#line 87 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_subtitle (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), "<small>.</small>", TRUE, PANGO_ALIGN_LEFT);
#line 799 "Thumbnail.c"
		}
	}
#line 80 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (tags);
#line 804 "Thumbnail.c"
}


static void thumbnail_on_tag_contents_altered (Thumbnail* self, ContainerSource* container, GeeCollection* added, gboolean relinking, GeeCollection* removed, gboolean unlinking) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GeeCollection* _tmp2_ = NULL;
	gboolean tag_added = FALSE;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_ = NULL;
	gboolean tag_removed = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
#line 90 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 90 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
#line 90 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 90 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 92 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->exposure;
#line 92 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!_tmp0_) {
#line 93 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 832 "Thumbnail.c"
	}
#line 95 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = added;
#line 95 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp2_ != NULL) {
#line 838 "Thumbnail.c"
		GeeCollection* _tmp3_ = NULL;
		MediaSource* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 95 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = added;
#line 95 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = self->priv->media;
#line 95 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = gee_collection_contains (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_SOURCE, DataSource));
#line 95 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = _tmp5_;
#line 850 "Thumbnail.c"
	} else {
#line 95 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = FALSE;
#line 854 "Thumbnail.c"
	}
#line 95 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tag_added = _tmp1_;
#line 96 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = removed;
#line 96 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp7_ != NULL) {
#line 862 "Thumbnail.c"
		GeeCollection* _tmp8_ = NULL;
		MediaSource* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 96 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = removed;
#line 96 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = self->priv->media;
#line 96 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = gee_collection_contains (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_SOURCE, DataSource));
#line 96 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp10_;
#line 874 "Thumbnail.c"
	} else {
#line 96 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = FALSE;
#line 878 "Thumbnail.c"
	}
#line 96 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	tag_removed = _tmp6_;
#line 99 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp12_ = tag_added;
#line 99 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp12_) {
#line 99 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = TRUE;
#line 888 "Thumbnail.c"
	} else {
		gboolean _tmp13_ = FALSE;
#line 99 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp13_ = tag_removed;
#line 99 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = _tmp13_;
#line 895 "Thumbnail.c"
	}
#line 99 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp11_) {
#line 100 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_tags (self, FALSE);
#line 901 "Thumbnail.c"
	}
}


static void thumbnail_on_tags_altered (Thumbnail* self, GeeMap* altered) {
	gboolean _tmp0_ = FALSE;
#line 103 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 103 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (GEE_IS_MAP (altered));
#line 104 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->exposure;
#line 104 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!_tmp0_) {
#line 105 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 918 "Thumbnail.c"
	}
	{
		GeeIterator* _object_it = NULL;
		GeeMap* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeSet* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = altered;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = gee_map_get_keys (_tmp1_);
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp2_;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _tmp3_;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ITERABLE, GeeIterable));
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp5_;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp4_);
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_object_it = _tmp6_;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		while (TRUE) {
#line 946 "Thumbnail.c"
			GeeIterator* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
			Tag* tag = NULL;
			DataObject* _tmp11_ = NULL;
			Tag* _tmp12_ = NULL;
			Tag* _tmp13_ = NULL;
			MediaSource* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp7_ = _object_it;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp8_ = gee_iterator_next (_tmp7_);
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (!_tmp8_) {
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 966 "Thumbnail.c"
			}
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp9_ = _object_it;
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp10_ = gee_iterator_get (_tmp9_);
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			object = (DataObject*) _tmp10_;
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp11_ = object;
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_TAG, Tag));
#line 108 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			tag = _tmp12_;
#line 110 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp13_ = tag;
#line 110 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp14_ = self->priv->media;
#line 110 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp15_ = tag_contains (_tmp13_, _tmp14_);
#line 110 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (_tmp15_) {
#line 111 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				thumbnail_update_tags (self, FALSE);
#line 113 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (tag);
#line 113 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (object);
#line 113 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 996 "Thumbnail.c"
			}
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (tag);
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (object);
#line 1002 "Thumbnail.c"
		}
#line 107 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_object_it);
#line 1006 "Thumbnail.c"
	}
}


static void thumbnail_update_title (Thumbnail* self, gboolean init) {
	gchar* title = NULL;
	MediaSource* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 118 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 119 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 119 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject));
#line 119 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	title = _tmp1_;
#line 120 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = title;
#line 120 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 120 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 121 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1033 "Thumbnail.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 122 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = init;
#line 122 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (!_tmp4_) {
#line 1040 "Thumbnail.c"
			const gchar* _tmp5_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp5_ = title;
#line 123 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			media_source_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), _tmp5_, FALSE, PANGO_ALIGN_LEFT);
#line 1046 "Thumbnail.c"
		} else {
#line 125 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			media_source_item_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), "", FALSE, PANGO_ALIGN_LEFT);
#line 1050 "Thumbnail.c"
		}
	}
#line 118 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (title);
#line 1055 "Thumbnail.c"
}


static void thumbnail_update_comment (Thumbnail* self, gboolean init) {
	gchar* comment = NULL;
	MediaSource* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 128 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 129 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 129 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media_source_get_comment (_tmp0_);
#line 129 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	comment = _tmp1_;
#line 130 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = comment;
#line 130 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 130 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 131 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 1081 "Thumbnail.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 132 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = init;
#line 132 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (!_tmp4_) {
#line 1088 "Thumbnail.c"
			const gchar* _tmp5_ = NULL;
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp5_ = comment;
#line 133 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp5_, FALSE, PANGO_ALIGN_LEFT);
#line 1094 "Thumbnail.c"
		} else {
#line 135 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), "", FALSE, PANGO_ALIGN_LEFT);
#line 1098 "Thumbnail.c"
		}
	}
#line 128 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (comment);
#line 1103 "Thumbnail.c"
}


static void thumbnail_real_notify_altered (DataObject* base, Alteration* alteration) {
	Thumbnail * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Alteration* _tmp8_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 138 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_ALTERATION (alteration));
#line 139 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->exposure;
#line 139 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp1_) {
#line 1122 "Thumbnail.c"
		Alteration* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 139 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = alteration;
#line 139 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = alteration_has_detail (_tmp2_, "metadata", "name");
#line 139 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = _tmp3_;
#line 1131 "Thumbnail.c"
	} else {
#line 139 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp0_ = FALSE;
#line 1135 "Thumbnail.c"
	}
#line 139 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 140 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_title (self, FALSE);
#line 1141 "Thumbnail.c"
	}
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = self->priv->exposure;
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp5_) {
#line 1147 "Thumbnail.c"
		Alteration* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = alteration;
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = alteration_has_detail (_tmp6_, "metadata", "comment");
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = _tmp7_;
#line 1156 "Thumbnail.c"
	} else {
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = FALSE;
#line 1160 "Thumbnail.c"
	}
#line 141 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_) {
#line 142 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_update_comment (self, FALSE);
#line 1166 "Thumbnail.c"
	}
#line 144 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = alteration;
#line 144 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_DATA_OBJECT, DataObject), _tmp8_);
#line 1172 "Thumbnail.c"
}


MediaSource* thumbnail_get_media_source (Thumbnail* self) {
	MediaSource* result = NULL;
	MediaSource* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_THUMBNAIL (self), NULL);
#line 148 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 148 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 148 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 148 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1190 "Thumbnail.c"
}


gint64 thumbnail_photo_id_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	void* _tmp3_ = NULL;
	MediaSource* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
#line 156 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = a;
#line 156 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp0_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 156 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_SOURCE, DataSource));
#line 156 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = b;
#line 156 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp3_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 156 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_SOURCE, DataSource));
#line 156 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp2_ - _tmp5_;
#line 156 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1218 "Thumbnail.c"
}


gint64 thumbnail_photo_id_descending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
#line 160 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 160 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 160 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_photo_id_ascending_comparator (_tmp0_, _tmp1_);
#line 160 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp2_;
#line 160 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1237 "Thumbnail.c"
}


gint64 thumbnail_title_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	GCompareFunc _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	void* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = g_strcmp0;
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = media_source_item_get_natural_collation_key (G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp1_, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem));
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = _tmp2_;
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = b;
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = media_source_item_get_natural_collation_key (G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp4_, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem));
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = _tmp5_;
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _tmp0_ (_tmp3_, _tmp6_);
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = (gint64) _tmp7_;
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp6_);
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp3_);
#line 164 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp8_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp10_ = _result_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp10_ != ((gint64) 0)) {
#line 1283 "Thumbnail.c"
		gint64 _tmp11_ = 0LL;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = _result_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = _tmp11_;
#line 1289 "Thumbnail.c"
	} else {
		void* _tmp12_ = NULL;
		void* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp12_ = a;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp13_ = b;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp14_ = thumbnail_photo_id_ascending_comparator (_tmp12_, _tmp13_);
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = _tmp14_;
#line 1302 "Thumbnail.c"
	}
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp9_;
#line 165 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1308 "Thumbnail.c"
}


gint64 thumbnail_title_descending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_title_ascending_comparator (_tmp0_, _tmp1_);
#line 169 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_;
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _result_;
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != ((gint64) 0)) {
#line 1332 "Thumbnail.c"
		gint64 _tmp5_ = 0LL;
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _result_;
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp5_;
#line 1338 "Thumbnail.c"
	} else {
		void* _tmp6_ = NULL;
		void* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = a;
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = b;
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = thumbnail_photo_id_descending_comparator (_tmp6_, _tmp7_);
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp8_;
#line 1351 "Thumbnail.c"
	}
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp3_;
#line 171 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1357 "Thumbnail.c"
}


gboolean thumbnail_title_comparator_predicate (DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	Alteration* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 174 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 174 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = alteration;
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "title");
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 175 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1377 "Thumbnail.c"
}


gint64 thumbnail_exposure_time_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 time_a = 0LL;
	void* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	time_t _tmp2_ = 0;
	gint64 time_b = 0LL;
	void* _tmp3_ = NULL;
	MediaSource* _tmp4_ = NULL;
	time_t _tmp5_ = 0;
	gint64 _result_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
#line 179 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = a;
#line 179 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp0_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 179 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = media_source_get_exposure_time (_tmp1_);
#line 179 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	time_a = (gint64) _tmp2_;
#line 180 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = b;
#line 180 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp3_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 180 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = media_source_get_exposure_time (_tmp4_);
#line 180 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	time_b = (gint64) _tmp5_;
#line 181 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = time_a;
#line 181 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = time_b;
#line 181 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp6_ - _tmp7_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = _result_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp9_ != ((gint64) 0)) {
#line 1422 "Thumbnail.c"
		gint64 _tmp10_ = 0LL;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = _result_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = _tmp10_;
#line 1428 "Thumbnail.c"
	} else {
		void* _tmp11_ = NULL;
		void* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = a;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp12_ = b;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp13_ = thumbnail_filename_ascending_comparator (_tmp11_, _tmp12_);
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = _tmp13_;
#line 1441 "Thumbnail.c"
	}
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp8_;
#line 183 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1447 "Thumbnail.c"
}


gint64 thumbnail_exposure_time_desending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_exposure_time_ascending_comparator (_tmp0_, _tmp1_);
#line 187 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_;
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _result_;
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != ((gint64) 0)) {
#line 1471 "Thumbnail.c"
		gint64 _tmp5_ = 0LL;
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _result_;
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp5_;
#line 1477 "Thumbnail.c"
	} else {
		void* _tmp6_ = NULL;
		void* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = a;
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = b;
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = thumbnail_filename_descending_comparator (_tmp6_, _tmp7_);
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp8_;
#line 1490 "Thumbnail.c"
	}
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp3_;
#line 189 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1496 "Thumbnail.c"
}


gboolean thumbnail_exposure_time_comparator_predicate (DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	Alteration* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 192 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 192 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 193 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = alteration;
#line 193 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "exposure-time");
#line 193 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 193 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1516 "Thumbnail.c"
}


gboolean thumbnail_filename_comparator_predicate (DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	Alteration* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 196 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 197 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = alteration;
#line 197 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "filename");
#line 197 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 197 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1536 "Thumbnail.c"
}


gint64 thumbnail_filename_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gchar* path_a = NULL;
	void* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* path_b = NULL;
	void* _tmp8_ = NULL;
	MediaSource* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gint64 _result_ = 0LL;
	GCompareFunc _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint64 _tmp24_ = 0LL;
	gint64 _tmp25_ = 0LL;
	gint64 _tmp26_ = 0LL;
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = a;
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp0_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = media_source_get_file (_tmp1_);
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = _tmp2_;
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = g_file_get_basename (_tmp3_);
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = _tmp4_;
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = g_utf8_strdown (_tmp5_, (gssize) -1);
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _tmp6_;
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp5_);
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (_tmp3_);
#line 201 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	path_a = _tmp7_;
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = b;
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp8_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp10_ = media_source_get_file (_tmp9_);
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp11_ = _tmp10_;
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp12_ = g_file_get_basename (_tmp11_);
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp13_ = _tmp12_;
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp15_ = _tmp14_;
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp13_);
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (_tmp11_);
#line 202 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	path_b = _tmp15_;
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp16_ = g_strcmp0;
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp17_ = path_a;
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp18_ = g_utf8_collate_key_for_filename (_tmp17_, (gssize) -1);
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp19_ = _tmp18_;
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp20_ = path_b;
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp21_ = g_utf8_collate_key_for_filename (_tmp20_, (gssize) -1);
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp22_ = _tmp21_;
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp23_ = _tmp16_ (_tmp19_, _tmp22_);
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp24_ = (gint64) _tmp23_;
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp22_);
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (_tmp19_);
#line 204 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp24_;
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp26_ = _result_;
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp26_ != ((gint64) 0)) {
#line 1644 "Thumbnail.c"
		gint64 _tmp27_ = 0LL;
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp27_ = _result_;
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp25_ = _tmp27_;
#line 1650 "Thumbnail.c"
	} else {
		void* _tmp28_ = NULL;
		void* _tmp29_ = NULL;
		gint64 _tmp30_ = 0LL;
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp28_ = a;
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp29_ = b;
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp30_ = thumbnail_photo_id_ascending_comparator (_tmp28_, _tmp29_);
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp25_ = _tmp30_;
#line 1663 "Thumbnail.c"
	}
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp25_;
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (path_b);
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_free0 (path_a);
#line 206 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1673 "Thumbnail.c"
}


gint64 thumbnail_filename_descending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 210 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 210 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 210 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_filename_ascending_comparator (_tmp0_, _tmp1_);
#line 210 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_;
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _result_;
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != ((gint64) 0)) {
#line 1697 "Thumbnail.c"
		gint64 _tmp5_ = 0LL;
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _result_;
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp5_;
#line 1703 "Thumbnail.c"
	} else {
		void* _tmp6_ = NULL;
		void* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = a;
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = b;
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = thumbnail_photo_id_descending_comparator (_tmp6_, _tmp7_);
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp8_;
#line 1716 "Thumbnail.c"
	}
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp3_;
#line 212 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1722 "Thumbnail.c"
}


gint64 thumbnail_rating_ascending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	Rating _tmp2_ = 0;
	void* _tmp3_ = NULL;
	MediaSource* _tmp4_ = NULL;
	Rating _tmp5_ = 0;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
#line 216 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = a;
#line 216 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp0_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 216 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = media_source_get_rating (_tmp1_);
#line 216 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = b;
#line 216 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST ((Thumbnail*) _tmp3_, TYPE_THUMBNAIL, Thumbnail)->priv->media;
#line 216 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = media_source_get_rating (_tmp4_);
#line 216 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = (gint64) (_tmp2_ - _tmp5_);
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = _result_;
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp7_ != ((gint64) 0)) {
#line 1755 "Thumbnail.c"
		gint64 _tmp8_ = 0LL;
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = _result_;
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp8_;
#line 1761 "Thumbnail.c"
	} else {
		void* _tmp9_ = NULL;
		void* _tmp10_ = NULL;
		gint64 _tmp11_ = 0LL;
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = a;
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = b;
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = thumbnail_photo_id_ascending_comparator (_tmp9_, _tmp10_);
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp11_;
#line 1774 "Thumbnail.c"
	}
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp6_;
#line 218 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1780 "Thumbnail.c"
}


gint64 thumbnail_rating_descending_comparator (void* a, void* b) {
	gint64 result = 0LL;
	gint64 _result_ = 0LL;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
#line 222 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = b;
#line 222 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = a;
#line 222 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = thumbnail_rating_ascending_comparator (_tmp0_, _tmp1_);
#line 222 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_result_ = _tmp2_;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = _result_;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != ((gint64) 0)) {
#line 1804 "Thumbnail.c"
		gint64 _tmp5_ = 0LL;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _result_;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp5_;
#line 1810 "Thumbnail.c"
	} else {
		void* _tmp6_ = NULL;
		void* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = a;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = b;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = thumbnail_photo_id_descending_comparator (_tmp6_, _tmp7_);
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp8_;
#line 1823 "Thumbnail.c"
	}
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp3_;
#line 224 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1829 "Thumbnail.c"
}


gboolean thumbnail_rating_comparator_predicate (DataObject* object, Alteration* alteration) {
	gboolean result = FALSE;
	Alteration* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 227 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
#line 227 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
#line 228 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = alteration;
#line 228 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = alteration_has_detail (_tmp0_, "metadata", "rating");
#line 228 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp1_;
#line 228 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 1849 "Thumbnail.c"
}


static void thumbnail_real_thumbnail_altered (ThumbnailView* base) {
	Thumbnail * self;
	MediaSource* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	gint _tmp2_ = 0;
	Dimensions _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
#line 231 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 232 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 232 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	media_source_get_dimensions (_tmp0_, PHOTO_EXCEPTION_NONE, &_tmp1_);
#line 232 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->original_dim = _tmp1_;
#line 233 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->scale;
#line 233 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, _tmp2_, TRUE, &_tmp3_);
#line 233 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp3_;
#line 235 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = self->priv->exposure;
#line 235 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_) {
#line 236 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_delayed_high_quality_fetch (self);
#line 1880 "Thumbnail.c"
	} else {
#line 238 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_paint_empty (self);
#line 1884 "Thumbnail.c"
	}
#line 240 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	THUMBNAIL_VIEW_CLASS (thumbnail_parent_class)->thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_THUMBNAIL_VIEW, ThumbnailView));
#line 1888 "Thumbnail.c"
}


static void thumbnail_real_notify_collection_property_set (DataObject* base, const gchar* name, GValue* old, GValue* val) {
	Thumbnail * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	const gchar* _tmp5_ = NULL;
	GValue* _tmp6_ = NULL;
	GValue _tmp7_ = {0};
#line 243 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 243 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (name != NULL);
#line 243 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (val != NULL);
#line 244 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = name;
#line 244 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _tmp0_;
#line 244 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 244 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_ == g_quark_from_string (THUMBNAIL_PROP_SIZE)) {
#line 244 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		switch (0) {
#line 1916 "Thumbnail.c"
			default:
			{
				GValue _tmp4_ = {0};
#line 246 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_tmp4_ = *val;
#line 246 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				thumbnail_resize (self, g_value_get_int (&_tmp4_));
#line 247 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 1926 "Thumbnail.c"
			}
		}
	} else if (_tmp3_ == g_quark_from_string (THUMBNAIL_PROP_SHOW_RATINGS)) {
#line 244 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		switch (0) {
#line 1932 "Thumbnail.c"
			default:
			{
#line 250 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
#line 251 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				break;
#line 1939 "Thumbnail.c"
			}
		}
	}
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = name;
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = old;
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = *val;
#line 254 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	DATA_OBJECT_CLASS (thumbnail_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_DATA_OBJECT, DataObject), _tmp5_, _tmp6_, &_tmp7_);
#line 1951 "Thumbnail.c"
}


static void thumbnail_resize (Thumbnail* self, gint new_scale) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Dimensions _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
#line 257 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = new_scale;
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = thumbnail_get_MIN_SCALE ();
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = _tmp1_;
#line 258 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (_tmp0_ >= _tmp2_, "new_scale >= MIN_SCALE");
#line 259 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = new_scale;
#line 259 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = thumbnail_get_MAX_SCALE ();
#line 259 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp5_ = _tmp4_;
#line 259 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_vala_assert (_tmp3_ <= _tmp5_, "new_scale <= MAX_SCALE");
#line 261 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = self->priv->scale;
#line 261 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = new_scale;
#line 261 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_ == _tmp7_) {
#line 262 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 1994 "Thumbnail.c"
	}
#line 264 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = new_scale;
#line 264 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->scale = _tmp8_;
#line 265 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp9_ = self->priv->scale;
#line 265 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	dimensions_get_scaled (&self->priv->original_dim, _tmp9_, TRUE, &_tmp10_);
#line 265 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->dim = _tmp10_;
#line 267 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp11_ = self->priv->exposure;
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp11_) {
#line 2012 "Thumbnail.c"
		GdkPixbuf* resizable = NULL;
		GdkPixbuf* _tmp12_ = NULL;
		GdkPixbuf* _tmp17_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		resizable = NULL;
#line 275 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp12_ = self->priv->unscaled_pixbuf;
#line 275 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (_tmp12_ != NULL) {
#line 2022 "Thumbnail.c"
			GdkPixbuf* _tmp13_ = NULL;
			GdkPixbuf* _tmp14_ = NULL;
#line 276 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp13_ = self->priv->unscaled_pixbuf;
#line 276 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp14_ = _g_object_ref0 (_tmp13_);
#line 276 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (resizable);
#line 276 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			resizable = _tmp14_;
#line 2033 "Thumbnail.c"
		} else {
			gboolean _tmp15_ = FALSE;
#line 277 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp15_ = checkerboard_item_has_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 277 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			if (_tmp15_) {
#line 2040 "Thumbnail.c"
				GdkPixbuf* _tmp16_ = NULL;
#line 278 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_tmp16_ = checkerboard_item_get_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 278 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				_g_object_unref0 (resizable);
#line 278 "/home/jens/Source/shotwell/src/Thumbnail.vala"
				resizable = _tmp16_;
#line 2048 "Thumbnail.c"
			}
		}
#line 280 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp17_ = resizable;
#line 280 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		if (_tmp17_ != NULL) {
#line 2055 "Thumbnail.c"
			GdkPixbuf* _tmp18_ = NULL;
			Dimensions _tmp19_ = {0};
			GdkPixbuf* _tmp20_ = NULL;
			GdkPixbuf* _tmp21_ = NULL;
#line 281 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp18_ = resizable;
#line 281 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp19_ = self->priv->dim;
#line 281 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp20_ = resize_pixbuf (_tmp18_, &_tmp19_, THUMBNAIL_LOW_QUALITY_INTERP);
#line 281 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_tmp21_ = _tmp20_;
#line 281 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp21_);
#line 281 "/home/jens/Source/shotwell/src/Thumbnail.vala"
			_g_object_unref0 (_tmp21_);
#line 2072 "Thumbnail.c"
		}
#line 283 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_delayed_high_quality_fetch (self);
#line 269 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (resizable);
#line 2078 "Thumbnail.c"
	} else {
		Dimensions _tmp22_ = {0};
#line 285 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp22_ = self->priv->dim;
#line 285 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp22_);
#line 2085 "Thumbnail.c"
	}
}


static void thumbnail_paint_empty (Thumbnail* self) {
	Dimensions _tmp0_ = {0};
#line 289 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 290 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 291 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->dim;
#line 291 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	checkerboard_item_clear_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), &_tmp0_);
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 292 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->unscaled_pixbuf = NULL;
#line 2104 "Thumbnail.c"
}


static void _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self) {
#line 299 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_low_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
#line 2111 "Thumbnail.c"
}


static void thumbnail_schedule_low_quality_fetch (Thumbnail* self) {
	GCancellable* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	Dimensions _tmp2_ = {0};
	GCancellable* _tmp3_ = NULL;
#line 295 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 296 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 297 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = g_cancellable_new ();
#line 297 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 297 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = _tmp0_;
#line 299 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = self->priv->media;
#line 299 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->dim;
#line 299 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = self->priv->cancellable;
#line 299 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_SMALLEST, &_tmp2_, THUMBNAIL_LOW_QUALITY_INTERP, _thumbnail_on_low_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp3_);
#line 2138 "Thumbnail.c"
}


static gboolean _thumbnail_on_schedule_high_quality_gsource_func (gpointer self) {
	gboolean result;
	result = thumbnail_on_schedule_high_quality ((Thumbnail*) self);
#line 310 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2147 "Thumbnail.c"
}


static void thumbnail_delayed_high_quality_fetch (Thumbnail* self) {
	gboolean _tmp0_ = FALSE;
#line 303 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 304 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->hq_scheduled;
#line 304 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 305 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->hq_reschedule = TRUE;
#line 307 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return;
#line 2163 "Thumbnail.c"
	}
#line 310 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) THUMBNAIL_HQ_IMPROVEMENT_MSEC, _thumbnail_on_schedule_high_quality_gsource_func, g_object_ref (self), g_object_unref);
#line 311 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = TRUE;
#line 2169 "Thumbnail.c"
}


static void _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, gpointer self) {
#line 325 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_on_high_quality_fetched ((Thumbnail*) self, pixbuf, unscaled, dim, interp, err);
#line 2176 "Thumbnail.c"
}


static gboolean thumbnail_on_schedule_high_quality (Thumbnail* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 314 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_val_if_fail (IS_THUMBNAIL (self), FALSE);
#line 315 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->hq_reschedule;
#line 315 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_) {
#line 316 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->hq_reschedule = FALSE;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		result = TRUE;
#line 318 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		return result;
#line 2197 "Thumbnail.c"
	}
#line 321 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_cancel_async_fetch (self);
#line 322 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = g_cancellable_new ();
#line 322 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 322 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = _tmp1_;
#line 324 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = self->priv->exposure;
#line 324 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp2_) {
#line 2211 "Thumbnail.c"
		MediaSource* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		Dimensions _tmp5_ = {0};
		GCancellable* _tmp6_ = NULL;
#line 325 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = self->priv->media;
#line 325 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = self->priv->scale;
#line 325 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = self->priv->dim;
#line 325 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = self->priv->cancellable;
#line 325 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_cache_fetch_async_scaled (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), _tmp4_, &_tmp5_, THUMBNAIL_HIGH_QUALITY_INTERP, _thumbnail_on_high_quality_fetched_thumbnail_cache_async_fetch_callback, self, _tmp6_);
#line 2226 "Thumbnail.c"
	}
#line 329 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = FALSE;
#line 331 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = FALSE;
#line 331 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2234 "Thumbnail.c"
}


static void thumbnail_cancel_async_fetch (Thumbnail* self) {
	GCancellable* _tmp0_ = NULL;
#line 334 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->cancellable;
#line 336 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2246 "Thumbnail.c"
		GCancellable* _tmp1_ = NULL;
#line 337 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = self->priv->cancellable;
#line 337 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_cancellable_cancel (_tmp1_);
#line 2252 "Thumbnail.c"
	}
}


static void thumbnail_on_low_quality_fetched (Thumbnail* self, GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err) {
	GError* _tmp0_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp8_ = NULL;
#line 340 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 340 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((pixbuf == NULL) || GDK_IS_PIXBUF (pixbuf));
#line 340 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((unscaled == NULL) || GDK_IS_PIXBUF (unscaled));
#line 340 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (dim != NULL);
#line 342 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = err;
#line 342 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2273 "Thumbnail.c"
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp1_;
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = self->priv->scale;
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = err;
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp4_->message;
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_critical ("Thumbnail.vala:343: Unable to fetch low-quality thumbnail for %s (scal" \
"e: %d): %s", _tmp2_, _tmp3_, _tmp5_);
#line 343 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_free0 (_tmp2_);
#line 2293 "Thumbnail.c"
	}
#line 346 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = pixbuf;
#line 346 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_ != NULL) {
#line 2299 "Thumbnail.c"
		GdkPixbuf* _tmp7_ = NULL;
#line 347 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = pixbuf;
#line 347 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp7_);
#line 2305 "Thumbnail.c"
	}
#line 349 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = unscaled;
#line 349 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp8_ != NULL) {
#line 2311 "Thumbnail.c"
		GdkPixbuf* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
#line 350 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = unscaled;
#line 350 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 350 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 350 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->unscaled_pixbuf = _tmp10_;
#line 2322 "Thumbnail.c"
	}
#line 352 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_delayed_high_quality_fetch (self);
#line 2326 "Thumbnail.c"
}


static void thumbnail_on_high_quality_fetched (Thumbnail* self, GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err) {
	GError* _tmp0_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp8_ = NULL;
#line 355 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (IS_THUMBNAIL (self));
#line 355 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((pixbuf == NULL) || GDK_IS_PIXBUF (pixbuf));
#line 355 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail ((unscaled == NULL) || GDK_IS_PIXBUF (unscaled));
#line 355 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_return_if_fail (dim != NULL);
#line 357 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = err;
#line 357 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2346 "Thumbnail.c"
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp1_;
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = self->priv->scale;
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp4_ = err;
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp4_->message;
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_critical ("Thumbnail.vala:358: Unable to fetch high-quality thumbnail for %s (sca" \
"le: %d): %s", _tmp2_, _tmp3_, _tmp5_);
#line 358 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_free0 (_tmp2_);
#line 2366 "Thumbnail.c"
	}
#line 361 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp6_ = pixbuf;
#line 361 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_ != NULL) {
#line 2372 "Thumbnail.c"
		GdkPixbuf* _tmp7_ = NULL;
#line 362 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = pixbuf;
#line 362 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		checkerboard_item_set_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem), _tmp7_);
#line 2378 "Thumbnail.c"
	}
#line 364 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp8_ = unscaled;
#line 364 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp8_ != NULL) {
#line 2384 "Thumbnail.c"
		GdkPixbuf* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
#line 365 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = unscaled;
#line 365 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 365 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 365 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		self->priv->unscaled_pixbuf = _tmp10_;
#line 2395 "Thumbnail.c"
	}
}


static void thumbnail_real_exposed (CheckerboardItem* base) {
	Thumbnail * self;
	gboolean _tmp0_ = FALSE;
#line 368 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 369 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = TRUE;
#line 371 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = checkerboard_item_has_image (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 371 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (!_tmp0_) {
#line 372 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		thumbnail_schedule_low_quality_fetch (self);
#line 2413 "Thumbnail.c"
	}
#line 374 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_title (self, FALSE);
#line 375 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_comment (self, FALSE);
#line 376 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_update_tags (self, FALSE);
#line 378 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->exposed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 2423 "Thumbnail.c"
}


static void thumbnail_real_unexposed (CheckerboardItem* base) {
	Thumbnail * self;
#line 381 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 382 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = FALSE;
#line 384 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_paint_empty (self);
#line 386 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	CHECKERBOARD_ITEM_CLASS (thumbnail_parent_class)->unexposed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem), TYPE_CHECKERBOARD_ITEM, CheckerboardItem));
#line 2437 "Thumbnail.c"
}


static GdkPixbuf* thumbnail_real_get_top_right_trinket (CheckerboardItem* base, gint scale) {
	Thumbnail * self;
	GdkPixbuf* result = NULL;
	Flaggable* flaggable = NULL;
	MediaSource* _tmp0_ = NULL;
	Flaggable* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Flaggable* _tmp4_ = NULL;
#line 389 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 390 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 390 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_FLAGGABLE) ? ((Flaggable*) _tmp0_) : NULL);
#line 390 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	flaggable = _tmp1_;
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = flaggable;
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp4_ != NULL) {
#line 2462 "Thumbnail.c"
		Flaggable* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = flaggable;
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = flaggable_is_flagged (_tmp5_);
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = _tmp6_;
#line 2471 "Thumbnail.c"
	} else {
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp3_ = FALSE;
#line 2475 "Thumbnail.c"
	}
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp3_) {
#line 2479 "Thumbnail.c"
		GdkPixbuf* _tmp7_ = NULL;
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp7_ = resources_get_icon (RESOURCES_ICON_FLAGGED_TRINKET, RESOURCES_DEFAULT_ICON_SCALE);
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp2_);
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = _tmp7_;
#line 2487 "Thumbnail.c"
	} else {
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp2_);
#line 393 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp2_ = NULL;
#line 2493 "Thumbnail.c"
	}
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp2_;
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (flaggable);
#line 392 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2501 "Thumbnail.c"
}


static void _vala_GValue_free (GValue* self) {
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_unset (self);
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_free (self);
#line 2510 "Thumbnail.c"
}


static GdkPixbuf* thumbnail_real_get_bottom_left_trinket (CheckerboardItem* base, gint scale) {
	Thumbnail * self;
	GdkPixbuf* result = NULL;
	Rating rating = 0;
	MediaSource* _tmp0_ = NULL;
	Rating _tmp1_ = 0;
	gboolean show_ratings = FALSE;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GdkPixbuf* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	Rating _tmp7_ = 0;
#line 396 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_THUMBNAIL, Thumbnail);
#line 397 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->media;
#line 397 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp1_ = media_source_get_rating (_tmp0_);
#line 397 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	rating = _tmp1_;
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = g_new0 (GValue, 1);
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_init (_tmp2_, G_TYPE_BOOLEAN);
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_value_set_boolean (_tmp2_, FALSE);
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp3_ = data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), THUMBNAIL_PROP_SHOW_RATINGS, _tmp2_);
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = g_value_get_boolean (_tmp3_);
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	__vala_GValue_free0 (_tmp2_);
#line 398 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	show_ratings = _tmp4_;
#line 400 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp7_ = rating;
#line 400 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp7_ != RATING_UNRATED) {
#line 2553 "Thumbnail.c"
		gboolean _tmp8_ = FALSE;
#line 400 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp8_ = show_ratings;
#line 400 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = _tmp8_;
#line 2559 "Thumbnail.c"
	} else {
#line 400 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp6_ = FALSE;
#line 2563 "Thumbnail.c"
	}
#line 400 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp6_) {
#line 2567 "Thumbnail.c"
		Rating _tmp9_ = 0;
		gint _tmp10_ = 0;
		GdkPixbuf* _tmp11_ = NULL;
#line 401 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp9_ = rating;
#line 401 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp10_ = scale;
#line 401 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp11_ = resources_get_rating_trinket (_tmp9_, _tmp10_);
#line 401 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp5_);
#line 401 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = _tmp11_;
#line 2581 "Thumbnail.c"
	} else {
#line 401 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_g_object_unref0 (_tmp5_);
#line 401 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp5_ = NULL;
#line 2587 "Thumbnail.c"
	}
#line 400 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp5_;
#line 400 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2593 "Thumbnail.c"
}


gint thumbnail_get_MIN_SCALE (void) {
	gint result;
#line 18 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = 72;
#line 18 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2603 "Thumbnail.c"
}


gint thumbnail_get_MAX_SCALE (void) {
	gint result;
	gint _tmp0_ = 0;
#line 23 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_LARGEST);
#line 23 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp0_;
#line 23 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2616 "Thumbnail.c"
}


gint thumbnail_get_DEFAULT_SCALE (void) {
	gint result;
	gint _tmp0_ = 0;
#line 28 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 28 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	result = _tmp0_;
#line 28 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	return result;
#line 2629 "Thumbnail.c"
}


static void thumbnail_class_init (ThumbnailClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	thumbnail_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_type_class_add_private (klass, sizeof (ThumbnailPrivate));
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((DataObjectClass *) klass)->notify_altered = thumbnail_real_notify_altered;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((ThumbnailViewClass *) klass)->thumbnail_altered = thumbnail_real_thumbnail_altered;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((DataObjectClass *) klass)->notify_collection_property_set = thumbnail_real_notify_collection_property_set;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->exposed = thumbnail_real_exposed;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->unexposed = thumbnail_real_unexposed;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->get_top_right_trinket = thumbnail_real_get_top_right_trinket;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = thumbnail_real_get_bottom_left_trinket;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_thumbnail_get_property;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (klass)->finalize = thumbnail_finalize;
#line 2656 "Thumbnail.c"
}


static void thumbnail_instance_init (Thumbnail * self) {
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv = THUMBNAIL_GET_PRIVATE (self);
#line 41 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->unscaled_pixbuf = NULL;
#line 42 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->cancellable = NULL;
#line 43 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_scheduled = FALSE;
#line 44 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->hq_reschedule = FALSE;
#line 47 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self->priv->exposure = FALSE;
#line 2673 "Thumbnail.c"
}


static void thumbnail_finalize (GObject* obj) {
	Thumbnail * self;
	GCancellable* _tmp0_ = NULL;
	TagSourceCollection* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	TagSourceCollection* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL, Thumbnail);
#line 73 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp0_ = self->priv->cancellable;
#line 73 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	if (_tmp0_ != NULL) {
#line 2690 "Thumbnail.c"
		GCancellable* _tmp1_ = NULL;
#line 74 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		_tmp1_ = self->priv->cancellable;
#line 74 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		g_cancellable_cancel (_tmp1_);
#line 2696 "Thumbnail.c"
	}
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp2_ = tag_global;
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_parse_name ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, &_tmp3_, NULL, FALSE);
#line 76 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _thumbnail_on_tag_contents_altered_container_source_collection_container_contents_altered, self);
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_tmp4_ = tag_global;
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_parse_name ("items-altered", TYPE_DATA_COLLECTION, &_tmp5_, NULL, FALSE);
#line 77 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DATA_COLLECTION, DataCollection), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _thumbnail_on_tags_altered_data_collection_items_altered, self);
#line 37 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->media);
#line 41 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->unscaled_pixbuf);
#line 42 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	_g_object_unref0 (self->priv->cancellable);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	G_OBJECT_CLASS (thumbnail_parent_class)->finalize (obj);
#line 2718 "Thumbnail.c"
}


GType thumbnail_get_type (void) {
	static volatile gsize thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnail), 0, (GInstanceInitFunc) thumbnail_instance_init, NULL };
		GType thumbnail_type_id;
		thumbnail_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_ITEM, "Thumbnail", &g_define_type_info, 0);
		g_once_init_leave (&thumbnail_type_id__volatile, thumbnail_type_id);
	}
	return thumbnail_type_id__volatile;
}


static void _vala_thumbnail_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Thumbnail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_THUMBNAIL, Thumbnail);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
	switch (property_id) {
#line 2739 "Thumbnail.c"
		default:
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 7 "/home/jens/Source/shotwell/src/Thumbnail.vala"
		break;
#line 2745 "Thumbnail.c"
	}
}



