/* SearchFilter.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from SearchFilter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Bitfield values used to specify which search bar features we want.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SEARCH_FILTER_CRITERIA (search_filter_criteria_get_type ())

#define TYPE_RATING_FILTER (rating_filter_get_type ())

#define TYPE_VIEW_FILTER (view_filter_get_type ())
#define VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_FILTER, ViewFilter))
#define VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_FILTER, ViewFilterClass))
#define IS_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_FILTER))
#define IS_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_FILTER))
#define VIEW_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_FILTER, ViewFilterClass))

typedef struct _ViewFilter ViewFilter;
typedef struct _ViewFilterClass ViewFilterClass;
typedef struct _ViewFilterPrivate ViewFilterPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_SEARCH_VIEW_FILTER (search_view_filter_get_type ())
#define SEARCH_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_VIEW_FILTER, SearchViewFilter))
#define SEARCH_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_VIEW_FILTER, SearchViewFilterClass))
#define IS_SEARCH_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_VIEW_FILTER))
#define IS_SEARCH_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_VIEW_FILTER))
#define SEARCH_VIEW_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_VIEW_FILTER, SearchViewFilterClass))

typedef struct _SearchViewFilter SearchViewFilter;
typedef struct _SearchViewFilterClass SearchViewFilterClass;
typedef struct _SearchViewFilterPrivate SearchViewFilterPrivate;

#define TYPE_RATING (rating_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DEFAULT_SEARCH_VIEW_FILTER (default_search_view_filter_get_type ())
#define DEFAULT_SEARCH_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_SEARCH_VIEW_FILTER, DefaultSearchViewFilter))
#define DEFAULT_SEARCH_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_SEARCH_VIEW_FILTER, DefaultSearchViewFilterClass))
#define IS_DEFAULT_SEARCH_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_SEARCH_VIEW_FILTER))
#define IS_DEFAULT_SEARCH_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_SEARCH_VIEW_FILTER))
#define DEFAULT_SEARCH_VIEW_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_SEARCH_VIEW_FILTER, DefaultSearchViewFilterClass))

typedef struct _DefaultSearchViewFilter DefaultSearchViewFilter;
typedef struct _DefaultSearchViewFilterClass DefaultSearchViewFilterClass;
typedef struct _DefaultSearchViewFilterPrivate DefaultSearchViewFilterPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;

#define TYPE_MEDIA_SOURCE_ITEM (media_source_item_get_type ())
#define MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItem))
#define MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))
#define IS_MEDIA_SOURCE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_ITEM))
#define IS_MEDIA_SOURCE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_ITEM))
#define MEDIA_SOURCE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_ITEM, MediaSourceItemClass))

typedef struct _MediaSourceItem MediaSourceItem;
typedef struct _MediaSourceItemClass MediaSourceItemClass;

#define TYPE_THUMBNAIL (thumbnail_get_type ())
#define THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL, Thumbnail))
#define THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL, ThumbnailClass))
#define IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL))
#define IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL))
#define THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL, ThumbnailClass))

typedef struct _Thumbnail Thumbnail;
typedef struct _ThumbnailClass ThumbnailClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_DISABLED_VIEW_FILTER (disabled_view_filter_get_type ())
#define DISABLED_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DISABLED_VIEW_FILTER, DisabledViewFilter))
#define DISABLED_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DISABLED_VIEW_FILTER, DisabledViewFilterClass))
#define IS_DISABLED_VIEW_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DISABLED_VIEW_FILTER))
#define IS_DISABLED_VIEW_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DISABLED_VIEW_FILTER))
#define DISABLED_VIEW_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DISABLED_VIEW_FILTER, DisabledViewFilterClass))

typedef struct _DisabledViewFilter DisabledViewFilter;
typedef struct _DisabledViewFilterClass DisabledViewFilterClass;
typedef struct _DisabledViewFilterPrivate DisabledViewFilterPrivate;

#define TYPE_TEXT_ACTION (text_action_get_type ())
#define TEXT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_ACTION, TextAction))
#define TEXT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_ACTION, TextActionClass))
#define IS_TEXT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_ACTION))
#define IS_TEXT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_ACTION))
#define TEXT_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_ACTION, TextActionClass))

typedef struct _TextAction TextAction;
typedef struct _TextActionClass TextActionClass;
typedef struct _TextActionPrivate TextActionPrivate;
typedef struct _ParamSpecTextAction ParamSpecTextAction;

#define TYPE_SEARCH_FILTER_ACTIONS (search_filter_actions_get_type ())
#define SEARCH_FILTER_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_FILTER_ACTIONS, SearchFilterActions))
#define SEARCH_FILTER_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_FILTER_ACTIONS, SearchFilterActionsClass))
#define IS_SEARCH_FILTER_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_FILTER_ACTIONS))
#define IS_SEARCH_FILTER_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_FILTER_ACTIONS))
#define SEARCH_FILTER_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_FILTER_ACTIONS, SearchFilterActionsClass))

typedef struct _SearchFilterActions SearchFilterActions;
typedef struct _SearchFilterActionsClass SearchFilterActionsClass;
typedef struct _SearchFilterActionsPrivate SearchFilterActionsPrivate;
#define _text_action_unref0(var) ((var == NULL) ? NULL : (var = (text_action_unref (var), NULL)))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_CHECKERBOARD_PAGE (checkerboard_page_get_type ())
#define CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPage))
#define CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))
#define IS_CHECKERBOARD_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_PAGE))
#define IS_CHECKERBOARD_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_PAGE))
#define CHECKERBOARD_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_PAGE, CheckerboardPageClass))

typedef struct _CheckerboardPage CheckerboardPage;
typedef struct _CheckerboardPageClass CheckerboardPageClass;

#define CORE_TYPE_TRACKER (core_tracker_get_type ())
#define CORE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER, CoreTracker))
#define CORE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_TRACKER, CoreTrackerClass))
#define CORE_IS_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER))
#define CORE_IS_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_TRACKER))
#define CORE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_TRACKER, CoreTrackerClass))

typedef struct _CoreTracker CoreTracker;
typedef struct _CoreTrackerClass CoreTrackerClass;

#define CORE_TYPE_VIEW_TRACKER (core_view_tracker_get_type ())
#define CORE_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTracker))
#define CORE_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))
#define CORE_IS_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_VIEW_TRACKER))
#define CORE_IS_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_VIEW_TRACKER))
#define CORE_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))

typedef struct _CoreViewTracker CoreViewTracker;
typedef struct _CoreViewTrackerClass CoreViewTrackerClass;

#define TYPE_MEDIA_VIEW_TRACKER (media_view_tracker_get_type ())
#define MEDIA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker))
#define MEDIA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_VIEW_TRACKER, MediaViewTrackerClass))
#define IS_MEDIA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_VIEW_TRACKER))
#define IS_MEDIA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_VIEW_TRACKER))
#define MEDIA_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_VIEW_TRACKER, MediaViewTrackerClass))

typedef struct _MediaViewTracker MediaViewTracker;
typedef struct _MediaViewTrackerClass MediaViewTrackerClass;

#define TYPE_CAMERA_VIEW_TRACKER (camera_view_tracker_get_type ())
#define CAMERA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CAMERA_VIEW_TRACKER, CameraViewTracker))
#define CAMERA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CAMERA_VIEW_TRACKER, CameraViewTrackerClass))
#define IS_CAMERA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CAMERA_VIEW_TRACKER))
#define IS_CAMERA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CAMERA_VIEW_TRACKER))
#define CAMERA_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CAMERA_VIEW_TRACKER, CameraViewTrackerClass))

typedef struct _CameraViewTracker CameraViewTracker;
typedef struct _CameraViewTrackerClass CameraViewTrackerClass;
#define _core_tracker_unref0(var) ((var == NULL) ? NULL : (var = (core_tracker_unref (var), NULL)))
typedef struct _CoreTrackerPrivate CoreTrackerPrivate;
typedef struct _CoreViewTrackerPrivate CoreViewTrackerPrivate;
typedef struct _MediaViewTrackerPrivate MediaViewTrackerPrivate;

#define TYPE_MEDIA_ACCUMULATOR (media_accumulator_get_type ())
#define MEDIA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ACCUMULATOR, MediaAccumulator))
#define MEDIA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_ACCUMULATOR, MediaAccumulatorClass))
#define IS_MEDIA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ACCUMULATOR))
#define IS_MEDIA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_ACCUMULATOR))
#define MEDIA_ACCUMULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_ACCUMULATOR, MediaAccumulatorClass))

typedef struct _MediaAccumulator MediaAccumulator;
typedef struct _MediaAccumulatorClass MediaAccumulatorClass;

#define CORE_TYPE_TRACKER_ACCUMULATOR (core_tracker_accumulator_get_type ())
#define CORE_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator))
#define CORE_IS_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR))
#define CORE_TRACKER_ACCUMULATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulatorIface))

typedef struct _CoreTrackerAccumulator CoreTrackerAccumulator;
typedef struct _CoreTrackerAccumulatorIface CoreTrackerAccumulatorIface;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _MediaAccumulatorPrivate MediaAccumulatorPrivate;
typedef struct _CameraViewTrackerPrivate CameraViewTrackerPrivate;

#define TYPE_CAMERA_ACCUMULATOR (camera_accumulator_get_type ())
#define CAMERA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CAMERA_ACCUMULATOR, CameraAccumulator))
#define CAMERA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CAMERA_ACCUMULATOR, CameraAccumulatorClass))
#define IS_CAMERA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CAMERA_ACCUMULATOR))
#define IS_CAMERA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CAMERA_ACCUMULATOR))
#define CAMERA_ACCUMULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CAMERA_ACCUMULATOR, CameraAccumulatorClass))

typedef struct _CameraAccumulator CameraAccumulator;
typedef struct _CameraAccumulatorClass CameraAccumulatorClass;
typedef struct _ParamSpecSearchFilterActions ParamSpecSearchFilterActions;

#define TYPE_SEARCH_FILTER_TOOLBAR (search_filter_toolbar_get_type ())
#define SEARCH_FILTER_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_FILTER_TOOLBAR, SearchFilterToolbar))
#define SEARCH_FILTER_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_FILTER_TOOLBAR, SearchFilterToolbarClass))
#define IS_SEARCH_FILTER_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_FILTER_TOOLBAR))
#define IS_SEARCH_FILTER_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_FILTER_TOOLBAR))
#define SEARCH_FILTER_TOOLBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_FILTER_TOOLBAR, SearchFilterToolbarClass))

typedef struct _SearchFilterToolbar SearchFilterToolbar;
typedef struct _SearchFilterToolbarClass SearchFilterToolbarClass;
typedef struct _SearchFilterToolbarPrivate SearchFilterToolbarPrivate;

#define SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX (search_filter_toolbar_search_box_get_type ())
#define SEARCH_FILTER_TOOLBAR_SEARCH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX, SearchFilterToolbarSearchBox))
#define SEARCH_FILTER_TOOLBAR_SEARCH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX, SearchFilterToolbarSearchBoxClass))
#define SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX))
#define SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX))
#define SEARCH_FILTER_TOOLBAR_SEARCH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX, SearchFilterToolbarSearchBoxClass))

typedef struct _SearchFilterToolbarSearchBox SearchFilterToolbarSearchBox;
typedef struct _SearchFilterToolbarSearchBoxClass SearchFilterToolbarSearchBoxClass;

#define SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON (search_filter_toolbar_rating_filter_button_get_type ())
#define SEARCH_FILTER_TOOLBAR_RATING_FILTER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON, SearchFilterToolbarRatingFilterButton))
#define SEARCH_FILTER_TOOLBAR_RATING_FILTER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON, SearchFilterToolbarRatingFilterButtonClass))
#define SEARCH_FILTER_TOOLBAR_IS_RATING_FILTER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON))
#define SEARCH_FILTER_TOOLBAR_IS_RATING_FILTER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON))
#define SEARCH_FILTER_TOOLBAR_RATING_FILTER_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON, SearchFilterToolbarRatingFilterButtonClass))

typedef struct _SearchFilterToolbarRatingFilterButton SearchFilterToolbarRatingFilterButton;
typedef struct _SearchFilterToolbarRatingFilterButtonClass SearchFilterToolbarRatingFilterButtonClass;

#define SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM (search_filter_toolbar_label_tool_item_get_type ())
#define SEARCH_FILTER_TOOLBAR_LABEL_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM, SearchFilterToolbarLabelToolItem))
#define SEARCH_FILTER_TOOLBAR_LABEL_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM, SearchFilterToolbarLabelToolItemClass))
#define SEARCH_FILTER_TOOLBAR_IS_LABEL_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM))
#define SEARCH_FILTER_TOOLBAR_IS_LABEL_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM))
#define SEARCH_FILTER_TOOLBAR_LABEL_TOOL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM, SearchFilterToolbarLabelToolItemClass))

typedef struct _SearchFilterToolbarLabelToolItem SearchFilterToolbarLabelToolItem;
typedef struct _SearchFilterToolbarLabelToolItemClass SearchFilterToolbarLabelToolItemClass;

#define SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON (search_filter_toolbar_toggle_action_tool_button_get_type ())
#define SEARCH_FILTER_TOOLBAR_TOGGLE_ACTION_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON, SearchFilterToolbarToggleActionToolButton))
#define SEARCH_FILTER_TOOLBAR_TOGGLE_ACTION_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON, SearchFilterToolbarToggleActionToolButtonClass))
#define SEARCH_FILTER_TOOLBAR_IS_TOGGLE_ACTION_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON))
#define SEARCH_FILTER_TOOLBAR_IS_TOGGLE_ACTION_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON))
#define SEARCH_FILTER_TOOLBAR_TOGGLE_ACTION_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON, SearchFilterToolbarToggleActionToolButtonClass))

typedef struct _SearchFilterToolbarToggleActionToolButton SearchFilterToolbarToggleActionToolButton;
typedef struct _SearchFilterToolbarToggleActionToolButtonClass SearchFilterToolbarToggleActionToolButtonClass;
#define _search_filter_actions_unref0(var) ((var == NULL) ? NULL : (var = (search_filter_actions_unref (var), NULL)))
#define _view_filter_unref0(var) ((var == NULL) ? NULL : (var = (view_filter_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SearchFilterToolbarRatingFilterButtonPrivate SearchFilterToolbarRatingFilterButtonPrivate;

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_LIBRARY_WINDOW (library_window_get_type ())
#define LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_WINDOW, LibraryWindow))
#define LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_WINDOW, LibraryWindowClass))
#define IS_LIBRARY_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_WINDOW))
#define IS_LIBRARY_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_WINDOW))
#define LIBRARY_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_WINDOW, LibraryWindowClass))

typedef struct _LibraryWindow LibraryWindow;
typedef struct _LibraryWindowClass LibraryWindowClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
typedef struct _SearchFilterToolbarLabelToolItemPrivate SearchFilterToolbarLabelToolItemPrivate;
typedef struct _SearchFilterToolbarToggleActionToolButtonPrivate SearchFilterToolbarToggleActionToolButtonPrivate;
typedef struct _SearchFilterToolbarSearchBoxPrivate SearchFilterToolbarSearchBoxPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	SEARCH_FILTER_CRITERIA_NONE = 0,
	SEARCH_FILTER_CRITERIA_RECURSIVE = 1 << 0,
	SEARCH_FILTER_CRITERIA_TEXT = 1 << 1,
	SEARCH_FILTER_CRITERIA_FLAG = 1 << 2,
	SEARCH_FILTER_CRITERIA_MEDIA = 1 << 3,
	SEARCH_FILTER_CRITERIA_RATING = 1 << 4,
	SEARCH_FILTER_CRITERIA_ALL = 0xFFFFFFFFLL
} SearchFilterCriteria;

typedef enum  {
	RATING_FILTER_NO_FILTER = 0,
	RATING_FILTER_REJECTED_OR_HIGHER = 1,
	RATING_FILTER_UNRATED_OR_HIGHER = 2,
	RATING_FILTER_ONE_OR_HIGHER = 3,
	RATING_FILTER_TWO_OR_HIGHER = 4,
	RATING_FILTER_THREE_OR_HIGHER = 5,
	RATING_FILTER_FOUR_OR_HIGHER = 6,
	RATING_FILTER_FIVE_OR_HIGHER = 7,
	RATING_FILTER_REJECTED_ONLY = 8,
	RATING_FILTER_UNRATED_ONLY = 9,
	RATING_FILTER_ONE_ONLY = 10,
	RATING_FILTER_TWO_ONLY = 11,
	RATING_FILTER_THREE_ONLY = 12,
	RATING_FILTER_FOUR_ONLY = 13,
	RATING_FILTER_FIVE_ONLY = 14
} RatingFilter;

struct _ViewFilter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ViewFilterPrivate * priv;
};

struct _ViewFilterClass {
	GTypeClass parent_class;
	void (*finalize) (ViewFilter *self);
	gboolean (*predicate) (ViewFilter* self, DataView* view);
	void (*refresh) (ViewFilter* self);
};

struct _SearchViewFilter {
	ViewFilter parent_instance;
	SearchViewFilterPrivate * priv;
};

struct _SearchViewFilterClass {
	ViewFilterClass parent_class;
	guint (*get_criteria) (SearchViewFilter* self);
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _SearchViewFilterPrivate {
	gboolean rating_allow_higher;
	Rating rating;
	RatingFilter rating_filter;
	gboolean _flagged;
	gboolean _show_media_video;
	gboolean _show_media_photos;
	gboolean _show_media_raw;
	gchar* search_filter;
	gchar** search_filter_words;
	gint search_filter_words_length1;
	gint _search_filter_words_size_;
};

struct _DefaultSearchViewFilter {
	SearchViewFilter parent_instance;
	DefaultSearchViewFilterPrivate * priv;
};

struct _DefaultSearchViewFilterClass {
	SearchViewFilterClass parent_class;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _DisabledViewFilter {
	SearchViewFilter parent_instance;
	DisabledViewFilterPrivate * priv;
};

struct _DisabledViewFilterClass {
	SearchViewFilterClass parent_class;
};

struct _TextAction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextActionPrivate * priv;
};

struct _TextActionClass {
	GTypeClass parent_class;
	void (*finalize) (TextAction *self);
};

struct _TextActionPrivate {
	gchar* text;
	gboolean sensitive;
	gboolean visible;
};

struct _ParamSpecTextAction {
	GParamSpec parent_instance;
};

struct _SearchFilterActions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SearchFilterActionsPrivate * priv;
};

struct _SearchFilterActionsClass {
	GTypeClass parent_class;
	void (*finalize) (SearchFilterActions *self);
};

struct _SearchFilterActionsPrivate {
	GtkActionGroup* action_group;
	SearchFilterCriteria criteria;
	TextAction* _text;
	gboolean has_flagged;
	gboolean has_photos;
	gboolean has_videos;
	gboolean has_raw;
	gboolean can_filter_by_stars;
};

struct _CoreTracker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CoreTrackerPrivate * priv;
};

struct _CoreTrackerClass {
	GTypeClass parent_class;
	void (*finalize) (CoreTracker *self);
	void (*updated) (CoreTracker* self);
};

struct _CoreViewTracker {
	CoreTracker parent_instance;
	CoreViewTrackerPrivate * priv;
};

struct _CoreViewTrackerClass {
	CoreTrackerClass parent_class;
};

struct _MediaViewTracker {
	CoreViewTracker parent_instance;
	MediaViewTrackerPrivate * priv;
	MediaAccumulator* all;
	MediaAccumulator* visible;
	MediaAccumulator* selected;
};

struct _MediaViewTrackerClass {
	CoreViewTrackerClass parent_class;
};

struct _CoreTrackerAccumulatorIface {
	GTypeInterface parent_iface;
	gboolean (*include) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*uninclude) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*altered) (CoreTrackerAccumulator* self, DataObject* object, Alteration* alteration);
};

struct _MediaAccumulator {
	GObject parent_instance;
	MediaAccumulatorPrivate * priv;
	gint total;
	gint photos;
	gint videos;
	gint raw;
	gint flagged;
};

struct _MediaAccumulatorClass {
	GObjectClass parent_class;
};

struct _CameraViewTracker {
	CoreViewTracker parent_instance;
	CameraViewTrackerPrivate * priv;
	CameraAccumulator* all;
	CameraAccumulator* visible;
	CameraAccumulator* selected;
};

struct _CameraViewTrackerClass {
	CoreViewTrackerClass parent_class;
};

struct _ParamSpecSearchFilterActions {
	GParamSpec parent_instance;
};

struct _SearchFilterToolbar {
	GtkRevealer parent_instance;
	SearchFilterToolbarPrivate * priv;
	GtkUIManager* ui;
};

struct _SearchFilterToolbarClass {
	GtkRevealerClass parent_class;
};

struct _SearchFilterToolbarPrivate {
	GtkToolbar* toolbar;
	GtkMenu* close_menu;
	GtkMenuItem* close_item;
	SearchFilterActions* actions;
	SearchFilterToolbarSearchBox* search_box;
	SearchFilterToolbarRatingFilterButton* rating_button;
	SearchViewFilter* search_filter;
	SearchFilterToolbarLabelToolItem* label_type;
	SearchFilterToolbarToggleActionToolButton* toolbtn_photos;
	SearchFilterToolbarToggleActionToolButton* toolbtn_videos;
	SearchFilterToolbarToggleActionToolButton* toolbtn_raw;
	SearchFilterToolbarToggleActionToolButton* toolbtn_flag;
	GtkSeparatorToolItem* sepr_mediatype_flagged;
	GtkSeparatorToolItem* sepr_flagged_rating;
};

struct _SearchFilterToolbarRatingFilterButton {
	GtkToolItem parent_instance;
	SearchFilterToolbarRatingFilterButtonPrivate * priv;
	GtkMenu* filter_popup;
	GtkButton* button;
};

struct _SearchFilterToolbarRatingFilterButtonClass {
	GtkToolItemClass parent_class;
};

struct _SearchFilterToolbarLabelToolItem {
	GtkToolItem parent_instance;
	SearchFilterToolbarLabelToolItemPrivate * priv;
};

struct _SearchFilterToolbarLabelToolItemClass {
	GtkToolItemClass parent_class;
};

struct _SearchFilterToolbarLabelToolItemPrivate {
	GtkLabel* label;
};

struct _SearchFilterToolbarToggleActionToolButton {
	GtkToolItem parent_instance;
	SearchFilterToolbarToggleActionToolButtonPrivate * priv;
};

struct _SearchFilterToolbarToggleActionToolButtonClass {
	GtkToolItemClass parent_class;
};

struct _SearchFilterToolbarToggleActionToolButtonPrivate {
	GtkToggleButton* button;
	GtkToggleAction* action;
};

struct _SearchFilterToolbarSearchBox {
	GtkToolItem parent_instance;
	SearchFilterToolbarSearchBoxPrivate * priv;
};

struct _SearchFilterToolbarSearchBoxClass {
	GtkToolItemClass parent_class;
};

struct _SearchFilterToolbarSearchBoxPrivate {
	GtkSearchEntry* search_entry;
	TextAction* action;
};


static gpointer search_view_filter_parent_class = NULL;
static gpointer default_search_view_filter_parent_class = NULL;
extern TagSourceCollection* tag_global;
static gpointer disabled_view_filter_parent_class = NULL;
static gpointer text_action_parent_class = NULL;
static gpointer search_filter_actions_parent_class = NULL;
extern gchar* resources_DISPLAY_ONE_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP;
extern gchar* resources_DISPLAY_TWO_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP;
extern gchar* resources_DISPLAY_THREE_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP;
extern gchar* resources_DISPLAY_FOUR_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP;
extern gchar* resources_DISPLAY_FIVE_OR_HIGHER_MENU;
extern gchar* resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP;
static gpointer search_filter_toolbar_parent_class = NULL;
static gpointer search_filter_toolbar_label_tool_item_parent_class = NULL;
static gpointer search_filter_toolbar_toggle_action_tool_button_parent_class = NULL;
static gpointer search_filter_toolbar_search_box_parent_class = NULL;
static gpointer search_filter_toolbar_rating_filter_button_parent_class = NULL;

GType search_filter_criteria_get_type (void) G_GNUC_CONST;
GType rating_filter_get_type (void) G_GNUC_CONST;
gpointer view_filter_ref (gpointer instance);
void view_filter_unref (gpointer instance);
GParamSpec* param_spec_view_filter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_view_filter (GValue* value, gpointer v_object);
void value_take_view_filter (GValue* value, gpointer v_object);
gpointer value_get_view_filter (const GValue* value);
GType view_filter_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_view_get_type (void) G_GNUC_CONST;
GType search_view_filter_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
#define SEARCH_VIEW_FILTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_VIEW_FILTER, SearchViewFilterPrivate))
enum  {
	SEARCH_VIEW_FILTER_DUMMY_PROPERTY
};
guint search_view_filter_get_criteria (SearchViewFilter* self);
static guint search_view_filter_real_get_criteria (SearchViewFilter* self);
void search_view_filter_set_rating_filter (SearchViewFilter* self, RatingFilter rf);
gboolean search_view_filter_has_search_filter (SearchViewFilter* self);
gboolean is_string_empty (const gchar* s);
const gchar* search_view_filter_get_search_filter (SearchViewFilter* self);
gchar** search_view_filter_get_search_filter_words (SearchViewFilter* self, int* result_length1);
void search_view_filter_set_search_filter (SearchViewFilter* self, const gchar* text);
static gchar** _vala_array_dup33 (gchar** self, int length);
void search_view_filter_clear_search_filter (SearchViewFilter* self);
gboolean search_view_filter_get_rating_allow_higher (SearchViewFilter* self);
Rating search_view_filter_get_rating (SearchViewFilter* self);
gboolean search_view_filter_filter_by_media_type (SearchViewFilter* self);
gboolean search_view_filter_get_show_media_video (SearchViewFilter* self);
gboolean search_view_filter_get_show_media_photos (SearchViewFilter* self);
gboolean search_view_filter_get_show_media_raw (SearchViewFilter* self);
SearchViewFilter* search_view_filter_construct (GType object_type);
ViewFilter* view_filter_construct (GType object_type);
gboolean search_view_filter_get_flagged (SearchViewFilter* self);
void search_view_filter_set_flagged (SearchViewFilter* self, gboolean value);
void search_view_filter_set_show_media_video (SearchViewFilter* self, gboolean value);
void search_view_filter_set_show_media_photos (SearchViewFilter* self, gboolean value);
void search_view_filter_set_show_media_raw (SearchViewFilter* self, gboolean value);
static void search_view_filter_finalize (ViewFilter* obj);
GType default_search_view_filter_get_type (void) G_GNUC_CONST;
enum  {
	DEFAULT_SEARCH_VIEW_FILTER_DUMMY_PROPERTY
};
static gboolean default_search_view_filter_real_predicate (ViewFilter* base, DataView* view);
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType thumbnail_view_get_type (void) G_GNUC_CONST;
GType checkerboard_item_get_type (void) G_GNUC_CONST;
GType media_source_item_get_type (void) G_GNUC_CONST;
GType thumbnail_get_type (void) G_GNUC_CONST;
MediaSource* thumbnail_get_media_source (Thumbnail* self);
Rating media_source_get_rating (MediaSource* self);
GType flaggable_get_type (void) G_GNUC_CONST;
gboolean flaggable_is_flagged (Flaggable* self);
GType video_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_get_master_file_format (Photo* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
gboolean photo_is_raw_developer_available (Photo* self, RawDeveloper d);
GType indexable_get_type (void) G_GNUC_CONST;
const gchar* indexable_get_indexable_keywords (Indexable* self);
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
Event* media_source_get_event (MediaSource* self);
GType tag_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self, MediaSource* source);
DefaultSearchViewFilter* default_search_view_filter_construct (GType object_type);
GType disabled_view_filter_get_type (void) G_GNUC_CONST;
enum  {
	DISABLED_VIEW_FILTER_DUMMY_PROPERTY
};
static gboolean disabled_view_filter_real_predicate (ViewFilter* base, DataView* view);
static guint disabled_view_filter_real_get_criteria (SearchViewFilter* base);
DisabledViewFilter* disabled_view_filter_new (void);
DisabledViewFilter* disabled_view_filter_construct (GType object_type);
gpointer text_action_ref (gpointer instance);
void text_action_unref (gpointer instance);
GParamSpec* param_spec_text_action (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_text_action (GValue* value, gpointer v_object);
void value_take_text_action (GValue* value, gpointer v_object);
gpointer value_get_text_action (const GValue* value);
GType text_action_get_type (void) G_GNUC_CONST;
#define TEXT_ACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEXT_ACTION, TextActionPrivate))
enum  {
	TEXT_ACTION_DUMMY_PROPERTY
};
TextAction* text_action_new (const gchar* init);
TextAction* text_action_construct (GType object_type, const gchar* init);
void text_action_set_text (TextAction* self, const gchar* text);
void text_action_clear (TextAction* self);
gboolean text_action_is_sensitive (TextAction* self);
void text_action_set_sensitive (TextAction* self, gboolean sensitive);
gboolean text_action_is_visible (TextAction* self);
void text_action_set_visible (TextAction* self, gboolean visible);
const gchar* text_action_get_value (TextAction* self);
static void text_action_finalize (TextAction* obj);
gpointer search_filter_actions_ref (gpointer instance);
void search_filter_actions_unref (gpointer instance);
GParamSpec* param_spec_search_filter_actions (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_search_filter_actions (GValue* value, gpointer v_object);
void value_take_search_filter_actions (GValue* value, gpointer v_object);
gpointer value_get_search_filter_actions (const GValue* value);
GType search_filter_actions_get_type (void) G_GNUC_CONST;
#define SEARCH_FILTER_ACTIONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_FILTER_ACTIONS, SearchFilterActionsPrivate))
enum  {
	SEARCH_FILTER_ACTIONS_DUMMY_PROPERTY
};
SearchFilterActions* search_filter_actions_new (void);
SearchFilterActions* search_filter_actions_construct (GType object_type);
static void search_filter_actions_register (SearchFilterActions* self);
TextAction* search_filter_actions_get_text (SearchFilterActions* self);
static void search_filter_actions_on_text_changed (SearchFilterActions* self, TextAction* action, const gchar* text);
static void _search_filter_actions_on_text_changed_text_action_text_changed (TextAction* _sender, const gchar* text, gpointer self);
GtkActionGroup* search_filter_actions_get_action_group (SearchFilterActions* self);
SearchFilterCriteria search_filter_actions_get_criteria (SearchFilterActions* self);
GtkAction* search_filter_actions_get_action (SearchFilterActions* self, const gchar* name);
void search_filter_actions_set_action_sensitive (SearchFilterActions* self, const gchar* name, gboolean sensitive);
void search_filter_actions_reset (SearchFilterActions* self);
GtkToggleAction* search_filter_actions_get_flagged (SearchFilterActions* self);
GtkToggleAction* search_filter_actions_get_photos (SearchFilterActions* self);
GtkToggleAction* search_filter_actions_get_raw (SearchFilterActions* self);
GtkToggleAction* search_filter_actions_get_videos (SearchFilterActions* self);
GtkRadioAction* search_filter_actions_get_rating (SearchFilterActions* self);
void search_filter_actions_set_sensitive_for_search_criteria (SearchFilterActions* self, SearchFilterCriteria criteria);
static void search_filter_actions_update_sensitivities (SearchFilterActions* self);
GType page_get_type (void) G_GNUC_CONST;
void search_filter_actions_monitor_page_contents (SearchFilterActions* self, Page* old_page, Page* new_page);
GType checkerboard_page_get_type (void) G_GNUC_CONST;
gpointer core_tracker_ref (gpointer instance);
void core_tracker_unref (gpointer instance);
GParamSpec* core_param_spec_tracker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void core_value_set_tracker (GValue* value, gpointer v_object);
void core_value_take_tracker (GValue* value, gpointer v_object);
gpointer core_value_get_tracker (const GValue* value);
GType core_tracker_get_type (void) G_GNUC_CONST;
GType core_view_tracker_get_type (void) G_GNUC_CONST;
CoreViewTracker* checkerboard_page_get_view_tracker (CheckerboardPage* self);
GType media_view_tracker_get_type (void) G_GNUC_CONST;
static void search_filter_actions_on_media_tracker_updated (SearchFilterActions* self, CoreTracker* t);
static void _search_filter_actions_on_media_tracker_updated_core_tracker_updated (CoreTracker* _sender, gpointer self);
GType camera_view_tracker_get_type (void) G_GNUC_CONST;
static void search_filter_actions_on_camera_tracker_updated (SearchFilterActions* self, CoreTracker* t);
static void _search_filter_actions_on_camera_tracker_updated_core_tracker_updated (CoreTracker* _sender, gpointer self);
GType media_accumulator_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
GType core_tracker_accumulator_get_type (void) G_GNUC_CONST;
GType camera_accumulator_get_type (void) G_GNUC_CONST;
gint camera_accumulator_get_photos (CameraAccumulator* self);
gint camera_accumulator_get_videos (CameraAccumulator* self);
gint camera_accumulator_get_raw (CameraAccumulator* self);
#define RESOURCES_ICON_FILTER_FLAGGED "filter-flagged"
#define RESOURCES_ICON_FILTER_FLAGGED_DISABLED "filter-flagged-disabled"
#define RESOURCES_ICON_FILTER_VIDEOS "filter-videos"
#define RESOURCES_ICON_FILTER_VIDEOS_DISABLED "filter-videos-disabled"
#define RESOURCES_ICON_FILTER_PHOTOS "filter-photos"
#define RESOURCES_ICON_FILTER_PHOTOS_DISABLED "filter-photos-disabled"
#define RESOURCES_ICON_FILTER_RAW "filter-raw"
#define RESOURCES_ICON_FILTER_RAW_DISABLED "filter-raw-disabled"
#define TRANSLATABLE "translatable"
#define RESOURCES_DISPLAY_REJECTED_ONLY_MENU _ ("Rejected _Only")
#define RESOURCES_DISPLAY_REJECTED_ONLY_TOOLTIP _ ("Show only rejected photos")
static void _vala_array_add338 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
#define RESOURCES_DISPLAY_REJECTED_OR_HIGHER_MENU _ ("All + _Rejected")
#define RESOURCES_DISPLAY_REJECTED_OR_HIGHER_TOOLTIP "Show all photos, including rejected"
static void _vala_array_add339 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
#define RESOURCES_DISPLAY_UNRATED_OR_HIGHER_MENU _ ("_All Photos")
#define RESOURCES_DISPLAY_UNRATED_OR_HIGHER_TOOLTIP _ ("Show all photos")
static void _vala_array_add340 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
static void _vala_array_add341 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
static void _vala_array_add342 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
static void _vala_array_add343 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
static void _vala_array_add344 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
static void _vala_array_add345 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value);
static void search_filter_actions_on_rating_changed (SearchFilterActions* self, GtkAction* action, GtkAction* current);
static void _search_filter_actions_on_rating_changed_gtk_radio_action_callback (GtkAction* action, GtkAction* current, gpointer self);
static void search_filter_actions_on_flagged_toggled (SearchFilterActions* self, GtkAction* action);
static void _search_filter_actions_on_flagged_toggled_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add346 (GtkToggleActionEntry** array, int* length, int* size, const GtkToggleActionEntry* value);
static void search_filter_actions_on_photos_toggled (SearchFilterActions* self, GtkAction* action);
static void _search_filter_actions_on_photos_toggled_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add347 (GtkToggleActionEntry** array, int* length, int* size, const GtkToggleActionEntry* value);
static void search_filter_actions_on_videos_toggled (SearchFilterActions* self, GtkAction* action);
static void _search_filter_actions_on_videos_toggled_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add348 (GtkToggleActionEntry** array, int* length, int* size, const GtkToggleActionEntry* value);
static void search_filter_actions_on_raw_toggled (SearchFilterActions* self, GtkAction* action);
static void _search_filter_actions_on_raw_toggled_gtk_action_callback (GtkAction* action, gpointer self);
static void _vala_array_add349 (GtkToggleActionEntry** array, int* length, int* size, const GtkToggleActionEntry* value);
gboolean search_filter_actions_get_has_photos (SearchFilterActions* self);
gboolean search_filter_actions_get_has_videos (SearchFilterActions* self);
gboolean search_filter_actions_get_has_raw (SearchFilterActions* self);
gboolean search_filter_actions_get_has_flagged (SearchFilterActions* self);
static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN_BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void search_filter_actions_finalize (SearchFilterActions* obj);
GType search_filter_toolbar_get_type (void) G_GNUC_CONST;
GType search_filter_toolbar_search_box_get_type (void) G_GNUC_CONST;
GType search_filter_toolbar_rating_filter_button_get_type (void) G_GNUC_CONST;
static GType search_filter_toolbar_label_tool_item_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType search_filter_toolbar_toggle_action_tool_button_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SEARCH_FILTER_TOOLBAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_FILTER_TOOLBAR, SearchFilterToolbarPrivate))
enum  {
	SEARCH_FILTER_TOOLBAR_DUMMY_PROPERTY
};
static void search_filter_toolbar_on_media_context_changed (SearchFilterToolbar* self, gboolean has_photos, gboolean has_videos, gboolean has_raw, gboolean has_flagged);
static void _search_filter_toolbar_on_media_context_changed_search_filter_actions_media_context_changed (SearchFilterActions* _sender, gboolean has_photos, gboolean has_videos, gboolean has_raw, gboolean has_flagged, gpointer self);
static void search_filter_toolbar_on_flagged_toggled (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_flagged_toggled_search_filter_actions_flagged_toggled (SearchFilterActions* _sender, gboolean on, gpointer self);
static void search_filter_toolbar_on_photos_toggled (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_photos_toggled_search_filter_actions_photos_toggled (SearchFilterActions* _sender, gboolean on, gpointer self);
static void search_filter_toolbar_on_videos_toggled (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_videos_toggled_search_filter_actions_videos_toggled (SearchFilterActions* _sender, gboolean on, gpointer self);
static void search_filter_toolbar_on_raw_toggled (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_raw_toggled_search_filter_actions_raw_toggled (SearchFilterActions* _sender, gboolean on, gpointer self);
static void search_filter_toolbar_on_rating_changed (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_rating_changed_search_filter_actions_rating_changed (SearchFilterActions* _sender, RatingFilter filter, gpointer self);
static void search_filter_toolbar_on_search_text_changed (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_search_text_changed_search_filter_actions_text_changed (SearchFilterActions* _sender, const gchar* text, gpointer self);
static void search_filter_toolbar_on_criteria_changed (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_criteria_changed_search_filter_actions_criteria_changed (SearchFilterActions* _sender, gpointer self);
static gboolean search_filter_toolbar_on_context_menu_requested (SearchFilterToolbar* self, gint x, gint y, gint button);
static gboolean _search_filter_toolbar_on_context_menu_requested_gtk_toolbar_popup_context_menu (GtkToolbar* _sender, gint x, gint y, gint button_number, gpointer self);
SearchFilterToolbarRatingFilterButton* search_filter_toolbar_rating_filter_button_new (void);
SearchFilterToolbarRatingFilterButton* search_filter_toolbar_rating_filter_button_construct (GType object_type);
#define SEARCH_FILTER_TOOLBAR_FILTER_BUTTON_MARGIN 12
#define SEARCH_FILTER_TOOLBAR_FILTER_ICON_STAR_SCALE 0.65f
#define SEARCH_FILTER_TOOLBAR_FILTER_ICON_SCALE 0.75f
#define SEARCH_FILTER_TOOLBAR_FILTER_ICON_BASE_WIDTH 30
#define SEARCH_FILTER_TOOLBAR_FILTER_ICON_PLUS_WIDTH 20
SearchFilterToolbar* search_filter_toolbar_new (SearchFilterActions* actions);
SearchFilterToolbar* search_filter_toolbar_construct (GType object_type, SearchFilterActions* actions);
SearchFilterToolbarSearchBox* search_filter_toolbar_search_box_new (TextAction* action);
SearchFilterToolbarSearchBox* search_filter_toolbar_search_box_construct (GType object_type, TextAction* action);
GFile* resources_get_ui (const gchar* filename);
void app_window_panic (const gchar* msg);
static void search_filter_toolbar_on_context_menu_close_chosen (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_context_menu_close_chosen_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static SearchFilterToolbarLabelToolItem* search_filter_toolbar_label_tool_item_new (const gchar* s, gint left_padding, gint right_padding);
static SearchFilterToolbarLabelToolItem* search_filter_toolbar_label_tool_item_construct (GType object_type, const gchar* s, gint left_padding, gint right_padding);
static SearchFilterToolbarToggleActionToolButton* search_filter_toolbar_toggle_action_tool_button_new (GtkToggleAction* action);
static SearchFilterToolbarToggleActionToolButton* search_filter_toolbar_toggle_action_tool_button_construct (GType object_type, GtkToggleAction* action);
static void search_filter_toolbar_toggle_action_tool_button_set_label (SearchFilterToolbarToggleActionToolButton* self, const gchar* label);
void search_filter_toolbar_rating_filter_button_set_label (SearchFilterToolbarRatingFilterButton* self, const gchar* label);
static void search_filter_toolbar_on_filter_button_clicked (SearchFilterToolbar* self);
static void _search_filter_toolbar_on_filter_button_clicked_search_filter_toolbar_rating_filter_button_clicked (SearchFilterToolbarRatingFilterButton* _sender, gpointer self);
static void search_filter_toolbar_toggle_action_tool_button_set_icon_name (SearchFilterToolbarToggleActionToolButton* self, const gchar* icon_name);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
GType library_window_get_type (void) G_GNUC_CONST;
LibraryWindow* library_window_get_app (void);
GtkAction* app_window_get_common_action (AppWindow* self, const gchar* name);
void search_filter_toolbar_update (SearchFilterToolbar* self);
void search_filter_toolbar_set_view_filter (SearchFilterToolbar* self, SearchViewFilter* search_filter);
void search_filter_toolbar_unset_view_filter (SearchFilterToolbar* self);
void library_window_show_search_bar (LibraryWindow* self, gboolean display);
void search_filter_toolbar_rating_filter_button_set_filter_icon (SearchFilterToolbarRatingFilterButton* self, RatingFilter filter);
static void search_filter_toolbar_position_filter_popup (SearchFilterToolbar* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
AppWindow* app_window_get_instance (void);
Page* page_window_get_current_page (PageWindow* self);
GtkMenuBar* page_get_menubar (Page* self);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gint configuration_facade_get_sidebar_position (ConfigurationFacade* self);
static void _search_filter_toolbar_position_filter_popup_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
void search_filter_toolbar_take_focus (SearchFilterToolbar* self);
void search_filter_toolbar_search_box_get_focus (SearchFilterToolbarSearchBox* self);
#define SEARCH_FILTER_TOOLBAR_LABEL_TOOL_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM, SearchFilterToolbarLabelToolItemPrivate))
enum  {
	SEARCH_FILTER_TOOLBAR_LABEL_TOOL_ITEM_DUMMY_PROPERTY
};
static void search_filter_toolbar_label_tool_item_finalize (GObject* obj);
#define SEARCH_FILTER_TOOLBAR_TOGGLE_ACTION_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON, SearchFilterToolbarToggleActionToolButtonPrivate))
enum  {
	SEARCH_FILTER_TOOLBAR_TOGGLE_ACTION_TOOL_BUTTON_DUMMY_PROPERTY
};
static void search_filter_toolbar_toggle_action_tool_button_on_button_activate (SearchFilterToolbarToggleActionToolButton* self);
static void _search_filter_toolbar_toggle_action_tool_button_on_button_activate_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_filter_toolbar_toggle_action_tool_button_finalize (GObject* obj);
#define SEARCH_FILTER_TOOLBAR_SEARCH_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX, SearchFilterToolbarSearchBoxPrivate))
enum  {
	SEARCH_FILTER_TOOLBAR_SEARCH_BOX_DUMMY_PROPERTY
};
static void search_filter_toolbar_search_box_on_action_text_changed (SearchFilterToolbarSearchBox* self, const gchar* text);
static void _search_filter_toolbar_search_box_on_action_text_changed_text_action_text_changed (TextAction* _sender, const gchar* text, gpointer self);
static void search_filter_toolbar_search_box_on_sensitivity_changed (SearchFilterToolbarSearchBox* self, gboolean sensitive);
static void _search_filter_toolbar_search_box_on_sensitivity_changed_text_action_sensitivity_changed (TextAction* _sender, gboolean sensitive, gpointer self);
static void search_filter_toolbar_search_box_on_visibility_changed (SearchFilterToolbarSearchBox* self, gboolean visible);
static void _search_filter_toolbar_search_box_on_visibility_changed_text_action_visibility_changed (TextAction* _sender, gboolean visible, gpointer self);
static void search_filter_toolbar_search_box_on_entry_changed (SearchFilterToolbarSearchBox* self);
static void _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self);
static void _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender, guint position, const gchar* chars, guint n_chars, gpointer self);
static gboolean search_filter_toolbar_search_box_on_escape_key (SearchFilterToolbarSearchBox* self, GdkEventKey* e);
static gboolean _search_filter_toolbar_search_box_on_escape_key_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void search_filter_toolbar_search_box_set_nullable_text (SearchFilterToolbarSearchBox* self, const gchar* text);
static void search_filter_toolbar_search_box_finalize (GObject* obj);
enum  {
	SEARCH_FILTER_TOOLBAR_RATING_FILTER_BUTTON_DUMMY_PROPERTY
};
static void search_filter_toolbar_rating_filter_button_on_clicked (SearchFilterToolbarRatingFilterButton* self);
static void _search_filter_toolbar_rating_filter_button_on_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GtkWidget* search_filter_toolbar_rating_filter_button_get_filter_icon (SearchFilterToolbarRatingFilterButton* self, RatingFilter filter);
#define RESOURCES_ICON_FILTER_ONE_OR_BETTER "one-star-filter-plus.svg"
#define RESOURCES_ICON_FILTER_TWO_OR_BETTER "two-star-filter-plus.svg"
#define RESOURCES_ICON_FILTER_THREE_OR_BETTER "three-star-filter-plus.svg"
#define RESOURCES_ICON_FILTER_FOUR_OR_BETTER "four-star-filter-plus.svg"
#define RESOURCES_ICON_FILTER_FIVE "five-star-filter.svg"
#define RESOURCES_ICON_FILTER_REJECTED_OR_BETTER "all-rejected.png"
#define RESOURCES_ICON_RATING_REJECTED "rejected.svg"
#define RESOURCES_ICON_FILTER_UNRATED_OR_BETTER "shotwell-16.png"
GdkPixbuf* resources_load_icon (const gchar* name, gint scale);
static gint search_filter_toolbar_rating_filter_button_get_filter_icon_size (SearchFilterToolbarRatingFilterButton* self, RatingFilter filter);
#define RESOURCES_ICON_FILTER_REJECTED_OR_BETTER_FIXED_SIZE 32
#define RESOURCES_ICON_FILTER_UNRATED_OR_BETTER_FIXED_SIZE 16
static gint search_filter_toolbar_rating_filter_button_get_filter_button_size (SearchFilterToolbarRatingFilterButton* self, RatingFilter filter);
gchar* resources_get_rating_filter_tooltip (RatingFilter filter);
static void search_filter_toolbar_rating_filter_button_finalize (GObject* obj);
static void search_filter_toolbar_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType search_filter_criteria_get_type (void) {
	static volatile gsize search_filter_criteria_type_id__volatile = 0;
	if (g_once_init_enter (&search_filter_criteria_type_id__volatile)) {
		static const GFlagsValue values[] = {{SEARCH_FILTER_CRITERIA_NONE, "SEARCH_FILTER_CRITERIA_NONE", "none"}, {SEARCH_FILTER_CRITERIA_RECURSIVE, "SEARCH_FILTER_CRITERIA_RECURSIVE", "recursive"}, {SEARCH_FILTER_CRITERIA_TEXT, "SEARCH_FILTER_CRITERIA_TEXT", "text"}, {SEARCH_FILTER_CRITERIA_FLAG, "SEARCH_FILTER_CRITERIA_FLAG", "flag"}, {SEARCH_FILTER_CRITERIA_MEDIA, "SEARCH_FILTER_CRITERIA_MEDIA", "media"}, {SEARCH_FILTER_CRITERIA_RATING, "SEARCH_FILTER_CRITERIA_RATING", "rating"}, {SEARCH_FILTER_CRITERIA_ALL, "SEARCH_FILTER_CRITERIA_ALL", "all"}, {0, NULL, NULL}};
		GType search_filter_criteria_type_id;
		search_filter_criteria_type_id = g_flags_register_static ("SearchFilterCriteria", values);
		g_once_init_leave (&search_filter_criteria_type_id__volatile, search_filter_criteria_type_id);
	}
	return search_filter_criteria_type_id__volatile;
}


GType rating_filter_get_type (void) {
	static volatile gsize rating_filter_type_id__volatile = 0;
	if (g_once_init_enter (&rating_filter_type_id__volatile)) {
		static const GEnumValue values[] = {{RATING_FILTER_NO_FILTER, "RATING_FILTER_NO_FILTER", "no-filter"}, {RATING_FILTER_REJECTED_OR_HIGHER, "RATING_FILTER_REJECTED_OR_HIGHER", "rejected-or-higher"}, {RATING_FILTER_UNRATED_OR_HIGHER, "RATING_FILTER_UNRATED_OR_HIGHER", "unrated-or-higher"}, {RATING_FILTER_ONE_OR_HIGHER, "RATING_FILTER_ONE_OR_HIGHER", "one-or-higher"}, {RATING_FILTER_TWO_OR_HIGHER, "RATING_FILTER_TWO_OR_HIGHER", "two-or-higher"}, {RATING_FILTER_THREE_OR_HIGHER, "RATING_FILTER_THREE_OR_HIGHER", "three-or-higher"}, {RATING_FILTER_FOUR_OR_HIGHER, "RATING_FILTER_FOUR_OR_HIGHER", "four-or-higher"}, {RATING_FILTER_FIVE_OR_HIGHER, "RATING_FILTER_FIVE_OR_HIGHER", "five-or-higher"}, {RATING_FILTER_REJECTED_ONLY, "RATING_FILTER_REJECTED_ONLY", "rejected-only"}, {RATING_FILTER_UNRATED_ONLY, "RATING_FILTER_UNRATED_ONLY", "unrated-only"}, {RATING_FILTER_ONE_ONLY, "RATING_FILTER_ONE_ONLY", "one-only"}, {RATING_FILTER_TWO_ONLY, "RATING_FILTER_TWO_ONLY", "two-only"}, {RATING_FILTER_THREE_ONLY, "RATING_FILTER_THREE_ONLY", "three-only"}, {RATING_FILTER_FOUR_ONLY, "RATING_FILTER_FOUR_ONLY", "four-only"}, {RATING_FILTER_FIVE_ONLY, "RATING_FILTER_FIVE_ONLY", "five-only"}, {0, NULL, NULL}};
		GType rating_filter_type_id;
		rating_filter_type_id = g_enum_register_static ("RatingFilter", values);
		g_once_init_leave (&rating_filter_type_id__volatile, rating_filter_type_id);
	}
	return rating_filter_type_id__volatile;
}


static guint search_view_filter_real_get_criteria (SearchViewFilter* self) {
#line 61 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_critical ("Type `%s' does not implement abstract method `search_view_filter_get_criteria'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 61 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return 0U;
#line 1248 "SearchFilter.c"
}


guint search_view_filter_get_criteria (SearchViewFilter* self) {
#line 61 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), 0U);
#line 61 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return SEARCH_VIEW_FILTER_GET_CLASS (self)->get_criteria (self);
#line 1257 "SearchFilter.c"
}


void search_view_filter_set_rating_filter (SearchViewFilter* self, RatingFilter rf) {
	RatingFilter _tmp0_ = 0;
	RatingFilter _tmp1_ = 0;
#line 63 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_VIEW_FILTER (self));
#line 64 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = rf;
#line 64 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->rating_filter = _tmp0_;
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = self->priv->rating_filter;
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	switch (_tmp1_) {
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_REJECTED_ONLY:
#line 1276 "SearchFilter.c"
		{
#line 67 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_REJECTED;
#line 68 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = FALSE;
#line 69 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1284 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_REJECTED_OR_HIGHER:
#line 1288 "SearchFilter.c"
		{
#line 72 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_REJECTED;
#line 73 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = TRUE;
#line 74 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1296 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_ONE_OR_HIGHER:
#line 1300 "SearchFilter.c"
		{
#line 77 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_ONE;
#line 78 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = TRUE;
#line 79 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1308 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_ONE_ONLY:
#line 1312 "SearchFilter.c"
		{
#line 82 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_ONE;
#line 83 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = FALSE;
#line 84 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1320 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_TWO_OR_HIGHER:
#line 1324 "SearchFilter.c"
		{
#line 87 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_TWO;
#line 88 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = TRUE;
#line 89 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1332 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_TWO_ONLY:
#line 1336 "SearchFilter.c"
		{
#line 92 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_TWO;
#line 93 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = FALSE;
#line 94 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1344 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_THREE_OR_HIGHER:
#line 1348 "SearchFilter.c"
		{
#line 97 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_THREE;
#line 98 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = TRUE;
#line 99 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1356 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_THREE_ONLY:
#line 1360 "SearchFilter.c"
		{
#line 102 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_THREE;
#line 103 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = FALSE;
#line 104 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1368 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FOUR_OR_HIGHER:
#line 1372 "SearchFilter.c"
		{
#line 107 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_FOUR;
#line 108 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = TRUE;
#line 109 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1380 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FOUR_ONLY:
#line 1384 "SearchFilter.c"
		{
#line 112 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_FOUR;
#line 113 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = FALSE;
#line 114 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1392 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FIVE_OR_HIGHER:
#line 1396 "SearchFilter.c"
		{
#line 117 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_FIVE;
#line 118 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = TRUE;
#line 119 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1404 "SearchFilter.c"
		}
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FIVE_ONLY:
#line 1408 "SearchFilter.c"
		{
#line 122 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_FIVE;
#line 123 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = FALSE;
#line 124 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1416 "SearchFilter.c"
		}
		default:
#line 65 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_UNRATED_OR_HIGHER:
#line 1421 "SearchFilter.c"
		{
#line 128 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating = RATING_UNRATED;
#line 129 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			self->priv->rating_allow_higher = TRUE;
#line 130 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 1429 "SearchFilter.c"
		}
	}
}


gboolean search_view_filter_has_search_filter (SearchViewFilter* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 134 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), FALSE);
#line 135 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->search_filter;
#line 135 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 135 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = !_tmp1_;
#line 135 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1449 "SearchFilter.c"
}


const gchar* search_view_filter_get_search_filter (SearchViewFilter* self) {
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), NULL);
#line 139 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->search_filter;
#line 139 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 139 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1464 "SearchFilter.c"
}


gchar** search_view_filter_get_search_filter_words (SearchViewFilter* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
#line 142 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), NULL);
#line 143 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->search_filter_words;
#line 143 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0__length1 = self->priv->search_filter_words_length1;
#line 143 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _tmp0_;
#line 143 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1__length1 = _tmp0__length1;
#line 143 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (result_length1) {
#line 143 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*result_length1 = _tmp1__length1;
#line 1488 "SearchFilter.c"
	}
#line 143 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp1_;
#line 143 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1494 "SearchFilter.c"
}


static gchar** _vala_array_dup33 (gchar** self, int length) {
	gchar** result;
	int i;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = g_new0 (gchar*, length + 1);
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	for (i = 0; i < length; i++) {
#line 1505 "SearchFilter.c"
		gchar* _tmp0_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = g_strdup (self[i]);
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		result[i] = _tmp0_;
#line 1511 "SearchFilter.c"
	}
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1515 "SearchFilter.c"
}


void search_view_filter_set_search_filter (SearchViewFilter* self, const gchar* text) {
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint __tmp6__size_ = 0;
	const gchar* _tmp7_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
#line 146 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_VIEW_FILTER (self));
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = text;
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = is_string_empty (_tmp1_);
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (!_tmp2_) {
#line 1538 "SearchFilter.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp3_ = text;
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_free0 (_tmp0_);
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = _tmp4_;
#line 1549 "SearchFilter.c"
	} else {
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_free0 (_tmp0_);
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = NULL;
#line 1555 "SearchFilter.c"
	}
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = g_strdup (_tmp0_);
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_free0 (self->priv->search_filter);
#line 147 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter = _tmp5_;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = self->priv->search_filter;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp7_ != NULL) {
#line 1567 "SearchFilter.c"
		const gchar* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gchar** _tmp10_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp8_ = self->priv->search_filter;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6_ = _tmp10_;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6__length1 = _vala_array_length (_tmp9_);
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		__tmp6__size_ = _tmp6__length1;
#line 1583 "SearchFilter.c"
	} else {
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6__length1 = 0;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		__tmp6__size_ = _tmp6__length1;
#line 1593 "SearchFilter.c"
	}
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = (_tmp6_ != NULL) ? _vala_array_dup33 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11__length1 = _tmp6__length1;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words = (_vala_array_free (self->priv->search_filter_words, self->priv->search_filter_words_length1, (GDestroyNotify) g_free), NULL);
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words = _tmp11_;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words_length1 = _tmp11__length1;
#line 148 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_search_filter_words_size_ = self->priv->search_filter_words_length1;
#line 146 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 146 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_free0 (_tmp0_);
#line 1611 "SearchFilter.c"
}


void search_view_filter_clear_search_filter (SearchViewFilter* self) {
#line 151 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_VIEW_FILTER (self));
#line 152 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_free0 (self->priv->search_filter);
#line 152 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter = NULL;
#line 153 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words = (_vala_array_free (self->priv->search_filter_words, self->priv->search_filter_words_length1, (GDestroyNotify) g_free), NULL);
#line 153 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words = NULL;
#line 153 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words_length1 = 0;
#line 153 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_search_filter_words_size_ = self->priv->search_filter_words_length1;
#line 1630 "SearchFilter.c"
}


gboolean search_view_filter_get_rating_allow_higher (SearchViewFilter* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 156 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), FALSE);
#line 157 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->rating_allow_higher;
#line 157 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 157 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1645 "SearchFilter.c"
}


Rating search_view_filter_get_rating (SearchViewFilter* self) {
	Rating result = 0;
	Rating _tmp0_ = 0;
#line 160 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), 0);
#line 161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->rating;
#line 161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1660 "SearchFilter.c"
}


gboolean search_view_filter_filter_by_media_type (SearchViewFilter* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 164 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), FALSE);
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = self->priv->_show_media_video;
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp3_) {
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = TRUE;
#line 1678 "SearchFilter.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp4_ = self->priv->_show_media_photos;
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = _tmp4_;
#line 1685 "SearchFilter.c"
	}
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp2_) {
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp1_ = TRUE;
#line 1691 "SearchFilter.c"
	} else {
		gboolean _tmp5_ = FALSE;
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp5_ = self->priv->_show_media_raw;
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp1_ = _tmp5_;
#line 1698 "SearchFilter.c"
	}
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp1_) {
#line 1702 "SearchFilter.c"
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp8_ = self->priv->_show_media_video;
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp8_) {
#line 1710 "SearchFilter.c"
			gboolean _tmp9_ = FALSE;
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp9_ = self->priv->_show_media_photos;
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp7_ = _tmp9_;
#line 1716 "SearchFilter.c"
		} else {
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp7_ = FALSE;
#line 1720 "SearchFilter.c"
		}
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp7_) {
#line 1724 "SearchFilter.c"
			gboolean _tmp10_ = FALSE;
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp10_ = self->priv->_show_media_raw;
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp6_ = _tmp10_;
#line 1730 "SearchFilter.c"
		} else {
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp6_ = FALSE;
#line 1734 "SearchFilter.c"
		}
#line 166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = !_tmp6_;
#line 1738 "SearchFilter.c"
	} else {
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = FALSE;
#line 1742 "SearchFilter.c"
	}
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1748 "SearchFilter.c"
}


SearchViewFilter* search_view_filter_construct (GType object_type) {
	SearchViewFilter* self = NULL;
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (SearchViewFilter*) view_filter_construct (object_type);
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 1758 "SearchFilter.c"
}


gboolean search_view_filter_get_flagged (SearchViewFilter* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 47 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), FALSE);
#line 47 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->_flagged;
#line 47 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 47 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1773 "SearchFilter.c"
}


void search_view_filter_set_flagged (SearchViewFilter* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 47 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_VIEW_FILTER (self));
#line 47 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = value;
#line 47 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_flagged = _tmp0_;
#line 1785 "SearchFilter.c"
}


gboolean search_view_filter_get_show_media_video (SearchViewFilter* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 50 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), FALSE);
#line 50 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->_show_media_video;
#line 50 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1800 "SearchFilter.c"
}


void search_view_filter_set_show_media_video (SearchViewFilter* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 50 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_VIEW_FILTER (self));
#line 50 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_show_media_video = _tmp0_;
#line 1812 "SearchFilter.c"
}


gboolean search_view_filter_get_show_media_photos (SearchViewFilter* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 51 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), FALSE);
#line 51 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->_show_media_photos;
#line 51 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1827 "SearchFilter.c"
}


void search_view_filter_set_show_media_photos (SearchViewFilter* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 51 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_VIEW_FILTER (self));
#line 51 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = value;
#line 51 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_show_media_photos = _tmp0_;
#line 1839 "SearchFilter.c"
}


gboolean search_view_filter_get_show_media_raw (SearchViewFilter* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 52 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_VIEW_FILTER (self), FALSE);
#line 52 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->_show_media_raw;
#line 52 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 52 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 1854 "SearchFilter.c"
}


void search_view_filter_set_show_media_raw (SearchViewFilter* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 52 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_VIEW_FILTER (self));
#line 52 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = value;
#line 52 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_show_media_raw = _tmp0_;
#line 1866 "SearchFilter.c"
}


static void search_view_filter_class_init (SearchViewFilterClass * klass) {
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_view_filter_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	((ViewFilterClass *) klass)->finalize = search_view_filter_finalize;
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_type_class_add_private (klass, sizeof (SearchViewFilterPrivate));
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	((SearchViewFilterClass *) klass)->get_criteria = search_view_filter_real_get_criteria;
#line 1879 "SearchFilter.c"
}


static void search_view_filter_instance_init (SearchViewFilter * self) {
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv = SEARCH_VIEW_FILTER_GET_PRIVATE (self);
#line 40 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->rating_allow_higher = TRUE;
#line 43 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->rating = RATING_UNRATED;
#line 44 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->rating_filter = RATING_FILTER_UNRATED_OR_HIGHER;
#line 47 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_flagged = FALSE;
#line 50 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_show_media_video = TRUE;
#line 51 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_show_media_photos = TRUE;
#line 52 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_show_media_raw = TRUE;
#line 55 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter = NULL;
#line 56 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words = NULL;
#line 56 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words_length1 = 0;
#line 56 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_search_filter_words_size_ = self->priv->search_filter_words_length1;
#line 1908 "SearchFilter.c"
}


static void search_view_filter_finalize (ViewFilter* obj) {
	SearchViewFilter * self;
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter);
#line 55 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_free0 (self->priv->search_filter);
#line 56 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter_words = (_vala_array_free (self->priv->search_filter_words, self->priv->search_filter_words_length1, (GDestroyNotify) g_free), NULL);
#line 38 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	VIEW_FILTER_CLASS (search_view_filter_parent_class)->finalize (obj);
#line 1922 "SearchFilter.c"
}


GType search_view_filter_get_type (void) {
	static volatile gsize search_view_filter_type_id__volatile = 0;
	if (g_once_init_enter (&search_view_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchViewFilter), 0, (GInstanceInitFunc) search_view_filter_instance_init, NULL };
		GType search_view_filter_type_id;
		search_view_filter_type_id = g_type_register_static (TYPE_VIEW_FILTER, "SearchViewFilter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&search_view_filter_type_id__volatile, search_view_filter_type_id);
	}
	return search_view_filter_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self ? g_object_ref (self) : NULL;
#line 1941 "SearchFilter.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/home/jens/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/home/jens/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/home/jens/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/home/jens/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/home/jens/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/home/jens/jhbuild/install/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1961 "SearchFilter.c"
}


static gboolean default_search_view_filter_real_predicate (ViewFilter* base, DataView* view) {
	DefaultSearchViewFilter * self;
	gboolean result = FALSE;
	MediaSource* source = NULL;
	DataView* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	guint criteria = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp14_ = 0U;
	gboolean _tmp22_ = FALSE;
	guint _tmp23_ = 0U;
	gboolean _tmp44_ = FALSE;
	guint _tmp45_ = 0U;
#line 173 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DEFAULT_SEARCH_VIEW_FILTER, DefaultSearchViewFilter);
#line 173 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_DATA_VIEW (view), FALSE);
#line 174 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = view;
#line 174 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = thumbnail_get_media_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_THUMBNAIL, Thumbnail));
#line 174 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	source = _tmp1_;
#line 175 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = search_view_filter_get_criteria (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 175 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	criteria = _tmp2_;
#line 178 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = criteria;
#line 178 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((SEARCH_FILTER_CRITERIA_RATING & _tmp3_) != 0) {
#line 1997 "SearchFilter.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp5_ = search_view_filter_get_rating_allow_higher (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp5_) {
#line 2004 "SearchFilter.c"
			MediaSource* _tmp6_ = NULL;
			Rating _tmp7_ = 0;
			Rating _tmp8_ = 0;
#line 179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp6_ = source;
#line 179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp7_ = media_source_get_rating (_tmp6_);
#line 179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp8_ = search_view_filter_get_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp4_ = _tmp7_ < _tmp8_;
#line 2016 "SearchFilter.c"
		} else {
#line 179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp4_ = FALSE;
#line 2020 "SearchFilter.c"
		}
#line 179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp4_) {
#line 180 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = FALSE;
#line 180 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_object_unref0 (source);
#line 180 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 2030 "SearchFilter.c"
		} else {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
#line 181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp10_ = search_view_filter_get_rating_allow_higher (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			if (!_tmp10_) {
#line 2038 "SearchFilter.c"
				MediaSource* _tmp11_ = NULL;
				Rating _tmp12_ = 0;
				Rating _tmp13_ = 0;
#line 181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp11_ = source;
#line 181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp12_ = media_source_get_rating (_tmp11_);
#line 181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp13_ = search_view_filter_get_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp9_ = _tmp12_ != _tmp13_;
#line 2050 "SearchFilter.c"
			} else {
#line 181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp9_ = FALSE;
#line 2054 "SearchFilter.c"
			}
#line 181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			if (_tmp9_) {
#line 182 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				result = FALSE;
#line 182 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_g_object_unref0 (source);
#line 182 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				return result;
#line 2064 "SearchFilter.c"
			}
		}
	}
#line 186 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp14_ = criteria;
#line 186 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((SEARCH_FILTER_CRITERIA_FLAG & _tmp14_) != 0) {
#line 2072 "SearchFilter.c"
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp17_ = search_view_filter_get_flagged (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp18_ = _tmp17_;
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp18_) {
#line 2083 "SearchFilter.c"
			MediaSource* _tmp19_ = NULL;
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp19_ = source;
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, TYPE_FLAGGABLE);
#line 2089 "SearchFilter.c"
		} else {
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp16_ = FALSE;
#line 2093 "SearchFilter.c"
		}
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp16_) {
#line 2097 "SearchFilter.c"
			MediaSource* _tmp20_ = NULL;
			gboolean _tmp21_ = FALSE;
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp20_ = source;
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp21_ = flaggable_is_flagged (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_FLAGGABLE, Flaggable));
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp15_ = !_tmp21_;
#line 2106 "SearchFilter.c"
		} else {
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp15_ = FALSE;
#line 2110 "SearchFilter.c"
		}
#line 187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp15_) {
#line 188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = FALSE;
#line 188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_object_unref0 (source);
#line 188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 2120 "SearchFilter.c"
		}
	}
#line 192 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp23_ = criteria;
#line 192 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((SEARCH_FILTER_CRITERIA_MEDIA & _tmp23_) != 0) {
#line 2127 "SearchFilter.c"
		gboolean _tmp24_ = FALSE;
#line 192 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp24_ = search_view_filter_filter_by_media_type (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 192 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp22_ = _tmp24_;
#line 2133 "SearchFilter.c"
	} else {
#line 192 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp22_ = FALSE;
#line 2137 "SearchFilter.c"
	}
#line 192 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp22_) {
#line 2141 "SearchFilter.c"
		MediaSource* _tmp25_ = NULL;
#line 193 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp25_ = source;
#line 193 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, TYPE_VIDEO_SOURCE)) {
#line 2147 "SearchFilter.c"
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
#line 194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp26_ = search_view_filter_get_show_media_video (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp27_ = _tmp26_;
#line 194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			if (!_tmp27_) {
#line 195 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				result = FALSE;
#line 195 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_g_object_unref0 (source);
#line 195 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				return result;
#line 2162 "SearchFilter.c"
			}
		} else {
			MediaSource* _tmp28_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp28_ = source;
#line 196 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, TYPE_PHOTO)) {
#line 2170 "SearchFilter.c"
				Photo* photo = NULL;
				MediaSource* _tmp29_ = NULL;
				Photo* _tmp30_ = NULL;
				Photo* _tmp31_ = NULL;
				PhotoFileFormat _tmp32_ = 0;
#line 197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp29_ = source;
#line 197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, TYPE_PHOTO) ? ((Photo*) _tmp29_) : NULL);
#line 197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				photo = _tmp30_;
#line 198 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp31_ = photo;
#line 198 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp32_ = photo_get_master_file_format (_tmp31_);
#line 198 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				if (_tmp32_ == PHOTO_FILE_FORMAT_RAW) {
#line 2188 "SearchFilter.c"
					Photo* _tmp33_ = NULL;
					gboolean _tmp34_ = FALSE;
#line 199 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_tmp33_ = photo;
#line 199 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_tmp34_ = photo_is_raw_developer_available (_tmp33_, RAW_DEVELOPER_CAMERA);
#line 199 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					if (_tmp34_) {
#line 2197 "SearchFilter.c"
						gboolean _tmp35_ = FALSE;
						gboolean _tmp36_ = FALSE;
						gboolean _tmp37_ = FALSE;
#line 200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp36_ = search_view_filter_get_show_media_photos (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp37_ = _tmp36_;
#line 200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						if (!_tmp37_) {
#line 2207 "SearchFilter.c"
							gboolean _tmp38_ = FALSE;
							gboolean _tmp39_ = FALSE;
#line 200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							_tmp38_ = search_view_filter_get_show_media_raw (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							_tmp39_ = _tmp38_;
#line 200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							_tmp35_ = !_tmp39_;
#line 2216 "SearchFilter.c"
						} else {
#line 200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							_tmp35_ = FALSE;
#line 2220 "SearchFilter.c"
						}
#line 200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						if (_tmp35_) {
#line 201 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							result = FALSE;
#line 201 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							_g_object_unref0 (photo);
#line 201 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							_g_object_unref0 (source);
#line 201 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							return result;
#line 2232 "SearchFilter.c"
						}
					} else {
						gboolean _tmp40_ = FALSE;
						gboolean _tmp41_ = FALSE;
#line 202 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp40_ = search_view_filter_get_show_media_raw (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 202 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp41_ = _tmp40_;
#line 202 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						if (!_tmp41_) {
#line 203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							result = FALSE;
#line 203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							_g_object_unref0 (photo);
#line 203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							_g_object_unref0 (source);
#line 203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							return result;
#line 2251 "SearchFilter.c"
						}
					}
				} else {
					gboolean _tmp42_ = FALSE;
					gboolean _tmp43_ = FALSE;
#line 205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_tmp42_ = search_view_filter_get_show_media_photos (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_tmp43_ = _tmp42_;
#line 205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					if (!_tmp43_) {
#line 206 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						result = FALSE;
#line 206 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_g_object_unref0 (photo);
#line 206 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_g_object_unref0 (source);
#line 206 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						return result;
#line 2271 "SearchFilter.c"
					}
				}
#line 196 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_g_object_unref0 (photo);
#line 2276 "SearchFilter.c"
			}
		}
	}
#line 210 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_ = criteria;
#line 210 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((SEARCH_FILTER_CRITERIA_TEXT & _tmp45_) != 0) {
#line 2284 "SearchFilter.c"
		gboolean _tmp46_ = FALSE;
#line 210 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp46_ = search_view_filter_has_search_filter (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 210 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp44_ = _tmp46_;
#line 2290 "SearchFilter.c"
	} else {
#line 210 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp44_ = FALSE;
#line 2294 "SearchFilter.c"
	}
#line 210 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp44_) {
#line 2298 "SearchFilter.c"
		const gchar* media_keywords = NULL;
		MediaSource* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		const gchar* event_keywords = NULL;
		Event* event = NULL;
		MediaSource* _tmp49_ = NULL;
		Event* _tmp50_ = NULL;
		Event* _tmp51_ = NULL;
		GeeList* tags = NULL;
		TagSourceCollection* _tmp54_ = NULL;
		MediaSource* _tmp55_ = NULL;
		GeeList* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		GeeList* _tmp58_ = NULL;
		gint tags_size = 0;
		gint _tmp62_ = 0;
		gchar** _tmp63_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp47_ = source;
#line 211 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp48_ = indexable_get_indexable_keywords (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, TYPE_INDEXABLE, Indexable));
#line 211 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		media_keywords = _tmp48_;
#line 213 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		event_keywords = NULL;
#line 214 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp49_ = source;
#line 214 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp50_ = media_source_get_event (_tmp49_);
#line 214 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		event = _tmp50_;
#line 215 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp51_ = event;
#line 215 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp51_ != NULL) {
#line 2334 "SearchFilter.c"
			Event* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
#line 216 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp52_ = event;
#line 216 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp53_ = indexable_get_indexable_keywords (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, TYPE_INDEXABLE, Indexable));
#line 216 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			event_keywords = _tmp53_;
#line 2343 "SearchFilter.c"
		}
#line 218 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp54_ = tag_global;
#line 218 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp55_ = source;
#line 218 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp56_ = tag_source_collection_fetch_for_source (_tmp54_, _tmp55_);
#line 218 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		tags = _tmp56_;
#line 219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp58_ = tags;
#line 219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp58_ != NULL) {
#line 2357 "SearchFilter.c"
			GeeList* _tmp59_ = NULL;
			gint _tmp60_ = 0;
			gint _tmp61_ = 0;
#line 219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp59_ = tags;
#line 219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp60_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_COLLECTION, GeeCollection));
#line 219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp61_ = _tmp60_;
#line 219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp57_ = _tmp61_;
#line 2369 "SearchFilter.c"
		} else {
#line 219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp57_ = 0;
#line 2373 "SearchFilter.c"
		}
#line 219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		tags_size = _tmp57_;
#line 221 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp63_ = search_view_filter_get_search_filter_words (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter), &_tmp62_);
#line 2379 "SearchFilter.c"
		{
			gchar** word_collection = NULL;
			gint word_collection_length1 = 0;
			gint _word_collection_size_ = 0;
			gint word_it = 0;
#line 221 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			word_collection = _tmp63_;
#line 221 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			word_collection_length1 = _tmp62_;
#line 221 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			for (word_it = 0; word_it < _tmp62_; word_it = word_it + 1) {
#line 2391 "SearchFilter.c"
				const gchar* word = NULL;
#line 221 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				word = word_collection[word_it];
#line 2395 "SearchFilter.c"
				{
					gboolean _tmp64_ = FALSE;
					const gchar* _tmp65_ = NULL;
					gboolean _tmp69_ = FALSE;
					const gchar* _tmp70_ = NULL;
					gint _tmp74_ = 0;
#line 222 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_tmp65_ = media_keywords;
#line 222 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					if (_tmp65_ != NULL) {
#line 2406 "SearchFilter.c"
						const gchar* _tmp66_ = NULL;
						const gchar* _tmp67_ = NULL;
						gboolean _tmp68_ = FALSE;
#line 222 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp66_ = media_keywords;
#line 222 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp67_ = word;
#line 222 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp68_ = string_contains (_tmp66_, _tmp67_);
#line 222 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp64_ = _tmp68_;
#line 2418 "SearchFilter.c"
					} else {
#line 222 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp64_ = FALSE;
#line 2422 "SearchFilter.c"
					}
#line 222 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					if (_tmp64_) {
#line 223 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						continue;
#line 2428 "SearchFilter.c"
					}
#line 225 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_tmp70_ = event_keywords;
#line 225 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					if (_tmp70_ != NULL) {
#line 2434 "SearchFilter.c"
						const gchar* _tmp71_ = NULL;
						const gchar* _tmp72_ = NULL;
						gboolean _tmp73_ = FALSE;
#line 225 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp71_ = event_keywords;
#line 225 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp72_ = word;
#line 225 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp73_ = string_contains (_tmp71_, _tmp72_);
#line 225 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp69_ = _tmp73_;
#line 2446 "SearchFilter.c"
					} else {
#line 225 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp69_ = FALSE;
#line 2450 "SearchFilter.c"
					}
#line 225 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					if (_tmp69_) {
#line 226 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						continue;
#line 2456 "SearchFilter.c"
					}
#line 228 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_tmp74_ = tags_size;
#line 228 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					if (_tmp74_ > 0) {
#line 2462 "SearchFilter.c"
						gboolean found = FALSE;
						gboolean _tmp90_ = FALSE;
#line 229 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						found = FALSE;
#line 2467 "SearchFilter.c"
						{
							gint ctr = 0;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							ctr = 0;
#line 2472 "SearchFilter.c"
							{
								gboolean _tmp75_ = FALSE;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
								_tmp75_ = TRUE;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
								while (TRUE) {
#line 2479 "SearchFilter.c"
									gint _tmp77_ = 0;
									gint _tmp78_ = 0;
									const gchar* tag_keywords = NULL;
									GeeList* _tmp79_ = NULL;
									gint _tmp80_ = 0;
									gpointer _tmp81_ = NULL;
									Tag* _tmp82_ = NULL;
									const gchar* _tmp83_ = NULL;
									const gchar* _tmp84_ = NULL;
									gboolean _tmp85_ = FALSE;
									const gchar* _tmp86_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									if (!_tmp75_) {
#line 2493 "SearchFilter.c"
										gint _tmp76_ = 0;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										_tmp76_ = ctr;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										ctr = _tmp76_ + 1;
#line 2499 "SearchFilter.c"
									}
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp75_ = FALSE;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp77_ = ctr;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp78_ = tags_size;
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									if (!(_tmp77_ < _tmp78_)) {
#line 230 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										break;
#line 2511 "SearchFilter.c"
									}
#line 231 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp79_ = tags;
#line 231 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp80_ = ctr;
#line 231 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp81_ = gee_list_get (_tmp79_, _tmp80_);
#line 231 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp82_ = (Tag*) _tmp81_;
#line 231 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp83_ = indexable_get_indexable_keywords (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, TYPE_INDEXABLE, Indexable));
#line 231 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp84_ = _tmp83_;
#line 231 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_g_object_unref0 (_tmp82_);
#line 231 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									tag_keywords = _tmp84_;
#line 232 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									_tmp86_ = tag_keywords;
#line 232 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									if (_tmp86_ != NULL) {
#line 2533 "SearchFilter.c"
										const gchar* _tmp87_ = NULL;
										const gchar* _tmp88_ = NULL;
										gboolean _tmp89_ = FALSE;
#line 232 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										_tmp87_ = tag_keywords;
#line 232 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										_tmp88_ = word;
#line 232 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										_tmp89_ = string_contains (_tmp87_, _tmp88_);
#line 232 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										_tmp85_ = _tmp89_;
#line 2545 "SearchFilter.c"
									} else {
#line 232 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										_tmp85_ = FALSE;
#line 2549 "SearchFilter.c"
									}
#line 232 "/home/jens/Source/shotwell/src/SearchFilter.vala"
									if (_tmp85_) {
#line 233 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										found = TRUE;
#line 235 "/home/jens/Source/shotwell/src/SearchFilter.vala"
										break;
#line 2557 "SearchFilter.c"
									}
								}
							}
						}
#line 239 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						_tmp90_ = found;
#line 239 "/home/jens/Source/shotwell/src/SearchFilter.vala"
						if (_tmp90_) {
#line 240 "/home/jens/Source/shotwell/src/SearchFilter.vala"
							continue;
#line 2568 "SearchFilter.c"
						}
					}
#line 245 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					result = FALSE;
#line 245 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_g_object_unref0 (tags);
#line 245 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_g_object_unref0 (event);
#line 245 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					_g_object_unref0 (source);
#line 245 "/home/jens/Source/shotwell/src/SearchFilter.vala"
					return result;
#line 2581 "SearchFilter.c"
				}
			}
		}
#line 210 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (tags);
#line 210 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (event);
#line 2589 "SearchFilter.c"
	}
#line 249 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = TRUE;
#line 249 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (source);
#line 249 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 2597 "SearchFilter.c"
}


DefaultSearchViewFilter* default_search_view_filter_construct (GType object_type) {
	DefaultSearchViewFilter* self = NULL;
#line 172 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (DefaultSearchViewFilter*) search_view_filter_construct (object_type);
#line 172 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 2607 "SearchFilter.c"
}


static void default_search_view_filter_class_init (DefaultSearchViewFilterClass * klass) {
#line 172 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	default_search_view_filter_parent_class = g_type_class_peek_parent (klass);
#line 172 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	((ViewFilterClass *) klass)->predicate = default_search_view_filter_real_predicate;
#line 2616 "SearchFilter.c"
}


static void default_search_view_filter_instance_init (DefaultSearchViewFilter * self) {
}


GType default_search_view_filter_get_type (void) {
	static volatile gsize default_search_view_filter_type_id__volatile = 0;
	if (g_once_init_enter (&default_search_view_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DefaultSearchViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) default_search_view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DefaultSearchViewFilter), 0, (GInstanceInitFunc) default_search_view_filter_instance_init, NULL };
		GType default_search_view_filter_type_id;
		default_search_view_filter_type_id = g_type_register_static (TYPE_SEARCH_VIEW_FILTER, "DefaultSearchViewFilter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&default_search_view_filter_type_id__volatile, default_search_view_filter_type_id);
	}
	return default_search_view_filter_type_id__volatile;
}


static gboolean disabled_view_filter_real_predicate (ViewFilter* base, DataView* view) {
	DisabledViewFilter * self;
	gboolean result = FALSE;
#line 254 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DISABLED_VIEW_FILTER, DisabledViewFilter);
#line 254 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_DATA_VIEW (view), FALSE);
#line 255 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = TRUE;
#line 255 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 2647 "SearchFilter.c"
}


static guint disabled_view_filter_real_get_criteria (SearchViewFilter* base) {
	DisabledViewFilter * self;
	guint result = 0U;
#line 258 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DISABLED_VIEW_FILTER, DisabledViewFilter);
#line 259 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = (guint) SEARCH_FILTER_CRITERIA_RATING;
#line 259 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 2660 "SearchFilter.c"
}


DisabledViewFilter* disabled_view_filter_construct (GType object_type) {
	DisabledViewFilter* self = NULL;
#line 253 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (DisabledViewFilter*) search_view_filter_construct (object_type);
#line 253 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 2670 "SearchFilter.c"
}


DisabledViewFilter* disabled_view_filter_new (void) {
#line 253 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return disabled_view_filter_construct (TYPE_DISABLED_VIEW_FILTER);
#line 2677 "SearchFilter.c"
}


static void disabled_view_filter_class_init (DisabledViewFilterClass * klass) {
#line 253 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	disabled_view_filter_parent_class = g_type_class_peek_parent (klass);
#line 253 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	((ViewFilterClass *) klass)->predicate = disabled_view_filter_real_predicate;
#line 253 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	((SearchViewFilterClass *) klass)->get_criteria = disabled_view_filter_real_get_criteria;
#line 2688 "SearchFilter.c"
}


static void disabled_view_filter_instance_init (DisabledViewFilter * self) {
}


GType disabled_view_filter_get_type (void) {
	static volatile gsize disabled_view_filter_type_id__volatile = 0;
	if (g_once_init_enter (&disabled_view_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DisabledViewFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) disabled_view_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisabledViewFilter), 0, (GInstanceInitFunc) disabled_view_filter_instance_init, NULL };
		GType disabled_view_filter_type_id;
		disabled_view_filter_type_id = g_type_register_static (TYPE_SEARCH_VIEW_FILTER, "DisabledViewFilter", &g_define_type_info, 0);
		g_once_init_leave (&disabled_view_filter_type_id__volatile, disabled_view_filter_type_id);
	}
	return disabled_view_filter_type_id__volatile;
}


TextAction* text_action_construct (GType object_type, const gchar* init) {
	TextAction* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 280 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (TextAction*) g_type_create_instance (object_type);
#line 281 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = init;
#line 281 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 281 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_free0 (self->priv->text);
#line 281 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->text = _tmp1_;
#line 280 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 2724 "SearchFilter.c"
}


TextAction* text_action_new (const gchar* init) {
#line 280 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return text_action_construct (TYPE_TEXT_ACTION, init);
#line 2731 "SearchFilter.c"
}


void text_action_set_text (TextAction* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 284 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_TEXT_ACTION (self));
#line 285 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->text;
#line 285 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = text;
#line 285 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
#line 2746 "SearchFilter.c"
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 286 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = text;
#line 286 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 286 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_free0 (self->priv->text);
#line 286 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		self->priv->text = _tmp3_;
#line 287 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp4_ = text;
#line 287 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_signal_emit_by_name (self, "text-changed", _tmp4_);
#line 2762 "SearchFilter.c"
	}
}


void text_action_clear (TextAction* self) {
#line 291 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_TEXT_ACTION (self));
#line 292 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	text_action_set_text (self, NULL);
#line 2772 "SearchFilter.c"
}


gboolean text_action_is_sensitive (TextAction* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 295 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_TEXT_ACTION (self), FALSE);
#line 296 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->sensitive;
#line 296 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 296 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 2787 "SearchFilter.c"
}


void text_action_set_sensitive (TextAction* self, gboolean sensitive) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 299 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_TEXT_ACTION (self));
#line 300 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->sensitive;
#line 300 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = sensitive;
#line 300 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp0_ != _tmp1_) {
#line 2802 "SearchFilter.c"
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 301 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = sensitive;
#line 301 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		self->priv->sensitive = _tmp2_;
#line 302 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp3_ = sensitive;
#line 302 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_signal_emit_by_name (self, "sensitivity-changed", _tmp3_);
#line 2813 "SearchFilter.c"
	}
}


gboolean text_action_is_visible (TextAction* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 306 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_TEXT_ACTION (self), FALSE);
#line 307 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->visible;
#line 307 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 307 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 2829 "SearchFilter.c"
}


void text_action_set_visible (TextAction* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 310 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_TEXT_ACTION (self));
#line 311 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->visible;
#line 311 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = visible;
#line 311 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp0_ != _tmp1_) {
#line 2844 "SearchFilter.c"
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
#line 312 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = visible;
#line 312 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		self->priv->visible = _tmp2_;
#line 313 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp3_ = visible;
#line 313 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_signal_emit_by_name (self, "visibility-changed", _tmp3_);
#line 2855 "SearchFilter.c"
	}
}


const gchar* text_action_get_value (TextAction* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 265 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_TEXT_ACTION (self), NULL);
#line 266 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->text;
#line 266 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 266 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 2871 "SearchFilter.c"
}


static void value_text_action_init (GValue* value) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	value->data[0].v_pointer = NULL;
#line 2878 "SearchFilter.c"
}


static void value_text_action_free_value (GValue* value) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (value->data[0].v_pointer) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		text_action_unref (value->data[0].v_pointer);
#line 2887 "SearchFilter.c"
	}
}


static void value_text_action_copy_value (const GValue* src_value, GValue* dest_value) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (src_value->data[0].v_pointer) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		dest_value->data[0].v_pointer = text_action_ref (src_value->data[0].v_pointer);
#line 2897 "SearchFilter.c"
	} else {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2901 "SearchFilter.c"
	}
}


static gpointer value_text_action_peek_pointer (const GValue* value) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return value->data[0].v_pointer;
#line 2909 "SearchFilter.c"
}


static gchar* value_text_action_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (collect_values[0].v_pointer) {
#line 2916 "SearchFilter.c"
		TextAction* object;
		object = collect_values[0].v_pointer;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (object->parent_instance.g_class == NULL) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2923 "SearchFilter.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2927 "SearchFilter.c"
		}
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = text_action_ref (object);
#line 2931 "SearchFilter.c"
	} else {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = NULL;
#line 2935 "SearchFilter.c"
	}
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return NULL;
#line 2939 "SearchFilter.c"
}


static gchar* value_text_action_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TextAction** object_p;
	object_p = collect_values[0].v_pointer;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (!object_p) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2950 "SearchFilter.c"
	}
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (!value->data[0].v_pointer) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*object_p = NULL;
#line 2956 "SearchFilter.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*object_p = value->data[0].v_pointer;
#line 2960 "SearchFilter.c"
	} else {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*object_p = text_action_ref (value->data[0].v_pointer);
#line 2964 "SearchFilter.c"
	}
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return NULL;
#line 2968 "SearchFilter.c"
}


GParamSpec* param_spec_text_action (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTextAction* spec;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEXT_ACTION), NULL);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return G_PARAM_SPEC (spec);
#line 2982 "SearchFilter.c"
}


gpointer value_get_text_action (const GValue* value) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ACTION), NULL);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return value->data[0].v_pointer;
#line 2991 "SearchFilter.c"
}


void value_set_text_action (GValue* value, gpointer v_object) {
	TextAction* old;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ACTION));
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	old = value->data[0].v_pointer;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (v_object) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_ACTION));
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = v_object;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		text_action_ref (value->data[0].v_pointer);
#line 3011 "SearchFilter.c"
	} else {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = NULL;
#line 3015 "SearchFilter.c"
	}
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (old) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		text_action_unref (old);
#line 3021 "SearchFilter.c"
	}
}


void value_take_text_action (GValue* value, gpointer v_object) {
	TextAction* old;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_ACTION));
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	old = value->data[0].v_pointer;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (v_object) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_ACTION));
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = v_object;
#line 3040 "SearchFilter.c"
	} else {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = NULL;
#line 3044 "SearchFilter.c"
	}
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (old) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		text_action_unref (old);
#line 3050 "SearchFilter.c"
	}
}


static void text_action_class_init (TextActionClass * klass) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	text_action_parent_class = g_type_class_peek_parent (klass);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	((TextActionClass *) klass)->finalize = text_action_finalize;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_type_class_add_private (klass, sizeof (TextActionPrivate));
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("text_changed", TYPE_TEXT_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("sensitivity_changed", TYPE_TEXT_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("visibility_changed", TYPE_TEXT_ACTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 3068 "SearchFilter.c"
}


static void text_action_instance_init (TextAction * self) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv = TEXT_ACTION_GET_PRIVATE (self);
#line 270 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->text = NULL;
#line 271 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->sensitive = TRUE;
#line 272 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->visible = TRUE;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->ref_count = 1;
#line 3083 "SearchFilter.c"
}


static void text_action_finalize (TextAction* obj) {
	TextAction * self;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_ACTION, TextAction);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_destroy (self);
#line 270 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_free0 (self->priv->text);
#line 3095 "SearchFilter.c"
}


GType text_action_get_type (void) {
	static volatile gsize text_action_type_id__volatile = 0;
	if (g_once_init_enter (&text_action_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_text_action_init, value_text_action_free_value, value_text_action_copy_value, value_text_action_peek_pointer, "p", value_text_action_collect_value, "p", value_text_action_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TextActionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_action_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextAction), 0, (GInstanceInitFunc) text_action_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType text_action_type_id;
		text_action_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TextAction", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&text_action_type_id__volatile, text_action_type_id);
	}
	return text_action_type_id__volatile;
}


gpointer text_action_ref (gpointer instance) {
	TextAction* self;
	self = instance;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_atomic_int_inc (&self->ref_count);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return instance;
#line 3120 "SearchFilter.c"
}


void text_action_unref (gpointer instance) {
	TextAction* self;
	self = instance;
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		TEXT_ACTION_GET_CLASS (self)->finalize (self);
#line 263 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3133 "SearchFilter.c"
	}
}


static void _search_filter_actions_on_text_changed_text_action_text_changed (TextAction* _sender, const gchar* text, gpointer self) {
#line 396 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_on_text_changed ((SearchFilterActions*) self, _sender, text);
#line 3141 "SearchFilter.c"
}


SearchFilterActions* search_filter_actions_construct (GType object_type) {
	SearchFilterActions* self = NULL;
	TextAction* _tmp0_ = NULL;
	TextAction* _tmp1_ = NULL;
#line 392 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (SearchFilterActions*) g_type_create_instance (object_type);
#line 394 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_register (self);
#line 396 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = search_filter_actions_get_text (self);
#line 396 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _tmp0_;
#line 396 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect (_tmp1_, "text-changed", (GCallback) _search_filter_actions_on_text_changed_text_action_text_changed, self);
#line 392 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 3161 "SearchFilter.c"
}


SearchFilterActions* search_filter_actions_new (void) {
#line 392 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return search_filter_actions_construct (TYPE_SEARCH_FILTER_ACTIONS);
#line 3168 "SearchFilter.c"
}


GtkActionGroup* search_filter_actions_get_action_group (SearchFilterActions* self) {
	GtkActionGroup* result = NULL;
	GtkActionGroup* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
#line 399 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), NULL);
#line 400 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->action_group;
#line 400 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 400 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp1_;
#line 400 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 3186 "SearchFilter.c"
}


SearchFilterCriteria search_filter_actions_get_criteria (SearchFilterActions* self) {
	SearchFilterCriteria result = 0;
	SearchFilterCriteria _tmp0_ = 0;
#line 403 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), 0);
#line 404 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->criteria;
#line 404 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 404 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 3201 "SearchFilter.c"
}


GtkAction* search_filter_actions_get_action (SearchFilterActions* self, const gchar* name) {
	GtkAction* result = NULL;
	GtkActionGroup* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), NULL);
#line 407 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 408 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->action_group;
#line 408 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = name;
#line 408 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp0_, _tmp1_);
#line 408 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp2_;
#line 408 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 3224 "SearchFilter.c"
}


void search_filter_actions_set_action_sensitive (SearchFilterActions* self, const gchar* name, gboolean sensitive) {
	GtkAction* action = NULL;
	const gchar* _tmp0_ = NULL;
	GtkAction* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
	GtkAction* _tmp3_ = NULL;
#line 411 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 411 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (name != NULL);
#line 412 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = name;
#line 412 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = search_filter_actions_get_action (self, _tmp0_);
#line 412 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 412 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	action = _tmp2_;
#line 413 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = action;
#line 413 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp3_ != NULL) {
#line 3250 "SearchFilter.c"
		GtkAction* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 414 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp4_ = action;
#line 414 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp5_ = sensitive;
#line 414 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		gtk_action_set_sensitive (_tmp4_, _tmp5_);
#line 3259 "SearchFilter.c"
	}
#line 411 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (action);
#line 3263 "SearchFilter.c"
}


void search_filter_actions_reset (SearchFilterActions* self) {
	GtkToggleAction* _tmp0_ = NULL;
	GtkToggleAction* _tmp1_ = NULL;
	GtkToggleAction* _tmp2_ = NULL;
	GtkToggleAction* _tmp3_ = NULL;
	GtkToggleAction* _tmp4_ = NULL;
	GtkToggleAction* _tmp5_ = NULL;
	GtkToggleAction* _tmp6_ = NULL;
	GtkToggleAction* _tmp7_ = NULL;
	GtkRadioAction* _tmp8_ = NULL;
	GtkRadioAction* _tmp9_ = NULL;
	TextAction* _tmp10_ = NULL;
	TextAction* _tmp11_ = NULL;
#line 417 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 418 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = search_filter_actions_get_flagged (self);
#line 418 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _tmp0_;
#line 418 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toggle_action_set_active (_tmp1_, FALSE);
#line 419 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = search_filter_actions_get_photos (self);
#line 419 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = _tmp2_;
#line 419 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toggle_action_set_active (_tmp3_, FALSE);
#line 420 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = search_filter_actions_get_raw (self);
#line 420 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = _tmp4_;
#line 420 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toggle_action_set_active (_tmp5_, FALSE);
#line 421 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = search_filter_actions_get_videos (self);
#line 421 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = _tmp6_;
#line 421 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toggle_action_set_active (_tmp7_, FALSE);
#line 422 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = search_filter_actions_get_rating (self);
#line 422 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = _tmp8_;
#line 422 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_radio_action_set_current_value (_tmp9_, (gint) RATING_FILTER_UNRATED_OR_HIGHER);
#line 423 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = search_filter_actions_get_text (self);
#line 423 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = _tmp10_;
#line 423 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	text_action_set_text (_tmp11_, NULL);
#line 3318 "SearchFilter.c"
}


void search_filter_actions_set_sensitive_for_search_criteria (SearchFilterActions* self, SearchFilterCriteria criteria) {
	SearchFilterCriteria _tmp0_ = 0;
#line 426 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 427 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = criteria;
#line 427 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->criteria = _tmp0_;
#line 428 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_update_sensitivities (self);
#line 431 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "criteria-changed");
#line 3334 "SearchFilter.c"
}


static void _search_filter_actions_on_media_tracker_updated_core_tracker_updated (CoreTracker* _sender, gpointer self) {
#line 439 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_on_media_tracker_updated ((SearchFilterActions*) self, _sender);
#line 3341 "SearchFilter.c"
}


static void _search_filter_actions_on_camera_tracker_updated_core_tracker_updated (CoreTracker* _sender, gpointer self) {
#line 441 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_on_camera_tracker_updated ((SearchFilterActions*) self, _sender);
#line 3348 "SearchFilter.c"
}


void search_filter_actions_monitor_page_contents (SearchFilterActions* self, Page* old_page, Page* new_page) {
	CheckerboardPage* old_tracked_page = NULL;
	Page* _tmp0_ = NULL;
	CheckerboardPage* _tmp1_ = NULL;
	CheckerboardPage* _tmp2_ = NULL;
	CheckerboardPage* new_tracked_page = NULL;
	Page* _tmp11_ = NULL;
	CheckerboardPage* _tmp12_ = NULL;
	CheckerboardPage* _tmp13_ = NULL;
#line 434 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 434 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail ((old_page == NULL) || IS_PAGE (old_page));
#line 434 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail ((new_page == NULL) || IS_PAGE (new_page));
#line 435 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = old_page;
#line 435 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_CHECKERBOARD_PAGE) ? ((CheckerboardPage*) _tmp0_) : NULL);
#line 435 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	old_tracked_page = _tmp1_;
#line 436 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = old_tracked_page;
#line 436 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp2_ != NULL) {
#line 3377 "SearchFilter.c"
		CoreViewTracker* tracker = NULL;
		CheckerboardPage* _tmp3_ = NULL;
		CoreViewTracker* _tmp4_ = NULL;
		CoreViewTracker* _tmp5_ = NULL;
#line 437 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp3_ = old_tracked_page;
#line 437 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp4_ = checkerboard_page_get_view_tracker (_tmp3_);
#line 437 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		tracker = _tmp4_;
#line 438 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp5_ = tracker;
#line 438 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_MEDIA_VIEW_TRACKER)) {
#line 3392 "SearchFilter.c"
			CoreViewTracker* _tmp6_ = NULL;
			guint _tmp7_ = 0U;
#line 439 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp6_ = tracker;
#line 439 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			g_signal_parse_name ("updated", CORE_TYPE_TRACKER, &_tmp7_, NULL, FALSE);
#line 439 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, CORE_TYPE_TRACKER, CoreTracker), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _search_filter_actions_on_media_tracker_updated_core_tracker_updated, self);
#line 3401 "SearchFilter.c"
		} else {
			CoreViewTracker* _tmp8_ = NULL;
#line 440 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp8_ = tracker;
#line 440 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_CAMERA_VIEW_TRACKER)) {
#line 3408 "SearchFilter.c"
				CoreViewTracker* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
#line 441 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp9_ = tracker;
#line 441 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				g_signal_parse_name ("updated", CORE_TYPE_TRACKER, &_tmp10_, NULL, FALSE);
#line 441 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CORE_TYPE_TRACKER, CoreTracker), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _search_filter_actions_on_camera_tracker_updated_core_tracker_updated, self);
#line 3417 "SearchFilter.c"
			}
		}
#line 436 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_core_tracker_unref0 (tracker);
#line 3422 "SearchFilter.c"
	}
#line 444 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = new_page;
#line 444 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_CHECKERBOARD_PAGE) ? ((CheckerboardPage*) _tmp11_) : NULL);
#line 444 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	new_tracked_page = _tmp12_;
#line 445 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp13_ = new_tracked_page;
#line 445 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp13_ != NULL) {
#line 3434 "SearchFilter.c"
		CoreViewTracker* tracker = NULL;
		CheckerboardPage* _tmp14_ = NULL;
		CoreViewTracker* _tmp15_ = NULL;
		CoreViewTracker* _tmp16_ = NULL;
#line 446 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		self->priv->can_filter_by_stars = TRUE;
#line 448 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp14_ = new_tracked_page;
#line 448 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp15_ = checkerboard_page_get_view_tracker (_tmp14_);
#line 448 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		tracker = _tmp15_;
#line 449 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp16_ = tracker;
#line 449 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_MEDIA_VIEW_TRACKER)) {
#line 3451 "SearchFilter.c"
			CoreViewTracker* _tmp17_ = NULL;
			CoreViewTracker* _tmp18_ = NULL;
#line 450 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp17_ = tracker;
#line 450 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, CORE_TYPE_TRACKER, CoreTracker), "updated", (GCallback) _search_filter_actions_on_media_tracker_updated_core_tracker_updated, self);
#line 451 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp18_ = tracker;
#line 451 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			search_filter_actions_on_media_tracker_updated (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, CORE_TYPE_TRACKER, CoreTracker));
#line 453 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_core_tracker_unref0 (tracker);
#line 453 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_object_unref0 (new_tracked_page);
#line 453 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_object_unref0 (old_tracked_page);
#line 453 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return;
#line 3470 "SearchFilter.c"
		} else {
			CoreViewTracker* _tmp19_ = NULL;
#line 454 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp19_ = tracker;
#line 454 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, TYPE_CAMERA_VIEW_TRACKER)) {
#line 3477 "SearchFilter.c"
				CoreViewTracker* _tmp20_ = NULL;
				CoreViewTracker* _tmp21_ = NULL;
#line 455 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp20_ = tracker;
#line 455 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, CORE_TYPE_TRACKER, CoreTracker), "updated", (GCallback) _search_filter_actions_on_camera_tracker_updated_core_tracker_updated, self);
#line 456 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_tmp21_ = tracker;
#line 456 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				search_filter_actions_on_camera_tracker_updated (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, CORE_TYPE_TRACKER, CoreTracker));
#line 458 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_core_tracker_unref0 (tracker);
#line 458 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_g_object_unref0 (new_tracked_page);
#line 458 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				_g_object_unref0 (old_tracked_page);
#line 458 "/home/jens/Source/shotwell/src/SearchFilter.vala"
				return;
#line 3496 "SearchFilter.c"
			}
		}
#line 445 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_core_tracker_unref0 (tracker);
#line 3501 "SearchFilter.c"
	}
#line 463 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_flagged = FALSE;
#line 464 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_photos = FALSE;
#line 465 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_videos = FALSE;
#line 466 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_raw = FALSE;
#line 467 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->can_filter_by_stars = FALSE;
#line 469 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_update_sensitivities (self);
#line 434 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (new_tracked_page);
#line 434 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (old_tracked_page);
#line 3519 "SearchFilter.c"
}


static gpointer _core_tracker_ref0 (gpointer self) {
#line 473 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self ? core_tracker_ref (self) : NULL;
#line 3526 "SearchFilter.c"
}


static void search_filter_actions_on_media_tracker_updated (SearchFilterActions* self, CoreTracker* t) {
	MediaViewTracker* tracker = NULL;
	CoreTracker* _tmp0_ = NULL;
	MediaViewTracker* _tmp1_ = NULL;
	MediaAccumulator* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	MediaAccumulator* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	MediaAccumulator* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	MediaAccumulator* _tmp8_ = NULL;
	gint _tmp9_ = 0;
#line 472 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 472 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (CORE_IS_TRACKER (t));
#line 473 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = t;
#line 473 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _core_tracker_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker));
#line 473 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	tracker = _tmp1_;
#line 475 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = tracker->all;
#line 475 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = _tmp2_->flagged;
#line 475 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_flagged = _tmp3_ > 0;
#line 476 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = tracker->all;
#line 476 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = _tmp4_->photos;
#line 476 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_photos = _tmp5_ > 0;
#line 477 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = tracker->all;
#line 477 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = _tmp6_->videos;
#line 477 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_videos = _tmp7_ > 0;
#line 478 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = tracker->all;
#line 478 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = _tmp8_->raw;
#line 478 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_raw = _tmp9_ > 0;
#line 480 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_update_sensitivities (self);
#line 472 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_core_tracker_unref0 (tracker);
#line 3580 "SearchFilter.c"
}


static void search_filter_actions_on_camera_tracker_updated (SearchFilterActions* self, CoreTracker* t) {
	CameraViewTracker* tracker = NULL;
	CoreTracker* _tmp0_ = NULL;
	CameraViewTracker* _tmp1_ = NULL;
	CameraAccumulator* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	CameraAccumulator* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	CameraAccumulator* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
#line 483 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 483 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (CORE_IS_TRACKER (t));
#line 484 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = t;
#line 484 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _core_tracker_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CAMERA_VIEW_TRACKER, CameraViewTracker));
#line 484 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	tracker = _tmp1_;
#line 486 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_flagged = FALSE;
#line 487 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = tracker->all;
#line 487 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = camera_accumulator_get_photos (_tmp2_);
#line 487 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = _tmp3_;
#line 487 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_photos = _tmp4_ > 0;
#line 488 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = tracker->all;
#line 488 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = camera_accumulator_get_videos (_tmp5_);
#line 488 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = _tmp6_;
#line 488 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_videos = _tmp7_ > 0;
#line 489 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = tracker->all;
#line 489 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = camera_accumulator_get_raw (_tmp8_);
#line 489 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = _tmp9_;
#line 489 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_raw = _tmp10_ > 0;
#line 491 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_update_sensitivities (self);
#line 483 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_core_tracker_unref0 (tracker);
#line 3637 "SearchFilter.c"
}


static void search_filter_actions_update_sensitivities (SearchFilterActions* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	SearchFilterCriteria _tmp2_ = 0;
	GtkToggleAction* _tmp4_ = NULL;
	GtkToggleAction* _tmp5_ = NULL;
	gboolean allow_media = FALSE;
	SearchFilterCriteria _tmp6_ = 0;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GtkToggleAction* _tmp11_ = NULL;
	GtkToggleAction* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GtkToggleAction* _tmp17_ = NULL;
	GtkToggleAction* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	GtkToggleAction* _tmp23_ = NULL;
	GtkToggleAction* _tmp24_ = NULL;
	gboolean allow_ratings = FALSE;
	SearchFilterCriteria _tmp25_ = 0;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	TextAction* _tmp34_ = NULL;
	TextAction* _tmp35_ = NULL;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
#line 494 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = self->priv->criteria;
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((SEARCH_FILTER_CRITERIA_FLAG & _tmp2_) != 0) {
#line 3686 "SearchFilter.c"
		gboolean _tmp3_ = FALSE;
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp3_ = self->priv->has_flagged;
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp1_ = _tmp3_;
#line 3692 "SearchFilter.c"
	} else {
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp1_ = FALSE;
#line 3696 "SearchFilter.c"
	}
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp1_) {
#line 496 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = RESOURCES_ICON_FILTER_FLAGGED;
#line 3702 "SearchFilter.c"
	} else {
#line 496 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = RESOURCES_ICON_FILTER_FLAGGED_DISABLED;
#line 3706 "SearchFilter.c"
	}
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = search_filter_actions_get_flagged (self);
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = _tmp4_;
#line 495 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_action_set_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_action_get_type (), GtkAction), _tmp0_);
#line 498 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = self->priv->criteria;
#line 498 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	allow_media = (SEARCH_FILTER_CRITERIA_MEDIA & _tmp6_) != 0;
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = allow_media;
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp9_) {
#line 3722 "SearchFilter.c"
		gboolean _tmp10_ = FALSE;
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp10_ = self->priv->has_videos;
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp8_ = _tmp10_;
#line 3728 "SearchFilter.c"
	} else {
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp8_ = FALSE;
#line 3732 "SearchFilter.c"
	}
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp8_) {
#line 500 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp7_ = RESOURCES_ICON_FILTER_VIDEOS;
#line 3738 "SearchFilter.c"
	} else {
#line 500 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp7_ = RESOURCES_ICON_FILTER_VIDEOS_DISABLED;
#line 3742 "SearchFilter.c"
	}
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = search_filter_actions_get_videos (self);
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = _tmp11_;
#line 499 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_action_set_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_action_get_type (), GtkAction), _tmp7_);
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp15_ = allow_media;
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp15_) {
#line 3754 "SearchFilter.c"
		gboolean _tmp16_ = FALSE;
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp16_ = self->priv->has_photos;
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp14_ = _tmp16_;
#line 3760 "SearchFilter.c"
	} else {
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp14_ = FALSE;
#line 3764 "SearchFilter.c"
	}
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp14_) {
#line 502 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp13_ = RESOURCES_ICON_FILTER_PHOTOS;
#line 3770 "SearchFilter.c"
	} else {
#line 502 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp13_ = RESOURCES_ICON_FILTER_PHOTOS_DISABLED;
#line 3774 "SearchFilter.c"
	}
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_ = search_filter_actions_get_photos (self);
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp18_ = _tmp17_;
#line 501 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_action_set_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_action_get_type (), GtkAction), _tmp13_);
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp21_ = allow_media;
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp21_) {
#line 3786 "SearchFilter.c"
		gboolean _tmp22_ = FALSE;
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp22_ = self->priv->has_raw;
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp20_ = _tmp22_;
#line 3792 "SearchFilter.c"
	} else {
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp20_ = FALSE;
#line 3796 "SearchFilter.c"
	}
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp20_) {
#line 504 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp19_ = RESOURCES_ICON_FILTER_RAW;
#line 3802 "SearchFilter.c"
	} else {
#line 504 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp19_ = RESOURCES_ICON_FILTER_RAW_DISABLED;
#line 3806 "SearchFilter.c"
	}
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp23_ = search_filter_actions_get_raw (self);
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp24_ = _tmp23_;
#line 503 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_action_set_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_action_get_type (), GtkAction), _tmp19_);
#line 506 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp25_ = self->priv->criteria;
#line 506 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	allow_ratings = (SEARCH_FILTER_CRITERIA_RATING & _tmp25_) != 0;
#line 507 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp26_ = self->priv->can_filter_by_stars;
#line 507 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_action_sensitive (self, "CommonDisplayRejectedOnly", allow_ratings & _tmp26_);
#line 508 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_ = self->priv->can_filter_by_stars;
#line 508 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_action_sensitive (self, "CommonDisplayRejectedOrHigher", allow_ratings & _tmp27_);
#line 509 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp28_ = self->priv->can_filter_by_stars;
#line 509 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_action_sensitive (self, "CommonDisplayUnratedOrHigher", allow_ratings & _tmp28_);
#line 510 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp29_ = self->priv->can_filter_by_stars;
#line 510 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_action_sensitive (self, "CommonDisplayOneOrHigher", allow_ratings & _tmp29_);
#line 511 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp30_ = self->priv->can_filter_by_stars;
#line 511 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_action_sensitive (self, "CommonDisplayTwoOrHigher", allow_ratings & _tmp30_);
#line 512 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp31_ = self->priv->can_filter_by_stars;
#line 512 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_action_sensitive (self, "CommonDisplayThreeOrHigher", allow_ratings & _tmp31_);
#line 513 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_ = self->priv->can_filter_by_stars;
#line 513 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_action_sensitive (self, "CommonDisplayFourOrHigher", allow_ratings & _tmp32_);
#line 514 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp33_ = self->priv->can_filter_by_stars;
#line 514 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_action_sensitive (self, "CommonDisplayFiveOrHigher", allow_ratings & _tmp33_);
#line 518 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp34_ = search_filter_actions_get_text (self);
#line 518 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp35_ = _tmp34_;
#line 518 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	text_action_set_sensitive (_tmp35_, TRUE);
#line 520 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp36_ = self->priv->has_photos;
#line 520 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp37_ = self->priv->has_videos;
#line 520 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp38_ = self->priv->has_raw;
#line 520 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp39_ = self->priv->has_flagged;
#line 520 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "media-context-changed", _tmp36_, _tmp37_, _tmp38_, _tmp39_);
#line 3866 "SearchFilter.c"
}


static void search_filter_actions_on_text_changed (SearchFilterActions* self, TextAction* action, const gchar* text) {
	const gchar* _tmp0_ = NULL;
#line 523 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 523 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_TEXT_ACTION (action));
#line 524 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = text;
#line 524 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "text-changed", _tmp0_);
#line 3880 "SearchFilter.c"
}


static void _vala_array_add338 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
#line 536 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 536 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 536 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkRadioActionEntry, *array, *size);
#line 3891 "SearchFilter.c"
	}
#line 536 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 3895 "SearchFilter.c"
}


static void _vala_array_add339 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
#line 543 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 543 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 543 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkRadioActionEntry, *array, *size);
#line 3906 "SearchFilter.c"
	}
#line 543 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 3910 "SearchFilter.c"
}


static void _vala_array_add340 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
#line 549 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 549 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 549 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkRadioActionEntry, *array, *size);
#line 3921 "SearchFilter.c"
	}
#line 549 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 3925 "SearchFilter.c"
}


static void _vala_array_add341 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
#line 555 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 555 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 555 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkRadioActionEntry, *array, *size);
#line 3936 "SearchFilter.c"
	}
#line 555 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 3940 "SearchFilter.c"
}


static void _vala_array_add342 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
#line 561 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 561 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 561 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkRadioActionEntry, *array, *size);
#line 3951 "SearchFilter.c"
	}
#line 561 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 3955 "SearchFilter.c"
}


static void _vala_array_add343 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
#line 567 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 567 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 567 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkRadioActionEntry, *array, *size);
#line 3966 "SearchFilter.c"
	}
#line 567 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 3970 "SearchFilter.c"
}


static void _vala_array_add344 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
#line 573 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 573 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 573 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkRadioActionEntry, *array, *size);
#line 3981 "SearchFilter.c"
	}
#line 573 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 3985 "SearchFilter.c"
}


static void _vala_array_add345 (GtkRadioActionEntry** array, int* length, int* size, const GtkRadioActionEntry* value) {
#line 579 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 579 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 579 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkRadioActionEntry, *array, *size);
#line 3996 "SearchFilter.c"
	}
#line 579 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 4000 "SearchFilter.c"
}


static void _search_filter_actions_on_rating_changed_gtk_radio_action_callback (GtkAction* action, GtkAction* current, gpointer self) {
#line 581 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_on_rating_changed ((SearchFilterActions*) self, action, current);
#line 4007 "SearchFilter.c"
}


static void _search_filter_actions_on_flagged_toggled_gtk_action_callback (GtkAction* action, gpointer self) {
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_on_flagged_toggled ((SearchFilterActions*) self, action);
#line 4014 "SearchFilter.c"
}


static void _vala_array_add346 (GtkToggleActionEntry** array, int* length, int* size, const GtkToggleActionEntry* value) {
#line 590 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 590 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 590 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkToggleActionEntry, *array, *size);
#line 4025 "SearchFilter.c"
	}
#line 590 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 4029 "SearchFilter.c"
}


static void _search_filter_actions_on_photos_toggled_gtk_action_callback (GtkAction* action, gpointer self) {
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_on_photos_toggled ((SearchFilterActions*) self, action);
#line 4036 "SearchFilter.c"
}


static void _vala_array_add347 (GtkToggleActionEntry** array, int* length, int* size, const GtkToggleActionEntry* value) {
#line 596 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 596 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 596 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkToggleActionEntry, *array, *size);
#line 4047 "SearchFilter.c"
	}
#line 596 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 4051 "SearchFilter.c"
}


static void _search_filter_actions_on_videos_toggled_gtk_action_callback (GtkAction* action, gpointer self) {
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_on_videos_toggled ((SearchFilterActions*) self, action);
#line 4058 "SearchFilter.c"
}


static void _vala_array_add348 (GtkToggleActionEntry** array, int* length, int* size, const GtkToggleActionEntry* value) {
#line 602 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 602 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 602 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkToggleActionEntry, *array, *size);
#line 4069 "SearchFilter.c"
	}
#line 602 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 4073 "SearchFilter.c"
}


static void _search_filter_actions_on_raw_toggled_gtk_action_callback (GtkAction* action, gpointer self) {
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_on_raw_toggled ((SearchFilterActions*) self, action);
#line 4080 "SearchFilter.c"
}


static void _vala_array_add349 (GtkToggleActionEntry** array, int* length, int* size, const GtkToggleActionEntry* value) {
#line 608 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if ((*length) == (*size)) {
#line 608 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 608 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*array = g_renew (GtkToggleActionEntry, *array, *size);
#line 4091 "SearchFilter.c"
	}
#line 608 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	(*array)[(*length)++] = *value;
#line 4095 "SearchFilter.c"
}


static void search_filter_actions_register (SearchFilterActions* self) {
	TextAction* _tmp0_ = NULL;
	GtkRadioActionEntry* view_filter_actions = NULL;
	GtkRadioActionEntry* _tmp1_ = NULL;
	gint view_filter_actions_length1 = 0;
	gint _view_filter_actions_size_ = 0;
	GtkRadioActionEntry rejected_only = {0};
	GtkRadioActionEntry _tmp2_ = {0};
	GtkRadioActionEntry* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GtkRadioActionEntry _tmp4_ = {0};
	GtkRadioActionEntry rejected_or_higher = {0};
	GtkRadioActionEntry _tmp5_ = {0};
	const gchar* _tmp6_ = NULL;
	GtkRadioActionEntry* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GtkRadioActionEntry _tmp8_ = {0};
	GtkRadioActionEntry unrated_or_higher = {0};
	GtkRadioActionEntry _tmp9_ = {0};
	GtkRadioActionEntry* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GtkRadioActionEntry _tmp11_ = {0};
	GtkRadioActionEntry one_or_higher = {0};
	GtkRadioActionEntry _tmp12_ = {0};
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkRadioActionEntry* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	GtkRadioActionEntry _tmp16_ = {0};
	GtkRadioActionEntry two_or_higher = {0};
	GtkRadioActionEntry _tmp17_ = {0};
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkRadioActionEntry* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	GtkRadioActionEntry _tmp21_ = {0};
	GtkRadioActionEntry three_or_higher = {0};
	GtkRadioActionEntry _tmp22_ = {0};
	const gchar* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	GtkRadioActionEntry* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	GtkRadioActionEntry _tmp26_ = {0};
	GtkRadioActionEntry four_or_higher = {0};
	GtkRadioActionEntry _tmp27_ = {0};
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	GtkRadioActionEntry* _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	GtkRadioActionEntry _tmp31_ = {0};
	GtkRadioActionEntry five_or_higher = {0};
	GtkRadioActionEntry _tmp32_ = {0};
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	GtkRadioActionEntry* _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	GtkRadioActionEntry _tmp36_ = {0};
	GtkActionGroup* _tmp37_ = NULL;
	GtkRadioActionEntry* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	GtkToggleActionEntry* toggle_actions = NULL;
	GtkToggleActionEntry* _tmp39_ = NULL;
	gint toggle_actions_length1 = 0;
	gint _toggle_actions_size_ = 0;
	GtkToggleActionEntry flagged_action = {0};
	GtkToggleActionEntry _tmp40_ = {0};
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GtkToggleActionEntry* _tmp43_ = NULL;
	gint _tmp43__length1 = 0;
	GtkToggleActionEntry _tmp44_ = {0};
	GtkToggleActionEntry photos_action = {0};
	GtkToggleActionEntry _tmp45_ = {0};
	const gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	GtkToggleActionEntry* _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	GtkToggleActionEntry _tmp49_ = {0};
	GtkToggleActionEntry videos_action = {0};
	GtkToggleActionEntry _tmp50_ = {0};
	const gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	GtkToggleActionEntry* _tmp53_ = NULL;
	gint _tmp53__length1 = 0;
	GtkToggleActionEntry _tmp54_ = {0};
	GtkToggleActionEntry raw_action = {0};
	GtkToggleActionEntry _tmp55_ = {0};
	const gchar* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GtkToggleActionEntry* _tmp58_ = NULL;
	gint _tmp58__length1 = 0;
	GtkToggleActionEntry _tmp59_ = {0};
	GtkActionGroup* _tmp60_ = NULL;
	GtkToggleActionEntry* _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
#line 527 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 528 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = text_action_new (NULL);
#line 528 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_text_action_unref0 (self->priv->_text);
#line 528 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_text = _tmp0_;
#line 530 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = g_new0 (GtkRadioActionEntry, 0);
#line 530 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	view_filter_actions = _tmp1_;
#line 530 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	view_filter_actions_length1 = 0;
#line 530 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_view_filter_actions_size_ = view_filter_actions_length1;
#line 532 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_.name = "CommonDisplayRejectedOnly";
#line 532 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_.stock_id = NULL;
#line 532 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_.label = TRANSLATABLE;
#line 532 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_.accelerator = "<Ctrl>8";
#line 532 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_.tooltip = TRANSLATABLE;
#line 532 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_.value = (gint) RATING_FILTER_REJECTED_ONLY;
#line 532 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	rejected_only = _tmp2_;
#line 534 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	rejected_only.label = RESOURCES_DISPLAY_REJECTED_ONLY_MENU;
#line 535 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	rejected_only.tooltip = RESOURCES_DISPLAY_REJECTED_ONLY_TOOLTIP;
#line 536 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = view_filter_actions;
#line 536 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3__length1 = view_filter_actions_length1;
#line 536 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = rejected_only;
#line 536 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add338 (&view_filter_actions, &view_filter_actions_length1, &_view_filter_actions_size_, &_tmp4_);
#line 538 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_.name = "CommonDisplayRejectedOrHigher";
#line 538 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_.stock_id = NULL;
#line 538 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_.label = TRANSLATABLE;
#line 538 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_.accelerator = "<Ctrl>9";
#line 538 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_.tooltip = TRANSLATABLE;
#line 538 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_.value = (gint) RATING_FILTER_REJECTED_OR_HIGHER;
#line 538 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	rejected_or_higher = _tmp5_;
#line 540 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	rejected_or_higher.label = RESOURCES_DISPLAY_REJECTED_OR_HIGHER_MENU;
#line 541 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = g_dpgettext2 (NULL, "Tooltip", RESOURCES_DISPLAY_REJECTED_OR_HIGHER_TOOLTIP);
#line 541 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	rejected_or_higher.tooltip = _tmp6_;
#line 543 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = view_filter_actions;
#line 543 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7__length1 = view_filter_actions_length1;
#line 543 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = rejected_or_higher;
#line 543 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add339 (&view_filter_actions, &view_filter_actions_length1, &_view_filter_actions_size_, &_tmp8_);
#line 545 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_.name = "CommonDisplayUnratedOrHigher";
#line 545 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_.stock_id = NULL;
#line 545 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_.label = TRANSLATABLE;
#line 545 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_.accelerator = "<Ctrl>0";
#line 545 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_.tooltip = TRANSLATABLE;
#line 545 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_.value = (gint) RATING_FILTER_UNRATED_OR_HIGHER;
#line 545 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	unrated_or_higher = _tmp9_;
#line 547 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	unrated_or_higher.label = RESOURCES_DISPLAY_UNRATED_OR_HIGHER_MENU;
#line 548 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	unrated_or_higher.tooltip = RESOURCES_DISPLAY_UNRATED_OR_HIGHER_TOOLTIP;
#line 549 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = view_filter_actions;
#line 549 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10__length1 = view_filter_actions_length1;
#line 549 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = unrated_or_higher;
#line 549 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add340 (&view_filter_actions, &view_filter_actions_length1, &_view_filter_actions_size_, &_tmp11_);
#line 551 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_.name = "CommonDisplayOneOrHigher";
#line 551 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_.stock_id = NULL;
#line 551 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_.label = TRANSLATABLE;
#line 551 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_.accelerator = "<Ctrl>1";
#line 551 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_.tooltip = TRANSLATABLE;
#line 551 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_.value = (gint) RATING_FILTER_ONE_OR_HIGHER;
#line 551 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	one_or_higher = _tmp12_;
#line 553 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp13_ = resources_DISPLAY_ONE_OR_HIGHER_MENU;
#line 553 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	one_or_higher.label = _tmp13_;
#line 554 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp14_ = resources_DISPLAY_ONE_OR_HIGHER_TOOLTIP;
#line 554 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	one_or_higher.tooltip = _tmp14_;
#line 555 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp15_ = view_filter_actions;
#line 555 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp15__length1 = view_filter_actions_length1;
#line 555 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp16_ = one_or_higher;
#line 555 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add341 (&view_filter_actions, &view_filter_actions_length1, &_view_filter_actions_size_, &_tmp16_);
#line 557 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_.name = "CommonDisplayTwoOrHigher";
#line 557 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_.stock_id = NULL;
#line 557 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_.label = TRANSLATABLE;
#line 557 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_.accelerator = "<Ctrl>2";
#line 557 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_.tooltip = TRANSLATABLE;
#line 557 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_.value = (gint) RATING_FILTER_TWO_OR_HIGHER;
#line 557 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	two_or_higher = _tmp17_;
#line 559 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp18_ = resources_DISPLAY_TWO_OR_HIGHER_MENU;
#line 559 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	two_or_higher.label = _tmp18_;
#line 560 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp19_ = resources_DISPLAY_TWO_OR_HIGHER_TOOLTIP;
#line 560 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	two_or_higher.tooltip = _tmp19_;
#line 561 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp20_ = view_filter_actions;
#line 561 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp20__length1 = view_filter_actions_length1;
#line 561 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp21_ = two_or_higher;
#line 561 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add342 (&view_filter_actions, &view_filter_actions_length1, &_view_filter_actions_size_, &_tmp21_);
#line 563 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_.name = "CommonDisplayThreeOrHigher";
#line 563 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_.stock_id = NULL;
#line 563 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_.label = TRANSLATABLE;
#line 563 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_.accelerator = "<Ctrl>3";
#line 563 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_.tooltip = TRANSLATABLE;
#line 563 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_.value = (gint) RATING_FILTER_THREE_OR_HIGHER;
#line 563 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	three_or_higher = _tmp22_;
#line 565 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp23_ = resources_DISPLAY_THREE_OR_HIGHER_MENU;
#line 565 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	three_or_higher.label = _tmp23_;
#line 566 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp24_ = resources_DISPLAY_THREE_OR_HIGHER_TOOLTIP;
#line 566 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	three_or_higher.tooltip = _tmp24_;
#line 567 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp25_ = view_filter_actions;
#line 567 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp25__length1 = view_filter_actions_length1;
#line 567 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp26_ = three_or_higher;
#line 567 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add343 (&view_filter_actions, &view_filter_actions_length1, &_view_filter_actions_size_, &_tmp26_);
#line 569 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_.name = "CommonDisplayFourOrHigher";
#line 569 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_.stock_id = NULL;
#line 569 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_.label = TRANSLATABLE;
#line 569 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_.accelerator = "<Ctrl>4";
#line 569 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_.tooltip = TRANSLATABLE;
#line 569 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_.value = (gint) RATING_FILTER_FOUR_OR_HIGHER;
#line 569 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	four_or_higher = _tmp27_;
#line 571 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp28_ = resources_DISPLAY_FOUR_OR_HIGHER_MENU;
#line 571 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	four_or_higher.label = _tmp28_;
#line 572 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp29_ = resources_DISPLAY_FOUR_OR_HIGHER_TOOLTIP;
#line 572 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	four_or_higher.tooltip = _tmp29_;
#line 573 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp30_ = view_filter_actions;
#line 573 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp30__length1 = view_filter_actions_length1;
#line 573 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp31_ = four_or_higher;
#line 573 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add344 (&view_filter_actions, &view_filter_actions_length1, &_view_filter_actions_size_, &_tmp31_);
#line 575 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_.name = "CommonDisplayFiveOrHigher";
#line 575 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_.stock_id = NULL;
#line 575 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_.label = TRANSLATABLE;
#line 575 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_.accelerator = "<Ctrl>5";
#line 575 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_.tooltip = TRANSLATABLE;
#line 575 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_.value = (gint) RATING_FILTER_FIVE_OR_HIGHER;
#line 575 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	five_or_higher = _tmp32_;
#line 577 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp33_ = resources_DISPLAY_FIVE_OR_HIGHER_MENU;
#line 577 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	five_or_higher.label = _tmp33_;
#line 578 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp34_ = resources_DISPLAY_FIVE_OR_HIGHER_TOOLTIP;
#line 578 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	five_or_higher.tooltip = _tmp34_;
#line 579 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp35_ = view_filter_actions;
#line 579 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp35__length1 = view_filter_actions_length1;
#line 579 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp36_ = five_or_higher;
#line 579 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add345 (&view_filter_actions, &view_filter_actions_length1, &_view_filter_actions_size_, &_tmp36_);
#line 581 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp37_ = self->priv->action_group;
#line 581 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp38_ = view_filter_actions;
#line 581 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp38__length1 = view_filter_actions_length1;
#line 581 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_action_group_add_radio_actions (_tmp37_, _tmp38_, _tmp38__length1, (gint) RATING_FILTER_UNRATED_OR_HIGHER, (GCallback) _search_filter_actions_on_rating_changed_gtk_radio_action_callback, self);
#line 584 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp39_ = g_new0 (GtkToggleActionEntry, 0);
#line 584 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	toggle_actions = _tmp39_;
#line 584 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	toggle_actions_length1 = 0;
#line 584 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_toggle_actions_size_ = toggle_actions_length1;
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_.name = "CommonDisplayFlagged";
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_.stock_id = RESOURCES_ICON_FILTER_FLAGGED;
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_.label = TRANSLATABLE;
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_.accelerator = NULL;
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_.tooltip = TRANSLATABLE;
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_.callback = (GCallback) _search_filter_actions_on_flagged_toggled_gtk_action_callback;
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_.is_active = FALSE;
#line 586 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	flagged_action = _tmp40_;
#line 588 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp41_ = _ ("Flagged");
#line 588 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	flagged_action.label = _tmp41_;
#line 589 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp42_ = _ ("Flagged");
#line 589 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	flagged_action.tooltip = _tmp42_;
#line 590 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp43_ = toggle_actions;
#line 590 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp43__length1 = toggle_actions_length1;
#line 590 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp44_ = flagged_action;
#line 590 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add346 (&toggle_actions, &toggle_actions_length1, &_toggle_actions_size_, &_tmp44_);
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_.name = "CommonDisplayPhotos";
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_.stock_id = RESOURCES_ICON_FILTER_PHOTOS;
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_.label = TRANSLATABLE;
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_.accelerator = NULL;
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_.tooltip = TRANSLATABLE;
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_.callback = (GCallback) _search_filter_actions_on_photos_toggled_gtk_action_callback;
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_.is_active = FALSE;
#line 592 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	photos_action = _tmp45_;
#line 594 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp46_ = _ ("Photos");
#line 594 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	photos_action.label = _tmp46_;
#line 595 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp47_ = _ ("Photos");
#line 595 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	photos_action.tooltip = _tmp47_;
#line 596 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp48_ = toggle_actions;
#line 596 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp48__length1 = toggle_actions_length1;
#line 596 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp49_ = photos_action;
#line 596 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add347 (&toggle_actions, &toggle_actions_length1, &_toggle_actions_size_, &_tmp49_);
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_.name = "CommonDisplayVideos";
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_.stock_id = RESOURCES_ICON_FILTER_VIDEOS;
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_.label = TRANSLATABLE;
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_.accelerator = NULL;
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_.tooltip = TRANSLATABLE;
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_.callback = (GCallback) _search_filter_actions_on_videos_toggled_gtk_action_callback;
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_.is_active = FALSE;
#line 598 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	videos_action = _tmp50_;
#line 600 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp51_ = _ ("Videos");
#line 600 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	videos_action.label = _tmp51_;
#line 601 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp52_ = _ ("Videos");
#line 601 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	videos_action.tooltip = _tmp52_;
#line 602 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp53_ = toggle_actions;
#line 602 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp53__length1 = toggle_actions_length1;
#line 602 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp54_ = videos_action;
#line 602 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add348 (&toggle_actions, &toggle_actions_length1, &_toggle_actions_size_, &_tmp54_);
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_.name = "CommonDisplayRaw";
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_.stock_id = RESOURCES_ICON_FILTER_RAW;
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_.label = TRANSLATABLE;
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_.accelerator = NULL;
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_.tooltip = TRANSLATABLE;
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_.callback = (GCallback) _search_filter_actions_on_raw_toggled_gtk_action_callback;
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_.is_active = FALSE;
#line 604 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	raw_action = _tmp55_;
#line 606 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp56_ = _ ("RAW Photos");
#line 606 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	raw_action.label = _tmp56_;
#line 607 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp57_ = _ ("RAW photos");
#line 607 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	raw_action.tooltip = _tmp57_;
#line 608 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp58_ = toggle_actions;
#line 608 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp58__length1 = toggle_actions_length1;
#line 608 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp59_ = raw_action;
#line 608 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_array_add349 (&toggle_actions, &toggle_actions_length1, &_toggle_actions_size_, &_tmp59_);
#line 610 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp60_ = self->priv->action_group;
#line 610 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp61_ = toggle_actions;
#line 610 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp61__length1 = toggle_actions_length1;
#line 610 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_action_group_add_toggle_actions (_tmp60_, _tmp61_, _tmp61__length1, self);
#line 527 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	toggle_actions = (g_free (toggle_actions), NULL);
#line 527 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	view_filter_actions = (g_free (view_filter_actions), NULL);
#line 4596 "SearchFilter.c"
}


static void search_filter_actions_on_rating_changed (SearchFilterActions* self, GtkAction* action, GtkAction* current) {
	GtkAction* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 613 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 613 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (GTK_IS_ACTION (action));
#line 613 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (GTK_IS_ACTION (current));
#line 614 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = current;
#line 614 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = gtk_radio_action_get_current_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_action_get_type (), GtkRadioAction));
#line 614 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "rating-changed", (RatingFilter) _tmp1_);
#line 4615 "SearchFilter.c"
}


static void search_filter_actions_on_flagged_toggled (SearchFilterActions* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 617 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 617 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (GTK_IS_ACTION (action));
#line 618 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = action;
#line 618 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = gtk_toggle_action_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 618 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = _tmp1_;
#line 618 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "flagged-toggled", _tmp2_);
#line 4635 "SearchFilter.c"
}


static void search_filter_actions_on_photos_toggled (SearchFilterActions* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 621 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 621 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (GTK_IS_ACTION (action));
#line 622 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = action;
#line 622 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = gtk_toggle_action_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 622 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = _tmp1_;
#line 622 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "photos-toggled", _tmp2_);
#line 4655 "SearchFilter.c"
}


static void search_filter_actions_on_videos_toggled (SearchFilterActions* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 625 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 625 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (GTK_IS_ACTION (action));
#line 626 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = action;
#line 626 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = gtk_toggle_action_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 626 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = _tmp1_;
#line 626 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "videos-toggled", _tmp2_);
#line 4675 "SearchFilter.c"
}


static void search_filter_actions_on_raw_toggled (SearchFilterActions* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 629 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_ACTIONS (self));
#line 629 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (GTK_IS_ACTION (action));
#line 630 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = action;
#line 630 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = gtk_toggle_action_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 630 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = _tmp1_;
#line 630 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "raw-toggled", _tmp2_);
#line 4695 "SearchFilter.c"
}


gboolean search_filter_actions_get_has_photos (SearchFilterActions* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 633 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), FALSE);
#line 634 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->has_photos;
#line 634 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 634 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4710 "SearchFilter.c"
}


gboolean search_filter_actions_get_has_videos (SearchFilterActions* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 637 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), FALSE);
#line 638 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->has_videos;
#line 638 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 638 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4725 "SearchFilter.c"
}


gboolean search_filter_actions_get_has_raw (SearchFilterActions* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 641 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), FALSE);
#line 642 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->has_raw;
#line 642 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 642 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4740 "SearchFilter.c"
}


gboolean search_filter_actions_get_has_flagged (SearchFilterActions* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 645 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), FALSE);
#line 646 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->has_flagged;
#line 646 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp0_;
#line 646 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4755 "SearchFilter.c"
}


GtkToggleAction* search_filter_actions_get_flagged (SearchFilterActions* self) {
	GtkToggleAction* result;
	GtkAction* _tmp0_ = NULL;
#line 321 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), NULL);
#line 322 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = search_filter_actions_get_action (self, "CommonDisplayFlagged");
#line 322 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp0_) : NULL;
#line 322 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4770 "SearchFilter.c"
}


GtkToggleAction* search_filter_actions_get_photos (SearchFilterActions* self) {
	GtkToggleAction* result;
	GtkAction* _tmp0_ = NULL;
#line 327 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), NULL);
#line 328 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = search_filter_actions_get_action (self, "CommonDisplayPhotos");
#line 328 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp0_) : NULL;
#line 328 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4785 "SearchFilter.c"
}


GtkToggleAction* search_filter_actions_get_videos (SearchFilterActions* self) {
	GtkToggleAction* result;
	GtkAction* _tmp0_ = NULL;
#line 333 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), NULL);
#line 334 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = search_filter_actions_get_action (self, "CommonDisplayVideos");
#line 334 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp0_) : NULL;
#line 334 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4800 "SearchFilter.c"
}


GtkToggleAction* search_filter_actions_get_raw (SearchFilterActions* self) {
	GtkToggleAction* result;
	GtkAction* _tmp0_ = NULL;
#line 339 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), NULL);
#line 340 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = search_filter_actions_get_action (self, "CommonDisplayRaw");
#line 340 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp0_) : NULL;
#line 340 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4815 "SearchFilter.c"
}


GtkRadioAction* search_filter_actions_get_rating (SearchFilterActions* self) {
	GtkRadioAction* result;
	GtkAction* _tmp0_ = NULL;
#line 345 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), NULL);
#line 346 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = search_filter_actions_get_action (self, "CommonDisplayUnratedOrHigher");
#line 346 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_radio_action_get_type ()) ? ((GtkRadioAction*) _tmp0_) : NULL;
#line 346 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4830 "SearchFilter.c"
}


TextAction* search_filter_actions_get_text (SearchFilterActions* self) {
	TextAction* result;
	TextAction* _tmp0_ = NULL;
	TextAction* _tmp1_ = NULL;
#line 351 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (self), NULL);
#line 352 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->_text;
#line 352 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_assert (_tmp0_ != NULL, "_text != null");
#line 353 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = self->priv->_text;
#line 353 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp1_;
#line 353 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 4850 "SearchFilter.c"
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN_BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN_BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gboolean arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN_BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (n_param_values == 5);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		data1 = closure->data;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		data2 = param_values->data[0].v_pointer;
#line 4869 "SearchFilter.c"
	} else {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		data1 = param_values->data[0].v_pointer;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		data2 = closure->data;
#line 4875 "SearchFilter.c"
	}
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN_BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), g_value_get_boolean (param_values + 3), g_value_get_boolean (param_values + 4), data2);
#line 4881 "SearchFilter.c"
}


static void value_search_filter_actions_init (GValue* value) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	value->data[0].v_pointer = NULL;
#line 4888 "SearchFilter.c"
}


static void value_search_filter_actions_free_value (GValue* value) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (value->data[0].v_pointer) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_actions_unref (value->data[0].v_pointer);
#line 4897 "SearchFilter.c"
	}
}


static void value_search_filter_actions_copy_value (const GValue* src_value, GValue* dest_value) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (src_value->data[0].v_pointer) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		dest_value->data[0].v_pointer = search_filter_actions_ref (src_value->data[0].v_pointer);
#line 4907 "SearchFilter.c"
	} else {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4911 "SearchFilter.c"
	}
}


static gpointer value_search_filter_actions_peek_pointer (const GValue* value) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return value->data[0].v_pointer;
#line 4919 "SearchFilter.c"
}


static gchar* value_search_filter_actions_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (collect_values[0].v_pointer) {
#line 4926 "SearchFilter.c"
		SearchFilterActions* object;
		object = collect_values[0].v_pointer;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (object->parent_instance.g_class == NULL) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4933 "SearchFilter.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4937 "SearchFilter.c"
		}
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = search_filter_actions_ref (object);
#line 4941 "SearchFilter.c"
	} else {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = NULL;
#line 4945 "SearchFilter.c"
	}
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return NULL;
#line 4949 "SearchFilter.c"
}


static gchar* value_search_filter_actions_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SearchFilterActions** object_p;
	object_p = collect_values[0].v_pointer;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (!object_p) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4960 "SearchFilter.c"
	}
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (!value->data[0].v_pointer) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*object_p = NULL;
#line 4966 "SearchFilter.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*object_p = value->data[0].v_pointer;
#line 4970 "SearchFilter.c"
	} else {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*object_p = search_filter_actions_ref (value->data[0].v_pointer);
#line 4974 "SearchFilter.c"
	}
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return NULL;
#line 4978 "SearchFilter.c"
}


GParamSpec* param_spec_search_filter_actions (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSearchFilterActions* spec;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SEARCH_FILTER_ACTIONS), NULL);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return G_PARAM_SPEC (spec);
#line 4992 "SearchFilter.c"
}


gpointer value_get_search_filter_actions (const GValue* value) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_FILTER_ACTIONS), NULL);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return value->data[0].v_pointer;
#line 5001 "SearchFilter.c"
}


void value_set_search_filter_actions (GValue* value, gpointer v_object) {
	SearchFilterActions* old;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_FILTER_ACTIONS));
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	old = value->data[0].v_pointer;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (v_object) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEARCH_FILTER_ACTIONS));
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = v_object;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_actions_ref (value->data[0].v_pointer);
#line 5021 "SearchFilter.c"
	} else {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = NULL;
#line 5025 "SearchFilter.c"
	}
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (old) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_actions_unref (old);
#line 5031 "SearchFilter.c"
	}
}


void value_take_search_filter_actions (GValue* value, gpointer v_object) {
	SearchFilterActions* old;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SEARCH_FILTER_ACTIONS));
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	old = value->data[0].v_pointer;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (v_object) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SEARCH_FILTER_ACTIONS));
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = v_object;
#line 5050 "SearchFilter.c"
	} else {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		value->data[0].v_pointer = NULL;
#line 5054 "SearchFilter.c"
	}
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (old) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_actions_unref (old);
#line 5060 "SearchFilter.c"
	}
}


static void search_filter_actions_class_init (SearchFilterActionsClass * klass) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_parent_class = g_type_class_peek_parent (klass);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	((SearchFilterActionsClass *) klass)->finalize = search_filter_actions_finalize;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_type_class_add_private (klass, sizeof (SearchFilterActionsPrivate));
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("flagged_toggled", TYPE_SEARCH_FILTER_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("photos_toggled", TYPE_SEARCH_FILTER_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("videos_toggled", TYPE_SEARCH_FILTER_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("raw_toggled", TYPE_SEARCH_FILTER_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("rating_changed", TYPE_SEARCH_FILTER_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, TYPE_RATING_FILTER);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("text_changed", TYPE_SEARCH_FILTER_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 5084 "SearchFilter.c"
	/**
	     * fired when the kinds of media present in the current view change (e.g., a video becomes
	     * available in the view through a new import operation or no raw photos are available in
	     * the view anymore because the last one was moved to the trash)
	     */
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("media_context_changed", TYPE_SEARCH_FILTER_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN_BOOLEAN_BOOLEAN, G_TYPE_NONE, 4, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("criteria_changed", TYPE_SEARCH_FILTER_ACTIONS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 5094 "SearchFilter.c"
}


static void search_filter_actions_instance_init (SearchFilterActions * self) {
	GtkActionGroup* _tmp0_ = NULL;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv = SEARCH_FILTER_ACTIONS_GET_PRIVATE (self);
#line 357 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = gtk_action_group_new ("SearchFilterActionGroup");
#line 357 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->action_group = _tmp0_;
#line 358 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->criteria = SEARCH_FILTER_CRITERIA_ALL;
#line 359 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->_text = NULL;
#line 360 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_flagged = TRUE;
#line 361 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_photos = TRUE;
#line 362 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_videos = TRUE;
#line 363 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->has_raw = TRUE;
#line 364 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->can_filter_by_stars = TRUE;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->ref_count = 1;
#line 5122 "SearchFilter.c"
}


static void search_filter_actions_finalize (SearchFilterActions* obj) {
	SearchFilterActions * self;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_FILTER_ACTIONS, SearchFilterActions);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_destroy (self);
#line 357 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->action_group);
#line 359 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_text_action_unref0 (self->priv->_text);
#line 5136 "SearchFilter.c"
}


GType search_filter_actions_get_type (void) {
	static volatile gsize search_filter_actions_type_id__volatile = 0;
	if (g_once_init_enter (&search_filter_actions_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_search_filter_actions_init, value_search_filter_actions_free_value, value_search_filter_actions_copy_value, value_search_filter_actions_peek_pointer, "p", value_search_filter_actions_collect_value, "p", value_search_filter_actions_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SearchFilterActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_filter_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchFilterActions), 0, (GInstanceInitFunc) search_filter_actions_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType search_filter_actions_type_id;
		search_filter_actions_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SearchFilterActions", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&search_filter_actions_type_id__volatile, search_filter_actions_type_id);
	}
	return search_filter_actions_type_id__volatile;
}


gpointer search_filter_actions_ref (gpointer instance) {
	SearchFilterActions* self;
	self = instance;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_atomic_int_inc (&self->ref_count);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return instance;
#line 5161 "SearchFilter.c"
}


void search_filter_actions_unref (gpointer instance) {
	SearchFilterActions* self;
	self = instance;
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		SEARCH_FILTER_ACTIONS_GET_CLASS (self)->finalize (self);
#line 319 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5174 "SearchFilter.c"
	}
}


static void _search_filter_toolbar_on_media_context_changed_search_filter_actions_media_context_changed (SearchFilterActions* _sender, gboolean has_photos, gboolean has_videos, gboolean has_raw, gboolean has_flagged, gpointer self) {
#line 1033 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_media_context_changed ((SearchFilterToolbar*) self, has_photos, has_videos, has_raw, has_flagged);
#line 5182 "SearchFilter.c"
}


static void _search_filter_toolbar_on_flagged_toggled_search_filter_actions_flagged_toggled (SearchFilterActions* _sender, gboolean on, gpointer self) {
#line 1035 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_flagged_toggled ((SearchFilterToolbar*) self);
#line 5189 "SearchFilter.c"
}


static void _search_filter_toolbar_on_photos_toggled_search_filter_actions_photos_toggled (SearchFilterActions* _sender, gboolean on, gpointer self) {
#line 1036 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_photos_toggled ((SearchFilterToolbar*) self);
#line 5196 "SearchFilter.c"
}


static void _search_filter_toolbar_on_videos_toggled_search_filter_actions_videos_toggled (SearchFilterActions* _sender, gboolean on, gpointer self) {
#line 1037 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_videos_toggled ((SearchFilterToolbar*) self);
#line 5203 "SearchFilter.c"
}


static void _search_filter_toolbar_on_raw_toggled_search_filter_actions_raw_toggled (SearchFilterActions* _sender, gboolean on, gpointer self) {
#line 1038 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_raw_toggled ((SearchFilterToolbar*) self);
#line 5210 "SearchFilter.c"
}


static void _search_filter_toolbar_on_rating_changed_search_filter_actions_rating_changed (SearchFilterActions* _sender, RatingFilter filter, gpointer self) {
#line 1039 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_rating_changed ((SearchFilterToolbar*) self);
#line 5217 "SearchFilter.c"
}


static void _search_filter_toolbar_on_search_text_changed_search_filter_actions_text_changed (SearchFilterActions* _sender, const gchar* text, gpointer self) {
#line 1040 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_search_text_changed ((SearchFilterToolbar*) self);
#line 5224 "SearchFilter.c"
}


static void _search_filter_toolbar_on_criteria_changed_search_filter_actions_criteria_changed (SearchFilterActions* _sender, gpointer self) {
#line 1041 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_criteria_changed ((SearchFilterToolbar*) self);
#line 5231 "SearchFilter.c"
}


static gboolean _search_filter_toolbar_on_context_menu_requested_gtk_toolbar_popup_context_menu (GtkToolbar* _sender, gint x, gint y, gint button_number, gpointer self) {
	gboolean result;
	result = search_filter_toolbar_on_context_menu_requested ((SearchFilterToolbar*) self, x, y, button_number);
#line 1043 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 5240 "SearchFilter.c"
}


static gpointer _search_filter_actions_ref0 (gpointer self) {
#line 936 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self ? search_filter_actions_ref (self) : NULL;
#line 5247 "SearchFilter.c"
}


static void _search_filter_toolbar_on_context_menu_close_chosen_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
#line 961 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_context_menu_close_chosen ((SearchFilterToolbar*) self);
#line 5254 "SearchFilter.c"
}


static void _search_filter_toolbar_on_filter_button_clicked_search_filter_toolbar_rating_filter_button_clicked (SearchFilterToolbarRatingFilterButton* _sender, gpointer self) {
#line 1001 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_filter_button_clicked ((SearchFilterToolbar*) self);
#line 5261 "SearchFilter.c"
}


SearchFilterToolbar* search_filter_toolbar_construct (GType object_type, SearchFilterActions* actions) {
	SearchFilterToolbar * self = NULL;
	SearchFilterActions* _tmp0_ = NULL;
	SearchFilterActions* _tmp1_ = NULL;
	GtkToolbar* _tmp2_ = NULL;
	SearchFilterActions* _tmp3_ = NULL;
	SearchFilterActions* _tmp4_ = NULL;
	TextAction* _tmp5_ = NULL;
	TextAction* _tmp6_ = NULL;
	SearchFilterToolbarSearchBox* _tmp7_ = NULL;
	GtkToolbar* _tmp8_ = NULL;
	GtkToolbar* _tmp9_ = NULL;
	GFile* ui_file = NULL;
	GFile* _tmp10_ = NULL;
	GtkUIManager* _tmp21_ = NULL;
	SearchFilterActions* _tmp22_ = NULL;
	GtkActionGroup* _tmp23_ = NULL;
	GtkActionGroup* _tmp24_ = NULL;
	GtkMenuItem* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GtkMenuItem* _tmp27_ = NULL;
	GtkMenuItem* _tmp28_ = NULL;
	GtkMenu* _tmp29_ = NULL;
	GtkMenuItem* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	SearchFilterToolbarLabelToolItem* _tmp32_ = NULL;
	GtkToolbar* _tmp33_ = NULL;
	SearchFilterToolbarLabelToolItem* _tmp34_ = NULL;
	SearchFilterActions* _tmp35_ = NULL;
	GtkToggleAction* _tmp36_ = NULL;
	GtkToggleAction* _tmp37_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp38_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp39_ = NULL;
	SearchFilterActions* _tmp40_ = NULL;
	GtkActionGroup* _tmp41_ = NULL;
	GtkActionGroup* _tmp42_ = NULL;
	GtkAction* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	SearchFilterActions* _tmp46_ = NULL;
	GtkToggleAction* _tmp47_ = NULL;
	GtkToggleAction* _tmp48_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp49_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp50_ = NULL;
	SearchFilterActions* _tmp51_ = NULL;
	GtkActionGroup* _tmp52_ = NULL;
	GtkActionGroup* _tmp53_ = NULL;
	GtkAction* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	SearchFilterActions* _tmp57_ = NULL;
	GtkToggleAction* _tmp58_ = NULL;
	GtkToggleAction* _tmp59_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp60_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp61_ = NULL;
	SearchFilterActions* _tmp62_ = NULL;
	GtkActionGroup* _tmp63_ = NULL;
	GtkActionGroup* _tmp64_ = NULL;
	GtkAction* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	const gchar* _tmp67_ = NULL;
	GtkToolbar* _tmp68_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp69_ = NULL;
	GtkToolbar* _tmp70_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp71_ = NULL;
	GtkToolbar* _tmp72_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp73_ = NULL;
	GtkSeparatorToolItem* _tmp74_ = NULL;
	GtkToolbar* _tmp75_ = NULL;
	GtkSeparatorToolItem* _tmp76_ = NULL;
	SearchFilterActions* _tmp77_ = NULL;
	GtkToggleAction* _tmp78_ = NULL;
	GtkToggleAction* _tmp79_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp80_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp83_ = NULL;
	SearchFilterActions* _tmp84_ = NULL;
	GtkActionGroup* _tmp85_ = NULL;
	GtkActionGroup* _tmp86_ = NULL;
	GtkAction* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	const gchar* _tmp89_ = NULL;
	GtkToolbar* _tmp90_ = NULL;
	SearchFilterToolbarToggleActionToolButton* _tmp91_ = NULL;
	GtkSeparatorToolItem* _tmp92_ = NULL;
	GtkToolbar* _tmp93_ = NULL;
	GtkSeparatorToolItem* _tmp94_ = NULL;
	SearchFilterToolbarRatingFilterButton* _tmp95_ = NULL;
	GtkUIManager* _tmp96_ = NULL;
	GtkWidget* _tmp97_ = NULL;
	GtkMenu* _tmp98_ = NULL;
	SearchFilterToolbarRatingFilterButton* _tmp99_ = NULL;
	const gchar* _tmp100_ = NULL;
	SearchFilterToolbarRatingFilterButton* _tmp101_ = NULL;
	SearchFilterToolbarRatingFilterButton* _tmp102_ = NULL;
	GtkToolbar* _tmp103_ = NULL;
	SearchFilterToolbarRatingFilterButton* _tmp104_ = NULL;
	GtkSeparatorToolItem* separator_align = NULL;
	GtkSeparatorToolItem* _tmp105_ = NULL;
	GtkToolbar* _tmp106_ = NULL;
	GtkToolbar* _tmp107_ = NULL;
	SearchFilterToolbarSearchBox* _tmp108_ = NULL;
	GtkToolbar* _tmp109_ = NULL;
	SearchFilterActions* _tmp110_ = NULL;
	SearchFilterActions* _tmp111_ = NULL;
	SearchFilterActions* _tmp112_ = NULL;
	SearchFilterActions* _tmp113_ = NULL;
	SearchFilterActions* _tmp114_ = NULL;
	SearchFilterActions* _tmp115_ = NULL;
	SearchFilterActions* _tmp116_ = NULL;
	GtkToolbar* _tmp117_ = NULL;
	SearchFilterActions* _tmp118_ = NULL;
	gboolean _tmp119_ = FALSE;
	SearchFilterActions* _tmp120_ = NULL;
	gboolean _tmp121_ = FALSE;
	SearchFilterActions* _tmp122_ = NULL;
	gboolean _tmp123_ = FALSE;
	SearchFilterActions* _tmp124_ = NULL;
	gboolean _tmp125_ = FALSE;
	GError * _inner_error_ = NULL;
#line 935 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_ACTIONS (actions), NULL);
#line 935 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (SearchFilterToolbar*) g_object_new (object_type, NULL);
#line 936 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = actions;
#line 936 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _search_filter_actions_ref0 (_tmp0_);
#line 936 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_search_filter_actions_unref0 (self->priv->actions);
#line 936 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->actions = _tmp1_;
#line 937 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = (GtkToolbar*) gtk_toolbar_new ();
#line 937 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp2_);
#line 937 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbar);
#line 937 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->toolbar = _tmp2_;
#line 938 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = actions;
#line 938 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp3_, "media-context-changed", (GCallback) _search_filter_toolbar_on_media_context_changed_search_filter_actions_media_context_changed, self, 0);
#line 939 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = actions;
#line 939 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = search_filter_actions_get_text (_tmp4_);
#line 939 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = _tmp5_;
#line 939 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = search_filter_toolbar_search_box_new (_tmp6_);
#line 939 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp7_);
#line 939 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->search_box);
#line 939 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_box = _tmp7_;
#line 941 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = self->priv->toolbar;
#line 941 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_buildable_set_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_BUILDABLE, GtkBuildable), "search-filter-toolbar");
#line 942 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = self->priv->toolbar;
#line 942 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_set_icon_size (_tmp9_, GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 944 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = resources_get_ui ("search_bar.ui");
#line 944 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	ui_file = _tmp10_;
#line 5436 "SearchFilter.c"
	{
		GtkUIManager* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 946 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp11_ = self->ui;
#line 946 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp12_ = g_file_get_path (ui_file);
#line 946 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp13_ = _tmp12_;
#line 946 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		gtk_ui_manager_add_ui_from_file (_tmp11_, _tmp13_, &_inner_error_);
#line 946 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_free0 (_tmp13_);
#line 946 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5453 "SearchFilter.c"
			goto __catch578_g_error;
		}
	}
	goto __finally578;
	__catch578_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
#line 945 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		err = _inner_error_;
#line 945 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_inner_error_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp14_ = _ ("Error loading UI file %s: %s");
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp15_ = g_file_get_path (ui_file);
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp16_ = _tmp15_;
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp17_ = err;
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp18_ = _tmp17_->message;
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp19_ = g_strdup_printf (_tmp14_, _tmp16_, _tmp18_);
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp20_ = _tmp19_;
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		app_window_panic (_tmp20_);
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_free0 (_tmp20_);
#line 948 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_free0 (_tmp16_);
#line 945 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_error_free0 (err);
#line 5494 "SearchFilter.c"
	}
	__finally578:
#line 945 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 945 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (ui_file);
#line 945 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 945 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_clear_error (&_inner_error_);
#line 945 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		return NULL;
#line 5507 "SearchFilter.c"
	}
#line 952 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp21_ = self->ui;
#line 952 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_ = actions;
#line 952 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp23_ = search_filter_actions_get_action_group (_tmp22_);
#line 952 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp24_ = _tmp23_;
#line 952 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_ui_manager_insert_action_group (_tmp21_, _tmp24_, 0);
#line 952 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp24_);
#line 959 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp25_ = self->priv->close_item;
#line 959 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp26_ = _ ("Close");
#line 959 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_menu_item_set_label (_tmp25_, _tmp26_);
#line 960 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_ = self->priv->close_item;
#line 960 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
#line 961 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp28_ = self->priv->close_item;
#line 961 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp28_, "activate", (GCallback) _search_filter_toolbar_on_context_menu_close_chosen_gtk_menu_item_activate, self, 0);
#line 962 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp29_ = self->priv->close_menu;
#line 962 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp30_ = self->priv->close_item;
#line 962 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_menu_shell_append (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_menu_shell_get_type (), GtkMenuShell), (GtkWidget*) _tmp30_);
#line 965 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp31_ = _ ("Type");
#line 965 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_ = search_filter_toolbar_label_tool_item_new (_tmp31_, 10, 5);
#line 965 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp32_);
#line 965 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->label_type);
#line 965 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->label_type = _tmp32_;
#line 966 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp33_ = self->priv->toolbar;
#line 966 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp34_ = self->priv->label_type;
#line 966 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 968 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp35_ = actions;
#line 968 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp36_ = search_filter_actions_get_photos (_tmp35_);
#line 968 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp37_ = _tmp36_;
#line 968 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp38_ = search_filter_toolbar_toggle_action_tool_button_new (_tmp37_);
#line 968 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp38_);
#line 968 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbtn_photos);
#line 968 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->toolbtn_photos = _tmp38_;
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp39_ = self->priv->toolbtn_photos;
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_ = actions;
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp41_ = search_filter_actions_get_action_group (_tmp40_);
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp42_ = _tmp41_;
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp43_ = gtk_action_group_get_action (_tmp42_, "CommonDisplayPhotos");
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp44_ = gtk_action_get_tooltip (_tmp43_);
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_ = _tmp44_;
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_tool_item_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_tool_item_get_type (), GtkToolItem), _tmp45_);
#line 969 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp42_);
#line 971 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp46_ = actions;
#line 971 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp47_ = search_filter_actions_get_videos (_tmp46_);
#line 971 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp48_ = _tmp47_;
#line 971 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp49_ = search_filter_toolbar_toggle_action_tool_button_new (_tmp48_);
#line 971 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp49_);
#line 971 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbtn_videos);
#line 971 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->toolbtn_videos = _tmp49_;
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_ = self->priv->toolbtn_videos;
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp51_ = actions;
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp52_ = search_filter_actions_get_action_group (_tmp51_);
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp53_ = _tmp52_;
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp54_ = gtk_action_group_get_action (_tmp53_, "CommonDisplayVideos");
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_ = gtk_action_get_tooltip (_tmp54_);
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp56_ = _tmp55_;
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_tool_item_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_tool_item_get_type (), GtkToolItem), _tmp56_);
#line 972 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp53_);
#line 974 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp57_ = actions;
#line 974 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp58_ = search_filter_actions_get_raw (_tmp57_);
#line 974 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp59_ = _tmp58_;
#line 974 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp60_ = search_filter_toolbar_toggle_action_tool_button_new (_tmp59_);
#line 974 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp60_);
#line 974 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbtn_raw);
#line 974 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->toolbtn_raw = _tmp60_;
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp61_ = self->priv->toolbtn_raw;
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp62_ = actions;
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp63_ = search_filter_actions_get_action_group (_tmp62_);
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp64_ = _tmp63_;
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp65_ = gtk_action_group_get_action (_tmp64_, "CommonDisplayRaw");
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp66_ = gtk_action_get_tooltip (_tmp65_);
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp67_ = _tmp66_;
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_tool_item_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_tool_item_get_type (), GtkToolItem), _tmp67_);
#line 975 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp64_);
#line 977 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp68_ = self->priv->toolbar;
#line 977 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp69_ = self->priv->toolbtn_photos;
#line 977 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp68_, G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 978 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp70_ = self->priv->toolbar;
#line 978 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp71_ = self->priv->toolbtn_videos;
#line 978 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp70_, G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 979 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp72_ = self->priv->toolbar;
#line 979 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp73_ = self->priv->toolbtn_raw;
#line 979 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp72_, G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 982 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp74_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
#line 982 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp74_);
#line 982 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->sepr_mediatype_flagged);
#line 982 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->sepr_mediatype_flagged = _tmp74_;
#line 983 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp75_ = self->priv->toolbar;
#line 983 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp76_ = self->priv->sepr_mediatype_flagged;
#line 983 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp75_, G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 987 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp77_ = actions;
#line 987 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp78_ = search_filter_actions_get_flagged (_tmp77_);
#line 987 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp79_ = _tmp78_;
#line 987 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp80_ = search_filter_toolbar_toggle_action_tool_button_new (_tmp79_);
#line 987 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp80_);
#line 987 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbtn_flag);
#line 987 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->toolbtn_flag = _tmp80_;
#line 988 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp81_ = self->priv->toolbtn_flag;
#line 988 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp82_ = _ ("Flagged");
#line 988 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_toggle_action_tool_button_set_label (_tmp81_, _tmp82_);
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp83_ = self->priv->toolbtn_flag;
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp84_ = actions;
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp85_ = search_filter_actions_get_action_group (_tmp84_);
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp86_ = _tmp85_;
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp87_ = gtk_action_group_get_action (_tmp86_, "CommonDisplayFlagged");
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp88_ = gtk_action_get_tooltip (_tmp87_);
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp89_ = _tmp88_;
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_tool_item_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, gtk_tool_item_get_type (), GtkToolItem), _tmp89_);
#line 989 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp86_);
#line 991 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp90_ = self->priv->toolbar;
#line 991 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp91_ = self->priv->toolbtn_flag;
#line 991 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp90_, G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 994 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp92_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
#line 994 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp92_);
#line 994 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->sepr_flagged_rating);
#line 994 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->sepr_flagged_rating = _tmp92_;
#line 995 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp93_ = self->priv->toolbar;
#line 995 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp94_ = self->priv->sepr_flagged_rating;
#line 995 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp93_, G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 998 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp95_ = self->priv->rating_button;
#line 998 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp96_ = self->ui;
#line 998 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp97_ = gtk_ui_manager_get_widget (_tmp96_, "/FilterPopupMenu");
#line 998 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, gtk_menu_get_type (), GtkMenu));
#line 998 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp95_->filter_popup);
#line 998 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp95_->filter_popup = _tmp98_;
#line 999 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp99_ = self->priv->rating_button;
#line 999 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp100_ = _ ("Rating");
#line 999 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_rating_filter_button_set_label (_tmp99_, _tmp100_);
#line 1000 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp101_ = self->priv->rating_button;
#line 1000 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_tool_item_set_expand (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, gtk_tool_item_get_type (), GtkToolItem), FALSE);
#line 1001 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp102_ = self->priv->rating_button;
#line 1001 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp102_, "clicked", (GCallback) _search_filter_toolbar_on_filter_button_clicked_search_filter_toolbar_rating_filter_button_clicked, self, 0);
#line 1002 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp103_ = self->priv->toolbar;
#line 1002 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp104_ = self->priv->rating_button;
#line 1002 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp103_, G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 1005 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp105_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
#line 1005 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp105_);
#line 1005 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	separator_align = _tmp105_;
#line 1006 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_tool_item_set_expand (G_TYPE_CHECK_INSTANCE_CAST (separator_align, gtk_tool_item_get_type (), GtkToolItem), TRUE);
#line 1007 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_separator_tool_item_set_draw (separator_align, FALSE);
#line 1008 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp106_ = self->priv->toolbar;
#line 1008 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp106_, G_TYPE_CHECK_INSTANCE_CAST (separator_align, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 1011 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp107_ = self->priv->toolbar;
#line 1011 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp108_ = self->priv->search_box;
#line 1011 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toolbar_insert (_tmp107_, G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, gtk_tool_item_get_type (), GtkToolItem), -1);
#line 1013 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp109_ = self->priv->toolbar;
#line 1013 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, gtk_widget_get_type (), GtkWidget));
#line 1016 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp110_ = actions;
#line 1016 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp110_, "flagged-toggled", (GCallback) _search_filter_toolbar_on_flagged_toggled_search_filter_actions_flagged_toggled, self, 0);
#line 1017 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp111_ = actions;
#line 1017 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp111_, "photos-toggled", (GCallback) _search_filter_toolbar_on_photos_toggled_search_filter_actions_photos_toggled, self, 0);
#line 1018 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp112_ = actions;
#line 1018 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp112_, "videos-toggled", (GCallback) _search_filter_toolbar_on_videos_toggled_search_filter_actions_videos_toggled, self, 0);
#line 1019 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp113_ = actions;
#line 1019 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp113_, "raw-toggled", (GCallback) _search_filter_toolbar_on_raw_toggled_search_filter_actions_raw_toggled, self, 0);
#line 1020 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp114_ = actions;
#line 1020 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp114_, "rating-changed", (GCallback) _search_filter_toolbar_on_rating_changed_search_filter_actions_rating_changed, self, 0);
#line 1021 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp115_ = actions;
#line 1021 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp115_, "text-changed", (GCallback) _search_filter_toolbar_on_search_text_changed_search_filter_actions_text_changed, self, 0);
#line 1022 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp116_ = actions;
#line 1022 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp116_, "criteria-changed", (GCallback) _search_filter_toolbar_on_criteria_changed_search_filter_actions_criteria_changed, self, 0);
#line 1025 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp117_ = self->priv->toolbar;
#line 1025 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp117_, "popup-context-menu", (GCallback) _search_filter_toolbar_on_context_menu_requested_gtk_toolbar_popup_context_menu, self, 0);
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp118_ = actions;
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp119_ = search_filter_actions_get_has_photos (_tmp118_);
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp120_ = actions;
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp121_ = search_filter_actions_get_has_videos (_tmp120_);
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp122_ = actions;
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp123_ = search_filter_actions_get_has_raw (_tmp122_);
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp124_ = actions;
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp125_ = search_filter_actions_get_has_flagged (_tmp124_);
#line 1027 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_on_media_context_changed (self, _tmp119_, _tmp121_, _tmp123_, _tmp125_);
#line 935 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (separator_align);
#line 935 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (ui_file);
#line 935 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 5855 "SearchFilter.c"
}


SearchFilterToolbar* search_filter_toolbar_new (SearchFilterActions* actions) {
#line 935 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return search_filter_toolbar_construct (TYPE_SEARCH_FILTER_TOOLBAR, actions);
#line 5862 "SearchFilter.c"
}


static void search_filter_toolbar_on_media_context_changed (SearchFilterToolbar* self, gboolean has_photos, gboolean has_videos, gboolean has_raw, gboolean has_flagged) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp9_ = FALSE;
#line 1046 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1048 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = has_photos;
#line 1048 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp0_) {
#line 5877 "SearchFilter.c"
		SearchFilterToolbarToggleActionToolButton* _tmp1_ = NULL;
#line 1049 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp1_ = self->priv->toolbtn_photos;
#line 1049 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_toolbar_toggle_action_tool_button_set_icon_name (_tmp1_, RESOURCES_ICON_FILTER_PHOTOS);
#line 5883 "SearchFilter.c"
	} else {
		SearchFilterToolbarToggleActionToolButton* _tmp2_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = self->priv->toolbtn_photos;
#line 1051 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_toolbar_toggle_action_tool_button_set_icon_name (_tmp2_, RESOURCES_ICON_FILTER_PHOTOS_DISABLED);
#line 5890 "SearchFilter.c"
	}
#line 1053 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = has_videos;
#line 1053 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp3_) {
#line 5896 "SearchFilter.c"
		SearchFilterToolbarToggleActionToolButton* _tmp4_ = NULL;
#line 1054 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp4_ = self->priv->toolbtn_videos;
#line 1054 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_toolbar_toggle_action_tool_button_set_icon_name (_tmp4_, RESOURCES_ICON_FILTER_VIDEOS);
#line 5902 "SearchFilter.c"
	} else {
		SearchFilterToolbarToggleActionToolButton* _tmp5_ = NULL;
#line 1056 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp5_ = self->priv->toolbtn_videos;
#line 1056 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_toolbar_toggle_action_tool_button_set_icon_name (_tmp5_, RESOURCES_ICON_FILTER_VIDEOS_DISABLED);
#line 5909 "SearchFilter.c"
	}
#line 1058 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = has_raw;
#line 1058 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp6_) {
#line 5915 "SearchFilter.c"
		SearchFilterToolbarToggleActionToolButton* _tmp7_ = NULL;
#line 1059 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp7_ = self->priv->toolbtn_raw;
#line 1059 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_toolbar_toggle_action_tool_button_set_icon_name (_tmp7_, RESOURCES_ICON_FILTER_RAW);
#line 5921 "SearchFilter.c"
	} else {
		SearchFilterToolbarToggleActionToolButton* _tmp8_ = NULL;
#line 1061 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp8_ = self->priv->toolbtn_raw;
#line 1061 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_toolbar_toggle_action_tool_button_set_icon_name (_tmp8_, RESOURCES_ICON_FILTER_RAW_DISABLED);
#line 5928 "SearchFilter.c"
	}
#line 1063 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = has_flagged;
#line 1063 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp9_) {
#line 5934 "SearchFilter.c"
		SearchFilterToolbarToggleActionToolButton* _tmp10_ = NULL;
#line 1064 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp10_ = self->priv->toolbtn_flag;
#line 1064 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_toolbar_toggle_action_tool_button_set_icon_name (_tmp10_, RESOURCES_ICON_FILTER_FLAGGED);
#line 5940 "SearchFilter.c"
	} else {
		SearchFilterToolbarToggleActionToolButton* _tmp11_ = NULL;
#line 1066 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp11_ = self->priv->toolbtn_flag;
#line 1066 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		search_filter_toolbar_toggle_action_tool_button_set_icon_name (_tmp11_, RESOURCES_ICON_FILTER_FLAGGED_DISABLED);
#line 5947 "SearchFilter.c"
	}
}


static gboolean search_filter_toolbar_on_context_menu_requested (SearchFilterToolbar* self, gint x, gint y, gint button) {
	gboolean result = FALSE;
	GtkMenu* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint32 _tmp2_ = 0U;
#line 1070 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_SEARCH_FILTER_TOOLBAR (self), FALSE);
#line 1071 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->close_menu;
#line 1071 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = button;
#line 1071 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = gtk_get_current_event_time ();
#line 1071 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_menu_popup (_tmp0_, NULL, NULL, NULL, NULL, (guint) _tmp1_, _tmp2_);
#line 1072 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = FALSE;
#line 1072 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 5971 "SearchFilter.c"
}


static void search_filter_toolbar_on_context_menu_close_chosen (SearchFilterToolbar* self) {
	AppWindow* aw = NULL;
	LibraryWindow* _tmp0_ = NULL;
	GtkToggleAction* searchbar_toggle = NULL;
	AppWindow* _tmp1_ = NULL;
	GtkAction* _tmp2_ = NULL;
	GtkToggleAction* _tmp3_ = NULL;
	GtkToggleAction* _tmp4_ = NULL;
#line 1077 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1078 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = library_window_get_app ();
#line 1078 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	aw = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_APP_WINDOW, AppWindow);
#line 1083 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = aw;
#line 1083 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = app_window_get_common_action (_tmp1_, "CommonDisplaySearchbar");
#line 1083 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL;
#line 1083 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp3_ == NULL) {
#line 1083 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (_tmp2_);
#line 5999 "SearchFilter.c"
	}
#line 1083 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	searchbar_toggle = _tmp3_;
#line 1086 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = searchbar_toggle;
#line 1086 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp4_ != NULL) {
#line 6007 "SearchFilter.c"
		GtkToggleAction* _tmp5_ = NULL;
#line 1088 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp5_ = searchbar_toggle;
#line 1088 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		gtk_toggle_action_set_active (_tmp5_, FALSE);
#line 6013 "SearchFilter.c"
	}
#line 1077 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (searchbar_toggle);
#line 1077 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (aw);
#line 6019 "SearchFilter.c"
}


static void search_filter_toolbar_on_flagged_toggled (SearchFilterToolbar* self) {
#line 1092 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1093 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_update (self);
#line 6028 "SearchFilter.c"
}


static void search_filter_toolbar_on_videos_toggled (SearchFilterToolbar* self) {
#line 1096 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1097 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_update (self);
#line 6037 "SearchFilter.c"
}


static void search_filter_toolbar_on_photos_toggled (SearchFilterToolbar* self) {
#line 1100 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1101 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_update (self);
#line 6046 "SearchFilter.c"
}


static void search_filter_toolbar_on_raw_toggled (SearchFilterToolbar* self) {
#line 1104 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1105 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_update (self);
#line 6055 "SearchFilter.c"
}


static void search_filter_toolbar_on_search_text_changed (SearchFilterToolbar* self) {
#line 1108 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1109 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_update (self);
#line 6064 "SearchFilter.c"
}


static void search_filter_toolbar_on_rating_changed (SearchFilterToolbar* self) {
	AppWindow* aw = NULL;
	LibraryWindow* _tmp0_ = NULL;
	AppWindow* _tmp1_ = NULL;
	GtkToggleAction* searchbar_toggle = NULL;
	AppWindow* _tmp2_ = NULL;
	GtkAction* _tmp3_ = NULL;
	GtkToggleAction* _tmp4_ = NULL;
	GtkToggleAction* _tmp5_ = NULL;
#line 1112 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1113 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = library_window_get_app ();
#line 1113 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	aw = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_APP_WINDOW, AppWindow);
#line 1115 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = aw;
#line 1115 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp1_ == NULL) {
#line 1116 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (aw);
#line 1116 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		return;
#line 6091 "SearchFilter.c"
	}
#line 1118 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = aw;
#line 1118 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = app_window_get_common_action (_tmp2_, "CommonDisplaySearchbar");
#line 1118 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp3_) : NULL;
#line 1118 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp4_ == NULL) {
#line 1118 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (_tmp3_);
#line 6103 "SearchFilter.c"
	}
#line 1118 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	searchbar_toggle = _tmp4_;
#line 1119 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = searchbar_toggle;
#line 1119 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp5_ != NULL) {
#line 6111 "SearchFilter.c"
		GtkToggleAction* _tmp6_ = NULL;
#line 1120 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6_ = searchbar_toggle;
#line 1120 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		gtk_toggle_action_set_active (_tmp6_, TRUE);
#line 6117 "SearchFilter.c"
	}
#line 1122 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_update (self);
#line 1112 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (searchbar_toggle);
#line 1112 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (aw);
#line 6125 "SearchFilter.c"
}


static void search_filter_toolbar_on_criteria_changed (SearchFilterToolbar* self) {
#line 1128 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1129 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_update (self);
#line 6134 "SearchFilter.c"
}


static gpointer _view_filter_ref0 (gpointer self) {
#line 1136 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self ? view_filter_ref (self) : NULL;
#line 6141 "SearchFilter.c"
}


void search_filter_toolbar_set_view_filter (SearchFilterToolbar* self, SearchViewFilter* search_filter) {
	SearchViewFilter* _tmp0_ = NULL;
	SearchViewFilter* _tmp1_ = NULL;
	SearchViewFilter* _tmp2_ = NULL;
	SearchViewFilter* _tmp3_ = NULL;
	SearchFilterActions* _tmp4_ = NULL;
	SearchViewFilter* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	SearchFilterToolbarRatingFilterButton* _tmp7_ = NULL;
	SearchViewFilter* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
#line 1132 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1132 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_VIEW_FILTER (search_filter));
#line 1133 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = search_filter;
#line 1133 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = self->priv->search_filter;
#line 1133 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp0_ == _tmp1_) {
#line 1134 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		return;
#line 6168 "SearchFilter.c"
	}
#line 1136 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = search_filter;
#line 1136 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = _view_filter_ref0 (_tmp2_);
#line 1136 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_view_filter_unref0 (self->priv->search_filter);
#line 1136 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter = _tmp3_;
#line 1139 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = self->priv->actions;
#line 1139 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = search_filter;
#line 1139 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = search_view_filter_get_criteria (_tmp5_);
#line 1139 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_actions_set_sensitive_for_search_criteria (_tmp4_, (SearchFilterCriteria) _tmp6_);
#line 1140 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = self->priv->rating_button;
#line 1140 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = search_filter;
#line 1140 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = search_view_filter_get_criteria (_tmp8_);
#line 1140 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), (SEARCH_FILTER_CRITERIA_RATING & _tmp9_) != 0);
#line 1142 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_update (self);
#line 6196 "SearchFilter.c"
}


void search_filter_toolbar_unset_view_filter (SearchFilterToolbar* self) {
	DisabledViewFilter* _tmp0_ = NULL;
	DisabledViewFilter* _tmp1_ = NULL;
#line 1145 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1146 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = disabled_view_filter_new ();
#line 1146 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _tmp0_;
#line 1146 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_set_view_filter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SEARCH_VIEW_FILTER, SearchViewFilter));
#line 1146 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_view_filter_unref0 (_tmp1_);
#line 6213 "SearchFilter.c"
}


void search_filter_toolbar_update (SearchFilterToolbar* self) {
	SearchViewFilter* _tmp0_ = NULL;
	SearchViewFilter* _tmp3_ = NULL;
	SearchViewFilter* _tmp4_ = NULL;
	SearchFilterActions* _tmp5_ = NULL;
	TextAction* _tmp6_ = NULL;
	TextAction* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	SearchViewFilter* _tmp10_ = NULL;
	SearchFilterActions* _tmp11_ = NULL;
	GtkToggleAction* _tmp12_ = NULL;
	GtkToggleAction* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	SearchViewFilter* _tmp16_ = NULL;
	SearchFilterActions* _tmp17_ = NULL;
	GtkToggleAction* _tmp18_ = NULL;
	GtkToggleAction* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	SearchViewFilter* _tmp22_ = NULL;
	SearchFilterActions* _tmp23_ = NULL;
	GtkToggleAction* _tmp24_ = NULL;
	GtkToggleAction* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	SearchViewFilter* _tmp28_ = NULL;
	SearchFilterActions* _tmp29_ = NULL;
	GtkToggleAction* _tmp30_ = NULL;
	GtkToggleAction* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	RatingFilter filter = 0;
	SearchFilterActions* _tmp34_ = NULL;
	GtkRadioAction* _tmp35_ = NULL;
	GtkRadioAction* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	SearchViewFilter* _tmp39_ = NULL;
	RatingFilter _tmp40_ = 0;
	SearchFilterToolbarRatingFilterButton* _tmp41_ = NULL;
	RatingFilter _tmp42_ = 0;
	SearchFilterCriteria criteria = 0;
	SearchFilterActions* _tmp43_ = NULL;
	SearchFilterCriteria _tmp44_ = 0;
	SearchFilterToolbarSearchBox* _tmp45_ = NULL;
	SearchFilterCriteria _tmp46_ = 0;
	SearchFilterToolbarRatingFilterButton* _tmp47_ = NULL;
	SearchFilterCriteria _tmp48_ = 0;
	SearchFilterToolbarToggleActionToolButton* _tmp49_ = NULL;
	SearchFilterCriteria _tmp50_ = 0;
	SearchFilterToolbarLabelToolItem* _tmp51_ = NULL;
	SearchFilterCriteria _tmp52_ = 0;
	SearchFilterToolbarToggleActionToolButton* _tmp53_ = NULL;
	SearchFilterCriteria _tmp54_ = 0;
	SearchFilterToolbarToggleActionToolButton* _tmp55_ = NULL;
	SearchFilterCriteria _tmp56_ = 0;
	SearchFilterToolbarToggleActionToolButton* _tmp57_ = NULL;
	SearchFilterCriteria _tmp58_ = 0;
	gboolean _tmp59_ = FALSE;
	SearchFilterToolbarLabelToolItem* _tmp60_ = NULL;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	GtkSeparatorToolItem* _tmp66_ = NULL;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	SearchFilterToolbarLabelToolItem* _tmp69_ = NULL;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	GtkSeparatorToolItem* _tmp82_ = NULL;
	SearchViewFilter* _tmp83_ = NULL;
#line 1150 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1151 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->search_filter;
#line 1151 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (NULL == _tmp0_) {
#line 6295 "SearchFilter.c"
		LibraryWindow* _tmp1_ = NULL;
		LibraryWindow* _tmp2_ = NULL;
#line 1153 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp1_ = library_window_get_app ();
#line 1153 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = _tmp1_;
#line 1153 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		library_window_show_search_bar (_tmp2_, TRUE);
#line 1153 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (_tmp2_);
#line 6306 "SearchFilter.c"
	}
#line 1156 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = self->priv->search_filter;
#line 1156 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_assert (NULL != _tmp3_, "null != search_filter");
#line 1158 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = self->priv->search_filter;
#line 1158 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = self->priv->actions;
#line 1158 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = search_filter_actions_get_text (_tmp5_);
#line 1158 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = _tmp6_;
#line 1158 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = text_action_get_value (_tmp7_);
#line 1158 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = _tmp8_;
#line 1158 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_view_filter_set_search_filter (_tmp4_, _tmp9_);
#line 1159 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = self->priv->search_filter;
#line 1159 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = self->priv->actions;
#line 1159 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = search_filter_actions_get_flagged (_tmp11_);
#line 1159 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp13_ = _tmp12_;
#line 1159 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp14_ = gtk_toggle_action_get_active (_tmp13_);
#line 1159 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp15_ = _tmp14_;
#line 1159 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_view_filter_set_flagged (_tmp10_, _tmp15_);
#line 1160 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp16_ = self->priv->search_filter;
#line 1160 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_ = self->priv->actions;
#line 1160 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp18_ = search_filter_actions_get_videos (_tmp17_);
#line 1160 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp19_ = _tmp18_;
#line 1160 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp20_ = gtk_toggle_action_get_active (_tmp19_);
#line 1160 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp21_ = _tmp20_;
#line 1160 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_view_filter_set_show_media_video (_tmp16_, _tmp21_);
#line 1161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_ = self->priv->search_filter;
#line 1161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp23_ = self->priv->actions;
#line 1161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp24_ = search_filter_actions_get_photos (_tmp23_);
#line 1161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp25_ = _tmp24_;
#line 1161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp26_ = gtk_toggle_action_get_active (_tmp25_);
#line 1161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp27_ = _tmp26_;
#line 1161 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_view_filter_set_show_media_photos (_tmp22_, _tmp27_);
#line 1162 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp28_ = self->priv->search_filter;
#line 1162 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp29_ = self->priv->actions;
#line 1162 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp30_ = search_filter_actions_get_raw (_tmp29_);
#line 1162 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp31_ = _tmp30_;
#line 1162 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp32_ = gtk_toggle_action_get_active (_tmp31_);
#line 1162 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp33_ = _tmp32_;
#line 1162 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_view_filter_set_show_media_raw (_tmp28_, _tmp33_);
#line 1164 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp34_ = self->priv->actions;
#line 1164 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp35_ = search_filter_actions_get_rating (_tmp34_);
#line 1164 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp36_ = _tmp35_;
#line 1164 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp37_ = gtk_radio_action_get_current_value (_tmp36_);
#line 1164 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp38_ = _tmp37_;
#line 1164 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	filter = (RatingFilter) _tmp38_;
#line 1165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp39_ = self->priv->search_filter;
#line 1165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp40_ = filter;
#line 1165 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_view_filter_set_rating_filter (_tmp39_, _tmp40_);
#line 1166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp41_ = self->priv->rating_button;
#line 1166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp42_ = filter;
#line 1166 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_rating_filter_button_set_filter_icon (_tmp41_, _tmp42_);
#line 1170 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp43_ = self->priv->actions;
#line 1170 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp44_ = search_filter_actions_get_criteria (_tmp43_);
#line 1170 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	criteria = _tmp44_;
#line 1172 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp45_ = self->priv->search_box;
#line 1172 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp46_ = criteria;
#line 1172 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget), (_tmp46_ & SEARCH_FILTER_CRITERIA_TEXT) != 0);
#line 1174 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp47_ = self->priv->rating_button;
#line 1174 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp48_ = criteria;
#line 1174 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_widget_get_type (), GtkWidget), (_tmp48_ & SEARCH_FILTER_CRITERIA_RATING) != 0);
#line 1176 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp49_ = self->priv->toolbtn_flag;
#line 1176 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp50_ = criteria;
#line 1176 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_widget_get_type (), GtkWidget), (_tmp50_ & SEARCH_FILTER_CRITERIA_FLAG) != 0);
#line 1178 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp51_ = self->priv->label_type;
#line 1178 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp52_ = criteria;
#line 1178 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_widget_get_type (), GtkWidget), (_tmp52_ & SEARCH_FILTER_CRITERIA_MEDIA) != 0);
#line 1179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp53_ = self->priv->toolbtn_photos;
#line 1179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp54_ = criteria;
#line 1179 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget), (_tmp54_ & SEARCH_FILTER_CRITERIA_MEDIA) != 0);
#line 1180 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp55_ = self->priv->toolbtn_videos;
#line 1180 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp56_ = criteria;
#line 1180 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_widget_get_type (), GtkWidget), (_tmp56_ & SEARCH_FILTER_CRITERIA_MEDIA) != 0);
#line 1181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp57_ = self->priv->toolbtn_raw;
#line 1181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp58_ = criteria;
#line 1181 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_widget_get_type (), GtkWidget), (_tmp58_ & SEARCH_FILTER_CRITERIA_MEDIA) != 0);
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp60_ = self->priv->label_type;
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp61_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget));
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp62_ = _tmp61_;
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp62_) {
#line 6462 "SearchFilter.c"
		SearchFilterToolbarToggleActionToolButton* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
		gboolean _tmp65_ = FALSE;
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp63_ = self->priv->toolbtn_flag;
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp64_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget));
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp65_ = _tmp64_;
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp59_ = _tmp65_;
#line 6474 "SearchFilter.c"
	} else {
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp59_ = FALSE;
#line 6478 "SearchFilter.c"
	}
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp66_ = self->priv->sepr_mediatype_flagged;
#line 1185 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, gtk_widget_get_type (), GtkWidget), _tmp59_);
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp69_ = self->priv->label_type;
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp70_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_widget_get_type (), GtkWidget));
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp71_ = _tmp70_;
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp71_) {
#line 6492 "SearchFilter.c"
		SearchFilterToolbarRatingFilterButton* _tmp72_ = NULL;
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_ = FALSE;
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp72_ = self->priv->rating_button;
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp73_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_widget_get_type (), GtkWidget));
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp74_ = _tmp73_;
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp68_ = _tmp74_;
#line 6504 "SearchFilter.c"
	} else {
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp68_ = FALSE;
#line 6508 "SearchFilter.c"
	}
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp68_) {
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp67_ = TRUE;
#line 6514 "SearchFilter.c"
	} else {
		gboolean _tmp75_ = FALSE;
		SearchFilterToolbarToggleActionToolButton* _tmp76_ = NULL;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp76_ = self->priv->toolbtn_flag;
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp77_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, gtk_widget_get_type (), GtkWidget));
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp78_ = _tmp77_;
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		if (_tmp78_) {
#line 6528 "SearchFilter.c"
			SearchFilterToolbarRatingFilterButton* _tmp79_ = NULL;
			gboolean _tmp80_ = FALSE;
			gboolean _tmp81_ = FALSE;
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp79_ = self->priv->rating_button;
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp80_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, gtk_widget_get_type (), GtkWidget));
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp81_ = _tmp80_;
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp75_ = _tmp81_;
#line 6540 "SearchFilter.c"
		} else {
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp75_ = FALSE;
#line 6544 "SearchFilter.c"
		}
#line 1188 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp67_ = _tmp75_;
#line 6548 "SearchFilter.c"
	}
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp82_ = self->priv->sepr_flagged_rating;
#line 1187 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, gtk_widget_get_type (), GtkWidget), _tmp67_);
#line 1191 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp83_ = self->priv->search_filter;
#line 1191 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, TYPE_VIEW_FILTER, ViewFilter), "refresh");
#line 6558 "SearchFilter.c"
}


static void search_filter_toolbar_position_filter_popup (SearchFilterToolbar* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	GtkMenu* _tmp0_ = NULL;
	gint rx = 0;
	gint ry = 0;
	SearchFilterToolbarRatingFilterButton* _tmp1_ = NULL;
	GdkWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkAllocation rating_button_allocation = {0};
	SearchFilterToolbarRatingFilterButton* _tmp5_ = NULL;
	GtkAllocation _tmp6_ = {0};
	GtkAllocation menubar_allocation = {0};
	AppWindow* _tmp7_ = NULL;
	AppWindow* _tmp8_ = NULL;
	Page* _tmp9_ = NULL;
	Page* _tmp10_ = NULL;
	GtkMenuBar* _tmp11_ = NULL;
	GtkMenuBar* _tmp12_ = NULL;
	GtkAllocation _tmp13_ = {0};
	gint sidebar_w = 0;
	ConfigFacade* _tmp14_ = NULL;
	ConfigFacade* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	GtkAllocation _tmp18_ = {0};
	gint _tmp19_ = 0;
	GtkAllocation _tmp20_ = {0};
	gint _tmp21_ = 0;
	GtkAllocation _tmp22_ = {0};
	gint _tmp23_ = 0;
	GtkAllocation _tmp24_ = {0};
	gint _tmp25_ = 0;
#line 1194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (GTK_IS_MENU (menu));
#line 1195 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = menu;
#line 1195 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_realize (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
#line 1197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = self->priv->rating_button;
#line 1197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
#line 1197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gdk_window_get_root_origin (_tmp2_, &_tmp3_, &_tmp4_);
#line 1197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	rx = _tmp3_;
#line 1197 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	ry = _tmp4_;
#line 1200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = self->priv->rating_button;
#line 1200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), &_tmp6_);
#line 1200 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	rating_button_allocation = _tmp6_;
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = app_window_get_instance ();
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = _tmp7_;
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PAGE_WINDOW, PageWindow));
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = _tmp9_;
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = page_get_menubar (_tmp10_);
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = _tmp11_;
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget), &_tmp13_);
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	menubar_allocation = _tmp13_;
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp12_);
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp10_);
#line 1203 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp8_);
#line 1205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp14_ = config_facade_get_instance ();
#line 1205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp15_ = _tmp14_;
#line 1205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp16_ = configuration_facade_get_sidebar_position (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 1205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_ = _tmp16_;
#line 1205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp15_);
#line 1205 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	sidebar_w = _tmp17_;
#line 1207 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp18_ = rating_button_allocation;
#line 1207 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp19_ = _tmp18_.x;
#line 1207 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_x = (rx + _tmp19_) + sidebar_w;
#line 1208 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp20_ = rating_button_allocation;
#line 1208 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp21_ = _tmp20_.y;
#line 1208 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp22_ = rating_button_allocation;
#line 1208 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp23_ = _tmp22_.height;
#line 1208 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp24_ = menubar_allocation;
#line 1208 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp25_ = _tmp24_.height;
#line 1208 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_y = ((ry + _tmp21_) + _tmp23_) + _tmp25_;
#line 1211 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_vala_push_in = FALSE;
#line 1194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (x) {
#line 1194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*x = _vala_x;
#line 6681 "SearchFilter.c"
	}
#line 1194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (y) {
#line 1194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*y = _vala_y;
#line 6687 "SearchFilter.c"
	}
#line 1194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (push_in) {
#line 1194 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		*push_in = _vala_push_in;
#line 6693 "SearchFilter.c"
	}
}


static void _search_filter_toolbar_position_filter_popup_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
#line 1215 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_position_filter_popup ((SearchFilterToolbar*) self, menu, x, y, push_in);
#line 1215 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_unref (self);
#line 6703 "SearchFilter.c"
}


static void search_filter_toolbar_on_filter_button_clicked (SearchFilterToolbar* self) {
	SearchFilterToolbarRatingFilterButton* _tmp0_ = NULL;
	GtkMenu* _tmp1_ = NULL;
	guint32 _tmp2_ = 0U;
#line 1214 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1215 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->rating_button;
#line 1215 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _tmp0_->filter_popup;
#line 1215 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = gtk_get_current_event_time ();
#line 1215 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_menu_popup (_tmp1_, NULL, NULL, _search_filter_toolbar_position_filter_popup_gtk_menu_position_func, g_object_ref (self), (guint) 0, _tmp2_);
#line 6721 "SearchFilter.c"
}


void search_filter_toolbar_take_focus (SearchFilterToolbar* self) {
	SearchFilterToolbarSearchBox* _tmp0_ = NULL;
#line 1219 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (IS_SEARCH_FILTER_TOOLBAR (self));
#line 1220 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->search_box;
#line 1220 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_get_focus (_tmp0_);
#line 6733 "SearchFilter.c"
}


static SearchFilterToolbarLabelToolItem* search_filter_toolbar_label_tool_item_construct (GType object_type, const gchar* s, gint left_padding, gint right_padding) {
	SearchFilterToolbarLabelToolItem * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
#line 664 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 664 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (SearchFilterToolbarLabelToolItem*) g_object_new (object_type, NULL);
#line 665 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = s;
#line 665 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
#line 665 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp1_);
#line 665 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->label);
#line 665 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->label = _tmp1_;
#line 666 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = left_padding;
#line 666 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp3_ != 0) {
#line 666 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = TRUE;
#line 6763 "SearchFilter.c"
	} else {
		gint _tmp4_ = 0;
#line 666 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp4_ = right_padding;
#line 666 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = _tmp4_ != 0;
#line 6770 "SearchFilter.c"
	}
#line 666 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp2_) {
#line 6774 "SearchFilter.c"
		GtkAlignment* alignment = NULL;
		GtkAlignment* _tmp5_ = NULL;
		GtkAlignment* _tmp6_ = NULL;
		GtkLabel* _tmp7_ = NULL;
		GtkAlignment* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		GtkAlignment* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		GtkAlignment* _tmp12_ = NULL;
#line 667 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp5_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, 0.5f, (gfloat) 0, (gfloat) 0);
#line 667 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_object_ref_sink (_tmp5_);
#line 667 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		alignment = _tmp5_;
#line 668 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6_ = alignment;
#line 668 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp7_ = self->priv->label;
#line 668 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
#line 669 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp8_ = alignment;
#line 669 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp9_ = left_padding;
#line 669 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_object_set (_tmp8_, "left-padding", (guint) _tmp9_, NULL);
#line 670 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp10_ = alignment;
#line 670 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp11_ = right_padding;
#line 670 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_object_set (_tmp10_, "right-padding", (guint) _tmp11_, NULL);
#line 671 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp12_ = alignment;
#line 671 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
#line 666 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (alignment);
#line 6814 "SearchFilter.c"
	} else {
		GtkLabel* _tmp13_ = NULL;
#line 673 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp13_ = self->priv->label;
#line 673 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
#line 6821 "SearchFilter.c"
	}
#line 664 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 6825 "SearchFilter.c"
}


static SearchFilterToolbarLabelToolItem* search_filter_toolbar_label_tool_item_new (const gchar* s, gint left_padding, gint right_padding) {
#line 664 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return search_filter_toolbar_label_tool_item_construct (SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM, s, left_padding, right_padding);
#line 6832 "SearchFilter.c"
}


static void search_filter_toolbar_label_tool_item_class_init (SearchFilterToolbarLabelToolItemClass * klass) {
#line 661 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_label_tool_item_parent_class = g_type_class_peek_parent (klass);
#line 661 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_type_class_add_private (klass, sizeof (SearchFilterToolbarLabelToolItemPrivate));
#line 661 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (klass)->finalize = search_filter_toolbar_label_tool_item_finalize;
#line 6843 "SearchFilter.c"
}


static void search_filter_toolbar_label_tool_item_instance_init (SearchFilterToolbarLabelToolItem * self) {
#line 661 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv = SEARCH_FILTER_TOOLBAR_LABEL_TOOL_ITEM_GET_PRIVATE (self);
#line 6850 "SearchFilter.c"
}


static void search_filter_toolbar_label_tool_item_finalize (GObject* obj) {
	SearchFilterToolbarLabelToolItem * self;
#line 661 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEARCH_FILTER_TOOLBAR_TYPE_LABEL_TOOL_ITEM, SearchFilterToolbarLabelToolItem);
#line 662 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->label);
#line 661 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (search_filter_toolbar_label_tool_item_parent_class)->finalize (obj);
#line 6862 "SearchFilter.c"
}


static GType search_filter_toolbar_label_tool_item_get_type (void) {
	static volatile gsize search_filter_toolbar_label_tool_item_type_id__volatile = 0;
	if (g_once_init_enter (&search_filter_toolbar_label_tool_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchFilterToolbarLabelToolItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_filter_toolbar_label_tool_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchFilterToolbarLabelToolItem), 0, (GInstanceInitFunc) search_filter_toolbar_label_tool_item_instance_init, NULL };
		GType search_filter_toolbar_label_tool_item_type_id;
		search_filter_toolbar_label_tool_item_type_id = g_type_register_static (gtk_tool_item_get_type (), "SearchFilterToolbarLabelToolItem", &g_define_type_info, 0);
		g_once_init_leave (&search_filter_toolbar_label_tool_item_type_id__volatile, search_filter_toolbar_label_tool_item_type_id);
	}
	return search_filter_toolbar_label_tool_item_type_id__volatile;
}


static void _search_filter_toolbar_toggle_action_tool_button_on_button_activate_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 696 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_toggle_action_tool_button_on_button_activate ((SearchFilterToolbarToggleActionToolButton*) self);
#line 6881 "SearchFilter.c"
}


static SearchFilterToolbarToggleActionToolButton* search_filter_toolbar_toggle_action_tool_button_construct (GType object_type, GtkToggleAction* action) {
	SearchFilterToolbarToggleActionToolButton * self = NULL;
	GtkToggleAction* _tmp0_ = NULL;
	GtkToggleAction* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	GtkToggleButton* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_ = NULL;
	GtkToggleAction* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkToggleButton* _tmp8_ = NULL;
	GtkToggleButton* _tmp9_ = NULL;
	GtkToggleButton* _tmp10_ = NULL;
	GtkToggleButton* _tmp11_ = NULL;
	GtkToggleButton* _tmp12_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (GTK_IS_TOGGLE_ACTION (action), NULL);
#line 682 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (SearchFilterToolbarToggleActionToolButton*) g_object_new (object_type, NULL);
#line 683 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = action;
#line 683 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 683 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->action);
#line 683 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->action = _tmp1_;
#line 684 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = (GtkToggleButton*) gtk_toggle_button_new ();
#line 684 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp2_);
#line 684 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->button);
#line 684 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->button = _tmp2_;
#line 685 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = self->priv->button;
#line 685 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_can_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 686 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = self->priv->button;
#line 686 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = action;
#line 686 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = gtk_toggle_action_get_active (_tmp5_);
#line 686 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = _tmp6_;
#line 686 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_toggle_button_set_active (_tmp4_, _tmp7_);
#line 687 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = self->priv->button;
#line 687 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _search_filter_toolbar_toggle_action_tool_button_on_button_activate_gtk_button_clicked, self, 0);
#line 688 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = self->priv->button;
#line 688 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_has_tooltip (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), TRUE);
#line 689 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = self->priv->button;
#line 689 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_relief (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_button_get_type (), GtkButton), GTK_RELIEF_NONE);
#line 690 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = self->priv->button;
#line 690 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), 2);
#line 692 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = self->priv->button;
#line 692 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
#line 682 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 6956 "SearchFilter.c"
}


static SearchFilterToolbarToggleActionToolButton* search_filter_toolbar_toggle_action_tool_button_new (GtkToggleAction* action) {
#line 682 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return search_filter_toolbar_toggle_action_tool_button_construct (SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON, action);
#line 6963 "SearchFilter.c"
}


static void search_filter_toolbar_toggle_action_tool_button_on_button_activate (SearchFilterToolbarToggleActionToolButton* self) {
	GtkToggleAction* _tmp0_ = NULL;
#line 699 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_TOGGLE_ACTION_TOOL_BUTTON (self));
#line 700 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->action;
#line 700 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_action_activate (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_action_get_type (), GtkAction));
#line 6975 "SearchFilter.c"
}


static void search_filter_toolbar_toggle_action_tool_button_set_icon_name (SearchFilterToolbarToggleActionToolButton* self, const gchar* icon_name) {
	GtkImage* image = NULL;
	GtkToggleButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkImage* _tmp7_ = NULL;
	GtkToggleButton* _tmp8_ = NULL;
	GtkImage* _tmp9_ = NULL;
#line 703 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_TOGGLE_ACTION_TOOL_BUTTON (self));
#line 703 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (icon_name != NULL);
#line 704 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	image = NULL;
#line 705 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->button;
#line 705 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_always_show_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_button_get_type (), GtkButton), TRUE);
#line 706 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = icon_name;
#line 706 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = string_contains (_tmp1_, "disabled");
#line 706 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp2_) {
#line 7003 "SearchFilter.c"
		const gchar* _tmp3_ = NULL;
		GtkImage* _tmp4_ = NULL;
#line 707 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp3_ = icon_name;
#line 707 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp4_ = (GtkImage*) gtk_image_new_from_stock (_tmp3_, GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 707 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_object_ref_sink (_tmp4_);
#line 707 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (image);
#line 707 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		image = _tmp4_;
#line 7016 "SearchFilter.c"
	} else {
		const gchar* _tmp5_ = NULL;
		GtkImage* _tmp6_ = NULL;
#line 709 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp5_ = icon_name;
#line 709 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp6_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp5_, GTK_ICON_SIZE_SMALL_TOOLBAR);
#line 709 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		g_object_ref_sink (_tmp6_);
#line 709 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_g_object_unref0 (image);
#line 709 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		image = _tmp6_;
#line 7030 "SearchFilter.c"
	}
#line 710 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = image;
#line 710 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), 6);
#line 711 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = self->priv->button;
#line 711 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = image;
#line 711 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_button_get_type (), GtkButton), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
#line 703 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (image);
#line 7044 "SearchFilter.c"
}


static void search_filter_toolbar_toggle_action_tool_button_set_label (SearchFilterToolbarToggleActionToolButton* self, const gchar* label) {
	GtkToggleButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 714 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_TOGGLE_ACTION_TOOL_BUTTON (self));
#line 714 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (label != NULL);
#line 715 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->button;
#line 715 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = label;
#line 715 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_button_get_type (), GtkButton), _tmp1_);
#line 7061 "SearchFilter.c"
}


static void search_filter_toolbar_toggle_action_tool_button_class_init (SearchFilterToolbarToggleActionToolButtonClass * klass) {
#line 678 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_toggle_action_tool_button_parent_class = g_type_class_peek_parent (klass);
#line 678 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_type_class_add_private (klass, sizeof (SearchFilterToolbarToggleActionToolButtonPrivate));
#line 678 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (klass)->finalize = search_filter_toolbar_toggle_action_tool_button_finalize;
#line 7072 "SearchFilter.c"
}


static void search_filter_toolbar_toggle_action_tool_button_instance_init (SearchFilterToolbarToggleActionToolButton * self) {
#line 678 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv = SEARCH_FILTER_TOOLBAR_TOGGLE_ACTION_TOOL_BUTTON_GET_PRIVATE (self);
#line 7079 "SearchFilter.c"
}


static void search_filter_toolbar_toggle_action_tool_button_finalize (GObject* obj) {
	SearchFilterToolbarToggleActionToolButton * self;
	GtkToggleButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 678 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEARCH_FILTER_TOOLBAR_TYPE_TOGGLE_ACTION_TOOL_BUTTON, SearchFilterToolbarToggleActionToolButton);
#line 696 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->button;
#line 696 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp1_, NULL, FALSE);
#line 696 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_button_get_type (), GtkButton), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _search_filter_toolbar_toggle_action_tool_button_on_button_activate_gtk_button_clicked, self);
#line 679 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->button);
#line 680 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->action);
#line 678 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (search_filter_toolbar_toggle_action_tool_button_parent_class)->finalize (obj);
#line 7101 "SearchFilter.c"
}


static GType search_filter_toolbar_toggle_action_tool_button_get_type (void) {
	static volatile gsize search_filter_toolbar_toggle_action_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&search_filter_toolbar_toggle_action_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchFilterToolbarToggleActionToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_filter_toolbar_toggle_action_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchFilterToolbarToggleActionToolButton), 0, (GInstanceInitFunc) search_filter_toolbar_toggle_action_tool_button_instance_init, NULL };
		GType search_filter_toolbar_toggle_action_tool_button_type_id;
		search_filter_toolbar_toggle_action_tool_button_type_id = g_type_register_static (gtk_tool_item_get_type (), "SearchFilterToolbarToggleActionToolButton", &g_define_type_info, 0);
		g_once_init_leave (&search_filter_toolbar_toggle_action_tool_button_type_id__volatile, search_filter_toolbar_toggle_action_tool_button_type_id);
	}
	return search_filter_toolbar_toggle_action_tool_button_type_id__volatile;
}


static void _search_filter_toolbar_search_box_on_action_text_changed_text_action_text_changed (TextAction* _sender, const gchar* text, gpointer self) {
#line 750 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_on_action_text_changed ((SearchFilterToolbarSearchBox*) self, text);
#line 7120 "SearchFilter.c"
}


static void _search_filter_toolbar_search_box_on_sensitivity_changed_text_action_sensitivity_changed (TextAction* _sender, gboolean sensitive, gpointer self) {
#line 751 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_on_sensitivity_changed ((SearchFilterToolbarSearchBox*) self, sensitive);
#line 7127 "SearchFilter.c"
}


static void _search_filter_toolbar_search_box_on_visibility_changed_text_action_visibility_changed (TextAction* _sender, gboolean visible, gpointer self) {
#line 752 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_on_visibility_changed ((SearchFilterToolbarSearchBox*) self, visible);
#line 7134 "SearchFilter.c"
}


static void _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_deleted_text (GtkEntryBuffer* _sender, guint position, guint n_chars, gpointer self) {
#line 754 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_on_entry_changed ((SearchFilterToolbarSearchBox*) self);
#line 7141 "SearchFilter.c"
}


static void _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_inserted_text (GtkEntryBuffer* _sender, guint position, const gchar* chars, guint n_chars, gpointer self) {
#line 755 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_on_entry_changed ((SearchFilterToolbarSearchBox*) self);
#line 7148 "SearchFilter.c"
}


static gpointer _text_action_ref0 (gpointer self) {
#line 732 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self ? text_action_ref (self) : NULL;
#line 7155 "SearchFilter.c"
}


static gboolean _search_filter_toolbar_search_box_on_escape_key_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = search_filter_toolbar_search_box_on_escape_key ((SearchFilterToolbarSearchBox*) self, event);
#line 736 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 7164 "SearchFilter.c"
}


SearchFilterToolbarSearchBox* search_filter_toolbar_search_box_construct (GType object_type, TextAction* action) {
	SearchFilterToolbarSearchBox * self = NULL;
	TextAction* _tmp0_ = NULL;
	TextAction* _tmp1_ = NULL;
	GtkSearchEntry* _tmp2_ = NULL;
	GtkSearchEntry* _tmp3_ = NULL;
	GtkSearchEntry* _tmp4_ = NULL;
	GtkSearchEntry* _tmp5_ = NULL;
	TextAction* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	TextAction* _tmp9_ = NULL;
	TextAction* _tmp10_ = NULL;
	TextAction* _tmp11_ = NULL;
	GtkSearchEntry* _tmp12_ = NULL;
	GtkEntryBuffer* _tmp13_ = NULL;
	GtkEntryBuffer* _tmp14_ = NULL;
	GtkSearchEntry* _tmp15_ = NULL;
	GtkEntryBuffer* _tmp16_ = NULL;
	GtkEntryBuffer* _tmp17_ = NULL;
#line 731 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (IS_TEXT_ACTION (action), NULL);
#line 731 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (SearchFilterToolbarSearchBox*) g_object_new (object_type, NULL);
#line 732 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = action;
#line 732 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _text_action_ref0 (_tmp0_);
#line 732 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_text_action_unref0 (self->priv->action);
#line 732 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->action = _tmp1_;
#line 733 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = (GtkSearchEntry*) gtk_search_entry_new ();
#line 733 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp2_);
#line 733 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 733 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_entry = _tmp2_;
#line 735 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = self->priv->search_entry;
#line 735 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_entry_set_width_chars (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_entry_get_type (), GtkEntry), 23);
#line 736 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = self->priv->search_entry;
#line 736 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _search_filter_toolbar_search_box_on_escape_key_gtk_widget_key_press_event, self, 0);
#line 737 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = self->priv->search_entry;
#line 737 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
#line 739 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = action;
#line 739 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = text_action_get_value (_tmp6_);
#line 739 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = _tmp7_;
#line 739 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_set_nullable_text (self, _tmp8_);
#line 741 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = action;
#line 741 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp9_, "text-changed", (GCallback) _search_filter_toolbar_search_box_on_action_text_changed_text_action_text_changed, self, 0);
#line 742 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = action;
#line 742 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp10_, "sensitivity-changed", (GCallback) _search_filter_toolbar_search_box_on_sensitivity_changed_text_action_sensitivity_changed, self, 0);
#line 743 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = action;
#line 743 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp11_, "visibility-changed", (GCallback) _search_filter_toolbar_search_box_on_visibility_changed_text_action_visibility_changed, self, 0);
#line 745 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = self->priv->search_entry;
#line 745 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp13_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_entry_get_type (), GtkEntry));
#line 745 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp14_ = _tmp13_;
#line 745 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp14_, "deleted-text", (GCallback) _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_deleted_text, self, 0);
#line 746 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp15_ = self->priv->search_entry;
#line 746 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp16_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_entry_get_type (), GtkEntry));
#line 746 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp17_ = _tmp16_;
#line 746 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp17_, "inserted-text", (GCallback) _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_inserted_text, self, 0);
#line 731 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 7258 "SearchFilter.c"
}


SearchFilterToolbarSearchBox* search_filter_toolbar_search_box_new (TextAction* action) {
#line 731 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return search_filter_toolbar_search_box_construct (SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX, action);
#line 7265 "SearchFilter.c"
}


void search_filter_toolbar_search_box_get_focus (SearchFilterToolbarSearchBox* self) {
	GtkSearchEntry* _tmp0_ = NULL;
#line 758 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX (self));
#line 759 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->search_entry;
#line 759 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), "has-focus", TRUE, NULL);
#line 7277 "SearchFilter.c"
}


static gboolean search_filter_toolbar_search_box_on_escape_key (SearchFilterToolbarSearchBox* self, GdkEventKey* e) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
#line 764 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX (self), FALSE);
#line 764 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (e != NULL, FALSE);
#line 765 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = e;
#line 765 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = _tmp0_->keyval;
#line 765 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = gdk_keyval_name (_tmp1_);
#line 765 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (g_strcmp0 (_tmp2_, "Escape") == 0) {
#line 7298 "SearchFilter.c"
		TextAction* _tmp3_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp3_ = self->priv->action;
#line 766 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		text_action_clear (_tmp3_);
#line 7304 "SearchFilter.c"
	}
#line 770 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = FALSE;
#line 770 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 7310 "SearchFilter.c"
}


static void search_filter_toolbar_search_box_on_action_text_changed (SearchFilterToolbarSearchBox* self, const gchar* text) {
	GtkSearchEntry* _tmp0_ = NULL;
	GtkEntryBuffer* _tmp1_ = NULL;
	GtkEntryBuffer* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GtkSearchEntry* _tmp4_ = NULL;
	GtkEntryBuffer* _tmp5_ = NULL;
	GtkEntryBuffer* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	const gchar* _tmp8_ = NULL;
	GtkSearchEntry* _tmp9_ = NULL;
	GtkEntryBuffer* _tmp10_ = NULL;
	GtkEntryBuffer* _tmp11_ = NULL;
	GtkSearchEntry* _tmp12_ = NULL;
	GtkEntryBuffer* _tmp13_ = NULL;
	GtkEntryBuffer* _tmp14_ = NULL;
#line 773 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX (self));
#line 774 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->search_entry;
#line 774 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
#line 774 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = _tmp1_;
#line 774 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("deleted-text", gtk_entry_buffer_get_type (), &_tmp3_, NULL, FALSE);
#line 774 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_deleted_text, self);
#line 775 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = self->priv->search_entry;
#line 775 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_entry_get_type (), GtkEntry));
#line 775 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = _tmp5_;
#line 775 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("inserted-text", gtk_entry_buffer_get_type (), &_tmp7_, NULL, FALSE);
#line 775 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_inserted_text, self);
#line 776 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = text;
#line 776 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_set_nullable_text (self, _tmp8_);
#line 777 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = self->priv->search_entry;
#line 777 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_entry_get_type (), GtkEntry));
#line 777 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = _tmp10_;
#line 777 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp11_, "deleted-text", (GCallback) _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_deleted_text, self, 0);
#line 778 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = self->priv->search_entry;
#line 778 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp13_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_entry_get_type (), GtkEntry));
#line 778 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp14_ = _tmp13_;
#line 778 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp14_, "inserted-text", (GCallback) _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_inserted_text, self, 0);
#line 7372 "SearchFilter.c"
}


static void search_filter_toolbar_search_box_on_entry_changed (SearchFilterToolbarSearchBox* self) {
	TextAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	TextAction* _tmp2_ = NULL;
	GtkSearchEntry* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	TextAction* _tmp5_ = NULL;
#line 781 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX (self));
#line 782 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->action;
#line 782 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("text-changed", TYPE_TEXT_ACTION, &_tmp1_, NULL, FALSE);
#line 782 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _search_filter_toolbar_search_box_on_action_text_changed_text_action_text_changed, self);
#line 783 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = self->priv->action;
#line 783 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = self->priv->search_entry;
#line 783 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_entry_get_type (), GtkEntry));
#line 783 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	text_action_set_text (_tmp2_, _tmp4_);
#line 784 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = self->priv->action;
#line 784 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp5_, "text-changed", (GCallback) _search_filter_toolbar_search_box_on_action_text_changed_text_action_text_changed, self, 0);
#line 7403 "SearchFilter.c"
}


static void search_filter_toolbar_search_box_on_sensitivity_changed (SearchFilterToolbarSearchBox* self, gboolean sensitive) {
	gboolean _tmp0_ = FALSE;
#line 787 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX (self));
#line 788 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = sensitive;
#line 788 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp0_);
#line 7415 "SearchFilter.c"
}


static void search_filter_toolbar_search_box_on_visibility_changed (SearchFilterToolbarSearchBox* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
#line 791 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX (self));
#line 792 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = visible;
#line 792 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp0_);
#line 7427 "SearchFilter.c"
}


static void search_filter_toolbar_search_box_set_nullable_text (SearchFilterToolbarSearchBox* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkSearchEntry* _tmp3_ = NULL;
#line 795 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_SEARCH_BOX (self));
#line 796 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = text;
#line 796 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	if (_tmp1_ != NULL) {
#line 7441 "SearchFilter.c"
		const gchar* _tmp2_ = NULL;
#line 796 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp2_ = text;
#line 796 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = _tmp2_;
#line 7447 "SearchFilter.c"
	} else {
#line 796 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		_tmp0_ = "";
#line 7451 "SearchFilter.c"
	}
#line 796 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = self->priv->search_entry;
#line 796 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_entry_get_type (), GtkEntry), _tmp0_);
#line 7457 "SearchFilter.c"
}


static void search_filter_toolbar_search_box_class_init (SearchFilterToolbarSearchBoxClass * klass) {
#line 727 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_search_box_parent_class = g_type_class_peek_parent (klass);
#line 727 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_type_class_add_private (klass, sizeof (SearchFilterToolbarSearchBoxPrivate));
#line 727 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (klass)->finalize = search_filter_toolbar_search_box_finalize;
#line 7468 "SearchFilter.c"
}


static void search_filter_toolbar_search_box_instance_init (SearchFilterToolbarSearchBox * self) {
#line 727 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv = SEARCH_FILTER_TOOLBAR_SEARCH_BOX_GET_PRIVATE (self);
#line 7475 "SearchFilter.c"
}


static void search_filter_toolbar_search_box_finalize (GObject* obj) {
	SearchFilterToolbarSearchBox * self;
	TextAction* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	TextAction* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	TextAction* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GtkSearchEntry* _tmp6_ = NULL;
	GtkEntryBuffer* _tmp7_ = NULL;
	GtkEntryBuffer* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	GtkSearchEntry* _tmp10_ = NULL;
	GtkEntryBuffer* _tmp11_ = NULL;
	GtkEntryBuffer* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
#line 727 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEARCH_FILTER_TOOLBAR_TYPE_SEARCH_BOX, SearchFilterToolbarSearchBox);
#line 750 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->action;
#line 750 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("text-changed", TYPE_TEXT_ACTION, &_tmp1_, NULL, FALSE);
#line 750 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _search_filter_toolbar_search_box_on_action_text_changed_text_action_text_changed, self);
#line 751 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = self->priv->action;
#line 751 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("sensitivity-changed", TYPE_TEXT_ACTION, &_tmp3_, NULL, FALSE);
#line 751 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _search_filter_toolbar_search_box_on_sensitivity_changed_text_action_sensitivity_changed, self);
#line 752 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = self->priv->action;
#line 752 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("visibility-changed", TYPE_TEXT_ACTION, &_tmp5_, NULL, FALSE);
#line 752 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _search_filter_toolbar_search_box_on_visibility_changed_text_action_visibility_changed, self);
#line 754 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = self->priv->search_entry;
#line 754 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_entry_get_type (), GtkEntry));
#line 754 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = _tmp7_;
#line 754 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("deleted-text", gtk_entry_buffer_get_type (), &_tmp9_, NULL, FALSE);
#line 754 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_deleted_text, self);
#line 755 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = self->priv->search_entry;
#line 755 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_entry_get_type (), GtkEntry));
#line 755 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = _tmp11_;
#line 755 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("inserted-text", gtk_entry_buffer_get_type (), &_tmp13_, NULL, FALSE);
#line 755 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _search_filter_toolbar_search_box_on_entry_changed_gtk_entry_buffer_inserted_text, self);
#line 728 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->search_entry);
#line 729 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_text_action_unref0 (self->priv->action);
#line 727 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (search_filter_toolbar_search_box_parent_class)->finalize (obj);
#line 7541 "SearchFilter.c"
}


GType search_filter_toolbar_search_box_get_type (void) {
	static volatile gsize search_filter_toolbar_search_box_type_id__volatile = 0;
	if (g_once_init_enter (&search_filter_toolbar_search_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchFilterToolbarSearchBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_filter_toolbar_search_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchFilterToolbarSearchBox), 0, (GInstanceInitFunc) search_filter_toolbar_search_box_instance_init, NULL };
		GType search_filter_toolbar_search_box_type_id;
		search_filter_toolbar_search_box_type_id = g_type_register_static (gtk_tool_item_get_type (), "SearchFilterToolbarSearchBox", &g_define_type_info, 0);
		g_once_init_leave (&search_filter_toolbar_search_box_type_id__volatile, search_filter_toolbar_search_box_type_id);
	}
	return search_filter_toolbar_search_box_type_id__volatile;
}


static void _search_filter_toolbar_rating_filter_button_on_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 822 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_rating_filter_button_on_clicked ((SearchFilterToolbarRatingFilterButton*) self);
#line 7560 "SearchFilter.c"
}


SearchFilterToolbarRatingFilterButton* search_filter_toolbar_rating_filter_button_construct (GType object_type) {
	SearchFilterToolbarRatingFilterButton * self = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkButton* _tmp8_ = NULL;
#line 807 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = (SearchFilterToolbarRatingFilterButton*) g_object_new (object_type, NULL);
#line 808 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = (GtkButton*) gtk_button_new ();
#line 808 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp0_);
#line 808 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->button);
#line 808 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->button = _tmp0_;
#line 809 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = self->button;
#line 809 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = search_filter_toolbar_rating_filter_button_get_filter_icon (self, RATING_FILTER_UNRATED_OR_HIGHER);
#line 809 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = _tmp2_;
#line 809 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_image (_tmp1_, _tmp3_);
#line 809 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp3_);
#line 810 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = self->button;
#line 810 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_can_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), FALSE);
#line 811 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = self->button;
#line 811 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_relief (_tmp5_, GTK_RELIEF_NONE);
#line 812 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = self->button;
#line 812 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), 2);
#line 814 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = self->button;
#line 814 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) _search_filter_toolbar_rating_filter_button_on_clicked_gtk_button_clicked, self, 0);
#line 816 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_tool_item_set_homogeneous (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tool_item_get_type (), GtkToolItem), FALSE);
#line 818 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = self->button;
#line 818 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
#line 807 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return self;
#line 7619 "SearchFilter.c"
}


SearchFilterToolbarRatingFilterButton* search_filter_toolbar_rating_filter_button_new (void) {
#line 807 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return search_filter_toolbar_rating_filter_button_construct (SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON);
#line 7626 "SearchFilter.c"
}


static void search_filter_toolbar_rating_filter_button_on_clicked (SearchFilterToolbarRatingFilterButton* self) {
#line 825 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_RATING_FILTER_BUTTON (self));
#line 826 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_emit_by_name (self, "clicked");
#line 7635 "SearchFilter.c"
}


static GtkWidget* search_filter_toolbar_rating_filter_button_get_filter_icon (SearchFilterToolbarRatingFilterButton* self, RatingFilter filter) {
	GtkWidget* result = NULL;
	gchar* filename = NULL;
	RatingFilter _tmp0_ = 0;
	GtkImage* image = NULL;
	const gchar* _tmp9_ = NULL;
	RatingFilter _tmp10_ = 0;
	gint _tmp11_ = 0;
	GdkPixbuf* _tmp12_ = NULL;
	GdkPixbuf* _tmp13_ = NULL;
	GtkImage* _tmp14_ = NULL;
	GtkImage* _tmp15_ = NULL;
#line 829 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (SEARCH_FILTER_TOOLBAR_IS_RATING_FILTER_BUTTON (self), NULL);
#line 830 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	filename = NULL;
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = filter;
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	switch (_tmp0_) {
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_ONE_OR_HIGHER:
#line 7661 "SearchFilter.c"
		{
			gchar* _tmp1_ = NULL;
#line 834 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp1_ = g_strdup (RESOURCES_ICON_FILTER_ONE_OR_BETTER);
#line 834 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_free0 (filename);
#line 834 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			filename = _tmp1_;
#line 835 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 7672 "SearchFilter.c"
		}
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_TWO_OR_HIGHER:
#line 7676 "SearchFilter.c"
		{
			gchar* _tmp2_ = NULL;
#line 838 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp2_ = g_strdup (RESOURCES_ICON_FILTER_TWO_OR_BETTER);
#line 838 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_free0 (filename);
#line 838 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			filename = _tmp2_;
#line 839 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 7687 "SearchFilter.c"
		}
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_THREE_OR_HIGHER:
#line 7691 "SearchFilter.c"
		{
			gchar* _tmp3_ = NULL;
#line 842 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp3_ = g_strdup (RESOURCES_ICON_FILTER_THREE_OR_BETTER);
#line 842 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_free0 (filename);
#line 842 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			filename = _tmp3_;
#line 843 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 7702 "SearchFilter.c"
		}
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FOUR_OR_HIGHER:
#line 7706 "SearchFilter.c"
		{
			gchar* _tmp4_ = NULL;
#line 846 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp4_ = g_strdup (RESOURCES_ICON_FILTER_FOUR_OR_BETTER);
#line 846 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_free0 (filename);
#line 846 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			filename = _tmp4_;
#line 847 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 7717 "SearchFilter.c"
		}
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FIVE_OR_HIGHER:
#line 7721 "SearchFilter.c"
		{
			gchar* _tmp5_ = NULL;
#line 850 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp5_ = g_strdup (RESOURCES_ICON_FILTER_FIVE);
#line 850 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_free0 (filename);
#line 850 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			filename = _tmp5_;
#line 851 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 7732 "SearchFilter.c"
		}
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_REJECTED_OR_HIGHER:
#line 7736 "SearchFilter.c"
		{
			gchar* _tmp6_ = NULL;
#line 854 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp6_ = g_strdup (RESOURCES_ICON_FILTER_REJECTED_OR_BETTER);
#line 854 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_free0 (filename);
#line 854 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			filename = _tmp6_;
#line 855 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 7747 "SearchFilter.c"
		}
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_REJECTED_ONLY:
#line 7751 "SearchFilter.c"
		{
			gchar* _tmp7_ = NULL;
#line 858 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp7_ = g_strdup (RESOURCES_ICON_RATING_REJECTED);
#line 858 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_free0 (filename);
#line 858 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			filename = _tmp7_;
#line 859 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 7762 "SearchFilter.c"
		}
		default:
#line 832 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_UNRATED_OR_HIGHER:
#line 7767 "SearchFilter.c"
		{
			gchar* _tmp8_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp8_ = g_strdup (RESOURCES_ICON_FILTER_UNRATED_OR_BETTER);
#line 863 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_g_free0 (filename);
#line 863 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			filename = _tmp8_;
#line 864 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			break;
#line 7778 "SearchFilter.c"
		}
	}
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = filename;
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = filter;
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp11_ = search_filter_toolbar_rating_filter_button_get_filter_icon_size (self, _tmp10_);
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = resources_load_icon (_tmp9_, _tmp11_);
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp13_ = _tmp12_;
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp14_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp13_);
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp14_);
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp15_ = _tmp14_;
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp13_);
#line 867 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	image = _tmp15_;
#line 869 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (image, gtk_widget_get_type (), GtkWidget), 6);
#line 871 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (image, gtk_widget_get_type (), GtkWidget);
#line 871 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_free0 (filename);
#line 871 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 7809 "SearchFilter.c"
}


static gint search_filter_toolbar_rating_filter_button_get_filter_icon_size (SearchFilterToolbarRatingFilterButton* self, RatingFilter filter) {
	gint result = 0;
	gint icon_base = 0;
	gint icon_star_base = 0;
	gint icon_plus = 0;
	RatingFilter _tmp0_ = 0;
#line 874 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (SEARCH_FILTER_TOOLBAR_IS_RATING_FILTER_BUTTON (self), 0);
#line 875 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	icon_base = (gint) (SEARCH_FILTER_TOOLBAR_FILTER_ICON_BASE_WIDTH * SEARCH_FILTER_TOOLBAR_FILTER_ICON_SCALE);
#line 876 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	icon_star_base = (gint) (SEARCH_FILTER_TOOLBAR_FILTER_ICON_BASE_WIDTH * SEARCH_FILTER_TOOLBAR_FILTER_ICON_STAR_SCALE);
#line 877 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	icon_plus = (gint) (SEARCH_FILTER_TOOLBAR_FILTER_ICON_PLUS_WIDTH * SEARCH_FILTER_TOOLBAR_FILTER_ICON_STAR_SCALE);
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = filter;
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	switch (_tmp0_) {
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_ONE_OR_HIGHER:
#line 7833 "SearchFilter.c"
		{
			gint _tmp1_ = 0;
			gint _tmp2_ = 0;
#line 881 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp1_ = icon_star_base;
#line 881 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp2_ = icon_plus;
#line 881 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = _tmp1_ + _tmp2_;
#line 881 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7845 "SearchFilter.c"
		}
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_TWO_OR_HIGHER:
#line 7849 "SearchFilter.c"
		{
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
#line 883 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp3_ = icon_star_base;
#line 883 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp4_ = icon_plus;
#line 883 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = (_tmp3_ * 2) + _tmp4_;
#line 883 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7861 "SearchFilter.c"
		}
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_THREE_OR_HIGHER:
#line 7865 "SearchFilter.c"
		{
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
#line 885 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp5_ = icon_star_base;
#line 885 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp6_ = icon_plus;
#line 885 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = (_tmp5_ * 3) + _tmp6_;
#line 885 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7877 "SearchFilter.c"
		}
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FOUR_OR_HIGHER:
#line 7881 "SearchFilter.c"
		{
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
#line 887 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp7_ = icon_star_base;
#line 887 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp8_ = icon_plus;
#line 887 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = (_tmp7_ * 4) + _tmp8_;
#line 887 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7893 "SearchFilter.c"
		}
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FIVE_OR_HIGHER:
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_FIVE_ONLY:
#line 7899 "SearchFilter.c"
		{
			gint _tmp9_ = 0;
#line 890 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			_tmp9_ = icon_star_base;
#line 890 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = _tmp9_ * 5;
#line 890 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7908 "SearchFilter.c"
		}
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_REJECTED_OR_HIGHER:
#line 7912 "SearchFilter.c"
		{
#line 892 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = RESOURCES_ICON_FILTER_REJECTED_OR_BETTER_FIXED_SIZE;
#line 892 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7918 "SearchFilter.c"
		}
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_UNRATED_OR_HIGHER:
#line 7922 "SearchFilter.c"
		{
#line 894 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = RESOURCES_ICON_FILTER_UNRATED_OR_BETTER_FIXED_SIZE;
#line 894 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7928 "SearchFilter.c"
		}
#line 879 "/home/jens/Source/shotwell/src/SearchFilter.vala"
		case RATING_FILTER_REJECTED_ONLY:
#line 7932 "SearchFilter.c"
		{
#line 896 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = icon_plus;
#line 896 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7938 "SearchFilter.c"
		}
		default:
		{
#line 898 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			result = icon_base;
#line 898 "/home/jens/Source/shotwell/src/SearchFilter.vala"
			return result;
#line 7946 "SearchFilter.c"
		}
	}
}


void search_filter_toolbar_rating_filter_button_set_filter_icon (SearchFilterToolbarRatingFilterButton* self, RatingFilter filter) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	RatingFilter _tmp2_ = 0;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	RatingFilter _tmp5_ = 0;
	gint _tmp6_ = 0;
	RatingFilter _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 902 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_RATING_FILTER_BUTTON (self));
#line 903 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->button;
#line 903 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_always_show_image (_tmp0_, TRUE);
#line 904 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = self->button;
#line 904 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = filter;
#line 904 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = search_filter_toolbar_rating_filter_button_get_filter_icon (self, _tmp2_);
#line 904 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = _tmp3_;
#line 904 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_image (_tmp1_, _tmp4_);
#line 904 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (_tmp4_);
#line 905 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp5_ = filter;
#line 905 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = search_filter_toolbar_rating_filter_button_get_filter_button_size (self, _tmp5_);
#line 905 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp6_, -1);
#line 906 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp7_ = filter;
#line 906 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = resources_get_rating_filter_tooltip (_tmp7_);
#line 906 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp9_ = _tmp8_;
#line 906 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_tool_item_set_tooltip_text (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tool_item_get_type (), GtkToolItem), _tmp9_);
#line 906 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_free0 (_tmp9_);
#line 907 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_set_has_tooltip (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
#line 908 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 8001 "SearchFilter.c"
}


static gint search_filter_toolbar_rating_filter_button_get_filter_button_size (SearchFilterToolbarRatingFilterButton* self, RatingFilter filter) {
	gint result = 0;
	RatingFilter _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 911 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_val_if_fail (SEARCH_FILTER_TOOLBAR_IS_RATING_FILTER_BUTTON (self), 0);
#line 912 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = filter;
#line 912 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = search_filter_toolbar_rating_filter_button_get_filter_icon_size (self, _tmp0_);
#line 912 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	result = _tmp1_ + (2 * SEARCH_FILTER_TOOLBAR_FILTER_BUTTON_MARGIN);
#line 912 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	return result;
#line 8019 "SearchFilter.c"
}


void search_filter_toolbar_rating_filter_button_set_label (SearchFilterToolbarRatingFilterButton* self, const gchar* label) {
	GtkButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 915 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (SEARCH_FILTER_TOOLBAR_IS_RATING_FILTER_BUTTON (self));
#line 915 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_return_if_fail (label != NULL);
#line 916 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->button;
#line 916 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = label;
#line 916 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	gtk_button_set_label (_tmp0_, _tmp1_);
#line 8036 "SearchFilter.c"
}


static void search_filter_toolbar_rating_filter_button_class_init (SearchFilterToolbarRatingFilterButtonClass * klass) {
#line 801 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_rating_filter_button_parent_class = g_type_class_peek_parent (klass);
#line 801 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (klass)->finalize = search_filter_toolbar_rating_filter_button_finalize;
#line 801 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_new ("clicked", SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 8047 "SearchFilter.c"
}


static void search_filter_toolbar_rating_filter_button_instance_init (SearchFilterToolbarRatingFilterButton * self) {
#line 802 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->filter_popup = NULL;
#line 8054 "SearchFilter.c"
}


static void search_filter_toolbar_rating_filter_button_finalize (GObject* obj) {
	SearchFilterToolbarRatingFilterButton * self;
	GtkButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 801 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEARCH_FILTER_TOOLBAR_TYPE_RATING_FILTER_BUTTON, SearchFilterToolbarRatingFilterButton);
#line 822 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->button;
#line 822 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("clicked", gtk_button_get_type (), &_tmp1_, NULL, FALSE);
#line 822 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _search_filter_toolbar_rating_filter_button_on_clicked_gtk_button_clicked, self);
#line 802 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->filter_popup);
#line 803 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->button);
#line 801 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (search_filter_toolbar_rating_filter_button_parent_class)->finalize (obj);
#line 8076 "SearchFilter.c"
}


GType search_filter_toolbar_rating_filter_button_get_type (void) {
	static volatile gsize search_filter_toolbar_rating_filter_button_type_id__volatile = 0;
	if (g_once_init_enter (&search_filter_toolbar_rating_filter_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchFilterToolbarRatingFilterButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_filter_toolbar_rating_filter_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchFilterToolbarRatingFilterButton), 0, (GInstanceInitFunc) search_filter_toolbar_rating_filter_button_instance_init, NULL };
		GType search_filter_toolbar_rating_filter_button_type_id;
		search_filter_toolbar_rating_filter_button_type_id = g_type_register_static (gtk_tool_item_get_type (), "SearchFilterToolbarRatingFilterButton", &g_define_type_info, 0);
		g_once_init_leave (&search_filter_toolbar_rating_filter_button_type_id__volatile, search_filter_toolbar_rating_filter_button_type_id);
	}
	return search_filter_toolbar_rating_filter_button_type_id__volatile;
}


static void search_filter_toolbar_class_init (SearchFilterToolbarClass * klass) {
#line 650 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	search_filter_toolbar_parent_class = g_type_class_peek_parent (klass);
#line 650 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_type_class_add_private (klass, sizeof (SearchFilterToolbarPrivate));
#line 650 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (klass)->finalize = search_filter_toolbar_finalize;
#line 8099 "SearchFilter.c"
}


static void search_filter_toolbar_instance_init (SearchFilterToolbar * self) {
	GtkMenu* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	GtkUIManager* _tmp2_ = NULL;
	SearchFilterToolbarRatingFilterButton* _tmp3_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv = SEARCH_FILTER_TOOLBAR_GET_PRIVATE (self);
#line 723 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
#line 723 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp0_);
#line 723 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->close_menu = _tmp0_;
#line 724 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new ();
#line 724 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp1_);
#line 724 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->close_item = _tmp1_;
#line 921 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = gtk_ui_manager_new ();
#line 921 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->ui = _tmp2_;
#line 925 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp3_ = search_filter_toolbar_rating_filter_button_new ();
#line 925 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_object_ref_sink (_tmp3_);
#line 925 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->rating_button = _tmp3_;
#line 926 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self->priv->search_filter = NULL;
#line 8134 "SearchFilter.c"
}


static void search_filter_toolbar_finalize (GObject* obj) {
	SearchFilterToolbar * self;
	SearchFilterActions* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	SearchFilterActions* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	SearchFilterActions* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	SearchFilterActions* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	SearchFilterActions* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	SearchFilterActions* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	SearchFilterActions* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	SearchFilterActions* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	GtkToolbar* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
#line 650 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_FILTER_TOOLBAR, SearchFilterToolbar);
#line 1033 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp0_ = self->priv->actions;
#line 1033 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("media-context-changed", TYPE_SEARCH_FILTER_ACTIONS, &_tmp1_, NULL, FALSE);
#line 1033 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _search_filter_toolbar_on_media_context_changed_search_filter_actions_media_context_changed, self);
#line 1035 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp2_ = self->priv->actions;
#line 1035 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("flagged-toggled", TYPE_SEARCH_FILTER_ACTIONS, &_tmp3_, NULL, FALSE);
#line 1035 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _search_filter_toolbar_on_flagged_toggled_search_filter_actions_flagged_toggled, self);
#line 1036 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp4_ = self->priv->actions;
#line 1036 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("photos-toggled", TYPE_SEARCH_FILTER_ACTIONS, &_tmp5_, NULL, FALSE);
#line 1036 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _search_filter_toolbar_on_photos_toggled_search_filter_actions_photos_toggled, self);
#line 1037 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp6_ = self->priv->actions;
#line 1037 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("videos-toggled", TYPE_SEARCH_FILTER_ACTIONS, &_tmp7_, NULL, FALSE);
#line 1037 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _search_filter_toolbar_on_videos_toggled_search_filter_actions_videos_toggled, self);
#line 1038 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp8_ = self->priv->actions;
#line 1038 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("raw-toggled", TYPE_SEARCH_FILTER_ACTIONS, &_tmp9_, NULL, FALSE);
#line 1038 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _search_filter_toolbar_on_raw_toggled_search_filter_actions_raw_toggled, self);
#line 1039 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp10_ = self->priv->actions;
#line 1039 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("rating-changed", TYPE_SEARCH_FILTER_ACTIONS, &_tmp11_, NULL, FALSE);
#line 1039 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _search_filter_toolbar_on_rating_changed_search_filter_actions_rating_changed, self);
#line 1040 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp12_ = self->priv->actions;
#line 1040 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("text-changed", TYPE_SEARCH_FILTER_ACTIONS, &_tmp13_, NULL, FALSE);
#line 1040 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _search_filter_toolbar_on_search_text_changed_search_filter_actions_text_changed, self);
#line 1041 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp14_ = self->priv->actions;
#line 1041 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("criteria-changed", TYPE_SEARCH_FILTER_ACTIONS, &_tmp15_, NULL, FALSE);
#line 1041 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp14_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp15_, 0, NULL, (GCallback) _search_filter_toolbar_on_criteria_changed_search_filter_actions_criteria_changed, self);
#line 1043 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_tmp16_ = self->priv->toolbar;
#line 1043 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_parse_name ("popup-context-menu", gtk_toolbar_get_type (), &_tmp17_, NULL, FALSE);
#line 1043 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	g_signal_handlers_disconnect_matched (_tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _search_filter_toolbar_on_context_menu_requested_gtk_toolbar_popup_context_menu, self);
#line 651 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbar);
#line 723 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->close_menu);
#line 724 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->close_item);
#line 921 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->ui);
#line 923 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_search_filter_actions_unref0 (self->priv->actions);
#line 924 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->search_box);
#line 925 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->rating_button);
#line 926 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_view_filter_unref0 (self->priv->search_filter);
#line 927 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->label_type);
#line 928 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbtn_photos);
#line 929 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbtn_videos);
#line 930 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbtn_raw);
#line 931 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->toolbtn_flag);
#line 932 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->sepr_mediatype_flagged);
#line 933 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	_g_object_unref0 (self->priv->sepr_flagged_rating);
#line 650 "/home/jens/Source/shotwell/src/SearchFilter.vala"
	G_OBJECT_CLASS (search_filter_toolbar_parent_class)->finalize (obj);
#line 8246 "SearchFilter.c"
}


GType search_filter_toolbar_get_type (void) {
	static volatile gsize search_filter_toolbar_type_id__volatile = 0;
	if (g_once_init_enter (&search_filter_toolbar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchFilterToolbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_filter_toolbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchFilterToolbar), 0, (GInstanceInitFunc) search_filter_toolbar_instance_init, NULL };
		GType search_filter_toolbar_type_id;
		search_filter_toolbar_type_id = g_type_register_static (gtk_revealer_get_type (), "SearchFilterToolbar", &g_define_type_info, 0);
		g_once_init_leave (&search_filter_toolbar_type_id__volatile, search_filter_toolbar_type_id);
	}
	return search_filter_toolbar_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



