/* Box.c generated by valac 0.32.0.15-114e9, the Vala compiler
 * generated from Box.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>


#define TYPE_BOX_LOCATION (box_location_get_type ())

#define TYPE_BOX_COMPLEMENTS (box_complements_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	BOX_LOCATION_OUTSIDE,
	BOX_LOCATION_INSIDE,
	BOX_LOCATION_TOP_SIDE,
	BOX_LOCATION_LEFT_SIDE,
	BOX_LOCATION_RIGHT_SIDE,
	BOX_LOCATION_BOTTOM_SIDE,
	BOX_LOCATION_TOP_LEFT,
	BOX_LOCATION_BOTTOM_LEFT,
	BOX_LOCATION_TOP_RIGHT,
	BOX_LOCATION_BOTTOM_RIGHT
} BoxLocation;

typedef enum  {
	BOX_COMPLEMENTS_NONE,
	BOX_COMPLEMENTS_VERTICAL,
	BOX_COMPLEMENTS_HORIZONTAL,
	BOX_COMPLEMENTS_BOTH
} BoxComplements;

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _Dimensions {
	gint width;
	gint height;
};



GType box_location_get_type (void) G_GNUC_CONST;
GType box_complements_get_type (void) G_GNUC_CONST;
BoxComplements box_complements_derive (gboolean horizontal_complement, gboolean vertical_complement);
GType box_get_type (void) G_GNUC_CONST;
Box* box_dup (const Box* self);
void box_free (Box* self);
#define BOX_HAND_GRENADES 12
void box_init (Box *self, gint left, gint top, gint right, gint bottom);
void box_from_rectangle (GdkRectangle* rect, Box* result);
void box_from_allocation (GtkAllocation* alloc, Box* result);
void box_from_points (GdkPoint* corner1, GdkPoint* corner2, Box* result);
void box_from_center (GdkPoint* center, gint width, gint height, Box* result);
gint box_get_width (Box *self);
gint box_get_height (Box *self);
gboolean box_is_valid (Box *self);
gboolean box_equals (Box *self, Box* box);
void box_adjust_width (Box *self, gint width);
void box_adjust_height (Box *self, gint height);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void box_get_scaled (Box *self, Dimensions* scaled, Box* result);
void box_get_dimensions (Box *self, Dimensions* result);
void dimensions_get_scale_ratios (Dimensions *self, Dimensions* scaled, gdouble* width_ratio, gdouble* height_ratio);
void box_get_scaled_similar (Box *self, Dimensions* original, Dimensions* scaled, Box* result);
void box_get_offset (Box *self, gint xofs, gint yofs, Box* result);
void dimensions_init (Dimensions *self, gint width, gint height);
void box_get_points (Box *self, GdkPoint* top_left, GdkPoint* bottom_right);
void box_get_rectangle (Box *self, GdkRectangle* result);
void box_get_center (Box *self, GdkPoint* result);
void box_rotate_clockwise (Box *self, Dimensions* space, Box* result);
void box_rotate_counterclockwise (Box *self, Dimensions* space, Box* result);
void box_flip_left_to_right (Box *self, Dimensions* space, Box* result);
void box_flip_top_to_bottom (Box *self, Dimensions* space, Box* result);
gboolean box_intersects (Box *self, Box* compare);
void box_get_reduced (Box *self, gint amount, Box* result);
void box_get_expanded (Box *self, gint amount, Box* result);
gboolean box_contains (Box *self, GdkPoint* point);
BoxComplements box_resized_complements (Box *self, Box* resized, Box* horizontal, gboolean* horizontal_enlarged, Box* vertical, gboolean* vertical_enlarged);
BoxComplements box_shifted_complements (Box *self, Box* shifted, Box* horizontal_this, Box* vertical_this, Box* horizontal_shifted, Box* vertical_shifted);
void box_rubber_band (Box *self, GdkPoint* point, Box* result);
gchar* box_to_string (Box *self);
gchar* dimensions_to_string (Dimensions *self);
static gboolean box_in_zone (gdouble pos, gint zone);
static gboolean box_in_between (gdouble pos, gint top, gint bottom);
static gboolean box_near_in_between (gdouble pos, gint top, gint bottom);
BoxLocation box_approx_location (Box *self, gint x, gint y);


GType box_location_get_type (void) {
	static volatile gsize box_location_type_id__volatile = 0;
	if (g_once_init_enter (&box_location_type_id__volatile)) {
		static const GEnumValue values[] = {{BOX_LOCATION_OUTSIDE, "BOX_LOCATION_OUTSIDE", "outside"}, {BOX_LOCATION_INSIDE, "BOX_LOCATION_INSIDE", "inside"}, {BOX_LOCATION_TOP_SIDE, "BOX_LOCATION_TOP_SIDE", "top-side"}, {BOX_LOCATION_LEFT_SIDE, "BOX_LOCATION_LEFT_SIDE", "left-side"}, {BOX_LOCATION_RIGHT_SIDE, "BOX_LOCATION_RIGHT_SIDE", "right-side"}, {BOX_LOCATION_BOTTOM_SIDE, "BOX_LOCATION_BOTTOM_SIDE", "bottom-side"}, {BOX_LOCATION_TOP_LEFT, "BOX_LOCATION_TOP_LEFT", "top-left"}, {BOX_LOCATION_BOTTOM_LEFT, "BOX_LOCATION_BOTTOM_LEFT", "bottom-left"}, {BOX_LOCATION_TOP_RIGHT, "BOX_LOCATION_TOP_RIGHT", "top-right"}, {BOX_LOCATION_BOTTOM_RIGHT, "BOX_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
		GType box_location_type_id;
		box_location_type_id = g_enum_register_static ("BoxLocation", values);
		g_once_init_leave (&box_location_type_id__volatile, box_location_type_id);
	}
	return box_location_type_id__volatile;
}


BoxComplements box_complements_derive (gboolean horizontal_complement, gboolean vertical_complement) {
	BoxComplements result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 27 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = horizontal_complement;
#line 27 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp1_) {
#line 140 "Box.c"
		gboolean _tmp2_ = FALSE;
#line 27 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp2_ = vertical_complement;
#line 27 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp0_ = _tmp2_;
#line 146 "Box.c"
	} else {
#line 27 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp0_ = FALSE;
#line 150 "Box.c"
	}
#line 27 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp0_) {
#line 28 "/home/jens/Source/shotwell/src/Box.vala"
		result = BOX_COMPLEMENTS_BOTH;
#line 28 "/home/jens/Source/shotwell/src/Box.vala"
		return result;
#line 158 "Box.c"
	} else {
		gboolean _tmp3_ = FALSE;
#line 29 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp3_ = horizontal_complement;
#line 29 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp3_) {
#line 30 "/home/jens/Source/shotwell/src/Box.vala"
			result = BOX_COMPLEMENTS_HORIZONTAL;
#line 30 "/home/jens/Source/shotwell/src/Box.vala"
			return result;
#line 169 "Box.c"
		} else {
			gboolean _tmp4_ = FALSE;
#line 31 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp4_ = vertical_complement;
#line 31 "/home/jens/Source/shotwell/src/Box.vala"
			if (_tmp4_) {
#line 32 "/home/jens/Source/shotwell/src/Box.vala"
				result = BOX_COMPLEMENTS_VERTICAL;
#line 32 "/home/jens/Source/shotwell/src/Box.vala"
				return result;
#line 180 "Box.c"
			}
		}
	}
#line 34 "/home/jens/Source/shotwell/src/Box.vala"
	result = BOX_COMPLEMENTS_NONE;
#line 34 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 188 "Box.c"
}


GType box_complements_get_type (void) {
	static volatile gsize box_complements_type_id__volatile = 0;
	if (g_once_init_enter (&box_complements_type_id__volatile)) {
		static const GEnumValue values[] = {{BOX_COMPLEMENTS_NONE, "BOX_COMPLEMENTS_NONE", "none"}, {BOX_COMPLEMENTS_VERTICAL, "BOX_COMPLEMENTS_VERTICAL", "vertical"}, {BOX_COMPLEMENTS_HORIZONTAL, "BOX_COMPLEMENTS_HORIZONTAL", "horizontal"}, {BOX_COMPLEMENTS_BOTH, "BOX_COMPLEMENTS_BOTH", "both"}, {0, NULL, NULL}};
		GType box_complements_type_id;
		box_complements_type_id = g_enum_register_static ("BoxComplements", values);
		g_once_init_leave (&box_complements_type_id__volatile, box_complements_type_id);
	}
	return box_complements_type_id__volatile;
}


void box_init (Box *self, gint left, gint top, gint right, gint bottom) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 46 "/home/jens/Source/shotwell/src/Box.vala"
	memset (self, 0, sizeof (Box));
#line 48 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = left;
#line 48 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = CLAMP (_tmp0_, 0, G_MAXINT);
#line 48 "/home/jens/Source/shotwell/src/Box.vala"
	left = _tmp1_;
#line 49 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = top;
#line 49 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = CLAMP (_tmp2_, 0, G_MAXINT);
#line 49 "/home/jens/Source/shotwell/src/Box.vala"
	top = _tmp3_;
#line 53 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = right;
#line 53 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = left;
#line 53 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp4_ <= _tmp5_) {
#line 237 "Box.c"
		gint _tmp6_ = 0;
#line 54 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp6_ = left;
#line 54 "/home/jens/Source/shotwell/src/Box.vala"
		right = _tmp6_ + 1;
#line 243 "Box.c"
	}
#line 56 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = bottom;
#line 56 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = top;
#line 56 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp7_ <= _tmp8_) {
#line 251 "Box.c"
		gint _tmp9_ = 0;
#line 57 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp9_ = top;
#line 57 "/home/jens/Source/shotwell/src/Box.vala"
		bottom = _tmp9_ + 1;
#line 257 "Box.c"
	}
#line 59 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = left;
#line 59 "/home/jens/Source/shotwell/src/Box.vala"
	(*self).left = _tmp10_;
#line 60 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = top;
#line 60 "/home/jens/Source/shotwell/src/Box.vala"
	(*self).top = _tmp11_;
#line 61 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp12_ = right;
#line 61 "/home/jens/Source/shotwell/src/Box.vala"
	(*self).right = _tmp12_;
#line 62 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp13_ = bottom;
#line 62 "/home/jens/Source/shotwell/src/Box.vala"
	(*self).bottom = _tmp13_;
#line 275 "Box.c"
}


void box_from_rectangle (GdkRectangle* rect, Box* result) {
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_ = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	gint _tmp9_ = 0;
	GdkRectangle _tmp10_ = {0};
	gint _tmp11_ = 0;
	Box _tmp12_ = {0};
#line 65 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (rect != NULL);
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *rect;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.x;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = *rect;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = _tmp2_.y;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = *rect;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = _tmp4_.x;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = *rect;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = _tmp6_.width;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = *rect;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = _tmp8_.y;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = *rect;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = _tmp10_.height;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp12_, _tmp1_, _tmp3_, (_tmp5_ + _tmp7_) - 1, (_tmp9_ + _tmp11_) - 1);
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp12_;
#line 66 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 325 "Box.c"
}


void box_from_allocation (GtkAllocation* alloc, Box* result) {
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	Box _tmp12_ = {0};
#line 69 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (alloc != NULL);
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *alloc;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.x;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = *alloc;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = _tmp2_.y;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = *alloc;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = _tmp4_.x;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = *alloc;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = _tmp6_.width;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = *alloc;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = _tmp8_.y;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = *alloc;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = _tmp10_.height;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp12_, _tmp1_, _tmp3_, (_tmp5_ + _tmp7_) - 1, (_tmp9_ + _tmp11_) - 1);
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp12_;
#line 70 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 375 "Box.c"
}


void box_from_points (GdkPoint* corner1, GdkPoint* corner2, Box* result) {
	GdkPoint _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkPoint _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkPoint _tmp5_ = {0};
	gint _tmp6_ = 0;
	GdkPoint _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GdkPoint _tmp10_ = {0};
	gint _tmp11_ = 0;
	GdkPoint _tmp12_ = {0};
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GdkPoint _tmp15_ = {0};
	gint _tmp16_ = 0;
	GdkPoint _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Box _tmp20_ = {0};
#line 75 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (corner1 != NULL);
#line 75 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (corner2 != NULL);
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *corner1;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.x;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = *corner2;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = _tmp2_.x;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = MIN (_tmp1_, _tmp3_);
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = *corner1;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = _tmp5_.y;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = *corner2;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = _tmp7_.y;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = MIN (_tmp6_, _tmp8_);
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = *corner1;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = _tmp10_.x;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp12_ = *corner2;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp13_ = _tmp12_.x;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp14_ = MAX (_tmp11_, _tmp13_);
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp15_ = *corner1;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp16_ = _tmp15_.y;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp17_ = *corner2;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp18_ = _tmp17_.y;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp19_ = MAX (_tmp16_, _tmp18_);
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp20_, _tmp4_, _tmp9_, _tmp14_, _tmp19_);
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp20_;
#line 76 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 451 "Box.c"
}


void box_from_center (GdkPoint* center, gint width, gint height, Box* result) {
	GdkPoint _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkPoint _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GdkPoint _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GdkPoint _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Box _tmp12_ = {0};
#line 80 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (center != NULL);
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *center;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.x;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = width;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = *center;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = _tmp3_.y;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = height;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = *center;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = _tmp6_.x;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = width;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = *center;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = _tmp9_.y;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = height;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp12_, _tmp1_ - (_tmp2_ / 2), _tmp4_ - (_tmp5_ / 2), _tmp7_ + (_tmp8_ / 2), _tmp10_ + (_tmp11_ / 2));
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp12_;
#line 81 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 501 "Box.c"
}


gint box_get_width (Box *self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 86 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).right;
#line 86 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).left;
#line 86 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_assert (_tmp0_ >= _tmp1_, "right >= left");
#line 88 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).right;
#line 88 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).left;
#line 88 "/home/jens/Source/shotwell/src/Box.vala"
	result = (_tmp2_ - _tmp3_) + 1;
#line 88 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 525 "Box.c"
}


gint box_get_height (Box *self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 92 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).bottom;
#line 92 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).top;
#line 92 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_assert (_tmp0_ >= _tmp1_, "bottom >= top");
#line 94 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).bottom;
#line 94 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).top;
#line 94 "/home/jens/Source/shotwell/src/Box.vala"
	result = (_tmp2_ - _tmp3_) + 1;
#line 94 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 549 "Box.c"
}


gboolean box_is_valid (Box *self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).left;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp3_ >= 0) {
#line 563 "Box.c"
		gint _tmp4_ = 0;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp4_ = (*self).top;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp2_ = _tmp4_ >= 0;
#line 569 "Box.c"
	} else {
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp2_ = FALSE;
#line 573 "Box.c"
	}
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp2_) {
#line 577 "Box.c"
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp5_ = (*self).right;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp6_ = (*self).left;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp1_ = _tmp5_ >= _tmp6_;
#line 586 "Box.c"
	} else {
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp1_ = FALSE;
#line 590 "Box.c"
	}
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp1_) {
#line 594 "Box.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp7_ = (*self).bottom;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp8_ = (*self).top;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp0_ = _tmp7_ >= _tmp8_;
#line 603 "Box.c"
	} else {
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp0_ = FALSE;
#line 607 "Box.c"
	}
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp0_;
#line 98 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 613 "Box.c"
}


gboolean box_equals (Box *self, Box* box) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	Box _tmp4_ = {0};
	gint _tmp5_ = 0;
#line 101 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_val_if_fail (box != NULL, FALSE);
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).left;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = *box;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = _tmp4_.left;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp3_ == _tmp5_) {
#line 635 "Box.c"
		gint _tmp6_ = 0;
		Box _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp6_ = (*self).top;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp7_ = *box;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp8_ = _tmp7_.top;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp2_ = _tmp6_ == _tmp8_;
#line 647 "Box.c"
	} else {
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp2_ = FALSE;
#line 651 "Box.c"
	}
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp2_) {
#line 655 "Box.c"
		gint _tmp9_ = 0;
		Box _tmp10_ = {0};
		gint _tmp11_ = 0;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp9_ = (*self).right;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp10_ = *box;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp11_ = _tmp10_.right;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp1_ = _tmp9_ == _tmp11_;
#line 667 "Box.c"
	} else {
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp1_ = FALSE;
#line 671 "Box.c"
	}
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp1_) {
#line 675 "Box.c"
		gint _tmp12_ = 0;
		Box _tmp13_ = {0};
		gint _tmp14_ = 0;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp12_ = (*self).bottom;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp13_ = *box;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp14_ = _tmp13_.bottom;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp0_ = _tmp12_ == _tmp14_;
#line 687 "Box.c"
	} else {
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp0_ = FALSE;
#line 691 "Box.c"
	}
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp0_;
#line 102 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 697 "Box.c"
}


void box_adjust_width (Box *self, gint width) {
	gint center_x = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 107 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 107 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).right;
#line 107 "/home/jens/Source/shotwell/src/Box.vala"
	center_x = (_tmp0_ + _tmp1_) / 2;
#line 108 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = width;
#line 108 "/home/jens/Source/shotwell/src/Box.vala"
	(*self).left = center_x - (_tmp2_ / 2);
#line 109 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = width;
#line 109 "/home/jens/Source/shotwell/src/Box.vala"
	(*self).right = center_x + (_tmp3_ / 2);
#line 721 "Box.c"
}


void box_adjust_height (Box *self, gint height) {
	gint center_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 114 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).top;
#line 114 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).bottom;
#line 114 "/home/jens/Source/shotwell/src/Box.vala"
	center_y = (_tmp0_ + _tmp1_) / 2;
#line 115 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = height;
#line 115 "/home/jens/Source/shotwell/src/Box.vala"
	(*self).top = center_y - (_tmp2_ / 2);
#line 116 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = height;
#line 116 "/home/jens/Source/shotwell/src/Box.vala"
	(*self).bottom = center_y + (_tmp3_ / 2);
#line 745 "Box.c"
}


void box_get_scaled (Box *self, Dimensions* scaled, Box* result) {
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint l = 0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gint t = 0;
	gint _tmp7_ = 0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gint r = 0;
	gint _tmp10_ = 0;
	Dimensions _tmp11_ = {0};
	gint _tmp12_ = 0;
	gint b = 0;
	gint _tmp13_ = 0;
	Dimensions _tmp14_ = {0};
	gint _tmp15_ = 0;
	Box box = {0};
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_ = 0;
	Dimensions _tmp22_ = {0};
	gint _tmp23_ = 0;
#line 119 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (scaled != NULL);
#line 121 "/home/jens/Source/shotwell/src/Box.vala"
	box_get_dimensions (&(*self), &_tmp0_);
#line 121 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = *scaled;
#line 121 "/home/jens/Source/shotwell/src/Box.vala"
	dimensions_get_scale_ratios (&_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
#line 121 "/home/jens/Source/shotwell/src/Box.vala"
	x_scale = _tmp2_;
#line 121 "/home/jens/Source/shotwell/src/Box.vala"
	y_scale = _tmp3_;
#line 123 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = (*self).left;
#line 123 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = x_scale;
#line 123 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = round (((gdouble) _tmp4_) * _tmp5_);
#line 123 "/home/jens/Source/shotwell/src/Box.vala"
	l = (gint) _tmp6_;
#line 124 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = (*self).top;
#line 124 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = y_scale;
#line 124 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = round (((gdouble) _tmp7_) * _tmp8_);
#line 124 "/home/jens/Source/shotwell/src/Box.vala"
	t = (gint) _tmp9_;
#line 127 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = l;
#line 127 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = *scaled;
#line 127 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp12_ = _tmp11_.width;
#line 127 "/home/jens/Source/shotwell/src/Box.vala"
	r = (_tmp10_ + _tmp12_) - 1;
#line 128 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp13_ = t;
#line 128 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp14_ = *scaled;
#line 128 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp15_ = _tmp14_.height;
#line 128 "/home/jens/Source/shotwell/src/Box.vala"
	b = (_tmp13_ + _tmp15_) - 1;
#line 130 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp16_ = l;
#line 130 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp17_ = t;
#line 130 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp18_ = r;
#line 130 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp19_ = b;
#line 130 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&box, _tmp16_, _tmp17_, _tmp18_, _tmp19_);
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp21_ = box_get_width (&box);
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp22_ = *scaled;
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp23_ = _tmp22_.width;
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp21_ == _tmp23_) {
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp20_ = TRUE;
#line 845 "Box.c"
	} else {
		gint _tmp24_ = 0;
		Dimensions _tmp25_ = {0};
		gint _tmp26_ = 0;
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp24_ = box_get_height (&box);
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp25_ = *scaled;
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp26_ = _tmp25_.height;
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp20_ = _tmp24_ == _tmp26_;
#line 858 "Box.c"
	}
#line 131 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_assert (_tmp20_, "box.get_width() == scaled.width || box.get_height() == scaled.height");
#line 133 "/home/jens/Source/shotwell/src/Box.vala"
	*result = box;
#line 133 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 866 "Box.c"
}


void box_get_scaled_similar (Box *self, Dimensions* original, Dimensions* scaled, Box* result) {
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gint l = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gint t = 0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gint r = 0;
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gint b = 0;
	gint _tmp12_ = 0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gint _tmp15_ = 0;
	Dimensions _tmp16_ = {0};
	gint _tmp17_ = 0;
	gint _tmp20_ = 0;
	Dimensions _tmp21_ = {0};
	gint _tmp22_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	Box _tmp29_ = {0};
#line 136 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (original != NULL);
#line 136 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (scaled != NULL);
#line 138 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *scaled;
#line 138 "/home/jens/Source/shotwell/src/Box.vala"
	dimensions_get_scale_ratios (original, &_tmp0_, &_tmp1_, &_tmp2_);
#line 138 "/home/jens/Source/shotwell/src/Box.vala"
	x_scale = _tmp1_;
#line 138 "/home/jens/Source/shotwell/src/Box.vala"
	y_scale = _tmp2_;
#line 140 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).left;
#line 140 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = x_scale;
#line 140 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = round (((gdouble) _tmp3_) * _tmp4_);
#line 140 "/home/jens/Source/shotwell/src/Box.vala"
	l = (gint) _tmp5_;
#line 141 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = (*self).top;
#line 141 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = y_scale;
#line 141 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = round (((gdouble) _tmp6_) * _tmp7_);
#line 141 "/home/jens/Source/shotwell/src/Box.vala"
	t = (gint) _tmp8_;
#line 142 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = (*self).right;
#line 142 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = x_scale;
#line 142 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = round (((gdouble) _tmp9_) * _tmp10_);
#line 142 "/home/jens/Source/shotwell/src/Box.vala"
	r = (gint) _tmp11_;
#line 143 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp12_ = (*self).bottom;
#line 143 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp13_ = y_scale;
#line 143 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp14_ = round (((gdouble) _tmp12_) * _tmp13_);
#line 143 "/home/jens/Source/shotwell/src/Box.vala"
	b = (gint) _tmp14_;
#line 146 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp15_ = r;
#line 146 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp16_ = *scaled;
#line 146 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp17_ = _tmp16_.width;
#line 146 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp15_ >= _tmp17_) {
#line 955 "Box.c"
		Dimensions _tmp18_ = {0};
		gint _tmp19_ = 0;
#line 147 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp18_ = *scaled;
#line 147 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp19_ = _tmp18_.width;
#line 147 "/home/jens/Source/shotwell/src/Box.vala"
		r = _tmp19_ - 1;
#line 964 "Box.c"
	}
#line 149 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp20_ = b;
#line 149 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp21_ = *scaled;
#line 149 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp22_ = _tmp21_.height;
#line 149 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp20_ >= _tmp22_) {
#line 974 "Box.c"
		Dimensions _tmp23_ = {0};
		gint _tmp24_ = 0;
#line 150 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp23_ = *scaled;
#line 150 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp24_ = _tmp23_.height;
#line 150 "/home/jens/Source/shotwell/src/Box.vala"
		b = _tmp24_ - 1;
#line 983 "Box.c"
	}
#line 152 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp25_ = l;
#line 152 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp26_ = t;
#line 152 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp27_ = r;
#line 152 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp28_ = b;
#line 152 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp29_, _tmp25_, _tmp26_, _tmp27_, _tmp28_);
#line 152 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp29_;
#line 152 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 999 "Box.c"
}


void box_get_offset (Box *self, gint xofs, gint yofs, Box* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Box _tmp8_ = {0};
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = xofs;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).top;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = yofs;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = (*self).right;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = xofs;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = (*self).bottom;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = yofs;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp8_, _tmp0_ + _tmp1_, _tmp2_ + _tmp3_, _tmp4_ + _tmp5_, _tmp6_ + _tmp7_);
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp8_;
#line 156 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1035 "Box.c"
}


void box_get_dimensions (Box *self, Dimensions* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
#line 160 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = box_get_width (&(*self));
#line 160 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = box_get_height (&(*self));
#line 160 "/home/jens/Source/shotwell/src/Box.vala"
	dimensions_init (&_tmp2_, _tmp0_, _tmp1_);
#line 160 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp2_;
#line 160 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1053 "Box.c"
}


void box_get_points (Box *self, GdkPoint* top_left, GdkPoint* bottom_right) {
	GdkPoint _vala_top_left = {0};
	GdkPoint _vala_bottom_right = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkPoint _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkPoint _tmp5_ = {0};
#line 164 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 164 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).top;
#line 164 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_.x = _tmp0_;
#line 164 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_.y = _tmp1_;
#line 164 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_top_left = _tmp2_;
#line 165 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).right;
#line 165 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = (*self).bottom;
#line 165 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_.x = _tmp3_;
#line 165 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_.y = _tmp4_;
#line 165 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_bottom_right = _tmp5_;
#line 163 "/home/jens/Source/shotwell/src/Box.vala"
	if (top_left) {
#line 163 "/home/jens/Source/shotwell/src/Box.vala"
		*top_left = _vala_top_left;
#line 1090 "Box.c"
	}
#line 163 "/home/jens/Source/shotwell/src/Box.vala"
	if (bottom_right) {
#line 163 "/home/jens/Source/shotwell/src/Box.vala"
		*bottom_right = _vala_bottom_right;
#line 1096 "Box.c"
	}
}


void box_get_rectangle (Box *self, GdkRectangle* result) {
	GdkRectangle rect = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 169 "/home/jens/Source/shotwell/src/Box.vala"
	memset (&rect, 0, sizeof (GdkRectangle));
#line 170 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 170 "/home/jens/Source/shotwell/src/Box.vala"
	rect.x = _tmp0_;
#line 171 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).top;
#line 171 "/home/jens/Source/shotwell/src/Box.vala"
	rect.y = _tmp1_;
#line 172 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = box_get_width (&(*self));
#line 172 "/home/jens/Source/shotwell/src/Box.vala"
	rect.width = _tmp2_;
#line 173 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = box_get_height (&(*self));
#line 173 "/home/jens/Source/shotwell/src/Box.vala"
	rect.height = _tmp3_;
#line 175 "/home/jens/Source/shotwell/src/Box.vala"
	*result = rect;
#line 175 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1129 "Box.c"
}


void box_get_center (Box *self, GdkPoint* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkPoint _tmp4_ = {0};
#line 179 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 179 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).right;
#line 179 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).top;
#line 179 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).bottom;
#line 179 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_.x = (_tmp0_ + _tmp1_) / 2;
#line 179 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_.y = (_tmp2_ + _tmp3_) / 2;
#line 179 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp4_;
#line 179 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1155 "Box.c"
}


void box_rotate_clockwise (Box *self, Dimensions* space, Box* result) {
	gint l = 0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint t = 0;
	gint _tmp3_ = 0;
	gint r = 0;
	Dimensions _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint b = 0;
	gint _tmp7_ = 0;
	Box _tmp8_ = {0};
#line 182 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (space != NULL);
#line 183 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *space;
#line 183 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.width;
#line 183 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).bottom;
#line 183 "/home/jens/Source/shotwell/src/Box.vala"
	l = (_tmp1_ - _tmp2_) - 1;
#line 184 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).left;
#line 184 "/home/jens/Source/shotwell/src/Box.vala"
	t = _tmp3_;
#line 185 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = *space;
#line 185 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = _tmp4_.width;
#line 185 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = (*self).top;
#line 185 "/home/jens/Source/shotwell/src/Box.vala"
	r = (_tmp5_ - _tmp6_) - 1;
#line 186 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = (*self).right;
#line 186 "/home/jens/Source/shotwell/src/Box.vala"
	b = _tmp7_;
#line 188 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp8_, l, t, r, b);
#line 188 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp8_;
#line 188 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1205 "Box.c"
}


void box_rotate_counterclockwise (Box *self, Dimensions* space, Box* result) {
	gint l = 0;
	gint _tmp0_ = 0;
	gint t = 0;
	Dimensions _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint r = 0;
	gint _tmp4_ = 0;
	gint b = 0;
	Dimensions _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Box _tmp8_ = {0};
#line 191 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (space != NULL);
#line 192 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).top;
#line 192 "/home/jens/Source/shotwell/src/Box.vala"
	l = _tmp0_;
#line 193 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = *space;
#line 193 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = _tmp1_.height;
#line 193 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).right;
#line 193 "/home/jens/Source/shotwell/src/Box.vala"
	t = (_tmp2_ - _tmp3_) - 1;
#line 194 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = (*self).bottom;
#line 194 "/home/jens/Source/shotwell/src/Box.vala"
	r = _tmp4_;
#line 195 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = *space;
#line 195 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = _tmp5_.height;
#line 195 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = (*self).left;
#line 195 "/home/jens/Source/shotwell/src/Box.vala"
	b = (_tmp6_ - _tmp7_) - 1;
#line 197 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp8_, l, t, r, b);
#line 197 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp8_;
#line 197 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1255 "Box.c"
}


void box_flip_left_to_right (Box *self, Dimensions* space, Box* result) {
	gint l = 0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint r = 0;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Box _tmp8_ = {0};
#line 200 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (space != NULL);
#line 201 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *space;
#line 201 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.width;
#line 201 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).right;
#line 201 "/home/jens/Source/shotwell/src/Box.vala"
	l = (_tmp1_ - _tmp2_) - 1;
#line 202 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = *space;
#line 202 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = _tmp3_.width;
#line 202 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = (*self).left;
#line 202 "/home/jens/Source/shotwell/src/Box.vala"
	r = (_tmp4_ - _tmp5_) - 1;
#line 204 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = (*self).top;
#line 204 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = (*self).bottom;
#line 204 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp8_, l, _tmp6_, r, _tmp7_);
#line 204 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp8_;
#line 204 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1299 "Box.c"
}


void box_flip_top_to_bottom (Box *self, Dimensions* space, Box* result) {
	gint t = 0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint b = 0;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Box _tmp8_ = {0};
#line 207 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (space != NULL);
#line 208 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *space;
#line 208 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.height;
#line 208 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).bottom;
#line 208 "/home/jens/Source/shotwell/src/Box.vala"
	t = (_tmp1_ - _tmp2_) - 1;
#line 209 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = *space;
#line 209 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = _tmp3_.height;
#line 209 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = (*self).top;
#line 209 "/home/jens/Source/shotwell/src/Box.vala"
	b = (_tmp4_ - _tmp5_) - 1;
#line 211 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = (*self).left;
#line 211 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = (*self).right;
#line 211 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp8_, _tmp6_, t, _tmp7_, b);
#line 211 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp8_;
#line 211 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1343 "Box.c"
}


gboolean box_intersects (Box *self, Box* compare) {
	gboolean result = FALSE;
	gint left_intersect = 0;
	gint _tmp0_ = 0;
	Box _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint top_intersect = 0;
	gint _tmp4_ = 0;
	Box _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint right_intersect = 0;
	gint _tmp8_ = 0;
	Box _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint bottom_intersect = 0;
	gint _tmp12_ = 0;
	Box _tmp13_ = {0};
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
#line 214 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_val_if_fail (compare != NULL, FALSE);
#line 215 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 215 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = *compare;
#line 215 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = _tmp1_.left;
#line 215 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = MAX (_tmp0_, _tmp2_);
#line 215 "/home/jens/Source/shotwell/src/Box.vala"
	left_intersect = _tmp3_;
#line 216 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = (*self).top;
#line 216 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = *compare;
#line 216 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = _tmp5_.top;
#line 216 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = MAX (_tmp4_, _tmp6_);
#line 216 "/home/jens/Source/shotwell/src/Box.vala"
	top_intersect = _tmp7_;
#line 217 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = (*self).right;
#line 217 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = *compare;
#line 217 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = _tmp9_.right;
#line 217 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = MIN (_tmp8_, _tmp10_);
#line 217 "/home/jens/Source/shotwell/src/Box.vala"
	right_intersect = _tmp11_;
#line 218 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp12_ = (*self).bottom;
#line 218 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp13_ = *compare;
#line 218 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp14_ = _tmp13_.bottom;
#line 218 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp15_ = MIN (_tmp12_, _tmp14_);
#line 218 "/home/jens/Source/shotwell/src/Box.vala"
	bottom_intersect = _tmp15_;
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp17_ = right_intersect;
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp18_ = left_intersect;
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp17_ >= _tmp18_) {
#line 1420 "Box.c"
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp19_ = bottom_intersect;
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp20_ = top_intersect;
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp16_ = _tmp19_ >= _tmp20_;
#line 1429 "Box.c"
	} else {
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp16_ = FALSE;
#line 1433 "Box.c"
	}
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp16_;
#line 220 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 1439 "Box.c"
}


void box_get_reduced (Box *self, gint amount, Box* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Box _tmp8_ = {0};
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = amount;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).top;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = amount;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = (*self).right;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = amount;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = (*self).bottom;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = amount;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp8_, _tmp0_ + _tmp1_, _tmp2_ + _tmp3_, _tmp4_ - _tmp5_, _tmp6_ - _tmp7_);
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp8_;
#line 224 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1475 "Box.c"
}


void box_get_expanded (Box *self, gint amount, Box* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Box _tmp8_ = {0};
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = amount;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).top;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = amount;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = (*self).right;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = amount;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = (*self).bottom;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = amount;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp8_, _tmp0_ - _tmp1_, _tmp2_ - _tmp3_, _tmp4_ + _tmp5_, _tmp6_ + _tmp7_);
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp8_;
#line 228 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 1511 "Box.c"
}


gboolean box_contains (Box *self, GdkPoint* point) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkPoint _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 231 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_val_if_fail (point != NULL, FALSE);
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = *point;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = _tmp3_.x;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = (*self).left;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp4_ >= _tmp5_) {
#line 1533 "Box.c"
		GdkPoint _tmp6_ = {0};
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp6_ = *point;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp7_ = _tmp6_.x;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp8_ = (*self).right;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp2_ = _tmp7_ <= _tmp8_;
#line 1545 "Box.c"
	} else {
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp2_ = FALSE;
#line 1549 "Box.c"
	}
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp2_) {
#line 1553 "Box.c"
		GdkPoint _tmp9_ = {0};
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp9_ = *point;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp10_ = _tmp9_.y;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp11_ = (*self).top;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp1_ = _tmp10_ >= _tmp11_;
#line 1565 "Box.c"
	} else {
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp1_ = FALSE;
#line 1569 "Box.c"
	}
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp1_) {
#line 1573 "Box.c"
		GdkPoint _tmp12_ = {0};
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp12_ = *point;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp13_ = _tmp12_.y;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp14_ = (*self).bottom;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp0_ = _tmp13_ <= _tmp14_;
#line 1585 "Box.c"
	} else {
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp0_ = FALSE;
#line 1589 "Box.c"
	}
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp0_;
#line 232 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 1595 "Box.c"
}


BoxComplements box_resized_complements (Box *self, Box* resized, Box* horizontal, gboolean* horizontal_enlarged, Box* vertical, gboolean* vertical_enlarged) {
	Box _vala_horizontal = {0};
	gboolean _vala_horizontal_enlarged = FALSE;
	Box _vala_vertical = {0};
	gboolean _vala_vertical_enlarged = FALSE;
	BoxComplements result = 0;
	gboolean horizontal_complement = FALSE;
	Box _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean vertical_complement = FALSE;
	Box _tmp36_ = {0};
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_ = FALSE;
	BoxComplements _tmp74_ = 0;
#line 238 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_val_if_fail (resized != NULL, 0);
#line 241 "/home/jens/Source/shotwell/src/Box.vala"
	horizontal_complement = TRUE;
#line 242 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *resized;
#line 242 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.top;
#line 242 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).top;
#line 242 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp1_ < _tmp2_) {
#line 1628 "Box.c"
		Box _tmp3_ = {0};
		gint _tmp4_ = 0;
		Box _tmp5_ = {0};
		gint _tmp6_ = 0;
		Box _tmp7_ = {0};
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 244 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp3_ = *resized;
#line 244 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp4_ = _tmp3_.left;
#line 244 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp5_ = *resized;
#line 244 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp6_ = _tmp5_.top;
#line 244 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp7_ = *resized;
#line 244 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp8_ = _tmp7_.right;
#line 244 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp9_ = (*self).top;
#line 244 "/home/jens/Source/shotwell/src/Box.vala"
		box_init (&_vala_horizontal, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
#line 245 "/home/jens/Source/shotwell/src/Box.vala"
		_vala_horizontal_enlarged = TRUE;
#line 1654 "Box.c"
	} else {
		Box _tmp10_ = {0};
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 246 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp10_ = *resized;
#line 246 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp11_ = _tmp10_.top;
#line 246 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp12_ = (*self).top;
#line 246 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp11_ > _tmp12_) {
#line 1667 "Box.c"
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			Box _tmp16_ = {0};
			gint _tmp17_ = 0;
#line 248 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp13_ = (*self).left;
#line 248 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp14_ = (*self).top;
#line 248 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp15_ = (*self).right;
#line 248 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp16_ = *resized;
#line 248 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp17_ = _tmp16_.top;
#line 248 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_horizontal, _tmp13_, _tmp14_, _tmp15_, _tmp17_);
#line 249 "/home/jens/Source/shotwell/src/Box.vala"
			_vala_horizontal_enlarged = FALSE;
#line 1687 "Box.c"
		} else {
			Box _tmp18_ = {0};
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 250 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp18_ = *resized;
#line 250 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp19_ = _tmp18_.bottom;
#line 250 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp20_ = (*self).bottom;
#line 250 "/home/jens/Source/shotwell/src/Box.vala"
			if (_tmp19_ < _tmp20_) {
#line 1700 "Box.c"
				gint _tmp21_ = 0;
				Box _tmp22_ = {0};
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
#line 252 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp21_ = (*self).left;
#line 252 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp22_ = *resized;
#line 252 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp23_ = _tmp22_.bottom;
#line 252 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp24_ = (*self).right;
#line 252 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp25_ = (*self).bottom;
#line 252 "/home/jens/Source/shotwell/src/Box.vala"
				box_init (&_vala_horizontal, _tmp21_, _tmp23_, _tmp24_, _tmp25_);
#line 253 "/home/jens/Source/shotwell/src/Box.vala"
				_vala_horizontal_enlarged = FALSE;
#line 1720 "Box.c"
			} else {
				Box _tmp26_ = {0};
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
#line 254 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp26_ = *resized;
#line 254 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp27_ = _tmp26_.bottom;
#line 254 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp28_ = (*self).bottom;
#line 254 "/home/jens/Source/shotwell/src/Box.vala"
				if (_tmp27_ > _tmp28_) {
#line 1733 "Box.c"
					Box _tmp29_ = {0};
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					Box _tmp32_ = {0};
					gint _tmp33_ = 0;
					Box _tmp34_ = {0};
					gint _tmp35_ = 0;
#line 256 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp29_ = *resized;
#line 256 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp30_ = _tmp29_.left;
#line 256 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp31_ = (*self).bottom;
#line 256 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp32_ = *resized;
#line 256 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp33_ = _tmp32_.right;
#line 256 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp34_ = *resized;
#line 256 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp35_ = _tmp34_.bottom;
#line 256 "/home/jens/Source/shotwell/src/Box.vala"
					box_init (&_vala_horizontal, _tmp30_, _tmp31_, _tmp33_, _tmp35_);
#line 257 "/home/jens/Source/shotwell/src/Box.vala"
					_vala_horizontal_enlarged = TRUE;
#line 1759 "Box.c"
				} else {
#line 259 "/home/jens/Source/shotwell/src/Box.vala"
					box_init (&_vala_horizontal, 0, 0, 0, 0);
#line 260 "/home/jens/Source/shotwell/src/Box.vala"
					_vala_horizontal_enlarged = FALSE;
#line 261 "/home/jens/Source/shotwell/src/Box.vala"
					horizontal_complement = FALSE;
#line 1767 "Box.c"
				}
			}
		}
	}
#line 264 "/home/jens/Source/shotwell/src/Box.vala"
	vertical_complement = TRUE;
#line 265 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp36_ = *resized;
#line 265 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp37_ = _tmp36_.left;
#line 265 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp38_ = (*self).left;
#line 265 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp37_ < _tmp38_) {
#line 1782 "Box.c"
		Box _tmp39_ = {0};
		gint _tmp40_ = 0;
		Box _tmp41_ = {0};
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Box _tmp44_ = {0};
		gint _tmp45_ = 0;
#line 267 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp39_ = *resized;
#line 267 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp40_ = _tmp39_.left;
#line 267 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp41_ = *resized;
#line 267 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp42_ = _tmp41_.top;
#line 267 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp43_ = (*self).left;
#line 267 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp44_ = *resized;
#line 267 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp45_ = _tmp44_.bottom;
#line 267 "/home/jens/Source/shotwell/src/Box.vala"
		box_init (&_vala_vertical, _tmp40_, _tmp42_, _tmp43_, _tmp45_);
#line 268 "/home/jens/Source/shotwell/src/Box.vala"
		_vala_vertical_enlarged = TRUE;
#line 1808 "Box.c"
	} else {
		Box _tmp46_ = {0};
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 269 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp46_ = *resized;
#line 269 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp47_ = _tmp46_.left;
#line 269 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp48_ = (*self).left;
#line 269 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp47_ > _tmp48_) {
#line 1821 "Box.c"
			gint _tmp49_ = 0;
			gint _tmp50_ = 0;
			Box _tmp51_ = {0};
			gint _tmp52_ = 0;
			gint _tmp53_ = 0;
#line 271 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp49_ = (*self).left;
#line 271 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp50_ = (*self).top;
#line 271 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp51_ = *resized;
#line 271 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp52_ = _tmp51_.left;
#line 271 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp53_ = (*self).bottom;
#line 271 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_vertical, _tmp49_, _tmp50_, _tmp52_, _tmp53_);
#line 272 "/home/jens/Source/shotwell/src/Box.vala"
			_vala_vertical_enlarged = FALSE;
#line 1841 "Box.c"
		} else {
			Box _tmp54_ = {0};
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
#line 273 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp54_ = *resized;
#line 273 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp55_ = _tmp54_.right;
#line 273 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp56_ = (*self).right;
#line 273 "/home/jens/Source/shotwell/src/Box.vala"
			if (_tmp55_ < _tmp56_) {
#line 1854 "Box.c"
				Box _tmp57_ = {0};
				gint _tmp58_ = 0;
				gint _tmp59_ = 0;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
#line 275 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp57_ = *resized;
#line 275 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp58_ = _tmp57_.right;
#line 275 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp59_ = (*self).top;
#line 275 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp60_ = (*self).right;
#line 275 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp61_ = (*self).bottom;
#line 275 "/home/jens/Source/shotwell/src/Box.vala"
				box_init (&_vala_vertical, _tmp58_, _tmp59_, _tmp60_, _tmp61_);
#line 276 "/home/jens/Source/shotwell/src/Box.vala"
				_vala_vertical_enlarged = FALSE;
#line 1874 "Box.c"
			} else {
				Box _tmp62_ = {0};
				gint _tmp63_ = 0;
				gint _tmp64_ = 0;
#line 277 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp62_ = *resized;
#line 277 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp63_ = _tmp62_.right;
#line 277 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp64_ = (*self).right;
#line 277 "/home/jens/Source/shotwell/src/Box.vala"
				if (_tmp63_ > _tmp64_) {
#line 1887 "Box.c"
					gint _tmp65_ = 0;
					Box _tmp66_ = {0};
					gint _tmp67_ = 0;
					Box _tmp68_ = {0};
					gint _tmp69_ = 0;
					Box _tmp70_ = {0};
					gint _tmp71_ = 0;
#line 279 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp65_ = (*self).right;
#line 279 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp66_ = *resized;
#line 279 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp67_ = _tmp66_.top;
#line 279 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp68_ = *resized;
#line 279 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp69_ = _tmp68_.right;
#line 279 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp70_ = *resized;
#line 279 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp71_ = _tmp70_.bottom;
#line 279 "/home/jens/Source/shotwell/src/Box.vala"
					box_init (&_vala_vertical, _tmp65_, _tmp67_, _tmp69_, _tmp71_);
#line 280 "/home/jens/Source/shotwell/src/Box.vala"
					_vala_vertical_enlarged = TRUE;
#line 1913 "Box.c"
				} else {
#line 282 "/home/jens/Source/shotwell/src/Box.vala"
					box_init (&_vala_vertical, 0, 0, 0, 0);
#line 283 "/home/jens/Source/shotwell/src/Box.vala"
					_vala_vertical_enlarged = FALSE;
#line 284 "/home/jens/Source/shotwell/src/Box.vala"
					vertical_complement = FALSE;
#line 1921 "Box.c"
				}
			}
		}
	}
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp72_ = horizontal_complement;
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp73_ = vertical_complement;
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp74_ = box_complements_derive (_tmp72_, _tmp73_);
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp74_;
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	if (horizontal) {
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
		*horizontal = _vala_horizontal;
#line 1938 "Box.c"
	}
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	if (horizontal_enlarged) {
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
		*horizontal_enlarged = _vala_horizontal_enlarged;
#line 1944 "Box.c"
	}
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	if (vertical) {
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
		*vertical = _vala_vertical;
#line 1950 "Box.c"
	}
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	if (vertical_enlarged) {
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
		*vertical_enlarged = _vala_vertical_enlarged;
#line 1956 "Box.c"
	}
#line 287 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 1960 "Box.c"
}


BoxComplements box_shifted_complements (Box *self, Box* shifted, Box* horizontal_this, Box* vertical_this, Box* horizontal_shifted, Box* vertical_shifted) {
	Box _vala_horizontal_this = {0};
	Box _vala_vertical_this = {0};
	Box _vala_horizontal_shifted = {0};
	Box _vala_vertical_shifted = {0};
	BoxComplements result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean horizontal_complement = FALSE;
	gboolean _tmp4_ = FALSE;
	Box _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean vertical_complement = FALSE;
	gboolean _tmp42_ = FALSE;
	Box _tmp43_ = {0};
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	BoxComplements _tmp82_ = 0;
#line 293 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_val_if_fail (shifted != NULL, 0);
#line 295 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = box_get_width (&(*self));
#line 295 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = box_get_width (shifted);
#line 295 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_assert (_tmp0_ == _tmp1_, "get_width() == shifted.get_width()");
#line 296 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = box_get_height (&(*self));
#line 296 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = box_get_height (shifted);
#line 296 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_assert (_tmp2_ == _tmp3_, "get_height() == shifted.get_height()");
#line 298 "/home/jens/Source/shotwell/src/Box.vala"
	horizontal_complement = TRUE;
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = *shifted;
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = _tmp5_.top;
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = (*self).top;
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp6_ < _tmp7_) {
#line 2011 "Box.c"
		Box _tmp8_ = {0};
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp8_ = *shifted;
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp9_ = _tmp8_.bottom;
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp10_ = (*self).top;
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp4_ = _tmp9_ > _tmp10_;
#line 2023 "Box.c"
	} else {
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp4_ = FALSE;
#line 2027 "Box.c"
	}
#line 299 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp4_) {
#line 2031 "Box.c"
		gint _tmp11_ = 0;
		Box _tmp12_ = {0};
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		Box _tmp16_ = {0};
		gint _tmp17_ = 0;
		Box _tmp18_ = {0};
		gint _tmp19_ = 0;
		Box _tmp20_ = {0};
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
#line 301 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp11_ = (*self).left;
#line 301 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp12_ = *shifted;
#line 301 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp13_ = _tmp12_.bottom;
#line 301 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp14_ = (*self).right;
#line 301 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp15_ = (*self).bottom;
#line 301 "/home/jens/Source/shotwell/src/Box.vala"
		box_init (&_vala_horizontal_this, _tmp11_, _tmp13_, _tmp14_, _tmp15_);
#line 302 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp16_ = *shifted;
#line 302 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp17_ = _tmp16_.left;
#line 302 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp18_ = *shifted;
#line 302 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp19_ = _tmp18_.top;
#line 302 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp20_ = *shifted;
#line 302 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp21_ = _tmp20_.right;
#line 302 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp22_ = (*self).top;
#line 302 "/home/jens/Source/shotwell/src/Box.vala"
		box_init (&_vala_horizontal_shifted, _tmp17_, _tmp19_, _tmp21_, _tmp22_);
#line 2072 "Box.c"
	} else {
		gboolean _tmp23_ = FALSE;
		Box _tmp24_ = {0};
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp24_ = *shifted;
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp25_ = _tmp24_.top;
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp26_ = (*self).top;
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp25_ > _tmp26_) {
#line 2086 "Box.c"
			Box _tmp27_ = {0};
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp27_ = *shifted;
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp28_ = _tmp27_.top;
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp29_ = (*self).bottom;
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp23_ = _tmp28_ < _tmp29_;
#line 2098 "Box.c"
		} else {
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp23_ = FALSE;
#line 2102 "Box.c"
		}
#line 303 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp23_) {
#line 2106 "Box.c"
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			Box _tmp33_ = {0};
			gint _tmp34_ = 0;
			Box _tmp35_ = {0};
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			Box _tmp38_ = {0};
			gint _tmp39_ = 0;
			Box _tmp40_ = {0};
			gint _tmp41_ = 0;
#line 305 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp30_ = (*self).left;
#line 305 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp31_ = (*self).top;
#line 305 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp32_ = (*self).right;
#line 305 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp33_ = *shifted;
#line 305 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp34_ = _tmp33_.top;
#line 305 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_horizontal_this, _tmp30_, _tmp31_, _tmp32_, _tmp34_);
#line 306 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp35_ = *shifted;
#line 306 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp36_ = _tmp35_.left;
#line 306 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp37_ = (*self).bottom;
#line 306 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp38_ = *shifted;
#line 306 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp39_ = _tmp38_.right;
#line 306 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp40_ = *shifted;
#line 306 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp41_ = _tmp40_.bottom;
#line 306 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_horizontal_shifted, _tmp36_, _tmp37_, _tmp39_, _tmp41_);
#line 2147 "Box.c"
		} else {
#line 309 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_horizontal_this, 0, 0, 0, 0);
#line 310 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_horizontal_shifted, 0, 0, 0, 0);
#line 311 "/home/jens/Source/shotwell/src/Box.vala"
			horizontal_complement = FALSE;
#line 2155 "Box.c"
		}
	}
#line 314 "/home/jens/Source/shotwell/src/Box.vala"
	vertical_complement = TRUE;
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp43_ = *shifted;
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp44_ = _tmp43_.left;
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp45_ = (*self).left;
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp44_ < _tmp45_) {
#line 2168 "Box.c"
		Box _tmp46_ = {0};
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp46_ = *shifted;
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp47_ = _tmp46_.right;
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp48_ = (*self).left;
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp42_ = _tmp47_ > _tmp48_;
#line 2180 "Box.c"
	} else {
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp42_ = FALSE;
#line 2184 "Box.c"
	}
#line 315 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp42_) {
#line 2188 "Box.c"
		Box _tmp49_ = {0};
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		Box _tmp54_ = {0};
		gint _tmp55_ = 0;
		Box _tmp56_ = {0};
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		Box _tmp59_ = {0};
		gint _tmp60_ = 0;
#line 317 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp49_ = *shifted;
#line 317 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp50_ = _tmp49_.right;
#line 317 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp51_ = (*self).top;
#line 317 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp52_ = (*self).right;
#line 317 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp53_ = (*self).bottom;
#line 317 "/home/jens/Source/shotwell/src/Box.vala"
		box_init (&_vala_vertical_this, _tmp50_, _tmp51_, _tmp52_, _tmp53_);
#line 318 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp54_ = *shifted;
#line 318 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp55_ = _tmp54_.left;
#line 318 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp56_ = *shifted;
#line 318 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp57_ = _tmp56_.top;
#line 318 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp58_ = (*self).left;
#line 318 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp59_ = *shifted;
#line 318 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp60_ = _tmp59_.bottom;
#line 318 "/home/jens/Source/shotwell/src/Box.vala"
		box_init (&_vala_vertical_shifted, _tmp55_, _tmp57_, _tmp58_, _tmp60_);
#line 2229 "Box.c"
	} else {
		gboolean _tmp61_ = FALSE;
		Box _tmp62_ = {0};
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp62_ = *shifted;
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp63_ = _tmp62_.left;
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp64_ = (*self).left;
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp63_ > _tmp64_) {
#line 2243 "Box.c"
			Box _tmp65_ = {0};
			gint _tmp66_ = 0;
			gint _tmp67_ = 0;
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp65_ = *shifted;
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp66_ = _tmp65_.left;
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp67_ = (*self).right;
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp61_ = _tmp66_ < _tmp67_;
#line 2255 "Box.c"
		} else {
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp61_ = FALSE;
#line 2259 "Box.c"
		}
#line 319 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp61_) {
#line 2263 "Box.c"
			gint _tmp68_ = 0;
			gint _tmp69_ = 0;
			Box _tmp70_ = {0};
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			Box _tmp74_ = {0};
			gint _tmp75_ = 0;
			Box _tmp76_ = {0};
			gint _tmp77_ = 0;
			Box _tmp78_ = {0};
			gint _tmp79_ = 0;
#line 321 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp68_ = (*self).left;
#line 321 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp69_ = (*self).top;
#line 321 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp70_ = *shifted;
#line 321 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp71_ = _tmp70_.left;
#line 321 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp72_ = (*self).bottom;
#line 321 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_vertical_this, _tmp68_, _tmp69_, _tmp71_, _tmp72_);
#line 322 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp73_ = (*self).right;
#line 322 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp74_ = *shifted;
#line 322 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp75_ = _tmp74_.top;
#line 322 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp76_ = *shifted;
#line 322 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp77_ = _tmp76_.right;
#line 322 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp78_ = *shifted;
#line 322 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp79_ = _tmp78_.bottom;
#line 322 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_vertical_shifted, _tmp73_, _tmp75_, _tmp77_, _tmp79_);
#line 2304 "Box.c"
		} else {
#line 325 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_vertical_this, 0, 0, 0, 0);
#line 326 "/home/jens/Source/shotwell/src/Box.vala"
			box_init (&_vala_vertical_shifted, 0, 0, 0, 0);
#line 327 "/home/jens/Source/shotwell/src/Box.vala"
			vertical_complement = FALSE;
#line 2312 "Box.c"
		}
	}
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp80_ = horizontal_complement;
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp81_ = vertical_complement;
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp82_ = box_complements_derive (_tmp80_, _tmp81_);
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp82_;
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	if (horizontal_this) {
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
		*horizontal_this = _vala_horizontal_this;
#line 2327 "Box.c"
	}
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	if (vertical_this) {
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
		*vertical_this = _vala_vertical_this;
#line 2333 "Box.c"
	}
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	if (horizontal_shifted) {
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
		*horizontal_shifted = _vala_horizontal_shifted;
#line 2339 "Box.c"
	}
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	if (vertical_shifted) {
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
		*vertical_shifted = _vala_vertical_shifted;
#line 2345 "Box.c"
	}
#line 330 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 2349 "Box.c"
}


void box_rubber_band (Box *self, GdkPoint* point, Box* result) {
	GdkPoint _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkPoint _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint t = 0;
	gint _tmp4_ = 0;
	GdkPoint _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint b = 0;
	gint _tmp8_ = 0;
	GdkPoint _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint l = 0;
	gint _tmp12_ = 0;
	GdkPoint _tmp13_ = {0};
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint r = 0;
	gint _tmp16_ = 0;
	GdkPoint _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Box _tmp20_ = {0};
#line 333 "/home/jens/Source/shotwell/src/Box.vala"
	g_return_if_fail (point != NULL);
#line 334 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = *point;
#line 334 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = _tmp0_.x;
#line 334 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_assert (_tmp1_ >= 0, "point.x >= 0");
#line 335 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = *point;
#line 335 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = _tmp2_.y;
#line 335 "/home/jens/Source/shotwell/src/Box.vala"
	_vala_assert (_tmp3_ >= 0, "point.y >= 0");
#line 337 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = (*self).top;
#line 337 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = *point;
#line 337 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = _tmp5_.y;
#line 337 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = MIN (_tmp4_, _tmp6_);
#line 337 "/home/jens/Source/shotwell/src/Box.vala"
	t = _tmp7_;
#line 338 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = (*self).bottom;
#line 338 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = *point;
#line 338 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = _tmp9_.y;
#line 338 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = MAX (_tmp8_, _tmp10_);
#line 338 "/home/jens/Source/shotwell/src/Box.vala"
	b = _tmp11_;
#line 339 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp12_ = (*self).left;
#line 339 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp13_ = *point;
#line 339 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp14_ = _tmp13_.x;
#line 339 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp15_ = MIN (_tmp12_, _tmp14_);
#line 339 "/home/jens/Source/shotwell/src/Box.vala"
	l = _tmp15_;
#line 340 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp16_ = (*self).right;
#line 340 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp17_ = *point;
#line 340 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp18_ = _tmp17_.x;
#line 340 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp19_ = MAX (_tmp16_, _tmp18_);
#line 340 "/home/jens/Source/shotwell/src/Box.vala"
	r = _tmp19_;
#line 342 "/home/jens/Source/shotwell/src/Box.vala"
	box_init (&_tmp20_, l, t, r, b);
#line 342 "/home/jens/Source/shotwell/src/Box.vala"
	*result = _tmp20_;
#line 342 "/home/jens/Source/shotwell/src/Box.vala"
	return;
#line 2439 "Box.c"
}


gchar* box_to_string (Box *self) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Dimensions _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = (*self).left;
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).top;
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).right;
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = (*self).bottom;
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	box_get_dimensions (&(*self), &_tmp4_);
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = dimensions_to_string (&_tmp4_);
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = _tmp5_;
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = g_strdup_printf ("%d,%d %d,%d (%s)", _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp6_);
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp8_ = _tmp7_;
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	_g_free0 (_tmp6_);
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp8_;
#line 346 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 2478 "Box.c"
}


static gboolean box_in_zone (gdouble pos, gint zone) {
	gboolean result = FALSE;
	gint top_zone = 0;
	gint _tmp0_ = 0;
	gint bottom_zone = 0;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_ = FALSE;
#line 350 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = zone;
#line 350 "/home/jens/Source/shotwell/src/Box.vala"
	top_zone = _tmp0_ - BOX_HAND_GRENADES;
#line 351 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = zone;
#line 351 "/home/jens/Source/shotwell/src/Box.vala"
	bottom_zone = _tmp1_ + BOX_HAND_GRENADES;
#line 353 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = pos;
#line 353 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = box_in_between (_tmp2_, top_zone, bottom_zone);
#line 353 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp3_;
#line 353 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 2506 "Box.c"
}


static gboolean box_in_between (gdouble pos, gint top, gint bottom) {
	gboolean result = FALSE;
	gint ipos = 0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 357 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = pos;
#line 357 "/home/jens/Source/shotwell/src/Box.vala"
	ipos = (gint) _tmp0_;
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = ipos;
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = top;
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp2_ > _tmp3_) {
#line 2527 "Box.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp4_ = ipos;
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp5_ = bottom;
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp1_ = _tmp4_ < _tmp5_;
#line 2536 "Box.c"
	} else {
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp1_ = FALSE;
#line 2540 "Box.c"
	}
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp1_;
#line 359 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 2546 "Box.c"
}


static gboolean box_near_in_between (gdouble pos, gint top, gint bottom) {
	gboolean result = FALSE;
	gint ipos = 0;
	gdouble _tmp0_ = 0.0;
	gint top_zone = 0;
	gint _tmp1_ = 0;
	gint bottom_zone = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 363 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = pos;
#line 363 "/home/jens/Source/shotwell/src/Box.vala"
	ipos = (gint) _tmp0_;
#line 364 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = top;
#line 364 "/home/jens/Source/shotwell/src/Box.vala"
	top_zone = _tmp1_ - BOX_HAND_GRENADES;
#line 365 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = bottom;
#line 365 "/home/jens/Source/shotwell/src/Box.vala"
	bottom_zone = _tmp2_ + BOX_HAND_GRENADES;
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = ipos;
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = top_zone;
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp4_ > _tmp5_) {
#line 2579 "Box.c"
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp6_ = ipos;
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp7_ = bottom_zone;
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp3_ = _tmp6_ < _tmp7_;
#line 2588 "Box.c"
	} else {
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp3_ = FALSE;
#line 2592 "Box.c"
	}
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
	result = _tmp3_;
#line 367 "/home/jens/Source/shotwell/src/Box.vala"
	return result;
#line 2598 "Box.c"
}


BoxLocation box_approx_location (Box *self, gint x, gint y) {
	BoxLocation result = 0;
	gboolean near_width = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean near_height = FALSE;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
#line 371 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp0_ = x;
#line 371 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp1_ = (*self).left;
#line 371 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp2_ = (*self).right;
#line 371 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp3_ = box_near_in_between ((gdouble) _tmp0_, _tmp1_, _tmp2_);
#line 371 "/home/jens/Source/shotwell/src/Box.vala"
	near_width = _tmp3_;
#line 372 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp4_ = y;
#line 372 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp5_ = (*self).top;
#line 372 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp6_ = (*self).bottom;
#line 372 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp7_ = box_near_in_between ((gdouble) _tmp4_, _tmp5_, _tmp6_);
#line 372 "/home/jens/Source/shotwell/src/Box.vala"
	near_height = _tmp7_;
#line 374 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp9_ = x;
#line 374 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp10_ = (*self).left;
#line 374 "/home/jens/Source/shotwell/src/Box.vala"
	_tmp11_ = box_in_zone ((gdouble) _tmp9_, _tmp10_);
#line 374 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp11_) {
#line 2646 "Box.c"
		gboolean _tmp12_ = FALSE;
#line 374 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp12_ = near_height;
#line 374 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp8_ = _tmp12_;
#line 2652 "Box.c"
	} else {
#line 374 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp8_ = FALSE;
#line 2656 "Box.c"
	}
#line 374 "/home/jens/Source/shotwell/src/Box.vala"
	if (_tmp8_) {
#line 2660 "Box.c"
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
#line 375 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp13_ = y;
#line 375 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp14_ = (*self).top;
#line 375 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp15_ = box_in_zone ((gdouble) _tmp13_, _tmp14_);
#line 375 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp15_) {
#line 376 "/home/jens/Source/shotwell/src/Box.vala"
			result = BOX_LOCATION_TOP_LEFT;
#line 376 "/home/jens/Source/shotwell/src/Box.vala"
			return result;
#line 2676 "Box.c"
		} else {
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gboolean _tmp18_ = FALSE;
#line 377 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp16_ = y;
#line 377 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp17_ = (*self).bottom;
#line 377 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp18_ = box_in_zone ((gdouble) _tmp16_, _tmp17_);
#line 377 "/home/jens/Source/shotwell/src/Box.vala"
			if (_tmp18_) {
#line 378 "/home/jens/Source/shotwell/src/Box.vala"
				result = BOX_LOCATION_BOTTOM_LEFT;
#line 378 "/home/jens/Source/shotwell/src/Box.vala"
				return result;
#line 2693 "Box.c"
			} else {
#line 380 "/home/jens/Source/shotwell/src/Box.vala"
				result = BOX_LOCATION_LEFT_SIDE;
#line 380 "/home/jens/Source/shotwell/src/Box.vala"
				return result;
#line 2699 "Box.c"
			}
		}
	} else {
		gboolean _tmp19_ = FALSE;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gboolean _tmp22_ = FALSE;
#line 382 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp20_ = x;
#line 382 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp21_ = (*self).right;
#line 382 "/home/jens/Source/shotwell/src/Box.vala"
		_tmp22_ = box_in_zone ((gdouble) _tmp20_, _tmp21_);
#line 382 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp22_) {
#line 2715 "Box.c"
			gboolean _tmp23_ = FALSE;
#line 382 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp23_ = near_height;
#line 382 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp19_ = _tmp23_;
#line 2721 "Box.c"
		} else {
#line 382 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp19_ = FALSE;
#line 2725 "Box.c"
		}
#line 382 "/home/jens/Source/shotwell/src/Box.vala"
		if (_tmp19_) {
#line 2729 "Box.c"
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gboolean _tmp26_ = FALSE;
#line 383 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp24_ = y;
#line 383 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp25_ = (*self).top;
#line 383 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp26_ = box_in_zone ((gdouble) _tmp24_, _tmp25_);
#line 383 "/home/jens/Source/shotwell/src/Box.vala"
			if (_tmp26_) {
#line 384 "/home/jens/Source/shotwell/src/Box.vala"
				result = BOX_LOCATION_TOP_RIGHT;
#line 384 "/home/jens/Source/shotwell/src/Box.vala"
				return result;
#line 2745 "Box.c"
			} else {
				gint _tmp27_ = 0;
				gint _tmp28_ = 0;
				gboolean _tmp29_ = FALSE;
#line 385 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp27_ = y;
#line 385 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp28_ = (*self).bottom;
#line 385 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp29_ = box_in_zone ((gdouble) _tmp27_, _tmp28_);
#line 385 "/home/jens/Source/shotwell/src/Box.vala"
				if (_tmp29_) {
#line 386 "/home/jens/Source/shotwell/src/Box.vala"
					result = BOX_LOCATION_BOTTOM_RIGHT;
#line 386 "/home/jens/Source/shotwell/src/Box.vala"
					return result;
#line 2762 "Box.c"
				} else {
#line 388 "/home/jens/Source/shotwell/src/Box.vala"
					result = BOX_LOCATION_RIGHT_SIDE;
#line 388 "/home/jens/Source/shotwell/src/Box.vala"
					return result;
#line 2768 "Box.c"
				}
			}
		} else {
			gboolean _tmp30_ = FALSE;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gboolean _tmp33_ = FALSE;
#line 390 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp31_ = y;
#line 390 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp32_ = (*self).top;
#line 390 "/home/jens/Source/shotwell/src/Box.vala"
			_tmp33_ = box_in_zone ((gdouble) _tmp31_, _tmp32_);
#line 390 "/home/jens/Source/shotwell/src/Box.vala"
			if (_tmp33_) {
#line 2784 "Box.c"
				gboolean _tmp34_ = FALSE;
#line 390 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp34_ = near_width;
#line 390 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp30_ = _tmp34_;
#line 2790 "Box.c"
			} else {
#line 390 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp30_ = FALSE;
#line 2794 "Box.c"
			}
#line 390 "/home/jens/Source/shotwell/src/Box.vala"
			if (_tmp30_) {
#line 392 "/home/jens/Source/shotwell/src/Box.vala"
				result = BOX_LOCATION_TOP_SIDE;
#line 392 "/home/jens/Source/shotwell/src/Box.vala"
				return result;
#line 2802 "Box.c"
			} else {
				gboolean _tmp35_ = FALSE;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				gboolean _tmp38_ = FALSE;
#line 393 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp36_ = y;
#line 393 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp37_ = (*self).bottom;
#line 393 "/home/jens/Source/shotwell/src/Box.vala"
				_tmp38_ = box_in_zone ((gdouble) _tmp36_, _tmp37_);
#line 393 "/home/jens/Source/shotwell/src/Box.vala"
				if (_tmp38_) {
#line 2816 "Box.c"
					gboolean _tmp39_ = FALSE;
#line 393 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp39_ = near_width;
#line 393 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp35_ = _tmp39_;
#line 2822 "Box.c"
				} else {
#line 393 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp35_ = FALSE;
#line 2826 "Box.c"
				}
#line 393 "/home/jens/Source/shotwell/src/Box.vala"
				if (_tmp35_) {
#line 395 "/home/jens/Source/shotwell/src/Box.vala"
					result = BOX_LOCATION_BOTTOM_SIDE;
#line 395 "/home/jens/Source/shotwell/src/Box.vala"
					return result;
#line 2834 "Box.c"
				} else {
					gboolean _tmp40_ = FALSE;
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					gboolean _tmp44_ = FALSE;
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp41_ = x;
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp42_ = (*self).left;
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp43_ = (*self).right;
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
					_tmp44_ = box_in_between ((gdouble) _tmp41_, _tmp42_, _tmp43_);
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
					if (_tmp44_) {
#line 2851 "Box.c"
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						gint _tmp47_ = 0;
						gboolean _tmp48_ = FALSE;
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
						_tmp45_ = y;
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
						_tmp46_ = (*self).top;
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
						_tmp47_ = (*self).bottom;
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
						_tmp48_ = box_in_between ((gdouble) _tmp45_, _tmp46_, _tmp47_);
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
						_tmp40_ = _tmp48_;
#line 2866 "Box.c"
					} else {
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
						_tmp40_ = FALSE;
#line 2870 "Box.c"
					}
#line 396 "/home/jens/Source/shotwell/src/Box.vala"
					if (_tmp40_) {
#line 397 "/home/jens/Source/shotwell/src/Box.vala"
						result = BOX_LOCATION_INSIDE;
#line 397 "/home/jens/Source/shotwell/src/Box.vala"
						return result;
#line 2878 "Box.c"
					} else {
#line 399 "/home/jens/Source/shotwell/src/Box.vala"
						result = BOX_LOCATION_OUTSIDE;
#line 399 "/home/jens/Source/shotwell/src/Box.vala"
						return result;
#line 2884 "Box.c"
					}
				}
			}
		}
	}
}


Box* box_dup (const Box* self) {
	Box* dup;
#line 38 "/home/jens/Source/shotwell/src/Box.vala"
	dup = g_new0 (Box, 1);
#line 38 "/home/jens/Source/shotwell/src/Box.vala"
	memcpy (dup, self, sizeof (Box));
#line 38 "/home/jens/Source/shotwell/src/Box.vala"
	return dup;
#line 2901 "Box.c"
}


void box_free (Box* self) {
#line 38 "/home/jens/Source/shotwell/src/Box.vala"
	g_free (self);
#line 2908 "Box.c"
}


GType box_get_type (void) {
	static volatile gsize box_type_id__volatile = 0;
	if (g_once_init_enter (&box_type_id__volatile)) {
		GType box_type_id;
		box_type_id = g_boxed_type_register_static ("Box", (GBoxedCopyFunc) box_dup, (GBoxedFreeFunc) box_free);
		g_once_init_leave (&box_type_id__volatile, box_type_id);
	}
	return box_type_id__volatile;
}



