Summary: GNOME2 interface for gnupg
Name: seahorse
Version: 0.7.4
Release: 0
License: GPL
Group: User Interface/Desktop
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
Seahorse is a gnome2 interface for gnupg.
It uses gpgme as the backend.

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall
%find_lang seahorse
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL
[ "$RPM_BUILD_ROOT" != "/" ] &&  rm -rf ${RPM_BUILD_ROOT}/var/scrollkeeper

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/%{name}.schemas
scrollkeeper-update
update-mime-database %{_datadir}/mime/ > /dev/null

%postun
scrollkeeper-update
update-mime-database %{_datadir}/mime/ > /dev/null

%files -f %{name}.lang
%defattr(-, root, root)
%{_bindir}/*
%{_libdir}/bonobo/*.so
%{_libdir}/bonobo/servers/*
%{_libdir}/gedit-2/plugins/*.so
%{_libdir}/gedit-2/plugins/*.gedit-plugin
%{_libexecdir}/*
%{_datadir}/%{name}
%{_datadir}/applications/*
%{_datadir}/omf/%{name}
%{_datadir}/pixmaps/*
%{_datadir}/gnome/help/%{name}
%{_datadir}/control-center-2.0/capplets/*
%{_datadir}/mime/packages/*
%{_datadir}/mime-info/*
%{_sysconfdir}/gconf/schemas/*

%doc AUTHORS COPYING NEWS README TODO

%changelog
* Wed Oct 13 2004 Nate Nielsen <nielsen@memberwebs.com>
- Added new mime info 

* Tue Oct 12 2004 Nate Nielsen <nielsen@memberwebs.com>
- Added the gedit plugin to the default manifest

* Fri May 02 2003 Yanko Kaneti <yaneti@declera.com>
- Add some new files to the manifest

* Wed Jan 15 2002 Jean Schurger <yshark@schurger.org>
- Scrollkeeper stuff
- locales install by %find_lang
- secure use of rm -rf

* Tue Jan 14 2002 Yanko Kaneti <yaneti@declera.com>
- First spec
