/*
 * Text manipulation plugin
 *
 * Author:
 *   JP Rosevear (jpr@arcavia.com)
 */

#include <libscaffold/libscaffold.h>

#include <bonobo/bonobo-i18n.h>
#include <libgnomeui/gnome-dialog.h>

#include "text-replace.h"

static void
_edit_repl_tab_spaces(
	gchar*				str,
	gpointer			data
)
{
	ScaffoldTool*			tool = (ScaffoldTool*)data;
	gint				i;
	gchar*				c;
	glong				tabsize;
	gint				column = 1;
	gchar*				filler;
	gint				numspaces;

	if(!str || scaffold_is_empty_string (str))
	{
		return;
	}

	tabsize = atol(str);

	for(i = 1; i <= scaffold_get_document_length(tool); i++)
	{
		c = scaffold_get_document_chars(tool, i - 1, i);
		if(*c == '\n')
		{
			column = 1;
		}
		else if(*c == '\t')
		{
			scaffold_delete_text(tool, i - 1, i);
			numspaces = ((column + tabsize - 1) / tabsize) *
				tabsize + 1 - column;

			filler = g_strnfill(numspaces, ' ');
			scaffold_insert_text_at_pos(tool, i - 1, filler);
			g_free(filler);

			i += numspaces - 1;
			column += numspaces;
		}
		else
		{
			column++;
		}
		g_free(c);
	}
}

void
text_replace_tab_spaces(
	GtkWidget*			widget,
	gpointer			data
)
{
	ScaffoldTool*			tool = (ScaffoldTool*)data;
	GtkWidget*			dlg;
	gint				spaces;
	gchar*				spacetext;

#if 0
	spaces = gI_text_default_tab_width(state->document);
#else
	spaces = 8;
#endif

	spacetext = g_strdup_printf("%d", spaces);
	dlg = gnome_request_dialog(FALSE, _("Number of spaces per TAB?"),
		spacetext, 3, _edit_repl_tab_spaces, tool, NULL);
	g_free(spacetext);

	gnome_dialog_run_and_close(GNOME_DIALOG(dlg));
}
