/* rygel-source-connection-manager.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-source-connection-manager.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <gst/gst.h>
#include <libgupnp-dlna/gupnp-dlna-discoverer.h>
#include <libgupnp-dlna/gupnp-dlna-profile.h>
#include <gio/gio.h>


#define RYGEL_TYPE_CONNECTION_MANAGER (rygel_connection_manager_get_type ())
#define RYGEL_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManager))
#define RYGEL_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManagerClass))
#define RYGEL_IS_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONNECTION_MANAGER))
#define RYGEL_IS_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONNECTION_MANAGER))
#define RYGEL_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONNECTION_MANAGER, RygelConnectionManagerClass))

typedef struct _RygelConnectionManager RygelConnectionManager;
typedef struct _RygelConnectionManagerClass RygelConnectionManagerClass;
typedef struct _RygelConnectionManagerPrivate RygelConnectionManagerPrivate;

#define RYGEL_TYPE_SOURCE_CONNECTION_MANAGER (rygel_source_connection_manager_get_type ())
#define RYGEL_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManager))
#define RYGEL_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_IS_SOURCE_CONNECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER))
#define RYGEL_SOURCE_CONNECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SOURCE_CONNECTION_MANAGER, RygelSourceConnectionManagerClass))

typedef struct _RygelSourceConnectionManager RygelSourceConnectionManager;
typedef struct _RygelSourceConnectionManagerClass RygelSourceConnectionManagerClass;
typedef struct _RygelSourceConnectionManagerPrivate RygelSourceConnectionManagerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_ROOT_DEVICE (rygel_root_device_get_type ())
#define RYGEL_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDevice))
#define RYGEL_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))
#define RYGEL_IS_ROOT_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_IS_ROOT_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ROOT_DEVICE))
#define RYGEL_ROOT_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ROOT_DEVICE, RygelRootDeviceClass))

typedef struct _RygelRootDevice RygelRootDevice;
typedef struct _RygelRootDeviceClass RygelRootDeviceClass;
typedef struct _RygelRootDevicePrivate RygelRootDevicePrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

struct _RygelConnectionManager {
	GUPnPService parent_instance;
	RygelConnectionManagerPrivate * priv;
	gchar* sink_protocol_info;
	gchar* connection_ids;
	gchar* source_protocol_info;
	gint rcs_id;
	gint av_transport_id;
	gchar* direction;
};

struct _RygelConnectionManagerClass {
	GUPnPServiceClass parent_class;
};

struct _RygelSourceConnectionManager {
	RygelConnectionManager parent_instance;
	RygelSourceConnectionManagerPrivate * priv;
};

struct _RygelSourceConnectionManagerClass {
	RygelConnectionManagerClass parent_class;
};

struct _RygelRootDevice {
	GUPnPRootDevice parent_instance;
	RygelRootDevicePrivate * priv;
	GeeArrayList* services;
};

struct _RygelRootDeviceClass {
	GUPnPRootDeviceClass parent_class;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};


static gpointer rygel_source_connection_manager_parent_class = NULL;

GType rygel_connection_manager_get_type (void) G_GNUC_CONST;
GType rygel_source_connection_manager_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SOURCE_CONNECTION_MANAGER_DUMMY_PROPERTY
};
static void rygel_source_connection_manager_real_constructed (GObject* base);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
static RygelHTTPServer* rygel_source_connection_manager_get_http_server (RygelSourceConnectionManager* self);
GeeArrayList* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
GType rygel_root_device_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
RygelSourceConnectionManager* rygel_source_connection_manager_new (void);
RygelSourceConnectionManager* rygel_source_connection_manager_construct (GType object_type);
RygelConnectionManager* rygel_connection_manager_new (void);
RygelConnectionManager* rygel_connection_manager_construct (GType object_type);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_source_connection_manager_real_constructed (GObject* base) {
	RygelSourceConnectionManager * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	RygelHTTPServer* _tmp2_ = NULL;
	RygelHTTPServer* server;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* protocol_infos;
	GUPnPDLNADiscoverer* _tmp4_ = NULL;
	GUPnPDLNADiscoverer* discoverer;
	gchar* _tmp5_ = NULL;
	gchar* protocol;
	GList* _tmp6_ = NULL;
	self = (RygelSourceConnectionManager*) base;
	G_OBJECT_CLASS (rygel_source_connection_manager_parent_class)->constructed ((GObject*) RYGEL_CONNECTION_MANAGER (self));
	((RygelConnectionManager*) self)->rcs_id = -1;
	((RygelConnectionManager*) self)->av_transport_id = -1;
	_tmp0_ = g_strdup ("Output");
	_tmp1_ = _tmp0_;
	_g_free0 (((RygelConnectionManager*) self)->direction);
	((RygelConnectionManager*) self)->direction = _tmp1_;
	_tmp2_ = rygel_source_connection_manager_get_http_server (self);
	server = _tmp2_;
	_tmp3_ = rygel_transcode_manager_get_protocol_info ((RygelTranscodeManager*) server);
	protocol_infos = _tmp3_;
	_tmp4_ = gupnp_dlna_discoverer_new ((GstClockTime) GST_SECOND, TRUE, FALSE);
	discoverer = _tmp4_;
	_tmp5_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) server);
	protocol = _tmp5_;
	_tmp6_ = gupnp_dlna_discoverer_list_profiles (discoverer);
	{
		GList* profile_collection;
		GList* profile_it;
		profile_collection = _tmp6_;
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
			GUPnPDLNAProfile* profile;
			profile = (GUPnPDLNAProfile*) profile_it->data;
			{
				GUPnPProtocolInfo* _tmp7_ = NULL;
				GUPnPProtocolInfo* protocol_info;
				const gchar* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_;
				_tmp7_ = gupnp_protocol_info_new ();
				protocol_info = _tmp7_;
				gupnp_protocol_info_set_protocol (protocol_info, protocol);
				_tmp8_ = gupnp_dlna_profile_get_mime (profile);
				gupnp_protocol_info_set_mime_type (protocol_info, _tmp8_);
				_tmp9_ = gupnp_dlna_profile_get_name (profile);
				gupnp_protocol_info_set_dlna_profile (protocol_info, _tmp9_);
				_tmp10_ = gee_abstract_collection_contains ((GeeAbstractCollection*) protocol_infos, protocol_info);
				if (!_tmp10_) {
					gee_abstract_list_insert ((GeeAbstractList*) protocol_infos, 0, protocol_info);
				}
				_g_object_unref0 (protocol_info);
			}
		}
	}
	{
		GeeArrayList* _tmp11_;
		GeeArrayList* _protocol_info_list;
		gint _tmp12_;
		gint _protocol_info_size;
		gint _protocol_info_index;
		_tmp11_ = _g_object_ref0 (protocol_infos);
		_protocol_info_list = _tmp11_;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _protocol_info_list);
		_protocol_info_size = _tmp12_;
		_protocol_info_index = -1;
		while (TRUE) {
			gpointer _tmp13_ = NULL;
			GUPnPProtocolInfo* protocol_info;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_protocol_info_index = _protocol_info_index + 1;
			if (!(_protocol_info_index < _protocol_info_size)) {
				break;
			}
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _protocol_info_list, _protocol_info_index);
			protocol_info = (GUPnPProtocolInfo*) _tmp13_;
			if (g_strcmp0 (((RygelConnectionManager*) self)->source_protocol_info, "") != 0) {
				gchar* _tmp14_;
				_tmp14_ = g_strconcat (((RygelConnectionManager*) self)->source_protocol_info, ",", NULL);
				_g_free0 (((RygelConnectionManager*) self)->source_protocol_info);
				((RygelConnectionManager*) self)->source_protocol_info = _tmp14_;
			}
			_tmp15_ = gupnp_protocol_info_to_string (protocol_info);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strconcat (((RygelConnectionManager*) self)->source_protocol_info, _tmp16_, NULL);
			_g_free0 (((RygelConnectionManager*) self)->source_protocol_info);
			((RygelConnectionManager*) self)->source_protocol_info = _tmp17_;
			_g_free0 (_tmp16_);
			_g_object_unref0 (protocol_info);
		}
		_g_object_unref0 (_protocol_info_list);
	}
	_g_free0 (protocol);
	_g_object_unref0 (discoverer);
	_g_object_unref0 (protocol_infos);
	_g_object_unref0 (server);
}


static RygelHTTPServer* rygel_source_connection_manager_get_http_server (RygelSourceConnectionManager* self) {
	RygelHTTPServer* result = NULL;
	RygelHTTPServer* server;
	GUPnPRootDevice* _tmp0_ = NULL;
	RygelRootDevice* root_device;
	g_return_val_if_fail (self != NULL, NULL);
	server = NULL;
	root_device = RYGEL_ROOT_DEVICE ((g_object_get ((GUPnPService*) self, "root-device", &_tmp0_, NULL), _tmp0_));
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _service_list;
		gint _tmp2_;
		gint _service_size;
		gint _service_index;
		_tmp1_ = _g_object_ref0 (root_device->services);
		_service_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _service_list);
		_service_size = _tmp2_;
		_service_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			GUPnPServiceInfo* service;
			GType _tmp4_;
			gboolean _tmp5_;
			_service_index = _service_index + 1;
			if (!(_service_index < _service_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _service_list, _service_index);
			service = (GUPnPServiceInfo*) _tmp3_;
			_tmp4_ = G_TYPE_FROM_INSTANCE ((GObject*) service);
			_tmp5_ = g_type_is_a (_tmp4_, RYGEL_TYPE_CONTENT_DIRECTORY);
			if (_tmp5_) {
				RygelContentDirectory* _tmp6_;
				RygelContentDirectory* content_directory;
				RygelHTTPServer* _tmp7_;
				RygelHTTPServer* _tmp8_;
				_tmp6_ = _g_object_ref0 (RYGEL_CONTENT_DIRECTORY (service));
				content_directory = _tmp6_;
				_tmp7_ = _g_object_ref0 (content_directory->http_server);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (server);
				server = _tmp8_;
				_g_object_unref0 (content_directory);
			}
			_g_object_unref0 (service);
		}
		_g_object_unref0 (_service_list);
	}
	result = server;
	_g_object_unref0 (root_device);
	return result;
}


RygelSourceConnectionManager* rygel_source_connection_manager_construct (GType object_type) {
	RygelSourceConnectionManager * self = NULL;
	self = (RygelSourceConnectionManager*) rygel_connection_manager_construct (object_type);
	return self;
}


RygelSourceConnectionManager* rygel_source_connection_manager_new (void) {
	return rygel_source_connection_manager_construct (RYGEL_TYPE_SOURCE_CONNECTION_MANAGER);
}


static void rygel_source_connection_manager_class_init (RygelSourceConnectionManagerClass * klass) {
	rygel_source_connection_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructed = rygel_source_connection_manager_real_constructed;
}


static void rygel_source_connection_manager_instance_init (RygelSourceConnectionManager * self) {
}


/**
 * UPnP ConnectionManager service for serving end-points (MediaServer).
 */
GType rygel_source_connection_manager_get_type (void) {
	static volatile gsize rygel_source_connection_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_source_connection_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSourceConnectionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_source_connection_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSourceConnectionManager), 0, (GInstanceInitFunc) rygel_source_connection_manager_instance_init, NULL };
		GType rygel_source_connection_manager_type_id;
		rygel_source_connection_manager_type_id = g_type_register_static (RYGEL_TYPE_CONNECTION_MANAGER, "RygelSourceConnectionManager", &g_define_type_info, 0);
		g_once_init_leave (&rygel_source_connection_manager_type_id__volatile, rygel_source_connection_manager_type_id);
	}
	return rygel_source_connection_manager_type_id__volatile;
}



