/* rygel-playbin-player.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-playbin-player.vala, do not modify */

/*
 * Copyright (C) 2008 OpenedHand Ltd.
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Jorn Baayen <jorn@openedhand.com>
 *         Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_PLAYBIN_TYPE_PLAYER (rygel_playbin_player_get_type ())
#define RYGEL_PLAYBIN_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayer))
#define RYGEL_PLAYBIN_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))
#define RYGEL_PLAYBIN_IS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_IS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_PLAYBIN_TYPE_PLAYER))
#define RYGEL_PLAYBIN_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerClass))

typedef struct _RygelPlaybinPlayer RygelPlaybinPlayer;
typedef struct _RygelPlaybinPlayerClass RygelPlaybinPlayerClass;
typedef struct _RygelPlaybinPlayerPrivate RygelPlaybinPlayerPrivate;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelPlaybinPlayer {
	GObject parent_instance;
	RygelPlaybinPlayerPrivate * priv;
};

struct _RygelPlaybinPlayerClass {
	GObjectClass parent_class;
};

struct _RygelPlaybinPlayerPrivate {
	GstElement* playbin;
	gchar* _playback_state;
};


static gpointer rygel_playbin_player_parent_class = NULL;
static RygelPlaybinPlayer* rygel_playbin_player_player;
static RygelPlaybinPlayer* rygel_playbin_player_player = NULL;
static RygelMediaPlayerIface* rygel_playbin_player_rygel_media_player_parent_iface = NULL;

GType rygel_playbin_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYBIN_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_PLAYBIN_TYPE_PLAYER, RygelPlaybinPlayerPrivate))
enum  {
	RYGEL_PLAYBIN_PLAYER_DUMMY_PROPERTY,
	RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE,
	RYGEL_PLAYBIN_PLAYER_URI,
	RYGEL_PLAYBIN_PLAYER_VOLUME,
	RYGEL_PLAYBIN_PLAYER_DURATION,
	RYGEL_PLAYBIN_PLAYER_POSITION
};
static RygelPlaybinPlayer* rygel_playbin_player_new (void);
static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type);
static gboolean rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_playbin_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
RygelPlaybinPlayer* rygel_playbin_player_get_default (void);
static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, GstClockTime time);
static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
static inline gchar* _dynamic_get_uri0 (GstElement* obj);
static inline void _dynamic_set_uri1 (GstElement* obj, const gchar* value);
static inline gdouble _dynamic_get_volume2 (GstElement* obj);
static inline void _dynamic_set_volume3 (GstElement* obj, gdouble value);
static void rygel_playbin_player_finalize (GObject* obj);
static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* RYGEL_PLAYBIN_PLAYER_protocols[2] = {"http-get", "rtsp"};
static const gchar* RYGEL_PLAYBIN_PLAYER_mime_types[26] = {"audio/mpeg", "application/ogg", "audio/x-vorbis", "audio/x-vorbis+ogg", "audio/x-ms-wma", "audio/x-ms-asf", "audio/x-flac", "audio/x-mod", "audio/x-wav", "audio/x-ac3", "audio/x-m4a", "video/x-theora", "video/x-dirac", "video/x-wmv", "video/x-wma", "video/x-msvideo", "video/x-3ivx", "video/x-3ivx", "video/x-matroska", "video/mpeg", "video/mp4", "video/x-ms-asf", "video/x-xvid", "video/x-ms-wmv", "audio/L16;rate=44100;channels=2", "audio/L16;rate=44100;channels=1"};

static gboolean _rygel_playbin_player_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = rygel_playbin_player_bus_handler (self, bus, message);
	return result;
}


static RygelPlaybinPlayer* rygel_playbin_player_construct (GType object_type) {
	RygelPlaybinPlayer * self = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* _tmp1_;
	GstBus* _tmp2_ = NULL;
	GstBus* bus;
	self = (RygelPlaybinPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = gst_element_factory_make ("playbin2", NULL);
	_tmp1_ = _tmp0_;
	_gst_object_unref0 (self->priv->playbin);
	self->priv->playbin = _tmp1_;
	g_assert (self->priv->playbin != NULL);
	_tmp2_ = gst_element_get_bus (self->priv->playbin);
	bus = _tmp2_;
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_playbin_player_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
	_gst_object_unref0 (bus);
	return self;
}


static RygelPlaybinPlayer* rygel_playbin_player_new (void) {
	return rygel_playbin_player_construct (RYGEL_PLAYBIN_TYPE_PLAYER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelPlaybinPlayer* rygel_playbin_player_get_default (void) {
	RygelPlaybinPlayer* result = NULL;
	RygelPlaybinPlayer* _tmp2_;
	if (rygel_playbin_player_player == NULL) {
		RygelPlaybinPlayer* _tmp0_ = NULL;
		RygelPlaybinPlayer* _tmp1_;
		_tmp0_ = rygel_playbin_player_new ();
		_tmp1_ = _tmp0_;
		_g_object_unref0 (rygel_playbin_player_player);
		rygel_playbin_player_player = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (rygel_playbin_player_player);
	result = _tmp2_;
	return result;
}


static gboolean rygel_playbin_player_real_seek (RygelMediaPlayer* base, GstClockTime time) {
	RygelPlaybinPlayer * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = gst_element_seek (self->priv->playbin, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, (gint64) time, GST_SEEK_TYPE_NONE, (gint64) (-1));
	result = _tmp0_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_protocols (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	const gchar** _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = (_tmp1_ = RYGEL_PLAYBIN_PLAYER_protocols, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols)));
	_tmp2_ = _tmp0_;
	*result_length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_protocols);
	result = _tmp2_;
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gchar** rygel_playbin_player_real_get_mime_types (RygelMediaPlayer* base, int* result_length1) {
	RygelPlaybinPlayer * self;
	gchar** result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	const gchar** _tmp2_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = (_tmp1_ = RYGEL_PLAYBIN_PLAYER_mime_types, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup2 (_tmp1_, G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types)));
	_tmp2_ = _tmp0_;
	*result_length1 = G_N_ELEMENTS (RYGEL_PLAYBIN_PLAYER_mime_types);
	result = _tmp2_;
	return result;
}


static gboolean rygel_playbin_player_bus_handler (RygelPlaybinPlayer* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_EOS:
		{
			g_debug ("rygel-playbin-player.vala:172: EOS");
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* _error_ = NULL;
			gchar* error_message = NULL;
			GError* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gst_message_parse_error (message, &_tmp0_, &_tmp1_);
			_g_error_free0 (_error_);
			_error_ = _tmp0_;
			_g_free0 (error_message);
			error_message = _tmp1_;
			_tmp2_ = gst_object_get_name ((GstObject*) self->priv->playbin);
			g_warning ("rygel-playbin-player.vala:183: Error from GStreamer element %s: %s", _tmp2_, error_message);
			g_warning ("rygel-playbin-player.vala:186: Going to STOPPED state");
			rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, "STOPPED");
			_g_free0 (error_message);
			_g_error_free0 (_error_);
			break;
		}
		default:
		break;
	}
	result = TRUE;
	return result;
}


static gchar* rygel_playbin_player_real_get_playback_state (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	gchar* _tmp0_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = g_strdup (self->priv->_playback_state);
	result = _tmp0_;
	return result;
}


static void rygel_playbin_player_real_set_playback_state (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp3_;
	static GQuark _tmp3__label0 = 0;
	static GQuark _tmp3__label1 = 0;
	static GQuark _tmp3__label2 = 0;
	self = (RygelPlaybinPlayer*) base;
	g_debug ("rygel-playbin-player.vala:66: Changing playback state to %s.", value);
	_tmp0_ = g_strdup (value);
	_tmp1_ = _tmp0_;
	_g_free0 (self->priv->_playback_state);
	self->priv->_playback_state = _tmp1_;
	_tmp2_ = self->priv->_playback_state;
	_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("STOPPED")))) {
		switch (0) {
			default:
			{
				gst_element_set_state (self->priv->playbin, GST_STATE_NULL);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp3__label1) ? _tmp3__label1 : (_tmp3__label1 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
		switch (0) {
			default:
			{
				gst_element_set_state (self->priv->playbin, GST_STATE_PAUSED);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp3__label2) ? _tmp3__label2 : (_tmp3__label2 = g_quark_from_static_string ("PLAYING")))) {
		switch (0) {
			default:
			{
				gst_element_set_state (self->priv->playbin, GST_STATE_PLAYING);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	g_object_notify ((GObject *) self, "playback-state");
}


static inline gchar* _dynamic_get_uri0 (GstElement* obj) {
	gchar* result;
	g_object_get (obj, "uri", &result, NULL);
	return result;
}


static gchar* rygel_playbin_player_real_get_uri (RygelMediaPlayer* base) {
	gchar* result;
	RygelPlaybinPlayer* self;
	gchar* _tmp0_ = NULL;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = _dynamic_get_uri0 (self->priv->playbin);
	result = _tmp0_;
	return result;
}


static inline void _dynamic_set_uri1 (GstElement* obj, const gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static void rygel_playbin_player_real_set_uri (RygelMediaPlayer* base, const gchar* value) {
	RygelPlaybinPlayer* self;
	self = (RygelPlaybinPlayer*) base;
	_dynamic_set_uri1 (self->priv->playbin, value);
	g_debug ("rygel-playbin-player.vala:92: URI set to %s.", value);
	g_object_notify ((GObject *) self, "uri");
}


static inline gdouble _dynamic_get_volume2 (GstElement* obj) {
	gdouble result;
	g_object_get (obj, "volume", &result, NULL);
	return result;
}


static gdouble rygel_playbin_player_real_get_volume (RygelMediaPlayer* base) {
	gdouble result;
	RygelPlaybinPlayer* self;
	gdouble _tmp0_;
	self = (RygelPlaybinPlayer*) base;
	_tmp0_ = _dynamic_get_volume2 (self->priv->playbin);
	result = _tmp0_;
	return result;
}


static inline void _dynamic_set_volume3 (GstElement* obj, gdouble value) {
	g_object_set (obj, "volume", value, NULL);
}


static void rygel_playbin_player_real_set_volume (RygelMediaPlayer* base, gdouble value) {
	RygelPlaybinPlayer* self;
	self = (RygelPlaybinPlayer*) base;
	_dynamic_set_volume3 (self->priv->playbin, value);
	g_debug ("rygel-playbin-player.vala:103: volume set to %f.", value);
	g_object_notify ((GObject *) self, "volume");
}


static gint64 rygel_playbin_player_real_get_duration (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 dur = 0LL;
	gint64 _tmp0_;
	gboolean _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	format = GST_FORMAT_TIME;
	_tmp1_ = gst_element_query_duration (self->priv->playbin, &format, &_tmp0_);
	dur = _tmp0_;
	if (_tmp1_) {
		result = dur;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


static gint64 rygel_playbin_player_real_get_position (RygelMediaPlayer* base) {
	gint64 result;
	RygelPlaybinPlayer* self;
	GstFormat format;
	gint64 pos = 0LL;
	gint64 _tmp0_;
	gboolean _tmp1_;
	self = (RygelPlaybinPlayer*) base;
	format = GST_FORMAT_TIME;
	_tmp1_ = gst_element_query_position (self->priv->playbin, &format, &_tmp0_);
	pos = _tmp0_;
	if (_tmp1_) {
		result = pos;
		return result;
	} else {
		result = (gint64) 0;
		return result;
	}
}


static void rygel_playbin_player_class_init (RygelPlaybinPlayerClass * klass) {
	rygel_playbin_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaybinPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_playbin_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_playbin_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_playbin_player_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE, "playback-state");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_URI, "uri");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_VOLUME, "volume");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_DURATION, "duration");
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_PLAYBIN_PLAYER_POSITION, "position");
}


static void rygel_playbin_player_rygel_media_player_interface_init (RygelMediaPlayerIface * iface) {
	rygel_playbin_player_rygel_media_player_parent_iface = g_type_interface_peek_parent (iface);
	iface->seek = (gboolean (*)(RygelMediaPlayer* ,GstClockTime)) rygel_playbin_player_real_seek;
	iface->get_protocols = (gchar** (*)(RygelMediaPlayer* ,int*)) rygel_playbin_player_real_get_protocols;
	iface->get_mime_types = (gchar** (*)(RygelMediaPlayer* ,int*)) rygel_playbin_player_real_get_mime_types;
	iface->get_playback_state = rygel_playbin_player_real_get_playback_state;
	iface->set_playback_state = rygel_playbin_player_real_set_playback_state;
	iface->get_uri = rygel_playbin_player_real_get_uri;
	iface->set_uri = rygel_playbin_player_real_set_uri;
	iface->get_volume = rygel_playbin_player_real_get_volume;
	iface->set_volume = rygel_playbin_player_real_set_volume;
	iface->get_duration = rygel_playbin_player_real_get_duration;
	iface->get_position = rygel_playbin_player_real_get_position;
}


static void rygel_playbin_player_instance_init (RygelPlaybinPlayer * self) {
	gchar* _tmp0_;
	self->priv = RYGEL_PLAYBIN_PLAYER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("STOPPED");
	self->priv->_playback_state = _tmp0_;
}


static void rygel_playbin_player_finalize (GObject* obj) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (obj);
	_gst_object_unref0 (self->priv->playbin);
	_g_free0 (self->priv->_playback_state);
	G_OBJECT_CLASS (rygel_playbin_player_parent_class)->finalize (obj);
}


GType rygel_playbin_player_get_type (void) {
	static volatile gsize rygel_playbin_player_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playbin_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaybinPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playbin_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaybinPlayer), 0, (GInstanceInitFunc) rygel_playbin_player_instance_init, NULL };
		static const GInterfaceInfo rygel_media_player_info = { (GInterfaceInitFunc) rygel_playbin_player_rygel_media_player_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playbin_player_type_id;
		rygel_playbin_player_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaybinPlayer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playbin_player_type_id, RYGEL_TYPE_MEDIA_PLAYER, &rygel_media_player_info);
		g_once_init_leave (&rygel_playbin_player_type_id__volatile, rygel_playbin_player_type_id);
	}
	return rygel_playbin_player_type_id__volatile;
}


static void _vala_rygel_playbin_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (object);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		g_value_take_string (value, rygel_media_player_get_playback_state ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		g_value_take_string (value, rygel_media_player_get_uri ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		g_value_set_double (value, rygel_media_player_get_volume ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_DURATION:
		g_value_set_int64 (value, rygel_media_player_get_duration ((RygelMediaPlayer*) self));
		break;
		case RYGEL_PLAYBIN_PLAYER_POSITION:
		g_value_set_int64 (value, rygel_media_player_get_position ((RygelMediaPlayer*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_playbin_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlaybinPlayer * self;
	self = RYGEL_PLAYBIN_PLAYER (object);
	switch (property_id) {
		case RYGEL_PLAYBIN_PLAYER_PLAYBACK_STATE:
		rygel_media_player_set_playback_state ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_URI:
		rygel_media_player_set_uri ((RygelMediaPlayer*) self, g_value_get_string (value));
		break;
		case RYGEL_PLAYBIN_PLAYER_VOLUME:
		rygel_media_player_set_volume ((RygelMediaPlayer*) self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



