/* rygel-media-export-media-cache-upgrader.c generated by valac 0.11.5, the Vala compiler
 * generated from rygel-media-export-media-cache-upgrader.vala, do not modify */

/*
 * Copyright (C) 2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
typedef struct _RygelMediaExportMediaCacheUpgraderPrivate RygelMediaExportMediaCacheUpgraderPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _RygelMediaExportParamSpecMediaCacheUpgrader RygelMediaExportParamSpecMediaCacheUpgrader;

struct _RygelMediaExportMediaCacheUpgrader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelMediaExportMediaCacheUpgraderPrivate * priv;
};

struct _RygelMediaExportMediaCacheUpgraderClass {
	GTypeClass parent_class;
	void (*finalize) (RygelMediaExportMediaCacheUpgrader *self);
};

struct _RygelMediaExportMediaCacheUpgraderPrivate {
	RygelMediaExportDatabase* database;
	RygelMediaExportSQLFactory* sql;
};

struct _Block12Data {
	int _ref_count_;
	RygelMediaExportMediaCacheUpgrader * self;
	gint current_version_temp;
};

typedef gboolean (*RygelMediaExportDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);
typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _Block13Data {
	int _ref_count_;
	RygelMediaExportMediaCacheUpgrader * self;
	gboolean schema_ok;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA
} RygelMediaExportSQLString;

struct _Block14Data {
	int _ref_count_;
	RygelMediaExportMediaCacheUpgrader * self;
	GeeQueue* queue;
};

struct _Block15Data {
	int _ref_count_;
	RygelMediaExportMediaCacheUpgrader * self;
	GeeLinkedList* queue;
};

struct _RygelMediaExportParamSpecMediaCacheUpgrader {
	GParamSpec parent_instance;
};


static gpointer rygel_media_export_media_cache_upgrader_parent_class = NULL;

gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_2 "UPDATE meta_data SET object_fk = " "(SELECT upnp_id FROM Object WHERE metadata_fk = meta_data.id)"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_3 "ALTER TABLE Object ADD timestamp INTEGER"
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_4 "UPDATE Object SET timestamp = 0"
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
GQuark rygel_media_export_database_error_quark (void);
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
static gboolean _lambda7_ (sqlite3_stmt* statement, Block12Data* _data12_);
static gboolean __lambda7__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version "10"
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (Block13Data* _data13_);
static gboolean _lambda8_ (sqlite3_stmt* statement, Block13Data* _data13_);
static gboolean __lambda8__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
static void rygel_media_export_media_cache_upgrader_update_v3_v4 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v4_v5 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v5_v6 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v6_v7 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v7_v8 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v8_v9 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_update_v9_v10 (RygelMediaExportMediaCacheUpgrader* self);
static void rygel_media_export_media_cache_upgrader_force_reindex (RygelMediaExportMediaCacheUpgrader* self, GError** error);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
static gboolean _lambda9_ (sqlite3_stmt* statement, Block14Data* _data14_);
static gboolean __lambda9__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static void _vala_GValue_array_free (GValue* array, gint array_length);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (Block15Data* _data15_);
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "Files & Folders"
static gboolean _lambda10_ (sqlite3_stmt* statement, Block15Data* _data15_);
static gboolean __lambda10__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static void rygel_media_export_media_cache_upgrader_finalize (RygelMediaExportMediaCacheUpgrader* obj);


RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql) {
	RygelMediaExportMediaCacheUpgrader* self = NULL;
	g_return_val_if_fail (database != NULL, NULL);
	g_return_val_if_fail (sql != NULL, NULL);
	self = (RygelMediaExportMediaCacheUpgrader*) g_type_create_instance (object_type);
	self->priv->database = database;
	self->priv->sql = sql;
	return self;
}


RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql) {
	return rygel_media_export_media_cache_upgrader_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, database, sql);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_rygel_media_export_media_cache_upgrader_unref0 (_data12_->self);
		g_slice_free (Block12Data, _data12_);
	}
}


static gboolean _lambda7_ (sqlite3_stmt* statement, Block12Data* _data12_) {
	RygelMediaExportMediaCacheUpgrader * self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = _data12_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_int (statement, 0);
	_data12_->current_version_temp = _tmp0_;
	result = FALSE;
	return result;
}


static gboolean __lambda7__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda7_ (stmt, self);
	return result;
}


gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error) {
	gint _current_version = 0;
	gboolean result = FALSE;
	Block12Data* _data12_;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = rygel_media_export_media_cache_upgrader_ref (self);
	_data12_->current_version_temp = 0;
	rygel_media_export_database_exec (self->priv->database, "SELECT version FROM schema_info", NULL, 0, __lambda7__rygel_media_export_database_row_callback, _data12_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return FALSE;
	}
	_current_version = _data12_->current_version_temp;
	_tmp0_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
	result = _current_version < _tmp0_;
	block12_data_unref (_data12_);
	_data12_ = NULL;
	if (current_version) {
		*current_version = _current_version;
	}
	return result;
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (Block13Data* _data13_) {
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_rygel_media_export_media_cache_upgrader_unref0 (_data13_->self);
		g_slice_free (Block13Data, _data13_);
	}
}


static gboolean _lambda8_ (sqlite3_stmt* statement, Block13Data* _data13_) {
	RygelMediaExportMediaCacheUpgrader * self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = _data13_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_int (statement, 0);
	_data13_->schema_ok = _tmp0_ == 1;
	result = FALSE;
	return result;
}


static gboolean __lambda8__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda8_ (stmt, self);
	return result;
}


void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error) {
	Block13Data* _data13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = rygel_media_export_media_cache_upgrader_ref (self);
	_data13_->schema_ok = TRUE;
	rygel_media_export_database_exec (self->priv->database, "SELECT count(*) FROM sqlite_master WHERE sql " "LIKE 'CREATE TABLE Meta_Data%object_fk TEXT " "UNIQUE%'", NULL, 0, __lambda8__rygel_media_export_database_row_callback, _data13_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block13_data_unref (_data13_);
		_data13_ = NULL;
		return;
	}
	if (!_data13_->schema_ok) {
		const gchar* _tmp0_ = NULL;
		g_message ("rygel-media-export-media-cache-upgrader.vala:73: Found faulty schema, " \
"forcing full reindex");
		rygel_media_export_database_begin (self->priv->database, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		rygel_media_export_database_exec (self->priv->database, "DELETE FROM Object WHERE upnp_id IN (" "SELECT DISTINCT object_fk FROM meta_data)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		rygel_media_export_database_exec (self->priv->database, "DROP TABLE Meta_Data", NULL, 0, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_tmp0_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA);
		rygel_media_export_database_exec (self->priv->database, _tmp0_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		rygel_media_export_database_commit (self->priv->database, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		goto __finally11;
		__catch11_g_error:
		{
			GError * _error_;
			gchar* _tmp1_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			rygel_media_export_database_rollback (self->priv->database);
			_tmp1_ = g_strconcat ("Failed to force reindex to fix database: ", _error_->message, NULL);
			g_warning ("rygel-media-export-media-cache-upgrader.vala:82: %s", _tmp1_);
			_g_free0 (_tmp1_);
			_g_error_free0 (_error_);
		}
		__finally11:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			block13_data_unref (_data13_);
			_data13_ = NULL;
			return;
		}
	}
	block13_data_unref (_data13_);
	_data13_ = NULL;
}


void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self) {
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
	rygel_media_export_database_exec (self->priv->database, _tmp0_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch12_g_error;
	}
	rygel_media_export_database_analyze (self->priv->database);
	goto __finally12;
	__catch12_g_error:
	{
		GError * _error_;
		gchar* _tmp1_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = g_strconcat ("Failed to create indices: ", _error_->message, NULL);
		g_warning ("rygel-media-export-media-cache-upgrader.vala:93: %s", _tmp1_);
		_g_free0 (_tmp1_);
		_g_error_free0 (_error_);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version) {
	gint _tmp0_;
	gint current_version;
	g_return_if_fail (self != NULL);
	g_debug ("rygel-media-export-media-cache-upgrader.vala:99: Older schema detected" \
". Upgrading...");
	_tmp0_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
	current_version = _tmp0_;
	while (TRUE) {
		if (!(old_version < current_version)) {
			break;
		}
		if (self->priv->database != NULL) {
			switch (old_version) {
				case 3:
				{
					rygel_media_export_media_cache_upgrader_update_v3_v4 (self);
					break;
				}
				case 4:
				{
					rygel_media_export_media_cache_upgrader_update_v4_v5 (self);
					break;
				}
				case 5:
				{
					rygel_media_export_media_cache_upgrader_update_v5_v6 (self);
					break;
				}
				case 6:
				{
					rygel_media_export_media_cache_upgrader_update_v6_v7 (self);
					break;
				}
				case 7:
				{
					rygel_media_export_media_cache_upgrader_update_v7_v8 (self);
					break;
				}
				case 8:
				{
					rygel_media_export_media_cache_upgrader_update_v8_v9 (self);
					break;
				}
				case 9:
				{
					rygel_media_export_media_cache_upgrader_update_v9_v10 (self);
					break;
				}
				default:
				{
					g_warning ("rygel-media-export-media-cache-upgrader.vala:126: Cannot upgrade");
					self->priv->database = NULL;
					break;
				}
			}
			old_version++;
		}
	}
}


static void rygel_media_export_media_cache_upgrader_force_reindex (RygelMediaExportMediaCacheUpgrader* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_exec (self->priv->database, "UPDATE Object SET timestamp = 0", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void rygel_media_export_media_cache_upgrader_update_v3_v4 (RygelMediaExportMediaCacheUpgrader* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_begin (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE Meta_Data RENAME TO _Meta_Data", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp0_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA);
	rygel_media_export_database_exec (self->priv->database, _tmp0_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "INSERT INTO meta_data (size, mime_type, " "duration, width, height, class, author, album, " "date, bitrate, sample_freq, bits_per_sample, " "channels, track, color_depth, object_fk) SELECT " "size, mime_type, duration, width, height, class, " "author, album, date, bitrate, sample_freq, " "bits_per_sample, channels, track, color_depth, " "o.upnp_id FROM _Meta_Data JOIN object o " "ON id = o.metadata_fk", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TABLE _Meta_Data", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_3, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_UPDATE_V3_V4_STRING_4, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
	rygel_media_export_database_exec (self->priv->database, _tmp1_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE schema_info SET version = '4'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_commit (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch13_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally13;
	__catch13_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_media_export_database_rollback (self->priv->database);
		g_warning ("rygel-media-export-media-cache-upgrader.vala:161: Database upgrade fai" \
"led: %s", _error_->message);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_rygel_media_export_media_cache_upgrader_unref0 (_data14_->self);
		_g_object_unref0 (_data14_->queue);
		g_slice_free (Block14Data, _data14_);
	}
}


static gboolean _lambda9_ (sqlite3_stmt* statement, Block14Data* _data14_) {
	RygelMediaExportMediaCacheUpgrader * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	self = _data14_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_text (statement, 0);
	gee_queue_offer (_data14_->queue, _tmp0_);
	result = TRUE;
	return result;
}


static gboolean __lambda9__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda9_ (stmt, self);
	return result;
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


static void rygel_media_export_media_cache_upgrader_update_v4_v5 (RygelMediaExportMediaCacheUpgrader* self) {
	Block14Data* _data14_;
	GeeLinkedList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = rygel_media_export_media_cache_upgrader_ref (self);
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_data14_->queue = (GeeQueue*) _tmp0_;
	rygel_media_export_database_begin (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TRIGGER IF EXISTS trgr_delete_children", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
	rygel_media_export_database_exec (self->priv->database, _tmp1_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE Object RENAME TO _Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DELETE FROM Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
	rygel_media_export_database_exec (self->priv->database, _tmp2_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "INSERT INTO _Object (upnp_id, type_fk, title, " "timestamp) VALUES ('0', 0, 'Root', 0)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "INSERT INTO Object (upnp_id, type_fk, title, " "timestamp) VALUES ('0', 0, 'Root', 0)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gee_queue_offer (_data14_->queue, "0");
	while (TRUE) {
		gboolean _tmp3_;
		gpointer _tmp4_ = NULL;
		GValue _tmp5_ = {0};
		GValue* _tmp6_ = NULL;
		GValue* args;
		gint args_length1;
		gint _args_size_;
		_tmp3_ = gee_collection_get_is_empty ((GeeCollection*) _data14_->queue);
		if (!(!_tmp3_)) {
			break;
		}
		_tmp4_ = gee_queue_poll (_data14_->queue);
		g_value_init (&_tmp5_, G_TYPE_STRING);
		g_value_take_string (&_tmp5_, (gchar*) _tmp4_);
		_tmp6_ = g_new0 (GValue, 1);
		_tmp6_[0] = _tmp5_;
		args = _tmp6_;
		args_length1 = 1;
		_args_size_ = 1;
		rygel_media_export_database_exec (self->priv->database, "SELECT upnp_id FROM _Object WHERE parent = ?", args, args_length1, __lambda9__rygel_media_export_database_row_callback, _data14_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			block14_data_unref (_data14_);
			_data14_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		rygel_media_export_database_exec (self->priv->database, "INSERT INTO Object SELECT * FROM _OBJECT " "WHERE parent = ?", args, args_length1, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch14_rygel_media_export_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			block14_data_unref (_data14_);
			_data14_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TABLE Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE _Object RENAME TO Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
	rygel_media_export_database_exec (self->priv->database, _tmp7_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
	rygel_media_export_database_exec (self->priv->database, _tmp8_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE schema_info SET version = '5'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_commit (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "VACUUM", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch14_rygel_media_export_database_error;
		}
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_analyze (self->priv->database);
	goto __finally14;
	__catch14_rygel_media_export_database_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		rygel_media_export_database_rollback (self->priv->database);
		g_warning ("rygel-media-export-media-cache-upgrader.vala:209: Database upgrade fai" \
"led: %s", err->message);
		self->priv->database = NULL;
		_g_error_free0 (err);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		block14_data_unref (_data14_);
		_data14_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


static void rygel_media_export_media_cache_upgrader_update_v5_v6 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_begin (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TABLE object_type", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE Object ADD COLUMN uri TEXT", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE Object SET uri = (SELECT uri " "FROM uri WHERE Uri.object_fk == Object.upnp_id LIMIT 1)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TRIGGER IF EXISTS trgr_delete_uris", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP INDEX IF EXISTS idx_uri_fk", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TABLE Uri", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE schema_info SET version = '6'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_commit (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "VACUUM", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch15_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_analyze (self->priv->database);
	goto __finally15;
	__catch15_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_media_export_database_rollback (self->priv->database);
		g_warning ("rygel-media-export-media-cache-upgrader.vala:230: Database upgrade fai" \
"led: %s", _error_->message);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v6_v7 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_begin (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch16_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE meta_data ADD COLUMN dlna_profile TEXT", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch16_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE schema_info SET version = '7'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch16_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_media_cache_upgrader_force_reindex (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch16_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_commit (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch16_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "VACUUM", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch16_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_analyze (self->priv->database);
	goto __finally16;
	__catch16_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_media_export_database_rollback (self->priv->database);
		g_warning ("rygel-media-export-media-cache-upgrader.vala:246: Database upgrade fai" \
"led: %s", _error_->message);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v7_v8 (RygelMediaExportMediaCacheUpgrader* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_begin (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch17_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE object ADD COLUMN flags TEXT", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch17_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE meta_data ADD COLUMN genre TEXT", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch17_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE schema_info SET version = '8'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch17_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_media_cache_upgrader_force_reindex (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch17_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_commit (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch17_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "VACUUM", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch17_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_analyze (self->priv->database);
	goto __finally17;
	__catch17_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_media_export_database_rollback (self->priv->database);
		g_warning ("rygel-media-export-media-cache-upgrader.vala:263: Database upgrade fai" \
"led: %s", _error_->message);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally17:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_upgrader_update_v8_v9 (RygelMediaExportMediaCacheUpgrader* self) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	rygel_media_export_database_begin (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TRIGGER trgr_update_closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TRIGGER trgr_delete_closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE Closure RENAME TO _Closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp0_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
	rygel_media_export_database_exec (self->priv->database, _tmp0_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "INSERT INTO Closure (ancestor, " "descendant, depth) SELECT DISTINCT " "ancestor, descendant, depth FROM " "_Closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
	rygel_media_export_database_exec (self->priv->database, _tmp1_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TABLE _Closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE schema_info SET version = '9'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_commit (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "VACUUM", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch18_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally18;
	__catch18_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_media_export_database_rollback (self->priv->database);
		g_warning ("rygel-media-export-media-cache-upgrader.vala:286: Database upgrade fai" \
"led: %s", _error_->message);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (Block15Data* _data15_) {
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_rygel_media_export_media_cache_upgrader_unref0 (_data15_->self);
		_g_object_unref0 (_data15_->queue);
		g_slice_free (Block15Data, _data15_);
	}
}


static gboolean _lambda10_ (sqlite3_stmt* statement, Block15Data* _data15_) {
	RygelMediaExportMediaCacheUpgrader * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	self = _data15_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_text (statement, 0);
	gee_queue_offer ((GeeQueue*) _data15_->queue, _tmp0_);
	result = TRUE;
	return result;
}


static gboolean __lambda10__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda10_ (stmt, self);
	return result;
}


static void rygel_media_export_media_cache_upgrader_update_v9_v10 (RygelMediaExportMediaCacheUpgrader* self) {
	Block15Data* _data15_;
	GeeLinkedList* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = rygel_media_export_media_cache_upgrader_ref (self);
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_data15_->queue = _tmp0_;
	rygel_media_export_database_begin (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DELETE FROM Object WHERE upnp_id LIKE '" RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "%'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TRIGGER trgr_update_closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TRIGGER trgr_delete_closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP INDEX idx_parent", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP INDEX idx_meta_data_fk", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP INDEX idx_closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TABLE Closure", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TRIGGER trgr_delete_metadata", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "INSERT INTO Object (parent, upnp_id, " "type_fk, title, timestamp) VALUES " "('0', '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "', 0, '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "', 0)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE Object SET parent = '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "' WHERE parent = '0' AND upnp_id " "NOT LIKE 'virtual-%' AND upnp_id " "<> '" RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE Object RENAME TO _Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "CREATE TABLE Object AS SELECT * FROM _Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "DELETE FROM Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp1_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
	rygel_media_export_database_exec (self->priv->database, _tmp1_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
	rygel_media_export_database_exec (self->priv->database, _tmp2_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "INSERT INTO Closure (ancestor, descendant, " "depth) VALUES ('0','0',0)", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gee_queue_offer ((GeeQueue*) _data15_->queue, "0");
	while (TRUE) {
		gboolean _tmp3_;
		gpointer _tmp4_ = NULL;
		GValue _tmp5_ = {0};
		GValue* _tmp6_ = NULL;
		GValue* args;
		gint args_length1;
		gint _args_size_;
		_tmp3_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) _data15_->queue);
		if (!(!_tmp3_)) {
			break;
		}
		_tmp4_ = gee_queue_poll ((GeeQueue*) _data15_->queue);
		g_value_init (&_tmp5_, G_TYPE_STRING);
		g_value_take_string (&_tmp5_, (gchar*) _tmp4_);
		_tmp6_ = g_new0 (GValue, 1);
		_tmp6_[0] = _tmp5_;
		args = _tmp6_;
		args_length1 = 1;
		_args_size_ = 1;
		rygel_media_export_database_exec (self->priv->database, "SELECT upnp_id FROM _Object WHERE parent = ?", args, args_length1, __lambda10__rygel_media_export_database_row_callback, _data15_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			block15_data_unref (_data15_);
			_data15_ = NULL;
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			block15_data_unref (_data15_);
			_data15_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		rygel_media_export_database_exec (self->priv->database, "INSERT INTO Object SELECT * FROM _Object " "WHERE parent = ?", args, args_length1, NULL, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			block15_data_unref (_data15_);
			_data15_ = NULL;
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch19_rygel_media_export_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			block15_data_unref (_data15_);
			_data15_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	rygel_media_export_database_exec (self->priv->database, "DROP TABLE Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "ALTER TABLE _Object RENAME TO Object", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
	rygel_media_export_database_exec (self->priv->database, _tmp7_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
	rygel_media_export_database_exec (self->priv->database, _tmp8_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
	rygel_media_export_database_exec (self->priv->database, _tmp9_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "UPDATE schema_info SET version = '10'", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_commit (self->priv->database, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_exec (self->priv->database, "VACUUM", NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		block15_data_unref (_data15_);
		_data15_ = NULL;
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch19_rygel_media_export_database_error;
		}
		block15_data_unref (_data15_);
		_data15_ = NULL;
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_database_analyze (self->priv->database);
	block15_data_unref (_data15_);
	_data15_ = NULL;
	goto __finally19;
	__catch19_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_media_export_database_rollback (self->priv->database);
		g_warning ("rygel-media-export-media-cache-upgrader.vala:355: Database upgrade fai" \
"led: %s", _error_->message);
		self->priv->database = NULL;
		_g_error_free0 (_error_);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_export_value_media_cache_upgrader_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void rygel_media_export_value_media_cache_upgrader_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		rygel_media_export_media_cache_upgrader_unref (value->data[0].v_pointer);
	}
}


static void rygel_media_export_value_media_cache_upgrader_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = rygel_media_export_media_cache_upgrader_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer rygel_media_export_value_media_cache_upgrader_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* rygel_media_export_value_media_cache_upgrader_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		RygelMediaExportMediaCacheUpgrader* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = rygel_media_export_media_cache_upgrader_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* rygel_media_export_value_media_cache_upgrader_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	RygelMediaExportMediaCacheUpgrader** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = rygel_media_export_media_cache_upgrader_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	RygelMediaExportParamSpecMediaCacheUpgrader* spec;
	g_return_val_if_fail (g_type_is_a (object_type, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER), NULL);
	return value->data[0].v_pointer;
}


void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object) {
	RygelMediaExportMediaCacheUpgrader* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		rygel_media_export_media_cache_upgrader_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_export_media_cache_upgrader_unref (old);
	}
}


void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object) {
	RygelMediaExportMediaCacheUpgrader* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		rygel_media_export_media_cache_upgrader_unref (old);
	}
}


static void rygel_media_export_media_cache_upgrader_class_init (RygelMediaExportMediaCacheUpgraderClass * klass) {
	rygel_media_export_media_cache_upgrader_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS (klass)->finalize = rygel_media_export_media_cache_upgrader_finalize;
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCacheUpgraderPrivate));
}


static void rygel_media_export_media_cache_upgrader_instance_init (RygelMediaExportMediaCacheUpgrader * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void rygel_media_export_media_cache_upgrader_finalize (RygelMediaExportMediaCacheUpgrader* obj) {
	RygelMediaExportMediaCacheUpgrader * self;
	self = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER (obj);
}


GType rygel_media_export_media_cache_upgrader_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_upgrader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_upgrader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { rygel_media_export_value_media_cache_upgrader_init, rygel_media_export_value_media_cache_upgrader_free_value, rygel_media_export_value_media_cache_upgrader_copy_value, rygel_media_export_value_media_cache_upgrader_peek_pointer, "p", rygel_media_export_value_media_cache_upgrader_collect_value, "p", rygel_media_export_value_media_cache_upgrader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheUpgraderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_upgrader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCacheUpgrader), 0, (GInstanceInitFunc) rygel_media_export_media_cache_upgrader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType rygel_media_export_media_cache_upgrader_type_id;
		rygel_media_export_media_cache_upgrader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "RygelMediaExportMediaCacheUpgrader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_upgrader_type_id__volatile, rygel_media_export_media_cache_upgrader_type_id);
	}
	return rygel_media_export_media_cache_upgrader_type_id__volatile;
}


gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance) {
	RygelMediaExportMediaCacheUpgrader* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void rygel_media_export_media_cache_upgrader_unref (gpointer instance) {
	RygelMediaExportMediaCacheUpgrader* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



