/* rygel-media-export-plugin.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-media-export-plugin.vala, do not modify */

/*
 * Copyright (C) 2008-2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gee.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_PLUGIN (rygel_media_export_plugin_get_type ())
#define RYGEL_MEDIA_EXPORT_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN, RygelMediaExportPlugin))
#define RYGEL_MEDIA_EXPORT_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN, RygelMediaExportPluginClass))
#define RYGEL_MEDIA_EXPORT_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN))
#define RYGEL_MEDIA_EXPORT_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN))
#define RYGEL_MEDIA_EXPORT_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_PLUGIN, RygelMediaExportPluginClass))

typedef struct _RygelMediaExportPlugin RygelMediaExportPlugin;
typedef struct _RygelMediaExportPluginClass RygelMediaExportPluginClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportPluginPrivate RygelMediaExportPluginPrivate;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

struct _Block1Data {
	int _ref_count_;
	RygelMediaExportPlugin* plugin;
	RygelPluginLoader* loader;
};

struct _RygelMediaExportPlugin {
	RygelMediaServerPlugin parent_instance;
	RygelMediaExportPluginPrivate * priv;
};

struct _RygelMediaExportPluginClass {
	RygelMediaServerPluginClass parent_class;
};


static gpointer rygel_media_export_plugin_parent_class = NULL;

#define TRACKER_PLUGIN "Tracker"
#define OUR_PLUGIN "MediaExport"
void module_init (RygelPluginLoader* loader);
GType rygel_media_export_plugin_get_type (void) G_GNUC_CONST;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
RygelMediaExportPlugin* rygel_media_export_plugin_new (void);
RygelMediaExportPlugin* rygel_media_export_plugin_construct (GType object_type);
static gboolean _lambda16_ (Block1Data* _data1_);
void on_plugin_available (RygelPlugin* plugin, RygelPlugin* our_plugin);
static void _lambda17_ (RygelPlugin* new_plugin, Block1Data* _data1_);
static void __lambda17__rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
static gboolean __lambda16__gsource_func (gpointer self);
RygelMediaContainer* rygel_media_export_root_container_get_instance (GError** error);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self);
enum  {
	RYGEL_MEDIA_EXPORT_PLUGIN_DUMMY_PROPERTY
};
static RygelMediaContainer* rygel_media_export_plugin_real_get_root_container (RygelMediaServerPlugin* base);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;


/**
 * Simple plugin which exposes the media contents of a directory via UPnP.
 *
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->plugin);
		_g_object_unref0 (_data1_->loader);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda17_ (RygelPlugin* new_plugin, Block1Data* _data1_) {
	g_return_if_fail (new_plugin != NULL);
	on_plugin_available (new_plugin, (RygelPlugin*) _data1_->plugin);
}


static void __lambda17__rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
	_lambda17_ (plugin, self);
}


static gboolean _lambda16_ (Block1Data* _data1_) {
	gboolean result = FALSE;
	{
		GeeCollection* _tmp0_ = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _loaded_plugin_it;
		_tmp0_ = rygel_plugin_loader_list_plugins (_data1_->loader);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_loaded_plugin_it = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			RygelPlugin* loaded_plugin;
			_tmp4_ = gee_iterator_next (_loaded_plugin_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_loaded_plugin_it);
			loaded_plugin = (RygelPlugin*) _tmp5_;
			on_plugin_available (loaded_plugin, (RygelPlugin*) _data1_->plugin);
			_g_object_unref0 (loaded_plugin);
		}
		_g_object_unref0 (_loaded_plugin_it);
	}
	g_signal_connect_data (_data1_->loader, "plugin-available", (GCallback) __lambda17__rygel_plugin_loader_plugin_available, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	result = FALSE;
	return result;
}


static gboolean __lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda16_ (self);
	return result;
}


void module_init (RygelPluginLoader* loader) {
	Block1Data* _data1_;
	RygelMediaExportPlugin* _tmp0_ = NULL;
	g_return_if_fail (loader != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->loader = _g_object_ref0 (loader);
	_tmp0_ = rygel_media_export_plugin_new ();
	_data1_->plugin = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda16__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	rygel_plugin_loader_add_plugin (_data1_->loader, (RygelPlugin*) _data1_->plugin);
	block1_data_unref (_data1_);
}


void on_plugin_available (RygelPlugin* plugin, RygelPlugin* our_plugin) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (plugin != NULL);
	g_return_if_fail (our_plugin != NULL);
	if (g_strcmp0 (plugin->name, TRACKER_PLUGIN) == 0) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = rygel_plugin_get_active (our_plugin);
		_tmp2_ = rygel_plugin_get_active (plugin);
		_tmp0_ = _tmp1_ == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp3_;
		gboolean _tmp9_;
		_tmp3_ = rygel_plugin_get_active (plugin);
		if (_tmp3_) {
			RygelMetaConfig* _tmp4_ = NULL;
			RygelMetaConfig* config;
			gboolean _tmp5_;
			gboolean enabled;
			g_message ("rygel-media-export-plugin.vala:53: Deactivating plugin '%s' in favor o" \
"f plugin '%s'", OUR_PLUGIN, TRACKER_PLUGIN);
			_tmp4_ = rygel_meta_config_get_default ();
			config = _tmp4_;
			_tmp5_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "MediaExport", "enabled", &_inner_error_);
			enabled = _tmp5_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (config);
				goto __catch0_g_error;
			}
			if (enabled) {
				RygelMediaContainer* _tmp6_ = NULL;
				RygelMediaContainer* _tmp7_;
				RygelMediaContainer* _tmp8_;
				RygelMediaExportRootContainer* root;
				_tmp6_ = rygel_media_export_root_container_get_instance (&_inner_error_);
				_tmp7_ = _tmp6_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (config);
					goto __catch0_g_error;
				}
				root = (_tmp8_ = _tmp7_, RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER (_tmp8_) ? ((RygelMediaExportRootContainer*) _tmp8_) : NULL);
				rygel_media_export_root_container_shutdown (root);
				_g_object_unref0 (root);
			}
			_g_object_unref0 (config);
			goto __finally0;
			__catch0_g_error:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (_error_);
			}
			__finally0:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		} else {
			g_message ("rygel-media-export-plugin.vala:67: Plugin '%s' inactivate, activating " \
"'%s' plugin", TRACKER_PLUGIN, OUR_PLUGIN);
		}
		_tmp9_ = rygel_plugin_get_active (plugin);
		rygel_plugin_set_active (our_plugin, !_tmp9_);
	}
}


RygelMediaExportPlugin* rygel_media_export_plugin_construct (GType object_type) {
	RygelMediaExportPlugin * self = NULL;
	const gchar* _tmp0_ = NULL;
	_tmp0_ = _ ("@REALNAME@'s media");
	self = (RygelMediaExportPlugin*) rygel_media_server_plugin_construct (object_type, OUR_PLUGIN, _tmp0_, NULL);
	return self;
}


RygelMediaExportPlugin* rygel_media_export_plugin_new (void) {
	return rygel_media_export_plugin_construct (RYGEL_MEDIA_EXPORT_TYPE_PLUGIN);
}


static RygelMediaContainer* rygel_media_export_plugin_real_get_root_container (RygelMediaServerPlugin* base) {
	RygelMediaExportPlugin * self;
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* _tmp0_ = NULL;
	RygelMediaContainer* _tmp1_;
	RygelNullContainer* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaExportPlugin*) base;
	_tmp0_ = rygel_media_export_root_container_get_instance (&_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	result = _tmp1_;
	return result;
	goto __finally1;
	__catch1_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("Could not create root container: %s. " "Disabling plugin", _error_->message);
		rygel_plugin_set_active ((RygelPlugin*) self, FALSE);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = rygel_null_container_new ();
	result = (RygelMediaContainer*) _tmp2_;
	return result;
}


static void rygel_media_export_plugin_class_init (RygelMediaExportPluginClass * klass) {
	rygel_media_export_plugin_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_SERVER_PLUGIN_CLASS (klass)->get_root_container = rygel_media_export_plugin_real_get_root_container;
}


static void rygel_media_export_plugin_instance_init (RygelMediaExportPlugin * self) {
}


GType rygel_media_export_plugin_get_type (void) {
	static volatile gsize rygel_media_export_plugin_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_plugin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportPlugin), 0, (GInstanceInitFunc) rygel_media_export_plugin_instance_init, NULL };
		GType rygel_media_export_plugin_type_id;
		rygel_media_export_plugin_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_SERVER_PLUGIN, "RygelMediaExportPlugin", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_plugin_type_id__volatile, rygel_media_export_plugin_type_id);
	}
	return rygel_media_export_plugin_type_id__volatile;
}



