/* rygel-subtitle-manager.c generated by valac 0.11.2, the Vala compiler
 * generated from rygel-subtitle-manager.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>.
 *
 * Authors: Andreas Henriksson <andreas@fatal.se>
 *          Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
typedef struct _RygelSubtitleManagerPrivate RygelSubtitleManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))

typedef enum  {
	SUBTITLE_MANAGER_ERROR_NO_SUBTITLE
} SubtitleManagerError;
#define SUBTITLE_MANAGER_ERROR subtitle_manager_error_quark ()
struct _RygelSubtitleManager {
	GObject parent_instance;
	RygelSubtitleManagerPrivate * priv;
};

struct _RygelSubtitleManagerClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_subtitle_manager_parent_class = NULL;
static RygelSubtitleManager* rygel_subtitle_manager_manager;
static RygelSubtitleManager* rygel_subtitle_manager_manager = NULL;

GQuark subtitle_manager_error_quark (void);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_SUBTITLE_MANAGER_DUMMY_PROPERTY
};
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitleManager* rygel_subtitle_manager_new (void);
RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type);
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const gchar* uri, GError** error);
RygelSubtitle* rygel_subtitle_new (const gchar* mime_type, const gchar* caption_type);
RygelSubtitle* rygel_subtitle_construct (GType object_type, const gchar* mime_type, const gchar* caption_type);
static void rygel_subtitle_manager_finalize (GObject* obj);


GQuark subtitle_manager_error_quark (void) {
	return g_quark_from_static_string ("subtitle_manager_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelSubtitleManager* rygel_subtitle_manager_get_default (void) {
	RygelSubtitleManager* result = NULL;
	RygelSubtitleManager* _tmp2_;
	if (rygel_subtitle_manager_manager == NULL) {
		RygelSubtitleManager* _tmp0_ = NULL;
		RygelSubtitleManager* _tmp1_;
		_tmp0_ = rygel_subtitle_manager_new ();
		_tmp1_ = _tmp0_;
		_g_object_unref0 (rygel_subtitle_manager_manager);
		rygel_subtitle_manager_manager = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (rygel_subtitle_manager_manager);
	result = _tmp2_;
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong _tmp0_;
	glong string_length;
	const gchar* _tmp1_ = NULL;
	const gchar* start;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	string_length = _tmp0_;
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp1_ = string_offset (self, offset);
	start = _tmp1_;
	_tmp2_ = string_offset (start, len);
	_tmp3_ = g_strndup (start, ((gchar*) _tmp2_) - ((gchar*) start));
	result = _tmp3_;
	return result;
}


RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const gchar* uri, GError** error) {
	RygelSubtitle* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* video_file;
	GFile* _tmp1_ = NULL;
	GFile* directory;
	gchar* _tmp2_ = NULL;
	gchar* filename;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* extension;
	gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* srt_file;
	GFileInfo* _tmp11_ = NULL;
	GFileInfo* info;
	gboolean _tmp12_;
	RygelSubtitle* _tmp15_ = NULL;
	RygelSubtitle* subtitle;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	guint64 _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	video_file = _tmp0_;
	_tmp1_ = g_file_get_parent (video_file);
	directory = _tmp1_;
	_tmp2_ = g_file_get_basename (video_file);
	filename = _tmp2_;
	_tmp3_ = g_utf8_strrchr (filename, (gssize) (-1), (gunichar) '.');
	_tmp4_ = g_strdup (_tmp3_);
	extension = _tmp4_;
	if (extension != NULL) {
		glong _tmp5_;
		glong _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp5_ = strlen (filename);
		_tmp6_ = strlen (extension);
		_tmp7_ = string_substring (filename, (glong) 0, _tmp5_ - _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (filename);
		filename = _tmp8_;
	}
	_tmp9_ = g_strconcat (filename, ".srt", NULL);
	_g_free0 (filename);
	filename = _tmp9_;
	_tmp10_ = g_file_get_child (directory, filename);
	srt_file = _tmp10_;
	_tmp11_ = g_file_query_info (srt_file, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp11_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (srt_file);
		_g_free0 (extension);
		_g_free0 (filename);
		_g_object_unref0 (directory);
		_g_object_unref0 (video_file);
		return NULL;
	}
	_tmp12_ = g_file_info_get_attribute_boolean (info, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp12_) {
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_tmp13_ = _ ("No subtitle available");
		_tmp14_ = g_error_new_literal (SUBTITLE_MANAGER_ERROR, SUBTITLE_MANAGER_ERROR_NO_SUBTITLE, _tmp13_);
		_inner_error_ = _tmp14_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (info);
		_g_object_unref0 (srt_file);
		_g_free0 (extension);
		_g_free0 (filename);
		_g_object_unref0 (directory);
		_g_object_unref0 (video_file);
		return NULL;
	}
	_tmp15_ = rygel_subtitle_new ("text/plain", "srt");
	subtitle = _tmp15_;
	_tmp16_ = g_file_get_uri (srt_file);
	_tmp17_ = _tmp16_;
	_g_free0 (subtitle->uri);
	subtitle->uri = _tmp17_;
	_tmp18_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_STANDARD_SIZE);
	subtitle->size = (gint64) _tmp18_;
	result = subtitle;
	_g_object_unref0 (info);
	_g_object_unref0 (srt_file);
	_g_free0 (extension);
	_g_free0 (filename);
	_g_object_unref0 (directory);
	_g_object_unref0 (video_file);
	return result;
}


RygelSubtitleManager* rygel_subtitle_manager_construct (GType object_type) {
	RygelSubtitleManager * self = NULL;
	self = (RygelSubtitleManager*) g_object_new (object_type, NULL);
	return self;
}


RygelSubtitleManager* rygel_subtitle_manager_new (void) {
	return rygel_subtitle_manager_construct (RYGEL_TYPE_SUBTITLE_MANAGER);
}


static void rygel_subtitle_manager_class_init (RygelSubtitleManagerClass * klass) {
	rygel_subtitle_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_manager_finalize;
}


static void rygel_subtitle_manager_instance_init (RygelSubtitleManager * self) {
}


static void rygel_subtitle_manager_finalize (GObject* obj) {
	RygelSubtitleManager * self;
	self = RYGEL_SUBTITLE_MANAGER (obj);
	G_OBJECT_CLASS (rygel_subtitle_manager_parent_class)->finalize (obj);
}


/**
 * Provides subtitles for vidoes.
 */
GType rygel_subtitle_manager_get_type (void) {
	static volatile gsize rygel_subtitle_manager_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitleManager), 0, (GInstanceInitFunc) rygel_subtitle_manager_instance_init, NULL };
		GType rygel_subtitle_manager_type_id;
		rygel_subtitle_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitleManager", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_manager_type_id__volatile, rygel_subtitle_manager_type_id);
	}
	return rygel_subtitle_manager_type_id__volatile;
}



